/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.janocchio.FrameDeltaDisplay;
import org.openscience.jmol.app.janocchio.NMR_Viewer;
import org.openscience.jmol.app.janocchio.NmrGuiMap;
import org.openscience.jmol.app.janocchio.PopulationDisplay;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jmolpanel.StatusBar;

public class NMR_DisplayPanel
extends DisplayPanel {
    StatusBar status;
    NmrGuiMap guimap;
    NMR_Viewer viewer;
    FrameDeltaDisplay frameDeltaDisplay;
    PopulationDisplay populationDisplay;

    NMR_DisplayPanel(JmolPanel jmol) {
        super(jmol);
    }

    @Override
    public void setViewer(Viewer viewer) {
        this.viewer = (NMR_Viewer)viewer;
        this.vwr = viewer;
        this.getSize(this.dimSize);
        Dimension d = this.haveDisplay && this.dimSize.width > 0 ? this.dimSize : this.startupDim;
        this.setSize(d);
        this.setPreferredSize(d);
        viewer.setScreenDimension(d.width, d.height);
    }

    public void setPopulationDisplay(PopulationDisplay populationDisplay) {
        this.populationDisplay = populationDisplay;
    }

    public void setFrameDeltaDisplay(FrameDeltaDisplay frameDeltaDisplay) {
        this.frameDeltaDisplay = frameDeltaDisplay;
    }

    void moveTo(String move) {
        if (this.viewer.getShowBbcage() || this.viewer.getBooleanProperty("showUnitCell")) {
            this.viewer.evalStringQuiet(move);
        } else {
            this.viewer.evalStringQuiet("boundbox on;" + move + ";delay 1;boundbox off");
        }
    }

    @Override
    public void addActions(List<Action> list) {
        super.addActions(list);
        list.add(new PickAction());
        list.add(new RotateAction());
        list.add(new PopulationDisplayAction());
        list.add(new FrameDeltaDisplayAction());
        list.add(new SelectallAction());
        list.add(new DeselectallAction());
    }

    class RotateAction
    extends AbstractAction {
        public RotateAction() {
            super("rotate");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NMR_DisplayPanel.this.viewer.setSelectionHalos(false);
            NMR_DisplayPanel.this.status.setStatus(1, ((JComponent)e.getSource()).getToolTipText());
        }
    }

    class PickAction
    extends AbstractAction {
        public PickAction() {
            super("pick");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NMR_DisplayPanel.this.viewer.setSelectionHalos(false);
            NMR_DisplayPanel.this.status.setStatus(1, GT.$("Select Atoms"));
        }
    }

    class DeselectallAction
    extends AbstractAction {
        public DeselectallAction() {
            super("deselectall");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NMR_DisplayPanel.this.viewer.evalStringQuiet("select none");
        }
    }

    class SelectallAction
    extends AbstractAction {
        public SelectallAction() {
            super("selectall");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NMR_DisplayPanel.this.viewer.evalStringQuiet("select all");
        }
    }

    class FrameDeltaDisplayAction
    extends AbstractAction {
        public FrameDeltaDisplayAction() {
            super("frameDeltaDisplayCheck");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
            NMR_DisplayPanel.this.frameDeltaDisplay.setVisible(cbmi.isSelected());
        }
    }

    class PopulationDisplayAction
    extends AbstractAction {
        public PopulationDisplayAction() {
            super("populationDisplayCheck");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
            NMR_DisplayPanel.this.populationDisplay.setVisible(cbmi.isSelected());
        }
    }
}

