/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.data.SourceInfo;
import tim.prune.load.MediaLinkInfo;
import tim.prune.load.xml.GpxHandler;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.XmlHandler;

public class ZipFileLoader {
    private App _app = null;
    private XmlFileLoader _xmlLoader = null;

    public ZipFileLoader(App app, XmlFileLoader xmlFileLoader) {
        this._app = app;
        this._xmlLoader = xmlFileLoader;
    }

    public void openFile(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            boolean bl = false;
            while (enumeration.hasMoreElements() && !bl) {
                String string;
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.toString();
                if (string2 == null || string2.length() <= 4 || !(string = string2.substring(string2.length() - 4).toLowerCase()).equals(".kml") && !string.equals(".gpx") && !string.equals(".xml")) continue;
                this._xmlLoader.reset();
                this._xmlLoader.parseXmlStream(zipFile.getInputStream(zipEntry));
                XmlHandler xmlHandler = this._xmlLoader.getHandler();
                if (xmlHandler == null) {
                    this._app.showErrorMessage("error.load.dialogtitle", "error.load.othererror");
                    continue;
                }
                SourceInfo sourceInfo = new SourceInfo(file, xmlHandler instanceof GpxHandler ? SourceInfo.FILE_TYPE.GPX : SourceInfo.FILE_TYPE.KML);
                this._app.informDataLoaded(xmlHandler.getFieldArray(), xmlHandler.getDataArray(), null, sourceInfo, xmlHandler.getTrackNameList(), new MediaLinkInfo(file, xmlHandler.getLinkArray()));
                bl = true;
            }
            zipFile.close();
            if (!bl) {
                this._app.showErrorMessage("error.load.dialogtitle", "error.load.noxmlinzip");
            }
        }
        catch (Exception exception) {
            this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(exception.getClass().getName()) + "\n - " + exception.getMessage());
        }
    }

    public void openStream(InputStream inputStream) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            boolean bl = false;
            while (!bl && zipInputStream.available() > 0) {
                String string;
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                String string2 = zipEntry.toString();
                if (string2 == null || string2.length() <= 4 || !(string = string2.substring(string2.length() - 4).toLowerCase()).equals(".kml") && !string.equals(".gpx") && !string.equals(".xml")) continue;
                this._xmlLoader.reset();
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse((InputStream)zipInputStream, (DefaultHandler)this._xmlLoader);
                XmlHandler xmlHandler = this._xmlLoader.getHandler();
                if (xmlHandler == null) {
                    this._app.showErrorMessage("error.load.dialogtitle", "error.load.othererror");
                    continue;
                }
                this._app.informDataLoaded(xmlHandler.getFieldArray(), xmlHandler.getDataArray(), new SourceInfo("gpsies", SourceInfo.FILE_TYPE.GPSIES), xmlHandler.getTrackNameList());
                bl = true;
            }
            if (!bl) {
                this._app.showErrorMessage("error.load.dialogtitle", "error.load.noxmlinzip");
            }
        }
        catch (Exception exception) {
            System.err.println("ZipStream Error: " + exception.getClass().getName() + " -message= " + exception.getMessage());
        }
    }
}

