#!/usr/bin/env sh

# Valid actions:

# - FATAL       - netdata exited due to a fatal condition
#      ACTION_RESULT  -- program name and thread tag
#      ACTION_DATA    -- fmt, args passed to fatal
# - START       - netdata started
#      ACTION_DATA     -- nan
# - EXIT        - installation action
#      ACTION_DATA     -- ret value of

ACTION="${1}"
ACTION_RESULT="${2}"
ACTION_DATA="${3}"
ACTION_DATA=$(echo "${ACTION_DATA}" | tr '"' "'")

# -------------------------------------------------------------------------------------------------
# check opt-out

if [ -f "/etc/netdata/.opt-out-from-anonymous-statistics" ] || [ ! "${DO_NOT_TRACK:-0}" -eq 0 ] || [ -n "$DO_NOT_TRACK" ]; then
  exit 0
fi

# Shorten version for easier reporting
NETDATA_VERSION=$(echo "${NETDATA_VERSION}" | sed 's/-.*//g' | tr -d 'v')

# -------------------------------------------------------------------------------------------------

# define body of request to be sent
REQ_BODY="$(cat << EOF
{
    "api_key": "mqkwGT0JNFqO-zX2t0mW6Tec9yooaVu7xCBlXtHnt5Y",
    "event": "${ACTION} ${ACTION_RESULT}",
    "properties": {
        "distinct_id": "${NETDATA_REGISTRY_UNIQUE_ID}",
        "\$current_url": "agent backend",
        "\$pathname": "netdata-backend",
        "\$host": "backend.netdata.io",
        "\$ip": "127.0.0.1",
        "event_source": "agent backend",
        "action": "${ACTION}",
        "action_result": "${ACTION_RESULT}",
        "action_data": "${ACTION_DATA}",
        "netdata_machine_guid": "${NETDATA_REGISTRY_UNIQUE_ID}",
        "netdata_version": "${NETDATA_VERSION}",
        "host_os_name": "${NETDATA_HOST_OS_NAME}",
        "host_os_id": "${NETDATA_HOST_OS_ID}",
        "host_os_id_like": "${NETDATA_HOST_OS_ID_LIKE}",
        "host_os_version": "${NETDATA_HOST_OS_VERSION}",
        "host_os_version_id": "${NETDATA_HOST_OS_VERSION_ID}",
        "host_os_detection": "${NETDATA_HOST_OS_DETECTION}",
        "host_is_k8s_node": "${NETDATA_HOST_IS_K8S_NODE}",
        "system_kernel_name": "${NETDATA_SYSTEM_KERNEL_NAME}",
        "system_kernel_version": "${NETDATA_SYSTEM_KERNEL_VERSION}",
        "system_architecture": "${NETDATA_SYSTEM_ARCHITECTURE}",
        "system_virtualization": "${NETDATA_SYSTEM_VIRTUALIZATION}",
        "system_virt_detection": "${NETDATA_SYSTEM_VIRT_DETECTION}",
        "system_container": "${NETDATA_SYSTEM_CONTAINER}",
        "system_container_detection": "${NETDATA_SYSTEM_CONTAINER_DETECTION}",
        "container_os_name": "${NETDATA_CONTAINER_OS_NAME}",
        "container_os_id": "${NETDATA_CONTAINER_OS_ID}",
        "container_os_id_like": "${NETDATA_CONTAINER_OS_ID_LIKE}",
        "container_os_version": "${NETDATA_CONTAINER_OS_VERSION}",
        "container_os_version_id": "${NETDATA_CONTAINER_OS_VERSION_ID}",
        "container_os_detection": "${NETDATA_CONTAINER_OS_DETECTION}",
        "system_cpu_detection": "${NETDATA_SYSTEM_CPU_DETECTION}",
        "system_cpu_freq": "${NETDATA_SYSTEM_CPU_FREQ}",
        "system_cpu_logical_cpu_count": "${NETDATA_SYSTEM_CPU_LOGICAL_CPU_COUNT}",
        "system_cpu_model": "${NETDATA_SYSTEM_CPU_MODEL}",
        "system_cpu_vendor": "${NETDATA_SYSTEM_CPU_VENDOR}",
        "system_disk_detection": "${NETDATA_SYSTEM_DISK_DETECTION}",
        "system_ram_detection": "${NETDATA_SYSTEM_RAM_DETECTION}",
        "system_total_disk_size": "${NETDATA_SYSTEM_TOTAL_DISK_SIZE}",
        "system_total_ram": "${NETDATA_SYSTEM_TOTAL_RAM}"
  }
}
EOF
)"

# send the anonymous statistics to the Netdata PostHog
if [ -n "$(command -v curl 2> /dev/null)" ]; then
  curl -X POST --header "Content-Type: application/json" -d "${REQ_BODY}" https://posthog.netdata.cloud/capture/ > /dev/null 2>&1
else
  wget -q -O - --no-check-certificate \
  --method POST \
  --timeout=1 \
  --header 'Content-Type: application/json' \
  --body-data "${REQ_BODY}" \
   'https://posthog.netdata.cloud/capture/' > /dev/null 2>&1
fi
