/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.classfile.ClassFileCache;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;

public class LazyDynamicClassInfo
extends DynamicClassInfo {
    private boolean isInitilaized;
    private boolean isInterface;

    public LazyDynamicClassInfo(String string, int n, String string2, String string3, String[] stringArray) throws IOException {
        super(string, n, string2, false);
        this.superName = string3;
        this.interfaces = stringArray;
    }

    @Override
    public int getMethodIndex(String string, String string2) {
        if (this.initializeClassFile()) {
            return super.getMethodIndex(string, string2);
        }
        return -1;
    }

    @Override
    public String[] getMethodNames() {
        if (this.initializeClassFile()) {
            return super.getMethodNames();
        }
        return new String[0];
    }

    @Override
    public void preloadBytecode() {
        super.preloadBytecode();
        if (!this.isInitilaized) {
            ClassFileCache.getDefault().preloadBytecode(this.getName(), this.getClassFileLocation());
        }
    }

    @Override
    public boolean isInterface() {
        if (!this.isInitilaized) {
            return this.isInterface;
        }
        return super.isInterface();
    }

    @Override
    public void setInterface() {
        this.isInterface = true;
    }

    private boolean initializeClassFile() {
        if (!this.isInitilaized) {
            this.isInitilaized = true;
            try {
                this.parseClassFile(this.getName());
                return true;
            }
            catch (ClassFormatError classFormatError) {
                Logger.getLogger(LazyDynamicClassInfo.class.getName()).log(Level.SEVERE, null, classFormatError);
            }
            catch (IOException iOException) {
                Logger.getLogger(LazyDynamicClassInfo.class.getName()).log(Level.INFO, null, iOException);
            }
            return false;
        }
        return true;
    }
}

