/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.FilteringToolbar;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.Formattable;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.ExternalPackages;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.SessionStorage;
import org.netbeans.modules.profiler.v2.impl.Bundle;
import org.netbeans.modules.profiler.v2.impl.WeakProcessor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class ClassMethodSelector {
    private static final WeakProcessor PROCESSOR = new WeakProcessor("Profiler ClassMethodSelector Processor");
    private static final MethodNameFormatter METHOD_FORMATTER = new DefaultMethodNameFormatter(2);
    private static final int LIST_WIDTH = 200;
    private static final Preferences PREF = NbPreferences.forModule(ClassMethodSelector.class);

    public static List<SourceClassInfo> selectClasses(ProfilerSession profilerSession) {
        UI uI = UI.forSession(profilerSession, false);
        HelpCtx helpCtx = new HelpCtx("SelectClassDialog.HelpCtx");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)uI, Bundle.ClassMethodSelector_selectClass(), true, new Object[]{uI.getOKButton(), DialogDescriptor.CANCEL_OPTION}, (Object)uI.getOKButton(), 0, helpCtx, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return dialogDescriptor.getValue() == uI.getOKButton() ? uI.selectedClasses() : Collections.EMPTY_LIST;
    }

    public static List<SourceMethodInfo> selectMethods(ProfilerSession profilerSession) {
        UI uI = UI.forSession(profilerSession, true);
        HelpCtx helpCtx = new HelpCtx("SelectMethodDialog.HelpCtx");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)uI, Bundle.ClassMethodSelector_selectMethod(), true, new Object[]{uI.getOKButton(), DialogDescriptor.CANCEL_OPTION}, (Object)uI.getOKButton(), 0, helpCtx, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return dialogDescriptor.getValue() == uI.getOKButton() ? uI.selectedMethods() : Collections.EMPTY_LIST;
    }

    private ClassMethodSelector() {
    }

    private static abstract class FilteredListModel<E>
    implements ListModel<E> {
        private final Collection<ListDataListener> listeners;
        private final ListModel<E> data;
        private ListSelectionModel selection;
        private E selected;
        private GenericFilter filter;
        private final List<Integer> indices;

        public FilteredListModel(ListModel listModel) {
            this.data = listModel;
            this.listeners = new HashSet<ListDataListener>();
            this.indices = new ArrayList<Integer>();
            this.doFilter();
            this.data.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent listDataEvent) {
                    FilteredListModel.this.doFilter();
                }

                @Override
                public void intervalRemoved(ListDataEvent listDataEvent) {
                    FilteredListModel.this.doFilter();
                }

                @Override
                public void contentsChanged(ListDataEvent listDataEvent) {
                    FilteredListModel.this.doFilter();
                }
            });
        }

        protected abstract boolean matchesFilter(E var1, GenericFilter var2);

        public void setSelectionModel(final ListSelectionModel listSelectionModel) {
            this.selection = listSelectionModel;
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        int n = listSelectionModel.getMinSelectionIndex();
                        FilteredListModel.this.selected = n == -1 ? null : FilteredListModel.this.getElementAt(n);
                    }
                }
            });
        }

        public void setFilter(GenericFilter genericFilter) {
            this.filter = genericFilter.isAll() ? null : genericFilter;
            this.doFilter();
        }

        public GenericFilter getFilter() {
            return this.filter;
        }

        @Override
        public int getSize() {
            return this.filter == null ? this.data.getSize() : this.indices.size();
        }

        @Override
        public E getElementAt(int n) {
            return this.data.getElementAt(this.filter == null ? n : this.indices.get(n));
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.listeners.add(listDataListener);
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.listeners.remove(listDataListener);
        }

        private void doFilter() {
            Object object;
            int n;
            this.indices.clear();
            int n2 = -1;
            if (this.filter != null) {
                for (n = 0; n < this.data.getSize(); ++n) {
                    object = this.data.getElementAt(n);
                    if (!this.matchesFilter(object, this.filter)) continue;
                    if (this.selection != null && object.equals(this.selected)) {
                        n2 = this.indices.size();
                    }
                    this.indices.add(n);
                }
            } else if (this.selection != null) {
                for (n = 0; n < this.data.getSize(); ++n) {
                    object = this.data.getElementAt(n);
                    if (!object.equals(this.selected)) continue;
                    n2 = n;
                }
            }
            if (!this.listeners.isEmpty()) {
                ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.indices.size());
                for (ListDataListener listDataListener : this.listeners) {
                    listDataListener.contentsChanged(listDataEvent);
                }
            }
            if (this.selection != null) {
                if (n2 == -1) {
                    this.selection.clearSelection();
                } else {
                    this.selection.setSelectionInterval(n2, n2);
                }
            }
        }
    }

    private static class HintRenderer
    extends LabelRenderer {
        HintRenderer() {
            super(true);
            this.setHorizontalAlignment(0);
            this.setForeground(UIUtils.getDisabledLineColor());
        }

        void setup(Boolean bl, Dimension dimension) {
            if (Boolean.FALSE.equals(bl)) {
                this.setText(Bundle.ClassMethodSelector_lblComputing());
            } else if (Boolean.TRUE.equals(bl)) {
                this.setText(Bundle.ClassMethodSelector_lblNoItems());
            } else {
                this.setText(Bundle.ClassMethodSelector_lblNoSelection());
            }
            this.setSize(dimension);
        }
    }

    private static abstract class MethodSelector
    extends JPanel {
        private final JList<SourceMethodInfo> methodsList;
        private final DefaultListModel<SourceMethodInfo> methodsListModel = new DefaultListModel();
        private final AbstractButton methodsInheritedB;
        private final AbstractButton methodsNonPublicB;
        private final AbstractButton methodsStaticB;
        private boolean isInitialized;

        abstract void methodSelected();

        abstract void reload();

        SourceMethodInfo getSelected() {
            return this.methodsList.getSelectedValue();
        }

        List<SourceMethodInfo> getAllSelected() {
            return this.methodsList.getSelectedValuesList();
        }

        void init(final SourceClassInfo sourceClassInfo) {
            this.isInitialized = sourceClassInfo != null;
            this.methodsListModel.clear();
            this.methodsList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                final boolean bl = this.methodsInheritedB.isSelected();
                final boolean bl2 = this.methodsNonPublicB.isSelected();
                final boolean bl3 = this.methodsStaticB.isSelected();
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final Collection collection = MethodSelector.getMethods(sourceClassInfo, bl, bl2, bl3);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MethodSelector.this.methodsList.setEnabled(true);
                                for (SourceMethodInfo sourceMethodInfo : collection) {
                                    MethodSelector.this.methodsListModel.addElement(sourceMethodInfo);
                                }
                            }
                        });
                    }
                });
            }
        }

        private static Collection<SourceMethodInfo> getMethods(SourceClassInfo sourceClassInfo, boolean bl, boolean bl2, boolean bl3) {
            TreeSet<SourceMethodInfo> treeSet = new TreeSet<SourceMethodInfo>(new Comparator<SourceMethodInfo>(){

                @Override
                public int compare(SourceMethodInfo sourceMethodInfo, SourceMethodInfo sourceMethodInfo2) {
                    Formattable formattable = METHOD_FORMATTER.formatMethodName("", sourceMethodInfo.getName(), sourceMethodInfo.getSignature());
                    Formattable formattable2 = METHOD_FORMATTER.formatMethodName("", sourceMethodInfo2.getName(), sourceMethodInfo2.getSignature());
                    return formattable.toFormatted().compareTo(formattable2.toFormatted());
                }
            });
            HashSet hashSet = new HashSet(sourceClassInfo.getConstructors());
            hashSet.addAll(sourceClassInfo.getMethods(bl));
            for (SourceMethodInfo sourceMethodInfo : hashSet) {
                int n = sourceMethodInfo.getModifiers();
                if (!bl2 && !Modifier.isPublic(n) || !bl3 && Modifier.isStatic(n)) continue;
                treeSet.add(sourceMethodInfo);
            }
            return treeSet;
        }

        MethodSelector() {
            final FilteredListModel<SourceMethodInfo> filteredListModel = new FilteredListModel<SourceMethodInfo>(this.methodsListModel){

                @Override
                protected boolean matchesFilter(SourceMethodInfo sourceMethodInfo, GenericFilter genericFilter) {
                    return genericFilter.passes(sourceMethodInfo.getName());
                }
            };
            final HintRenderer hintRenderer = new HintRenderer();
            this.methodsList = new JList(filteredListModel){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dimension = super.getPreferredScrollableViewportSize();
                    dimension.width = 200;
                    return dimension;
                }

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (this.getModel().getSize() == 0) {
                        if (!this.isEnabled()) {
                            hintRenderer.setup(false, this.getSize());
                        } else if (MethodSelector.this.isInitialized) {
                            hintRenderer.setup(true, this.getSize());
                        } else {
                            hintRenderer.setup(null, this.getSize());
                        }
                        hintRenderer.paint(graphics);
                    }
                }
            };
            this.methodsList.setSelectionMode(2);
            filteredListModel.setSelectionModel(this.methodsList.getSelectionModel());
            this.methodsList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    SourceMethodInfo sourceMethodInfo = (SourceMethodInfo)object;
                    defaultListCellRenderer.setText(METHOD_FORMATTER.formatMethodName("", sourceMethodInfo.getName(), sourceMethodInfo.getSignature()).toFormatted());
                    defaultListCellRenderer.setIcon(Icons.getIcon((String)"LanguageIcons.MethodPublic"));
                    return defaultListCellRenderer;
                }
            });
            this.methodsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        MethodSelector.this.methodSelected();
                    }
                }
            });
            JLabel jLabel = new JLabel(Bundle.ClassMethodSelector_capMethods(), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.methodsInheritedB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.MethodInheritedStatic")){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    MethodSelector.this.reload();
                    PREF.putBoolean("Profiler.CMS.methodsInheritedB", MethodSelector.this.methodsInheritedB.isSelected());
                }
            };
            this.methodsInheritedB.putClientProperty("JButton.buttonType", "segmented");
            this.methodsInheritedB.putClientProperty("JButton.segmentPosition", "first");
            this.methodsInheritedB.setToolTipText(Bundle.ClassMethodSelector_showInheritedMethods());
            this.methodsInheritedB.setSelected(PREF.getBoolean("Profiler.CMS.methodsInheritedB", false));
            this.methodsNonPublicB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.MethodPrivate")){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    MethodSelector.this.reload();
                    PREF.putBoolean("Profiler.CMS.methodsNonPublicB", MethodSelector.this.methodsNonPublicB.isSelected());
                }
            };
            this.methodsNonPublicB.putClientProperty("JButton.buttonType", "segmented");
            this.methodsNonPublicB.putClientProperty("JButton.segmentPosition", "middle");
            this.methodsNonPublicB.setToolTipText(Bundle.ClassMethodSelector_showNonPublicMethods());
            this.methodsNonPublicB.setSelected(PREF.getBoolean("Profiler.CMS.methodsNonPublicB", true));
            this.methodsStaticB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.MethodPublicStatic")){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    MethodSelector.this.reload();
                    PREF.putBoolean("Profiler.CMS.methodsStaticB", MethodSelector.this.methodsStaticB.isSelected());
                }
            };
            this.methodsStaticB.putClientProperty("JButton.buttonType", "segmented");
            this.methodsStaticB.putClientProperty("JButton.segmentPosition", "last");
            this.methodsStaticB.setToolTipText(Bundle.ClassMethodSelector_showStaticMethods());
            this.methodsStaticB.setSelected(PREF.getBoolean("Profiler.CMS.methodsStaticB", true));
            FilteringToolbar filteringToolbar = new FilteringToolbar(Bundle.ClassMethodSelector_lblFilterItems()){

                protected void filterChanged() {
                    filteredListModel.setFilter(this.getFilter());
                }
            };
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.addSeparator();
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.add(this.methodsInheritedB);
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.add(this.methodsStaticB);
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.add(this.methodsNonPublicB);
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)jLabel, "North");
            this.add((Component)new JScrollPane(this.methodsList), "Center");
            this.add((Component)filteringToolbar, "South");
        }
    }

    private static abstract class ClassSelector
    extends JPanel {
        private final JList<SourceClassInfo> classesList;
        private final DefaultListModel<SourceClassInfo> classesListModel = new DefaultListModel();
        private final AbstractButton classesInnerB;
        private final AbstractButton classesAnonymousB;
        private boolean isInitialized;

        abstract void classSelected();

        abstract void reload();

        SourceClassInfo getSelected() {
            return this.classesList.getSelectedValue();
        }

        List<SourceClassInfo> getAllSelected() {
            return this.classesList.getSelectedValuesList();
        }

        void init(final SourcePackageInfo sourcePackageInfo) {
            this.isInitialized = sourcePackageInfo != null;
            this.classesListModel.clear();
            this.classesList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                final boolean bl = this.classesInnerB.isSelected();
                final boolean bl2 = this.classesAnonymousB.isSelected();
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final Collection collection = ClassSelector.getClasses(sourcePackageInfo, bl, bl2);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ClassSelector.this.classesList.setEnabled(true);
                                for (SourceClassInfo sourceClassInfo : collection) {
                                    ClassSelector.this.classesListModel.addElement(sourceClassInfo);
                                }
                            }
                        });
                    }
                });
            }
        }

        private static Collection<SourceClassInfo> getClasses(SourcePackageInfo sourcePackageInfo, boolean bl, boolean bl2) {
            AbstractSet abstractSet;
            AbstractSet abstractSet2 = sourcePackageInfo.getClasses();
            if (bl) {
                abstractSet = new HashSet();
                while (!abstractSet2.isEmpty()) {
                    SourceClassInfo sourceClassInfo = (SourceClassInfo)abstractSet2.iterator().next();
                    abstractSet2.remove(sourceClassInfo);
                    if (bl2 || !sourceClassInfo.isAnonymous()) {
                        abstractSet.add(sourceClassInfo);
                    }
                    abstractSet2.addAll(sourceClassInfo.getInnerClases());
                }
                abstractSet2 = abstractSet;
            }
            abstractSet = new TreeSet<SourceClassInfo>(new Comparator<SourceClassInfo>(){

                @Override
                public int compare(SourceClassInfo sourceClassInfo, SourceClassInfo sourceClassInfo2) {
                    return sourceClassInfo.getSimpleName().compareTo(sourceClassInfo2.getSimpleName());
                }
            });
            abstractSet.addAll(abstractSet2);
            return abstractSet;
        }

        ClassSelector(boolean bl) {
            final FilteredListModel<SourceClassInfo> filteredListModel = new FilteredListModel<SourceClassInfo>(this.classesListModel){

                @Override
                protected boolean matchesFilter(SourceClassInfo sourceClassInfo, GenericFilter genericFilter) {
                    return genericFilter.passes(sourceClassInfo.getSimpleName());
                }
            };
            final HintRenderer hintRenderer = new HintRenderer();
            this.classesList = new JList(filteredListModel){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dimension = super.getPreferredScrollableViewportSize();
                    dimension.width = 200;
                    return dimension;
                }

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (this.getModel().getSize() == 0) {
                        if (!this.isEnabled()) {
                            hintRenderer.setup(false, this.getSize());
                        } else if (ClassSelector.this.isInitialized) {
                            hintRenderer.setup(true, this.getSize());
                        } else {
                            hintRenderer.setup(null, this.getSize());
                        }
                        hintRenderer.paint(graphics);
                    }
                }
            };
            this.classesList.setSelectionMode(bl ? 0 : 2);
            filteredListModel.setSelectionModel(this.classesList.getSelectionModel());
            this.classesList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    SourceClassInfo sourceClassInfo = (SourceClassInfo)object;
                    defaultListCellRenderer.setText(sourceClassInfo.getSimpleName());
                    defaultListCellRenderer.setIcon(Icons.getIcon((String)"LanguageIcons.Class"));
                    return defaultListCellRenderer;
                }
            });
            this.classesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ClassSelector.this.classSelected();
                    }
                }
            });
            JLabel jLabel = new JLabel(Bundle.ClassMethodSelector_capClasses(), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.classesInnerB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.Class")){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    ClassSelector.this.reload();
                    ClassSelector.this.classesAnonymousB.setEnabled(this.isSelected());
                    PREF.putBoolean("Profiler.CMS.classesInnerB", ClassSelector.this.classesInnerB.isSelected());
                }
            };
            this.classesInnerB.putClientProperty("JButton.buttonType", "segmented");
            this.classesInnerB.putClientProperty("JButton.segmentPosition", "first");
            this.classesInnerB.setToolTipText(Bundle.ClassMethodSelector_showInnerClasses());
            this.classesInnerB.setSelected(PREF.getBoolean("Profiler.CMS.classesInnerB", true));
            this.classesAnonymousB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.ClassAnonymous")){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    ClassSelector.this.reload();
                    PREF.putBoolean("Profiler.CMS.classesAnonymousB", ClassSelector.this.classesAnonymousB.isSelected());
                }

                @Override
                public void setEnabled(boolean bl) {
                    super.setEnabled(bl);
                    if (!this.isEnabled()) {
                        this.setSelected(false);
                    }
                }
            };
            this.classesAnonymousB.putClientProperty("JButton.buttonType", "segmented");
            this.classesAnonymousB.putClientProperty("JButton.segmentPosition", "last");
            this.classesAnonymousB.setToolTipText(Bundle.ClassMethodSelector_showAnonymousClasses());
            this.classesAnonymousB.setSelected(PREF.getBoolean("Profiler.CMS.classesAnonymousB", false));
            FilteringToolbar filteringToolbar = new FilteringToolbar(Bundle.ClassMethodSelector_lblFilterItems()){

                protected void filterChanged() {
                    filteredListModel.setFilter(this.getFilter());
                }
            };
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.addSeparator();
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.add(this.classesInnerB);
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.add(this.classesAnonymousB);
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)jLabel, "North");
            this.add((Component)new JScrollPane(this.classesList), "Center");
            this.add((Component)filteringToolbar, "South");
        }
    }

    private static abstract class PackageSelector
    extends JPanel {
        private final JList<SourcePackageInfo> packageList;
        private final DefaultListModel<SourcePackageInfo> packageListModel = new DefaultListModel();
        private final AbstractButton packagesSourcesB;
        private final AbstractButton packagesDependenciesB;
        private boolean isInitialized;

        abstract void packageSelected();

        abstract void reload();

        SourcePackageInfo getSelected() {
            return this.packageList.getSelectedValue();
        }

        void init(final Lookup.Provider provider) {
            this.isInitialized = provider != null;
            this.packageListModel.clear();
            this.packageList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                final boolean bl = this.packagesSourcesB.isSelected();
                final boolean bl2 = this.packagesDependenciesB.isSelected();
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final Collection collection = PackageSelector.getProjectPackages(provider, bl, bl2);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PackageSelector.this.packageList.setEnabled(true);
                                for (SourcePackageInfo sourcePackageInfo : collection) {
                                    PackageSelector.this.packageListModel.addElement(sourcePackageInfo);
                                }
                            }
                        });
                    }
                });
            }
        }

        void init(final FileObject fileObject) {
            this.isInitialized = fileObject != null;
            this.packageListModel.clear();
            this.packageList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final Collection collection = PackageSelector.getFilePackages(fileObject);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PackageSelector.this.packageList.setEnabled(true);
                                for (SourcePackageInfo sourcePackageInfo : collection) {
                                    PackageSelector.this.packageListModel.addElement(sourcePackageInfo);
                                }
                            }
                        });
                    }
                });
            }
        }

        private static Collection<SourcePackageInfo> getProjectPackages(Lookup.Provider provider, boolean bl, boolean bl2) {
            HashSet hashSet = new HashSet();
            if (bl) {
                hashSet.addAll(ProfilerTypeUtils.getPackages((boolean)false, (SourcePackageInfo.Scope)SourcePackageInfo.Scope.SOURCE, (Lookup.Provider)provider));
            }
            if (bl2) {
                hashSet.addAll(ProfilerTypeUtils.getPackages((boolean)false, (SourcePackageInfo.Scope)SourcePackageInfo.Scope.DEPENDENCIES, (Lookup.Provider)provider));
            }
            TreeSet<SourcePackageInfo> treeSet = new TreeSet<SourcePackageInfo>(new Comparator<SourcePackageInfo>(){

                @Override
                public int compare(SourcePackageInfo sourcePackageInfo, SourcePackageInfo sourcePackageInfo2) {
                    return sourcePackageInfo.getBinaryName().compareTo(sourcePackageInfo2.getBinaryName());
                }
            });
            treeSet.addAll(hashSet);
            return treeSet;
        }

        private static Collection<SourcePackageInfo> getFilePackages(FileObject fileObject) {
            HashSet hashSet = new HashSet(ExternalPackages.forPath((FileObject)fileObject, (boolean)true));
            TreeSet<SourcePackageInfo> treeSet = new TreeSet<SourcePackageInfo>(new Comparator<SourcePackageInfo>(){

                @Override
                public int compare(SourcePackageInfo sourcePackageInfo, SourcePackageInfo sourcePackageInfo2) {
                    return sourcePackageInfo.getBinaryName().compareTo(sourcePackageInfo2.getBinaryName());
                }
            });
            treeSet.addAll(hashSet);
            return treeSet;
        }

        PackageSelector(boolean bl) {
            final FilteredListModel<SourcePackageInfo> filteredListModel = new FilteredListModel<SourcePackageInfo>(this.packageListModel){

                @Override
                protected boolean matchesFilter(SourcePackageInfo sourcePackageInfo, GenericFilter genericFilter) {
                    return genericFilter.passes(sourcePackageInfo.getBinaryName());
                }
            };
            final HintRenderer hintRenderer = new HintRenderer();
            this.packageList = new JList(filteredListModel){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dimension = super.getPreferredScrollableViewportSize();
                    dimension.width = 200;
                    return dimension;
                }

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (this.getModel().getSize() == 0) {
                        if (!this.isEnabled()) {
                            hintRenderer.setup(false, this.getSize());
                        } else if (PackageSelector.this.isInitialized) {
                            hintRenderer.setup(true, this.getSize());
                        } else {
                            hintRenderer.setup(null, this.getSize());
                        }
                        hintRenderer.paint(graphics);
                    }
                }
            };
            this.packageList.setSelectionMode(0);
            filteredListModel.setSelectionModel(this.packageList.getSelectionModel());
            this.packageList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    SourcePackageInfo sourcePackageInfo = (SourcePackageInfo)object;
                    defaultListCellRenderer.setText(sourcePackageInfo.getBinaryName());
                    defaultListCellRenderer.setIcon(Icons.getIcon((String)"LanguageIcons.Package"));
                    return defaultListCellRenderer;
                }
            });
            this.packageList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        PackageSelector.this.packageSelected();
                    }
                }
            });
            JLabel jLabel = new JLabel(Bundle.ClassMethodSelector_capPackages(), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            FilteringToolbar filteringToolbar = new FilteringToolbar(Bundle.ClassMethodSelector_lblFilterItems()){

                protected void filterChanged() {
                    filteredListModel.setFilter(this.getFilter());
                }
            };
            if (bl) {
                this.packagesSourcesB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.Constructors")){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        PackageSelector.this.reload();
                        PREF.putBoolean("Profiler.CMS.packagesSourcesB", PackageSelector.this.packagesSourcesB.isSelected());
                    }
                };
                this.packagesSourcesB.putClientProperty("JButton.buttonType", "segmented");
                this.packagesSourcesB.putClientProperty("JButton.segmentPosition", "first");
                this.packagesSourcesB.setToolTipText(Bundle.ClassMethodSelector_showProjectPackages());
                this.packagesSourcesB.setSelected(PREF.getBoolean("Profiler.CMS.packagesSourcesB", true));
                this.packagesDependenciesB = new JToggleButton(Icons.getIcon((String)"LanguangeIcons.Jar")){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        PackageSelector.this.reload();
                        PREF.putBoolean("Profiler.CMS.packagesDependenciesB", PackageSelector.this.packagesDependenciesB.isSelected());
                    }
                };
                this.packagesDependenciesB.putClientProperty("JButton.buttonType", "segmented");
                this.packagesDependenciesB.putClientProperty("JButton.segmentPosition", "last");
                this.packagesDependenciesB.setToolTipText(Bundle.ClassMethodSelector_showDependenciesPackages());
                this.packagesDependenciesB.setSelected(PREF.getBoolean("Profiler.CMS.packagesDependenciesB", false));
                filteringToolbar.add(Box.createHorizontalStrut(2));
                filteringToolbar.addSeparator();
                filteringToolbar.add(Box.createHorizontalStrut(2));
                filteringToolbar.add(this.packagesSourcesB);
                filteringToolbar.add(Box.createHorizontalStrut(2));
                filteringToolbar.add(this.packagesDependenciesB);
            } else {
                this.packagesSourcesB = null;
                this.packagesDependenciesB = null;
            }
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)jLabel, "North");
            this.add((Component)new JScrollPane(this.packageList), "Center");
            this.add((Component)filteringToolbar, "South");
        }
    }

    private static abstract class ProjectSelector
    extends JPanel {
        private final JList<Lookup.Provider> projectList;
        private final DefaultListModel<Lookup.Provider> projectListModel = new DefaultListModel();
        private boolean isInitialized;

        abstract void projectSelected();

        Lookup.Provider getSelected() {
            return this.projectList.getSelectedValue();
        }

        void init(final Lookup.Provider provider) {
            this.isInitialized = true;
            this.projectListModel.clear();
            this.projectList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final Lookup.Provider[] providerArray = ProjectSelector.getProjects();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectSelector.this.projectList.setEnabled(true);
                                for (Lookup.Provider provider : providerArray) {
                                    ProjectSelector.this.projectListModel.addElement(provider);
                                }
                                if (provider != null) {
                                    ProjectSelector.this.projectList.setSelectedValue(provider, true);
                                }
                            }
                        });
                    }
                });
            }
        }

        private static Lookup.Provider[] getProjects() {
            return ProjectUtilities.getSortedProjects((Lookup.Provider[])ProjectUtilities.getOpenedProjects());
        }

        ProjectSelector() {
            final FilteredListModel<Lookup.Provider> filteredListModel = new FilteredListModel<Lookup.Provider>(this.projectListModel){

                @Override
                protected boolean matchesFilter(Lookup.Provider provider, GenericFilter genericFilter) {
                    return genericFilter.passes(ProjectUtilities.getDisplayName((Lookup.Provider)provider));
                }
            };
            final HintRenderer hintRenderer = new HintRenderer();
            this.projectList = new JList(filteredListModel){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dimension = super.getPreferredScrollableViewportSize();
                    dimension.width = 200;
                    return dimension;
                }

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (this.getModel().getSize() == 0) {
                        hintRenderer.setup(true, this.getSize());
                        hintRenderer.paint(graphics);
                    }
                }
            };
            this.projectList.setSelectionMode(0);
            filteredListModel.setSelectionModel(this.projectList.getSelectionModel());
            this.projectList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    Lookup.Provider provider = (Lookup.Provider)object;
                    defaultListCellRenderer.setText(ProjectUtilities.getDisplayName((Lookup.Provider)provider));
                    defaultListCellRenderer.setIcon(ProjectUtilities.getIcon((Lookup.Provider)provider));
                    return defaultListCellRenderer;
                }
            });
            this.projectList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ProjectSelector.this.projectSelected();
                    }
                }
            });
            JLabel jLabel = new JLabel(Bundle.ClassMethodSelector_capProjects(), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            FilteringToolbar filteringToolbar = new FilteringToolbar(Bundle.ClassMethodSelector_lblFilterItems()){

                protected void filterChanged() {
                    filteredListModel.setFilter(this.getFilter());
                }
            };
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)jLabel, "North");
            this.add((Component)new JScrollPane(this.projectList), "Center");
            this.add((Component)filteringToolbar, "South");
        }
    }

    private static abstract class FileSelector
    extends JPanel {
        private final JList<FileObject> fileList;
        private final DefaultListModel<FileObject> fileListModel = new DefaultListModel();
        private final AbstractButton addFileB;
        private final AbstractButton removeFileB;
        private boolean isInitialized;

        abstract void fileSelected();

        abstract SessionStorage getStorage();

        FileObject getSelected() {
            return this.fileList.getSelectedValue();
        }

        void init() {
            this.isInitialized = true;
            this.fileListModel.clear();
            this.fileList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        SessionStorage sessionStorage = FileSelector.this.getStorage();
                        final Collection collection = FileSelector.getFiles(sessionStorage);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FileSelector.this.fileList.setEnabled(true);
                                for (FileObject fileObject : collection) {
                                    FileSelector.this.fileListModel.addElement(fileObject);
                                }
                            }
                        });
                    }
                });
            }
        }

        private static Collection<FileObject> getFiles(SessionStorage sessionStorage) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            String string = sessionStorage.readFlag("CMS.files", "");
            if (!string.isEmpty()) {
                for (String string2 : string.split("#")) {
                    FileObject fileObject;
                    File file = new File(string2);
                    FileObject fileObject2 = fileObject = file.exists() ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)) : null;
                    if (fileObject == null) continue;
                    arrayList.add(fileObject);
                }
            }
            return arrayList;
        }

        private void persist() {
            StringBuilder stringBuilder = new StringBuilder();
            Enumeration<FileObject> enumeration = this.fileListModel.elements();
            while (enumeration.hasMoreElements()) {
                FileObject fileObject = enumeration.nextElement();
                stringBuilder.append(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
                if (!enumeration.hasMoreElements()) continue;
                stringBuilder.append("#");
            }
            if (stringBuilder.length() == 0) {
                this.getStorage().storeFlag("CMS.files", null);
            } else {
                this.getStorage().storeFlag("CMS.files", stringBuilder.toString());
            }
        }

        FileSelector() {
            final FilteredListModel<FileObject> filteredListModel = new FilteredListModel<FileObject>(this.fileListModel){

                @Override
                protected boolean matchesFilter(FileObject fileObject, GenericFilter genericFilter) {
                    return genericFilter.passes(fileObject.getNameExt());
                }
            };
            final HintRenderer hintRenderer = new HintRenderer();
            this.fileList = new JList(filteredListModel){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dimension = super.getPreferredScrollableViewportSize();
                    dimension.width = 200;
                    return dimension;
                }

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (this.getModel().getSize() == 0) {
                        hintRenderer.setup(true, this.getSize());
                        hintRenderer.paint(graphics);
                    }
                }
            };
            this.fileList.setSelectionMode(0);
            filteredListModel.setSelectionModel(this.fileList.getSelectionModel());
            this.fileList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    FileObject fileObject = (FileObject)object;
                    defaultListCellRenderer.setText(fileObject.getNameExt());
                    defaultListCellRenderer.setIcon(Icons.getIcon((String)(fileObject.isFolder() ? "LanguageIcons.Libraries" : "LanguangeIcons.Jar")));
                    return defaultListCellRenderer;
                }
            });
            this.fileList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        FileSelector.this.fileSelected();
                        FileSelector.this.removeFileB.setEnabled(FileSelector.this.fileList.getSelectedValue() != null);
                    }
                }
            });
            JLabel jLabel = new JLabel(Bundle.ClassMethodSelector_capFiles(), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            FilteringToolbar filteringToolbar = new FilteringToolbar(Bundle.ClassMethodSelector_lblFilterItems()){

                protected void filterChanged() {
                    filteredListModel.setFilter(this.getFilter());
                }
            };
            String string = "GeneralIcons.Folder";
            Image image = Icons.getImage((String)string);
            Image image2 = Icons.getImage((String)"GeneralIcons.BadgeAdd");
            Image image3 = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)0, (int)0);
            this.addFileB = new JButton(ImageUtilities.image2Icon((Image)image3)){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    FileObject fileObject;
                    super.fireActionPerformed(actionEvent);
                    FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(ClassMethodSelector.class);
                    fileChooserBuilder.setAcceptAllFileFilterUsed(false);
                    File file = fileChooserBuilder.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            String string = null;
                            String string2 = file.getName();
                            int n = string2.lastIndexOf(".");
                            if (n > -1) {
                                string = string2.substring(n + 1);
                            }
                            return string != null && string.equalsIgnoreCase("jar");
                        }

                        @Override
                        public String getDescription() {
                            return Bundle.ClassMethodSelector_jarsFoldersFilterDescr();
                        }
                    }).setTitle(Bundle.ClassMethodSelector_selectJarOrFolder()).showOpenDialog();
                    if (file != null && (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file))) != null) {
                        FileSelector.this.fileListModel.addElement(fileObject);
                        FileSelector.this.persist();
                    }
                }
            };
            this.addFileB.setToolTipText(Bundle.ClassMethodSelector_addFileOrFolder());
            Image image4 = Icons.getImage((String)"GeneralIcons.BadgeRemove");
            Image image5 = ImageUtilities.mergeImages((Image)image, (Image)image4, (int)0, (int)0);
            this.removeFileB = new JButton(ImageUtilities.image2Icon((Image)image5)){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    List list = FileSelector.this.fileList.getSelectedValuesList();
                    if (!list.isEmpty()) {
                        for (FileObject fileObject : list) {
                            FileSelector.this.fileListModel.removeElement(fileObject);
                        }
                        FileSelector.this.persist();
                    }
                }
            };
            this.removeFileB.setToolTipText(Bundle.ClassMethodSelector_removeSelectedItem());
            this.removeFileB.setEnabled(this.fileList.getSelectedValue() != null);
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.addSeparator();
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.add(this.addFileB);
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.add(this.removeFileB);
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)jLabel, "North");
            this.add((Component)new JScrollPane(this.fileList), "Center");
            this.add((Component)filteringToolbar, "South");
        }
    }

    private static class UI
    extends JPanel {
        private final JButton okButton = new JButton(Bundle.ClassMethodSelector_btnOk());
        private final JPanel p_selectors;
        private final MethodSelector p_methodSelector;
        private final ClassSelector p_classSelector;
        private final PackageSelector p_packageSelector;
        private final ProjectSelector p_projectSelector;
        private final JPanel f_selectors;
        private final MethodSelector f_methodSelector;
        private final ClassSelector f_classSelector;
        private final PackageSelector f_packageSelector;
        private final FileSelector f_fileSelector;
        private JComponent selected;

        static UI forSession(ProfilerSession profilerSession, boolean bl) {
            return new UI(profilerSession, bl);
        }

        JButton getOKButton() {
            return this.okButton;
        }

        List<SourceClassInfo> selectedClasses() {
            if (this.p_selectors == this.selected && this.p_classSelector != null) {
                return this.p_classSelector.getAllSelected();
            }
            if (this.f_selectors == this.selected && this.f_classSelector != null) {
                return this.f_classSelector.getAllSelected();
            }
            return null;
        }

        List<SourceMethodInfo> selectedMethods() {
            if (this.p_selectors == this.selected && this.p_methodSelector != null) {
                return this.p_methodSelector.getAllSelected();
            }
            if (this.f_selectors == this.selected && this.f_methodSelector != null) {
                return this.f_methodSelector.getAllSelected();
            }
            return null;
        }

        private UI(final ProfilerSession profilerSession, final boolean bl) {
            this.okButton.setEnabled(false);
            final boolean[] blArray = new boolean[1];
            if (profilerSession.getProject() != null) {
                this.p_methodSelector = bl ? new MethodSelector(){

                    @Override
                    void methodSelected() {
                        UI.this.okButton.setEnabled(this.getSelected() != null);
                    }

                    @Override
                    void reload() {
                        this.init(UI.this.p_classSelector.getSelected());
                    }
                } : null;
                this.p_classSelector = new ClassSelector(bl){

                    @Override
                    void classSelected() {
                        if (!bl) {
                            UI.this.okButton.setEnabled(this.getSelected() != null);
                        } else {
                            UI.this.p_methodSelector.init(this.getSelected());
                        }
                    }

                    @Override
                    void reload() {
                        this.init(UI.this.p_packageSelector.getSelected());
                    }
                };
                this.p_packageSelector = new PackageSelector(true){

                    @Override
                    void packageSelected() {
                        UI.this.p_classSelector.init(this.getSelected());
                    }

                    @Override
                    void reload() {
                        this.init(UI.this.p_projectSelector.getSelected());
                    }
                };
                this.p_projectSelector = new ProjectSelector(){

                    @Override
                    void projectSelected() {
                        UI.this.p_packageSelector.init(this.getSelected());
                    }
                };
                this.p_selectors = new JPanel(new GridLayout(1, bl ? 4 : 3, 10, 10));
                this.p_selectors.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
                this.p_selectors.add(this.p_projectSelector);
                this.p_selectors.add(this.p_packageSelector);
                this.p_selectors.add(this.p_classSelector);
                if (bl) {
                    this.p_selectors.add(this.p_methodSelector);
                }
            } else {
                this.p_selectors = null;
                this.p_methodSelector = null;
                this.p_classSelector = null;
                this.p_packageSelector = null;
                this.p_projectSelector = null;
            }
            final boolean[] blArray2 = new boolean[1];
            this.f_methodSelector = bl ? new MethodSelector(){

                @Override
                void methodSelected() {
                    UI.this.okButton.setEnabled(this.getSelected() != null);
                }

                @Override
                void reload() {
                    this.init(UI.this.f_classSelector.getSelected());
                }
            } : null;
            this.f_classSelector = new ClassSelector(bl){

                @Override
                void classSelected() {
                    if (!bl) {
                        UI.this.okButton.setEnabled(this.getSelected() != null);
                    } else {
                        UI.this.f_methodSelector.init(this.getSelected());
                    }
                }

                @Override
                void reload() {
                    this.init(UI.this.f_packageSelector.getSelected());
                }
            };
            this.f_packageSelector = new PackageSelector(false){

                @Override
                void packageSelected() {
                    UI.this.f_classSelector.init(this.getSelected());
                }

                @Override
                void reload() {
                    this.init(UI.this.f_fileSelector.getSelected());
                }
            };
            this.f_fileSelector = new FileSelector(){

                @Override
                void fileSelected() {
                    UI.this.f_packageSelector.init(this.getSelected());
                }

                @Override
                SessionStorage getStorage() {
                    return profilerSession.getStorage();
                }
            };
            this.f_selectors = new JPanel(new GridLayout(1, bl ? 4 : 3, 10, 10));
            this.f_selectors.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            this.f_selectors.add(this.f_fileSelector);
            this.f_selectors.add(this.f_packageSelector);
            this.f_selectors.add(this.f_classSelector);
            if (bl) {
                this.f_selectors.add(this.f_methodSelector);
            }
            JTabbedPane jTabbedPane = new JTabbedPane(){

                @Override
                protected void fireStateChanged() {
                    super.fireStateChanged();
                    Component component = this.getSelectedComponent();
                    if (component == UI.this.p_selectors) {
                        UI.this.selected = UI.this.p_selectors;
                        if (!blArray[0]) {
                            UI.this.p_projectSelector.init(profilerSession.getProject());
                            blArray[0] = true;
                        }
                        if (UI.this.p_methodSelector != null) {
                            UI.this.p_methodSelector.methodSelected();
                        } else {
                            UI.this.p_classSelector.classSelected();
                        }
                    } else if (component == UI.this.f_selectors) {
                        UI.this.selected = UI.this.f_selectors;
                        if (!blArray2[0]) {
                            UI.this.f_fileSelector.init();
                            blArray2[0] = true;
                        }
                        if (UI.this.f_methodSelector != null) {
                            UI.this.f_methodSelector.methodSelected();
                        } else {
                            UI.this.f_classSelector.classSelected();
                        }
                    }
                }
            };
            if (UIUtils.isAquaLookAndFeel()) {
                jTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, -11, -13, -10));
            } else {
                Insets insets = UIManager.getInsets("TabbedPane.contentBorderInsets");
                if (insets == null) {
                    jTabbedPane.setBorder(BorderFactory.createEmptyBorder());
                } else {
                    jTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, -insets.left, -insets.bottom, -insets.right));
                }
            }
            if (this.p_selectors != null) {
                jTabbedPane.addTab(Bundle.ClassMethodSelector_capFromProject(), null, this.p_selectors, null);
            }
            if (this.f_selectors != null) {
                jTabbedPane.addTab(Bundle.ClassMethodSelector_capFromJarFolder(), null, this.f_selectors, null);
            }
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add((Component)jTabbedPane, "Center");
        }
    }
}

