/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.common;

import de.tuberlin.polymake.common.PolymakeControl;
import de.tuberlin.polymake.common.io.PolymakeServerParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SelectorThread
extends Thread {
    protected static final String USAGE = "usage: java de.tuberlin.polymake.common.Launcher <ps_port>";
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final PrintStream newErr = System.err;
    protected Selector selector = null;
    protected SocketChannel polyChannel = null;
    protected SelectionKey polyKey = null;
    protected BufferedReader polyReader = null;
    protected Charset charset = null;
    protected HashMap clientControlMap = new HashMap(8);
    protected HashMap pipeControlMap = new HashMap(8);
    protected HashMap pipeClientMap = new HashMap(8);
    protected ByteBuffer bbuf = ByteBuffer.allocateDirect(8);
    protected SelectionKey staticGeometryKey = null;
    protected PolymakeServerParser psp = null;

    public SelectorThread(SocketChannel socketChannel) throws IOException {
        super("SelectorThread");
        this.selector = Selector.open();
        this.psp = new PolymakeServerParser(this);
        if (socketChannel != null) {
            this.polyChannel = socketChannel;
            this.polyReader = new BufferedReader(Channels.newReader((ReadableByteChannel)this.polyChannel, CHARSET.name()));
        }
        this.setPriority(5);
    }

    public SelectionKey registerControl(PolymakeControl polymakeControl, SocketChannel socketChannel, Pipe pipe) throws IOException {
        SelectionKey selectionKey = pipe.source().register(this.selector, 1);
        SelectionKey selectionKey2 = socketChannel.register(this.selector, 1);
        this.clientControlMap.put(selectionKey2, polymakeControl);
        this.pipeControlMap.put(selectionKey, polymakeControl);
        this.pipeClientMap.put(selectionKey, selectionKey2);
        return selectionKey2;
    }

    public void registerControl(PolymakeControl polymakeControl, Pipe pipe) throws IOException {
        SelectionKey selectionKey = pipe.source().register(this.selector, 1);
        if (this.staticGeometryKey == null) {
            this.staticGeometryKey = selectionKey;
        }
        this.pipeControlMap.put(selectionKey, polymakeControl);
        this.pipeClientMap.put(selectionKey, null);
    }

    @Override
    public void run() {
        try {
            this.polyKey = this.polyChannel.register(this.selector, 1);
            while (true) {
                if (System.getProperty("polymake.debug") != null) {
                    newErr.println("java: selecting");
                }
                this.selector.select();
                Set<SelectionKey> set = this.selector.selectedKeys();
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    if (this.pipeControlMap.containsKey(selectionKey)) {
                        if (System.getProperty("polymake.debug") != null) {
                            newErr.println("controlPipe...");
                        }
                        this.bbuf.clear();
                        ((Pipe.SourceChannel)selectionKey.channel()).read(this.bbuf);
                        this.bbuf.flip();
                        char c = this.bbuf.getChar();
                        PolymakeControl polymakeControl = (PolymakeControl)this.pipeControlMap.get(selectionKey);
                        SelectionKey selectionKey2 = (SelectionKey)this.pipeClientMap.get(selectionKey);
                        if (!polymakeControl.isAlive()) {
                            this.pipeControlMap.remove(selectionKey);
                            this.pipeClientMap.remove(selectionKey);
                            if (selectionKey2 != null && this.clientControlMap.containsKey(selectionKey2)) {
                                this.clientControlMap.remove(selectionKey2);
                                selectionKey2.channel().close();
                            }
                        }
                        switch (c) {
                            case 'P': {
                                Object object = polymakeControl.getMessage();
                                this.polyChannel.write(CHARSET.encode((String)object));
                                if (System.getProperty("polymake.debug") == null) break;
                                newErr.println("jv->pm:\n" + (String)object + "sent.");
                                break;
                            }
                            case 'C': {
                                if (selectionKey2 == null) break;
                                Object object = (SocketChannel)selectionKey2.channel();
                                String string = polymakeControl.getMessage();
                                ((SocketChannel)object).write(CHARSET.encode(string));
                                if (System.getProperty("polymake.debug") == null) break;
                                newErr.println("jv->client:\n" + string + "sent.");
                                break;
                            }
                        }
                        if (!polymakeControl.getAnswer()) {
                            polymakeControl.popMessage();
                        }
                        if (!polymakeControl.isAlive() && this.pipeClientMap.size() == 0) {
                            System.exit(0);
                        }
                        if (System.getProperty("polymake.debug") == null) continue;
                        newErr.println("controlPipe...done");
                        continue;
                    }
                    if (this.clientControlMap.containsKey(selectionKey)) {
                        if (System.getProperty("polymake.debug") != null) {
                            newErr.println("clientChannel...");
                        }
                        ((PolymakeControl)this.clientControlMap.get(selectionKey)).update();
                        if (System.getProperty("polymake.debug") == null) continue;
                        newErr.println("clientChannel...done");
                        continue;
                    }
                    if (!this.polyKey.equals(selectionKey)) continue;
                    if (System.getProperty("polymake.debug") != null) {
                        newErr.println("polyChannel...");
                    }
                    if (selectionKey.isReadable()) {
                        try {
                            this.psp.parseLine(this.polyReader);
                        }
                        catch (PolymakeServerParser.PolymakeServerReadException polymakeServerReadException) {
                            System.exit(0);
                        }
                    }
                    if (System.getProperty("polymake.debug") == null) continue;
                    System.err.println("polyChannel...done");
                }
                Thread.yield();
            }
        }
        catch (ClosedChannelException closedChannelException) {
            newErr.println("Polymake exited while java running -- terminating java");
            System.exit(0);
        }
        catch (IOException iOException) {
            newErr.println("SelectorThread: caught IOException in IOThread");
            iOException.printStackTrace(newErr);
        }
    }

    protected void cleanUp() throws IOException {
        if (System.getProperty("polymake.debug") != null) {
            newErr.print("java exiting...");
        }
        if (this.polyChannel != null) {
            this.polyChannel.close();
        }
        if (System.getProperty("polymake.debug") != null) {
            newErr.println("done!");
        }
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        if (System.getProperty("polymake.debug") == null) {
            try {
                System.setOut(new PrintStream(new File("/dev/null")));
                System.setErr(new PrintStream(new File("/dev/null")));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace(newErr);
            }
        }
        try {
            int n = Integer.parseInt(stringArray[0]);
            InetAddress[] inetAddressArray = InetAddress.getAllByName("localhost");
            SocketChannel socketChannel = SocketChannel.open();
            InetSocketAddress inetSocketAddress = null;
            for (int i = 0; i < inetAddressArray.length; ++i) {
                try {
                    inetSocketAddress = new InetSocketAddress(inetAddressArray[i], n);
                    socketChannel.configureBlocking(true);
                    if (!socketChannel.connect(inetSocketAddress)) continue;
                    if (System.getProperty("polymake.debug") == null) break;
                    newErr.println("de.tuberlin.polymake.common.Launcher: Connection to " + inetAddressArray[i].toString() + ":" + n + " successful.");
                    break;
                }
                catch (IOException iOException) {
                    if (i <= inetAddressArray.length - 1) {
                        if (System.getProperty("polymake.debug") != null) {
                            newErr.println("de.tuberlin.polymake.common.Launcher: Connection to " + inetAddressArray[i].toString() + ":" + n + " refused.");
                        }
                        socketChannel = SocketChannel.open();
                        continue;
                    }
                    throw new IOException("Connection to polymake server at localhost could not be established.");
                }
            }
            socketChannel.configureBlocking(false);
            SelectorThread selectorThread = new SelectorThread(socketChannel);
            for (int i = 1; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("-nl")) continue;
                System.loadLibrary(stringArray[++i]);
            }
            selectorThread.start();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace(newErr);
            System.exit(0);
        }
        catch (NumberFormatException numberFormatException) {
            newErr.println(USAGE);
            System.exit(0);
        }
        catch (Exception exception) {
            newErr.println("SelectorThread: error initializing channels.");
            exception.printStackTrace(newErr);
            System.exit(0);
        }
    }
}

