/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.traces.painters.TracePainterPolyline;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.reflection.ObjRecorder2Trace2DAdapter;
import info.monitorenter.util.Range;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.JFrame;

public class RunningChart
extends JFrame {
    protected Chart2D m_chart = null;

    public static void main(String[] args) {
        Chart2D chart = new Chart2D();
        chart.setMinPaintLatency(20);
        Trace2DLtd data = new Trace2DLtd(300);
        data.setColor(new Color(255, 0, 0, 255));
        data.setName("random");
        data.setPhysicalUnits("hertz", "ms");
        TracePainterPolyline dotPainter = new TracePainterPolyline();
        data.setTracePainter(dotPainter);
        chart.addTrace(data);
        RunningChart wnd = new RunningChart(chart, "RunningChart");
        chart.getAxisX().setPaintGrid(true);
        chart.getAxisX().setStartMajorTick(false);
        chart.getAxisY().setPaintGrid(true);
        chart.getAxisX().setPaintScale(true);
        chart.getAxisX().setPaintScale(true);
        chart.getAxisY().setRangePolicy(new RangePolicyMinimumViewport(new Range(-10000.0, 10000.0)));
        wnd.setLocation(200, 300);
        wnd.setSize(700, 210);
        wnd.setResizable(true);
        wnd.setVisible(true);
        new ObjRecorder2Trace2DAdapter(data, new RandomBumper(0.5, 1000), "m_number", 100L);
    }

    public RunningChart(Chart2D chart, String label) {
        super(label);
        this.m_chart = chart;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RunningChart.this.setVisible(false);
                RunningChart.this.dispose();
                System.exit(0);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new ChartPanel(this.m_chart), "Center");
    }

    static class RandomBumper
    extends Thread {
        protected double m_factor;
        protected double m_number = 0.0;
        protected double m_plusminus = 0.5;
        protected Random m_randomizer = new Random();

        public RandomBumper(double plusminus, int factor) {
            if (plusminus < 0.0 || plusminus > 1.0) {
                System.out.println(this.getClass().getName() + " ignores constructor-passed value. Must be between 0.0 and 1.0!");
            } else {
                this.m_plusminus = plusminus;
            }
            this.m_factor = factor;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (true) {
                double rand;
                this.m_number = (rand = this.m_randomizer.nextDouble()) < this.m_plusminus ? (this.m_number += this.m_randomizer.nextDouble() * this.m_factor) : (this.m_number -= this.m_randomizer.nextDouble() * this.m_factor);
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

