/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tomcat.jakartaee.bcel.classfile.Constant;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantObject;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public final class ConstantPackage
extends Constant
implements ConstantObject {
    private int nameIndex;

    public ConstantPackage(ConstantPackage c) {
        this(c.getNameIndex());
    }

    ConstantPackage(DataInput file) throws IOException {
        this(file.readUnsignedShort());
    }

    public ConstantPackage(int nameIndex) {
        super((byte)20);
        this.nameIndex = nameIndex;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantPackage(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.nameIndex);
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        Constant c = cp.getConstant(this.nameIndex, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public String getBytes(ConstantPool cp) {
        return (String)this.getConstantValue(cp);
    }

    @Override
    public String toString() {
        return super.toString() + "(nameIndex = " + this.nameIndex + ")";
    }
}

