/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.ui;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.NodesCache;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.model.RootNode;
import com.sun.tools.visualvm.heapviewer.ui.BreadCrumbsNavigator;
import com.sun.tools.visualvm.heapviewer.ui.Bundle;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerNodeAction;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerRenderer;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerTreeTable;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableViewColumn;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableViewRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.openide.util.Lookup;

public class TreeTableView {
    private final String viewID;
    private final HeapContext context;
    private final HeapViewerActions actions;
    private final List<TreeTableViewColumn> columns;
    private final Root root;
    private HeapViewerNode currentRoot;
    private Model model;
    private NodesCache nodesCache;
    private HeapViewerTreeTable treeTable;
    private List<DataType> dataTypes;
    private List<SortOrder> sortOrders;
    private Collection<HeapViewerRenderer.Provider> rendererProviders;
    private TreeTableViewRenderer nodesRenderer;
    private Collection<HeapViewerNodeAction.Provider> actionProviders;
    private JComponent component;
    private BreadCrumbsNavigator navigator;
    private HeapViewerNodeFilter filter;
    private JComponent filterComponent;
    private boolean hasSelection;
    private String viewName;

    public TreeTableView(String viewID, HeapContext context, HeapViewerActions actions, TreeTableViewColumn ... columns) {
        this(viewID, context, actions, false, true, columns);
    }

    public TreeTableView(String viewID, final HeapContext context, final HeapViewerActions actions, boolean useBreadCrumbs, boolean pluggableColumns, TreeTableViewColumn ... columns) {
        assert (!SwingUtilities.isEventDispatchThread());
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("View must have at least one column defined");
        }
        this.viewID = viewID;
        this.context = context;
        this.actions = actions;
        this.root = new Root(){

            @Override
            public HeapContext getContext() {
                return TreeTableView.this.context;
            }

            @Override
            public String getViewID() {
                return TreeTableView.this.viewID;
            }

            @Override
            public HeapViewerNodeFilter getViewFilter() {
                return TreeTableView.this.filter;
            }

            @Override
            public List<DataType> getDataTypes() {
                return TreeTableView.this.dataTypes;
            }

            @Override
            public List<SortOrder> getSortOrders() {
                return TreeTableView.this.sortOrders;
            }

            @Override
            public void refreshNode(HeapViewerNode node) {
                if (TreeTableView.this.treeTable != null) {
                    TreeTableView.this.treeTable.repaint();
                }
            }

            @Override
            public void updateChildren(HeapViewerNode node) {
                if (TreeTableView.this.model != null) {
                    TreeTableView.this.model.childrenChanged((TreeNode)((Object)TreeTableView.this.root));
                }
                TreeTableView.this.childrenChanged();
            }

            @Override
            protected HeapViewerNode[] retrieveChildren(HeapViewerNode node) {
                return TreeTableView.this.nodesCache.retrieveChildren(node);
            }

            @Override
            protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
                return TreeTableView.this.computeData(TreeTableView.this.root, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
            }
        };
        this.currentRoot = this.root;
        this.columns = new ArrayList<TreeTableViewColumn>();
        if (columns != null) {
            Collections.addAll(this.columns, columns);
        }
        if (pluggableColumns) {
            Heap heap = context.getFragment().getHeap();
            for (TreeTableViewColumn.Provider provider : Lookup.getDefault().lookupAll(TreeTableViewColumn.Provider.class)) {
                Collections.addAll(this.columns, provider.getColumns(heap, this.viewID));
            }
        }
        Collections.sort(this.columns, new Comparator<TreeTableViewColumn>(){

            @Override
            public int compare(TreeTableViewColumn column1, TreeTableViewColumn column2) {
                return Integer.compare(column1.getPosition(), column2.getPosition());
            }
        });
        this.rendererProviders = new ArrayList<HeapViewerRenderer.Provider>();
        for (Object provider : Lookup.getDefault().lookupAll(HeapViewerRenderer.Provider.class)) {
            if (!((HeapViewerRenderer.Provider)provider).supportsView(context, viewID)) continue;
            this.rendererProviders.add((HeapViewerRenderer.Provider)provider);
        }
        this.actionProviders = new ArrayList<HeapViewerNodeAction.Provider>();
        for (Object provider : Lookup.getDefault().lookupAll(HeapViewerNodeAction.Provider.class)) {
            if (!((HeapViewerNodeAction.Provider)provider).supportsView(context, viewID)) continue;
            this.actionProviders.add((HeapViewerNodeAction.Provider)provider);
        }
        if (useBreadCrumbs) {
            this.navigator = new BreadCrumbsNavigator(){

                @Override
                void nodeClicked(HeapViewerNode node) {
                    TreeTableView.this.selectExistingNode(node);
                }

                @Override
                void nodePinned(HeapViewerNode node) {
                    TreeTableView.this.pinNode(node);
                }

                @Override
                void openNode(HeapViewerNode node) {
                }

                @Override
                HeapViewerRenderer getRenderer(HeapViewerNode node) {
                    return TreeTableView.this.getNodeRenderer(node);
                }

                @Override
                HeapViewerNodeAction.Actions getNodeActions(HeapViewerNode node) {
                    return HeapViewerNodeAction.Actions.forNode(node, TreeTableView.this.actionProviders, context, actions, new HeapViewerNodeAction[0]);
                }
            };
        }
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
        if (this.component != null && !this.hasSelection) {
            this.nodeSelected(null, false);
        }
    }

    public void setViewFilter(HeapViewerNodeFilter filter) {
        this.filter = filter;
        this.setViewName(this.viewName);
        this.reloadView();
    }

    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    String getViewID() {
        return this.viewID;
    }

    HeapContext getContext() {
        return this.context;
    }

    public RootNode getRoot() {
        if (this.component == null) {
            this.init();
        }
        return this.root;
    }

    public void reloadView() {
        if (this.component != null) {
            Root _root = (Root)this.getRoot();
            if (_root != this.currentRoot) {
                this.pinNode(null);
            }
            _root.resetChildren();
            _root.updateChildren(null);
        }
    }

    public void selectNode(HeapViewerNode node) {
        this.treeTable.selectPath(HeapViewerNode.fromNode((TreeNode)((Object)node), (TreeNode)((Object)this.currentRoot)), true);
    }

    public void expandNode(HeapViewerNode node) {
        if (this.treeTable == null) {
            return;
        }
        this.treeTable.expandPath(HeapViewerNode.fromNode((TreeNode)((Object)node)));
    }

    public void collapseChildren(HeapViewerNode node) {
        if (this.treeTable == null) {
            return;
        }
        this.treeTable.collapseChildren(HeapViewerNode.fromNode((TreeNode)((Object)node)));
    }

    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        boolean bl = this.hasSelection = node != null;
        if (this.navigator != null) {
            String _viewName = this.viewName;
            if (_viewName != null && this.filter != null) {
                _viewName = Bundle.TreeTableView_FilteredFlag(_viewName);
            }
            this.navigator.setNode(node, this.currentRoot == this.root ? null : this.currentRoot, this.getRoot(), _viewName);
        }
    }

    protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
        return HeapViewerNode.NO_NODES;
    }

    protected void childrenChanged() {
    }

    private TreeTableViewRenderer getNodesRenderer() {
        if (this.nodesRenderer == null) {
            HashMap<Class<? extends HeapViewerNode>, HeapViewerRenderer> map = new HashMap<Class<? extends HeapViewerNode>, HeapViewerRenderer>();
            this.nodesRenderer = new TreeTableViewRenderer();
            for (HeapViewerRenderer.Provider provider : this.rendererProviders) {
                map.clear();
                provider.registerRenderers(map, this.context);
                this.nodesRenderer.registerRenderers(map);
            }
            this.rendererProviders = null;
        }
        return this.nodesRenderer;
    }

    public HeapViewerRenderer getNodeRenderer(HeapViewerNode node) {
        TreeTableViewRenderer viewRenderer = this.getNodesRenderer();
        HeapViewerRenderer nodeRenderer = viewRenderer.resolve(((Object)((Object)node)).getClass());
        nodeRenderer.setValue((Object)node, -1);
        return nodeRenderer;
    }

    private void setRoot(HeapViewerNode newRoot) {
        this.model.setRoot((TreeNode)((Object)newRoot));
        this.currentRoot = newRoot;
        this.treeTable.setRootVisible(this.currentRoot != this.root);
    }

    void selectExistingNode(HeapViewerNode node) {
        if (node == null) {
            this.treeTable.clearSelection();
            this.setRoot(this.root);
            this.treeTable.collapseAll();
            this.treeTable.expandPath(new TreePath(this.model.getRoot()));
            this.treeTable.scrollRectToVisible(new Rectangle());
        } else {
            if (!this.inPinnedView(node)) {
                this.setRoot(this.root);
            }
            this.treeTable.selectPath(HeapViewerNode.fromNode((TreeNode)((Object)node), (TreeNode)((Object)this.currentRoot)), true);
            this.treeTable.collapseChildren(HeapViewerNode.fromNode((TreeNode)((Object)node), (TreeNode)((Object)this.currentRoot)));
        }
        this.treeTable.requestFocusInWindow();
        this.updateSelectedNode();
    }

    protected void pinNode(HeapViewerNode node) {
        HeapViewerNode sel;
        int row = this.treeTable.getSelectedRow();
        HeapViewerNode heapViewerNode = sel = row == -1 ? null : (HeapViewerNode)((Object)this.treeTable.getValueForRow(row));
        if (node == null) {
            this.setRoot(this.root);
            if (sel != null) {
                this.treeTable.selectPath(HeapViewerNode.fromNode((TreeNode)((Object)sel), (TreeNode)((Object)this.currentRoot)), true);
            }
        } else {
            this.setRoot(node);
            if (sel != null) {
                this.treeTable.selectPath(HeapViewerNode.fromNode((TreeNode)((Object)sel), (TreeNode)((Object)this.currentRoot)), true);
            }
            if (this.treeTable.getSelectedValue(0) == null) {
                this.treeTable.selectRow(0, true);
            }
        }
        this.updateSelectedNode();
        this.treeTable.requestFocusInWindow();
    }

    private boolean inPinnedView(HeapViewerNode node) {
        while (node != this.root && node != null) {
            if (node == this.currentRoot) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private void updateSelectedNode() {
    }

    private void init() {
        this.model = new Model();
        this.nodesCache = new NodesCache();
        this.component = this.createComponent();
    }

    protected JComponent createComponent() {
        List<RowSorter.SortKey> sortKeys;
        int sortingColumn = -1;
        for (int i = 0; i < this.columns.size(); ++i) {
            TreeTableViewColumn column = this.columns.get(i);
            if (!column.initiallyVisible() || !column.initiallySorting()) continue;
            sortingColumn = i;
            break;
        }
        if (sortingColumn != -1) {
            RowSorter.SortKey sortKey = new RowSorter.SortKey(sortingColumn, SortOrder.DESCENDING);
            sortKeys = Collections.singletonList(sortKey);
        } else {
            sortKeys = Collections.EMPTY_LIST;
        }
        this.updateSortInfo((List<? extends RowSorter.SortKey>)sortKeys);
        this.treeTable = new HeapViewerTreeTable((ProfilerTreeTableModel)this.model, sortKeys){

            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                HeapViewerNode node = (HeapViewerNode)((Object)value);
                HeapViewerNodeAction.Actions nodeActions = TreeTableView.this.navigator == null ? HeapViewerNodeAction.Actions.forNode(node, TreeTableView.this.actionProviders, TreeTableView.this.context, TreeTableView.this.actions, new HeapViewerNodeAction[0]) : HeapViewerNodeAction.Actions.forNode(node, TreeTableView.this.actionProviders, TreeTableView.this.context, TreeTableView.this.actions, new PinAction(node), new ResetPinAction());
                nodeActions.populatePopup(popup);
                TreeTableView.this.populatePopup(node, popup);
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                popup.add(TreeTableView.this.treeTable.createCopyMenuItem());
                TreeTableView.this.populatePopupLast(node, popup);
            }

            public void performDefaultAction(ActionEvent e) {
                int row = this.getSelectedRow();
                if (row == -1) {
                    return;
                }
                TreeNode value = this.getValueForRow(row);
                if (!(value instanceof HeapViewerNode)) {
                    return;
                }
                HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode((HeapViewerNode)((Object)value), TreeTableView.this.actionProviders, TreeTableView.this.context, TreeTableView.this.actions, new HeapViewerNodeAction[0]);
                nodeActions.performDefaultAction(e);
            }

            @Override
            protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
                TreeTableView.this.nodeSelected(node, adjusting);
            }

            @Override
            protected void forgetChildren(HeapViewerNode node) {
                node.forgetChildren(TreeTableView.this.nodesCache);
            }

            @Override
            protected void willBeSorted(List<? extends RowSorter.SortKey> sortKeys) {
                if (!this.isInitializing() && !sortKeys.isEmpty()) {
                    Heap heap;
                    int col = sortKeys.get(0).getColumn();
                    DataType type = ((TreeTableViewColumn)TreeTableView.this.columns.get(col)).getDataType();
                    if (!type.valuesAvailable(heap = TreeTableView.this.context.getFragment().getHeap())) {
                        type.computeValues(heap, null);
                    }
                }
                TreeTableView.this.updateSortInfo(sortKeys);
                TreeTableView.this.nodesCache.clear();
                super.willBeSorted(sortKeys);
            }
        };
        this.treeTable.setTreeCellRenderer(this.getNodesRenderer());
        for (int i = 0; i < this.columns.size(); ++i) {
            int width;
            TreeTableViewColumn column = this.columns.get(i);
            if (i > 0) {
                this.treeTable.setColumnRenderer(i, TreeTableView.getRenderer(column));
            }
            if ((width = column.getPreferredWidth()) > -1) {
                this.treeTable.setDefaultColumnWidth(i, width);
            }
            if (column.initiallyVisible()) continue;
            this.treeTable.setColumnVisibility(i, false);
        }
        this.treeTable.providePopupMenu(true);
        this.treeTable.setSelectionOnMiddlePress(true);
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    int row = TreeTableView.this.treeTable.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    TreeNode value = TreeTableView.this.treeTable.getValueForRow(row);
                    if (!(value instanceof HeapViewerNode)) {
                        return;
                    }
                    HeapViewerNode node = (HeapViewerNode)((Object)value);
                    HeapViewerNodeAction.Actions nodeActions = TreeTableView.this.navigator == null ? HeapViewerNodeAction.Actions.forNode(node, TreeTableView.this.actionProviders, TreeTableView.this.context, TreeTableView.this.actions, new HeapViewerNodeAction[0]) : HeapViewerNodeAction.Actions.forNode(node, TreeTableView.this.actionProviders, TreeTableView.this.context, TreeTableView.this.actions, new PinAction(node), new ResetPinAction());
                    ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "middle button", e.getWhen(), e.getModifiers());
                    nodeActions.performMiddleButtonAction(ae);
                }
            }
        });
        JPanel comp = new JPanel(new BorderLayout()){

            @Override
            public boolean requestFocusInWindow() {
                return TreeTableView.this.treeTable.requestFocusInWindow();
            }
        };
        comp.add((Component)new ProfilerTableContainer((ProfilerTable)this.treeTable, false, null), "Center");
        JPanel toolsContainer = new JPanel(new GridBagLayout());
        comp.add((Component)toolsContainer, "South");
        if (this.navigator != null) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.fill = 2;
            c.weightx = 1.0;
            toolsContainer.add(this.navigator.getComponent(), c);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        this.filterComponent = new JPanel(new BorderLayout());
        this.filterComponent.setVisible(false);
        toolsContainer.add((Component)this.filterComponent, c);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableView.this.nodeSelected(null, false);
            }
        });
        return comp;
    }

    protected void populatePopup(HeapViewerNode node, JPopupMenu popup) {
    }

    protected void populatePopupLast(HeapViewerNode node, JPopupMenu popup) {
        if (this.filterComponent.getComponentCount() > 0) {
            popup.addSeparator();
            popup.add(new JMenuItem(Bundle.TreeTableView_Filter()){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    TreeTableView.this.activateFilter();
                }
            });
        }
    }

    protected void setFilterComponent(JComponent filter) {
        this.filterComponent.add((Component)filter, "Center");
        this.filterComponent.setVisible(true);
        this.registerActions();
    }

    protected JComponent getFilterComponent() {
        return this.filterComponent.getComponentCount() == 0 ? null : (JComponent)this.filterComponent.getComponent(0);
    }

    private void activateFilter() {
        JComponent filterComp = this.getFilterComponent();
        if (filterComp != null) {
            ((Component)filterComp).setVisible(true);
            ((Component)filterComp).requestFocusInWindow();
        }
    }

    private void registerActions() {
        InputMap inputMap = this.treeTable.getInputMap(1);
        ActionMap actionMap = this.treeTable.getActionMap();
        String filterKey = "filter-action-key";
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeTableView.this.activateFilter();
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
    }

    private void updateSortInfo(List<? extends RowSorter.SortKey> sortKeys) {
        if (sortKeys == null) {
            this.dataTypes = null;
            this.sortOrders = null;
        } else {
            this.dataTypes = new ArrayList<DataType>(sortKeys.size());
            this.sortOrders = new ArrayList<SortOrder>(sortKeys.size());
            for (RowSorter.SortKey sortKey : sortKeys) {
                if (this.columns.size() <= sortKey.getColumn()) continue;
                this.dataTypes.add(this.columns.get(sortKey.getColumn()).getDataType());
                this.sortOrders.add(sortKey.getSortOrder());
            }
        }
    }

    private static ProfilerRenderer getRenderer(TreeTableViewColumn column) {
        ProfilerRenderer renderer = column.getRenderer();
        if (renderer != null) {
            return renderer;
        }
        Class columnClass = column.getDataType().getType();
        if (Number.class.isAssignableFrom(columnClass)) {
            return new NumberRenderer();
        }
        return new LabelRenderer();
    }

    private abstract class Root
    extends RootNode {
        private Root() {
        }

        @Override
        public abstract void updateChildren(HeapViewerNode var1);
    }

    private final class Model
    extends ProfilerTreeTableModel.Abstract {
        private Runnable[] dataTypeListeners;

        private Model() {
            super((TreeNode)((Object)TreeTableView.this.root));
            this.dataTypeListeners = new Runnable[this.getColumnCount()];
            for (int i = 0; i < this.dataTypeListeners.length; ++i) {
                TreeTableViewColumn viewColumn = (TreeTableViewColumn)TreeTableView.this.columns.get(i);
                final DataType dataType = viewColumn.getDataType();
                if (dataType.valuesAvailable(TreeTableView.this.context.getFragment().getHeap())) {
                    this.dataTypeListeners[i] = null;
                    continue;
                }
                final int ii = i;
                this.dataTypeListeners[ii] = new Runnable(){

                    @Override
                    public void run() {
                        ((Model)Model.this).dataTypeListeners[ii] = null;
                        TableColumn tableColumn = TreeTableView.this.treeTable.getColumnModel().getColumn(ii);
                        tableColumn.setHeaderValue(Model.this.getColumnName(ii));
                        TreeTableView.this.component.repaint();
                        if (TreeTableView.this.dataTypes != null && TreeTableView.this.dataTypes.contains(dataType)) {
                            TreeTableView.this.reloadView();
                        }
                    }
                };
                dataType.notifyWhenAvailable(TreeTableView.this.context.getFragment().getHeap(), this.dataTypeListeners[ii]);
            }
        }

        public int getColumnCount() {
            return TreeTableView.this.columns.size();
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return JTree.class;
            }
            return ((TreeTableViewColumn)TreeTableView.this.columns.get(column)).getDataType().getType();
        }

        public String getColumnName(int column) {
            String columnName = ((TreeTableViewColumn)TreeTableView.this.columns.get(column)).getHeaderValue().toString();
            return this.dataTypeListeners[column] == null ? columnName : "<html><nobr>" + columnName + " <small style='color: gray;'>(" + Bundle.TreeTableView_SortToGet() + ")</small></nobr></html>";
        }

        public Object getValueAt(TreeNode node, int column) {
            return HeapViewerNode.getValue((HeapViewerNode)((Object)node), ((TreeTableViewColumn)TreeTableView.this.columns.get(column)).getDataType(), TreeTableView.this.context.getFragment().getHeap());
        }

        public void setValueAt(Object aValue, TreeNode node, int column) {
        }

        public boolean isCellEditable(TreeNode node, int column) {
            return false;
        }
    }

    private class ResetPinAction
    extends HeapViewerNodeAction {
        ResetPinAction() {
            super(Bundle.TreeTableView_ResetPin(), 111);
            this.setEnabled(TreeTableView.this.root != TreeTableView.this.currentRoot);
        }

        @Override
        public boolean isMiddleButtonDefault(ActionEvent e) {
            int modifiers = e.getModifiers();
            return (modifiers & 2) == 2 && (modifiers & 1) == 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeTableView.this.pinNode(null);
        }
    }

    private class PinAction
    extends HeapViewerNodeAction {
        private final HeapViewerNode node;

        PinAction(HeapViewerNode node) {
            super(Bundle.TreeTableView_Pin(), 110);
            this.node = node;
            this.setEnabled(node != TreeTableView.this.currentRoot && !node.isLeaf());
        }

        @Override
        public boolean isMiddleButtonDefault(ActionEvent e) {
            int modifiers = e.getModifiers();
            return (modifiers & 2) == 2 && (modifiers & 1) != 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeTableView.this.pinNode(this.node);
        }
    }
}

