/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import jakarta.el.ELException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.SimpleNode;

public final class AstNegative
extends SimpleNode {
    public AstNegative(int n) {
        super(n);
    }

    @Override
    public Class<?> getType(EvaluationContext evaluationContext) throws ELException {
        return Number.class;
    }

    @Override
    public Object getValue(EvaluationContext evaluationContext) throws ELException {
        Object object = this.children[0].getValue(evaluationContext);
        if (object == null) {
            return 0L;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).negate();
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).negate();
        }
        if (object instanceof String) {
            if (AstNegative.isStringFloat((String)object)) {
                return -Double.parseDouble((String)object);
            }
            return -Long.parseLong((String)object);
        }
        if (object instanceof Long) {
            return -((Long)object).longValue();
        }
        if (object instanceof Double) {
            return -((Double)object).doubleValue();
        }
        if (object instanceof Integer) {
            return -((Integer)object).intValue();
        }
        if (object instanceof Float) {
            return Float.valueOf(-((Float)object).floatValue());
        }
        if (object instanceof Short) {
            return -((Short)object).shortValue();
        }
        if (object instanceof Byte) {
            return -((Byte)object).byteValue();
        }
        Long l = (Long)AstNegative.coerceToNumber(evaluationContext, object, Long.class);
        return -l.longValue();
    }
}

