/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class SetBuildQueueMessage
extends DOMMessage {
    private final String colonyId;
    private final String[] queue;

    public SetBuildQueueMessage(Colony colony, List<BuildableType> queue) {
        super(SetBuildQueueMessage.getXMLElementTagName());
        this.colonyId = colony.getId();
        this.queue = new String[queue.size()];
        for (int i = 0; i < queue.size(); ++i) {
            this.queue[i] = queue.get(i).getId();
        }
    }

    public SetBuildQueueMessage(Game game, Element element) {
        super(SetBuildQueueMessage.getXMLElementTagName());
        int size;
        this.colonyId = element.getAttribute("colony");
        try {
            size = Integer.parseInt(element.getAttribute("size"));
        }
        catch (NumberFormatException e) {
            size = -1;
        }
        if (size >= 0) {
            this.queue = new String[size];
            for (int i = 0; i < size; ++i) {
                this.queue[i] = element.getAttribute("x" + Integer.toString(i));
            }
        } else {
            this.queue = null;
        }
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        Specification spec = game.getSpecification();
        try {
            colony = player.getOurFreeColGameObject(this.colonyId, Colony.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (this.queue == null) {
            return DOMMessage.clientError("Empty queue");
        }
        ArrayList<BuildableType> buildQueue = new ArrayList<BuildableType>();
        for (int i = 0; i < this.queue.length; ++i) {
            try {
                buildQueue.add(i, spec.getType(this.queue[i], BuildableType.class));
                continue;
            }
            catch (Exception cce) {
                return DOMMessage.clientError("Not a buildable type: " + this.queue[i]);
            }
        }
        return server.getInGameController().setBuildQueue(serverPlayer, colony, buildQueue);
    }

    @Override
    public Element toXMLElement() {
        Element result = SetBuildQueueMessage.createMessage(SetBuildQueueMessage.getXMLElementTagName(), "colony", this.colonyId, "size", Integer.toString(this.queue.length));
        for (int i = 0; i < this.queue.length; ++i) {
            result.setAttribute("x" + Integer.toString(i), this.queue[i]);
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "setBuildQueue";
    }
}

