/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;

public class JDBCStore
extends StoreBase {
    protected static final String info = "JDBCStore/1.0";
    private String name = null;
    protected static String storeName = "JDBCStore";
    protected String threadName = "JDBCStore";
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    private Connection dbConnection = null;
    protected Driver driver = null;
    protected String driverName = null;
    protected String dataSourceName = null;
    protected DataSource dataSource = null;
    protected String sessionTable = "tomcat$sessions";
    protected String sessionAppCol = "app";
    protected String sessionIdCol = "id";
    protected String sessionDataCol = "data";
    protected String sessionValidCol = "valid";
    protected String sessionMaxInactiveCol = "maxinactive";
    protected String sessionLastAccessedCol = "lastaccess";
    protected PreparedStatement preparedSizeSql = null;
    protected PreparedStatement preparedSaveSql = null;
    protected PreparedStatement preparedClearSql = null;
    protected PreparedStatement preparedRemoveSql = null;
    protected PreparedStatement preparedLoadSql = null;

    @Override
    public String getInfo() {
        return info;
    }

    public String getName() {
        if (this.name == null) {
            Container container = this.manager.getContainer();
            String string = container.getName();
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            String string2 = "";
            String string3 = "";
            if (container.getParent() != null) {
                Container container2 = container.getParent();
                string2 = container2.getName();
                if (container2.getParent() != null) {
                    string3 = container2.getParent().getName();
                }
            }
            this.name = "/" + string3 + "/" + string2 + string;
        }
        return this.name;
    }

    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public String getStoreName() {
        return storeName;
    }

    public void setDriverName(String string) {
        String string2 = this.driverName;
        this.driverName = string;
        this.support.firePropertyChange("driverName", string2, this.driverName);
        this.driverName = string;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String string) {
        this.connectionPassword = string;
    }

    public void setConnectionURL(String string) {
        String string2 = this.connectionURL;
        this.connectionURL = string;
        this.support.firePropertyChange("connectionURL", string2, this.connectionURL);
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setSessionTable(String string) {
        String string2 = this.sessionTable;
        this.sessionTable = string;
        this.support.firePropertyChange("sessionTable", string2, this.sessionTable);
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionAppCol(String string) {
        String string2 = this.sessionAppCol;
        this.sessionAppCol = string;
        this.support.firePropertyChange("sessionAppCol", string2, this.sessionAppCol);
    }

    public String getSessionAppCol() {
        return this.sessionAppCol;
    }

    public void setSessionIdCol(String string) {
        String string2 = this.sessionIdCol;
        this.sessionIdCol = string;
        this.support.firePropertyChange("sessionIdCol", string2, this.sessionIdCol);
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionDataCol(String string) {
        String string2 = this.sessionDataCol;
        this.sessionDataCol = string;
        this.support.firePropertyChange("sessionDataCol", string2, this.sessionDataCol);
    }

    public String getSessionDataCol() {
        return this.sessionDataCol;
    }

    public void setSessionValidCol(String string) {
        String string2 = this.sessionValidCol;
        this.sessionValidCol = string;
        this.support.firePropertyChange("sessionValidCol", string2, this.sessionValidCol);
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionMaxInactiveCol(String string) {
        String string2 = this.sessionMaxInactiveCol;
        this.sessionMaxInactiveCol = string;
        this.support.firePropertyChange("sessionMaxInactiveCol", string2, this.sessionMaxInactiveCol);
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionLastAccessedCol(String string) {
        String string2 = this.sessionLastAccessedCol;
        this.sessionLastAccessedCol = string;
        this.support.firePropertyChange("sessionLastAccessedCol", string2, this.sessionLastAccessedCol);
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    public void setDataSourceName(String string) {
        if (string == null || "".equals(string.trim())) {
            this.manager.getContainer().getLogger().warn((Object)sm.getString(this.getStoreName() + ".missingDataSourceName"));
            return;
        }
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public String[] expiredKeys() throws IOException {
        return this.keys(true);
    }

    @Override
    public String[] keys() throws IOException {
        return this.keys(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] keys(boolean bl) throws IOException {
        String[] stringArray = null;
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return new String[0];
                }
                try {
                    String string = "SELECT " + this.sessionIdCol + " FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                    if (bl) {
                        string = string + " AND (" + this.sessionLastAccessedCol + " + " + this.sessionMaxInactiveCol + " * 1000 < ?)";
                    }
                    PreparedStatement preparedStatement = connection.prepareStatement(string);
                    try {
                        preparedStatement.setString(1, this.getName());
                        if (bl) {
                            preparedStatement.setLong(2, System.currentTimeMillis());
                        }
                        ResultSet resultSet = preparedStatement.executeQuery();
                        try {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            if (resultSet != null) {
                                while (resultSet.next()) {
                                    arrayList.add(resultSet.getString(1));
                                }
                            }
                            stringArray = arrayList.toArray(new String[0]);
                            i = 0;
                            continue;
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                    }
                    finally {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    stringArray = new String[]{};
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    this.release(connection);
                }
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() throws IOException {
        int n = 0;
        ResultSet resultSet = null;
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return n;
                }
                try {
                    if (this.preparedSizeSql == null) {
                        String string = "SELECT COUNT(" + this.sessionIdCol + ") FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                        this.preparedSizeSql = connection.prepareStatement(string);
                    }
                    this.preparedSizeSql.setString(1, this.getName());
                    resultSet = this.preparedSizeSql.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                    i = 0;
                    continue;
                }
                catch (SQLException sQLException) {
                    this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    this.release(connection);
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session load(String string) throws ClassNotFoundException, IOException {
        ResultSet resultSet = null;
        StandardSession standardSession = null;
        ClassLoader classLoader = null;
        ObjectInputStream objectInputStream = null;
        Context context = (Context)this.manager.getContainer();
        Log log = context.getLogger();
        Loader loader = context.getLoader();
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return null;
                }
                ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                try {
                    if (this.preparedLoadSql == null) {
                        String string2 = "SELECT " + this.sessionIdCol + ", " + this.sessionDataCol + " FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ? AND " + this.sessionAppCol + " = ?";
                        this.preparedLoadSql = connection.prepareStatement(string2);
                    }
                    this.preparedLoadSql.setString(1, string);
                    this.preparedLoadSql.setString(2, this.getName());
                    resultSet = this.preparedLoadSql.executeQuery();
                    if (resultSet.next()) {
                        if (classLoader != null) {
                            Thread.currentThread().setContextClassLoader(classLoader);
                        }
                        objectInputStream = this.getObjectInputStream(resultSet.getBinaryStream(2));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString(this.getStoreName() + ".loading", new Object[]{string, this.sessionTable}));
                        }
                        standardSession = (StandardSession)this.manager.createEmptySession();
                        standardSession.readObjectData(objectInputStream);
                        standardSession.setManager(this.manager);
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)(this.getStoreName() + ": No persisted data object found"));
                    }
                    i = 0;
                    continue;
                }
                catch (SQLException sQLException) {
                    log.error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    Thread.currentThread().setContextClassLoader(classLoader2);
                    this.release(connection);
                }
            }
        }
        return standardSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String string) throws IOException {
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return;
                }
                try {
                    this.remove(string, connection);
                    i = 0;
                    continue;
                }
                catch (SQLException sQLException) {
                    this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    this.release(connection);
                }
            }
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)sm.getString(this.getStoreName() + ".removing", new Object[]{string, this.sessionTable}));
        }
    }

    private void remove(String string, Connection connection) throws SQLException {
        if (this.preparedRemoveSql == null) {
            String string2 = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?  AND " + this.sessionAppCol + " = ?";
            this.preparedRemoveSql = connection.prepareStatement(string2);
        }
        this.preparedRemoveSql.setString(1, string);
        this.preparedRemoveSql.setString(2, this.getName());
        this.preparedRemoveSql.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return;
                }
                try {
                    if (this.preparedClearSql == null) {
                        String string = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                        this.preparedClearSql = connection.prepareStatement(string);
                    }
                    this.preparedClearSql.setString(1, this.getName());
                    this.preparedClearSql.execute();
                    i = 0;
                    continue;
                }
                catch (SQLException sQLException) {
                    this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                finally {
                    this.release(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Session session) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = null;
        JDBCStore jDBCStore = this;
        synchronized (jDBCStore) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return;
                }
                try {
                    this.remove(session.getIdInternal(), connection);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));
                    ((StandardSession)session).writeObjectData(objectOutputStream);
                    objectOutputStream.close();
                    objectOutputStream = null;
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    int n = byArray.length;
                    byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
                    inputStream = new BufferedInputStream(byteArrayInputStream, n);
                    if (this.preparedSaveSql == null) {
                        String string = "INSERT INTO " + this.sessionTable + " (" + this.sessionIdCol + ", " + this.sessionAppCol + ", " + this.sessionDataCol + ", " + this.sessionValidCol + ", " + this.sessionMaxInactiveCol + ", " + this.sessionLastAccessedCol + ") VALUES (?, ?, ?, ?, ?, ?)";
                        this.preparedSaveSql = connection.prepareStatement(string);
                    }
                    this.preparedSaveSql.setString(1, session.getIdInternal());
                    this.preparedSaveSql.setString(2, this.getName());
                    this.preparedSaveSql.setBinaryStream(3, inputStream, n);
                    this.preparedSaveSql.setString(4, session.isValid() ? "1" : "0");
                    this.preparedSaveSql.setInt(5, session.getMaxInactiveInterval());
                    this.preparedSaveSql.setLong(6, session.getLastAccessedTime());
                    this.preparedSaveSql.execute();
                    i = 0;
                    continue;
                }
                catch (SQLException sQLException) {
                    this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    if (this.dbConnection == null) continue;
                    this.close(this.dbConnection);
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                finally {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    this.release(connection);
                }
            }
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)sm.getString(this.getStoreName() + ".saving", new Object[]{session.getIdInternal(), this.sessionTable}));
        }
    }

    protected Connection getConnection() {
        Connection connection = null;
        try {
            connection = this.open();
            if (connection == null || connection.isClosed()) {
                this.manager.getContainer().getLogger().info((Object)sm.getString(this.getStoreName() + ".checkConnectionDBClosed"));
                connection = this.open();
                if (connection == null || connection.isClosed()) {
                    this.manager.getContainer().getLogger().info((Object)sm.getString(this.getStoreName() + ".checkConnectionDBReOpenFail"));
                }
            }
        }
        catch (SQLException sQLException) {
            this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".checkConnectionSQLException", new Object[]{sQLException.toString()}));
        }
        return connection;
    }

    protected Connection open() throws SQLException {
        Class<?> clazz;
        if (this.dbConnection != null) {
            return this.dbConnection;
        }
        if (this.dataSourceName != null && this.dataSource == null) {
            try {
                clazz = new InitialContext();
                javax.naming.Context context = (javax.naming.Context)clazz.lookup("java:comp/env");
                this.dataSource = (DataSource)context.lookup(this.dataSourceName);
            }
            catch (NamingException namingException) {
                this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".wrongDataSource", new Object[]{this.dataSourceName}), (Throwable)namingException);
            }
        }
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        if (this.driver == null) {
            try {
                clazz = Class.forName(this.driverName);
                this.driver = (Driver)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".checkConnectionClassNotFoundException", new Object[]{classNotFoundException.toString()}));
                throw new SQLException(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".checkConnectionClassNotFoundException", new Object[]{instantiationException.toString()}));
                throw new SQLException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".checkConnectionClassNotFoundException", new Object[]{illegalAccessException.toString()}));
                throw new SQLException(illegalAccessException);
            }
        }
        clazz = new Properties();
        if (this.connectionName != null) {
            ((Properties)((Object)clazz)).put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            ((Properties)((Object)clazz)).put("password", this.connectionPassword);
        }
        this.dbConnection = this.driver.connect(this.connectionURL, (Properties)((Object)clazz));
        this.dbConnection.setAutoCommit(true);
        return this.dbConnection;
    }

    protected void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            this.preparedSizeSql.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.preparedSizeSql = null;
        try {
            this.preparedSaveSql.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.preparedSaveSql = null;
        try {
            this.preparedClearSql.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        try {
            this.preparedRemoveSql.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.preparedRemoveSql = null;
        try {
            this.preparedLoadSql.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.preparedLoadSql = null;
        try {
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".commitSQLException"), (Throwable)sQLException);
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.manager.getContainer().getLogger().error((Object)sm.getString(this.getStoreName() + ".close", new Object[]{sQLException.toString()}));
        }
        finally {
            this.dbConnection = null;
        }
    }

    protected void release(Connection connection) {
        if (this.dataSource != null) {
            this.close(connection);
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (this.dataSourceName == null) {
            this.dbConnection = this.getConnection();
        }
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (this.dbConnection != null) {
            try {
                this.dbConnection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.close(this.dbConnection);
        }
    }
}

