/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.XMultiPropertySet;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XMacroExpander;
import com.sun.star.wizards.common.PropertySetHelper;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Date;

public class Helper {
    public static long convertUnoDatetoInteger(com.sun.star.util.Date DateValue) {
        Calendar oCal = Calendar.getInstance();
        oCal.set(DateValue.Year, DateValue.Month, DateValue.Day);
        Date dTime = oCal.getTime();
        long lTime = dTime.getTime();
        return lTime / 86400000L;
    }

    public static void setUnoPropertyValue(Object oUnoObject, String PropertyName, Object PropertyValue2) {
        try {
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oUnoObject);
            if (!xPSet.getPropertySetInfo().hasPropertyByName(PropertyName)) {
                throw new IllegalArgumentException("No Such Property: '" + PropertyName + "'");
            }
            xPSet.setPropertyValue(PropertyName, PropertyValue2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static Object getUnoObjectbyName(Object oUnoObject, String ElementName) {
        try {
            XNameAccess xName = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oUnoObject);
            if (xName.hasByName(ElementName)) {
                return xName.getByName(ElementName);
            }
            throw new RuntimeException();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static Object getUnoPropertyValue(Object oUnoObject, String PropertyName, Class<?> xClass) {
        try {
            if (oUnoObject != null) {
                XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oUnoObject);
                Object oObject = xPSet.getPropertyValue(PropertyName);
                if (AnyConverter.isVoid((Object)oObject)) {
                    return null;
                }
                return AnyConverter.toObject((Type)new Type(xClass), (Object)oObject);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static Object getUnoPropertyValue(Object oUnoObject, String PropertyName) {
        try {
            if (oUnoObject != null) {
                XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oUnoObject);
                return xPSet.getPropertyValue(PropertyName);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    public static Object getUnoArrayPropertyValue(Object oUnoObject, String PropertyName) {
        try {
            XPropertySet xPSet;
            Object oObject;
            if (oUnoObject != null && AnyConverter.isArray((Object)(oObject = (xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oUnoObject)).getPropertyValue(PropertyName)))) {
                return Helper.getArrayValue(oObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    public static Object getUnoStructValue(Object oUnoObject, String PropertyName) {
        try {
            XPropertySet xPSet;
            if (oUnoObject != null && (xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oUnoObject)).getPropertySetInfo().hasPropertyByName(PropertyName)) {
                return xPSet.getPropertyValue(PropertyName);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static void setUnoPropertyValues(Object oUnoObject, String[] PropertyNames2, Object[] PropertyValues) {
        try {
            XMultiPropertySet xMultiPSetLst = (XMultiPropertySet)UnoRuntime.queryInterface(XMultiPropertySet.class, (Object)oUnoObject);
            if (xMultiPSetLst != null) {
                xMultiPSetLst.setPropertyValues(PropertyNames2, PropertyValues);
            } else {
                for (int i = 0; i < PropertyNames2.length; ++i) {
                    Helper.setUnoPropertyValue(oUnoObject, PropertyNames2[i], PropertyValues[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private static Object getArrayValue(Object oValue) {
        try {
            Object oPropList = AnyConverter.toArray((Object)oValue);
            int nlen = Array.getLength(oPropList);
            if (nlen == 0) {
                return null;
            }
            return oPropList;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static XComponentContext getComponentContext(XMultiServiceFactory _xMSF) {
        XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)_xMSF);
        PropertySetHelper aHelper = new PropertySetHelper(xProps);
        Object aDefaultContext = aHelper.getPropertyValueAsObject("DefaultContext");
        return (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)aDefaultContext);
    }

    public static XMacroExpander getMacroExpander(XMultiServiceFactory _xMSF) {
        XComponentContext xComponentContext = Helper.getComponentContext(_xMSF);
        Object aSingleton = xComponentContext.getValueByName("/singletons/com.sun.star.util.theMacroExpander");
        return (XMacroExpander)UnoRuntime.queryInterface(XMacroExpander.class, (Object)aSingleton);
    }
}

