/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;

public abstract class FailableCache<K, V> {
    private final LoadingCache<K, Object> delegate = CacheBuilder.newBuilder().build(new CacheLoader<K, Object>(){

        @Override
        public Object load(K key2) {
            Errors errors = new Errors();
            Object result = null;
            try {
                result = FailableCache.this.create(key2, errors);
            }
            catch (ErrorsException e2) {
                errors.merge(e2.getErrors());
            }
            return errors.hasErrors() ? errors : result;
        }
    });

    protected abstract V create(K var1, Errors var2) throws ErrorsException;

    public V get(K key2, Errors errors) throws ErrorsException {
        Object resultOrError = this.delegate.getUnchecked(key2);
        if (resultOrError instanceof Errors) {
            errors.merge((Errors)resultOrError);
            throw errors.toException();
        }
        Object result = resultOrError;
        return (V)result;
    }

    boolean remove(K key2) {
        return this.delegate.asMap().remove(key2) != null;
    }
}

