/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine;

import java.io.IOException;
import org.apache.commons.jcs3.engine.behavior.ICache;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheListener;

public class CacheAdaptor<K, V>
implements ICacheListener<K, V> {
    private final ICache<K, V> cache;
    private long listenerId = 0L;

    @Override
    public void setListenerId(long id) throws IOException {
        this.listenerId = id;
    }

    @Override
    public long getListenerId() throws IOException {
        return this.listenerId;
    }

    public CacheAdaptor(ICache<K, V> cache) {
        this.cache = cache;
    }

    @Override
    public void handlePut(ICacheElement<K, V> item) throws IOException {
        try {
            this.cache.update(item);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void handleRemove(String cacheName, K key) throws IOException {
        this.cache.remove(key);
    }

    @Override
    public void handleRemoveAll(String cacheName) throws IOException {
        this.cache.removeAll();
    }

    @Override
    public void handleDispose(String cacheName) throws IOException {
        this.cache.dispose();
    }
}

