/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.VersionTableColumnModel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class VersionTable
extends JTable
implements ChangeListener,
Destroyable {
    private VersionTablePopupMenu popupMenu;
    private final transient HistoryBrowserModel model;

    public VersionTable(HistoryBrowserModel model) {
        super(model.getVersionTableModel(), new VersionTableColumnModel());
        model.addChangeListener(this);
        this.build();
        this.model = model;
    }

    protected void build() {
        this.getTableHeader().setFont(this.getTableHeader().getFont().deriveFont(9.0f));
        this.setRowSelectionAllowed(false);
        this.setShowGrid(false);
        this.setAutoResizeMode(0);
        TableHelper.setFont(this, this.getClass());
        GuiHelper.setBackgroundReadable(this, UIManager.getColor("Button.background"));
        this.setIntercellSpacing(new Dimension(6, 0));
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.popupMenu = new VersionTablePopupMenu();
        this.addMouseListener(new MouseListener());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                long ref = VersionTable.this.model.getReferencePointInTime().getVersion();
                long cur = VersionTable.this.model.getCurrentPointInTime().getVersion();
                if (e.getKeyCode() == 40) {
                    History refNext = VersionTable.this.model.getHistory().from(ref);
                    History curNext = VersionTable.this.model.getHistory().from(cur);
                    if (refNext.getNumVersions() > 1 && curNext.getNumVersions() > 1) {
                        VersionTable.this.model.setReferencePointInTime(refNext.sortAscending().get(1));
                        VersionTable.this.model.setCurrentPointInTime(curNext.sortAscending().get(1));
                    }
                } else if (e.getKeyCode() == 38) {
                    History refNext = VersionTable.this.model.getHistory().until(ref);
                    History curNext = VersionTable.this.model.getHistory().until(cur);
                    if (refNext.getNumVersions() > 1 && curNext.getNumVersions() > 1) {
                        VersionTable.this.model.setReferencePointInTime(refNext.sortDescending().get(1));
                        VersionTable.this.model.setCurrentPointInTime(curNext.sortDescending().get(1));
                    }
                }
            }
        });
        this.getModel().addTableModelListener(e -> IntStream.range(0, this.model.getHistory().getNumVersions()).filter(this.model::isCurrentPointInTime).findFirst().ifPresent(row -> this.scrollRectToVisible(this.getCellRect(row, 0, true))));
        this.getModel().addTableModelListener(e -> {
            VersionTable.adjustColumnWidth(this, 0, 0);
            VersionTable.adjustColumnWidth(this, 1, -8);
            VersionTable.adjustColumnWidth(this, 2, -8);
            VersionTable.adjustColumnWidth(this, 3, 0);
            VersionTable.adjustColumnWidth(this, 4, 0);
            VersionTable.adjustColumnWidth(this, 5, 0);
        });
    }

    @Override
    public void destroy() {
        this.popupMenu.destroy();
    }

    @Override
    public void scrollRectToVisible(Rectangle aRect) {
        super.scrollRectToVisible(new Rectangle(0, aRect.y, aRect.width, aRect.height));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    private static void adjustColumnWidth(JTable tbl, int col, int cellInset) {
        int maxwidth = 0;
        for (int row = 0; row < tbl.getRowCount(); ++row) {
            TableCellRenderer tcr = tbl.getCellRenderer(row, col);
            Object val = tbl.getValueAt(row, col);
            Component comp = tcr.getTableCellRendererComponent(tbl, val, false, false, row, col);
            maxwidth = Math.max(comp.getPreferredSize().width + cellInset, maxwidth);
        }
        TableCellRenderer tcr = tbl.getTableHeader().getDefaultRenderer();
        Object val = tbl.getColumnModel().getColumn(col).getHeaderValue();
        Component comp = tcr.getTableCellRendererComponent(tbl, val, false, false, -1, col);
        maxwidth = Math.max(comp.getPreferredSize().width + Config.getPref().getInt("table.header-inset", 0), maxwidth);
        int spacing = tbl.getIntercellSpacing().width;
        tbl.getColumnModel().getColumn(col).setPreferredWidth(maxwidth + spacing);
    }

    public static class AlignedRenderer
    extends JLabel
    implements TableCellRenderer {
        public AlignedRenderer(int hAlignment) {
            this.setHorizontalAlignment(hAlignment);
        }

        AlignedRenderer() {
            this(10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String v = "";
            if (value != null) {
                v = value.toString();
            }
            this.setText(v);
            return this;
        }
    }

    public static class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        private final JRadioButton btn = new JRadioButton();

        public RadioButtonEditor() {
            super(new JCheckBox());
            this.btn.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            boolean val = (Boolean)value;
            this.btn.setSelected(val);
            this.btn.addItemListener(this);
            return this.btn;
        }

        @Override
        public Object getCellEditorValue() {
            this.btn.removeItemListener(this);
            return this.btn.isSelected();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.fireEditingStopped();
        }
    }

    public static class RadioButtonRenderer
    extends JRadioButton
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value != null && (Boolean)value != false);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    static class VersionTablePopupMenu
    extends JPopupMenu
    implements Destroyable {
        private ChangesetInfoAction changesetInfoAction;
        private UserInfoAction userInfoAction;

        VersionTablePopupMenu() {
            this.build();
        }

        protected void build() {
            this.changesetInfoAction = new ChangesetInfoAction();
            this.add(this.changesetInfoAction);
            this.userInfoAction = new UserInfoAction();
            this.add(this.userInfoAction);
        }

        public void prepare(HistoryOsmPrimitive primitive) {
            this.changesetInfoAction.prepare(primitive);
            this.userInfoAction.prepare(primitive);
            this.invalidate();
        }

        @Override
        public void destroy() {
            if (this.changesetInfoAction != null) {
                this.changesetInfoAction.destroy();
                this.changesetInfoAction = null;
            }
            if (this.userInfoAction != null) {
                this.userInfoAction.destroy();
                this.userInfoAction = null;
            }
        }
    }

    static class UserInfoAction
    extends AbstractInfoAction {
        private transient HistoryOsmPrimitive primitive;

        UserInfoAction() {
            super(true);
            this.putValue("Name", I18n.tr("User info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launch browser with information about the user", new Object[0]));
            new ImageProvider("data/user").getResource().attachImageIcon(this, true);
        }

        @Override
        protected String createInfoUrl(Object infoObject) {
            if (infoObject instanceof HistoryOsmPrimitive) {
                HistoryOsmPrimitive hp = (HistoryOsmPrimitive)infoObject;
                return hp.getUser() == null ? null : Config.getUrls().getBaseUserUrl() + '/' + hp.getUser().getName();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            String url = this.createInfoUrl(this.primitive);
            OpenBrowser.displayUrl(url);
        }

        public void prepare(HistoryOsmPrimitive primitive) {
            User user = primitive.getUser();
            this.putValue("Name", "<html>" + I18n.tr("Show user {0}", user == null ? "?" : XmlWriter.encode(user.getName(), true) + " <font color=gray>(" + user.getId() + ")</font>") + "</html>");
            this.primitive = primitive;
        }
    }

    static class ChangesetInfoAction
    extends AbstractInfoAction {
        private transient HistoryOsmPrimitive primitive;

        ChangesetInfoAction() {
            super(true);
            this.putValue("Name", I18n.tr("Changeset info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launch browser with information about the changeset", new Object[0]));
            new ImageProvider("help/internet").getResource().attachImageIcon(this, true);
        }

        @Override
        protected String createInfoUrl(Object infoObject) {
            if (infoObject instanceof HistoryOsmPrimitive) {
                HistoryOsmPrimitive prim = (HistoryOsmPrimitive)infoObject;
                return Config.getUrls().getBaseBrowseUrl() + "/changeset/" + prim.getChangesetId();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            String url = this.createInfoUrl(this.primitive);
            OpenBrowser.displayUrl(url);
        }

        public void prepare(HistoryOsmPrimitive primitive) {
            this.putValue("Name", I18n.tr("Show changeset {0}", primitive.getChangesetId()));
            this.primitive = primitive;
        }
    }

    final class MouseListener
    extends PopupMenuLauncher {
        private MouseListener() {
            super(Objects.requireNonNull(VersionTable.this.popupMenu));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (!e.isPopupTrigger() && e.getButton() == 1) {
                int row = VersionTable.this.rowAtPoint(e.getPoint());
                int col = VersionTable.this.columnAtPoint(e.getPoint());
                if (row >= 0 && (col == 3 || col == 4)) {
                    VersionTable.this.model.setCurrentPointInTime(row);
                    VersionTable.this.model.setReferencePointInTime(Math.max(0, row - 1));
                }
            }
        }

        @Override
        protected int checkTableSelection(JTable table, Point p) {
            int row = VersionTable.this.rowAtPoint(p);
            if (row > -1 && !VersionTable.this.model.isLatest(row)) {
                VersionTable.this.popupMenu.prepare(VersionTable.this.model.getPrimitive(row));
            }
            return row;
        }
    }
}

