/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.date;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.UncheckedParseException;

public final class DateUtils {
    public static final TimeZone UTC = TimeZone.getTimeZone(ZoneOffset.UTC);
    public static final BooleanProperty PROP_ISO_DATES = new BooleanProperty("iso.dates", false);

    private DateUtils() {
    }

    public static Date fromString(String str) {
        return new Date(DateUtils.tsFromString(str));
    }

    public static long tsFromString(String str) {
        return DateUtils.parseInstant(str).toEpochMilli();
    }

    public static Instant parseInstant(String str) {
        if (DateUtils.checkLayout(str, "xxxx-xx-xx") || DateUtils.checkLayout(str, "xxxx-xx") || DateUtils.checkLayout(str, "xxxx")) {
            ZonedDateTime local = ZonedDateTime.of(DateUtils.parsePart4(str, 0), str.length() > 5 ? DateUtils.parsePart2(str, 5) : 1, str.length() > 8 ? DateUtils.parsePart2(str, 8) : 1, 0, 0, 0, 0, ZoneOffset.UTC);
            return local.toInstant();
        }
        if (DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xxZ") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx") || DateUtils.checkLayout(str, "xxxx:xx:xx xx:xx:xx") || DateUtils.checkLayout(str, "xxxx-xx-xx xx:xx:xxZ") || DateUtils.checkLayout(str, "xxxx-xx-xx xx:xx:xx UTC") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx+xx") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx-xx") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx+xx:00") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx-xx:00")) {
            ZonedDateTime local = ZonedDateTime.of(DateUtils.parsePart4(str, 0), DateUtils.parsePart2(str, 5), DateUtils.parsePart2(str, 8), DateUtils.parsePart2(str, 11), DateUtils.parsePart2(str, 14), DateUtils.parsePart2(str, 17), 0, ZoneOffset.UTC);
            if (str.length() == 22 || str.length() == 25) {
                int plusHr = DateUtils.parsePart2(str, 20);
                return local.plusHours(str.charAt(19) == '+' ? (long)(-plusHr) : (long)plusHr).toInstant();
            }
            return local.toInstant();
        }
        if (DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx.xxxZ") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx.xxx") || DateUtils.checkLayout(str, "xxxx:xx:xx xx:xx:xx.xxx") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx.xxx+xx:00") || DateUtils.checkLayout(str, "xxxx-xx-xxTxx:xx:xx.xxx-xx:00")) {
            ZonedDateTime local = ZonedDateTime.of(DateUtils.parsePart4(str, 0), DateUtils.parsePart2(str, 5), DateUtils.parsePart2(str, 8), DateUtils.parsePart2(str, 11), DateUtils.parsePart2(str, 14), DateUtils.parsePart2(str, 17), DateUtils.parsePart3(str, 20) * 1000000, ZoneOffset.UTC);
            if (str.length() == 29) {
                int plusHr = DateUtils.parsePart2(str, 24);
                return local.plusHours(str.charAt(23) == '+' ? (long)(-plusHr) : (long)plusHr).toInstant();
            }
            return local.toInstant();
        }
        SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yy HH:mm:ss");
        Date d = f.parse(str, new ParsePosition(0));
        if (d != null) {
            return d.toInstant();
        }
        try {
            return ZonedDateTime.parse(str).toInstant();
        }
        catch (IllegalArgumentException | DateTimeParseException ex) {
            throw new UncheckedParseException("The date string (" + str + ") could not be parsed.", ex);
        }
    }

    public static String fromTimestamp(long timestamp) {
        return DateUtils.fromTimestampInMillis(TimeUnit.SECONDS.toMillis(timestamp));
    }

    public static String fromTimestampInMillis(long timestamp) {
        ZonedDateTime temporal = Instant.ofEpochMilli(timestamp).atZone(ZoneOffset.UTC);
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(temporal);
    }

    public static String fromTimestamp(int timestamp) {
        return DateUtils.fromTimestamp(Integer.toUnsignedLong(timestamp));
    }

    public static String fromDate(Date date) {
        ZonedDateTime temporal = date.toInstant().atZone(ZoneOffset.UTC);
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(temporal);
    }

    public static Date cloneDate(Date d) {
        return d != null ? (Date)d.clone() : null;
    }

    private static boolean checkLayout(String text, String pattern) {
        if (text.length() != pattern.length()) {
            return false;
        }
        for (int i = 0; i < pattern.length(); ++i) {
            char pc = pattern.charAt(i);
            char tc = text.charAt(i);
            if (pc == 'x' && Character.isDigit(tc) || pc != 'x' && pc == tc) continue;
            return false;
        }
        return true;
    }

    private static int num(char c) {
        return c - 48;
    }

    private static int parsePart2(String str, int off) {
        return 10 * DateUtils.num(str.charAt(off)) + DateUtils.num(str.charAt(off + 1));
    }

    private static int parsePart3(String str, int off) {
        return 100 * DateUtils.num(str.charAt(off)) + 10 * DateUtils.num(str.charAt(off + 1)) + DateUtils.num(str.charAt(off + 2));
    }

    private static int parsePart4(String str, int off) {
        return 1000 * DateUtils.num(str.charAt(off)) + 100 * DateUtils.num(str.charAt(off + 1)) + 10 * DateUtils.num(str.charAt(off + 2)) + DateUtils.num(str.charAt(off + 3));
    }

    public static SimpleDateFormat newIsoDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static SimpleDateFormat newIsoDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    }

    public static SimpleDateFormat newOsmApiDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);
    }

    public static DateFormat getDateFormat(int dateStyle) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return DateUtils.newIsoDateFormat();
        }
        return DateFormat.getDateInstance(dateStyle, Locale.getDefault());
    }

    public static DateTimeFormatter getDateFormatter(FormatStyle dateStyle) {
        DateTimeFormatter formatter = PROP_ISO_DATES.get() != false ? DateTimeFormatter.ISO_LOCAL_DATE : DateTimeFormatter.ofLocalizedDate(dateStyle);
        return formatter.withZone(ZoneId.systemDefault());
    }

    @Deprecated
    public static DateFormat getGpxFormat() {
        SimpleDateFormat result = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        result.setTimeZone(UTC);
        return result;
    }

    public static String formatDate(Date date, int dateStyle) {
        CheckParameterUtil.ensureParameterNotNull(date, "date");
        return DateUtils.getDateFormat(dateStyle).format(date);
    }

    public static DateFormat getTimeFormat(int timeStyle) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return new SimpleDateFormat("HH:mm:ss");
        }
        return DateFormat.getTimeInstance(timeStyle, Locale.getDefault());
    }

    public static DateTimeFormatter getTimeFormatter(FormatStyle timeStyle) {
        DateTimeFormatter formatter = PROP_ISO_DATES.get() != false ? DateTimeFormatter.ISO_LOCAL_TIME : DateTimeFormatter.ofLocalizedTime(timeStyle);
        return formatter.withZone(ZoneId.systemDefault());
    }

    public static String formatTime(Date time, int timeStyle) {
        CheckParameterUtil.ensureParameterNotNull(time, "time");
        return DateUtils.getTimeFormat(timeStyle).format(time);
    }

    public static DateFormat getDateTimeFormat(int dateStyle, int timeStyle) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.getDefault());
    }

    public static DateTimeFormatter getDateTimeFormatter(FormatStyle dateStyle, FormatStyle timeStyle) {
        DateTimeFormatter formatter = PROP_ISO_DATES.get() != false ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : DateTimeFormatter.ofLocalizedDateTime(dateStyle, timeStyle);
        return formatter.withZone(ZoneId.systemDefault());
    }

    public static String formatDateTime(Date datetime, int dateStyle, int timeStyle) {
        CheckParameterUtil.ensureParameterNotNull(datetime, "datetime");
        return DateUtils.getDateTimeFormat(dateStyle, timeStyle).format(datetime);
    }
}

