/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalOutputBuffer
extends AbstractOutputBuffer<Socket>
implements ByteChunk.ByteOutputChannel {
    protected OutputStream outputStream;
    private ByteChunk socketBuffer;
    private boolean useSocketBuffer = false;

    public InternalOutputBuffer(Response response, int n) {
        this.response = response;
        this.buf = new byte[n];
        this.outputStreamOutputBuffer = new OutputStreamOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.socketBuffer = new ByteChunk();
        this.socketBuffer.setByteOutputChannel(this);
        this.committed = false;
        this.finished = false;
    }

    public void setSocketBuffer(int n) {
        if (n > 500) {
            this.useSocketBuffer = true;
            this.socketBuffer.allocate(n, n);
        } else {
            this.useSocketBuffer = false;
        }
    }

    @Override
    public void init(SocketWrapper<Socket> socketWrapper, AbstractEndpoint<Socket> abstractEndpoint) throws IOException {
        this.outputStream = socketWrapper.getSocket().getOutputStream();
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.useSocketBuffer) {
            this.socketBuffer.flushBuffer();
        }
    }

    @Override
    public void recycle() {
        super.recycle();
        this.outputStream = null;
    }

    @Override
    public void nextRequest() {
        super.nextRequest();
        this.socketBuffer.recycle();
    }

    @Override
    public void endRequest() throws IOException {
        super.endRequest();
        if (this.useSocketBuffer) {
            this.socketBuffer.flushBuffer();
        }
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed) {
            this.outputStream.write(Constants.ACK_BYTES);
        }
    }

    @Override
    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            if (this.useSocketBuffer) {
                this.socketBuffer.append(this.buf, 0, this.pos);
            } else {
                this.outputStream.write(this.buf, 0, this.pos);
            }
        }
    }

    @Override
    public void realWriteBytes(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            this.outputStream.write(byArray, n, n2);
        }
    }

    protected class OutputStreamOutputBuffer
    implements OutputBuffer {
        protected OutputStreamOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk byteChunk, Response response) throws IOException {
            try {
                int n = byteChunk.getLength();
                if (InternalOutputBuffer.this.useSocketBuffer) {
                    InternalOutputBuffer.this.socketBuffer.append(byteChunk.getBuffer(), byteChunk.getStart(), n);
                } else {
                    InternalOutputBuffer.this.outputStream.write(byteChunk.getBuffer(), byteChunk.getStart(), n);
                }
                InternalOutputBuffer.this.byteCount += (long)byteChunk.getLength();
                return byteChunk.getLength();
            }
            catch (IOException iOException) {
                InternalOutputBuffer.this.response.action(ActionCode.CLOSE_NOW, iOException);
                throw iOException;
            }
        }

        @Override
        public long getBytesWritten() {
            return InternalOutputBuffer.this.byteCount;
        }
    }
}

