/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.RedirectorElement;

public abstract class BaseRedirectorHelperTask
extends Task {
    protected Redirector redirector = new Redirector((Task)this);
    protected RedirectorElement redirectorElement = null;
    protected OutputStream redirectOutStream = null;
    protected OutputStream redirectErrStream = null;
    PrintStream redirectOutPrintStream = null;
    PrintStream redirectErrPrintStream = null;
    protected boolean failOnError = true;
    protected boolean redirectOutput = false;
    protected boolean redirectorConfigured = false;
    protected boolean alwaysLog = false;

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setOutput(File file) {
        this.redirector.setOutput(file);
        this.redirectOutput = true;
    }

    public void setError(File file) {
        this.redirector.setError(file);
        this.redirectOutput = true;
    }

    public void setLogError(boolean bl) {
        this.redirector.setLogError(bl);
        this.redirectOutput = true;
    }

    public void setOutputproperty(String string) {
        this.redirector.setOutputProperty(string);
        this.redirectOutput = true;
    }

    public void setErrorProperty(String string) {
        this.redirector.setErrorProperty(string);
        this.redirectOutput = true;
    }

    public void setAppend(boolean bl) {
        this.redirector.setAppend(bl);
        this.redirectOutput = true;
    }

    public void setAlwaysLog(boolean bl) {
        this.alwaysLog = bl;
        this.redirectOutput = true;
    }

    public void setCreateEmptyFiles(boolean bl) {
        this.redirector.setCreateEmptyFiles(bl);
        this.redirectOutput = true;
    }

    public void addConfiguredRedirector(RedirectorElement redirectorElement) {
        if (this.redirectorElement != null) {
            throw new BuildException("Cannot have > 1 nested <redirector>s");
        }
        this.redirectorElement = redirectorElement;
    }

    private void configureRedirector() {
        if (this.redirectorElement != null) {
            this.redirectorElement.configure(this.redirector);
            this.redirectOutput = true;
        }
        this.redirectorConfigured = true;
    }

    protected void openRedirector() {
        if (!this.redirectorConfigured) {
            this.configureRedirector();
        }
        if (this.redirectOutput) {
            this.redirector.createStreams();
            this.redirectOutStream = this.redirector.getOutputStream();
            this.redirectOutPrintStream = new PrintStream(this.redirectOutStream);
            this.redirectErrStream = this.redirector.getErrorStream();
            this.redirectErrPrintStream = new PrintStream(this.redirectErrStream);
        }
    }

    protected void closeRedirector() {
        try {
            if (this.redirectOutput && this.redirectOutPrintStream != null) {
                this.redirector.complete();
            }
        }
        catch (IOException iOException) {
            this.log("Error closing redirector: " + iOException.getMessage(), 0);
        }
        this.redirectOutStream = null;
        this.redirectOutPrintStream = null;
        this.redirectErrStream = null;
        this.redirectErrPrintStream = null;
    }

    protected void handleOutput(String string) {
        if (this.redirectOutput) {
            if (this.redirectOutPrintStream == null) {
                this.openRedirector();
            }
            this.redirectOutPrintStream.println(string);
            if (this.alwaysLog) {
                this.log(string, 2);
            }
        } else {
            this.log(string, 2);
        }
    }

    protected void handleFlush(String string) {
        this.handleOutput(string);
        this.redirectOutPrintStream.flush();
    }

    protected void handleErrorOutput(String string) {
        if (this.redirectOutput) {
            if (this.redirectErrPrintStream == null) {
                this.openRedirector();
            }
            this.redirectErrPrintStream.println(string);
            if (this.alwaysLog) {
                this.log(string, 0);
            }
        } else {
            this.log(string, 0);
        }
    }

    protected void handleErrorFlush(String string) {
        this.handleErrorOutput(string);
        this.redirectErrPrintStream.flush();
    }

    protected void handleOutput(String string, int n) {
        if (n == 0) {
            this.handleErrorOutput(string);
        } else {
            this.handleOutput(string);
        }
    }
}

