/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.tomcat.dbcp.dbcp.DelegatingCallableStatement;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.DelegatingStatement;
import org.apache.tomcat.dbcp.pool.ObjectPool;

public class PoolingDataSource<C extends Connection>
implements DataSource {
    private boolean accessToUnderlyingConnectionAllowed = false;
    protected PrintWriter _logWriter = null;
    protected ObjectPool<C> _pool = null;

    public PoolingDataSource() {
        this(null);
    }

    public PoolingDataSource(ObjectPool<C> objectPool) {
        this._pool = objectPool;
    }

    public void setPool(ObjectPool<C> objectPool) throws IllegalStateException, NullPointerException {
        if (null != this._pool) {
            throw new IllegalStateException("Pool already set");
        }
        if (null == objectPool) {
            throw new NullPointerException("Pool must not be null.");
        }
        this._pool = objectPool;
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException("PoolingDataSource is not a wrapper.");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Connection connection = (Connection)this._pool.borrowObject();
            if (connection != null) {
                connection = new PoolGuardConnectionWrapper(connection);
            }
            return connection;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Cannot get a connection, pool error " + noSuchElementException.getMessage(), noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Cannot get a connection, general error", exception);
        }
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    @Override
    public int getLoginTimeout() {
        throw new UnsupportedOperationException("Login timeout is not supported.");
    }

    @Override
    public void setLoginTimeout(int n) {
        throw new UnsupportedOperationException("Login timeout is not supported.");
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }

    private class PoolGuardConnectionWrapper
    extends DelegatingConnection {
        private Connection delegate;

        PoolGuardConnectionWrapper(Connection connection) {
            super(connection);
            this.delegate = connection;
        }

        @Override
        protected void checkOpen() throws SQLException {
            if (this.delegate == null) {
                throw new SQLException("Connection is closed.");
            }
        }

        @Override
        public void close() throws SQLException {
            if (this.delegate != null) {
                this.delegate.close();
                this.delegate = null;
                super.setDelegate(null);
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            if (this.delegate == null) {
                return true;
            }
            return this.delegate.isClosed();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.checkOpen();
            this.delegate.clearWarnings();
        }

        @Override
        public void commit() throws SQLException {
            this.checkOpen();
            this.delegate.commit();
        }

        @Override
        public Statement createStatement() throws SQLException {
            this.checkOpen();
            return new DelegatingStatement(this, this.delegate.createStatement());
        }

        @Override
        public Statement createStatement(int n, int n2) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement(this, this.delegate.createStatement(n, n2));
        }

        @Override
        public boolean innermostDelegateEquals(Connection connection) {
            Connection connection2 = super.getInnermostDelegate();
            if (connection2 == null) {
                return connection == null;
            }
            return connection2.equals(connection);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            this.checkOpen();
            return this.delegate.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            this.checkOpen();
            return this.delegate.getCatalog();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            this.checkOpen();
            return this.delegate.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            this.checkOpen();
            return this.delegate.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            this.checkOpen();
            return this.delegate.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            this.checkOpen();
            return this.delegate.getWarnings();
        }

        @Override
        public int hashCode() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            Connection connection = super.getInnermostDelegate();
            if (connection == null) {
                return false;
            }
            if (object instanceof DelegatingConnection) {
                DelegatingConnection delegatingConnection = (DelegatingConnection)object;
                return delegatingConnection.innermostDelegateEquals(connection);
            }
            return connection.equals(object);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            this.checkOpen();
            return this.delegate.isReadOnly();
        }

        @Override
        public String nativeSQL(String string) throws SQLException {
            this.checkOpen();
            return this.delegate.nativeSQL(string);
        }

        @Override
        public CallableStatement prepareCall(String string) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(string));
        }

        @Override
        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(string, n, n2));
        }

        @Override
        public PreparedStatement prepareStatement(String string) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string));
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, n, n2));
        }

        @Override
        public void rollback() throws SQLException {
            this.checkOpen();
            this.delegate.rollback();
        }

        @Override
        public void setAutoCommit(boolean bl) throws SQLException {
            this.checkOpen();
            this.delegate.setAutoCommit(bl);
        }

        @Override
        public void setCatalog(String string) throws SQLException {
            this.checkOpen();
            this.delegate.setCatalog(string);
        }

        @Override
        public void setReadOnly(boolean bl) throws SQLException {
            this.checkOpen();
            this.delegate.setReadOnly(bl);
        }

        @Override
        public void setTransactionIsolation(int n) throws SQLException {
            this.checkOpen();
            this.delegate.setTransactionIsolation(n);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.checkOpen();
            this.delegate.setTypeMap(map);
        }

        @Override
        public String toString() {
            if (this.delegate == null) {
                return "NULL";
            }
            return this.delegate.toString();
        }

        @Override
        public int getHoldability() throws SQLException {
            this.checkOpen();
            return this.delegate.getHoldability();
        }

        @Override
        public void setHoldability(int n) throws SQLException {
            this.checkOpen();
            this.delegate.setHoldability(n);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            this.checkOpen();
            return this.delegate.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String string) throws SQLException {
            this.checkOpen();
            return this.delegate.setSavepoint(string);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this.delegate.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this.delegate.rollback(savepoint);
        }

        @Override
        public Statement createStatement(int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement(this, this.delegate.createStatement(n, n2, n3));
        }

        @Override
        public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(string, n, n2, n3));
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, n));
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, n, n2, n3));
        }

        @Override
        public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, nArray));
        }

        @Override
        public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, stringArray));
        }

        @Override
        public Connection getDelegate() {
            if (PoolingDataSource.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getDelegate();
            }
            return null;
        }

        @Override
        public Connection getInnermostDelegate() {
            if (PoolingDataSource.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }
    }
}

