/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.data.persistence;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.data.persistence.OsmWindowLocationStorage;

@XmlRootElement
public class ComponentLocationStorage {
    private int x;
    private int y;
    private int width;
    private int height;

    public static String marshall(ComponentLocationStorage pStorage) {
        Class[] classes = ComponentLocationStorage.getClasses();
        return OsmWindow.marshall(pStorage, classes);
    }

    static Class[] getClasses() {
        return new Class[]{ComponentLocationStorage.class, OsmWindowLocationStorage.class};
    }

    public static ComponentLocationStorage unmarshall(String pInput) {
        return (ComponentLocationStorage)OsmWindow.unmarshall(pInput, ComponentLocationStorage.getClasses());
    }

    public static void main(String[] args) {
        ComponentLocationStorage st = new ComponentLocationStorage();
        st.x = 17;
        st.height = 100;
        String erg = ComponentLocationStorage.marshall(st);
        System.out.println(erg);
        ComponentLocationStorage storage = ComponentLocationStorage.unmarshall(erg);
        System.out.println(storage.height);
        OsmWindowLocationStorage os = new OsmWindowLocationStorage();
        os.setSplitLocation(12);
        os.setHeight(18);
        String res2 = ComponentLocationStorage.marshall(os);
        System.out.println(res2);
        ComponentLocationStorage.unmarshall(res2);
    }

    @XmlElement
    public int getX() {
        return this.x;
    }

    public void setX(int pX) {
        this.x = pX;
    }

    @XmlElement
    public int getY() {
        return this.y;
    }

    public void setY(int pY) {
        this.y = pY;
    }

    @XmlElement
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int pWidth) {
        this.width = pWidth;
    }

    @XmlElement
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int pHeight) {
        this.height = pHeight;
    }

    public static void storeDialogPositions(OsmWindow controller, Window dialog, ComponentLocationStorage storage, String window_preference_storage_property) {
        String result = ComponentLocationStorage.storeDialogPositions(storage, dialog);
        controller.getOffroadProperties().put(window_preference_storage_property, result);
    }

    protected static String storeDialogPositions(ComponentLocationStorage storage, Window dialog) {
        String marshalled;
        storage.setX(dialog.getX());
        storage.setY(dialog.getY());
        storage.setWidth(dialog.getWidth());
        storage.setHeight(dialog.getHeight());
        String result = marshalled = ComponentLocationStorage.marshall(storage);
        return result;
    }

    public static ComponentLocationStorage decorateDialog(OsmWindow controller, Window dialog, String window_preference_storage_property) {
        String marshalled = controller.getOffroadProperties().getProperty(window_preference_storage_property);
        ComponentLocationStorage result = ComponentLocationStorage.decorateDialog(marshalled, dialog);
        return result;
    }

    public static ComponentLocationStorage decorateDialog(String marshalled, Window dialog) {
        ComponentLocationStorage storage;
        if (marshalled != null && (storage = ComponentLocationStorage.unmarshall(marshalled)) != null) {
            Dimension screenSize;
            if ("false".equals("place_dialogs_on_first_screen")) {
                Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
                screenSize = defaultToolkit.getScreenSize();
            } else {
                screenSize = new Dimension();
                screenSize.height = Integer.MAX_VALUE;
                screenSize.width = Integer.MAX_VALUE;
            }
            int delta = 20;
            dialog.setLocation(Math.min(storage.getX(), screenSize.width - delta), Math.min(storage.getY(), screenSize.height - delta));
            dialog.setSize(new Dimension(storage.getWidth(), storage.getHeight()));
            return storage;
        }
        Frame rootFrame = JOptionPane.getFrameForComponent(dialog);
        Dimension prefSize = rootFrame.getSize();
        prefSize.width = prefSize.width * 3 / 4;
        prefSize.height = prefSize.height * 3 / 4;
        dialog.setSize(prefSize);
        return null;
    }
}

