/*
 * Decompiled with CFR 0.152.
 */
package ext.plantuml.com.at.gadermaier.argon2.algorithm;

import ext.plantuml.com.at.gadermaier.argon2.Argon2;
import ext.plantuml.com.at.gadermaier.argon2.algorithm.Functions;
import ext.plantuml.com.at.gadermaier.argon2.model.Block;
import ext.plantuml.com.at.gadermaier.argon2.model.Instance;

public class Finalize {
    public static void finalize(Instance instance, Argon2 argon2) {
        Block finalBlock = instance.memory[instance.getLaneLength() - 1];
        for (int i = 1; i < instance.getLanes(); ++i) {
            int lastBlockInLane = i * instance.getLaneLength() + (instance.getLaneLength() - 1);
            finalBlock.xorWith(instance.memory[lastBlockInLane]);
        }
        byte[] finalBlockBytes = finalBlock.toBytes();
        byte[] finalResult = Functions.blake2bLong(finalBlockBytes, argon2.getOutputLength());
        argon2.setOutput(finalResult);
        if (argon2.isClearMemory()) {
            instance.clear();
            argon2.clear();
        }
    }
}

