//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.5
//
// <auto-generated>
//
// Generated from file `Exception.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Exception_h__
#define __IceGrid_Exception_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Identity.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 5
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

/**
 * This exception is raised if an application does not exist.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ApplicationNotExistException : public ::Ice::UserExceptionHelper<ApplicationNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ApplicationNotExistException();

    ApplicationNotExistException(const ApplicationNotExistException&) = default;

    ApplicationNotExistException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the application.
     */
    ApplicationNotExistException(const ::std::string& name) :
        name(name)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The name of the application.
     */
    ::std::string name;
};

/// \cond INTERNAL
static ApplicationNotExistException _iceS_ApplicationNotExistException_init;
/// \endcond

/**
 * This exception is raised if a server does not exist.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ServerNotExistException : public ::Ice::UserExceptionHelper<ServerNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServerNotExistException();

    ServerNotExistException(const ServerNotExistException&) = default;

    ServerNotExistException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The identifier of the server.
     */
    ServerNotExistException(const ::std::string& id) :
        id(id)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(id);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The identifier of the server.
     */
    ::std::string id;
};

/**
 * This exception is raised if a server failed to start.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ServerStartException : public ::Ice::UserExceptionHelper<ServerStartException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServerStartException();

    ServerStartException(const ServerStartException&) = default;

    ServerStartException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The identifier of the server.
     * @param reason The reason for the failure.
     */
    ServerStartException(const ::std::string& id, const ::std::string& reason) :
        id(id),
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The identifier of the server.
     */
    ::std::string id;
    /**
     * The reason for the failure.
     */
    ::std::string reason;
};

/**
 * This exception is raised if a server failed to stop.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ServerStopException : public ::Ice::UserExceptionHelper<ServerStopException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServerStopException();

    ServerStopException(const ServerStopException&) = default;

    ServerStopException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The identifier of the server.
     * @param reason The reason for the failure.
     */
    ServerStopException(const ::std::string& id, const ::std::string& reason) :
        id(id),
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The identifier of the server.
     */
    ::std::string id;
    /**
     * The reason for the failure.
     */
    ::std::string reason;
};

/**
 * This exception is raised if an adapter does not exist.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) AdapterNotExistException : public ::Ice::UserExceptionHelper<AdapterNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~AdapterNotExistException();

    AdapterNotExistException(const AdapterNotExistException&) = default;

    AdapterNotExistException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The id of the object adapter.
     */
    AdapterNotExistException(const ::std::string& id) :
        id(id)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(id);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The id of the object adapter.
     */
    ::std::string id;
};

/**
 * This exception is raised if an object already exists.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ObjectExistsException : public ::Ice::UserExceptionHelper<ObjectExistsException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ObjectExistsException();

    ObjectExistsException(const ObjectExistsException&) = default;

    ObjectExistsException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The identity of the object.
     */
    ObjectExistsException(const ::Ice::Identity& id) :
        id(id)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::Ice::Identity&> ice_tuple() const
    {
        return std::tie(id);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The identity of the object.
     */
    ::Ice::Identity id;
};

/**
 * This exception is raised if an object is not registered.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ObjectNotRegisteredException : public ::Ice::UserExceptionHelper<ObjectNotRegisteredException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ObjectNotRegisteredException();

    ObjectNotRegisteredException(const ObjectNotRegisteredException&) = default;

    ObjectNotRegisteredException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The identity of the object.
     */
    ObjectNotRegisteredException(const ::Ice::Identity& id) :
        id(id)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::Ice::Identity&> ice_tuple() const
    {
        return std::tie(id);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The identity of the object.
     */
    ::Ice::Identity id;
};

/**
 * This exception is raised if a node does not exist.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) NodeNotExistException : public ::Ice::UserExceptionHelper<NodeNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~NodeNotExistException();

    NodeNotExistException(const NodeNotExistException&) = default;

    NodeNotExistException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The node name.
     */
    NodeNotExistException(const ::std::string& name) :
        name(name)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The node name.
     */
    ::std::string name;
};

/**
 * This exception is raised if a registry does not exist.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) RegistryNotExistException : public ::Ice::UserExceptionHelper<RegistryNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~RegistryNotExistException();

    RegistryNotExistException(const RegistryNotExistException&) = default;

    RegistryNotExistException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The registry name.
     */
    RegistryNotExistException(const ::std::string& name) :
        name(name)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(name);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The registry name.
     */
    ::std::string name;
};

/**
 * An exception for deployment errors.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) DeploymentException : public ::Ice::UserExceptionHelper<DeploymentException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~DeploymentException();

    DeploymentException(const DeploymentException&) = default;

    DeploymentException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the failure.
     */
    DeploymentException(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The reason for the failure.
     */
    ::std::string reason;
};

/**
 * This exception is raised if a node could not be reached.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) NodeUnreachableException : public ::Ice::UserExceptionHelper<NodeUnreachableException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~NodeUnreachableException();

    NodeUnreachableException(const NodeUnreachableException&) = default;

    NodeUnreachableException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the node that is not reachable.
     * @param reason The reason why the node couldn't be reached.
     */
    NodeUnreachableException(const ::std::string& name, const ::std::string& reason) :
        name(name),
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The name of the node that is not reachable.
     */
    ::std::string name;
    /**
     * The reason why the node couldn't be reached.
     */
    ::std::string reason;
};

/**
 * This exception is raised if a server could not be reached.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ServerUnreachableException : public ::Ice::UserExceptionHelper<ServerUnreachableException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServerUnreachableException();

    ServerUnreachableException(const ServerUnreachableException&) = default;

    ServerUnreachableException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The id of the server that is not reachable.
     * @param reason The reason why the server couldn't be reached.
     */
    ServerUnreachableException(const ::std::string& name, const ::std::string& reason) :
        name(name),
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The id of the server that is not reachable.
     */
    ::std::string name;
    /**
     * The reason why the server couldn't be reached.
     */
    ::std::string reason;
};

/**
 * This exception is raised if a registry could not be reached.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) RegistryUnreachableException : public ::Ice::UserExceptionHelper<RegistryUnreachableException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~RegistryUnreachableException();

    RegistryUnreachableException(const RegistryUnreachableException&) = default;

    RegistryUnreachableException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the registry that is not reachable.
     * @param reason The reason why the registry couldn't be reached.
     */
    RegistryUnreachableException(const ::std::string& name, const ::std::string& reason) :
        name(name),
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The name of the registry that is not reachable.
     */
    ::std::string name;
    /**
     * The reason why the registry couldn't be reached.
     */
    ::std::string reason;
};

/**
 * This exception is raised if an unknown signal was sent to
 * to a server.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) BadSignalException : public ::Ice::UserExceptionHelper<BadSignalException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~BadSignalException();

    BadSignalException(const BadSignalException&) = default;

    BadSignalException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The details of the unknown signal.
     */
    BadSignalException(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The details of the unknown signal.
     */
    ::std::string reason;
};

/**
 * This exception is raised if a patch failed.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) PatchException : public ::Ice::UserExceptionHelper<PatchException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~PatchException();

    PatchException(const PatchException&) = default;

    PatchException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reasons The reasons why the patch failed.
     */
    PatchException(const ::Ice::StringSeq& reasons) :
        reasons(reasons)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::Ice::StringSeq&> ice_tuple() const
    {
        return std::tie(reasons);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The reasons why the patch failed.
     */
    ::Ice::StringSeq reasons;
};

/**
 * This exception is raised if a registry lock wasn't
 * acquired or is already held by a session.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) AccessDeniedException : public ::Ice::UserExceptionHelper<AccessDeniedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~AccessDeniedException();

    AccessDeniedException(const AccessDeniedException&) = default;

    AccessDeniedException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param lockUserId The id of the user holding the lock (if any).
     */
    AccessDeniedException(const ::std::string& lockUserId) :
        lockUserId(lockUserId)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(lockUserId);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The id of the user holding the lock (if any).
     */
    ::std::string lockUserId;
};

/**
 * This exception is raised if the allocation of an object failed.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) AllocationException : public ::Ice::UserExceptionHelper<AllocationException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~AllocationException();

    AllocationException(const AllocationException&) = default;

    AllocationException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason why the object couldn't be allocated.
     */
    AllocationException(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The reason why the object couldn't be allocated.
     */
    ::std::string reason;
};

/**
 * This exception is raised if the request to allocate an object times
 * out.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) AllocationTimeoutException : public ::Ice::UserExceptionHelper<AllocationTimeoutException, AllocationException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~AllocationTimeoutException();

    AllocationTimeoutException(const AllocationTimeoutException&) = default;

    AllocationTimeoutException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason why the object couldn't be allocated.
     */
    AllocationTimeoutException(const ::std::string& reason) :
        ::Ice::UserExceptionHelper<AllocationTimeoutException, AllocationException>(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();
};

/**
 * This exception is raised if a client is denied the ability to create
 * a session with IceGrid.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) PermissionDeniedException : public ::Ice::UserExceptionHelper<PermissionDeniedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~PermissionDeniedException();

    PermissionDeniedException(const PermissionDeniedException&) = default;

    PermissionDeniedException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason why permission was denied.
     */
    PermissionDeniedException(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The reason why permission was denied.
     */
    ::std::string reason;
};

/**
 * This exception is raised if an observer is already registered with
 * the registry.
 * @see AdminSession#setObservers
 * @see AdminSession#setObserversByIdentity
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ObserverAlreadyRegisteredException : public ::Ice::UserExceptionHelper<ObserverAlreadyRegisteredException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ObserverAlreadyRegisteredException();

    ObserverAlreadyRegisteredException(const ObserverAlreadyRegisteredException&) = default;

    ObserverAlreadyRegisteredException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The identity of the observer.
     */
    ObserverAlreadyRegisteredException(const ::Ice::Identity& id) :
        id(id)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::Ice::Identity&> ice_tuple() const
    {
        return std::tie(id);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The identity of the observer.
     */
    ::Ice::Identity id;
};

/**
 * This exception is raised if a file is not available.
 * @see AdminSession#openServerStdOut
 * @see AdminSession#openServerStdErr
 * @see AdminSession#openNodeStdOut
 * @see AdminSession#openNodeStdErr
 * @see AdminSession#openRegistryStdOut
 * @see AdminSession#openRegistryStdErr
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) FileNotAvailableException : public ::Ice::UserExceptionHelper<FileNotAvailableException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~FileNotAvailableException();

    FileNotAvailableException(const FileNotAvailableException&) = default;

    FileNotAvailableException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the failure.
     */
    FileNotAvailableException(const ::std::string& reason) :
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The reason for the failure.
     */
    ::std::string reason;
};

}

/// \cond STREAM
namespace Ice
{

template<typename S>
struct StreamReader<::IceGrid::ApplicationNotExistException, S>
{
    static void read(S* istr, ::IceGrid::ApplicationNotExistException& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServerNotExistException, S>
{
    static void read(S* istr, ::IceGrid::ServerNotExistException& v)
    {
        istr->readAll(v.id);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServerStartException, S>
{
    static void read(S* istr, ::IceGrid::ServerStartException& v)
    {
        istr->readAll(v.id, v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServerStopException, S>
{
    static void read(S* istr, ::IceGrid::ServerStopException& v)
    {
        istr->readAll(v.id, v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::AdapterNotExistException, S>
{
    static void read(S* istr, ::IceGrid::AdapterNotExistException& v)
    {
        istr->readAll(v.id);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ObjectExistsException, S>
{
    static void read(S* istr, ::IceGrid::ObjectExistsException& v)
    {
        istr->readAll(v.id);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ObjectNotRegisteredException, S>
{
    static void read(S* istr, ::IceGrid::ObjectNotRegisteredException& v)
    {
        istr->readAll(v.id);
    }
};

template<typename S>
struct StreamReader<::IceGrid::NodeNotExistException, S>
{
    static void read(S* istr, ::IceGrid::NodeNotExistException& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceGrid::RegistryNotExistException, S>
{
    static void read(S* istr, ::IceGrid::RegistryNotExistException& v)
    {
        istr->readAll(v.name);
    }
};

template<typename S>
struct StreamReader<::IceGrid::DeploymentException, S>
{
    static void read(S* istr, ::IceGrid::DeploymentException& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::NodeUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::NodeUnreachableException& v)
    {
        istr->readAll(v.name, v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServerUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::ServerUnreachableException& v)
    {
        istr->readAll(v.name, v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::RegistryUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::RegistryUnreachableException& v)
    {
        istr->readAll(v.name, v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::BadSignalException, S>
{
    static void read(S* istr, ::IceGrid::BadSignalException& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::PatchException, S>
{
    static void read(S* istr, ::IceGrid::PatchException& v)
    {
        istr->readAll(v.reasons);
    }
};

template<typename S>
struct StreamReader<::IceGrid::AccessDeniedException, S>
{
    static void read(S* istr, ::IceGrid::AccessDeniedException& v)
    {
        istr->readAll(v.lockUserId);
    }
};

template<typename S>
struct StreamReader<::IceGrid::AllocationException, S>
{
    static void read(S* istr, ::IceGrid::AllocationException& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::AllocationTimeoutException, S>
{
    static void write(S*, const ::IceGrid::AllocationTimeoutException&)
    {
    }
};

template<typename S>
struct StreamReader<::IceGrid::AllocationTimeoutException, S>
{
    static void read(S*, ::IceGrid::AllocationTimeoutException&)
    {
    }
};

template<typename S>
struct StreamReader<::IceGrid::PermissionDeniedException, S>
{
    static void read(S* istr, ::IceGrid::PermissionDeniedException& v)
    {
        istr->readAll(v.reason);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ObserverAlreadyRegisteredException, S>
{
    static void read(S* istr, ::IceGrid::ObserverAlreadyRegisteredException& v)
    {
        istr->readAll(v.id);
    }
};

template<typename S>
struct StreamReader<::IceGrid::FileNotAvailableException, S>
{
    static void read(S* istr, ::IceGrid::FileNotAvailableException& v)
    {
        istr->readAll(v.reason);
    }
};

}
/// \endcond

#else // C++98 mapping

namespace IceGrid
{

/**
 * This exception is raised if an application does not exist.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ApplicationNotExistException : public ::Ice::UserException
{
public:

    ApplicationNotExistException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the application.
     */
    explicit ApplicationNotExistException(const ::std::string& name);
    virtual ~ApplicationNotExistException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ApplicationNotExistException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The name of the application.
     */
    ::std::string name;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static ApplicationNotExistException _iceS_ApplicationNotExistException_init;
/// \endcond

/**
 * This exception is raised if a server does not exist.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ServerNotExistException : public ::Ice::UserException
{
public:

    ServerNotExistException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param id The identifier of the server.
     */
    explicit ServerNotExistException(const ::std::string& id);
    virtual ~ServerNotExistException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ServerNotExistException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The identifier of the server.
     */
    ::std::string id;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a server failed to start.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ServerStartException : public ::Ice::UserException
{
public:

    ServerStartException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param id The identifier of the server.
     * @param reason The reason for the failure.
     */
    ServerStartException(const ::std::string& id, const ::std::string& reason);
    virtual ~ServerStartException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ServerStartException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The identifier of the server.
     */
    ::std::string id;
    /**
     * The reason for the failure.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a server failed to stop.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ServerStopException : public ::Ice::UserException
{
public:

    ServerStopException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param id The identifier of the server.
     * @param reason The reason for the failure.
     */
    ServerStopException(const ::std::string& id, const ::std::string& reason);
    virtual ~ServerStopException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ServerStopException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The identifier of the server.
     */
    ::std::string id;
    /**
     * The reason for the failure.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if an adapter does not exist.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API AdapterNotExistException : public ::Ice::UserException
{
public:

    AdapterNotExistException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param id The id of the object adapter.
     */
    explicit AdapterNotExistException(const ::std::string& id);
    virtual ~AdapterNotExistException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AdapterNotExistException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The id of the object adapter.
     */
    ::std::string id;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if an object already exists.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ObjectExistsException : public ::Ice::UserException
{
public:

    ObjectExistsException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param id The identity of the object.
     */
    explicit ObjectExistsException(const ::Ice::Identity& id);
    virtual ~ObjectExistsException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ObjectExistsException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The identity of the object.
     */
    ::Ice::Identity id;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if an object is not registered.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ObjectNotRegisteredException : public ::Ice::UserException
{
public:

    ObjectNotRegisteredException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param id The identity of the object.
     */
    explicit ObjectNotRegisteredException(const ::Ice::Identity& id);
    virtual ~ObjectNotRegisteredException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ObjectNotRegisteredException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The identity of the object.
     */
    ::Ice::Identity id;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a node does not exist.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API NodeNotExistException : public ::Ice::UserException
{
public:

    NodeNotExistException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param name The node name.
     */
    explicit NodeNotExistException(const ::std::string& name);
    virtual ~NodeNotExistException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual NodeNotExistException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The node name.
     */
    ::std::string name;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a registry does not exist.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API RegistryNotExistException : public ::Ice::UserException
{
public:

    RegistryNotExistException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param name The registry name.
     */
    explicit RegistryNotExistException(const ::std::string& name);
    virtual ~RegistryNotExistException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual RegistryNotExistException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The registry name.
     */
    ::std::string name;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * An exception for deployment errors.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API DeploymentException : public ::Ice::UserException
{
public:

    DeploymentException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the failure.
     */
    explicit DeploymentException(const ::std::string& reason);
    virtual ~DeploymentException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual DeploymentException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason for the failure.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a node could not be reached.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API NodeUnreachableException : public ::Ice::UserException
{
public:

    NodeUnreachableException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the node that is not reachable.
     * @param reason The reason why the node couldn't be reached.
     */
    NodeUnreachableException(const ::std::string& name, const ::std::string& reason);
    virtual ~NodeUnreachableException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual NodeUnreachableException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The name of the node that is not reachable.
     */
    ::std::string name;
    /**
     * The reason why the node couldn't be reached.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a server could not be reached.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ServerUnreachableException : public ::Ice::UserException
{
public:

    ServerUnreachableException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param name The id of the server that is not reachable.
     * @param reason The reason why the server couldn't be reached.
     */
    ServerUnreachableException(const ::std::string& name, const ::std::string& reason);
    virtual ~ServerUnreachableException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ServerUnreachableException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The id of the server that is not reachable.
     */
    ::std::string name;
    /**
     * The reason why the server couldn't be reached.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a registry could not be reached.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API RegistryUnreachableException : public ::Ice::UserException
{
public:

    RegistryUnreachableException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the registry that is not reachable.
     * @param reason The reason why the registry couldn't be reached.
     */
    RegistryUnreachableException(const ::std::string& name, const ::std::string& reason);
    virtual ~RegistryUnreachableException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual RegistryUnreachableException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The name of the registry that is not reachable.
     */
    ::std::string name;
    /**
     * The reason why the registry couldn't be reached.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if an unknown signal was sent to
 * to a server.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API BadSignalException : public ::Ice::UserException
{
public:

    BadSignalException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The details of the unknown signal.
     */
    explicit BadSignalException(const ::std::string& reason);
    virtual ~BadSignalException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual BadSignalException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The details of the unknown signal.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a patch failed.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API PatchException : public ::Ice::UserException
{
public:

    PatchException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reasons The reasons why the patch failed.
     */
    explicit PatchException(const ::Ice::StringSeq& reasons);
    virtual ~PatchException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual PatchException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reasons why the patch failed.
     */
    ::Ice::StringSeq reasons;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a registry lock wasn't
 * acquired or is already held by a session.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API AccessDeniedException : public ::Ice::UserException
{
public:

    AccessDeniedException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param lockUserId The id of the user holding the lock (if any).
     */
    explicit AccessDeniedException(const ::std::string& lockUserId);
    virtual ~AccessDeniedException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AccessDeniedException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The id of the user holding the lock (if any).
     */
    ::std::string lockUserId;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if the allocation of an object failed.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API AllocationException : public ::Ice::UserException
{
public:

    AllocationException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason why the object couldn't be allocated.
     */
    explicit AllocationException(const ::std::string& reason);
    virtual ~AllocationException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AllocationException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason why the object couldn't be allocated.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if the request to allocate an object times
 * out.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API AllocationTimeoutException : public AllocationException
{
public:

    AllocationTimeoutException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason why the object couldn't be allocated.
     */
    explicit AllocationTimeoutException(const ::std::string& reason);
    virtual ~AllocationTimeoutException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AllocationTimeoutException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a client is denied the ability to create
 * a session with IceGrid.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API PermissionDeniedException : public ::Ice::UserException
{
public:

    PermissionDeniedException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason why permission was denied.
     */
    explicit PermissionDeniedException(const ::std::string& reason);
    virtual ~PermissionDeniedException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual PermissionDeniedException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason why permission was denied.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if an observer is already registered with
 * the registry.
 * @see AdminSession#setObservers
 * @see AdminSession#setObserversByIdentity
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ObserverAlreadyRegisteredException : public ::Ice::UserException
{
public:

    ObserverAlreadyRegisteredException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param id The identity of the observer.
     */
    explicit ObserverAlreadyRegisteredException(const ::Ice::Identity& id);
    virtual ~ObserverAlreadyRegisteredException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ObserverAlreadyRegisteredException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The identity of the observer.
     */
    ::Ice::Identity id;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a file is not available.
 * @see AdminSession#openServerStdOut
 * @see AdminSession#openServerStdErr
 * @see AdminSession#openNodeStdOut
 * @see AdminSession#openNodeStdErr
 * @see AdminSession#openRegistryStdOut
 * @see AdminSession#openRegistryStdErr
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API FileNotAvailableException : public ::Ice::UserException
{
public:

    FileNotAvailableException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param reason The reason for the failure.
     */
    explicit FileNotAvailableException(const ::std::string& reason);
    virtual ~FileNotAvailableException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual FileNotAvailableException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason for the failure.
     */
    ::std::string reason;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::ApplicationNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ApplicationNotExistException, S>
{
    static void write(S* ostr, const ::IceGrid::ApplicationNotExistException& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ApplicationNotExistException, S>
{
    static void read(S* istr, ::IceGrid::ApplicationNotExistException& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerNotExistException, S>
{
    static void write(S* ostr, const ::IceGrid::ServerNotExistException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerNotExistException, S>
{
    static void read(S* istr, ::IceGrid::ServerNotExistException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerStartException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerStartException, S>
{
    static void write(S* ostr, const ::IceGrid::ServerStartException& v)
    {
        ostr->write(v.id);
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerStartException, S>
{
    static void read(S* istr, ::IceGrid::ServerStartException& v)
    {
        istr->read(v.id);
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerStopException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerStopException, S>
{
    static void write(S* ostr, const ::IceGrid::ServerStopException& v)
    {
        ostr->write(v.id);
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerStopException, S>
{
    static void read(S* istr, ::IceGrid::ServerStopException& v)
    {
        istr->read(v.id);
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AdapterNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::AdapterNotExistException, S>
{
    static void write(S* ostr, const ::IceGrid::AdapterNotExistException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdapterNotExistException, S>
{
    static void read(S* istr, ::IceGrid::AdapterNotExistException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ObjectExistsException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ObjectExistsException, S>
{
    static void write(S* ostr, const ::IceGrid::ObjectExistsException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ObjectExistsException, S>
{
    static void read(S* istr, ::IceGrid::ObjectExistsException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ObjectNotRegisteredException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ObjectNotRegisteredException, S>
{
    static void write(S* ostr, const ::IceGrid::ObjectNotRegisteredException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ObjectNotRegisteredException, S>
{
    static void read(S* istr, ::IceGrid::ObjectNotRegisteredException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeNotExistException, S>
{
    static void write(S* ostr, const ::IceGrid::NodeNotExistException& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeNotExistException, S>
{
    static void read(S* istr, ::IceGrid::NodeNotExistException& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceGrid::RegistryNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::RegistryNotExistException, S>
{
    static void write(S* ostr, const ::IceGrid::RegistryNotExistException& v)
    {
        ostr->write(v.name);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::RegistryNotExistException, S>
{
    static void read(S* istr, ::IceGrid::RegistryNotExistException& v)
    {
        istr->read(v.name);
    }
};

template<>
struct StreamableTraits< ::IceGrid::DeploymentException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::DeploymentException, S>
{
    static void write(S* ostr, const ::IceGrid::DeploymentException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::DeploymentException, S>
{
    static void read(S* istr, ::IceGrid::DeploymentException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeUnreachableException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeUnreachableException, S>
{
    static void write(S* ostr, const ::IceGrid::NodeUnreachableException& v)
    {
        ostr->write(v.name);
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::NodeUnreachableException& v)
    {
        istr->read(v.name);
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerUnreachableException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerUnreachableException, S>
{
    static void write(S* ostr, const ::IceGrid::ServerUnreachableException& v)
    {
        ostr->write(v.name);
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::ServerUnreachableException& v)
    {
        istr->read(v.name);
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::RegistryUnreachableException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::RegistryUnreachableException, S>
{
    static void write(S* ostr, const ::IceGrid::RegistryUnreachableException& v)
    {
        ostr->write(v.name);
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::RegistryUnreachableException, S>
{
    static void read(S* istr, ::IceGrid::RegistryUnreachableException& v)
    {
        istr->read(v.name);
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::BadSignalException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::BadSignalException, S>
{
    static void write(S* ostr, const ::IceGrid::BadSignalException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::BadSignalException, S>
{
    static void read(S* istr, ::IceGrid::BadSignalException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::PatchException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::PatchException, S>
{
    static void write(S* ostr, const ::IceGrid::PatchException& v)
    {
        ostr->write(v.reasons);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::PatchException, S>
{
    static void read(S* istr, ::IceGrid::PatchException& v)
    {
        istr->read(v.reasons);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AccessDeniedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::AccessDeniedException, S>
{
    static void write(S* ostr, const ::IceGrid::AccessDeniedException& v)
    {
        ostr->write(v.lockUserId);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AccessDeniedException, S>
{
    static void read(S* istr, ::IceGrid::AccessDeniedException& v)
    {
        istr->read(v.lockUserId);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AllocationException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::AllocationException, S>
{
    static void write(S* ostr, const ::IceGrid::AllocationException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AllocationException, S>
{
    static void read(S* istr, ::IceGrid::AllocationException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AllocationTimeoutException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceGrid::PermissionDeniedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::PermissionDeniedException, S>
{
    static void write(S* ostr, const ::IceGrid::PermissionDeniedException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::PermissionDeniedException, S>
{
    static void read(S* istr, ::IceGrid::PermissionDeniedException& v)
    {
        istr->read(v.reason);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ObserverAlreadyRegisteredException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::ObserverAlreadyRegisteredException, S>
{
    static void write(S* ostr, const ::IceGrid::ObserverAlreadyRegisteredException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ObserverAlreadyRegisteredException, S>
{
    static void read(S* istr, ::IceGrid::ObserverAlreadyRegisteredException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::FileNotAvailableException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::FileNotAvailableException, S>
{
    static void write(S* ostr, const ::IceGrid::FileNotAvailableException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::FileNotAvailableException, S>
{
    static void read(S* istr, ::IceGrid::FileNotAvailableException& v)
    {
        istr->read(v.reason);
    }
};

}
/// \endcond

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
