from collections import OrderedDict

from .. import Provider as PersonProvider


class Provider(PersonProvider):
    formats_female = OrderedDict((
        ('{{first_name_female}} {{last_name}}', 0.97),
        ('{{prefix_female}} {{first_name_female}} {{last_name}}', 0.015),
        ('{{first_name_female}} {{last_name}} {{suffix_female}}', 0.02),
        ('{{prefix_female}} {{first_name_female}} {{last_name}} {{suffix_female}}', 0.005),
    ))

    formats_nonbinary = OrderedDict((
        ('{{first_name_nonbinary}} {{last_name}}', 0.97),
        ('{{prefix_nonbinary}} {{first_name_nonbinary}} {{last_name}}', 0.015),
        ('{{first_name_nonbinary}} {{last_name}} {{suffix_nonbinary}}', 0.02),
        ('{{prefix_nonbinary}} {{first_name_nonbinary}} {{last_name}} {{suffix_nonbinary}}', 0.005),
    ))

    formats_male = OrderedDict((
        ('{{first_name_male}} {{last_name}}', 0.97),
        ('{{prefix_male}} {{first_name_male}} {{last_name}}', 0.015),
        ('{{first_name_male}} {{last_name}} {{suffix_male}}', 0.02),
        ('{{prefix_male}} {{first_name_male}} {{last_name}} {{suffix_male}}', 0.005),
    ))

    # Using random_element's dictionary weighting means that the
    #     formats = formats_male + formats_female
    # has to be replaced with something dict and python 2.x compatible

    formats = formats_male.copy()
    formats.update(formats_female)

    # Top 200 names of the decade from the 60's-90's from:
    # https://www.ssa.gov/OACT/babynames/decades/names1960s.html
    # Weightings derived from total number on each name

    first_names_female = OrderedDict((
        ('April', 0.004529083),
        ('Abigail', 0.002043839),
        ('Adriana', 0.000488767),
        ('Adrienne', 0.000622931),
        ('Aimee', 0.000424727),
        ('Alejandra', 0.000415754),
        ('Alexa', 0.000663005),
        ('Alexandra', 0.002835711),
        ('Alexandria', 0.000964993),
        ('Alexis', 0.003446735),
        ('Alice', 0.000589904),
        ('Alicia', 0.003766845),
        ('Alisha', 0.000475942),
        ('Alison', 0.001506047),
        ('Allison', 0.003740866),
        ('Alyssa', 0.00324341),
        ('Amanda', 0.015360768),
        ('Amber', 0.006928794),
        ('Amy', 0.012860314),
        ('Ana', 0.000853679),
        ('Andrea', 0.006747028),
        ('Angel', 0.001161117),
        ('Angela', 0.011954085),
        ('Angelica', 0.001102746),
        ('Angie', 0.00030166),
        ('Anita', 0.001383767),
        ('Ann', 0.002627483),
        ('Anna', 0.004691502),
        ('Anne', 0.002089582),
        ('Annette', 0.001487399),
        ('Ariana', 0.000412668),
        ('Ariel', 0.000615774),
        ('Ashlee', 0.000696534),
        ('Ashley', 0.014773009),
        ('Audrey', 0.001139165),
        ('Autumn', 0.000918594),
        ('Bailey', 0.000691916),
        ('Barbara', 0.004839169),
        ('Becky', 0.000960944),
        ('Belinda', 0.000502227),
        ('Beth', 0.002246113),
        ('Bethany', 0.001249385),
        ('Betty', 0.000840241),
        ('Beverly', 0.000990272),
        ('Bianca', 0.000624835),
        ('Bonnie', 0.001351901),
        ('Brandi', 0.002077216),
        ('Brandy', 0.002177499),
        ('Breanna', 0.000876003),
        ('Brenda', 0.005737124),
        ('Briana', 0.00093665),
        ('Brianna', 0.002543549),
        ('Bridget', 0.000787232),
        ('Brittany', 0.007258404),
        ('Brittney', 0.001566147),
        ('Brooke', 0.002410152),
        ('Caitlin', 0.001808319),
        ('Caitlyn', 0.000481194),
        ('Candace', 0.000550662),
        ('Candice', 0.000653199),
        ('Carla', 0.00195185),
        ('Carly', 0.000498725),
        ('Carmen', 0.000891783),
        ('Carol', 0.002972719),
        ('Caroline', 0.001198127),
        ('Carolyn', 0.002647225),
        ('Carrie', 0.002934659),
        ('Casey', 0.001177707),
        ('Cassandra', 0.002501243),
        ('Cassidy', 0.000452129),
        ('Cassie', 0.000344886),
        ('Catherine', 0.004460622),
        ('Cathy', 0.001413248),
        ('Charlene', 0.000538865),
        ('Charlotte', 0.000530417),
        ('Chelsea', 0.00280043),
        ('Chelsey', 0.000368501),
        ('Cheryl', 0.004166447),
        ('Cheyenne', 0.000696907),
        ('Chloe', 0.000565807),
        ('Christie', 0.000397873),
        ('Christina', 0.008735669),
        ('Christine', 0.007488758),
        ('Christy', 0.00141861),
        ('Cindy', 0.003360109),
        ('Claire', 0.000553835),
        ('Claudia', 0.00096055),
        ('Colleen', 0.001836203),
        ('Connie', 0.001821845),
        ('Courtney', 0.00484939),
        ('Cristina', 0.000328734),
        ('Crystal', 0.006365045),
        ('Cynthia', 0.007655379),
        ('Daisy', 0.000437443),
        ('Dana', 0.003395805),
        ('Danielle', 0.006671783),
        ('Darlene', 0.000952737),
        ('Dawn', 0.005014983),
        ('Deanna', 0.002049026),
        ('Debbie', 0.001842922),
        ('Deborah', 0.005386088),
        ('Debra', 0.004123572),
        ('Denise', 0.004592291),
        ('Desiree', 0.000991497),
        ('Destiny', 0.001055515),
        ('Diamond', 0.000331732),
        ('Diana', 0.003699348),
        ('Diane', 0.003058996),
        ('Dominique', 0.000847857),
        ('Donna', 0.00570819),
        ('Doris', 0.000398026),
        ('Dorothy', 0.000722426),
        ('Ebony', 0.000399624),
        ('Eileen', 0.000544271),
        ('Elaine', 0.000601175),
        ('Elizabeth', 0.014954075),
        ('Ellen', 0.000747267),
        ('Emily', 0.009100581),
        ('Emma', 0.001272059),
        ('Erica', 0.004344471),
        ('Erika', 0.002105537),
        ('Erin', 0.005450719),
        ('Evelyn', 0.000825095),
        ('Faith', 0.000427113),
        ('Felicia', 0.001717294),
        ('Frances', 0.000546897),
        ('Gabriela', 0.000526937),
        ('Gabriella', 0.00044123),
        ('Gabrielle', 0.001090096),
        ('Gail', 0.00071934),
        ('Gina', 0.002841095),
        ('Glenda', 0.000384982),
        ('Gloria', 0.001155623),
        ('Grace', 0.00087202),
        ('Gwendolyn', 0.000407831),
        ('Hailey', 0.000662917),
        ('Haley', 0.001557939),
        ('Hannah', 0.004189822),
        ('Hayley', 0.000478305),
        ('Heather', 0.010945254),
        ('Heidi', 0.002239941),
        ('Helen', 0.000636675),
        ('Holly', 0.003487028),
        ('Isabel', 0.000352305),
        ('Isabella', 0.000410282),
        ('Jackie', 0.000566748),
        ('Jaclyn', 0.00047708),
        ('Jacqueline', 0.004811242),
        ('Jade', 0.000446264),
        ('Jaime', 0.000853175),
        ('Jamie', 0.005067663),
        ('Jane', 0.0009486),
        ('Janet', 0.002489993),
        ('Janice', 0.001593308),
        ('Jasmin', 0.000333374),
        ('Jasmine', 0.003025422),
        ('Jean', 0.000815969),
        ('Jeanette', 0.000767293),
        ('Jeanne', 0.000515381),
        ('Jenna', 0.001804052),
        ('Jennifer', 0.029218839),
        ('Jenny', 0.000932667),
        ('Jessica', 0.020047608),
        ('Jill', 0.003253018),
        ('Jillian', 0.000988587),
        ('Jo', 0.000442083),
        ('Joan', 0.000802793),
        ('Joann', 0.000544336),
        ('Joanna', 0.001176284),
        ('Joanne', 0.000729824),
        ('Jocelyn', 0.000456878),
        ('Jodi', 0.001252405),
        ('Jody', 0.000741861),
        ('Jordan', 0.001653057),
        ('Joy', 0.000916515),
        ('Joyce', 0.001009488),
        ('Judith', 0.000870706),
        ('Judy', 0.001101586),
        ('Julia', 0.003301891),
        ('Julie', 0.008211731),
        ('Kaitlin', 0.000674473),
        ('Kaitlyn', 0.001478623),
        ('Kara', 0.001549119),
        ('Karen', 0.009643845),
        ('Kari', 0.000794323),
        ('Karina', 0.000494764),
        ('Karla', 0.000387696),
        ('Katelyn', 0.001476128),
        ('Katherine', 0.006581479),
        ('Kathleen', 0.00503549),
        ('Kathryn', 0.004177806),
        ('Kathy', 0.002710214),
        ('Katie', 0.003056216),
        ('Katrina', 0.001565446),
        ('Kayla', 0.004621465),
        ('Kaylee', 0.000551734),
        ('Kelli', 0.000932163),
        ('Kellie', 0.000299187),
        ('Kelly', 0.009342929),
        ('Kelsey', 0.002470383),
        ('Kendra', 0.001401079),
        ('Kerri', 0.000316215),
        ('Kerry', 0.000352984),
        ('Kiara', 0.000390037),
        ('Kim', 0.002518642),
        ('Kimberly', 0.015594077),
        ('Kirsten', 0.000369486),
        ('Krista', 0.001266872),
        ('Kristen', 0.004345587),
        ('Kristi', 0.001022926),
        ('Kristie', 0.000380189),
        ('Kristin', 0.003613728),
        ('Kristina', 0.002316281),
        ('Kristine', 0.000977709),
        ('Kristy', 0.001097734),
        ('Krystal', 0.001238113),
        ('Kylie', 0.00049739),
        ('Lacey', 0.00045469),
        ('Latasha', 0.00032904),
        ('Latoya', 0.000646371),
        ('Laura', 0.010815096),
        ('Lauren', 0.007015421),
        ('Laurie', 0.002200786),
        ('Leah', 0.001997571),
        ('Leslie', 0.003606134),
        ('Linda', 0.006437751),
        ('Lindsay', 0.002185466),
        ('Lindsey', 0.002646153),
        ('Lisa', 0.01872729),
        ('Loretta', 0.000482945),
        ('Lori', 0.006040316),
        ('Lorraine', 0.000486753),
        ('Lydia', 0.000370274),
        ('Lynn', 0.001522308),
        ('Mackenzie', 0.000761056),
        ('Madeline', 0.000808921),
        ('Madison', 0.002011184),
        ('Makayla', 0.000439391),
        ('Mallory', 0.000688633),
        ('Mandy', 0.000355566),
        ('Marcia', 0.000403213),
        ('Margaret', 0.003839968),
        ('Maria', 0.006593123),
        ('Mariah', 0.00097598),
        ('Marie', 0.001520229),
        ('Marilyn', 0.000590889),
        ('Marisa', 0.000339983),
        ('Marissa', 0.001582627),
        ('Martha', 0.001290028),
        ('Mary', 0.014288466),
        ('Maureen', 0.000753855),
        ('Mckenzie', 0.000334512),
        ('Meagan', 0.000729999),
        ('Megan', 0.007686786),
        ('Meghan', 0.001481578),
        ('Melanie', 0.003400117),
        ('Melinda', 0.002078113),
        ('Melissa', 0.014890692),
        ('Melody', 0.000404264),
        ('Mercedes', 0.000334643),
        ('Meredith', 0.000766987),
        ('Mia', 0.000319935),
        ('Michaela', 0.000506998),
        ('Michele', 0.003519551),
        ('Michelle', 0.01527423),
        ('Mikayla', 0.000410195),
        ('Mindy', 0.000306891),
        ('Miranda', 0.001421193),
        ('Misty', 0.001564614),
        ('Molly', 0.001710641),
        ('Monica', 0.004324095),
        ('Monique', 0.001272125),
        ('Morgan', 0.002527025),
        ('Nancy', 0.005023343),
        ('Natalie', 0.003658398),
        ('Natasha', 0.001739815),
        ('Nichole', 0.001001237),
        ('Nicole', 0.011156655),
        ('Nina', 0.000298115),
        ('Norma', 0.000470754),
        ('Olivia', 0.001967609),
        ('Paige', 0.001106313),
        ('Pam', 0.000374454),
        ('Pamela', 0.005816222),
        ('Patricia', 0.008349353),
        ('Patty', 0.000383493),
        ('Paula', 0.002478284),
        ('Peggy', 0.000810606),
        ('Penny', 0.000836564),
        ('Phyllis', 0.000562437),
        ('Priscilla', 0.000350226),
        ('Rachael', 0.001098128),
        ('Rachel', 0.00876108),
        ('Raven', 0.000404855),
        ('Rebecca', 0.010563161),
        ('Rebekah', 0.000858581),
        ('Regina', 0.001941739),
        ('Renee', 0.00257883),
        ('Rhonda', 0.002879221),
        ('Rita', 0.000719187),
        ('Roberta', 0.000461715),
        ('Robin', 0.00409199),
        ('Robyn', 0.00032138),
        ('Rose', 0.000697125),
        ('Ruth', 0.001041946),
        ('Sabrina', 0.001920969),
        ('Sally', 0.000532912),
        ('Samantha', 0.008186124),
        ('Sandra', 0.006473426),
        ('Sandy', 0.000497106),
        ('Sara', 0.005619879),
        ('Sarah', 0.014434273),
        ('Savannah', 0.000978344),
        ('Selena', 0.000329106),
        ('Shannon', 0.005952552),
        ('Shari', 0.000449043),
        ('Sharon', 0.004796469),
        ('Shawna', 0.000354209),
        ('Sheena', 0.000355763),
        ('Sheila', 0.00220129),
        ('Shelby', 0.001575601),
        ('Shelia', 0.000403673),
        ('Shelley', 0.000922227),
        ('Shelly', 0.001339469),
        ('Sheri', 0.000913166),
        ('Sherri', 0.001285038),
        ('Sherry', 0.002445235),
        ('Sheryl', 0.00057025),
        ('Shirley', 0.000833259),
        ('Sierra', 0.000954816),
        ('Sonia', 0.000332739),
        ('Sonya', 0.000914085),
        ('Sophia', 0.000535976),
        ('Stacey', 0.002836761),
        ('Stacie', 0.0003903),
        ('Stacy', 0.00311717),
        ('Stefanie', 0.00034644),
        ('Stephanie', 0.013595762),
        ('Sue', 0.000472877),
        ('Summer', 0.000411508),
        ('Susan', 0.0088973),
        ('Suzanne', 0.001943577),
        ('Sydney', 0.001220101),
        ('Sylvia', 0.000625798),
        ('Tabitha', 0.000428404),
        ('Tamara', 0.00212948),
        ('Tami', 0.000403651),
        ('Tammie', 0.00042337),
        ('Tammy', 0.006493584),
        ('Tanya', 0.002039024),
        ('Tara', 0.00316834),
        ('Tasha', 0.000355807),
        ('Taylor', 0.003996871),
        ('Teresa', 0.005060003),
        ('Terri', 0.001823903),
        ('Terry', 0.00060494),
        ('Theresa', 0.003492762),
        ('Tiffany', 0.006594283),
        ('Tina', 0.005186419),
        ('Toni', 0.000891695),
        ('Tonya', 0.002404133),
        ('Tracey', 0.001511146),
        ('Traci', 0.00086193),
        ('Tracie', 0.000301901),
        ('Tracy', 0.00498572),
        ('Tricia', 0.000449196),
        ('Valerie', 0.003218022),
        ('Vanessa', 0.003779189),
        ('Veronica', 0.003017805),
        ('Vicki', 0.00088653),
        ('Vickie', 0.000695199),
        ('Victoria', 0.005237677),
        ('Virginia', 0.001496482),
        ('Wanda', 0.001336186),
        ('Wendy', 0.004058263),
        ('Whitney', 0.001690768),
        ('Yesenia', 0.000331951),
        ('Yolanda', 0.001213819),
        ('Yvette', 0.000483427),
        ('Yvonne', 0.001005483),
        ('Zoe', 0.000367407),
    ))

    first_names_male = OrderedDict((
        ('Aaron', 0.006741589),
        ('Adam', 0.007124922),
        ('Adrian', 0.001521889),
        ('Alan', 0.002344657),
        ('Albert', 0.001316595),
        ('Alec', 0.000442958),
        ('Alejandro', 0.000862489),
        ('Alex', 0.002111833),
        ('Alexander', 0.005215733),
        ('Alexis', 0.000277915),
        ('Alfred', 0.000318919),
        ('Allen', 0.001679613),
        ('Alvin', 0.00024794),
        ('Andre', 0.001400621),
        ('Andres', 0.000335574),
        ('Andrew', 0.013475074),
        ('Angel', 0.000902262),
        ('Anthony', 0.013783357),
        ('Antonio', 0.002392535),
        ('Arthur', 0.001342637),
        ('Austin', 0.003785615),
        ('Barry', 0.001102751),
        ('Benjamin', 0.006535474),
        ('Bernard', 0.000298691),
        ('Bill', 0.000430013),
        ('Billy', 0.001749806),
        ('Blake', 0.001218155),
        ('Bob', 0.000235731),
        ('Bobby', 0.001666977),
        ('Brad', 0.000984544),
        ('Bradley', 0.003845018),
        ('Brady', 0.000277522),
        ('Brandon', 0.009518346),
        ('Brendan', 0.000736758),
        ('Brent', 0.001889131),
        ('Brett', 0.002248371),
        ('Brian', 0.01597677),
        ('Bruce', 0.001883335),
        ('Bryan', 0.00456454),
        ('Bryce', 0.000457406),
        ('Caleb', 0.001485861),
        ('Calvin', 0.001168738),
        ('Cameron', 0.00180755),
        ('Carl', 0.002011802),
        ('Carlos', 0.00266638),
        ('Casey', 0.001440035),
        ('Cesar', 0.000304898),
        ('Chad', 0.003858817),
        ('Charles', 0.010889881),
        ('Chase', 0.000971942),
        ('Chris', 0.001389507),
        ('Christian', 0.003097779),
        ('Christopher', 0.02783596),
        ('Clarence', 0.000299289),
        ('Clayton', 0.000662222),
        ('Clifford', 0.00053078),
        ('Clinton', 0.000579307),
        ('Cody', 0.00353482),
        ('Cole', 0.000578811),
        ('Colin', 0.00078508),
        ('Collin', 0.000406057),
        ('Colton', 0.000520845),
        ('Connor', 0.000981073),
        ('Corey', 0.002476612),
        ('Cory', 0.001813005),
        ('Craig', 0.00338161),
        ('Cristian', 0.000333847),
        ('Curtis', 0.002140235),
        ('Dakota', 0.000797614),
        ('Dale', 0.001171354),
        ('Dalton', 0.000615113),
        ('Damon', 0.00034308),
        ('Dan', 0.000388496),
        ('Daniel', 0.018881874),
        ('Danny', 0.001873879),
        ('Darin', 0.000234962),
        ('Darius', 0.000336189),
        ('Darrell', 0.001218582),
        ('Darren', 0.001253738),
        ('Darryl', 0.00067019),
        ('Daryl', 0.000260918),
        ('Dave', 0.000269673),
        ('David', 0.031073833),
        ('Dean', 0.000965375),
        ('Dennis', 0.003318992),
        ('Derek', 0.003095299),
        ('Derrick', 0.001955921),
        ('Devin', 0.001312474),
        ('Devon', 0.000485877),
        ('Dillon', 0.000558361),
        ('Dominic', 0.000438221),
        ('Don', 0.000378322),
        ('Donald', 0.005689572),
        ('Douglas', 0.004513687),
        ('Drew', 0.000596868),
        ('Duane', 0.00061855),
        ('Dustin', 0.003088938),
        ('Dwayne', 0.000711382),
        ('Dylan', 0.002329096),
        ('Earl', 0.000348347),
        ('Eddie', 0.0007944),
        ('Edgar', 0.000379536),
        ('Eduardo', 0.000465358),
        ('Edward', 0.005702242),
        ('Edwin', 0.001117833),
        ('Elijah', 0.000592183),
        ('Eric', 0.012024659),
        ('Erik', 0.001997096),
        ('Ernest', 0.000746556),
        ('Ethan', 0.001143978),
        ('Eugene', 0.000784243),
        ('Evan', 0.001570691),
        ('Fernando', 0.000557608),
        ('Francis', 0.000330837),
        ('Francisco', 0.001084335),
        ('Frank', 0.003276449),
        ('Franklin', 0.000237561),
        ('Fred', 0.000396618),
        ('Frederick', 0.001104188),
        ('Gabriel', 0.001906504),
        ('Garrett', 0.001124861),
        ('Gary', 0.005023109),
        ('Gavin', 0.000295373),
        ('Gene', 0.00023426),
        ('Geoffrey', 0.000425978),
        ('George', 0.004423984),
        ('Gerald', 0.00165841),
        ('Gilbert', 0.000246726),
        ('Glen', 0.000374338),
        ('Glenn', 0.001111421),
        ('Gordon', 0.00027075),
        ('Grant', 0.00068322),
        ('Greg', 0.000623492),
        ('Gregg', 0.000235885),
        ('Gregory', 0.007676443),
        ('Guy', 0.000262645),
        ('Harold', 0.000929467),
        ('Harry', 0.000586934),
        ('Hayden', 0.000279454),
        ('Hector', 0.000798691),
        ('Henry', 0.001856232),
        ('Herbert', 0.000234226),
        ('Howard', 0.000712921),
        ('Hunter', 0.001034679),
        ('Ian', 0.001863192),
        ('Isaac', 0.001001951),
        ('Isaiah', 0.000625441),
        ('Ivan', 0.000350433),
        ('Jack', 0.001839748),
        ('Jackson', 0.000403253),
        ('Jacob', 0.007845384),
        ('Jaime', 0.000421378),
        ('Jake', 0.000565782),
        ('James', 0.029601617),
        ('Jamie', 0.00093552),
        ('Jared', 0.002538802),
        ('Jason', 0.01520513),
        ('Javier', 0.000625202),
        ('Jay', 0.001411462),
        ('Jeff', 0.001271436),
        ('Jeffery', 0.002627873),
        ('Jeffrey', 0.01225709),
        ('Jeremiah', 0.001209605),
        ('Jeremy', 0.006336079),
        ('Jermaine', 0.000450156),
        ('Jerome', 0.000634299),
        ('Jerry', 0.003150273),
        ('Jesse', 0.003884552),
        ('Jesus', 0.001628965),
        ('Jim', 0.000567714),
        ('Jimmy', 0.001607489),
        ('Joe', 0.001621544),
        ('Joel', 0.002537742),
        ('John', 0.028683008),
        ('Johnathan', 0.000840448),
        ('Johnny', 0.002117065),
        ('Jon', 0.001561184),
        ('Jonathan', 0.009963971),
        ('Jonathon', 0.000701157),
        ('Jordan', 0.003451546),
        ('Jorge', 0.001180553),
        ('Jose', 0.005368207),
        ('Joseph', 0.018604763),
        ('Joshua', 0.014808101),
        ('Juan', 0.003233598),
        ('Julian', 0.000693736),
        ('Justin', 0.010197889),
        ('Karl', 0.000362437),
        ('Keith', 0.004622866),
        ('Kelly', 0.000775283),
        ('Kenneth', 0.008318145),
        ('Kent', 0.000329418),
        ('Kerry', 0.000261448),
        ('Kevin', 0.014324157),
        ('Kirk', 0.0003801),
        ('Kristopher', 0.000580692),
        ('Kurt', 0.000716375),
        ('Kyle', 0.006350049),
        ('Lance', 0.001048495),
        ('Larry', 0.003658807),
        ('Lawrence', 0.001670294),
        ('Lee', 0.001223883),
        ('Leon', 0.000236347),
        ('Leonard', 0.000756713),
        ('Leroy', 0.000260234),
        ('Leslie', 0.000234637),
        ('Levi', 0.000347184),
        ('Logan', 0.001325812),
        ('Lonnie', 0.000258576),
        ('Louis', 0.001212255),
        ('Lucas', 0.001098237),
        ('Luis', 0.002427777),
        ('Luke', 0.001221455),
        ('Malik', 0.000306813),
        ('Manuel', 0.001331369),
        ('Marc', 0.001431947),
        ('Marco', 0.000290586),
        ('Marcus', 0.002604122),
        ('Mario', 0.001229337),
        ('Mark', 0.014382277),
        ('Martin', 0.002085226),
        ('Marvin', 0.000732962),
        ('Mason', 0.000562037),
        ('Mathew', 0.000605555),
        ('Matthew', 0.020425018),
        ('Maurice', 0.000777078),
        ('Max', 0.000311276),
        ('Maxwell', 0.000357478),
        ('Melvin', 0.00061932),
        ('Michael', 0.045602241),
        ('Micheal', 0.001273847),
        ('Miguel', 0.001416267),
        ('Mike', 0.001221797),
        ('Mitchell', 0.001747788),
        ('Nathan', 0.005039405),
        ('Nathaniel', 0.001887558),
        ('Neil', 0.000240331),
        ('Nicholas', 0.010021219),
        ('Nicolas', 0.000362522),
        ('Noah', 0.000960947),
        ('Norman', 0.000389043),
        ('Omar', 0.000639052),
        ('Oscar', 0.000946583),
        ('Parker', 0.000277522),
        ('Patrick', 0.007153255),
        ('Paul', 0.009272953),
        ('Pedro', 0.000275726),
        ('Perry', 0.000258644),
        ('Peter', 0.004340385),
        ('Philip', 0.002262956),
        ('Phillip', 0.00280273),
        ('Preston', 0.000292022),
        ('Ralph', 0.000836891),
        ('Randall', 0.001614722),
        ('Randy', 0.003021926),
        ('Ray', 0.000379451),
        ('Raymond', 0.003493952),
        ('Reginald', 0.00095108),
        ('Ricardo', 0.001197276),
        ('Richard', 0.014131961),
        ('Rick', 0.000440016),
        ('Rickey', 0.00023833),
        ('Ricky', 0.001856882),
        ('Riley', 0.000322031),
        ('Robert', 0.026938092),
        ('Roberto', 0.000906024),
        ('Rodney', 0.002180555),
        ('Roger', 0.002038032),
        ('Ronald', 0.00576775),
        ('Ronnie', 0.000905938),
        ('Ross', 0.00026863),
        ('Roy', 0.001311346),
        ('Ruben', 0.000774821),
        ('Russell', 0.002096221),
        ('Ryan', 0.01128178),
        ('Samuel', 0.00498019),
        ('Scott', 0.010580999),
        ('Sean', 0.005593456),
        ('Sergio', 0.000568518),
        ('Seth', 0.001537416),
        ('Shane', 0.002530218),
        ('Shannon', 0.000421583),
        ('Shaun', 0.000748761),
        ('Shawn', 0.004474546),
        ('Spencer', 0.000912094),
        ('Stanley', 0.000739032),
        ('Stephen', 0.007675365),
        ('Steve', 0.001407564),
        ('Steven', 0.013292898),
        ('Stuart', 0.000238826),
        ('Tanner', 0.000639292),
        ('Taylor', 0.00133036),
        ('Terrance', 0.000203311),
        ('Terrence', 0.000203704),
        ('Terry', 0.002873624),
        ('Theodore', 0.000596561),
        ('Thomas', 0.0143364),
        ('Tim', 0.000711126),
        ('Timothy', 0.012632608),
        ('Todd', 0.00414612),
        ('Tom', 0.000499283),
        ('Tommy', 0.000778737),
        ('Tony', 0.002511563),
        ('Tracy', 0.000728259),
        ('Travis', 0.004022458),
        ('Trevor', 0.001692523),
        ('Tristan', 0.000408759),
        ('Troy', 0.002695415),
        ('Tyler', 0.005962323),
        ('Tyrone', 0.000587207),
        ('Vernon', 0.000246401),
        ('Victor', 0.002340621),
        ('Vincent', 0.002494515),
        ('Walter', 0.001525891),
        ('Warren', 0.000317414),
        ('Wayne', 0.00160966),
        ('Wesley', 0.001733835),
        ('William', 0.020025989),
        ('Willie', 0.001379247),
        ('Wyatt', 0.000306591),
        ('Xavier', 0.000415222),
        ('Zachary', 0.005918634),
    ))

    first_names = first_names_male.copy()
    first_names.update(first_names_female)

    first_names_nonbinary = first_names_male.copy()
    first_names_nonbinary.update(first_names_female)

    # Top 1000 US surnames from US Census data
    # Weighted by number of occurrences
    # By way of http://names.mongabay.com/data/1000.html on 2/10/2016
    last_names = OrderedDict((
        ('Smith', 0.021712045),
        ('Johnson', 0.01696938),
        ('Williams', 0.014016962),
        ('Brown', 0.012610763),
        ('Jones', 0.012451866),
        ('Miller', 0.010305045),
        ('Davis', 0.009798219),
        ('Garcia', 0.007842422),
        ('Rodriguez', 0.007348561),
        ('Wilson', 0.007154951),
        ('Martinez', 0.007082045),
        ('Anderson', 0.006966203),
        ('Taylor', 0.006582218),
        ('Thomas', 0.006493824),
        ('Hernandez', 0.006454314),
        ('Moore', 0.006383948),
        ('Martin', 0.006146745),
        ('Jackson', 0.006086567),
        ('Thompson', 0.005887767),
        ('White', 0.005843424),
        ('Lopez', 0.005679145),
        ('Lee', 0.005535909),
        ('Gonzalez', 0.005461513),
        ('Harris', 0.005423356),
        ('Clark', 0.005010598),
        ('Lewis', 0.00465937),
        ('Robinson', 0.004596305),
        ('Walker', 0.004580579),
        ('Perez', 0.00446375),
        ('Hall', 0.004327121),
        ('Young', 0.004257495),
        ('Allen', 0.00423392),
        ('Sanchez', 0.004031749),
        ('Wright', 0.004023754),
        ('King', 0.004011135),
        ('Scott', 0.003838487),
        ('Green', 0.003778053),
        ('Baker', 0.003776901),
        ('Adams', 0.00377448),
        ('Nelson', 0.003766713),
        ('Hill', 0.003762455),
        ('Ramirez', 0.003554281),
        ('Campbell', 0.003398636),
        ('Mitchell', 0.003357336),
        ('Roberts', 0.003346207),
        ('Carter', 0.0033127),
        ('Phillips', 0.003214932),
        ('Evans', 0.003127113),
        ('Turner', 0.003067045),
        ('Torres', 0.002971158),
        ('Parker', 0.002962725),
        ('Collins', 0.002904264),
        ('Edwards', 0.002897155),
        ('Stewart', 0.002859044),
        ('Flores', 0.002856449),
        ('Morris', 0.002848582),
        ('Nguyen', 0.002833697),
        ('Murphy', 0.00274576),
        ('Rivera', 0.002736275),
        ('Cook', 0.002693623),
        ('Rogers', 0.002690041),
        ('Morgan', 0.002525543),
        ('Peterson', 0.002513125),
        ('Cooper', 0.00246795),
        ('Reed', 0.0024437),
        ('Bailey', 0.002429747),
        ('Bell', 0.002419112),
        ('Gomez', 0.002408494),
        ('Kelly', 0.002379209),
        ('Howard', 0.002327986),
        ('Ward', 0.002321973),
        ('Cox', 0.002318775),
        ('Diaz', 0.00230051),
        ('Richardson', 0.002280051),
        ('Wood', 0.002259639),
        ('Watson', 0.002215168),
        ('Brooks', 0.002199808),
        ('Bennett', 0.002184311),
        ('Gray', 0.002162912),
        ('James', 0.002131032),
        ('Reyes', 0.002124517),
        ('Cruz', 0.002111304),
        ('Hughes', 0.002095999),
        ('Price', 0.002090206),
        ('Myers', 0.002054278),
        ('Long', 0.002042126),
        ('Foster', 0.002019703),
        ('Sanders', 0.002018442),
        ('Ross', 0.002009844),
        ('Morales', 0.001988655),
        ('Powell', 0.001978704),
        ('Sullivan', 0.001970362),
        ('Russell', 0.001968461),
        ('Ortiz', 0.001961617),
        ('Jenkins', 0.001952974),
        ('Gutierrez', 0.001945371),
        ('Perry', 0.001942986),
        ('Butler', 0.001926859),
        ('Barnes', 0.00192272),
        ('Fisher', 0.001921377),
        ('Henderson', 0.001919686),
        ('Coleman', 0.001906255),
        ('Simmons', 0.001842531),
        ('Patterson', 0.00181427),
        ('Jordan', 0.00180198),
        ('Reynolds', 0.001787233),
        ('Hamilton', 0.001775656),
        ('Graham', 0.001773307),
        ('Kim', 0.001773243),
        ('Gonzales', 0.001772028),
        ('Alexander', 0.001767542),
        ('Ramos', 0.001764371),
        ('Wallace', 0.001743026),
        ('Griffin', 0.001741893),
        ('West', 0.001722047),
        ('Cole', 0.001715916),
        ('Hayes', 0.001712992),
        ('Chavez', 0.001698299),
        ('Gibson', 0.001685096),
        ('Bryant', 0.001679075),
        ('Ellis', 0.001662381),
        ('Stevens', 0.001657657),
        ('Murray', 0.001630218),
        ('Ford', 0.001630062),
        ('Marshall', 0.001619244),
        ('Owens', 0.001611212),
        ('Mcdonald', 0.001609019),
        ('Harrison', 0.001604295),
        ('Ruiz', 0.001602943),
        ('Kennedy', 0.001568285),
        ('Wells', 0.001559139),
        ('Alvarez', 0.001542527),
        ('Woods', 0.0015425),
        ('Mendoza', 0.001540243),
        ('Castillo', 0.001511972),
        ('Olson', 0.001493963),
        ('Webb', 0.001493771),
        ('Washington', 0.001489705),
        ('Tucker', 0.001488763),
        ('Freeman', 0.001486507),
        ('Burns', 0.001481636),
        ('Henry', 0.001474683),
        ('Vasquez', 0.001461863),
        ('Snyder', 0.001456143),
        ('Simpson', 0.001445891),
        ('Crawford', 0.001444795),
        ('Jimenez', 0.001438892),
        ('Porter', 0.001433163),
        ('Mason', 0.0014207),
        ('Shaw', 0.001417849),
        ('Gordon', 0.001415674),
        ('Wagner', 0.001411855),
        ('Hunter', 0.001410886),
        ('Romero', 0.001405057),
        ('Hicks', 0.00140365),
        ('Dixon', 0.001389003),
        ('Hunt', 0.001388738),
        ('Palmer', 0.00137431),
        ('Robertson', 0.001373323),
        ('Black', 0.001372291),
        ('Holmes', 0.001372108),
        ('Stone', 0.001368782),
        ('Meyer', 0.001367521),
        ('Boyd', 0.001365803),
        ('Mills', 0.001351485),
        ('Warren', 0.001351458),
        ('Fox', 0.001346441),
        ('Rose', 0.001342485),
        ('Rice', 0.001338062),
        ('Moreno', 0.001334846),
        ('Schmidt', 0.001330067),
        ('Patel', 0.001325508),
        ('Ferguson', 0.001299832),
        ('Nichols', 0.001296908),
        ('Herrera', 0.0012864),
        ('Medina', 0.001273307),
        ('Ryan', 0.001273142),
        ('Fernandez', 0.001272841),
        ('Weaver', 0.001268354),
        ('Daniels', 0.001268034),
        ('Stephens', 0.001267724),
        ('Gardner', 0.001266974),
        ('Payne', 0.0012612),
        ('Kelley', 0.001256878),
        ('Dunn', 0.001251395),
        ('Pierce', 0.001247393),
        ('Arnold', 0.001245547),
        ('Tran', 0.001243537),
        ('Spencer', 0.001228443),
        ('Peters', 0.001226505),
        ('Hawkins', 0.001224998),
        ('Grant', 0.001224705),
        ('Hansen', 0.001219589),
        ('Castro', 0.001217578),
        ('Hoffman', 0.001212014),
        ('Hart', 0.001210378),
        ('Elliott', 0.001210296),
        ('Cunningham', 0.00120517),
        ('Knight', 0.001204841),
        ('Bradley', 0.001199624),
        ('Carroll', 0.001197166),
        ('Hudson', 0.001195091),
        ('Duncan', 0.001191674),
        ('Armstrong', 0.001187681),
        ('Berry', 0.001182409),
        ('Andrews', 0.001181632),
        ('Johnston', 0.001178114),
        ('Ray', 0.001176826),
        ('Lane', 0.001176214),
        ('Riley', 0.001169206),
        ('Carpenter', 0.001161101),
        ('Perkins', 0.001159986),
        ('Aguilar', 0.001154942),
        ('Silva', 0.001152795),
        ('Richards', 0.001148126),
        ('Willis', 0.001147888),
        ('Matthews', 0.001140688),
        ('Chapman', 0.001138632),
        ('Lawrence', 0.001135955),
        ('Garza', 0.00113421),
        ('Vargas', 0.001132583),
        ('Watkins', 0.001118832),
        ('Wheeler', 0.00111186),
        ('Larson', 0.001106195),
        ('Carlson', 0.001097606),
        ('Harper', 0.001095267),
        ('George', 0.001094444),
        ('Greene', 0.001092855),
        ('Burke', 0.001088935),
        ('Guzman', 0.001081762),
        ('Morrison', 0.001077641),
        ('Munoz', 0.001076133),
        ('Jacobs', 0.001055721),
        ('Obrien', 0.001054304),
        ('Lawson', 0.001052486),
        ('Franklin', 0.001049498),
        ('Lynch', 0.001045743),
        ('Bishop', 0.00104196),
        ('Carr', 0.001040662),
        ('Salazar', 0.001036788),
        ('Austin', 0.001033974),
        ('Mendez', 0.0010301),
        ('Gilbert', 0.001027084),
        ('Jensen', 0.001026408),
        ('Williamson', 0.001025348),
        ('Montgomery', 0.00102469),
        ('Harvey', 0.001024617),
        ('Oliver', 0.001020094),
        ('Howell', 0.001001756),
        ('Dean', 0.000998064),
        ('Hanson', 0.000996685),
        ('Weber', 0.000985601),
        ('Garrett', 0.000984788),
        ('Sims', 0.000979918),
        ('Burton', 0.000979132),
        ('Fuller', 0.000974783),
        ('Soto', 0.000974317),
        ('Mccoy', 0.000972946),
        ('Welch', 0.00096676),
        ('Chen', 0.000964384),
        ('Schultz', 0.000959067),
        ('Walters', 0.000952844),
        ('Reid', 0.00095034),
        ('Fields', 0.00094335),
        ('Walsh', 0.000943113),
        ('Little', 0.000938563),
        ('Fowler', 0.000937667),
        ('Bowman', 0.000934186),
        ('Davidson', 0.000932404),
        ('May', 0.000929498),
        ('Day', 0.000929041),
        ('Schneider', 0.00091878),
        ('Newman', 0.000918214),
        ('Brewer', 0.000917976),
        ('Lucas', 0.000917538),
        ('Holland', 0.000912677),
        ('Wong', 0.000908172),
        ('Banks', 0.000907276),
        ('Santos', 0.000904526),
        ('Curtis', 0.000904206),
        ('Pearson', 0.000902105),
        ('Delgado', 0.000901621),
        ('Valdez', 0.000901027),
        ('Pena', 0.000898605),
        ('Rios', 0.000882377),
        ('Douglas', 0.000881062),
        ('Sandoval', 0.000879947),
        ('Barrett', 0.000876228),
        ('Hopkins', 0.000864414),
        ('Keller', 0.000861645),
        ('Guerrero', 0.000860293),
        ('Stanley', 0.000857232),
        ('Bates', 0.000856555),
        ('Alvarado', 0.000856373),
        ('Beck', 0.000851238),
        ('Ortega', 0.000850963),
        ('Wade', 0.00084825),
        ('Estrada', 0.000848222),
        ('Contreras', 0.00084666),
        ('Barnett', 0.000843252),
        ('Caldwell', 0.00083458),
        ('Santiago', 0.00083119),
        ('Lambert', 0.000828001),
        ('Powers', 0.000826019),
        ('Chambers', 0.000825324),
        ('Nunez', 0.000824255),
        ('Craig', 0.000818618),
        ('Leonard', 0.000815027),
        ('Lowe', 0.000814844),
        ('Rhodes', 0.000812459),
        ('Byrd', 0.00081149),
        ('Gregory', 0.000811481),
        ('Shelton', 0.000807059),
        ('Frazier', 0.00080705),
        ('Becker', 0.000805122),
        ('Maldonado', 0.000804226),
        ('Fleming', 0.000803614),
        ('Vega', 0.000801595),
        ('Sutton', 0.000798351),
        ('Cohen', 0.000797008),
        ('Jennings', 0.00079529),
        ('Parks', 0.000788967),
        ('Mcdaniel', 0.000788702),
        ('Watts', 0.000787889),
        ('Barker', 0.000778688),
        ('Norris', 0.000778605),
        ('Vaughn', 0.000777006),
        ('Vazquez', 0.000775992),
        ('Holt', 0.000774018),
        ('Schwartz', 0.000773918),
        ('Steele', 0.000770756),
        ('Benson', 0.00076966),
        ('Neal', 0.000766151),
        ('Dominguez', 0.000765073),
        ('Horton', 0.000763173),
        ('Terry', 0.000762387),
        ('Wolfe', 0.000759417),
        ('Hale', 0.000757983),
        ('Lyons', 0.000751614),
        ('Graves', 0.000750892),
        ('Haynes', 0.000749595),
        ('Miles', 0.000748644),
        ('Park', 0.000748251),
        ('Warner', 0.000747648),
        ('Padilla', 0.000747475),
        ('Bush', 0.000744907),
        ('Thornton', 0.000741864),
        ('Mccarthy', 0.000740439),
        ('Mann', 0.00074032),
        ('Zimmerman', 0.000739608),
        ('Erickson', 0.000739534),
        ('Fletcher', 0.000739498),
        ('Mckinney', 0.00073661),
        ('Page', 0.000735487),
        ('Dawson', 0.000732718),
        ('Joseph', 0.000731256),
        ('Marquez', 0.000730534),
        ('Reeves', 0.00072931),
        ('Klein', 0.000728104),
        ('Espinoza', 0.000724787),
        ('Baldwin', 0.000723224),
        ('Moran', 0.000717696),
        ('Love', 0.000715659),
        ('Robbins', 0.000713996),
        ('Higgins', 0.000713685),
        ('Ball', 0.000708696),
        ('Cortez', 0.000708066),
        ('Le', 0.000707709),
        ('Griffith', 0.00070749),
        ('Bowen', 0.000704283),
        ('Sharp', 0.000702364),
        ('Cummings', 0.000700893),
        ('Ramsey', 0.000700144),
        ('Hardy', 0.000699988),
        ('Swanson', 0.000699358),
        ('Barber', 0.000699038),
        ('Acosta', 0.000698791),
        ('Luna', 0.000695593),
        ('Chandler', 0.000695474),
        ('Daniel', 0.000686529),
        ('Blair', 0.000686529),
        ('Cross', 0.00068652),
        ('Simon', 0.000683824),
        ('Dennis', 0.000683322),
        ('Oconnor', 0.000683066),
        ('Quinn', 0.00068101),
        ('Gross', 0.000678762),
        ('Navarro', 0.000675884),
        ('Moss', 0.000673874),
        ('Fitzgerald', 0.000671791),
        ('Doyle', 0.000671754),
        ('Mclaughlin', 0.000668191),
        ('Rojas', 0.00066767),
        ('Rodgers', 0.000667213),
        ('Stevenson', 0.000666034),
        ('Singh', 0.00066375),
        ('Yang', 0.000663613),
        ('Figueroa', 0.000662754),
        ('Harmon', 0.000661667),
        ('Newton', 0.000660881),
        ('Paul', 0.00066015),
        ('Manning', 0.000658514),
        ('Garner', 0.000658359),
        ('Mcgee', 0.000657198),
        ('Reese', 0.000655636),
        ('Francis', 0.000655353),
        ('Burgess', 0.000654265),
        ('Adkins', 0.000653571),
        ('Goodman', 0.000653151),
        ('Curry', 0.00065189),
        ('Brady', 0.000650345),
        ('Christensen', 0.000650062),
        ('Potter', 0.000649688),
        ('Walton', 0.000648719),
        ('Goodwin', 0.000642652),
        ('Mullins', 0.000642222),
        ('Molina', 0.000641537),
        ('Webster', 0.000640733),
        ('Fischer', 0.000640477),
        ('Campos', 0.000639152),
        ('Avila', 0.000638175),
        ('Sherman', 0.000638147),
        ('Todd', 0.000637873),
        ('Chang', 0.00063738),
        ('Blake', 0.000633021),
        ('Malone', 0.00063282),
        ('Wolf', 0.000629604),
        ('Hodges', 0.000629266),
        ('Juarez', 0.000628507),
        ('Gill', 0.000627722),
        ('Farmer', 0.000624158),
        ('Hines', 0.00062266),
        ('Gallagher', 0.00062202),
        ('Duran', 0.000621755),
        ('Hubbard', 0.000621527),
        ('Cannon', 0.000620631),
        ('Miranda', 0.0006181),
        ('Wang', 0.000617406),
        ('Saunders', 0.000614116),
        ('Tate', 0.000614098),
        ('Mack', 0.000613604),
        ('Hammond', 0.000612773),
        ('Carrillo', 0.000612691),
        ('Townsend', 0.000610854),
        ('Wise', 0.000609803),
        ('Ingram', 0.000609136),
        ('Barton', 0.000608743),
        ('Mejia', 0.000607939),
        ('Ayala', 0.000607766),
        ('Schroeder', 0.000606825),
        ('Hampton', 0.000606514),
        ('Rowe', 0.000604933),
        ('Parsons', 0.000604915),
        ('Frank', 0.000602311),
        ('Waters', 0.000601388),
        ('Strickland', 0.000601361),
        ('Osborne', 0.000601251),
        ('Maxwell', 0.000601041),
        ('Chan', 0.000600493),
        ('Deleon', 0.000599387),
        ('Norman', 0.000596381),
        ('Harrington', 0.00059512),
        ('Casey', 0.000592232),
        ('Patton', 0.00059184),
        ('Logan', 0.000590049),
        ('Bowers', 0.000589318),
        ('Mueller', 0.000587572),
        ('Glover', 0.00058643),
        ('Floyd', 0.000586074),
        ('Hartman', 0.000583205),
        ('Buchanan', 0.000583187),
        ('Cobb', 0.000582401),
        ('French', 0.00057701),
        ('Kramer', 0.000575858),
        ('Mccormick', 0.000572569),
        ('Clarke', 0.0005715),
        ('Tyler', 0.00057139),
        ('Gibbs', 0.000571208),
        ('Moody', 0.000569654),
        ('Conner', 0.000569572),
        ('Sparks', 0.000568649),
        ('Mcguire', 0.000567571),
        ('Leon', 0.000566822),
        ('Bauer', 0.000566319),
        ('Norton', 0.000564729),
        ('Pope', 0.000564227),
        ('Flynn', 0.000564199),
        ('Hogan', 0.000563322),
        ('Robles', 0.00056303),
        ('Salinas', 0.000562692),
        ('Yates', 0.000561029),
        ('Lindsey', 0.000559192),
        ('Lloyd', 0.000558781),
        ('Marsh', 0.000557365),
        ('Mcbride', 0.000556222),
        ('Owen', 0.000552449),
        ('Solis', 0.000548648),
        ('Pham', 0.00054777),
        ('Lang', 0.000546802),
        ('Pratt', 0.000546418),
        ('Lara', 0.000545779),
        ('Brock', 0.000545331),
        ('Ballard', 0.00054513),
        ('Trujillo', 0.000544664),
        ('Shaffer', 0.000541173),
        ('Drake', 0.000539602),
        ('Roman', 0.000539282),
        ('Aguirre', 0.00053835),
        ('Morton', 0.000537162),
        ('Stokes', 0.000536239),
        ('Lamb', 0.000535033),
        ('Pacheco', 0.000534841),
        ('Patrick', 0.00053231),
        ('Cochran', 0.000532091),
        ('Shepherd', 0.000529368),
        ('Cain', 0.000528801),
        ('Burnett', 0.000528674),
        ('Hess', 0.000528335),
        ('Li', 0.000528007),
        ('Cervantes', 0.000527084),
        ('Olsen', 0.000524087),
        ('Briggs', 0.000523538),
        ('Ochoa', 0.000522743),
        ('Cabrera', 0.000522387),
        ('Velasquez', 0.000522314),
        ('Montoya', 0.00052151),
        ('Roth', 0.000521099),
        ('Meyers', 0.000518485),
        ('Cardenas', 0.000517334),
        ('Fuentes', 0.000515717),
        ('Weiss', 0.000513085),
        ('Wilkins', 0.000512309),
        ('Hoover', 0.000512309),
        ('Nicholson', 0.000511559),
        ('Underwood', 0.000511441),
        ('Short', 0.000510801),
        ('Carson', 0.000510052),
        ('Morrow', 0.000508617),
        ('Colon', 0.000507228),
        ('Holloway', 0.000506808),
        ('Summers', 0.000506123),
        ('Bryan', 0.000505008),
        ('Petersen', 0.00050424),
        ('Mckenzie', 0.000503318),
        ('Serrano', 0.000503071),
        ('Wilcox', 0.000502431),
        ('Carey', 0.000501856),
        ('Clayton', 0.000501408),
        ('Poole', 0.000499864),
        ('Calderon', 0.000499727),
        ('Gallegos', 0.000499553),
        ('Greer', 0.000498996),
        ('Rivas', 0.000498786),
        ('Guerra', 0.000498667),
        ('Decker', 0.000497525),
        ('Collier', 0.000497196),
        ('Wall', 0.000497077),
        ('Whitaker', 0.000496547),
        ('Bass', 0.000496117),
        ('Flowers', 0.000495944),
        ('Davenport', 0.000495295),
        ('Conley', 0.000495185),
        ('Houston', 0.00049365),
        ('Huff', 0.000492426),
        ('Copeland', 0.00049132),
        ('Hood', 0.00049101),
        ('Monroe', 0.000488616),
        ('Massey', 0.00048847),
        ('Roberson', 0.000486085),
        ('Combs', 0.00048592),
        ('Franco', 0.000485747),
        ('Larsen', 0.000483937),
        ('Pittman', 0.000481434),
        ('Randall', 0.000479661),
        ('Skinner', 0.000479616),
        ('Wilkinson', 0.000479552),
        ('Kirby', 0.00047946),
        ('Cameron', 0.00047915),
        ('Bridges', 0.000477514),
        ('Anthony', 0.000476472),
        ('Richard', 0.000476399),
        ('Kirk', 0.00047565),
        ('Bruce', 0.000475175),
        ('Singleton', 0.000473283),
        ('Mathis', 0.000473274),
        ('Bradford', 0.000472635),
        ('Boone', 0.000472205),
        ('Abbott', 0.000471666),
        ('Charles', 0.000470734),
        ('Allison', 0.000470606),
        ('Sweeney', 0.00047057),
        ('Atkinson', 0.000470469),
        ('Horn', 0.000469473),
        ('Jefferson', 0.0004693),
        ('Rosales', 0.000469071),
        ('York', 0.000469053),
        ('Christian', 0.000467618),
        ('Phelps', 0.000467408),
        ('Farrell', 0.000466869),
        ('Castaneda', 0.000466814),
        ('Nash', 0.000466193),
        ('Dickerson', 0.000466156),
        ('Bond', 0.000465818),
        ('Wyatt', 0.00046485),
        ('Foley', 0.000464649),
        ('Chase', 0.000463963),
        ('Gates', 0.000463698),
        ('Vincent', 0.000462602),
        ('Mathews', 0.000462419),
        ('Hodge', 0.000462136),
        ('Garrison', 0.000461268),
        ('Trevino', 0.000461012),
        ('Villarreal', 0.000460071),
        ('Heath', 0.000459669),
        ('Dalton', 0.00045838),
        ('Valencia', 0.000457101),
        ('Callahan', 0.000456178),
        ('Hensley', 0.000455566),
        ('Atkins', 0.000454616),
        ('Huffman', 0.000454461),
        ('Roy', 0.000454351),
        ('Boyer', 0.000453218),
        ('Shields', 0.000452807),
        ('Lin', 0.000451016),
        ('Hancock', 0.000450742),
        ('Grimes', 0.000449965),
        ('Glenn', 0.000449929),
        ('Cline', 0.000449252),
        ('Delacruz', 0.00044917),
        ('Camacho', 0.000447726),
        ('Dillon', 0.0004462),
        ('Parrish', 0.000446109),
        ('Oneill', 0.000444583),
        ('Melton', 0.000444017),
        ('Booth', 0.000443889),
        ('Kane', 0.000443404),
        ('Berg', 0.000442975),
        ('Harrell', 0.000442893),
        ('Pitts', 0.000442811),
        ('Savage', 0.000441943),
        ('Wiggins', 0.000441833),
        ('Brennan', 0.000441294),
        ('Salas', 0.000441166),
        ('Marks', 0.000441157),
        ('Russo', 0.00043974),
        ('Sawyer', 0.000438397),
        ('Baxter', 0.000437283),
        ('Golden', 0.000437118),
        ('Hutchinson', 0.000436844),
        ('Liu', 0.000435528),
        ('Walter', 0.000435071),
        ('Mcdowell', 0.000434258),
        ('Wiley', 0.000434048),
        ('Rich', 0.00043381),
        ('Humphrey', 0.000433746),
        ('Johns', 0.000432093),
        ('Koch', 0.000432065),
        ('Suarez', 0.000431599),
        ('Hobbs', 0.000431462),
        ('Beard', 0.000430621),
        ('Gilmore', 0.000429909),
        ('Ibarra', 0.000428492),
        ('Keith', 0.00042714),
        ('Macias', 0.000427067),
        ('Khan', 0.000426829),
        ('Andrade', 0.000426729),
        ('Ware', 0.000426546),
        ('Stephenson', 0.000426363),
        ('Henson', 0.000425879),
        ('Wilkerson', 0.000425843),
        ('Dyer', 0.000425559),
        ('Mcclure', 0.000424929),
        ('Blackwell', 0.000424838),
        ('Mercado', 0.000424308),
        ('Tanner', 0.000424079),
        ('Eaton', 0.000423997),
        ('Clay', 0.000422727),
        ('Barron', 0.000422106),
        ('Beasley', 0.00042195),
        ('Oneal', 0.000421786),
        ('Small', 0.000418944),
        ('Preston', 0.000418944),
        ('Wu', 0.000418624),
        ('Zamora', 0.000418542),
        ('Macdonald', 0.000418323),
        ('Vance', 0.000418149),
        ('Snow', 0.000417473),
        ('Mcclain', 0.000416294),
        ('Stafford', 0.000414366),
        ('Orozco', 0.000413818),
        ('Barry', 0.000411579),
        ('English', 0.00041147),
        ('Shannon', 0.000410282),
        ('Kline', 0.000410264),
        ('Jacobson', 0.000410026),
        ('Woodard', 0.000409624),
        ('Huang', 0.000408573),
        ('Kemp', 0.000408445),
        ('Mosley', 0.000408418),
        ('Prince', 0.000407888),
        ('Merritt', 0.00040776),
        ('Hurst', 0.000407404),
        ('Villanueva', 0.000407248),
        ('Roach', 0.000406188),
        ('Nolan', 0.000405887),
        ('Lam', 0.000405558),
        ('Yoder', 0.000404279),
        ('Mccullough', 0.000403164),
        ('Lester', 0.0004013),
        ('Santana', 0.000400898),
        ('Valenzuela', 0.000399938),
        ('Winters', 0.000399865),
        ('Barrera', 0.000399482),
        ('Orr', 0.000398988),
        ('Leach', 0.000398988),
        ('Berger', 0.000397983),
        ('Mckee', 0.000397974),
        ('Strong', 0.000396832),
        ('Conway', 0.000396512),
        ('Stein', 0.000395927),
        ('Whitehead', 0.000395735),
        ('Bullock', 0.000393095),
        ('Escobar', 0.000392492),
        ('Knox', 0.000392327),
        ('Meadows', 0.000391843),
        ('Solomon', 0.000391432),
        ('Velez', 0.000391258),
        ('Odonnell', 0.000391094),
        ('Kerr', 0.000390692),
        ('Stout', 0.000389878),
        ('Blankenship', 0.000389824),
        ('Browning', 0.000389632),
        ('Kent', 0.00038922),
        ('Lozano', 0.000388946),
        ('Bartlett', 0.000388444),
        ('Pruitt', 0.000387996),
        ('Buck', 0.000387795),
        ('Barr', 0.000387713),
        ('Gaines', 0.000387137),
        ('Durham', 0.000387101),
        ('Gentry', 0.000387028),
        ('Mcintyre', 0.000386826),
        ('Sloan', 0.000386333),
        ('Rocha', 0.000385036),
        ('Melendez', 0.000385036),
        ('Herman', 0.000384597),
        ('Sexton', 0.000384496),
        ('Moon', 0.000384332),
        ('Hendricks', 0.00038266),
        ('Rangel', 0.000382559),
        ('Stark', 0.000382514),
        ('Lowery', 0.00038075),
        ('Hardin', 0.000380695),
        ('Hull', 0.000380622),
        ('Sellers', 0.000379754),
        ('Ellison', 0.000378822),
        ('Calhoun', 0.000378758),
        ('Gillespie', 0.000378219),
        ('Mora', 0.000377808),
        ('Knapp', 0.000377068),
        ('Mccall', 0.000376739),
        ('Morse', 0.000375652),
        ('Dorsey', 0.000375579),
        ('Weeks', 0.000375113),
        ('Nielsen', 0.000374692),
        ('Livingston', 0.000374299),
        ('Leblanc', 0.000373925),
        ('Mclean', 0.00037345),
        ('Bradshaw', 0.000372746),
        ('Glass', 0.000372106),
        ('Middleton', 0.00037196),
        ('Buckley', 0.000371942),
        ('Schaefer', 0.000371549),
        ('Frost', 0.000370809),
        ('Howe', 0.000370562),
        ('House', 0.000369849),
        ('Mcintosh', 0.00036963),
        ('Ho', 0.000369265),
        ('Pennington', 0.000368588),
        ('Reilly', 0.000368324),
        ('Hebert', 0.000368077),
        ('Mcfarland', 0.00036772),
        ('Hickman', 0.000367538),
        ('Noble', 0.000367474),
        ('Spears', 0.000367346),
        ('Conrad', 0.000366423),
        ('Arias', 0.000366277),
        ('Galvan', 0.000365911),
        ('Velazquez', 0.000365765),
        ('Huynh', 0.000365591),
        ('Frederick', 0.000364659),
        ('Randolph', 0.000363134),
        ('Cantu', 0.000361845),
        ('Fitzpatrick', 0.000360931),
        ('Mahoney', 0.000360374),
        ('Peck', 0.000360301),
        ('Villa', 0.000360027),
        ('Michael', 0.000359725),
        ('Donovan', 0.000358821),
        ('Mcconnell', 0.000358209),
        ('Walls', 0.00035787),
        ('Boyle', 0.000357642),
        ('Mayer', 0.000357368),
        ('Zuniga', 0.000356875),
        ('Giles', 0.000356372),
        ('Pineda', 0.000356345),
        ('Pace', 0.000356125),
        ('Hurley', 0.000356089),
        ('Mays', 0.000355568),
        ('Mcmillan', 0.000355403),
        ('Crosby', 0.000354928),
        ('Ayers', 0.000354855),
        ('Case', 0.000354152),
        ('Bentley', 0.00035374),
        ('Shepard', 0.000353658),
        ('Everett', 0.000353631),
        ('Pugh', 0.00035353),
        ('David', 0.000353238),
        ('Mcmahon', 0.000352306),
        ('Dunlap', 0.000351931),
        ('Bender', 0.000351456),
        ('Hahn', 0.000350451),
        ('Harding', 0.000350323),
        ('Acevedo', 0.000349336),
        ('Raymond', 0.00034866),
        ('Blackburn', 0.000348468),
        ('Duffy', 0.000346869),
        ('Landry', 0.00034686),
        ('Dougherty', 0.00034633),
        ('Bautista', 0.000345818),
        ('Shah', 0.00034569),
        ('Potts', 0.000344356),
        ('Arroyo', 0.000344274),
        ('Valentine', 0.000344192),
        ('Meza', 0.000344128),
        ('Gould', 0.00034411),
        ('Vaughan', 0.000343479),
        ('Fry', 0.000343032),
        ('Rush', 0.000342374),
        ('Avery', 0.0003421),
        ('Herring', 0.000341305),
        ('Dodson', 0.000340802),
        ('Clements', 0.000340245),
        ('Sampson', 0.000340217),
        ('Tapia', 0.000339916),
        ('Bean', 0.000339404),
        ('Lynn', 0.000339221),
        ('Crane', 0.000339203),
        ('Farley', 0.000339139),
        ('Cisneros', 0.000338536),
        ('Benton', 0.000338372),
        ('Ashley', 0.000338271),
        ('Mckay', 0.000337604),
        ('Finley', 0.000336928),
        ('Best', 0.000336818),
        ('Blevins', 0.000336626),
        ('Friedman', 0.000336553),
        ('Moses', 0.00033638),
        ('Sosa', 0.00033637),
        ('Blanchard', 0.000335923),
        ('Huber', 0.000335603),
        ('Frye', 0.000335484),
        ('Krueger', 0.000335283),
        ('Bernard', 0.000333931),
        ('Rosario', 0.000333867),
        ('Rubio', 0.000333794),
        ('Mullen', 0.000332981),
        ('Benjamin', 0.000332953),
        ('Haley', 0.000332898),
        ('Chung', 0.000332798),
        ('Moyer', 0.000332789),
        ('Choi', 0.000332505),
        ('Horne', 0.000331573),
        ('Yu', 0.000331546),
        ('Woodward', 0.000331153),
        ('Ali', 0.000329664),
        ('Nixon', 0.00032928),
        ('Hayden', 0.000329161),
        ('Rivers', 0.000328759),
        ('Estes', 0.000327471),
        ('Mccarty', 0.000326365),
        ('Richmond', 0.000326338),
        ('Stuart', 0.00032621),
        ('Maynard', 0.000325726),
        ('Brandt', 0.000325433),
        ('Oconnell', 0.000325378),
        ('Hanna', 0.000325278),
        ('Sanford', 0.000324967),
        ('Sheppard', 0.000324867),
        ('Church', 0.00032473),
        ('Burch', 0.000324565),
        ('Levy', 0.000324044),
        ('Rasmussen', 0.000323944),
        ('Coffey', 0.000323843),
        ('Ponce', 0.000323459),
        ('Faulkner', 0.000323359),
        ('Donaldson', 0.000323341),
        ('Schmitt', 0.000322783),
        ('Novak', 0.000322381),
        ('Costa', 0.000321879),
        ('Montes', 0.000321595),
        ('Booker', 0.000320727),
        ('Cordova', 0.000320481),
        ('Waller', 0.000319814),
        ('Arellano', 0.000319795),
        ('Maddox', 0.00031953),
        ('Mata', 0.000318781),
        ('Bonilla', 0.000318196),
        ('Stanton', 0.000318087),
        ('Compton', 0.000317867),
        ('Kaufman', 0.000317849),
        ('Dudley', 0.000317703),
        ('Mcpherson', 0.000317639),
        ('Beltran', 0.000317392),
        ('Dickson', 0.000317045),
        ('Mccann', 0.00031699),
        ('Villegas', 0.000316917),
        ('Proctor', 0.000316899),
        ('Hester', 0.000316835),
        ('Cantrell', 0.000316826),
        ('Daugherty', 0.000316607),
        ('Cherry', 0.000316287),
        ('Bray', 0.000315921),
        ('Davila', 0.000315611),
        ('Rowland', 0.000315218),
        ('Madden', 0.00031498),
        ('Levine', 0.00031498),
        ('Spence', 0.000314642),
        ('Good', 0.000314596),
        ('Irwin', 0.000314085),
        ('Werner', 0.000313884),
        ('Krause', 0.00031382),
        ('Petty', 0.000313207),
        ('Whitney', 0.000312961),
        ('Baird', 0.000312796),
        ('Hooper', 0.000311435),
        ('Pollard', 0.000311389),
        ('Zavala', 0.000311289),
        ('Jarvis', 0.000311124),
        ('Holden', 0.000311042),
        ('Hendrix', 0.00031096),
        ('Haas', 0.00031096),
        ('Mcgrath', 0.000310951),
        ('Bird', 0.00031032),
        ('Lucero', 0.000309955),
        ('Terrell', 0.000309882),
        ('Riggs', 0.000309461),
        ('Joyce', 0.000309233),
        ('Rollins', 0.000308812),
        ('Mercer', 0.000308812),
        ('Galloway', 0.000308593),
        ('Duke', 0.000308337),
        ('Odom', 0.000308081),
        ('Andersen', 0.000306172),
        ('Downs', 0.000306044),
        ('Hatfield', 0.00030577),
        ('Benitez', 0.00030556),
        ('Archer', 0.000305285),
        ('Huerta', 0.00030471),
        ('Travis', 0.000304628),
        ('Mcneil', 0.000303714),
        ('Hinton', 0.00030344),
        ('Zhang', 0.000303376),
        ('Hays', 0.000303303),
        ('Mayo', 0.000302681),
        ('Fritz', 0.000302151),
        ('Branch', 0.000301896),
        ('Mooney', 0.000301101),
        ('Ewing', 0.000300845),
        ('Ritter', 0.000300287),
        ('Esparza', 0.000299447),
        ('Frey', 0.000299109),
        ('Braun', 0.00029857),
        ('Gay', 0.000298533),
        ('Riddle', 0.000298369),
        ('Haney', 0.000298277),
        ('Kaiser', 0.000297574),
        ('Holder', 0.000296651),
        ('Chaney', 0.000296349),
        ('Mcknight', 0.00029592),
        ('Gamble', 0.000295838),
        ('Vang', 0.000295435),
        ('Cooley', 0.000295015),
        ('Carney', 0.000294969),
        ('Cowan', 0.000294604),
        ('Forbes', 0.000294476),
        ('Ferrell', 0.000293983),
        ('Davies', 0.0002939),
        ('Barajas', 0.000293736),
        ('Shea', 0.000293023),
        ('Osborn', 0.000292795),
        ('Bright', 0.000292777),
        ('Cuevas', 0.00029253),
        ('Bolton', 0.000292347),
        ('Murillo', 0.000292064),
        ('Lutz', 0.000291845),
        ('Duarte', 0.000291442),
        ('Kidd', 0.000291351),
        ('Key', 0.000291315),
        ('Cooke', 0.000291114),
    ))

    prefixes_female = OrderedDict((
        ('Mrs.', 0.5),
        ('Ms.', 0.1),
        ('Miss', 0.1),
        ('Dr.', 0.3),
    ))
    prefixes_male = OrderedDict((
        ('Mr.', 0.7),
        ('Dr.', 0.3),
    ))

    # https://en.wikipedia.org/wiki/Gender-neutral_title
    prefixes_nonbinary = OrderedDict((
        ('Mx.', 0.5),
        ('Ind.', 0.1),
        ('Misc.', 0.1),
        ('Dr.', 0.3),
    ))

    suffixes_female = OrderedDict((
        ('MD', 0.5),
        ('DDS', 0.3),
        ('PhD', 0.1),
        ('DVM', 0.2),
    ))

    # Removed Sr and I as they'd almost never be part of legal names.
    suffixes_male = OrderedDict((
        ('Jr.', 0.2),
        ('II', 0.05),
        ('III', 0.03),
        ('IV', 0.015),
        ('V', 0.005),
        ('MD', 0.3),
        ('DDS', 0.2),
        ('PhD', 0.1),
        ('DVM', 0.1),
    ))

    suffixes_nonbinary = suffixes_male.copy()
