/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.version;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.core.settings.IvySettings;
import org.jetbrains.kotlin.org.apache.ivy.plugins.IvySettingsAware;
import org.jetbrains.kotlin.org.apache.ivy.plugins.version.AbstractVersionMatcher;
import org.jetbrains.kotlin.org.apache.ivy.plugins.version.VersionMatcher;
import org.jetbrains.kotlin.org.apache.ivy.util.Checks;

public class ChainVersionMatcher
extends AbstractVersionMatcher {
    private final List<VersionMatcher> matchers = new LinkedList<VersionMatcher>();

    public ChainVersionMatcher() {
        super("chain");
    }

    public void add(VersionMatcher matcher) {
        Checks.checkNotNull(matcher, "matcher");
        this.matchers.add(0, matcher);
        if (this.getSettings() != null && matcher instanceof IvySettingsAware) {
            ((IvySettingsAware)((Object)matcher)).setSettings(this.getSettings());
        }
    }

    @Override
    public void setSettings(IvySettings settings) {
        super.setSettings(settings);
        for (VersionMatcher matcher : this.matchers) {
            if (!(matcher instanceof IvySettingsAware)) continue;
            ((IvySettingsAware)((Object)matcher)).setSettings(settings);
        }
    }

    @Override
    public boolean isDynamic(ModuleRevisionId askedMrid) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        for (VersionMatcher matcher : this.matchers) {
            if (!matcher.isDynamic(askedMrid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compare(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid, Comparator<ModuleRevisionId> staticComparator) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMrid, "foundMrid");
        Checks.checkNotNull(staticComparator, "staticComparator");
        for (VersionMatcher matcher : this.matchers) {
            if (!matcher.isDynamic(askedMrid)) continue;
            return matcher.compare(askedMrid, foundMrid, staticComparator);
        }
        throw new IllegalArgumentException("impossible to compare revisions: askedMrid is not dynamic: " + askedMrid);
    }

    @Override
    public boolean accept(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMrid, "foundMrid");
        Iterator<VersionMatcher> iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher = iter.next();
            if (iter.hasNext() && !matcher.isDynamic(askedMrid)) continue;
            return matcher.accept(askedMrid, foundMrid);
        }
        return false;
    }

    @Override
    public boolean needModuleDescriptor(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMrid, "foundMrid");
        Iterator<VersionMatcher> iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher = iter.next();
            if (iter.hasNext() && !matcher.isDynamic(askedMrid)) continue;
            return matcher.needModuleDescriptor(askedMrid, foundMrid);
        }
        return false;
    }

    @Override
    public boolean accept(ModuleRevisionId askedMrid, ModuleDescriptor foundMD) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMD, "foundMD");
        Iterator<VersionMatcher> iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher = iter.next();
            if (iter.hasNext() && !matcher.isDynamic(askedMrid)) continue;
            return matcher.accept(askedMrid, foundMD);
        }
        return false;
    }
}

