/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.TreeResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rR\"\u0010\u0004\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "outerLocalClassForNested", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Map;)V", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "outerClass", "classSymbol", "outerType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "classLikeType", "resolve"})
public final class FirOuterClassManager {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Map<FirClassLikeSymbol<?>, FirClassLikeSymbol<?>> outerLocalClassForNested;
    @NotNull
    private final FirSymbolProvider symbolProvider;

    public FirOuterClassManager(@NotNull FirSession session2, @NotNull Map<FirClassLikeSymbol<?>, ? extends FirClassLikeSymbol<?>> outerLocalClassForNested) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(outerLocalClassForNested, "outerLocalClassForNested");
        this.session = session2;
        this.outerLocalClassForNested = outerLocalClassForNested;
        this.symbolProvider = MainSessionComponentsKt.getFirSymbolProvider(this.session);
    }

    @Nullable
    public final FirClassLikeSymbol<?> outerClass(@NotNull FirClassLikeSymbol<?> classSymbol) {
        ClassId classId;
        Intrinsics.checkNotNullParameter(classSymbol, "classSymbol");
        if (!(classSymbol instanceof FirClassSymbol)) {
            return null;
        }
        ClassId classId2 = classSymbol.getClassId();
        if (classId2.isLocal()) {
            return this.outerLocalClassForNested.get(classSymbol);
        }
        ClassId classId3 = classId2.getOuterClassId();
        if (classId3 == null) {
            return null;
        }
        ClassId outerClassId = classId = classId3;
        return this.symbolProvider.getClassLikeSymbolByFqName(outerClassId);
    }

    @Nullable
    public final ConeClassLikeType outerType(@NotNull ConeClassLikeType classLikeType) {
        int n;
        FirRegularClass firRegularClass;
        List<FirTypeParameterRef> list2;
        FirRegularClassSymbol firRegularClassSymbol;
        FirClassLikeSymbol<?> $i$f$isInner2;
        Intrinsics.checkNotNullParameter(classLikeType, "classLikeType");
        ConeClassLikeType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default(classLikeType, this.session, null, 2, null);
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(fullyExpandedType2.getLookupTag(), this.session);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        if (symbol2 instanceof FirRegularClassSymbol) {
            FirRegularClass $this$isInner$iv = (FirRegularClass)((FirRegularClassSymbol)symbol2).getFir();
            boolean $i$f$isInner2 = false;
            if (!$this$isInner$iv.getStatus().isInner()) {
                return null;
            }
        }
        if (($i$f$isInner2 = this.outerClass(symbol2)) == null) {
            return null;
        }
        FirClassLikeSymbol<?> containingSymbol = $i$f$isInner2;
        FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol = symbol2 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)symbol2 : null;
        List<FirTypeParameterRef> list3 = firRegularClassSymbol == null ? null : (list2 = (firRegularClass = (FirRegularClass)firRegularClassSymbol.getFir()) == null ? null : firRegularClass.getTypeParameters());
        if (list2 == null) {
            n = 0;
        } else {
            int n2;
            int n3;
            Iterable $this$count$iv = list2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n3 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                    boolean bl = false;
                    if (!(it instanceof FirTypeParameter)) continue;
                    int n4 = ++count$iv;
                    boolean bl2 = false;
                    if (n4 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n3 = count$iv;
            }
            n = n2 = n3;
        }
        int currentTypeArgumentsNumber = n;
        Collection $this$toTypedArray$iv = ArraysKt.drop(fullyExpandedType2.getTypeArguments(), currentTypeArgumentsNumber);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (ConeClassLikeType)TreeResolveUtilsKt.constructType$default(containingSymbol, coneTypeProjectionArray, false, null, 4, null);
    }
}

