/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.components.TrivialConstraintTypeInferenceOracle;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDependencyInformationProvider;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.DeclaredUpperBoundConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentListMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.model.TypeVariableTypeConstructorMarker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0003,-.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J<\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0011J:\u0010\u001b\u001a\u0004\u0018\u00010\f*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u001d\u001a\u00020\u001e*\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0014\u0010#\u001a\u00020\b*\u00020\u000e2\u0006\u0010\r\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u00020\b*\u00020\u000e2\u0006\u0010&\u001a\u00020\u0017H\u0002J\u0014\u0010'\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0014\u0010(\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0014\u0010)\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0014\u0010*\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0014\u0010+\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;", "", "trivialConstraintTypeInferenceOracle", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "inferenceCompatibilityModeEnabled", "", "getInferenceCompatibilityModeEnabled", "()Z", "findFirstVariableForFixation", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$VariableForFixation;", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;", "allTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "postponedKtPrimitives", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "topLevelType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "isTypeVariableHasProperConstraint", "context", "typeVariable", "findTypeVariableForFixation", "postponedArguments", "getTypeVariableReadiness", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$TypeVariableFixationReadiness;", "variable", "dependencyProvider", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider;", "hasDependencyToOtherTypeVariables", "isProperArgumentConstraint", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "isProperType", "type", "isReified", "variableHasLowerNonNothingProperConstraint", "variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound", "variableHasProperArgumentConstraints", "variableHasTrivialOrNonProperConstraints", "Context", "TypeVariableFixationReadiness", "VariableForFixation", "resolution.common"})
public final class VariableFixationFinder {
    @NotNull
    private final TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public VariableFixationFinder(@NotNull TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(trivialConstraintTypeInferenceOracle, "trivialConstraintTypeInferenceOracle");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.trivialConstraintTypeInferenceOracle = trivialConstraintTypeInferenceOracle;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Nullable
    public final VariableForFixation findFirstVariableForFixation(@NotNull Context c, @NotNull List<? extends TypeConstructorMarker> allTypeVariables, @NotNull List<? extends PostponedResolvedAtomMarker> postponedKtPrimitives, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull KotlinTypeMarker topLevelType) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(allTypeVariables, "allTypeVariables");
        Intrinsics.checkNotNullParameter(postponedKtPrimitives, "postponedKtPrimitives");
        Intrinsics.checkNotNullParameter((Object)completionMode, "completionMode");
        Intrinsics.checkNotNullParameter(topLevelType, "topLevelType");
        return this.findTypeVariableForFixation(c, allTypeVariables, postponedKtPrimitives, completionMode, topLevelType);
    }

    private final boolean getInferenceCompatibilityModeEnabled() {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.InferenceCompatibility);
    }

    private final TypeVariableFixationReadiness getTypeVariableReadiness(Context $this$getTypeVariableReadiness, TypeConstructorMarker variable2, TypeVariableDependencyInformationProvider dependencyProvider) {
        Map<TypeConstructorMarker, VariableWithConstraints> map = $this$getTypeVariableReadiness.getNotFixedTypeVariables();
        boolean bl = false;
        Map<TypeConstructorMarker, VariableWithConstraints> map2 = map;
        boolean bl2 = false;
        return !map2.containsKey(variable2) || dependencyProvider.isVariableRelatedToTopLevelType(variable2) ? TypeVariableFixationReadiness.FORBIDDEN : (!this.variableHasProperArgumentConstraints($this$getTypeVariableReadiness, variable2) ? TypeVariableFixationReadiness.WITHOUT_PROPER_ARGUMENT_CONSTRAINT : (this.hasDependencyToOtherTypeVariables($this$getTypeVariableReadiness, variable2) ? TypeVariableFixationReadiness.WITH_COMPLEX_DEPENDENCY : (this.variableHasTrivialOrNonProperConstraints($this$getTypeVariableReadiness, variable2) ? TypeVariableFixationReadiness.WITH_TRIVIAL_OR_NON_PROPER_CONSTRAINTS : (dependencyProvider.isVariableRelatedToAnyOutputType(variable2) ? TypeVariableFixationReadiness.RELATED_TO_ANY_OUTPUT_TYPE : (this.variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound($this$getTypeVariableReadiness, variable2) ? TypeVariableFixationReadiness.FROM_INCORPORATION_OF_DECLARED_UPPER_BOUND : (this.isReified($this$getTypeVariableReadiness, variable2) ? TypeVariableFixationReadiness.READY_FOR_FIXATION_REIFIED : (this.getInferenceCompatibilityModeEnabled() ? (this.variableHasLowerNonNothingProperConstraint($this$getTypeVariableReadiness, variable2) ? TypeVariableFixationReadiness.READY_FOR_FIXATION_LOWER : TypeVariableFixationReadiness.READY_FOR_FIXATION_UPPER) : TypeVariableFixationReadiness.READY_FOR_FIXATION)))))));
    }

    public final boolean isTypeVariableHasProperConstraint(@NotNull Context context2, @NotNull TypeConstructorMarker typeVariable2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(typeVariable2, "typeVariable");
        boolean bl2 = false;
        boolean bl3 = false;
        Context $this$isTypeVariableHasProperConstraint_u24lambda_u2d0 = context2;
        boolean bl4 = false;
        TypeVariableDependencyInformationProvider dependencyProvider = new TypeVariableDependencyInformationProvider($this$isTypeVariableHasProperConstraint_u24lambda_u2d0.getNotFixedTypeVariables(), CollectionsKt.emptyList(), null, context2);
        TypeVariableFixationReadiness typeVariableFixationReadiness = this.getTypeVariableReadiness($this$isTypeVariableHasProperConstraint_u24lambda_u2d0, typeVariable2, dependencyProvider);
        int n = WhenMappings.$EnumSwitchMapping$0[typeVariableFixationReadiness.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean variableHasTrivialOrNonProperConstraints(Context $this$variableHasTrivialOrNonProperConstraints, TypeConstructorMarker variable2) {
        boolean bl;
        List<Constraint> list2;
        VariableWithConstraints variableWithConstraints = $this$variableHasTrivialOrNonProperConstraints.getNotFixedTypeVariables().get(variable2);
        List<Constraint> list3 = list2 = variableWithConstraints == null ? null : variableWithConstraints.getConstraints();
        if (list2 == null) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3;
            block5: {
                Iterable $this$all$iv = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Constraint constraint = (Constraint)element$iv;
                        boolean bl4 = false;
                        boolean isProperConstraint = this.isProperArgumentConstraint($this$variableHasTrivialOrNonProperConstraints, constraint);
                        if (isProperConstraint && this.trivialConstraintTypeInferenceOracle.isNotInterestingConstraint(constraint) || !isProperConstraint) continue;
                        bl3 = false;
                        break block5;
                    }
                    bl3 = true;
                }
            }
            bl = bl2 = bl3;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound(Context $this$variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound, TypeConstructorMarker variable2) {
        boolean bl;
        block5: {
            void $this$all$iv;
            void $this$filterTo$iv$iv;
            List<Constraint> list2;
            VariableWithConstraints variableWithConstraints = $this$variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound.getNotFixedTypeVariables().get(variable2);
            List<Constraint> list3 = list2 = variableWithConstraints == null ? null : variableWithConstraints.getConstraints();
            if (list2 == null) {
                return false;
            }
            List<Constraint> constraints = list2;
            Iterable $this$filter$iv = constraints;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Constraint it = (Constraint)element$iv$iv;
                boolean bl2 = false;
                if (!this.isProperArgumentConstraint($this$variableHasOnlyIncorporatedConstraintsFromDeclaredUpperBound, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Constraint it = (Constraint)element$iv;
                    boolean bl3 = false;
                    if (it.getPosition().isFromDeclaredUpperBound()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final VariableForFixation findTypeVariableForFixation(Context $this$findTypeVariableForFixation, List<? extends TypeConstructorMarker> allTypeVariables, List<? extends PostponedResolvedAtomMarker> postponedArguments, ConstraintSystemCompletionMode completionMode, KotlinTypeMarker topLevelType) {
        VariableForFixation variableForFixation;
        Object v0;
        if (allTypeVariables.isEmpty()) {
            return null;
        }
        KotlinTypeMarker kotlinTypeMarker = topLevelType;
        boolean bl = false;
        boolean bl2 = false;
        KotlinTypeMarker kotlinTypeMarker2 = kotlinTypeMarker;
        List<? extends PostponedResolvedAtomMarker> list2 = postponedArguments;
        Map<TypeConstructorMarker, VariableWithConstraints> map = $this$findTypeVariableForFixation.getNotFixedTypeVariables();
        boolean bl3 = false;
        boolean bl4 = completionMode == ConstraintSystemCompletionMode.PARTIAL;
        TypeSystemInferenceExtensionContext typeSystemInferenceExtensionContext = $this$findTypeVariableForFixation;
        KotlinTypeMarker kotlinTypeMarker3 = bl4 ? kotlinTypeMarker : null;
        List<? extends PostponedResolvedAtomMarker> list3 = list2;
        Map<TypeConstructorMarker, VariableWithConstraints> map2 = map;
        TypeVariableDependencyInformationProvider dependencyProvider = new TypeVariableDependencyInformationProvider(map2, list3, kotlinTypeMarker3, typeSystemInferenceExtensionContext);
        Iterable $this$maxByOrNull$iv = allTypeVariables;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                TypeConstructorMarker it = (TypeConstructorMarker)maxElem$iv;
                boolean bl5 = false;
                Comparable maxValue$iv = (Comparable)((Object)this.getTypeVariableReadiness($this$findTypeVariableForFixation, it, dependencyProvider));
                do {
                    Object e$iv = iterator$iv.next();
                    TypeConstructorMarker it2 = (TypeConstructorMarker)e$iv;
                    $i$a$-maxByOrNull-VariableFixationFinder$findTypeVariableForFixation$candidate$1 = false;
                    Comparable v$iv = (Comparable)((Object)this.getTypeVariableReadiness($this$findTypeVariableForFixation, it2, dependencyProvider));
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Object object = v0;
        if (object == null) {
            return null;
        }
        TypeConstructorMarker candidate2 = object;
        object = this.getTypeVariableReadiness($this$findTypeVariableForFixation, candidate2, dependencyProvider);
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                variableForFixation = null;
                break;
            }
            case 2: {
                variableForFixation = new VariableForFixation(candidate2, false, false, 4, null);
                break;
            }
            case 3: {
                variableForFixation = new VariableForFixation(candidate2, true, true);
                break;
            }
            default: {
                variableForFixation = new VariableForFixation(candidate2, true, false, 4, null);
            }
        }
        return variableForFixation;
    }

    private final boolean hasDependencyToOtherTypeVariables(Context $this$hasDependencyToOtherTypeVariables, TypeConstructorMarker typeVariable2) {
        List<Constraint> list2;
        VariableWithConstraints variableWithConstraints = $this$hasDependencyToOtherTypeVariables.getNotFixedTypeVariables().get(typeVariable2);
        List<Constraint> list3 = list2 = variableWithConstraints == null ? null : variableWithConstraints.getConstraints();
        if (list2 == null) {
            return false;
        }
        for (Constraint constraint : list2) {
            Function1 dependencyPresenceCondition2 = new Function1<KotlinTypeMarker, Boolean>($this$hasDependencyToOtherTypeVariables, typeVariable2){
                final /* synthetic */ Context $this_hasDependencyToOtherTypeVariables;
                final /* synthetic */ TypeConstructorMarker $typeVariable;
                {
                    this.$this_hasDependencyToOtherTypeVariables = $receiver;
                    this.$typeVariable = $typeVariable;
                    super(1);
                }

                public final boolean invoke(@NotNull KotlinTypeMarker type2) {
                    Intrinsics.checkNotNullParameter(type2, "type");
                    return !Intrinsics.areEqual(this.$this_hasDependencyToOtherTypeVariables.typeConstructor(type2), this.$typeVariable) && this.$this_hasDependencyToOtherTypeVariables.getNotFixedTypeVariables().containsKey(this.$this_hasDependencyToOtherTypeVariables.typeConstructor(type2));
                }
            };
            if ($this$hasDependencyToOtherTypeVariables.argumentsCount($this$hasDependencyToOtherTypeVariables.lowerBoundIfFlexible(constraint.getType())) == 0 || !$this$hasDependencyToOtherTypeVariables.contains(constraint.getType(), dependencyPresenceCondition2)) continue;
            return true;
        }
        return false;
    }

    private final boolean variableHasProperArgumentConstraints(Context $this$variableHasProperArgumentConstraints, TypeConstructorMarker variable2) {
        boolean bl;
        boolean areThereConstraintsWithUninferredTypeParameter2;
        block8: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            List<Constraint> constraints;
            block7: {
                List<Constraint> list2;
                VariableWithConstraints variableWithConstraints = $this$variableHasProperArgumentConstraints.getNotFixedTypeVariables().get(variable2);
                List<Constraint> list3 = list2 = variableWithConstraints == null ? null : variableWithConstraints.getConstraints();
                if (list2 == null) {
                    return false;
                }
                constraints = list2;
                $this$any$iv = constraints;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Constraint c = (Constraint)element$iv;
                        boolean bl3 = false;
                        if (!$this$variableHasProperArgumentConstraints.contains(c.getType(), (Function1<? super KotlinTypeMarker, Boolean>)new Function1<KotlinTypeMarker, Boolean>($this$variableHasProperArgumentConstraints){
                            final /* synthetic */ Context $this_variableHasProperArgumentConstraints;
                            {
                                this.$this_variableHasProperArgumentConstraints = $receiver;
                                super(1);
                            }

                            public final boolean invoke(@NotNull KotlinTypeMarker it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                return this.$this_variableHasProperArgumentConstraints.isUninferredParameter(it);
                            }
                        })) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            areThereConstraintsWithUninferredTypeParameter2 = bl2;
            $this$any$iv = constraints;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Constraint it = (Constraint)element$iv;
                    boolean bl4 = false;
                    if (!this.isProperArgumentConstraint($this$variableHasProperArgumentConstraints, it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl && !areThereConstraintsWithUninferredTypeParameter2;
    }

    private final boolean isProperArgumentConstraint(Context $this$isProperArgumentConstraint, Constraint c) {
        return this.isProperType($this$isProperArgumentConstraint, c.getType()) && !(c.getPosition().getInitialConstraint().getPosition() instanceof DeclaredUpperBoundConstraintPosition) && !c.isNullabilityConstraint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProperType(Context $this$isProperType, KotlinTypeMarker type2) {
        boolean bl;
        TypeSystemInferenceExtensionContext $this$isProperTypeForFixation$iv = $this$isProperType;
        boolean $i$f$isProperTypeForFixation = false;
        KotlinTypeMarker t = type2;
        boolean bl2 = false;
        if ($this$isProperType.contains(t, (Function1<? super KotlinTypeMarker, Boolean>)new Function1<KotlinTypeMarker, Boolean>($this$isProperType){
            final /* synthetic */ Context $this_isProperType;
            {
                this.$this_isProperType = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull KotlinTypeMarker it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$this_isProperType.getNotFixedTypeVariables().containsKey(this.$this_isProperType.typeConstructor(it));
            }
        })) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        Iterable $this$all$iv$iv = VariableFixationFinderKt.extractProjectionsForAllCapturedTypes($this$isProperTypeForFixation$iv, type2);
        boolean $i$f$all = false;
        if ($this$all$iv$iv instanceof Collection && ((Collection)$this$all$iv$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv$iv = iterator2.next();
            KotlinTypeMarker t2 = (KotlinTypeMarker)element$iv$iv;
            $i$a$-isProperTypeForFixation-VariableFixationFinder$isProperType$1 = false;
            if ($this$isProperType.contains(t2, (Function1<? super KotlinTypeMarker, Boolean>)new /* invalid duplicate definition of identical inner class */)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private final boolean isReified(Context $this$isReified, TypeConstructorMarker variable2) {
        boolean bl;
        TypeVariableMarker typeVariableMarker;
        VariableWithConstraints variableWithConstraints = $this$isReified.getNotFixedTypeVariables().get(variable2);
        TypeVariableMarker typeVariableMarker2 = typeVariableMarker = variableWithConstraints == null ? null : variableWithConstraints.getTypeVariable();
        if (typeVariableMarker == null) {
            bl = false;
        } else {
            boolean bl2;
            TypeVariableMarker typeVariableMarker3 = typeVariableMarker;
            boolean bl3 = false;
            boolean bl4 = false;
            TypeVariableMarker it = typeVariableMarker3;
            boolean bl5 = false;
            bl = bl2 = $this$isReified.isReified(it);
        }
        return bl;
    }

    private final boolean variableHasLowerNonNothingProperConstraint(Context $this$variableHasLowerNonNothingProperConstraint, TypeConstructorMarker variable2) {
        boolean bl;
        block4: {
            List<Constraint> list2;
            VariableWithConstraints variableWithConstraints = $this$variableHasLowerNonNothingProperConstraint.getNotFixedTypeVariables().get(variable2);
            List<Constraint> list3 = list2 = variableWithConstraints == null ? null : variableWithConstraints.getConstraints();
            if (list2 == null) {
                return false;
            }
            List<Constraint> constraints = list2;
            Iterable $this$any$iv = constraints;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Constraint it = (Constraint)element$iv;
                    boolean bl2 = false;
                    if (!(it.getKind().isLower() && this.isProperArgumentConstraint($this$variableHasLowerNonNothingProperConstraint, it) && !$this$variableHasLowerNonNothingProperConstraint.isNothingConstructor($this$variableHasLowerNonNothingProperConstraint.typeConstructor(it.getType())))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH&R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "fixedTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "getFixedTypeVariables", "()Ljava/util/Map;", "notFixedTypeVariables", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "getNotFixedTypeVariables", "postponedTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "getPostponedTypeVariables", "()Ljava/util/List;", "isReified", "", "variable", "resolution.common"})
    public static interface Context
    extends TypeSystemInferenceExtensionContext {
        @NotNull
        public Map<TypeConstructorMarker, VariableWithConstraints> getNotFixedTypeVariables();

        @NotNull
        public Map<TypeConstructorMarker, KotlinTypeMarker> getFixedTypeVariables();

        @NotNull
        public List<TypeVariableMarker> getPostponedTypeVariables();

        public boolean isReified(@NotNull TypeVariableMarker var1);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static boolean identicalArguments(@NotNull Context this_, @NotNull SimpleTypeMarker a, @NotNull SimpleTypeMarker b) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(a, "a");
                Intrinsics.checkNotNullParameter(b, "b");
                return TypeSystemInferenceExtensionContext.DefaultImpls.identicalArguments(this_, a, b);
            }

            public static boolean anySuperTypeConstructor(@NotNull Context this_, @NotNull KotlinTypeMarker receiver, @NotNull Function1<? super TypeConstructorMarker, Boolean> predicate) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                Intrinsics.checkNotNullParameter(predicate, "predicate");
                return TypeSystemInferenceExtensionContext.DefaultImpls.anySuperTypeConstructor(this_, receiver, predicate);
            }

            @NotNull
            public static Set<TypeVariableTypeConstructorMarker> extractTypeVariables(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.extractTypeVariables(this_, receiver);
            }

            public static boolean hasFlexibleNullability(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.hasFlexibleNullability(this_, receiver);
            }

            public static boolean isCapturedDynamic(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedDynamic(this_, receiver);
            }

            public static boolean isCapturedType(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedType(this_, receiver);
            }

            public static boolean isDefinitelyNotNullType(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDefinitelyNotNullType(this_, receiver);
            }

            public static boolean isDynamic(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDynamic(this_, receiver);
            }

            public static boolean isFlexible(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexible(this_, receiver);
            }

            public static boolean isFlexibleNothing(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexibleNothing(this_, receiver);
            }

            public static boolean isMarkedNullable(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isMarkedNullable(this_, receiver);
            }

            public static boolean isNothing(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNothing(this_, receiver);
            }

            public static boolean isNullableAny(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableAny(this_, receiver);
            }

            public static boolean isNullableNothing(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableNothing(this_, receiver);
            }

            public static boolean isSimpleType(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isSimpleType(this_, receiver);
            }

            @NotNull
            public static SimpleTypeMarker lowerBoundIfFlexible(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.lowerBoundIfFlexible(this_, receiver);
            }

            @NotNull
            public static TypeConstructorMarker typeConstructor(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeConstructor(this_, receiver);
            }

            public static int typeDepth(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeDepth(this_, receiver);
            }

            @NotNull
            public static SimpleTypeMarker upperBoundIfFlexible(@NotNull Context this_, @NotNull KotlinTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.upperBoundIfFlexible(this_, receiver);
            }

            @Nullable
            public static List<SimpleTypeMarker> fastCorrespondingSupertypes(@NotNull Context this_, @NotNull SimpleTypeMarker receiver, @NotNull TypeConstructorMarker constructor2) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                Intrinsics.checkNotNullParameter(constructor2, "constructor");
                return TypeSystemInferenceExtensionContext.DefaultImpls.fastCorrespondingSupertypes(this_, receiver, constructor2);
            }

            @Nullable
            public static TypeArgumentMarker getArgumentOrNull(@NotNull Context this_, @NotNull SimpleTypeMarker receiver, int index2) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.getArgumentOrNull(this_, receiver, index2);
            }

            public static boolean isClassType(@NotNull Context this_, @NotNull SimpleTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isClassType(this_, receiver);
            }

            public static boolean isIntegerLiteralType(@NotNull Context this_, @NotNull SimpleTypeMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isIntegerLiteralType(this_, receiver);
            }

            @NotNull
            public static TypeArgumentMarker get(@NotNull Context this_, @NotNull TypeArgumentListMarker receiver, int index2) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.get(this_, receiver, index2);
            }

            @NotNull
            public static Iterator<TypeArgumentMarker> iterator(@NotNull Context this_, @NotNull TypeArgumentListMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.iterator(this_, receiver);
            }

            public static int size(@NotNull Context this_, @NotNull TypeArgumentListMarker receiver) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.size(this_, receiver);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$VariableForFixation;", "", "variable", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "hasProperConstraint", "", "hasOnlyTrivialProperConstraint", "(Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;ZZ)V", "getHasOnlyTrivialProperConstraint", "()Z", "getHasProperConstraint", "getVariable", "()Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "resolution.common"})
    public static final class VariableForFixation {
        @NotNull
        private final TypeConstructorMarker variable;
        private final boolean hasProperConstraint;
        private final boolean hasOnlyTrivialProperConstraint;

        public VariableForFixation(@NotNull TypeConstructorMarker variable2, boolean hasProperConstraint, boolean hasOnlyTrivialProperConstraint) {
            Intrinsics.checkNotNullParameter(variable2, "variable");
            this.variable = variable2;
            this.hasProperConstraint = hasProperConstraint;
            this.hasOnlyTrivialProperConstraint = hasOnlyTrivialProperConstraint;
        }

        public /* synthetic */ VariableForFixation(TypeConstructorMarker typeConstructorMarker, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(typeConstructorMarker, bl, bl2);
        }

        @NotNull
        public final TypeConstructorMarker getVariable() {
            return this.variable;
        }

        public final boolean getHasProperConstraint() {
            return this.hasProperConstraint;
        }

        public final boolean getHasOnlyTrivialProperConstraint() {
            return this.hasOnlyTrivialProperConstraint;
        }

        @NotNull
        public final TypeConstructorMarker component1() {
            return this.variable;
        }

        public final boolean component2() {
            return this.hasProperConstraint;
        }

        public final boolean component3() {
            return this.hasOnlyTrivialProperConstraint;
        }

        @NotNull
        public final VariableForFixation copy(@NotNull TypeConstructorMarker variable2, boolean hasProperConstraint, boolean hasOnlyTrivialProperConstraint) {
            Intrinsics.checkNotNullParameter(variable2, "variable");
            return new VariableForFixation(variable2, hasProperConstraint, hasOnlyTrivialProperConstraint);
        }

        public static /* synthetic */ VariableForFixation copy$default(VariableForFixation variableForFixation, TypeConstructorMarker typeConstructorMarker, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                typeConstructorMarker = variableForFixation.variable;
            }
            if ((n & 2) != 0) {
                bl = variableForFixation.hasProperConstraint;
            }
            if ((n & 4) != 0) {
                bl2 = variableForFixation.hasOnlyTrivialProperConstraint;
            }
            return variableForFixation.copy(typeConstructorMarker, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "VariableForFixation(variable=" + this.variable + ", hasProperConstraint=" + this.hasProperConstraint + ", hasOnlyTrivialProperConstraint=" + this.hasOnlyTrivialProperConstraint + ')';
        }

        public int hashCode() {
            int result2 = this.variable.hashCode();
            int n = this.hasProperConstraint ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            int n2 = this.hasOnlyTrivialProperConstraint ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result2 = result2 * 31 + n2;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariableForFixation)) {
                return false;
            }
            VariableForFixation variableForFixation = (VariableForFixation)other;
            if (!Intrinsics.areEqual(this.variable, variableForFixation.variable)) {
                return false;
            }
            if (this.hasProperConstraint != variableForFixation.hasProperConstraint) {
                return false;
            }
            return this.hasOnlyTrivialProperConstraint == variableForFixation.hasOnlyTrivialProperConstraint;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$TypeVariableFixationReadiness;", "", "(Ljava/lang/String;I)V", "FORBIDDEN", "WITHOUT_PROPER_ARGUMENT_CONSTRAINT", "WITH_COMPLEX_DEPENDENCY", "WITH_TRIVIAL_OR_NON_PROPER_CONSTRAINTS", "RELATED_TO_ANY_OUTPUT_TYPE", "FROM_INCORPORATION_OF_DECLARED_UPPER_BOUND", "READY_FOR_FIXATION_UPPER", "READY_FOR_FIXATION_LOWER", "READY_FOR_FIXATION", "READY_FOR_FIXATION_REIFIED", "resolution.common"})
    public static final class TypeVariableFixationReadiness
    extends Enum<TypeVariableFixationReadiness> {
        public static final /* enum */ TypeVariableFixationReadiness FORBIDDEN = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness WITHOUT_PROPER_ARGUMENT_CONSTRAINT = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness WITH_COMPLEX_DEPENDENCY = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness WITH_TRIVIAL_OR_NON_PROPER_CONSTRAINTS = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness RELATED_TO_ANY_OUTPUT_TYPE = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness FROM_INCORPORATION_OF_DECLARED_UPPER_BOUND = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness READY_FOR_FIXATION_UPPER = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness READY_FOR_FIXATION_LOWER = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness READY_FOR_FIXATION = new TypeVariableFixationReadiness();
        public static final /* enum */ TypeVariableFixationReadiness READY_FOR_FIXATION_REIFIED = new TypeVariableFixationReadiness();
        private static final /* synthetic */ TypeVariableFixationReadiness[] $VALUES;

        public static TypeVariableFixationReadiness[] values() {
            TypeVariableFixationReadiness[] typeVariableFixationReadinessArray = $VALUES;
            TypeVariableFixationReadiness[] typeVariableFixationReadinessArray2 = new TypeVariableFixationReadiness[typeVariableFixationReadinessArray.length];
            System.arraycopy(typeVariableFixationReadinessArray, 0, typeVariableFixationReadinessArray2, 0, typeVariableFixationReadinessArray.length);
            return typeVariableFixationReadinessArray2;
        }

        public static TypeVariableFixationReadiness valueOf(String value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            return Enum.valueOf(TypeVariableFixationReadiness.class, value2);
        }

        static {
            $VALUES = typeVariableFixationReadinessArray = new TypeVariableFixationReadiness[]{TypeVariableFixationReadiness.FORBIDDEN, TypeVariableFixationReadiness.WITHOUT_PROPER_ARGUMENT_CONSTRAINT, TypeVariableFixationReadiness.WITH_COMPLEX_DEPENDENCY, TypeVariableFixationReadiness.WITH_TRIVIAL_OR_NON_PROPER_CONSTRAINTS, TypeVariableFixationReadiness.RELATED_TO_ANY_OUTPUT_TYPE, TypeVariableFixationReadiness.FROM_INCORPORATION_OF_DECLARED_UPPER_BOUND, TypeVariableFixationReadiness.READY_FOR_FIXATION_UPPER, TypeVariableFixationReadiness.READY_FOR_FIXATION_LOWER, TypeVariableFixationReadiness.READY_FOR_FIXATION, TypeVariableFixationReadiness.READY_FOR_FIXATION_REIFIED};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeVariableFixationReadiness.values().length];
            nArray[TypeVariableFixationReadiness.FORBIDDEN.ordinal()] = 1;
            nArray[TypeVariableFixationReadiness.WITHOUT_PROPER_ARGUMENT_CONSTRAINT.ordinal()] = 2;
            nArray[TypeVariableFixationReadiness.WITH_TRIVIAL_OR_NON_PROPER_CONSTRAINTS.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

