/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;

public class AutoupdateSettings {
    private static String tempIdeIdentity = null;
    private static final Logger err = Logger.getLogger(AutoupdateSettings.class.getName());
    private static final String PROP_IDE_IDENTITY = "ideIdentity";
    private static final String PROP_SUPER_IDENTITY = "superId";
    private static final String PROP_QUALIFIED_IDENTITY = "qualifiedId";
    private static final String PROP_PERIOD = "period";
    private static final String PROP_LAST_CHECK = "lastCheckTime";
    private static final String DEFAULT_NETBEANS_DIR = ".netbeans";
    private static final String SUPER_IDENTITY_FILE_NAME = ".superId";
    private static final char IDE_ID_DELIMETER = '0';
    private static final char QUALIFIED_ID_DELIMETER = '_';
    public static final int EVERY_STARTUP = 0;
    public static final int EVERY_DAY = 1;
    public static final int EVERY_WEEK = 2;
    public static final int EVERY_2WEEKS = 3;
    public static final int EVERY_MONTH = 4;
    public static final int NEVER = 5;
    public static final int CUSTOM_CHECK_INTERVAL = 6;
    private static final String EXPIRATION_RECORD = "expiration";
    private static final String IMPORTED = "imported";
    private static final String[] VERSIONS_FOR_IMPORT = new String[0];
    private static final String[][] KNOWN = new String[][]{{"EVERY_STARTUP", "0"}, {"EVERY_DAY", "1"}, {"EVERY_WEEK", "2"}, {"EVERY_2WEEKS", "3"}, {"EVERY_MONTH", "4"}, {"NEVER", "5"}};
    private static int checkInterval = 0;
    private static String superId;

    private AutoupdateSettings() {
    }

    public static void generateIdentity() {
        AutoupdateSettings.expirationCheck();
        if (tempIdeIdentity instanceof String) {
            return;
        }
        String string = AutoupdateSettings.getPreferences().get(PROP_IDE_IDENTITY, null);
        String string2 = null;
        string2 = string == null ? AutoupdateSettings.modifyIdeIdentityIfNeeded('0' + AutoupdateSettings.generateNewId()) : AutoupdateSettings.modifyIdeIdentityIfNeeded(string);
        tempIdeIdentity = string2;
        if (!string2.equals(string) || !AutoupdateSettings.existsSuperIdentity() || AutoupdateSettings.getPreferences().get(PROP_QUALIFIED_IDENTITY, null) == null) {
            err.log(Level.FINE, "Put new value of PROP_IDE_IDENTITY to " + string2);
            assert (!string2.startsWith("-n+")) : "Generated identity (" + string2 + ") is of wrong format. Old identity was [" + string + "].";
            AutoupdateSettings.getPreferences().put(PROP_IDE_IDENTITY, string2);
            String string3 = AutoupdateSettings.getSuperIdentity();
            if (string3 != null) {
                AutoupdateSettings.getPreferences().put(PROP_SUPER_IDENTITY, string3);
            }
            AutoupdateSettings.getPreferences().put(PROP_QUALIFIED_IDENTITY, AutoupdateSettings.getQualifiedIdentity(string2));
        }
    }

    public static int getPeriod() {
        boolean bl = AutoupdateSettings.getPreferences().get(PROP_PERIOD, null) == null;
        Integer n = null;
        if (bl) {
            n = AutoupdateSettings.parse(Utilities.getCustomCheckIntervalInMinutes());
        }
        if (n == null) {
            n = 2;
        }
        err.log(Level.FINEST, "getPeriod () returns " + AutoupdateSettings.getPreferences().getInt(PROP_PERIOD, n));
        return AutoupdateSettings.getPreferences().getInt(PROP_PERIOD, n);
    }

    public static int getCheckInterval() {
        err.log(Level.FINEST, "getCheckInterval () returns " + checkInterval + "ms");
        return checkInterval;
    }

    public static void setPeriod(int n) {
        err.log(Level.FINEST, "Called setPeriod (" + n + ")");
        AutoupdateSettings.getPreferences().putInt(PROP_PERIOD, n);
    }

    public static Date getLastCheck() {
        long l = AutoupdateSettings.getPreferences().getLong(PROP_LAST_CHECK, -1L);
        return l > 0L ? new Date(l) : null;
    }

    public static void setLastCheck(Date date) {
        err.log(Level.FINER, "Set the last check to " + date);
        if (date != null) {
            AutoupdateSettings.getPreferences().putLong(PROP_LAST_CHECK, date.getTime());
        } else {
            AutoupdateSettings.getPreferences().remove(PROP_LAST_CHECK);
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String modifyIdeIdentityIfNeeded(String string) {
        String string2;
        String string3;
        String string4;
        block13: {
            int n = string.indexOf(48);
            String[] stringArray = string.split("\\d");
            string4 = null;
            string3 = null;
            if (stringArray.length == 0 || n == 0) {
                string4 = string;
                string3 = "";
            } else if (n != -1 && string.substring(stringArray[0].length()).startsWith(new StringBuffer(48).toString())) {
                string3 = string.substring(0, n);
                string4 = string.substring(string3.length());
            } else {
                string3 = stringArray[0];
                string4 = string.substring(string3.length());
            }
            err.log(Level.FINER, "Old IDE Identity Prefix: " + string3);
            err.log(Level.FINER, "Old IDE Identity ID: " + string4);
            string2 = "";
            try {
                FileObject fileObject = FileUtil.getConfigFile((String)"productid");
                if (fileObject == null) break block13;
                try (InputStream inputStream = fileObject.getInputStream();){
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    string2 = bufferedReader.readLine().trim();
                    if (string2.length() > 128) {
                        string2 = string2.substring(0, 128);
                    }
                }
            }
            catch (IOException iOException) {
                err.log(Level.FINER, iOException.getMessage(), iOException);
            }
        }
        if (!string2.equals(string3)) {
            err.log(Level.FINER, "New IDE Identity Prefix: " + string2);
        } else {
            err.log(Level.FINER, "No new prefix.");
        }
        assert (!(string2 + string4).startsWith("-n+")) : "Product Indentity is of wrong format, prefix=" + string2 + ", id=" + string4 + ", oldPrefix=" + string3 + ",oldIdeIdentity=" + string;
        return string2 + string4;
    }

    private static String generateNewId() {
        return UUID.randomUUID().toString();
    }

    private static Integer parse(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Integer n = null;
        for (String[] stringArray : KNOWN) {
            if (!stringArray[0].equalsIgnoreCase(string)) continue;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                assert (false) : "Invalid value " + stringArray + " throws " + numberFormatException;
            }
        }
        if (n == null) {
            try {
                checkInterval = Long.parseLong(string) * 1000L * 60L > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.parseInt(string) * 1000 * 60;
                n = 6;
                err.log(Level.FINE, "Custom value of " + Utilities.PLUGIN_MANAGER_CHECK_INTERVAL + " is " + string + " minutes.");
            }
            catch (NumberFormatException numberFormatException) {
                err.log(Level.FINE, "Invalid value " + string + " of " + Utilities.PLUGIN_MANAGER_CHECK_INTERVAL + " throws " + numberFormatException);
            }
        } else {
            err.log(Level.FINE, "Custom value of " + Utilities.PLUGIN_MANAGER_CHECK_INTERVAL + " is " + string);
        }
        return n;
    }

    private static void expirationCheck() {
        Preferences preferences = AutoupdateSettings.getPreferences();
        String string = preferences.get(EXPIRATION_RECORD, null);
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(VERSIONS_FOR_IMPORT));
        String string2 = new File(System.getProperty("netbeans.user")).getName();
        hashSet.add(string2);
        if (string != null && !hashSet.contains(string)) {
            try {
                List<File> list;
                int n = AutoupdateSettings.getPeriod();
                boolean bl = Utilities.isGlobalInstallation() == null ? false : Utilities.isGlobalInstallation();
                preferences.removeNode();
                AutoupdateSettings.getPreferences().put(IMPORTED, Boolean.toString(true));
                AutoupdateSettings.getPreferences().putInt(PROP_PERIOD, n);
                if (bl && !(list = Utilities.sharedDirs()).isEmpty()) {
                    for (File file : list) {
                        if (!file.exists() || !file.isDirectory() || Utilities.canWriteInCluster(file)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        Utilities.setGlobalInstallation(bl);
                    }
                }
                err.log(Level.FINE, "Don't read preferences from userdir " + string);
            }
            catch (BackingStoreException backingStoreException) {
                err.log(Level.INFO, backingStoreException.getLocalizedMessage(), backingStoreException);
            }
        } else if (string == null) {
            err.log(Level.FINEST, "No preferences imported from previous versoin.");
        } else {
            err.log(Level.FINEST, "Read preferences from userdir " + string);
        }
        err.log(Level.FINEST, "Store current version " + string2 + " for future import.");
        AutoupdateSettings.getPreferences().put(EXPIRATION_RECORD, string2);
    }

    private static boolean existsSuperIdentity() {
        File file = AutoupdateSettings.getSuperFile();
        if (file == null) {
            return true;
        }
        err.log(Level.FINE, "Does " + file + " exist? " + file.exists());
        return file.exists();
    }

    private static File getSuperFile() {
        String string = System.getProperty("user.home");
        if ("memory".equals(string)) {
            err.log(Level.INFO, "IDE launched as JNLP");
            return null;
        }
        File file = AutoupdateSettings.getSuperFileOsSpecific();
        if (file != null) {
            err.log(Level.FINE, "Does OS specific " + file + " exist? " + file.exists());
            if (file != null && file.exists()) {
                return file;
            }
        }
        File file2 = new File(string, DEFAULT_NETBEANS_DIR);
        err.log(Level.FINE, "Does " + file2 + " exist? " + file2.exists());
        if (file2.exists() && file != null) {
            String string2;
            File file3 = new File(file2, SUPER_IDENTITY_FILE_NAME);
            err.log(Level.FINE, "Does " + file3 + " exist on the old place? " + file3.exists());
            if (file3.exists() && (string2 = AutoupdateSettings.readSuperFile(file3)) != null) {
                AutoupdateSettings.writeSuperFile(file, string2);
            }
        } else if (file2.exists() && file == null) {
            file = new File(file2, SUPER_IDENTITY_FILE_NAME);
        }
        return file;
    }

    private static File getSuperFileOsSpecific() {
        String string = System.getProperty("netbeans.default_userdir_root", null);
        err.log(Level.FINER, "netbeans.default_userdir_root: " + string);
        if (string == null) {
            err.warning("The property \"netbeans.default_userdir_root\" was not set!");
            return null;
        }
        File file = new File(string);
        file.mkdirs();
        return new File(file, SUPER_IDENTITY_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSuperFile(File file, String string) {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(string);
            superId = string;
            err.log(Level.FINE, "Wrote Super Id: " + superId + " in " + file);
        }
        catch (IOException iOException) {
            err.log(Level.FINER, null, iOException);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {
                err.log(Level.FINER, null, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readSuperFile(File file) {
        String string = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            string = bufferedReader.readLine().trim();
            err.log(Level.FINE, "Read Super Id: " + string + " from " + file);
        }
        catch (IOException iOException) {
            err.log(Level.FINER, null, iOException);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {
                err.log(Level.FINER, null, iOException);
            }
        }
        return string;
    }

    private static String getSuperIdentity() {
        if (superId != null) {
            return superId;
        }
        File file = AutoupdateSettings.getSuperFile();
        if (file == null) {
            err.log(Level.FINE, "superFile was returns null.");
            return null;
        }
        if (file.exists()) {
            superId = AutoupdateSettings.readSuperFile(file);
        } else {
            superId = AutoupdateSettings.generateNewId();
            AutoupdateSettings.writeSuperFile(file, superId);
        }
        if (superId != null) {
            err.log(Level.FINE, "Returns Super Id: " + superId);
            return superId;
        }
        err.log(Level.FINE, "Was problem while handling Super Id. Returns null");
        return null;
    }

    private static String getQualifiedIdentity(String string) {
        if (AutoupdateSettings.getSuperIdentity() != null) {
            err.log(Level.FINE, "Returns Qualified Id: " + string + '_' + AutoupdateSettings.getSuperIdentity());
            return string + '_' + AutoupdateSettings.getSuperIdentity();
        }
        err.log(Level.FINE, "Was problem while handling Qualified Id. Returns only original Id: " + string);
        return string;
    }
}

