/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;

public class ProfilerXYTooltipPainter
extends JPanel {
    private static Color BACKGROUND_COLOR = Utils.forceSpeed() ? new Color(80, 80, 80) : new Color(0, 0, 0, 170);
    private JLabel caption;
    private JLabel[] valuePainters;
    private JLabel[] extraValuePainters;
    private final ProfilerXYTooltipModel model;
    private boolean initialized;

    public ProfilerXYTooltipPainter(ProfilerXYTooltipModel profilerXYTooltipModel) {
        this.model = profilerXYTooltipModel;
        this.initialized = false;
    }

    public void update(List<ItemSelection> list) {
        int n;
        if (!this.initialized) {
            this.initComponents();
        }
        int n2 = this.model.getRowsCount();
        if (list.size() != n2) {
            throw new IllegalStateException("Rows and selected items don't match");
        }
        XYItemSelection xYItemSelection = (XYItemSelection)list.get(0);
        long l = xYItemSelection.getItem().getXValue(xYItemSelection.getValueIndex());
        this.caption.setText(this.model.getTimeValue(l));
        for (n = 0; n < n2; ++n) {
            XYItemSelection xYItemSelection2 = (XYItemSelection)list.get(n);
            long l2 = xYItemSelection2.getItem().getYValue(xYItemSelection2.getValueIndex());
            this.valuePainters[n].setText(this.model.getRowValue(n, l2));
        }
        n = this.model.getExtraRowsCount();
        for (int i = 0; i < n; ++i) {
            this.extraValuePainters[i].setText(this.model.getExtraRowValue(i));
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(BACKGROUND_COLOR);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(graphics);
    }

    private void initComponents() {
        JComponent jComponent;
        Object object;
        JLabel jLabel;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        Color color = new Color(230, 230, 230);
        this.caption = new JLabel();
        this.caption.setFont(ProfilerXYTooltipPainter.smallerFont(this.caption.getFont()));
        this.caption.setForeground(color);
        this.caption.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.caption, gridBagConstraints);
        final Dimension dimension = new Dimension(0, 0);
        int n = this.model.getRowsCount();
        this.valuePainters = new JLabel[n];
        int n2 = 1;
        while (n2 <= n) {
            JLabel jLabel2;
            JLabel jLabel3 = new JLabel();
            jLabel3.setText(this.model.getRowName(n2 - 1));
            jLabel3.setForeground(Color.WHITE);
            jLabel3.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jLabel3, gridBagConstraints);
            this.valuePainters[n2 - 1] = jLabel2 = new JLabel();
            jLabel2.setForeground(Color.WHITE);
            jLabel2.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)jLabel2, gridBagConstraints);
            jLabel = new JLabel();
            object = this.model.getRowUnits(n2 - 1);
            if (!((String)object).isEmpty()) {
                object = " " + (String)object;
            }
            jLabel.setText((String)object);
            jLabel.setForeground(Color.WHITE);
            jLabel.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jLabel, gridBagConstraints);
            jComponent = new JPanel(null){

                @Override
                public Dimension getPreferredSize() {
                    return dimension;
                }
            };
            jComponent.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
        }
        n2 = this.model.getExtraRowsCount();
        this.extraValuePainters = new JLabel[n];
        for (int i = 1; i <= n2; ++i) {
            int n3 = i == 1 ? 5 : 0;
            jLabel = new JLabel();
            jLabel.setText(this.model.getExtraRowName(i - 1));
            jLabel.setFont(ProfilerXYTooltipPainter.smallerFont(jLabel.getFont()));
            jLabel.setForeground(color);
            jLabel.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n + i;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(n3, 0, 0, 0);
            this.add((Component)jLabel, gridBagConstraints);
            object = new JLabel();
            this.extraValuePainters[i - 1] = object;
            ((JComponent)object).setFont(ProfilerXYTooltipPainter.smallerFont(((Component)object).getFont()));
            ((JComponent)object).setForeground(color);
            ((JComponent)object).setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n + i;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(n3, 8, 0, 0);
            this.add((Component)object, gridBagConstraints);
            jComponent = new JLabel();
            String string = this.model.getExtraRowUnits(i - 1);
            if (!string.isEmpty()) {
                string = " " + string;
            }
            ((JLabel)jComponent).setText(string);
            jComponent.setFont(ProfilerXYTooltipPainter.smallerFont(jComponent.getFont()));
            jComponent.setForeground(color);
            jComponent.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n + i;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(n3, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
            JPanel jPanel = new JPanel(null){

                @Override
                public Dimension getPreferredSize() {
                    return dimension;
                }
            };
            jPanel.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n + i;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(n3, 0, 0, 0);
            this.add((Component)jPanel, gridBagConstraints);
        }
        this.initialized = true;
    }

    private static Font smallerFont(Font font) {
        return new Font(font.getName(), font.getStyle(), font.getSize() - 2);
    }
}

