/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.AlgorithmParameters;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ECUtil {
    ECUtil() {
    }

    static boolean isECPrivateKey(PrivateKey privateKey) {
        return privateKey instanceof ECPrivateKey || "EC".equalsIgnoreCase(privateKey.getAlgorithm());
    }

    static boolean isCurveSupported(String string, JcaJceHelper jcaJceHelper) {
        try {
            AlgorithmParameters algorithmParameters = jcaJceHelper.createAlgorithmParameters("EC");
            algorithmParameters.init(new ECGenParameterSpec(string));
            if (algorithmParameters.getParameterSpec(ECParameterSpec.class) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

