// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32f100.svd, see https://github.com/tinygo-org/stm32-svd

// +build stm32,stm32f100

// STM32F100
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32F100"
)

// Interrupt numbers.
const (
	// Window watchdog
	IRQ_WWDG = 0

	// Power control
	IRQ_PVD = 1

	// EXTI
	IRQ_TAMPER_STAMP = 2

	// Real time clock
	IRQ_RTC_WKUP = 3

	// FLASH
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// EXTI
	IRQ_EXTI0 = 6

	// EXTI
	IRQ_EXTI1 = 7

	// EXTI
	IRQ_EXTI2 = 8

	// EXTI
	IRQ_EXTI3 = 9

	// EXTI
	IRQ_EXTI4 = 10

	// DMA controller
	IRQ_DMA1_Channel1 = 11

	// DMA controller
	IRQ_DMA1_Channel2 = 12

	// DMA controller
	IRQ_DMA1_Channel3 = 13

	// DMA controller
	IRQ_DMA1_Channel4 = 14

	// DMA controller
	IRQ_DMA1_Channel5 = 15

	// DMA controller
	IRQ_DMA1_Channel6 = 16

	// DMA controller
	IRQ_DMA1_Channel7 = 17

	// Analog to digital converter
	IRQ_ADC = 18

	// EXTI
	IRQ_EXTI9_5 = 23

	// Advanced timer
	IRQ_TIM1_BRK_TIM15 = 24

	// Advanced timer
	IRQ_TIM1_UP_TIM16 = 25

	// Advanced timer
	IRQ_TIM1_TRG_COM_TIM17 = 26

	// Advanced timer
	IRQ_TIM1_CC = 27

	// General purpose timer
	IRQ_TIM2 = 28

	IRQ_TIM3 = 29

	IRQ_TIM4 = 30

	// Inter integrated circuit
	IRQ_I2C1_EV = 31

	// Inter integrated circuit
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// EXTI
	IRQ_EXTI15_10 = 40

	// Real time clock
	IRQ_RTCAlarm = 41

	// HDMI-CEC controller
	IRQ_CEC = 42

	// General purpose timer
	IRQ_TIM12 = 43

	// General purpose timer
	IRQ_TIM13 = 44

	IRQ_TIM14 = 45

	// Flexible static memory controller
	IRQ_FSMC = 48

	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	// Universal asynchronous receiver transmitter
	IRQ_UART4 = 52

	IRQ_UART5 = 53

	// Basic timer
	IRQ_TIM6_DAC = 54

	IRQ_TIM7 = 55

	IRQ_DMA2_Channel1 = 56

	IRQ_DMA2_Channel2 = 57

	IRQ_DMA2_Channel3 = 58

	IRQ_DMA2_Channel4_5 = 59

	// Highest interrupt number on this device.
	IRQ_max = 59
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_PVD, "PVD_IRQHandler")
	_ = interrupt.Register(IRQ_TAMPER_STAMP, "TAMPER_STAMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP, "RTC_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0, "EXTI0_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1, "EXTI1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2, "EXTI2_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3, "EXTI3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4, "EXTI4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel1, "DMA1_Channel1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel2, "DMA1_Channel2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel3, "DMA1_Channel3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel4, "DMA1_Channel4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel5, "DMA1_Channel5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel6, "DMA1_Channel6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel7, "DMA1_Channel7_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI9_5, "EXTI9_5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_TIM15, "TIM1_BRK_TIM15_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_UP_TIM16, "TIM1_UP_TIM16_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_TRG_COM_TIM17, "TIM1_TRG_COM_TIM17_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM4, "TIM4_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV, "I2C1_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER, "I2C1_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_EV, "I2C2_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_ER, "I2C2_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI15_10, "EXTI15_10_IRQHandler")
	_ = interrupt.Register(IRQ_RTCAlarm, "RTCAlarm_IRQHandler")
	_ = interrupt.Register(IRQ_CEC, "CEC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM12, "TIM12_IRQHandler")
	_ = interrupt.Register(IRQ_TIM13, "TIM13_IRQHandler")
	_ = interrupt.Register(IRQ_TIM14, "TIM14_IRQHandler")
	_ = interrupt.Register(IRQ_FSMC, "FSMC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM5, "TIM5_IRQHandler")
	_ = interrupt.Register(IRQ_SPI3, "SPI3_IRQHandler")
	_ = interrupt.Register(IRQ_UART4, "UART4_IRQHandler")
	_ = interrupt.Register(IRQ_UART5, "UART5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DAC, "TIM6_DAC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7, "TIM7_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Channel1, "DMA2_Channel1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Channel2, "DMA2_Channel2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Channel3, "DMA2_Channel3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Channel4_5, "DMA2_Channel4_5_IRQHandler")
)

// Peripherals.
var (
	// Flexible static memory controller
	FSMC = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// General purpose I/O
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40010800)))

	// Alternate function I/O
	AFIO = (*AFIO_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// EXTI
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Real time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Backup registers
	BKP = (*BKP_Type)(unsafe.Pointer(uintptr(0x40006c04)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Advanced timer
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// General purpose timer
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timer
	TIM12 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// General purpose timer
	TIM13 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// Basic timer
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Inter integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Analog to digital converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))

	// Digital to analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Debug support
	DBGMCU = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// Universal asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// CRC calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// FLASH
	FLASH = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// General purpose timers
	TIM15 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General-purpose-timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// HDMI-CEC controller
	CEC = (*CEC_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// General purpose I/O
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40010c00)))

	// General purpose I/O
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// General purpose I/O
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// General purpose I/O
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40011800)))

	// General purpose I/O
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40011c00)))

	// General purpose I/O
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General purpose timer
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General purpose timer
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General purpose timer
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// General purpose timer
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Basic timer
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Inter integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// General-purpose-timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))
)

// Flexible static memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [228]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// Reset and clock control
type RCC_Type struct {
	CR       volatile.Register32 // 0x0
	CFGR     volatile.Register32 // 0x4
	CIR      volatile.Register32 // 0x8
	APB2RSTR volatile.Register32 // 0xC
	APB1RSTR volatile.Register32 // 0x10
	AHBENR   volatile.Register32 // 0x14
	APB2ENR  volatile.Register32 // 0x18
	APB1ENR  volatile.Register32 // 0x1C
	BDCR     volatile.Register32 // 0x20
	CSR      volatile.Register32 // 0x24
	_        [4]byte
	CFGR2    volatile.Register32 // 0x2C
}

// General purpose I/O
type GPIO_Type struct {
	CRL  volatile.Register32 // 0x0
	CRH  volatile.Register32 // 0x4
	IDR  volatile.Register32 // 0x8
	ODR  volatile.Register32 // 0xC
	BSRR volatile.Register32 // 0x10
	BRR  volatile.Register32 // 0x14
	LCKR volatile.Register32 // 0x18
}

// Alternate function I/O
type AFIO_Type struct {
	EVCR    volatile.Register32 // 0x0
	MAPR    volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [4]byte
	MAPR2   volatile.Register32 // 0x1C
}

// EXTI
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// DMA controller
type DMA_Type struct {
	ISR  volatile.Register32 // 0x0
	IFCR volatile.Register32 // 0x4
	CH   [7]struct {
		CR   volatile.Register32
		NDTR volatile.Register32
		PAR  volatile.Register32
		MAR  volatile.Register32
		_    [4]byte
	} // 0x8
}

// Real time clock
type RTC_Type struct {
	CRH  volatile.Register32 // 0x0
	CRL  volatile.Register32 // 0x4
	PRLH volatile.Register32 // 0x8
	PRLL volatile.Register32 // 0xC
	DIVH volatile.Register32 // 0x10
	DIVL volatile.Register32 // 0x14
	CNTH volatile.Register32 // 0x18
	CNTL volatile.Register32 // 0x1C
	ALRH volatile.Register32 // 0x20
	ALRL volatile.Register32 // 0x24
}

// Backup registers
type BKP_Type struct {
	DR0      volatile.Register32 // 0x0
	DR1      volatile.Register32 // 0x4
	DR2      volatile.Register32 // 0x8
	DR3      volatile.Register32 // 0xC
	DR4      volatile.Register32 // 0x10
	DR5      volatile.Register32 // 0x14
	DR6      volatile.Register32 // 0x18
	DR7      volatile.Register32 // 0x1C
	DR8      volatile.Register32 // 0x20
	DR9      volatile.Register32 // 0x24
	RTCCR    volatile.Register32 // 0x28
	CR       volatile.Register32 // 0x2C
	CSR      volatile.Register32 // 0x30
	_        [8]byte
	BKP_DR0  volatile.Register32 // 0x3C
	BKP_DR1  volatile.Register32 // 0x40
	BKP_DR2  volatile.Register32 // 0x44
	BKP_DR3  volatile.Register32 // 0x48
	BKP_DR4  volatile.Register32 // 0x4C
	BKP_DR5  volatile.Register32 // 0x50
	BKP_DR6  volatile.Register32 // 0x54
	BKP_DR7  volatile.Register32 // 0x58
	BKP_DR8  volatile.Register32 // 0x5C
	BKP_DR9  volatile.Register32 // 0x60
	BKP_DR10 volatile.Register32 // 0x64
	BKP_DR11 volatile.Register32 // 0x68
	BKP_DR12 volatile.Register32 // 0x6C
	BKP_DR13 volatile.Register32 // 0x70
	BKP_DR14 volatile.Register32 // 0x74
	BKP_DR15 volatile.Register32 // 0x78
	BKP_DR16 volatile.Register32 // 0x7C
	BKP_DR17 volatile.Register32 // 0x80
	BKP_DR18 volatile.Register32 // 0x84
	BKP_DR19 volatile.Register32 // 0x88
	BKP_DR20 volatile.Register32 // 0x8C
	BKP_DR21 volatile.Register32 // 0x90
	BKP_DR22 volatile.Register32 // 0x94
	BKP_DR23 volatile.Register32 // 0x98
	BKP_DR24 volatile.Register32 // 0x9C
	BKP_DR25 volatile.Register32 // 0xA0
	BKP_DR26 volatile.Register32 // 0xA4
	BKP_DR27 volatile.Register32 // 0xA8
	BKP_DR28 volatile.Register32 // 0xAC
	BKP_DR29 volatile.Register32 // 0xB0
	BKP_DR30 volatile.Register32 // 0xB4
	BKP_DR31 volatile.Register32 // 0xB8
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Advanced timer
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// Inter integrated circuit
type I2C_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	OAR1  volatile.Register32 // 0x8
	OAR2  volatile.Register32 // 0xC
	DR    volatile.Register32 // 0x10
	SR1   volatile.Register32 // 0x14
	SR2   volatile.Register32 // 0x18
	CCR   volatile.Register32 // 0x1C
	TRISE volatile.Register32 // 0x20
}

// Serial peripheral interface
type SPI_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	SR     volatile.Register32 // 0x8
	DR     volatile.Register32 // 0xC
	CRCPR  volatile.Register32 // 0x10
	RXCRCR volatile.Register32 // 0x14
	TXCRCR volatile.Register32 // 0x18
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	SR   volatile.Register32 // 0x0
	DR   volatile.Register32 // 0x4
	BRR  volatile.Register32 // 0x8
	CR1  volatile.Register32 // 0xC
	CR2  volatile.Register32 // 0x10
	CR3  volatile.Register32 // 0x14
	GTPR volatile.Register32 // 0x18
}

// Analog to digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	JOFR1 volatile.Register32 // 0x14
	JOFR2 volatile.Register32 // 0x18
	JOFR3 volatile.Register32 // 0x1C
	JOFR4 volatile.Register32 // 0x20
	HTR   volatile.Register32 // 0x24
	LTR   volatile.Register32 // 0x28
	SQR1  volatile.Register32 // 0x2C
	SQR2  volatile.Register32 // 0x30
	SQR3  volatile.Register32 // 0x34
	JSQR  volatile.Register32 // 0x38
	JDR1  volatile.Register32 // 0x3C
	JDR2  volatile.Register32 // 0x40
	JDR3  volatile.Register32 // 0x44
	JDR4  volatile.Register32 // 0x48
	DR    volatile.Register32 // 0x4C
}

// Digital to analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// Debug support
type DBG_Type struct {
	IDCODE volatile.Register32 // 0x0
	CR     volatile.Register32 // 0x4
}

// CRC calculation unit
type CRC_Type struct {
	DR  volatile.Register32 // 0x0
	IDR volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	AR      volatile.Register32 // 0x14
	_       [4]byte
	OBR     volatile.Register32 // 0x1C
	WRPR    volatile.Register32 // 0x20
}

// HDMI-CEC controller
type CEC_Type struct {
	CFGR volatile.Register32 // 0x0
	OAR  volatile.Register32 // 0x4
	PRES volatile.Register32 // 0x8
	ESR  volatile.Register32 // 0xC
	CSR  volatile.Register32 // 0x10
	TXD  volatile.Register32 // 0x14
	RXD  volatile.Register32 // 0x18
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	_     [120]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	_     [120]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	_     [120]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	_     [120]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	_     [248]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// System control block ACTLR
type SCB_Type struct {
	ACTRL volatile.Register32 // 0x0
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD_ volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// Bitfields for FSMC: Flexible static memory controller
const (
	// BCR1: SRAM/NOR-Flash chip-select control register 1
	// Position of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR1_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR1_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR1_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR1_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR1_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR1_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR1_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR1_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR1_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR1_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR1_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR1_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR1_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR1_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR1_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR1_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR1_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR1_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR1_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR1_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR1_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR1_WAITCFG_DuringWaitState = 0x1
	// Position of WAITPOL field.
	FSMC_BCR1_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR1_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR1_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR1_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR1_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR1_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR1_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR1_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR1_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR1_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR1_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR1_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR1_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR1_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR1_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR1_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR1_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR1_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR1_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR1_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR1_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR1_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR1_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR1_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR1_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR1_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR1_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR1_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR1_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR1_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR1_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR1_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR1_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR1_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR1_MBKEN_Enabled = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR1_WRAPMOD = 0x400
	// Position of CPSIZE field.
	FSMC_BCR1_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR1_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR1_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes1024 = 0x4

	// BTR1: SRAM/NOR-Flash chip-select timing register 1
	// Position of ACCMOD field.
	FSMC_BTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BTR_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FSMC_BTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BTR_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FSMC_BTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BTR_ADDSET_Msk = 0xf

	// BCR2: SRAM/NOR-Flash chip-select control register 2
	// Position of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR_WAITCFG_DuringWaitState = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR_WRAPMOD = 0x400
	// Position of WAITPOL field.
	FSMC_BCR_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR_MBKEN_Enabled = 0x1
	// Position of CPSIZE field.
	FSMC_BCR_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes1024 = 0x4

	// BWTR1: SRAM/NOR-Flash write timing registers 1
	// Position of ACCMOD field.
	FSMC_BWTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BWTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BWTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BWTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BWTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BWTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BWTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BWTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BWTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BWTR_CLKDIV_Msk = 0xf00000
	// Position of DATAST field.
	FSMC_BWTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BWTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BWTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BWTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BWTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BWTR_ADDSET_Msk = 0xf
	// Position of BUSTURN field.
	FSMC_BWTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BWTR_BUSTURN_Msk = 0xf0000
)

// Bitfields for PWR: Power control
const (
	// CR: Power control register (PWR_CR)
	// Position of LPDS field.
	PWR_CR_LPDS_Pos = 0x0
	// Bit mask of LPDS field.
	PWR_CR_LPDS_Msk = 0x1
	// Bit LPDS.
	PWR_CR_LPDS = 0x1
	// Position of PDDS field.
	PWR_CR_PDDS_Pos = 0x1
	// Bit mask of PDDS field.
	PWR_CR_PDDS_Msk = 0x2
	// Bit PDDS.
	PWR_CR_PDDS = 0x2
	// Enter Stop mode when the CPU enters deepsleep
	PWR_CR_PDDS_STOP_MODE = 0x0
	// Enter Standby mode when the CPU enters deepsleep
	PWR_CR_PDDS_STANDBY_MODE = 0x1
	// Position of CWUF field.
	PWR_CR_CWUF_Pos = 0x2
	// Bit mask of CWUF field.
	PWR_CR_CWUF_Msk = 0x4
	// Bit CWUF.
	PWR_CR_CWUF = 0x4
	// Position of CSBF field.
	PWR_CR_CSBF_Pos = 0x3
	// Bit mask of CSBF field.
	PWR_CR_CSBF_Msk = 0x8
	// Bit CSBF.
	PWR_CR_CSBF = 0x8
	// Position of PVDE field.
	PWR_CR_PVDE_Pos = 0x4
	// Bit mask of PVDE field.
	PWR_CR_PVDE_Msk = 0x10
	// Bit PVDE.
	PWR_CR_PVDE = 0x10
	// Position of PLS field.
	PWR_CR_PLS_Pos = 0x5
	// Bit mask of PLS field.
	PWR_CR_PLS_Msk = 0xe0
	// Position of DBP field.
	PWR_CR_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR_DBP = 0x100

	// CSR: Power control register (PWR_CR)
	// Position of WUF field.
	PWR_CSR_WUF_Pos = 0x0
	// Bit mask of WUF field.
	PWR_CSR_WUF_Msk = 0x1
	// Bit WUF.
	PWR_CSR_WUF = 0x1
	// Position of SBF field.
	PWR_CSR_SBF_Pos = 0x1
	// Bit mask of SBF field.
	PWR_CSR_SBF_Msk = 0x2
	// Bit SBF.
	PWR_CSR_SBF = 0x2
	// Position of PVDO field.
	PWR_CSR_PVDO_Pos = 0x2
	// Bit mask of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4
	// Bit PVDO.
	PWR_CSR_PVDO = 0x4
	// Position of EWUP field.
	PWR_CSR_EWUP_Pos = 0x8
	// Bit mask of EWUP field.
	PWR_CSR_EWUP_Msk = 0x100
	// Bit EWUP.
	PWR_CSR_EWUP = 0x100
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x0
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x1
	// Bit HSION.
	RCC_CR_HSION = 0x1
	// Clock Off
	RCC_CR_HSION_Off = 0x0
	// Clock On
	RCC_CR_HSION_On = 0x1
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0x1
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x2
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x2
	// Clock not ready
	RCC_CR_HSIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSIRDY_Ready = 0x1
	// Position of HSITRIM field.
	RCC_CR_HSITRIM_Pos = 0x3
	// Bit mask of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8
	// Position of HSICAL field.
	RCC_CR_HSICAL_Pos = 0x8
	// Bit mask of HSICAL field.
	RCC_CR_HSICAL_Msk = 0xff00
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Clock Off
	RCC_CR_HSEON_Off = 0x0
	// Clock On
	RCC_CR_HSEON_On = 0x1
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Clock not ready
	RCC_CR_HSERDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSERDY_Ready = 0x1
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// HSE crystal oscillator not bypassed
	RCC_CR_HSEBYP_NotBypassed = 0x0
	// HSE crystal oscillator bypassed with external clock
	RCC_CR_HSEBYP_Bypassed = 0x1
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Clock security system disabled (clock detector OFF)
	RCC_CR_CSSON_Off = 0x0
	// Clock security system enable (clock detector ON if the HSE is ready, OFF if not)
	RCC_CR_CSSON_On = 0x1
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Clock Off
	RCC_CR_PLLON_Off = 0x0
	// Clock On
	RCC_CR_PLLON_On = 0x1
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Clock not ready
	RCC_CR_PLLRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLRDY_Ready = 0x1

	// CFGR: Clock configuration register (RCC_CFGR)
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3
	// HSI selected as system clock
	RCC_CFGR_SW_HSI = 0x0
	// HSE selected as system clock
	RCC_CFGR_SW_HSE = 0x1
	// PLL selected as system clock
	RCC_CFGR_SW_PLL = 0x2
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// HSI oscillator used as system clock
	RCC_CFGR_SWS_HSI = 0x0
	// HSE oscillator used as system clock
	RCC_CFGR_SWS_HSE = 0x1
	// PLL used as system clock
	RCC_CFGR_SWS_PLL = 0x2
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// SYSCLK not divided
	RCC_CFGR_HPRE_Div1 = 0x0
	// SYSCLK divided by 2
	RCC_CFGR_HPRE_Div2 = 0x8
	// SYSCLK divided by 4
	RCC_CFGR_HPRE_Div4 = 0x9
	// SYSCLK divided by 8
	RCC_CFGR_HPRE_Div8 = 0xa
	// SYSCLK divided by 16
	RCC_CFGR_HPRE_Div16 = 0xb
	// SYSCLK divided by 64
	RCC_CFGR_HPRE_Div64 = 0xc
	// SYSCLK divided by 128
	RCC_CFGR_HPRE_Div128 = 0xd
	// SYSCLK divided by 256
	RCC_CFGR_HPRE_Div256 = 0xe
	// SYSCLK divided by 512
	RCC_CFGR_HPRE_Div512 = 0xf
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0x8
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x700
	// HCLK not divided
	RCC_CFGR_PPRE1_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE1_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE1_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE1_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE1_Div16 = 0x7
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xb
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0x3800
	// HCLK not divided
	RCC_CFGR_PPRE2_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE2_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE2_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE2_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE2_Div16 = 0x7
	// Position of ADCPRE field.
	RCC_CFGR_ADCPRE_Pos = 0xe
	// Bit mask of ADCPRE field.
	RCC_CFGR_ADCPRE_Msk = 0xc000
	// PCLK2 divided by 2
	RCC_CFGR_ADCPRE_Div2 = 0x0
	// PCLK2 divided by 4
	RCC_CFGR_ADCPRE_Div4 = 0x1
	// PCLK2 divided by 8
	RCC_CFGR_ADCPRE_Div6 = 0x2
	// PCLK2 divided by 16
	RCC_CFGR_ADCPRE_Div8 = 0x3
	// Position of PLLSRC field.
	RCC_CFGR_PLLSRC_Pos = 0x10
	// Bit mask of PLLSRC field.
	RCC_CFGR_PLLSRC_Msk = 0x10000
	// Bit PLLSRC.
	RCC_CFGR_PLLSRC = 0x10000
	// HSI divided by 2 selected as PLL input clock
	RCC_CFGR_PLLSRC_HSI_Div2 = 0x0
	// HSE divided by PREDIV selected as PLL input clock
	RCC_CFGR_PLLSRC_HSE_Div_PREDIV = 0x1
	// Position of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE_Pos = 0x11
	// Bit mask of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE_Msk = 0x20000
	// Bit PLLXTPRE.
	RCC_CFGR_PLLXTPRE = 0x20000
	// HSE clock not divided
	RCC_CFGR_PLLXTPRE_Div1 = 0x0
	// HSE clock divided by 2
	RCC_CFGR_PLLXTPRE_Div2 = 0x1
	// Position of PLLMUL field.
	RCC_CFGR_PLLMUL_Pos = 0x12
	// Bit mask of PLLMUL field.
	RCC_CFGR_PLLMUL_Msk = 0x3c0000
	// PLL input clock x2
	RCC_CFGR_PLLMUL_Mul2 = 0x0
	// PLL input clock x3
	RCC_CFGR_PLLMUL_Mul3 = 0x1
	// PLL input clock x4
	RCC_CFGR_PLLMUL_Mul4 = 0x2
	// PLL input clock x5
	RCC_CFGR_PLLMUL_Mul5 = 0x3
	// PLL input clock x6
	RCC_CFGR_PLLMUL_Mul6 = 0x4
	// PLL input clock x7
	RCC_CFGR_PLLMUL_Mul7 = 0x5
	// PLL input clock x8
	RCC_CFGR_PLLMUL_Mul8 = 0x6
	// PLL input clock x9
	RCC_CFGR_PLLMUL_Mul9 = 0x7
	// PLL input clock x10
	RCC_CFGR_PLLMUL_Mul10 = 0x8
	// PLL input clock x11
	RCC_CFGR_PLLMUL_Mul11 = 0x9
	// PLL input clock x12
	RCC_CFGR_PLLMUL_Mul12 = 0xa
	// PLL input clock x13
	RCC_CFGR_PLLMUL_Mul13 = 0xb
	// PLL input clock x14
	RCC_CFGR_PLLMUL_Mul14 = 0xc
	// PLL input clock x15
	RCC_CFGR_PLLMUL_Mul15 = 0xd
	// PLL input clock x16
	RCC_CFGR_PLLMUL_Mul16 = 0xe
	// PLL input clock x16
	RCC_CFGR_PLLMUL_Mul16x = 0xf
	// Position of MCO field.
	RCC_CFGR_MCO_Pos = 0x18
	// Bit mask of MCO field.
	RCC_CFGR_MCO_Msk = 0x7000000
	// MCO output disabled, no clock on MCO
	RCC_CFGR_MCO_NoMCO = 0x0
	// System clock selected
	RCC_CFGR_MCO_SYSCLK = 0x4
	// HSI oscillator clock selected
	RCC_CFGR_MCO_HSI = 0x5
	// HSE oscillator clock selected
	RCC_CFGR_MCO_HSE = 0x6
	// PLL clock selected (divided by 1 or 2, depending en PLLNODIV)
	RCC_CFGR_MCO_PLL = 0x7

	// CIR: Clock interrupt register (RCC_CIR)
	// Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIR_LSIRDYF = 0x1
	// No clock ready interrupt
	RCC_CIR_LSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSIRDYF_Interrupted = 0x1
	// Position of LSERDYF field.
	RCC_CIR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIR_LSERDYF = 0x2
	// No clock ready interrupt
	RCC_CIR_LSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSERDYF_Interrupted = 0x1
	// Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Pos = 0x2
	// Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk = 0x4
	// Bit HSIRDYF.
	RCC_CIR_HSIRDYF = 0x4
	// No clock ready interrupt
	RCC_CIR_HSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSIRDYF_Interrupted = 0x1
	// Position of HSERDYF field.
	RCC_CIR_HSERDYF_Pos = 0x3
	// Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF_Msk = 0x8
	// Bit HSERDYF.
	RCC_CIR_HSERDYF = 0x8
	// No clock ready interrupt
	RCC_CIR_HSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSERDYF_Interrupted = 0x1
	// Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Pos = 0x4
	// Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk = 0x10
	// Bit PLLRDYF.
	RCC_CIR_PLLRDYF = 0x10
	// No clock ready interrupt
	RCC_CIR_PLLRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLRDYF_Interrupted = 0x1
	// Position of CSSF field.
	RCC_CIR_CSSF_Pos = 0x7
	// Bit mask of CSSF field.
	RCC_CIR_CSSF_Msk = 0x80
	// Bit CSSF.
	RCC_CIR_CSSF = 0x80
	// No clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_NotInterrupted = 0x0
	// Clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_Interrupted = 0x1
	// Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Pos = 0x8
	// Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100
	// Bit LSIRDYIE.
	RCC_CIR_LSIRDYIE = 0x100
	// Interrupt disabled
	RCC_CIR_LSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSIRDYIE_Enabled = 0x1
	// Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Pos = 0x9
	// Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200
	// Bit LSERDYIE.
	RCC_CIR_LSERDYIE = 0x200
	// Interrupt disabled
	RCC_CIR_LSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSERDYIE_Enabled = 0x1
	// Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Pos = 0xa
	// Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400
	// Bit HSIRDYIE.
	RCC_CIR_HSIRDYIE = 0x400
	// Interrupt disabled
	RCC_CIR_HSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSIRDYIE_Enabled = 0x1
	// Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Pos = 0xb
	// Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800
	// Bit HSERDYIE.
	RCC_CIR_HSERDYIE = 0x800
	// Interrupt disabled
	RCC_CIR_HSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSERDYIE_Enabled = 0x1
	// Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Pos = 0xc
	// Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000
	// Bit PLLRDYIE.
	RCC_CIR_PLLRDYIE = 0x1000
	// Interrupt disabled
	RCC_CIR_PLLRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLRDYIE_Enabled = 0x1
	// Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Pos = 0x10
	// Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk = 0x10000
	// Bit LSIRDYC.
	RCC_CIR_LSIRDYC = 0x10000
	// Clear interrupt flag
	RCC_CIR_LSIRDYC_Clear = 0x1
	// Position of LSERDYC field.
	RCC_CIR_LSERDYC_Pos = 0x11
	// Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC_Msk = 0x20000
	// Bit LSERDYC.
	RCC_CIR_LSERDYC = 0x20000
	// Clear interrupt flag
	RCC_CIR_LSERDYC_Clear = 0x1
	// Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Pos = 0x12
	// Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk = 0x40000
	// Bit HSIRDYC.
	RCC_CIR_HSIRDYC = 0x40000
	// Clear interrupt flag
	RCC_CIR_HSIRDYC_Clear = 0x1
	// Position of HSERDYC field.
	RCC_CIR_HSERDYC_Pos = 0x13
	// Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC_Msk = 0x80000
	// Bit HSERDYC.
	RCC_CIR_HSERDYC = 0x80000
	// Clear interrupt flag
	RCC_CIR_HSERDYC_Clear = 0x1
	// Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Pos = 0x14
	// Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk = 0x100000
	// Bit PLLRDYC.
	RCC_CIR_PLLRDYC = 0x100000
	// Clear interrupt flag
	RCC_CIR_PLLRDYC_Clear = 0x1
	// Position of CSSC field.
	RCC_CIR_CSSC_Pos = 0x17
	// Bit mask of CSSC field.
	RCC_CIR_CSSC_Msk = 0x800000
	// Bit CSSC.
	RCC_CIR_CSSC = 0x800000
	// Clear CSSF flag
	RCC_CIR_CSSC_Clear = 0x1

	// APB2RSTR: APB2 peripheral reset register (RCC_APB2RSTR)
	// Position of AFIORST field.
	RCC_APB2RSTR_AFIORST_Pos = 0x0
	// Bit mask of AFIORST field.
	RCC_APB2RSTR_AFIORST_Msk = 0x1
	// Bit AFIORST.
	RCC_APB2RSTR_AFIORST = 0x1
	// Reset the selected module
	RCC_APB2RSTR_AFIORST_Reset = 0x1
	// Position of IOPARST field.
	RCC_APB2RSTR_IOPARST_Pos = 0x2
	// Bit mask of IOPARST field.
	RCC_APB2RSTR_IOPARST_Msk = 0x4
	// Bit IOPARST.
	RCC_APB2RSTR_IOPARST = 0x4
	// Reset the selected module
	RCC_APB2RSTR_IOPARST_Reset = 0x1
	// Position of IOPBRST field.
	RCC_APB2RSTR_IOPBRST_Pos = 0x3
	// Bit mask of IOPBRST field.
	RCC_APB2RSTR_IOPBRST_Msk = 0x8
	// Bit IOPBRST.
	RCC_APB2RSTR_IOPBRST = 0x8
	// Reset the selected module
	RCC_APB2RSTR_IOPBRST_Reset = 0x1
	// Position of IOPCRST field.
	RCC_APB2RSTR_IOPCRST_Pos = 0x4
	// Bit mask of IOPCRST field.
	RCC_APB2RSTR_IOPCRST_Msk = 0x10
	// Bit IOPCRST.
	RCC_APB2RSTR_IOPCRST = 0x10
	// Reset the selected module
	RCC_APB2RSTR_IOPCRST_Reset = 0x1
	// Position of IOPDRST field.
	RCC_APB2RSTR_IOPDRST_Pos = 0x5
	// Bit mask of IOPDRST field.
	RCC_APB2RSTR_IOPDRST_Msk = 0x20
	// Bit IOPDRST.
	RCC_APB2RSTR_IOPDRST = 0x20
	// Reset the selected module
	RCC_APB2RSTR_IOPDRST_Reset = 0x1
	// Position of IOPERST field.
	RCC_APB2RSTR_IOPERST_Pos = 0x6
	// Bit mask of IOPERST field.
	RCC_APB2RSTR_IOPERST_Msk = 0x40
	// Bit IOPERST.
	RCC_APB2RSTR_IOPERST = 0x40
	// Reset the selected module
	RCC_APB2RSTR_IOPERST_Reset = 0x1
	// Position of IOPFRST field.
	RCC_APB2RSTR_IOPFRST_Pos = 0x7
	// Bit mask of IOPFRST field.
	RCC_APB2RSTR_IOPFRST_Msk = 0x80
	// Bit IOPFRST.
	RCC_APB2RSTR_IOPFRST = 0x80
	// Reset the selected module
	RCC_APB2RSTR_IOPFRST_Reset = 0x1
	// Position of IOPGRST field.
	RCC_APB2RSTR_IOPGRST_Pos = 0x8
	// Bit mask of IOPGRST field.
	RCC_APB2RSTR_IOPGRST_Msk = 0x100
	// Bit IOPGRST.
	RCC_APB2RSTR_IOPGRST = 0x100
	// Reset the selected module
	RCC_APB2RSTR_IOPGRST_Reset = 0x1
	// Position of ADC1RST field.
	RCC_APB2RSTR_ADC1RST_Pos = 0x9
	// Bit mask of ADC1RST field.
	RCC_APB2RSTR_ADC1RST_Msk = 0x200
	// Bit ADC1RST.
	RCC_APB2RSTR_ADC1RST = 0x200
	// Reset the selected module
	RCC_APB2RSTR_ADC1RST_Reset = 0x1
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0xb
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x800
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x800
	// Reset the selected module
	RCC_APB2RSTR_TIM1RST_Reset = 0x1
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Reset the selected module
	RCC_APB2RSTR_SPI1RST_Reset = 0x1
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0xe
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x4000
	// Reset the selected module
	RCC_APB2RSTR_USART1RST_Reset = 0x1
	// Position of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Pos = 0x10
	// Bit mask of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Msk = 0x10000
	// Bit TIM15RST.
	RCC_APB2RSTR_TIM15RST = 0x10000
	// Reset the selected module
	RCC_APB2RSTR_TIM15RST_Reset = 0x1
	// Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Pos = 0x11
	// Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk = 0x20000
	// Bit TIM16RST.
	RCC_APB2RSTR_TIM16RST = 0x20000
	// Reset the selected module
	RCC_APB2RSTR_TIM16RST_Reset = 0x1
	// Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Pos = 0x12
	// Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk = 0x40000
	// Bit TIM17RST.
	RCC_APB2RSTR_TIM17RST = 0x40000
	// Reset the selected module
	RCC_APB2RSTR_TIM17RST_Reset = 0x1

	// APB1RSTR: APB1 peripheral reset register (RCC_APB1RSTR)
	// Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR_TIM2RST = 0x1
	// Reset the selected module
	RCC_APB1RSTR_TIM2RST_Reset = 0x1
	// Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APB1RSTR_TIM3RST = 0x2
	// Reset the selected module
	RCC_APB1RSTR_TIM3RST_Reset = 0x1
	// Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Pos = 0x2
	// Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk = 0x4
	// Bit TIM4RST.
	RCC_APB1RSTR_TIM4RST = 0x4
	// Reset the selected module
	RCC_APB1RSTR_TIM4RST_Reset = 0x1
	// Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Pos = 0x3
	// Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk = 0x8
	// Bit TIM5RST.
	RCC_APB1RSTR_TIM5RST = 0x8
	// Reset the selected module
	RCC_APB1RSTR_TIM5RST_Reset = 0x1
	// Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Pos = 0x4
	// Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk = 0x10
	// Bit TIM6RST.
	RCC_APB1RSTR_TIM6RST = 0x10
	// Reset the selected module
	RCC_APB1RSTR_TIM6RST_Reset = 0x1
	// Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Pos = 0x5
	// Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk = 0x20
	// Bit TIM7RST.
	RCC_APB1RSTR_TIM7RST = 0x20
	// Reset the selected module
	RCC_APB1RSTR_TIM7RST_Reset = 0x1
	// Position of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Pos = 0x6
	// Bit mask of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Msk = 0x40
	// Bit TIM12RST.
	RCC_APB1RSTR_TIM12RST = 0x40
	// Reset the selected module
	RCC_APB1RSTR_TIM12RST_Reset = 0x1
	// Position of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Pos = 0x7
	// Bit mask of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Msk = 0x80
	// Bit TIM13RST.
	RCC_APB1RSTR_TIM13RST = 0x80
	// Reset the selected module
	RCC_APB1RSTR_TIM13RST_Reset = 0x1
	// Position of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Pos = 0x8
	// Bit mask of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Msk = 0x100
	// Bit TIM14RST.
	RCC_APB1RSTR_TIM14RST = 0x100
	// Reset the selected module
	RCC_APB1RSTR_TIM14RST_Reset = 0x1
	// Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Pos = 0xb
	// Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk = 0x800
	// Bit WWDGRST.
	RCC_APB1RSTR_WWDGRST = 0x800
	// Reset the selected module
	RCC_APB1RSTR_WWDGRST_Reset = 0x1
	// Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR_SPI2RST = 0x4000
	// Reset the selected module
	RCC_APB1RSTR_SPI2RST_Reset = 0x1
	// Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Pos = 0xf
	// Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk = 0x8000
	// Bit SPI3RST.
	RCC_APB1RSTR_SPI3RST = 0x8000
	// Reset the selected module
	RCC_APB1RSTR_SPI3RST_Reset = 0x1
	// Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Pos = 0x11
	// Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk = 0x20000
	// Bit USART2RST.
	RCC_APB1RSTR_USART2RST = 0x20000
	// Reset the selected module
	RCC_APB1RSTR_USART2RST_Reset = 0x1
	// Position of USART3RST field.
	RCC_APB1RSTR_USART3RST_Pos = 0x12
	// Bit mask of USART3RST field.
	RCC_APB1RSTR_USART3RST_Msk = 0x40000
	// Bit USART3RST.
	RCC_APB1RSTR_USART3RST = 0x40000
	// Reset the selected module
	RCC_APB1RSTR_USART3RST_Reset = 0x1
	// Position of UART4RST field.
	RCC_APB1RSTR_UART4RST_Pos = 0x13
	// Bit mask of UART4RST field.
	RCC_APB1RSTR_UART4RST_Msk = 0x80000
	// Bit UART4RST.
	RCC_APB1RSTR_UART4RST = 0x80000
	// Reset the selected module
	RCC_APB1RSTR_UART4RST_Reset = 0x1
	// Position of UART5RST field.
	RCC_APB1RSTR_UART5RST_Pos = 0x14
	// Bit mask of UART5RST field.
	RCC_APB1RSTR_UART5RST_Msk = 0x100000
	// Bit UART5RST.
	RCC_APB1RSTR_UART5RST = 0x100000
	// Reset the selected module
	RCC_APB1RSTR_UART5RST_Reset = 0x1
	// Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR_I2C1RST = 0x200000
	// Reset the selected module
	RCC_APB1RSTR_I2C1RST_Reset = 0x1
	// Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR_I2C2RST = 0x400000
	// Reset the selected module
	RCC_APB1RSTR_I2C2RST_Reset = 0x1
	// Position of BKPRST field.
	RCC_APB1RSTR_BKPRST_Pos = 0x1b
	// Bit mask of BKPRST field.
	RCC_APB1RSTR_BKPRST_Msk = 0x8000000
	// Bit BKPRST.
	RCC_APB1RSTR_BKPRST = 0x8000000
	// Reset the selected module
	RCC_APB1RSTR_BKPRST_Reset = 0x1
	// Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR_PWRRST = 0x10000000
	// Reset the selected module
	RCC_APB1RSTR_PWRRST_Reset = 0x1
	// Position of DACRST field.
	RCC_APB1RSTR_DACRST_Pos = 0x1d
	// Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST_Msk = 0x20000000
	// Bit DACRST.
	RCC_APB1RSTR_DACRST = 0x20000000
	// Reset the selected module
	RCC_APB1RSTR_DACRST_Reset = 0x1
	// Position of CECRST field.
	RCC_APB1RSTR_CECRST_Pos = 0x1e
	// Bit mask of CECRST field.
	RCC_APB1RSTR_CECRST_Msk = 0x40000000
	// Bit CECRST.
	RCC_APB1RSTR_CECRST = 0x40000000
	// Reset the selected module
	RCC_APB1RSTR_CECRST_Reset = 0x1

	// AHBENR: AHB Peripheral Clock enable register (RCC_AHBENR)
	// Position of DMA1EN field.
	RCC_AHBENR_DMA1EN_Pos = 0x0
	// Bit mask of DMA1EN field.
	RCC_AHBENR_DMA1EN_Msk = 0x1
	// Bit DMA1EN.
	RCC_AHBENR_DMA1EN = 0x1
	// The selected clock is disabled
	RCC_AHBENR_DMA1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_DMA1EN_Enabled = 0x1
	// Position of DMA2EN field.
	RCC_AHBENR_DMA2EN_Pos = 0x1
	// Bit mask of DMA2EN field.
	RCC_AHBENR_DMA2EN_Msk = 0x2
	// Bit DMA2EN.
	RCC_AHBENR_DMA2EN = 0x2
	// The selected clock is disabled
	RCC_AHBENR_DMA2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_DMA2EN_Enabled = 0x1
	// Position of SRAMEN field.
	RCC_AHBENR_SRAMEN_Pos = 0x2
	// Bit mask of SRAMEN field.
	RCC_AHBENR_SRAMEN_Msk = 0x4
	// Bit SRAMEN.
	RCC_AHBENR_SRAMEN = 0x4
	// The selected clock is disabled
	RCC_AHBENR_SRAMEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_SRAMEN_Enabled = 0x1
	// Position of FLITFEN field.
	RCC_AHBENR_FLITFEN_Pos = 0x4
	// Bit mask of FLITFEN field.
	RCC_AHBENR_FLITFEN_Msk = 0x10
	// Bit FLITFEN.
	RCC_AHBENR_FLITFEN = 0x10
	// The selected clock is disabled
	RCC_AHBENR_FLITFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_FLITFEN_Enabled = 0x1
	// Position of CRCEN field.
	RCC_AHBENR_CRCEN_Pos = 0x6
	// Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN_Msk = 0x40
	// Bit CRCEN.
	RCC_AHBENR_CRCEN = 0x40
	// The selected clock is disabled
	RCC_AHBENR_CRCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_CRCEN_Enabled = 0x1
	// Position of FSMCEN field.
	RCC_AHBENR_FSMCEN_Pos = 0x8
	// Bit mask of FSMCEN field.
	RCC_AHBENR_FSMCEN_Msk = 0x100
	// Bit FSMCEN.
	RCC_AHBENR_FSMCEN = 0x100
	// The selected clock is disabled
	RCC_AHBENR_FSMCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_FSMCEN_Enabled = 0x1

	// APB2ENR: APB2 peripheral clock enable register (RCC_APB2ENR)
	// Position of AFIOEN field.
	RCC_APB2ENR_AFIOEN_Pos = 0x0
	// Bit mask of AFIOEN field.
	RCC_APB2ENR_AFIOEN_Msk = 0x1
	// Bit AFIOEN.
	RCC_APB2ENR_AFIOEN = 0x1
	// The selected clock is disabled
	RCC_APB2ENR_AFIOEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_AFIOEN_Enabled = 0x1
	// Position of IOPAEN field.
	RCC_APB2ENR_IOPAEN_Pos = 0x2
	// Bit mask of IOPAEN field.
	RCC_APB2ENR_IOPAEN_Msk = 0x4
	// Bit IOPAEN.
	RCC_APB2ENR_IOPAEN = 0x4
	// The selected clock is disabled
	RCC_APB2ENR_IOPAEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_IOPAEN_Enabled = 0x1
	// Position of IOPBEN field.
	RCC_APB2ENR_IOPBEN_Pos = 0x3
	// Bit mask of IOPBEN field.
	RCC_APB2ENR_IOPBEN_Msk = 0x8
	// Bit IOPBEN.
	RCC_APB2ENR_IOPBEN = 0x8
	// The selected clock is disabled
	RCC_APB2ENR_IOPBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_IOPBEN_Enabled = 0x1
	// Position of IOPCEN field.
	RCC_APB2ENR_IOPCEN_Pos = 0x4
	// Bit mask of IOPCEN field.
	RCC_APB2ENR_IOPCEN_Msk = 0x10
	// Bit IOPCEN.
	RCC_APB2ENR_IOPCEN = 0x10
	// The selected clock is disabled
	RCC_APB2ENR_IOPCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_IOPCEN_Enabled = 0x1
	// Position of IOPDEN field.
	RCC_APB2ENR_IOPDEN_Pos = 0x5
	// Bit mask of IOPDEN field.
	RCC_APB2ENR_IOPDEN_Msk = 0x20
	// Bit IOPDEN.
	RCC_APB2ENR_IOPDEN = 0x20
	// The selected clock is disabled
	RCC_APB2ENR_IOPDEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_IOPDEN_Enabled = 0x1
	// Position of IOPEEN field.
	RCC_APB2ENR_IOPEEN_Pos = 0x6
	// Bit mask of IOPEEN field.
	RCC_APB2ENR_IOPEEN_Msk = 0x40
	// Bit IOPEEN.
	RCC_APB2ENR_IOPEEN = 0x40
	// The selected clock is disabled
	RCC_APB2ENR_IOPEEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_IOPEEN_Enabled = 0x1
	// Position of IOPFEN field.
	RCC_APB2ENR_IOPFEN_Pos = 0x7
	// Bit mask of IOPFEN field.
	RCC_APB2ENR_IOPFEN_Msk = 0x80
	// Bit IOPFEN.
	RCC_APB2ENR_IOPFEN = 0x80
	// The selected clock is disabled
	RCC_APB2ENR_IOPFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_IOPFEN_Enabled = 0x1
	// Position of IOPGEN field.
	RCC_APB2ENR_IOPGEN_Pos = 0x8
	// Bit mask of IOPGEN field.
	RCC_APB2ENR_IOPGEN_Msk = 0x100
	// Bit IOPGEN.
	RCC_APB2ENR_IOPGEN = 0x100
	// The selected clock is disabled
	RCC_APB2ENR_IOPGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_IOPGEN_Enabled = 0x1
	// Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Pos = 0x9
	// Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk = 0x200
	// Bit ADC1EN.
	RCC_APB2ENR_ADC1EN = 0x200
	// The selected clock is disabled
	RCC_APB2ENR_ADC1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC1EN_Enabled = 0x1
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0xb
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x800
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x800
	// The selected clock is disabled
	RCC_APB2ENR_TIM1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM1EN_Enabled = 0x1
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// The selected clock is disabled
	RCC_APB2ENR_SPI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI1EN_Enabled = 0x1
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x4000
	// The selected clock is disabled
	RCC_APB2ENR_USART1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART1EN_Enabled = 0x1
	// Position of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Pos = 0x10
	// Bit mask of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Msk = 0x10000
	// Bit TIM15EN.
	RCC_APB2ENR_TIM15EN = 0x10000
	// The selected clock is disabled
	RCC_APB2ENR_TIM15EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM15EN_Enabled = 0x1
	// Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Pos = 0x11
	// Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk = 0x20000
	// Bit TIM16EN.
	RCC_APB2ENR_TIM16EN = 0x20000
	// The selected clock is disabled
	RCC_APB2ENR_TIM16EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM16EN_Enabled = 0x1
	// Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Pos = 0x12
	// Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk = 0x40000
	// Bit TIM17EN.
	RCC_APB2ENR_TIM17EN = 0x40000
	// The selected clock is disabled
	RCC_APB2ENR_TIM17EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM17EN_Enabled = 0x1

	// APB1ENR: APB1 peripheral clock enable register (RCC_APB1ENR)
	// Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR_TIM2EN = 0x1
	// The selected clock is disabled
	RCC_APB1ENR_TIM2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM2EN_Enabled = 0x1
	// Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APB1ENR_TIM3EN = 0x2
	// The selected clock is disabled
	RCC_APB1ENR_TIM3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM3EN_Enabled = 0x1
	// Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Pos = 0x2
	// Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk = 0x4
	// Bit TIM4EN.
	RCC_APB1ENR_TIM4EN = 0x4
	// The selected clock is disabled
	RCC_APB1ENR_TIM4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM4EN_Enabled = 0x1
	// Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Pos = 0x3
	// Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk = 0x8
	// Bit TIM5EN.
	RCC_APB1ENR_TIM5EN = 0x8
	// The selected clock is disabled
	RCC_APB1ENR_TIM5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM5EN_Enabled = 0x1
	// Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Pos = 0x4
	// Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk = 0x10
	// Bit TIM6EN.
	RCC_APB1ENR_TIM6EN = 0x10
	// The selected clock is disabled
	RCC_APB1ENR_TIM6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM6EN_Enabled = 0x1
	// Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Pos = 0x5
	// Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk = 0x20
	// Bit TIM7EN.
	RCC_APB1ENR_TIM7EN = 0x20
	// The selected clock is disabled
	RCC_APB1ENR_TIM7EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM7EN_Enabled = 0x1
	// Position of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Pos = 0x6
	// Bit mask of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Msk = 0x40
	// Bit TIM12EN.
	RCC_APB1ENR_TIM12EN = 0x40
	// The selected clock is disabled
	RCC_APB1ENR_TIM12EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM12EN_Enabled = 0x1
	// Position of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Pos = 0x7
	// Bit mask of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Msk = 0x80
	// Bit TIM13EN.
	RCC_APB1ENR_TIM13EN = 0x80
	// The selected clock is disabled
	RCC_APB1ENR_TIM13EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM13EN_Enabled = 0x1
	// Position of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Pos = 0x8
	// Bit mask of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Msk = 0x100
	// Bit TIM14EN.
	RCC_APB1ENR_TIM14EN = 0x100
	// The selected clock is disabled
	RCC_APB1ENR_TIM14EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM14EN_Enabled = 0x1
	// Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR_WWDGEN = 0x800
	// The selected clock is disabled
	RCC_APB1ENR_WWDGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_WWDGEN_Enabled = 0x1
	// Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR_SPI2EN = 0x4000
	// The selected clock is disabled
	RCC_APB1ENR_SPI2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI2EN_Enabled = 0x1
	// Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Pos = 0xf
	// Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk = 0x8000
	// Bit SPI3EN.
	RCC_APB1ENR_SPI3EN = 0x8000
	// The selected clock is disabled
	RCC_APB1ENR_SPI3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI3EN_Enabled = 0x1
	// Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR_USART2EN = 0x20000
	// The selected clock is disabled
	RCC_APB1ENR_USART2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART2EN_Enabled = 0x1
	// Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Pos = 0x12
	// Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000
	// Bit USART3EN.
	RCC_APB1ENR_USART3EN = 0x40000
	// The selected clock is disabled
	RCC_APB1ENR_USART3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART3EN_Enabled = 0x1
	// Position of UART4EN field.
	RCC_APB1ENR_UART4EN_Pos = 0x13
	// Bit mask of UART4EN field.
	RCC_APB1ENR_UART4EN_Msk = 0x80000
	// Bit UART4EN.
	RCC_APB1ENR_UART4EN = 0x80000
	// The selected clock is disabled
	RCC_APB1ENR_UART4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART4EN_Enabled = 0x1
	// Position of UART5EN field.
	RCC_APB1ENR_UART5EN_Pos = 0x14
	// Bit mask of UART5EN field.
	RCC_APB1ENR_UART5EN_Msk = 0x100000
	// Bit UART5EN.
	RCC_APB1ENR_UART5EN = 0x100000
	// The selected clock is disabled
	RCC_APB1ENR_UART5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART5EN_Enabled = 0x1
	// Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR_I2C1EN = 0x200000
	// The selected clock is disabled
	RCC_APB1ENR_I2C1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C1EN_Enabled = 0x1
	// Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR_I2C2EN = 0x400000
	// The selected clock is disabled
	RCC_APB1ENR_I2C2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C2EN_Enabled = 0x1
	// Position of BKPEN field.
	RCC_APB1ENR_BKPEN_Pos = 0x1b
	// Bit mask of BKPEN field.
	RCC_APB1ENR_BKPEN_Msk = 0x8000000
	// Bit BKPEN.
	RCC_APB1ENR_BKPEN = 0x8000000
	// The selected clock is disabled
	RCC_APB1ENR_BKPEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_BKPEN_Enabled = 0x1
	// Position of PWREN field.
	RCC_APB1ENR_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR_PWREN = 0x10000000
	// The selected clock is disabled
	RCC_APB1ENR_PWREN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_PWREN_Enabled = 0x1
	// Position of DACEN field.
	RCC_APB1ENR_DACEN_Pos = 0x1d
	// Bit mask of DACEN field.
	RCC_APB1ENR_DACEN_Msk = 0x20000000
	// Bit DACEN.
	RCC_APB1ENR_DACEN = 0x20000000
	// The selected clock is disabled
	RCC_APB1ENR_DACEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_DACEN_Enabled = 0x1
	// Position of CECEN field.
	RCC_APB1ENR_CECEN_Pos = 0x1e
	// Bit mask of CECEN field.
	RCC_APB1ENR_CECEN_Msk = 0x40000000
	// Bit CECEN.
	RCC_APB1ENR_CECEN = 0x40000000
	// The selected clock is disabled
	RCC_APB1ENR_CECEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_CECEN_Enabled = 0x1

	// BDCR: Backup domain control register (RCC_BDCR)
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1
	// LSE oscillator Off
	RCC_BDCR_LSEON_Off = 0x0
	// LSE oscillator On
	RCC_BDCR_LSEON_On = 0x1
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// LSE oscillator not ready
	RCC_BDCR_LSERDY_NotReady = 0x0
	// LSE oscillator ready
	RCC_BDCR_LSERDY_Ready = 0x1
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// LSE crystal oscillator not bypassed
	RCC_BDCR_LSEBYP_NotBypassed = 0x0
	// LSE crystal oscillator bypassed with external clock
	RCC_BDCR_LSEBYP_Bypassed = 0x1
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// No clock
	RCC_BDCR_RTCSEL_NoClock = 0x0
	// LSE oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSE = 0x1
	// LSI oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSI = 0x2
	// HSE oscillator clock divided by a prescaler used as RTC clock
	RCC_BDCR_RTCSEL_HSE = 0x3
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// RTC clock disabled
	RCC_BDCR_RTCEN_Disabled = 0x0
	// RTC clock enabled
	RCC_BDCR_RTCEN_Enabled = 0x1
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Reset not activated
	RCC_BDCR_BDRST_Disabled = 0x0
	// Reset the entire RTC domain
	RCC_BDCR_BDRST_Enabled = 0x1

	// CSR: Control/status register (RCC_CSR)
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
	// LSI oscillator Off
	RCC_CSR_LSION_Off = 0x0
	// LSI oscillator On
	RCC_CSR_LSION_On = 0x1
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// LSI oscillator not ready
	RCC_CSR_LSIRDY_NotReady = 0x0
	// LSI oscillator ready
	RCC_CSR_LSIRDY_Ready = 0x1
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x18
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x1000000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x1000000
	// Clears the reset flag
	RCC_CSR_RMVF_Clear = 0x1
	// Position of PINRSTF field.
	RCC_CSR_PINRSTF_Pos = 0x1a
	// Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF_Msk = 0x4000000
	// Bit PINRSTF.
	RCC_CSR_PINRSTF = 0x4000000
	// No reset has occured
	RCC_CSR_PINRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PINRSTF_Reset = 0x1
	// Position of PORRSTF field.
	RCC_CSR_PORRSTF_Pos = 0x1b
	// Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF_Msk = 0x8000000
	// Bit PORRSTF.
	RCC_CSR_PORRSTF = 0x8000000
	// No reset has occured
	RCC_CSR_PORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PORRSTF_Reset = 0x1
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// No reset has occured
	RCC_CSR_SFTRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_SFTRSTF_Reset = 0x1
	// Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Pos = 0x1d
	// Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000
	// Bit IWDGRSTF.
	RCC_CSR_IWDGRSTF = 0x20000000
	// No reset has occured
	RCC_CSR_IWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_IWDGRSTF_Reset = 0x1
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// No reset has occured
	RCC_CSR_WWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WWDGRSTF_Reset = 0x1
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
	// No reset has occured
	RCC_CSR_LPWRRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_LPWRRSTF_Reset = 0x1

	// CFGR2: Clock configuration register 2
	// Position of PREDIV1 field.
	RCC_CFGR2_PREDIV1_Pos = 0x0
	// Bit mask of PREDIV1 field.
	RCC_CFGR2_PREDIV1_Msk = 0xf
	// PREDIV input clock not divided
	RCC_CFGR2_PREDIV1_Div1 = 0x0
	// PREDIV input clock divided by 2
	RCC_CFGR2_PREDIV1_Div2 = 0x1
	// PREDIV input clock divided by 3
	RCC_CFGR2_PREDIV1_Div3 = 0x2
	// PREDIV input clock divided by 4
	RCC_CFGR2_PREDIV1_Div4 = 0x3
	// PREDIV input clock divided by 5
	RCC_CFGR2_PREDIV1_Div5 = 0x4
	// PREDIV input clock divided by 6
	RCC_CFGR2_PREDIV1_Div6 = 0x5
	// PREDIV input clock divided by 7
	RCC_CFGR2_PREDIV1_Div7 = 0x6
	// PREDIV input clock divided by 8
	RCC_CFGR2_PREDIV1_Div8 = 0x7
	// PREDIV input clock divided by 9
	RCC_CFGR2_PREDIV1_Div9 = 0x8
	// PREDIV input clock divided by 10
	RCC_CFGR2_PREDIV1_Div10 = 0x9
	// PREDIV input clock divided by 11
	RCC_CFGR2_PREDIV1_Div11 = 0xa
	// PREDIV input clock divided by 12
	RCC_CFGR2_PREDIV1_Div12 = 0xb
	// PREDIV input clock divided by 13
	RCC_CFGR2_PREDIV1_Div13 = 0xc
	// PREDIV input clock divided by 14
	RCC_CFGR2_PREDIV1_Div14 = 0xd
	// PREDIV input clock divided by 15
	RCC_CFGR2_PREDIV1_Div15 = 0xe
	// PREDIV input clock divided by 16
	RCC_CFGR2_PREDIV1_Div16 = 0xf
)

// Bitfields for GPIOA: General purpose I/O
const (
	// CRL: Port configuration register low (GPIOn_CRL)
	// Position of MODE0 field.
	GPIO_CRL_MODE0_Pos = 0x0
	// Bit mask of MODE0 field.
	GPIO_CRL_MODE0_Msk = 0x3
	// Input mode (reset state)
	GPIO_CRL_MODE0_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRL_MODE0_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRL_MODE0_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRL_MODE0_Output50 = 0x3
	// Position of CNF0 field.
	GPIO_CRL_CNF0_Pos = 0x2
	// Bit mask of CNF0 field.
	GPIO_CRL_CNF0_Msk = 0xc
	// Analog mode / Push-Pull mode
	GPIO_CRL_CNF0_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRL_CNF0_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRL_CNF0_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRL_CNF0_AltOpenDrain = 0x3
	// Position of MODE1 field.
	GPIO_CRL_MODE1_Pos = 0x4
	// Bit mask of MODE1 field.
	GPIO_CRL_MODE1_Msk = 0x30
	// Input mode (reset state)
	GPIO_CRL_MODE1_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRL_MODE1_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRL_MODE1_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRL_MODE1_Output50 = 0x3
	// Position of CNF1 field.
	GPIO_CRL_CNF1_Pos = 0x6
	// Bit mask of CNF1 field.
	GPIO_CRL_CNF1_Msk = 0xc0
	// Analog mode / Push-Pull mode
	GPIO_CRL_CNF1_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRL_CNF1_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRL_CNF1_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRL_CNF1_AltOpenDrain = 0x3
	// Position of MODE2 field.
	GPIO_CRL_MODE2_Pos = 0x8
	// Bit mask of MODE2 field.
	GPIO_CRL_MODE2_Msk = 0x300
	// Input mode (reset state)
	GPIO_CRL_MODE2_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRL_MODE2_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRL_MODE2_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRL_MODE2_Output50 = 0x3
	// Position of CNF2 field.
	GPIO_CRL_CNF2_Pos = 0xa
	// Bit mask of CNF2 field.
	GPIO_CRL_CNF2_Msk = 0xc00
	// Analog mode / Push-Pull mode
	GPIO_CRL_CNF2_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRL_CNF2_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRL_CNF2_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRL_CNF2_AltOpenDrain = 0x3
	// Position of MODE3 field.
	GPIO_CRL_MODE3_Pos = 0xc
	// Bit mask of MODE3 field.
	GPIO_CRL_MODE3_Msk = 0x3000
	// Input mode (reset state)
	GPIO_CRL_MODE3_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRL_MODE3_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRL_MODE3_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRL_MODE3_Output50 = 0x3
	// Position of CNF3 field.
	GPIO_CRL_CNF3_Pos = 0xe
	// Bit mask of CNF3 field.
	GPIO_CRL_CNF3_Msk = 0xc000
	// Analog mode / Push-Pull mode
	GPIO_CRL_CNF3_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRL_CNF3_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRL_CNF3_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRL_CNF3_AltOpenDrain = 0x3
	// Position of MODE4 field.
	GPIO_CRL_MODE4_Pos = 0x10
	// Bit mask of MODE4 field.
	GPIO_CRL_MODE4_Msk = 0x30000
	// Input mode (reset state)
	GPIO_CRL_MODE4_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRL_MODE4_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRL_MODE4_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRL_MODE4_Output50 = 0x3
	// Position of CNF4 field.
	GPIO_CRL_CNF4_Pos = 0x12
	// Bit mask of CNF4 field.
	GPIO_CRL_CNF4_Msk = 0xc0000
	// Analog mode / Push-Pull mode
	GPIO_CRL_CNF4_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRL_CNF4_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRL_CNF4_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRL_CNF4_AltOpenDrain = 0x3
	// Position of MODE5 field.
	GPIO_CRL_MODE5_Pos = 0x14
	// Bit mask of MODE5 field.
	GPIO_CRL_MODE5_Msk = 0x300000
	// Input mode (reset state)
	GPIO_CRL_MODE5_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRL_MODE5_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRL_MODE5_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRL_MODE5_Output50 = 0x3
	// Position of CNF5 field.
	GPIO_CRL_CNF5_Pos = 0x16
	// Bit mask of CNF5 field.
	GPIO_CRL_CNF5_Msk = 0xc00000
	// Analog mode / Push-Pull mode
	GPIO_CRL_CNF5_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRL_CNF5_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRL_CNF5_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRL_CNF5_AltOpenDrain = 0x3
	// Position of MODE6 field.
	GPIO_CRL_MODE6_Pos = 0x18
	// Bit mask of MODE6 field.
	GPIO_CRL_MODE6_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_CRL_MODE6_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRL_MODE6_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRL_MODE6_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRL_MODE6_Output50 = 0x3
	// Position of CNF6 field.
	GPIO_CRL_CNF6_Pos = 0x1a
	// Bit mask of CNF6 field.
	GPIO_CRL_CNF6_Msk = 0xc000000
	// Analog mode / Push-Pull mode
	GPIO_CRL_CNF6_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRL_CNF6_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRL_CNF6_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRL_CNF6_AltOpenDrain = 0x3
	// Position of MODE7 field.
	GPIO_CRL_MODE7_Pos = 0x1c
	// Bit mask of MODE7 field.
	GPIO_CRL_MODE7_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_CRL_MODE7_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRL_MODE7_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRL_MODE7_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRL_MODE7_Output50 = 0x3
	// Position of CNF7 field.
	GPIO_CRL_CNF7_Pos = 0x1e
	// Bit mask of CNF7 field.
	GPIO_CRL_CNF7_Msk = 0xc0000000
	// Analog mode / Push-Pull mode
	GPIO_CRL_CNF7_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRL_CNF7_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRL_CNF7_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRL_CNF7_AltOpenDrain = 0x3

	// CRH: Port configuration register high (GPIOn_CRL)
	// Position of MODE8 field.
	GPIO_CRH_MODE8_Pos = 0x0
	// Bit mask of MODE8 field.
	GPIO_CRH_MODE8_Msk = 0x3
	// Input mode (reset state)
	GPIO_CRH_MODE8_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRH_MODE8_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRH_MODE8_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRH_MODE8_Output50 = 0x3
	// Position of CNF8 field.
	GPIO_CRH_CNF8_Pos = 0x2
	// Bit mask of CNF8 field.
	GPIO_CRH_CNF8_Msk = 0xc
	// Analog mode / Push-Pull mode
	GPIO_CRH_CNF8_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRH_CNF8_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRH_CNF8_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRH_CNF8_AltOpenDrain = 0x3
	// Position of MODE9 field.
	GPIO_CRH_MODE9_Pos = 0x4
	// Bit mask of MODE9 field.
	GPIO_CRH_MODE9_Msk = 0x30
	// Input mode (reset state)
	GPIO_CRH_MODE9_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRH_MODE9_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRH_MODE9_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRH_MODE9_Output50 = 0x3
	// Position of CNF9 field.
	GPIO_CRH_CNF9_Pos = 0x6
	// Bit mask of CNF9 field.
	GPIO_CRH_CNF9_Msk = 0xc0
	// Analog mode / Push-Pull mode
	GPIO_CRH_CNF9_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRH_CNF9_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRH_CNF9_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRH_CNF9_AltOpenDrain = 0x3
	// Position of MODE10 field.
	GPIO_CRH_MODE10_Pos = 0x8
	// Bit mask of MODE10 field.
	GPIO_CRH_MODE10_Msk = 0x300
	// Input mode (reset state)
	GPIO_CRH_MODE10_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRH_MODE10_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRH_MODE10_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRH_MODE10_Output50 = 0x3
	// Position of CNF10 field.
	GPIO_CRH_CNF10_Pos = 0xa
	// Bit mask of CNF10 field.
	GPIO_CRH_CNF10_Msk = 0xc00
	// Analog mode / Push-Pull mode
	GPIO_CRH_CNF10_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRH_CNF10_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRH_CNF10_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRH_CNF10_AltOpenDrain = 0x3
	// Position of MODE11 field.
	GPIO_CRH_MODE11_Pos = 0xc
	// Bit mask of MODE11 field.
	GPIO_CRH_MODE11_Msk = 0x3000
	// Input mode (reset state)
	GPIO_CRH_MODE11_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRH_MODE11_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRH_MODE11_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRH_MODE11_Output50 = 0x3
	// Position of CNF11 field.
	GPIO_CRH_CNF11_Pos = 0xe
	// Bit mask of CNF11 field.
	GPIO_CRH_CNF11_Msk = 0xc000
	// Analog mode / Push-Pull mode
	GPIO_CRH_CNF11_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRH_CNF11_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRH_CNF11_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRH_CNF11_AltOpenDrain = 0x3
	// Position of MODE12 field.
	GPIO_CRH_MODE12_Pos = 0x10
	// Bit mask of MODE12 field.
	GPIO_CRH_MODE12_Msk = 0x30000
	// Input mode (reset state)
	GPIO_CRH_MODE12_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRH_MODE12_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRH_MODE12_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRH_MODE12_Output50 = 0x3
	// Position of CNF12 field.
	GPIO_CRH_CNF12_Pos = 0x12
	// Bit mask of CNF12 field.
	GPIO_CRH_CNF12_Msk = 0xc0000
	// Analog mode / Push-Pull mode
	GPIO_CRH_CNF12_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRH_CNF12_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRH_CNF12_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRH_CNF12_AltOpenDrain = 0x3
	// Position of MODE13 field.
	GPIO_CRH_MODE13_Pos = 0x14
	// Bit mask of MODE13 field.
	GPIO_CRH_MODE13_Msk = 0x300000
	// Input mode (reset state)
	GPIO_CRH_MODE13_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRH_MODE13_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRH_MODE13_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRH_MODE13_Output50 = 0x3
	// Position of CNF13 field.
	GPIO_CRH_CNF13_Pos = 0x16
	// Bit mask of CNF13 field.
	GPIO_CRH_CNF13_Msk = 0xc00000
	// Analog mode / Push-Pull mode
	GPIO_CRH_CNF13_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRH_CNF13_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRH_CNF13_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRH_CNF13_AltOpenDrain = 0x3
	// Position of MODE14 field.
	GPIO_CRH_MODE14_Pos = 0x18
	// Bit mask of MODE14 field.
	GPIO_CRH_MODE14_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_CRH_MODE14_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRH_MODE14_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRH_MODE14_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRH_MODE14_Output50 = 0x3
	// Position of CNF14 field.
	GPIO_CRH_CNF14_Pos = 0x1a
	// Bit mask of CNF14 field.
	GPIO_CRH_CNF14_Msk = 0xc000000
	// Analog mode / Push-Pull mode
	GPIO_CRH_CNF14_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRH_CNF14_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRH_CNF14_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRH_CNF14_AltOpenDrain = 0x3
	// Position of MODE15 field.
	GPIO_CRH_MODE15_Pos = 0x1c
	// Bit mask of MODE15 field.
	GPIO_CRH_MODE15_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_CRH_MODE15_Input = 0x0
	// Output mode 10 MHz
	GPIO_CRH_MODE15_Output = 0x1
	// Output mode 2 MHz
	GPIO_CRH_MODE15_Output2 = 0x2
	// Output mode 50 MHz
	GPIO_CRH_MODE15_Output50 = 0x3
	// Position of CNF15 field.
	GPIO_CRH_CNF15_Pos = 0x1e
	// Bit mask of CNF15 field.
	GPIO_CRH_CNF15_Msk = 0xc0000000
	// Analog mode / Push-Pull mode
	GPIO_CRH_CNF15_PushPull = 0x0
	// Floating input (reset state) / Open Drain-Mode
	GPIO_CRH_CNF15_OpenDrain = 0x1
	// Input with pull-up/pull-down / Alternate Function Push-Pull Mode
	GPIO_CRH_CNF15_AltPushPull = 0x2
	// Alternate Function Open-Drain Mode
	GPIO_CRH_CNF15_AltOpenDrain = 0x3

	// IDR: Port input data register (GPIOn_IDR)
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1
	// Input is logic high
	GPIO_IDR_IDR0_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR0_Low = 0x0
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Input is logic high
	GPIO_IDR_IDR1_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR1_Low = 0x0
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Input is logic high
	GPIO_IDR_IDR2_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR2_Low = 0x0
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Input is logic high
	GPIO_IDR_IDR3_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR3_Low = 0x0
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Input is logic high
	GPIO_IDR_IDR4_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR4_Low = 0x0
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Input is logic high
	GPIO_IDR_IDR5_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR5_Low = 0x0
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Input is logic high
	GPIO_IDR_IDR6_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR6_Low = 0x0
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Input is logic high
	GPIO_IDR_IDR7_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR7_Low = 0x0
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Input is logic high
	GPIO_IDR_IDR8_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR8_Low = 0x0
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Input is logic high
	GPIO_IDR_IDR9_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR9_Low = 0x0
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Input is logic high
	GPIO_IDR_IDR10_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR10_Low = 0x0
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Input is logic high
	GPIO_IDR_IDR11_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR11_Low = 0x0
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Input is logic high
	GPIO_IDR_IDR12_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR12_Low = 0x0
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Input is logic high
	GPIO_IDR_IDR13_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR13_Low = 0x0
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Input is logic high
	GPIO_IDR_IDR14_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR14_Low = 0x0
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Input is logic high
	GPIO_IDR_IDR15_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR15_Low = 0x0

	// ODR: Port output data register (GPIOn_ODR)
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1
	// Set output to logic high
	GPIO_ODR_ODR0_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR0_Low = 0x0
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Set output to logic high
	GPIO_ODR_ODR1_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR1_Low = 0x0
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Set output to logic high
	GPIO_ODR_ODR2_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR2_Low = 0x0
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Set output to logic high
	GPIO_ODR_ODR3_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR3_Low = 0x0
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Set output to logic high
	GPIO_ODR_ODR4_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR4_Low = 0x0
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Set output to logic high
	GPIO_ODR_ODR5_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR5_Low = 0x0
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Set output to logic high
	GPIO_ODR_ODR6_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR6_Low = 0x0
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Set output to logic high
	GPIO_ODR_ODR7_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR7_Low = 0x0
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Set output to logic high
	GPIO_ODR_ODR8_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR8_Low = 0x0
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Set output to logic high
	GPIO_ODR_ODR9_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR9_Low = 0x0
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Set output to logic high
	GPIO_ODR_ODR10_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR10_Low = 0x0
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Set output to logic high
	GPIO_ODR_ODR11_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR11_Low = 0x0
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Set output to logic high
	GPIO_ODR_ODR12_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR12_Low = 0x0
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Set output to logic high
	GPIO_ODR_ODR13_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR13_Low = 0x0
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Set output to logic high
	GPIO_ODR_ODR14_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR14_Low = 0x0
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Set output to logic high
	GPIO_ODR_ODR15_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR15_Low = 0x0

	// BSRR: Port bit set/reset register (GPIOn_BSRR)
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS0_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR15_Reset = 0x1

	// BRR: Port bit reset register (GPIOn_BRR)
	// Position of BR0 field.
	GPIO_BRR_BR0_Pos = 0x0
	// Bit mask of BR0 field.
	GPIO_BRR_BR0_Msk = 0x1
	// Bit BR0.
	GPIO_BRR_BR0 = 0x1
	// No action on the corresponding ODx bit
	GPIO_BRR_BR0_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR0_Reset = 0x1
	// Position of BR1 field.
	GPIO_BRR_BR1_Pos = 0x1
	// Bit mask of BR1 field.
	GPIO_BRR_BR1_Msk = 0x2
	// Bit BR1.
	GPIO_BRR_BR1 = 0x2
	// No action on the corresponding ODx bit
	GPIO_BRR_BR1_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR1_Reset = 0x1
	// Position of BR2 field.
	GPIO_BRR_BR2_Pos = 0x2
	// Bit mask of BR2 field.
	GPIO_BRR_BR2_Msk = 0x4
	// Bit BR2.
	GPIO_BRR_BR2 = 0x4
	// No action on the corresponding ODx bit
	GPIO_BRR_BR2_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR2_Reset = 0x1
	// Position of BR3 field.
	GPIO_BRR_BR3_Pos = 0x3
	// Bit mask of BR3 field.
	GPIO_BRR_BR3_Msk = 0x8
	// Bit BR3.
	GPIO_BRR_BR3 = 0x8
	// No action on the corresponding ODx bit
	GPIO_BRR_BR3_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR3_Reset = 0x1
	// Position of BR4 field.
	GPIO_BRR_BR4_Pos = 0x4
	// Bit mask of BR4 field.
	GPIO_BRR_BR4_Msk = 0x10
	// Bit BR4.
	GPIO_BRR_BR4 = 0x10
	// No action on the corresponding ODx bit
	GPIO_BRR_BR4_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR4_Reset = 0x1
	// Position of BR5 field.
	GPIO_BRR_BR5_Pos = 0x5
	// Bit mask of BR5 field.
	GPIO_BRR_BR5_Msk = 0x20
	// Bit BR5.
	GPIO_BRR_BR5 = 0x20
	// No action on the corresponding ODx bit
	GPIO_BRR_BR5_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR5_Reset = 0x1
	// Position of BR6 field.
	GPIO_BRR_BR6_Pos = 0x6
	// Bit mask of BR6 field.
	GPIO_BRR_BR6_Msk = 0x40
	// Bit BR6.
	GPIO_BRR_BR6 = 0x40
	// No action on the corresponding ODx bit
	GPIO_BRR_BR6_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR6_Reset = 0x1
	// Position of BR7 field.
	GPIO_BRR_BR7_Pos = 0x7
	// Bit mask of BR7 field.
	GPIO_BRR_BR7_Msk = 0x80
	// Bit BR7.
	GPIO_BRR_BR7 = 0x80
	// No action on the corresponding ODx bit
	GPIO_BRR_BR7_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR7_Reset = 0x1
	// Position of BR8 field.
	GPIO_BRR_BR8_Pos = 0x8
	// Bit mask of BR8 field.
	GPIO_BRR_BR8_Msk = 0x100
	// Bit BR8.
	GPIO_BRR_BR8 = 0x100
	// No action on the corresponding ODx bit
	GPIO_BRR_BR8_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR8_Reset = 0x1
	// Position of BR9 field.
	GPIO_BRR_BR9_Pos = 0x9
	// Bit mask of BR9 field.
	GPIO_BRR_BR9_Msk = 0x200
	// Bit BR9.
	GPIO_BRR_BR9 = 0x200
	// No action on the corresponding ODx bit
	GPIO_BRR_BR9_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR9_Reset = 0x1
	// Position of BR10 field.
	GPIO_BRR_BR10_Pos = 0xa
	// Bit mask of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400
	// Bit BR10.
	GPIO_BRR_BR10 = 0x400
	// No action on the corresponding ODx bit
	GPIO_BRR_BR10_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR10_Reset = 0x1
	// Position of BR11 field.
	GPIO_BRR_BR11_Pos = 0xb
	// Bit mask of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800
	// Bit BR11.
	GPIO_BRR_BR11 = 0x800
	// No action on the corresponding ODx bit
	GPIO_BRR_BR11_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR11_Reset = 0x1
	// Position of BR12 field.
	GPIO_BRR_BR12_Pos = 0xc
	// Bit mask of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000
	// Bit BR12.
	GPIO_BRR_BR12 = 0x1000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR12_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR12_Reset = 0x1
	// Position of BR13 field.
	GPIO_BRR_BR13_Pos = 0xd
	// Bit mask of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000
	// Bit BR13.
	GPIO_BRR_BR13 = 0x2000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR13_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR13_Reset = 0x1
	// Position of BR14 field.
	GPIO_BRR_BR14_Pos = 0xe
	// Bit mask of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000
	// Bit BR14.
	GPIO_BRR_BR14 = 0x4000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR14_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR14_Reset = 0x1
	// Position of BR15 field.
	GPIO_BRR_BR15_Pos = 0xf
	// Bit mask of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000
	// Bit BR15.
	GPIO_BRR_BR15 = 0x8000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR15_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR15_Reset = 0x1

	// LCKR: Port configuration lock register
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
)

// Bitfields for AFIO: Alternate function I/O
const (
	// EVCR: Event Control Register (AFIO_EVCR)
	// Position of PIN field.
	AFIO_EVCR_PIN_Pos = 0x0
	// Bit mask of PIN field.
	AFIO_EVCR_PIN_Msk = 0xf
	// Position of PORT field.
	AFIO_EVCR_PORT_Pos = 0x4
	// Bit mask of PORT field.
	AFIO_EVCR_PORT_Msk = 0x70
	// Position of EVOE field.
	AFIO_EVCR_EVOE_Pos = 0x7
	// Bit mask of EVOE field.
	AFIO_EVCR_EVOE_Msk = 0x80
	// Bit EVOE.
	AFIO_EVCR_EVOE = 0x80

	// MAPR: AF remap and debug I/O configuration register (AFIO_MAPR)
	// Position of SPI1_REMAP field.
	AFIO_MAPR_SPI1_REMAP_Pos = 0x0
	// Bit mask of SPI1_REMAP field.
	AFIO_MAPR_SPI1_REMAP_Msk = 0x1
	// Bit SPI1_REMAP.
	AFIO_MAPR_SPI1_REMAP = 0x1
	// Position of I2C1_REMAP field.
	AFIO_MAPR_I2C1_REMAP_Pos = 0x1
	// Bit mask of I2C1_REMAP field.
	AFIO_MAPR_I2C1_REMAP_Msk = 0x2
	// Bit I2C1_REMAP.
	AFIO_MAPR_I2C1_REMAP = 0x2
	// Position of USART1_REMAP field.
	AFIO_MAPR_USART1_REMAP_Pos = 0x2
	// Bit mask of USART1_REMAP field.
	AFIO_MAPR_USART1_REMAP_Msk = 0x4
	// Bit USART1_REMAP.
	AFIO_MAPR_USART1_REMAP = 0x4
	// Position of USART2_REMAP field.
	AFIO_MAPR_USART2_REMAP_Pos = 0x3
	// Bit mask of USART2_REMAP field.
	AFIO_MAPR_USART2_REMAP_Msk = 0x8
	// Bit USART2_REMAP.
	AFIO_MAPR_USART2_REMAP = 0x8
	// Position of USART3_REMAP field.
	AFIO_MAPR_USART3_REMAP_Pos = 0x4
	// Bit mask of USART3_REMAP field.
	AFIO_MAPR_USART3_REMAP_Msk = 0x30
	// Position of TIM1_REMAP field.
	AFIO_MAPR_TIM1_REMAP_Pos = 0x6
	// Bit mask of TIM1_REMAP field.
	AFIO_MAPR_TIM1_REMAP_Msk = 0xc0
	// Position of TIM2_REMAP field.
	AFIO_MAPR_TIM2_REMAP_Pos = 0x8
	// Bit mask of TIM2_REMAP field.
	AFIO_MAPR_TIM2_REMAP_Msk = 0x300
	// Position of TIM3_REMAP field.
	AFIO_MAPR_TIM3_REMAP_Pos = 0xa
	// Bit mask of TIM3_REMAP field.
	AFIO_MAPR_TIM3_REMAP_Msk = 0xc00
	// Position of TIM4_REMAP field.
	AFIO_MAPR_TIM4_REMAP_Pos = 0xc
	// Bit mask of TIM4_REMAP field.
	AFIO_MAPR_TIM4_REMAP_Msk = 0x1000
	// Bit TIM4_REMAP.
	AFIO_MAPR_TIM4_REMAP = 0x1000
	// Position of PD01_REMAP field.
	AFIO_MAPR_PD01_REMAP_Pos = 0xf
	// Bit mask of PD01_REMAP field.
	AFIO_MAPR_PD01_REMAP_Msk = 0x8000
	// Bit PD01_REMAP.
	AFIO_MAPR_PD01_REMAP = 0x8000
	// Position of TIM5CH4_IREMAP field.
	AFIO_MAPR_TIM5CH4_IREMAP_Pos = 0x10
	// Bit mask of TIM5CH4_IREMAP field.
	AFIO_MAPR_TIM5CH4_IREMAP_Msk = 0x10000
	// Bit TIM5CH4_IREMAP.
	AFIO_MAPR_TIM5CH4_IREMAP = 0x10000
	// Position of SWJ_CFG field.
	AFIO_MAPR_SWJ_CFG_Pos = 0x18
	// Bit mask of SWJ_CFG field.
	AFIO_MAPR_SWJ_CFG_Msk = 0x7000000

	// EXTICR1: External interrupt configuration register 1 (AFIO_EXTICR1)
	// Position of EXTI0 field.
	AFIO_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	AFIO_EXTICR1_EXTI0_Msk = 0xf
	// Position of EXTI1 field.
	AFIO_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	AFIO_EXTICR1_EXTI1_Msk = 0xf0
	// Position of EXTI2 field.
	AFIO_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	AFIO_EXTICR1_EXTI2_Msk = 0xf00
	// Position of EXTI3 field.
	AFIO_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	AFIO_EXTICR1_EXTI3_Msk = 0xf000

	// EXTICR2: External interrupt configuration register 2 (AFIO_EXTICR2)
	// Position of EXTI4 field.
	AFIO_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	AFIO_EXTICR2_EXTI4_Msk = 0xf
	// Position of EXTI5 field.
	AFIO_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	AFIO_EXTICR2_EXTI5_Msk = 0xf0
	// Position of EXTI6 field.
	AFIO_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	AFIO_EXTICR2_EXTI6_Msk = 0xf00
	// Position of EXTI7 field.
	AFIO_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	AFIO_EXTICR2_EXTI7_Msk = 0xf000

	// EXTICR3: External interrupt configuration register 3 (AFIO_EXTICR3)
	// Position of EXTI8 field.
	AFIO_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	AFIO_EXTICR3_EXTI8_Msk = 0xf
	// Position of EXTI9 field.
	AFIO_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	AFIO_EXTICR3_EXTI9_Msk = 0xf0
	// Position of EXTI10 field.
	AFIO_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	AFIO_EXTICR3_EXTI10_Msk = 0xf00
	// Position of EXTI11 field.
	AFIO_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	AFIO_EXTICR3_EXTI11_Msk = 0xf000

	// EXTICR4: External interrupt configuration register 4 (AFIO_EXTICR4)
	// Position of EXTI12 field.
	AFIO_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	AFIO_EXTICR4_EXTI12_Msk = 0xf
	// Position of EXTI13 field.
	AFIO_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	AFIO_EXTICR4_EXTI13_Msk = 0xf0
	// Position of EXTI14 field.
	AFIO_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	AFIO_EXTICR4_EXTI14_Msk = 0xf00
	// Position of EXTI15 field.
	AFIO_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	AFIO_EXTICR4_EXTI15_Msk = 0xf000

	// MAPR2: AF remap and debug I/O configuration register
	// Position of TIM15_REMAP field.
	AFIO_MAPR2_TIM15_REMAP_Pos = 0x0
	// Bit mask of TIM15_REMAP field.
	AFIO_MAPR2_TIM15_REMAP_Msk = 0x1
	// Bit TIM15_REMAP.
	AFIO_MAPR2_TIM15_REMAP = 0x1
	// Position of TIM16_REMAP field.
	AFIO_MAPR2_TIM16_REMAP_Pos = 0x1
	// Bit mask of TIM16_REMAP field.
	AFIO_MAPR2_TIM16_REMAP_Msk = 0x2
	// Bit TIM16_REMAP.
	AFIO_MAPR2_TIM16_REMAP = 0x2
	// Position of TIM17_REMAP field.
	AFIO_MAPR2_TIM17_REMAP_Pos = 0x2
	// Bit mask of TIM17_REMAP field.
	AFIO_MAPR2_TIM17_REMAP_Msk = 0x4
	// Bit TIM17_REMAP.
	AFIO_MAPR2_TIM17_REMAP = 0x4
	// Position of TIM13_REMAP field.
	AFIO_MAPR2_TIM13_REMAP_Pos = 0x8
	// Bit mask of TIM13_REMAP field.
	AFIO_MAPR2_TIM13_REMAP_Msk = 0x100
	// Bit TIM13_REMAP.
	AFIO_MAPR2_TIM13_REMAP = 0x100
	// Position of TIM14_REMAP field.
	AFIO_MAPR2_TIM14_REMAP_Pos = 0x9
	// Bit mask of TIM14_REMAP field.
	AFIO_MAPR2_TIM14_REMAP_Msk = 0x200
	// Bit TIM14_REMAP.
	AFIO_MAPR2_TIM14_REMAP = 0x200
	// Position of FSMC_NADV field.
	AFIO_MAPR2_FSMC_NADV_Pos = 0xa
	// Bit mask of FSMC_NADV field.
	AFIO_MAPR2_FSMC_NADV_Msk = 0x400
	// Bit FSMC_NADV.
	AFIO_MAPR2_FSMC_NADV = 0x400
	// Position of CEC_REMAP field.
	AFIO_MAPR2_CEC_REMAP_Pos = 0x3
	// Bit mask of CEC_REMAP field.
	AFIO_MAPR2_CEC_REMAP_Msk = 0x8
	// Bit CEC_REMAP.
	AFIO_MAPR2_CEC_REMAP = 0x8
	// Position of TIM1_DMA_REMAP field.
	AFIO_MAPR2_TIM1_DMA_REMAP_Pos = 0x4
	// Bit mask of TIM1_DMA_REMAP field.
	AFIO_MAPR2_TIM1_DMA_REMAP_Msk = 0x10
	// Bit TIM1_DMA_REMAP.
	AFIO_MAPR2_TIM1_DMA_REMAP = 0x10
	// Position of TIM67_DAC_DMA_REMAP field.
	AFIO_MAPR2_TIM67_DAC_DMA_REMAP_Pos = 0xb
	// Bit mask of TIM67_DAC_DMA_REMAP field.
	AFIO_MAPR2_TIM67_DAC_DMA_REMAP_Msk = 0x800
	// Bit TIM67_DAC_DMA_REMAP.
	AFIO_MAPR2_TIM67_DAC_DMA_REMAP = 0x800
	// Position of TIM12_REMAP field.
	AFIO_MAPR2_TIM12_REMAP_Pos = 0xc
	// Bit mask of TIM12_REMAP field.
	AFIO_MAPR2_TIM12_REMAP_Msk = 0x1000
	// Bit TIM12_REMAP.
	AFIO_MAPR2_TIM12_REMAP = 0x1000
	// Position of MISC_REMAP field.
	AFIO_MAPR2_MISC_REMAP_Pos = 0xd
	// Bit mask of MISC_REMAP field.
	AFIO_MAPR2_MISC_REMAP_Msk = 0x2000
	// Bit MISC_REMAP.
	AFIO_MAPR2_MISC_REMAP = 0x2000
)

// Bitfields for EXTI: EXTI
const (
	// IMR: Interrupt mask register (EXTI_IMR)
	// Position of MR0 field.
	EXTI_IMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_IMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_IMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_IMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_IMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_IMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_IMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_IMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_IMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_IMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_IMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_IMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_IMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_IMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_IMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_IMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_IMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_IMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_IMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_IMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_IMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_IMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_IMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_IMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_IMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_IMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_IMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_IMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_IMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_IMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_IMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_IMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_IMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_IMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_IMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_IMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_IMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_IMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_IMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_IMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_IMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_IMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_IMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_IMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_IMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_IMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_IMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR17_Unmasked = 0x1

	// EMR: Event mask register (EXTI_EMR)
	// Position of MR0 field.
	EXTI_EMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_EMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_EMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_EMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_EMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_EMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_EMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_EMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_EMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_EMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_EMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_EMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_EMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_EMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_EMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_EMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_EMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_EMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_EMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_EMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_EMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_EMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_EMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_EMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_EMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_EMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_EMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_EMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_EMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_EMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_EMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_EMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_EMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_EMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_EMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_EMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_EMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_EMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_EMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_EMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_EMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_EMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_EMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_EMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_EMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_EMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_EMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR17_Unmasked = 0x1

	// RTSR: Rising Trigger selection register (EXTI_RTSR)
	// Position of TR0 field.
	EXTI_RTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_RTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_RTSR_TR0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR_TR0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_RTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_RTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_RTSR_TR1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR_TR1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_RTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_RTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_RTSR_TR2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR_TR2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_RTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_RTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_RTSR_TR3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR_TR3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_RTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_RTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_RTSR_TR4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR_TR4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_RTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_RTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_RTSR_TR5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR_TR5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_RTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_RTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_RTSR_TR6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR_TR6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_RTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_RTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_RTSR_TR7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR_TR7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_RTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_RTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_RTSR_TR8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR_TR8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_RTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_RTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_RTSR_TR9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR_TR9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_RTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_RTSR_TR10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR_TR10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_RTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_RTSR_TR11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR_TR11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_RTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_RTSR_TR12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_RTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_RTSR_TR13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_RTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_RTSR_TR14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_RTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_RTSR_TR15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_RTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_RTSR_TR16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_RTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_RTSR_TR17 = 0x20000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR17_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR17_Enabled = 0x1

	// FTSR: Falling Trigger selection register (EXTI_FTSR)
	// Position of TR0 field.
	EXTI_FTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_FTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_FTSR_TR0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR_TR0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_FTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_FTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_FTSR_TR1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR_TR1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_FTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_FTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_FTSR_TR2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR_TR2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_FTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_FTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_FTSR_TR3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR_TR3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_FTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_FTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_FTSR_TR4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR_TR4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_FTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_FTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_FTSR_TR5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR_TR5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_FTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_FTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_FTSR_TR6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR_TR6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_FTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_FTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_FTSR_TR7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR_TR7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_FTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_FTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_FTSR_TR8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR_TR8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_FTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_FTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_FTSR_TR9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR_TR9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_FTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_FTSR_TR10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR_TR10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_FTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_FTSR_TR11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR_TR11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_FTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_FTSR_TR12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_FTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_FTSR_TR13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_FTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_FTSR_TR14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_FTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_FTSR_TR15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_FTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_FTSR_TR16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_FTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_FTSR_TR17 = 0x20000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR17_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR17_Enabled = 0x1

	// SWIER: Software interrupt event register (EXTI_SWIER)
	// Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Pos = 0x0
	// Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk = 0x1
	// Bit SWIER0.
	EXTI_SWIER_SWIER0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER_SWIER0_Pend = 0x1
	// Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Pos = 0x1
	// Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk = 0x2
	// Bit SWIER1.
	EXTI_SWIER_SWIER1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER_SWIER1_Pend = 0x1
	// Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Pos = 0x2
	// Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk = 0x4
	// Bit SWIER2.
	EXTI_SWIER_SWIER2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER_SWIER2_Pend = 0x1
	// Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Pos = 0x3
	// Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk = 0x8
	// Bit SWIER3.
	EXTI_SWIER_SWIER3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER_SWIER3_Pend = 0x1
	// Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Pos = 0x4
	// Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk = 0x10
	// Bit SWIER4.
	EXTI_SWIER_SWIER4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER_SWIER4_Pend = 0x1
	// Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Pos = 0x5
	// Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk = 0x20
	// Bit SWIER5.
	EXTI_SWIER_SWIER5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER_SWIER5_Pend = 0x1
	// Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Pos = 0x6
	// Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk = 0x40
	// Bit SWIER6.
	EXTI_SWIER_SWIER6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER_SWIER6_Pend = 0x1
	// Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Pos = 0x7
	// Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk = 0x80
	// Bit SWIER7.
	EXTI_SWIER_SWIER7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER_SWIER7_Pend = 0x1
	// Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Pos = 0x8
	// Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk = 0x100
	// Bit SWIER8.
	EXTI_SWIER_SWIER8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER_SWIER8_Pend = 0x1
	// Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Pos = 0x9
	// Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk = 0x200
	// Bit SWIER9.
	EXTI_SWIER_SWIER9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER_SWIER9_Pend = 0x1
	// Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Pos = 0xa
	// Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400
	// Bit SWIER10.
	EXTI_SWIER_SWIER10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER_SWIER10_Pend = 0x1
	// Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Pos = 0xb
	// Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800
	// Bit SWIER11.
	EXTI_SWIER_SWIER11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER_SWIER11_Pend = 0x1
	// Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Pos = 0xc
	// Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000
	// Bit SWIER12.
	EXTI_SWIER_SWIER12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER_SWIER12_Pend = 0x1
	// Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Pos = 0xd
	// Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000
	// Bit SWIER13.
	EXTI_SWIER_SWIER13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER_SWIER13_Pend = 0x1
	// Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Pos = 0xe
	// Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000
	// Bit SWIER14.
	EXTI_SWIER_SWIER14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER_SWIER14_Pend = 0x1
	// Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Pos = 0xf
	// Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000
	// Bit SWIER15.
	EXTI_SWIER_SWIER15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER_SWIER15_Pend = 0x1
	// Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Pos = 0x10
	// Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000
	// Bit SWIER16.
	EXTI_SWIER_SWIER16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER_SWIER16_Pend = 0x1
	// Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Pos = 0x11
	// Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000
	// Bit SWIER17.
	EXTI_SWIER_SWIER17 = 0x20000
	// Generates an interrupt request
	EXTI_SWIER_SWIER17_Pend = 0x1

	// PR: Pending register (EXTI_PR)
	// Position of PR0 field.
	EXTI_PR_PR0_Pos = 0x0
	// Bit mask of PR0 field.
	EXTI_PR_PR0_Msk = 0x1
	// Bit PR0.
	EXTI_PR_PR0 = 0x1
	// No trigger request occurred
	EXTI_PR_PR0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR0_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR0_Clear = 0x1
	// Position of PR1 field.
	EXTI_PR_PR1_Pos = 0x1
	// Bit mask of PR1 field.
	EXTI_PR_PR1_Msk = 0x2
	// Bit PR1.
	EXTI_PR_PR1 = 0x2
	// No trigger request occurred
	EXTI_PR_PR1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR1_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR1_Clear = 0x1
	// Position of PR2 field.
	EXTI_PR_PR2_Pos = 0x2
	// Bit mask of PR2 field.
	EXTI_PR_PR2_Msk = 0x4
	// Bit PR2.
	EXTI_PR_PR2 = 0x4
	// No trigger request occurred
	EXTI_PR_PR2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR2_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR2_Clear = 0x1
	// Position of PR3 field.
	EXTI_PR_PR3_Pos = 0x3
	// Bit mask of PR3 field.
	EXTI_PR_PR3_Msk = 0x8
	// Bit PR3.
	EXTI_PR_PR3 = 0x8
	// No trigger request occurred
	EXTI_PR_PR3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR3_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR3_Clear = 0x1
	// Position of PR4 field.
	EXTI_PR_PR4_Pos = 0x4
	// Bit mask of PR4 field.
	EXTI_PR_PR4_Msk = 0x10
	// Bit PR4.
	EXTI_PR_PR4 = 0x10
	// No trigger request occurred
	EXTI_PR_PR4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR4_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR4_Clear = 0x1
	// Position of PR5 field.
	EXTI_PR_PR5_Pos = 0x5
	// Bit mask of PR5 field.
	EXTI_PR_PR5_Msk = 0x20
	// Bit PR5.
	EXTI_PR_PR5 = 0x20
	// No trigger request occurred
	EXTI_PR_PR5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR5_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR5_Clear = 0x1
	// Position of PR6 field.
	EXTI_PR_PR6_Pos = 0x6
	// Bit mask of PR6 field.
	EXTI_PR_PR6_Msk = 0x40
	// Bit PR6.
	EXTI_PR_PR6 = 0x40
	// No trigger request occurred
	EXTI_PR_PR6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR6_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR6_Clear = 0x1
	// Position of PR7 field.
	EXTI_PR_PR7_Pos = 0x7
	// Bit mask of PR7 field.
	EXTI_PR_PR7_Msk = 0x80
	// Bit PR7.
	EXTI_PR_PR7 = 0x80
	// No trigger request occurred
	EXTI_PR_PR7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR7_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR7_Clear = 0x1
	// Position of PR8 field.
	EXTI_PR_PR8_Pos = 0x8
	// Bit mask of PR8 field.
	EXTI_PR_PR8_Msk = 0x100
	// Bit PR8.
	EXTI_PR_PR8 = 0x100
	// No trigger request occurred
	EXTI_PR_PR8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR8_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR8_Clear = 0x1
	// Position of PR9 field.
	EXTI_PR_PR9_Pos = 0x9
	// Bit mask of PR9 field.
	EXTI_PR_PR9_Msk = 0x200
	// Bit PR9.
	EXTI_PR_PR9 = 0x200
	// No trigger request occurred
	EXTI_PR_PR9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR9_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR9_Clear = 0x1
	// Position of PR10 field.
	EXTI_PR_PR10_Pos = 0xa
	// Bit mask of PR10 field.
	EXTI_PR_PR10_Msk = 0x400
	// Bit PR10.
	EXTI_PR_PR10 = 0x400
	// No trigger request occurred
	EXTI_PR_PR10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR10_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR10_Clear = 0x1
	// Position of PR11 field.
	EXTI_PR_PR11_Pos = 0xb
	// Bit mask of PR11 field.
	EXTI_PR_PR11_Msk = 0x800
	// Bit PR11.
	EXTI_PR_PR11 = 0x800
	// No trigger request occurred
	EXTI_PR_PR11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR11_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR11_Clear = 0x1
	// Position of PR12 field.
	EXTI_PR_PR12_Pos = 0xc
	// Bit mask of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000
	// Bit PR12.
	EXTI_PR_PR12 = 0x1000
	// No trigger request occurred
	EXTI_PR_PR12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR12_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR12_Clear = 0x1
	// Position of PR13 field.
	EXTI_PR_PR13_Pos = 0xd
	// Bit mask of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000
	// Bit PR13.
	EXTI_PR_PR13 = 0x2000
	// No trigger request occurred
	EXTI_PR_PR13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR13_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR13_Clear = 0x1
	// Position of PR14 field.
	EXTI_PR_PR14_Pos = 0xe
	// Bit mask of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000
	// Bit PR14.
	EXTI_PR_PR14 = 0x4000
	// No trigger request occurred
	EXTI_PR_PR14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR14_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR14_Clear = 0x1
	// Position of PR15 field.
	EXTI_PR_PR15_Pos = 0xf
	// Bit mask of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000
	// Bit PR15.
	EXTI_PR_PR15 = 0x8000
	// No trigger request occurred
	EXTI_PR_PR15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR15_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR15_Clear = 0x1
	// Position of PR16 field.
	EXTI_PR_PR16_Pos = 0x10
	// Bit mask of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000
	// Bit PR16.
	EXTI_PR_PR16 = 0x10000
	// No trigger request occurred
	EXTI_PR_PR16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR16_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR16_Clear = 0x1
	// Position of PR17 field.
	EXTI_PR_PR17_Pos = 0x11
	// Bit mask of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000
	// Bit PR17.
	EXTI_PR_PR17 = 0x20000
	// No trigger request occurred
	EXTI_PR_PR17_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR17_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR17_Clear = 0x1
)

// Bitfields for DMA1: DMA controller
const (
	// ISR: DMA interrupt status register (DMA_ISR)
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1
	// No transfer error, half event, complete event
	DMA_ISR_GIF1_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF1_Event = 0x1
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// No transfer complete event
	DMA_ISR_TCIF1_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF1_Complete = 0x1
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// No half transfer event
	DMA_ISR_HTIF1_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF1_Half = 0x1
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// No transfer error
	DMA_ISR_TEIF1_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF1_Error = 0x1
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// No transfer error, half event, complete event
	DMA_ISR_GIF2_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF2_Event = 0x1
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// No transfer complete event
	DMA_ISR_TCIF2_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF2_Complete = 0x1
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// No half transfer event
	DMA_ISR_HTIF2_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF2_Half = 0x1
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// No transfer error
	DMA_ISR_TEIF2_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF2_Error = 0x1
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// No transfer error, half event, complete event
	DMA_ISR_GIF3_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF3_Event = 0x1
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// No transfer complete event
	DMA_ISR_TCIF3_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF3_Complete = 0x1
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// No half transfer event
	DMA_ISR_HTIF3_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF3_Half = 0x1
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// No transfer error
	DMA_ISR_TEIF3_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF3_Error = 0x1
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// No transfer error, half event, complete event
	DMA_ISR_GIF4_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF4_Event = 0x1
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// No transfer complete event
	DMA_ISR_TCIF4_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF4_Complete = 0x1
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// No half transfer event
	DMA_ISR_HTIF4_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF4_Half = 0x1
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// No transfer error
	DMA_ISR_TEIF4_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF4_Error = 0x1
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// No transfer error, half event, complete event
	DMA_ISR_GIF5_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF5_Event = 0x1
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// No transfer complete event
	DMA_ISR_TCIF5_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF5_Complete = 0x1
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// No half transfer event
	DMA_ISR_HTIF5_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF5_Half = 0x1
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000
	// No transfer error
	DMA_ISR_TEIF5_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF5_Error = 0x1
	// Position of GIF6 field.
	DMA_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_ISR_GIF6 = 0x100000
	// No transfer error, half event, complete event
	DMA_ISR_GIF6_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF6_Event = 0x1
	// Position of TCIF6 field.
	DMA_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_ISR_TCIF6 = 0x200000
	// No transfer complete event
	DMA_ISR_TCIF6_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF6_Complete = 0x1
	// Position of HTIF6 field.
	DMA_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_ISR_HTIF6 = 0x400000
	// No half transfer event
	DMA_ISR_HTIF6_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF6_Half = 0x1
	// Position of TEIF6 field.
	DMA_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_ISR_TEIF6 = 0x800000
	// No transfer error
	DMA_ISR_TEIF6_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF6_Error = 0x1
	// Position of GIF7 field.
	DMA_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_ISR_GIF7 = 0x1000000
	// No transfer error, half event, complete event
	DMA_ISR_GIF7_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF7_Event = 0x1
	// Position of TCIF7 field.
	DMA_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_ISR_TCIF7 = 0x2000000
	// No transfer complete event
	DMA_ISR_TCIF7_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF7_Complete = 0x1
	// Position of HTIF7 field.
	DMA_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_ISR_HTIF7 = 0x4000000
	// No half transfer event
	DMA_ISR_HTIF7_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF7_Half = 0x1
	// Position of TEIF7 field.
	DMA_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_ISR_TEIF7 = 0x8000000
	// No transfer error
	DMA_ISR_TEIF7_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF7_Error = 0x1

	// IFCR: DMA interrupt flag clear register (DMA_IFCR)
	// Position of CGIF1 field.
	DMA_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA_IFCR_CGIF1 = 0x1
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF1_Clear = 0x1
	// Position of CGIF2 field.
	DMA_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA_IFCR_CGIF2 = 0x10
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF2_Clear = 0x1
	// Position of CGIF3 field.
	DMA_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA_IFCR_CGIF3 = 0x100
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF3_Clear = 0x1
	// Position of CGIF4 field.
	DMA_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA_IFCR_CGIF4 = 0x1000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF4_Clear = 0x1
	// Position of CGIF5 field.
	DMA_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA_IFCR_CGIF5 = 0x10000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF5_Clear = 0x1
	// Position of CGIF6 field.
	DMA_IFCR_CGIF6_Pos = 0x14
	// Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6_Msk = 0x100000
	// Bit CGIF6.
	DMA_IFCR_CGIF6 = 0x100000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF6_Clear = 0x1
	// Position of CGIF7 field.
	DMA_IFCR_CGIF7_Pos = 0x18
	// Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7_Msk = 0x1000000
	// Bit CGIF7.
	DMA_IFCR_CGIF7 = 0x1000000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF7_Clear = 0x1
	// Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA_IFCR_CTCIF1 = 0x2
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF1_Clear = 0x1
	// Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA_IFCR_CTCIF2 = 0x20
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF2_Clear = 0x1
	// Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA_IFCR_CTCIF3 = 0x200
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF3_Clear = 0x1
	// Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA_IFCR_CTCIF4 = 0x2000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF4_Clear = 0x1
	// Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA_IFCR_CTCIF5 = 0x20000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF5_Clear = 0x1
	// Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_IFCR_CTCIF6 = 0x200000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF6_Clear = 0x1
	// Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Pos = 0x19
	// Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000
	// Bit CTCIF7.
	DMA_IFCR_CTCIF7 = 0x2000000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF7_Clear = 0x1
	// Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA_IFCR_CHTIF1 = 0x4
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF1_Clear = 0x1
	// Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA_IFCR_CHTIF2 = 0x40
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF2_Clear = 0x1
	// Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA_IFCR_CHTIF3 = 0x400
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF3_Clear = 0x1
	// Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA_IFCR_CHTIF4 = 0x4000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF4_Clear = 0x1
	// Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA_IFCR_CHTIF5 = 0x40000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF5_Clear = 0x1
	// Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Pos = 0x16
	// Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000
	// Bit CHTIF6.
	DMA_IFCR_CHTIF6 = 0x400000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF6_Clear = 0x1
	// Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_IFCR_CHTIF7 = 0x4000000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF7_Clear = 0x1
	// Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA_IFCR_CTEIF1 = 0x8
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF1_Clear = 0x1
	// Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA_IFCR_CTEIF2 = 0x80
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF2_Clear = 0x1
	// Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA_IFCR_CTEIF3 = 0x800
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF3_Clear = 0x1
	// Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Pos = 0xf
	// Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000
	// Bit CTEIF4.
	DMA_IFCR_CTEIF4 = 0x8000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF4_Clear = 0x1
	// Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA_IFCR_CTEIF5 = 0x80000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF5_Clear = 0x1
	// Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Pos = 0x17
	// Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000
	// Bit CTEIF6.
	DMA_IFCR_CTEIF6 = 0x800000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF6_Clear = 0x1
	// Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Pos = 0x1b
	// Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000
	// Bit CTEIF7.
	DMA_IFCR_CTEIF7 = 0x8000000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF7_Clear = 0x1

	// CH.CR: DMA channel configuration register (DMA_CCR)
	// Position of EN field.
	DMA_CH_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH_CR_EN_Msk = 0x1
	// Bit EN.
	DMA_CH_CR_EN = 0x1
	// Channel disabled
	DMA_CH_CR_EN_Disabled = 0x0
	// Channel enabled
	DMA_CH_CR_EN_Enabled = 0x1
	// Position of TCIE field.
	DMA_CH_CR_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CH_CR_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CH_CR_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CH_CR_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CH_CR_TCIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CH_CR_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CH_CR_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CH_CR_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CH_CR_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CH_CR_HTIE_Enabled = 0x1
	// Position of TEIE field.
	DMA_CH_CR_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CH_CR_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CH_CR_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CH_CR_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CH_CR_TEIE_Enabled = 0x1
	// Position of DIR field.
	DMA_CH_CR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CH_CR_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CH_CR_DIR = 0x10
	// Read from peripheral
	DMA_CH_CR_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CH_CR_DIR_FromMemory = 0x1
	// Position of CIRC field.
	DMA_CH_CR_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CH_CR_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CH_CR_CIRC = 0x20
	// Circular buffer disabled
	DMA_CH_CR_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CH_CR_CIRC_Enabled = 0x1
	// Position of PINC field.
	DMA_CH_CR_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CH_CR_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CH_CR_PINC = 0x40
	// Increment mode disabled
	DMA_CH_CR_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CH_CR_PINC_Enabled = 0x1
	// Position of MINC field.
	DMA_CH_CR_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CH_CR_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CH_CR_MINC = 0x80
	// Increment mode disabled
	DMA_CH_CR_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CH_CR_MINC_Enabled = 0x1
	// Position of PSIZE field.
	DMA_CH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CH_CR_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CH_CR_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CH_CR_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CH_CR_PSIZE_Bits32 = 0x2
	// Position of MSIZE field.
	DMA_CH_CR_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CH_CR_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CH_CR_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CH_CR_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CH_CR_MSIZE_Bits32 = 0x2
	// Position of PL field.
	DMA_CH_CR_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CH_CR_PL_Msk = 0x3000
	// Low priority
	DMA_CH_CR_PL_Low = 0x0
	// Medium priority
	DMA_CH_CR_PL_Medium = 0x1
	// High priority
	DMA_CH_CR_PL_High = 0x2
	// Very high priority
	DMA_CH_CR_PL_VeryHigh = 0x3
	// Position of MEM2MEM field.
	DMA_CH_CR_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CH_CR_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CH_CR_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CH_CR_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CH_CR_MEM2MEM_Enabled = 0x1

	// CH.NDTR: DMA channel 1 number of data register
	// Position of NDT field.
	DMA_CH_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CH_NDTR_NDT_Msk = 0xffff

	// CH.PAR: DMA channel 1 peripheral address register
	// Position of PA field.
	DMA_CH_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CH_PAR_PA_Msk = 0xffffffff

	// CH.MAR: DMA channel 1 memory address register
	// Position of MA field.
	DMA_CH_MAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CH_MAR_MA_Msk = 0xffffffff
)

// Bitfields for RTC: Real time clock
const (
	// CRH: RTC Control Register High
	// Position of SECIE field.
	RTC_CRH_SECIE_Pos = 0x0
	// Bit mask of SECIE field.
	RTC_CRH_SECIE_Msk = 0x1
	// Bit SECIE.
	RTC_CRH_SECIE = 0x1
	// Position of ALRIE field.
	RTC_CRH_ALRIE_Pos = 0x1
	// Bit mask of ALRIE field.
	RTC_CRH_ALRIE_Msk = 0x2
	// Bit ALRIE.
	RTC_CRH_ALRIE = 0x2
	// Position of OWIE field.
	RTC_CRH_OWIE_Pos = 0x2
	// Bit mask of OWIE field.
	RTC_CRH_OWIE_Msk = 0x4
	// Bit OWIE.
	RTC_CRH_OWIE = 0x4

	// CRL: RTC Control Register Low
	// Position of SECF field.
	RTC_CRL_SECF_Pos = 0x0
	// Bit mask of SECF field.
	RTC_CRL_SECF_Msk = 0x1
	// Bit SECF.
	RTC_CRL_SECF = 0x1
	// Position of ALRF field.
	RTC_CRL_ALRF_Pos = 0x1
	// Bit mask of ALRF field.
	RTC_CRL_ALRF_Msk = 0x2
	// Bit ALRF.
	RTC_CRL_ALRF = 0x2
	// Position of OWF field.
	RTC_CRL_OWF_Pos = 0x2
	// Bit mask of OWF field.
	RTC_CRL_OWF_Msk = 0x4
	// Bit OWF.
	RTC_CRL_OWF = 0x4
	// Position of RSF field.
	RTC_CRL_RSF_Pos = 0x3
	// Bit mask of RSF field.
	RTC_CRL_RSF_Msk = 0x8
	// Bit RSF.
	RTC_CRL_RSF = 0x8
	// Position of CNF field.
	RTC_CRL_CNF_Pos = 0x4
	// Bit mask of CNF field.
	RTC_CRL_CNF_Msk = 0x10
	// Bit CNF.
	RTC_CRL_CNF = 0x10
	// Position of RTOFF field.
	RTC_CRL_RTOFF_Pos = 0x5
	// Bit mask of RTOFF field.
	RTC_CRL_RTOFF_Msk = 0x20
	// Bit RTOFF.
	RTC_CRL_RTOFF = 0x20

	// PRLH: RTC Prescaler Load Register High
	// Position of PRLH field.
	RTC_PRLH_PRLH_Pos = 0x0
	// Bit mask of PRLH field.
	RTC_PRLH_PRLH_Msk = 0xf

	// PRLL: RTC Prescaler Load Register Low
	// Position of PRLL field.
	RTC_PRLL_PRLL_Pos = 0x0
	// Bit mask of PRLL field.
	RTC_PRLL_PRLL_Msk = 0xffff

	// DIVH: RTC Prescaler Divider Register High
	// Position of DIVH field.
	RTC_DIVH_DIVH_Pos = 0x0
	// Bit mask of DIVH field.
	RTC_DIVH_DIVH_Msk = 0xf

	// DIVL: RTC Prescaler Divider Register Low
	// Position of DIVL field.
	RTC_DIVL_DIVL_Pos = 0x0
	// Bit mask of DIVL field.
	RTC_DIVL_DIVL_Msk = 0xffff

	// CNTH: RTC Counter Register High
	// Position of CNTH field.
	RTC_CNTH_CNTH_Pos = 0x0
	// Bit mask of CNTH field.
	RTC_CNTH_CNTH_Msk = 0xffff

	// CNTL: RTC Counter Register Low
	// Position of CNTL field.
	RTC_CNTL_CNTL_Pos = 0x0
	// Bit mask of CNTL field.
	RTC_CNTL_CNTL_Msk = 0xffff

	// ALRH: RTC Alarm Register High
	// Position of ALRH field.
	RTC_ALRH_ALRH_Pos = 0x0
	// Bit mask of ALRH field.
	RTC_ALRH_ALRH_Msk = 0xffff

	// ALRL: RTC Alarm Register Low
	// Position of ALRL field.
	RTC_ALRL_ALRL_Pos = 0x0
	// Bit mask of ALRL field.
	RTC_ALRL_ALRL_Msk = 0xffff
)

// Bitfields for BKP: Backup registers
const (
	// DR0: Backup data register (BKP_DR)
	// Position of D field.
	BKP_DR_D_Pos = 0x0
	// Bit mask of D field.
	BKP_DR_D_Msk = 0xffff

	// RTCCR: RTC clock calibration register (BKP_RTCCR)
	// Position of CAL field.
	BKP_RTCCR_CAL_Pos = 0x0
	// Bit mask of CAL field.
	BKP_RTCCR_CAL_Msk = 0x7f
	// Position of CCO field.
	BKP_RTCCR_CCO_Pos = 0x7
	// Bit mask of CCO field.
	BKP_RTCCR_CCO_Msk = 0x80
	// Bit CCO.
	BKP_RTCCR_CCO = 0x80
	// Position of ASOE field.
	BKP_RTCCR_ASOE_Pos = 0x8
	// Bit mask of ASOE field.
	BKP_RTCCR_ASOE_Msk = 0x100
	// Bit ASOE.
	BKP_RTCCR_ASOE = 0x100
	// Disabled
	BKP_RTCCR_ASOE_Disabled = 0x0
	// Setting this bit outputs either the RTC Alarm pulse signal or the Second pulse signal on the TAMPER pin depending on the ASOS bit
	BKP_RTCCR_ASOE_Enabled = 0x1
	// Position of ASOS field.
	BKP_RTCCR_ASOS_Pos = 0x9
	// Bit mask of ASOS field.
	BKP_RTCCR_ASOS_Msk = 0x200
	// Bit ASOS.
	BKP_RTCCR_ASOS = 0x200
	// RTC Alarm pulse output selected
	BKP_RTCCR_ASOS_Alarm = 0x0
	// RTC Second pulse output selected
	BKP_RTCCR_ASOS_Second = 0x1

	// CR: Backup control register (BKP_CR)
	// Position of TPE field.
	BKP_CR_TPE_Pos = 0x0
	// Bit mask of TPE field.
	BKP_CR_TPE_Msk = 0x1
	// Bit TPE.
	BKP_CR_TPE = 0x1
	// The TAMPER pin is free for general purpose I/O
	BKP_CR_TPE_General = 0x0
	// Tamper alternate I/O function is activated
	BKP_CR_TPE_Alternate = 0x1
	// Position of TPAL field.
	BKP_CR_TPAL_Pos = 0x1
	// Bit mask of TPAL field.
	BKP_CR_TPAL_Msk = 0x2
	// Bit TPAL.
	BKP_CR_TPAL = 0x2
	// A high level on the TAMPER pin resets all data backup registers (if TPE bit is set)
	BKP_CR_TPAL_High = 0x0
	// A low level on the TAMPER pin resets all data backup registers (if TPE bit is set)
	BKP_CR_TPAL_Low = 0x1

	// CSR: BKP_CSR control/status register (BKP_CSR)
	// Position of CTE field.
	BKP_CSR_CTE_Pos = 0x0
	// Bit mask of CTE field.
	BKP_CSR_CTE_Msk = 0x1
	// Bit CTE.
	BKP_CSR_CTE = 0x1
	// Reset the TEF Tamper event flag (and the Tamper detector)
	BKP_CSR_CTE_Reset = 0x1
	// Position of CTI field.
	BKP_CSR_CTI_Pos = 0x1
	// Bit mask of CTI field.
	BKP_CSR_CTI_Msk = 0x2
	// Bit CTI.
	BKP_CSR_CTI = 0x2
	// Clear the Tamper interrupt and the TIF Tamper interrupt flag
	BKP_CSR_CTI_Clear = 0x1
	// Position of TPIE field.
	BKP_CSR_TPIE_Pos = 0x2
	// Bit mask of TPIE field.
	BKP_CSR_TPIE_Msk = 0x4
	// Bit TPIE.
	BKP_CSR_TPIE = 0x4
	// Tamper interrupt disabled
	BKP_CSR_TPIE_Disabled = 0x0
	// Tamper interrupt enabled (the TPE bit must also be set in the BKP_CR register
	BKP_CSR_TPIE_Enabled = 0x1
	// Position of TEF field.
	BKP_CSR_TEF_Pos = 0x8
	// Bit mask of TEF field.
	BKP_CSR_TEF_Msk = 0x100
	// Bit TEF.
	BKP_CSR_TEF = 0x100
	// Position of TIF field.
	BKP_CSR_TIF_Pos = 0x9
	// Bit mask of TIF field.
	BKP_CSR_TIF_Msk = 0x200
	// Bit TIF.
	BKP_CSR_TIF = 0x200

	// BKP_DR0: Backup data register (BKP_DR)
	// Position of D field.
	BKP_BKP_DR_D_Pos = 0x0
	// Bit mask of D field.
	BKP_BKP_DR_D_Msk = 0xffff
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register (IWDG_KR)
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register (IWDG_PR)
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register (IWDG_RLR)
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register (IWDG_SR)
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register (WWDG_CR)
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_Disabled = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_Enabled = 0x1

	// CFR: Configuration register (WWDG_CFR)
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// interrupt occurs whenever the counter reaches the value 0x40
	WWDG_CFR_EWI_Enable = 0x1
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0x7
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180
	// Counter clock (PCLK1 div 4096) div 1
	WWDG_CFR_WDGTB_Div1 = 0x0
	// Counter clock (PCLK1 div 4096) div 2
	WWDG_CFR_WDGTB_Div2 = 0x1
	// Counter clock (PCLK1 div 4096) div 4
	WWDG_CFR_WDGTB_Div4 = 0x2
	// Counter clock (PCLK1 div 4096) div 8
	WWDG_CFR_WDGTB_Div8 = 0x3

	// SR: Status register (WWDG_SR)
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
	// The EWI Interrupt Service Routine has been triggered
	WWDG_SR_EWIF_Pending = 0x1
	// The EWI Interrupt Service Routine has been serviced
	WWDG_SR_EWIF_Finished = 0x0
)

// Bitfields for TIM1: Advanced timer
const (
	// CR1: control register 1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIM_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIM_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIM_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIM_CR1_CMS_CenterAligned3 = 0x3
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_Down = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIM_CR1_OPM_Enabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1

	// CR2: control register 2
	// Position of OIS4 field.
	TIM_CR2_OIS4_Pos = 0xe
	// Bit mask of OIS4 field.
	TIM_CR2_OIS4_Msk = 0x4000
	// Bit OIS4.
	TIM_CR2_OIS4 = 0x4000
	// Position of OIS3N field.
	TIM_CR2_OIS3N_Pos = 0xd
	// Bit mask of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000
	// Bit OIS3N.
	TIM_CR2_OIS3N = 0x2000
	// Position of OIS3 field.
	TIM_CR2_OIS3_Pos = 0xc
	// Bit mask of OIS3 field.
	TIM_CR2_OIS3_Msk = 0x1000
	// Bit OIS3.
	TIM_CR2_OIS3 = 0x1000
	// Position of OIS2N field.
	TIM_CR2_OIS2N_Pos = 0xb
	// Bit mask of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800
	// Bit OIS2N.
	TIM_CR2_OIS2N = 0x800
	// Position of OIS2 field.
	TIM_CR2_OIS2_Pos = 0xa
	// Bit mask of OIS2 field.
	TIM_CR2_OIS2_Msk = 0x400
	// Bit OIS2.
	TIM_CR2_OIS2 = 0x400
	// Position of OIS1N field.
	TIM_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	TIM_CR2_OIS1N = 0x200
	// Position of OIS1 field.
	TIM_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	TIM_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	TIM_CR2_OIS1 = 0x100
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIM_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIM_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIM_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIM_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIM_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIM_CR2_CCDS_OnUpdate = 0x1
	// Position of CCUS field.
	TIM_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	TIM_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	TIM_CR2_CCUS = 0x4
	// Position of CCPC field.
	TIM_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	TIM_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	TIM_CR2_CCPC = 0x1

	// SMCR: slave mode control register
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIM_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIM_SMCR_ETP_Inverted = 0x1
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_Enabled = 0x1
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_Div8 = 0x3
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_Sync = 0x1
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIM_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIM_SMCR_TS_ETRF = 0x7
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIM_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIM_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIM_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_SMCR_SMS_Ext_Clock_Mode = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIM_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC1IE_Enabled = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIM_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC2IE_Enabled = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIM_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC3IE_Enabled = 0x1
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIM_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC4IE_Enabled = 0x1
	// Position of COMIE field.
	TIM_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	TIM_DIER_COMIE = 0x20
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_Enabled = 0x1
	// Position of BIE field.
	TIM_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	TIM_DIER_BIE_Msk = 0x80
	// Bit BIE.
	TIM_DIER_BIE = 0x80
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_Enabled = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIM_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC1DE_Enabled = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIM_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC2DE_Enabled = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIM_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC3DE_Enabled = 0x1
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIM_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC4DE_Enabled = 0x1
	// Position of COMDE field.
	TIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_DIER_COMDE = 0x2000
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_Enabled = 0x1

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC1OF_Clear = 0x0
	// Position of BIF field.
	TIM_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	TIM_SR_BIF_Msk = 0x80
	// Bit BIF.
	TIM_SR_BIF = 0x80
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred
	TIM_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIM_SR_TIF_Trigger = 0x1
	// Clear flag
	TIM_SR_TIF_Clear = 0x0
	// Position of COMIF field.
	TIM_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	TIM_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	TIM_SR_COMIF = 0x20
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC4IF_Match = 0x1
	// Clear flag
	TIM_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC3IF_Match = 0x1
	// Clear flag
	TIM_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC2IF_Match = 0x1
	// Clear flag
	TIM_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC1IF_Match = 0x1
	// Clear flag
	TIM_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1

	// EGR: event generation register
	// Position of BG field.
	TIM_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	TIM_EGR_BG_Msk = 0x80
	// Bit BG.
	TIM_EGR_BG = 0x80
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_Trigger = 0x1
	// Position of COMG field.
	TIM_EGR_COMG_Pos = 0x5
	// Bit mask of COMG field.
	TIM_EGR_COMG_Msk = 0x20
	// Bit COMG.
	TIM_EGR_COMG = 0x20
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIM_EGR_UG_Update = 0x1

	// CCMR1_Output: capture/compare mode register (output mode)
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately
	TIM_CCMR1_Output_OC2PE_Disabled = 0x0
	// Preload register on CCR2 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC2PE_Enabled = 0x1
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_Output = 0x0
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on CCR1 disabled. New values written to CCR1 are taken into account immediately
	TIM_CCMR1_Output_OC1PE_Disabled = 0x0
	// Preload register on CCR1 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC1PE_Enabled = 0x1
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_Output = 0x0

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xf
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0x78000
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_TI2 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_TI1 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC
	TIM_CCMR1_Input_CC2S_TRC = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N8 = 0xf
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_TI1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_TI2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC
	TIM_CCMR1_Input_CC1S_TRC = 0x3

	// CCMR2_Output: capture/compare mode register (output mode)
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Preload register on CCR4 disabled. New values written to CCR4 are taken into account immediately
	TIM_CCMR2_Output_OC4PE_Disabled = 0x0
	// Preload register on CCR4 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC4PE_Enabled = 0x1
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_Output = 0x0
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Preload register on CCR3 disabled. New values written to CCR3 are taken into account immediately
	TIM_CCMR2_Output_OC3PE_Disabled = 0x0
	// Preload register on CCR3 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC3PE_Enabled = 0x1
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_Output = 0x0

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xf
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0x78000
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_TI4 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_TI3 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC
	TIM_CCMR2_Input_CC4S_TRC = 0x3
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_TI3 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_TI4 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC
	TIM_CCMR2_Input_CC3S_TRC = 0x3

	// CCER: capture/compare enable register
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Position of CC3NE field.
	TIM_CCER_CC3NE_Pos = 0xa
	// Bit mask of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400
	// Bit CC3NE.
	TIM_CCER_CC3NE = 0x400
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Position of CC2NE field.
	TIM_CCER_CC2NE_Pos = 0x6
	// Bit mask of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40
	// Bit CC2NE.
	TIM_CCER_CC2NE = 0x40
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC1NE field.
	TIM_CCER_CC1NE_Pos = 0x2
	// Bit mask of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4
	// Bit CC1NE.
	TIM_CCER_CC1NE = 0x4
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffff

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffff

	// RCR: repetition counter register
	// Position of REP field.
	TIM_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	TIM_RCR_REP_Msk = 0xff

	// CCR1: capture/compare register 1
	// Position of CCR field.
	TIM_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR_CCR_Msk = 0xffff

	// BDTR: break and dead-time register
	// Position of MOE field.
	TIM_BDTR_MOE_Pos = 0xf
	// Bit mask of MOE field.
	TIM_BDTR_MOE_Msk = 0x8000
	// Bit MOE.
	TIM_BDTR_MOE = 0x8000
	// OC/OCN are disabled or forced idle depending on OSSI
	TIM_BDTR_MOE_DisabledIdle = 0x0
	// OC/OCN are enabled if CCxE/CCxNE are set
	TIM_BDTR_MOE_Enabled = 0x1
	// Position of AOE field.
	TIM_BDTR_AOE_Pos = 0xe
	// Bit mask of AOE field.
	TIM_BDTR_AOE_Msk = 0x4000
	// Bit AOE.
	TIM_BDTR_AOE = 0x4000
	// Position of BKP field.
	TIM_BDTR_BKP_Pos = 0xd
	// Bit mask of BKP field.
	TIM_BDTR_BKP_Msk = 0x2000
	// Bit BKP.
	TIM_BDTR_BKP = 0x2000
	// Position of BKE field.
	TIM_BDTR_BKE_Pos = 0xc
	// Bit mask of BKE field.
	TIM_BDTR_BKE_Msk = 0x1000
	// Bit BKE.
	TIM_BDTR_BKE = 0x1000
	// Position of OSSR field.
	TIM_BDTR_OSSR_Pos = 0xb
	// Bit mask of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800
	// Bit OSSR.
	TIM_BDTR_OSSR = 0x800
	// When inactive, OC/OCN outputs are disabled
	TIM_BDTR_OSSR_Disabled = 0x0
	// When inactive, OC/OCN outputs are enabled with their inactive level
	TIM_BDTR_OSSR_IdleLevel = 0x1
	// Position of OSSI field.
	TIM_BDTR_OSSI_Pos = 0xa
	// Bit mask of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400
	// Bit OSSI.
	TIM_BDTR_OSSI = 0x400
	// When inactive, OC/OCN outputs are disabled
	TIM_BDTR_OSSI_Disabled = 0x0
	// When inactive, OC/OCN outputs are forced to idle level
	TIM_BDTR_OSSI_IdleLevel = 0x1
	// Position of LOCK field.
	TIM_BDTR_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300
	// Position of DTG field.
	TIM_BDTR_DTG_Pos = 0x0
	// Bit mask of DTG field.
	TIM_BDTR_DTG_Msk = 0xff

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff
)

// Bitfields for I2C1: Inter integrated circuit
const (
	// CR1: Control register 1
	// Position of SWRST field.
	I2C_CR1_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	I2C_CR1_SWRST_Msk = 0x8000
	// Bit SWRST.
	I2C_CR1_SWRST = 0x8000
	// I2C peripheral not under reset
	I2C_CR1_SWRST_NotReset = 0x0
	// I2C peripheral under reset
	I2C_CR1_SWRST_Reset = 0x1
	// Position of ALERT field.
	I2C_CR1_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_CR1_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_CR1_ALERT = 0x2000
	// SMBA pin released high
	I2C_CR1_ALERT_Release = 0x0
	// SMBA pin driven low
	I2C_CR1_ALERT_Drive = 0x1
	// Position of PEC field.
	I2C_CR1_PEC_Pos = 0xc
	// Bit mask of PEC field.
	I2C_CR1_PEC_Msk = 0x1000
	// Bit PEC.
	I2C_CR1_PEC = 0x1000
	// No PEC transfer
	I2C_CR1_PEC_Disabled = 0x0
	// PEC transfer
	I2C_CR1_PEC_Enabled = 0x1
	// Position of POS field.
	I2C_CR1_POS_Pos = 0xb
	// Bit mask of POS field.
	I2C_CR1_POS_Msk = 0x800
	// Bit POS.
	I2C_CR1_POS = 0x800
	// ACK bit controls the (N)ACK of the current byte being received
	I2C_CR1_POS_Current = 0x0
	// ACK bit controls the (N)ACK of the next byte to be received
	I2C_CR1_POS_Next = 0x1
	// Position of ACK field.
	I2C_CR1_ACK_Pos = 0xa
	// Bit mask of ACK field.
	I2C_CR1_ACK_Msk = 0x400
	// Bit ACK.
	I2C_CR1_ACK = 0x400
	// No acknowledge returned
	I2C_CR1_ACK_NAK = 0x0
	// Acknowledge returned after a byte is received
	I2C_CR1_ACK_ACK = 0x1
	// Position of STOP field.
	I2C_CR1_STOP_Pos = 0x9
	// Bit mask of STOP field.
	I2C_CR1_STOP_Msk = 0x200
	// Bit STOP.
	I2C_CR1_STOP = 0x200
	// No Stop generation
	I2C_CR1_STOP_NoStop = 0x0
	// In master mode: stop generation after current byte/start, in slave mode: release SCL and SDA after current byte
	I2C_CR1_STOP_Stop = 0x1
	// Position of START field.
	I2C_CR1_START_Pos = 0x8
	// Bit mask of START field.
	I2C_CR1_START_Msk = 0x100
	// Bit START.
	I2C_CR1_START = 0x100
	// No Start generation
	I2C_CR1_START_NoStart = 0x0
	// In master mode: repeated start generation, in slave mode: start generation when bus is free
	I2C_CR1_START_Start = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x7
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x80
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x80
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of ENGC field.
	I2C_CR1_ENGC_Pos = 0x6
	// Bit mask of ENGC field.
	I2C_CR1_ENGC_Msk = 0x40
	// Bit ENGC.
	I2C_CR1_ENGC = 0x40
	// General call disabled
	I2C_CR1_ENGC_Disabled = 0x0
	// General call enabled
	I2C_CR1_ENGC_Enabled = 0x1
	// Position of ENPEC field.
	I2C_CR1_ENPEC_Pos = 0x5
	// Bit mask of ENPEC field.
	I2C_CR1_ENPEC_Msk = 0x20
	// Bit ENPEC.
	I2C_CR1_ENPEC = 0x20
	// PEC calculation disabled
	I2C_CR1_ENPEC_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_ENPEC_Enabled = 0x1
	// Position of ENARP field.
	I2C_CR1_ENARP_Pos = 0x4
	// Bit mask of ENARP field.
	I2C_CR1_ENARP_Msk = 0x10
	// Bit ENARP.
	I2C_CR1_ENARP = 0x10
	// ARP disabled
	I2C_CR1_ENARP_Disabled = 0x0
	// ARP enabled
	I2C_CR1_ENARP_Enabled = 0x1
	// Position of SMBTYPE field.
	I2C_CR1_SMBTYPE_Pos = 0x3
	// Bit mask of SMBTYPE field.
	I2C_CR1_SMBTYPE_Msk = 0x8
	// Bit SMBTYPE.
	I2C_CR1_SMBTYPE = 0x8
	// SMBus Device
	I2C_CR1_SMBTYPE_Device = 0x0
	// SMBus Host
	I2C_CR1_SMBTYPE_Host = 0x1
	// Position of SMBUS field.
	I2C_CR1_SMBUS_Pos = 0x1
	// Bit mask of SMBUS field.
	I2C_CR1_SMBUS_Msk = 0x2
	// Bit SMBUS.
	I2C_CR1_SMBUS = 0x2
	// I2C Mode
	I2C_CR1_SMBUS_I2C = 0x0
	// SMBus
	I2C_CR1_SMBUS_SMBus = 0x1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1

	// CR2: Control register 2
	// Position of LAST field.
	I2C_CR2_LAST_Pos = 0xc
	// Bit mask of LAST field.
	I2C_CR2_LAST_Msk = 0x1000
	// Bit LAST.
	I2C_CR2_LAST = 0x1000
	// Next DMA EOT is not the last transfer
	I2C_CR2_LAST_NotLast = 0x0
	// Next DMA EOT is the last transfer
	I2C_CR2_LAST_Last = 0x1
	// Position of DMAEN field.
	I2C_CR2_DMAEN_Pos = 0xb
	// Bit mask of DMAEN field.
	I2C_CR2_DMAEN_Msk = 0x800
	// Bit DMAEN.
	I2C_CR2_DMAEN = 0x800
	// DMA requests disabled
	I2C_CR2_DMAEN_Disabled = 0x0
	// DMA request enabled when TxE=1 or RxNE=1
	I2C_CR2_DMAEN_Enabled = 0x1
	// Position of ITBUFEN field.
	I2C_CR2_ITBUFEN_Pos = 0xa
	// Bit mask of ITBUFEN field.
	I2C_CR2_ITBUFEN_Msk = 0x400
	// Bit ITBUFEN.
	I2C_CR2_ITBUFEN = 0x400
	// TxE=1 or RxNE=1 does not generate any interrupt
	I2C_CR2_ITBUFEN_Disabled = 0x0
	// TxE=1 or RxNE=1 generates Event interrupt
	I2C_CR2_ITBUFEN_Enabled = 0x1
	// Position of ITEVTEN field.
	I2C_CR2_ITEVTEN_Pos = 0x9
	// Bit mask of ITEVTEN field.
	I2C_CR2_ITEVTEN_Msk = 0x200
	// Bit ITEVTEN.
	I2C_CR2_ITEVTEN = 0x200
	// Event interrupt disabled
	I2C_CR2_ITEVTEN_Disabled = 0x0
	// Event interrupt enabled
	I2C_CR2_ITEVTEN_Enabled = 0x1
	// Position of ITERREN field.
	I2C_CR2_ITERREN_Pos = 0x8
	// Bit mask of ITERREN field.
	I2C_CR2_ITERREN_Msk = 0x100
	// Bit ITERREN.
	I2C_CR2_ITERREN = 0x100
	// Error interrupt disabled
	I2C_CR2_ITERREN_Disabled = 0x0
	// Error interrupt enabled
	I2C_CR2_ITERREN_Enabled = 0x1
	// Position of FREQ field.
	I2C_CR2_FREQ_Pos = 0x0
	// Bit mask of FREQ field.
	I2C_CR2_FREQ_Msk = 0x3f

	// OAR1: Own address register 1
	// Position of ADDMODE field.
	I2C_OAR1_ADDMODE_Pos = 0xf
	// Bit mask of ADDMODE field.
	I2C_OAR1_ADDMODE_Msk = 0x8000
	// Bit ADDMODE.
	I2C_OAR1_ADDMODE = 0x8000
	// 7-bit slave address
	I2C_OAR1_ADDMODE_ADD7 = 0x0
	// 10-bit slave address
	I2C_OAR1_ADDMODE_ADD10 = 0x1
	// Position of ADD field.
	I2C_OAR1_ADD_Pos = 0x0
	// Bit mask of ADD field.
	I2C_OAR1_ADD_Msk = 0x3ff

	// OAR2: Own address register 2
	// Position of ADD2 field.
	I2C_OAR2_ADD2_Pos = 0x1
	// Bit mask of ADD2 field.
	I2C_OAR2_ADD2_Msk = 0xfe
	// Position of ENDUAL field.
	I2C_OAR2_ENDUAL_Pos = 0x0
	// Bit mask of ENDUAL field.
	I2C_OAR2_ENDUAL_Msk = 0x1
	// Bit ENDUAL.
	I2C_OAR2_ENDUAL = 0x1
	// Single addressing mode
	I2C_OAR2_ENDUAL_Single = 0x0
	// Dual addressing mode
	I2C_OAR2_ENDUAL_Dual = 0x1

	// DR: Data register
	// Position of DR field.
	I2C_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	I2C_DR_DR_Msk = 0xff

	// SR1: Status register 1
	// Position of SMBALERT field.
	I2C_SR1_SMBALERT_Pos = 0xf
	// Bit mask of SMBALERT field.
	I2C_SR1_SMBALERT_Msk = 0x8000
	// Bit SMBALERT.
	I2C_SR1_SMBALERT = 0x8000
	// No SMBALERT occured
	I2C_SR1_SMBALERT_NoAlert = 0x0
	// SMBALERT occurred
	I2C_SR1_SMBALERT_Alert = 0x1
	// Position of TIMEOUT field.
	I2C_SR1_TIMEOUT_Pos = 0xe
	// Bit mask of TIMEOUT field.
	I2C_SR1_TIMEOUT_Msk = 0x4000
	// Bit TIMEOUT.
	I2C_SR1_TIMEOUT = 0x4000
	// No Timeout error
	I2C_SR1_TIMEOUT_NoTimeout = 0x0
	// SCL remained LOW for 25 ms
	I2C_SR1_TIMEOUT_Timeout = 0x1
	// Position of PECERR field.
	I2C_SR1_PECERR_Pos = 0xc
	// Bit mask of PECERR field.
	I2C_SR1_PECERR_Msk = 0x1000
	// Bit PECERR.
	I2C_SR1_PECERR = 0x1000
	// no PEC error: receiver returns ACK after PEC reception (if ACK=1)
	I2C_SR1_PECERR_NoError = 0x0
	// PEC error: receiver returns NACK after PEC reception (whatever ACK)
	I2C_SR1_PECERR_Error = 0x1
	// Position of OVR field.
	I2C_SR1_OVR_Pos = 0xb
	// Bit mask of OVR field.
	I2C_SR1_OVR_Msk = 0x800
	// Bit OVR.
	I2C_SR1_OVR = 0x800
	// No overrun/underrun occured
	I2C_SR1_OVR_NoOverrun = 0x0
	// Overrun/underrun occured
	I2C_SR1_OVR_Overrun = 0x1
	// Position of AF field.
	I2C_SR1_AF_Pos = 0xa
	// Bit mask of AF field.
	I2C_SR1_AF_Msk = 0x400
	// Bit AF.
	I2C_SR1_AF = 0x400
	// No acknowledge failure
	I2C_SR1_AF_NoFailure = 0x0
	// Acknowledge failure
	I2C_SR1_AF_Failure = 0x1
	// Position of ARLO field.
	I2C_SR1_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_SR1_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_SR1_ARLO = 0x200
	// No Arbitration Lost detected
	I2C_SR1_ARLO_NoLost = 0x0
	// Arbitration Lost detected
	I2C_SR1_ARLO_Lost = 0x1
	// Position of BERR field.
	I2C_SR1_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_SR1_BERR_Msk = 0x100
	// Bit BERR.
	I2C_SR1_BERR = 0x100
	// No misplaced Start or Stop condition
	I2C_SR1_BERR_NoError = 0x0
	// Misplaced Start or Stop condition
	I2C_SR1_BERR_Error = 0x1
	// Position of TxE field.
	I2C_SR1_TxE_Pos = 0x7
	// Bit mask of TxE field.
	I2C_SR1_TxE_Msk = 0x80
	// Bit TxE.
	I2C_SR1_TxE = 0x80
	// Data register not empty
	I2C_SR1_TxE_NotEmpty = 0x0
	// Data register empty
	I2C_SR1_TxE_Empty = 0x1
	// Position of RxNE field.
	I2C_SR1_RxNE_Pos = 0x6
	// Bit mask of RxNE field.
	I2C_SR1_RxNE_Msk = 0x40
	// Bit RxNE.
	I2C_SR1_RxNE = 0x40
	// Data register empty
	I2C_SR1_RxNE_Empty = 0x0
	// Data register not empty
	I2C_SR1_RxNE_NotEmpty = 0x1
	// Position of STOPF field.
	I2C_SR1_STOPF_Pos = 0x4
	// Bit mask of STOPF field.
	I2C_SR1_STOPF_Msk = 0x10
	// Bit STOPF.
	I2C_SR1_STOPF = 0x10
	// No Stop condition detected
	I2C_SR1_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_SR1_STOPF_Stop = 0x1
	// Position of ADD10 field.
	I2C_SR1_ADD10_Pos = 0x3
	// Bit mask of ADD10 field.
	I2C_SR1_ADD10_Msk = 0x8
	// Bit ADD10.
	I2C_SR1_ADD10 = 0x8
	// Position of BTF field.
	I2C_SR1_BTF_Pos = 0x2
	// Bit mask of BTF field.
	I2C_SR1_BTF_Msk = 0x4
	// Bit BTF.
	I2C_SR1_BTF = 0x4
	// Data byte transfer not done
	I2C_SR1_BTF_NotFinished = 0x0
	// Data byte transfer successful
	I2C_SR1_BTF_Finished = 0x1
	// Position of ADDR field.
	I2C_SR1_ADDR_Pos = 0x1
	// Bit mask of ADDR field.
	I2C_SR1_ADDR_Msk = 0x2
	// Bit ADDR.
	I2C_SR1_ADDR = 0x2
	// Adress mismatched or not received
	I2C_SR1_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_SR1_ADDR_Match = 0x1
	// Position of SB field.
	I2C_SR1_SB_Pos = 0x0
	// Bit mask of SB field.
	I2C_SR1_SB_Msk = 0x1
	// Bit SB.
	I2C_SR1_SB = 0x1
	// No Start condition
	I2C_SR1_SB_NoStart = 0x0
	// Start condition generated
	I2C_SR1_SB_Start = 0x1

	// SR2: Status register 2
	// Position of PEC field.
	I2C_SR2_PEC_Pos = 0x8
	// Bit mask of PEC field.
	I2C_SR2_PEC_Msk = 0xff00
	// Position of DUALF field.
	I2C_SR2_DUALF_Pos = 0x7
	// Bit mask of DUALF field.
	I2C_SR2_DUALF_Msk = 0x80
	// Bit DUALF.
	I2C_SR2_DUALF = 0x80
	// Position of SMBHOST field.
	I2C_SR2_SMBHOST_Pos = 0x6
	// Bit mask of SMBHOST field.
	I2C_SR2_SMBHOST_Msk = 0x40
	// Bit SMBHOST.
	I2C_SR2_SMBHOST = 0x40
	// Position of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Pos = 0x5
	// Bit mask of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Msk = 0x20
	// Bit SMBDEFAULT.
	I2C_SR2_SMBDEFAULT = 0x20
	// Position of GENCALL field.
	I2C_SR2_GENCALL_Pos = 0x4
	// Bit mask of GENCALL field.
	I2C_SR2_GENCALL_Msk = 0x10
	// Bit GENCALL.
	I2C_SR2_GENCALL = 0x10
	// Position of TRA field.
	I2C_SR2_TRA_Pos = 0x2
	// Bit mask of TRA field.
	I2C_SR2_TRA_Msk = 0x4
	// Bit TRA.
	I2C_SR2_TRA = 0x4
	// Position of BUSY field.
	I2C_SR2_BUSY_Pos = 0x1
	// Bit mask of BUSY field.
	I2C_SR2_BUSY_Msk = 0x2
	// Bit BUSY.
	I2C_SR2_BUSY = 0x2
	// Position of MSL field.
	I2C_SR2_MSL_Pos = 0x0
	// Bit mask of MSL field.
	I2C_SR2_MSL_Msk = 0x1
	// Bit MSL.
	I2C_SR2_MSL = 0x1

	// CCR: Clock control register
	// Position of F_S field.
	I2C_CCR_F_S_Pos = 0xf
	// Bit mask of F_S field.
	I2C_CCR_F_S_Msk = 0x8000
	// Bit F_S.
	I2C_CCR_F_S = 0x8000
	// Standard mode I2C
	I2C_CCR_F_S_Standard = 0x0
	// Fast mode I2C
	I2C_CCR_F_S_Fast = 0x1
	// Position of DUTY field.
	I2C_CCR_DUTY_Pos = 0xe
	// Bit mask of DUTY field.
	I2C_CCR_DUTY_Msk = 0x4000
	// Bit DUTY.
	I2C_CCR_DUTY = 0x4000
	// Duty cycle t_low/t_high = 2/1
	I2C_CCR_DUTY_Duty2_1 = 0x0
	// Duty cycle t_low/t_high = 16/9
	I2C_CCR_DUTY_Duty16_9 = 0x1
	// Position of CCR field.
	I2C_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	I2C_CCR_CCR_Msk = 0xfff

	// TRISE: TRISE register
	// Position of TRISE field.
	I2C_TRISE_TRISE_Pos = 0x0
	// Bit mask of TRISE field.
	I2C_TRISE_TRISE_Msk = 0x3f
)

// Bitfields for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// 2-line unidirectional data mode selected
	SPI_CR1_BIDIMODE_Unidirectional = 0x0
	// 1-line bidirectional data mode selected
	SPI_CR1_BIDIMODE_Bidirectional = 0x1
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Output disabled (receive-only mode)
	SPI_CR1_BIDIOE_OutputDisabled = 0x0
	// Output enabled (transmit-only mode)
	SPI_CR1_BIDIOE_OutputEnabled = 0x1
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// CRC calculation disabled
	SPI_CR1_CRCEN_Disabled = 0x0
	// CRC calculation enabled
	SPI_CR1_CRCEN_Enabled = 0x1
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Next transmit value is from Tx buffer
	SPI_CR1_CRCNEXT_TxBuffer = 0x0
	// Next transmit value is from Tx CRC register
	SPI_CR1_CRCNEXT_CRC = 0x1
	// Position of DFF field.
	SPI_CR1_DFF_Pos = 0xb
	// Bit mask of DFF field.
	SPI_CR1_DFF_Msk = 0x800
	// Bit DFF.
	SPI_CR1_DFF = 0x800
	// 8-bit data frame format is selected for transmission/reception
	SPI_CR1_DFF_EightBit = 0x0
	// 16-bit data frame format is selected for transmission/reception
	SPI_CR1_DFF_SixteenBit = 0x1
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Full duplex (Transmit and receive)
	SPI_CR1_RXONLY_FullDuplex = 0x0
	// Output disabled (Receive-only mode)
	SPI_CR1_RXONLY_OutputDisabled = 0x1
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Software slave management disabled
	SPI_CR1_SSM_Disabled = 0x0
	// Software slave management enabled
	SPI_CR1_SSM_Enabled = 0x1
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// 0 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveSelected = 0x0
	// 1 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveNotSelected = 0x1
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Data is transmitted/received with the MSB first
	SPI_CR1_LSBFIRST_MSBFirst = 0x0
	// Data is transmitted/received with the LSB first
	SPI_CR1_LSBFIRST_LSBFirst = 0x1
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Peripheral disabled
	SPI_CR1_SPE_Disabled = 0x0
	// Peripheral enabled
	SPI_CR1_SPE_Enabled = 0x1
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// f_PCLK / 2
	SPI_CR1_BR_Div2 = 0x0
	// f_PCLK / 4
	SPI_CR1_BR_Div4 = 0x1
	// f_PCLK / 8
	SPI_CR1_BR_Div8 = 0x2
	// f_PCLK / 16
	SPI_CR1_BR_Div16 = 0x3
	// f_PCLK / 32
	SPI_CR1_BR_Div32 = 0x4
	// f_PCLK / 64
	SPI_CR1_BR_Div64 = 0x5
	// f_PCLK / 128
	SPI_CR1_BR_Div128 = 0x6
	// f_PCLK / 256
	SPI_CR1_BR_Div256 = 0x7
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Slave configuration
	SPI_CR1_MSTR_Slave = 0x0
	// Master configuration
	SPI_CR1_MSTR_Master = 0x1
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// CK to 0 when idle
	SPI_CR1_CPOL_IdleLow = 0x0
	// CK to 1 when idle
	SPI_CR1_CPOL_IdleHigh = 0x1
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1
	// The first clock transition is the first data capture edge
	SPI_CR1_CPHA_FirstEdge = 0x0
	// The second clock transition is the first data capture edge
	SPI_CR1_CPHA_SecondEdge = 0x1

	// CR2: control register 2
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// TXE interrupt masked
	SPI_CR2_TXEIE_Masked = 0x0
	// TXE interrupt not masked
	SPI_CR2_TXEIE_NotMasked = 0x1
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// RXE interrupt masked
	SPI_CR2_RXNEIE_Masked = 0x0
	// RXE interrupt not masked
	SPI_CR2_RXNEIE_NotMasked = 0x1
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Error interrupt masked
	SPI_CR2_ERRIE_Masked = 0x0
	// Error interrupt not masked
	SPI_CR2_ERRIE_NotMasked = 0x1
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// SS output is disabled in master mode
	SPI_CR2_SSOE_Disabled = 0x0
	// SS output is enabled in master mode
	SPI_CR2_SSOE_Enabled = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Tx buffer DMA disabled
	SPI_CR2_TXDMAEN_Disabled = 0x0
	// Tx buffer DMA enabled
	SPI_CR2_TXDMAEN_Enabled = 0x1
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Rx buffer DMA disabled
	SPI_CR2_RXDMAEN_Disabled = 0x0
	// Rx buffer DMA enabled
	SPI_CR2_RXDMAEN_Enabled = 0x1

	// SR: status register
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// SPI not busy
	SPI_SR_BSY_NotBusy = 0x0
	// SPI busy
	SPI_SR_BSY_Busy = 0x1
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// No overrun occurred
	SPI_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	SPI_SR_OVR_Overrun = 0x1
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// No mode fault occurred
	SPI_SR_MODF_NoFault = 0x0
	// Mode fault occurred
	SPI_SR_MODF_Fault = 0x1
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// CRC value received matches the SPIx_RXCRCR value
	SPI_SR_CRCERR_Match = 0x0
	// CRC value received does not match the SPIx_RXCRCR value
	SPI_SR_CRCERR_NoMatch = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Tx buffer not empty
	SPI_SR_TXE_NotEmpty = 0x0
	// Tx buffer empty
	SPI_SR_TXE_Empty = 0x1
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Rx buffer empty
	SPI_SR_RXNE_Empty = 0x0
	// Rx buffer not empty
	SPI_SR_RXNE_NotEmpty = 0x1

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// SR: Status register
	// Position of CTS field.
	USART_SR_CTS_Pos = 0x9
	// Bit mask of CTS field.
	USART_SR_CTS_Msk = 0x200
	// Bit CTS.
	USART_SR_CTS = 0x200
	// Position of LBD field.
	USART_SR_LBD_Pos = 0x8
	// Bit mask of LBD field.
	USART_SR_LBD_Msk = 0x100
	// Bit LBD.
	USART_SR_LBD = 0x100
	// Position of TXE field.
	USART_SR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_SR_TXE_Msk = 0x80
	// Bit TXE.
	USART_SR_TXE = 0x80
	// Position of TC field.
	USART_SR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_SR_TC_Msk = 0x40
	// Bit TC.
	USART_SR_TC = 0x40
	// Position of RXNE field.
	USART_SR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_SR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_SR_RXNE = 0x20
	// Position of IDLE field.
	USART_SR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_SR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_SR_IDLE = 0x10
	// Position of ORE field.
	USART_SR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_SR_ORE_Msk = 0x8
	// Bit ORE.
	USART_SR_ORE = 0x8
	// Position of NE field.
	USART_SR_NE_Pos = 0x2
	// Bit mask of NE field.
	USART_SR_NE_Msk = 0x4
	// Bit NE.
	USART_SR_NE = 0x4
	// Position of FE field.
	USART_SR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_SR_FE_Msk = 0x2
	// Bit FE.
	USART_SR_FE = 0x2
	// Position of PE field.
	USART_SR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_SR_PE_Msk = 0x1
	// Bit PE.
	USART_SR_PE = 0x1

	// DR: Data register
	// Position of DR field.
	USART_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	USART_DR_DR_Msk = 0x1ff

	// BRR: Baud rate register
	// Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Pos = 0x4
	// Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0
	// Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Pos = 0x0
	// Bit mask of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf

	// CR1: Control register 1
	// Position of UE field.
	USART_CR1_UE_Pos = 0xd
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x2000
	// Bit UE.
	USART_CR1_UE = 0x2000
	// USART prescaler and outputs disabled
	USART_CR1_UE_Disabled = 0x0
	// USART enabled
	USART_CR1_UE_Enabled = 0x1
	// Position of M field.
	USART_CR1_M_Pos = 0xc
	// Bit mask of M field.
	USART_CR1_M_Msk = 0x1000
	// Bit M.
	USART_CR1_M = 0x1000
	// 8 data bits
	USART_CR1_M_M8 = 0x0
	// 9 data bits
	USART_CR1_M_M9 = 0x1
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// USART wakeup on idle line
	USART_CR1_WAKE_IdleLine = 0x0
	// USART wakeup on address mark
	USART_CR1_WAKE_AddressMark = 0x1
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Parity control disabled
	USART_CR1_PCE_Disabled = 0x0
	// Parity control enabled
	USART_CR1_PCE_Enabled = 0x1
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Even parity
	USART_CR1_PS_Even = 0x0
	// Odd parity
	USART_CR1_PS_Odd = 0x1
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// PE interrupt disabled
	USART_CR1_PEIE_Disabled = 0x0
	// PE interrupt enabled
	USART_CR1_PEIE_Enabled = 0x1
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// TXE interrupt disabled
	USART_CR1_TXEIE_Disabled = 0x0
	// TXE interrupt enabled
	USART_CR1_TXEIE_Enabled = 0x1
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// TC interrupt disabled
	USART_CR1_TCIE_Disabled = 0x0
	// TC interrupt enabled
	USART_CR1_TCIE_Enabled = 0x1
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// RXNE interrupt disabled
	USART_CR1_RXNEIE_Disabled = 0x0
	// RXNE interrupt enabled
	USART_CR1_RXNEIE_Enabled = 0x1
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// IDLE interrupt disabled
	USART_CR1_IDLEIE_Disabled = 0x0
	// IDLE interrupt enabled
	USART_CR1_IDLEIE_Enabled = 0x1
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Transmitter disabled
	USART_CR1_TE_Disabled = 0x0
	// Transmitter enabled
	USART_CR1_TE_Enabled = 0x1
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Receiver disabled
	USART_CR1_RE_Disabled = 0x0
	// Receiver enabled
	USART_CR1_RE_Enabled = 0x1
	// Position of RWU field.
	USART_CR1_RWU_Pos = 0x1
	// Bit mask of RWU field.
	USART_CR1_RWU_Msk = 0x2
	// Bit RWU.
	USART_CR1_RWU = 0x2
	// Receiver in active mode
	USART_CR1_RWU_Active = 0x0
	// Receiver in mute mode
	USART_CR1_RWU_Mute = 0x1
	// Position of SBK field.
	USART_CR1_SBK_Pos = 0x0
	// Bit mask of SBK field.
	USART_CR1_SBK_Msk = 0x1
	// Bit SBK.
	USART_CR1_SBK = 0x1
	// No break character is transmitted
	USART_CR1_SBK_NoBreak = 0x0
	// Break character transmitted
	USART_CR1_SBK_Break = 0x1

	// CR2: Control register 2
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_Disabled = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_Enabled = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_Stop1 = 0x0
	// 0.5 stop bits
	USART_CR2_STOP_Stop0p5 = 0x1
	// 2 stop bits
	USART_CR2_STOP_Stop2 = 0x2
	// 1.5 stop bits
	USART_CR2_STOP_Stop1p5 = 0x3
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// CK pin disabled
	USART_CR2_CLKEN_Disabled = 0x0
	// CK pin enabled
	USART_CR2_CLKEN_Enabled = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on CK pin outside transmission window
	USART_CR2_CPOL_Low = 0x0
	// Steady high value on CK pin outside transmission window
	USART_CR2_CPOL_High = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_First = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_Second = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// LIN break detection interrupt disabled
	USART_CR2_LBDIE_Disabled = 0x0
	// LIN break detection interrupt enabled
	USART_CR2_LBDIE_Enabled = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_LBDL10 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_LBDL11 = 0x1
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x0
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xf

	// CR3: Control register 3
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// CTS interrupt disabled
	USART_CR3_CTSIE_Disabled = 0x0
	// CTS interrupt enabled
	USART_CR3_CTSIE_Enabled = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_Disabled = 0x0
	// CTS hardware flow control enabled
	USART_CR3_CTSE_Enabled = 0x1
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_Disabled = 0x0
	// RTS hardware flow control enabled
	USART_CR3_RTSE_Enabled = 0x1
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_Disabled = 0x0
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_Enabled = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is disabled for reception
	USART_CR3_DMAR_Disabled = 0x0
	// DMA mode is enabled for reception
	USART_CR3_DMAR_Enabled = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard mode disabled
	USART_CR3_SCEN_Disabled = 0x0
	// Smartcard mode enabled
	USART_CR3_SCEN_Enabled = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_Disabled = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_Enabled = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_FullDuplex = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_HalfDuplex = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_Normal = 0x0
	// Low-power mode
	USART_CR3_IRLP_LowPower = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_Disabled = 0x0
	// IrDA enabled
	USART_CR3_IREN_Enabled = 0x1
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Error interrupt disabled
	USART_CR3_EIE_Disabled = 0x0
	// Error interrupt enabled
	USART_CR3_EIE_Enabled = 0x1

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff
)

// Bitfields for ADC1: Analog to digital converter
const (
	// SR: status register
	// Position of STRT field.
	ADC_SR_STRT_Pos = 0x4
	// Bit mask of STRT field.
	ADC_SR_STRT_Msk = 0x10
	// Bit STRT.
	ADC_SR_STRT = 0x10
	// No regular channel conversion started
	ADC_SR_STRT_NotStarted = 0x0
	// Regular channel conversion has started
	ADC_SR_STRT_Started = 0x1
	// Clear the Regular channel Start flag
	ADC_SR_STRT_Clear = 0x0
	// Position of JSTRT field.
	ADC_SR_JSTRT_Pos = 0x3
	// Bit mask of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8
	// Bit JSTRT.
	ADC_SR_JSTRT = 0x8
	// No injected group conversion started
	ADC_SR_JSTRT_NotStarted = 0x0
	// Injected group conversion has started
	ADC_SR_JSTRT_Started = 0x1
	// Clear Injected channel Start flag
	ADC_SR_JSTRT_Clear = 0x0
	// Position of JEOC field.
	ADC_SR_JEOC_Pos = 0x2
	// Bit mask of JEOC field.
	ADC_SR_JEOC_Msk = 0x4
	// Bit JEOC.
	ADC_SR_JEOC = 0x4
	// Conversion is not complete
	ADC_SR_JEOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_JEOC_Complete = 0x1
	// Clear Injected channel end of conversion flag
	ADC_SR_JEOC_Clear = 0x0
	// Position of EOC field.
	ADC_SR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	ADC_SR_EOC_Msk = 0x2
	// Bit EOC.
	ADC_SR_EOC = 0x2
	// Conversion is not complete
	ADC_SR_EOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_EOC_Complete = 0x1
	// Clear End of conversion flag
	ADC_SR_EOC_Clear = 0x0
	// Position of AWD field.
	ADC_SR_AWD_Pos = 0x0
	// Bit mask of AWD field.
	ADC_SR_AWD_Msk = 0x1
	// Bit AWD.
	ADC_SR_AWD = 0x1
	// No analog watchdog event occurred
	ADC_SR_AWD_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_SR_AWD_Event = 0x1
	// Clear the analog watchdog event flag
	ADC_SR_AWD_Clear = 0x0

	// CR1: control register 1
	// Position of AWDEN field.
	ADC_CR1_AWDEN_Pos = 0x17
	// Bit mask of AWDEN field.
	ADC_CR1_AWDEN_Msk = 0x800000
	// Bit AWDEN.
	ADC_CR1_AWDEN = 0x800000
	// Analog watchdog disabled on regular channels
	ADC_CR1_AWDEN_Disabled = 0x0
	// Analog watchdog enabled on regular channels
	ADC_CR1_AWDEN_Enabled = 0x1
	// Position of JAWDEN field.
	ADC_CR1_JAWDEN_Pos = 0x16
	// Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN_Msk = 0x400000
	// Bit JAWDEN.
	ADC_CR1_JAWDEN = 0x400000
	// Analog watchdog disabled on injected channels
	ADC_CR1_JAWDEN_Disabled = 0x0
	// Analog watchdog enabled on injected channels
	ADC_CR1_JAWDEN_Enabled = 0x1
	// Position of DISCNUM field.
	ADC_CR1_DISCNUM_Pos = 0xd
	// Bit mask of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000
	// Position of JDISCEN field.
	ADC_CR1_JDISCEN_Pos = 0xc
	// Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000
	// Bit JDISCEN.
	ADC_CR1_JDISCEN = 0x1000
	// Discontinuous mode on injected channels disabled
	ADC_CR1_JDISCEN_Disabled = 0x0
	// Discontinuous mode on injected channels enabled
	ADC_CR1_JDISCEN_Enabled = 0x1
	// Position of DISCEN field.
	ADC_CR1_DISCEN_Pos = 0xb
	// Bit mask of DISCEN field.
	ADC_CR1_DISCEN_Msk = 0x800
	// Bit DISCEN.
	ADC_CR1_DISCEN = 0x800
	// Discontinuous mode on regular channels disabled
	ADC_CR1_DISCEN_Disabled = 0x0
	// Discontinuous mode on regular channels enabled
	ADC_CR1_DISCEN_Enabled = 0x1
	// Position of JAUTO field.
	ADC_CR1_JAUTO_Pos = 0xa
	// Bit mask of JAUTO field.
	ADC_CR1_JAUTO_Msk = 0x400
	// Bit JAUTO.
	ADC_CR1_JAUTO = 0x400
	// Automatic injected group conversion disabled
	ADC_CR1_JAUTO_Disabled = 0x0
	// Automatic injected group conversion enabled
	ADC_CR1_JAUTO_Enabled = 0x1
	// Position of AWDSGL field.
	ADC_CR1_AWDSGL_Pos = 0x9
	// Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL_Msk = 0x200
	// Bit AWDSGL.
	ADC_CR1_AWDSGL = 0x200
	// Analog watchdog enabled on all channels
	ADC_CR1_AWDSGL_All = 0x0
	// Analog watchdog enabled on a single channel
	ADC_CR1_AWDSGL_Single = 0x1
	// Position of SCAN field.
	ADC_CR1_SCAN_Pos = 0x8
	// Bit mask of SCAN field.
	ADC_CR1_SCAN_Msk = 0x100
	// Bit SCAN.
	ADC_CR1_SCAN = 0x100
	// Scan mode disabled
	ADC_CR1_SCAN_Disabled = 0x0
	// Scan mode enabled
	ADC_CR1_SCAN_Enabled = 0x1
	// Position of JEOCIE field.
	ADC_CR1_JEOCIE_Pos = 0x7
	// Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE_Msk = 0x80
	// Bit JEOCIE.
	ADC_CR1_JEOCIE = 0x80
	// JEOC interrupt disabled
	ADC_CR1_JEOCIE_Disabled = 0x0
	// JEOC interrupt enabled. An interrupt is generated when the JEOC bit is set
	ADC_CR1_JEOCIE_Enabled = 0x1
	// Position of AWDIE field.
	ADC_CR1_AWDIE_Pos = 0x6
	// Bit mask of AWDIE field.
	ADC_CR1_AWDIE_Msk = 0x40
	// Bit AWDIE.
	ADC_CR1_AWDIE = 0x40
	// Analog watchdog interrupt disabled
	ADC_CR1_AWDIE_Disabled = 0x0
	// Analog watchdog interrupt enabled
	ADC_CR1_AWDIE_Enabled = 0x1
	// Position of EOCIE field.
	ADC_CR1_EOCIE_Pos = 0x5
	// Bit mask of EOCIE field.
	ADC_CR1_EOCIE_Msk = 0x20
	// Bit EOCIE.
	ADC_CR1_EOCIE = 0x20
	// EOC interrupt disabled
	ADC_CR1_EOCIE_Disabled = 0x0
	// EOC interrupt enabled. An interrupt is generated when the EOC bit is set
	ADC_CR1_EOCIE_Enabled = 0x1
	// Position of AWDCH field.
	ADC_CR1_AWDCH_Pos = 0x0
	// Bit mask of AWDCH field.
	ADC_CR1_AWDCH_Msk = 0x1f

	// CR2: control register 2
	// Position of TSVREFE field.
	ADC_CR2_TSVREFE_Pos = 0x17
	// Bit mask of TSVREFE field.
	ADC_CR2_TSVREFE_Msk = 0x800000
	// Bit TSVREFE.
	ADC_CR2_TSVREFE = 0x800000
	// Temperature sensor and V_REFINT channel disabled
	ADC_CR2_TSVREFE_Disabled = 0x0
	// Temperature sensor and V_REFINT channel enabled
	ADC_CR2_TSVREFE_Enabled = 0x1
	// Position of SWSTART field.
	ADC_CR2_SWSTART_Pos = 0x16
	// Bit mask of SWSTART field.
	ADC_CR2_SWSTART_Msk = 0x400000
	// Bit SWSTART.
	ADC_CR2_SWSTART = 0x400000
	// Reset state
	ADC_CR2_SWSTART_Started = 0x0
	// Starting conversion of regular channels
	ADC_CR2_SWSTART_NotStarted = 0x1
	// Start conversion of regular channels
	ADC_CR2_SWSTART_Start = 0x1
	// Position of JSWSTART field.
	ADC_CR2_JSWSTART_Pos = 0x15
	// Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x200000
	// Bit JSWSTART.
	ADC_CR2_JSWSTART = 0x200000
	// Reset state
	ADC_CR2_JSWSTART_Started = 0x0
	// Starting conversion of injected channels
	ADC_CR2_JSWSTART_NotStarted = 0x1
	// Start conversion of injected channels
	ADC_CR2_JSWSTART_Start = 0x1
	// Position of EXTTRIG field.
	ADC_CR2_EXTTRIG_Pos = 0x14
	// Bit mask of EXTTRIG field.
	ADC_CR2_EXTTRIG_Msk = 0x100000
	// Bit EXTTRIG.
	ADC_CR2_EXTTRIG = 0x100000
	// Conversion on external event disabled
	ADC_CR2_EXTTRIG_Disabled = 0x0
	// Conversion on external event enabled
	ADC_CR2_EXTTRIG_Enabled = 0x1
	// Position of EXTSEL field.
	ADC_CR2_EXTSEL_Pos = 0x11
	// Bit mask of EXTSEL field.
	ADC_CR2_EXTSEL_Msk = 0xe0000
	// Timer 1 CC1 event
	ADC_CR2_EXTSEL_Tim1Cc1 = 0x0
	// Timer 1 CC2 event
	ADC_CR2_EXTSEL_Tim1Cc2 = 0x1
	// Timer 1 CC3 event
	ADC_CR2_EXTSEL_Tim1Cc3 = 0x2
	// Timer 2 CC2 event
	ADC_CR2_EXTSEL_Tim2Cc2 = 0x3
	// Timer 3 TRGO event
	ADC_CR2_EXTSEL_Tim3Trgo = 0x4
	// Timer 4 CC4 event
	ADC_CR2_EXTSEL_Tim4Cc4 = 0x5
	// EXTI line 11/TIM8_TRGO event (TIM8_TRGO is available only in high-density and XL-density devices)
	ADC_CR2_EXTSEL_Exti11 = 0x6
	// SWSTART
	ADC_CR2_EXTSEL_Swstart = 0x7
	// Position of JEXTTRIG field.
	ADC_CR2_JEXTTRIG_Pos = 0xf
	// Bit mask of JEXTTRIG field.
	ADC_CR2_JEXTTRIG_Msk = 0x8000
	// Bit JEXTTRIG.
	ADC_CR2_JEXTTRIG = 0x8000
	// Conversion on external event disabled
	ADC_CR2_JEXTTRIG_Disabled = 0x0
	// Conversion on external event enabled
	ADC_CR2_JEXTTRIG_Enabled = 0x1
	// Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Pos = 0xc
	// Bit mask of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk = 0x7000
	// Timer 1 TRGO event
	ADC_CR2_JEXTSEL_Tim1Trgo = 0x0
	// Timer 1 CC4 event
	ADC_CR2_JEXTSEL_Tim1Cc4 = 0x1
	// Timer 2 TRGO event
	ADC_CR2_JEXTSEL_Tim2Trgo = 0x2
	// Timer 2 CC1 event
	ADC_CR2_JEXTSEL_Tim2Cc1 = 0x3
	// Timer 3 CC4 event
	ADC_CR2_JEXTSEL_Tim3Cc4 = 0x4
	// Timer 4 TRGO event
	ADC_CR2_JEXTSEL_Tim4Trgo = 0x5
	// EXTI line15/TIM8_CC4 event (TIM8_CC4 is available only in high-density and XL-density devices)
	ADC_CR2_JEXTSEL_Exti15 = 0x6
	// JSWSTART
	ADC_CR2_JEXTSEL_Jswstart = 0x7
	// Position of ALIGN field.
	ADC_CR2_ALIGN_Pos = 0xb
	// Bit mask of ALIGN field.
	ADC_CR2_ALIGN_Msk = 0x800
	// Bit ALIGN.
	ADC_CR2_ALIGN = 0x800
	// Right Alignment
	ADC_CR2_ALIGN_Right = 0x0
	// Left Alignment
	ADC_CR2_ALIGN_Left = 0x1
	// Position of DMA field.
	ADC_CR2_DMA_Pos = 0x8
	// Bit mask of DMA field.
	ADC_CR2_DMA_Msk = 0x100
	// Bit DMA.
	ADC_CR2_DMA = 0x100
	// DMA mode disabled
	ADC_CR2_DMA_Disabled = 0x0
	// DMA mode enabled
	ADC_CR2_DMA_Enabled = 0x1
	// Position of RSTCAL field.
	ADC_CR2_RSTCAL_Pos = 0x3
	// Bit mask of RSTCAL field.
	ADC_CR2_RSTCAL_Msk = 0x8
	// Bit RSTCAL.
	ADC_CR2_RSTCAL = 0x8
	// Calibration register initialized
	ADC_CR2_RSTCAL_Initialized = 0x0
	// Initializing calibration register
	ADC_CR2_RSTCAL_NotInitialized = 0x1
	// Initialize calibration register
	ADC_CR2_RSTCAL_Initialize = 0x1
	// Position of CAL field.
	ADC_CR2_CAL_Pos = 0x2
	// Bit mask of CAL field.
	ADC_CR2_CAL_Msk = 0x4
	// Bit CAL.
	ADC_CR2_CAL = 0x4
	// Calibration completed
	ADC_CR2_CAL_Complete = 0x0
	// Calibrating
	ADC_CR2_CAL_NotComplete = 0x1
	// Enable calibration
	ADC_CR2_CAL_Start = 0x1
	// Position of CONT field.
	ADC_CR2_CONT_Pos = 0x1
	// Bit mask of CONT field.
	ADC_CR2_CONT_Msk = 0x2
	// Bit CONT.
	ADC_CR2_CONT = 0x2
	// Single conversion mode
	ADC_CR2_CONT_Single = 0x0
	// Continuous conversion mode
	ADC_CR2_CONT_Continuous = 0x1
	// Position of ADON field.
	ADC_CR2_ADON_Pos = 0x0
	// Bit mask of ADON field.
	ADC_CR2_ADON_Msk = 0x1
	// Bit ADON.
	ADC_CR2_ADON = 0x1
	// Disable ADC conversion/calibration and go to power down mode
	ADC_CR2_ADON_Disabled = 0x0
	// Enable ADC and to start conversion
	ADC_CR2_ADON_Enabled = 0x1

	// SMPR1: sample time register 1
	// Position of SMP10 field.
	ADC_SMPR1_SMP10_Pos = 0x0
	// Bit mask of SMP10 field.
	ADC_SMPR1_SMP10_Msk = 0x7
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP10_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP10_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR1_SMP10_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR1_SMP10_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR1_SMP10_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR1_SMP10_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR1_SMP10_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR1_SMP10_Cycles239_5 = 0x7
	// Position of SMP11 field.
	ADC_SMPR1_SMP11_Pos = 0x3
	// Bit mask of SMP11 field.
	ADC_SMPR1_SMP11_Msk = 0x38
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP11_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP11_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR1_SMP11_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR1_SMP11_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR1_SMP11_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR1_SMP11_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR1_SMP11_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR1_SMP11_Cycles239_5 = 0x7
	// Position of SMP12 field.
	ADC_SMPR1_SMP12_Pos = 0x6
	// Bit mask of SMP12 field.
	ADC_SMPR1_SMP12_Msk = 0x1c0
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP12_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP12_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR1_SMP12_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR1_SMP12_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR1_SMP12_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR1_SMP12_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR1_SMP12_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR1_SMP12_Cycles239_5 = 0x7
	// Position of SMP13 field.
	ADC_SMPR1_SMP13_Pos = 0x9
	// Bit mask of SMP13 field.
	ADC_SMPR1_SMP13_Msk = 0xe00
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP13_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP13_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR1_SMP13_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR1_SMP13_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR1_SMP13_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR1_SMP13_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR1_SMP13_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR1_SMP13_Cycles239_5 = 0x7
	// Position of SMP14 field.
	ADC_SMPR1_SMP14_Pos = 0xc
	// Bit mask of SMP14 field.
	ADC_SMPR1_SMP14_Msk = 0x7000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP14_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP14_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR1_SMP14_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR1_SMP14_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR1_SMP14_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR1_SMP14_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR1_SMP14_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR1_SMP14_Cycles239_5 = 0x7
	// Position of SMP15 field.
	ADC_SMPR1_SMP15_Pos = 0xf
	// Bit mask of SMP15 field.
	ADC_SMPR1_SMP15_Msk = 0x38000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP15_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP15_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR1_SMP15_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR1_SMP15_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR1_SMP15_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR1_SMP15_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR1_SMP15_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR1_SMP15_Cycles239_5 = 0x7
	// Position of SMP16 field.
	ADC_SMPR1_SMP16_Pos = 0x12
	// Bit mask of SMP16 field.
	ADC_SMPR1_SMP16_Msk = 0x1c0000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP16_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP16_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR1_SMP16_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR1_SMP16_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR1_SMP16_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR1_SMP16_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR1_SMP16_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR1_SMP16_Cycles239_5 = 0x7
	// Position of SMP17 field.
	ADC_SMPR1_SMP17_Pos = 0x15
	// Bit mask of SMP17 field.
	ADC_SMPR1_SMP17_Msk = 0xe00000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP17_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP17_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR1_SMP17_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR1_SMP17_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR1_SMP17_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR1_SMP17_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR1_SMP17_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR1_SMP17_Cycles239_5 = 0x7

	// SMPR2: sample time register 2
	// Position of SMP0 field.
	ADC_SMPR2_SMP0_Pos = 0x0
	// Bit mask of SMP0 field.
	ADC_SMPR2_SMP0_Msk = 0x7
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP0_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP0_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR2_SMP0_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR2_SMP0_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR2_SMP0_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR2_SMP0_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR2_SMP0_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR2_SMP0_Cycles239_5 = 0x7
	// Position of SMP1 field.
	ADC_SMPR2_SMP1_Pos = 0x3
	// Bit mask of SMP1 field.
	ADC_SMPR2_SMP1_Msk = 0x38
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP1_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP1_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR2_SMP1_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR2_SMP1_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR2_SMP1_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR2_SMP1_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR2_SMP1_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR2_SMP1_Cycles239_5 = 0x7
	// Position of SMP2 field.
	ADC_SMPR2_SMP2_Pos = 0x6
	// Bit mask of SMP2 field.
	ADC_SMPR2_SMP2_Msk = 0x1c0
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP2_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP2_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR2_SMP2_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR2_SMP2_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR2_SMP2_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR2_SMP2_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR2_SMP2_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR2_SMP2_Cycles239_5 = 0x7
	// Position of SMP3 field.
	ADC_SMPR2_SMP3_Pos = 0x9
	// Bit mask of SMP3 field.
	ADC_SMPR2_SMP3_Msk = 0xe00
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP3_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP3_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR2_SMP3_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR2_SMP3_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR2_SMP3_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR2_SMP3_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR2_SMP3_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR2_SMP3_Cycles239_5 = 0x7
	// Position of SMP4 field.
	ADC_SMPR2_SMP4_Pos = 0xc
	// Bit mask of SMP4 field.
	ADC_SMPR2_SMP4_Msk = 0x7000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP4_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP4_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR2_SMP4_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR2_SMP4_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR2_SMP4_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR2_SMP4_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR2_SMP4_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR2_SMP4_Cycles239_5 = 0x7
	// Position of SMP5 field.
	ADC_SMPR2_SMP5_Pos = 0xf
	// Bit mask of SMP5 field.
	ADC_SMPR2_SMP5_Msk = 0x38000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP5_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP5_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR2_SMP5_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR2_SMP5_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR2_SMP5_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR2_SMP5_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR2_SMP5_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR2_SMP5_Cycles239_5 = 0x7
	// Position of SMP6 field.
	ADC_SMPR2_SMP6_Pos = 0x12
	// Bit mask of SMP6 field.
	ADC_SMPR2_SMP6_Msk = 0x1c0000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP6_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP6_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR2_SMP6_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR2_SMP6_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR2_SMP6_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR2_SMP6_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR2_SMP6_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR2_SMP6_Cycles239_5 = 0x7
	// Position of SMP7 field.
	ADC_SMPR2_SMP7_Pos = 0x15
	// Bit mask of SMP7 field.
	ADC_SMPR2_SMP7_Msk = 0xe00000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP7_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP7_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR2_SMP7_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR2_SMP7_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR2_SMP7_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR2_SMP7_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR2_SMP7_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR2_SMP7_Cycles239_5 = 0x7
	// Position of SMP8 field.
	ADC_SMPR2_SMP8_Pos = 0x18
	// Bit mask of SMP8 field.
	ADC_SMPR2_SMP8_Msk = 0x7000000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP8_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP8_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR2_SMP8_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR2_SMP8_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR2_SMP8_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR2_SMP8_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR2_SMP8_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR2_SMP8_Cycles239_5 = 0x7
	// Position of SMP9 field.
	ADC_SMPR2_SMP9_Pos = 0x1b
	// Bit mask of SMP9 field.
	ADC_SMPR2_SMP9_Msk = 0x38000000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP9_Cycles1_5 = 0x0
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP9_Cycles7_5 = 0x1
	// 13.5 ADC clock cycles
	ADC_SMPR2_SMP9_Cycles13_5 = 0x2
	// 28.5 ADC clock cycles
	ADC_SMPR2_SMP9_Cycles28_5 = 0x3
	// 41.5 ADC clock cycles
	ADC_SMPR2_SMP9_Cycles41_5 = 0x4
	// 55.5 ADC clock cycles
	ADC_SMPR2_SMP9_Cycles55_5 = 0x5
	// 71.5 ADC clock cycles
	ADC_SMPR2_SMP9_Cycles71_5 = 0x6
	// 239.5 ADC clock cycles
	ADC_SMPR2_SMP9_Cycles239_5 = 0x7

	// JOFR1: injected channel data offset register x
	// Position of JOFFSET1 field.
	ADC_JOFR1_JOFFSET1_Pos = 0x0
	// Bit mask of JOFFSET1 field.
	ADC_JOFR1_JOFFSET1_Msk = 0xfff

	// JOFR2: injected channel data offset register x
	// Position of JOFFSET2 field.
	ADC_JOFR2_JOFFSET2_Pos = 0x0
	// Bit mask of JOFFSET2 field.
	ADC_JOFR2_JOFFSET2_Msk = 0xfff

	// JOFR3: injected channel data offset register x
	// Position of JOFFSET3 field.
	ADC_JOFR3_JOFFSET3_Pos = 0x0
	// Bit mask of JOFFSET3 field.
	ADC_JOFR3_JOFFSET3_Msk = 0xfff

	// JOFR4: injected channel data offset register x
	// Position of JOFFSET4 field.
	ADC_JOFR4_JOFFSET4_Pos = 0x0
	// Bit mask of JOFFSET4 field.
	ADC_JOFR4_JOFFSET4_Msk = 0xfff

	// HTR: watchdog higher threshold register
	// Position of HT field.
	ADC_HTR_HT_Pos = 0x0
	// Bit mask of HT field.
	ADC_HTR_HT_Msk = 0xfff

	// LTR: watchdog lower threshold register
	// Position of LT field.
	ADC_LTR_LT_Pos = 0x0
	// Bit mask of LT field.
	ADC_LTR_LT_Msk = 0xfff

	// SQR1: regular sequence register 1
	// Position of L field.
	ADC_SQR1_L_Pos = 0x14
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf00000
	// Position of SQ16 field.
	ADC_SQR1_SQ16_Pos = 0xf
	// Bit mask of SQ16 field.
	ADC_SQR1_SQ16_Msk = 0xf8000
	// Position of SQ15 field.
	ADC_SQR1_SQ15_Pos = 0xa
	// Bit mask of SQ15 field.
	ADC_SQR1_SQ15_Msk = 0x7c00
	// Position of SQ14 field.
	ADC_SQR1_SQ14_Pos = 0x5
	// Bit mask of SQ14 field.
	ADC_SQR1_SQ14_Msk = 0x3e0
	// Position of SQ13 field.
	ADC_SQR1_SQ13_Pos = 0x0
	// Bit mask of SQ13 field.
	ADC_SQR1_SQ13_Msk = 0x1f

	// SQR2: regular sequence register 2
	// Position of SQ12 field.
	ADC_SQR2_SQ12_Pos = 0x19
	// Bit mask of SQ12 field.
	ADC_SQR2_SQ12_Msk = 0x3e000000
	// Position of SQ11 field.
	ADC_SQR2_SQ11_Pos = 0x14
	// Bit mask of SQ11 field.
	ADC_SQR2_SQ11_Msk = 0x1f00000
	// Position of SQ10 field.
	ADC_SQR2_SQ10_Pos = 0xf
	// Bit mask of SQ10 field.
	ADC_SQR2_SQ10_Msk = 0xf8000
	// Position of SQ9 field.
	ADC_SQR2_SQ9_Pos = 0xa
	// Bit mask of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x7c00
	// Position of SQ8 field.
	ADC_SQR2_SQ8_Pos = 0x5
	// Bit mask of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x3e0
	// Position of SQ7 field.
	ADC_SQR2_SQ7_Pos = 0x0
	// Bit mask of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f

	// SQR3: regular sequence register 3
	// Position of SQ6 field.
	ADC_SQR3_SQ6_Pos = 0x19
	// Bit mask of SQ6 field.
	ADC_SQR3_SQ6_Msk = 0x3e000000
	// Position of SQ5 field.
	ADC_SQR3_SQ5_Pos = 0x14
	// Bit mask of SQ5 field.
	ADC_SQR3_SQ5_Msk = 0x1f00000
	// Position of SQ4 field.
	ADC_SQR3_SQ4_Pos = 0xf
	// Bit mask of SQ4 field.
	ADC_SQR3_SQ4_Msk = 0xf8000
	// Position of SQ3 field.
	ADC_SQR3_SQ3_Pos = 0xa
	// Bit mask of SQ3 field.
	ADC_SQR3_SQ3_Msk = 0x7c00
	// Position of SQ2 field.
	ADC_SQR3_SQ2_Pos = 0x5
	// Bit mask of SQ2 field.
	ADC_SQR3_SQ2_Msk = 0x3e0
	// Position of SQ1 field.
	ADC_SQR3_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_SQR3_SQ1_Msk = 0x1f

	// JSQR: injected sequence register
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x14
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x300000
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0xf
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0xa
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0x5
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x0
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f

	// JDR1: injected data register x
	// Position of JDATA field.
	ADC_JDR1_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR1_JDATA_Msk = 0xffff

	// JDR2: injected data register x
	// Position of JDATA field.
	ADC_JDR2_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR2_JDATA_Msk = 0xffff

	// JDR3: injected data register x
	// Position of JDATA field.
	ADC_JDR3_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR3_JDATA_Msk = 0xffff

	// JDR4: injected data register x
	// Position of JDATA field.
	ADC_JDR4_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR4_JDATA_Msk = 0xffff

	// DR: regular data register
	// Position of DATA field.
	ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_DR_DATA_Msk = 0xffff
)

// Bitfields for DAC: Digital to analog converter
const (
	// CR: Control register (DAC_CR)
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// DAC channel X disabled
	DAC_CR_EN1_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN1_Enabled = 0x1
	// Position of BOFF1 field.
	DAC_CR_BOFF1_Pos = 0x1
	// Bit mask of BOFF1 field.
	DAC_CR_BOFF1_Msk = 0x2
	// Bit BOFF1.
	DAC_CR_BOFF1 = 0x2
	// DAC channel X output buffer enabled
	DAC_CR_BOFF1_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF1_Disabled = 0x1
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x2
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x4
	// Bit TEN1.
	DAC_CR_TEN1 = 0x4
	// DAC channel X trigger disabled
	DAC_CR_TEN1_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN1_Enabled = 0x1
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x3
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x38
	// Timer 6 TRGO event
	DAC_CR_TSEL1_TIM6_TRGO = 0x0
	// Timer 3 TRGO event
	DAC_CR_TSEL1_TIM3_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL1_TIM7_TRGO = 0x2
	// Timer 15 TRGO event
	DAC_CR_TSEL1_TIM15_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL1_TIM2_TRGO = 0x4
	// EXTI line9
	DAC_CR_TSEL1_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL1_SOFTWARE = 0x7
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Wave generation disabled
	DAC_CR_WAVE1_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE1_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE1_Triangle = 0x2
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN1_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN1_Enabled = 0x1
	// Position of EN2 field.
	DAC_CR_EN2_Pos = 0x10
	// Bit mask of EN2 field.
	DAC_CR_EN2_Msk = 0x10000
	// Bit EN2.
	DAC_CR_EN2 = 0x10000
	// DAC channel X disabled
	DAC_CR_EN2_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN2_Enabled = 0x1
	// Position of BOFF2 field.
	DAC_CR_BOFF2_Pos = 0x11
	// Bit mask of BOFF2 field.
	DAC_CR_BOFF2_Msk = 0x20000
	// Bit BOFF2.
	DAC_CR_BOFF2 = 0x20000
	// DAC channel X output buffer enabled
	DAC_CR_BOFF2_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF2_Disabled = 0x1
	// Position of TEN2 field.
	DAC_CR_TEN2_Pos = 0x12
	// Bit mask of TEN2 field.
	DAC_CR_TEN2_Msk = 0x40000
	// Bit TEN2.
	DAC_CR_TEN2 = 0x40000
	// DAC channel X trigger disabled
	DAC_CR_TEN2_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN2_Enabled = 0x1
	// Position of TSEL2 field.
	DAC_CR_TSEL2_Pos = 0x13
	// Bit mask of TSEL2 field.
	DAC_CR_TSEL2_Msk = 0x380000
	// Timer 6 TRGO event
	DAC_CR_TSEL2_TIM6_TRGO = 0x0
	// Timer 8 TRGO event
	DAC_CR_TSEL2_TIM8_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL2_TIM7_TRGO = 0x2
	// Timer 5 TRGO event
	DAC_CR_TSEL2_TIM5_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL2_TIM2_TRGO = 0x4
	// Timer 4 TRGO event
	DAC_CR_TSEL2_TIM4_TRGO = 0x5
	// EXTI line9
	DAC_CR_TSEL2_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL2_SOFTWARE = 0x7
	// Position of WAVE2 field.
	DAC_CR_WAVE2_Pos = 0x16
	// Bit mask of WAVE2 field.
	DAC_CR_WAVE2_Msk = 0xc00000
	// Wave generation disabled
	DAC_CR_WAVE2_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE2_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE2_Triangle = 0x2
	// Position of MAMP2 field.
	DAC_CR_MAMP2_Pos = 0x18
	// Bit mask of MAMP2 field.
	DAC_CR_MAMP2_Msk = 0xf000000
	// Position of DMAEN2 field.
	DAC_CR_DMAEN2_Pos = 0x1c
	// Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2_Msk = 0x10000000
	// Bit DMAEN2.
	DAC_CR_DMAEN2 = 0x10000000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN2_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN2_Enabled = 0x1
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE1_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE1_Enabled = 0x1
	// Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Pos = 0x1d
	// Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000
	// Bit DMAUDRIE2.
	DAC_CR_DMAUDRIE2 = 0x20000000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE2_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE2_Enabled = 0x1

	// SWTRIGR: DAC software trigger register (DAC_SWTRIGR)
	// Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG1 = 0x1
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG1_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG1_Enabled = 0x1
	// Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1
	// Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2
	// Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG2 = 0x2
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG2_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG2_Enabled = 0x1

	// DHR12R1: DAC channel1 12-bit right-aligned data holding register(DAC_DHR12R1)
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: DAC channel1 12-bit left aligned data holding register (DAC_DHR12L1)
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: DAC channel1 8-bit right aligned data holding register (DAC_DHR8R1)
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12R2: DAC channel2 12-bit right aligned data holding register (DAC_DHR12R2)
	// Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DHR12L2: DAC channel2 12-bit left aligned data holding register (DAC_DHR12L2)
	// Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DHR8R2: DAC channel2 8-bit right-aligned data holding register (DAC_DHR8R2)
	// Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register (DAC_DHR12RD), Bits 31:28 Reserved, Bits 15:12 Reserved
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff
	// Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000

	// DHR12LD: DUAL DAC 12-bit left aligned data holding register (DAC_DHR12LD), Bits 19:16 Reserved, Bits 3:0 Reserved
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0
	// Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000

	// DHR8RD: DUAL DAC 8-bit right aligned data holding register (DAC_DHR8RD), Bits 31:16 Reserved
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff
	// Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00

	// DOR1: DAC channel1 data output register (DAC_DOR1)
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DOR2: DAC channel2 data output register (DAC_DOR2)
	// Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff

	// SR: DAC status register
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_Underrun = 0x1
	// Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Pos = 0x1d
	// Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000
	// Bit DMAUDR2.
	DAC_SR_DMAUDR2 = 0x20000000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_Underrun = 0x1
)

// Bitfields for DBGMCU: Debug support
const (
	// IDCODE: DBGMCU_IDCODE
	// Position of DEV_ID field.
	DBG_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBG_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBG_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBG_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: DBGMCU_CR
	// Position of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBG_CR_DBG_SLEEP = 0x1
	// Position of DBG_STOP field.
	DBG_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBG_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBG_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBG_CR_DBG_STANDBY = 0x4
	// Position of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Pos = 0x5
	// Bit mask of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Msk = 0x20
	// Bit TRACE_IOEN.
	DBG_CR_TRACE_IOEN = 0x20
	// Position of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Pos = 0x6
	// Bit mask of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Msk = 0xc0
	// Position of DBG_IWDG_STOP field.
	DBG_CR_DBG_IWDG_STOP_Pos = 0x8
	// Bit mask of DBG_IWDG_STOP field.
	DBG_CR_DBG_IWDG_STOP_Msk = 0x100
	// Bit DBG_IWDG_STOP.
	DBG_CR_DBG_IWDG_STOP = 0x100
	// Position of DBG_WWDG_STOP field.
	DBG_CR_DBG_WWDG_STOP_Pos = 0x9
	// Bit mask of DBG_WWDG_STOP field.
	DBG_CR_DBG_WWDG_STOP_Msk = 0x200
	// Bit DBG_WWDG_STOP.
	DBG_CR_DBG_WWDG_STOP = 0x200
	// Position of DBG_TIM1_STOP field.
	DBG_CR_DBG_TIM1_STOP_Pos = 0xa
	// Bit mask of DBG_TIM1_STOP field.
	DBG_CR_DBG_TIM1_STOP_Msk = 0x400
	// Bit DBG_TIM1_STOP.
	DBG_CR_DBG_TIM1_STOP = 0x400
	// Position of DBG_TIM2_STOP field.
	DBG_CR_DBG_TIM2_STOP_Pos = 0xb
	// Bit mask of DBG_TIM2_STOP field.
	DBG_CR_DBG_TIM2_STOP_Msk = 0x800
	// Bit DBG_TIM2_STOP.
	DBG_CR_DBG_TIM2_STOP = 0x800
	// Position of DBG_TIM3_STOP field.
	DBG_CR_DBG_TIM3_STOP_Pos = 0xc
	// Bit mask of DBG_TIM3_STOP field.
	DBG_CR_DBG_TIM3_STOP_Msk = 0x1000
	// Bit DBG_TIM3_STOP.
	DBG_CR_DBG_TIM3_STOP = 0x1000
	// Position of DBG_TIM4_STOP field.
	DBG_CR_DBG_TIM4_STOP_Pos = 0xd
	// Bit mask of DBG_TIM4_STOP field.
	DBG_CR_DBG_TIM4_STOP_Msk = 0x2000
	// Bit DBG_TIM4_STOP.
	DBG_CR_DBG_TIM4_STOP = 0x2000
	// Position of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_CR_DBG_I2C1_SMBUS_TIMEOUT_Pos = 0xf
	// Bit mask of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_CR_DBG_I2C1_SMBUS_TIMEOUT_Msk = 0x8000
	// Bit DBG_I2C1_SMBUS_TIMEOUT.
	DBG_CR_DBG_I2C1_SMBUS_TIMEOUT = 0x8000
	// Position of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_CR_DBG_I2C2_SMBUS_TIMEOUT_Pos = 0x10
	// Bit mask of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_CR_DBG_I2C2_SMBUS_TIMEOUT_Msk = 0x10000
	// Bit DBG_I2C2_SMBUS_TIMEOUT.
	DBG_CR_DBG_I2C2_SMBUS_TIMEOUT = 0x10000
	// Position of DBG_TIM5_STOP field.
	DBG_CR_DBG_TIM5_STOP_Pos = 0x12
	// Bit mask of DBG_TIM5_STOP field.
	DBG_CR_DBG_TIM5_STOP_Msk = 0x40000
	// Bit DBG_TIM5_STOP.
	DBG_CR_DBG_TIM5_STOP = 0x40000
	// Position of DBG_TIM6_STOP field.
	DBG_CR_DBG_TIM6_STOP_Pos = 0x13
	// Bit mask of DBG_TIM6_STOP field.
	DBG_CR_DBG_TIM6_STOP_Msk = 0x80000
	// Bit DBG_TIM6_STOP.
	DBG_CR_DBG_TIM6_STOP = 0x80000
	// Position of DBG_TIM7_STOP field.
	DBG_CR_DBG_TIM7_STOP_Pos = 0x14
	// Bit mask of DBG_TIM7_STOP field.
	DBG_CR_DBG_TIM7_STOP_Msk = 0x100000
	// Bit DBG_TIM7_STOP.
	DBG_CR_DBG_TIM7_STOP = 0x100000
	// Position of DBG_TIM15_STOP field.
	DBG_CR_DBG_TIM15_STOP_Pos = 0x16
	// Bit mask of DBG_TIM15_STOP field.
	DBG_CR_DBG_TIM15_STOP_Msk = 0x400000
	// Bit DBG_TIM15_STOP.
	DBG_CR_DBG_TIM15_STOP = 0x400000
	// Position of DBG_TIM16_STOP field.
	DBG_CR_DBG_TIM16_STOP_Pos = 0x17
	// Bit mask of DBG_TIM16_STOP field.
	DBG_CR_DBG_TIM16_STOP_Msk = 0x800000
	// Bit DBG_TIM16_STOP.
	DBG_CR_DBG_TIM16_STOP = 0x800000
	// Position of DBG_TIM17_STOP field.
	DBG_CR_DBG_TIM17_STOP_Pos = 0x18
	// Bit mask of DBG_TIM17_STOP field.
	DBG_CR_DBG_TIM17_STOP_Msk = 0x1000000
	// Bit DBG_TIM17_STOP.
	DBG_CR_DBG_TIM17_STOP = 0x1000000
	// Position of DBG_TIM12_STOP field.
	DBG_CR_DBG_TIM12_STOP_Pos = 0x19
	// Bit mask of DBG_TIM12_STOP field.
	DBG_CR_DBG_TIM12_STOP_Msk = 0x2000000
	// Bit DBG_TIM12_STOP.
	DBG_CR_DBG_TIM12_STOP = 0x2000000
	// Position of DBG_TIM13_STOP field.
	DBG_CR_DBG_TIM13_STOP_Pos = 0x1a
	// Bit mask of DBG_TIM13_STOP field.
	DBG_CR_DBG_TIM13_STOP_Msk = 0x4000000
	// Bit DBG_TIM13_STOP.
	DBG_CR_DBG_TIM13_STOP = 0x4000000
	// Position of DBG_TIM14_STOP field.
	DBG_CR_DBG_TIM14_STOP_Pos = 0x1b
	// Bit mask of DBG_TIM14_STOP field.
	DBG_CR_DBG_TIM14_STOP_Msk = 0x8000000
	// Bit DBG_TIM14_STOP.
	DBG_CR_DBG_TIM14_STOP = 0x8000000
)

// Bitfields for CRC: CRC calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent Data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1
)

// Bitfields for FLASH: FLASH
const (
	// ACR: Flash access control register
	// Position of HLFCYA field.
	FLASH_ACR_HLFCYA_Pos = 0x3
	// Bit mask of HLFCYA field.
	FLASH_ACR_HLFCYA_Msk = 0x8
	// Bit HLFCYA.
	FLASH_ACR_HLFCYA = 0x8

	// KEYR: Flash key register
	// Position of KEY field.
	FLASH_KEYR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FLASH_KEYR_KEY_Msk = 0xffffffff

	// OPTKEYR: Flash option key register
	// Position of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Pos = 0x0
	// Bit mask of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	FLASH_SR_EOP_Pos = 0x5
	// Bit mask of EOP field.
	FLASH_SR_EOP_Msk = 0x20
	// Bit EOP.
	FLASH_SR_EOP = 0x20
	// Position of WRPRTERR field.
	FLASH_SR_WRPRTERR_Pos = 0x4
	// Bit mask of WRPRTERR field.
	FLASH_SR_WRPRTERR_Msk = 0x10
	// Bit WRPRTERR.
	FLASH_SR_WRPRTERR = 0x10
	// Position of PGERR field.
	FLASH_SR_PGERR_Pos = 0x2
	// Bit mask of PGERR field.
	FLASH_SR_PGERR_Msk = 0x4
	// Bit PGERR.
	FLASH_SR_PGERR = 0x4
	// Position of BSY field.
	FLASH_SR_BSY_Pos = 0x0
	// Bit mask of BSY field.
	FLASH_SR_BSY_Msk = 0x1
	// Bit BSY.
	FLASH_SR_BSY = 0x1

	// CR: Control register
	// Position of PG field.
	FLASH_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	FLASH_CR_PG_Msk = 0x1
	// Bit PG.
	FLASH_CR_PG = 0x1
	// Position of PER field.
	FLASH_CR_PER_Pos = 0x1
	// Bit mask of PER field.
	FLASH_CR_PER_Msk = 0x2
	// Bit PER.
	FLASH_CR_PER = 0x2
	// Position of MER field.
	FLASH_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	FLASH_CR_MER_Msk = 0x4
	// Bit MER.
	FLASH_CR_MER = 0x4
	// Position of OPTPG field.
	FLASH_CR_OPTPG_Pos = 0x4
	// Bit mask of OPTPG field.
	FLASH_CR_OPTPG_Msk = 0x10
	// Bit OPTPG.
	FLASH_CR_OPTPG = 0x10
	// Position of OPTER field.
	FLASH_CR_OPTER_Pos = 0x5
	// Bit mask of OPTER field.
	FLASH_CR_OPTER_Msk = 0x20
	// Bit OPTER.
	FLASH_CR_OPTER = 0x20
	// Position of STRT field.
	FLASH_CR_STRT_Pos = 0x6
	// Bit mask of STRT field.
	FLASH_CR_STRT_Msk = 0x40
	// Bit STRT.
	FLASH_CR_STRT = 0x40
	// Position of LOCK field.
	FLASH_CR_LOCK_Pos = 0x7
	// Bit mask of LOCK field.
	FLASH_CR_LOCK_Msk = 0x80
	// Bit LOCK.
	FLASH_CR_LOCK = 0x80
	// Position of OPTWRE field.
	FLASH_CR_OPTWRE_Pos = 0x9
	// Bit mask of OPTWRE field.
	FLASH_CR_OPTWRE_Msk = 0x200
	// Bit OPTWRE.
	FLASH_CR_OPTWRE = 0x200
	// Position of ERRIE field.
	FLASH_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	FLASH_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	FLASH_CR_ERRIE = 0x400
	// Position of EOPIE field.
	FLASH_CR_EOPIE_Pos = 0xc
	// Bit mask of EOPIE field.
	FLASH_CR_EOPIE_Msk = 0x1000
	// Bit EOPIE.
	FLASH_CR_EOPIE = 0x1000

	// AR: Flash address register
	// Position of FAR field.
	FLASH_AR_FAR_Pos = 0x0
	// Bit mask of FAR field.
	FLASH_AR_FAR_Msk = 0xffffffff

	// OBR: Option byte register
	// Position of OPTERR field.
	FLASH_OBR_OPTERR_Pos = 0x0
	// Bit mask of OPTERR field.
	FLASH_OBR_OPTERR_Msk = 0x1
	// Bit OPTERR.
	FLASH_OBR_OPTERR = 0x1
	// Position of RDPRT field.
	FLASH_OBR_RDPRT_Pos = 0x1
	// Bit mask of RDPRT field.
	FLASH_OBR_RDPRT_Msk = 0x2
	// Bit RDPRT.
	FLASH_OBR_RDPRT = 0x2
	// Position of WDG_SW field.
	FLASH_OBR_WDG_SW_Pos = 0x2
	// Bit mask of WDG_SW field.
	FLASH_OBR_WDG_SW_Msk = 0x4
	// Bit WDG_SW.
	FLASH_OBR_WDG_SW = 0x4
	// Position of NRST_STOP field.
	FLASH_OBR_NRST_STOP_Pos = 0x3
	// Bit mask of NRST_STOP field.
	FLASH_OBR_NRST_STOP_Msk = 0x8
	// Bit NRST_STOP.
	FLASH_OBR_NRST_STOP = 0x8
	// Position of NRST_STDBY field.
	FLASH_OBR_NRST_STDBY_Pos = 0x4
	// Bit mask of NRST_STDBY field.
	FLASH_OBR_NRST_STDBY_Msk = 0x10
	// Bit NRST_STDBY.
	FLASH_OBR_NRST_STDBY = 0x10
	// Position of Data0 field.
	FLASH_OBR_Data0_Pos = 0xa
	// Bit mask of Data0 field.
	FLASH_OBR_Data0_Msk = 0x3fc00
	// Position of Data1 field.
	FLASH_OBR_Data1_Pos = 0x12
	// Bit mask of Data1 field.
	FLASH_OBR_Data1_Msk = 0x3fc0000

	// WRPR: Write protection register
	// Position of WRP field.
	FLASH_WRPR_WRP_Pos = 0x0
	// Bit mask of WRP field.
	FLASH_WRPR_WRP_Msk = 0xffffffff
)

// Bitfields for CEC: HDMI-CEC controller
const (
	// CFGR: configuration register
	// Position of PE field.
	CEC_CFGR_PE_Pos = 0x0
	// Bit mask of PE field.
	CEC_CFGR_PE_Msk = 0x1
	// Bit PE.
	CEC_CFGR_PE = 0x1
	// Position of IE field.
	CEC_CFGR_IE_Pos = 0x1
	// Bit mask of IE field.
	CEC_CFGR_IE_Msk = 0x2
	// Bit IE.
	CEC_CFGR_IE = 0x2
	// Position of BTEM field.
	CEC_CFGR_BTEM_Pos = 0x2
	// Bit mask of BTEM field.
	CEC_CFGR_BTEM_Msk = 0x4
	// Bit BTEM.
	CEC_CFGR_BTEM = 0x4
	// Position of BPEM field.
	CEC_CFGR_BPEM_Pos = 0x3
	// Bit mask of BPEM field.
	CEC_CFGR_BPEM_Msk = 0x8
	// Bit BPEM.
	CEC_CFGR_BPEM = 0x8

	// OAR: CEC own address register
	// Position of OA field.
	CEC_OAR_OA_Pos = 0x0
	// Bit mask of OA field.
	CEC_OAR_OA_Msk = 0xf

	// PRES: Rx Data Register
	// Position of PRESC field.
	CEC_PRES_PRESC_Pos = 0x0
	// Bit mask of PRESC field.
	CEC_PRES_PRESC_Msk = 0x3fff

	// ESR: CEC error status register
	// Position of BTE field.
	CEC_ESR_BTE_Pos = 0x0
	// Bit mask of BTE field.
	CEC_ESR_BTE_Msk = 0x1
	// Bit BTE.
	CEC_ESR_BTE = 0x1
	// Position of BPE field.
	CEC_ESR_BPE_Pos = 0x1
	// Bit mask of BPE field.
	CEC_ESR_BPE_Msk = 0x2
	// Bit BPE.
	CEC_ESR_BPE = 0x2
	// Position of RBTFE field.
	CEC_ESR_RBTFE_Pos = 0x2
	// Bit mask of RBTFE field.
	CEC_ESR_RBTFE_Msk = 0x4
	// Bit RBTFE.
	CEC_ESR_RBTFE = 0x4
	// Position of SBE field.
	CEC_ESR_SBE_Pos = 0x3
	// Bit mask of SBE field.
	CEC_ESR_SBE_Msk = 0x8
	// Bit SBE.
	CEC_ESR_SBE = 0x8
	// Position of ACKE field.
	CEC_ESR_ACKE_Pos = 0x4
	// Bit mask of ACKE field.
	CEC_ESR_ACKE_Msk = 0x10
	// Bit ACKE.
	CEC_ESR_ACKE = 0x10
	// Position of LINE field.
	CEC_ESR_LINE_Pos = 0x5
	// Bit mask of LINE field.
	CEC_ESR_LINE_Msk = 0x20
	// Bit LINE.
	CEC_ESR_LINE = 0x20
	// Position of TBTFE field.
	CEC_ESR_TBTFE_Pos = 0x6
	// Bit mask of TBTFE field.
	CEC_ESR_TBTFE_Msk = 0x40
	// Bit TBTFE.
	CEC_ESR_TBTFE = 0x40

	// CSR: CEC control and status register
	// Position of TSOM field.
	CEC_CSR_TSOM_Pos = 0x0
	// Bit mask of TSOM field.
	CEC_CSR_TSOM_Msk = 0x1
	// Bit TSOM.
	CEC_CSR_TSOM = 0x1
	// Position of TEOM field.
	CEC_CSR_TEOM_Pos = 0x1
	// Bit mask of TEOM field.
	CEC_CSR_TEOM_Msk = 0x2
	// Bit TEOM.
	CEC_CSR_TEOM = 0x2
	// Position of TERR field.
	CEC_CSR_TERR_Pos = 0x2
	// Bit mask of TERR field.
	CEC_CSR_TERR_Msk = 0x4
	// Bit TERR.
	CEC_CSR_TERR = 0x4
	// Position of TBTRF field.
	CEC_CSR_TBTRF_Pos = 0x3
	// Bit mask of TBTRF field.
	CEC_CSR_TBTRF_Msk = 0x8
	// Bit TBTRF.
	CEC_CSR_TBTRF = 0x8
	// Position of RSOM field.
	CEC_CSR_RSOM_Pos = 0x4
	// Bit mask of RSOM field.
	CEC_CSR_RSOM_Msk = 0x10
	// Bit RSOM.
	CEC_CSR_RSOM = 0x10
	// Position of REOM field.
	CEC_CSR_REOM_Pos = 0x5
	// Bit mask of REOM field.
	CEC_CSR_REOM_Msk = 0x20
	// Bit REOM.
	CEC_CSR_REOM = 0x20
	// Position of RERR field.
	CEC_CSR_RERR_Pos = 0x6
	// Bit mask of RERR field.
	CEC_CSR_RERR_Msk = 0x40
	// Bit RERR.
	CEC_CSR_RERR = 0x40
	// Position of RBTF field.
	CEC_CSR_RBTF_Pos = 0x7
	// Bit mask of RBTF field.
	CEC_CSR_RBTF_Msk = 0x80
	// Bit RBTF.
	CEC_CSR_RBTF = 0x80

	// TXD: CEC Tx data register
	// Position of TXD field.
	CEC_TXD_TXD_Pos = 0x0
	// Bit mask of TXD field.
	CEC_TXD_TXD_Msk = 0xff

	// RXD: CEC Rx data register
	// Position of RXD field.
	CEC_RXD_RXD_Pos = 0x0
	// Bit mask of RXD field.
	CEC_RXD_RXD_Msk = 0xff
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER0_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff

	// ISER1: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER1_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff

	// ICER0: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER0_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff

	// ICER1: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER1_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff

	// ISPR0: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff

	// ISPR1: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff

	// ICPR0: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff

	// ICPR1: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff

	// IABR0: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff

	// IABR1: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000

	// IPR2: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000

	// IPR3: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000

	// IPR4: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000

	// IPR5: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000

	// IPR6: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000

	// IPR7: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000

	// IPR8: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000

	// IPR9: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000

	// IPR10: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000

	// IPR11: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000

	// IPR12: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000

	// IPR13: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000

	// IPR14: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	// Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_MPU_TYPER_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk = 0xff00
	// Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Pos = 0x10
	// Bit mask of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk = 0xff0000

	// MPU_CTRL: MPU control register
	// Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_MPU_CTRL_PRIVDEFENA = 0x4

	// MPU_RNR: MPU region number register
	// Position of REGION field.
	MPU_MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff

	// MPU_RBAR: MPU region base address register
	// Position of REGION field.
	MPU_MPU_RBAR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf
	// Position of VALID field.
	MPU_MPU_RBAR_VALID_Pos = 0x4
	// Bit mask of VALID field.
	MPU_MPU_RBAR_VALID_Msk = 0x10
	// Bit VALID.
	MPU_MPU_RBAR_VALID = 0x10
	// Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Pos = 0x5
	// Bit mask of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk = 0xffffffe0

	// MPU_RASR: MPU region attribute and size register
	// Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_RASR_ENABLE = 0x1
	// Position of SIZE field.
	MPU_MPU_RASR_SIZE_Pos = 0x1
	// Bit mask of SIZE field.
	MPU_MPU_RASR_SIZE_Msk = 0x3e
	// Position of SRD field.
	MPU_MPU_RASR_SRD_Pos = 0x8
	// Bit mask of SRD field.
	MPU_MPU_RASR_SRD_Msk = 0xff00
	// Position of B field.
	MPU_MPU_RASR_B_Pos = 0x10
	// Bit mask of B field.
	MPU_MPU_RASR_B_Msk = 0x10000
	// Bit B.
	MPU_MPU_RASR_B = 0x10000
	// Position of C field.
	MPU_MPU_RASR_C_Pos = 0x11
	// Bit mask of C field.
	MPU_MPU_RASR_C_Msk = 0x20000
	// Bit C.
	MPU_MPU_RASR_C = 0x20000
	// Position of S field.
	MPU_MPU_RASR_S_Pos = 0x12
	// Bit mask of S field.
	MPU_MPU_RASR_S_Msk = 0x40000
	// Bit S.
	MPU_MPU_RASR_S = 0x40000
	// Position of TEX field.
	MPU_MPU_RASR_TEX_Pos = 0x13
	// Bit mask of TEX field.
	MPU_MPU_RASR_TEX_Msk = 0x380000
	// Position of AP field.
	MPU_MPU_RASR_AP_Pos = 0x18
	// Bit mask of AP field.
	MPU_MPU_RASR_AP_Msk = 0x7000000
	// Position of XN field.
	MPU_MPU_RASR_XN_Pos = 0x1c
	// Bit mask of XN field.
	MPU_MPU_RASR_XN_Msk = 0x10000000
	// Bit XN.
	MPU_MPU_RASR_XN = 0x10000000
)

// Bitfields for SCB_ACTRL: System control block ACTLR
const (
	// ACTRL: Auxiliary control register
	// Position of DISFOLD field.
	SCB_ACTRL_DISFOLD_Pos = 0x2
	// Bit mask of DISFOLD field.
	SCB_ACTRL_DISFOLD_Msk = 0x4
	// Bit DISFOLD.
	SCB_ACTRL_DISFOLD = 0x4
	// Position of FPEXCODIS field.
	SCB_ACTRL_FPEXCODIS_Pos = 0xa
	// Bit mask of FPEXCODIS field.
	SCB_ACTRL_FPEXCODIS_Msk = 0x400
	// Bit FPEXCODIS.
	SCB_ACTRL_FPEXCODIS = 0x400
	// Position of DISRAMODE field.
	SCB_ACTRL_DISRAMODE_Pos = 0xb
	// Bit mask of DISRAMODE field.
	SCB_ACTRL_DISRAMODE_Msk = 0x800
	// Bit DISRAMODE.
	SCB_ACTRL_DISRAMODE = 0x800
	// Position of DISITMATBFLUSH field.
	SCB_ACTRL_DISITMATBFLUSH_Pos = 0xc
	// Bit mask of DISITMATBFLUSH field.
	SCB_ACTRL_DISITMATBFLUSH_Msk = 0x1000
	// Bit DISITMATBFLUSH.
	SCB_ACTRL_DISITMATBFLUSH = 0x1000
)

// Bitfields for STK: SysTick timer
const (
	// CTRL: SysTick control and status register
	// Position of ENABLE field.
	STK_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	STK_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	STK_CTRL_ENABLE = 0x1
	// Position of TICKINT field.
	STK_CTRL_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	STK_CTRL_TICKINT_Msk = 0x2
	// Bit TICKINT.
	STK_CTRL_TICKINT = 0x2
	// Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	STK_CTRL_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	STK_CTRL_COUNTFLAG = 0x10000

	// LOAD_: SysTick reload value register
	// Position of RELOAD field.
	STK_LOAD__RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	STK_LOAD__RELOAD_Msk = 0xffffff

	// VAL: SysTick current value register
	// Position of CURRENT field.
	STK_VAL_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff

	// CALIB: SysTick calibration value register
	// Position of TENMS field.
	STK_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff
)
