/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.serialization;

import java.io.IOException;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.CacheElementSerialized;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElementSerialized;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class SerializationConversionUtil {
    private static final Log log = LogManager.getLog(SerializationConversionUtil.class);

    public static <K, V> ICacheElementSerialized<K, V> getSerializedCacheElement(ICacheElement<K, V> element, IElementSerializer elementSerializer) throws IOException {
        if (element == null) {
            return null;
        }
        byte[] serializedValue = null;
        if (element instanceof ICacheElementSerialized) {
            serializedValue = ((ICacheElementSerialized)element).getSerializedValue();
        } else if (elementSerializer != null) {
            try {
                serializedValue = elementSerializer.serialize(element.getVal());
                element.getElementAttributes().setSize(serializedValue.length);
            }
            catch (IOException e) {
                log.error("Problem serializing object.", e);
                throw e;
            }
        } else {
            throw new IOException("Could not serialize object. The ElementSerializer is null.");
        }
        CacheElementSerialized serialized = new CacheElementSerialized(element.getCacheName(), element.getKey(), serializedValue, element.getElementAttributes());
        return serialized;
    }

    public static <K, V> ICacheElement<K, V> getDeSerializedCacheElement(ICacheElementSerialized<K, V> serialized, IElementSerializer elementSerializer) throws IOException, ClassNotFoundException {
        Object deSerializedValue;
        block6: {
            if (serialized == null) {
                return null;
            }
            deSerializedValue = null;
            if (elementSerializer != null) {
                try {
                    try {
                        deSerializedValue = elementSerializer.deSerialize(serialized.getSerializedValue(), null);
                        break block6;
                    }
                    catch (ClassNotFoundException e) {
                        log.error("Problem de-serializing object.", e);
                        throw e;
                    }
                }
                catch (IOException e) {
                    log.error("Problem de-serializing object.", e);
                    throw e;
                }
            }
            throw new IOException("Could not de-serialize object. The ElementSerializer is null.");
        }
        CacheElement deSerialized = new CacheElement(serialized.getCacheName(), serialized.getKey(), deSerializedValue);
        deSerialized.setElementAttributes(serialized.getElementAttributes());
        return deSerialized;
    }
}

