/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.aix;

import java.util.HashMap;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public final class Ls {
    private Ls() {
    }

    public static Map<String, Pair<Integer, Integer>> queryDeviceMajorMinor() {
        HashMap<String, Pair<Integer, Integer>> majMinMap = new HashMap<String, Pair<Integer, Integer>>();
        for (String s2 : ExecutingCommand.runNative("ls -l /dev")) {
            int idx;
            if (s2.isEmpty() || s2.charAt(0) != 'b' || (idx = s2.lastIndexOf(32)) <= 0 || idx >= s2.length()) continue;
            String device = s2.substring(idx + 1);
            int major = ParseUtil.getNthIntValue(s2, 2);
            int minor = ParseUtil.getNthIntValue(s2, 3);
            majMinMap.put(device, new Pair<Integer, Integer>(major, minor));
        }
        return majMinMap;
    }
}

