/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

public class ByteListHelper {
    public static boolean eachCodePoint(ByteList bytelist, CodePoint each2) {
        int n;
        byte[] bytes2 = bytelist.unsafeBytes();
        int len = bytelist.getRealSize();
        Encoding encoding2 = bytelist.getEncoding();
        int begin2 = bytelist.begin();
        int end2 = begin2 + len;
        for (int i2 = 0; i2 < len; i2 += n) {
            int realIndex = begin2 + i2;
            n = StringSupport.encFastMBCLen(bytes2, realIndex, end2, encoding2);
            if (each2.call(i2, encoding2.mbcToCode(bytes2, realIndex, end2), encoding2)) continue;
            return false;
        }
        return true;
    }

    public static <T> T split(ByteList value2, ByteList pattern, Visit<ByteList, T> bodyVisitor, Visit<ByteList, T> headVisitor) {
        int patternIndex;
        if (headVisitor == null) {
            headVisitor = bodyVisitor;
        }
        Encoding enc = pattern.getEncoding();
        byte[] bytes2 = value2.getUnsafeBytes();
        int begin2 = value2.getBegin();
        int realSize = value2.getRealSize();
        int end2 = begin2 + realSize;
        int currentOffset = 0;
        int i2 = 0;
        Object current2 = null;
        while (currentOffset < realSize && (patternIndex = value2.indexOf(pattern, currentOffset)) >= 0) {
            int t = enc.rightAdjustCharHead(bytes2, currentOffset + begin2, patternIndex + begin2, end2) - begin2;
            if (t != patternIndex) {
                currentOffset = t;
            } else {
                current2 = bodyVisitor.call(i2, value2.makeShared(currentOffset, patternIndex - currentOffset), current2);
                if (current2 == null) {
                    return null;
                }
                currentOffset = patternIndex + pattern.getRealSize();
            }
            ++i2;
        }
        return headVisitor.call(i2, value2.makeShared(currentOffset, realSize - currentOffset), current2);
    }

    public static interface Visit<T, U> {
        public U call(int var1, T var2, U var3);
    }

    public static interface CodePoint {
        public boolean call(int var1, int var2, Encoding var3);
    }
}

