/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerException;

abstract class IntColumnFilter
extends ColumnFilter {
    IntColumnFilter() {
    }

    abstract int oneValueToAnother(int var1);

    @Override
    final Object apply(Object value, JDBCType asJDBCType) throws SQLServerException {
        if (value == null) {
            return value;
        }
        switch (asJDBCType) {
            case INTEGER: {
                return new Integer(this.oneValueToAnother((Integer)value));
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)this.oneValueToAnother(((Short)value).intValue()));
            }
            case BIGINT: {
                return new Long(this.oneValueToAnother(((Long)value).intValue()));
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                return Integer.toString(this.oneValueToAnother(Integer.parseInt((String)value)));
            }
        }
        DataTypes.throwConversionError("int", asJDBCType.toString());
        return value;
    }
}

