/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.algorithms.shortestpath;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gephi.algorithms.shortestpath.AbstractShortestPathAlgorithm;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;

public class DijkstraShortestPathAlgorithm
extends AbstractShortestPathAlgorithm {
    protected final Graph graph;
    protected final HashMap<Node, Edge> predecessors;

    public DijkstraShortestPathAlgorithm(Graph graph, Node sourceNode) {
        super(sourceNode);
        this.graph = graph;
        this.predecessors = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compute() {
        this.graph.readLock();
        try {
            HashSet<Node> unsettledNodes = new HashSet<Node>();
            HashSet<Node> settledNodes = new HashSet<Node>();
            for (Node node : this.graph.getNodes()) {
                this.distances.put(node, Double.POSITIVE_INFINITY);
            }
            this.distances.put(this.sourceNode, 0.0);
            unsettledNodes.add(this.sourceNode);
            while (!unsettledNodes.isEmpty()) {
                Double minDistance = Double.POSITIVE_INFINITY;
                Node minDistanceNode = null;
                for (Node k : unsettledNodes) {
                    Double dist = (Double)this.distances.get(k);
                    if (minDistanceNode == null) {
                        minDistanceNode = k;
                    }
                    if (dist.compareTo(minDistance) >= 0) continue;
                    minDistance = dist;
                    minDistanceNode = k;
                }
                unsettledNodes.remove(minDistanceNode);
                settledNodes.add(minDistanceNode);
                for (Edge edge : this.graph.getEdges(minDistanceNode)) {
                    Node neighbor = this.graph.getOpposite(minDistanceNode, edge);
                    if (settledNodes.contains(neighbor)) continue;
                    double dist = this.getShortestDistance(minDistanceNode) + this.edgeWeight(edge);
                    if (!(this.getShortestDistance(neighbor) > dist)) continue;
                    this.distances.put(neighbor, dist);
                    this.predecessors.put(neighbor, edge);
                    unsettledNodes.add(neighbor);
                    this.maxDistance = Math.max(this.maxDistance, dist);
                }
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    private double getShortestDistance(Node destination) {
        Double d = (Double)this.distances.get(destination);
        if (d == null) {
            return Double.POSITIVE_INFINITY;
        }
        return d;
    }

    @Override
    public Map<Node, Edge> getPredecessors() {
        return this.predecessors;
    }
}

