/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jsmpp.bean.Outbind;
import org.jsmpp.session.OutbindRequest;

class OutbindRequestReceiver {
    private final Lock lock = new ReentrantLock();
    private final Condition requestCondition = this.lock.newCondition();
    private OutbindRequest request;
    private boolean alreadyWaitForRequest;

    OutbindRequestReceiver() {
    }

    OutbindRequest waitForRequest(long timeout) throws IllegalStateException, TimeoutException {
        this.lock.lock();
        try {
            if (this.alreadyWaitForRequest) {
                throw new IllegalStateException("waitForRequest(long) method already invoked");
            }
            if (this.request == null) {
                try {
                    this.requestCondition.await(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("waitForRequest was interrupted");
                }
            }
            if (this.request != null) {
                OutbindRequest outbindRequest = this.request;
                return outbindRequest;
            }
            throw new TimeoutException("Waiting for outbind request take time too long");
        }
        finally {
            this.alreadyWaitForRequest = true;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAcceptOutbind(Outbind outbind) throws IllegalStateException {
        block4: {
            this.lock.lock();
            try {
                if (this.request == null) {
                    this.request = new OutbindRequest(outbind);
                    this.requestCondition.signal();
                    break block4;
                }
                throw new IllegalStateException("Already waiting for acceptance outbind");
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

