// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATmega16U2.atdf, see http://packs.download.atmel.com/

// +build avr,atmega16u2

// Device information for the ATmega16U2.
package avr

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATmega16U2"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin,Power-on Reset,Brown-out Reset,Watchdog Reset,and JTAG AVR Reset. See Datasheet.
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_INT1         = 2  // External Interrupt Request 1
	IRQ_INT2         = 3  // External Interrupt Request 2
	IRQ_INT3         = 4  // External Interrupt Request 3
	IRQ_INT4         = 5  // External Interrupt Request 4
	IRQ_INT5         = 6  // External Interrupt Request 5
	IRQ_INT6         = 7  // External Interrupt Request 6
	IRQ_INT7         = 8  // External Interrupt Request 7
	IRQ_PCINT0       = 9  // Pin Change Interrupt Request 0
	IRQ_PCINT1       = 10 // Pin Change Interrupt Request 1
	IRQ_USB_GEN      = 11 // USB General Interrupt Request
	IRQ_USB_COM      = 12 // USB Endpoint/Pipe Interrupt Communication Request
	IRQ_WDT          = 13 // Watchdog Time-out Interrupt
	IRQ_TIMER1_CAPT  = 14 // Timer/Counter2 Capture Event
	IRQ_TIMER1_COMPA = 15 // Timer/Counter2 Compare Match B
	IRQ_TIMER1_COMPB = 16 // Timer/Counter2 Compare Match B
	IRQ_TIMER1_COMPC = 17 // Timer/Counter2 Compare Match C
	IRQ_TIMER1_OVF   = 18 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMPA = 19 // Timer/Counter0 Compare Match A
	IRQ_TIMER0_COMPB = 20 // Timer/Counter0 Compare Match B
	IRQ_TIMER0_OVF   = 21 // Timer/Counter0 Overflow
	IRQ_SPI_STC      = 22 // SPI Serial Transfer Complete
	IRQ_USART1_RX    = 23 // USART1, Rx Complete
	IRQ_USART1_UDRE  = 24 // USART1 Data register Empty
	IRQ_USART1_TX    = 25 // USART1, Tx Complete
	IRQ_ANALOG_COMP  = 26 // Analog Comparator
	IRQ_EE_READY     = 27 // EEPROM Ready
	IRQ_SPM_READY    = 28 // Store Program Memory Read
	IRQ_max          = 28 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_RESET, "__vector_RESET")
	_ = interrupt.Register(IRQ_INT0, "__vector_INT0")
	_ = interrupt.Register(IRQ_INT1, "__vector_INT1")
	_ = interrupt.Register(IRQ_INT2, "__vector_INT2")
	_ = interrupt.Register(IRQ_INT3, "__vector_INT3")
	_ = interrupt.Register(IRQ_INT4, "__vector_INT4")
	_ = interrupt.Register(IRQ_INT5, "__vector_INT5")
	_ = interrupt.Register(IRQ_INT6, "__vector_INT6")
	_ = interrupt.Register(IRQ_INT7, "__vector_INT7")
	_ = interrupt.Register(IRQ_PCINT0, "__vector_PCINT0")
	_ = interrupt.Register(IRQ_PCINT1, "__vector_PCINT1")
	_ = interrupt.Register(IRQ_USB_GEN, "__vector_USB_GEN")
	_ = interrupt.Register(IRQ_USB_COM, "__vector_USB_COM")
	_ = interrupt.Register(IRQ_WDT, "__vector_WDT")
	_ = interrupt.Register(IRQ_TIMER1_CAPT, "__vector_TIMER1_CAPT")
	_ = interrupt.Register(IRQ_TIMER1_COMPA, "__vector_TIMER1_COMPA")
	_ = interrupt.Register(IRQ_TIMER1_COMPB, "__vector_TIMER1_COMPB")
	_ = interrupt.Register(IRQ_TIMER1_COMPC, "__vector_TIMER1_COMPC")
	_ = interrupt.Register(IRQ_TIMER1_OVF, "__vector_TIMER1_OVF")
	_ = interrupt.Register(IRQ_TIMER0_COMPA, "__vector_TIMER0_COMPA")
	_ = interrupt.Register(IRQ_TIMER0_COMPB, "__vector_TIMER0_COMPB")
	_ = interrupt.Register(IRQ_TIMER0_OVF, "__vector_TIMER0_OVF")
	_ = interrupt.Register(IRQ_SPI_STC, "__vector_SPI_STC")
	_ = interrupt.Register(IRQ_USART1_RX, "__vector_USART1_RX")
	_ = interrupt.Register(IRQ_USART1_UDRE, "__vector_USART1_UDRE")
	_ = interrupt.Register(IRQ_USART1_TX, "__vector_USART1_TX")
	_ = interrupt.Register(IRQ_ANALOG_COMP, "__vector_ANALOG_COMP")
	_ = interrupt.Register(IRQ_EE_READY, "__vector_EE_READY")
	_ = interrupt.Register(IRQ_SPM_READY, "__vector_SPM_READY")
)

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// I/O Port
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))

	// Serial Peripheral Interface
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))

	// Bootloader
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// Timer/Counter, 8-bit
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	GTCCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))

	// Timer/Counter, 16-bit
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	OCR1CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8c)))
	OCR1CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8d)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))

	// Phase Locked Loop
	PLLCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))

	// USB Device Registers
	UPOE    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfb)))
	UEINT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf4)))
	UEBCLX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf2)))
	UEDATX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))
	UEIENX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	UESTA1X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xef)))
	UESTA0X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xee)))
	UECFG1X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xed)))
	UECFG0X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xec)))
	UECONX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xeb)))
	UERST   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xea)))
	UENUM   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe9)))
	UEINTX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe8)))
	UDMFN   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe6)))
	UDFNUML = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe4)))
	UDFNUMH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe5)))
	UDADDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe3)))
	UDIEN   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe2)))
	UDINT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe1)))
	UDCON   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe0)))
	USBCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd8)))
	REGCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x63)))

	// CPU Registers
	SREG    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	OSCCAL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	CLKPR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SMCR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	EIND    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5c)))
	GPIOR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	PRR1    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x65)))
	PRR0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))
	CLKSTA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd2)))
	CLKSEL1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd1)))
	CLKSEL0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd0)))
	DWDR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EICRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6a)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))

	// USART
	UDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	UCSR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc8)))
	UCSR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc9)))
	UCSR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xca)))
	UCSR1D = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcb)))
	UBRR1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))
	UBRR1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))
	WDTCKD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x62)))

	// Analog Comparator
	ACSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))
	ACMUX = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7d)))
	DIDR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_BODLEVEL0 = 0x1 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL1 = 0x2 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL2 = 0x4 // Brown-out Detector trigger level
	EXTENDED_HWBE      = 0x8 // Hardware Boot Enable

	// HIGH
	HIGH_DWEN     = 0x80 // Debug Wire enable
	HIGH_RSTDISBL = 0x40 // Reset Disabled (Enable PC6 as i/o pin)
	HIGH_SPIEN    = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON    = 0x10 // Watchdog timer always on
	HIGH_EESAVE   = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0  = 0x2  // Select Boot Size
	HIGH_BOOTSZ1  = 0x4  // Select Boot Size
	HIGH_BOOTRST  = 0x1  // Boot Reset vector Enabled

	// LOW
	LOW_CKDIV8     = 0x80 // Divide clock by 8 internally
	LOW_CKOUT      = 0x40 // Clock output on PORTC7
	LOW_SUT_CKSEL0 = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1 = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2 = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3 = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4 = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5 = 0x20 // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0   = 0x1  // Memory Lock
	LOCKBIT_LB1   = 0x2  // Memory Lock
	LOCKBIT_BLB00 = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01 = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB10 = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11 = 0x20 // Boot Loader Protection Mode
)

// Bitfields for PORT: I/O Port
const (
	// PORTC: Port C Data Register
	PORTC_PORTC0 = 0x10 // Port C Data Register bits
	PORTC_PORTC1 = 0x20 // Port C Data Register bits
	PORTC_PORTC2 = 0x40 // Port C Data Register bits
	PORTC_PORTC3 = 0x80 // Port C Data Register bits
	PORTC_PORTC0 = 0x1  // Port C Data Register bits
	PORTC_PORTC1 = 0x2  // Port C Data Register bits
	PORTC_PORTC2 = 0x4  // Port C Data Register bits

	// DDRC: Port C Data Direction Register
	DDRC_DDC0 = 0x10 // Port C Data Direction Register bits
	DDRC_DDC1 = 0x20 // Port C Data Direction Register bits
	DDRC_DDC2 = 0x40 // Port C Data Direction Register bits
	DDRC_DDC3 = 0x80 // Port C Data Direction Register bits
	DDRC_DDC0 = 0x1  // Port C Data Direction Register bits
	DDRC_DDC1 = 0x2  // Port C Data Direction Register bits
	DDRC_DDC2 = 0x4  // Port C Data Direction Register bits

	// PINC: Port C Input Pins
	PINC_PINC0 = 0x10 // Port C Input Pins bits
	PINC_PINC1 = 0x20 // Port C Input Pins bits
	PINC_PINC2 = 0x40 // Port C Input Pins bits
	PINC_PINC3 = 0x80 // Port C Input Pins bits
	PINC_PINC0 = 0x1  // Port C Input Pins bits
	PINC_PINC1 = 0x2  // Port C Input Pins bits
	PINC_PINC2 = 0x4  // Port C Input Pins bits
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	SPCR_SPIE = 0x80 // SPI Interrupt Enable
	SPCR_SPE  = 0x40 // SPI Enable
	SPCR_DORD = 0x20 // Data Order
	SPCR_MSTR = 0x10 // Master/Slave Select
	SPCR_CPOL = 0x8  // Clock polarity
	SPCR_CPHA = 0x4  // Clock Phase
	SPCR_SPR0 = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1 = 0x2  // SPI Clock Rate Selects

	// SPSR: SPI Status Register
	SPSR_SPIF  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL  = 0x40 // Write Collision Flag
	SPSR_SPI2X = 0x1  // Double SPI Speed Bit

	// SPDR: SPI Data Register
	SPDR_SPDR0 = 0x1  // SPI Data bits
	SPDR_SPDR1 = 0x2  // SPI Data bits
	SPDR_SPDR2 = 0x4  // SPI Data bits
	SPDR_SPDR3 = 0x8  // SPI Data bits
	SPDR_SPDR4 = 0x10 // SPI Data bits
	SPDR_SPDR5 = 0x20 // SPI Data bits
	SPDR_SPDR6 = 0x40 // SPI Data bits
	SPDR_SPDR7 = 0x80 // SPI Data bits
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_SPMIE  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB  = 0x40 // Read While Write Section Busy
	SPMCSR_SIGRD  = 0x20 // Signature Row Read
	SPMCSR_RWWSRE = 0x10 // Read While Write section read enable
	SPMCSR_BLBSET = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT  = 0x4  // Page Write
	SPMCSR_PGERS  = 0x2  // Page Erase
	SPMCSR_SPMEN  = 0x1  // Store Program Memory Enable
)

// Bitfields for EEPROM: EEPROM
const (
	// EEARL: EEPROM Address Register Low Bytes

	// EEARH: EEPROM Address Register Low Bytes
	EEAR_EEAR0 = 0x1  // EEPROM Address bits
	EEAR_EEAR1 = 0x2  // EEPROM Address bits
	EEAR_EEAR2 = 0x4  // EEPROM Address bits
	EEAR_EEAR3 = 0x8  // EEPROM Address bits
	EEAR_EEAR4 = 0x10 // EEPROM Address bits
	EEAR_EEAR5 = 0x20 // EEPROM Address bits
	EEAR_EEAR6 = 0x40 // EEPROM Address bits
	EEAR_EEAR7 = 0x80 // EEPROM Address bits

	// EEDR: EEPROM Data Register
	EEDR_EEDR0 = 0x1  // EEPROM Data bits
	EEDR_EEDR1 = 0x2  // EEPROM Data bits
	EEDR_EEDR2 = 0x4  // EEPROM Data bits
	EEDR_EEDR3 = 0x8  // EEPROM Data bits
	EEDR_EEDR4 = 0x10 // EEPROM Data bits
	EEDR_EEDR5 = 0x20 // EEPROM Data bits
	EEDR_EEDR6 = 0x40 // EEPROM Data bits
	EEDR_EEDR7 = 0x80 // EEPROM Data bits

	// EECR: EEPROM Control Register
	EECR_EEPM0 = 0x10 // EEPROM Programming Mode Bits
	EECR_EEPM1 = 0x20 // EEPROM Programming Mode Bits
	EECR_EERIE = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EEMPE = 0x4  // EEPROM Master Write Enable
	EECR_EEPE  = 0x2  // EEPROM Write Enable
	EECR_EERE  = 0x1  // EEPROM Read Enable
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// OCR0B: Timer/Counter0 Output Compare Register
	OCR0B_OCR0B0 = 0x1  // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B1 = 0x2  // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B2 = 0x4  // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B3 = 0x8  // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B4 = 0x10 // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B5 = 0x20 // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B6 = 0x40 // Timer/Counter0 Output Compare B bits
	OCR0B_OCR0B7 = 0x80 // Timer/Counter0 Output Compare B bits

	// OCR0A: Timer/Counter0 Output Compare Register
	OCR0A_OCR0A0 = 0x1  // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A1 = 0x2  // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A2 = 0x4  // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A3 = 0x8  // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A4 = 0x10 // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A5 = 0x20 // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A6 = 0x40 // Timer/Counter0 Output Compare A bits
	OCR0A_OCR0A7 = 0x80 // Timer/Counter0 Output Compare A bits

	// TCNT0: Timer/Counter0
	TCNT0_TCNT00 = 0x1  // Timer/Counter0 bits
	TCNT0_TCNT01 = 0x2  // Timer/Counter0 bits
	TCNT0_TCNT02 = 0x4  // Timer/Counter0 bits
	TCNT0_TCNT03 = 0x8  // Timer/Counter0 bits
	TCNT0_TCNT04 = 0x10 // Timer/Counter0 bits
	TCNT0_TCNT05 = 0x20 // Timer/Counter0 bits
	TCNT0_TCNT06 = 0x40 // Timer/Counter0 bits
	TCNT0_TCNT07 = 0x80 // Timer/Counter0 bits

	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A = 0x80 // Force Output Compare A
	TCCR0B_FOC0B = 0x40 // Force Output Compare B
	TCCR0B_WGM02 = 0x8
	TCCR0B_CS00  = 0x1 // Clock Select
	TCCR0B_CS01  = 0x2 // Clock Select
	TCCR0B_CS02  = 0x4 // Clock Select

	// TCCR0A: Timer/Counter  Control Register A
	TCCR0A_COM0A0 = 0x40 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A1 = 0x80 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0B0 = 0x10 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B1 = 0x20 // Compare Output Mode, Fast PWm
	TCCR0A_WGM00  = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01  = 0x2  // Waveform Generation Mode

	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0B = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0B = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0A = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_TOV0  = 0x1 // Timer/Counter0 Overflow Flag

	// GTCCR: General Timer/Counter Control Register
	GTCCR_TSM     = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_PSRSYNC = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0 = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1 = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0 = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1 = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1C0 = 0x4  // Compare Output Mode 1C, bits
	TCCR1A_COM1C1 = 0x8  // Compare Output Mode 1C, bits
	TCCR1A_WGM10  = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11  = 0x2  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1 = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1 = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10 = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11 = 0x10 // Waveform Generation Mode
	TCCR1B_CS10  = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11  = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12  = 0x4  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter 1 Control Register C
	TCCR1C_FOC1A = 0x80 // Force Output Compare 1A
	TCCR1C_FOC1B = 0x40 // Force Output Compare 1B
	TCCR1C_FOC1C = 0x20 // Force Output Compare 1C

	// TCNT1L: Timer/Counter1 Bytes

	// TCNT1H: Timer/Counter1 Bytes
	TCNT1_TCNT10 = 0x1  // Timer/Counter1 bits
	TCNT1_TCNT11 = 0x2  // Timer/Counter1 bits
	TCNT1_TCNT12 = 0x4  // Timer/Counter1 bits
	TCNT1_TCNT13 = 0x8  // Timer/Counter1 bits
	TCNT1_TCNT14 = 0x10 // Timer/Counter1 bits
	TCNT1_TCNT15 = 0x20 // Timer/Counter1 bits
	TCNT1_TCNT16 = 0x40 // Timer/Counter1 bits
	TCNT1_TCNT17 = 0x80 // Timer/Counter1 bits

	// OCR1AL: Timer/Counter1 Output Compare Register A Bytes

	// OCR1AH: Timer/Counter1 Output Compare Register A Bytes
	OCR1A_OCR1A0 = 0x1  // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A1 = 0x2  // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A2 = 0x4  // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A3 = 0x8  // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A4 = 0x10 // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A5 = 0x20 // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A6 = 0x40 // Timer/Counter1 Output Compare A bits
	OCR1A_OCR1A7 = 0x80 // Timer/Counter1 Output Compare A bits

	// OCR1BL: Timer/Counter1 Output Compare Register B Bytes

	// OCR1BH: Timer/Counter1 Output Compare Register B Bytes
	OCR1B_OCR1B0 = 0x1  // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B1 = 0x2  // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B2 = 0x4  // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B3 = 0x8  // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B4 = 0x10 // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B5 = 0x20 // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B6 = 0x40 // Timer/Counter1 Output Compare B bits
	OCR1B_OCR1B7 = 0x80 // Timer/Counter1 Output Compare B bits

	// OCR1CL: Timer/Counter1 Output Compare Register C Bytes

	// OCR1CH: Timer/Counter1 Output Compare Register C Bytes
	OCR1C_OCR1C0 = 0x1  // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C1 = 0x2  // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C2 = 0x4  // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C3 = 0x8  // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C4 = 0x10 // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C5 = 0x20 // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C6 = 0x40 // Timer/Counter1 Output Compare C bits
	OCR1C_OCR1C7 = 0x80 // Timer/Counter1 Output Compare C bits

	// ICR1L: Timer/Counter1 Input Capture Register Bytes

	// ICR1H: Timer/Counter1 Input Capture Register Bytes
	ICR1_ICR10 = 0x1  // Timer/Counter1 Input Capture bits
	ICR1_ICR11 = 0x2  // Timer/Counter1 Input Capture bits
	ICR1_ICR12 = 0x4  // Timer/Counter1 Input Capture bits
	ICR1_ICR13 = 0x8  // Timer/Counter1 Input Capture bits
	ICR1_ICR14 = 0x10 // Timer/Counter1 Input Capture bits
	ICR1_ICR15 = 0x20 // Timer/Counter1 Input Capture bits
	ICR1_ICR16 = 0x40 // Timer/Counter1 Input Capture bits
	ICR1_ICR17 = 0x80 // Timer/Counter1 Input Capture bits

	// TIMSK1: Timer/Counter1 Interrupt Mask Register
	TIMSK1_ICIE1  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1C = 0x8  // Timer/Counter1 Output Compare C Match Interrupt Enable
	TIMSK1_OCIE1B = 0x4  // Timer/Counter1 Output Compare B Match Interrupt Enable
	TIMSK1_OCIE1A = 0x2  // Timer/Counter1 Output Compare A Match Interrupt Enable
	TIMSK1_TOIE1  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter1 Interrupt Flag register
	TIFR1_ICF1  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1C = 0x8  // Output Compare Flag 1C
	TIFR1_OCF1B = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1  = 0x1  // Timer/Counter1 Overflow Flag
)

// Bitfields for PLL: Phase Locked Loop
const (
	// PLLCSR: PLL Status and Control register
	PLLCSR_PLLP0 = 0x4  // PLL prescaler Bits
	PLLCSR_PLLP1 = 0x8  // PLL prescaler Bits
	PLLCSR_PLLP2 = 0x10 // PLL prescaler Bits
	PLLCSR_PLLE  = 0x2  // PLL Enable Bit
	PLLCSR_PLOCK = 0x1  // PLL Lock Status Bit
)

// Bitfields for USB_DEVICE: USB Device Registers
const (
	// UPOE: USB Software Output Enable register
	UPOE_UPWE0  = 0x40 // USB Buffers Direct Drive enable configuration
	UPOE_UPWE1  = 0x80 // USB Buffers Direct Drive enable configuration
	UPOE_UPDRV0 = 0x10 // USB direct drive values
	UPOE_UPDRV1 = 0x20 // USB direct drive values
	UPOE_DPI    = 0x2  // D+ Input value
	UPOE_DMI    = 0x1  // D- Input value

	// UEINT: USB Endpoint Number Interrupt Register
	UEINT_EPINT0 = 0x1  // Byte Count bits
	UEINT_EPINT1 = 0x2  // Byte Count bits
	UEINT_EPINT2 = 0x4  // Byte Count bits
	UEINT_EPINT3 = 0x8  // Byte Count bits
	UEINT_EPINT4 = 0x10 // Byte Count bits

	// UEBCLX: USB Endpoint Byte Count Register
	UEBCLX_BYCT0 = 0x1  // Byte Count bits
	UEBCLX_BYCT1 = 0x2  // Byte Count bits
	UEBCLX_BYCT2 = 0x4  // Byte Count bits
	UEBCLX_BYCT3 = 0x8  // Byte Count bits
	UEBCLX_BYCT4 = 0x10 // Byte Count bits
	UEBCLX_BYCT5 = 0x20 // Byte Count bits
	UEBCLX_BYCT6 = 0x40 // Byte Count bits
	UEBCLX_BYCT7 = 0x80 // Byte Count bits

	// UEDATX: USB Data Endpoint
	UEDATX_DAT0 = 0x1  // Data bits
	UEDATX_DAT1 = 0x2  // Data bits
	UEDATX_DAT2 = 0x4  // Data bits
	UEDATX_DAT3 = 0x8  // Data bits
	UEDATX_DAT4 = 0x10 // Data bits
	UEDATX_DAT5 = 0x20 // Data bits
	UEDATX_DAT6 = 0x40 // Data bits
	UEDATX_DAT7 = 0x80 // Data bits

	// UEIENX: USB Endpoint Interrupt Enable Register
	UEIENX_FLERRE   = 0x80 // Flow Error Interrupt Enable Flag
	UEIENX_NAKINE   = 0x40 // NAK IN Interrupt Enable Bit
	UEIENX_NAKOUTE  = 0x10 // NAK OUT Interrupt Enable Bit
	UEIENX_RXSTPE   = 0x8  // Received SETUP Interrupt Enable Flag
	UEIENX_RXOUTE   = 0x4  // Received OUT Data Interrupt Enable Flag
	UEIENX_STALLEDE = 0x2  // Stalled Interrupt Enable Flag
	UEIENX_TXINE    = 0x1  // Transmitter Ready Interrupt Enable Flag

	// UESTA1X: USB Endpoint Status 1 Register
	UESTA1X_CTRLDIR = 0x4 // Control Direction
	UESTA1X_CURRBK0 = 0x1 // Current Bank
	UESTA1X_CURRBK1 = 0x2 // Current Bank

	// UESTA0X: USB Endpoint Status 0 Register
	UESTA0X_CFGOK    = 0x80 // Configuration Status Flag
	UESTA0X_OVERFI   = 0x40 // Overflow Error Interrupt Flag
	UESTA0X_UNDERFI  = 0x20 // Underflow Error Interrupt Flag
	UESTA0X_DTSEQ0   = 0x4  // Data Toggle Sequencing Flag
	UESTA0X_DTSEQ1   = 0x8  // Data Toggle Sequencing Flag
	UESTA0X_NBUSYBK0 = 0x1  // Busy Bank Flag
	UESTA0X_NBUSYBK1 = 0x2  // Busy Bank Flag

	// UECFG1X: USB Endpoint Configuration 1 Register
	UECFG1X_EPSIZE0 = 0x10 // Endpoint Size Bits
	UECFG1X_EPSIZE1 = 0x20 // Endpoint Size Bits
	UECFG1X_EPSIZE2 = 0x40 // Endpoint Size Bits
	UECFG1X_EPBK0   = 0x4  // Endpoint Bank Bits
	UECFG1X_EPBK1   = 0x8  // Endpoint Bank Bits
	UECFG1X_ALLOC   = 0x2  // Endpoint Allocation Bit

	// UECFG0X: USB Endpoint Configuration 0 Register
	UECFG0X_EPTYPE0 = 0x40 // Endpoint Type Bits
	UECFG0X_EPTYPE1 = 0x80 // Endpoint Type Bits
	UECFG0X_EPDIR   = 0x1  // Endpoint Direction Bit

	// UECONX: USB Endpoint Control Register
	UECONX_STALLRQ  = 0x20 // STALL Request Handshake Bit
	UECONX_STALLRQC = 0x10 // STALL Request Clear Handshake Bit
	UECONX_RSTDT    = 0x8  // Reset Data Toggle Bit
	UECONX_EPEN     = 0x1  // Endpoint Enable Bit

	// UERST: USB Endpoint Reset Register
	UERST_EPRST0 = 0x1  // Endpoint FIFO Reset Bits
	UERST_EPRST1 = 0x2  // Endpoint FIFO Reset Bits
	UERST_EPRST2 = 0x4  // Endpoint FIFO Reset Bits
	UERST_EPRST3 = 0x8  // Endpoint FIFO Reset Bits
	UERST_EPRST4 = 0x10 // Endpoint FIFO Reset Bits

	// UENUM: USB Endpoint Number
	UENUM_EPNUM0 = 0x1 // Endpoint Number bits
	UENUM_EPNUM1 = 0x2 // Endpoint Number bits
	UENUM_EPNUM2 = 0x4 // Endpoint Number bits

	// UEINTX: USB Endpoint Interrupt Register
	UEINTX_FIFOCON  = 0x80 // FIFO Control Bit
	UEINTX_NAKINI   = 0x40 // NAK IN Received Interrupt Flag
	UEINTX_RWAL     = 0x20 // Read/Write Allowed Flag
	UEINTX_NAKOUTI  = 0x10 // NAK OUT Received Interrupt Flag
	UEINTX_RXSTPI   = 0x8  // Received SETUP Interrupt Flag
	UEINTX_RXOUTI   = 0x4  // Received OUT Data Interrupt Flag
	UEINTX_STALLEDI = 0x2  // STALLEDI Interrupt Flag
	UEINTX_TXINI    = 0x1  // Transmitter Ready Interrupt Flag

	// UDMFN: USB Device Micro Frame Number
	UDMFN_FNCERR = 0x10 // Frame Number CRC Error Flag

	// UDFNUML: USB Device Frame Number High Register

	// UDFNUMH: USB Device Frame Number High Register
	UDFNUM_FNUM0 = 0x1  // Frame Number Upper Flag
	UDFNUM_FNUM1 = 0x2  // Frame Number Upper Flag
	UDFNUM_FNUM2 = 0x4  // Frame Number Upper Flag
	UDFNUM_FNUM3 = 0x8  // Frame Number Upper Flag
	UDFNUM_FNUM4 = 0x10 // Frame Number Upper Flag
	UDFNUM_FNUM5 = 0x20 // Frame Number Upper Flag
	UDFNUM_FNUM6 = 0x40 // Frame Number Upper Flag
	UDFNUM_FNUM7 = 0x80 // Frame Number Upper Flag

	// UDADDR: USB Device Address Register
	UDADDR_ADDEN = 0x80 // Address Enable Bit
	UDADDR_UADD0 = 0x1  // USB Address Bits
	UDADDR_UADD1 = 0x2  // USB Address Bits
	UDADDR_UADD2 = 0x4  // USB Address Bits
	UDADDR_UADD3 = 0x8  // USB Address Bits
	UDADDR_UADD4 = 0x10 // USB Address Bits
	UDADDR_UADD5 = 0x20 // USB Address Bits
	UDADDR_UADD6 = 0x40 // USB Address Bits

	// UDIEN: USB Device Interrupt Enable Register
	UDIEN_UPRSME  = 0x40 // Upstream Resume Interrupt Enable Bit
	UDIEN_EORSME  = 0x20 // End Of Resume Interrupt Enable Bit
	UDIEN_WAKEUPE = 0x10 // Wake-up CPU Interrupt Enable Bit
	UDIEN_EORSTE  = 0x8  // End Of Reset Interrupt Enable Bit
	UDIEN_SOFE    = 0x4  // Start Of Frame Interrupt Enable Bit
	UDIEN_SUSPE   = 0x1  // Suspend Interrupt Enable Bit

	// UDINT: USB Device Interrupt Register
	UDINT_UPRSMI  = 0x40 // Upstream Resume Interrupt Flag
	UDINT_EORSMI  = 0x20 // End Of Resume Interrupt Flag
	UDINT_WAKEUPI = 0x10 // Wake-up CPU Interrupt Flag
	UDINT_EORSTI  = 0x8  // End Of Reset Interrupt Flag
	UDINT_SOFI    = 0x4  // Start Of Frame Interrupt Flag
	UDINT_SUSPI   = 0x1  // Suspend Interrupt Flag

	// UDCON: USB Device Control Registers
	UDCON_RSTCPU = 0x4 // USB Reset CPU Bit
	UDCON_RMWKUP = 0x2 // Remote Wake-up Bit
	UDCON_DETACH = 0x1 // Detach Bit

	// USBCON: USB General Control Register
	USBCON_USBE   = 0x80 // USB macro Enable Bit
	USBCON_FRZCLK = 0x20 // Freeze USB Clock Bit

	// REGCR: Regulator Control Register
	REGCR_REGDIS = 0x1 // Regulator Disable
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I = 0x80 // Global Interrupt Enable
	SREG_T = 0x40 // Bit Copy Storage
	SREG_H = 0x20 // Half Carry Flag
	SREG_S = 0x10 // Sign Bit
	SREG_V = 0x8  // Two's Complement Overflow Flag
	SREG_N = 0x4  // Negative Flag
	SREG_Z = 0x2  // Zero Flag
	SREG_C = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_PUD   = 0x10 // Pull-up disable
	MCUCR_IVSEL = 0x2  // Interrupt Vector Select
	MCUCR_IVCE  = 0x1  // Interrupt Vector Change Enable

	// MCUSR: MCU Status Register
	MCUSR_USBRF = 0x20 // USB reset flag
	MCUSR_WDRF  = 0x8  // Watchdog Reset Flag
	MCUSR_BORF  = 0x4  // Brown-out Reset Flag
	MCUSR_EXTRF = 0x2  // External Reset Flag
	MCUSR_PORF  = 0x1  // Power-on reset flag

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0 = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1 = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2 = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3 = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4 = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5 = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6 = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7 = 0x80 // Oscillator Calibration

	// CLKPR
	CLKPR_CLKPCE = 0x80
	CLKPR_CLKPS0 = 0x1
	CLKPR_CLKPS1 = 0x2
	CLKPR_CLKPS2 = 0x4
	CLKPR_CLKPS3 = 0x8

	// SMCR: Sleep Mode Control Register
	SMCR_SM0 = 0x2 // Sleep Mode Select bits
	SMCR_SM1 = 0x4 // Sleep Mode Select bits
	SMCR_SM2 = 0x8 // Sleep Mode Select bits
	SMCR_SE  = 0x1 // Sleep Enable

	// GPIOR2: General Purpose IO Register 2
	GPIOR2_GPIOR0 = 0x1  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR1 = 0x2  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR2 = 0x4  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR3 = 0x8  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR4 = 0x10 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR5 = 0x20 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR6 = 0x40 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR7 = 0x80 // General Purpose IO Register 2 bis

	// GPIOR1: General Purpose IO Register 1
	GPIOR1_GPIOR0 = 0x1  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR1 = 0x2  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR2 = 0x4  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR3 = 0x8  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR4 = 0x10 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR5 = 0x20 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR6 = 0x40 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR7 = 0x80 // General Purpose IO Register 1 bis

	// GPIOR0: General Purpose IO Register 0
	GPIOR0_GPIOR07 = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR06 = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR05 = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR04 = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR03 = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR02 = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR01 = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR00 = 0x1  // General Purpose IO Register 0 bit 0

	// PRR1: Power Reduction Register1
	PRR1_PRUSB    = 0x80 // Power Reduction USB
	PRR1_PRUSART1 = 0x1  // Power Reduction USART1

	// PRR0: Power Reduction Register0
	PRR0_PRTIM0 = 0x20 // Power Reduction Timer/Counter0
	PRR0_PRTIM1 = 0x8  // Power Reduction Timer/Counter1
	PRR0_PRSPI  = 0x4  // Power Reduction Serial Peripheral Interface

	// CLKSTA
	CLKSTA_RCON  = 0x2
	CLKSTA_EXTON = 0x1

	// CLKSEL1
	CLKSEL1_RCCKSEL0 = 0x10
	CLKSEL1_RCCKSEL1 = 0x20
	CLKSEL1_RCCKSEL2 = 0x40
	CLKSEL1_RCCKSEL3 = 0x80
	CLKSEL1_EXCKSEL0 = 0x1
	CLKSEL1_EXCKSEL1 = 0x2
	CLKSEL1_EXCKSEL2 = 0x4
	CLKSEL1_EXCKSEL3 = 0x8

	// CLKSEL0
	CLKSEL0_RCSUT0 = 0x40
	CLKSEL0_RCSUT1 = 0x80
	CLKSEL0_EXSUT0 = 0x10
	CLKSEL0_EXSUT1 = 0x20
	CLKSEL0_RCE    = 0x8
	CLKSEL0_EXTE   = 0x4
	CLKSEL0_CLKS   = 0x1
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register A
	EICRA_ISC30 = 0x40 // External Interrupt Sense Control Bit
	EICRA_ISC31 = 0x80 // External Interrupt Sense Control Bit
	EICRA_ISC20 = 0x10 // External Interrupt Sense Control Bit
	EICRA_ISC21 = 0x20 // External Interrupt Sense Control Bit
	EICRA_ISC10 = 0x4  // External Interrupt Sense Control Bit
	EICRA_ISC11 = 0x8  // External Interrupt Sense Control Bit
	EICRA_ISC00 = 0x1  // External Interrupt Sense Control Bit
	EICRA_ISC01 = 0x2  // External Interrupt Sense Control Bit

	// EICRB: External Interrupt Control Register B
	EICRB_ISC70 = 0x40 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC71 = 0x80 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC60 = 0x10 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC61 = 0x20 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC50 = 0x4  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC51 = 0x8  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC40 = 0x1  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC41 = 0x2  // External Interrupt 7-4 Sense Control Bit

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0 = 0x1  // External Interrupt Request 7 Enable
	EIMSK_INT1 = 0x2  // External Interrupt Request 7 Enable
	EIMSK_INT2 = 0x4  // External Interrupt Request 7 Enable
	EIMSK_INT3 = 0x8  // External Interrupt Request 7 Enable
	EIMSK_INT4 = 0x10 // External Interrupt Request 7 Enable
	EIMSK_INT5 = 0x20 // External Interrupt Request 7 Enable
	EIMSK_INT6 = 0x40 // External Interrupt Request 7 Enable
	EIMSK_INT7 = 0x80 // External Interrupt Request 7 Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0 = 0x1  // External Interrupt Flags
	EIFR_INTF1 = 0x2  // External Interrupt Flags
	EIFR_INTF2 = 0x4  // External Interrupt Flags
	EIFR_INTF3 = 0x8  // External Interrupt Flags
	EIFR_INTF4 = 0x10 // External Interrupt Flags
	EIFR_INTF5 = 0x20 // External Interrupt Flags
	EIFR_INTF6 = 0x40 // External Interrupt Flags
	EIFR_INTF7 = 0x80 // External Interrupt Flags

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0 = 0x1  // Pin Change Enable Masks
	PCMSK0_PCINT1 = 0x2  // Pin Change Enable Masks
	PCMSK0_PCINT2 = 0x4  // Pin Change Enable Masks
	PCMSK0_PCINT3 = 0x8  // Pin Change Enable Masks
	PCMSK0_PCINT4 = 0x10 // Pin Change Enable Masks
	PCMSK0_PCINT5 = 0x20 // Pin Change Enable Masks
	PCMSK0_PCINT6 = 0x40 // Pin Change Enable Masks
	PCMSK0_PCINT7 = 0x80 // Pin Change Enable Masks

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0 = 0x1
	PCMSK1_PCINT1 = 0x2
	PCMSK1_PCINT2 = 0x4
	PCMSK1_PCINT3 = 0x8
	PCMSK1_PCINT4 = 0x10

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0 = 0x1 // Pin Change Interrupt Flags
	PCIFR_PCIF1 = 0x2 // Pin Change Interrupt Flags

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0 = 0x1 // Pin Change Interrupt Enables
	PCICR_PCIE1 = 0x2 // Pin Change Interrupt Enables
)

// Bitfields for USART: USART
const (
	// UDR1: USART I/O Data Register
	UDR1_UDR10 = 0x1  // USART I/O Data bits
	UDR1_UDR11 = 0x2  // USART I/O Data bits
	UDR1_UDR12 = 0x4  // USART I/O Data bits
	UDR1_UDR13 = 0x8  // USART I/O Data bits
	UDR1_UDR14 = 0x10 // USART I/O Data bits
	UDR1_UDR15 = 0x20 // USART I/O Data bits
	UDR1_UDR16 = 0x40 // USART I/O Data bits
	UDR1_UDR17 = 0x80 // USART I/O Data bits

	// UCSR1A: USART Control and Status Register A
	UCSR1A_RXC1  = 0x80 // USART Receive Complete
	UCSR1A_TXC1  = 0x40 // USART Transmitt Complete
	UCSR1A_UDRE1 = 0x20 // USART Data Register Empty
	UCSR1A_FE1   = 0x10 // Framing Error
	UCSR1A_DOR1  = 0x8  // Data overRun
	UCSR1A_UPE1  = 0x4  // Parity Error
	UCSR1A_U2X1  = 0x2  // Double the USART transmission speed
	UCSR1A_MPCM1 = 0x1  // Multi-processor Communication Mode

	// UCSR1B: USART Control and Status Register B
	UCSR1B_RXCIE1 = 0x80 // RX Complete Interrupt Enable
	UCSR1B_TXCIE1 = 0x40 // TX Complete Interrupt Enable
	UCSR1B_UDRIE1 = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_RXEN1  = 0x10 // Receiver Enable
	UCSR1B_TXEN1  = 0x8  // Transmitter Enable
	UCSR1B_UCSZ12 = 0x4  // Character Size
	UCSR1B_RXB81  = 0x2  // Receive Data Bit 8
	UCSR1B_TXB81  = 0x1  // Transmit Data Bit 8

	// UCSR1C: USART Control and Status Register C
	UCSR1C_UMSEL10 = 0x40 // USART Mode Select
	UCSR1C_UMSEL11 = 0x80 // USART Mode Select
	UCSR1C_UPM10   = 0x10 // Parity Mode Bits
	UCSR1C_UPM11   = 0x20 // Parity Mode Bits
	UCSR1C_USBS1   = 0x8  // Stop Bit Select
	UCSR1C_UCSZ10  = 0x2  // Character Size
	UCSR1C_UCSZ11  = 0x4  // Character Size
	UCSR1C_UCPOL1  = 0x1  // Clock Polarity

	// UCSR1D: USART Control and Status Register D
	UCSR1D_CTSEN = 0x2 // CTS Enable
	UCSR1D_RTSEN = 0x1 // RTS Enable

	// UBRR1L: USART Baud Rate Register Bytes

	// UBRR1H: USART Baud Rate Register Bytes
	UBRR1_UBRR10 = 0x1  // USART Baud Rate bits
	UBRR1_UBRR11 = 0x2  // USART Baud Rate bits
	UBRR1_UBRR12 = 0x4  // USART Baud Rate bits
	UBRR1_UBRR13 = 0x8  // USART Baud Rate bits
	UBRR1_UBRR14 = 0x10 // USART Baud Rate bits
	UBRR1_UBRR15 = 0x20 // USART Baud Rate bits
	UBRR1_UBRR16 = 0x40 // USART Baud Rate bits
	UBRR1_UBRR17 = 0x80 // USART Baud Rate bits
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control Register
	WDTCSR_WDIF = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIE = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDP0 = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1 = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2 = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3 = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDCE = 0x10 // Watchdog Change Enable
	WDTCSR_WDE  = 0x8  // Watch Dog Enable

	// WDTCKD: Watchdog Timer Clock Divider
	WDTCKD_WDEWIF = 0x8 // Watchdog Early Warning Interrupt Flag
	WDTCKD_WDEWIE = 0x4 // Watchdog Early Warning Interrupt Enable
	WDTCKD_WCLKD0 = 0x1 // Watchdog Timer Clock Dividers
	WDTCKD_WCLKD1 = 0x2 // Watchdog Timer Clock Dividers
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD   = 0x80 // Analog Comparator Disable
	ACSR_ACBG  = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO   = 0x20 // Analog Compare Output
	ACSR_ACI   = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE  = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC  = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0 = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1 = 0x2  // Analog Comparator Interrupt Mode Select bits

	// ACMUX: Analog Comparator Input Multiplexer
	ACMUX_CMUX0 = 0x1 // Analog Comparator Selection Bits
	ACMUX_CMUX1 = 0x2 // Analog Comparator Selection Bits
	ACMUX_CMUX2 = 0x4 // Analog Comparator Selection Bits

	// DIDR1
	DIDR1_AIN7D = 0x80 // AIN7 Digital Input Disable
	DIDR1_AIN6D = 0x40 // AIN6 Digital Input Disable
	DIDR1_AIN5D = 0x20 // AIN5 Digital Input Disable
	DIDR1_AIN4D = 0x10 // AIN4 Digital Input Disable
	DIDR1_AIN3D = 0x8  // AIN3 Digital Input Disable
	DIDR1_AIN2D = 0x4  // AIN2 Digital Input Disable
	DIDR1_AIN1D = 0x2  // AIN1 Digital Input Disable
	DIDR1_AIN0D = 0x1  // AIN0 Digital Input Disable
)
