// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC18xx.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

// +build nxp,lpc18xx

// Register cmsis file for LPC18xx parts
//

package nxp

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "LPC18xx"
)

// Interrupt numbers.
const (
	// Digital-to-Analog Converter (DAC)
	IRQ_DAC = 0

	// General Purpose DMA (GPDMA)
	IRQ_DMA = 2

	// EEPROM
	IRQ_FLASH = 4

	// Ethernet
	IRQ_ETHERNET = 5

	// SD/MMC
	IRQ_SDIO = 6

	// LCD controller
	IRQ_LCD = 7

	// USB0 Host/Device/OTG controller
	IRQ_USB0 = 8

	// USB1 Host/Device controller
	IRQ_USB1 = 9

	// State Configurable Timer (SCT) with dither engine
	IRQ_SCT = 10

	// Repetitive Interrupt Timer (RIT)
	IRQ_RITIMER = 11

	// Timer0/1/2/3
	IRQ_TIMER0 = 12

	IRQ_TIMER1 = 13

	IRQ_TIMER2 = 14

	IRQ_TIMER3 = 15

	// Motor Control PWM (MOTOCONPWM)
	IRQ_MCPWM = 16

	// 10-bit Analog-to-Digital Converter (ADC)
	IRQ_ADC0 = 17

	// I2C-bus interface
	IRQ_I2C0 = 18

	IRQ_I2C1 = 19

	IRQ_ADC1 = 21

	// SSP0/1
	IRQ_SSP0 = 22

	IRQ_SSP1 = 23

	// USART0_2_3
	IRQ_USART0 = 24

	// UART1
	IRQ_UART1 = 25

	IRQ_USART2 = 26

	IRQ_USART3 = 27

	// I2S interface
	IRQ_I2S0 = 28

	IRQ_I2S1 = 29

	// SPI Flash Interface (SPIFI)
	IRQ_SPIFI = 30

	// GPIO pin interrupt
	IRQ_PIN_INT0 = 32

	// GPIO pin interrupt
	IRQ_PIN_INT1 = 33

	// GPIO pin interrupt
	IRQ_PIN_INT2 = 34

	// GPIO pin interrupt
	IRQ_PIN_INT3 = 35

	// GPIO pin interrupt
	IRQ_PIN_INT4 = 36

	// GPIO pin interrupt
	IRQ_PIN_INT5 = 37

	// GPIO pin interrupt
	IRQ_PIN_INT6 = 38

	// GPIO pin interrupt
	IRQ_PIN_INT7 = 39

	// GPIO group interrupt 0
	IRQ_GINT0 = 40

	IRQ_GINT1 = 41

	// Event router
	IRQ_EVENTROUTER = 42

	// C_CAN
	IRQ_C_CAN1 = 43

	// Alarm timer
	IRQ_ATIMER = 46

	// Real-Time Clock (RTC) and event recorder
	IRQ_RTC = 47

	// Windowed Watchdog timer (WWDT)
	IRQ_WWDT = 49

	IRQ_C_CAN0 = 51

	// Quadrature Encoder Interface (QEI)
	IRQ_QEI = 52

	// Highest interrupt number on this device.
	IRQ_max = 52
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_DAC, "DAC_IRQHandler")
	_ = interrupt.Register(IRQ_DMA, "DMA_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_ETHERNET, "ETHERNET_IRQHandler")
	_ = interrupt.Register(IRQ_SDIO, "SDIO_IRQHandler")
	_ = interrupt.Register(IRQ_LCD, "LCD_IRQHandler")
	_ = interrupt.Register(IRQ_USB0, "USB0_IRQHandler")
	_ = interrupt.Register(IRQ_USB1, "USB1_IRQHandler")
	_ = interrupt.Register(IRQ_SCT, "SCT_IRQHandler")
	_ = interrupt.Register(IRQ_RITIMER, "RITIMER_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER0, "TIMER0_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER1, "TIMER1_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER2, "TIMER2_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER3, "TIMER3_IRQHandler")
	_ = interrupt.Register(IRQ_MCPWM, "MCPWM_IRQHandler")
	_ = interrupt.Register(IRQ_ADC0, "ADC0_IRQHandler")
	_ = interrupt.Register(IRQ_I2C0, "I2C0_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1, "I2C1_IRQHandler")
	_ = interrupt.Register(IRQ_ADC1, "ADC1_IRQHandler")
	_ = interrupt.Register(IRQ_SSP0, "SSP0_IRQHandler")
	_ = interrupt.Register(IRQ_SSP1, "SSP1_IRQHandler")
	_ = interrupt.Register(IRQ_USART0, "USART0_IRQHandler")
	_ = interrupt.Register(IRQ_UART1, "UART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_I2S0, "I2S0_IRQHandler")
	_ = interrupt.Register(IRQ_I2S1, "I2S1_IRQHandler")
	_ = interrupt.Register(IRQ_SPIFI, "SPIFI_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT0, "PIN_INT0_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT1, "PIN_INT1_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT2, "PIN_INT2_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT3, "PIN_INT3_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT4, "PIN_INT4_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT5, "PIN_INT5_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT6, "PIN_INT6_IRQHandler")
	_ = interrupt.Register(IRQ_PIN_INT7, "PIN_INT7_IRQHandler")
	_ = interrupt.Register(IRQ_GINT0, "GINT0_IRQHandler")
	_ = interrupt.Register(IRQ_GINT1, "GINT1_IRQHandler")
	_ = interrupt.Register(IRQ_EVENTROUTER, "EVENTROUTER_IRQHandler")
	_ = interrupt.Register(IRQ_C_CAN1, "C_CAN1_IRQHandler")
	_ = interrupt.Register(IRQ_ATIMER, "ATIMER_IRQHandler")
	_ = interrupt.Register(IRQ_RTC, "RTC_IRQHandler")
	_ = interrupt.Register(IRQ_WWDT, "WWDT_IRQHandler")
	_ = interrupt.Register(IRQ_C_CAN0, "C_CAN0_IRQHandler")
	_ = interrupt.Register(IRQ_QEI, "QEI_IRQHandler")
)

// Peripherals.
var (
	// State Configurable Timer (SCT) with dither engine
	SCT = (*SCT_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General Purpose DMA (GPDMA)
	GPDMA = (*GPDMA_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// SPI Flash Interface (SPIFI)
	SPIFI = (*SPIFI_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// SD/MMC
	SDMMC = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// External Memory Controller (EMC)
	EMC = (*EMC_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// USB0 Host/Device/OTG controller
	USB0 = (*USB0_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// USB1 Host/Device controller
	USB1 = (*USB1_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// LCD controller
	LCD = (*LCD_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// EEPROM
	EEPROM = (*EEPROM_Type)(unsafe.Pointer(uintptr(0x4000e000)))

	// Ethernet
	ETHERNET = (*ETHERNET_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Alarm timer
	ATIMER = (*ATIMER_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// RTC REGFILE
	REGFILE = (*REGFILE_Type)(unsafe.Pointer(uintptr(0x40041000)))

	// Power Management Controller (PMC)
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x40042000)))

	// Configuration Registers (CREG)
	CREG = (*CREG_Type)(unsafe.Pointer(uintptr(0x40043000)))

	// Event router
	EVENTROUTER = (*EVENTROUTER_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// Real-Time Clock (RTC) and event recorder
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40046000)))

	// Clock Generation Unit (CGU)
	CGU = (*CGU_Type)(unsafe.Pointer(uintptr(0x40050000)))

	// Clock Control Unit (CCU)
	CCU1 = (*CCU1_Type)(unsafe.Pointer(uintptr(0x40051000)))

	// Clock Control Unit (CCU2)
	CCU2 = (*CCU2_Type)(unsafe.Pointer(uintptr(0x40052000)))

	// Reset Generation Unit (RGU)
	RGU = (*RGU_Type)(unsafe.Pointer(uintptr(0x40053000)))

	// Windowed Watchdog timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// USART0_2_3
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40081000)))

	// UART1
	UART1 = (*UART1_Type)(unsafe.Pointer(uintptr(0x40082000)))

	// SSP0/1
	SSP0 = (*SSP_Type)(unsafe.Pointer(uintptr(0x40083000)))

	// Timer0/1/2/3
	TIMER0 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40084000)))

	// System Control Unit (SCU) I/O configuration
	SCU = (*SCU_Type)(unsafe.Pointer(uintptr(0x40086000)))

	// GPIO pin interrupt
	GPIO_PIN_INT = (*GPIO_PIN_INT_Type)(unsafe.Pointer(uintptr(0x40087000)))

	// GPIO group interrupt 0
	GPIO_GROUP_INT0 = (*GPIO_GROUP_INT0_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// GPIO group interrupt 0
	GPIO_GROUP_INT1 = (*GPIO_GROUP_INT0_Type)(unsafe.Pointer(uintptr(0x40089000)))

	// Motor Control PWM (MOTOCONPWM)
	MCPWM = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x400a0000)))

	// I2C-bus interface
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x400a1000)))

	// I2S interface
	I2S0 = (*I2S_Type)(unsafe.Pointer(uintptr(0x400a2000)))

	// C_CAN
	C_CAN1 = (*C_CAN1_Type)(unsafe.Pointer(uintptr(0x400a4000)))

	// Repetitive Interrupt Timer (RIT)
	RITIMER = (*RITIMER_Type)(unsafe.Pointer(uintptr(0x400c0000)))

	// Quadrature Encoder Interface (QEI)
	QEI = (*QEI_Type)(unsafe.Pointer(uintptr(0x400c6000)))

	// Global Input Multiplexer Array (GIMA)
	GIMA = (*GIMA_Type)(unsafe.Pointer(uintptr(0x400c7000)))

	// Digital-to-Analog Converter (DAC)
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x400e1000)))

	// C_CAN
	C_CAN0 = (*C_CAN1_Type)(unsafe.Pointer(uintptr(0x400e2000)))

	// 10-bit Analog-to-Digital Converter (ADC)
	ADC0 = (*ADC_Type)(unsafe.Pointer(uintptr(0x400e3000)))

	// GPIO port
	GPIO_PORT = (*GPIO_PORT_Type)(unsafe.Pointer(uintptr(0x400f4000)))

	// USART0_2_3
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x400c1000)))

	// USART0_2_3
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x400c2000)))

	// SSP0/1
	SSP1 = (*SSP_Type)(unsafe.Pointer(uintptr(0x400c5000)))

	// Timer0/1/2/3
	TIMER1 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40085000)))

	// Timer0/1/2/3
	TIMER2 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x400c3000)))

	// Timer0/1/2/3
	TIMER3 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x400c4000)))

	// I2C-bus interface
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x400e0000)))

	// I2S interface
	I2S1 = (*I2S_Type)(unsafe.Pointer(uintptr(0x400a3000)))

	// 10-bit Analog-to-Digital Converter (ADC)
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x400e4000)))
)

// State Configurable Timer (SCT) with dither engine
type SCT_Type struct {
	CONFIG        volatile.Register32 // 0x0
	CTRL          volatile.Register32 // 0x4
	LIMIT         volatile.Register32 // 0x8
	HALT          volatile.Register32 // 0xC
	STOP          volatile.Register32 // 0x10
	START         volatile.Register32 // 0x14
	DITHER        volatile.Register32 // 0x18
	_             [36]byte
	COUNT         volatile.Register32 // 0x40
	STATE         volatile.Register32 // 0x44
	INPUT         volatile.Register32 // 0x48
	REGMODE       volatile.Register32 // 0x4C
	OUTPUT        volatile.Register32 // 0x50
	OUTPUTDIRCTRL volatile.Register32 // 0x54
	RES           volatile.Register32 // 0x58
	DMAREQ0       volatile.Register32 // 0x5C
	DMAREQ1       volatile.Register32 // 0x60
	_             [140]byte
	EVEN          volatile.Register32 // 0xF0
	EVFLAG        volatile.Register32 // 0xF4
	CONEN         volatile.Register32 // 0xF8
	CONFLAG       volatile.Register32 // 0xFC
	MATCH0        volatile.Register32 // 0x100
	MATCH1        volatile.Register32 // 0x104
	MATCH2        volatile.Register32 // 0x108
	MATCH3        volatile.Register32 // 0x10C
	MATCH4        volatile.Register32 // 0x110
	MATCH5        volatile.Register32 // 0x114
	MATCH6        volatile.Register32 // 0x118
	MATCH7        volatile.Register32 // 0x11C
	MATCH8        volatile.Register32 // 0x120
	MATCH9        volatile.Register32 // 0x124
	MATCH10       volatile.Register32 // 0x128
	MATCH11       volatile.Register32 // 0x12C
	MATCH12       volatile.Register32 // 0x130
	MATCH13       volatile.Register32 // 0x134
	MATCH14       volatile.Register32 // 0x138
	MATCH15       volatile.Register32 // 0x13C
	FRACMAT0      volatile.Register32 // 0x140
	FRACMAT1      volatile.Register32 // 0x144
	FRACMAT2      volatile.Register32 // 0x148
	FRACMAT3      volatile.Register32 // 0x14C
	FRACMAT4      volatile.Register32 // 0x150
	FRACMAT5      volatile.Register32 // 0x154
	_             [168]byte
	MATCHREL0     volatile.Register32 // 0x200
	MATCHREL1     volatile.Register32 // 0x204
	MATCHREL2     volatile.Register32 // 0x208
	MATCHREL3     volatile.Register32 // 0x20C
	MATCHREL4     volatile.Register32 // 0x210
	MATCHREL5     volatile.Register32 // 0x214
	MATCHREL6     volatile.Register32 // 0x218
	MATCHREL7     volatile.Register32 // 0x21C
	MATCHREL8     volatile.Register32 // 0x220
	MATCHREL9     volatile.Register32 // 0x224
	MATCHREL10    volatile.Register32 // 0x228
	MATCHREL11    volatile.Register32 // 0x22C
	MATCHREL12    volatile.Register32 // 0x230
	MATCHREL13    volatile.Register32 // 0x234
	MATCHREL14    volatile.Register32 // 0x238
	MATCHREL15    volatile.Register32 // 0x23C
	FRACMATREL0   volatile.Register32 // 0x240
	FRACMATREL1   volatile.Register32 // 0x244
	FRACMATREL2   volatile.Register32 // 0x248
	FRACMATREL3   volatile.Register32 // 0x24C
	FRACMATREL4   volatile.Register32 // 0x250
	FRACMATREL5   volatile.Register32 // 0x254
	_             [168]byte
	EV0_STATE     volatile.Register32 // 0x300
	EV0_CTRL      volatile.Register32 // 0x304
	EV1_STATE     volatile.Register32 // 0x308
	EV1_CTRL      volatile.Register32 // 0x30C
	EV2_STATE     volatile.Register32 // 0x310
	EV2_CTRL      volatile.Register32 // 0x314
	EV3_STATE     volatile.Register32 // 0x318
	EV3_CTRL      volatile.Register32 // 0x31C
	EV4_STATE     volatile.Register32 // 0x320
	EV4_CTRL      volatile.Register32 // 0x324
	EV5_STATE     volatile.Register32 // 0x328
	EV5_CTRL      volatile.Register32 // 0x32C
	EV6_STATE     volatile.Register32 // 0x330
	EV6_CTRL      volatile.Register32 // 0x334
	EV7_STATE     volatile.Register32 // 0x338
	EV7_CTRL      volatile.Register32 // 0x33C
	EV8_STATE     volatile.Register32 // 0x340
	EV8_CTRL      volatile.Register32 // 0x344
	EV9_STATE     volatile.Register32 // 0x348
	EV9_CTRL      volatile.Register32 // 0x34C
	EV10_STATE    volatile.Register32 // 0x350
	EV10_CTRL     volatile.Register32 // 0x354
	EV11_STATE    volatile.Register32 // 0x358
	EV11_CTRL     volatile.Register32 // 0x35C
	EV12_STATE    volatile.Register32 // 0x360
	EV12_CTRL     volatile.Register32 // 0x364
	EV13_STATE    volatile.Register32 // 0x368
	EV13_CTRL     volatile.Register32 // 0x36C
	EV14_STATE    volatile.Register32 // 0x370
	EV14_CTRL     volatile.Register32 // 0x374
	EV15_STATE    volatile.Register32 // 0x378
	EV15_CTRL     volatile.Register32 // 0x37C
	_             [384]byte
	OUT0_SET      volatile.Register32 // 0x500
	OUT0_CLR      volatile.Register32 // 0x504
	OUT1_SET      volatile.Register32 // 0x508
	OUT1_CLR      volatile.Register32 // 0x50C
	OUT2_SET      volatile.Register32 // 0x510
	OUT2_CLR      volatile.Register32 // 0x514
	OUT3_SET      volatile.Register32 // 0x518
	OUT3_CLR      volatile.Register32 // 0x51C
	OUT4_SET      volatile.Register32 // 0x520
	OUT4_CLR      volatile.Register32 // 0x524
	OUT5_SET      volatile.Register32 // 0x528
	OUT5_CLR      volatile.Register32 // 0x52C
	OUT6_SET      volatile.Register32 // 0x530
	OUT6_CLR      volatile.Register32 // 0x534
	OUT7_SET      volatile.Register32 // 0x538
	OUT7_CLR      volatile.Register32 // 0x53C
	OUT8_SET      volatile.Register32 // 0x540
	OUT8_CLR      volatile.Register32 // 0x544
	OUT9_SET      volatile.Register32 // 0x548
	OUT9_CLR      volatile.Register32 // 0x54C
	OUT10_SET     volatile.Register32 // 0x550
	OUT10_CLR     volatile.Register32 // 0x554
	OUT11_SET     volatile.Register32 // 0x558
	OUT11_CLR     volatile.Register32 // 0x55C
	OUT12_SET     volatile.Register32 // 0x560
	OUT12_CLR     volatile.Register32 // 0x564
	OUT13_SET     volatile.Register32 // 0x568
	OUT13_CLR     volatile.Register32 // 0x56C
	OUT14_SET     volatile.Register32 // 0x570
	OUT14_CLR     volatile.Register32 // 0x574
	OUT15_SET     volatile.Register32 // 0x578
	OUT15_CLR     volatile.Register32 // 0x57C
}

// General Purpose DMA (GPDMA)
type GPDMA_Type struct {
	INTSTAT       volatile.Register32 // 0x0
	INTTCSTAT     volatile.Register32 // 0x4
	INTTCCLEAR    volatile.Register32 // 0x8
	INTERRSTAT    volatile.Register32 // 0xC
	INTERRCLR     volatile.Register32 // 0x10
	RAWINTTCSTAT  volatile.Register32 // 0x14
	RAWINTERRSTAT volatile.Register32 // 0x18
	ENBLDCHNS     volatile.Register32 // 0x1C
	SOFTBREQ      volatile.Register32 // 0x20
	SOFTSREQ      volatile.Register32 // 0x24
	SOFTLBREQ     volatile.Register32 // 0x28
	SOFTLSREQ     volatile.Register32 // 0x2C
	CONFIG        volatile.Register32 // 0x30
	SYNC          volatile.Register32 // 0x34
	_             [200]byte
	C0SRCADDR     volatile.Register32 // 0x100
	C0DESTADDR    volatile.Register32 // 0x104
	C0LLI         volatile.Register32 // 0x108
	C0CONTROL     volatile.Register32 // 0x10C
	C0CONFIG      volatile.Register32 // 0x110
	_             [12]byte
	C1SRCADDR     volatile.Register32 // 0x120
	C1DESTADDR    volatile.Register32 // 0x124
	C1LLI         volatile.Register32 // 0x128
	C1CONTROL     volatile.Register32 // 0x12C
	C1CONFIG      volatile.Register32 // 0x130
	_             [12]byte
	C2SRCADDR     volatile.Register32 // 0x140
	C2DESTADDR    volatile.Register32 // 0x144
	C2LLI         volatile.Register32 // 0x148
	C2CONTROL     volatile.Register32 // 0x14C
	C2CONFIG      volatile.Register32 // 0x150
	_             [12]byte
	C3SRCADDR     volatile.Register32 // 0x160
	C3DESTADDR    volatile.Register32 // 0x164
	C3LLI         volatile.Register32 // 0x168
	C3CONTROL     volatile.Register32 // 0x16C
	C3CONFIG      volatile.Register32 // 0x170
	_             [12]byte
	C4SRCADDR     volatile.Register32 // 0x180
	C4DESTADDR    volatile.Register32 // 0x184
	C4LLI         volatile.Register32 // 0x188
	C4CONTROL     volatile.Register32 // 0x18C
	C4CONFIG      volatile.Register32 // 0x190
	_             [12]byte
	C5SRCADDR     volatile.Register32 // 0x1A0
	C5DESTADDR    volatile.Register32 // 0x1A4
	C5LLI         volatile.Register32 // 0x1A8
	C5CONTROL     volatile.Register32 // 0x1AC
	C5CONFIG      volatile.Register32 // 0x1B0
	_             [12]byte
	C6SRCADDR     volatile.Register32 // 0x1C0
	C6DESTADDR    volatile.Register32 // 0x1C4
	C6LLI         volatile.Register32 // 0x1C8
	C6CONTROL     volatile.Register32 // 0x1CC
	C6CONFIG      volatile.Register32 // 0x1D0
	_             [12]byte
	C7SRCADDR     volatile.Register32 // 0x1E0
	C7DESTADDR    volatile.Register32 // 0x1E4
	C7LLI         volatile.Register32 // 0x1E8
	C7CONTROL     volatile.Register32 // 0x1EC
	C7CONFIG      volatile.Register32 // 0x1F0
}

// SPI Flash Interface (SPIFI)
type SPIFI_Type struct {
	CTRL   volatile.Register32 // 0x0
	CMD    volatile.Register32 // 0x4
	ADDR   volatile.Register32 // 0x8
	IDATA  volatile.Register32 // 0xC
	CLIMIT volatile.Register32 // 0x10
	DATA   volatile.Register32 // 0x14
	MCMD   volatile.Register32 // 0x18
	STAT   volatile.Register32 // 0x1C
}

// SD/MMC
type SDMMC_Type struct {
	CTRL    volatile.Register32 // 0x0
	PWREN   volatile.Register32 // 0x4
	CLKDIV  volatile.Register32 // 0x8
	CLKSRC  volatile.Register32 // 0xC
	CLKENA  volatile.Register32 // 0x10
	TMOUT   volatile.Register32 // 0x14
	CTYPE   volatile.Register32 // 0x18
	BLKSIZ  volatile.Register32 // 0x1C
	BYTCNT  volatile.Register32 // 0x20
	INTMASK volatile.Register32 // 0x24
	CMDARG  volatile.Register32 // 0x28
	CMD     volatile.Register32 // 0x2C
	RESP0   volatile.Register32 // 0x30
	RESP1   volatile.Register32 // 0x34
	RESP2   volatile.Register32 // 0x38
	RESP3   volatile.Register32 // 0x3C
	MINTSTS volatile.Register32 // 0x40
	RINTSTS volatile.Register32 // 0x44
	STATUS  volatile.Register32 // 0x48
	FIFOTH  volatile.Register32 // 0x4C
	CDETECT volatile.Register32 // 0x50
	WRTPRT  volatile.Register32 // 0x54
	_       [4]byte
	TCBCNT  volatile.Register32 // 0x5C
	TBBCNT  volatile.Register32 // 0x60
	DEBNCE  volatile.Register32 // 0x64
	_       [16]byte
	RST_N   volatile.Register32 // 0x78
	_       [4]byte
	BMOD    volatile.Register32 // 0x80
	PLDMND  volatile.Register32 // 0x84
	DBADDR  volatile.Register32 // 0x88
	IDSTS   volatile.Register32 // 0x8C
	IDINTEN volatile.Register32 // 0x90
	DSCADDR volatile.Register32 // 0x94
	BUFADDR volatile.Register32 // 0x98
}

// External Memory Controller (EMC)
type EMC_Type struct {
	CONTROL            volatile.Register32 // 0x0
	STATUS             volatile.Register32 // 0x4
	CONFIG             volatile.Register32 // 0x8
	_                  [20]byte
	DYNAMICCONTROL     volatile.Register32 // 0x20
	DYNAMICREFRESH     volatile.Register32 // 0x24
	DYNAMICREADCONFIG  volatile.Register32 // 0x28
	_                  [4]byte
	DYNAMICRP          volatile.Register32 // 0x30
	DYNAMICRAS         volatile.Register32 // 0x34
	DYNAMICSREX        volatile.Register32 // 0x38
	DYNAMICAPR         volatile.Register32 // 0x3C
	DYNAMICDAL         volatile.Register32 // 0x40
	DYNAMICWR          volatile.Register32 // 0x44
	DYNAMICRC          volatile.Register32 // 0x48
	DYNAMICRFC         volatile.Register32 // 0x4C
	DYNAMICXSR         volatile.Register32 // 0x50
	DYNAMICRRD         volatile.Register32 // 0x54
	DYNAMICMRD         volatile.Register32 // 0x58
	_                  [36]byte
	STATICEXTENDEDWAIT volatile.Register32 // 0x80
	_                  [124]byte
	DYNAMICCONFIG0     volatile.Register32 // 0x100
	DYNAMICRASCAS0     volatile.Register32 // 0x104
	_                  [24]byte
	DYNAMICCONFIG1     volatile.Register32 // 0x120
	DYNAMICRASCAS1     volatile.Register32 // 0x124
	_                  [24]byte
	DYNAMICCONFIG2     volatile.Register32 // 0x140
	DYNAMICRASCAS2     volatile.Register32 // 0x144
	_                  [24]byte
	DYNAMICCONFIG3     volatile.Register32 // 0x160
	DYNAMICRASCAS3     volatile.Register32 // 0x164
	_                  [152]byte
	STATICCONFIG0      volatile.Register32 // 0x200
	STATICWAITWEN0     volatile.Register32 // 0x204
	STATICWAITOEN0     volatile.Register32 // 0x208
	STATICWAITRD0      volatile.Register32 // 0x20C
	STATICWAITPAGE0    volatile.Register32 // 0x210
	STATICWAITWR0      volatile.Register32 // 0x214
	STATICWAITTURN0    volatile.Register32 // 0x218
	_                  [4]byte
	STATICCONFIG1      volatile.Register32 // 0x220
	STATICWAITWEN1     volatile.Register32 // 0x224
	STATICWAITOEN1     volatile.Register32 // 0x228
	STATICWAITRD1      volatile.Register32 // 0x22C
	STATICWAITPAGE1    volatile.Register32 // 0x230
	STATICWAITWR1      volatile.Register32 // 0x234
	STATICWAITTURN1    volatile.Register32 // 0x238
	_                  [4]byte
	STATICCONFIG2      volatile.Register32 // 0x240
	STATICWAITWEN2     volatile.Register32 // 0x244
	STATICWAITOEN2     volatile.Register32 // 0x248
	STATICWAITRD2      volatile.Register32 // 0x24C
	STATICWAITPAGE2    volatile.Register32 // 0x250
	STATICWAITWR2      volatile.Register32 // 0x254
	STATICWAITTURN2    volatile.Register32 // 0x258
	_                  [4]byte
	STATICCONFIG3      volatile.Register32 // 0x260
	STATICWAITWEN3     volatile.Register32 // 0x264
	STATICWAITOEN3     volatile.Register32 // 0x268
	STATICWAITRD3      volatile.Register32 // 0x26C
	STATICWAITPAGE3    volatile.Register32 // 0x270
	STATICWAITWR3      volatile.Register32 // 0x274
	STATICWAITTURN3    volatile.Register32 // 0x278
}

// USB0 Host/Device/OTG controller
type USB0_Type struct {
	_                [256]byte
	CAPLENGTH        volatile.Register32 // 0x100
	HCSPARAMS        volatile.Register32 // 0x104
	HCCPARAMS        volatile.Register32 // 0x108
	_                [20]byte
	DCIVERSION       volatile.Register32 // 0x120
	_                [28]byte
	USBCMD_D         volatile.Register32 // 0x140
	USBSTS_D         volatile.Register32 // 0x144
	USBINTR_D        volatile.Register32 // 0x148
	FRINDEX_D        volatile.Register32 // 0x14C
	_                [4]byte
	DEVICEADDR       volatile.Register32 // 0x154
	ENDPOINTLISTADDR volatile.Register32 // 0x158
	TTCTRL           volatile.Register32 // 0x15C
	BURSTSIZE        volatile.Register32 // 0x160
	TXFILLTUNING     volatile.Register32 // 0x164
	_                [12]byte
	BINTERVAL        volatile.Register32 // 0x174
	ENDPTNAK         volatile.Register32 // 0x178
	ENDPTNAKEN       volatile.Register32 // 0x17C
	_                [4]byte
	PORTSC1_D        volatile.Register32 // 0x184
	_                [28]byte
	OTGSC            volatile.Register32 // 0x1A4
	USBMODE_D        volatile.Register32 // 0x1A8
	ENDPTSETUPSTAT   volatile.Register32 // 0x1AC
	ENDPTPRIME       volatile.Register32 // 0x1B0
	ENDPTFLUSH       volatile.Register32 // 0x1B4
	ENDPTSTAT        volatile.Register32 // 0x1B8
	ENDPTCOMPLETE    volatile.Register32 // 0x1BC
	ENDPTCTRL0       volatile.Register32 // 0x1C0
	ENDPTCTRL1       volatile.Register32 // 0x1C4
	ENDPTCTRL2       volatile.Register32 // 0x1C8
	ENDPTCTRL3       volatile.Register32 // 0x1CC
	ENDPTCTRL4       volatile.Register32 // 0x1D0
	ENDPTCTRL5       volatile.Register32 // 0x1D4
}

// USB1 Host/Device controller
type USB1_Type struct {
	_                [256]byte
	CAPLENGTH        volatile.Register32 // 0x100
	HCSPARAMS        volatile.Register32 // 0x104
	HCCPARAMS        volatile.Register32 // 0x108
	_                [20]byte
	DCIVERSION       volatile.Register32 // 0x120
	_                [28]byte
	USBCMD_D         volatile.Register32 // 0x140
	USBSTS_D         volatile.Register32 // 0x144
	USBINTR_D        volatile.Register32 // 0x148
	FRINDEX_D        volatile.Register32 // 0x14C
	_                [4]byte
	DEVICEADDR       volatile.Register32 // 0x154
	ENDPOINTLISTADDR volatile.Register32 // 0x158
	TTCTRL           volatile.Register32 // 0x15C
	BURSTSIZE        volatile.Register32 // 0x160
	TXFILLTUNING     volatile.Register32 // 0x164
	_                [8]byte
	ULPIVIEWPORT     volatile.Register32 // 0x170
	BINTERVAL        volatile.Register32 // 0x174
	ENDPTNAK         volatile.Register32 // 0x178
	ENDPTNAKEN       volatile.Register32 // 0x17C
	_                [4]byte
	PORTSC1_D        volatile.Register32 // 0x184
	_                [32]byte
	USBMODE_D        volatile.Register32 // 0x1A8
	ENDPTSETUPSTAT   volatile.Register32 // 0x1AC
	ENDPTPRIME       volatile.Register32 // 0x1B0
	ENDPTFLUSH       volatile.Register32 // 0x1B4
	ENDPTSTAT        volatile.Register32 // 0x1B8
	ENDPTCOMPLETE    volatile.Register32 // 0x1BC
	ENDPTCTRL0       volatile.Register32 // 0x1C0
	ENDPTCTRL1       volatile.Register32 // 0x1C4
	ENDPTCTRL2       volatile.Register32 // 0x1C8
	ENDPTCTRL3       volatile.Register32 // 0x1CC
}

// LCD controller
type LCD_Type struct {
	TIMH         volatile.Register32 // 0x0
	TIMV         volatile.Register32 // 0x4
	POL          volatile.Register32 // 0x8
	LE           volatile.Register32 // 0xC
	UPBASE       volatile.Register32 // 0x10
	LPBASE       volatile.Register32 // 0x14
	CTRL         volatile.Register32 // 0x18
	INTMSK       volatile.Register32 // 0x1C
	INTRAW       volatile.Register32 // 0x20
	INTSTAT      volatile.Register32 // 0x24
	INTCLR       volatile.Register32 // 0x28
	UPCURR       volatile.Register32 // 0x2C
	LPCURR       volatile.Register32 // 0x30
	_            [460]byte
	PAL          [256]volatile.Register32 // 0x200
	_            [512]byte
	CRSR_IMG     [256]volatile.Register32 // 0x800
	CRSR_CTRL    volatile.Register32      // 0xC00
	CRSR_CFG     volatile.Register32      // 0xC04
	CRSR_PAL0    volatile.Register32      // 0xC08
	CRSR_PAL1    volatile.Register32      // 0xC0C
	CRSR_XY      volatile.Register32      // 0xC10
	CRSR_CLIP    volatile.Register32      // 0xC14
	_            [8]byte
	CRSR_INTMSK  volatile.Register32 // 0xC20
	CRSR_INTCLR  volatile.Register32 // 0xC24
	CRSR_INTRAW  volatile.Register32 // 0xC28
	CRSR_INTSTAT volatile.Register32 // 0xC2C
}

// EEPROM
type EEPROM_Type struct {
	CMD        volatile.Register32 // 0x0
	_          [4]byte
	RWSTATE    volatile.Register32 // 0x8
	AUTOPROG   volatile.Register32 // 0xC
	WSTATE     volatile.Register32 // 0x10
	CLKDIV     volatile.Register32 // 0x14
	PWRDWN     volatile.Register32 // 0x18
	_          [4028]byte
	INTENCLR   volatile.Register32 // 0xFD8
	INTENSET   volatile.Register32 // 0xFDC
	INTSTAT    volatile.Register32 // 0xFE0
	INTEN      volatile.Register32 // 0xFE4
	INTSTATCLR volatile.Register32 // 0xFE8
	INTSTATSET volatile.Register32 // 0xFEC
}

// Ethernet
type ETHERNET_Type struct {
	MAC_CONFIG            volatile.Register32 // 0x0
	MAC_FRAME_FILTER      volatile.Register32 // 0x4
	MAC_HASHTABLE_HIGH    volatile.Register32 // 0x8
	MAC_HASHTABLE_LOW     volatile.Register32 // 0xC
	MAC_MII_ADDR          volatile.Register32 // 0x10
	MAC_MII_DATA          volatile.Register32 // 0x14
	MAC_FLOW_CTRL         volatile.Register32 // 0x18
	MAC_VLAN_TAG          volatile.Register32 // 0x1C
	_                     [4]byte
	MAC_DEBUG             volatile.Register32 // 0x24
	MAC_RWAKE_FRFLT       volatile.Register32 // 0x28
	MAC_PMT_CTRL_STAT     volatile.Register32 // 0x2C
	_                     [8]byte
	MAC_INTR              volatile.Register32 // 0x38
	MAC_INTR_MASK         volatile.Register32 // 0x3C
	MAC_ADDR0_HIGH        volatile.Register32 // 0x40
	MAC_ADDR0_LOW         volatile.Register32 // 0x44
	_                     [1720]byte
	MAC_TIMESTP_CTRL      volatile.Register32 // 0x700
	SUBSECOND_INCR        volatile.Register32 // 0x704
	SECONDS               volatile.Register32 // 0x708
	NANOSECONDS           volatile.Register32 // 0x70C
	SECONDSUPDATE         volatile.Register32 // 0x710
	NANOSECONDSUPDATE     volatile.Register32 // 0x714
	ADDEND                volatile.Register32 // 0x718
	TARGETSECONDS         volatile.Register32 // 0x71C
	TARGETNANOSECONDS     volatile.Register32 // 0x720
	HIGHWORD              volatile.Register32 // 0x724
	TIMESTAMPSTAT         volatile.Register32 // 0x728
	_                     [2260]byte
	DMA_BUS_MODE          volatile.Register32 // 0x1000
	DMA_TRANS_POLL_DEMAND volatile.Register32 // 0x1004
	DMA_REC_POLL_DEMAND   volatile.Register32 // 0x1008
	DMA_REC_DES_ADDR      volatile.Register32 // 0x100C
	DMA_TRANS_DES_ADDR    volatile.Register32 // 0x1010
	DMA_STAT              volatile.Register32 // 0x1014
	DMA_OP_MODE           volatile.Register32 // 0x1018
	DMA_INT_EN            volatile.Register32 // 0x101C
	DMA_MFRM_BUFOF        volatile.Register32 // 0x1020
	DMA_REC_INT_WDT       volatile.Register32 // 0x1024
	_                     [32]byte
	DMA_CURHOST_TRANS_DES volatile.Register32 // 0x1048
	DMA_CURHOST_REC_DES   volatile.Register32 // 0x104C
	DMA_CURHOST_TRANS_BUF volatile.Register32 // 0x1050
	DMA_CURHOST_REC_BUF   volatile.Register32 // 0x1054
}

// Alarm timer
type ATIMER_Type struct {
	DOWNCOUNTER volatile.Register32 // 0x0
	PRESET      volatile.Register32 // 0x4
	_           [4048]byte
	CLR_EN      volatile.Register32 // 0xFD8
	SET_EN      volatile.Register32 // 0xFDC
	STATUS      volatile.Register32 // 0xFE0
	ENABLE      volatile.Register32 // 0xFE4
	CLR_STAT    volatile.Register32 // 0xFE8
	SET_STAT    volatile.Register32 // 0xFEC
}

// RTC REGFILE
type REGFILE_Type struct {
	REGFILE [64]volatile.Register32 // 0x0
}

// Power Management Controller (PMC)
type PMC_Type struct {
	PD0_SLEEP0_HW_ENA volatile.Register32 // 0x0
	_                 [24]byte
	PD0_SLEEP0_MODE   volatile.Register32 // 0x1C
}

// Configuration Registers (CREG)
type CREG_Type struct {
	_         [4]byte
	CREG0     volatile.Register32 // 0x4
	_         [248]byte
	M3MEMMAP  volatile.Register32 // 0x100
	_         [20]byte
	CREG5     volatile.Register32 // 0x118
	DMAMUX    volatile.Register32 // 0x11C
	FLASHCFGA volatile.Register32 // 0x120
	FLASHCFGB volatile.Register32 // 0x124
	ETBCFG    volatile.Register32 // 0x128
	CREG6     volatile.Register32 // 0x12C
	_         [208]byte
	CHIPID    volatile.Register32 // 0x200
	_         [764]byte
	USB0FLADJ volatile.Register32 // 0x500
	_         [252]byte
	USB1FLADJ volatile.Register32 // 0x600
}

// Event router
type EVENTROUTER_Type struct {
	HILO     volatile.Register32 // 0x0
	EDGE     volatile.Register32 // 0x4
	_        [4048]byte
	CLR_EN   volatile.Register32 // 0xFD8
	SET_EN   volatile.Register32 // 0xFDC
	STATUS   volatile.Register32 // 0xFE0
	ENABLE   volatile.Register32 // 0xFE4
	CLR_STAT volatile.Register32 // 0xFE8
	SET_STAT volatile.Register32 // 0xFEC
}

// Real-Time Clock (RTC) and event recorder
type RTC_Type struct {
	ILR           volatile.Register32 // 0x0
	_             [4]byte
	CCR           volatile.Register32 // 0x8
	CIIR          volatile.Register32 // 0xC
	AMR           volatile.Register32 // 0x10
	CTIME0        volatile.Register32 // 0x14
	CTIME1        volatile.Register32 // 0x18
	CTIME2        volatile.Register32 // 0x1C
	SEC           volatile.Register32 // 0x20
	MIN           volatile.Register32 // 0x24
	HRS           volatile.Register32 // 0x28
	DOM           volatile.Register32 // 0x2C
	DOW           volatile.Register32 // 0x30
	DOY           volatile.Register32 // 0x34
	MONTH         volatile.Register32 // 0x38
	YEAR          volatile.Register32 // 0x3C
	CALIBRATION   volatile.Register32 // 0x40
	_             [28]byte
	ASEC          volatile.Register32 // 0x60
	AMIN          volatile.Register32 // 0x64
	AHRS          volatile.Register32 // 0x68
	ADOM          volatile.Register32 // 0x6C
	ADOW          volatile.Register32 // 0x70
	ADOY          volatile.Register32 // 0x74
	AMON          volatile.Register32 // 0x78
	AYRS          volatile.Register32 // 0x7C
	ERSTATUS      volatile.Register32 // 0x80
	ERCONTRO      volatile.Register32 // 0x84
	ERCOUNTERS    volatile.Register32 // 0x88
	_             [4]byte
	ERFIRSTSTAMP0 volatile.Register32 // 0x90
	ERFIRSTSTAMP1 volatile.Register32 // 0x94
	ERFIRSTSTAMP2 volatile.Register32 // 0x98
	_             [4]byte
	ERLASTSTAMP0  volatile.Register32 // 0xA0
	ERLASTSTAMP1  volatile.Register32 // 0xA4
	ERLASTSTAMP2  volatile.Register32 // 0xA8
}

// Clock Generation Unit (CGU)
type CGU_Type struct {
	_                 [20]byte
	FREQ_MON          volatile.Register32 // 0x14
	XTAL_OSC_CTRL     volatile.Register32 // 0x18
	PLL0USB_STAT      volatile.Register32 // 0x1C
	PLL0USB_CTRL      volatile.Register32 // 0x20
	PLL0USB_MDIV      volatile.Register32 // 0x24
	PLL0USB_NP_DIV    volatile.Register32 // 0x28
	PLL0AUDIO_STAT    volatile.Register32 // 0x2C
	PLL0AUDIO_CTRL    volatile.Register32 // 0x30
	PLL0AUDIO_MDIV    volatile.Register32 // 0x34
	PLL0AUDIO_NP_DIV  volatile.Register32 // 0x38
	PLL0AUDIO_FRAC    volatile.Register32 // 0x3C
	PLL1_STAT         volatile.Register32 // 0x40
	PLL1_CTRL         volatile.Register32 // 0x44
	IDIVA_CTRL        volatile.Register32 // 0x48
	IDIVB_CTRL        volatile.Register32 // 0x4C
	IDIVC_CTRL        volatile.Register32 // 0x50
	IDIVD_CTRL        volatile.Register32 // 0x54
	IDIVE_CTRL        volatile.Register32 // 0x58
	BASE_SAFE_CLK     volatile.Register32 // 0x5C
	BASE_USB0_CLK     volatile.Register32 // 0x60
	BASE_PERIPH_CLK   volatile.Register32 // 0x64
	BASE_USB1_CLK     volatile.Register32 // 0x68
	BASE_M3_CLK       volatile.Register32 // 0x6C
	BASE_SPIFI_CLK    volatile.Register32 // 0x70
	_                 [4]byte
	BASE_PHY_RX_CLK   volatile.Register32 // 0x78
	BASE_PHY_TX_CLK   volatile.Register32 // 0x7C
	BASE_APB1_CLK     volatile.Register32 // 0x80
	BASE_APB3_CLK     volatile.Register32 // 0x84
	BASE_LCD_CLK      volatile.Register32 // 0x88
	_                 [4]byte
	BASE_SDIO_CLK     volatile.Register32 // 0x90
	BASE_SSP0_CLK     volatile.Register32 // 0x94
	BASE_SSP1_CLK     volatile.Register32 // 0x98
	BASE_UART0_CLK    volatile.Register32 // 0x9C
	BASE_UART1_CLK    volatile.Register32 // 0xA0
	BASE_UART2_CLK    volatile.Register32 // 0xA4
	BASE_UART3_CLK    volatile.Register32 // 0xA8
	BASE_OUT_CLK      volatile.Register32 // 0xAC
	_                 [16]byte
	BASE_AUDIO_CLK    volatile.Register32 // 0xC0
	BASE_CGU_OUT0_CLK volatile.Register32 // 0xC4
	BASE_CGU_OUT1_CLK volatile.Register32 // 0xC8
}

// Clock Control Unit (CCU)
type CCU1_Type struct {
	PM                       volatile.Register32 // 0x0
	BASE_STAT                volatile.Register32 // 0x4
	_                        [248]byte
	CLK_APB3_BUS_CFG         volatile.Register32 // 0x100
	CLK_APB3_BUS_STAT        volatile.Register32 // 0x104
	CLK_APB3_I2C1_CFG        volatile.Register32 // 0x108
	CLK_APB3_I2C1_STAT       volatile.Register32 // 0x10C
	CLK_APB3_DAC_CFG         volatile.Register32 // 0x110
	CLK_APB3_DAC_STAT        volatile.Register32 // 0x114
	CLK_APB3_ADC0_CFG        volatile.Register32 // 0x118
	CLK_APB3_ADC0_STAT       volatile.Register32 // 0x11C
	CLK_APB3_ADC1_CFG        volatile.Register32 // 0x120
	CLK_APB3_ADC1_STAT       volatile.Register32 // 0x124
	CLK_APB3_CAN0_CFG        volatile.Register32 // 0x128
	CLK_APB3_CAN0_STAT       volatile.Register32 // 0x12C
	_                        [208]byte
	CLK_APB1_BUS_CFG         volatile.Register32 // 0x200
	CLK_APB1_BUS_STAT        volatile.Register32 // 0x204
	CLK_APB1_MOTOCONPWM_CFG  volatile.Register32 // 0x208
	CLK_APB1_MOTOCONPWM_STAT volatile.Register32 // 0x20C
	CLK_APB1_I2C0_CFG        volatile.Register32 // 0x210
	CLK_APB1_I2C0_STAT       volatile.Register32 // 0x214
	CLK_APB1_I2S_CFG         volatile.Register32 // 0x218
	CLK_APB1_I2S_STAT        volatile.Register32 // 0x21C
	CLK_APB1_CAN1_CFG        volatile.Register32 // 0x220
	CLK_APB1_CAN1_STAT       volatile.Register32 // 0x224
	_                        [216]byte
	CLK_SPIFI_CFG            volatile.Register32 // 0x300
	CLK_SPIFI_STAT           volatile.Register32 // 0x304
	_                        [248]byte
	CLK_M3_BUS_CFG           volatile.Register32 // 0x400
	CLK_M3_BUS_STAT          volatile.Register32 // 0x404
	CLK_M3_SPIFI_CFG         volatile.Register32 // 0x408
	CLK_M3_SPIFI_STAT        volatile.Register32 // 0x40C
	CLK_M3_GPIO_CFG          volatile.Register32 // 0x410
	CLK_M3_GPIO_STAT         volatile.Register32 // 0x414
	CLK_M3_LCD_CFG           volatile.Register32 // 0x418
	CLK_M3_LCD_STAT          volatile.Register32 // 0x41C
	CLK_M3_ETHERNET_CFG      volatile.Register32 // 0x420
	CLK_M3_ETHERNET_STAT     volatile.Register32 // 0x424
	CLK_M3_USB0_CFG          volatile.Register32 // 0x428
	CLK_M3_USB0_STAT         volatile.Register32 // 0x42C
	CLK_M3_EMC_CFG           volatile.Register32 // 0x430
	CLK_M3_EMC_STAT          volatile.Register32 // 0x434
	CLK_M3_SDIO_CFG          volatile.Register32 // 0x438
	CLK_M3_SDIO_STAT         volatile.Register32 // 0x43C
	CLK_M3_DMA_CFG           volatile.Register32 // 0x440
	CLK_M3_DMA_STAT          volatile.Register32 // 0x444
	CLK_M3_M3CORE_CFG        volatile.Register32 // 0x448
	CLK_M3_M3CORE_STAT       volatile.Register32 // 0x44C
	_                        [24]byte
	CLK_M3_SCT_CFG           volatile.Register32 // 0x468
	CLK_M3_SCT_STAT          volatile.Register32 // 0x46C
	CLK_M3_USB1_CFG          volatile.Register32 // 0x470
	CLK_M3_USB1_STAT         volatile.Register32 // 0x474
	CLK_M3_EMCDIV_CFG        volatile.Register32 // 0x478
	CLK_M3_EMCDIV_STAT       volatile.Register32 // 0x47C
	CLK_M3_FLASHA_CFG        volatile.Register32 // 0x480
	CLK_M3_FLASHA_STAT       volatile.Register32 // 0x484
	CLK_M3_FLASHB_CFG        volatile.Register32 // 0x488
	CLK_M3_FLASHB_STAT       volatile.Register32 // 0x48C
	_                        [16]byte
	CLK_M3_EEPROM_CFG        volatile.Register32 // 0x4A0
	CLK_M3_EEPROM_STAT       volatile.Register32 // 0x4A4
	_                        [88]byte
	CLK_M3_WWDT_CFG          volatile.Register32 // 0x500
	CLK_M3_WWDT_STAT         volatile.Register32 // 0x504
	CLK_M3_USART0_CFG        volatile.Register32 // 0x508
	CLK_M3_USART0_STAT       volatile.Register32 // 0x50C
	CLK_M3_UART1_CFG         volatile.Register32 // 0x510
	CLK_M3_UART1_STAT        volatile.Register32 // 0x514
	CLK_M3_SSP0_CFG          volatile.Register32 // 0x518
	CLK_M3_SSP0_STAT         volatile.Register32 // 0x51C
	CLK_M3_TIMER0_CFG        volatile.Register32 // 0x520
	CLK_M3_TIMER0_STAT       volatile.Register32 // 0x524
	CLK_M3_TIMER1_CFG        volatile.Register32 // 0x528
	CLK_M3_TIMER1_STAT       volatile.Register32 // 0x52C
	CLK_M3_SCU_CFG           volatile.Register32 // 0x530
	CLK_M3_SCU_STAT          volatile.Register32 // 0x534
	CLK_M3_CREG_CFG          volatile.Register32 // 0x538
	CLK_M3_CREG_STAT         volatile.Register32 // 0x53C
	_                        [192]byte
	CLK_M3_RITIMER_CFG       volatile.Register32 // 0x600
	CLK_M3_RITIMER_STAT      volatile.Register32 // 0x604
	CLK_M3_USART2_CFG        volatile.Register32 // 0x608
	CLK_M3_USART2_STAT       volatile.Register32 // 0x60C
	CLK_M3_USART3_CFG        volatile.Register32 // 0x610
	CLK_M3_USART3_STAT       volatile.Register32 // 0x614
	CLK_M3_TIMER2_CFG        volatile.Register32 // 0x618
	CLK_M3_TIMER2_STAT       volatile.Register32 // 0x61C
	CLK_M3_TIMER3_CFG        volatile.Register32 // 0x620
	CLK_M3_TIMER3_STAT       volatile.Register32 // 0x624
	CLK_M3_SSP1_CFG          volatile.Register32 // 0x628
	CLK_M3_SSP1_STAT         volatile.Register32 // 0x62C
	CLK_M3_QEI_CFG           volatile.Register32 // 0x630
	CLK_M3_QEI_STAT          volatile.Register32 // 0x634
	_                        [456]byte
	CLK_USB0_CFG             volatile.Register32 // 0x800
	CLK_USB0_STAT            volatile.Register32 // 0x804
	_                        [248]byte
	CLK_USB1_CFG             volatile.Register32 // 0x900
	CLK_USB1_STAT            volatile.Register32 // 0x904
}

// Clock Control Unit (CCU2)
type CCU2_Type struct {
	PM                     volatile.Register32 // 0x0
	BASE_STAT              volatile.Register32 // 0x4
	_                      [248]byte
	CLK_AUDIO_CFG          volatile.Register32 // 0x100
	CLK_AUDIO_STAT         volatile.Register32 // 0x104
	_                      [248]byte
	CLK_APB2_USART3_CFG    volatile.Register32 // 0x200
	CLK_APB2_USART3_STAT   volatile.Register32 // 0x204
	_                      [248]byte
	CLK_APB2_USART2_CFG    volatile.Register32 // 0x300
	CLK_APB2_USART2_STAT   volatile.Register32 // 0x304
	_                      [248]byte
	CLK_APB0_UART1_BUS_CFG volatile.Register32 // 0x400
	CLK_APB0_UART1_STAT    volatile.Register32 // 0x404
	_                      [248]byte
	CLK_APB0_USART0_CFG    volatile.Register32 // 0x500
	CLK_APB0_USART0_STAT   volatile.Register32 // 0x504
	_                      [248]byte
	CLK_APB2_SSP1_CFG      volatile.Register32 // 0x600
	CLK_APB2_SSP1_STAT     volatile.Register32 // 0x604
	_                      [248]byte
	CLK_APB0_SSP0_CFG      volatile.Register32 // 0x700
	CLK_APB0_SSP0_STAT     volatile.Register32 // 0x704
	_                      [248]byte
	CLK_SDIO_CFG           volatile.Register32 // 0x800
	CLK_SDIO_STAT          volatile.Register32 // 0x804
}

// Reset Generation Unit (RGU)
type RGU_Type struct {
	_                    [256]byte
	RESET_CTRL0          volatile.Register32 // 0x100
	RESET_CTRL1          volatile.Register32 // 0x104
	_                    [8]byte
	RESET_STATUS0        volatile.Register32 // 0x110
	RESET_STATUS1        volatile.Register32 // 0x114
	RESET_STATUS2        volatile.Register32 // 0x118
	RESET_STATUS3        volatile.Register32 // 0x11C
	_                    [48]byte
	RESET_ACTIVE_STATUS0 volatile.Register32 // 0x150
	RESET_ACTIVE_STATUS1 volatile.Register32 // 0x154
	_                    [684]byte
	RESET_EXT_STAT1      volatile.Register32 // 0x404
	RESET_EXT_STAT2      volatile.Register32 // 0x408
	_                    [8]byte
	RESET_EXT_STAT5      volatile.Register32 // 0x414
	_                    [8]byte
	RESET_EXT_STAT8      volatile.Register32 // 0x420
	RESET_EXT_STAT9      volatile.Register32 // 0x424
	_                    [12]byte
	RESET_EXT_STAT13     volatile.Register32 // 0x434
	_                    [8]byte
	RESET_EXT_STAT16     volatile.Register32 // 0x440
	RESET_EXT_STAT17     volatile.Register32 // 0x444
	RESET_EXT_STAT18     volatile.Register32 // 0x448
	RESET_EXT_STAT19     volatile.Register32 // 0x44C
	RESET_EXT_STAT20     volatile.Register32 // 0x450
	RESET_EXT_STAT21     volatile.Register32 // 0x454
	RESET_EXT_STAT22     volatile.Register32 // 0x458
	_                    [8]byte
	RESET_EXT_STAT25     volatile.Register32 // 0x464
	_                    [4]byte
	RESET_EXT_STAT27     volatile.Register32 // 0x46C
	RESET_EXT_STAT28     volatile.Register32 // 0x470
	RESET_EXT_STAT29     volatile.Register32 // 0x474
	_                    [8]byte
	RESET_EXT_STAT32     volatile.Register32 // 0x480
	RESET_EXT_STAT33     volatile.Register32 // 0x484
	RESET_EXT_STAT34     volatile.Register32 // 0x488
	RESET_EXT_STAT35     volatile.Register32 // 0x48C
	RESET_EXT_STAT36     volatile.Register32 // 0x490
	RESET_EXT_STAT37     volatile.Register32 // 0x494
	RESET_EXT_STAT38     volatile.Register32 // 0x498
	RESET_EXT_STAT39     volatile.Register32 // 0x49C
	RESET_EXT_STAT40     volatile.Register32 // 0x4A0
	RESET_EXT_STAT41     volatile.Register32 // 0x4A4
	RESET_EXT_STAT42     volatile.Register32 // 0x4A8
	_                    [4]byte
	RESET_EXT_STAT44     volatile.Register32 // 0x4B0
	RESET_EXT_STAT45     volatile.Register32 // 0x4B4
	RESET_EXT_STAT46     volatile.Register32 // 0x4B8
	RESET_EXT_STAT47     volatile.Register32 // 0x4BC
	RESET_EXT_STAT48     volatile.Register32 // 0x4C0
	RESET_EXT_STAT49     volatile.Register32 // 0x4C4
	RESET_EXT_STAT50     volatile.Register32 // 0x4C8
	RESET_EXT_STAT51     volatile.Register32 // 0x4CC
	RESET_EXT_STAT52     volatile.Register32 // 0x4D0
	RESET_EXT_STAT53     volatile.Register32 // 0x4D4
	RESET_EXT_STAT54     volatile.Register32 // 0x4D8
	RESET_EXT_STAT55     volatile.Register32 // 0x4DC
}

// Windowed Watchdog timer (WWDT)
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	_       [4]byte
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// USART0_2_3
type USART_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	_             [4]byte
	LSR           volatile.Register32 // 0x14
	_             [4]byte
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	ICR           volatile.Register32 // 0x24
	FDR           volatile.Register32 // 0x28
	OSR           volatile.Register32 // 0x2C
	_             [16]byte
	HDEN          volatile.Register32 // 0x40
	_             [4]byte
	SCICTRL       volatile.Register32 // 0x48
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
	SYNCCTRL      volatile.Register32 // 0x58
	TER           volatile.Register32 // 0x5C
}

// UART1
type UART1_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	MCR           volatile.Register32 // 0x10
	LSR           volatile.Register32 // 0x14
	MSR           volatile.Register32 // 0x18
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	_             [4]byte
	FDR           volatile.Register32 // 0x28
	_             [32]byte
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
	_             [4]byte
	TER           volatile.Register32 // 0x5C
}

// SSP0/1
type SSP_Type struct {
	CR0   volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	DR    volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	CPSR  volatile.Register32 // 0x10
	IMSC  volatile.Register32 // 0x14
	RIS   volatile.Register32 // 0x18
	MIS   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	DMACR volatile.Register32 // 0x24
}

// Timer0/1/2/3
type TIMER_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	CR1  volatile.Register32 // 0x30
	CR2  volatile.Register32 // 0x34
	CR3  volatile.Register32 // 0x38
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
}

// System Control Unit (SCU) I/O configuration
type SCU_Type struct {
	SFSP0_0     volatile.Register32 // 0x0
	SFSP0_1     volatile.Register32 // 0x4
	_           [120]byte
	SFSP1_0     volatile.Register32 // 0x80
	SFSP1_1     volatile.Register32 // 0x84
	SFSP1_2     volatile.Register32 // 0x88
	SFSP1_3     volatile.Register32 // 0x8C
	SFSP1_4     volatile.Register32 // 0x90
	SFSP1_5     volatile.Register32 // 0x94
	SFSP1_6     volatile.Register32 // 0x98
	SFSP1_7     volatile.Register32 // 0x9C
	SFSP1_8     volatile.Register32 // 0xA0
	SFSP1_9     volatile.Register32 // 0xA4
	SFSP1_10    volatile.Register32 // 0xA8
	SFSP1_11    volatile.Register32 // 0xAC
	SFSP1_12    volatile.Register32 // 0xB0
	SFSP1_13    volatile.Register32 // 0xB4
	SFSP1_14    volatile.Register32 // 0xB8
	SFSP1_15    volatile.Register32 // 0xBC
	SFSP1_16    volatile.Register32 // 0xC0
	SFSP1_17    volatile.Register32 // 0xC4
	SFSP1_18    volatile.Register32 // 0xC8
	SFSP1_19    volatile.Register32 // 0xCC
	SFSP1_20    volatile.Register32 // 0xD0
	_           [44]byte
	SFSP2_0     volatile.Register32 // 0x100
	SFSP2_1     volatile.Register32 // 0x104
	SFSP2_2     volatile.Register32 // 0x108
	SFSP2_3     volatile.Register32 // 0x10C
	SFSP2_4     volatile.Register32 // 0x110
	SFSP2_5     volatile.Register32 // 0x114
	SFSP2_6     volatile.Register32 // 0x118
	SFSP2_7     volatile.Register32 // 0x11C
	SFSP2_8     volatile.Register32 // 0x120
	SFSP2_9     volatile.Register32 // 0x124
	SFSP2_10    volatile.Register32 // 0x128
	SFSP2_11    volatile.Register32 // 0x12C
	SFSP2_12    volatile.Register32 // 0x130
	_           [76]byte
	SFSP3_0     volatile.Register32 // 0x180
	SFSP3_1     volatile.Register32 // 0x184
	SFSP3_2     volatile.Register32 // 0x188
	SFSP3_3     volatile.Register32 // 0x18C
	SFSP3_4     volatile.Register32 // 0x190
	SFSP3_5     volatile.Register32 // 0x194
	SFSP3_6     volatile.Register32 // 0x198
	SFSP3_7     volatile.Register32 // 0x19C
	SFSP3_8     volatile.Register32 // 0x1A0
	_           [92]byte
	SFSP4_0     volatile.Register32 // 0x200
	SFSP4_1     volatile.Register32 // 0x204
	SFSP4_2     volatile.Register32 // 0x208
	SFSP4_3     volatile.Register32 // 0x20C
	SFSP4_4     volatile.Register32 // 0x210
	SFSP4_5     volatile.Register32 // 0x214
	SFSP4_6     volatile.Register32 // 0x218
	SFSP4_7     volatile.Register32 // 0x21C
	SFSP4_8     volatile.Register32 // 0x220
	SFSP4_9     volatile.Register32 // 0x224
	SFSP4_10    volatile.Register32 // 0x228
	_           [84]byte
	SFSP5_0     volatile.Register32 // 0x280
	SFSP5_1     volatile.Register32 // 0x284
	SFSP5_2     volatile.Register32 // 0x288
	SFSP5_3     volatile.Register32 // 0x28C
	SFSP5_4     volatile.Register32 // 0x290
	SFSP5_5     volatile.Register32 // 0x294
	SFSP5_6     volatile.Register32 // 0x298
	SFSP5_7     volatile.Register32 // 0x29C
	_           [96]byte
	SFSP6_0     volatile.Register32 // 0x300
	SFSP6_1     volatile.Register32 // 0x304
	SFSP6_2     volatile.Register32 // 0x308
	SFSP6_3     volatile.Register32 // 0x30C
	SFSP6_4     volatile.Register32 // 0x310
	SFSP6_5     volatile.Register32 // 0x314
	SFSP6_6     volatile.Register32 // 0x318
	SFSP6_7     volatile.Register32 // 0x31C
	SFSP6_8     volatile.Register32 // 0x320
	SFSP6_9     volatile.Register32 // 0x324
	SFSP6_10    volatile.Register32 // 0x328
	SFSP6_11    volatile.Register32 // 0x32C
	SFSP6_12    volatile.Register32 // 0x330
	_           [76]byte
	SFSP7_0     volatile.Register32 // 0x380
	SFSP7_1     volatile.Register32 // 0x384
	SFSP7_2     volatile.Register32 // 0x388
	SFSP7_3     volatile.Register32 // 0x38C
	SFSP7_4     volatile.Register32 // 0x390
	SFSP7_5     volatile.Register32 // 0x394
	SFSP7_6     volatile.Register32 // 0x398
	SFSP7_7     volatile.Register32 // 0x39C
	_           [96]byte
	SFSP8_0     volatile.Register32 // 0x400
	SFSP8_1     volatile.Register32 // 0x404
	SFSP8_2     volatile.Register32 // 0x408
	SFSP8_3     volatile.Register32 // 0x40C
	SFSP8_4     volatile.Register32 // 0x410
	SFSP8_5     volatile.Register32 // 0x414
	SFSP8_6     volatile.Register32 // 0x418
	SFSP8_7     volatile.Register32 // 0x41C
	SFSP8_8     volatile.Register32 // 0x420
	_           [92]byte
	SFSP9_0     volatile.Register32 // 0x480
	SFSP9_1     volatile.Register32 // 0x484
	SFSP9_2     volatile.Register32 // 0x488
	SFSP9_3     volatile.Register32 // 0x48C
	SFSP9_4     volatile.Register32 // 0x490
	SFSP9_5     volatile.Register32 // 0x494
	SFSP9_6     volatile.Register32 // 0x498
	_           [100]byte
	SFSPA_0     volatile.Register32 // 0x500
	SFSPA_1     volatile.Register32 // 0x504
	SFSPA_2     volatile.Register32 // 0x508
	SFSPA_3     volatile.Register32 // 0x50C
	SFSPA_4     volatile.Register32 // 0x510
	_           [108]byte
	SFSPB_0     volatile.Register32 // 0x580
	SFSPB_1     volatile.Register32 // 0x584
	SFSPB_2     volatile.Register32 // 0x588
	SFSPB_3     volatile.Register32 // 0x58C
	SFSPB_4     volatile.Register32 // 0x590
	SFSPB_5     volatile.Register32 // 0x594
	SFSPB_6     volatile.Register32 // 0x598
	_           [100]byte
	SFSPC_0     volatile.Register32 // 0x600
	SFSPC_1     volatile.Register32 // 0x604
	SFSPC_2     volatile.Register32 // 0x608
	SFSPC_3     volatile.Register32 // 0x60C
	SFSPC_4     volatile.Register32 // 0x610
	SFSPC_5     volatile.Register32 // 0x614
	SFSPC_6     volatile.Register32 // 0x618
	SFSPC_7     volatile.Register32 // 0x61C
	SFSPC_8     volatile.Register32 // 0x620
	SFSPC_9     volatile.Register32 // 0x624
	SFSPC_10    volatile.Register32 // 0x628
	SFSPC_11    volatile.Register32 // 0x62C
	SFSPC_12    volatile.Register32 // 0x630
	SFSPC_13    volatile.Register32 // 0x634
	SFSPC_14    volatile.Register32 // 0x638
	_           [68]byte
	SFSPD_0     volatile.Register32 // 0x680
	SFSPD_1     volatile.Register32 // 0x684
	SFSPD_2     volatile.Register32 // 0x688
	SFSPD_3     volatile.Register32 // 0x68C
	SFSPD_4     volatile.Register32 // 0x690
	SFSPD_5     volatile.Register32 // 0x694
	SFSPD_6     volatile.Register32 // 0x698
	SFSPD_7     volatile.Register32 // 0x69C
	SFSPD_8     volatile.Register32 // 0x6A0
	SFSPD_9     volatile.Register32 // 0x6A4
	SFSPD_10    volatile.Register32 // 0x6A8
	SFSPD_11    volatile.Register32 // 0x6AC
	SFSPD_12    volatile.Register32 // 0x6B0
	SFSPD_13    volatile.Register32 // 0x6B4
	SFSPD_14    volatile.Register32 // 0x6B8
	SFSPD_15    volatile.Register32 // 0x6BC
	SFSPD_16    volatile.Register32 // 0x6C0
	_           [60]byte
	SFSPE_0     volatile.Register32 // 0x700
	SFSPE_1     volatile.Register32 // 0x704
	SFSPE_2     volatile.Register32 // 0x708
	SFSPE_3     volatile.Register32 // 0x70C
	SFSPE_4     volatile.Register32 // 0x710
	SFSPE_5     volatile.Register32 // 0x714
	SFSPE_6     volatile.Register32 // 0x718
	SFSPE_7     volatile.Register32 // 0x71C
	SFSPE_8     volatile.Register32 // 0x720
	SFSPE_9     volatile.Register32 // 0x724
	SFSPE_10    volatile.Register32 // 0x728
	SFSPE_11    volatile.Register32 // 0x72C
	SFSPE_12    volatile.Register32 // 0x730
	SFSPE_13    volatile.Register32 // 0x734
	SFSPE_14    volatile.Register32 // 0x738
	SFSPE_15    volatile.Register32 // 0x73C
	_           [64]byte
	SFSPF_0     volatile.Register32 // 0x780
	SFSPF_1     volatile.Register32 // 0x784
	SFSPF_2     volatile.Register32 // 0x788
	SFSPF_3     volatile.Register32 // 0x78C
	SFSPF_4     volatile.Register32 // 0x790
	SFSPF_5     volatile.Register32 // 0x794
	SFSPF_6     volatile.Register32 // 0x798
	SFSPF_7     volatile.Register32 // 0x79C
	SFSPF_8     volatile.Register32 // 0x7A0
	SFSPF_9     volatile.Register32 // 0x7A4
	SFSPF_10    volatile.Register32 // 0x7A8
	SFSPF_11    volatile.Register32 // 0x7AC
	_           [1104]byte
	SFSCLK_0    volatile.Register32 // 0xC00
	SFSCLK_1    volatile.Register32 // 0xC04
	SFSCLK_2    volatile.Register32 // 0xC08
	SFSCLK_3    volatile.Register32 // 0xC0C
	_           [112]byte
	SFSUSB      volatile.Register32 // 0xC80
	SFSI2C0     volatile.Register32 // 0xC84
	ENAIO0      volatile.Register32 // 0xC88
	ENAIO1      volatile.Register32 // 0xC8C
	ENAIO2      volatile.Register32 // 0xC90
	_           [108]byte
	EMCDELAYCLK volatile.Register32 // 0xD00
	_           [124]byte
	SDDELAY     volatile.Register32 // 0xD80
	_           [124]byte
	PINTSEL0    volatile.Register32 // 0xE00
	PINTSEL1    volatile.Register32 // 0xE04
}

// GPIO pin interrupt
type GPIO_PIN_INT_Type struct {
	ISEL  volatile.Register32 // 0x0
	IENR  volatile.Register32 // 0x4
	SIENR volatile.Register32 // 0x8
	CIENR volatile.Register32 // 0xC
	IENF  volatile.Register32 // 0x10
	SIENF volatile.Register32 // 0x14
	CIENF volatile.Register32 // 0x18
	RISE  volatile.Register32 // 0x1C
	FALL  volatile.Register32 // 0x20
	IST   volatile.Register32 // 0x24
}

// GPIO group interrupt 0
type GPIO_GROUP_INT0_Type struct {
	CTRL      volatile.Register32 // 0x0
	_         [28]byte
	PORT_POL0 volatile.Register32 // 0x20
	PORT_POL1 volatile.Register32 // 0x24
	PORT_POL2 volatile.Register32 // 0x28
	PORT_POL3 volatile.Register32 // 0x2C
	PORT_POL4 volatile.Register32 // 0x30
	PORT_POL5 volatile.Register32 // 0x34
	PORT_POL6 volatile.Register32 // 0x38
	PORT_POL7 volatile.Register32 // 0x3C
	PORT_ENA0 volatile.Register32 // 0x40
	PORT_ENA1 volatile.Register32 // 0x44
	PORT_ENA2 volatile.Register32 // 0x48
	PORT_ENA3 volatile.Register32 // 0x4C
	PORT_ENA4 volatile.Register32 // 0x50
	PORT_ENA5 volatile.Register32 // 0x54
	PORT_ENA6 volatile.Register32 // 0x58
	PORT_ENA7 volatile.Register32 // 0x5C
}

// Motor Control PWM (MOTOCONPWM)
type MCPWM_Type struct {
	CON        volatile.Register32 // 0x0
	CON_SET    volatile.Register32 // 0x4
	CON_CLR    volatile.Register32 // 0x8
	CAPCON     volatile.Register32 // 0xC
	CAPCON_SET volatile.Register32 // 0x10
	CAPCON_CLR volatile.Register32 // 0x14
	TC0        volatile.Register32 // 0x18
	TC1        volatile.Register32 // 0x1C
	TC2        volatile.Register32 // 0x20
	LIM0       volatile.Register32 // 0x24
	LIM1       volatile.Register32 // 0x28
	LIM2       volatile.Register32 // 0x2C
	MAT0       volatile.Register32 // 0x30
	MAT1       volatile.Register32 // 0x34
	MAT2       volatile.Register32 // 0x38
	DT         volatile.Register32 // 0x3C
	CCP        volatile.Register32 // 0x40
	CAP0       volatile.Register32 // 0x44
	CAP1       volatile.Register32 // 0x48
	CAP2       volatile.Register32 // 0x4C
	INTEN      volatile.Register32 // 0x50
	INTEN_SET  volatile.Register32 // 0x54
	INTEN_CLR  volatile.Register32 // 0x58
	CNTCON     volatile.Register32 // 0x5C
	CNTCON_SET volatile.Register32 // 0x60
	CNTCON_CLR volatile.Register32 // 0x64
	INTF       volatile.Register32 // 0x68
	INTF_SET   volatile.Register32 // 0x6C
	INTF_CLR   volatile.Register32 // 0x70
	CAP_CLR    volatile.Register32 // 0x74
}

// I2C-bus interface
type I2C_Type struct {
	CONSET      volatile.Register32 // 0x0
	STAT        volatile.Register32 // 0x4
	DAT         volatile.Register32 // 0x8
	ADR0        volatile.Register32 // 0xC
	SCLH        volatile.Register32 // 0x10
	SCLL        volatile.Register32 // 0x14
	CONCLR      volatile.Register32 // 0x18
	MMCTRL      volatile.Register32 // 0x1C
	ADR1        volatile.Register32 // 0x20
	ADR2        volatile.Register32 // 0x24
	ADR3        volatile.Register32 // 0x28
	DATA_BUFFER volatile.Register32 // 0x2C
	MASK0       volatile.Register32 // 0x30
	MASK1       volatile.Register32 // 0x34
	MASK2       volatile.Register32 // 0x38
	MASK3       volatile.Register32 // 0x3C
}

// I2S interface
type I2S_Type struct {
	DAO       volatile.Register32 // 0x0
	DAI       volatile.Register32 // 0x4
	TXFIFO    volatile.Register32 // 0x8
	RXFIFO    volatile.Register32 // 0xC
	STATE     volatile.Register32 // 0x10
	DMA1      volatile.Register32 // 0x14
	DMA2      volatile.Register32 // 0x18
	IRQ       volatile.Register32 // 0x1C
	TXRATE    volatile.Register32 // 0x20
	RXRATE    volatile.Register32 // 0x24
	TXBITRATE volatile.Register32 // 0x28
	RXBITRATE volatile.Register32 // 0x2C
	TXMODE    volatile.Register32 // 0x30
	RXMODE    volatile.Register32 // 0x34
}

// C_CAN
type C_CAN1_Type struct {
	CNTL         volatile.Register32 // 0x0
	STAT         volatile.Register32 // 0x4
	EC           volatile.Register32 // 0x8
	BT           volatile.Register32 // 0xC
	INT          volatile.Register32 // 0x10
	TEST         volatile.Register32 // 0x14
	BRPE         volatile.Register32 // 0x18
	_            [4]byte
	IF1_CMDREQ   volatile.Register32 // 0x20
	IF1_CMDMSK_W volatile.Register32 // 0x24
	IF1_MSK1     volatile.Register32 // 0x28
	IF1_MSK2     volatile.Register32 // 0x2C
	IF1_ARB1     volatile.Register32 // 0x30
	IF1_ARB2     volatile.Register32 // 0x34
	IF1_MCTRL    volatile.Register32 // 0x38
	IF1_DA1      volatile.Register32 // 0x3C
	IF1_DA2      volatile.Register32 // 0x40
	IF1_DB1      volatile.Register32 // 0x44
	IF1_DB2      volatile.Register32 // 0x48
	_            [52]byte
	IF2_CMDREQ   volatile.Register32 // 0x80
	IF2_CMDMSK_W volatile.Register32 // 0x84
	IF2_MSK1     volatile.Register32 // 0x88
	IF2_MSK2     volatile.Register32 // 0x8C
	IF2_ARB1     volatile.Register32 // 0x90
	IF2_ARB2     volatile.Register32 // 0x94
	IF2_MCTRL    volatile.Register32 // 0x98
	IF2_DA1      volatile.Register32 // 0x9C
	IF2_DA2      volatile.Register32 // 0xA0
	IF2_DB1      volatile.Register32 // 0xA4
	IF2_DB2      volatile.Register32 // 0xA8
	_            [84]byte
	TXREQ1       volatile.Register32 // 0x100
	TXREQ2       volatile.Register32 // 0x104
	_            [24]byte
	ND1          volatile.Register32 // 0x120
	ND2          volatile.Register32 // 0x124
	_            [24]byte
	IR1          volatile.Register32 // 0x140
	IR2          volatile.Register32 // 0x144
	_            [24]byte
	MSGV1        volatile.Register32 // 0x160
	MSGV2        volatile.Register32 // 0x164
	_            [24]byte
	CLKDIV       volatile.Register32 // 0x180
}

// Repetitive Interrupt Timer (RIT)
type RITIMER_Type struct {
	COMPVAL volatile.Register32 // 0x0
	MASK    volatile.Register32 // 0x4
	CTRL    volatile.Register32 // 0x8
	COUNTER volatile.Register32 // 0xC
}

// Quadrature Encoder Interface (QEI)
type QEI_Type struct {
	CON       volatile.Register32 // 0x0
	STAT      volatile.Register32 // 0x4
	CONF      volatile.Register32 // 0x8
	POS       volatile.Register32 // 0xC
	MAXPOS    volatile.Register32 // 0x10
	CMPOS0    volatile.Register32 // 0x14
	CMPOS1    volatile.Register32 // 0x18
	CMPOS2    volatile.Register32 // 0x1C
	INXCNT    volatile.Register32 // 0x20
	INXCMP0   volatile.Register32 // 0x24
	LOAD      volatile.Register32 // 0x28
	TIME      volatile.Register32 // 0x2C
	VEL       volatile.Register32 // 0x30
	CAP       volatile.Register32 // 0x34
	VELCOMP   volatile.Register32 // 0x38
	FILTERPHA volatile.Register32 // 0x3C
	FILTERPHB volatile.Register32 // 0x40
	FILTERINX volatile.Register32 // 0x44
	WINDOW    volatile.Register32 // 0x48
	INXCMP1   volatile.Register32 // 0x4C
	INXCMP2   volatile.Register32 // 0x50
	_         [3972]byte
	IEC       volatile.Register32 // 0xFD8
	IES       volatile.Register32 // 0xFDC
	INTSTAT   volatile.Register32 // 0xFE0
	IE        volatile.Register32 // 0xFE4
	CLR       volatile.Register32 // 0xFE8
	SET       volatile.Register32 // 0xFEC
}

// Global Input Multiplexer Array (GIMA)
type GIMA_Type struct {
	CAP0_0_IN         volatile.Register32 // 0x0
	CAP0_1_IN         volatile.Register32 // 0x4
	CAP0_2_IN         volatile.Register32 // 0x8
	CAP0_3_IN         volatile.Register32 // 0xC
	CAP1_0_IN         volatile.Register32 // 0x10
	CAP1_1_IN         volatile.Register32 // 0x14
	CAP1_2_IN         volatile.Register32 // 0x18
	CAP1_3_IN         volatile.Register32 // 0x1C
	CAP2_0_IN         volatile.Register32 // 0x20
	CAP2_1_IN         volatile.Register32 // 0x24
	CAP2_2_IN         volatile.Register32 // 0x28
	CAP2_3_IN         volatile.Register32 // 0x2C
	CAP3_0_IN         volatile.Register32 // 0x30
	CAP3_1_IN         volatile.Register32 // 0x34
	CAP3_2_IN         volatile.Register32 // 0x38
	CAP3_3_IN         volatile.Register32 // 0x3C
	CTIN_0_IN         volatile.Register32 // 0x40
	CTIN_1_IN         volatile.Register32 // 0x44
	CTIN_2_IN         volatile.Register32 // 0x48
	CTIN_3_IN         volatile.Register32 // 0x4C
	CTIN_4_IN         volatile.Register32 // 0x50
	CTIN_5_IN         volatile.Register32 // 0x54
	CTIN_6_IN         volatile.Register32 // 0x58
	CTIN_7_IN         volatile.Register32 // 0x5C
	_                 [4]byte
	EVENTROUTER_13_IN volatile.Register32 // 0x64
	EVENTROUTER_14_IN volatile.Register32 // 0x68
	EVENTROUTER_16_IN volatile.Register32 // 0x6C
	ADCSTART0_IN      volatile.Register32 // 0x70
	ADCSTART1_IN      volatile.Register32 // 0x74
}

// Digital-to-Analog Converter (DAC)
type DAC_Type struct {
	CR     volatile.Register32 // 0x0
	CTRL   volatile.Register32 // 0x4
	CNTVAL volatile.Register32 // 0x8
}

// 10-bit Analog-to-Digital Converter (ADC)
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	GDR   volatile.Register32 // 0x4
	_     [4]byte
	INTEN volatile.Register32    // 0xC
	DR    [8]volatile.Register32 // 0x10
	STAT  volatile.Register32    // 0x30
}

// GPIO port
type GPIO_PORT_Type struct {
	B     [256]volatile.Register8 // 0x0
	_     [3840]byte
	W     [256]volatile.Register32 // 0x1000
	_     [3072]byte
	DIR0  volatile.Register32 // 0x2000
	DIR1  volatile.Register32 // 0x2004
	DIR2  volatile.Register32 // 0x2008
	DIR3  volatile.Register32 // 0x200C
	DIR4  volatile.Register32 // 0x2010
	DIR5  volatile.Register32 // 0x2014
	DIR6  volatile.Register32 // 0x2018
	DIR7  volatile.Register32 // 0x201C
	_     [96]byte
	MASK0 volatile.Register32 // 0x2080
	MASK1 volatile.Register32 // 0x2084
	MASK2 volatile.Register32 // 0x2088
	MASK3 volatile.Register32 // 0x208C
	MASK4 volatile.Register32 // 0x2090
	MASK5 volatile.Register32 // 0x2094
	MASK6 volatile.Register32 // 0x2098
	MASK7 volatile.Register32 // 0x209C
	_     [96]byte
	PIN0  volatile.Register32 // 0x2100
	PIN1  volatile.Register32 // 0x2104
	PIN2  volatile.Register32 // 0x2108
	PIN3  volatile.Register32 // 0x210C
	PIN4  volatile.Register32 // 0x2110
	PIN5  volatile.Register32 // 0x2114
	PIN6  volatile.Register32 // 0x2118
	PIN7  volatile.Register32 // 0x211C
	_     [96]byte
	MPIN0 volatile.Register32 // 0x2180
	MPIN1 volatile.Register32 // 0x2184
	MPIN2 volatile.Register32 // 0x2188
	MPIN3 volatile.Register32 // 0x218C
	MPIN4 volatile.Register32 // 0x2190
	MPIN5 volatile.Register32 // 0x2194
	MPIN6 volatile.Register32 // 0x2198
	MPIN7 volatile.Register32 // 0x219C
	_     [96]byte
	SET0  volatile.Register32 // 0x2200
	SET1  volatile.Register32 // 0x2204
	SET2  volatile.Register32 // 0x2208
	SET3  volatile.Register32 // 0x220C
	SET4  volatile.Register32 // 0x2210
	SET5  volatile.Register32 // 0x2214
	SET6  volatile.Register32 // 0x2218
	SET7  volatile.Register32 // 0x221C
	_     [96]byte
	CLR0  volatile.Register32 // 0x2280
	CLR1  volatile.Register32 // 0x2284
	CLR2  volatile.Register32 // 0x2288
	CLR3  volatile.Register32 // 0x228C
	CLR4  volatile.Register32 // 0x2290
	CLR5  volatile.Register32 // 0x2294
	CLR6  volatile.Register32 // 0x2298
	CLR7  volatile.Register32 // 0x229C
	_     [96]byte
	NOT0  volatile.Register32 // 0x2300
	NOT1  volatile.Register32 // 0x2304
	NOT2  volatile.Register32 // 0x2308
	NOT3  volatile.Register32 // 0x230C
	NOT4  volatile.Register32 // 0x2310
	NOT5  volatile.Register32 // 0x2314
	NOT6  volatile.Register32 // 0x2318
	NOT7  volatile.Register32 // 0x231C
}

// Bitfields for SCT: State Configurable Timer (SCT) with dither engine
const (
	// CONFIG: SCT configuration register
	// Position of UNIFY field.
	SCT_CONFIG_UNIFY_Pos = 0x0
	// Bit mask of UNIFY field.
	SCT_CONFIG_UNIFY_Msk = 0x1
	// Bit UNIFY.
	SCT_CONFIG_UNIFY = 0x1
	// 16-bit.The SCT operates as two 16-bit counters named L and H.
	SCT_CONFIG_UNIFY_16_BIT = 0x0
	// 32-bit. The SCT operates as a unified 32-bit counter.
	SCT_CONFIG_UNIFY_32_BIT = 0x1
	// Position of CLKMODE field.
	SCT_CONFIG_CLKMODE_Pos = 0x1
	// Bit mask of CLKMODE field.
	SCT_CONFIG_CLKMODE_Msk = 0x6
	// Bus clock. The bus clock clocks the SCT and prescalers.
	SCT_CONFIG_CLKMODE_BUS_CLOCK = 0x0
	// Prescaled bus clock. The SCT clock is the bus clock, but the prescalers are enabled to count only when sampling of the input selected by the CKSEL field finds the selected edge. The minimum pulse width on the clock input is 1 bus clock period. This mode is the high-performance sampled-clock mode.
	SCT_CONFIG_CLKMODE_PRESCALED_BUS_CLOCK = 0x1
	// SCT Input. The input selected by CKSEL clocks the SCT and prescalers. The input is synchronized to the bus clock and possibly inverted. The minimum pulse width on the clock input is 1 bus clock period. This mode is the low-power sampled-clock mode.
	SCT_CONFIG_CLKMODE_SCT_INPUT = 0x2
	// Position of CKSEL field.
	SCT_CONFIG_CKSEL_Pos = 0x3
	// Bit mask of CKSEL field.
	SCT_CONFIG_CKSEL_Msk = 0x78
	// Position of NORELAOD_L field.
	SCT_CONFIG_NORELAOD_L_Pos = 0x7
	// Bit mask of NORELAOD_L field.
	SCT_CONFIG_NORELAOD_L_Msk = 0x80
	// Bit NORELAOD_L.
	SCT_CONFIG_NORELAOD_L = 0x80
	// Position of NORELOAD_H field.
	SCT_CONFIG_NORELOAD_H_Pos = 0x8
	// Bit mask of NORELOAD_H field.
	SCT_CONFIG_NORELOAD_H_Msk = 0x100
	// Bit NORELOAD_H.
	SCT_CONFIG_NORELOAD_H = 0x100
	// Position of INSYNC field.
	SCT_CONFIG_INSYNC_Pos = 0x9
	// Bit mask of INSYNC field.
	SCT_CONFIG_INSYNC_Msk = 0x1fe00
	// Position of AUTOLIMIT_L field.
	SCT_CONFIG_AUTOLIMIT_L_Pos = 0x11
	// Bit mask of AUTOLIMIT_L field.
	SCT_CONFIG_AUTOLIMIT_L_Msk = 0x20000
	// Bit AUTOLIMIT_L.
	SCT_CONFIG_AUTOLIMIT_L = 0x20000
	// Position of AUTOLIMIT_H field.
	SCT_CONFIG_AUTOLIMIT_H_Pos = 0x12
	// Bit mask of AUTOLIMIT_H field.
	SCT_CONFIG_AUTOLIMIT_H_Msk = 0x40000
	// Bit AUTOLIMIT_H.
	SCT_CONFIG_AUTOLIMIT_H = 0x40000
	// Position of RESERVED field.
	SCT_CONFIG_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	SCT_CONFIG_RESERVED_Msk = 0xfff80000

	// CTRL: SCT control register
	// Position of DOWN_L field.
	SCT_CTRL_DOWN_L_Pos = 0x0
	// Bit mask of DOWN_L field.
	SCT_CTRL_DOWN_L_Msk = 0x1
	// Bit DOWN_L.
	SCT_CTRL_DOWN_L = 0x1
	// Position of STOP_L field.
	SCT_CTRL_STOP_L_Pos = 0x1
	// Bit mask of STOP_L field.
	SCT_CTRL_STOP_L_Msk = 0x2
	// Bit STOP_L.
	SCT_CTRL_STOP_L = 0x2
	// Position of HALT_L field.
	SCT_CTRL_HALT_L_Pos = 0x2
	// Bit mask of HALT_L field.
	SCT_CTRL_HALT_L_Msk = 0x4
	// Bit HALT_L.
	SCT_CTRL_HALT_L = 0x4
	// Position of CLRCTR_L field.
	SCT_CTRL_CLRCTR_L_Pos = 0x3
	// Bit mask of CLRCTR_L field.
	SCT_CTRL_CLRCTR_L_Msk = 0x8
	// Bit CLRCTR_L.
	SCT_CTRL_CLRCTR_L = 0x8
	// Position of BIDIR_L field.
	SCT_CTRL_BIDIR_L_Pos = 0x4
	// Bit mask of BIDIR_L field.
	SCT_CTRL_BIDIR_L_Msk = 0x10
	// Bit BIDIR_L.
	SCT_CTRL_BIDIR_L = 0x10
	// Up. The counter counts up to its limit condition, then is cleared to zero.
	SCT_CTRL_BIDIR_L_UP = 0x0
	// Up-down. The counter counts up to its limit, then counts down to a limit condition or to 0.
	SCT_CTRL_BIDIR_L_UPDOWN = 0x1
	// Position of PRE_L field.
	SCT_CTRL_PRE_L_Pos = 0x5
	// Bit mask of PRE_L field.
	SCT_CTRL_PRE_L_Msk = 0x1fe0
	// Position of RESERVED field.
	SCT_CTRL_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SCT_CTRL_RESERVED_Msk = 0xe000
	// Position of DOWN_H field.
	SCT_CTRL_DOWN_H_Pos = 0x10
	// Bit mask of DOWN_H field.
	SCT_CTRL_DOWN_H_Msk = 0x10000
	// Bit DOWN_H.
	SCT_CTRL_DOWN_H = 0x10000
	// Position of STOP_H field.
	SCT_CTRL_STOP_H_Pos = 0x11
	// Bit mask of STOP_H field.
	SCT_CTRL_STOP_H_Msk = 0x20000
	// Bit STOP_H.
	SCT_CTRL_STOP_H = 0x20000
	// Position of HALT_H field.
	SCT_CTRL_HALT_H_Pos = 0x12
	// Bit mask of HALT_H field.
	SCT_CTRL_HALT_H_Msk = 0x40000
	// Bit HALT_H.
	SCT_CTRL_HALT_H = 0x40000
	// Position of CLRCTR_H field.
	SCT_CTRL_CLRCTR_H_Pos = 0x13
	// Bit mask of CLRCTR_H field.
	SCT_CTRL_CLRCTR_H_Msk = 0x80000
	// Bit CLRCTR_H.
	SCT_CTRL_CLRCTR_H = 0x80000
	// Position of BIDIR_H field.
	SCT_CTRL_BIDIR_H_Pos = 0x14
	// Bit mask of BIDIR_H field.
	SCT_CTRL_BIDIR_H_Msk = 0x100000
	// Bit BIDIR_H.
	SCT_CTRL_BIDIR_H = 0x100000
	// Up. The H counter counts up to its limit condition, then is cleared to zero.
	SCT_CTRL_BIDIR_H_UP = 0x0
	// Up-down. The H counter counts up to its limit, then counts down to a limit condition or to 0.
	SCT_CTRL_BIDIR_H_UPDOWN = 0x1
	// Position of PRE_H field.
	SCT_CTRL_PRE_H_Pos = 0x15
	// Bit mask of PRE_H field.
	SCT_CTRL_PRE_H_Msk = 0x1fe00000
	// Position of RESERVED field.
	SCT_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	SCT_CTRL_RESERVED_Msk = 0xe0000000

	// LIMIT: SCT limit register
	// Position of LIMMSK_L field.
	SCT_LIMIT_LIMMSK_L_Pos = 0x0
	// Bit mask of LIMMSK_L field.
	SCT_LIMIT_LIMMSK_L_Msk = 0xffff
	// Position of LIMMSK_H field.
	SCT_LIMIT_LIMMSK_H_Pos = 0x10
	// Bit mask of LIMMSK_H field.
	SCT_LIMIT_LIMMSK_H_Msk = 0xffff0000

	// HALT: SCT halt condition register
	// Position of HALTMSK_L field.
	SCT_HALT_HALTMSK_L_Pos = 0x0
	// Bit mask of HALTMSK_L field.
	SCT_HALT_HALTMSK_L_Msk = 0xffff
	// Position of HALTMSK_H field.
	SCT_HALT_HALTMSK_H_Pos = 0x10
	// Bit mask of HALTMSK_H field.
	SCT_HALT_HALTMSK_H_Msk = 0xffff0000

	// STOP: SCT stop condition register
	// Position of STOPMSK_L field.
	SCT_STOP_STOPMSK_L_Pos = 0x0
	// Bit mask of STOPMSK_L field.
	SCT_STOP_STOPMSK_L_Msk = 0xffff
	// Position of STOPMSK_H field.
	SCT_STOP_STOPMSK_H_Pos = 0x10
	// Bit mask of STOPMSK_H field.
	SCT_STOP_STOPMSK_H_Msk = 0xffff0000

	// START: SCT start condition register
	// Position of STARTMSK_L field.
	SCT_START_STARTMSK_L_Pos = 0x0
	// Bit mask of STARTMSK_L field.
	SCT_START_STARTMSK_L_Msk = 0xffff
	// Position of STARTMSK_H field.
	SCT_START_STARTMSK_H_Pos = 0x10
	// Bit mask of STARTMSK_H field.
	SCT_START_STARTMSK_H_Msk = 0xffff0000

	// DITHER: SCT dither condition register
	// Position of DITHMSK_L field.
	SCT_DITHER_DITHMSK_L_Pos = 0x0
	// Bit mask of DITHMSK_L field.
	SCT_DITHER_DITHMSK_L_Msk = 0xffff
	// Position of DITHMSK_H field.
	SCT_DITHER_DITHMSK_H_Pos = 0x10
	// Bit mask of DITHMSK_H field.
	SCT_DITHER_DITHMSK_H_Msk = 0xffff0000

	// COUNT: SCT counter register
	// Position of CTR_L field.
	SCT_COUNT_CTR_L_Pos = 0x0
	// Bit mask of CTR_L field.
	SCT_COUNT_CTR_L_Msk = 0xffff
	// Position of CTR_H field.
	SCT_COUNT_CTR_H_Pos = 0x10
	// Bit mask of CTR_H field.
	SCT_COUNT_CTR_H_Msk = 0xffff0000

	// STATE: SCT state register
	// Position of STATE_L field.
	SCT_STATE_STATE_L_Pos = 0x0
	// Bit mask of STATE_L field.
	SCT_STATE_STATE_L_Msk = 0x1f
	// Position of RESERVED field.
	SCT_STATE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCT_STATE_RESERVED_Msk = 0xffe0
	// Position of STATE_H field.
	SCT_STATE_STATE_H_Pos = 0x10
	// Bit mask of STATE_H field.
	SCT_STATE_STATE_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT_STATE_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT_STATE_RESERVED_Msk = 0xffe00000

	// INPUT: SCT input register
	// Position of AIN0 field.
	SCT_INPUT_AIN0_Pos = 0x0
	// Bit mask of AIN0 field.
	SCT_INPUT_AIN0_Msk = 0x1
	// Bit AIN0.
	SCT_INPUT_AIN0 = 0x1
	// Position of AIN1 field.
	SCT_INPUT_AIN1_Pos = 0x1
	// Bit mask of AIN1 field.
	SCT_INPUT_AIN1_Msk = 0x2
	// Bit AIN1.
	SCT_INPUT_AIN1 = 0x2
	// Position of AIN2 field.
	SCT_INPUT_AIN2_Pos = 0x2
	// Bit mask of AIN2 field.
	SCT_INPUT_AIN2_Msk = 0x4
	// Bit AIN2.
	SCT_INPUT_AIN2 = 0x4
	// Position of AIN3 field.
	SCT_INPUT_AIN3_Pos = 0x3
	// Bit mask of AIN3 field.
	SCT_INPUT_AIN3_Msk = 0x8
	// Bit AIN3.
	SCT_INPUT_AIN3 = 0x8
	// Position of AIN4 field.
	SCT_INPUT_AIN4_Pos = 0x4
	// Bit mask of AIN4 field.
	SCT_INPUT_AIN4_Msk = 0x10
	// Bit AIN4.
	SCT_INPUT_AIN4 = 0x10
	// Position of AIN5 field.
	SCT_INPUT_AIN5_Pos = 0x5
	// Bit mask of AIN5 field.
	SCT_INPUT_AIN5_Msk = 0x20
	// Bit AIN5.
	SCT_INPUT_AIN5 = 0x20
	// Position of AIN6 field.
	SCT_INPUT_AIN6_Pos = 0x6
	// Bit mask of AIN6 field.
	SCT_INPUT_AIN6_Msk = 0x40
	// Bit AIN6.
	SCT_INPUT_AIN6 = 0x40
	// Position of AIN7 field.
	SCT_INPUT_AIN7_Pos = 0x7
	// Bit mask of AIN7 field.
	SCT_INPUT_AIN7_Msk = 0x80
	// Bit AIN7.
	SCT_INPUT_AIN7 = 0x80
	// Position of RESERVED field.
	SCT_INPUT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCT_INPUT_RESERVED_Msk = 0xff00
	// Position of SIN0 field.
	SCT_INPUT_SIN0_Pos = 0x10
	// Bit mask of SIN0 field.
	SCT_INPUT_SIN0_Msk = 0x10000
	// Bit SIN0.
	SCT_INPUT_SIN0 = 0x10000
	// Position of SIN1 field.
	SCT_INPUT_SIN1_Pos = 0x11
	// Bit mask of SIN1 field.
	SCT_INPUT_SIN1_Msk = 0x20000
	// Bit SIN1.
	SCT_INPUT_SIN1 = 0x20000
	// Position of SIN2 field.
	SCT_INPUT_SIN2_Pos = 0x12
	// Bit mask of SIN2 field.
	SCT_INPUT_SIN2_Msk = 0x40000
	// Bit SIN2.
	SCT_INPUT_SIN2 = 0x40000
	// Position of SIN3 field.
	SCT_INPUT_SIN3_Pos = 0x13
	// Bit mask of SIN3 field.
	SCT_INPUT_SIN3_Msk = 0x80000
	// Bit SIN3.
	SCT_INPUT_SIN3 = 0x80000
	// Position of SIN4 field.
	SCT_INPUT_SIN4_Pos = 0x14
	// Bit mask of SIN4 field.
	SCT_INPUT_SIN4_Msk = 0x100000
	// Bit SIN4.
	SCT_INPUT_SIN4 = 0x100000
	// Position of SIN5 field.
	SCT_INPUT_SIN5_Pos = 0x15
	// Bit mask of SIN5 field.
	SCT_INPUT_SIN5_Msk = 0x200000
	// Bit SIN5.
	SCT_INPUT_SIN5 = 0x200000
	// Position of SIN6 field.
	SCT_INPUT_SIN6_Pos = 0x16
	// Bit mask of SIN6 field.
	SCT_INPUT_SIN6_Msk = 0x400000
	// Bit SIN6.
	SCT_INPUT_SIN6 = 0x400000
	// Position of SIN7 field.
	SCT_INPUT_SIN7_Pos = 0x17
	// Bit mask of SIN7 field.
	SCT_INPUT_SIN7_Msk = 0x800000
	// Bit SIN7.
	SCT_INPUT_SIN7 = 0x800000
	// Position of RESERVED field.
	SCT_INPUT_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SCT_INPUT_RESERVED_Msk = 0xff000000

	// REGMODE: SCT match/capture registers mode register
	// Position of REGMOD_L field.
	SCT_REGMODE_REGMOD_L_Pos = 0x0
	// Bit mask of REGMOD_L field.
	SCT_REGMODE_REGMOD_L_Msk = 0xffff
	// Position of REGMOD_H field.
	SCT_REGMODE_REGMOD_H_Pos = 0x10
	// Bit mask of REGMOD_H field.
	SCT_REGMODE_REGMOD_H_Msk = 0xffff0000

	// OUTPUT: SCT output register
	// Position of OUT field.
	SCT_OUTPUT_OUT_Pos = 0x0
	// Bit mask of OUT field.
	SCT_OUTPUT_OUT_Msk = 0xffff
	// Position of RESERVED field.
	SCT_OUTPUT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT_OUTPUT_RESERVED_Msk = 0xffff0000

	// OUTPUTDIRCTRL: SCT output counter direction control register
	// Position of SETCLR0 field.
	SCT_OUTPUTDIRCTRL_SETCLR0_Pos = 0x0
	// Bit mask of SETCLR0 field.
	SCT_OUTPUTDIRCTRL_SETCLR0_Msk = 0x3
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR0_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR0_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR0_H_COUNTER = 0x2
	// Position of SETCLR1 field.
	SCT_OUTPUTDIRCTRL_SETCLR1_Pos = 0x2
	// Bit mask of SETCLR1 field.
	SCT_OUTPUTDIRCTRL_SETCLR1_Msk = 0xc
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR1_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR1_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR1_H_COUNTER = 0x2
	// Position of SETCLR2 field.
	SCT_OUTPUTDIRCTRL_SETCLR2_Pos = 0x4
	// Bit mask of SETCLR2 field.
	SCT_OUTPUTDIRCTRL_SETCLR2_Msk = 0x30
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR2_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR2_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR2_H_COUNTER = 0x2
	// Position of SETCLR3 field.
	SCT_OUTPUTDIRCTRL_SETCLR3_Pos = 0x6
	// Bit mask of SETCLR3 field.
	SCT_OUTPUTDIRCTRL_SETCLR3_Msk = 0xc0
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR3_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR3_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR3_H_COUNTER = 0x2
	// Position of SETCLR4 field.
	SCT_OUTPUTDIRCTRL_SETCLR4_Pos = 0x8
	// Bit mask of SETCLR4 field.
	SCT_OUTPUTDIRCTRL_SETCLR4_Msk = 0x300
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR4_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR4_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR4_H_COUNTER = 0x2
	// Position of SETCLR5 field.
	SCT_OUTPUTDIRCTRL_SETCLR5_Pos = 0xa
	// Bit mask of SETCLR5 field.
	SCT_OUTPUTDIRCTRL_SETCLR5_Msk = 0xc00
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR5_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR5_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR5_H_COUNTER = 0x2
	// Position of SETCLR6 field.
	SCT_OUTPUTDIRCTRL_SETCLR6_Pos = 0xc
	// Bit mask of SETCLR6 field.
	SCT_OUTPUTDIRCTRL_SETCLR6_Msk = 0x3000
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR6_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR6_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR6_H_COUNTER = 0x2
	// Position of SETCLR7 field.
	SCT_OUTPUTDIRCTRL_SETCLR7_Pos = 0xe
	// Bit mask of SETCLR7 field.
	SCT_OUTPUTDIRCTRL_SETCLR7_Msk = 0xc000
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR7_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR7_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR7_H_COUNTER = 0x2
	// Position of SETCLR8 field.
	SCT_OUTPUTDIRCTRL_SETCLR8_Pos = 0x10
	// Bit mask of SETCLR8 field.
	SCT_OUTPUTDIRCTRL_SETCLR8_Msk = 0x30000
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR8_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR8_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR8_H_COUNTER = 0x2
	// Position of SETCLR9 field.
	SCT_OUTPUTDIRCTRL_SETCLR9_Pos = 0x12
	// Bit mask of SETCLR9 field.
	SCT_OUTPUTDIRCTRL_SETCLR9_Msk = 0xc0000
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR9_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR9_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR9_H_COUNTER = 0x2
	// Position of SETCLR10 field.
	SCT_OUTPUTDIRCTRL_SETCLR10_Pos = 0x14
	// Bit mask of SETCLR10 field.
	SCT_OUTPUTDIRCTRL_SETCLR10_Msk = 0x300000
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR10_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR10_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR10_H_COUNTER = 0x2
	// Position of SETCLR11 field.
	SCT_OUTPUTDIRCTRL_SETCLR11_Pos = 0x16
	// Bit mask of SETCLR11 field.
	SCT_OUTPUTDIRCTRL_SETCLR11_Msk = 0xc00000
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR11_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR11_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR11_H_COUNTER = 0x2
	// Position of SETCLR12 field.
	SCT_OUTPUTDIRCTRL_SETCLR12_Pos = 0x18
	// Bit mask of SETCLR12 field.
	SCT_OUTPUTDIRCTRL_SETCLR12_Msk = 0x3000000
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR12_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR12_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR12_H_COUNTER = 0x2
	// Position of SETCLR13 field.
	SCT_OUTPUTDIRCTRL_SETCLR13_Pos = 0x1a
	// Bit mask of SETCLR13 field.
	SCT_OUTPUTDIRCTRL_SETCLR13_Msk = 0xc000000
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR13_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR13_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR13_H_COUNTER = 0x2
	// Position of SETCLR14 field.
	SCT_OUTPUTDIRCTRL_SETCLR14_Pos = 0x1c
	// Bit mask of SETCLR14 field.
	SCT_OUTPUTDIRCTRL_SETCLR14_Msk = 0x30000000
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR14_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR14_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR14_H_COUNTER = 0x2
	// Position of SETCLR15 field.
	SCT_OUTPUTDIRCTRL_SETCLR15_Pos = 0x1e
	// Bit mask of SETCLR15 field.
	SCT_OUTPUTDIRCTRL_SETCLR15_Msk = 0xc0000000
	// Independent. Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR15_INDEPENDENT = 0x0
	// L counter. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT_OUTPUTDIRCTRL_SETCLR15_L_COUNTER = 0x1
	// H counter. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT_OUTPUTDIRCTRL_SETCLR15_H_COUNTER = 0x2

	// RES: SCT conflict resolution register
	// Position of O0RES field.
	SCT_RES_O0RES_Pos = 0x0
	// Bit mask of O0RES field.
	SCT_RES_O0RES_Msk = 0x3
	// No change.
	SCT_RES_O0RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR0 field).
	SCT_RES_O0RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR0 field).
	SCT_RES_O0RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O0RES_TOGGLE_OUTPUT = 0x3
	// Position of O1RES field.
	SCT_RES_O1RES_Pos = 0x2
	// Bit mask of O1RES field.
	SCT_RES_O1RES_Msk = 0xc
	// No change.
	SCT_RES_O1RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR1 field).
	SCT_RES_O1RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR1 field).
	SCT_RES_O1RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O1RES_TOGGLE_OUTPUT = 0x3
	// Position of O2RES field.
	SCT_RES_O2RES_Pos = 0x4
	// Bit mask of O2RES field.
	SCT_RES_O2RES_Msk = 0x30
	// No change.
	SCT_RES_O2RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR2 field).
	SCT_RES_O2RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output n (or set based on the SETCLR2 field).
	SCT_RES_O2RES_CLEAR_OUTPUT_N_OR_S = 0x2
	// Toggle output.
	SCT_RES_O2RES_TOGGLE_OUTPUT = 0x3
	// Position of O3RES field.
	SCT_RES_O3RES_Pos = 0x6
	// Bit mask of O3RES field.
	SCT_RES_O3RES_Msk = 0xc0
	// No change.
	SCT_RES_O3RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR3 field).
	SCT_RES_O3RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR3 field).
	SCT_RES_O3RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O3RES_TOGGLE_OUTPUT = 0x3
	// Position of O4RES field.
	SCT_RES_O4RES_Pos = 0x8
	// Bit mask of O4RES field.
	SCT_RES_O4RES_Msk = 0x300
	// No change.
	SCT_RES_O4RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR4 field).
	SCT_RES_O4RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR4 field).
	SCT_RES_O4RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O4RES_TOGGLE_OUTPUT = 0x3
	// Position of O5RES field.
	SCT_RES_O5RES_Pos = 0xa
	// Bit mask of O5RES field.
	SCT_RES_O5RES_Msk = 0xc00
	// No change.
	SCT_RES_O5RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR5 field).
	SCT_RES_O5RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR5 field).
	SCT_RES_O5RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O5RES_TOGGLE_OUTPUT = 0x3
	// Position of O6RES field.
	SCT_RES_O6RES_Pos = 0xc
	// Bit mask of O6RES field.
	SCT_RES_O6RES_Msk = 0x3000
	// No change.
	SCT_RES_O6RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR6 field).
	SCT_RES_O6RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR6 field).
	SCT_RES_O6RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O6RES_TOGGLE_OUTPUT = 0x3
	// Position of O7RES field.
	SCT_RES_O7RES_Pos = 0xe
	// Bit mask of O7RES field.
	SCT_RES_O7RES_Msk = 0xc000
	// No change.
	SCT_RES_O7RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR7 field).
	SCT_RES_O7RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR7 field).
	SCT_RES_O7RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O7RES_TOGGLE_OUTPUT = 0x3
	// Position of O8RES field.
	SCT_RES_O8RES_Pos = 0x10
	// Bit mask of O8RES field.
	SCT_RES_O8RES_Msk = 0x30000
	// No change.
	SCT_RES_O8RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR8 field).
	SCT_RES_O8RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR8 field).
	SCT_RES_O8RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O8RES_TOGGLE_OUTPUT = 0x3
	// Position of O9RES field.
	SCT_RES_O9RES_Pos = 0x12
	// Bit mask of O9RES field.
	SCT_RES_O9RES_Msk = 0xc0000
	// No change.
	SCT_RES_O9RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR9 field).
	SCT_RES_O9RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR9 field).
	SCT_RES_O9RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O9RES_TOGGLE_OUTPUT = 0x3
	// Position of O10RES field.
	SCT_RES_O10RES_Pos = 0x14
	// Bit mask of O10RES field.
	SCT_RES_O10RES_Msk = 0x300000
	// No change.
	SCT_RES_O10RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR10 field).
	SCT_RES_O10RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR10 field).
	SCT_RES_O10RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O10RES_TOGGLE_OUTPUT = 0x3
	// Position of O11RES field.
	SCT_RES_O11RES_Pos = 0x16
	// Bit mask of O11RES field.
	SCT_RES_O11RES_Msk = 0xc00000
	// No change.
	SCT_RES_O11RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR11 field).
	SCT_RES_O11RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR11 field).
	SCT_RES_O11RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O11RES_TOGGLE_OUTPUT = 0x3
	// Position of O12RES field.
	SCT_RES_O12RES_Pos = 0x18
	// Bit mask of O12RES field.
	SCT_RES_O12RES_Msk = 0x3000000
	// No change.
	SCT_RES_O12RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR12 field).
	SCT_RES_O12RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR12 field).
	SCT_RES_O12RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O12RES_TOGGLE_OUTPUT = 0x3
	// Position of O13RES field.
	SCT_RES_O13RES_Pos = 0x1a
	// Bit mask of O13RES field.
	SCT_RES_O13RES_Msk = 0xc000000
	// No change.
	SCT_RES_O13RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR13 field).
	SCT_RES_O13RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR13 field).
	SCT_RES_O13RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O13RES_TOGGLE_OUTPUT = 0x3
	// Position of O14RES field.
	SCT_RES_O14RES_Pos = 0x1c
	// Bit mask of O14RES field.
	SCT_RES_O14RES_Msk = 0x30000000
	// No change.
	SCT_RES_O14RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR14 field).
	SCT_RES_O14RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR14 field).
	SCT_RES_O14RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O14RES_TOGGLE_OUTPUT = 0x3
	// Position of O15RES field.
	SCT_RES_O15RES_Pos = 0x1e
	// Bit mask of O15RES field.
	SCT_RES_O15RES_Msk = 0xc0000000
	// No change.
	SCT_RES_O15RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR15 field).
	SCT_RES_O15RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR15 field).
	SCT_RES_O15RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O15RES_TOGGLE_OUTPUT = 0x3

	// DMAREQ0: SCT DMA request 0 register
	// Position of DEV_00 field.
	SCT_DMAREQ0_DEV_00_Pos = 0x0
	// Bit mask of DEV_00 field.
	SCT_DMAREQ0_DEV_00_Msk = 0x1
	// Bit DEV_00.
	SCT_DMAREQ0_DEV_00 = 0x1
	// Position of DEV_01 field.
	SCT_DMAREQ0_DEV_01_Pos = 0x1
	// Bit mask of DEV_01 field.
	SCT_DMAREQ0_DEV_01_Msk = 0x2
	// Bit DEV_01.
	SCT_DMAREQ0_DEV_01 = 0x2
	// Position of DEV_02 field.
	SCT_DMAREQ0_DEV_02_Pos = 0x2
	// Bit mask of DEV_02 field.
	SCT_DMAREQ0_DEV_02_Msk = 0x4
	// Bit DEV_02.
	SCT_DMAREQ0_DEV_02 = 0x4
	// Position of DEV_03 field.
	SCT_DMAREQ0_DEV_03_Pos = 0x3
	// Bit mask of DEV_03 field.
	SCT_DMAREQ0_DEV_03_Msk = 0x8
	// Bit DEV_03.
	SCT_DMAREQ0_DEV_03 = 0x8
	// Position of DEV_04 field.
	SCT_DMAREQ0_DEV_04_Pos = 0x4
	// Bit mask of DEV_04 field.
	SCT_DMAREQ0_DEV_04_Msk = 0x10
	// Bit DEV_04.
	SCT_DMAREQ0_DEV_04 = 0x10
	// Position of DEV_05 field.
	SCT_DMAREQ0_DEV_05_Pos = 0x5
	// Bit mask of DEV_05 field.
	SCT_DMAREQ0_DEV_05_Msk = 0x20
	// Bit DEV_05.
	SCT_DMAREQ0_DEV_05 = 0x20
	// Position of DEV_06 field.
	SCT_DMAREQ0_DEV_06_Pos = 0x6
	// Bit mask of DEV_06 field.
	SCT_DMAREQ0_DEV_06_Msk = 0x40
	// Bit DEV_06.
	SCT_DMAREQ0_DEV_06 = 0x40
	// Position of DEV_07 field.
	SCT_DMAREQ0_DEV_07_Pos = 0x7
	// Bit mask of DEV_07 field.
	SCT_DMAREQ0_DEV_07_Msk = 0x80
	// Bit DEV_07.
	SCT_DMAREQ0_DEV_07 = 0x80
	// Position of DEV_08 field.
	SCT_DMAREQ0_DEV_08_Pos = 0x8
	// Bit mask of DEV_08 field.
	SCT_DMAREQ0_DEV_08_Msk = 0x100
	// Bit DEV_08.
	SCT_DMAREQ0_DEV_08 = 0x100
	// Position of DEV_09 field.
	SCT_DMAREQ0_DEV_09_Pos = 0x9
	// Bit mask of DEV_09 field.
	SCT_DMAREQ0_DEV_09_Msk = 0x200
	// Bit DEV_09.
	SCT_DMAREQ0_DEV_09 = 0x200
	// Position of DEV_010 field.
	SCT_DMAREQ0_DEV_010_Pos = 0xa
	// Bit mask of DEV_010 field.
	SCT_DMAREQ0_DEV_010_Msk = 0x400
	// Bit DEV_010.
	SCT_DMAREQ0_DEV_010 = 0x400
	// Position of DEV_011 field.
	SCT_DMAREQ0_DEV_011_Pos = 0xb
	// Bit mask of DEV_011 field.
	SCT_DMAREQ0_DEV_011_Msk = 0x800
	// Bit DEV_011.
	SCT_DMAREQ0_DEV_011 = 0x800
	// Position of DEV_012 field.
	SCT_DMAREQ0_DEV_012_Pos = 0xc
	// Bit mask of DEV_012 field.
	SCT_DMAREQ0_DEV_012_Msk = 0x1000
	// Bit DEV_012.
	SCT_DMAREQ0_DEV_012 = 0x1000
	// Position of DEV_013 field.
	SCT_DMAREQ0_DEV_013_Pos = 0xd
	// Bit mask of DEV_013 field.
	SCT_DMAREQ0_DEV_013_Msk = 0x2000
	// Bit DEV_013.
	SCT_DMAREQ0_DEV_013 = 0x2000
	// Position of DEV_014 field.
	SCT_DMAREQ0_DEV_014_Pos = 0xe
	// Bit mask of DEV_014 field.
	SCT_DMAREQ0_DEV_014_Msk = 0x4000
	// Bit DEV_014.
	SCT_DMAREQ0_DEV_014 = 0x4000
	// Position of DEV_015 field.
	SCT_DMAREQ0_DEV_015_Pos = 0xf
	// Bit mask of DEV_015 field.
	SCT_DMAREQ0_DEV_015_Msk = 0x8000
	// Bit DEV_015.
	SCT_DMAREQ0_DEV_015 = 0x8000
	// Position of RESERVED field.
	SCT_DMAREQ0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT_DMAREQ0_RESERVED_Msk = 0x3fff0000
	// Position of DRL0 field.
	SCT_DMAREQ0_DRL0_Pos = 0x1e
	// Bit mask of DRL0 field.
	SCT_DMAREQ0_DRL0_Msk = 0x40000000
	// Bit DRL0.
	SCT_DMAREQ0_DRL0 = 0x40000000
	// Position of DRQ0 field.
	SCT_DMAREQ0_DRQ0_Pos = 0x1f
	// Bit mask of DRQ0 field.
	SCT_DMAREQ0_DRQ0_Msk = 0x80000000
	// Bit DRQ0.
	SCT_DMAREQ0_DRQ0 = 0x80000000

	// DMAREQ1: SCT DMA request 1 register
	// Position of DEV_10 field.
	SCT_DMAREQ1_DEV_10_Pos = 0x0
	// Bit mask of DEV_10 field.
	SCT_DMAREQ1_DEV_10_Msk = 0x1
	// Bit DEV_10.
	SCT_DMAREQ1_DEV_10 = 0x1
	// Position of DEV_11 field.
	SCT_DMAREQ1_DEV_11_Pos = 0x1
	// Bit mask of DEV_11 field.
	SCT_DMAREQ1_DEV_11_Msk = 0x2
	// Bit DEV_11.
	SCT_DMAREQ1_DEV_11 = 0x2
	// Position of DEV_12 field.
	SCT_DMAREQ1_DEV_12_Pos = 0x2
	// Bit mask of DEV_12 field.
	SCT_DMAREQ1_DEV_12_Msk = 0x4
	// Bit DEV_12.
	SCT_DMAREQ1_DEV_12 = 0x4
	// Position of DEV_13 field.
	SCT_DMAREQ1_DEV_13_Pos = 0x3
	// Bit mask of DEV_13 field.
	SCT_DMAREQ1_DEV_13_Msk = 0x8
	// Bit DEV_13.
	SCT_DMAREQ1_DEV_13 = 0x8
	// Position of DEV_14 field.
	SCT_DMAREQ1_DEV_14_Pos = 0x4
	// Bit mask of DEV_14 field.
	SCT_DMAREQ1_DEV_14_Msk = 0x10
	// Bit DEV_14.
	SCT_DMAREQ1_DEV_14 = 0x10
	// Position of DEV_15 field.
	SCT_DMAREQ1_DEV_15_Pos = 0x5
	// Bit mask of DEV_15 field.
	SCT_DMAREQ1_DEV_15_Msk = 0x20
	// Bit DEV_15.
	SCT_DMAREQ1_DEV_15 = 0x20
	// Position of DEV_16 field.
	SCT_DMAREQ1_DEV_16_Pos = 0x6
	// Bit mask of DEV_16 field.
	SCT_DMAREQ1_DEV_16_Msk = 0x40
	// Bit DEV_16.
	SCT_DMAREQ1_DEV_16 = 0x40
	// Position of DEV_17 field.
	SCT_DMAREQ1_DEV_17_Pos = 0x7
	// Bit mask of DEV_17 field.
	SCT_DMAREQ1_DEV_17_Msk = 0x80
	// Bit DEV_17.
	SCT_DMAREQ1_DEV_17 = 0x80
	// Position of DEV_18 field.
	SCT_DMAREQ1_DEV_18_Pos = 0x8
	// Bit mask of DEV_18 field.
	SCT_DMAREQ1_DEV_18_Msk = 0x100
	// Bit DEV_18.
	SCT_DMAREQ1_DEV_18 = 0x100
	// Position of DEV_19 field.
	SCT_DMAREQ1_DEV_19_Pos = 0x9
	// Bit mask of DEV_19 field.
	SCT_DMAREQ1_DEV_19_Msk = 0x200
	// Bit DEV_19.
	SCT_DMAREQ1_DEV_19 = 0x200
	// Position of DEV_110 field.
	SCT_DMAREQ1_DEV_110_Pos = 0xa
	// Bit mask of DEV_110 field.
	SCT_DMAREQ1_DEV_110_Msk = 0x400
	// Bit DEV_110.
	SCT_DMAREQ1_DEV_110 = 0x400
	// Position of DEV_111 field.
	SCT_DMAREQ1_DEV_111_Pos = 0xb
	// Bit mask of DEV_111 field.
	SCT_DMAREQ1_DEV_111_Msk = 0x800
	// Bit DEV_111.
	SCT_DMAREQ1_DEV_111 = 0x800
	// Position of DEV_112 field.
	SCT_DMAREQ1_DEV_112_Pos = 0xc
	// Bit mask of DEV_112 field.
	SCT_DMAREQ1_DEV_112_Msk = 0x1000
	// Bit DEV_112.
	SCT_DMAREQ1_DEV_112 = 0x1000
	// Position of DEV_113 field.
	SCT_DMAREQ1_DEV_113_Pos = 0xd
	// Bit mask of DEV_113 field.
	SCT_DMAREQ1_DEV_113_Msk = 0x2000
	// Bit DEV_113.
	SCT_DMAREQ1_DEV_113 = 0x2000
	// Position of DEV_114 field.
	SCT_DMAREQ1_DEV_114_Pos = 0xe
	// Bit mask of DEV_114 field.
	SCT_DMAREQ1_DEV_114_Msk = 0x4000
	// Bit DEV_114.
	SCT_DMAREQ1_DEV_114 = 0x4000
	// Position of DEV_115 field.
	SCT_DMAREQ1_DEV_115_Pos = 0xf
	// Bit mask of DEV_115 field.
	SCT_DMAREQ1_DEV_115_Msk = 0x8000
	// Bit DEV_115.
	SCT_DMAREQ1_DEV_115 = 0x8000
	// Position of RESERVED field.
	SCT_DMAREQ1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT_DMAREQ1_RESERVED_Msk = 0x3fff0000
	// Position of DRL1 field.
	SCT_DMAREQ1_DRL1_Pos = 0x1e
	// Bit mask of DRL1 field.
	SCT_DMAREQ1_DRL1_Msk = 0x40000000
	// Bit DRL1.
	SCT_DMAREQ1_DRL1 = 0x40000000
	// Position of DRQ1 field.
	SCT_DMAREQ1_DRQ1_Pos = 0x1f
	// Bit mask of DRQ1 field.
	SCT_DMAREQ1_DRQ1_Msk = 0x80000000
	// Bit DRQ1.
	SCT_DMAREQ1_DRQ1 = 0x80000000

	// EVEN: SCT event enable register
	// Position of IEN0 field.
	SCT_EVEN_IEN0_Pos = 0x0
	// Bit mask of IEN0 field.
	SCT_EVEN_IEN0_Msk = 0x1
	// Bit IEN0.
	SCT_EVEN_IEN0 = 0x1
	// Position of IEN1 field.
	SCT_EVEN_IEN1_Pos = 0x1
	// Bit mask of IEN1 field.
	SCT_EVEN_IEN1_Msk = 0x2
	// Bit IEN1.
	SCT_EVEN_IEN1 = 0x2
	// Position of IEN2 field.
	SCT_EVEN_IEN2_Pos = 0x2
	// Bit mask of IEN2 field.
	SCT_EVEN_IEN2_Msk = 0x4
	// Bit IEN2.
	SCT_EVEN_IEN2 = 0x4
	// Position of IEN3 field.
	SCT_EVEN_IEN3_Pos = 0x3
	// Bit mask of IEN3 field.
	SCT_EVEN_IEN3_Msk = 0x8
	// Bit IEN3.
	SCT_EVEN_IEN3 = 0x8
	// Position of IEN4 field.
	SCT_EVEN_IEN4_Pos = 0x4
	// Bit mask of IEN4 field.
	SCT_EVEN_IEN4_Msk = 0x10
	// Bit IEN4.
	SCT_EVEN_IEN4 = 0x10
	// Position of IEN5 field.
	SCT_EVEN_IEN5_Pos = 0x5
	// Bit mask of IEN5 field.
	SCT_EVEN_IEN5_Msk = 0x20
	// Bit IEN5.
	SCT_EVEN_IEN5 = 0x20
	// Position of IEN6 field.
	SCT_EVEN_IEN6_Pos = 0x6
	// Bit mask of IEN6 field.
	SCT_EVEN_IEN6_Msk = 0x40
	// Bit IEN6.
	SCT_EVEN_IEN6 = 0x40
	// Position of IEN7 field.
	SCT_EVEN_IEN7_Pos = 0x7
	// Bit mask of IEN7 field.
	SCT_EVEN_IEN7_Msk = 0x80
	// Bit IEN7.
	SCT_EVEN_IEN7 = 0x80
	// Position of IEN8 field.
	SCT_EVEN_IEN8_Pos = 0x8
	// Bit mask of IEN8 field.
	SCT_EVEN_IEN8_Msk = 0x100
	// Bit IEN8.
	SCT_EVEN_IEN8 = 0x100
	// Position of IEN9 field.
	SCT_EVEN_IEN9_Pos = 0x9
	// Bit mask of IEN9 field.
	SCT_EVEN_IEN9_Msk = 0x200
	// Bit IEN9.
	SCT_EVEN_IEN9 = 0x200
	// Position of IEN10 field.
	SCT_EVEN_IEN10_Pos = 0xa
	// Bit mask of IEN10 field.
	SCT_EVEN_IEN10_Msk = 0x400
	// Bit IEN10.
	SCT_EVEN_IEN10 = 0x400
	// Position of IEN11 field.
	SCT_EVEN_IEN11_Pos = 0xb
	// Bit mask of IEN11 field.
	SCT_EVEN_IEN11_Msk = 0x800
	// Bit IEN11.
	SCT_EVEN_IEN11 = 0x800
	// Position of IEN12 field.
	SCT_EVEN_IEN12_Pos = 0xc
	// Bit mask of IEN12 field.
	SCT_EVEN_IEN12_Msk = 0x1000
	// Bit IEN12.
	SCT_EVEN_IEN12 = 0x1000
	// Position of IEN13 field.
	SCT_EVEN_IEN13_Pos = 0xd
	// Bit mask of IEN13 field.
	SCT_EVEN_IEN13_Msk = 0x2000
	// Bit IEN13.
	SCT_EVEN_IEN13 = 0x2000
	// Position of IEN14 field.
	SCT_EVEN_IEN14_Pos = 0xe
	// Bit mask of IEN14 field.
	SCT_EVEN_IEN14_Msk = 0x4000
	// Bit IEN14.
	SCT_EVEN_IEN14 = 0x4000
	// Position of IEN15 field.
	SCT_EVEN_IEN15_Pos = 0xf
	// Bit mask of IEN15 field.
	SCT_EVEN_IEN15_Msk = 0x8000
	// Bit IEN15.
	SCT_EVEN_IEN15 = 0x8000
	// Position of RESERVED field.
	SCT_EVEN_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT_EVEN_RESERVED_Msk = 0xffff0000

	// EVFLAG: SCT event flag register
	// Position of FLAG0 field.
	SCT_EVFLAG_FLAG0_Pos = 0x0
	// Bit mask of FLAG0 field.
	SCT_EVFLAG_FLAG0_Msk = 0x1
	// Bit FLAG0.
	SCT_EVFLAG_FLAG0 = 0x1
	// Position of FLAG1 field.
	SCT_EVFLAG_FLAG1_Pos = 0x1
	// Bit mask of FLAG1 field.
	SCT_EVFLAG_FLAG1_Msk = 0x2
	// Bit FLAG1.
	SCT_EVFLAG_FLAG1 = 0x2
	// Position of FLAG2 field.
	SCT_EVFLAG_FLAG2_Pos = 0x2
	// Bit mask of FLAG2 field.
	SCT_EVFLAG_FLAG2_Msk = 0x4
	// Bit FLAG2.
	SCT_EVFLAG_FLAG2 = 0x4
	// Position of FLAG3 field.
	SCT_EVFLAG_FLAG3_Pos = 0x3
	// Bit mask of FLAG3 field.
	SCT_EVFLAG_FLAG3_Msk = 0x8
	// Bit FLAG3.
	SCT_EVFLAG_FLAG3 = 0x8
	// Position of FLAG4 field.
	SCT_EVFLAG_FLAG4_Pos = 0x4
	// Bit mask of FLAG4 field.
	SCT_EVFLAG_FLAG4_Msk = 0x10
	// Bit FLAG4.
	SCT_EVFLAG_FLAG4 = 0x10
	// Position of FLAG5 field.
	SCT_EVFLAG_FLAG5_Pos = 0x5
	// Bit mask of FLAG5 field.
	SCT_EVFLAG_FLAG5_Msk = 0x20
	// Bit FLAG5.
	SCT_EVFLAG_FLAG5 = 0x20
	// Position of FLAG6 field.
	SCT_EVFLAG_FLAG6_Pos = 0x6
	// Bit mask of FLAG6 field.
	SCT_EVFLAG_FLAG6_Msk = 0x40
	// Bit FLAG6.
	SCT_EVFLAG_FLAG6 = 0x40
	// Position of FLAG7 field.
	SCT_EVFLAG_FLAG7_Pos = 0x7
	// Bit mask of FLAG7 field.
	SCT_EVFLAG_FLAG7_Msk = 0x80
	// Bit FLAG7.
	SCT_EVFLAG_FLAG7 = 0x80
	// Position of FLAG8 field.
	SCT_EVFLAG_FLAG8_Pos = 0x8
	// Bit mask of FLAG8 field.
	SCT_EVFLAG_FLAG8_Msk = 0x100
	// Bit FLAG8.
	SCT_EVFLAG_FLAG8 = 0x100
	// Position of FLAG9 field.
	SCT_EVFLAG_FLAG9_Pos = 0x9
	// Bit mask of FLAG9 field.
	SCT_EVFLAG_FLAG9_Msk = 0x200
	// Bit FLAG9.
	SCT_EVFLAG_FLAG9 = 0x200
	// Position of FLAG10 field.
	SCT_EVFLAG_FLAG10_Pos = 0xa
	// Bit mask of FLAG10 field.
	SCT_EVFLAG_FLAG10_Msk = 0x400
	// Bit FLAG10.
	SCT_EVFLAG_FLAG10 = 0x400
	// Position of FLAG11 field.
	SCT_EVFLAG_FLAG11_Pos = 0xb
	// Bit mask of FLAG11 field.
	SCT_EVFLAG_FLAG11_Msk = 0x800
	// Bit FLAG11.
	SCT_EVFLAG_FLAG11 = 0x800
	// Position of FLAG12 field.
	SCT_EVFLAG_FLAG12_Pos = 0xc
	// Bit mask of FLAG12 field.
	SCT_EVFLAG_FLAG12_Msk = 0x1000
	// Bit FLAG12.
	SCT_EVFLAG_FLAG12 = 0x1000
	// Position of FLAG13 field.
	SCT_EVFLAG_FLAG13_Pos = 0xd
	// Bit mask of FLAG13 field.
	SCT_EVFLAG_FLAG13_Msk = 0x2000
	// Bit FLAG13.
	SCT_EVFLAG_FLAG13 = 0x2000
	// Position of FLAG14 field.
	SCT_EVFLAG_FLAG14_Pos = 0xe
	// Bit mask of FLAG14 field.
	SCT_EVFLAG_FLAG14_Msk = 0x4000
	// Bit FLAG14.
	SCT_EVFLAG_FLAG14 = 0x4000
	// Position of FLAG15 field.
	SCT_EVFLAG_FLAG15_Pos = 0xf
	// Bit mask of FLAG15 field.
	SCT_EVFLAG_FLAG15_Msk = 0x8000
	// Bit FLAG15.
	SCT_EVFLAG_FLAG15 = 0x8000
	// Position of RESERVED field.
	SCT_EVFLAG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT_EVFLAG_RESERVED_Msk = 0xffff0000

	// CONEN: SCT conflict enable register
	// Position of NCEN0 field.
	SCT_CONEN_NCEN0_Pos = 0x0
	// Bit mask of NCEN0 field.
	SCT_CONEN_NCEN0_Msk = 0x1
	// Bit NCEN0.
	SCT_CONEN_NCEN0 = 0x1
	// Position of NCEN1 field.
	SCT_CONEN_NCEN1_Pos = 0x1
	// Bit mask of NCEN1 field.
	SCT_CONEN_NCEN1_Msk = 0x2
	// Bit NCEN1.
	SCT_CONEN_NCEN1 = 0x2
	// Position of NCEN2 field.
	SCT_CONEN_NCEN2_Pos = 0x2
	// Bit mask of NCEN2 field.
	SCT_CONEN_NCEN2_Msk = 0x4
	// Bit NCEN2.
	SCT_CONEN_NCEN2 = 0x4
	// Position of NCEN3 field.
	SCT_CONEN_NCEN3_Pos = 0x3
	// Bit mask of NCEN3 field.
	SCT_CONEN_NCEN3_Msk = 0x8
	// Bit NCEN3.
	SCT_CONEN_NCEN3 = 0x8
	// Position of NCEN4 field.
	SCT_CONEN_NCEN4_Pos = 0x4
	// Bit mask of NCEN4 field.
	SCT_CONEN_NCEN4_Msk = 0x10
	// Bit NCEN4.
	SCT_CONEN_NCEN4 = 0x10
	// Position of NCEN5 field.
	SCT_CONEN_NCEN5_Pos = 0x5
	// Bit mask of NCEN5 field.
	SCT_CONEN_NCEN5_Msk = 0x20
	// Bit NCEN5.
	SCT_CONEN_NCEN5 = 0x20
	// Position of NCEN6 field.
	SCT_CONEN_NCEN6_Pos = 0x6
	// Bit mask of NCEN6 field.
	SCT_CONEN_NCEN6_Msk = 0x40
	// Bit NCEN6.
	SCT_CONEN_NCEN6 = 0x40
	// Position of NCEN7 field.
	SCT_CONEN_NCEN7_Pos = 0x7
	// Bit mask of NCEN7 field.
	SCT_CONEN_NCEN7_Msk = 0x80
	// Bit NCEN7.
	SCT_CONEN_NCEN7 = 0x80
	// Position of NCEN8 field.
	SCT_CONEN_NCEN8_Pos = 0x8
	// Bit mask of NCEN8 field.
	SCT_CONEN_NCEN8_Msk = 0x100
	// Bit NCEN8.
	SCT_CONEN_NCEN8 = 0x100
	// Position of NCEN9 field.
	SCT_CONEN_NCEN9_Pos = 0x9
	// Bit mask of NCEN9 field.
	SCT_CONEN_NCEN9_Msk = 0x200
	// Bit NCEN9.
	SCT_CONEN_NCEN9 = 0x200
	// Position of NCEN10 field.
	SCT_CONEN_NCEN10_Pos = 0xa
	// Bit mask of NCEN10 field.
	SCT_CONEN_NCEN10_Msk = 0x400
	// Bit NCEN10.
	SCT_CONEN_NCEN10 = 0x400
	// Position of NCEN11 field.
	SCT_CONEN_NCEN11_Pos = 0xb
	// Bit mask of NCEN11 field.
	SCT_CONEN_NCEN11_Msk = 0x800
	// Bit NCEN11.
	SCT_CONEN_NCEN11 = 0x800
	// Position of NCEN12 field.
	SCT_CONEN_NCEN12_Pos = 0xc
	// Bit mask of NCEN12 field.
	SCT_CONEN_NCEN12_Msk = 0x1000
	// Bit NCEN12.
	SCT_CONEN_NCEN12 = 0x1000
	// Position of NCEN13 field.
	SCT_CONEN_NCEN13_Pos = 0xd
	// Bit mask of NCEN13 field.
	SCT_CONEN_NCEN13_Msk = 0x2000
	// Bit NCEN13.
	SCT_CONEN_NCEN13 = 0x2000
	// Position of NCEN14 field.
	SCT_CONEN_NCEN14_Pos = 0xe
	// Bit mask of NCEN14 field.
	SCT_CONEN_NCEN14_Msk = 0x4000
	// Bit NCEN14.
	SCT_CONEN_NCEN14 = 0x4000
	// Position of NCEN15 field.
	SCT_CONEN_NCEN15_Pos = 0xf
	// Bit mask of NCEN15 field.
	SCT_CONEN_NCEN15_Msk = 0x8000
	// Bit NCEN15.
	SCT_CONEN_NCEN15 = 0x8000
	// Position of RESERVED field.
	SCT_CONEN_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT_CONEN_RESERVED_Msk = 0xffff0000

	// CONFLAG: SCT conflict flag register
	// Position of NCFLAG0 field.
	SCT_CONFLAG_NCFLAG0_Pos = 0x0
	// Bit mask of NCFLAG0 field.
	SCT_CONFLAG_NCFLAG0_Msk = 0x1
	// Bit NCFLAG0.
	SCT_CONFLAG_NCFLAG0 = 0x1
	// Position of NCFLAG1 field.
	SCT_CONFLAG_NCFLAG1_Pos = 0x1
	// Bit mask of NCFLAG1 field.
	SCT_CONFLAG_NCFLAG1_Msk = 0x2
	// Bit NCFLAG1.
	SCT_CONFLAG_NCFLAG1 = 0x2
	// Position of NCFLAG2 field.
	SCT_CONFLAG_NCFLAG2_Pos = 0x2
	// Bit mask of NCFLAG2 field.
	SCT_CONFLAG_NCFLAG2_Msk = 0x4
	// Bit NCFLAG2.
	SCT_CONFLAG_NCFLAG2 = 0x4
	// Position of NCFLAG3 field.
	SCT_CONFLAG_NCFLAG3_Pos = 0x3
	// Bit mask of NCFLAG3 field.
	SCT_CONFLAG_NCFLAG3_Msk = 0x8
	// Bit NCFLAG3.
	SCT_CONFLAG_NCFLAG3 = 0x8
	// Position of NCFLAG4 field.
	SCT_CONFLAG_NCFLAG4_Pos = 0x4
	// Bit mask of NCFLAG4 field.
	SCT_CONFLAG_NCFLAG4_Msk = 0x10
	// Bit NCFLAG4.
	SCT_CONFLAG_NCFLAG4 = 0x10
	// Position of NCFLAG5 field.
	SCT_CONFLAG_NCFLAG5_Pos = 0x5
	// Bit mask of NCFLAG5 field.
	SCT_CONFLAG_NCFLAG5_Msk = 0x20
	// Bit NCFLAG5.
	SCT_CONFLAG_NCFLAG5 = 0x20
	// Position of NCFLAG6 field.
	SCT_CONFLAG_NCFLAG6_Pos = 0x6
	// Bit mask of NCFLAG6 field.
	SCT_CONFLAG_NCFLAG6_Msk = 0x40
	// Bit NCFLAG6.
	SCT_CONFLAG_NCFLAG6 = 0x40
	// Position of NCFLAG7 field.
	SCT_CONFLAG_NCFLAG7_Pos = 0x7
	// Bit mask of NCFLAG7 field.
	SCT_CONFLAG_NCFLAG7_Msk = 0x80
	// Bit NCFLAG7.
	SCT_CONFLAG_NCFLAG7 = 0x80
	// Position of NCFLAG8 field.
	SCT_CONFLAG_NCFLAG8_Pos = 0x8
	// Bit mask of NCFLAG8 field.
	SCT_CONFLAG_NCFLAG8_Msk = 0x100
	// Bit NCFLAG8.
	SCT_CONFLAG_NCFLAG8 = 0x100
	// Position of NCFLAG9 field.
	SCT_CONFLAG_NCFLAG9_Pos = 0x9
	// Bit mask of NCFLAG9 field.
	SCT_CONFLAG_NCFLAG9_Msk = 0x200
	// Bit NCFLAG9.
	SCT_CONFLAG_NCFLAG9 = 0x200
	// Position of NCFLAG10 field.
	SCT_CONFLAG_NCFLAG10_Pos = 0xa
	// Bit mask of NCFLAG10 field.
	SCT_CONFLAG_NCFLAG10_Msk = 0x400
	// Bit NCFLAG10.
	SCT_CONFLAG_NCFLAG10 = 0x400
	// Position of NCFLAG11 field.
	SCT_CONFLAG_NCFLAG11_Pos = 0xb
	// Bit mask of NCFLAG11 field.
	SCT_CONFLAG_NCFLAG11_Msk = 0x800
	// Bit NCFLAG11.
	SCT_CONFLAG_NCFLAG11 = 0x800
	// Position of NCFLAG12 field.
	SCT_CONFLAG_NCFLAG12_Pos = 0xc
	// Bit mask of NCFLAG12 field.
	SCT_CONFLAG_NCFLAG12_Msk = 0x1000
	// Bit NCFLAG12.
	SCT_CONFLAG_NCFLAG12 = 0x1000
	// Position of NCFLAG13 field.
	SCT_CONFLAG_NCFLAG13_Pos = 0xd
	// Bit mask of NCFLAG13 field.
	SCT_CONFLAG_NCFLAG13_Msk = 0x2000
	// Bit NCFLAG13.
	SCT_CONFLAG_NCFLAG13 = 0x2000
	// Position of NCFLAG14 field.
	SCT_CONFLAG_NCFLAG14_Pos = 0xe
	// Bit mask of NCFLAG14 field.
	SCT_CONFLAG_NCFLAG14_Msk = 0x4000
	// Bit NCFLAG14.
	SCT_CONFLAG_NCFLAG14 = 0x4000
	// Position of NCFLAG15 field.
	SCT_CONFLAG_NCFLAG15_Pos = 0xf
	// Bit mask of NCFLAG15 field.
	SCT_CONFLAG_NCFLAG15_Msk = 0x8000
	// Bit NCFLAG15.
	SCT_CONFLAG_NCFLAG15 = 0x8000
	// Position of RESERVED field.
	SCT_CONFLAG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT_CONFLAG_RESERVED_Msk = 0x3fff0000
	// Position of BUSERRL field.
	SCT_CONFLAG_BUSERRL_Pos = 0x1e
	// Bit mask of BUSERRL field.
	SCT_CONFLAG_BUSERRL_Msk = 0x40000000
	// Bit BUSERRL.
	SCT_CONFLAG_BUSERRL = 0x40000000
	// Position of BUSERRH field.
	SCT_CONFLAG_BUSERRH_Pos = 0x1f
	// Bit mask of BUSERRH field.
	SCT_CONFLAG_BUSERRH_Msk = 0x80000000
	// Bit BUSERRH.
	SCT_CONFLAG_BUSERRH = 0x80000000

	// MATCH0: SCT match value register of match channels 0 to 15; REGMOD0 to REGMODE15 = 0
	// Position of MATCH_L field.
	SCT_MATCH_MATCH_L_Pos = 0x0
	// Bit mask of MATCH_L field.
	SCT_MATCH_MATCH_L_Msk = 0xffff
	// Position of MATCH_H field.
	SCT_MATCH_MATCH_H_Pos = 0x10
	// Bit mask of MATCH_H field.
	SCT_MATCH_MATCH_H_Msk = 0xffff0000

	// CAP0: SCT capture register of capture channel 0 to 15; REGMOD0 to REGMODE15 = 1
	// Position of CAP_L field.
	SCT_CAP_CAP_L_Pos = 0x0
	// Bit mask of CAP_L field.
	SCT_CAP_CAP_L_Msk = 0xffff
	// Position of CAP_H field.
	SCT_CAP_CAP_H_Pos = 0x10
	// Bit mask of CAP_H field.
	SCT_CAP_CAP_H_Msk = 0xffff0000

	// FRACMAT0: Fractional match registers 0 to 5 for SCT match value registers 0 to 5.
	// Position of FRACMAT_L field.
	SCT_FRACMAT_FRACMAT_L_Pos = 0x0
	// Bit mask of FRACMAT_L field.
	SCT_FRACMAT_FRACMAT_L_Msk = 0xf
	// Position of RESERVED field.
	SCT_FRACMAT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT_FRACMAT_RESERVED_Msk = 0xfff0
	// Position of FRACMAT_H field.
	SCT_FRACMAT_FRACMAT_H_Pos = 0x10
	// Bit mask of FRACMAT_H field.
	SCT_FRACMAT_FRACMAT_H_Msk = 0xf0000
	// Position of RESERVED field.
	SCT_FRACMAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SCT_FRACMAT_RESERVED_Msk = 0xfff00000

	// MATCHREL0: SCT match reload value register 0 to 15; REGMOD0 = 0 to REGMODE15 = 0
	// Position of RELOAD_L field.
	SCT_MATCHREL_RELOAD_L_Pos = 0x0
	// Bit mask of RELOAD_L field.
	SCT_MATCHREL_RELOAD_L_Msk = 0xffff
	// Position of RELOAD_H field.
	SCT_MATCHREL_RELOAD_H_Pos = 0x10
	// Bit mask of RELOAD_H field.
	SCT_MATCHREL_RELOAD_H_Msk = 0xffff0000

	// CAPCTRL0: SCT capture control register 0 to 15; REGMOD0 = 1 to REGMODE15 = 1
	// Position of CAPCON_L field.
	SCT_CAPCTRL_CAPCON_L_Pos = 0x0
	// Bit mask of CAPCON_L field.
	SCT_CAPCTRL_CAPCON_L_Msk = 0xffff
	// Position of CAPCON_H field.
	SCT_CAPCTRL_CAPCON_H_Pos = 0x10
	// Bit mask of CAPCON_H field.
	SCT_CAPCTRL_CAPCON_H_Msk = 0xffff0000

	// FRACMATREL0: Fractional match reload registers 0 to 5 for SCT match value registers 0 to 5.
	// Position of RELFRAC_L field.
	SCT_FRACMATREL_RELFRAC_L_Pos = 0x0
	// Bit mask of RELFRAC_L field.
	SCT_FRACMATREL_RELFRAC_L_Msk = 0xf
	// Position of RESERVED field.
	SCT_FRACMATREL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT_FRACMATREL_RESERVED_Msk = 0xfff0
	// Position of RELFRAC_H field.
	SCT_FRACMATREL_RELFRAC_H_Pos = 0x10
	// Bit mask of RELFRAC_H field.
	SCT_FRACMATREL_RELFRAC_H_Msk = 0xf0000
	// Position of RESERVED field.
	SCT_FRACMATREL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SCT_FRACMATREL_RESERVED_Msk = 0xfff00000

	// EV0_STATE: SCT event state register 0
	// Position of STATEMSK0 field.
	SCT_EV_STATE_STATEMSK0_Pos = 0x0
	// Bit mask of STATEMSK0 field.
	SCT_EV_STATE_STATEMSK0_Msk = 0x1
	// Bit STATEMSK0.
	SCT_EV_STATE_STATEMSK0 = 0x1
	// Position of STATEMSK1 field.
	SCT_EV_STATE_STATEMSK1_Pos = 0x1
	// Bit mask of STATEMSK1 field.
	SCT_EV_STATE_STATEMSK1_Msk = 0x2
	// Bit STATEMSK1.
	SCT_EV_STATE_STATEMSK1 = 0x2
	// Position of STATEMSK2 field.
	SCT_EV_STATE_STATEMSK2_Pos = 0x2
	// Bit mask of STATEMSK2 field.
	SCT_EV_STATE_STATEMSK2_Msk = 0x4
	// Bit STATEMSK2.
	SCT_EV_STATE_STATEMSK2 = 0x4
	// Position of STATEMSK3 field.
	SCT_EV_STATE_STATEMSK3_Pos = 0x3
	// Bit mask of STATEMSK3 field.
	SCT_EV_STATE_STATEMSK3_Msk = 0x8
	// Bit STATEMSK3.
	SCT_EV_STATE_STATEMSK3 = 0x8
	// Position of STATEMSK4 field.
	SCT_EV_STATE_STATEMSK4_Pos = 0x4
	// Bit mask of STATEMSK4 field.
	SCT_EV_STATE_STATEMSK4_Msk = 0x10
	// Bit STATEMSK4.
	SCT_EV_STATE_STATEMSK4 = 0x10
	// Position of STATEMSK5 field.
	SCT_EV_STATE_STATEMSK5_Pos = 0x5
	// Bit mask of STATEMSK5 field.
	SCT_EV_STATE_STATEMSK5_Msk = 0x20
	// Bit STATEMSK5.
	SCT_EV_STATE_STATEMSK5 = 0x20
	// Position of STATEMSK6 field.
	SCT_EV_STATE_STATEMSK6_Pos = 0x6
	// Bit mask of STATEMSK6 field.
	SCT_EV_STATE_STATEMSK6_Msk = 0x40
	// Bit STATEMSK6.
	SCT_EV_STATE_STATEMSK6 = 0x40
	// Position of STATEMSK7 field.
	SCT_EV_STATE_STATEMSK7_Pos = 0x7
	// Bit mask of STATEMSK7 field.
	SCT_EV_STATE_STATEMSK7_Msk = 0x80
	// Bit STATEMSK7.
	SCT_EV_STATE_STATEMSK7 = 0x80
	// Position of STATEMSK8 field.
	SCT_EV_STATE_STATEMSK8_Pos = 0x8
	// Bit mask of STATEMSK8 field.
	SCT_EV_STATE_STATEMSK8_Msk = 0x100
	// Bit STATEMSK8.
	SCT_EV_STATE_STATEMSK8 = 0x100
	// Position of STATEMSK9 field.
	SCT_EV_STATE_STATEMSK9_Pos = 0x9
	// Bit mask of STATEMSK9 field.
	SCT_EV_STATE_STATEMSK9_Msk = 0x200
	// Bit STATEMSK9.
	SCT_EV_STATE_STATEMSK9 = 0x200
	// Position of STATEMSK10 field.
	SCT_EV_STATE_STATEMSK10_Pos = 0xa
	// Bit mask of STATEMSK10 field.
	SCT_EV_STATE_STATEMSK10_Msk = 0x400
	// Bit STATEMSK10.
	SCT_EV_STATE_STATEMSK10 = 0x400
	// Position of STATEMSK11 field.
	SCT_EV_STATE_STATEMSK11_Pos = 0xb
	// Bit mask of STATEMSK11 field.
	SCT_EV_STATE_STATEMSK11_Msk = 0x800
	// Bit STATEMSK11.
	SCT_EV_STATE_STATEMSK11 = 0x800
	// Position of STATEMSK12 field.
	SCT_EV_STATE_STATEMSK12_Pos = 0xc
	// Bit mask of STATEMSK12 field.
	SCT_EV_STATE_STATEMSK12_Msk = 0x1000
	// Bit STATEMSK12.
	SCT_EV_STATE_STATEMSK12 = 0x1000
	// Position of STATEMSK13 field.
	SCT_EV_STATE_STATEMSK13_Pos = 0xd
	// Bit mask of STATEMSK13 field.
	SCT_EV_STATE_STATEMSK13_Msk = 0x2000
	// Bit STATEMSK13.
	SCT_EV_STATE_STATEMSK13 = 0x2000
	// Position of STATEMSK14 field.
	SCT_EV_STATE_STATEMSK14_Pos = 0xe
	// Bit mask of STATEMSK14 field.
	SCT_EV_STATE_STATEMSK14_Msk = 0x4000
	// Bit STATEMSK14.
	SCT_EV_STATE_STATEMSK14 = 0x4000
	// Position of STATEMSK15 field.
	SCT_EV_STATE_STATEMSK15_Pos = 0xf
	// Bit mask of STATEMSK15 field.
	SCT_EV_STATE_STATEMSK15_Msk = 0x8000
	// Bit STATEMSK15.
	SCT_EV_STATE_STATEMSK15 = 0x8000
	// Position of STATEMSK16 field.
	SCT_EV_STATE_STATEMSK16_Pos = 0x10
	// Bit mask of STATEMSK16 field.
	SCT_EV_STATE_STATEMSK16_Msk = 0x10000
	// Bit STATEMSK16.
	SCT_EV_STATE_STATEMSK16 = 0x10000
	// Position of STATEMSK17 field.
	SCT_EV_STATE_STATEMSK17_Pos = 0x11
	// Bit mask of STATEMSK17 field.
	SCT_EV_STATE_STATEMSK17_Msk = 0x20000
	// Bit STATEMSK17.
	SCT_EV_STATE_STATEMSK17 = 0x20000
	// Position of STATEMSK18 field.
	SCT_EV_STATE_STATEMSK18_Pos = 0x12
	// Bit mask of STATEMSK18 field.
	SCT_EV_STATE_STATEMSK18_Msk = 0x40000
	// Bit STATEMSK18.
	SCT_EV_STATE_STATEMSK18 = 0x40000
	// Position of STATEMSK19 field.
	SCT_EV_STATE_STATEMSK19_Pos = 0x13
	// Bit mask of STATEMSK19 field.
	SCT_EV_STATE_STATEMSK19_Msk = 0x80000
	// Bit STATEMSK19.
	SCT_EV_STATE_STATEMSK19 = 0x80000
	// Position of STATEMSK20 field.
	SCT_EV_STATE_STATEMSK20_Pos = 0x14
	// Bit mask of STATEMSK20 field.
	SCT_EV_STATE_STATEMSK20_Msk = 0x100000
	// Bit STATEMSK20.
	SCT_EV_STATE_STATEMSK20 = 0x100000
	// Position of STATEMSK21 field.
	SCT_EV_STATE_STATEMSK21_Pos = 0x15
	// Bit mask of STATEMSK21 field.
	SCT_EV_STATE_STATEMSK21_Msk = 0x200000
	// Bit STATEMSK21.
	SCT_EV_STATE_STATEMSK21 = 0x200000
	// Position of STATEMSK22 field.
	SCT_EV_STATE_STATEMSK22_Pos = 0x16
	// Bit mask of STATEMSK22 field.
	SCT_EV_STATE_STATEMSK22_Msk = 0x400000
	// Bit STATEMSK22.
	SCT_EV_STATE_STATEMSK22 = 0x400000
	// Position of STATEMSK23 field.
	SCT_EV_STATE_STATEMSK23_Pos = 0x17
	// Bit mask of STATEMSK23 field.
	SCT_EV_STATE_STATEMSK23_Msk = 0x800000
	// Bit STATEMSK23.
	SCT_EV_STATE_STATEMSK23 = 0x800000
	// Position of STATEMSK24 field.
	SCT_EV_STATE_STATEMSK24_Pos = 0x18
	// Bit mask of STATEMSK24 field.
	SCT_EV_STATE_STATEMSK24_Msk = 0x1000000
	// Bit STATEMSK24.
	SCT_EV_STATE_STATEMSK24 = 0x1000000
	// Position of STATEMSK25 field.
	SCT_EV_STATE_STATEMSK25_Pos = 0x19
	// Bit mask of STATEMSK25 field.
	SCT_EV_STATE_STATEMSK25_Msk = 0x2000000
	// Bit STATEMSK25.
	SCT_EV_STATE_STATEMSK25 = 0x2000000
	// Position of STATEMSK26 field.
	SCT_EV_STATE_STATEMSK26_Pos = 0x1a
	// Bit mask of STATEMSK26 field.
	SCT_EV_STATE_STATEMSK26_Msk = 0x4000000
	// Bit STATEMSK26.
	SCT_EV_STATE_STATEMSK26 = 0x4000000
	// Position of STATEMSK27 field.
	SCT_EV_STATE_STATEMSK27_Pos = 0x1b
	// Bit mask of STATEMSK27 field.
	SCT_EV_STATE_STATEMSK27_Msk = 0x8000000
	// Bit STATEMSK27.
	SCT_EV_STATE_STATEMSK27 = 0x8000000
	// Position of STATEMSK28 field.
	SCT_EV_STATE_STATEMSK28_Pos = 0x1c
	// Bit mask of STATEMSK28 field.
	SCT_EV_STATE_STATEMSK28_Msk = 0x10000000
	// Bit STATEMSK28.
	SCT_EV_STATE_STATEMSK28 = 0x10000000
	// Position of STATEMSK29 field.
	SCT_EV_STATE_STATEMSK29_Pos = 0x1d
	// Bit mask of STATEMSK29 field.
	SCT_EV_STATE_STATEMSK29_Msk = 0x20000000
	// Bit STATEMSK29.
	SCT_EV_STATE_STATEMSK29 = 0x20000000
	// Position of STATEMSK30 field.
	SCT_EV_STATE_STATEMSK30_Pos = 0x1e
	// Bit mask of STATEMSK30 field.
	SCT_EV_STATE_STATEMSK30_Msk = 0x40000000
	// Bit STATEMSK30.
	SCT_EV_STATE_STATEMSK30 = 0x40000000
	// Position of STATEMSK31 field.
	SCT_EV_STATE_STATEMSK31_Pos = 0x1f
	// Bit mask of STATEMSK31 field.
	SCT_EV_STATE_STATEMSK31_Msk = 0x80000000
	// Bit STATEMSK31.
	SCT_EV_STATE_STATEMSK31 = 0x80000000

	// EV0_CTRL: SCT event control register 0
	// Position of MATCHSEL field.
	SCT_EV_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT_EV_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT_EV_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT_EV_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT_EV_CTRL_HEVENT = 0x10
	// L state. Selects the L state and the L match register selected by MATCHSEL.
	SCT_EV_CTRL_HEVENT_L_STATE = 0x0
	// H state. Selects the H state and the H match register selected by MATCHSEL.
	SCT_EV_CTRL_HEVENT_H_STATE = 0x1
	// Position of OUTSEL field.
	SCT_EV_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT_EV_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT_EV_CTRL_OUTSEL = 0x20
	// Input. Selects the input selected by IOSEL.
	SCT_EV_CTRL_OUTSEL_INPUT = 0x0
	// Output. Selects the output selected by IOSEL.
	SCT_EV_CTRL_OUTSEL_OUTPUT = 0x1
	// Position of IOSEL field.
	SCT_EV_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT_EV_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT_EV_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT_EV_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT_EV_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT_EV_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT_EV_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT_EV_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT_EV_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT_EV_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT_EV_CTRL_COMBMODE_OR = 0x0
	// MATCH. Uses the specified match only.
	SCT_EV_CTRL_COMBMODE_MATCH = 0x1
	// IO. Uses the specified I/O condition only.
	SCT_EV_CTRL_COMBMODE_IO = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT_EV_CTRL_COMBMODE_AND = 0x3
	// Position of STATELD field.
	SCT_EV_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT_EV_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT_EV_CTRL_STATELD = 0x4000
	// STATEV value is added into STATE (the carry-out is ignored).
	SCT_EV_CTRL_STATELD_STATEV_VALUE_IS_ADDE = 0x0
	// STATEV value is loaded into STATE.
	SCT_EV_CTRL_STATELD_STATEV_VALUE_IS_LOAD = 0x1
	// Position of STATEV field.
	SCT_EV_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT_EV_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT_EV_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT_EV_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT_EV_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT_EV_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT_EV_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT_EV_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT_EV_CTRL_DIRECTION_COUNTING_UP = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT_EV_CTRL_DIRECTION_COUNTING_DOWN = 0x2
	// Position of RESERVED field.
	SCT_EV_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT_EV_CTRL_RESERVED_Msk = 0xff800000

	// OUT0_SET: SCT output 0 set register
	// Position of SET0 field.
	SCT_OUT_SET_SET0_Pos = 0x0
	// Bit mask of SET0 field.
	SCT_OUT_SET_SET0_Msk = 0x1
	// Bit SET0.
	SCT_OUT_SET_SET0 = 0x1
	// Position of SET1 field.
	SCT_OUT_SET_SET1_Pos = 0x1
	// Bit mask of SET1 field.
	SCT_OUT_SET_SET1_Msk = 0x2
	// Bit SET1.
	SCT_OUT_SET_SET1 = 0x2
	// Position of SET2 field.
	SCT_OUT_SET_SET2_Pos = 0x2
	// Bit mask of SET2 field.
	SCT_OUT_SET_SET2_Msk = 0x4
	// Bit SET2.
	SCT_OUT_SET_SET2 = 0x4
	// Position of SET3 field.
	SCT_OUT_SET_SET3_Pos = 0x3
	// Bit mask of SET3 field.
	SCT_OUT_SET_SET3_Msk = 0x8
	// Bit SET3.
	SCT_OUT_SET_SET3 = 0x8
	// Position of SET4 field.
	SCT_OUT_SET_SET4_Pos = 0x4
	// Bit mask of SET4 field.
	SCT_OUT_SET_SET4_Msk = 0x10
	// Bit SET4.
	SCT_OUT_SET_SET4 = 0x10
	// Position of SET5 field.
	SCT_OUT_SET_SET5_Pos = 0x5
	// Bit mask of SET5 field.
	SCT_OUT_SET_SET5_Msk = 0x20
	// Bit SET5.
	SCT_OUT_SET_SET5 = 0x20
	// Position of SET6 field.
	SCT_OUT_SET_SET6_Pos = 0x6
	// Bit mask of SET6 field.
	SCT_OUT_SET_SET6_Msk = 0x40
	// Bit SET6.
	SCT_OUT_SET_SET6 = 0x40
	// Position of SET7 field.
	SCT_OUT_SET_SET7_Pos = 0x7
	// Bit mask of SET7 field.
	SCT_OUT_SET_SET7_Msk = 0x80
	// Bit SET7.
	SCT_OUT_SET_SET7 = 0x80
	// Position of SET8 field.
	SCT_OUT_SET_SET8_Pos = 0x8
	// Bit mask of SET8 field.
	SCT_OUT_SET_SET8_Msk = 0x100
	// Bit SET8.
	SCT_OUT_SET_SET8 = 0x100
	// Position of SET9 field.
	SCT_OUT_SET_SET9_Pos = 0x9
	// Bit mask of SET9 field.
	SCT_OUT_SET_SET9_Msk = 0x200
	// Bit SET9.
	SCT_OUT_SET_SET9 = 0x200
	// Position of SET10 field.
	SCT_OUT_SET_SET10_Pos = 0xa
	// Bit mask of SET10 field.
	SCT_OUT_SET_SET10_Msk = 0x400
	// Bit SET10.
	SCT_OUT_SET_SET10 = 0x400
	// Position of SET11 field.
	SCT_OUT_SET_SET11_Pos = 0xb
	// Bit mask of SET11 field.
	SCT_OUT_SET_SET11_Msk = 0x800
	// Bit SET11.
	SCT_OUT_SET_SET11 = 0x800
	// Position of SET12 field.
	SCT_OUT_SET_SET12_Pos = 0xc
	// Bit mask of SET12 field.
	SCT_OUT_SET_SET12_Msk = 0x1000
	// Bit SET12.
	SCT_OUT_SET_SET12 = 0x1000
	// Position of SET13 field.
	SCT_OUT_SET_SET13_Pos = 0xd
	// Bit mask of SET13 field.
	SCT_OUT_SET_SET13_Msk = 0x2000
	// Bit SET13.
	SCT_OUT_SET_SET13 = 0x2000
	// Position of SET14 field.
	SCT_OUT_SET_SET14_Pos = 0xe
	// Bit mask of SET14 field.
	SCT_OUT_SET_SET14_Msk = 0x4000
	// Bit SET14.
	SCT_OUT_SET_SET14 = 0x4000
	// Position of SET15 field.
	SCT_OUT_SET_SET15_Pos = 0xf
	// Bit mask of SET15 field.
	SCT_OUT_SET_SET15_Msk = 0x8000
	// Bit SET15.
	SCT_OUT_SET_SET15 = 0x8000
	// Position of RESERVED field.
	SCT_OUT_SET_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT_OUT_SET_RESERVED_Msk = 0xffff0000

	// OUT0_CLR: SCT output 0 clear register
	// Position of CLR0 field.
	SCT_OUT_CLR_CLR0_Pos = 0x0
	// Bit mask of CLR0 field.
	SCT_OUT_CLR_CLR0_Msk = 0x1
	// Bit CLR0.
	SCT_OUT_CLR_CLR0 = 0x1
	// Position of CLR1 field.
	SCT_OUT_CLR_CLR1_Pos = 0x1
	// Bit mask of CLR1 field.
	SCT_OUT_CLR_CLR1_Msk = 0x2
	// Bit CLR1.
	SCT_OUT_CLR_CLR1 = 0x2
	// Position of CLR2 field.
	SCT_OUT_CLR_CLR2_Pos = 0x2
	// Bit mask of CLR2 field.
	SCT_OUT_CLR_CLR2_Msk = 0x4
	// Bit CLR2.
	SCT_OUT_CLR_CLR2 = 0x4
	// Position of CLR3 field.
	SCT_OUT_CLR_CLR3_Pos = 0x3
	// Bit mask of CLR3 field.
	SCT_OUT_CLR_CLR3_Msk = 0x8
	// Bit CLR3.
	SCT_OUT_CLR_CLR3 = 0x8
	// Position of CLR4 field.
	SCT_OUT_CLR_CLR4_Pos = 0x4
	// Bit mask of CLR4 field.
	SCT_OUT_CLR_CLR4_Msk = 0x10
	// Bit CLR4.
	SCT_OUT_CLR_CLR4 = 0x10
	// Position of CLR5 field.
	SCT_OUT_CLR_CLR5_Pos = 0x5
	// Bit mask of CLR5 field.
	SCT_OUT_CLR_CLR5_Msk = 0x20
	// Bit CLR5.
	SCT_OUT_CLR_CLR5 = 0x20
	// Position of CLR6 field.
	SCT_OUT_CLR_CLR6_Pos = 0x6
	// Bit mask of CLR6 field.
	SCT_OUT_CLR_CLR6_Msk = 0x40
	// Bit CLR6.
	SCT_OUT_CLR_CLR6 = 0x40
	// Position of CLR7 field.
	SCT_OUT_CLR_CLR7_Pos = 0x7
	// Bit mask of CLR7 field.
	SCT_OUT_CLR_CLR7_Msk = 0x80
	// Bit CLR7.
	SCT_OUT_CLR_CLR7 = 0x80
	// Position of CLR8 field.
	SCT_OUT_CLR_CLR8_Pos = 0x8
	// Bit mask of CLR8 field.
	SCT_OUT_CLR_CLR8_Msk = 0x100
	// Bit CLR8.
	SCT_OUT_CLR_CLR8 = 0x100
	// Position of CLR9 field.
	SCT_OUT_CLR_CLR9_Pos = 0x9
	// Bit mask of CLR9 field.
	SCT_OUT_CLR_CLR9_Msk = 0x200
	// Bit CLR9.
	SCT_OUT_CLR_CLR9 = 0x200
	// Position of CLR10 field.
	SCT_OUT_CLR_CLR10_Pos = 0xa
	// Bit mask of CLR10 field.
	SCT_OUT_CLR_CLR10_Msk = 0x400
	// Bit CLR10.
	SCT_OUT_CLR_CLR10 = 0x400
	// Position of CLR11 field.
	SCT_OUT_CLR_CLR11_Pos = 0xb
	// Bit mask of CLR11 field.
	SCT_OUT_CLR_CLR11_Msk = 0x800
	// Bit CLR11.
	SCT_OUT_CLR_CLR11 = 0x800
	// Position of CLR12 field.
	SCT_OUT_CLR_CLR12_Pos = 0xc
	// Bit mask of CLR12 field.
	SCT_OUT_CLR_CLR12_Msk = 0x1000
	// Bit CLR12.
	SCT_OUT_CLR_CLR12 = 0x1000
	// Position of CLR13 field.
	SCT_OUT_CLR_CLR13_Pos = 0xd
	// Bit mask of CLR13 field.
	SCT_OUT_CLR_CLR13_Msk = 0x2000
	// Bit CLR13.
	SCT_OUT_CLR_CLR13 = 0x2000
	// Position of CLR14 field.
	SCT_OUT_CLR_CLR14_Pos = 0xe
	// Bit mask of CLR14 field.
	SCT_OUT_CLR_CLR14_Msk = 0x4000
	// Bit CLR14.
	SCT_OUT_CLR_CLR14 = 0x4000
	// Position of CLR15 field.
	SCT_OUT_CLR_CLR15_Pos = 0xf
	// Bit mask of CLR15 field.
	SCT_OUT_CLR_CLR15_Msk = 0x8000
	// Bit CLR15.
	SCT_OUT_CLR_CLR15 = 0x8000
	// Position of RESERVED field.
	SCT_OUT_CLR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT_OUT_CLR_RESERVED_Msk = 0xffff0000
)

// Bitfields for GPDMA: General Purpose DMA (GPDMA)
const (
	// INTSTAT: DMA Interrupt Status Register
	// Position of INTSTAT0 field.
	GPDMA_INTSTAT_INTSTAT0_Pos = 0x0
	// Bit mask of INTSTAT0 field.
	GPDMA_INTSTAT_INTSTAT0_Msk = 0x1
	// Bit INTSTAT0.
	GPDMA_INTSTAT_INTSTAT0 = 0x1
	// Position of INTSTAT1 field.
	GPDMA_INTSTAT_INTSTAT1_Pos = 0x1
	// Bit mask of INTSTAT1 field.
	GPDMA_INTSTAT_INTSTAT1_Msk = 0x2
	// Bit INTSTAT1.
	GPDMA_INTSTAT_INTSTAT1 = 0x2
	// Position of INTSTAT2 field.
	GPDMA_INTSTAT_INTSTAT2_Pos = 0x2
	// Bit mask of INTSTAT2 field.
	GPDMA_INTSTAT_INTSTAT2_Msk = 0x4
	// Bit INTSTAT2.
	GPDMA_INTSTAT_INTSTAT2 = 0x4
	// Position of INTSTAT3 field.
	GPDMA_INTSTAT_INTSTAT3_Pos = 0x3
	// Bit mask of INTSTAT3 field.
	GPDMA_INTSTAT_INTSTAT3_Msk = 0x8
	// Bit INTSTAT3.
	GPDMA_INTSTAT_INTSTAT3 = 0x8
	// Position of INTSTAT4 field.
	GPDMA_INTSTAT_INTSTAT4_Pos = 0x4
	// Bit mask of INTSTAT4 field.
	GPDMA_INTSTAT_INTSTAT4_Msk = 0x10
	// Bit INTSTAT4.
	GPDMA_INTSTAT_INTSTAT4 = 0x10
	// Position of INTSTAT5 field.
	GPDMA_INTSTAT_INTSTAT5_Pos = 0x5
	// Bit mask of INTSTAT5 field.
	GPDMA_INTSTAT_INTSTAT5_Msk = 0x20
	// Bit INTSTAT5.
	GPDMA_INTSTAT_INTSTAT5 = 0x20
	// Position of INTSTAT6 field.
	GPDMA_INTSTAT_INTSTAT6_Pos = 0x6
	// Bit mask of INTSTAT6 field.
	GPDMA_INTSTAT_INTSTAT6_Msk = 0x40
	// Bit INTSTAT6.
	GPDMA_INTSTAT_INTSTAT6 = 0x40
	// Position of INTSTAT7 field.
	GPDMA_INTSTAT_INTSTAT7_Pos = 0x7
	// Bit mask of INTSTAT7 field.
	GPDMA_INTSTAT_INTSTAT7_Msk = 0x80
	// Bit INTSTAT7.
	GPDMA_INTSTAT_INTSTAT7 = 0x80
	// Position of RESERVED field.
	GPDMA_INTSTAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_INTSTAT_RESERVED_Msk = 0xffffff00

	// INTTCSTAT: DMA Interrupt Terminal Count Request Status Register
	// Position of INTTCSTAT0 field.
	GPDMA_INTTCSTAT_INTTCSTAT0_Pos = 0x0
	// Bit mask of INTTCSTAT0 field.
	GPDMA_INTTCSTAT_INTTCSTAT0_Msk = 0x1
	// Bit INTTCSTAT0.
	GPDMA_INTTCSTAT_INTTCSTAT0 = 0x1
	// Position of INTTCSTAT1 field.
	GPDMA_INTTCSTAT_INTTCSTAT1_Pos = 0x1
	// Bit mask of INTTCSTAT1 field.
	GPDMA_INTTCSTAT_INTTCSTAT1_Msk = 0x2
	// Bit INTTCSTAT1.
	GPDMA_INTTCSTAT_INTTCSTAT1 = 0x2
	// Position of INTTCSTAT2 field.
	GPDMA_INTTCSTAT_INTTCSTAT2_Pos = 0x2
	// Bit mask of INTTCSTAT2 field.
	GPDMA_INTTCSTAT_INTTCSTAT2_Msk = 0x4
	// Bit INTTCSTAT2.
	GPDMA_INTTCSTAT_INTTCSTAT2 = 0x4
	// Position of INTTCSTAT3 field.
	GPDMA_INTTCSTAT_INTTCSTAT3_Pos = 0x3
	// Bit mask of INTTCSTAT3 field.
	GPDMA_INTTCSTAT_INTTCSTAT3_Msk = 0x8
	// Bit INTTCSTAT3.
	GPDMA_INTTCSTAT_INTTCSTAT3 = 0x8
	// Position of INTTCSTAT4 field.
	GPDMA_INTTCSTAT_INTTCSTAT4_Pos = 0x4
	// Bit mask of INTTCSTAT4 field.
	GPDMA_INTTCSTAT_INTTCSTAT4_Msk = 0x10
	// Bit INTTCSTAT4.
	GPDMA_INTTCSTAT_INTTCSTAT4 = 0x10
	// Position of INTTCSTAT5 field.
	GPDMA_INTTCSTAT_INTTCSTAT5_Pos = 0x5
	// Bit mask of INTTCSTAT5 field.
	GPDMA_INTTCSTAT_INTTCSTAT5_Msk = 0x20
	// Bit INTTCSTAT5.
	GPDMA_INTTCSTAT_INTTCSTAT5 = 0x20
	// Position of INTTCSTAT6 field.
	GPDMA_INTTCSTAT_INTTCSTAT6_Pos = 0x6
	// Bit mask of INTTCSTAT6 field.
	GPDMA_INTTCSTAT_INTTCSTAT6_Msk = 0x40
	// Bit INTTCSTAT6.
	GPDMA_INTTCSTAT_INTTCSTAT6 = 0x40
	// Position of INTTCSTAT7 field.
	GPDMA_INTTCSTAT_INTTCSTAT7_Pos = 0x7
	// Bit mask of INTTCSTAT7 field.
	GPDMA_INTTCSTAT_INTTCSTAT7_Msk = 0x80
	// Bit INTTCSTAT7.
	GPDMA_INTTCSTAT_INTTCSTAT7 = 0x80
	// Position of RESERVED field.
	GPDMA_INTTCSTAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_INTTCSTAT_RESERVED_Msk = 0xffffff00

	// INTTCCLEAR: DMA Interrupt Terminal Count Request Clear Register
	// Position of INTTCCLEAR0 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR0_Pos = 0x0
	// Bit mask of INTTCCLEAR0 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR0_Msk = 0x1
	// Bit INTTCCLEAR0.
	GPDMA_INTTCCLEAR_INTTCCLEAR0 = 0x1
	// Position of INTTCCLEAR1 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR1_Pos = 0x1
	// Bit mask of INTTCCLEAR1 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR1_Msk = 0x2
	// Bit INTTCCLEAR1.
	GPDMA_INTTCCLEAR_INTTCCLEAR1 = 0x2
	// Position of INTTCCLEAR2 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR2_Pos = 0x2
	// Bit mask of INTTCCLEAR2 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR2_Msk = 0x4
	// Bit INTTCCLEAR2.
	GPDMA_INTTCCLEAR_INTTCCLEAR2 = 0x4
	// Position of INTTCCLEAR3 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR3_Pos = 0x3
	// Bit mask of INTTCCLEAR3 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR3_Msk = 0x8
	// Bit INTTCCLEAR3.
	GPDMA_INTTCCLEAR_INTTCCLEAR3 = 0x8
	// Position of INTTCCLEAR4 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR4_Pos = 0x4
	// Bit mask of INTTCCLEAR4 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR4_Msk = 0x10
	// Bit INTTCCLEAR4.
	GPDMA_INTTCCLEAR_INTTCCLEAR4 = 0x10
	// Position of INTTCCLEAR5 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR5_Pos = 0x5
	// Bit mask of INTTCCLEAR5 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR5_Msk = 0x20
	// Bit INTTCCLEAR5.
	GPDMA_INTTCCLEAR_INTTCCLEAR5 = 0x20
	// Position of INTTCCLEAR6 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR6_Pos = 0x6
	// Bit mask of INTTCCLEAR6 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR6_Msk = 0x40
	// Bit INTTCCLEAR6.
	GPDMA_INTTCCLEAR_INTTCCLEAR6 = 0x40
	// Position of INTTCCLEAR7 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR7_Pos = 0x7
	// Bit mask of INTTCCLEAR7 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR7_Msk = 0x80
	// Bit INTTCCLEAR7.
	GPDMA_INTTCCLEAR_INTTCCLEAR7 = 0x80
	// Position of RESERVED field.
	GPDMA_INTTCCLEAR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_INTTCCLEAR_RESERVED_Msk = 0xffffff00

	// INTERRSTAT: DMA Interrupt Error Status Register
	// Position of INTERRSTAT0 field.
	GPDMA_INTERRSTAT_INTERRSTAT0_Pos = 0x0
	// Bit mask of INTERRSTAT0 field.
	GPDMA_INTERRSTAT_INTERRSTAT0_Msk = 0x1
	// Bit INTERRSTAT0.
	GPDMA_INTERRSTAT_INTERRSTAT0 = 0x1
	// Position of INTERRSTAT1 field.
	GPDMA_INTERRSTAT_INTERRSTAT1_Pos = 0x1
	// Bit mask of INTERRSTAT1 field.
	GPDMA_INTERRSTAT_INTERRSTAT1_Msk = 0x2
	// Bit INTERRSTAT1.
	GPDMA_INTERRSTAT_INTERRSTAT1 = 0x2
	// Position of INTERRSTAT2 field.
	GPDMA_INTERRSTAT_INTERRSTAT2_Pos = 0x2
	// Bit mask of INTERRSTAT2 field.
	GPDMA_INTERRSTAT_INTERRSTAT2_Msk = 0x4
	// Bit INTERRSTAT2.
	GPDMA_INTERRSTAT_INTERRSTAT2 = 0x4
	// Position of INTERRSTAT3 field.
	GPDMA_INTERRSTAT_INTERRSTAT3_Pos = 0x3
	// Bit mask of INTERRSTAT3 field.
	GPDMA_INTERRSTAT_INTERRSTAT3_Msk = 0x8
	// Bit INTERRSTAT3.
	GPDMA_INTERRSTAT_INTERRSTAT3 = 0x8
	// Position of INTERRSTAT4 field.
	GPDMA_INTERRSTAT_INTERRSTAT4_Pos = 0x4
	// Bit mask of INTERRSTAT4 field.
	GPDMA_INTERRSTAT_INTERRSTAT4_Msk = 0x10
	// Bit INTERRSTAT4.
	GPDMA_INTERRSTAT_INTERRSTAT4 = 0x10
	// Position of INTERRSTAT5 field.
	GPDMA_INTERRSTAT_INTERRSTAT5_Pos = 0x5
	// Bit mask of INTERRSTAT5 field.
	GPDMA_INTERRSTAT_INTERRSTAT5_Msk = 0x20
	// Bit INTERRSTAT5.
	GPDMA_INTERRSTAT_INTERRSTAT5 = 0x20
	// Position of INTERRSTAT6 field.
	GPDMA_INTERRSTAT_INTERRSTAT6_Pos = 0x6
	// Bit mask of INTERRSTAT6 field.
	GPDMA_INTERRSTAT_INTERRSTAT6_Msk = 0x40
	// Bit INTERRSTAT6.
	GPDMA_INTERRSTAT_INTERRSTAT6 = 0x40
	// Position of INTERRSTAT7 field.
	GPDMA_INTERRSTAT_INTERRSTAT7_Pos = 0x7
	// Bit mask of INTERRSTAT7 field.
	GPDMA_INTERRSTAT_INTERRSTAT7_Msk = 0x80
	// Bit INTERRSTAT7.
	GPDMA_INTERRSTAT_INTERRSTAT7 = 0x80
	// Position of RESERVED field.
	GPDMA_INTERRSTAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_INTERRSTAT_RESERVED_Msk = 0xffffff00

	// INTERRCLR: DMA Interrupt Error Clear Register
	// Position of INTERRCLR0 field.
	GPDMA_INTERRCLR_INTERRCLR0_Pos = 0x0
	// Bit mask of INTERRCLR0 field.
	GPDMA_INTERRCLR_INTERRCLR0_Msk = 0x1
	// Bit INTERRCLR0.
	GPDMA_INTERRCLR_INTERRCLR0 = 0x1
	// Position of INTERRCLR1 field.
	GPDMA_INTERRCLR_INTERRCLR1_Pos = 0x1
	// Bit mask of INTERRCLR1 field.
	GPDMA_INTERRCLR_INTERRCLR1_Msk = 0x2
	// Bit INTERRCLR1.
	GPDMA_INTERRCLR_INTERRCLR1 = 0x2
	// Position of INTERRCLR2 field.
	GPDMA_INTERRCLR_INTERRCLR2_Pos = 0x2
	// Bit mask of INTERRCLR2 field.
	GPDMA_INTERRCLR_INTERRCLR2_Msk = 0x4
	// Bit INTERRCLR2.
	GPDMA_INTERRCLR_INTERRCLR2 = 0x4
	// Position of INTERRCLR3 field.
	GPDMA_INTERRCLR_INTERRCLR3_Pos = 0x3
	// Bit mask of INTERRCLR3 field.
	GPDMA_INTERRCLR_INTERRCLR3_Msk = 0x8
	// Bit INTERRCLR3.
	GPDMA_INTERRCLR_INTERRCLR3 = 0x8
	// Position of INTERRCLR4 field.
	GPDMA_INTERRCLR_INTERRCLR4_Pos = 0x4
	// Bit mask of INTERRCLR4 field.
	GPDMA_INTERRCLR_INTERRCLR4_Msk = 0x10
	// Bit INTERRCLR4.
	GPDMA_INTERRCLR_INTERRCLR4 = 0x10
	// Position of INTERRCLR5 field.
	GPDMA_INTERRCLR_INTERRCLR5_Pos = 0x5
	// Bit mask of INTERRCLR5 field.
	GPDMA_INTERRCLR_INTERRCLR5_Msk = 0x20
	// Bit INTERRCLR5.
	GPDMA_INTERRCLR_INTERRCLR5 = 0x20
	// Position of INTERRCLR6 field.
	GPDMA_INTERRCLR_INTERRCLR6_Pos = 0x6
	// Bit mask of INTERRCLR6 field.
	GPDMA_INTERRCLR_INTERRCLR6_Msk = 0x40
	// Bit INTERRCLR6.
	GPDMA_INTERRCLR_INTERRCLR6 = 0x40
	// Position of INTERRCLR7 field.
	GPDMA_INTERRCLR_INTERRCLR7_Pos = 0x7
	// Bit mask of INTERRCLR7 field.
	GPDMA_INTERRCLR_INTERRCLR7_Msk = 0x80
	// Bit INTERRCLR7.
	GPDMA_INTERRCLR_INTERRCLR7 = 0x80
	// Position of RESERVED field.
	GPDMA_INTERRCLR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_INTERRCLR_RESERVED_Msk = 0xffffff00

	// RAWINTTCSTAT: DMA Raw Interrupt Terminal Count Status Register
	// Position of RAWINTTCSTAT0 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Pos = 0x0
	// Bit mask of RAWINTTCSTAT0 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Msk = 0x1
	// Bit RAWINTTCSTAT0.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0 = 0x1
	// Position of RAWINTTCSTAT1 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Pos = 0x1
	// Bit mask of RAWINTTCSTAT1 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Msk = 0x2
	// Bit RAWINTTCSTAT1.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1 = 0x2
	// Position of RAWINTTCSTAT2 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Pos = 0x2
	// Bit mask of RAWINTTCSTAT2 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Msk = 0x4
	// Bit RAWINTTCSTAT2.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2 = 0x4
	// Position of RAWINTTCSTAT3 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Pos = 0x3
	// Bit mask of RAWINTTCSTAT3 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Msk = 0x8
	// Bit RAWINTTCSTAT3.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3 = 0x8
	// Position of RAWINTTCSTAT4 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Pos = 0x4
	// Bit mask of RAWINTTCSTAT4 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Msk = 0x10
	// Bit RAWINTTCSTAT4.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4 = 0x10
	// Position of RAWINTTCSTAT5 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Pos = 0x5
	// Bit mask of RAWINTTCSTAT5 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Msk = 0x20
	// Bit RAWINTTCSTAT5.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5 = 0x20
	// Position of RAWINTTCSTAT6 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Pos = 0x6
	// Bit mask of RAWINTTCSTAT6 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Msk = 0x40
	// Bit RAWINTTCSTAT6.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6 = 0x40
	// Position of RAWINTTCSTAT7 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Pos = 0x7
	// Bit mask of RAWINTTCSTAT7 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Msk = 0x80
	// Bit RAWINTTCSTAT7.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7 = 0x80
	// Position of RESERVED field.
	GPDMA_RAWINTTCSTAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_RAWINTTCSTAT_RESERVED_Msk = 0xffffff00

	// RAWINTERRSTAT: DMA Raw Error Interrupt Status Register
	// Position of RAWINTERRSTAT0 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Pos = 0x0
	// Bit mask of RAWINTERRSTAT0 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Msk = 0x1
	// Bit RAWINTERRSTAT0.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0 = 0x1
	// Position of RAWINTERRSTAT1 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Pos = 0x1
	// Bit mask of RAWINTERRSTAT1 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Msk = 0x2
	// Bit RAWINTERRSTAT1.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1 = 0x2
	// Position of RAWINTERRSTAT2 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Pos = 0x2
	// Bit mask of RAWINTERRSTAT2 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Msk = 0x4
	// Bit RAWINTERRSTAT2.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2 = 0x4
	// Position of RAWINTERRSTAT3 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Pos = 0x3
	// Bit mask of RAWINTERRSTAT3 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Msk = 0x8
	// Bit RAWINTERRSTAT3.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3 = 0x8
	// Position of RAWINTERRSTAT4 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Pos = 0x4
	// Bit mask of RAWINTERRSTAT4 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Msk = 0x10
	// Bit RAWINTERRSTAT4.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4 = 0x10
	// Position of RAWINTERRSTAT5 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Pos = 0x5
	// Bit mask of RAWINTERRSTAT5 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Msk = 0x20
	// Bit RAWINTERRSTAT5.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5 = 0x20
	// Position of RAWINTERRSTAT6 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Pos = 0x6
	// Bit mask of RAWINTERRSTAT6 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Msk = 0x40
	// Bit RAWINTERRSTAT6.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6 = 0x40
	// Position of RAWINTERRSTAT7 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Pos = 0x7
	// Bit mask of RAWINTERRSTAT7 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Msk = 0x80
	// Bit RAWINTERRSTAT7.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7 = 0x80
	// Position of RESERVED field.
	GPDMA_RAWINTERRSTAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_RAWINTERRSTAT_RESERVED_Msk = 0xffffff00

	// ENBLDCHNS: DMA Enabled Channel Register
	// Position of ENABLEDCHANNELS0 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Pos = 0x0
	// Bit mask of ENABLEDCHANNELS0 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Msk = 0x1
	// Bit ENABLEDCHANNELS0.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS0 = 0x1
	// Position of ENABLEDCHANNELS1 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Pos = 0x1
	// Bit mask of ENABLEDCHANNELS1 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Msk = 0x2
	// Bit ENABLEDCHANNELS1.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS1 = 0x2
	// Position of ENABLEDCHANNELS2 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Pos = 0x2
	// Bit mask of ENABLEDCHANNELS2 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Msk = 0x4
	// Bit ENABLEDCHANNELS2.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS2 = 0x4
	// Position of ENABLEDCHANNELS3 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Pos = 0x3
	// Bit mask of ENABLEDCHANNELS3 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Msk = 0x8
	// Bit ENABLEDCHANNELS3.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS3 = 0x8
	// Position of ENABLEDCHANNELS4 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Pos = 0x4
	// Bit mask of ENABLEDCHANNELS4 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Msk = 0x10
	// Bit ENABLEDCHANNELS4.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS4 = 0x10
	// Position of ENABLEDCHANNELS5 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Pos = 0x5
	// Bit mask of ENABLEDCHANNELS5 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Msk = 0x20
	// Bit ENABLEDCHANNELS5.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS5 = 0x20
	// Position of ENABLEDCHANNELS6 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Pos = 0x6
	// Bit mask of ENABLEDCHANNELS6 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Msk = 0x40
	// Bit ENABLEDCHANNELS6.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS6 = 0x40
	// Position of ENABLEDCHANNELS7 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Pos = 0x7
	// Bit mask of ENABLEDCHANNELS7 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Msk = 0x80
	// Bit ENABLEDCHANNELS7.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS7 = 0x80
	// Position of RESERVED field.
	GPDMA_ENBLDCHNS_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_ENBLDCHNS_RESERVED_Msk = 0xffffff00

	// SOFTBREQ: DMA Software Burst Request Register
	// Position of SOFTBREQ0 field.
	GPDMA_SOFTBREQ_SOFTBREQ0_Pos = 0x0
	// Bit mask of SOFTBREQ0 field.
	GPDMA_SOFTBREQ_SOFTBREQ0_Msk = 0x1
	// Bit SOFTBREQ0.
	GPDMA_SOFTBREQ_SOFTBREQ0 = 0x1
	// Position of SOFTBREQ1 field.
	GPDMA_SOFTBREQ_SOFTBREQ1_Pos = 0x1
	// Bit mask of SOFTBREQ1 field.
	GPDMA_SOFTBREQ_SOFTBREQ1_Msk = 0x2
	// Bit SOFTBREQ1.
	GPDMA_SOFTBREQ_SOFTBREQ1 = 0x2
	// Position of SOFTBREQ2 field.
	GPDMA_SOFTBREQ_SOFTBREQ2_Pos = 0x2
	// Bit mask of SOFTBREQ2 field.
	GPDMA_SOFTBREQ_SOFTBREQ2_Msk = 0x4
	// Bit SOFTBREQ2.
	GPDMA_SOFTBREQ_SOFTBREQ2 = 0x4
	// Position of SOFTBREQ3 field.
	GPDMA_SOFTBREQ_SOFTBREQ3_Pos = 0x3
	// Bit mask of SOFTBREQ3 field.
	GPDMA_SOFTBREQ_SOFTBREQ3_Msk = 0x8
	// Bit SOFTBREQ3.
	GPDMA_SOFTBREQ_SOFTBREQ3 = 0x8
	// Position of SOFTBREQ4 field.
	GPDMA_SOFTBREQ_SOFTBREQ4_Pos = 0x4
	// Bit mask of SOFTBREQ4 field.
	GPDMA_SOFTBREQ_SOFTBREQ4_Msk = 0x10
	// Bit SOFTBREQ4.
	GPDMA_SOFTBREQ_SOFTBREQ4 = 0x10
	// Position of SOFTBREQ5 field.
	GPDMA_SOFTBREQ_SOFTBREQ5_Pos = 0x5
	// Bit mask of SOFTBREQ5 field.
	GPDMA_SOFTBREQ_SOFTBREQ5_Msk = 0x20
	// Bit SOFTBREQ5.
	GPDMA_SOFTBREQ_SOFTBREQ5 = 0x20
	// Position of SOFTBREQ6 field.
	GPDMA_SOFTBREQ_SOFTBREQ6_Pos = 0x6
	// Bit mask of SOFTBREQ6 field.
	GPDMA_SOFTBREQ_SOFTBREQ6_Msk = 0x40
	// Bit SOFTBREQ6.
	GPDMA_SOFTBREQ_SOFTBREQ6 = 0x40
	// Position of SOFTBREQ7 field.
	GPDMA_SOFTBREQ_SOFTBREQ7_Pos = 0x7
	// Bit mask of SOFTBREQ7 field.
	GPDMA_SOFTBREQ_SOFTBREQ7_Msk = 0x80
	// Bit SOFTBREQ7.
	GPDMA_SOFTBREQ_SOFTBREQ7 = 0x80
	// Position of SOFTBREQ8 field.
	GPDMA_SOFTBREQ_SOFTBREQ8_Pos = 0x8
	// Bit mask of SOFTBREQ8 field.
	GPDMA_SOFTBREQ_SOFTBREQ8_Msk = 0x100
	// Bit SOFTBREQ8.
	GPDMA_SOFTBREQ_SOFTBREQ8 = 0x100
	// Position of SOFTBREQ9 field.
	GPDMA_SOFTBREQ_SOFTBREQ9_Pos = 0x9
	// Bit mask of SOFTBREQ9 field.
	GPDMA_SOFTBREQ_SOFTBREQ9_Msk = 0x200
	// Bit SOFTBREQ9.
	GPDMA_SOFTBREQ_SOFTBREQ9 = 0x200
	// Position of SOFTBREQ10 field.
	GPDMA_SOFTBREQ_SOFTBREQ10_Pos = 0xa
	// Bit mask of SOFTBREQ10 field.
	GPDMA_SOFTBREQ_SOFTBREQ10_Msk = 0x400
	// Bit SOFTBREQ10.
	GPDMA_SOFTBREQ_SOFTBREQ10 = 0x400
	// Position of SOFTBREQ11 field.
	GPDMA_SOFTBREQ_SOFTBREQ11_Pos = 0xb
	// Bit mask of SOFTBREQ11 field.
	GPDMA_SOFTBREQ_SOFTBREQ11_Msk = 0x800
	// Bit SOFTBREQ11.
	GPDMA_SOFTBREQ_SOFTBREQ11 = 0x800
	// Position of SOFTBREQ12 field.
	GPDMA_SOFTBREQ_SOFTBREQ12_Pos = 0xc
	// Bit mask of SOFTBREQ12 field.
	GPDMA_SOFTBREQ_SOFTBREQ12_Msk = 0x1000
	// Bit SOFTBREQ12.
	GPDMA_SOFTBREQ_SOFTBREQ12 = 0x1000
	// Position of SOFTBREQ13 field.
	GPDMA_SOFTBREQ_SOFTBREQ13_Pos = 0xd
	// Bit mask of SOFTBREQ13 field.
	GPDMA_SOFTBREQ_SOFTBREQ13_Msk = 0x2000
	// Bit SOFTBREQ13.
	GPDMA_SOFTBREQ_SOFTBREQ13 = 0x2000
	// Position of SOFTBREQ14 field.
	GPDMA_SOFTBREQ_SOFTBREQ14_Pos = 0xe
	// Bit mask of SOFTBREQ14 field.
	GPDMA_SOFTBREQ_SOFTBREQ14_Msk = 0x4000
	// Bit SOFTBREQ14.
	GPDMA_SOFTBREQ_SOFTBREQ14 = 0x4000
	// Position of SOFTBREQ15 field.
	GPDMA_SOFTBREQ_SOFTBREQ15_Pos = 0xf
	// Bit mask of SOFTBREQ15 field.
	GPDMA_SOFTBREQ_SOFTBREQ15_Msk = 0x8000
	// Bit SOFTBREQ15.
	GPDMA_SOFTBREQ_SOFTBREQ15 = 0x8000
	// Position of RESERVED field.
	GPDMA_SOFTBREQ_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	GPDMA_SOFTBREQ_RESERVED_Msk = 0xffff0000

	// SOFTSREQ: DMA Software Single Request Register
	// Position of SOFTSREQ0 field.
	GPDMA_SOFTSREQ_SOFTSREQ0_Pos = 0x0
	// Bit mask of SOFTSREQ0 field.
	GPDMA_SOFTSREQ_SOFTSREQ0_Msk = 0x1
	// Bit SOFTSREQ0.
	GPDMA_SOFTSREQ_SOFTSREQ0 = 0x1
	// Position of SOFTSREQ1 field.
	GPDMA_SOFTSREQ_SOFTSREQ1_Pos = 0x1
	// Bit mask of SOFTSREQ1 field.
	GPDMA_SOFTSREQ_SOFTSREQ1_Msk = 0x2
	// Bit SOFTSREQ1.
	GPDMA_SOFTSREQ_SOFTSREQ1 = 0x2
	// Position of SOFTSREQ2 field.
	GPDMA_SOFTSREQ_SOFTSREQ2_Pos = 0x2
	// Bit mask of SOFTSREQ2 field.
	GPDMA_SOFTSREQ_SOFTSREQ2_Msk = 0x4
	// Bit SOFTSREQ2.
	GPDMA_SOFTSREQ_SOFTSREQ2 = 0x4
	// Position of SOFTSREQ3 field.
	GPDMA_SOFTSREQ_SOFTSREQ3_Pos = 0x3
	// Bit mask of SOFTSREQ3 field.
	GPDMA_SOFTSREQ_SOFTSREQ3_Msk = 0x8
	// Bit SOFTSREQ3.
	GPDMA_SOFTSREQ_SOFTSREQ3 = 0x8
	// Position of SOFTSREQ4 field.
	GPDMA_SOFTSREQ_SOFTSREQ4_Pos = 0x4
	// Bit mask of SOFTSREQ4 field.
	GPDMA_SOFTSREQ_SOFTSREQ4_Msk = 0x10
	// Bit SOFTSREQ4.
	GPDMA_SOFTSREQ_SOFTSREQ4 = 0x10
	// Position of SOFTSREQ5 field.
	GPDMA_SOFTSREQ_SOFTSREQ5_Pos = 0x5
	// Bit mask of SOFTSREQ5 field.
	GPDMA_SOFTSREQ_SOFTSREQ5_Msk = 0x20
	// Bit SOFTSREQ5.
	GPDMA_SOFTSREQ_SOFTSREQ5 = 0x20
	// Position of SOFTSREQ6 field.
	GPDMA_SOFTSREQ_SOFTSREQ6_Pos = 0x6
	// Bit mask of SOFTSREQ6 field.
	GPDMA_SOFTSREQ_SOFTSREQ6_Msk = 0x40
	// Bit SOFTSREQ6.
	GPDMA_SOFTSREQ_SOFTSREQ6 = 0x40
	// Position of SOFTSREQ7 field.
	GPDMA_SOFTSREQ_SOFTSREQ7_Pos = 0x7
	// Bit mask of SOFTSREQ7 field.
	GPDMA_SOFTSREQ_SOFTSREQ7_Msk = 0x80
	// Bit SOFTSREQ7.
	GPDMA_SOFTSREQ_SOFTSREQ7 = 0x80
	// Position of SOFTSREQ8 field.
	GPDMA_SOFTSREQ_SOFTSREQ8_Pos = 0x8
	// Bit mask of SOFTSREQ8 field.
	GPDMA_SOFTSREQ_SOFTSREQ8_Msk = 0x100
	// Bit SOFTSREQ8.
	GPDMA_SOFTSREQ_SOFTSREQ8 = 0x100
	// Position of SOFTSREQ9 field.
	GPDMA_SOFTSREQ_SOFTSREQ9_Pos = 0x9
	// Bit mask of SOFTSREQ9 field.
	GPDMA_SOFTSREQ_SOFTSREQ9_Msk = 0x200
	// Bit SOFTSREQ9.
	GPDMA_SOFTSREQ_SOFTSREQ9 = 0x200
	// Position of SOFTSREQ10 field.
	GPDMA_SOFTSREQ_SOFTSREQ10_Pos = 0xa
	// Bit mask of SOFTSREQ10 field.
	GPDMA_SOFTSREQ_SOFTSREQ10_Msk = 0x400
	// Bit SOFTSREQ10.
	GPDMA_SOFTSREQ_SOFTSREQ10 = 0x400
	// Position of SOFTSREQ11 field.
	GPDMA_SOFTSREQ_SOFTSREQ11_Pos = 0xb
	// Bit mask of SOFTSREQ11 field.
	GPDMA_SOFTSREQ_SOFTSREQ11_Msk = 0x800
	// Bit SOFTSREQ11.
	GPDMA_SOFTSREQ_SOFTSREQ11 = 0x800
	// Position of SOFTSREQ12 field.
	GPDMA_SOFTSREQ_SOFTSREQ12_Pos = 0xc
	// Bit mask of SOFTSREQ12 field.
	GPDMA_SOFTSREQ_SOFTSREQ12_Msk = 0x1000
	// Bit SOFTSREQ12.
	GPDMA_SOFTSREQ_SOFTSREQ12 = 0x1000
	// Position of SOFTSREQ13 field.
	GPDMA_SOFTSREQ_SOFTSREQ13_Pos = 0xd
	// Bit mask of SOFTSREQ13 field.
	GPDMA_SOFTSREQ_SOFTSREQ13_Msk = 0x2000
	// Bit SOFTSREQ13.
	GPDMA_SOFTSREQ_SOFTSREQ13 = 0x2000
	// Position of SOFTSREQ14 field.
	GPDMA_SOFTSREQ_SOFTSREQ14_Pos = 0xe
	// Bit mask of SOFTSREQ14 field.
	GPDMA_SOFTSREQ_SOFTSREQ14_Msk = 0x4000
	// Bit SOFTSREQ14.
	GPDMA_SOFTSREQ_SOFTSREQ14 = 0x4000
	// Position of SOFTSREQ15 field.
	GPDMA_SOFTSREQ_SOFTSREQ15_Pos = 0xf
	// Bit mask of SOFTSREQ15 field.
	GPDMA_SOFTSREQ_SOFTSREQ15_Msk = 0x8000
	// Bit SOFTSREQ15.
	GPDMA_SOFTSREQ_SOFTSREQ15 = 0x8000
	// Position of RESERVED field.
	GPDMA_SOFTSREQ_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	GPDMA_SOFTSREQ_RESERVED_Msk = 0xffff0000

	// SOFTLBREQ: DMA Software Last Burst Request Register
	// Position of SOFTLBREQ0 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ0_Pos = 0x0
	// Bit mask of SOFTLBREQ0 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ0_Msk = 0x1
	// Bit SOFTLBREQ0.
	GPDMA_SOFTLBREQ_SOFTLBREQ0 = 0x1
	// Position of SOFTLBREQ1 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ1_Pos = 0x1
	// Bit mask of SOFTLBREQ1 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ1_Msk = 0x2
	// Bit SOFTLBREQ1.
	GPDMA_SOFTLBREQ_SOFTLBREQ1 = 0x2
	// Position of SOFTLBREQ2 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ2_Pos = 0x2
	// Bit mask of SOFTLBREQ2 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ2_Msk = 0x4
	// Bit SOFTLBREQ2.
	GPDMA_SOFTLBREQ_SOFTLBREQ2 = 0x4
	// Position of SOFTLBREQ3 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ3_Pos = 0x3
	// Bit mask of SOFTLBREQ3 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ3_Msk = 0x8
	// Bit SOFTLBREQ3.
	GPDMA_SOFTLBREQ_SOFTLBREQ3 = 0x8
	// Position of SOFTLBREQ4 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ4_Pos = 0x4
	// Bit mask of SOFTLBREQ4 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ4_Msk = 0x10
	// Bit SOFTLBREQ4.
	GPDMA_SOFTLBREQ_SOFTLBREQ4 = 0x10
	// Position of SOFTLBREQ5 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ5_Pos = 0x5
	// Bit mask of SOFTLBREQ5 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ5_Msk = 0x20
	// Bit SOFTLBREQ5.
	GPDMA_SOFTLBREQ_SOFTLBREQ5 = 0x20
	// Position of SOFTLBREQ6 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ6_Pos = 0x6
	// Bit mask of SOFTLBREQ6 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ6_Msk = 0x40
	// Bit SOFTLBREQ6.
	GPDMA_SOFTLBREQ_SOFTLBREQ6 = 0x40
	// Position of SOFTLBREQ7 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ7_Pos = 0x7
	// Bit mask of SOFTLBREQ7 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ7_Msk = 0x80
	// Bit SOFTLBREQ7.
	GPDMA_SOFTLBREQ_SOFTLBREQ7 = 0x80
	// Position of SOFTLBREQ8 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ8_Pos = 0x8
	// Bit mask of SOFTLBREQ8 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ8_Msk = 0x100
	// Bit SOFTLBREQ8.
	GPDMA_SOFTLBREQ_SOFTLBREQ8 = 0x100
	// Position of SOFTLBREQ9 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ9_Pos = 0x9
	// Bit mask of SOFTLBREQ9 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ9_Msk = 0x200
	// Bit SOFTLBREQ9.
	GPDMA_SOFTLBREQ_SOFTLBREQ9 = 0x200
	// Position of SOFTLBREQ10 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ10_Pos = 0xa
	// Bit mask of SOFTLBREQ10 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ10_Msk = 0x400
	// Bit SOFTLBREQ10.
	GPDMA_SOFTLBREQ_SOFTLBREQ10 = 0x400
	// Position of SOFTLBREQ11 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ11_Pos = 0xb
	// Bit mask of SOFTLBREQ11 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ11_Msk = 0x800
	// Bit SOFTLBREQ11.
	GPDMA_SOFTLBREQ_SOFTLBREQ11 = 0x800
	// Position of SOFTLBREQ12 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ12_Pos = 0xc
	// Bit mask of SOFTLBREQ12 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ12_Msk = 0x1000
	// Bit SOFTLBREQ12.
	GPDMA_SOFTLBREQ_SOFTLBREQ12 = 0x1000
	// Position of SOFTLBREQ13 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ13_Pos = 0xd
	// Bit mask of SOFTLBREQ13 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ13_Msk = 0x2000
	// Bit SOFTLBREQ13.
	GPDMA_SOFTLBREQ_SOFTLBREQ13 = 0x2000
	// Position of SOFTLBREQ14 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ14_Pos = 0xe
	// Bit mask of SOFTLBREQ14 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ14_Msk = 0x4000
	// Bit SOFTLBREQ14.
	GPDMA_SOFTLBREQ_SOFTLBREQ14 = 0x4000
	// Position of SOFTLBREQ15 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ15_Pos = 0xf
	// Bit mask of SOFTLBREQ15 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ15_Msk = 0x8000
	// Bit SOFTLBREQ15.
	GPDMA_SOFTLBREQ_SOFTLBREQ15 = 0x8000
	// Position of RESERVED field.
	GPDMA_SOFTLBREQ_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	GPDMA_SOFTLBREQ_RESERVED_Msk = 0xffff0000

	// SOFTLSREQ: DMA Software Last Single Request Register
	// Position of SOFTLSREQ0 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ0_Pos = 0x0
	// Bit mask of SOFTLSREQ0 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ0_Msk = 0x1
	// Bit SOFTLSREQ0.
	GPDMA_SOFTLSREQ_SOFTLSREQ0 = 0x1
	// Position of SOFTLSREQ1 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ1_Pos = 0x1
	// Bit mask of SOFTLSREQ1 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ1_Msk = 0x2
	// Bit SOFTLSREQ1.
	GPDMA_SOFTLSREQ_SOFTLSREQ1 = 0x2
	// Position of SOFTLSREQ2 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ2_Pos = 0x2
	// Bit mask of SOFTLSREQ2 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ2_Msk = 0x4
	// Bit SOFTLSREQ2.
	GPDMA_SOFTLSREQ_SOFTLSREQ2 = 0x4
	// Position of SOFTLSREQ3 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ3_Pos = 0x3
	// Bit mask of SOFTLSREQ3 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ3_Msk = 0x8
	// Bit SOFTLSREQ3.
	GPDMA_SOFTLSREQ_SOFTLSREQ3 = 0x8
	// Position of SOFTLSREQ4 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ4_Pos = 0x4
	// Bit mask of SOFTLSREQ4 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ4_Msk = 0x10
	// Bit SOFTLSREQ4.
	GPDMA_SOFTLSREQ_SOFTLSREQ4 = 0x10
	// Position of SOFTLSREQ5 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ5_Pos = 0x5
	// Bit mask of SOFTLSREQ5 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ5_Msk = 0x20
	// Bit SOFTLSREQ5.
	GPDMA_SOFTLSREQ_SOFTLSREQ5 = 0x20
	// Position of SOFTLSREQ6 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ6_Pos = 0x6
	// Bit mask of SOFTLSREQ6 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ6_Msk = 0x40
	// Bit SOFTLSREQ6.
	GPDMA_SOFTLSREQ_SOFTLSREQ6 = 0x40
	// Position of SOFTLSREQ7 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ7_Pos = 0x7
	// Bit mask of SOFTLSREQ7 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ7_Msk = 0x80
	// Bit SOFTLSREQ7.
	GPDMA_SOFTLSREQ_SOFTLSREQ7 = 0x80
	// Position of SOFTLSREQ8 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ8_Pos = 0x8
	// Bit mask of SOFTLSREQ8 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ8_Msk = 0x100
	// Bit SOFTLSREQ8.
	GPDMA_SOFTLSREQ_SOFTLSREQ8 = 0x100
	// Position of SOFTLSREQ9 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ9_Pos = 0x9
	// Bit mask of SOFTLSREQ9 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ9_Msk = 0x200
	// Bit SOFTLSREQ9.
	GPDMA_SOFTLSREQ_SOFTLSREQ9 = 0x200
	// Position of SOFTLSREQ10 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ10_Pos = 0xa
	// Bit mask of SOFTLSREQ10 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ10_Msk = 0x400
	// Bit SOFTLSREQ10.
	GPDMA_SOFTLSREQ_SOFTLSREQ10 = 0x400
	// Position of SOFTLSREQ11 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ11_Pos = 0xb
	// Bit mask of SOFTLSREQ11 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ11_Msk = 0x800
	// Bit SOFTLSREQ11.
	GPDMA_SOFTLSREQ_SOFTLSREQ11 = 0x800
	// Position of SOFTLSREQ12 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ12_Pos = 0xc
	// Bit mask of SOFTLSREQ12 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ12_Msk = 0x1000
	// Bit SOFTLSREQ12.
	GPDMA_SOFTLSREQ_SOFTLSREQ12 = 0x1000
	// Position of SOFTLSREQ13 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ13_Pos = 0xd
	// Bit mask of SOFTLSREQ13 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ13_Msk = 0x2000
	// Bit SOFTLSREQ13.
	GPDMA_SOFTLSREQ_SOFTLSREQ13 = 0x2000
	// Position of SOFTLSREQ14 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ14_Pos = 0xe
	// Bit mask of SOFTLSREQ14 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ14_Msk = 0x4000
	// Bit SOFTLSREQ14.
	GPDMA_SOFTLSREQ_SOFTLSREQ14 = 0x4000
	// Position of SOFTLSREQ15 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ15_Pos = 0xf
	// Bit mask of SOFTLSREQ15 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ15_Msk = 0x8000
	// Bit SOFTLSREQ15.
	GPDMA_SOFTLSREQ_SOFTLSREQ15 = 0x8000
	// Position of RESERVED field.
	GPDMA_SOFTLSREQ_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	GPDMA_SOFTLSREQ_RESERVED_Msk = 0xffff0000

	// CONFIG: DMA Configuration Register
	// Position of E field.
	GPDMA_CONFIG_E_Pos = 0x0
	// Bit mask of E field.
	GPDMA_CONFIG_E_Msk = 0x1
	// Bit E.
	GPDMA_CONFIG_E = 0x1
	// Disabled (default). Disabling the DMA Controller reduces power consumption.
	GPDMA_CONFIG_E_DISABLED__DEFAULT_ = 0x0
	// Enabled
	GPDMA_CONFIG_E_ENABLED = 0x1
	// Position of M0 field.
	GPDMA_CONFIG_M0_Pos = 0x1
	// Bit mask of M0 field.
	GPDMA_CONFIG_M0_Msk = 0x2
	// Bit M0.
	GPDMA_CONFIG_M0 = 0x2
	// Little-endian mode (default).
	GPDMA_CONFIG_M0_LITTLE_ENDIAN_MODE = 0x0
	// Big-endian mode.
	GPDMA_CONFIG_M0_BIG_ENDIAN_MODE_ = 0x1
	// Position of M1 field.
	GPDMA_CONFIG_M1_Pos = 0x2
	// Bit mask of M1 field.
	GPDMA_CONFIG_M1_Msk = 0x4
	// Bit M1.
	GPDMA_CONFIG_M1 = 0x4
	// Little-endian mode (default).
	GPDMA_CONFIG_M1_LITTLE_ENDIAN_MODE = 0x0
	// Big-endian mode.
	GPDMA_CONFIG_M1_BIG_ENDIAN_MODE_ = 0x1
	// Position of RESERVED field.
	GPDMA_CONFIG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	GPDMA_CONFIG_RESERVED_Msk = 0xfffffff8

	// SYNC: DMA Synchronization Register
	// Position of DMACSYNC0 field.
	GPDMA_SYNC_DMACSYNC0_Pos = 0x0
	// Bit mask of DMACSYNC0 field.
	GPDMA_SYNC_DMACSYNC0_Msk = 0x1
	// Bit DMACSYNC0.
	GPDMA_SYNC_DMACSYNC0 = 0x1
	// Position of DMACSYNC1 field.
	GPDMA_SYNC_DMACSYNC1_Pos = 0x1
	// Bit mask of DMACSYNC1 field.
	GPDMA_SYNC_DMACSYNC1_Msk = 0x2
	// Bit DMACSYNC1.
	GPDMA_SYNC_DMACSYNC1 = 0x2
	// Position of DMACSYNC2 field.
	GPDMA_SYNC_DMACSYNC2_Pos = 0x2
	// Bit mask of DMACSYNC2 field.
	GPDMA_SYNC_DMACSYNC2_Msk = 0x4
	// Bit DMACSYNC2.
	GPDMA_SYNC_DMACSYNC2 = 0x4
	// Position of DMACSYNC3 field.
	GPDMA_SYNC_DMACSYNC3_Pos = 0x3
	// Bit mask of DMACSYNC3 field.
	GPDMA_SYNC_DMACSYNC3_Msk = 0x8
	// Bit DMACSYNC3.
	GPDMA_SYNC_DMACSYNC3 = 0x8
	// Position of DMACSYNC4 field.
	GPDMA_SYNC_DMACSYNC4_Pos = 0x4
	// Bit mask of DMACSYNC4 field.
	GPDMA_SYNC_DMACSYNC4_Msk = 0x10
	// Bit DMACSYNC4.
	GPDMA_SYNC_DMACSYNC4 = 0x10
	// Position of DMACSYNC5 field.
	GPDMA_SYNC_DMACSYNC5_Pos = 0x5
	// Bit mask of DMACSYNC5 field.
	GPDMA_SYNC_DMACSYNC5_Msk = 0x20
	// Bit DMACSYNC5.
	GPDMA_SYNC_DMACSYNC5 = 0x20
	// Position of DMACSYNC6 field.
	GPDMA_SYNC_DMACSYNC6_Pos = 0x6
	// Bit mask of DMACSYNC6 field.
	GPDMA_SYNC_DMACSYNC6_Msk = 0x40
	// Bit DMACSYNC6.
	GPDMA_SYNC_DMACSYNC6 = 0x40
	// Position of DMACSYNC7 field.
	GPDMA_SYNC_DMACSYNC7_Pos = 0x7
	// Bit mask of DMACSYNC7 field.
	GPDMA_SYNC_DMACSYNC7_Msk = 0x80
	// Bit DMACSYNC7.
	GPDMA_SYNC_DMACSYNC7 = 0x80
	// Position of DMACSYNC8 field.
	GPDMA_SYNC_DMACSYNC8_Pos = 0x8
	// Bit mask of DMACSYNC8 field.
	GPDMA_SYNC_DMACSYNC8_Msk = 0x100
	// Bit DMACSYNC8.
	GPDMA_SYNC_DMACSYNC8 = 0x100
	// Position of DMACSYNC9 field.
	GPDMA_SYNC_DMACSYNC9_Pos = 0x9
	// Bit mask of DMACSYNC9 field.
	GPDMA_SYNC_DMACSYNC9_Msk = 0x200
	// Bit DMACSYNC9.
	GPDMA_SYNC_DMACSYNC9 = 0x200
	// Position of DMACSYNC10 field.
	GPDMA_SYNC_DMACSYNC10_Pos = 0xa
	// Bit mask of DMACSYNC10 field.
	GPDMA_SYNC_DMACSYNC10_Msk = 0x400
	// Bit DMACSYNC10.
	GPDMA_SYNC_DMACSYNC10 = 0x400
	// Position of DMACSYNC11 field.
	GPDMA_SYNC_DMACSYNC11_Pos = 0xb
	// Bit mask of DMACSYNC11 field.
	GPDMA_SYNC_DMACSYNC11_Msk = 0x800
	// Bit DMACSYNC11.
	GPDMA_SYNC_DMACSYNC11 = 0x800
	// Position of DMACSYNC12 field.
	GPDMA_SYNC_DMACSYNC12_Pos = 0xc
	// Bit mask of DMACSYNC12 field.
	GPDMA_SYNC_DMACSYNC12_Msk = 0x1000
	// Bit DMACSYNC12.
	GPDMA_SYNC_DMACSYNC12 = 0x1000
	// Position of DMACSYNC13 field.
	GPDMA_SYNC_DMACSYNC13_Pos = 0xd
	// Bit mask of DMACSYNC13 field.
	GPDMA_SYNC_DMACSYNC13_Msk = 0x2000
	// Bit DMACSYNC13.
	GPDMA_SYNC_DMACSYNC13 = 0x2000
	// Position of DMACSYNC14 field.
	GPDMA_SYNC_DMACSYNC14_Pos = 0xe
	// Bit mask of DMACSYNC14 field.
	GPDMA_SYNC_DMACSYNC14_Msk = 0x4000
	// Bit DMACSYNC14.
	GPDMA_SYNC_DMACSYNC14 = 0x4000
	// Position of DMACSYNC15 field.
	GPDMA_SYNC_DMACSYNC15_Pos = 0xf
	// Bit mask of DMACSYNC15 field.
	GPDMA_SYNC_DMACSYNC15_Msk = 0x8000
	// Bit DMACSYNC15.
	GPDMA_SYNC_DMACSYNC15 = 0x8000
	// Position of RESERVED field.
	GPDMA_SYNC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	GPDMA_SYNC_RESERVED_Msk = 0xffff0000

	// C0SRCADDR: DMA Channel Source Address Register
	// Position of SRCADDR field.
	GPDMA_CSRCADDR_SRCADDR_Pos = 0x0
	// Bit mask of SRCADDR field.
	GPDMA_CSRCADDR_SRCADDR_Msk = 0xffffffff

	// C0DESTADDR: DMA Channel Destination Address Register
	// Position of DESTADDR field.
	GPDMA_CDESTADDR_DESTADDR_Pos = 0x0
	// Bit mask of DESTADDR field.
	GPDMA_CDESTADDR_DESTADDR_Msk = 0xffffffff

	// C0LLI: DMA Channel Linked List Item Register
	// Position of LM field.
	GPDMA_CLLI_LM_Pos = 0x0
	// Bit mask of LM field.
	GPDMA_CLLI_LM_Msk = 0x1
	// Bit LM.
	GPDMA_CLLI_LM = 0x1
	// AHB Master 0.
	GPDMA_CLLI_LM_AHB_MASTER_0_ = 0x0
	// AHB Master 1.
	GPDMA_CLLI_LM_AHB_MASTER_1_ = 0x1
	// Position of R field.
	GPDMA_CLLI_R_Pos = 0x1
	// Bit mask of R field.
	GPDMA_CLLI_R_Msk = 0x2
	// Bit R.
	GPDMA_CLLI_R = 0x2
	// Position of LLI field.
	GPDMA_CLLI_LLI_Pos = 0x2
	// Bit mask of LLI field.
	GPDMA_CLLI_LLI_Msk = 0xfffffffc

	// C0CONTROL: DMA Channel Control Register
	// Position of TRANSFERSIZE field.
	GPDMA_CCONTROL_TRANSFERSIZE_Pos = 0x0
	// Bit mask of TRANSFERSIZE field.
	GPDMA_CCONTROL_TRANSFERSIZE_Msk = 0xfff
	// Position of SBSIZE field.
	GPDMA_CCONTROL_SBSIZE_Pos = 0xc
	// Bit mask of SBSIZE field.
	GPDMA_CCONTROL_SBSIZE_Msk = 0x7000
	// Source burst size = 1
	GPDMA_CCONTROL_SBSIZE_SOURCE_BURST_1 = 0x0
	// Source burst size = 4
	GPDMA_CCONTROL_SBSIZE_SOURCE_BURST_4 = 0x1
	// Source burst size = 8
	GPDMA_CCONTROL_SBSIZE_SOURCE_BURST_8 = 0x2
	// Source burst size = 16
	GPDMA_CCONTROL_SBSIZE_SOURCE_BURST_16 = 0x3
	// Source burst size = 32
	GPDMA_CCONTROL_SBSIZE_SOURCE_BURST_32 = 0x4
	// Source burst size = 64
	GPDMA_CCONTROL_SBSIZE_SOURCE_BURST_64 = 0x5
	// Source burst size = 128
	GPDMA_CCONTROL_SBSIZE_SOURCE_BURST_128 = 0x6
	// Source burst size = 256
	GPDMA_CCONTROL_SBSIZE_SOURCE_BURST_256 = 0x7
	// Position of DBSIZE field.
	GPDMA_CCONTROL_DBSIZE_Pos = 0xf
	// Bit mask of DBSIZE field.
	GPDMA_CCONTROL_DBSIZE_Msk = 0x38000
	// Destination burst size = 1
	GPDMA_CCONTROL_DBSIZE_DESTINATION_BURST_1 = 0x0
	// Destination burst size = 4
	GPDMA_CCONTROL_DBSIZE_DESTINATION_BURST_4 = 0x1
	// Destination burst size = 8
	GPDMA_CCONTROL_DBSIZE_DESTINATION_BURST_8 = 0x2
	// Destination burst size = 16
	GPDMA_CCONTROL_DBSIZE_DESTINATION_BURST_16 = 0x3
	// Destination burst size = 32
	GPDMA_CCONTROL_DBSIZE_DESTINATION_BURST_32 = 0x4
	// Destination burst size = 64
	GPDMA_CCONTROL_DBSIZE_DESTINATION_BURST_64 = 0x5
	// Destination burst size = 128
	GPDMA_CCONTROL_DBSIZE_DESTINATION_BURST_128 = 0x6
	// Destination burst size = 256
	GPDMA_CCONTROL_DBSIZE_DESTINATION_BURST_256 = 0x7
	// Position of SWIDTH field.
	GPDMA_CCONTROL_SWIDTH_Pos = 0x12
	// Bit mask of SWIDTH field.
	GPDMA_CCONTROL_SWIDTH_Msk = 0x1c0000
	// Byte (8-bit)
	GPDMA_CCONTROL_SWIDTH_BYTE_8_BIT = 0x0
	// Halfword (16-bit)
	GPDMA_CCONTROL_SWIDTH_HALFWORD_16_BIT = 0x1
	// Word (32-bit)
	GPDMA_CCONTROL_SWIDTH_WORD_32_BIT = 0x2
	// Position of DWIDTH field.
	GPDMA_CCONTROL_DWIDTH_Pos = 0x15
	// Bit mask of DWIDTH field.
	GPDMA_CCONTROL_DWIDTH_Msk = 0xe00000
	// Byte (8-bit)
	GPDMA_CCONTROL_DWIDTH_BYTE_8_BIT = 0x0
	// Halfword (16-bit)
	GPDMA_CCONTROL_DWIDTH_HALFWORD_16_BIT = 0x1
	// Word (32-bit)
	GPDMA_CCONTROL_DWIDTH_WORD_32_BIT = 0x2
	// Position of S field.
	GPDMA_CCONTROL_S_Pos = 0x18
	// Bit mask of S field.
	GPDMA_CCONTROL_S_Msk = 0x1000000
	// Bit S.
	GPDMA_CCONTROL_S = 0x1000000
	// AHB Master 0 selected for source transfer.
	GPDMA_CCONTROL_S_AHB_MASTER_0_SELECTE = 0x0
	// AHB Master 1 selected for source transfer.
	GPDMA_CCONTROL_S_AHB_MASTER_1_SELECTE = 0x1
	// Position of D field.
	GPDMA_CCONTROL_D_Pos = 0x19
	// Bit mask of D field.
	GPDMA_CCONTROL_D_Msk = 0x2000000
	// Bit D.
	GPDMA_CCONTROL_D = 0x2000000
	// AHB Master 0 selected for destination transfer.
	GPDMA_CCONTROL_D_AHB_MASTER_0_SELECTE = 0x0
	// AHB Master 1 selected for destination transfer.
	GPDMA_CCONTROL_D_AHB_MASTER_1_SELECTE = 0x1
	// Position of SI field.
	GPDMA_CCONTROL_SI_Pos = 0x1a
	// Bit mask of SI field.
	GPDMA_CCONTROL_SI_Msk = 0x4000000
	// Bit SI.
	GPDMA_CCONTROL_SI = 0x4000000
	// The source address is not incremented after each transfer.
	GPDMA_CCONTROL_SI_NOT_INCREMENT = 0x0
	// The source address is incremented after each transfer.
	GPDMA_CCONTROL_SI_INCREMENT = 0x1
	// Position of DI field.
	GPDMA_CCONTROL_DI_Pos = 0x1b
	// Bit mask of DI field.
	GPDMA_CCONTROL_DI_Msk = 0x8000000
	// Bit DI.
	GPDMA_CCONTROL_DI = 0x8000000
	// Position of PROT1 field.
	GPDMA_CCONTROL_PROT1_Pos = 0x1c
	// Bit mask of PROT1 field.
	GPDMA_CCONTROL_PROT1_Msk = 0x10000000
	// Bit PROT1.
	GPDMA_CCONTROL_PROT1 = 0x10000000
	// Access is in user mode
	GPDMA_CCONTROL_PROT1_ACCESS_IS_IN_USER_MO = 0x0
	// Access is in privileged mode.
	GPDMA_CCONTROL_PROT1_ACCESS_IS_IN_PRIVILE = 0x1
	// Position of PROT2 field.
	GPDMA_CCONTROL_PROT2_Pos = 0x1d
	// Bit mask of PROT2 field.
	GPDMA_CCONTROL_PROT2_Msk = 0x20000000
	// Bit PROT2.
	GPDMA_CCONTROL_PROT2 = 0x20000000
	// Access is not bufferable.
	GPDMA_CCONTROL_PROT2_ACCESS_IS_NOT_BUFFER = 0x0
	// Access is bufferable.
	GPDMA_CCONTROL_PROT2_ACCESS_IS_BUFFERABLE = 0x1
	// Position of PROT3 field.
	GPDMA_CCONTROL_PROT3_Pos = 0x1e
	// Bit mask of PROT3 field.
	GPDMA_CCONTROL_PROT3_Msk = 0x40000000
	// Bit PROT3.
	GPDMA_CCONTROL_PROT3 = 0x40000000
	// Access is not cacheable.
	GPDMA_CCONTROL_PROT3_ACCESS_IS_NOT_CACHEA = 0x0
	// Access is cacheable.
	GPDMA_CCONTROL_PROT3_ACCESS_IS_CACHEABLE_ = 0x1
	// Position of I field.
	GPDMA_CCONTROL_I_Pos = 0x1f
	// Bit mask of I field.
	GPDMA_CCONTROL_I_Msk = 0x80000000
	// Bit I.
	GPDMA_CCONTROL_I = 0x80000000

	// C0CONFIG: DMA Channel Configuration Register
	// Position of E field.
	GPDMA_CCONFIG_E_Pos = 0x0
	// Bit mask of E field.
	GPDMA_CCONFIG_E_Msk = 0x1
	// Bit E.
	GPDMA_CCONFIG_E = 0x1
	// Channel disabled.
	GPDMA_CCONFIG_E_CHANNEL_DISABLED_ = 0x0
	// Channel enabled.
	GPDMA_CCONFIG_E_CHANNEL_ENABLED_ = 0x1
	// Position of SRCPERIPHERAL field.
	GPDMA_CCONFIG_SRCPERIPHERAL_Pos = 0x1
	// Bit mask of SRCPERIPHERAL field.
	GPDMA_CCONFIG_SRCPERIPHERAL_Msk = 0x3e
	// Source = SPIFI
	GPDMA_CCONFIG_SRCPERIPHERAL_SOURCE_EQ_SPIFI = 0x0
	// Source = SSP0 receive/I2S channel 0
	GPDMA_CCONFIG_SRCPERIPHERAL_SOURCE_EQ_SSP0_RECEIV = 0x9
	// Source = SSP0 transmit/I2S channel 1
	GPDMA_CCONFIG_SRCPERIPHERAL_SOURCE_EQ_SSP0_TRANSM = 0xa
	// Source = SSP1 receive
	GPDMA_CCONFIG_SRCPERIPHERAL_SOURCE_EQ_SSP1_RECEIV = 0xb
	// Source = SSP1 transmit
	GPDMA_CCONFIG_SRCPERIPHERAL_SOURCE_EQ_SSP1_TRANSM = 0xc
	// Source = ADC0
	GPDMA_CCONFIG_SRCPERIPHERAL_SOURCE_EQ_ADC0 = 0xd
	// Source = ADC1
	GPDMA_CCONFIG_SRCPERIPHERAL_SOURCE_EQ_ADC1 = 0xe
	// Source = DAC
	GPDMA_CCONFIG_SRCPERIPHERAL_SOURCE_EQ_DAC = 0xf
	// Position of DESTPERIPHERAL field.
	GPDMA_CCONFIG_DESTPERIPHERAL_Pos = 0x6
	// Bit mask of DESTPERIPHERAL field.
	GPDMA_CCONFIG_DESTPERIPHERAL_Msk = 0x7c0
	// Destination = SPIFI
	GPDMA_CCONFIG_DESTPERIPHERAL_DESTINATION_EQ_SPIFI = 0x0
	// Destination = SSP0 receive/I2S channel 0
	GPDMA_CCONFIG_DESTPERIPHERAL_DESTINATION_EQ_SSP0_R = 0x9
	// Destination = SSP0 transmit/I2S channel 1
	GPDMA_CCONFIG_DESTPERIPHERAL_DESTINATION_EQ_SSP0_T = 0xa
	// Destination = SSP1 receive
	GPDMA_CCONFIG_DESTPERIPHERAL_DESTINATION_EQ_SSP1_R = 0xb
	// Destination = SSP1 transmit
	GPDMA_CCONFIG_DESTPERIPHERAL_DESTINATION_EQ_SSP1_T = 0xc
	// Destination = ADC0
	GPDMA_CCONFIG_DESTPERIPHERAL_DESTINATION_EQ_ADC0 = 0xd
	// Destination = ADC1
	GPDMA_CCONFIG_DESTPERIPHERAL_DESTINATION_EQ_ADC1 = 0xe
	// Destination = DAC
	GPDMA_CCONFIG_DESTPERIPHERAL_DESTINATION_EQ_DAC = 0xf
	// Position of FLOWCNTRL field.
	GPDMA_CCONFIG_FLOWCNTRL_Pos = 0xb
	// Bit mask of FLOWCNTRL field.
	GPDMA_CCONFIG_FLOWCNTRL_Msk = 0x3800
	// Memory to memory (DMA control)
	GPDMA_CCONFIG_FLOWCNTRL_MEMORY_TO_MEMORY = 0x0
	// Position of IE field.
	GPDMA_CCONFIG_IE_Pos = 0xe
	// Bit mask of IE field.
	GPDMA_CCONFIG_IE_Msk = 0x4000
	// Bit IE.
	GPDMA_CCONFIG_IE = 0x4000
	// Position of ITC field.
	GPDMA_CCONFIG_ITC_Pos = 0xf
	// Bit mask of ITC field.
	GPDMA_CCONFIG_ITC_Msk = 0x8000
	// Bit ITC.
	GPDMA_CCONFIG_ITC = 0x8000
	// Position of L field.
	GPDMA_CCONFIG_L_Pos = 0x10
	// Bit mask of L field.
	GPDMA_CCONFIG_L_Msk = 0x10000
	// Bit L.
	GPDMA_CCONFIG_L = 0x10000
	// Position of A field.
	GPDMA_CCONFIG_A_Pos = 0x11
	// Bit mask of A field.
	GPDMA_CCONFIG_A_Msk = 0x20000
	// Bit A.
	GPDMA_CCONFIG_A = 0x20000
	// Position of H field.
	GPDMA_CCONFIG_H_Pos = 0x12
	// Bit mask of H field.
	GPDMA_CCONFIG_H_Msk = 0x40000
	// Bit H.
	GPDMA_CCONFIG_H = 0x40000
	// Enable DMA requests.
	GPDMA_CCONFIG_H_ENABLE_DMA_REQUESTS_ = 0x0
	// Ignore further source DMA requests.
	GPDMA_CCONFIG_H_IGNORE_FURTHER_SOURC = 0x1
	// Position of RESERVED field.
	GPDMA_CCONFIG_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	GPDMA_CCONFIG_RESERVED_Msk = 0xfff80000
)

// Bitfields for SPIFI: SPI Flash Interface (SPIFI)
const (
	// CTRL: SPIFI control register
	// Position of TIMEOUT field.
	SPIFI_CTRL_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	SPIFI_CTRL_TIMEOUT_Msk = 0xffff
	// Position of CSHIGH field.
	SPIFI_CTRL_CSHIGH_Pos = 0x10
	// Bit mask of CSHIGH field.
	SPIFI_CTRL_CSHIGH_Msk = 0xf0000
	// Position of RESERVED field.
	SPIFI_CTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SPIFI_CTRL_RESERVED_Msk = 0x100000
	// Bit RESERVED.
	SPIFI_CTRL_RESERVED = 0x100000
	// Position of D_PRFTCH_DIS field.
	SPIFI_CTRL_D_PRFTCH_DIS_Pos = 0x15
	// Bit mask of D_PRFTCH_DIS field.
	SPIFI_CTRL_D_PRFTCH_DIS_Msk = 0x200000
	// Bit D_PRFTCH_DIS.
	SPIFI_CTRL_D_PRFTCH_DIS = 0x200000
	// Position of INTEN field.
	SPIFI_CTRL_INTEN_Pos = 0x16
	// Bit mask of INTEN field.
	SPIFI_CTRL_INTEN_Msk = 0x400000
	// Bit INTEN.
	SPIFI_CTRL_INTEN = 0x400000
	// Position of MODE3 field.
	SPIFI_CTRL_MODE3_Pos = 0x17
	// Bit mask of MODE3 field.
	SPIFI_CTRL_MODE3_Msk = 0x800000
	// Bit MODE3.
	SPIFI_CTRL_MODE3 = 0x800000
	// SCK LOW. The SPIFI drives SCK low after the rising edge at which the last bit of each command is captured, and keeps it low while CS is HIGH.
	SPIFI_CTRL_MODE3_SCK_LOW = 0x0
	// SCK HIGH. the SPIFI keeps SCK high after the rising edge for the last bit of each command and while CS is HIGH, and drives it low after it drives CS LOW. (Known serial flash devices can handle either mode, but some devices may require a particular mode for proper operation.) MODE3, RFCLK, and FBCLK should not all be 1, because in this case there is no final rising edge on SCK on which to sample the last data bit of the frame.
	SPIFI_CTRL_MODE3_SCK_HIGH = 0x1
	// Position of RESERVED field.
	SPIFI_CTRL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SPIFI_CTRL_RESERVED_Msk = 0x7000000
	// Position of PRFTCH_DIS field.
	SPIFI_CTRL_PRFTCH_DIS_Pos = 0x1b
	// Bit mask of PRFTCH_DIS field.
	SPIFI_CTRL_PRFTCH_DIS_Msk = 0x8000000
	// Bit PRFTCH_DIS.
	SPIFI_CTRL_PRFTCH_DIS = 0x8000000
	// Enable. Cache prefetching enabled.
	SPIFI_CTRL_PRFTCH_DIS_ENABLE = 0x0
	// Disable. Disables prefetching of cache lines.
	SPIFI_CTRL_PRFTCH_DIS_DISABLE = 0x1
	// Position of DUAL field.
	SPIFI_CTRL_DUAL_Pos = 0x1c
	// Bit mask of DUAL field.
	SPIFI_CTRL_DUAL_Msk = 0x10000000
	// Bit DUAL.
	SPIFI_CTRL_DUAL = 0x10000000
	// Quad protocol. This protocol uses IO3:0.
	SPIFI_CTRL_DUAL_QUAD_PROTOCOL = 0x0
	// Dual protocol. This protocol uses IO1:0.
	SPIFI_CTRL_DUAL_DUAL_PROTOCOL = 0x1
	// Position of RFCLK field.
	SPIFI_CTRL_RFCLK_Pos = 0x1d
	// Bit mask of RFCLK field.
	SPIFI_CTRL_RFCLK_Msk = 0x20000000
	// Bit RFCLK.
	SPIFI_CTRL_RFCLK = 0x20000000
	// Rising edge. Read data is sampled on rising edges on the clock, as in classic SPI operation.
	SPIFI_CTRL_RFCLK_RISING_EDGE = 0x0
	// Falling edge. Read data is sampled on falling edges of the clock, allowing a full serial clock of of time in order to maximize the serial clock frequency. MODE3, RFCLK, and FBCLK should not all be 1, because in this case there is no final rising edge on SCK on which to sample the last data bit of the frame.
	SPIFI_CTRL_RFCLK_FALLING_EDGE = 0x1
	// Position of FBCLK field.
	SPIFI_CTRL_FBCLK_Pos = 0x1e
	// Bit mask of FBCLK field.
	SPIFI_CTRL_FBCLK_Msk = 0x40000000
	// Bit FBCLK.
	SPIFI_CTRL_FBCLK = 0x40000000
	// Internal clock. The SPIFI samples read data using an internal clock.
	SPIFI_CTRL_FBCLK_INTERNAL_CLOCK = 0x0
	// Feedback clock. Read data is sampled using a feedback clock from the SCK pin. This allows slightly more time for each received bit. MODE3, RFCLK, and FBCLK should not all be 1, because in this case there is no final rising edge on SCK on which to sample the last data bit of the frame.
	SPIFI_CTRL_FBCLK_FEEDBACK_CLOCK = 0x1
	// Position of DMAEN field.
	SPIFI_CTRL_DMAEN_Pos = 0x1f
	// Bit mask of DMAEN field.
	SPIFI_CTRL_DMAEN_Msk = 0x80000000
	// Bit DMAEN.
	SPIFI_CTRL_DMAEN = 0x80000000

	// CMD: SPIFI command register
	// Position of DATALEN field.
	SPIFI_CMD_DATALEN_Pos = 0x0
	// Bit mask of DATALEN field.
	SPIFI_CMD_DATALEN_Msk = 0x3fff
	// Position of POLL field.
	SPIFI_CMD_POLL_Pos = 0xe
	// Bit mask of POLL field.
	SPIFI_CMD_POLL_Msk = 0x4000
	// Bit POLL.
	SPIFI_CMD_POLL = 0x4000
	// Position of DOUT field.
	SPIFI_CMD_DOUT_Pos = 0xf
	// Bit mask of DOUT field.
	SPIFI_CMD_DOUT_Msk = 0x8000
	// Bit DOUT.
	SPIFI_CMD_DOUT = 0x8000
	// Input from serial flash.
	SPIFI_CMD_DOUT_INPUT_FROM_SERIAL_FL = 0x0
	// Output to serial flash.
	SPIFI_CMD_DOUT_OUTPUT_TO_SERIAL_FLA = 0x1
	// Position of INTLEN field.
	SPIFI_CMD_INTLEN_Pos = 0x10
	// Bit mask of INTLEN field.
	SPIFI_CMD_INTLEN_Msk = 0x70000
	// Position of FIELDFORM field.
	SPIFI_CMD_FIELDFORM_Pos = 0x13
	// Bit mask of FIELDFORM field.
	SPIFI_CMD_FIELDFORM_Msk = 0x180000
	// All serial. All fields of the command are serial.
	SPIFI_CMD_FIELDFORM_ALL_SERIAL = 0x0
	// Quad/dual data. Data field is quad/dual, other fields are serial.
	SPIFI_CMD_FIELDFORM_QUADDUAL_DATA = 0x1
	// Serial opcode. Opcode field is serial. Other fields are quad/dual.
	SPIFI_CMD_FIELDFORM_SERIAL_OPCODE = 0x2
	// All quad/dual. All fields of the command are in quad/dual format.
	SPIFI_CMD_FIELDFORM_ALL_QUADDUAL = 0x3
	// Position of FRAMEFORM field.
	SPIFI_CMD_FRAMEFORM_Pos = 0x15
	// Bit mask of FRAMEFORM field.
	SPIFI_CMD_FRAMEFORM_Msk = 0xe00000
	// Opcode. Opcode only, no address.
	SPIFI_CMD_FRAMEFORM_OPCODE = 0x1
	// Opcode one byte. Opcode, least significant byte of address.
	SPIFI_CMD_FRAMEFORM_OPCODE_ONE_BYTE = 0x2
	// Opcode two bytes. Opcode, two least significant bytes of address.
	SPIFI_CMD_FRAMEFORM_OPCODE_TWO_BYTES = 0x3
	// Opcode three bytes. Opcode, three least significant bytes of address.
	SPIFI_CMD_FRAMEFORM_OPCODE_THREE_BYTES = 0x4
	// Opcode four bytes. Opcode, 4 bytes of address.
	SPIFI_CMD_FRAMEFORM_OPCODE_FOUR_BYTES = 0x5
	// No opcode three bytes. No opcode, 3 least significant bytes of address.
	SPIFI_CMD_FRAMEFORM_NO_OPCODE_THREE_BYTE = 0x6
	// No opcode four bytes. No opcode, 4 bytes of address.
	SPIFI_CMD_FRAMEFORM_NO_OPCODE_FOUR_BYTES = 0x7
	// Position of OPCODE field.
	SPIFI_CMD_OPCODE_Pos = 0x18
	// Bit mask of OPCODE field.
	SPIFI_CMD_OPCODE_Msk = 0xff000000

	// ADDR: SPIFI address register
	// Position of ADDRESS field.
	SPIFI_ADDR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	SPIFI_ADDR_ADDRESS_Msk = 0xffffffff

	// IDATA: SPIFI intermediate data register
	// Position of IDATA field.
	SPIFI_IDATA_IDATA_Pos = 0x0
	// Bit mask of IDATA field.
	SPIFI_IDATA_IDATA_Msk = 0xffffffff

	// CLIMIT: SPIFI cache limit register
	// Position of CLIMIT field.
	SPIFI_CLIMIT_CLIMIT_Pos = 0x0
	// Bit mask of CLIMIT field.
	SPIFI_CLIMIT_CLIMIT_Msk = 0xffffffff

	// DATA: SPIFI data register
	// Position of DATA field.
	SPIFI_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SPIFI_DATA_DATA_Msk = 0xffffffff

	// MCMD: SPIFI memory command register
	// Position of RESERVED field.
	SPIFI_MCMD_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SPIFI_MCMD_RESERVED_Msk = 0x3fff
	// Position of POLL field.
	SPIFI_MCMD_POLL_Pos = 0xe
	// Bit mask of POLL field.
	SPIFI_MCMD_POLL_Msk = 0x4000
	// Bit POLL.
	SPIFI_MCMD_POLL = 0x4000
	// Position of DOUT field.
	SPIFI_MCMD_DOUT_Pos = 0xf
	// Bit mask of DOUT field.
	SPIFI_MCMD_DOUT_Msk = 0x8000
	// Bit DOUT.
	SPIFI_MCMD_DOUT = 0x8000
	// Position of INTLEN field.
	SPIFI_MCMD_INTLEN_Pos = 0x10
	// Bit mask of INTLEN field.
	SPIFI_MCMD_INTLEN_Msk = 0x70000
	// Position of FIELDFORM field.
	SPIFI_MCMD_FIELDFORM_Pos = 0x13
	// Bit mask of FIELDFORM field.
	SPIFI_MCMD_FIELDFORM_Msk = 0x180000
	// All serial. All fields of the command are serial.
	SPIFI_MCMD_FIELDFORM_ALL_SERIAL = 0x0
	// Quad/dual data. Data field is quad/dual, other fields are serial.
	SPIFI_MCMD_FIELDFORM_QUADDUAL_DATA = 0x1
	// Serial opcode. Opcode field is serial. Other fields are quad/dual.
	SPIFI_MCMD_FIELDFORM_SERIAL_OPCODE = 0x2
	// All quad/dual. All fields of the command are in quad/dual format.
	SPIFI_MCMD_FIELDFORM_ALL_QUADDUAL = 0x3
	// Position of FRAMEFORM field.
	SPIFI_MCMD_FRAMEFORM_Pos = 0x15
	// Bit mask of FRAMEFORM field.
	SPIFI_MCMD_FRAMEFORM_Msk = 0xe00000
	// Opcode one byte. Opcode, least-significant byte of address.
	SPIFI_MCMD_FRAMEFORM_OPCODE_ONE_BYTE = 0x2
	// Opcode two bytes. Opcode, 2 least-significant bytes of address.
	SPIFI_MCMD_FRAMEFORM_OPCODE_TWO_BYTES = 0x3
	// Opcode three bytes. Opcode, 3 least-significant bytes of address.
	SPIFI_MCMD_FRAMEFORM_OPCODE_THREE_BYTES = 0x4
	// Opcode four bytes. Opcode, 4 bytes of address.
	SPIFI_MCMD_FRAMEFORM_OPCODE_FOUR_BYTES = 0x5
	// No opcode three bytes. No opcode, 3 least-significant bytes of address.
	SPIFI_MCMD_FRAMEFORM_NO_OPCODE_THREE_BYTE = 0x6
	// No opcode, 4 bytes of address.
	SPIFI_MCMD_FRAMEFORM_NO_OPCODE_FOUR_BYTES = 0x7
	// Position of OPCODE field.
	SPIFI_MCMD_OPCODE_Pos = 0x18
	// Bit mask of OPCODE field.
	SPIFI_MCMD_OPCODE_Msk = 0xff000000

	// STAT: SPIFI status register
	// Position of MCINIT field.
	SPIFI_STAT_MCINIT_Pos = 0x0
	// Bit mask of MCINIT field.
	SPIFI_STAT_MCINIT_Msk = 0x1
	// Bit MCINIT.
	SPIFI_STAT_MCINIT = 0x1
	// Position of CMD field.
	SPIFI_STAT_CMD_Pos = 0x1
	// Bit mask of CMD field.
	SPIFI_STAT_CMD_Msk = 0x2
	// Bit CMD.
	SPIFI_STAT_CMD = 0x2
	// Position of RESET field.
	SPIFI_STAT_RESET_Pos = 0x4
	// Bit mask of RESET field.
	SPIFI_STAT_RESET_Msk = 0x10
	// Bit RESET.
	SPIFI_STAT_RESET = 0x10
	// Position of INTRQ field.
	SPIFI_STAT_INTRQ_Pos = 0x5
	// Bit mask of INTRQ field.
	SPIFI_STAT_INTRQ_Msk = 0x20
	// Bit INTRQ.
	SPIFI_STAT_INTRQ = 0x20
	// Position of RESERVED field.
	SPIFI_STAT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPIFI_STAT_RESERVED_Msk = 0xffffc0
	// Position of VERSION field.
	SPIFI_STAT_VERSION_Pos = 0x18
	// Bit mask of VERSION field.
	SPIFI_STAT_VERSION_Msk = 0xff000000
)

// Bitfields for SDMMC: SD/MMC
const (
	// CTRL: Control Register
	// Position of CONTROLLER_RESET field.
	SDMMC_CTRL_CONTROLLER_RESET_Pos = 0x0
	// Bit mask of CONTROLLER_RESET field.
	SDMMC_CTRL_CONTROLLER_RESET_Msk = 0x1
	// Bit CONTROLLER_RESET.
	SDMMC_CTRL_CONTROLLER_RESET = 0x1
	// No change.
	SDMMC_CTRL_CONTROLLER_RESET_NO_CHANGE = 0x0
	// Reset. Reset SD/MMC controller
	SDMMC_CTRL_CONTROLLER_RESET_RESET = 0x1
	// Position of FIFO_RESET field.
	SDMMC_CTRL_FIFO_RESET_Pos = 0x1
	// Bit mask of FIFO_RESET field.
	SDMMC_CTRL_FIFO_RESET_Msk = 0x2
	// Bit FIFO_RESET.
	SDMMC_CTRL_FIFO_RESET = 0x2
	// No change.
	SDMMC_CTRL_FIFO_RESET_NO_CHANGE = 0x0
	// Reset. Reset to data FIFO To reset FIFO pointers
	SDMMC_CTRL_FIFO_RESET_RESET = 0x1
	// Position of DMA_RESET field.
	SDMMC_CTRL_DMA_RESET_Pos = 0x2
	// Bit mask of DMA_RESET field.
	SDMMC_CTRL_DMA_RESET_Msk = 0x4
	// Bit DMA_RESET.
	SDMMC_CTRL_DMA_RESET = 0x4
	// No change.
	SDMMC_CTRL_DMA_RESET_NO_CHANGE = 0x0
	// Reset. Reset internal DMA interface control logic
	SDMMC_CTRL_DMA_RESET_RESET = 0x1
	// Position of RESERVED field.
	SDMMC_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	SDMMC_CTRL_RESERVED_Msk = 0x8
	// Bit RESERVED.
	SDMMC_CTRL_RESERVED = 0x8
	// Position of INT_ENABLE field.
	SDMMC_CTRL_INT_ENABLE_Pos = 0x4
	// Bit mask of INT_ENABLE field.
	SDMMC_CTRL_INT_ENABLE_Msk = 0x10
	// Bit INT_ENABLE.
	SDMMC_CTRL_INT_ENABLE = 0x10
	// Disable interrupts
	SDMMC_CTRL_INT_ENABLE_DISABLE_INTERRUPTS = 0x0
	// Enable interrupts
	SDMMC_CTRL_INT_ENABLE_ENABLE_INTERRUPTS = 0x1
	// Position of RESERVED field.
	SDMMC_CTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SDMMC_CTRL_RESERVED_Msk = 0x20
	// Bit RESERVED.
	SDMMC_CTRL_RESERVED = 0x20
	// Position of READ_WAIT field.
	SDMMC_CTRL_READ_WAIT_Pos = 0x6
	// Bit mask of READ_WAIT field.
	SDMMC_CTRL_READ_WAIT_Msk = 0x40
	// Bit READ_WAIT.
	SDMMC_CTRL_READ_WAIT = 0x40
	// Clear read wait
	SDMMC_CTRL_READ_WAIT_CLEAR_READ_WAIT = 0x0
	// Assert read wait
	SDMMC_CTRL_READ_WAIT_ASSERT_READ_WAIT = 0x1
	// Position of SEND_IRQ_RESPONSE field.
	SDMMC_CTRL_SEND_IRQ_RESPONSE_Pos = 0x7
	// Bit mask of SEND_IRQ_RESPONSE field.
	SDMMC_CTRL_SEND_IRQ_RESPONSE_Msk = 0x80
	// Bit SEND_IRQ_RESPONSE.
	SDMMC_CTRL_SEND_IRQ_RESPONSE = 0x80
	// No change
	SDMMC_CTRL_SEND_IRQ_RESPONSE_NO_CHANGE = 0x0
	// Send auto IRQ response
	SDMMC_CTRL_SEND_IRQ_RESPONSE_SEND_AUTO_IRQ_RESPON = 0x1
	// Position of ABORT_READ_DATA field.
	SDMMC_CTRL_ABORT_READ_DATA_Pos = 0x8
	// Bit mask of ABORT_READ_DATA field.
	SDMMC_CTRL_ABORT_READ_DATA_Msk = 0x100
	// Bit ABORT_READ_DATA.
	SDMMC_CTRL_ABORT_READ_DATA = 0x100
	// No change
	SDMMC_CTRL_ABORT_READ_DATA_NO_CHANGE = 0x0
	// Abort. After suspend command is issued during read-transfer, software polls card to find when suspend happened. Once suspend occurs, software sets bit to reset data state-machine, which is waiting for next block of data. This bit automatically clears once data state machine resets to idle. Used in SDIO card suspend sequence.
	SDMMC_CTRL_ABORT_READ_DATA_ABORT = 0x1
	// Position of SEND_CCSD field.
	SDMMC_CTRL_SEND_CCSD_Pos = 0x9
	// Bit mask of SEND_CCSD field.
	SDMMC_CTRL_SEND_CCSD_Msk = 0x200
	// Bit SEND_CCSD.
	SDMMC_CTRL_SEND_CCSD = 0x200
	// Clear bit if the SD/MMC controller does not reset the bit.
	SDMMC_CTRL_SEND_CCSD_CLEAR_BIT = 0x0
	// Send Command Completion Signal Disable (CCSD) to CE-ATA device
	SDMMC_CTRL_SEND_CCSD_SEND_COMMAND_COMPLET = 0x1
	// Position of SEND_AUTO_STOP field.
	SDMMC_CTRL_SEND_AUTO_STOP_Pos = 0xa
	// Bit mask of SEND_AUTO_STOP field.
	SDMMC_CTRL_SEND_AUTO_STOP_Msk = 0x400
	// Bit SEND_AUTO_STOP.
	SDMMC_CTRL_SEND_AUTO_STOP = 0x400
	// Clear this bit if the SD/MMC controller does not reset the bit.
	SDMMC_CTRL_SEND_AUTO_STOP_CLEAR_THIS_BIT_IF_TH = 0x0
	// Send internally generated STOP after sending CCSD to CE-ATA device.
	SDMMC_CTRL_SEND_AUTO_STOP_SEND_INTERNALLY_GENE = 0x1
	// Position of CEATA_DEVICE_INTERRUPT_STATUS field.
	SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Pos = 0xb
	// Bit mask of CEATA_DEVICE_INTERRUPT_STATUS field.
	SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Msk = 0x800
	// Bit CEATA_DEVICE_INTERRUPT_STATUS.
	SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS = 0x800
	// Disabled. Interrupts not enabled in CE-ATA device (nIEN = 1 in ATA control register)
	SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_DISABLED = 0x0
	// Enabled. Interrupts are enabled in CE-ATA device (nIEN = 0 in ATA control register)
	SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_ENABLED = 0x1
	// Position of RESERVED field.
	SDMMC_CTRL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SDMMC_CTRL_RESERVED_Msk = 0xf000
	// Position of CARD_VOLTAGE_A0 field.
	SDMMC_CTRL_CARD_VOLTAGE_A0_Pos = 0x10
	// Bit mask of CARD_VOLTAGE_A0 field.
	SDMMC_CTRL_CARD_VOLTAGE_A0_Msk = 0x10000
	// Bit CARD_VOLTAGE_A0.
	SDMMC_CTRL_CARD_VOLTAGE_A0 = 0x10000
	// Position of CARD_VOLTAGE_A1 field.
	SDMMC_CTRL_CARD_VOLTAGE_A1_Pos = 0x11
	// Bit mask of CARD_VOLTAGE_A1 field.
	SDMMC_CTRL_CARD_VOLTAGE_A1_Msk = 0x20000
	// Bit CARD_VOLTAGE_A1.
	SDMMC_CTRL_CARD_VOLTAGE_A1 = 0x20000
	// Position of CARD_VOLTAGE_A2 field.
	SDMMC_CTRL_CARD_VOLTAGE_A2_Pos = 0x12
	// Bit mask of CARD_VOLTAGE_A2 field.
	SDMMC_CTRL_CARD_VOLTAGE_A2_Msk = 0x40000
	// Bit CARD_VOLTAGE_A2.
	SDMMC_CTRL_CARD_VOLTAGE_A2 = 0x40000
	// Position of RESERVED field.
	SDMMC_CTRL_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	SDMMC_CTRL_RESERVED_Msk = 0xf80000
	// Position of RESERVED field.
	SDMMC_CTRL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SDMMC_CTRL_RESERVED_Msk = 0x1000000
	// Bit RESERVED.
	SDMMC_CTRL_RESERVED = 0x1000000
	// Position of USE_INTERNAL_DMAC field.
	SDMMC_CTRL_USE_INTERNAL_DMAC_Pos = 0x19
	// Bit mask of USE_INTERNAL_DMAC field.
	SDMMC_CTRL_USE_INTERNAL_DMAC_Msk = 0x2000000
	// Bit USE_INTERNAL_DMAC.
	SDMMC_CTRL_USE_INTERNAL_DMAC = 0x2000000
	// Host. The host performs data transfers through the slave interface
	SDMMC_CTRL_USE_INTERNAL_DMAC_HOST = 0x0
	// DMA. Internal DMA used for data transfer
	SDMMC_CTRL_USE_INTERNAL_DMAC_DMA = 0x1
	// Position of RESERVED field.
	SDMMC_CTRL_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SDMMC_CTRL_RESERVED_Msk = 0xfc000000

	// PWREN: Power Enable Register
	// Position of POWER_ENABLE field.
	SDMMC_PWREN_POWER_ENABLE_Pos = 0x0
	// Bit mask of POWER_ENABLE field.
	SDMMC_PWREN_POWER_ENABLE_Msk = 0x1
	// Bit POWER_ENABLE.
	SDMMC_PWREN_POWER_ENABLE = 0x1
	// Position of RESERVED field.
	SDMMC_PWREN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SDMMC_PWREN_RESERVED_Msk = 0xfffffffe

	// CLKDIV: Clock Divider Register
	// Position of CLK_DIVIDER0 field.
	SDMMC_CLKDIV_CLK_DIVIDER0_Pos = 0x0
	// Bit mask of CLK_DIVIDER0 field.
	SDMMC_CLKDIV_CLK_DIVIDER0_Msk = 0xff
	// Position of CLK_DIVIDER1 field.
	SDMMC_CLKDIV_CLK_DIVIDER1_Pos = 0x8
	// Bit mask of CLK_DIVIDER1 field.
	SDMMC_CLKDIV_CLK_DIVIDER1_Msk = 0xff00
	// Position of CLK_DIVIDER2 field.
	SDMMC_CLKDIV_CLK_DIVIDER2_Pos = 0x10
	// Bit mask of CLK_DIVIDER2 field.
	SDMMC_CLKDIV_CLK_DIVIDER2_Msk = 0xff0000
	// Position of CLK_DIVIDER3 field.
	SDMMC_CLKDIV_CLK_DIVIDER3_Pos = 0x18
	// Bit mask of CLK_DIVIDER3 field.
	SDMMC_CLKDIV_CLK_DIVIDER3_Msk = 0xff000000

	// CLKSRC: SD Clock Source Register
	// Position of CLK_SOURCE field.
	SDMMC_CLKSRC_CLK_SOURCE_Pos = 0x0
	// Bit mask of CLK_SOURCE field.
	SDMMC_CLKSRC_CLK_SOURCE_Msk = 0x3
	// Position of RESERVED field.
	SDMMC_CLKSRC_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SDMMC_CLKSRC_RESERVED_Msk = 0xfffffffe

	// CLKENA: Clock Enable Register
	// Position of CCLK_ENABLE field.
	SDMMC_CLKENA_CCLK_ENABLE_Pos = 0x0
	// Bit mask of CCLK_ENABLE field.
	SDMMC_CLKENA_CCLK_ENABLE_Msk = 0x1
	// Bit CCLK_ENABLE.
	SDMMC_CLKENA_CCLK_ENABLE = 0x1
	// Position of RESERVED field.
	SDMMC_CLKENA_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SDMMC_CLKENA_RESERVED_Msk = 0xfffe
	// Position of CCLK_LOW_POWER field.
	SDMMC_CLKENA_CCLK_LOW_POWER_Pos = 0x10
	// Bit mask of CCLK_LOW_POWER field.
	SDMMC_CLKENA_CCLK_LOW_POWER_Msk = 0x10000
	// Bit CCLK_LOW_POWER.
	SDMMC_CLKENA_CCLK_LOW_POWER = 0x10000
	// Position of RESERVED field.
	SDMMC_CLKENA_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SDMMC_CLKENA_RESERVED_Msk = 0xfffe0000

	// TMOUT: Time-out Register
	// Position of RESPONSE_TIMEOUT field.
	SDMMC_TMOUT_RESPONSE_TIMEOUT_Pos = 0x0
	// Bit mask of RESPONSE_TIMEOUT field.
	SDMMC_TMOUT_RESPONSE_TIMEOUT_Msk = 0xff
	// Position of DATA_TIMEOUT field.
	SDMMC_TMOUT_DATA_TIMEOUT_Pos = 0x8
	// Bit mask of DATA_TIMEOUT field.
	SDMMC_TMOUT_DATA_TIMEOUT_Msk = 0xffffff00

	// CTYPE: Card Type Register
	// Position of CARD_WIDTH0 field.
	SDMMC_CTYPE_CARD_WIDTH0_Pos = 0x0
	// Bit mask of CARD_WIDTH0 field.
	SDMMC_CTYPE_CARD_WIDTH0_Msk = 0x1
	// Bit CARD_WIDTH0.
	SDMMC_CTYPE_CARD_WIDTH0 = 0x1
	// Position of RESERVED field.
	SDMMC_CTYPE_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SDMMC_CTYPE_RESERVED_Msk = 0xfffe
	// Position of CARD_WIDTH1 field.
	SDMMC_CTYPE_CARD_WIDTH1_Pos = 0x10
	// Bit mask of CARD_WIDTH1 field.
	SDMMC_CTYPE_CARD_WIDTH1_Msk = 0x10000
	// Bit CARD_WIDTH1.
	SDMMC_CTYPE_CARD_WIDTH1 = 0x10000
	// Position of RESERVED field.
	SDMMC_CTYPE_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SDMMC_CTYPE_RESERVED_Msk = 0xfffe0000

	// BLKSIZ: Block Size Register
	// Position of BLOCK_SIZE field.
	SDMMC_BLKSIZ_BLOCK_SIZE_Pos = 0x0
	// Bit mask of BLOCK_SIZE field.
	SDMMC_BLKSIZ_BLOCK_SIZE_Msk = 0xffff
	// Position of RESERVED field.
	SDMMC_BLKSIZ_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SDMMC_BLKSIZ_RESERVED_Msk = 0xffff0000

	// BYTCNT: Byte Count Register
	// Position of BYTE_COUNT field.
	SDMMC_BYTCNT_BYTE_COUNT_Pos = 0x0
	// Bit mask of BYTE_COUNT field.
	SDMMC_BYTCNT_BYTE_COUNT_Msk = 0xffffffff

	// INTMASK: Interrupt Mask Register
	// Position of CDET field.
	SDMMC_INTMASK_CDET_Pos = 0x0
	// Bit mask of CDET field.
	SDMMC_INTMASK_CDET_Msk = 0x1
	// Bit CDET.
	SDMMC_INTMASK_CDET = 0x1
	// Position of RE field.
	SDMMC_INTMASK_RE_Pos = 0x1
	// Bit mask of RE field.
	SDMMC_INTMASK_RE_Msk = 0x2
	// Bit RE.
	SDMMC_INTMASK_RE = 0x2
	// Position of CDONE field.
	SDMMC_INTMASK_CDONE_Pos = 0x2
	// Bit mask of CDONE field.
	SDMMC_INTMASK_CDONE_Msk = 0x4
	// Bit CDONE.
	SDMMC_INTMASK_CDONE = 0x4
	// Position of DTO field.
	SDMMC_INTMASK_DTO_Pos = 0x3
	// Bit mask of DTO field.
	SDMMC_INTMASK_DTO_Msk = 0x8
	// Bit DTO.
	SDMMC_INTMASK_DTO = 0x8
	// Position of TXDR field.
	SDMMC_INTMASK_TXDR_Pos = 0x4
	// Bit mask of TXDR field.
	SDMMC_INTMASK_TXDR_Msk = 0x10
	// Bit TXDR.
	SDMMC_INTMASK_TXDR = 0x10
	// Position of RXDR field.
	SDMMC_INTMASK_RXDR_Pos = 0x5
	// Bit mask of RXDR field.
	SDMMC_INTMASK_RXDR_Msk = 0x20
	// Bit RXDR.
	SDMMC_INTMASK_RXDR = 0x20
	// Position of RCRC field.
	SDMMC_INTMASK_RCRC_Pos = 0x6
	// Bit mask of RCRC field.
	SDMMC_INTMASK_RCRC_Msk = 0x40
	// Bit RCRC.
	SDMMC_INTMASK_RCRC = 0x40
	// Position of DCRC field.
	SDMMC_INTMASK_DCRC_Pos = 0x7
	// Bit mask of DCRC field.
	SDMMC_INTMASK_DCRC_Msk = 0x80
	// Bit DCRC.
	SDMMC_INTMASK_DCRC = 0x80
	// Position of RTO field.
	SDMMC_INTMASK_RTO_Pos = 0x8
	// Bit mask of RTO field.
	SDMMC_INTMASK_RTO_Msk = 0x100
	// Bit RTO.
	SDMMC_INTMASK_RTO = 0x100
	// Position of DRTO field.
	SDMMC_INTMASK_DRTO_Pos = 0x9
	// Bit mask of DRTO field.
	SDMMC_INTMASK_DRTO_Msk = 0x200
	// Bit DRTO.
	SDMMC_INTMASK_DRTO = 0x200
	// Position of HTO field.
	SDMMC_INTMASK_HTO_Pos = 0xa
	// Bit mask of HTO field.
	SDMMC_INTMASK_HTO_Msk = 0x400
	// Bit HTO.
	SDMMC_INTMASK_HTO = 0x400
	// Position of FRUN field.
	SDMMC_INTMASK_FRUN_Pos = 0xb
	// Bit mask of FRUN field.
	SDMMC_INTMASK_FRUN_Msk = 0x800
	// Bit FRUN.
	SDMMC_INTMASK_FRUN = 0x800
	// Position of HLE field.
	SDMMC_INTMASK_HLE_Pos = 0xc
	// Bit mask of HLE field.
	SDMMC_INTMASK_HLE_Msk = 0x1000
	// Bit HLE.
	SDMMC_INTMASK_HLE = 0x1000
	// Position of SBE field.
	SDMMC_INTMASK_SBE_Pos = 0xd
	// Bit mask of SBE field.
	SDMMC_INTMASK_SBE_Msk = 0x2000
	// Bit SBE.
	SDMMC_INTMASK_SBE = 0x2000
	// Position of ACD field.
	SDMMC_INTMASK_ACD_Pos = 0xe
	// Bit mask of ACD field.
	SDMMC_INTMASK_ACD_Msk = 0x4000
	// Bit ACD.
	SDMMC_INTMASK_ACD = 0x4000
	// Position of EBE field.
	SDMMC_INTMASK_EBE_Pos = 0xf
	// Bit mask of EBE field.
	SDMMC_INTMASK_EBE_Msk = 0x8000
	// Bit EBE.
	SDMMC_INTMASK_EBE = 0x8000
	// Position of SDIO_INT_MASK field.
	SDMMC_INTMASK_SDIO_INT_MASK_Pos = 0x10
	// Bit mask of SDIO_INT_MASK field.
	SDMMC_INTMASK_SDIO_INT_MASK_Msk = 0x10000
	// Bit SDIO_INT_MASK.
	SDMMC_INTMASK_SDIO_INT_MASK = 0x10000
	// Position of RESERVED field.
	SDMMC_INTMASK_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SDMMC_INTMASK_RESERVED_Msk = 0xfffe0000

	// CMDARG: Command Argument Register
	// Position of CMD_ARG field.
	SDMMC_CMDARG_CMD_ARG_Pos = 0x0
	// Bit mask of CMD_ARG field.
	SDMMC_CMDARG_CMD_ARG_Msk = 0xffffffff

	// CMD: Command Register
	// Position of CMD_INDEX field.
	SDMMC_CMD_CMD_INDEX_Pos = 0x0
	// Bit mask of CMD_INDEX field.
	SDMMC_CMD_CMD_INDEX_Msk = 0x3f
	// Position of RESPONSE_EXPECT field.
	SDMMC_CMD_RESPONSE_EXPECT_Pos = 0x6
	// Bit mask of RESPONSE_EXPECT field.
	SDMMC_CMD_RESPONSE_EXPECT_Msk = 0x40
	// Bit RESPONSE_EXPECT.
	SDMMC_CMD_RESPONSE_EXPECT = 0x40
	// None. No response expected from card
	SDMMC_CMD_RESPONSE_EXPECT_NONE = 0x0
	// Expected. Response expected from card
	SDMMC_CMD_RESPONSE_EXPECT_EXPECTED = 0x1
	// Position of RESPONSE_LENGTH field.
	SDMMC_CMD_RESPONSE_LENGTH_Pos = 0x7
	// Bit mask of RESPONSE_LENGTH field.
	SDMMC_CMD_RESPONSE_LENGTH_Msk = 0x80
	// Bit RESPONSE_LENGTH.
	SDMMC_CMD_RESPONSE_LENGTH = 0x80
	// Short. Short response expected from card
	SDMMC_CMD_RESPONSE_LENGTH_SHORT = 0x0
	// Long. Long response expected from card
	SDMMC_CMD_RESPONSE_LENGTH_LONG = 0x1
	// Position of CHECK_RESPONSE_CRC field.
	SDMMC_CMD_CHECK_RESPONSE_CRC_Pos = 0x8
	// Bit mask of CHECK_RESPONSE_CRC field.
	SDMMC_CMD_CHECK_RESPONSE_CRC_Msk = 0x100
	// Bit CHECK_RESPONSE_CRC.
	SDMMC_CMD_CHECK_RESPONSE_CRC = 0x100
	// Do not check response CRC
	SDMMC_CMD_CHECK_RESPONSE_CRC_DO_NOT_CHECK_RESPONS = 0x0
	// Check response CRC
	SDMMC_CMD_CHECK_RESPONSE_CRC_CHECK_RESPONSE_CRC = 0x1
	// Position of DATA_EXPECTED field.
	SDMMC_CMD_DATA_EXPECTED_Pos = 0x9
	// Bit mask of DATA_EXPECTED field.
	SDMMC_CMD_DATA_EXPECTED_Msk = 0x200
	// Bit DATA_EXPECTED.
	SDMMC_CMD_DATA_EXPECTED = 0x200
	// None. No data transfer expected (read/write)
	SDMMC_CMD_DATA_EXPECTED_NONE = 0x0
	// Data. Data transfer expected (read/write)
	SDMMC_CMD_DATA_EXPECTED_DATA = 0x1
	// Position of READ_WRITE field.
	SDMMC_CMD_READ_WRITE_Pos = 0xa
	// Bit mask of READ_WRITE field.
	SDMMC_CMD_READ_WRITE_Msk = 0x400
	// Bit READ_WRITE.
	SDMMC_CMD_READ_WRITE = 0x400
	// Read from card
	SDMMC_CMD_READ_WRITE_READ_FROM_CARD = 0x0
	// Write to card
	SDMMC_CMD_READ_WRITE_WRITE_TO_CARD = 0x1
	// Position of TRANSFER_MODE field.
	SDMMC_CMD_TRANSFER_MODE_Pos = 0xb
	// Bit mask of TRANSFER_MODE field.
	SDMMC_CMD_TRANSFER_MODE_Msk = 0x800
	// Bit TRANSFER_MODE.
	SDMMC_CMD_TRANSFER_MODE = 0x800
	// Block data transfer command
	SDMMC_CMD_TRANSFER_MODE_BLOCK_DATA_TRANSFER = 0x0
	// Stream data transfer command
	SDMMC_CMD_TRANSFER_MODE_STREAM_DATA_TRANSFER = 0x1
	// Position of SEND_AUTO_STOP field.
	SDMMC_CMD_SEND_AUTO_STOP_Pos = 0xc
	// Bit mask of SEND_AUTO_STOP field.
	SDMMC_CMD_SEND_AUTO_STOP_Msk = 0x1000
	// Bit SEND_AUTO_STOP.
	SDMMC_CMD_SEND_AUTO_STOP = 0x1000
	// No stop command sent at end of data transfer
	SDMMC_CMD_SEND_AUTO_STOP_NO_STOP_COMMAND_SENT = 0x0
	// Send stop command at end of data transfer
	SDMMC_CMD_SEND_AUTO_STOP_SEND_STOP_COMMAND_AT = 0x1
	// Position of WAIT_PRVDATA_COMPLETE field.
	SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Pos = 0xd
	// Bit mask of WAIT_PRVDATA_COMPLETE field.
	SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Msk = 0x2000
	// Bit WAIT_PRVDATA_COMPLETE.
	SDMMC_CMD_WAIT_PRVDATA_COMPLETE = 0x2000
	// Send. Send command at once, even if previous data transfer has not completed.
	SDMMC_CMD_WAIT_PRVDATA_COMPLETE_SEND = 0x0
	// Wait. Wait for previous data transfer completion before sending command.
	SDMMC_CMD_WAIT_PRVDATA_COMPLETE_WAIT = 0x1
	// Position of STOP_ABORT_CMD field.
	SDMMC_CMD_STOP_ABORT_CMD_Pos = 0xe
	// Bit mask of STOP_ABORT_CMD field.
	SDMMC_CMD_STOP_ABORT_CMD_Msk = 0x4000
	// Bit STOP_ABORT_CMD.
	SDMMC_CMD_STOP_ABORT_CMD = 0x4000
	// Disabled. Neither stop nor abort command to stop current data transfer in progress. If abort is sent to function-number currently selected or not in data-transfer mode, then bit should be set to 0.
	SDMMC_CMD_STOP_ABORT_CMD_DISABLED = 0x0
	// Enabled. Stop or abort command intended to stop current data transfer in progress.
	SDMMC_CMD_STOP_ABORT_CMD_ENABLED = 0x1
	// Position of SEND_INITIALIZATION field.
	SDMMC_CMD_SEND_INITIALIZATION_Pos = 0xf
	// Bit mask of SEND_INITIALIZATION field.
	SDMMC_CMD_SEND_INITIALIZATION_Msk = 0x8000
	// Bit SEND_INITIALIZATION.
	SDMMC_CMD_SEND_INITIALIZATION = 0x8000
	// No. Do not send initialization sequence (80 clocks of 1) before sending this command.
	SDMMC_CMD_SEND_INITIALIZATION_NO = 0x0
	// Send. Send initialization sequence before sending this command.
	SDMMC_CMD_SEND_INITIALIZATION_SEND = 0x1
	// Position of RESERVED field.
	SDMMC_CMD_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SDMMC_CMD_RESERVED_Msk = 0x1f0000
	// Position of UPDATE_CLOCK_REGISTERS_ONLY field.
	SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Pos = 0x15
	// Bit mask of UPDATE_CLOCK_REGISTERS_ONLY field.
	SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Msk = 0x200000
	// Bit UPDATE_CLOCK_REGISTERS_ONLY.
	SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY = 0x200000
	// Normal. Normal command sequence
	SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_NORMAL = 0x0
	// No. Do not send commands, just update clock register value into card clock domain
	SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_NO = 0x1
	// Position of READ_CEATA_DEVICE field.
	SDMMC_CMD_READ_CEATA_DEVICE_Pos = 0x16
	// Bit mask of READ_CEATA_DEVICE field.
	SDMMC_CMD_READ_CEATA_DEVICE_Msk = 0x400000
	// Bit READ_CEATA_DEVICE.
	SDMMC_CMD_READ_CEATA_DEVICE = 0x400000
	// No read. Host is not performing read access (RW_REG or RW_BLK) towards CE-ATA device.
	SDMMC_CMD_READ_CEATA_DEVICE_NO_READ = 0x0
	// Read. Host is performing read access (RW_REG or RW_BLK) towards CE-ATA device.
	SDMMC_CMD_READ_CEATA_DEVICE_READ = 0x1
	// Position of CCS_EXPECTED field.
	SDMMC_CMD_CCS_EXPECTED_Pos = 0x17
	// Bit mask of CCS_EXPECTED field.
	SDMMC_CMD_CCS_EXPECTED_Msk = 0x800000
	// Bit CCS_EXPECTED.
	SDMMC_CMD_CCS_EXPECTED = 0x800000
	// Disabled. Interrupts are not enabled in CE-ATA device (nIEN = 1 in ATA control register), or command does not expect CCS from device.
	SDMMC_CMD_CCS_EXPECTED_DISABLED = 0x0
	// Enabled. Interrupts are enabled in CE-ATA device (nIEN = 0), and RW_BLK command expects command completion signal from CE-ATA device.
	SDMMC_CMD_CCS_EXPECTED_ENABLED = 0x1
	// Position of ENABLE_BOOT field.
	SDMMC_CMD_ENABLE_BOOT_Pos = 0x18
	// Bit mask of ENABLE_BOOT field.
	SDMMC_CMD_ENABLE_BOOT_Msk = 0x1000000
	// Bit ENABLE_BOOT.
	SDMMC_CMD_ENABLE_BOOT = 0x1000000
	// Position of EXPECT_BOOT_ACK field.
	SDMMC_CMD_EXPECT_BOOT_ACK_Pos = 0x19
	// Bit mask of EXPECT_BOOT_ACK field.
	SDMMC_CMD_EXPECT_BOOT_ACK_Msk = 0x2000000
	// Bit EXPECT_BOOT_ACK.
	SDMMC_CMD_EXPECT_BOOT_ACK = 0x2000000
	// Position of DISABLE_BOOT field.
	SDMMC_CMD_DISABLE_BOOT_Pos = 0x1a
	// Bit mask of DISABLE_BOOT field.
	SDMMC_CMD_DISABLE_BOOT_Msk = 0x4000000
	// Bit DISABLE_BOOT.
	SDMMC_CMD_DISABLE_BOOT = 0x4000000
	// Position of BOOT_MODE field.
	SDMMC_CMD_BOOT_MODE_Pos = 0x1b
	// Bit mask of BOOT_MODE field.
	SDMMC_CMD_BOOT_MODE_Msk = 0x8000000
	// Bit BOOT_MODE.
	SDMMC_CMD_BOOT_MODE = 0x8000000
	// Mandatory Boot operation
	SDMMC_CMD_BOOT_MODE_MANDATORY_BOOT_OPERA = 0x0
	// Alternate Boot operation
	SDMMC_CMD_BOOT_MODE_ALTERNATE_BOOT_OPERA = 0x1
	// Position of VOLT_SWITCH field.
	SDMMC_CMD_VOLT_SWITCH_Pos = 0x1c
	// Bit mask of VOLT_SWITCH field.
	SDMMC_CMD_VOLT_SWITCH_Msk = 0x10000000
	// Bit VOLT_SWITCH.
	SDMMC_CMD_VOLT_SWITCH = 0x10000000
	// Disabled. No voltage switching
	SDMMC_CMD_VOLT_SWITCH_DISABLED = 0x0
	// Enabled. Voltage switching enabled; must be set for CMD11 only
	SDMMC_CMD_VOLT_SWITCH_ENABLED = 0x1
	// Position of RESERVED field.
	SDMMC_CMD_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	SDMMC_CMD_RESERVED_Msk = 0x60000000
	// Position of START_CMD field.
	SDMMC_CMD_START_CMD_Pos = 0x1f
	// Bit mask of START_CMD field.
	SDMMC_CMD_START_CMD_Msk = 0x80000000
	// Bit START_CMD.
	SDMMC_CMD_START_CMD = 0x80000000

	// RESP0: Response Register 0
	// Position of RESPONSE0 field.
	SDMMC_RESP0_RESPONSE0_Pos = 0x0
	// Bit mask of RESPONSE0 field.
	SDMMC_RESP0_RESPONSE0_Msk = 0xffffffff

	// RESP1: Response Register 1
	// Position of RESPONSE1 field.
	SDMMC_RESP1_RESPONSE1_Pos = 0x0
	// Bit mask of RESPONSE1 field.
	SDMMC_RESP1_RESPONSE1_Msk = 0xffffffff

	// RESP2: Response Register 2
	// Position of RESPONSE2 field.
	SDMMC_RESP2_RESPONSE2_Pos = 0x0
	// Bit mask of RESPONSE2 field.
	SDMMC_RESP2_RESPONSE2_Msk = 0xffffffff

	// RESP3: Response Register 3
	// Position of RESPONSE3 field.
	SDMMC_RESP3_RESPONSE3_Pos = 0x0
	// Bit mask of RESPONSE3 field.
	SDMMC_RESP3_RESPONSE3_Msk = 0xffffffff

	// MINTSTS: Masked Interrupt Status Register
	// Position of CDET field.
	SDMMC_MINTSTS_CDET_Pos = 0x0
	// Bit mask of CDET field.
	SDMMC_MINTSTS_CDET_Msk = 0x1
	// Bit CDET.
	SDMMC_MINTSTS_CDET = 0x1
	// Position of RE field.
	SDMMC_MINTSTS_RE_Pos = 0x1
	// Bit mask of RE field.
	SDMMC_MINTSTS_RE_Msk = 0x2
	// Bit RE.
	SDMMC_MINTSTS_RE = 0x2
	// Position of CDONE field.
	SDMMC_MINTSTS_CDONE_Pos = 0x2
	// Bit mask of CDONE field.
	SDMMC_MINTSTS_CDONE_Msk = 0x4
	// Bit CDONE.
	SDMMC_MINTSTS_CDONE = 0x4
	// Position of DTO field.
	SDMMC_MINTSTS_DTO_Pos = 0x3
	// Bit mask of DTO field.
	SDMMC_MINTSTS_DTO_Msk = 0x8
	// Bit DTO.
	SDMMC_MINTSTS_DTO = 0x8
	// Position of TXDR field.
	SDMMC_MINTSTS_TXDR_Pos = 0x4
	// Bit mask of TXDR field.
	SDMMC_MINTSTS_TXDR_Msk = 0x10
	// Bit TXDR.
	SDMMC_MINTSTS_TXDR = 0x10
	// Position of RXDR field.
	SDMMC_MINTSTS_RXDR_Pos = 0x5
	// Bit mask of RXDR field.
	SDMMC_MINTSTS_RXDR_Msk = 0x20
	// Bit RXDR.
	SDMMC_MINTSTS_RXDR = 0x20
	// Position of RCRC field.
	SDMMC_MINTSTS_RCRC_Pos = 0x6
	// Bit mask of RCRC field.
	SDMMC_MINTSTS_RCRC_Msk = 0x40
	// Bit RCRC.
	SDMMC_MINTSTS_RCRC = 0x40
	// Position of DCRC field.
	SDMMC_MINTSTS_DCRC_Pos = 0x7
	// Bit mask of DCRC field.
	SDMMC_MINTSTS_DCRC_Msk = 0x80
	// Bit DCRC.
	SDMMC_MINTSTS_DCRC = 0x80
	// Position of RTO field.
	SDMMC_MINTSTS_RTO_Pos = 0x8
	// Bit mask of RTO field.
	SDMMC_MINTSTS_RTO_Msk = 0x100
	// Bit RTO.
	SDMMC_MINTSTS_RTO = 0x100
	// Position of DRTO field.
	SDMMC_MINTSTS_DRTO_Pos = 0x9
	// Bit mask of DRTO field.
	SDMMC_MINTSTS_DRTO_Msk = 0x200
	// Bit DRTO.
	SDMMC_MINTSTS_DRTO = 0x200
	// Position of HTO field.
	SDMMC_MINTSTS_HTO_Pos = 0xa
	// Bit mask of HTO field.
	SDMMC_MINTSTS_HTO_Msk = 0x400
	// Bit HTO.
	SDMMC_MINTSTS_HTO = 0x400
	// Position of FRUN field.
	SDMMC_MINTSTS_FRUN_Pos = 0xb
	// Bit mask of FRUN field.
	SDMMC_MINTSTS_FRUN_Msk = 0x800
	// Bit FRUN.
	SDMMC_MINTSTS_FRUN = 0x800
	// Position of HLE field.
	SDMMC_MINTSTS_HLE_Pos = 0xc
	// Bit mask of HLE field.
	SDMMC_MINTSTS_HLE_Msk = 0x1000
	// Bit HLE.
	SDMMC_MINTSTS_HLE = 0x1000
	// Position of SBE field.
	SDMMC_MINTSTS_SBE_Pos = 0xd
	// Bit mask of SBE field.
	SDMMC_MINTSTS_SBE_Msk = 0x2000
	// Bit SBE.
	SDMMC_MINTSTS_SBE = 0x2000
	// Position of ACD field.
	SDMMC_MINTSTS_ACD_Pos = 0xe
	// Bit mask of ACD field.
	SDMMC_MINTSTS_ACD_Msk = 0x4000
	// Bit ACD.
	SDMMC_MINTSTS_ACD = 0x4000
	// Position of EBE field.
	SDMMC_MINTSTS_EBE_Pos = 0xf
	// Bit mask of EBE field.
	SDMMC_MINTSTS_EBE_Msk = 0x8000
	// Bit EBE.
	SDMMC_MINTSTS_EBE = 0x8000
	// Position of SDIO_INTERRUPT field.
	SDMMC_MINTSTS_SDIO_INTERRUPT_Pos = 0x10
	// Bit mask of SDIO_INTERRUPT field.
	SDMMC_MINTSTS_SDIO_INTERRUPT_Msk = 0x10000
	// Bit SDIO_INTERRUPT.
	SDMMC_MINTSTS_SDIO_INTERRUPT = 0x10000
	// Position of RESERVED field.
	SDMMC_MINTSTS_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SDMMC_MINTSTS_RESERVED_Msk = 0xfffe0000

	// RINTSTS: Raw Interrupt Status Register
	// Position of CDET field.
	SDMMC_RINTSTS_CDET_Pos = 0x0
	// Bit mask of CDET field.
	SDMMC_RINTSTS_CDET_Msk = 0x1
	// Bit CDET.
	SDMMC_RINTSTS_CDET = 0x1
	// Position of RE field.
	SDMMC_RINTSTS_RE_Pos = 0x1
	// Bit mask of RE field.
	SDMMC_RINTSTS_RE_Msk = 0x2
	// Bit RE.
	SDMMC_RINTSTS_RE = 0x2
	// Position of CDONE field.
	SDMMC_RINTSTS_CDONE_Pos = 0x2
	// Bit mask of CDONE field.
	SDMMC_RINTSTS_CDONE_Msk = 0x4
	// Bit CDONE.
	SDMMC_RINTSTS_CDONE = 0x4
	// Position of DTO field.
	SDMMC_RINTSTS_DTO_Pos = 0x3
	// Bit mask of DTO field.
	SDMMC_RINTSTS_DTO_Msk = 0x8
	// Bit DTO.
	SDMMC_RINTSTS_DTO = 0x8
	// Position of TXDR field.
	SDMMC_RINTSTS_TXDR_Pos = 0x4
	// Bit mask of TXDR field.
	SDMMC_RINTSTS_TXDR_Msk = 0x10
	// Bit TXDR.
	SDMMC_RINTSTS_TXDR = 0x10
	// Position of RXDR field.
	SDMMC_RINTSTS_RXDR_Pos = 0x5
	// Bit mask of RXDR field.
	SDMMC_RINTSTS_RXDR_Msk = 0x20
	// Bit RXDR.
	SDMMC_RINTSTS_RXDR = 0x20
	// Position of RCRC field.
	SDMMC_RINTSTS_RCRC_Pos = 0x6
	// Bit mask of RCRC field.
	SDMMC_RINTSTS_RCRC_Msk = 0x40
	// Bit RCRC.
	SDMMC_RINTSTS_RCRC = 0x40
	// Position of DCRC field.
	SDMMC_RINTSTS_DCRC_Pos = 0x7
	// Bit mask of DCRC field.
	SDMMC_RINTSTS_DCRC_Msk = 0x80
	// Bit DCRC.
	SDMMC_RINTSTS_DCRC = 0x80
	// Position of RTO_BAR field.
	SDMMC_RINTSTS_RTO_BAR_Pos = 0x8
	// Bit mask of RTO_BAR field.
	SDMMC_RINTSTS_RTO_BAR_Msk = 0x100
	// Bit RTO_BAR.
	SDMMC_RINTSTS_RTO_BAR = 0x100
	// Position of DRTO_BDS field.
	SDMMC_RINTSTS_DRTO_BDS_Pos = 0x9
	// Bit mask of DRTO_BDS field.
	SDMMC_RINTSTS_DRTO_BDS_Msk = 0x200
	// Bit DRTO_BDS.
	SDMMC_RINTSTS_DRTO_BDS = 0x200
	// Position of HTO field.
	SDMMC_RINTSTS_HTO_Pos = 0xa
	// Bit mask of HTO field.
	SDMMC_RINTSTS_HTO_Msk = 0x400
	// Bit HTO.
	SDMMC_RINTSTS_HTO = 0x400
	// Position of FRUN field.
	SDMMC_RINTSTS_FRUN_Pos = 0xb
	// Bit mask of FRUN field.
	SDMMC_RINTSTS_FRUN_Msk = 0x800
	// Bit FRUN.
	SDMMC_RINTSTS_FRUN = 0x800
	// Position of HLE field.
	SDMMC_RINTSTS_HLE_Pos = 0xc
	// Bit mask of HLE field.
	SDMMC_RINTSTS_HLE_Msk = 0x1000
	// Bit HLE.
	SDMMC_RINTSTS_HLE = 0x1000
	// Position of SBE field.
	SDMMC_RINTSTS_SBE_Pos = 0xd
	// Bit mask of SBE field.
	SDMMC_RINTSTS_SBE_Msk = 0x2000
	// Bit SBE.
	SDMMC_RINTSTS_SBE = 0x2000
	// Position of ACD field.
	SDMMC_RINTSTS_ACD_Pos = 0xe
	// Bit mask of ACD field.
	SDMMC_RINTSTS_ACD_Msk = 0x4000
	// Bit ACD.
	SDMMC_RINTSTS_ACD = 0x4000
	// Position of EBE field.
	SDMMC_RINTSTS_EBE_Pos = 0xf
	// Bit mask of EBE field.
	SDMMC_RINTSTS_EBE_Msk = 0x8000
	// Bit EBE.
	SDMMC_RINTSTS_EBE = 0x8000
	// Position of SDIO_INTERRUPT field.
	SDMMC_RINTSTS_SDIO_INTERRUPT_Pos = 0x10
	// Bit mask of SDIO_INTERRUPT field.
	SDMMC_RINTSTS_SDIO_INTERRUPT_Msk = 0x10000
	// Bit SDIO_INTERRUPT.
	SDMMC_RINTSTS_SDIO_INTERRUPT = 0x10000
	// Position of RESERVED field.
	SDMMC_RINTSTS_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SDMMC_RINTSTS_RESERVED_Msk = 0xfffe0000

	// STATUS: Status Register
	// Position of FIFO_RX_WATERMARK field.
	SDMMC_STATUS_FIFO_RX_WATERMARK_Pos = 0x0
	// Bit mask of FIFO_RX_WATERMARK field.
	SDMMC_STATUS_FIFO_RX_WATERMARK_Msk = 0x1
	// Bit FIFO_RX_WATERMARK.
	SDMMC_STATUS_FIFO_RX_WATERMARK = 0x1
	// Position of FIFO_TX_WATERMARK field.
	SDMMC_STATUS_FIFO_TX_WATERMARK_Pos = 0x1
	// Bit mask of FIFO_TX_WATERMARK field.
	SDMMC_STATUS_FIFO_TX_WATERMARK_Msk = 0x2
	// Bit FIFO_TX_WATERMARK.
	SDMMC_STATUS_FIFO_TX_WATERMARK = 0x2
	// Position of FIFO_EMPTY field.
	SDMMC_STATUS_FIFO_EMPTY_Pos = 0x2
	// Bit mask of FIFO_EMPTY field.
	SDMMC_STATUS_FIFO_EMPTY_Msk = 0x4
	// Bit FIFO_EMPTY.
	SDMMC_STATUS_FIFO_EMPTY = 0x4
	// Position of FIFO_FULL field.
	SDMMC_STATUS_FIFO_FULL_Pos = 0x3
	// Bit mask of FIFO_FULL field.
	SDMMC_STATUS_FIFO_FULL_Msk = 0x8
	// Bit FIFO_FULL.
	SDMMC_STATUS_FIFO_FULL = 0x8
	// Position of CMDFSMSTATES field.
	SDMMC_STATUS_CMDFSMSTATES_Pos = 0x4
	// Bit mask of CMDFSMSTATES field.
	SDMMC_STATUS_CMDFSMSTATES_Msk = 0xf0
	// Position of DATA_3_STATUS field.
	SDMMC_STATUS_DATA_3_STATUS_Pos = 0x8
	// Bit mask of DATA_3_STATUS field.
	SDMMC_STATUS_DATA_3_STATUS_Msk = 0x100
	// Bit DATA_3_STATUS.
	SDMMC_STATUS_DATA_3_STATUS = 0x100
	// Position of DATA_BUSY field.
	SDMMC_STATUS_DATA_BUSY_Pos = 0x9
	// Bit mask of DATA_BUSY field.
	SDMMC_STATUS_DATA_BUSY_Msk = 0x200
	// Bit DATA_BUSY.
	SDMMC_STATUS_DATA_BUSY = 0x200
	// Position of DATA_STATE_MC_BUSY field.
	SDMMC_STATUS_DATA_STATE_MC_BUSY_Pos = 0xa
	// Bit mask of DATA_STATE_MC_BUSY field.
	SDMMC_STATUS_DATA_STATE_MC_BUSY_Msk = 0x400
	// Bit DATA_STATE_MC_BUSY.
	SDMMC_STATUS_DATA_STATE_MC_BUSY = 0x400
	// Position of RESPONSE_INDEX field.
	SDMMC_STATUS_RESPONSE_INDEX_Pos = 0xb
	// Bit mask of RESPONSE_INDEX field.
	SDMMC_STATUS_RESPONSE_INDEX_Msk = 0x1f800
	// Position of FIFO_COUNT field.
	SDMMC_STATUS_FIFO_COUNT_Pos = 0x11
	// Bit mask of FIFO_COUNT field.
	SDMMC_STATUS_FIFO_COUNT_Msk = 0x3ffe0000
	// Position of DMA_ACK field.
	SDMMC_STATUS_DMA_ACK_Pos = 0x1e
	// Bit mask of DMA_ACK field.
	SDMMC_STATUS_DMA_ACK_Msk = 0x40000000
	// Bit DMA_ACK.
	SDMMC_STATUS_DMA_ACK = 0x40000000
	// Position of DMA_REQ field.
	SDMMC_STATUS_DMA_REQ_Pos = 0x1f
	// Bit mask of DMA_REQ field.
	SDMMC_STATUS_DMA_REQ_Msk = 0x80000000
	// Bit DMA_REQ.
	SDMMC_STATUS_DMA_REQ = 0x80000000

	// FIFOTH: FIFO Threshold Watermark Register
	// Position of TX_WMARK field.
	SDMMC_FIFOTH_TX_WMARK_Pos = 0x0
	// Bit mask of TX_WMARK field.
	SDMMC_FIFOTH_TX_WMARK_Msk = 0xfff
	// Position of RESERVED field.
	SDMMC_FIFOTH_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SDMMC_FIFOTH_RESERVED_Msk = 0xf000
	// Position of RX_WMARK field.
	SDMMC_FIFOTH_RX_WMARK_Pos = 0x10
	// Bit mask of RX_WMARK field.
	SDMMC_FIFOTH_RX_WMARK_Msk = 0xfff0000
	// Position of DMA_MTS field.
	SDMMC_FIFOTH_DMA_MTS_Pos = 0x1c
	// Bit mask of DMA_MTS field.
	SDMMC_FIFOTH_DMA_MTS_Msk = 0x70000000
	// 1 transfer
	SDMMC_FIFOTH_DMA_MTS_1_TRANSFER = 0x0
	// 4 transfers
	SDMMC_FIFOTH_DMA_MTS_4_TRANSFERS = 0x1
	// 8 transfers
	SDMMC_FIFOTH_DMA_MTS_8_TRANSFERS = 0x2
	// 16 transfers
	SDMMC_FIFOTH_DMA_MTS_16_TRANSFERS = 0x3
	// 32 transfers
	SDMMC_FIFOTH_DMA_MTS_32_TRANSFERS = 0x4
	// 64 transfers
	SDMMC_FIFOTH_DMA_MTS_64_TRANSFERS = 0x5
	// 128 transfers
	SDMMC_FIFOTH_DMA_MTS_128_TRANSFERS = 0x6
	// 256 transfers
	SDMMC_FIFOTH_DMA_MTS_256_TRANSFERS = 0x7
	// Position of RESERVED field.
	SDMMC_FIFOTH_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	SDMMC_FIFOTH_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	SDMMC_FIFOTH_RESERVED = 0x80000000

	// CDETECT: Card Detect Register
	// Position of CARD_DETECT field.
	SDMMC_CDETECT_CARD_DETECT_Pos = 0x0
	// Bit mask of CARD_DETECT field.
	SDMMC_CDETECT_CARD_DETECT_Msk = 0x1
	// Bit CARD_DETECT.
	SDMMC_CDETECT_CARD_DETECT = 0x1
	// Position of RESERVED field.
	SDMMC_CDETECT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SDMMC_CDETECT_RESERVED_Msk = 0xfffffffe

	// WRTPRT: Write Protect Register
	// Position of WRITE_PROTECT field.
	SDMMC_WRTPRT_WRITE_PROTECT_Pos = 0x0
	// Bit mask of WRITE_PROTECT field.
	SDMMC_WRTPRT_WRITE_PROTECT_Msk = 0x1
	// Bit WRITE_PROTECT.
	SDMMC_WRTPRT_WRITE_PROTECT = 0x1
	// Position of RESERVED field.
	SDMMC_WRTPRT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SDMMC_WRTPRT_RESERVED_Msk = 0xfffffffe

	// TCBCNT: Transferred CIU Card Byte Count Register
	// Position of TRANS_CARD_BYTE_COUNT field.
	SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Pos = 0x0
	// Bit mask of TRANS_CARD_BYTE_COUNT field.
	SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Msk = 0xffffffff

	// TBBCNT: Transferred Host to BIU-FIFO Byte Count Register
	// Position of TRANS_FIFO_BYTE_COUNT field.
	SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Pos = 0x0
	// Bit mask of TRANS_FIFO_BYTE_COUNT field.
	SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Msk = 0xffffffff

	// DEBNCE: Debounce Count Register
	// Position of DEBOUNCE_COUNT field.
	SDMMC_DEBNCE_DEBOUNCE_COUNT_Pos = 0x0
	// Bit mask of DEBOUNCE_COUNT field.
	SDMMC_DEBNCE_DEBOUNCE_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	SDMMC_DEBNCE_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SDMMC_DEBNCE_RESERVED_Msk = 0xff000000

	// RST_N: Hardware Reset
	// Position of CARD_RESET field.
	SDMMC_RST_N_CARD_RESET_Pos = 0x0
	// Bit mask of CARD_RESET field.
	SDMMC_RST_N_CARD_RESET_Msk = 0x1
	// Bit CARD_RESET.
	SDMMC_RST_N_CARD_RESET = 0x1
	// Position of RESERVED field.
	SDMMC_RST_N_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SDMMC_RST_N_RESERVED_Msk = 0xfffffffe

	// BMOD: Bus Mode Register
	// Position of SWR field.
	SDMMC_BMOD_SWR_Pos = 0x0
	// Bit mask of SWR field.
	SDMMC_BMOD_SWR_Msk = 0x1
	// Bit SWR.
	SDMMC_BMOD_SWR = 0x1
	// Position of FB field.
	SDMMC_BMOD_FB_Pos = 0x1
	// Bit mask of FB field.
	SDMMC_BMOD_FB_Msk = 0x2
	// Bit FB.
	SDMMC_BMOD_FB = 0x2
	// Position of DSL field.
	SDMMC_BMOD_DSL_Pos = 0x2
	// Bit mask of DSL field.
	SDMMC_BMOD_DSL_Msk = 0x7c
	// Position of DE field.
	SDMMC_BMOD_DE_Pos = 0x7
	// Bit mask of DE field.
	SDMMC_BMOD_DE_Msk = 0x80
	// Bit DE.
	SDMMC_BMOD_DE = 0x80
	// Position of PBL field.
	SDMMC_BMOD_PBL_Pos = 0x8
	// Bit mask of PBL field.
	SDMMC_BMOD_PBL_Msk = 0x700
	// 1 transfer
	SDMMC_BMOD_PBL_1_TRANSFER = 0x0
	// 4 transfers
	SDMMC_BMOD_PBL_4_TRANSFERS = 0x1
	// 8 transfers
	SDMMC_BMOD_PBL_8_TRANSFERS = 0x2
	// 16 transfers
	SDMMC_BMOD_PBL_16_TRANSFERS = 0x3
	// 32 transfers
	SDMMC_BMOD_PBL_32_TRANSFERS = 0x4
	// 64 transfers
	SDMMC_BMOD_PBL_64_TRANSFERS = 0x5
	// 128 transfers
	SDMMC_BMOD_PBL_128_TRANSFERS = 0x6
	// 256 transfers
	SDMMC_BMOD_PBL_256_TRANSFERS = 0x7
	// Position of RESERVED field.
	SDMMC_BMOD_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SDMMC_BMOD_RESERVED_Msk = 0xfffff800

	// PLDMND: Poll Demand Register
	// Position of PD field.
	SDMMC_PLDMND_PD_Pos = 0x0
	// Bit mask of PD field.
	SDMMC_PLDMND_PD_Msk = 0xffffffff

	// DBADDR: Descriptor List Base Address Register
	// Position of SDL field.
	SDMMC_DBADDR_SDL_Pos = 0x0
	// Bit mask of SDL field.
	SDMMC_DBADDR_SDL_Msk = 0xffffffff

	// IDSTS: Internal DMAC Status Register
	// Position of TI field.
	SDMMC_IDSTS_TI_Pos = 0x0
	// Bit mask of TI field.
	SDMMC_IDSTS_TI_Msk = 0x1
	// Bit TI.
	SDMMC_IDSTS_TI = 0x1
	// Position of RI field.
	SDMMC_IDSTS_RI_Pos = 0x1
	// Bit mask of RI field.
	SDMMC_IDSTS_RI_Msk = 0x2
	// Bit RI.
	SDMMC_IDSTS_RI = 0x2
	// Position of FBE field.
	SDMMC_IDSTS_FBE_Pos = 0x2
	// Bit mask of FBE field.
	SDMMC_IDSTS_FBE_Msk = 0x4
	// Bit FBE.
	SDMMC_IDSTS_FBE = 0x4
	// Position of RESERVED field.
	SDMMC_IDSTS_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	SDMMC_IDSTS_RESERVED_Msk = 0x8
	// Bit RESERVED.
	SDMMC_IDSTS_RESERVED = 0x8
	// Position of DU field.
	SDMMC_IDSTS_DU_Pos = 0x4
	// Bit mask of DU field.
	SDMMC_IDSTS_DU_Msk = 0x10
	// Bit DU.
	SDMMC_IDSTS_DU = 0x10
	// Position of CES field.
	SDMMC_IDSTS_CES_Pos = 0x5
	// Bit mask of CES field.
	SDMMC_IDSTS_CES_Msk = 0x20
	// Bit CES.
	SDMMC_IDSTS_CES = 0x20
	// Position of RESERVED field.
	SDMMC_IDSTS_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SDMMC_IDSTS_RESERVED_Msk = 0xc0
	// Position of NIS field.
	SDMMC_IDSTS_NIS_Pos = 0x8
	// Bit mask of NIS field.
	SDMMC_IDSTS_NIS_Msk = 0x100
	// Bit NIS.
	SDMMC_IDSTS_NIS = 0x100
	// Position of AIS field.
	SDMMC_IDSTS_AIS_Pos = 0x9
	// Bit mask of AIS field.
	SDMMC_IDSTS_AIS_Msk = 0x200
	// Bit AIS.
	SDMMC_IDSTS_AIS = 0x200
	// Position of EB field.
	SDMMC_IDSTS_EB_Pos = 0xa
	// Bit mask of EB field.
	SDMMC_IDSTS_EB_Msk = 0x1c00
	// Position of FSM field.
	SDMMC_IDSTS_FSM_Pos = 0xd
	// Bit mask of FSM field.
	SDMMC_IDSTS_FSM_Msk = 0x1e000
	// Position of RESERVED field.
	SDMMC_IDSTS_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SDMMC_IDSTS_RESERVED_Msk = 0xfffe0000

	// IDINTEN: Internal DMAC Interrupt Enable Register
	// Position of TI field.
	SDMMC_IDINTEN_TI_Pos = 0x0
	// Bit mask of TI field.
	SDMMC_IDINTEN_TI_Msk = 0x1
	// Bit TI.
	SDMMC_IDINTEN_TI = 0x1
	// Position of RI field.
	SDMMC_IDINTEN_RI_Pos = 0x1
	// Bit mask of RI field.
	SDMMC_IDINTEN_RI_Msk = 0x2
	// Bit RI.
	SDMMC_IDINTEN_RI = 0x2
	// Position of FBE field.
	SDMMC_IDINTEN_FBE_Pos = 0x2
	// Bit mask of FBE field.
	SDMMC_IDINTEN_FBE_Msk = 0x4
	// Bit FBE.
	SDMMC_IDINTEN_FBE = 0x4
	// Position of RESERVED field.
	SDMMC_IDINTEN_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	SDMMC_IDINTEN_RESERVED_Msk = 0x8
	// Bit RESERVED.
	SDMMC_IDINTEN_RESERVED = 0x8
	// Position of DU field.
	SDMMC_IDINTEN_DU_Pos = 0x4
	// Bit mask of DU field.
	SDMMC_IDINTEN_DU_Msk = 0x10
	// Bit DU.
	SDMMC_IDINTEN_DU = 0x10
	// Position of CES field.
	SDMMC_IDINTEN_CES_Pos = 0x5
	// Bit mask of CES field.
	SDMMC_IDINTEN_CES_Msk = 0x20
	// Bit CES.
	SDMMC_IDINTEN_CES = 0x20
	// Position of RESERVED field.
	SDMMC_IDINTEN_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SDMMC_IDINTEN_RESERVED_Msk = 0xc0
	// Position of NIS field.
	SDMMC_IDINTEN_NIS_Pos = 0x8
	// Bit mask of NIS field.
	SDMMC_IDINTEN_NIS_Msk = 0x100
	// Bit NIS.
	SDMMC_IDINTEN_NIS = 0x100
	// Position of AIS field.
	SDMMC_IDINTEN_AIS_Pos = 0x9
	// Bit mask of AIS field.
	SDMMC_IDINTEN_AIS_Msk = 0x200
	// Bit AIS.
	SDMMC_IDINTEN_AIS = 0x200
	// Position of RESERVED field.
	SDMMC_IDINTEN_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SDMMC_IDINTEN_RESERVED_Msk = 0xfffffc00

	// DSCADDR: Current Host Descriptor Address Register
	// Position of HDA field.
	SDMMC_DSCADDR_HDA_Pos = 0x0
	// Bit mask of HDA field.
	SDMMC_DSCADDR_HDA_Msk = 0xffffffff

	// BUFADDR: Current Buffer Descriptor Address Register
	// Position of HBA field.
	SDMMC_BUFADDR_HBA_Pos = 0x0
	// Bit mask of HBA field.
	SDMMC_BUFADDR_HBA_Msk = 0xffffffff
)

// Bitfields for EMC: External Memory Controller (EMC)
const (
	// CONTROL: Controls operation of the memory controller.
	// Position of E field.
	EMC_CONTROL_E_Pos = 0x0
	// Bit mask of E field.
	EMC_CONTROL_E_Msk = 0x1
	// Bit E.
	EMC_CONTROL_E = 0x1
	// Disabled
	EMC_CONTROL_E_DISABLED = 0x0
	// Enabled. (POR and warm reset value).
	EMC_CONTROL_E_ENABLED = 0x1
	// Position of M field.
	EMC_CONTROL_M_Pos = 0x1
	// Bit mask of M field.
	EMC_CONTROL_M_Msk = 0x2
	// Bit M.
	EMC_CONTROL_M = 0x2
	// Normal. Normal memory map.
	EMC_CONTROL_M_NORMAL = 0x0
	// Reset. Reset memory map. Static memory CS1 is mirrored onto CS0 and DYCS0 (POR reset value).
	EMC_CONTROL_M_RESET = 0x1
	// Position of L field.
	EMC_CONTROL_L_Pos = 0x2
	// Bit mask of L field.
	EMC_CONTROL_L_Msk = 0x4
	// Bit L.
	EMC_CONTROL_L = 0x4
	// Normal. Normal mode (warm reset value).
	EMC_CONTROL_L_NORMAL = 0x0
	// Low-power mode.
	EMC_CONTROL_L_LOW_POWER_MODE = 0x1
	// Position of RESERVED field.
	EMC_CONTROL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EMC_CONTROL_RESERVED_Msk = 0xfffffff8

	// STATUS: Provides EMC status information.
	// Position of B field.
	EMC_STATUS_B_Pos = 0x0
	// Bit mask of B field.
	EMC_STATUS_B_Msk = 0x1
	// Bit B.
	EMC_STATUS_B = 0x1
	// Idle. EMC is idle (warm reset value).
	EMC_STATUS_B_IDLE = 0x0
	// Busy. EMC is busy performing memory transactions, commands, auto-refresh cycles, or is in self-refresh mode (POR reset value).
	EMC_STATUS_B_BUSY = 0x1
	// Position of S field.
	EMC_STATUS_S_Pos = 0x1
	// Bit mask of S field.
	EMC_STATUS_S_Msk = 0x2
	// Bit S.
	EMC_STATUS_S = 0x2
	// Empty. Write buffers empty (POR reset value)
	EMC_STATUS_S_EMPTY = 0x0
	// Data. Write buffers contain data.
	EMC_STATUS_S_DATA = 0x1
	// Position of SA field.
	EMC_STATUS_SA_Pos = 0x2
	// Bit mask of SA field.
	EMC_STATUS_SA_Msk = 0x4
	// Bit SA.
	EMC_STATUS_SA = 0x4
	// Normal mode.
	EMC_STATUS_SA_NORMAL_MODE = 0x0
	// Self-refresh mode. (POR reset value.)
	EMC_STATUS_SA_SELF_REFRESH_MODE = 0x1
	// Position of RESERVED field.
	EMC_STATUS_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EMC_STATUS_RESERVED_Msk = 0xfffffff8

	// CONFIG: Configures operation of the memory controller.
	// Position of EM field.
	EMC_CONFIG_EM_Pos = 0x0
	// Bit mask of EM field.
	EMC_CONFIG_EM_Msk = 0x1
	// Bit EM.
	EMC_CONFIG_EM = 0x1
	// Little-endian mode. (POR reset value.)
	EMC_CONFIG_EM_LITTLE_ENDIAN_MODE = 0x0
	// Big-endian mode.
	EMC_CONFIG_EM_BIG_ENDIAN_MODE = 0x1
	// Position of RESERVED field.
	EMC_CONFIG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	EMC_CONFIG_RESERVED_Msk = 0xfe
	// Position of RESERVED field.
	EMC_CONFIG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	EMC_CONFIG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	EMC_CONFIG_RESERVED = 0x100
	// Position of RESERVED field.
	EMC_CONFIG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	EMC_CONFIG_RESERVED_Msk = 0xfffffe00

	// DYNAMICCONTROL: Controls dynamic memory operation.
	// Position of CE field.
	EMC_DYNAMICCONTROL_CE_Pos = 0x0
	// Bit mask of CE field.
	EMC_DYNAMICCONTROL_CE_Msk = 0x1
	// Bit CE.
	EMC_DYNAMICCONTROL_CE = 0x1
	// Disabled. Clock enable of idle devices are deasserted to save power (POR reset value).
	EMC_DYNAMICCONTROL_CE_DISABLED = 0x0
	// Enabled. All clock enables are driven HIGH continuously.[1]
	EMC_DYNAMICCONTROL_CE_ENABLED = 0x1
	// Position of CS field.
	EMC_DYNAMICCONTROL_CS_Pos = 0x1
	// Bit mask of CS field.
	EMC_DYNAMICCONTROL_CS_Msk = 0x2
	// Bit CS.
	EMC_DYNAMICCONTROL_CS = 0x2
	// Stop. CLKOUT stops when all SDRAMs are idle and during self-refresh mode.
	EMC_DYNAMICCONTROL_CS_STOP = 0x0
	// Run. CLKOUT runs continuously (POR reset value).
	EMC_DYNAMICCONTROL_CS_RUN = 0x1
	// Position of SR field.
	EMC_DYNAMICCONTROL_SR_Pos = 0x2
	// Bit mask of SR field.
	EMC_DYNAMICCONTROL_SR_Msk = 0x4
	// Bit SR.
	EMC_DYNAMICCONTROL_SR = 0x4
	// Normal mode.
	EMC_DYNAMICCONTROL_SR_NORMAL_MODE = 0x0
	// Self-refresh. Enter self-refresh mode (POR reset value).
	EMC_DYNAMICCONTROL_SR_SELF_REFRESH = 0x1
	// Position of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Msk = 0x18
	// Position of MMC field.
	EMC_DYNAMICCONTROL_MMC_Pos = 0x5
	// Bit mask of MMC field.
	EMC_DYNAMICCONTROL_MMC_Msk = 0x20
	// Bit MMC.
	EMC_DYNAMICCONTROL_MMC = 0x20
	// Enabled. CLKOUT enabled (POR reset value).
	EMC_DYNAMICCONTROL_MMC_ENABLED = 0x0
	// Disabled. CLKOUT disabled.[3]
	EMC_DYNAMICCONTROL_MMC_DISABLED = 0x1
	// Position of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Msk = 0x40
	// Bit RESERVED.
	EMC_DYNAMICCONTROL_RESERVED = 0x40
	// Position of I field.
	EMC_DYNAMICCONTROL_I_Pos = 0x7
	// Bit mask of I field.
	EMC_DYNAMICCONTROL_I_Msk = 0x180
	// Normal. Issue SDRAM NORMAL operation command (POR reset value).
	EMC_DYNAMICCONTROL_I_NORMAL = 0x0
	// Mode. Issue SDRAM MODE command.
	EMC_DYNAMICCONTROL_I_MODE = 0x1
	// PALL. Issue SDRAM PALL (precharge all) command.
	EMC_DYNAMICCONTROL_I_PALL = 0x2
	// NOP. Issue SDRAM NOP (no operation) command)
	EMC_DYNAMICCONTROL_I_NOP = 0x3
	// Position of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Msk = 0x3e00
	// Position of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Msk = 0xffffc000

	// DYNAMICREFRESH: Configures dynamic memory refresh operation.
	// Position of REFRESH field.
	EMC_DYNAMICREFRESH_REFRESH_Pos = 0x0
	// Bit mask of REFRESH field.
	EMC_DYNAMICREFRESH_REFRESH_Msk = 0x7ff
	// Position of RESERVED field.
	EMC_DYNAMICREFRESH_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	EMC_DYNAMICREFRESH_RESERVED_Msk = 0xfffff800

	// DYNAMICREADCONFIG: Configures the dynamic memory read strategy.
	// Position of RD field.
	EMC_DYNAMICREADCONFIG_RD_Pos = 0x0
	// Bit mask of RD field.
	EMC_DYNAMICREADCONFIG_RD_Msk = 0x3
	// Do not use. POR reset value.
	EMC_DYNAMICREADCONFIG_RD_DO_NOT_USE = 0x0
	// Command delayed by 1/2 EMC_CCLK.
	EMC_DYNAMICREADCONFIG_RD_HALF = 0x1
	// Command delayed by 1/2 EMC_CCLK plus one clock cycle.
	EMC_DYNAMICREADCONFIG_RD_HALFPLUSONE = 0x2
	// Command delayed by1/2 EMC_CCLK plus two clock cycles,
	EMC_DYNAMICREADCONFIG_RD_HALFPLUSTWO = 0x3
	// Position of RESERVED field.
	EMC_DYNAMICREADCONFIG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	EMC_DYNAMICREADCONFIG_RESERVED_Msk = 0xfffffffc

	// DYNAMICRP: Selects the precharge command period.
	// Position of TRP field.
	EMC_DYNAMICRP_TRP_Pos = 0x0
	// Bit mask of TRP field.
	EMC_DYNAMICRP_TRP_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICRP_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICRP_RESERVED_Msk = 0xfffffff0

	// DYNAMICRAS: Selects the active to precharge command period.
	// Position of TRAS field.
	EMC_DYNAMICRAS_TRAS_Pos = 0x0
	// Bit mask of TRAS field.
	EMC_DYNAMICRAS_TRAS_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICRAS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICRAS_RESERVED_Msk = 0xfffffff0

	// DYNAMICSREX: Selects the self-refresh exit time.
	// Position of TSREX field.
	EMC_DYNAMICSREX_TSREX_Pos = 0x0
	// Bit mask of TSREX field.
	EMC_DYNAMICSREX_TSREX_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICSREX_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICSREX_RESERVED_Msk = 0xfffffff0

	// DYNAMICAPR: Selects the last-data-out to active command time.
	// Position of TAPR field.
	EMC_DYNAMICAPR_TAPR_Pos = 0x0
	// Bit mask of TAPR field.
	EMC_DYNAMICAPR_TAPR_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICAPR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICAPR_RESERVED_Msk = 0xfffffff0

	// DYNAMICDAL: Selects the data-in to active command time.
	// Position of TDAL field.
	EMC_DYNAMICDAL_TDAL_Pos = 0x0
	// Bit mask of TDAL field.
	EMC_DYNAMICDAL_TDAL_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICDAL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICDAL_RESERVED_Msk = 0xfffffff0

	// DYNAMICWR: Selects the write recovery time.
	// Position of TWR field.
	EMC_DYNAMICWR_TWR_Pos = 0x0
	// Bit mask of TWR field.
	EMC_DYNAMICWR_TWR_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICWR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICWR_RESERVED_Msk = 0xfffffff0

	// DYNAMICRC: Selects the active to active command period.
	// Position of TRC field.
	EMC_DYNAMICRC_TRC_Pos = 0x0
	// Bit mask of TRC field.
	EMC_DYNAMICRC_TRC_Msk = 0x1f
	// Position of RESERVED field.
	EMC_DYNAMICRC_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_DYNAMICRC_RESERVED_Msk = 0xffffffe0

	// DYNAMICRFC: Selects the auto-refresh period.
	// Position of TRFC field.
	EMC_DYNAMICRFC_TRFC_Pos = 0x0
	// Bit mask of TRFC field.
	EMC_DYNAMICRFC_TRFC_Msk = 0x1f
	// Position of RESERVED field.
	EMC_DYNAMICRFC_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_DYNAMICRFC_RESERVED_Msk = 0xffffffe0

	// DYNAMICXSR: Selects the exit self-refresh to active command time.
	// Position of TXSR field.
	EMC_DYNAMICXSR_TXSR_Pos = 0x0
	// Bit mask of TXSR field.
	EMC_DYNAMICXSR_TXSR_Msk = 0x1f
	// Position of RESERVED field.
	EMC_DYNAMICXSR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_DYNAMICXSR_RESERVED_Msk = 0xffffffe0

	// DYNAMICRRD: Selects the active bank A to active bank B latency.
	// Position of TRRD field.
	EMC_DYNAMICRRD_TRRD_Pos = 0x0
	// Bit mask of TRRD field.
	EMC_DYNAMICRRD_TRRD_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICRRD_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICRRD_RESERVED_Msk = 0xfffffff0

	// DYNAMICMRD: Selects the load mode register to active command time.
	// Position of TMRD field.
	EMC_DYNAMICMRD_TMRD_Pos = 0x0
	// Bit mask of TMRD field.
	EMC_DYNAMICMRD_TMRD_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICMRD_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICMRD_RESERVED_Msk = 0xfffffff0

	// STATICEXTENDEDWAIT: Selects time for long static memory read and write transfers.
	// Position of EXTENDEDWAIT field.
	EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Pos = 0x0
	// Bit mask of EXTENDEDWAIT field.
	EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Msk = 0x3ff
	// Position of RESERVED field.
	EMC_STATICEXTENDEDWAIT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	EMC_STATICEXTENDEDWAIT_RESERVED_Msk = 0xfffffc00

	// DYNAMICCONFIG0: Selects the configuration information for dynamic memory chip select 0.
	// Position of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Msk = 0x7
	// Position of MD field.
	EMC_DYNAMICCONFIG_MD_Pos = 0x3
	// Bit mask of MD field.
	EMC_DYNAMICCONFIG_MD_Msk = 0x18
	// SDRAM (POR reset value).
	EMC_DYNAMICCONFIG_MD_SDRAM = 0x0
	// Position of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Msk = 0x60
	// Position of AM0 field.
	EMC_DYNAMICCONFIG_AM0_Pos = 0x7
	// Bit mask of AM0 field.
	EMC_DYNAMICCONFIG_AM0_Msk = 0x1f80
	// Position of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	EMC_DYNAMICCONFIG_RESERVED = 0x2000
	// Position of AM1 field.
	EMC_DYNAMICCONFIG_AM1_Pos = 0xe
	// Bit mask of AM1 field.
	EMC_DYNAMICCONFIG_AM1_Msk = 0x4000
	// Bit AM1.
	EMC_DYNAMICCONFIG_AM1 = 0x4000
	// Position of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Msk = 0x78000
	// Position of B field.
	EMC_DYNAMICCONFIG_B_Pos = 0x13
	// Bit mask of B field.
	EMC_DYNAMICCONFIG_B_Msk = 0x80000
	// Bit B.
	EMC_DYNAMICCONFIG_B = 0x80000
	// Disabled. Buffer disabled for accesses to this chip select (POR reset value).
	EMC_DYNAMICCONFIG_B_DISABLED = 0x0
	// Enabled. Buffer enabled for accesses to this chip select. After configuration of the dynamic memory, the buffer must be enabled for normal operation. [2]
	EMC_DYNAMICCONFIG_B_ENABLED = 0x1
	// Position of P field.
	EMC_DYNAMICCONFIG_P_Pos = 0x14
	// Bit mask of P field.
	EMC_DYNAMICCONFIG_P_Msk = 0x100000
	// Bit P.
	EMC_DYNAMICCONFIG_P = 0x100000
	// None. Writes not protected (POR reset value).
	EMC_DYNAMICCONFIG_P_NONE = 0x0
	// Protected. Writes protected.
	EMC_DYNAMICCONFIG_P_PROTECTED = 0x1
	// Position of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Msk = 0xffe00000

	// DYNAMICRASCAS0: Selects the RAS and CAS latencies for dynamic memory chip select 0.
	// Position of RAS field.
	EMC_DYNAMICRASCAS_RAS_Pos = 0x0
	// Bit mask of RAS field.
	EMC_DYNAMICRASCAS_RAS_Msk = 0x3
	// One EMC_CCLK cycle.
	EMC_DYNAMICRASCAS_RAS_ONE_EMC_CCLK_CYCLE = 0x1
	// Two EMC_CCLK cycles.
	EMC_DYNAMICRASCAS_RAS_TWO_EMC_CCLK_CYCLES = 0x2
	// Three EMC_CCLK cycles (POR reset value).
	EMC_DYNAMICRASCAS_RAS_THREE_EMC_CCLK_CYCLE = 0x3
	// Position of RESERVED field.
	EMC_DYNAMICRASCAS_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	EMC_DYNAMICRASCAS_RESERVED_Msk = 0xfc
	// Position of CAS field.
	EMC_DYNAMICRASCAS_CAS_Pos = 0x8
	// Bit mask of CAS field.
	EMC_DYNAMICRASCAS_CAS_Msk = 0x300
	// One EMC_CCLK cycle.
	EMC_DYNAMICRASCAS_CAS_ONE_EMC_CCLK_CYCLE = 0x1
	// Two EMC_CCLK cycles.
	EMC_DYNAMICRASCAS_CAS_TWO_EMC_CCLK_CYCLES = 0x2
	// Three EMC_CCLK cycles (POR reset value).
	EMC_DYNAMICRASCAS_CAS_THREE_EMC_CCLK_CYCLE = 0x3
	// Position of RESERVED field.
	EMC_DYNAMICRASCAS_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	EMC_DYNAMICRASCAS_RESERVED_Msk = 0xfffffc00

	// STATICCONFIG0: Selects the memory configuration for static chip select 0.
	// Position of MW field.
	EMC_STATICCONFIG_MW_Pos = 0x0
	// Bit mask of MW field.
	EMC_STATICCONFIG_MW_Msk = 0x3
	// 8 bit (POR reset value).
	EMC_STATICCONFIG_MW_8_BIT = 0x0
	// 16 bit.
	EMC_STATICCONFIG_MW_16_BIT = 0x1
	// 32 bit.
	EMC_STATICCONFIG_MW_32_BIT = 0x2
	// Position of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Msk = 0x4
	// Bit RESERVED.
	EMC_STATICCONFIG_RESERVED = 0x4
	// Position of PM field.
	EMC_STATICCONFIG_PM_Pos = 0x3
	// Bit mask of PM field.
	EMC_STATICCONFIG_PM_Msk = 0x8
	// Bit PM.
	EMC_STATICCONFIG_PM = 0x8
	// Disabled. (POR reset value.)
	EMC_STATICCONFIG_PM_DISABLED = 0x0
	// Enabled. Async page mode enabled (page length four).
	EMC_STATICCONFIG_PM_ENABLED = 0x1
	// Position of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Msk = 0x30
	// Position of PC field.
	EMC_STATICCONFIG_PC_Pos = 0x6
	// Bit mask of PC field.
	EMC_STATICCONFIG_PC_Msk = 0x40
	// Bit PC.
	EMC_STATICCONFIG_PC = 0x40
	// Active LOW chip select.
	EMC_STATICCONFIG_PC_ACTIVE_LOW = 0x0
	// Active HIGH chip select.
	EMC_STATICCONFIG_PC_ACTIVE_HIGH = 0x1
	// Position of PB field.
	EMC_STATICCONFIG_PB_Pos = 0x7
	// Bit mask of PB field.
	EMC_STATICCONFIG_PB_Msk = 0x80
	// Bit PB.
	EMC_STATICCONFIG_PB = 0x80
	// High. For reads all the bits in BLSn[3:0] are HIGH. For writes the respective active bits in BLSn[3:0] are LOW (POR reset value).
	EMC_STATICCONFIG_PB_HIGH = 0x0
	// Low. For reads the respective active bits in BLSn[3:0] are LOW. For writes the respective active bits in BLSn[3:0] are LOW.
	EMC_STATICCONFIG_PB_LOW = 0x1
	// Position of EW field.
	EMC_STATICCONFIG_EW_Pos = 0x8
	// Bit mask of EW field.
	EMC_STATICCONFIG_EW_Msk = 0x100
	// Bit EW.
	EMC_STATICCONFIG_EW = 0x100
	// Disabled. Extended wait disabled (POR reset value).
	EMC_STATICCONFIG_EW_DISABLED = 0x0
	// Enabled. Extended wait enabled.
	EMC_STATICCONFIG_EW_ENABLED = 0x1
	// Position of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Msk = 0x7fe00
	// Position of B field.
	EMC_STATICCONFIG_B_Pos = 0x13
	// Bit mask of B field.
	EMC_STATICCONFIG_B_Msk = 0x80000
	// Bit B.
	EMC_STATICCONFIG_B = 0x80000
	// Disabled. Buffer disabled (POR reset value).
	EMC_STATICCONFIG_B_DISABLED = 0x0
	// Enabled. Buffer enabled.
	EMC_STATICCONFIG_B_ENABLED = 0x1
	// Position of P field.
	EMC_STATICCONFIG_P_Pos = 0x14
	// Bit mask of P field.
	EMC_STATICCONFIG_P_Msk = 0x100000
	// Bit P.
	EMC_STATICCONFIG_P = 0x100000
	// None. Writes not protected (POR reset value).
	EMC_STATICCONFIG_P_NONE = 0x0
	// Protect. Write protected.
	EMC_STATICCONFIG_P_PROTECT = 0x1
	// Position of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Msk = 0xffe00000

	// STATICWAITWEN0: Selects the delay from chip select 0 to write enable.
	// Position of WAITWEN field.
	EMC_STATICWAITWEN_WAITWEN_Pos = 0x0
	// Bit mask of WAITWEN field.
	EMC_STATICWAITWEN_WAITWEN_Msk = 0xf
	// Position of RESERVED field.
	EMC_STATICWAITWEN_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_STATICWAITWEN_RESERVED_Msk = 0xfffffff0

	// STATICWAITOEN0: Selects the delay from chip select 0 or address change, whichever is later, to output enable.
	// Position of WAITOEN field.
	EMC_STATICWAITOEN_WAITOEN_Pos = 0x0
	// Bit mask of WAITOEN field.
	EMC_STATICWAITOEN_WAITOEN_Msk = 0xf
	// Position of RESERVED field.
	EMC_STATICWAITOEN_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_STATICWAITOEN_RESERVED_Msk = 0xfffffff0

	// STATICWAITRD0: Selects the delay from chip select 0 to a read access.
	// Position of WAITRD field.
	EMC_STATICWAITRD_WAITRD_Pos = 0x0
	// Bit mask of WAITRD field.
	EMC_STATICWAITRD_WAITRD_Msk = 0x1f
	// Position of RESERVED field.
	EMC_STATICWAITRD_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_STATICWAITRD_RESERVED_Msk = 0xffffffe0

	// STATICWAITPAGE0: Selects the delay for asynchronous page mode sequential accesses for chip select 0.
	// Position of WAITPAGE field.
	EMC_STATICWAITPAGE_WAITPAGE_Pos = 0x0
	// Bit mask of WAITPAGE field.
	EMC_STATICWAITPAGE_WAITPAGE_Msk = 0x1f
	// Position of RESERVED field.
	EMC_STATICWAITPAGE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_STATICWAITPAGE_RESERVED_Msk = 0xffffffe0

	// STATICWAITWR0: Selects the delay from chip select 0 to a write access.
	// Position of WAITWR field.
	EMC_STATICWAITWR_WAITWR_Pos = 0x0
	// Bit mask of WAITWR field.
	EMC_STATICWAITWR_WAITWR_Msk = 0x1f
	// Position of RESERVED field.
	EMC_STATICWAITWR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_STATICWAITWR_RESERVED_Msk = 0xffffffe0

	// STATICWAITTURN0: Selects the number of bus turnaround cycles for chip select 0.
	// Position of WAITTURN field.
	EMC_STATICWAITTURN_WAITTURN_Pos = 0x0
	// Bit mask of WAITTURN field.
	EMC_STATICWAITTURN_WAITTURN_Msk = 0xf
	// Position of RESERVED field.
	EMC_STATICWAITTURN_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_STATICWAITTURN_RESERVED_Msk = 0xfffffff0
)

// Bitfields for USB0: USB0 Host/Device/OTG controller
const (
	// CAPLENGTH: Capability register length
	// Position of CAPLENGTH field.
	USB0_CAPLENGTH_CAPLENGTH_Pos = 0x0
	// Bit mask of CAPLENGTH field.
	USB0_CAPLENGTH_CAPLENGTH_Msk = 0xff
	// Position of HCIVERSION field.
	USB0_CAPLENGTH_HCIVERSION_Pos = 0x8
	// Bit mask of HCIVERSION field.
	USB0_CAPLENGTH_HCIVERSION_Msk = 0xffff00
	// Position of RESERVED field.
	USB0_CAPLENGTH_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB0_CAPLENGTH_RESERVED_Msk = 0xff000000

	// HCSPARAMS: Host controller structural parameters
	// Position of N_PORTS field.
	USB0_HCSPARAMS_N_PORTS_Pos = 0x0
	// Bit mask of N_PORTS field.
	USB0_HCSPARAMS_N_PORTS_Msk = 0xf
	// Position of PPC field.
	USB0_HCSPARAMS_PPC_Pos = 0x4
	// Bit mask of PPC field.
	USB0_HCSPARAMS_PPC_Msk = 0x10
	// Bit PPC.
	USB0_HCSPARAMS_PPC = 0x10
	// Position of RESERVED field.
	USB0_HCSPARAMS_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB0_HCSPARAMS_RESERVED_Msk = 0xe0
	// Position of N_PCC field.
	USB0_HCSPARAMS_N_PCC_Pos = 0x8
	// Bit mask of N_PCC field.
	USB0_HCSPARAMS_N_PCC_Msk = 0xf00
	// Position of N_CC field.
	USB0_HCSPARAMS_N_CC_Pos = 0xc
	// Bit mask of N_CC field.
	USB0_HCSPARAMS_N_CC_Msk = 0xf000
	// Position of PI field.
	USB0_HCSPARAMS_PI_Pos = 0x10
	// Bit mask of PI field.
	USB0_HCSPARAMS_PI_Msk = 0x10000
	// Bit PI.
	USB0_HCSPARAMS_PI = 0x10000
	// Position of RESERVED field.
	USB0_HCSPARAMS_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB0_HCSPARAMS_RESERVED_Msk = 0xe0000
	// Position of N_PTT field.
	USB0_HCSPARAMS_N_PTT_Pos = 0x14
	// Bit mask of N_PTT field.
	USB0_HCSPARAMS_N_PTT_Msk = 0xf00000
	// Position of N_TT field.
	USB0_HCSPARAMS_N_TT_Pos = 0x18
	// Bit mask of N_TT field.
	USB0_HCSPARAMS_N_TT_Msk = 0xf000000
	// Position of RESERVED field.
	USB0_HCSPARAMS_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	USB0_HCSPARAMS_RESERVED_Msk = 0xf0000000

	// HCCPARAMS: Host controller capability parameters
	// Position of ADC field.
	USB0_HCCPARAMS_ADC_Pos = 0x0
	// Bit mask of ADC field.
	USB0_HCCPARAMS_ADC_Msk = 0x1
	// Bit ADC.
	USB0_HCCPARAMS_ADC = 0x1
	// Position of PFL field.
	USB0_HCCPARAMS_PFL_Pos = 0x1
	// Bit mask of PFL field.
	USB0_HCCPARAMS_PFL_Msk = 0x2
	// Bit PFL.
	USB0_HCCPARAMS_PFL = 0x2
	// Position of ASP field.
	USB0_HCCPARAMS_ASP_Pos = 0x2
	// Bit mask of ASP field.
	USB0_HCCPARAMS_ASP_Msk = 0x4
	// Bit ASP.
	USB0_HCCPARAMS_ASP = 0x4
	// Position of IST field.
	USB0_HCCPARAMS_IST_Pos = 0x4
	// Bit mask of IST field.
	USB0_HCCPARAMS_IST_Msk = 0xf0
	// Position of EECP field.
	USB0_HCCPARAMS_EECP_Pos = 0x8
	// Bit mask of EECP field.
	USB0_HCCPARAMS_EECP_Msk = 0xff00
	// Position of RESERVED field.
	USB0_HCCPARAMS_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB0_HCCPARAMS_RESERVED_Msk = 0xffff0000

	// DCIVERSION: Device interface version number
	// Position of DCIVERSION field.
	USB0_DCIVERSION_DCIVERSION_Pos = 0x0
	// Bit mask of DCIVERSION field.
	USB0_DCIVERSION_DCIVERSION_Msk = 0xffff

	// USBCMD_D: USB command (device mode)
	// Position of RS field.
	USB0_USBCMD_D_RS_Pos = 0x0
	// Bit mask of RS field.
	USB0_USBCMD_D_RS_Msk = 0x1
	// Bit RS.
	USB0_USBCMD_D_RS = 0x1
	// Writing a 0 to this bit will cause a detach event.
	USB0_USBCMD_D_RS_DETACH = 0x0
	// Writing a one to this bit will cause the device controller to enable a pull-up on USB_DP and initiate an attach event. This control bit is not directly connected to the pull-up enable, as the pull-up will become disabled upon transitioning into high-speed mode. Software should use this bit to prevent an attach event before the device controller has been properly initialized.
	USB0_USBCMD_D_RS_ATTACH = 0x1
	// Position of RST field.
	USB0_USBCMD_D_RST_Pos = 0x1
	// Bit mask of RST field.
	USB0_USBCMD_D_RST_Msk = 0x2
	// Bit RST.
	USB0_USBCMD_D_RST = 0x2
	// Set to 0 by hardware when the reset process is complete.
	USB0_USBCMD_D_RST_RESETCOMPLETE = 0x0
	// When software writes a one to this bit, the Device Controller resets its internal pipelines, timers, counters, state machines etc. to their initial values. Writing a one to this bit when the device is in the attached state is not recommended, since the effect on an attached host is undefined. In order to ensure that the device is not in an attached state before initiating a device controller reset, all primed endpoints should be flushed and the USBCMD Run/Stop bit should be set to 0.
	USB0_USBCMD_D_RST_RESET = 0x1
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0xc
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB0_USBCMD_D_RESERVED = 0x10
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USB0_USBCMD_D_RESERVED = 0x20
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0x40
	// Bit RESERVED.
	USB0_USBCMD_D_RESERVED = 0x40
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USB0_USBCMD_D_RESERVED = 0x80
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0x300
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USB0_USBCMD_D_RESERVED = 0x400
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0x800
	// Bit RESERVED.
	USB0_USBCMD_D_RESERVED = 0x800
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	USB0_USBCMD_D_RESERVED = 0x1000
	// Position of SUTW field.
	USB0_USBCMD_D_SUTW_Pos = 0xd
	// Bit mask of SUTW field.
	USB0_USBCMD_D_SUTW_Msk = 0x2000
	// Bit SUTW.
	USB0_USBCMD_D_SUTW = 0x2000
	// Position of ATDTW field.
	USB0_USBCMD_D_ATDTW_Pos = 0xe
	// Bit mask of ATDTW field.
	USB0_USBCMD_D_ATDTW_Msk = 0x4000
	// Bit ATDTW.
	USB0_USBCMD_D_ATDTW = 0x4000
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0x8000
	// Bit RESERVED.
	USB0_USBCMD_D_RESERVED = 0x8000
	// Position of ITC field.
	USB0_USBCMD_D_ITC_Pos = 0x10
	// Bit mask of ITC field.
	USB0_USBCMD_D_ITC_Msk = 0xff0000
	// Position of RESERVED field.
	USB0_USBCMD_D_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB0_USBCMD_D_RESERVED_Msk = 0xff000000

	// USBCMD_H: USB command (host mode)
	// Position of RS field.
	USB0_USBCMD_H_RS_Pos = 0x0
	// Bit mask of RS field.
	USB0_USBCMD_H_RS_Msk = 0x1
	// Bit RS.
	USB0_USBCMD_H_RS = 0x1
	// When this bit is set to 0, the Host Controller completes the current transaction on the USB and then halts. The HC Halted bit in the status register indicates when the Host Controller has finished the transaction and has entered the stopped state. Software should not write a one to this field unless the host controller is in the Halted state (i.e. HCHalted in the USBSTS register is a one).
	USB0_USBCMD_H_RS_HALT = 0x0
	// When set to a 1, the Host Controller proceeds with the execution of the schedule. The Host Controller continues execution as long as this bit is set to a one.
	USB0_USBCMD_H_RS_PROCEED = 0x1
	// Position of RST field.
	USB0_USBCMD_H_RST_Pos = 0x1
	// Bit mask of RST field.
	USB0_USBCMD_H_RST_Msk = 0x2
	// Bit RST.
	USB0_USBCMD_H_RST = 0x2
	// This bit is set to zero by hardware when the reset process is complete.
	USB0_USBCMD_H_RST_RESETCOMPLETE = 0x0
	// When software writes a one to this bit, the Host Controller resets its internal pipelines, timers, counters, state machines etc. to their initial value. Any transaction currently in progress on USB is immediately terminated. A USB reset is not driven on downstream ports. Software should not set this bit to a one when the HCHalted bit in the USBSTS register is a zero. Attempting to reset an actively running host controller will result in undefined behavior.
	USB0_USBCMD_H_RST_RESET = 0x1
	// Position of FS0 field.
	USB0_USBCMD_H_FS0_Pos = 0x2
	// Bit mask of FS0 field.
	USB0_USBCMD_H_FS0_Msk = 0x4
	// Bit FS0.
	USB0_USBCMD_H_FS0 = 0x4
	// Position of FS1 field.
	USB0_USBCMD_H_FS1_Pos = 0x3
	// Bit mask of FS1 field.
	USB0_USBCMD_H_FS1_Msk = 0x8
	// Bit FS1.
	USB0_USBCMD_H_FS1 = 0x8
	// Position of PSE field.
	USB0_USBCMD_H_PSE_Pos = 0x4
	// Bit mask of PSE field.
	USB0_USBCMD_H_PSE_Msk = 0x10
	// Bit PSE.
	USB0_USBCMD_H_PSE = 0x10
	// Do not process the periodic schedule.
	USB0_USBCMD_H_PSE_DO_NOT_PROCESS_THE_P = 0x0
	// Use the PERIODICLISTBASE register to access the periodic schedule.
	USB0_USBCMD_H_PSE_USE_THE_PERIODICLIST = 0x1
	// Position of ASE field.
	USB0_USBCMD_H_ASE_Pos = 0x5
	// Bit mask of ASE field.
	USB0_USBCMD_H_ASE_Msk = 0x20
	// Bit ASE.
	USB0_USBCMD_H_ASE = 0x20
	// Do not process the asynchronous schedule.
	USB0_USBCMD_H_ASE_DO_NOT_PROCESS_THE_A = 0x0
	// Use the ASYNCLISTADDR to access the asynchronous schedule.
	USB0_USBCMD_H_ASE_USE_THE_ASYNCLISTADD = 0x1
	// Position of IAA field.
	USB0_USBCMD_H_IAA_Pos = 0x6
	// Bit mask of IAA field.
	USB0_USBCMD_H_IAA_Msk = 0x40
	// Bit IAA.
	USB0_USBCMD_H_IAA = 0x40
	// The host controller sets this bit to zero after it has set the Interrupt on Sync Advance status bit in the USBSTS register to one.
	USB0_USBCMD_H_IAA_THE_HOST_CONTROLLER_ = 0x0
	// Software must write a 1 to this bit to ring the doorbell. When the host controller has evicted all appropriate cached schedule states, it sets the Interrupt on Async Advance status bit in the USBSTS register. If the Interrupt on Sync Advance Enable bit in the USBINTR register is one, then the host controller will assert an interrupt at the next interrupt threshold. Software should not write a one to this bit when the asynchronous schedule is inactive. Doing so will yield undefined results.
	USB0_USBCMD_H_IAA_SOFTWARE_MUST_WRITE_ = 0x1
	// Position of RESERVED field.
	USB0_USBCMD_H_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USB0_USBCMD_H_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USB0_USBCMD_H_RESERVED = 0x80
	// Position of ASP1_0 field.
	USB0_USBCMD_H_ASP1_0_Pos = 0x8
	// Bit mask of ASP1_0 field.
	USB0_USBCMD_H_ASP1_0_Msk = 0x300
	// Position of RESERVED field.
	USB0_USBCMD_H_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB0_USBCMD_H_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USB0_USBCMD_H_RESERVED = 0x400
	// Position of ASPE field.
	USB0_USBCMD_H_ASPE_Pos = 0xb
	// Bit mask of ASPE field.
	USB0_USBCMD_H_ASPE_Msk = 0x800
	// Bit ASPE.
	USB0_USBCMD_H_ASPE = 0x800
	// Park mode is disabled.
	USB0_USBCMD_H_ASPE_PARK_MODE_IS_DISABLE = 0x0
	// Park mode is enabled.
	USB0_USBCMD_H_ASPE_PARK_MODE_IS_ENABLED = 0x1
	// Position of RESERVED field.
	USB0_USBCMD_H_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	USB0_USBCMD_H_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	USB0_USBCMD_H_RESERVED = 0x1000
	// Position of RESERVED field.
	USB0_USBCMD_H_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB0_USBCMD_H_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USB0_USBCMD_H_RESERVED = 0x2000
	// Position of RESERVED field.
	USB0_USBCMD_H_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	USB0_USBCMD_H_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	USB0_USBCMD_H_RESERVED = 0x4000
	// Position of FS2 field.
	USB0_USBCMD_H_FS2_Pos = 0xf
	// Bit mask of FS2 field.
	USB0_USBCMD_H_FS2_Msk = 0x8000
	// Bit FS2.
	USB0_USBCMD_H_FS2 = 0x8000
	// Position of ITC field.
	USB0_USBCMD_H_ITC_Pos = 0x10
	// Bit mask of ITC field.
	USB0_USBCMD_H_ITC_Msk = 0xff0000
	// Position of RESERVED field.
	USB0_USBCMD_H_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB0_USBCMD_H_RESERVED_Msk = 0xff000000

	// USBSTS_D: USB status (device mode)
	// Position of UI field.
	USB0_USBSTS_D_UI_Pos = 0x0
	// Bit mask of UI field.
	USB0_USBSTS_D_UI_Msk = 0x1
	// Bit UI.
	USB0_USBSTS_D_UI = 0x1
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_D_UI_ST = 0x0
	// This bit is set by the Host/Device Controller when the cause of an interrupt is a completion of a USB transaction where the Transfer Descriptor (TD) has an interrupt on complete (IOC) bit set. This bit is also set by the Host/Device Controller when a short packet is detected. A short packet is when the actual number of bytes received was less than the expected number of bytes.
	USB0_USBSTS_D_UI_CLEAR = 0x1
	// Position of UEI field.
	USB0_USBSTS_D_UEI_Pos = 0x1
	// Bit mask of UEI field.
	USB0_USBSTS_D_UEI_Msk = 0x2
	// Bit UEI.
	USB0_USBSTS_D_UEI = 0x2
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_D_UEI_ST = 0x0
	// When completion of a USB transaction results in an error condition, this bit is set by the Host/Device Controller. This bit is set along with the USBINT bit, if the TD on which the error interrupt occurred also had its interrupt on complete (IOC) bit set. The device controller detects resume signaling only (see Section 18.10.11.6).
	USB0_USBSTS_D_UEI_CLEAR = 0x1
	// Position of PCI field.
	USB0_USBSTS_D_PCI_Pos = 0x2
	// Bit mask of PCI field.
	USB0_USBSTS_D_PCI_Msk = 0x4
	// Bit PCI.
	USB0_USBSTS_D_PCI = 0x4
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_D_PCI_ST = 0x0
	// The Device Controller sets this bit to a one when the port controller enters the full or high-speed operational state. When the port controller exits the full or high-speed operation states due to Reset or Suspend events, the notification mechanisms are the USB Reset Received bit (URI) and the DCSuspend bits (SLI) respectively.
	USB0_USBSTS_D_PCI_CLEAR = 0x1
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USB0_USBSTS_D_RESERVED = 0x8
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB0_USBSTS_D_RESERVED = 0x10
	// Position of AAI field.
	USB0_USBSTS_D_AAI_Pos = 0x5
	// Bit mask of AAI field.
	USB0_USBSTS_D_AAI_Msk = 0x20
	// Bit AAI.
	USB0_USBSTS_D_AAI = 0x20
	// Position of URI field.
	USB0_USBSTS_D_URI_Pos = 0x6
	// Bit mask of URI field.
	USB0_USBSTS_D_URI_Msk = 0x40
	// Bit URI.
	USB0_USBSTS_D_URI = 0x40
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_D_URI_ST = 0x0
	// When the device controller detects a USB Reset and enters the default state, this bit will be set to a one.
	USB0_USBSTS_D_URI_CLEAR = 0x1
	// Position of SRI field.
	USB0_USBSTS_D_SRI_Pos = 0x7
	// Bit mask of SRI field.
	USB0_USBSTS_D_SRI_Msk = 0x80
	// Bit SRI.
	USB0_USBSTS_D_SRI = 0x80
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_D_SRI_ST = 0x0
	// When the device controller detects a Start Of (micro) Frame, this bit will be set to a one. When a SOF is extremely late, the device controller will automatically set this bit to indicate that an SOF was expected. Therefore, this bit will be set roughly every 1 ms in device FS mode and every 125 ms in HS mode and will be synchronized to the actual SOF that is received. Since the device controller is initialized to FS before connect, this bit will be set at an interval of 1ms during the prelude to connect and chirp.
	USB0_USBSTS_D_SRI_CLEAR = 0x1
	// Position of SLI field.
	USB0_USBSTS_D_SLI_Pos = 0x8
	// Bit mask of SLI field.
	USB0_USBSTS_D_SLI_Msk = 0x100
	// Bit SLI.
	USB0_USBSTS_D_SLI = 0x100
	// The device controller clears the bit upon exiting from a suspend state. This bit is cleared by software writing a one to it.
	USB0_USBSTS_D_SLI_ST = 0x0
	// When a device controller enters a suspend state from an active state, this bit will be set to a one.
	USB0_USBSTS_D_SLI_CLEAR = 0x1
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0xe00
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	USB0_USBSTS_D_RESERVED = 0x1000
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USB0_USBSTS_D_RESERVED = 0x2000
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	USB0_USBSTS_D_RESERVED = 0x4000
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0x8000
	// Bit RESERVED.
	USB0_USBSTS_D_RESERVED = 0x8000
	// Position of NAKI field.
	USB0_USBSTS_D_NAKI_Pos = 0x10
	// Bit mask of NAKI field.
	USB0_USBSTS_D_NAKI_Msk = 0x10000
	// Bit NAKI.
	USB0_USBSTS_D_NAKI = 0x10000
	// This bit is automatically cleared by hardware when the all the enabled TX/RX Endpoint NAK bits are cleared.
	USB0_USBSTS_D_NAKI_ST = 0x0
	// It is set by hardware when for a particular endpoint both the TX/RX Endpoint NAK bit and the corresponding TX/RX Endpoint NAK Enable bit are set.
	USB0_USBSTS_D_NAKI_CLEAR = 0x1
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB0_USBSTS_D_RESERVED = 0x20000
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	USB0_USBSTS_D_RESERVED = 0x40000
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0x80000
	// Bit RESERVED.
	USB0_USBSTS_D_RESERVED = 0x80000
	// Position of RESERVED field.
	USB0_USBSTS_D_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB0_USBSTS_D_RESERVED_Msk = 0xfff00000

	// USBSTS_H: USB status (host mode)
	// Position of UI field.
	USB0_USBSTS_H_UI_Pos = 0x0
	// Bit mask of UI field.
	USB0_USBSTS_H_UI_Msk = 0x1
	// Bit UI.
	USB0_USBSTS_H_UI = 0x1
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_H_UI_ST = 0x0
	// This bit is set by the Host/Device Controller when the cause of an interrupt is a completion of a USB transaction where the Transfer Descriptor (TD) has an interrupt on complete (IOC) bit set. This bit is also set by the Host/Device Controller when a short packet is detected. A short packet is when the actual number of bytes received was less than the expected number of bytes.
	USB0_USBSTS_H_UI_CLEAR = 0x1
	// Position of UEI field.
	USB0_USBSTS_H_UEI_Pos = 0x1
	// Bit mask of UEI field.
	USB0_USBSTS_H_UEI_Msk = 0x2
	// Bit UEI.
	USB0_USBSTS_H_UEI = 0x2
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_H_UEI_ST = 0x0
	// When completion of a USB transaction results in an error condition, this bit is set by the Host/Device Controller. This bit is set along with the USBINT bit, if the TD on which the error interrupt occurred also had its interrupt on complete (IOC) bit set.
	USB0_USBSTS_H_UEI_CLEAR = 0x1
	// Position of PCI field.
	USB0_USBSTS_H_PCI_Pos = 0x2
	// Bit mask of PCI field.
	USB0_USBSTS_H_PCI_Msk = 0x4
	// Bit PCI.
	USB0_USBSTS_H_PCI = 0x4
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_H_PCI_ST = 0x0
	// The Host Controller sets this bit to a one when on any port a Connect Status occurs, a Port Enable/Disable Change occurs, or the Force Port Resume bit is set as the result of a J-K transition on the suspended port.
	USB0_USBSTS_H_PCI_CLEAR = 0x1
	// Position of FRI field.
	USB0_USBSTS_H_FRI_Pos = 0x3
	// Bit mask of FRI field.
	USB0_USBSTS_H_FRI_Msk = 0x8
	// Bit FRI.
	USB0_USBSTS_H_FRI = 0x8
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_H_FRI_ST = 0x0
	// The Host Controller sets this bit to a one when the Frame List Index rolls over from its maximum value to zero. The exact value at which the rollover occurs depends on the frame list size. For example, if the frame list size (as programmed in the Frame List Size field of the USBCMD register) is 1024, the Frame Index Register rolls over every time FRINDEX bit 13 toggles. Similarly, if the size is 512, the Host Controller sets this bit to a one every time FRINDEX bit 12 toggles (see Section 18.6.6).
	USB0_USBSTS_H_FRI_CLEAR = 0x1
	// Position of RESERVED field.
	USB0_USBSTS_H_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB0_USBSTS_H_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB0_USBSTS_H_RESERVED = 0x10
	// Position of AAI field.
	USB0_USBSTS_H_AAI_Pos = 0x5
	// Bit mask of AAI field.
	USB0_USBSTS_H_AAI_Msk = 0x20
	// Bit AAI.
	USB0_USBSTS_H_AAI = 0x20
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_H_AAI_ST = 0x0
	// System software can force the host controller to issue an interrupt the next time the host controller advances the asynchronous schedule by writing a one to the Interrupt on Async Advance Doorbell bit in the USBCMD register. This status bit indicates the assertion of that interrupt source.
	USB0_USBSTS_H_AAI_CLEAR = 0x1
	// Position of RESERVED field.
	USB0_USBSTS_H_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_USBSTS_H_RESERVED_Msk = 0x40
	// Bit RESERVED.
	USB0_USBSTS_H_RESERVED = 0x40
	// Position of SRI field.
	USB0_USBSTS_H_SRI_Pos = 0x7
	// Bit mask of SRI field.
	USB0_USBSTS_H_SRI_Msk = 0x80
	// Bit SRI.
	USB0_USBSTS_H_SRI = 0x80
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_H_SRI_ST = 0x0
	// In host mode, this bit will be set every 125 ms and can be used by host controller driver as a time base.
	USB0_USBSTS_H_SRI_CLEAR = 0x1
	// Position of RESERVED field.
	USB0_USBSTS_H_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB0_USBSTS_H_RESERVED_Msk = 0x100
	// Bit RESERVED.
	USB0_USBSTS_H_RESERVED = 0x100
	// Position of RESERVED field.
	USB0_USBSTS_H_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB0_USBSTS_H_RESERVED_Msk = 0xe00
	// Position of HCH field.
	USB0_USBSTS_H_HCH_Pos = 0xc
	// Bit mask of HCH field.
	USB0_USBSTS_H_HCH_Msk = 0x1000
	// Bit HCH.
	USB0_USBSTS_H_HCH = 0x1000
	// The RS bit in USBCMD is set to zero. Set by the host controller.
	USB0_USBSTS_H_HCH_RS = 0x0
	// The Host Controller sets this bit to one after it has stopped executing because of the Run/Stop bit being set to 0, either by software or by the Host Controller hardware (e.g. because of an internal error).
	USB0_USBSTS_H_HCH_HALT = 0x1
	// Position of RCL field.
	USB0_USBSTS_H_RCL_Pos = 0xd
	// Bit mask of RCL field.
	USB0_USBSTS_H_RCL_Msk = 0x2000
	// Bit RCL.
	USB0_USBSTS_H_RCL = 0x2000
	// No empty asynchronous schedule detected.
	USB0_USBSTS_H_RCL_NO_EMPTY_ASYNCHRONOU = 0x0
	// An empty asynchronous schedule is detected. Set by the host controller.
	USB0_USBSTS_H_RCL_EMPTY_ASYNCHRONOU = 0x1
	// Position of PS field.
	USB0_USBSTS_H_PS_Pos = 0xe
	// Bit mask of PS field.
	USB0_USBSTS_H_PS_Msk = 0x4000
	// Bit PS.
	USB0_USBSTS_H_PS = 0x4000
	// Position of AS field.
	USB0_USBSTS_H_AS_Pos = 0xf
	// Bit mask of AS field.
	USB0_USBSTS_H_AS_Msk = 0x8000
	// Bit AS.
	USB0_USBSTS_H_AS = 0x8000
	// Position of RESERVED field.
	USB0_USBSTS_H_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB0_USBSTS_H_RESERVED_Msk = 0x10000
	// Bit RESERVED.
	USB0_USBSTS_H_RESERVED = 0x10000
	// Position of RESERVED field.
	USB0_USBSTS_H_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB0_USBSTS_H_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB0_USBSTS_H_RESERVED = 0x20000
	// Position of UAI field.
	USB0_USBSTS_H_UAI_Pos = 0x12
	// Bit mask of UAI field.
	USB0_USBSTS_H_UAI_Msk = 0x40000
	// Bit UAI.
	USB0_USBSTS_H_UAI = 0x40000
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_H_UAI_ST = 0x0
	// This bit is set by the Host Controller when the cause of an interrupt is a completion of a USB transaction where the Transfer Descriptor (TD) has an interrupt on complete (IOC) bit set and the TD was from the asynchronous schedule. This bit is also set by the Host when a short packet is detected and the packet is on the asynchronous schedule. A short packet is when the actual number of bytes received was less than the expected number of bytes.
	USB0_USBSTS_H_UAI_CLEAR = 0x1
	// Position of UPI field.
	USB0_USBSTS_H_UPI_Pos = 0x13
	// Bit mask of UPI field.
	USB0_USBSTS_H_UPI_Msk = 0x80000
	// Bit UPI.
	USB0_USBSTS_H_UPI = 0x80000
	// This bit is cleared by software writing a one to it.
	USB0_USBSTS_H_UPI_ST = 0x0
	// This bit is set by the Host Controller when the cause of an interrupt is a completion of a USB transaction where the Transfer Descriptor (TD) has an interrupt on complete (IOC) bit set and the TD was from the periodic schedule. This bit is also set by the Host Controller when a short packet is detected and the packet is on the periodic schedule. A short packet is when the actual number of bytes received was less than the expected number of bytes.
	USB0_USBSTS_H_UPI_CLEAR = 0x1
	// Position of RESERVED field.
	USB0_USBSTS_H_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB0_USBSTS_H_RESERVED_Msk = 0xfff00000

	// USBINTR_D: USB interrupt enable (device mode)
	// Position of UE field.
	USB0_USBINTR_D_UE_Pos = 0x0
	// Bit mask of UE field.
	USB0_USBINTR_D_UE_Msk = 0x1
	// Bit UE.
	USB0_USBINTR_D_UE = 0x1
	// Position of UEE field.
	USB0_USBINTR_D_UEE_Pos = 0x1
	// Bit mask of UEE field.
	USB0_USBINTR_D_UEE_Msk = 0x2
	// Bit UEE.
	USB0_USBINTR_D_UEE = 0x2
	// Position of PCE field.
	USB0_USBINTR_D_PCE_Pos = 0x2
	// Bit mask of PCE field.
	USB0_USBINTR_D_PCE_Msk = 0x4
	// Bit PCE.
	USB0_USBINTR_D_PCE = 0x4
	// Position of RESERVED field.
	USB0_USBINTR_D_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USB0_USBINTR_D_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USB0_USBINTR_D_RESERVED = 0x8
	// Position of RESERVED field.
	USB0_USBINTR_D_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB0_USBINTR_D_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB0_USBINTR_D_RESERVED = 0x10
	// Position of RESERVED field.
	USB0_USBINTR_D_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB0_USBINTR_D_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USB0_USBINTR_D_RESERVED = 0x20
	// Position of URE field.
	USB0_USBINTR_D_URE_Pos = 0x6
	// Bit mask of URE field.
	USB0_USBINTR_D_URE_Msk = 0x40
	// Bit URE.
	USB0_USBINTR_D_URE = 0x40
	// Position of SRE field.
	USB0_USBINTR_D_SRE_Pos = 0x7
	// Bit mask of SRE field.
	USB0_USBINTR_D_SRE_Msk = 0x80
	// Bit SRE.
	USB0_USBINTR_D_SRE = 0x80
	// Position of SLE field.
	USB0_USBINTR_D_SLE_Pos = 0x8
	// Bit mask of SLE field.
	USB0_USBINTR_D_SLE_Msk = 0x100
	// Bit SLE.
	USB0_USBINTR_D_SLE = 0x100
	// Position of RESERVED field.
	USB0_USBINTR_D_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB0_USBINTR_D_RESERVED_Msk = 0xfe00
	// Position of NAKE field.
	USB0_USBINTR_D_NAKE_Pos = 0x10
	// Bit mask of NAKE field.
	USB0_USBINTR_D_NAKE_Msk = 0x10000
	// Bit NAKE.
	USB0_USBINTR_D_NAKE = 0x10000
	// Position of RESERVED field.
	USB0_USBINTR_D_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB0_USBINTR_D_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB0_USBINTR_D_RESERVED = 0x20000
	// Position of RESERVED field.
	USB0_USBINTR_D_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	USB0_USBINTR_D_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	USB0_USBINTR_D_RESERVED = 0x40000
	// Position of RESERVED field.
	USB0_USBINTR_D_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	USB0_USBINTR_D_RESERVED_Msk = 0x80000
	// Bit RESERVED.
	USB0_USBINTR_D_RESERVED = 0x80000
	// Position of RESERVED field.
	USB0_USBINTR_D_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB0_USBINTR_D_RESERVED_Msk = 0xfff00000

	// USBINTR_H: USB interrupt enable (host mode)
	// Position of UE field.
	USB0_USBINTR_H_UE_Pos = 0x0
	// Bit mask of UE field.
	USB0_USBINTR_H_UE_Msk = 0x1
	// Bit UE.
	USB0_USBINTR_H_UE = 0x1
	// Position of UEE field.
	USB0_USBINTR_H_UEE_Pos = 0x1
	// Bit mask of UEE field.
	USB0_USBINTR_H_UEE_Msk = 0x2
	// Bit UEE.
	USB0_USBINTR_H_UEE = 0x2
	// Position of PCE field.
	USB0_USBINTR_H_PCE_Pos = 0x2
	// Bit mask of PCE field.
	USB0_USBINTR_H_PCE_Msk = 0x4
	// Bit PCE.
	USB0_USBINTR_H_PCE = 0x4
	// Position of FRE field.
	USB0_USBINTR_H_FRE_Pos = 0x3
	// Bit mask of FRE field.
	USB0_USBINTR_H_FRE_Msk = 0x8
	// Bit FRE.
	USB0_USBINTR_H_FRE = 0x8
	// Position of RESERVED field.
	USB0_USBINTR_H_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB0_USBINTR_H_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB0_USBINTR_H_RESERVED = 0x10
	// Position of AAE field.
	USB0_USBINTR_H_AAE_Pos = 0x5
	// Bit mask of AAE field.
	USB0_USBINTR_H_AAE_Msk = 0x20
	// Bit AAE.
	USB0_USBINTR_H_AAE = 0x20
	// Position of RESERVED field.
	USB0_USBINTR_H_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_USBINTR_H_RESERVED_Msk = 0x40
	// Bit RESERVED.
	USB0_USBINTR_H_RESERVED = 0x40
	// Position of SRE field.
	USB0_USBINTR_H_SRE_Pos = 0x7
	// Bit mask of SRE field.
	USB0_USBINTR_H_SRE_Msk = 0x80
	// Bit SRE.
	USB0_USBINTR_H_SRE = 0x80
	// Position of RESERVED field.
	USB0_USBINTR_H_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB0_USBINTR_H_RESERVED_Msk = 0x100
	// Bit RESERVED.
	USB0_USBINTR_H_RESERVED = 0x100
	// Position of RESERVED field.
	USB0_USBINTR_H_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB0_USBINTR_H_RESERVED_Msk = 0xfe00
	// Position of RESERVED field.
	USB0_USBINTR_H_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB0_USBINTR_H_RESERVED_Msk = 0x10000
	// Bit RESERVED.
	USB0_USBINTR_H_RESERVED = 0x10000
	// Position of RESERVED field.
	USB0_USBINTR_H_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB0_USBINTR_H_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB0_USBINTR_H_RESERVED = 0x20000
	// Position of UAIE field.
	USB0_USBINTR_H_UAIE_Pos = 0x12
	// Bit mask of UAIE field.
	USB0_USBINTR_H_UAIE_Msk = 0x40000
	// Bit UAIE.
	USB0_USBINTR_H_UAIE = 0x40000
	// Position of UPIA field.
	USB0_USBINTR_H_UPIA_Pos = 0x13
	// Bit mask of UPIA field.
	USB0_USBINTR_H_UPIA_Msk = 0x80000
	// Bit UPIA.
	USB0_USBINTR_H_UPIA = 0x80000
	// Position of RESERVED field.
	USB0_USBINTR_H_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB0_USBINTR_H_RESERVED_Msk = 0xfff00000

	// FRINDEX_D: USB frame index (device mode)
	// Position of FRINDEX2_0 field.
	USB0_FRINDEX_D_FRINDEX2_0_Pos = 0x0
	// Bit mask of FRINDEX2_0 field.
	USB0_FRINDEX_D_FRINDEX2_0_Msk = 0x7
	// Position of FRINDEX13_3 field.
	USB0_FRINDEX_D_FRINDEX13_3_Pos = 0x3
	// Bit mask of FRINDEX13_3 field.
	USB0_FRINDEX_D_FRINDEX13_3_Msk = 0x3ff8
	// Position of RESERVED field.
	USB0_FRINDEX_D_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	USB0_FRINDEX_D_RESERVED_Msk = 0xffffc000

	// FRINDEX_H: USB frame index (host mode)
	// Position of FRINDEX2_0 field.
	USB0_FRINDEX_H_FRINDEX2_0_Pos = 0x0
	// Bit mask of FRINDEX2_0 field.
	USB0_FRINDEX_H_FRINDEX2_0_Msk = 0x7
	// Position of FRINDEX12_3 field.
	USB0_FRINDEX_H_FRINDEX12_3_Pos = 0x3
	// Bit mask of FRINDEX12_3 field.
	USB0_FRINDEX_H_FRINDEX12_3_Msk = 0x1ff8
	// Position of RESERVED field.
	USB0_FRINDEX_H_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB0_FRINDEX_H_RESERVED_Msk = 0xffffe000

	// DEVICEADDR: USB device address (device mode)
	// Position of RESERVED field.
	USB0_DEVICEADDR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB0_DEVICEADDR_RESERVED_Msk = 0xffffff
	// Position of USBADRA field.
	USB0_DEVICEADDR_USBADRA_Pos = 0x18
	// Bit mask of USBADRA field.
	USB0_DEVICEADDR_USBADRA_Msk = 0x1000000
	// Bit USBADRA.
	USB0_DEVICEADDR_USBADRA = 0x1000000
	// Any write to USBADR are instantaneous.
	USB0_DEVICEADDR_USBADRA_INSTANTANEOUS = 0x0
	// When the user writes a one to this bit at the same time or before USBADR is written, the write to USBADR fields is staged and held in a hidden register. After an IN occurs on endpoint 0 and is acknowledged, USBADR will be loaded from the holding register. Hardware will automatically clear this bit on the following conditions: IN is ACKed to endpoint 0. USBADR is updated from the staging register. OUT/SETUP occurs on endpoint 0. USBADR is not updated. Device reset occurs. USBADR is set to 0. After the status phase of the SET_ADDRESS descriptor, the DCD has 2 ms to program the USBADR field. This mechanism will ensure this specification is met when the DCD can not write the device address within 2 ms from the SET_ADDRESS status phase. If the DCD writes the USBADR with USBADRA=1 after the SET_ADDRESS data phase (before the prime of the status phase), the USBADR will be programmed instantly at the correct time and meet the 2 ms USB requirement.
	USB0_DEVICEADDR_USBADRA_DELAYED = 0x1
	// Position of USBADR field.
	USB0_DEVICEADDR_USBADR_Pos = 0x19
	// Bit mask of USBADR field.
	USB0_DEVICEADDR_USBADR_Msk = 0xfe000000

	// PERIODICLISTBASE: Frame list base address (host mode)
	// Position of RESERVED field.
	USB0_PERIODICLISTBASE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB0_PERIODICLISTBASE_RESERVED_Msk = 0xfff
	// Position of PERBASE31_12 field.
	USB0_PERIODICLISTBASE_PERBASE31_12_Pos = 0xc
	// Bit mask of PERBASE31_12 field.
	USB0_PERIODICLISTBASE_PERBASE31_12_Msk = 0xfffff000

	// ENDPOINTLISTADDR: Address of endpoint list in memory
	// Position of RESERVED field.
	USB0_ENDPOINTLISTADDR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB0_ENDPOINTLISTADDR_RESERVED_Msk = 0x7ff
	// Position of EPBASE31_11 field.
	USB0_ENDPOINTLISTADDR_EPBASE31_11_Pos = 0xb
	// Bit mask of EPBASE31_11 field.
	USB0_ENDPOINTLISTADDR_EPBASE31_11_Msk = 0xfffff800

	// ASYNCLISTADDR: Address of endpoint list in memory
	// Position of RESERVED field.
	USB0_ASYNCLISTADDR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB0_ASYNCLISTADDR_RESERVED_Msk = 0x1f
	// Position of ASYBASE31_5 field.
	USB0_ASYNCLISTADDR_ASYBASE31_5_Pos = 0x5
	// Bit mask of ASYBASE31_5 field.
	USB0_ASYNCLISTADDR_ASYBASE31_5_Msk = 0xffffffe0

	// TTCTRL: Asynchronous buffer status for embedded TT (host mode)
	// Position of RESERVED field.
	USB0_TTCTRL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB0_TTCTRL_RESERVED_Msk = 0xffffff
	// Position of TTHA field.
	USB0_TTCTRL_TTHA_Pos = 0x18
	// Bit mask of TTHA field.
	USB0_TTCTRL_TTHA_Msk = 0x7f000000
	// Position of RESERVED field.
	USB0_TTCTRL_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	USB0_TTCTRL_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	USB0_TTCTRL_RESERVED = 0x80000000

	// BURSTSIZE: Programmable burst size
	// Position of RXPBURST field.
	USB0_BURSTSIZE_RXPBURST_Pos = 0x0
	// Bit mask of RXPBURST field.
	USB0_BURSTSIZE_RXPBURST_Msk = 0xff
	// Position of TXPBURST field.
	USB0_BURSTSIZE_TXPBURST_Pos = 0x8
	// Bit mask of TXPBURST field.
	USB0_BURSTSIZE_TXPBURST_Msk = 0xff00
	// Position of RESERVED field.
	USB0_BURSTSIZE_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB0_BURSTSIZE_RESERVED_Msk = 0xffff0000

	// TXFILLTUNING: Host transmit pre-buffer packet tuning (host mode)
	// Position of TXSCHOH field.
	USB0_TXFILLTUNING_TXSCHOH_Pos = 0x0
	// Bit mask of TXSCHOH field.
	USB0_TXFILLTUNING_TXSCHOH_Msk = 0xff
	// Position of TXSCHEATLTH field.
	USB0_TXFILLTUNING_TXSCHEATLTH_Pos = 0x8
	// Bit mask of TXSCHEATLTH field.
	USB0_TXFILLTUNING_TXSCHEATLTH_Msk = 0x1f00
	// Position of RESERVED field.
	USB0_TXFILLTUNING_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB0_TXFILLTUNING_RESERVED_Msk = 0xe000
	// Position of TXFIFOTHRES field.
	USB0_TXFILLTUNING_TXFIFOTHRES_Pos = 0x10
	// Bit mask of TXFIFOTHRES field.
	USB0_TXFILLTUNING_TXFIFOTHRES_Msk = 0x3f0000
	// Position of RESERVED field.
	USB0_TXFILLTUNING_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	USB0_TXFILLTUNING_RESERVED_Msk = 0xffc00000

	// BINTERVAL: Length of virtual frame
	// Position of BINT field.
	USB0_BINTERVAL_BINT_Pos = 0x0
	// Bit mask of BINT field.
	USB0_BINTERVAL_BINT_Msk = 0xf
	// Position of RESERVED field.
	USB0_BINTERVAL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB0_BINTERVAL_RESERVED_Msk = 0xfffffff0

	// ENDPTNAK: Endpoint NAK (device mode)
	// Position of EPRN0 field.
	USB0_ENDPTNAK_EPRN0_Pos = 0x0
	// Bit mask of EPRN0 field.
	USB0_ENDPTNAK_EPRN0_Msk = 0x1
	// Bit EPRN0.
	USB0_ENDPTNAK_EPRN0 = 0x1
	// Position of EPRN1 field.
	USB0_ENDPTNAK_EPRN1_Pos = 0x1
	// Bit mask of EPRN1 field.
	USB0_ENDPTNAK_EPRN1_Msk = 0x2
	// Bit EPRN1.
	USB0_ENDPTNAK_EPRN1 = 0x2
	// Position of EPRN2 field.
	USB0_ENDPTNAK_EPRN2_Pos = 0x2
	// Bit mask of EPRN2 field.
	USB0_ENDPTNAK_EPRN2_Msk = 0x4
	// Bit EPRN2.
	USB0_ENDPTNAK_EPRN2 = 0x4
	// Position of EPRN3 field.
	USB0_ENDPTNAK_EPRN3_Pos = 0x3
	// Bit mask of EPRN3 field.
	USB0_ENDPTNAK_EPRN3_Msk = 0x8
	// Bit EPRN3.
	USB0_ENDPTNAK_EPRN3 = 0x8
	// Position of EPRN4 field.
	USB0_ENDPTNAK_EPRN4_Pos = 0x4
	// Bit mask of EPRN4 field.
	USB0_ENDPTNAK_EPRN4_Msk = 0x10
	// Bit EPRN4.
	USB0_ENDPTNAK_EPRN4 = 0x10
	// Position of EPRN5 field.
	USB0_ENDPTNAK_EPRN5_Pos = 0x5
	// Bit mask of EPRN5 field.
	USB0_ENDPTNAK_EPRN5_Msk = 0x20
	// Bit EPRN5.
	USB0_ENDPTNAK_EPRN5 = 0x20
	// Position of RESERVED field.
	USB0_ENDPTNAK_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_ENDPTNAK_RESERVED_Msk = 0xffc0
	// Position of EPTN0 field.
	USB0_ENDPTNAK_EPTN0_Pos = 0x10
	// Bit mask of EPTN0 field.
	USB0_ENDPTNAK_EPTN0_Msk = 0x10000
	// Bit EPTN0.
	USB0_ENDPTNAK_EPTN0 = 0x10000
	// Position of EPTN1 field.
	USB0_ENDPTNAK_EPTN1_Pos = 0x11
	// Bit mask of EPTN1 field.
	USB0_ENDPTNAK_EPTN1_Msk = 0x20000
	// Bit EPTN1.
	USB0_ENDPTNAK_EPTN1 = 0x20000
	// Position of EPTN2 field.
	USB0_ENDPTNAK_EPTN2_Pos = 0x12
	// Bit mask of EPTN2 field.
	USB0_ENDPTNAK_EPTN2_Msk = 0x40000
	// Bit EPTN2.
	USB0_ENDPTNAK_EPTN2 = 0x40000
	// Position of EPTN3 field.
	USB0_ENDPTNAK_EPTN3_Pos = 0x13
	// Bit mask of EPTN3 field.
	USB0_ENDPTNAK_EPTN3_Msk = 0x80000
	// Bit EPTN3.
	USB0_ENDPTNAK_EPTN3 = 0x80000
	// Position of EPTN4 field.
	USB0_ENDPTNAK_EPTN4_Pos = 0x14
	// Bit mask of EPTN4 field.
	USB0_ENDPTNAK_EPTN4_Msk = 0x100000
	// Bit EPTN4.
	USB0_ENDPTNAK_EPTN4 = 0x100000
	// Position of EPTN5 field.
	USB0_ENDPTNAK_EPTN5_Pos = 0x15
	// Bit mask of EPTN5 field.
	USB0_ENDPTNAK_EPTN5_Msk = 0x200000
	// Bit EPTN5.
	USB0_ENDPTNAK_EPTN5 = 0x200000
	// Position of RESERVED field.
	USB0_ENDPTNAK_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	USB0_ENDPTNAK_RESERVED_Msk = 0xffc00000

	// ENDPTNAKEN: Endpoint NAK Enable (device mode)
	// Position of EPRNE0 field.
	USB0_ENDPTNAKEN_EPRNE0_Pos = 0x0
	// Bit mask of EPRNE0 field.
	USB0_ENDPTNAKEN_EPRNE0_Msk = 0x1
	// Bit EPRNE0.
	USB0_ENDPTNAKEN_EPRNE0 = 0x1
	// Position of EPRNE1 field.
	USB0_ENDPTNAKEN_EPRNE1_Pos = 0x1
	// Bit mask of EPRNE1 field.
	USB0_ENDPTNAKEN_EPRNE1_Msk = 0x2
	// Bit EPRNE1.
	USB0_ENDPTNAKEN_EPRNE1 = 0x2
	// Position of EPRNE2 field.
	USB0_ENDPTNAKEN_EPRNE2_Pos = 0x2
	// Bit mask of EPRNE2 field.
	USB0_ENDPTNAKEN_EPRNE2_Msk = 0x4
	// Bit EPRNE2.
	USB0_ENDPTNAKEN_EPRNE2 = 0x4
	// Position of EPRNE3 field.
	USB0_ENDPTNAKEN_EPRNE3_Pos = 0x3
	// Bit mask of EPRNE3 field.
	USB0_ENDPTNAKEN_EPRNE3_Msk = 0x8
	// Bit EPRNE3.
	USB0_ENDPTNAKEN_EPRNE3 = 0x8
	// Position of EPRNE4 field.
	USB0_ENDPTNAKEN_EPRNE4_Pos = 0x4
	// Bit mask of EPRNE4 field.
	USB0_ENDPTNAKEN_EPRNE4_Msk = 0x10
	// Bit EPRNE4.
	USB0_ENDPTNAKEN_EPRNE4 = 0x10
	// Position of EPRNE5 field.
	USB0_ENDPTNAKEN_EPRNE5_Pos = 0x5
	// Bit mask of EPRNE5 field.
	USB0_ENDPTNAKEN_EPRNE5_Msk = 0x20
	// Bit EPRNE5.
	USB0_ENDPTNAKEN_EPRNE5 = 0x20
	// Position of RESERVED field.
	USB0_ENDPTNAKEN_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_ENDPTNAKEN_RESERVED_Msk = 0xffc0
	// Position of EPTNE0 field.
	USB0_ENDPTNAKEN_EPTNE0_Pos = 0x10
	// Bit mask of EPTNE0 field.
	USB0_ENDPTNAKEN_EPTNE0_Msk = 0x10000
	// Bit EPTNE0.
	USB0_ENDPTNAKEN_EPTNE0 = 0x10000
	// Position of EPTNE1 field.
	USB0_ENDPTNAKEN_EPTNE1_Pos = 0x11
	// Bit mask of EPTNE1 field.
	USB0_ENDPTNAKEN_EPTNE1_Msk = 0x20000
	// Bit EPTNE1.
	USB0_ENDPTNAKEN_EPTNE1 = 0x20000
	// Position of EPTNE2 field.
	USB0_ENDPTNAKEN_EPTNE2_Pos = 0x12
	// Bit mask of EPTNE2 field.
	USB0_ENDPTNAKEN_EPTNE2_Msk = 0x40000
	// Bit EPTNE2.
	USB0_ENDPTNAKEN_EPTNE2 = 0x40000
	// Position of EPTNE3 field.
	USB0_ENDPTNAKEN_EPTNE3_Pos = 0x13
	// Bit mask of EPTNE3 field.
	USB0_ENDPTNAKEN_EPTNE3_Msk = 0x80000
	// Bit EPTNE3.
	USB0_ENDPTNAKEN_EPTNE3 = 0x80000
	// Position of EPTNE4 field.
	USB0_ENDPTNAKEN_EPTNE4_Pos = 0x14
	// Bit mask of EPTNE4 field.
	USB0_ENDPTNAKEN_EPTNE4_Msk = 0x100000
	// Bit EPTNE4.
	USB0_ENDPTNAKEN_EPTNE4 = 0x100000
	// Position of EPTNE5 field.
	USB0_ENDPTNAKEN_EPTNE5_Pos = 0x15
	// Bit mask of EPTNE5 field.
	USB0_ENDPTNAKEN_EPTNE5_Msk = 0x200000
	// Bit EPTNE5.
	USB0_ENDPTNAKEN_EPTNE5 = 0x200000
	// Position of RESERVED field.
	USB0_ENDPTNAKEN_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	USB0_ENDPTNAKEN_RESERVED_Msk = 0xffc00000

	// PORTSC1_D: Port 1 status/control (device mode)
	// Position of CCS field.
	USB0_PORTSC1_D_CCS_Pos = 0x0
	// Bit mask of CCS field.
	USB0_PORTSC1_D_CCS_Msk = 0x1
	// Bit CCS.
	USB0_PORTSC1_D_CCS = 0x1
	// Device not attached A zero indicates that the device did not attach successfully or was forcibly disconnected by the software writing a zero to the Run bit in the USBCMD register. It does not state the device being disconnected or suspended.
	USB0_PORTSC1_D_CCS_DEVICE_NOT_ATTACHED_ = 0x0
	// Device attached. A one indicates that the device successfully attached and is operating in either high-speed mode or full-speed mode as indicated by the High Speed Port bit in this register.
	USB0_PORTSC1_D_CCS_DEVICE_ATTACHED__A_ = 0x1
	// Position of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USB0_PORTSC1_D_RESERVED = 0x2
	// Position of PE field.
	USB0_PORTSC1_D_PE_Pos = 0x2
	// Bit mask of PE field.
	USB0_PORTSC1_D_PE_Msk = 0x4
	// Bit PE.
	USB0_PORTSC1_D_PE = 0x4
	// Position of PEC field.
	USB0_PORTSC1_D_PEC_Pos = 0x3
	// Bit mask of PEC field.
	USB0_PORTSC1_D_PEC_Msk = 0x8
	// Bit PEC.
	USB0_PORTSC1_D_PEC = 0x8
	// Position of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Msk = 0x30
	// Position of FPR field.
	USB0_PORTSC1_D_FPR_Pos = 0x6
	// Bit mask of FPR field.
	USB0_PORTSC1_D_FPR_Msk = 0x40
	// Bit FPR.
	USB0_PORTSC1_D_FPR = 0x40
	// No resume (K-state) detected/driven on port.
	USB0_PORTSC1_D_FPR_NO_RESUME = 0x0
	// Resume detected/driven on port.
	USB0_PORTSC1_D_FPR_RESUME_DETECTED = 0x1
	// Position of SUSP field.
	USB0_PORTSC1_D_SUSP_Pos = 0x7
	// Bit mask of SUSP field.
	USB0_PORTSC1_D_SUSP_Msk = 0x80
	// Bit SUSP.
	USB0_PORTSC1_D_SUSP = 0x80
	// Port not in suspend state
	USB0_PORTSC1_D_SUSP_PORT_NOT_IN_SUSPEND_ = 0x0
	// Port in suspend state
	USB0_PORTSC1_D_SUSP_PORT_IN_SUSPEND_STAT = 0x1
	// Position of PR field.
	USB0_PORTSC1_D_PR_Pos = 0x8
	// Bit mask of PR field.
	USB0_PORTSC1_D_PR_Msk = 0x100
	// Bit PR.
	USB0_PORTSC1_D_PR = 0x100
	// Port is not in the reset state.
	USB0_PORTSC1_D_PR_PORT_IS_NOT_IN_THE_R = 0x0
	// Port is in the reset state.
	USB0_PORTSC1_D_PR_PORT_IS_IN_THE_RESET = 0x1
	// Position of HSP field.
	USB0_PORTSC1_D_HSP_Pos = 0x9
	// Bit mask of HSP field.
	USB0_PORTSC1_D_HSP_Msk = 0x200
	// Bit HSP.
	USB0_PORTSC1_D_HSP = 0x200
	// Host/device connected to the port is not in High-speed mode.
	USB0_PORTSC1_D_HSP_NOT_HIGHSSPEED = 0x0
	// Host/device connected to the port is in High-speed mode.
	USB0_PORTSC1_D_HSP_HIGHSPEED = 0x1
	// Position of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Msk = 0xc00
	// Position of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	USB0_PORTSC1_D_RESERVED = 0x1000
	// Position of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USB0_PORTSC1_D_RESERVED = 0x2000
	// Position of PIC1_0 field.
	USB0_PORTSC1_D_PIC1_0_Pos = 0xe
	// Bit mask of PIC1_0 field.
	USB0_PORTSC1_D_PIC1_0_Msk = 0xc000
	// Port indicators are off.
	USB0_PORTSC1_D_PIC1_0_OFF = 0x0
	// amber
	USB0_PORTSC1_D_PIC1_0_AMBER = 0x1
	// green
	USB0_PORTSC1_D_PIC1_0_GREEN = 0x2
	// undefined
	USB0_PORTSC1_D_PIC1_0_UNDEFINED = 0x3
	// Position of PTC3_0 field.
	USB0_PORTSC1_D_PTC3_0_Pos = 0x10
	// Bit mask of PTC3_0 field.
	USB0_PORTSC1_D_PTC3_0_Msk = 0xf0000
	// TEST_MODE_DISABLE
	USB0_PORTSC1_D_PTC3_0_TEST_MODE_DISABLE = 0x0
	// J_STATE
	USB0_PORTSC1_D_PTC3_0_J_STATE = 0x1
	// K_STATE
	USB0_PORTSC1_D_PTC3_0_K_STATE = 0x2
	// SE0 (host)/NAK (device)
	USB0_PORTSC1_D_PTC3_0_SE0_NAK = 0x3
	// Packet
	USB0_PORTSC1_D_PTC3_0_PACKET = 0x4
	// FORCE_ENABLE_HS
	USB0_PORTSC1_D_PTC3_0_FORCE_ENABLE_HS = 0x5
	// FORCE_ENABLE_FS
	USB0_PORTSC1_D_PTC3_0_FORCE_ENABLE_FS = 0x6
	// Position of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Msk = 0x100000
	// Bit RESERVED.
	USB0_PORTSC1_D_RESERVED = 0x100000
	// Position of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Msk = 0x200000
	// Bit RESERVED.
	USB0_PORTSC1_D_RESERVED = 0x200000
	// Position of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Msk = 0x400000
	// Bit RESERVED.
	USB0_PORTSC1_D_RESERVED = 0x400000
	// Position of PHCD field.
	USB0_PORTSC1_D_PHCD_Pos = 0x17
	// Bit mask of PHCD field.
	USB0_PORTSC1_D_PHCD_Msk = 0x800000
	// Bit PHCD.
	USB0_PORTSC1_D_PHCD = 0x800000
	// Writing a 0 enables the PHY clock. Reading a 0 indicates the status of the PHY clock (enabled).
	USB0_PORTSC1_D_PHCD_ENABLE = 0x0
	// Writing a 1 disables the PHY clock. Reading a 1 indicates the status of the PHY clock (disabled).
	USB0_PORTSC1_D_PHCD_DISABLE = 0x1
	// Position of PFSC field.
	USB0_PORTSC1_D_PFSC_Pos = 0x18
	// Bit mask of PFSC field.
	USB0_PORTSC1_D_PFSC_Msk = 0x1000000
	// Bit PFSC.
	USB0_PORTSC1_D_PFSC = 0x1000000
	// Port connects at any speed.
	USB0_PORTSC1_D_PFSC_ANYSPEED = 0x0
	// Writing this bit to a 1 will force the port to only connect at full speed. It disables the chirp sequence that allows the port to identify itself as High-speed. This is useful for testing FS configurations with a HS host, hub or device.
	USB0_PORTSC1_D_PFSC_FULLSPEED = 0x1
	// Position of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Msk = 0x2000000
	// Bit RESERVED.
	USB0_PORTSC1_D_RESERVED = 0x2000000
	// Position of PSPD field.
	USB0_PORTSC1_D_PSPD_Pos = 0x1a
	// Bit mask of PSPD field.
	USB0_PORTSC1_D_PSPD_Msk = 0xc000000
	// Full-speed
	USB0_PORTSC1_D_PSPD_FULL_SPEED = 0x0
	// invalid in device mode
	USB0_PORTSC1_D_PSPD_INVALID_IN_DEVICE_MO = 0x1
	// High-speed
	USB0_PORTSC1_D_PSPD_HIGH_SPEED = 0x2
	// Position of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	USB0_PORTSC1_D_RESERVED_Msk = 0xf0000000

	// PORTSC1_H: Port 1 status/control (host mode)
	// Position of CCS field.
	USB0_PORTSC1_H_CCS_Pos = 0x0
	// Bit mask of CCS field.
	USB0_PORTSC1_H_CCS_Msk = 0x1
	// Bit CCS.
	USB0_PORTSC1_H_CCS = 0x1
	// No device is present.
	USB0_PORTSC1_H_CCS_NO_DEVICE_IS_PRESENT = 0x0
	// Device is present on the port.
	USB0_PORTSC1_H_CCS_DEVICE_IS_PRESENT_ON = 0x1
	// Position of CSC field.
	USB0_PORTSC1_H_CSC_Pos = 0x1
	// Bit mask of CSC field.
	USB0_PORTSC1_H_CSC_Msk = 0x2
	// Bit CSC.
	USB0_PORTSC1_H_CSC = 0x2
	// No change in current status.
	USB0_PORTSC1_H_CSC_NO_CHANGE_IN_CURRENT = 0x0
	// Change in current status.
	USB0_PORTSC1_H_CSC_CHANGE_IN_CURRENT_ST = 0x1
	// Position of PE field.
	USB0_PORTSC1_H_PE_Pos = 0x2
	// Bit mask of PE field.
	USB0_PORTSC1_H_PE_Msk = 0x4
	// Bit PE.
	USB0_PORTSC1_H_PE = 0x4
	// Port disabled.
	USB0_PORTSC1_H_PE_PORT_DISABLED_ = 0x0
	// Port enabled.
	USB0_PORTSC1_H_PE_PORT_ENABLED_ = 0x1
	// Position of PEC field.
	USB0_PORTSC1_H_PEC_Pos = 0x3
	// Bit mask of PEC field.
	USB0_PORTSC1_H_PEC_Msk = 0x8
	// Bit PEC.
	USB0_PORTSC1_H_PEC = 0x8
	// No change.
	USB0_PORTSC1_H_PEC_NO_CHANGE_ = 0x0
	// Port enabled/disabled status has changed.
	USB0_PORTSC1_H_PEC_CHANGED = 0x1
	// Position of OCA field.
	USB0_PORTSC1_H_OCA_Pos = 0x4
	// Bit mask of OCA field.
	USB0_PORTSC1_H_OCA_Msk = 0x10
	// Bit OCA.
	USB0_PORTSC1_H_OCA = 0x10
	// The port does not have an over-current condition.
	USB0_PORTSC1_H_OCA_THE_PORT_DOES_NOT_HA = 0x0
	// The port has currently an over-current condition.
	USB0_PORTSC1_H_OCA_THE_PORT_HAS_CURRENT = 0x1
	// Position of OCC field.
	USB0_PORTSC1_H_OCC_Pos = 0x5
	// Bit mask of OCC field.
	USB0_PORTSC1_H_OCC_Msk = 0x20
	// Bit OCC.
	USB0_PORTSC1_H_OCC = 0x20
	// Position of FPR field.
	USB0_PORTSC1_H_FPR_Pos = 0x6
	// Bit mask of FPR field.
	USB0_PORTSC1_H_FPR_Msk = 0x40
	// Bit FPR.
	USB0_PORTSC1_H_FPR = 0x40
	// No resume (K-state) detected/driven on port.
	USB0_PORTSC1_H_FPR_NO_RESUME = 0x0
	// Resume detected/driven on port.
	USB0_PORTSC1_H_FPR_RESUME_DETECTED = 0x1
	// Position of SUSP field.
	USB0_PORTSC1_H_SUSP_Pos = 0x7
	// Bit mask of SUSP field.
	USB0_PORTSC1_H_SUSP_Msk = 0x80
	// Bit SUSP.
	USB0_PORTSC1_H_SUSP = 0x80
	// Port not in suspend state
	USB0_PORTSC1_H_SUSP_PORT_NOT_IN_SUSPEND_ = 0x0
	// Port in suspend state When in suspend state, downstream propagation of data is blocked on this port, except for port reset. The blocking occurs at the end of the current transaction if a transaction was in progress when this bit was written to 1. In the suspend state, the port is sensitive to resume detection. Note that the bit status does not change until the port is suspended and that there may be a delay in suspending a port if there is a transaction currently in progress on the USB.
	USB0_PORTSC1_H_SUSP_PORT_IN_SUSPEND_STAT = 0x1
	// Position of PR field.
	USB0_PORTSC1_H_PR_Pos = 0x8
	// Bit mask of PR field.
	USB0_PORTSC1_H_PR_Msk = 0x100
	// Bit PR.
	USB0_PORTSC1_H_PR = 0x100
	// Port is not in the reset state.
	USB0_PORTSC1_H_PR_PORT_IS_NOT_IN_THE_R = 0x0
	// Port is in the reset state.
	USB0_PORTSC1_H_PR_PORT_IS_IN_THE_RESET = 0x1
	// Position of HSP field.
	USB0_PORTSC1_H_HSP_Pos = 0x9
	// Bit mask of HSP field.
	USB0_PORTSC1_H_HSP_Msk = 0x200
	// Bit HSP.
	USB0_PORTSC1_H_HSP = 0x200
	// Host/device connected to the port is not in High-speed mode.
	USB0_PORTSC1_H_HSP_NO_HISPEED = 0x0
	// Host/device connected to the port is in High-speed mode.
	USB0_PORTSC1_H_HSP_HISPEED = 0x1
	// Position of LS field.
	USB0_PORTSC1_H_LS_Pos = 0xa
	// Bit mask of LS field.
	USB0_PORTSC1_H_LS_Msk = 0xc00
	// SE0 (USB_DP and USB_DM LOW)
	USB0_PORTSC1_H_LS_SE0 = 0x0
	// J-state (USB_DP HIGH and USB_DM LOW)
	USB0_PORTSC1_H_LS_J_STATE = 0x1
	// K-state (USB_DP LOW and USB_DM HIGH)
	USB0_PORTSC1_H_LS_K_STATE = 0x2
	// Undefined
	USB0_PORTSC1_H_LS_UNDEFINED = 0x3
	// Position of PP field.
	USB0_PORTSC1_H_PP_Pos = 0xc
	// Bit mask of PP field.
	USB0_PORTSC1_H_PP_Msk = 0x1000
	// Bit PP.
	USB0_PORTSC1_H_PP = 0x1000
	// Port power off.
	USB0_PORTSC1_H_PP_PORT_POWER_OFF_ = 0x0
	// Port power on.
	USB0_PORTSC1_H_PP_PORT_POWER_ON_ = 0x1
	// Position of RESERVED field.
	USB0_PORTSC1_H_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB0_PORTSC1_H_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USB0_PORTSC1_H_RESERVED = 0x2000
	// Position of PIC1_0 field.
	USB0_PORTSC1_H_PIC1_0_Pos = 0xe
	// Bit mask of PIC1_0 field.
	USB0_PORTSC1_H_PIC1_0_Msk = 0xc000
	// Port indicators are off.
	USB0_PORTSC1_H_PIC1_0_PORT_INDICATORS_ARE_ = 0x0
	// Amber
	USB0_PORTSC1_H_PIC1_0_AMBER = 0x1
	// Green
	USB0_PORTSC1_H_PIC1_0_GREEN = 0x2
	// Undefined
	USB0_PORTSC1_H_PIC1_0_UNDEFINED = 0x3
	// Position of PTC3_0 field.
	USB0_PORTSC1_H_PTC3_0_Pos = 0x10
	// Bit mask of PTC3_0 field.
	USB0_PORTSC1_H_PTC3_0_Msk = 0xf0000
	// TEST_MODE_DISABLE
	USB0_PORTSC1_H_PTC3_0_TEST_MODE_DISABLE = 0x0
	// J_STATE
	USB0_PORTSC1_H_PTC3_0_J_STATE = 0x1
	// K_STATE
	USB0_PORTSC1_H_PTC3_0_K_STATE = 0x2
	// SE0 (host)/NAK (device)
	USB0_PORTSC1_H_PTC3_0_SE0_NAK = 0x3
	// Packet
	USB0_PORTSC1_H_PTC3_0_PACKET = 0x4
	// FORCE_ENABLE_HS
	USB0_PORTSC1_H_PTC3_0_FORCE_ENABLE_HS = 0x5
	// FORCE_ENABLE_FS
	USB0_PORTSC1_H_PTC3_0_FORCE_ENABLE_FS = 0x6
	// FORCE_ENABLE_LS
	USB0_PORTSC1_H_PTC3_0_FORCE_ENABLE_LS = 0x7
	// Position of WKCN field.
	USB0_PORTSC1_H_WKCN_Pos = 0x14
	// Bit mask of WKCN field.
	USB0_PORTSC1_H_WKCN_Msk = 0x100000
	// Bit WKCN.
	USB0_PORTSC1_H_WKCN = 0x100000
	// Disables the port to wake up on device connects.
	USB0_PORTSC1_H_WKCN_DISABLES_THE_PORT_TO = 0x0
	// Writing this bit to a one enables the port to be sensitive to device connects as wake-up events.
	USB0_PORTSC1_H_WKCN_WRITING_THIS_BIT_TO_ = 0x1
	// Position of WKDC field.
	USB0_PORTSC1_H_WKDC_Pos = 0x15
	// Bit mask of WKDC field.
	USB0_PORTSC1_H_WKDC_Msk = 0x200000
	// Bit WKDC.
	USB0_PORTSC1_H_WKDC = 0x200000
	// Disables the port to wake up on device disconnects.
	USB0_PORTSC1_H_WKDC_DISABLES_THE_PORT_TO = 0x0
	// Writing this bit to a one enables the port to be sensitive to device disconnects as wake-up events.
	USB0_PORTSC1_H_WKDC_WRITING_THIS_BIT_TO_ = 0x1
	// Position of WKOC field.
	USB0_PORTSC1_H_WKOC_Pos = 0x16
	// Bit mask of WKOC field.
	USB0_PORTSC1_H_WKOC_Msk = 0x400000
	// Bit WKOC.
	USB0_PORTSC1_H_WKOC = 0x400000
	// Disables the port to wake up on over-current events.
	USB0_PORTSC1_H_WKOC_DISABLES_THE_PORT_TO = 0x0
	// Writing a one to this bit enabled the port to be sensitive to over-current conditions as wake-up events.
	USB0_PORTSC1_H_WKOC_WRITING_A_ONE_TO_THI = 0x1
	// Position of PHCD field.
	USB0_PORTSC1_H_PHCD_Pos = 0x17
	// Bit mask of PHCD field.
	USB0_PORTSC1_H_PHCD_Msk = 0x800000
	// Bit PHCD.
	USB0_PORTSC1_H_PHCD = 0x800000
	// Writing a 0 enables the PHY clock. Reading a 0 indicates the status of the PHY clock (enabled).
	USB0_PORTSC1_H_PHCD_WRITING_A_0_ENABLES_ = 0x0
	// Writing a 1 disables the PHY clock. Reading a 1 indicates the status of the PHY clock (disabled).
	USB0_PORTSC1_H_PHCD_WRITING_A_1_DISABLES = 0x1
	// Position of PFSC field.
	USB0_PORTSC1_H_PFSC_Pos = 0x18
	// Bit mask of PFSC field.
	USB0_PORTSC1_H_PFSC_Msk = 0x1000000
	// Bit PFSC.
	USB0_PORTSC1_H_PFSC = 0x1000000
	// Port connects at any speed.
	USB0_PORTSC1_H_PFSC_PORT_CONNECTS_AT_ANY = 0x0
	// Writing this bit to a 1 will force the port to only connect at Full Speed. It disables the chirp sequence that allows the port to identify itself as High Speed. This is useful for testing FS configurations with a HS host, hub or device.
	USB0_PORTSC1_H_PFSC_WRITING_THIS_BIT_TO_ = 0x1
	// Position of RESERVED field.
	USB0_PORTSC1_H_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	USB0_PORTSC1_H_RESERVED_Msk = 0x2000000
	// Bit RESERVED.
	USB0_PORTSC1_H_RESERVED = 0x2000000
	// Position of PSPD field.
	USB0_PORTSC1_H_PSPD_Pos = 0x1a
	// Bit mask of PSPD field.
	USB0_PORTSC1_H_PSPD_Msk = 0xc000000
	// Full-speed
	USB0_PORTSC1_H_PSPD_FULL_SPEED = 0x0
	// Low-speed
	USB0_PORTSC1_H_PSPD_LOW_SPEED = 0x1
	// High-speed
	USB0_PORTSC1_H_PSPD_HIGH_SPEED = 0x2

	// OTGSC: OTG status and control
	// Position of VD field.
	USB0_OTGSC_VD_Pos = 0x0
	// Bit mask of VD field.
	USB0_OTGSC_VD_Msk = 0x1
	// Bit VD.
	USB0_OTGSC_VD = 0x1
	// Position of VC field.
	USB0_OTGSC_VC_Pos = 0x1
	// Bit mask of VC field.
	USB0_OTGSC_VC_Msk = 0x2
	// Bit VC.
	USB0_OTGSC_VC = 0x2
	// Position of HAAR field.
	USB0_OTGSC_HAAR_Pos = 0x2
	// Bit mask of HAAR field.
	USB0_OTGSC_HAAR_Msk = 0x4
	// Bit HAAR.
	USB0_OTGSC_HAAR = 0x4
	// Disabled
	USB0_OTGSC_HAAR_DISABLED = 0x0
	// Enable automatic reset after connect on host port.
	USB0_OTGSC_HAAR_ENABLE_AUTOMATIC_RES = 0x1
	// Position of OT field.
	USB0_OTGSC_OT_Pos = 0x3
	// Bit mask of OT field.
	USB0_OTGSC_OT_Msk = 0x8
	// Bit OT.
	USB0_OTGSC_OT = 0x8
	// Position of DP field.
	USB0_OTGSC_DP_Pos = 0x4
	// Bit mask of DP field.
	USB0_OTGSC_DP_Msk = 0x10
	// Bit DP.
	USB0_OTGSC_DP = 0x10
	// Position of IDPU field.
	USB0_OTGSC_IDPU_Pos = 0x5
	// Bit mask of IDPU field.
	USB0_OTGSC_IDPU_Msk = 0x20
	// Bit IDPU.
	USB0_OTGSC_IDPU = 0x20
	// Pull-up off. The ID bit will not be sampled.
	USB0_OTGSC_IDPU_PULL_UP_OFF_THE_ID_ = 0x0
	// Pull-up on.
	USB0_OTGSC_IDPU_PULL_UP_ON_ = 0x1
	// Position of HADP field.
	USB0_OTGSC_HADP_Pos = 0x6
	// Bit mask of HADP field.
	USB0_OTGSC_HADP_Msk = 0x40
	// Bit HADP.
	USB0_OTGSC_HADP = 0x40
	// Position of HABA field.
	USB0_OTGSC_HABA_Pos = 0x7
	// Bit mask of HABA field.
	USB0_OTGSC_HABA_Msk = 0x80
	// Bit HABA.
	USB0_OTGSC_HABA = 0x80
	// Disabled.
	USB0_OTGSC_HABA_DISABLED_ = 0x0
	// Enable automatic B-disconnect to A-connect sequence.
	USB0_OTGSC_HABA_ENABLE_AUTOMATIC_B_D = 0x1
	// Position of ID field.
	USB0_OTGSC_ID_Pos = 0x8
	// Bit mask of ID field.
	USB0_OTGSC_ID_Msk = 0x100
	// Bit ID.
	USB0_OTGSC_ID = 0x100
	// A-device
	USB0_OTGSC_ID_A_DEVICE = 0x0
	// B-device
	USB0_OTGSC_ID_B_DEVICE = 0x1
	// Position of AVV field.
	USB0_OTGSC_AVV_Pos = 0x9
	// Bit mask of AVV field.
	USB0_OTGSC_AVV_Msk = 0x200
	// Bit AVV.
	USB0_OTGSC_AVV = 0x200
	// Position of ASV field.
	USB0_OTGSC_ASV_Pos = 0xa
	// Bit mask of ASV field.
	USB0_OTGSC_ASV_Msk = 0x400
	// Bit ASV.
	USB0_OTGSC_ASV = 0x400
	// Position of BSV field.
	USB0_OTGSC_BSV_Pos = 0xb
	// Bit mask of BSV field.
	USB0_OTGSC_BSV_Msk = 0x800
	// Bit BSV.
	USB0_OTGSC_BSV = 0x800
	// Position of BSE field.
	USB0_OTGSC_BSE_Pos = 0xc
	// Bit mask of BSE field.
	USB0_OTGSC_BSE_Msk = 0x1000
	// Bit BSE.
	USB0_OTGSC_BSE = 0x1000
	// Position of MS1T field.
	USB0_OTGSC_MS1T_Pos = 0xd
	// Bit mask of MS1T field.
	USB0_OTGSC_MS1T_Msk = 0x2000
	// Bit MS1T.
	USB0_OTGSC_MS1T = 0x2000
	// Position of DPS field.
	USB0_OTGSC_DPS_Pos = 0xe
	// Bit mask of DPS field.
	USB0_OTGSC_DPS_Msk = 0x4000
	// Bit DPS.
	USB0_OTGSC_DPS = 0x4000
	// Position of RESERVED field.
	USB0_OTGSC_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USB0_OTGSC_RESERVED_Msk = 0x8000
	// Bit RESERVED.
	USB0_OTGSC_RESERVED = 0x8000
	// Position of IDIS field.
	USB0_OTGSC_IDIS_Pos = 0x10
	// Bit mask of IDIS field.
	USB0_OTGSC_IDIS_Msk = 0x10000
	// Bit IDIS.
	USB0_OTGSC_IDIS = 0x10000
	// Position of AVVIS field.
	USB0_OTGSC_AVVIS_Pos = 0x11
	// Bit mask of AVVIS field.
	USB0_OTGSC_AVVIS_Msk = 0x20000
	// Bit AVVIS.
	USB0_OTGSC_AVVIS = 0x20000
	// Position of ASVIS field.
	USB0_OTGSC_ASVIS_Pos = 0x12
	// Bit mask of ASVIS field.
	USB0_OTGSC_ASVIS_Msk = 0x40000
	// Bit ASVIS.
	USB0_OTGSC_ASVIS = 0x40000
	// Position of BSVIS field.
	USB0_OTGSC_BSVIS_Pos = 0x13
	// Bit mask of BSVIS field.
	USB0_OTGSC_BSVIS_Msk = 0x80000
	// Bit BSVIS.
	USB0_OTGSC_BSVIS = 0x80000
	// Position of BSEIS field.
	USB0_OTGSC_BSEIS_Pos = 0x14
	// Bit mask of BSEIS field.
	USB0_OTGSC_BSEIS_Msk = 0x100000
	// Bit BSEIS.
	USB0_OTGSC_BSEIS = 0x100000
	// Position of MS1S field.
	USB0_OTGSC_MS1S_Pos = 0x15
	// Bit mask of MS1S field.
	USB0_OTGSC_MS1S_Msk = 0x200000
	// Bit MS1S.
	USB0_OTGSC_MS1S = 0x200000
	// Position of DPIS field.
	USB0_OTGSC_DPIS_Pos = 0x16
	// Bit mask of DPIS field.
	USB0_OTGSC_DPIS_Msk = 0x400000
	// Bit DPIS.
	USB0_OTGSC_DPIS = 0x400000
	// Position of RESERVED field.
	USB0_OTGSC_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	USB0_OTGSC_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	USB0_OTGSC_RESERVED = 0x800000
	// Position of IDIE field.
	USB0_OTGSC_IDIE_Pos = 0x18
	// Bit mask of IDIE field.
	USB0_OTGSC_IDIE_Msk = 0x1000000
	// Bit IDIE.
	USB0_OTGSC_IDIE = 0x1000000
	// Position of AVVIE field.
	USB0_OTGSC_AVVIE_Pos = 0x19
	// Bit mask of AVVIE field.
	USB0_OTGSC_AVVIE_Msk = 0x2000000
	// Bit AVVIE.
	USB0_OTGSC_AVVIE = 0x2000000
	// Position of ASVIE field.
	USB0_OTGSC_ASVIE_Pos = 0x1a
	// Bit mask of ASVIE field.
	USB0_OTGSC_ASVIE_Msk = 0x4000000
	// Bit ASVIE.
	USB0_OTGSC_ASVIE = 0x4000000
	// Position of BSVIE field.
	USB0_OTGSC_BSVIE_Pos = 0x1b
	// Bit mask of BSVIE field.
	USB0_OTGSC_BSVIE_Msk = 0x8000000
	// Bit BSVIE.
	USB0_OTGSC_BSVIE = 0x8000000
	// Position of BSEIE field.
	USB0_OTGSC_BSEIE_Pos = 0x1c
	// Bit mask of BSEIE field.
	USB0_OTGSC_BSEIE_Msk = 0x10000000
	// Bit BSEIE.
	USB0_OTGSC_BSEIE = 0x10000000
	// Position of MS1E field.
	USB0_OTGSC_MS1E_Pos = 0x1d
	// Bit mask of MS1E field.
	USB0_OTGSC_MS1E_Msk = 0x20000000
	// Bit MS1E.
	USB0_OTGSC_MS1E = 0x20000000
	// Position of DPIE field.
	USB0_OTGSC_DPIE_Pos = 0x1e
	// Bit mask of DPIE field.
	USB0_OTGSC_DPIE_Msk = 0x40000000
	// Bit DPIE.
	USB0_OTGSC_DPIE = 0x40000000
	// Position of RESERVED field.
	USB0_OTGSC_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	USB0_OTGSC_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	USB0_OTGSC_RESERVED = 0x80000000

	// USBMODE_D: USB device mode (device mode)
	// Position of CM1_0 field.
	USB0_USBMODE_D_CM1_0_Pos = 0x0
	// Bit mask of CM1_0 field.
	USB0_USBMODE_D_CM1_0_Msk = 0x3
	// Idle
	USB0_USBMODE_D_CM1_0_IDLE = 0x0
	// Device controller
	USB0_USBMODE_D_CM1_0_DEVICE_CONTROLLER = 0x2
	// Host controller
	USB0_USBMODE_D_CM1_0_HOST_CONTROLLER = 0x3
	// Position of ES field.
	USB0_USBMODE_D_ES_Pos = 0x2
	// Bit mask of ES field.
	USB0_USBMODE_D_ES_Msk = 0x4
	// Bit ES.
	USB0_USBMODE_D_ES = 0x4
	// Little endian: first byte referenced in least significant byte of 32-bit word.
	USB0_USBMODE_D_ES_LITTLE_ENDIAN_FIRST = 0x0
	// Big endian: first byte referenced in most significant byte of 32-bit word.
	USB0_USBMODE_D_ES_BIG_ENDIAN_FIRST_BY = 0x1
	// Position of SLOM field.
	USB0_USBMODE_D_SLOM_Pos = 0x3
	// Bit mask of SLOM field.
	USB0_USBMODE_D_SLOM_Msk = 0x8
	// Bit SLOM.
	USB0_USBMODE_D_SLOM = 0x8
	// Setup Lockouts on
	USB0_USBMODE_D_SLOM_SETUP_LOCKOUTS_ON = 0x0
	// Setup Lockouts Off (DCD requires the use of Setup Buffer Tripwire in USBCMD)
	USB0_USBMODE_D_SLOM_SETUP_LOCKOUTS_OFF = 0x1
	// Position of SDIS field.
	USB0_USBMODE_D_SDIS_Pos = 0x4
	// Bit mask of SDIS field.
	USB0_USBMODE_D_SDIS_Msk = 0x10
	// Bit SDIS.
	USB0_USBMODE_D_SDIS = 0x10
	// Not disabled
	USB0_USBMODE_D_SDIS_NOT_DISABLED = 0x0
	// Disabled. Setting this bit to one disables double priming on both RX and TX for low bandwidth systems. This mode ensures that when the RX and TX buffers are sufficient to contain an entire packet that the standard double buffering scheme is disabled to prevent overruns/underruns in bandwidth limited systems. Note: In High Speed Mode, all packets received will be responded to with a NYET handshake when stream disable is active.
	USB0_USBMODE_D_SDIS_DISABLED_SETTING_TH = 0x1
	// Position of RESERVED field.
	USB0_USBMODE_D_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB0_USBMODE_D_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USB0_USBMODE_D_RESERVED = 0x20
	// Position of RESERVED field.
	USB0_USBMODE_D_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_USBMODE_D_RESERVED_Msk = 0xffffffc0

	// USBMODE_H: USB mode (host mode)
	// Position of CM field.
	USB0_USBMODE_H_CM_Pos = 0x0
	// Bit mask of CM field.
	USB0_USBMODE_H_CM_Msk = 0x3
	// Idle
	USB0_USBMODE_H_CM_IDLE = 0x0
	// Device controller
	USB0_USBMODE_H_CM_DEVICE_CONTROLLER = 0x2
	// Host controller
	USB0_USBMODE_H_CM_HOST_CONTROLLER = 0x3
	// Position of ES field.
	USB0_USBMODE_H_ES_Pos = 0x2
	// Bit mask of ES field.
	USB0_USBMODE_H_ES_Msk = 0x4
	// Bit ES.
	USB0_USBMODE_H_ES = 0x4
	// Little endian: first byte referenced in least significant byte of 32-bit word.
	USB0_USBMODE_H_ES_LITTLE_ENDIAN_FIRST = 0x0
	// Big endian: first byte referenced in most significant byte of 32-bit word.
	USB0_USBMODE_H_ES_BIG_ENDIAN_FIRST_BY = 0x1
	// Position of RESERVED field.
	USB0_USBMODE_H_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USB0_USBMODE_H_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USB0_USBMODE_H_RESERVED = 0x8
	// Position of SDIS field.
	USB0_USBMODE_H_SDIS_Pos = 0x4
	// Bit mask of SDIS field.
	USB0_USBMODE_H_SDIS_Msk = 0x10
	// Bit SDIS.
	USB0_USBMODE_H_SDIS = 0x10
	// Not disabled
	USB0_USBMODE_H_SDIS_NOT_DISABLED = 0x0
	// Disabled. Setting to a 1 ensures that overruns/underruns of the latency FIFO are eliminated for low bandwidth systems where the RX and TX buffers are sufficient to contain the entire packet. Enabling stream disable also has the effect of ensuring the the TX latency is filled to capacity before the packet is launched onto the USB. Note: Time duration to pre-fill the FIFO becomes significant when stream disable is active. See TXFILLTUNING to characterize the adjustments needed for the scheduler when using this feature.
	USB0_USBMODE_H_SDIS_DISABLED_SETTING_TO = 0x1
	// Position of VBPS field.
	USB0_USBMODE_H_VBPS_Pos = 0x5
	// Bit mask of VBPS field.
	USB0_USBMODE_H_VBPS_Msk = 0x20
	// Bit VBPS.
	USB0_USBMODE_H_VBPS = 0x20
	// vbus_pwr_select is set LOW.
	USB0_USBMODE_H_VBPS_LOW = 0x0
	// vbus_pwr_select is set HIGH
	USB0_USBMODE_H_VBPS_HIGH = 0x1
	// Position of RESERVED field.
	USB0_USBMODE_H_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_USBMODE_H_RESERVED_Msk = 0xffffffc0

	// ENDPTSETUPSTAT: Endpoint setup status
	// Position of ENDPTSETUPSTAT0 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Pos = 0x0
	// Bit mask of ENDPTSETUPSTAT0 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Msk = 0x1
	// Bit ENDPTSETUPSTAT0.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT0 = 0x1
	// Position of ENDPTSETUPSTAT1 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Pos = 0x1
	// Bit mask of ENDPTSETUPSTAT1 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Msk = 0x2
	// Bit ENDPTSETUPSTAT1.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT1 = 0x2
	// Position of ENDPTSETUPSTAT2 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Pos = 0x2
	// Bit mask of ENDPTSETUPSTAT2 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Msk = 0x4
	// Bit ENDPTSETUPSTAT2.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT2 = 0x4
	// Position of ENDPTSETUPSTAT3 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Pos = 0x3
	// Bit mask of ENDPTSETUPSTAT3 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Msk = 0x8
	// Bit ENDPTSETUPSTAT3.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT3 = 0x8
	// Position of ENDPTSETUPSTAT4 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT4_Pos = 0x4
	// Bit mask of ENDPTSETUPSTAT4 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT4_Msk = 0x10
	// Bit ENDPTSETUPSTAT4.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT4 = 0x10
	// Position of ENDPTSETUPSTAT5 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT5_Pos = 0x5
	// Bit mask of ENDPTSETUPSTAT5 field.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT5_Msk = 0x20
	// Bit ENDPTSETUPSTAT5.
	USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT5 = 0x20
	// Position of RESERVED field.
	USB0_ENDPTSETUPSTAT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_ENDPTSETUPSTAT_RESERVED_Msk = 0xffffffc0

	// ENDPTPRIME: Endpoint initialization
	// Position of PERB0 field.
	USB0_ENDPTPRIME_PERB0_Pos = 0x0
	// Bit mask of PERB0 field.
	USB0_ENDPTPRIME_PERB0_Msk = 0x1
	// Bit PERB0.
	USB0_ENDPTPRIME_PERB0 = 0x1
	// Position of PERB1 field.
	USB0_ENDPTPRIME_PERB1_Pos = 0x1
	// Bit mask of PERB1 field.
	USB0_ENDPTPRIME_PERB1_Msk = 0x2
	// Bit PERB1.
	USB0_ENDPTPRIME_PERB1 = 0x2
	// Position of PERB2 field.
	USB0_ENDPTPRIME_PERB2_Pos = 0x2
	// Bit mask of PERB2 field.
	USB0_ENDPTPRIME_PERB2_Msk = 0x4
	// Bit PERB2.
	USB0_ENDPTPRIME_PERB2 = 0x4
	// Position of PERB3 field.
	USB0_ENDPTPRIME_PERB3_Pos = 0x3
	// Bit mask of PERB3 field.
	USB0_ENDPTPRIME_PERB3_Msk = 0x8
	// Bit PERB3.
	USB0_ENDPTPRIME_PERB3 = 0x8
	// Position of PERB4 field.
	USB0_ENDPTPRIME_PERB4_Pos = 0x4
	// Bit mask of PERB4 field.
	USB0_ENDPTPRIME_PERB4_Msk = 0x10
	// Bit PERB4.
	USB0_ENDPTPRIME_PERB4 = 0x10
	// Position of PERB5 field.
	USB0_ENDPTPRIME_PERB5_Pos = 0x5
	// Bit mask of PERB5 field.
	USB0_ENDPTPRIME_PERB5_Msk = 0x20
	// Bit PERB5.
	USB0_ENDPTPRIME_PERB5 = 0x20
	// Position of RESERVED field.
	USB0_ENDPTPRIME_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_ENDPTPRIME_RESERVED_Msk = 0xffc0
	// Position of PETB0 field.
	USB0_ENDPTPRIME_PETB0_Pos = 0x10
	// Bit mask of PETB0 field.
	USB0_ENDPTPRIME_PETB0_Msk = 0x10000
	// Bit PETB0.
	USB0_ENDPTPRIME_PETB0 = 0x10000
	// Position of PETB1 field.
	USB0_ENDPTPRIME_PETB1_Pos = 0x11
	// Bit mask of PETB1 field.
	USB0_ENDPTPRIME_PETB1_Msk = 0x20000
	// Bit PETB1.
	USB0_ENDPTPRIME_PETB1 = 0x20000
	// Position of PETB2 field.
	USB0_ENDPTPRIME_PETB2_Pos = 0x12
	// Bit mask of PETB2 field.
	USB0_ENDPTPRIME_PETB2_Msk = 0x40000
	// Bit PETB2.
	USB0_ENDPTPRIME_PETB2 = 0x40000
	// Position of PETB3 field.
	USB0_ENDPTPRIME_PETB3_Pos = 0x13
	// Bit mask of PETB3 field.
	USB0_ENDPTPRIME_PETB3_Msk = 0x80000
	// Bit PETB3.
	USB0_ENDPTPRIME_PETB3 = 0x80000
	// Position of PETB4 field.
	USB0_ENDPTPRIME_PETB4_Pos = 0x14
	// Bit mask of PETB4 field.
	USB0_ENDPTPRIME_PETB4_Msk = 0x100000
	// Bit PETB4.
	USB0_ENDPTPRIME_PETB4 = 0x100000
	// Position of PETB5 field.
	USB0_ENDPTPRIME_PETB5_Pos = 0x15
	// Bit mask of PETB5 field.
	USB0_ENDPTPRIME_PETB5_Msk = 0x200000
	// Bit PETB5.
	USB0_ENDPTPRIME_PETB5 = 0x200000
	// Position of RESERVED field.
	USB0_ENDPTPRIME_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	USB0_ENDPTPRIME_RESERVED_Msk = 0xffc00000

	// ENDPTFLUSH: Endpoint de-initialization
	// Position of FERB0 field.
	USB0_ENDPTFLUSH_FERB0_Pos = 0x0
	// Bit mask of FERB0 field.
	USB0_ENDPTFLUSH_FERB0_Msk = 0x1
	// Bit FERB0.
	USB0_ENDPTFLUSH_FERB0 = 0x1
	// Position of FERB1 field.
	USB0_ENDPTFLUSH_FERB1_Pos = 0x1
	// Bit mask of FERB1 field.
	USB0_ENDPTFLUSH_FERB1_Msk = 0x2
	// Bit FERB1.
	USB0_ENDPTFLUSH_FERB1 = 0x2
	// Position of FERB2 field.
	USB0_ENDPTFLUSH_FERB2_Pos = 0x2
	// Bit mask of FERB2 field.
	USB0_ENDPTFLUSH_FERB2_Msk = 0x4
	// Bit FERB2.
	USB0_ENDPTFLUSH_FERB2 = 0x4
	// Position of FERB3 field.
	USB0_ENDPTFLUSH_FERB3_Pos = 0x3
	// Bit mask of FERB3 field.
	USB0_ENDPTFLUSH_FERB3_Msk = 0x8
	// Bit FERB3.
	USB0_ENDPTFLUSH_FERB3 = 0x8
	// Position of FERB4 field.
	USB0_ENDPTFLUSH_FERB4_Pos = 0x4
	// Bit mask of FERB4 field.
	USB0_ENDPTFLUSH_FERB4_Msk = 0x10
	// Bit FERB4.
	USB0_ENDPTFLUSH_FERB4 = 0x10
	// Position of FERB5 field.
	USB0_ENDPTFLUSH_FERB5_Pos = 0x5
	// Bit mask of FERB5 field.
	USB0_ENDPTFLUSH_FERB5_Msk = 0x20
	// Bit FERB5.
	USB0_ENDPTFLUSH_FERB5 = 0x20
	// Position of RESERVED field.
	USB0_ENDPTFLUSH_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_ENDPTFLUSH_RESERVED_Msk = 0xffc0
	// Position of FETB0 field.
	USB0_ENDPTFLUSH_FETB0_Pos = 0x10
	// Bit mask of FETB0 field.
	USB0_ENDPTFLUSH_FETB0_Msk = 0x10000
	// Bit FETB0.
	USB0_ENDPTFLUSH_FETB0 = 0x10000
	// Position of FETB1 field.
	USB0_ENDPTFLUSH_FETB1_Pos = 0x11
	// Bit mask of FETB1 field.
	USB0_ENDPTFLUSH_FETB1_Msk = 0x20000
	// Bit FETB1.
	USB0_ENDPTFLUSH_FETB1 = 0x20000
	// Position of FETB2 field.
	USB0_ENDPTFLUSH_FETB2_Pos = 0x12
	// Bit mask of FETB2 field.
	USB0_ENDPTFLUSH_FETB2_Msk = 0x40000
	// Bit FETB2.
	USB0_ENDPTFLUSH_FETB2 = 0x40000
	// Position of FETB3 field.
	USB0_ENDPTFLUSH_FETB3_Pos = 0x13
	// Bit mask of FETB3 field.
	USB0_ENDPTFLUSH_FETB3_Msk = 0x80000
	// Bit FETB3.
	USB0_ENDPTFLUSH_FETB3 = 0x80000
	// Position of FETB4 field.
	USB0_ENDPTFLUSH_FETB4_Pos = 0x14
	// Bit mask of FETB4 field.
	USB0_ENDPTFLUSH_FETB4_Msk = 0x100000
	// Bit FETB4.
	USB0_ENDPTFLUSH_FETB4 = 0x100000
	// Position of FETB5 field.
	USB0_ENDPTFLUSH_FETB5_Pos = 0x15
	// Bit mask of FETB5 field.
	USB0_ENDPTFLUSH_FETB5_Msk = 0x200000
	// Bit FETB5.
	USB0_ENDPTFLUSH_FETB5 = 0x200000
	// Position of RESERVED field.
	USB0_ENDPTFLUSH_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	USB0_ENDPTFLUSH_RESERVED_Msk = 0xffc00000

	// ENDPTSTAT: Endpoint status
	// Position of ERBR0 field.
	USB0_ENDPTSTAT_ERBR0_Pos = 0x0
	// Bit mask of ERBR0 field.
	USB0_ENDPTSTAT_ERBR0_Msk = 0x1
	// Bit ERBR0.
	USB0_ENDPTSTAT_ERBR0 = 0x1
	// Position of ERBR1 field.
	USB0_ENDPTSTAT_ERBR1_Pos = 0x1
	// Bit mask of ERBR1 field.
	USB0_ENDPTSTAT_ERBR1_Msk = 0x2
	// Bit ERBR1.
	USB0_ENDPTSTAT_ERBR1 = 0x2
	// Position of ERBR2 field.
	USB0_ENDPTSTAT_ERBR2_Pos = 0x2
	// Bit mask of ERBR2 field.
	USB0_ENDPTSTAT_ERBR2_Msk = 0x4
	// Bit ERBR2.
	USB0_ENDPTSTAT_ERBR2 = 0x4
	// Position of ERBR3 field.
	USB0_ENDPTSTAT_ERBR3_Pos = 0x3
	// Bit mask of ERBR3 field.
	USB0_ENDPTSTAT_ERBR3_Msk = 0x8
	// Bit ERBR3.
	USB0_ENDPTSTAT_ERBR3 = 0x8
	// Position of ERBR4 field.
	USB0_ENDPTSTAT_ERBR4_Pos = 0x4
	// Bit mask of ERBR4 field.
	USB0_ENDPTSTAT_ERBR4_Msk = 0x10
	// Bit ERBR4.
	USB0_ENDPTSTAT_ERBR4 = 0x10
	// Position of ERBR5 field.
	USB0_ENDPTSTAT_ERBR5_Pos = 0x5
	// Bit mask of ERBR5 field.
	USB0_ENDPTSTAT_ERBR5_Msk = 0x20
	// Bit ERBR5.
	USB0_ENDPTSTAT_ERBR5 = 0x20
	// Position of RESERVED field.
	USB0_ENDPTSTAT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_ENDPTSTAT_RESERVED_Msk = 0xffc0
	// Position of ETBR0 field.
	USB0_ENDPTSTAT_ETBR0_Pos = 0x10
	// Bit mask of ETBR0 field.
	USB0_ENDPTSTAT_ETBR0_Msk = 0x10000
	// Bit ETBR0.
	USB0_ENDPTSTAT_ETBR0 = 0x10000
	// Position of ETBR1 field.
	USB0_ENDPTSTAT_ETBR1_Pos = 0x11
	// Bit mask of ETBR1 field.
	USB0_ENDPTSTAT_ETBR1_Msk = 0x20000
	// Bit ETBR1.
	USB0_ENDPTSTAT_ETBR1 = 0x20000
	// Position of ETBR2 field.
	USB0_ENDPTSTAT_ETBR2_Pos = 0x12
	// Bit mask of ETBR2 field.
	USB0_ENDPTSTAT_ETBR2_Msk = 0x40000
	// Bit ETBR2.
	USB0_ENDPTSTAT_ETBR2 = 0x40000
	// Position of ETBR3 field.
	USB0_ENDPTSTAT_ETBR3_Pos = 0x13
	// Bit mask of ETBR3 field.
	USB0_ENDPTSTAT_ETBR3_Msk = 0x80000
	// Bit ETBR3.
	USB0_ENDPTSTAT_ETBR3 = 0x80000
	// Position of ETBR4 field.
	USB0_ENDPTSTAT_ETBR4_Pos = 0x14
	// Bit mask of ETBR4 field.
	USB0_ENDPTSTAT_ETBR4_Msk = 0x100000
	// Bit ETBR4.
	USB0_ENDPTSTAT_ETBR4 = 0x100000
	// Position of ETBR5 field.
	USB0_ENDPTSTAT_ETBR5_Pos = 0x15
	// Bit mask of ETBR5 field.
	USB0_ENDPTSTAT_ETBR5_Msk = 0x200000
	// Bit ETBR5.
	USB0_ENDPTSTAT_ETBR5 = 0x200000
	// Position of RESERVED field.
	USB0_ENDPTSTAT_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	USB0_ENDPTSTAT_RESERVED_Msk = 0xffc00000

	// ENDPTCOMPLETE: Endpoint complete
	// Position of ERCE0 field.
	USB0_ENDPTCOMPLETE_ERCE0_Pos = 0x0
	// Bit mask of ERCE0 field.
	USB0_ENDPTCOMPLETE_ERCE0_Msk = 0x1
	// Bit ERCE0.
	USB0_ENDPTCOMPLETE_ERCE0 = 0x1
	// Position of ERCE1 field.
	USB0_ENDPTCOMPLETE_ERCE1_Pos = 0x1
	// Bit mask of ERCE1 field.
	USB0_ENDPTCOMPLETE_ERCE1_Msk = 0x2
	// Bit ERCE1.
	USB0_ENDPTCOMPLETE_ERCE1 = 0x2
	// Position of ERCE2 field.
	USB0_ENDPTCOMPLETE_ERCE2_Pos = 0x2
	// Bit mask of ERCE2 field.
	USB0_ENDPTCOMPLETE_ERCE2_Msk = 0x4
	// Bit ERCE2.
	USB0_ENDPTCOMPLETE_ERCE2 = 0x4
	// Position of ERCE3 field.
	USB0_ENDPTCOMPLETE_ERCE3_Pos = 0x3
	// Bit mask of ERCE3 field.
	USB0_ENDPTCOMPLETE_ERCE3_Msk = 0x8
	// Bit ERCE3.
	USB0_ENDPTCOMPLETE_ERCE3 = 0x8
	// Position of ERCE4 field.
	USB0_ENDPTCOMPLETE_ERCE4_Pos = 0x4
	// Bit mask of ERCE4 field.
	USB0_ENDPTCOMPLETE_ERCE4_Msk = 0x10
	// Bit ERCE4.
	USB0_ENDPTCOMPLETE_ERCE4 = 0x10
	// Position of ERCE5 field.
	USB0_ENDPTCOMPLETE_ERCE5_Pos = 0x5
	// Bit mask of ERCE5 field.
	USB0_ENDPTCOMPLETE_ERCE5_Msk = 0x20
	// Bit ERCE5.
	USB0_ENDPTCOMPLETE_ERCE5 = 0x20
	// Position of RESERVED field.
	USB0_ENDPTCOMPLETE_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB0_ENDPTCOMPLETE_RESERVED_Msk = 0xffc0
	// Position of ETCE0 field.
	USB0_ENDPTCOMPLETE_ETCE0_Pos = 0x10
	// Bit mask of ETCE0 field.
	USB0_ENDPTCOMPLETE_ETCE0_Msk = 0x10000
	// Bit ETCE0.
	USB0_ENDPTCOMPLETE_ETCE0 = 0x10000
	// Position of ETCE1 field.
	USB0_ENDPTCOMPLETE_ETCE1_Pos = 0x11
	// Bit mask of ETCE1 field.
	USB0_ENDPTCOMPLETE_ETCE1_Msk = 0x20000
	// Bit ETCE1.
	USB0_ENDPTCOMPLETE_ETCE1 = 0x20000
	// Position of ETCE2 field.
	USB0_ENDPTCOMPLETE_ETCE2_Pos = 0x12
	// Bit mask of ETCE2 field.
	USB0_ENDPTCOMPLETE_ETCE2_Msk = 0x40000
	// Bit ETCE2.
	USB0_ENDPTCOMPLETE_ETCE2 = 0x40000
	// Position of ETCE3 field.
	USB0_ENDPTCOMPLETE_ETCE3_Pos = 0x13
	// Bit mask of ETCE3 field.
	USB0_ENDPTCOMPLETE_ETCE3_Msk = 0x80000
	// Bit ETCE3.
	USB0_ENDPTCOMPLETE_ETCE3 = 0x80000
	// Position of ETCE4 field.
	USB0_ENDPTCOMPLETE_ETCE4_Pos = 0x14
	// Bit mask of ETCE4 field.
	USB0_ENDPTCOMPLETE_ETCE4_Msk = 0x100000
	// Bit ETCE4.
	USB0_ENDPTCOMPLETE_ETCE4 = 0x100000
	// Position of ETCE5 field.
	USB0_ENDPTCOMPLETE_ETCE5_Pos = 0x15
	// Bit mask of ETCE5 field.
	USB0_ENDPTCOMPLETE_ETCE5_Msk = 0x200000
	// Bit ETCE5.
	USB0_ENDPTCOMPLETE_ETCE5 = 0x200000
	// Position of RESERVED field.
	USB0_ENDPTCOMPLETE_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	USB0_ENDPTCOMPLETE_RESERVED_Msk = 0xffc00000

	// ENDPTCTRL0: Endpoint control 0
	// Position of RXS field.
	USB0_ENDPTCTRL0_RXS_Pos = 0x0
	// Bit mask of RXS field.
	USB0_ENDPTCTRL0_RXS_Msk = 0x1
	// Bit RXS.
	USB0_ENDPTCTRL0_RXS = 0x1
	// Endpoint ok.
	USB0_ENDPTCTRL0_RXS_ENDPOINT_OK_ = 0x0
	// Endpoint stalled Software can write a one to this bit to force the endpoint to return a STALL handshake to the Host. It will continue returning STALL until the bit is cleared by software, or it will automatically be cleared upon receipt of a new SETUP request. After receiving a SETUP request, this bit will continue to be cleared by hardware until the associated ENDSETUPSTAT bit is cleared.[1]
	USB0_ENDPTCTRL0_RXS_ENDPOINT_STALLED_SOF = 0x1
	// Position of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USB0_ENDPTCTRL0_RESERVED = 0x2
	// Position of RXT1_0 field.
	USB0_ENDPTCTRL0_RXT1_0_Pos = 0x2
	// Bit mask of RXT1_0 field.
	USB0_ENDPTCTRL0_RXT1_0_Msk = 0xc
	// Position of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Msk = 0x70
	// Position of RXE field.
	USB0_ENDPTCTRL0_RXE_Pos = 0x7
	// Bit mask of RXE field.
	USB0_ENDPTCTRL0_RXE_Msk = 0x80
	// Bit RXE.
	USB0_ENDPTCTRL0_RXE = 0x80
	// Position of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Msk = 0xff00
	// Position of TXS field.
	USB0_ENDPTCTRL0_TXS_Pos = 0x10
	// Bit mask of TXS field.
	USB0_ENDPTCTRL0_TXS_Msk = 0x10000
	// Bit TXS.
	USB0_ENDPTCTRL0_TXS = 0x10000
	// Endpoint ok.
	USB0_ENDPTCTRL0_TXS_ENDPOINT_OK_ = 0x0
	// Endpoint stalled Software can write a one to this bit to force the endpoint to return a STALL handshake to the Host. It will continue returning STALL until the bit is cleared by software, or it will automatically be cleared upon receipt of a new SETUP request. After receiving a SETUP request, this bit will continue to be cleared by hardware until the associated ENDSETUPSTAT bit is cleared.[1]
	USB0_ENDPTCTRL0_TXS_ENDPOINT_STALLED_SOF = 0x1
	// Position of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB0_ENDPTCTRL0_RESERVED = 0x20000
	// Position of TXT1_0 field.
	USB0_ENDPTCTRL0_TXT1_0_Pos = 0x12
	// Bit mask of TXT1_0 field.
	USB0_ENDPTCTRL0_TXT1_0_Msk = 0xc0000
	// Position of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Msk = 0x700000
	// Position of TXE field.
	USB0_ENDPTCTRL0_TXE_Pos = 0x17
	// Bit mask of TXE field.
	USB0_ENDPTCTRL0_TXE_Msk = 0x800000
	// Bit TXE.
	USB0_ENDPTCTRL0_TXE = 0x800000
	// Position of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL0_RESERVED_Msk = 0xff000000

	// ENDPTCTRL1: Endpoint control
	// Position of RXS field.
	USB0_ENDPTCTRL_RXS_Pos = 0x0
	// Bit mask of RXS field.
	USB0_ENDPTCTRL_RXS_Msk = 0x1
	// Bit RXS.
	USB0_ENDPTCTRL_RXS = 0x1
	// Endpoint ok. This bit will be cleared automatically upon receipt of a SETUP request if this Endpoint is configured as a Control Endpoint and this bit will continue to be cleared by hardware until the associated ENDPTSETUPSTAT bit is cleared.
	USB0_ENDPTCTRL_RXS_ENDPOINT_OK_THIS_BI = 0x0
	// Endpoint stalled Software can write a one to this bit to force the endpoint to return a STALL handshake to the Host. It will continue returning STALL until the bit is cleared by software, or it will automatically be cleared upon receipt of a new SETUP request.
	USB0_ENDPTCTRL_RXS_ENDPOINT_STALLED_SOF = 0x1
	// Position of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USB0_ENDPTCTRL_RESERVED = 0x2
	// Position of RXT field.
	USB0_ENDPTCTRL_RXT_Pos = 0x2
	// Bit mask of RXT field.
	USB0_ENDPTCTRL_RXT_Msk = 0xc
	// Control
	USB0_ENDPTCTRL_RXT_CONTROL = 0x0
	// Isochronous
	USB0_ENDPTCTRL_RXT_ISOCHRONOUS = 0x1
	// Bulk
	USB0_ENDPTCTRL_RXT_BULK = 0x2
	// Position of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB0_ENDPTCTRL_RESERVED = 0x10
	// Position of RXI field.
	USB0_ENDPTCTRL_RXI_Pos = 0x5
	// Bit mask of RXI field.
	USB0_ENDPTCTRL_RXI_Msk = 0x20
	// Bit RXI.
	USB0_ENDPTCTRL_RXI = 0x20
	// Disabled
	USB0_ENDPTCTRL_RXI_DISABLED = 0x0
	// Enabled
	USB0_ENDPTCTRL_RXI_ENABLED = 0x1
	// Position of RXR field.
	USB0_ENDPTCTRL_RXR_Pos = 0x6
	// Bit mask of RXR field.
	USB0_ENDPTCTRL_RXR_Msk = 0x40
	// Bit RXR.
	USB0_ENDPTCTRL_RXR = 0x40
	// Position of RXE field.
	USB0_ENDPTCTRL_RXE_Pos = 0x7
	// Bit mask of RXE field.
	USB0_ENDPTCTRL_RXE_Msk = 0x80
	// Bit RXE.
	USB0_ENDPTCTRL_RXE = 0x80
	// Endpoint disabled.
	USB0_ENDPTCTRL_RXE_ENDPOINT_DISABLED_ = 0x0
	// Endpoint enabled.
	USB0_ENDPTCTRL_RXE_ENDPOINT_ENABLED_ = 0x1
	// Position of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Msk = 0xff00
	// Position of TXS field.
	USB0_ENDPTCTRL_TXS_Pos = 0x10
	// Bit mask of TXS field.
	USB0_ENDPTCTRL_TXS_Msk = 0x10000
	// Bit TXS.
	USB0_ENDPTCTRL_TXS = 0x10000
	// Endpoint ok. This bit will be cleared automatically upon receipt of a SETUP request if this Endpoint is configured as a Control Endpoint, and this bit will continue to be cleared by hardware until the associated ENDPTSETUPSTAT bit is cleared.
	USB0_ENDPTCTRL_TXS_ENDPOINT_OK_THIS_BI = 0x0
	// Endpoint stalled Software can write a one to this bit to force the endpoint to return a STALL handshake to the Host. It will continue returning STALL until the bit is cleared by software, or it will automatically be cleared upon receipt of a new SETUP request.
	USB0_ENDPTCTRL_TXS_ENDPOINT_STALLED_SOF = 0x1
	// Position of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB0_ENDPTCTRL_RESERVED = 0x20000
	// Position of TXT1_0 field.
	USB0_ENDPTCTRL_TXT1_0_Pos = 0x12
	// Bit mask of TXT1_0 field.
	USB0_ENDPTCTRL_TXT1_0_Msk = 0xc0000
	// Control
	USB0_ENDPTCTRL_TXT1_0_CONTROL = 0x0
	// Isochronous
	USB0_ENDPTCTRL_TXT1_0_ISOCHRONOUS = 0x1
	// Bulk
	USB0_ENDPTCTRL_TXT1_0_BULK = 0x2
	// Interrupt
	USB0_ENDPTCTRL_TXT1_0_INTERRUPT = 0x3
	// Position of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Msk = 0x100000
	// Bit RESERVED.
	USB0_ENDPTCTRL_RESERVED = 0x100000
	// Position of TXI field.
	USB0_ENDPTCTRL_TXI_Pos = 0x15
	// Bit mask of TXI field.
	USB0_ENDPTCTRL_TXI_Msk = 0x200000
	// Bit TXI.
	USB0_ENDPTCTRL_TXI = 0x200000
	// Enabled
	USB0_ENDPTCTRL_TXI_ENABLED = 0x0
	// Disabled
	USB0_ENDPTCTRL_TXI_DISABLED = 0x1
	// Position of TXR field.
	USB0_ENDPTCTRL_TXR_Pos = 0x16
	// Bit mask of TXR field.
	USB0_ENDPTCTRL_TXR_Msk = 0x400000
	// Bit TXR.
	USB0_ENDPTCTRL_TXR = 0x400000
	// Position of TXE field.
	USB0_ENDPTCTRL_TXE_Pos = 0x17
	// Bit mask of TXE field.
	USB0_ENDPTCTRL_TXE_Msk = 0x800000
	// Bit TXE.
	USB0_ENDPTCTRL_TXE = 0x800000
	// Endpoint disabled.
	USB0_ENDPTCTRL_TXE_ENDPOINT_DISABLED_ = 0x0
	// Endpoint enabled.
	USB0_ENDPTCTRL_TXE_ENDPOINT_ENABLED_ = 0x1
	// Position of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB0_ENDPTCTRL_RESERVED_Msk = 0xff000000
)

// Bitfields for USB1: USB1 Host/Device controller
const (
	// CAPLENGTH: Capability register length
	// Position of CAPLENGTH field.
	USB1_CAPLENGTH_CAPLENGTH_Pos = 0x0
	// Bit mask of CAPLENGTH field.
	USB1_CAPLENGTH_CAPLENGTH_Msk = 0xff
	// Position of HCIVERSION field.
	USB1_CAPLENGTH_HCIVERSION_Pos = 0x8
	// Bit mask of HCIVERSION field.
	USB1_CAPLENGTH_HCIVERSION_Msk = 0xffff00
	// Position of RESERVED field.
	USB1_CAPLENGTH_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB1_CAPLENGTH_RESERVED_Msk = 0xff000000

	// HCSPARAMS: Host controller structural parameters
	// Position of N_PORTS field.
	USB1_HCSPARAMS_N_PORTS_Pos = 0x0
	// Bit mask of N_PORTS field.
	USB1_HCSPARAMS_N_PORTS_Msk = 0xf
	// Position of PPC field.
	USB1_HCSPARAMS_PPC_Pos = 0x4
	// Bit mask of PPC field.
	USB1_HCSPARAMS_PPC_Msk = 0x10
	// Bit PPC.
	USB1_HCSPARAMS_PPC = 0x10
	// Position of RESERVED field.
	USB1_HCSPARAMS_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB1_HCSPARAMS_RESERVED_Msk = 0xe0
	// Position of N_PCC field.
	USB1_HCSPARAMS_N_PCC_Pos = 0x8
	// Bit mask of N_PCC field.
	USB1_HCSPARAMS_N_PCC_Msk = 0xf00
	// Position of N_CC field.
	USB1_HCSPARAMS_N_CC_Pos = 0xc
	// Bit mask of N_CC field.
	USB1_HCSPARAMS_N_CC_Msk = 0xf000
	// Position of PI field.
	USB1_HCSPARAMS_PI_Pos = 0x10
	// Bit mask of PI field.
	USB1_HCSPARAMS_PI_Msk = 0x10000
	// Bit PI.
	USB1_HCSPARAMS_PI = 0x10000
	// Position of RESERVED field.
	USB1_HCSPARAMS_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB1_HCSPARAMS_RESERVED_Msk = 0xe0000
	// Position of N_PTT field.
	USB1_HCSPARAMS_N_PTT_Pos = 0x14
	// Bit mask of N_PTT field.
	USB1_HCSPARAMS_N_PTT_Msk = 0xf00000
	// Position of N_TT field.
	USB1_HCSPARAMS_N_TT_Pos = 0x18
	// Bit mask of N_TT field.
	USB1_HCSPARAMS_N_TT_Msk = 0xf000000
	// Position of RESERVED field.
	USB1_HCSPARAMS_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	USB1_HCSPARAMS_RESERVED_Msk = 0xf0000000

	// HCCPARAMS: Host controller capability parameters
	// Position of ADC field.
	USB1_HCCPARAMS_ADC_Pos = 0x0
	// Bit mask of ADC field.
	USB1_HCCPARAMS_ADC_Msk = 0x1
	// Bit ADC.
	USB1_HCCPARAMS_ADC = 0x1
	// Position of PFL field.
	USB1_HCCPARAMS_PFL_Pos = 0x1
	// Bit mask of PFL field.
	USB1_HCCPARAMS_PFL_Msk = 0x2
	// Bit PFL.
	USB1_HCCPARAMS_PFL = 0x2
	// Position of ASP field.
	USB1_HCCPARAMS_ASP_Pos = 0x2
	// Bit mask of ASP field.
	USB1_HCCPARAMS_ASP_Msk = 0x4
	// Bit ASP.
	USB1_HCCPARAMS_ASP = 0x4
	// Position of IST field.
	USB1_HCCPARAMS_IST_Pos = 0x4
	// Bit mask of IST field.
	USB1_HCCPARAMS_IST_Msk = 0xf0
	// Position of EECP field.
	USB1_HCCPARAMS_EECP_Pos = 0x8
	// Bit mask of EECP field.
	USB1_HCCPARAMS_EECP_Msk = 0xff00
	// Position of RESERVED field.
	USB1_HCCPARAMS_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB1_HCCPARAMS_RESERVED_Msk = 0xffff0000

	// DCIVERSION: Device interface version number
	// Position of DCIVERSION field.
	USB1_DCIVERSION_DCIVERSION_Pos = 0x0
	// Bit mask of DCIVERSION field.
	USB1_DCIVERSION_DCIVERSION_Msk = 0xffff
	// Position of RESERVED field.
	USB1_DCIVERSION_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB1_DCIVERSION_RESERVED_Msk = 0xffff0000

	// USBCMD_D: USB command (device mode)
	// Position of RS field.
	USB1_USBCMD_D_RS_Pos = 0x0
	// Bit mask of RS field.
	USB1_USBCMD_D_RS_Msk = 0x1
	// Bit RS.
	USB1_USBCMD_D_RS = 0x1
	// Writing a 0 to this bit will cause a detach event.
	USB1_USBCMD_D_RS_DETACH = 0x0
	// Writing a one to this bit will cause the device controller to enable a pull-up on USB_DP and initiate an attach event. This control bit is not directly connected to the pull-up enable, as the pull-up will become disabled upon transitioning into high-speed mode. Software should use this bit to prevent an attach event before the device controller has been properly initialized.
	USB1_USBCMD_D_RS_ATACH = 0x1
	// Position of RST field.
	USB1_USBCMD_D_RST_Pos = 0x1
	// Bit mask of RST field.
	USB1_USBCMD_D_RST_Msk = 0x2
	// Bit RST.
	USB1_USBCMD_D_RST = 0x2
	// Set to 0 by hardware when the reset process is complete.
	USB1_USBCMD_D_RST_RESETCOMPLETE = 0x0
	// When software writes a one to this bit, the Device Controller resets its internal pipelines, timers, counters, state machines etc. to their initial values. Writing a one to this bit when the device is in the attached state is not recommended, since the effect on an attached host is undefined. In order to ensure that the device is not in an attached state before initiating a device controller reset, all primed endpoints should be flushed and the USBCMD Run/Stop bit should be set to 0.
	USB1_USBCMD_D_RST_RESET = 0x1
	// Position of RESERVED field.
	USB1_USBCMD_D_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	USB1_USBCMD_D_RESERVED_Msk = 0xc
	// Position of RESERVED field.
	USB1_USBCMD_D_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_USBCMD_D_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB1_USBCMD_D_RESERVED = 0x10
	// Position of RESERVED field.
	USB1_USBCMD_D_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB1_USBCMD_D_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USB1_USBCMD_D_RESERVED = 0x20
	// Position of RESERVED field.
	USB1_USBCMD_D_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB1_USBCMD_D_RESERVED_Msk = 0x40
	// Bit RESERVED.
	USB1_USBCMD_D_RESERVED = 0x40
	// Position of RESERVED field.
	USB1_USBCMD_D_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USB1_USBCMD_D_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USB1_USBCMD_D_RESERVED = 0x80
	// Position of RESERVED field.
	USB1_USBCMD_D_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB1_USBCMD_D_RESERVED_Msk = 0x300
	// Position of RESERVED field.
	USB1_USBCMD_D_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB1_USBCMD_D_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USB1_USBCMD_D_RESERVED = 0x400
	// Position of RESERVED field.
	USB1_USBCMD_D_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	USB1_USBCMD_D_RESERVED_Msk = 0x800
	// Bit RESERVED.
	USB1_USBCMD_D_RESERVED = 0x800
	// Position of RESERVED field.
	USB1_USBCMD_D_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	USB1_USBCMD_D_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	USB1_USBCMD_D_RESERVED = 0x1000
	// Position of SUTW field.
	USB1_USBCMD_D_SUTW_Pos = 0xd
	// Bit mask of SUTW field.
	USB1_USBCMD_D_SUTW_Msk = 0x2000
	// Bit SUTW.
	USB1_USBCMD_D_SUTW = 0x2000
	// Position of ATDTW field.
	USB1_USBCMD_D_ATDTW_Pos = 0xe
	// Bit mask of ATDTW field.
	USB1_USBCMD_D_ATDTW_Msk = 0x4000
	// Bit ATDTW.
	USB1_USBCMD_D_ATDTW = 0x4000
	// Position of FS2 field.
	USB1_USBCMD_D_FS2_Pos = 0xf
	// Bit mask of FS2 field.
	USB1_USBCMD_D_FS2_Msk = 0x8000
	// Bit FS2.
	USB1_USBCMD_D_FS2 = 0x8000
	// Position of ITC field.
	USB1_USBCMD_D_ITC_Pos = 0x10
	// Bit mask of ITC field.
	USB1_USBCMD_D_ITC_Msk = 0xff0000
	// Position of RESERVED field.
	USB1_USBCMD_D_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB1_USBCMD_D_RESERVED_Msk = 0xff000000

	// USBCMD_H: USB command (host mode)
	// Position of RS field.
	USB1_USBCMD_H_RS_Pos = 0x0
	// Bit mask of RS field.
	USB1_USBCMD_H_RS_Msk = 0x1
	// Bit RS.
	USB1_USBCMD_H_RS = 0x1
	// When this bit is set to 0, the Host Controller completes the current transaction on the USB and then halts. The HC Halted bit in the status register indicates when the Host Controller has finished the transaction and has entered the stopped state. Software should not write a one to this field unless the host controller is in the Halted state (i.e. HCHalted in the USBSTS register is a one).
	USB1_USBCMD_H_RS_HALT = 0x0
	// When set to a 1, the Host Controller proceeds with the execution of the schedule. The Host Controller continues execution as long as this bit is set to a one.
	USB1_USBCMD_H_RS_PROCEED = 0x1
	// Position of RST field.
	USB1_USBCMD_H_RST_Pos = 0x1
	// Bit mask of RST field.
	USB1_USBCMD_H_RST_Msk = 0x2
	// Bit RST.
	USB1_USBCMD_H_RST = 0x2
	// This bit is set to zero by hardware when the reset process is complete.
	USB1_USBCMD_H_RST_RESETCOMPLETE = 0x0
	// When software writes a one to this bit, the Host Controller resets its internal pipelines, timers, counters, state machines etc. to their initial value. Any transaction currently in progress on USB is immediately terminated. A USB reset is not driven on downstream ports. Software should not set this bit to a one when the HCHalted bit in the USBSTS register is a zero. Attempting to reset an actively running host controller will result in undefined behavior.
	USB1_USBCMD_H_RST_RESET = 0x1
	// Position of FS0 field.
	USB1_USBCMD_H_FS0_Pos = 0x2
	// Bit mask of FS0 field.
	USB1_USBCMD_H_FS0_Msk = 0x4
	// Bit FS0.
	USB1_USBCMD_H_FS0 = 0x4
	// Position of FS1 field.
	USB1_USBCMD_H_FS1_Pos = 0x3
	// Bit mask of FS1 field.
	USB1_USBCMD_H_FS1_Msk = 0x8
	// Bit FS1.
	USB1_USBCMD_H_FS1 = 0x8
	// Position of PSE field.
	USB1_USBCMD_H_PSE_Pos = 0x4
	// Bit mask of PSE field.
	USB1_USBCMD_H_PSE_Msk = 0x10
	// Bit PSE.
	USB1_USBCMD_H_PSE = 0x10
	// Do not process the periodic schedule.
	USB1_USBCMD_H_PSE_DO_NOT_PROCESS_THE_P = 0x0
	// Use the PERIODICLISTBASE register to access the periodic schedule.
	USB1_USBCMD_H_PSE_USE_THE_PERIODICLIST = 0x1
	// Position of ASE field.
	USB1_USBCMD_H_ASE_Pos = 0x5
	// Bit mask of ASE field.
	USB1_USBCMD_H_ASE_Msk = 0x20
	// Bit ASE.
	USB1_USBCMD_H_ASE = 0x20
	// Do not process the asynchronous schedule.
	USB1_USBCMD_H_ASE_DO_NOT_PROCESS_THE_A = 0x0
	// Use the ASYNCLISTADDR to access the asynchronous schedule.
	USB1_USBCMD_H_ASE_USE_THE_ASYNCLISTADD = 0x1
	// Position of IAA field.
	USB1_USBCMD_H_IAA_Pos = 0x6
	// Bit mask of IAA field.
	USB1_USBCMD_H_IAA_Msk = 0x40
	// Bit IAA.
	USB1_USBCMD_H_IAA = 0x40
	// The host controller sets this bit to zero after it has set the Interrupt on Sync Advance status bit in the USBSTS register to one.
	USB1_USBCMD_H_IAA_ST = 0x0
	// Software must write a 1 to this bit to ring the doorbell. When the host controller has evicted all appropriate cached schedule states, it sets the Interrupt on Async Advance status bit in the USBSTS register. If the Interrupt on Sync Advance Enable bit in the USBINTR register is one, then the host controller will assert an interrupt at the next interrupt threshold. Software should not write a one to this bit when the asynchronous schedule is inactive. Doing so will yield undefined results.
	USB1_USBCMD_H_IAA_DOORBELL = 0x1
	// Position of RESERVED field.
	USB1_USBCMD_H_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USB1_USBCMD_H_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USB1_USBCMD_H_RESERVED = 0x80
	// Position of ASP1_0 field.
	USB1_USBCMD_H_ASP1_0_Pos = 0x8
	// Bit mask of ASP1_0 field.
	USB1_USBCMD_H_ASP1_0_Msk = 0x300
	// Position of RESERVED field.
	USB1_USBCMD_H_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB1_USBCMD_H_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USB1_USBCMD_H_RESERVED = 0x400
	// Position of ASPE field.
	USB1_USBCMD_H_ASPE_Pos = 0xb
	// Bit mask of ASPE field.
	USB1_USBCMD_H_ASPE_Msk = 0x800
	// Bit ASPE.
	USB1_USBCMD_H_ASPE = 0x800
	// Park mode is disabled.
	USB1_USBCMD_H_ASPE_PARK_MODE_IS_DISABLE = 0x0
	// Park mode is enabled.
	USB1_USBCMD_H_ASPE_PARK_MODE_IS_ENABLED = 0x1
	// Position of RESERVED field.
	USB1_USBCMD_H_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	USB1_USBCMD_H_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	USB1_USBCMD_H_RESERVED = 0x1000
	// Position of RESERVED field.
	USB1_USBCMD_H_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB1_USBCMD_H_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USB1_USBCMD_H_RESERVED = 0x2000
	// Position of RESERVED field.
	USB1_USBCMD_H_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	USB1_USBCMD_H_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	USB1_USBCMD_H_RESERVED = 0x4000
	// Position of FS2 field.
	USB1_USBCMD_H_FS2_Pos = 0xf
	// Bit mask of FS2 field.
	USB1_USBCMD_H_FS2_Msk = 0x8000
	// Bit FS2.
	USB1_USBCMD_H_FS2 = 0x8000
	// Position of ITC field.
	USB1_USBCMD_H_ITC_Pos = 0x10
	// Bit mask of ITC field.
	USB1_USBCMD_H_ITC_Msk = 0xff0000
	// Position of RESERVED field.
	USB1_USBCMD_H_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB1_USBCMD_H_RESERVED_Msk = 0xff000000

	// USBSTS_D: USB status (device mode)
	// Position of UI field.
	USB1_USBSTS_D_UI_Pos = 0x0
	// Bit mask of UI field.
	USB1_USBSTS_D_UI_Msk = 0x1
	// Bit UI.
	USB1_USBSTS_D_UI = 0x1
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_D_UI_ST = 0x0
	// This bit is set by the Host/Device Controller when the cause of an interrupt is a completion of a USB transaction where the Transfer Descriptor (TD) has an interrupt on complete (IOC) bit set. This bit is also set by the Host/Device Controller when a short packet is detected. A short packet is when the actual number of bytes received was less than the expected number of bytes.
	USB1_USBSTS_D_UI_CLEAR = 0x1
	// Position of UEI field.
	USB1_USBSTS_D_UEI_Pos = 0x1
	// Bit mask of UEI field.
	USB1_USBSTS_D_UEI_Msk = 0x2
	// Bit UEI.
	USB1_USBSTS_D_UEI = 0x2
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_D_UEI_ST = 0x0
	// When completion of a USB transaction results in an error condition, this bit is set by the Host/Device Controller. This bit is set along with the USBINT bit, if the TD on which the error interrupt occurred also had its interrupt on complete (IOC) bit set. The device controller detects resume signaling only (see Section 18.10.11.6).
	USB1_USBSTS_D_UEI_CLEAR = 0x1
	// Position of PCI field.
	USB1_USBSTS_D_PCI_Pos = 0x2
	// Bit mask of PCI field.
	USB1_USBSTS_D_PCI_Msk = 0x4
	// Bit PCI.
	USB1_USBSTS_D_PCI = 0x4
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_D_PCI_ST = 0x0
	// The Device Controller sets this bit to a one when the port controller enters the full or high-speed operational state. When the port controller exits the full or high-speed operation states due to Reset or Suspend events, the notification mechanisms are the USB Reset Received bit (URI) and the DCSuspend bits (SLI) respectively.
	USB1_USBSTS_D_PCI_CLEAR = 0x1
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USB1_USBSTS_D_RESERVED = 0x8
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB1_USBSTS_D_RESERVED = 0x10
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USB1_USBSTS_D_RESERVED = 0x20
	// Position of URI field.
	USB1_USBSTS_D_URI_Pos = 0x6
	// Bit mask of URI field.
	USB1_USBSTS_D_URI_Msk = 0x40
	// Bit URI.
	USB1_USBSTS_D_URI = 0x40
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_D_URI_ST = 0x0
	// When the device controller detects a USB Reset and enters the default state, this bit will be set to a one.
	USB1_USBSTS_D_URI_CLEAR = 0x1
	// Position of SRI field.
	USB1_USBSTS_D_SRI_Pos = 0x7
	// Bit mask of SRI field.
	USB1_USBSTS_D_SRI_Msk = 0x80
	// Bit SRI.
	USB1_USBSTS_D_SRI = 0x80
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_D_SRI_ST = 0x0
	// When the device controller detects a Start Of (micro) Frame, this bit will be set to a one. When a SOF is extremely late, the device controller will automatically set this bit to indicate that an SOF was expected. Therefore, this bit will be set roughly every 1 ms in device FS mode and every 125 ms in HS mode and will be synchronized to the actual SOF that is received. Since the device controller is initialized to FS before connect, this bit will be set at an interval of 1ms during the prelude to connect and chirp.
	USB1_USBSTS_D_SRI_CLEAR = 0x1
	// Position of SLI field.
	USB1_USBSTS_D_SLI_Pos = 0x8
	// Bit mask of SLI field.
	USB1_USBSTS_D_SLI_Msk = 0x100
	// Bit SLI.
	USB1_USBSTS_D_SLI = 0x100
	// The device controller clears the bit upon exiting from a suspend state. This bit is cleared by software writing a one to it.
	USB1_USBSTS_D_SLI_ST = 0x0
	// When a device controller enters a suspend state from an active state, this bit will be set to a one.
	USB1_USBSTS_D_SLI_CLEAR = 0x1
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0xe00
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	USB1_USBSTS_D_RESERVED = 0x1000
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USB1_USBSTS_D_RESERVED = 0x2000
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	USB1_USBSTS_D_RESERVED = 0x4000
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0x8000
	// Bit RESERVED.
	USB1_USBSTS_D_RESERVED = 0x8000
	// Position of NAKI field.
	USB1_USBSTS_D_NAKI_Pos = 0x10
	// Bit mask of NAKI field.
	USB1_USBSTS_D_NAKI_Msk = 0x10000
	// Bit NAKI.
	USB1_USBSTS_D_NAKI = 0x10000
	// This bit is automatically cleared by hardware when the all the enabled TX/RX Endpoint NAK bits are cleared.
	USB1_USBSTS_D_NAKI_ENDPCLEAR = 0x0
	// It is set by hardware when for a particular endpoint both the TX/RX Endpoint NAK bit and the corresponding TX/RX Endpoint NAK Enable bit are set.
	USB1_USBSTS_D_NAKI_SET = 0x1
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB1_USBSTS_D_RESERVED = 0x20000
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	USB1_USBSTS_D_RESERVED = 0x40000
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0x80000
	// Bit RESERVED.
	USB1_USBSTS_D_RESERVED = 0x80000
	// Position of RESERVED field.
	USB1_USBSTS_D_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_USBSTS_D_RESERVED_Msk = 0xfff00000

	// USBSTS_H: USB status (host mode)
	// Position of UI field.
	USB1_USBSTS_H_UI_Pos = 0x0
	// Bit mask of UI field.
	USB1_USBSTS_H_UI_Msk = 0x1
	// Bit UI.
	USB1_USBSTS_H_UI = 0x1
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_H_UI_ST = 0x0
	// This bit is set by the Host/Device Controller when the cause of an interrupt is a completion of a USB transaction where the Transfer Descriptor (TD) has an interrupt on complete (IOC) bit set. This bit is also set by the Host/Device Controller when a short packet is detected. A short packet is when the actual number of bytes received was less than the expected number of bytes.
	USB1_USBSTS_H_UI_CLEAR = 0x1
	// Position of UEI field.
	USB1_USBSTS_H_UEI_Pos = 0x1
	// Bit mask of UEI field.
	USB1_USBSTS_H_UEI_Msk = 0x2
	// Bit UEI.
	USB1_USBSTS_H_UEI = 0x2
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_H_UEI_ST = 0x0
	// When completion of a USB transaction results in an error condition, this bit is set by the Host/Device Controller. This bit is set along with the USBINT bit, if the TD on which the error interrupt occurred also had its interrupt on complete (IOC) bit set.
	USB1_USBSTS_H_UEI_CLEAR = 0x1
	// Position of PCI field.
	USB1_USBSTS_H_PCI_Pos = 0x2
	// Bit mask of PCI field.
	USB1_USBSTS_H_PCI_Msk = 0x4
	// Bit PCI.
	USB1_USBSTS_H_PCI = 0x4
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_H_PCI_ST = 0x0
	// The Host Controller sets this bit to a one when on any port a Connect Status occurs, a Port Enable/Disable Change occurs, or the Force Port Resume bit is set as the result of a J-K transition on the suspended port.
	USB1_USBSTS_H_PCI_CLEAR = 0x1
	// Position of FRI field.
	USB1_USBSTS_H_FRI_Pos = 0x3
	// Bit mask of FRI field.
	USB1_USBSTS_H_FRI_Msk = 0x8
	// Bit FRI.
	USB1_USBSTS_H_FRI = 0x8
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_H_FRI_ST = 0x0
	// The Host Controller sets this bit to a one when the Frame List Index rolls over from its maximum value to zero. The exact value at which the rollover occurs depends on the frame list size. For example, if the frame list size (as programmed in the Frame List Size field of the USBCMD register) is 1024, the Frame Index Register rolls over every time FRINDEX [13] toggles. Similarly, if the size is 512, the Host Controller sets this bit to a one every time FRINDEX bit 12 toggles (see Section 19.6.5).
	USB1_USBSTS_H_FRI_CLEAR = 0x1
	// Position of RESERVED field.
	USB1_USBSTS_H_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_USBSTS_H_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB1_USBSTS_H_RESERVED = 0x10
	// Position of AAI field.
	USB1_USBSTS_H_AAI_Pos = 0x5
	// Bit mask of AAI field.
	USB1_USBSTS_H_AAI_Msk = 0x20
	// Bit AAI.
	USB1_USBSTS_H_AAI = 0x20
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_H_AAI_ST = 0x0
	// System software can force the host controller to issue an interrupt the next time the host controller advances the asynchronous schedule by writing a one to the Interrupt on Async Advance Doorbell bit in the USBCMD register. This status bit indicates the assertion of that interrupt source.
	USB1_USBSTS_H_AAI_CLEAR = 0x1
	// Position of RESERVED field.
	USB1_USBSTS_H_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB1_USBSTS_H_RESERVED_Msk = 0x40
	// Bit RESERVED.
	USB1_USBSTS_H_RESERVED = 0x40
	// Position of SRI field.
	USB1_USBSTS_H_SRI_Pos = 0x7
	// Bit mask of SRI field.
	USB1_USBSTS_H_SRI_Msk = 0x80
	// Bit SRI.
	USB1_USBSTS_H_SRI = 0x80
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_H_SRI_ST = 0x0
	// In host mode, this bit will be set every 125 ms and can be used by host controller driver as a time base.
	USB1_USBSTS_H_SRI_CLEAR = 0x1
	// Position of SLI field.
	USB1_USBSTS_H_SLI_Pos = 0x8
	// Bit mask of SLI field.
	USB1_USBSTS_H_SLI_Msk = 0x100
	// Bit SLI.
	USB1_USBSTS_H_SLI = 0x100
	// Position of RESERVED field.
	USB1_USBSTS_H_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB1_USBSTS_H_RESERVED_Msk = 0xe00
	// Position of HCH field.
	USB1_USBSTS_H_HCH_Pos = 0xc
	// Bit mask of HCH field.
	USB1_USBSTS_H_HCH_Msk = 0x1000
	// Bit HCH.
	USB1_USBSTS_H_HCH = 0x1000
	// The RS bit in USBCMD is set to zero. Set by the host controller.
	USB1_USBSTS_H_HCH_RS = 0x0
	// The Host Controller sets this bit to one after it has stopped executing because of the Run/Stop bit being set to 0, either by software or by the Host Controller hardware (e.g. because of an internal error).
	USB1_USBSTS_H_HCH_STOP = 0x1
	// Position of RCL field.
	USB1_USBSTS_H_RCL_Pos = 0xd
	// Bit mask of RCL field.
	USB1_USBSTS_H_RCL_Msk = 0x2000
	// Bit RCL.
	USB1_USBSTS_H_RCL = 0x2000
	// No empty asynchronous schedule detected.
	USB1_USBSTS_H_RCL_NO_EMPTY_ASYNCHRONOU = 0x0
	// An empty asynchronous schedule is detected. Set by the host controller.
	USB1_USBSTS_H_RCL_EMPTY_ASYNCHRONOU = 0x1
	// Position of PS field.
	USB1_USBSTS_H_PS_Pos = 0xe
	// Bit mask of PS field.
	USB1_USBSTS_H_PS_Msk = 0x4000
	// Bit PS.
	USB1_USBSTS_H_PS = 0x4000
	// The periodic schedule status is disabled.
	USB1_USBSTS_H_PS_DISABLED = 0x0
	// The periodic schedule status is enabled.
	USB1_USBSTS_H_PS_ENABLED = 0x1
	// Position of AS field.
	USB1_USBSTS_H_AS_Pos = 0xf
	// Bit mask of AS field.
	USB1_USBSTS_H_AS_Msk = 0x8000
	// Bit AS.
	USB1_USBSTS_H_AS = 0x8000
	// Asynchronous schedule status is disabled.
	USB1_USBSTS_H_AS_DISABLED = 0x0
	// Asynchronous schedule status is enabled.
	USB1_USBSTS_H_AS_ENABLED = 0x1
	// Position of RESERVED field.
	USB1_USBSTS_H_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB1_USBSTS_H_RESERVED_Msk = 0x10000
	// Bit RESERVED.
	USB1_USBSTS_H_RESERVED = 0x10000
	// Position of RESERVED field.
	USB1_USBSTS_H_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB1_USBSTS_H_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB1_USBSTS_H_RESERVED = 0x20000
	// Position of UAI field.
	USB1_USBSTS_H_UAI_Pos = 0x12
	// Bit mask of UAI field.
	USB1_USBSTS_H_UAI_Msk = 0x40000
	// Bit UAI.
	USB1_USBSTS_H_UAI = 0x40000
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_H_UAI_ST = 0x0
	// This bit is set by the Host Controller when the cause of an interrupt is a completion of a USB transaction where the Transfer Descriptor (TD) has an interrupt on complete (IOC) bit set and the TD was from the asynchronous schedule. This bit is also set by the Host when a short packet is detected and the packet is on the asynchronous schedule. A short packet is when the actual number of bytes received was less than the expected number of bytes.
	USB1_USBSTS_H_UAI_CLEAR = 0x1
	// Position of UPI field.
	USB1_USBSTS_H_UPI_Pos = 0x13
	// Bit mask of UPI field.
	USB1_USBSTS_H_UPI_Msk = 0x80000
	// Bit UPI.
	USB1_USBSTS_H_UPI = 0x80000
	// This bit is cleared by software writing a one to it.
	USB1_USBSTS_H_UPI_ST = 0x0
	// This bit is set by the Host Controller when the cause of an interrupt is a completion of a USB transaction where the Transfer Descriptor (TD) has an interrupt on complete (IOC) bit set and the TD was from the periodic schedule. This bit is also set by the Host Controller when a short packet is detected and the packet is on the periodic schedule. A short packet is when the actual number of bytes received was less than the expected number of bytes.
	USB1_USBSTS_H_UPI_CLEAR = 0x1
	// Position of RESERVED field.
	USB1_USBSTS_H_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_USBSTS_H_RESERVED_Msk = 0xfff00000

	// USBINTR_D: USB interrupt enable (device mode)
	// Position of UE field.
	USB1_USBINTR_D_UE_Pos = 0x0
	// Bit mask of UE field.
	USB1_USBINTR_D_UE_Msk = 0x1
	// Bit UE.
	USB1_USBINTR_D_UE = 0x1
	// Position of UEE field.
	USB1_USBINTR_D_UEE_Pos = 0x1
	// Bit mask of UEE field.
	USB1_USBINTR_D_UEE_Msk = 0x2
	// Bit UEE.
	USB1_USBINTR_D_UEE = 0x2
	// Position of PCE field.
	USB1_USBINTR_D_PCE_Pos = 0x2
	// Bit mask of PCE field.
	USB1_USBINTR_D_PCE_Msk = 0x4
	// Bit PCE.
	USB1_USBINTR_D_PCE = 0x4
	// Position of RESERVED field.
	USB1_USBINTR_D_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USB1_USBINTR_D_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USB1_USBINTR_D_RESERVED = 0x8
	// Position of RESERVED field.
	USB1_USBINTR_D_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_USBINTR_D_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB1_USBINTR_D_RESERVED = 0x10
	// Position of RESERVED field.
	USB1_USBINTR_D_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB1_USBINTR_D_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USB1_USBINTR_D_RESERVED = 0x20
	// Position of URE field.
	USB1_USBINTR_D_URE_Pos = 0x6
	// Bit mask of URE field.
	USB1_USBINTR_D_URE_Msk = 0x40
	// Bit URE.
	USB1_USBINTR_D_URE = 0x40
	// Position of SRE field.
	USB1_USBINTR_D_SRE_Pos = 0x7
	// Bit mask of SRE field.
	USB1_USBINTR_D_SRE_Msk = 0x80
	// Bit SRE.
	USB1_USBINTR_D_SRE = 0x80
	// Position of SLE field.
	USB1_USBINTR_D_SLE_Pos = 0x8
	// Bit mask of SLE field.
	USB1_USBINTR_D_SLE_Msk = 0x100
	// Bit SLE.
	USB1_USBINTR_D_SLE = 0x100
	// Position of RESERVED field.
	USB1_USBINTR_D_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB1_USBINTR_D_RESERVED_Msk = 0xfe00
	// Position of NAKE field.
	USB1_USBINTR_D_NAKE_Pos = 0x10
	// Bit mask of NAKE field.
	USB1_USBINTR_D_NAKE_Msk = 0x10000
	// Bit NAKE.
	USB1_USBINTR_D_NAKE = 0x10000
	// Position of RESERVED field.
	USB1_USBINTR_D_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB1_USBINTR_D_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB1_USBINTR_D_RESERVED = 0x20000
	// Position of UAIE field.
	USB1_USBINTR_D_UAIE_Pos = 0x12
	// Bit mask of UAIE field.
	USB1_USBINTR_D_UAIE_Msk = 0x40000
	// Bit UAIE.
	USB1_USBINTR_D_UAIE = 0x40000
	// Position of UPIA field.
	USB1_USBINTR_D_UPIA_Pos = 0x13
	// Bit mask of UPIA field.
	USB1_USBINTR_D_UPIA_Msk = 0x80000
	// Bit UPIA.
	USB1_USBINTR_D_UPIA = 0x80000
	// Position of RESERVED field.
	USB1_USBINTR_D_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_USBINTR_D_RESERVED_Msk = 0xfff00000

	// USBINTR_H: USB interrupt enable (host mode)
	// Position of UE field.
	USB1_USBINTR_H_UE_Pos = 0x0
	// Bit mask of UE field.
	USB1_USBINTR_H_UE_Msk = 0x1
	// Bit UE.
	USB1_USBINTR_H_UE = 0x1
	// Position of UEE field.
	USB1_USBINTR_H_UEE_Pos = 0x1
	// Bit mask of UEE field.
	USB1_USBINTR_H_UEE_Msk = 0x2
	// Bit UEE.
	USB1_USBINTR_H_UEE = 0x2
	// Position of PCE field.
	USB1_USBINTR_H_PCE_Pos = 0x2
	// Bit mask of PCE field.
	USB1_USBINTR_H_PCE_Msk = 0x4
	// Bit PCE.
	USB1_USBINTR_H_PCE = 0x4
	// Position of FRE field.
	USB1_USBINTR_H_FRE_Pos = 0x3
	// Bit mask of FRE field.
	USB1_USBINTR_H_FRE_Msk = 0x8
	// Bit FRE.
	USB1_USBINTR_H_FRE = 0x8
	// Position of RESERVED field.
	USB1_USBINTR_H_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_USBINTR_H_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB1_USBINTR_H_RESERVED = 0x10
	// Position of AAE field.
	USB1_USBINTR_H_AAE_Pos = 0x5
	// Bit mask of AAE field.
	USB1_USBINTR_H_AAE_Msk = 0x20
	// Bit AAE.
	USB1_USBINTR_H_AAE = 0x20
	// Position of RESERVED field.
	USB1_USBINTR_H_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB1_USBINTR_H_RESERVED_Msk = 0x40
	// Bit RESERVED.
	USB1_USBINTR_H_RESERVED = 0x40
	// Position of SRE field.
	USB1_USBINTR_H_SRE_Pos = 0x7
	// Bit mask of SRE field.
	USB1_USBINTR_H_SRE_Msk = 0x80
	// Bit SRE.
	USB1_USBINTR_H_SRE = 0x80
	// Position of RESERVED field.
	USB1_USBINTR_H_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB1_USBINTR_H_RESERVED_Msk = 0x100
	// Bit RESERVED.
	USB1_USBINTR_H_RESERVED = 0x100
	// Position of RESERVED field.
	USB1_USBINTR_H_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB1_USBINTR_H_RESERVED_Msk = 0xfe00
	// Position of RESERVED field.
	USB1_USBINTR_H_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB1_USBINTR_H_RESERVED_Msk = 0x10000
	// Bit RESERVED.
	USB1_USBINTR_H_RESERVED = 0x10000
	// Position of RESERVED field.
	USB1_USBINTR_H_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB1_USBINTR_H_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB1_USBINTR_H_RESERVED = 0x20000
	// Position of UAIE field.
	USB1_USBINTR_H_UAIE_Pos = 0x12
	// Bit mask of UAIE field.
	USB1_USBINTR_H_UAIE_Msk = 0x40000
	// Bit UAIE.
	USB1_USBINTR_H_UAIE = 0x40000
	// Position of UPIA field.
	USB1_USBINTR_H_UPIA_Pos = 0x13
	// Bit mask of UPIA field.
	USB1_USBINTR_H_UPIA_Msk = 0x80000
	// Bit UPIA.
	USB1_USBINTR_H_UPIA = 0x80000
	// Position of RESERVED field.
	USB1_USBINTR_H_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_USBINTR_H_RESERVED_Msk = 0xfff00000

	// FRINDEX_D: USB frame index (device mode)
	// Position of FRINDEX2_0 field.
	USB1_FRINDEX_D_FRINDEX2_0_Pos = 0x0
	// Bit mask of FRINDEX2_0 field.
	USB1_FRINDEX_D_FRINDEX2_0_Msk = 0x7
	// Position of FRINDEX13_3 field.
	USB1_FRINDEX_D_FRINDEX13_3_Pos = 0x3
	// Bit mask of FRINDEX13_3 field.
	USB1_FRINDEX_D_FRINDEX13_3_Msk = 0x3ff8
	// Position of RESERVED field.
	USB1_FRINDEX_D_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	USB1_FRINDEX_D_RESERVED_Msk = 0xffffc000

	// FRINDEX_H: USB frame index (host mode)
	// Position of FRINDEX2_0 field.
	USB1_FRINDEX_H_FRINDEX2_0_Pos = 0x0
	// Bit mask of FRINDEX2_0 field.
	USB1_FRINDEX_H_FRINDEX2_0_Msk = 0x7
	// Position of FRINDEX12_3 field.
	USB1_FRINDEX_H_FRINDEX12_3_Pos = 0x3
	// Bit mask of FRINDEX12_3 field.
	USB1_FRINDEX_H_FRINDEX12_3_Msk = 0x1ff8
	// Position of RESERVED field.
	USB1_FRINDEX_H_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB1_FRINDEX_H_RESERVED_Msk = 0xffffe000

	// DEVICEADDR: USB device address
	// Position of RESERVED field.
	USB1_DEVICEADDR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB1_DEVICEADDR_RESERVED_Msk = 0xffffff
	// Position of USBADRA field.
	USB1_DEVICEADDR_USBADRA_Pos = 0x18
	// Bit mask of USBADRA field.
	USB1_DEVICEADDR_USBADRA_Msk = 0x1000000
	// Bit USBADRA.
	USB1_DEVICEADDR_USBADRA = 0x1000000
	// Any write to USBADR are instantaneous.
	USB1_DEVICEADDR_USBADRA_ADVANCE = 0x0
	// When the user writes a one to this bit at the same time or before USBADR is written, the write to USBADR fields is staged and held in a hidden register. After an IN occurs on endpoint 0 and is acknowledged, USBADR will be loaded from the holding register. Hardware will automatically clear this bit on the following conditions: IN is ACKed to endpoint 0. USBADR is updated from the staging register. OUT/SETUP occurs on endpoint 0. USBADR is not updated. Device reset occurs. USBADR is set to 0. After the status phase of the SET_ADDRESS descriptor, the DCD has 2 ms to program the USBADR field. This mechanism will ensure this specification is met when the DCD can not write the device address within 2 ms from the SET_ADDRESS status phase. If the DCD writes the USBADR with USBADRA=1 after the SET_ADDRESS data phase (before the prime of the status phase), the USBADR will be programmed instantly at the correct time and meet the 2 ms USB requirement.
	USB1_DEVICEADDR_USBADRA_HOLD = 0x1
	// Position of USBADR field.
	USB1_DEVICEADDR_USBADR_Pos = 0x19
	// Bit mask of USBADR field.
	USB1_DEVICEADDR_USBADR_Msk = 0xfe000000

	// PERIODICLISTBASE: Frame list base address
	// Position of RESERVED field.
	USB1_PERIODICLISTBASE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB1_PERIODICLISTBASE_RESERVED_Msk = 0xfff
	// Position of PERBASE31_12 field.
	USB1_PERIODICLISTBASE_PERBASE31_12_Pos = 0xc
	// Bit mask of PERBASE31_12 field.
	USB1_PERIODICLISTBASE_PERBASE31_12_Msk = 0xfffff000

	// ENDPOINTLISTADDR: Address of endpoint list in memory (device mode)
	// Position of RESERVED field.
	USB1_ENDPOINTLISTADDR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB1_ENDPOINTLISTADDR_RESERVED_Msk = 0x7ff
	// Position of EPBASE31_11 field.
	USB1_ENDPOINTLISTADDR_EPBASE31_11_Pos = 0xb
	// Bit mask of EPBASE31_11 field.
	USB1_ENDPOINTLISTADDR_EPBASE31_11_Msk = 0xfffff800

	// ASYNCLISTADDR: Address of endpoint list in memory (host mode)
	// Position of RESERVED field.
	USB1_ASYNCLISTADDR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB1_ASYNCLISTADDR_RESERVED_Msk = 0x1f
	// Position of ASYBASE31_5 field.
	USB1_ASYNCLISTADDR_ASYBASE31_5_Pos = 0x5
	// Bit mask of ASYBASE31_5 field.
	USB1_ASYNCLISTADDR_ASYBASE31_5_Msk = 0xffffffe0

	// TTCTRL: Asynchronous buffer status for embedded TT (host mode)
	// Position of RESERVED field.
	USB1_TTCTRL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB1_TTCTRL_RESERVED_Msk = 0xffffff
	// Position of TTHA field.
	USB1_TTCTRL_TTHA_Pos = 0x18
	// Bit mask of TTHA field.
	USB1_TTCTRL_TTHA_Msk = 0x7f000000
	// Position of RESERVED field.
	USB1_TTCTRL_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	USB1_TTCTRL_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	USB1_TTCTRL_RESERVED = 0x80000000

	// BURSTSIZE: Programmable burst size
	// Position of RXPBURST field.
	USB1_BURSTSIZE_RXPBURST_Pos = 0x0
	// Bit mask of RXPBURST field.
	USB1_BURSTSIZE_RXPBURST_Msk = 0xff
	// Position of TXPBURST field.
	USB1_BURSTSIZE_TXPBURST_Pos = 0x8
	// Bit mask of TXPBURST field.
	USB1_BURSTSIZE_TXPBURST_Msk = 0xff00
	// Position of RESERVED field.
	USB1_BURSTSIZE_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB1_BURSTSIZE_RESERVED_Msk = 0xffff0000

	// TXFILLTUNING: Host transmit pre-buffer packet tuning (host mode)
	// Position of TXSCHOH field.
	USB1_TXFILLTUNING_TXSCHOH_Pos = 0x0
	// Bit mask of TXSCHOH field.
	USB1_TXFILLTUNING_TXSCHOH_Msk = 0xff
	// Position of TXSCHEATLTH field.
	USB1_TXFILLTUNING_TXSCHEATLTH_Pos = 0x8
	// Bit mask of TXSCHEATLTH field.
	USB1_TXFILLTUNING_TXSCHEATLTH_Msk = 0x1f00
	// Position of RESERVED field.
	USB1_TXFILLTUNING_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB1_TXFILLTUNING_RESERVED_Msk = 0xe000
	// Position of TXFIFOTHRES field.
	USB1_TXFILLTUNING_TXFIFOTHRES_Pos = 0x10
	// Bit mask of TXFIFOTHRES field.
	USB1_TXFILLTUNING_TXFIFOTHRES_Msk = 0x3f0000
	// Position of RESERVED field.
	USB1_TXFILLTUNING_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	USB1_TXFILLTUNING_RESERVED_Msk = 0xffc00000

	// ULPIVIEWPORT: ULPI viewport
	// Position of ULPIDATWR field.
	USB1_ULPIVIEWPORT_ULPIDATWR_Pos = 0x0
	// Bit mask of ULPIDATWR field.
	USB1_ULPIVIEWPORT_ULPIDATWR_Msk = 0xff
	// Position of ULPIDATRD field.
	USB1_ULPIVIEWPORT_ULPIDATRD_Pos = 0x8
	// Bit mask of ULPIDATRD field.
	USB1_ULPIVIEWPORT_ULPIDATRD_Msk = 0xff00
	// Position of ULPIADDR field.
	USB1_ULPIVIEWPORT_ULPIADDR_Pos = 0x10
	// Bit mask of ULPIADDR field.
	USB1_ULPIVIEWPORT_ULPIADDR_Msk = 0xff0000
	// Position of ULPIPORT field.
	USB1_ULPIVIEWPORT_ULPIPORT_Pos = 0x18
	// Bit mask of ULPIPORT field.
	USB1_ULPIVIEWPORT_ULPIPORT_Msk = 0x7000000
	// Position of ULPISS field.
	USB1_ULPIVIEWPORT_ULPISS_Pos = 0x1b
	// Bit mask of ULPISS field.
	USB1_ULPIVIEWPORT_ULPISS_Msk = 0x8000000
	// Bit ULPISS.
	USB1_ULPIVIEWPORT_ULPISS = 0x8000000
	// In another state (ie. carkit, serial, low power)
	USB1_ULPIVIEWPORT_ULPISS_IN_ANOTHER_STATE = 0x0
	// Normal Sync. State.
	USB1_ULPIVIEWPORT_ULPISS_NORMAL_SYNC_STATE_ = 0x1
	// Position of RESERVED field.
	USB1_ULPIVIEWPORT_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	USB1_ULPIVIEWPORT_RESERVED_Msk = 0x10000000
	// Bit RESERVED.
	USB1_ULPIVIEWPORT_RESERVED = 0x10000000
	// Position of ULPIRW field.
	USB1_ULPIVIEWPORT_ULPIRW_Pos = 0x1d
	// Bit mask of ULPIRW field.
	USB1_ULPIVIEWPORT_ULPIRW_Msk = 0x20000000
	// Bit ULPIRW.
	USB1_ULPIVIEWPORT_ULPIRW = 0x20000000
	// Read
	USB1_ULPIVIEWPORT_ULPIRW_READ = 0x0
	// Write
	USB1_ULPIVIEWPORT_ULPIRW_WRITE = 0x1
	// Position of ULPIRUN field.
	USB1_ULPIVIEWPORT_ULPIRUN_Pos = 0x1e
	// Bit mask of ULPIRUN field.
	USB1_ULPIVIEWPORT_ULPIRUN_Msk = 0x40000000
	// Bit ULPIRUN.
	USB1_ULPIVIEWPORT_ULPIRUN = 0x40000000
	// Position of ULPIWU field.
	USB1_ULPIVIEWPORT_ULPIWU_Pos = 0x1f
	// Bit mask of ULPIWU field.
	USB1_ULPIVIEWPORT_ULPIWU_Msk = 0x80000000
	// Bit ULPIWU.
	USB1_ULPIVIEWPORT_ULPIWU = 0x80000000

	// BINTERVAL: Length of virtual frame
	// Position of BINT field.
	USB1_BINTERVAL_BINT_Pos = 0x0
	// Bit mask of BINT field.
	USB1_BINTERVAL_BINT_Msk = 0xf
	// Position of RESERVED field.
	USB1_BINTERVAL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_BINTERVAL_RESERVED_Msk = 0xfffffff0

	// ENDPTNAK: Endpoint NAK (device mode)
	// Position of EPRN0 field.
	USB1_ENDPTNAK_EPRN0_Pos = 0x0
	// Bit mask of EPRN0 field.
	USB1_ENDPTNAK_EPRN0_Msk = 0x1
	// Bit EPRN0.
	USB1_ENDPTNAK_EPRN0 = 0x1
	// Position of EPRN1 field.
	USB1_ENDPTNAK_EPRN1_Pos = 0x1
	// Bit mask of EPRN1 field.
	USB1_ENDPTNAK_EPRN1_Msk = 0x2
	// Bit EPRN1.
	USB1_ENDPTNAK_EPRN1 = 0x2
	// Position of EPRN2 field.
	USB1_ENDPTNAK_EPRN2_Pos = 0x2
	// Bit mask of EPRN2 field.
	USB1_ENDPTNAK_EPRN2_Msk = 0x4
	// Bit EPRN2.
	USB1_ENDPTNAK_EPRN2 = 0x4
	// Position of EPRN3 field.
	USB1_ENDPTNAK_EPRN3_Pos = 0x3
	// Bit mask of EPRN3 field.
	USB1_ENDPTNAK_EPRN3_Msk = 0x8
	// Bit EPRN3.
	USB1_ENDPTNAK_EPRN3 = 0x8
	// Position of RESERVED field.
	USB1_ENDPTNAK_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_ENDPTNAK_RESERVED_Msk = 0xfff0
	// Position of EPTN16 field.
	USB1_ENDPTNAK_EPTN16_Pos = 0x10
	// Bit mask of EPTN16 field.
	USB1_ENDPTNAK_EPTN16_Msk = 0x10000
	// Bit EPTN16.
	USB1_ENDPTNAK_EPTN16 = 0x10000
	// Position of EPTN17 field.
	USB1_ENDPTNAK_EPTN17_Pos = 0x11
	// Bit mask of EPTN17 field.
	USB1_ENDPTNAK_EPTN17_Msk = 0x20000
	// Bit EPTN17.
	USB1_ENDPTNAK_EPTN17 = 0x20000
	// Position of EPTN18 field.
	USB1_ENDPTNAK_EPTN18_Pos = 0x12
	// Bit mask of EPTN18 field.
	USB1_ENDPTNAK_EPTN18_Msk = 0x40000
	// Bit EPTN18.
	USB1_ENDPTNAK_EPTN18 = 0x40000
	// Position of EPTN19 field.
	USB1_ENDPTNAK_EPTN19_Pos = 0x13
	// Bit mask of EPTN19 field.
	USB1_ENDPTNAK_EPTN19_Msk = 0x80000
	// Bit EPTN19.
	USB1_ENDPTNAK_EPTN19 = 0x80000
	// Position of RESERVED field.
	USB1_ENDPTNAK_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_ENDPTNAK_RESERVED_Msk = 0xfff00000

	// ENDPTNAKEN: Endpoint NAK Enable (device mode)
	// Position of EPRNE0 field.
	USB1_ENDPTNAKEN_EPRNE0_Pos = 0x0
	// Bit mask of EPRNE0 field.
	USB1_ENDPTNAKEN_EPRNE0_Msk = 0x1
	// Bit EPRNE0.
	USB1_ENDPTNAKEN_EPRNE0 = 0x1
	// Position of EPRNE1 field.
	USB1_ENDPTNAKEN_EPRNE1_Pos = 0x1
	// Bit mask of EPRNE1 field.
	USB1_ENDPTNAKEN_EPRNE1_Msk = 0x2
	// Bit EPRNE1.
	USB1_ENDPTNAKEN_EPRNE1 = 0x2
	// Position of EPRNE2 field.
	USB1_ENDPTNAKEN_EPRNE2_Pos = 0x2
	// Bit mask of EPRNE2 field.
	USB1_ENDPTNAKEN_EPRNE2_Msk = 0x4
	// Bit EPRNE2.
	USB1_ENDPTNAKEN_EPRNE2 = 0x4
	// Position of EPRNE3 field.
	USB1_ENDPTNAKEN_EPRNE3_Pos = 0x3
	// Bit mask of EPRNE3 field.
	USB1_ENDPTNAKEN_EPRNE3_Msk = 0x8
	// Bit EPRNE3.
	USB1_ENDPTNAKEN_EPRNE3 = 0x8
	// Position of RESERVED field.
	USB1_ENDPTNAKEN_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_ENDPTNAKEN_RESERVED_Msk = 0xfff0
	// Position of EPTNE16 field.
	USB1_ENDPTNAKEN_EPTNE16_Pos = 0x10
	// Bit mask of EPTNE16 field.
	USB1_ENDPTNAKEN_EPTNE16_Msk = 0x10000
	// Bit EPTNE16.
	USB1_ENDPTNAKEN_EPTNE16 = 0x10000
	// Position of EPTNE17 field.
	USB1_ENDPTNAKEN_EPTNE17_Pos = 0x11
	// Bit mask of EPTNE17 field.
	USB1_ENDPTNAKEN_EPTNE17_Msk = 0x20000
	// Bit EPTNE17.
	USB1_ENDPTNAKEN_EPTNE17 = 0x20000
	// Position of EPTNE18 field.
	USB1_ENDPTNAKEN_EPTNE18_Pos = 0x12
	// Bit mask of EPTNE18 field.
	USB1_ENDPTNAKEN_EPTNE18_Msk = 0x40000
	// Bit EPTNE18.
	USB1_ENDPTNAKEN_EPTNE18 = 0x40000
	// Position of EPTNE19 field.
	USB1_ENDPTNAKEN_EPTNE19_Pos = 0x13
	// Bit mask of EPTNE19 field.
	USB1_ENDPTNAKEN_EPTNE19_Msk = 0x80000
	// Bit EPTNE19.
	USB1_ENDPTNAKEN_EPTNE19 = 0x80000
	// Position of RESERVED field.
	USB1_ENDPTNAKEN_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_ENDPTNAKEN_RESERVED_Msk = 0xfff00000

	// PORTSC1_D: Port 1 status/control (device mode)
	// Position of CCS field.
	USB1_PORTSC1_D_CCS_Pos = 0x0
	// Bit mask of CCS field.
	USB1_PORTSC1_D_CCS_Msk = 0x1
	// Bit CCS.
	USB1_PORTSC1_D_CCS = 0x1
	// Device not attached A zero indicates that the device did not attach successfully or was forcibly disconnected by the software writing a zero to the Run bit in the USBCMD register. It does not state the device being disconnected or suspended.
	USB1_PORTSC1_D_CCS_DEVICE_NOT_ATTACHED_ = 0x0
	// Device attached. A one indicates that the device successfully attached and is operating in either high-speed mode or full-speed mode as indicated by the High Speed Port bit in this register.
	USB1_PORTSC1_D_CCS_DEVICE_ATTACHED__A_ = 0x1
	// Position of CSC field.
	USB1_PORTSC1_D_CSC_Pos = 0x1
	// Bit mask of CSC field.
	USB1_PORTSC1_D_CSC_Msk = 0x2
	// Bit CSC.
	USB1_PORTSC1_D_CSC = 0x2
	// Position of PE field.
	USB1_PORTSC1_D_PE_Pos = 0x2
	// Bit mask of PE field.
	USB1_PORTSC1_D_PE_Msk = 0x4
	// Bit PE.
	USB1_PORTSC1_D_PE = 0x4
	// Position of PEC field.
	USB1_PORTSC1_D_PEC_Pos = 0x3
	// Bit mask of PEC field.
	USB1_PORTSC1_D_PEC_Msk = 0x8
	// Bit PEC.
	USB1_PORTSC1_D_PEC = 0x8
	// Position of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Msk = 0x30
	// Position of FPR field.
	USB1_PORTSC1_D_FPR_Pos = 0x6
	// Bit mask of FPR field.
	USB1_PORTSC1_D_FPR_Msk = 0x40
	// Bit FPR.
	USB1_PORTSC1_D_FPR = 0x40
	// No resume (K-state) detected/driven on port.
	USB1_PORTSC1_D_FPR_NO_RESUME = 0x0
	// Resume detected/driven on port.
	USB1_PORTSC1_D_FPR_RESUME_DETECTED = 0x1
	// Position of SUSP field.
	USB1_PORTSC1_D_SUSP_Pos = 0x7
	// Bit mask of SUSP field.
	USB1_PORTSC1_D_SUSP_Msk = 0x80
	// Bit SUSP.
	USB1_PORTSC1_D_SUSP = 0x80
	// Port not in suspend state
	USB1_PORTSC1_D_SUSP_PORT_NOT_IN_SUSPEND_ = 0x0
	// Port in suspend state
	USB1_PORTSC1_D_SUSP_PORT_IN_SUSPEND_STAT = 0x1
	// Position of PR field.
	USB1_PORTSC1_D_PR_Pos = 0x8
	// Bit mask of PR field.
	USB1_PORTSC1_D_PR_Msk = 0x100
	// Bit PR.
	USB1_PORTSC1_D_PR = 0x100
	// Port is not in the reset state.
	USB1_PORTSC1_D_PR_PORT_IS_NOT_IN_THE_R = 0x0
	// Port is in the reset state.
	USB1_PORTSC1_D_PR_PORT_IS_IN_THE_RESET = 0x1
	// Position of HSP field.
	USB1_PORTSC1_D_HSP_Pos = 0x9
	// Bit mask of HSP field.
	USB1_PORTSC1_D_HSP_Msk = 0x200
	// Bit HSP.
	USB1_PORTSC1_D_HSP = 0x200
	// Host/device connected to the port is not in High-speed mode.
	USB1_PORTSC1_D_HSP_NOHISPEED = 0x0
	// Host/device connected to the port is in High-speed mode.
	USB1_PORTSC1_D_HSP_HISPEED = 0x1
	// Position of LS field.
	USB1_PORTSC1_D_LS_Pos = 0xa
	// Bit mask of LS field.
	USB1_PORTSC1_D_LS_Msk = 0xc00
	// Position of PP field.
	USB1_PORTSC1_D_PP_Pos = 0xc
	// Bit mask of PP field.
	USB1_PORTSC1_D_PP_Msk = 0x1000
	// Bit PP.
	USB1_PORTSC1_D_PP = 0x1000
	// Position of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USB1_PORTSC1_D_RESERVED = 0x2000
	// Position of PIC1_0 field.
	USB1_PORTSC1_D_PIC1_0_Pos = 0xe
	// Bit mask of PIC1_0 field.
	USB1_PORTSC1_D_PIC1_0_Msk = 0xc000
	// Port indicators are off.
	USB1_PORTSC1_D_PIC1_0_OFF = 0x0
	// amber
	USB1_PORTSC1_D_PIC1_0_AMBER = 0x1
	// green
	USB1_PORTSC1_D_PIC1_0_GREEN = 0x2
	// undefined
	USB1_PORTSC1_D_PIC1_0_UNDEFINED = 0x3
	// Position of PTC3_0 field.
	USB1_PORTSC1_D_PTC3_0_Pos = 0x10
	// Bit mask of PTC3_0 field.
	USB1_PORTSC1_D_PTC3_0_Msk = 0xf0000
	// TEST_MODE_DISABLE
	USB1_PORTSC1_D_PTC3_0_TEST_MODE_DISABLE = 0x0
	// J_STATE
	USB1_PORTSC1_D_PTC3_0_J_STATE = 0x1
	// K_STATE
	USB1_PORTSC1_D_PTC3_0_K_STATE = 0x2
	// SE0 (host)/NAK (device)
	USB1_PORTSC1_D_PTC3_0_SE0 = 0x3
	// Packet
	USB1_PORTSC1_D_PTC3_0_PACKET = 0x4
	// FORCE_ENABLE_HS
	USB1_PORTSC1_D_PTC3_0_FORCE_ENABLE_HS = 0x5
	// FORCE_ENABLE_FS
	USB1_PORTSC1_D_PTC3_0_FORCE_ENABLE_FS = 0x6
	// Position of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Msk = 0x100000
	// Bit RESERVED.
	USB1_PORTSC1_D_RESERVED = 0x100000
	// Position of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Msk = 0x200000
	// Bit RESERVED.
	USB1_PORTSC1_D_RESERVED = 0x200000
	// Position of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Msk = 0x400000
	// Bit RESERVED.
	USB1_PORTSC1_D_RESERVED = 0x400000
	// Position of PHCD field.
	USB1_PORTSC1_D_PHCD_Pos = 0x17
	// Bit mask of PHCD field.
	USB1_PORTSC1_D_PHCD_Msk = 0x800000
	// Bit PHCD.
	USB1_PORTSC1_D_PHCD = 0x800000
	// Writing a 0 enables the PHY clock. Reading a 0 indicates the status of the PHY clock (enabled).
	USB1_PORTSC1_D_PHCD_ENABLED = 0x0
	// Writing a 1 disables the PHY clock. Reading a 1 indicates the status of the PHY clock (disabled).
	USB1_PORTSC1_D_PHCD_DISABLED = 0x1
	// Position of PFSC field.
	USB1_PORTSC1_D_PFSC_Pos = 0x18
	// Bit mask of PFSC field.
	USB1_PORTSC1_D_PFSC_Msk = 0x1000000
	// Bit PFSC.
	USB1_PORTSC1_D_PFSC = 0x1000000
	// Port connects at any speed.
	USB1_PORTSC1_D_PFSC_ANYSPEED = 0x0
	// Writing this bit to a 1 will force the port to only connect at full speed. It disables the chirp sequence that allows the port to identify itself as High-speed. This is useful for testing FS configurations with a HS host, hub or device.
	USB1_PORTSC1_D_PFSC_FULLSPEED = 0x1
	// Position of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Msk = 0x2000000
	// Bit RESERVED.
	USB1_PORTSC1_D_RESERVED = 0x2000000
	// Position of PSPD field.
	USB1_PORTSC1_D_PSPD_Pos = 0x1a
	// Bit mask of PSPD field.
	USB1_PORTSC1_D_PSPD_Msk = 0xc000000
	// Full-speed
	USB1_PORTSC1_D_PSPD_FULL_SPEED = 0x1
	// invalid in device mode
	USB1_PORTSC1_D_PSPD_INVALID_IN_DEVICE_MO = 0x2
	// High-speed
	USB1_PORTSC1_D_PSPD_HIGH_SPEED = 0x3
	// Position of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	USB1_PORTSC1_D_RESERVED_Msk = 0x30000000
	// Position of PTS field.
	USB1_PORTSC1_D_PTS_Pos = 0x1e
	// Bit mask of PTS field.
	USB1_PORTSC1_D_PTS_Msk = 0xc0000000
	// ULPI
	USB1_PORTSC1_D_PTS_ULPI = 0x2
	// Serial/ 1.1 PHY (Full-speed only)
	USB1_PORTSC1_D_PTS_SERIAL = 0x3

	// PORTSC1_H: Port 1 status/control (host mode)
	// Position of CCS field.
	USB1_PORTSC1_H_CCS_Pos = 0x0
	// Bit mask of CCS field.
	USB1_PORTSC1_H_CCS_Msk = 0x1
	// Bit CCS.
	USB1_PORTSC1_H_CCS = 0x1
	// No device is present.
	USB1_PORTSC1_H_CCS_NO_DEVICE_IS_PRESENT = 0x0
	// Device is present on the port.
	USB1_PORTSC1_H_CCS_DEVICE_IS_PRESENT_ON = 0x1
	// Position of CSC field.
	USB1_PORTSC1_H_CSC_Pos = 0x1
	// Bit mask of CSC field.
	USB1_PORTSC1_H_CSC_Msk = 0x2
	// Bit CSC.
	USB1_PORTSC1_H_CSC = 0x2
	// No change in current status.
	USB1_PORTSC1_H_CSC_NO_CHANGE_IN_CURRENT = 0x0
	// Change in current status.
	USB1_PORTSC1_H_CSC_CHANGE_IN_CURRENT_ST = 0x1
	// Position of PE field.
	USB1_PORTSC1_H_PE_Pos = 0x2
	// Bit mask of PE field.
	USB1_PORTSC1_H_PE_Msk = 0x4
	// Bit PE.
	USB1_PORTSC1_H_PE = 0x4
	// Port disabled.
	USB1_PORTSC1_H_PE_PORT_DISABLED_ = 0x0
	// Port enabled.
	USB1_PORTSC1_H_PE_PORT_ENABLED_ = 0x1
	// Position of PEC field.
	USB1_PORTSC1_H_PEC_Pos = 0x3
	// Bit mask of PEC field.
	USB1_PORTSC1_H_PEC_Msk = 0x8
	// Bit PEC.
	USB1_PORTSC1_H_PEC = 0x8
	// No change.
	USB1_PORTSC1_H_PEC_NO_CHANGE_ = 0x0
	// Port enabled/disabled status has changed.
	USB1_PORTSC1_H_PEC_CHANGED = 0x1
	// Position of OCA field.
	USB1_PORTSC1_H_OCA_Pos = 0x4
	// Bit mask of OCA field.
	USB1_PORTSC1_H_OCA_Msk = 0x10
	// Bit OCA.
	USB1_PORTSC1_H_OCA = 0x10
	// The port does not have an over-current condition.
	USB1_PORTSC1_H_OCA_THE_PORT_DOES_NOT_HA = 0x0
	// The port has currently an over-current condition.
	USB1_PORTSC1_H_OCA_THE_PORT_HAS_CURRENT = 0x1
	// Position of OCC field.
	USB1_PORTSC1_H_OCC_Pos = 0x5
	// Bit mask of OCC field.
	USB1_PORTSC1_H_OCC_Msk = 0x20
	// Bit OCC.
	USB1_PORTSC1_H_OCC = 0x20
	// Position of FPR field.
	USB1_PORTSC1_H_FPR_Pos = 0x6
	// Bit mask of FPR field.
	USB1_PORTSC1_H_FPR_Msk = 0x40
	// Bit FPR.
	USB1_PORTSC1_H_FPR = 0x40
	// No resume (K-state) detected/driven on port.
	USB1_PORTSC1_H_FPR_NO_RESUME = 0x0
	// Resume detected/driven on port.
	USB1_PORTSC1_H_FPR_RESUME_DETECTED = 0x1
	// Position of SUSP field.
	USB1_PORTSC1_H_SUSP_Pos = 0x7
	// Bit mask of SUSP field.
	USB1_PORTSC1_H_SUSP_Msk = 0x80
	// Bit SUSP.
	USB1_PORTSC1_H_SUSP = 0x80
	// Port not in suspend state
	USB1_PORTSC1_H_SUSP_PORT_NOT_IN_SUSPEND_ = 0x0
	// Port in suspend state When in suspend state, downstream propagation of data is blocked on this port, except for port reset. The blocking occurs at the end of the current transaction if a transaction was in progress when this bit was written to 1. In the suspend state, the port is sensitive to resume detection. Note that the bit status does not change until the port is suspended and that there may be a delay in suspending a port if there is a transaction currently in progress on the USB.
	USB1_PORTSC1_H_SUSP_PORT_IN_SUSPEND_STAT = 0x1
	// Position of PR field.
	USB1_PORTSC1_H_PR_Pos = 0x8
	// Bit mask of PR field.
	USB1_PORTSC1_H_PR_Msk = 0x100
	// Bit PR.
	USB1_PORTSC1_H_PR = 0x100
	// Port is not in the reset state.
	USB1_PORTSC1_H_PR_NOT_IN_RESET = 0x0
	// Port is in the reset state.
	USB1_PORTSC1_H_PR_PORT_IS_IN_THE_RESET = 0x1
	// Position of HSP field.
	USB1_PORTSC1_H_HSP_Pos = 0x9
	// Bit mask of HSP field.
	USB1_PORTSC1_H_HSP_Msk = 0x200
	// Bit HSP.
	USB1_PORTSC1_H_HSP = 0x200
	// Host/device connected to the port is not in High-speed mode.
	USB1_PORTSC1_H_HSP_NOHIGHSPEED = 0x0
	// Host/device connected to the port is in High-speed mode.
	USB1_PORTSC1_H_HSP_HIGHSPEED = 0x1
	// Position of LS field.
	USB1_PORTSC1_H_LS_Pos = 0xa
	// Bit mask of LS field.
	USB1_PORTSC1_H_LS_Msk = 0xc00
	// SE0 (USB_DP and USB_DM LOW)
	USB1_PORTSC1_H_LS_SE0 = 0x0
	// J-state (USB_DP HIGH and USB_DM LOW)
	USB1_PORTSC1_H_LS_J_STATE = 0x1
	// K-state (USB_DP LOW and USB_DM HIGH)
	USB1_PORTSC1_H_LS_K_STATE = 0x2
	// Undefined
	USB1_PORTSC1_H_LS_UNDEFINED = 0x3
	// Position of PP field.
	USB1_PORTSC1_H_PP_Pos = 0xc
	// Bit mask of PP field.
	USB1_PORTSC1_H_PP_Msk = 0x1000
	// Bit PP.
	USB1_PORTSC1_H_PP = 0x1000
	// Port power off.
	USB1_PORTSC1_H_PP_PORT_POWER_OFF_ = 0x0
	// Port power on.
	USB1_PORTSC1_H_PP_PORT_POWER_ON_ = 0x1
	// Position of RESERVED field.
	USB1_PORTSC1_H_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USB1_PORTSC1_H_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USB1_PORTSC1_H_RESERVED = 0x2000
	// Position of PIC1_0 field.
	USB1_PORTSC1_H_PIC1_0_Pos = 0xe
	// Bit mask of PIC1_0 field.
	USB1_PORTSC1_H_PIC1_0_Msk = 0xc000
	// Port indicators are off.
	USB1_PORTSC1_H_PIC1_0_OFF = 0x0
	// Amber
	USB1_PORTSC1_H_PIC1_0_AMBER = 0x1
	// Green
	USB1_PORTSC1_H_PIC1_0_GREEN = 0x2
	// Undefined
	USB1_PORTSC1_H_PIC1_0_UNDEFINED = 0x3
	// Position of PTC3_0 field.
	USB1_PORTSC1_H_PTC3_0_Pos = 0x10
	// Bit mask of PTC3_0 field.
	USB1_PORTSC1_H_PTC3_0_Msk = 0xf0000
	// TEST_MODE_DISABLE
	USB1_PORTSC1_H_PTC3_0_TEST_MODE_DISABLE = 0x0
	// J_STATE
	USB1_PORTSC1_H_PTC3_0_J_STATE = 0x1
	// K_STATE
	USB1_PORTSC1_H_PTC3_0_K_STATE = 0x2
	// SE0 (host)/NAK (device)
	USB1_PORTSC1_H_PTC3_0_SE0_NAK = 0x3
	// Packet
	USB1_PORTSC1_H_PTC3_0_PACKET = 0x4
	// FORCE_ENABLE_HS
	USB1_PORTSC1_H_PTC3_0_FORCE_ENABLE_HS = 0x5
	// FORCE_ENABLE_FS
	USB1_PORTSC1_H_PTC3_0_FORCE_ENABLE_FS = 0x6
	// FORCE_ENABLE_LS
	USB1_PORTSC1_H_PTC3_0_FORCE_ENABLE_LS = 0x7
	// Position of WKCN field.
	USB1_PORTSC1_H_WKCN_Pos = 0x14
	// Bit mask of WKCN field.
	USB1_PORTSC1_H_WKCN_Msk = 0x100000
	// Bit WKCN.
	USB1_PORTSC1_H_WKCN = 0x100000
	// Disables the port to wake up on device connects.
	USB1_PORTSC1_H_WKCN_DISABLES_THE_PORT_TO = 0x0
	// Writing this bit to a one enables the port to be sensitive to device connects as wake-up events.
	USB1_PORTSC1_H_WKCN_ENABLE_DEVICE_CON = 0x1
	// Position of WKDC field.
	USB1_PORTSC1_H_WKDC_Pos = 0x15
	// Bit mask of WKDC field.
	USB1_PORTSC1_H_WKDC_Msk = 0x200000
	// Bit WKDC.
	USB1_PORTSC1_H_WKDC = 0x200000
	// Disables the port to wake up on device disconnects.
	USB1_PORTSC1_H_WKDC_DISABLES_THE_PORT_TO = 0x0
	// Writing this bit to a one enables the port to be sensitive to device disconnects as wake-up events.
	USB1_PORTSC1_H_WKDC_ENABLE_DEVICE_CON = 0x1
	// Position of WKOC field.
	USB1_PORTSC1_H_WKOC_Pos = 0x16
	// Bit mask of WKOC field.
	USB1_PORTSC1_H_WKOC_Msk = 0x400000
	// Bit WKOC.
	USB1_PORTSC1_H_WKOC = 0x400000
	// Disables the port to wake up on over-current events.
	USB1_PORTSC1_H_WKOC_DISABLES_OVERCURRENT = 0x0
	// Writing a one to this bit enabled the port to be sensitive to over-current conditions as wake-up events.
	USB1_PORTSC1_H_WKOC_ENABLE_OVERCURRENT = 0x1
	// Position of PHCD field.
	USB1_PORTSC1_H_PHCD_Pos = 0x17
	// Bit mask of PHCD field.
	USB1_PORTSC1_H_PHCD_Msk = 0x800000
	// Bit PHCD.
	USB1_PORTSC1_H_PHCD = 0x800000
	// Writing a 0 enables the PHY clock. Reading a 0 indicates the status of the PHY clock (enabled).
	USB1_PORTSC1_H_PHCD_ENABLE_PHY_CLK = 0x0
	// Writing a 1 disables the PHY clock. Reading a 1 indicates the status of the PHY clock (disabled).
	USB1_PORTSC1_H_PHCD_DISABLE_PHY_CLK = 0x1
	// Position of PFSC field.
	USB1_PORTSC1_H_PFSC_Pos = 0x18
	// Bit mask of PFSC field.
	USB1_PORTSC1_H_PFSC_Msk = 0x1000000
	// Bit PFSC.
	USB1_PORTSC1_H_PFSC = 0x1000000
	// Port connects at any speed.
	USB1_PORTSC1_H_PFSC_ANYSPEED = 0x0
	// Writing this bit to a 1 will force the port to only connect at Full Speed. It disables the chirp sequence that allows the port to identify itself as High Speed. This is useful for testing FS configurations with a HS host, hub or device.
	USB1_PORTSC1_H_PFSC_FULLSPEED = 0x1
	// Position of RESERVED field.
	USB1_PORTSC1_H_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	USB1_PORTSC1_H_RESERVED_Msk = 0x2000000
	// Bit RESERVED.
	USB1_PORTSC1_H_RESERVED = 0x2000000
	// Position of PSPD field.
	USB1_PORTSC1_H_PSPD_Pos = 0x1a
	// Bit mask of PSPD field.
	USB1_PORTSC1_H_PSPD_Msk = 0xc000000
	// Full-speed
	USB1_PORTSC1_H_PSPD_FULL_SPEED = 0x0
	// Low-speed
	USB1_PORTSC1_H_PSPD_LOW_SPEED = 0x1
	// High-speed
	USB1_PORTSC1_H_PSPD_HIGH_SPEED = 0x2
	// Position of RESERVED field.
	USB1_PORTSC1_H_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	USB1_PORTSC1_H_RESERVED_Msk = 0x30000000
	// Position of PTS field.
	USB1_PORTSC1_H_PTS_Pos = 0x1e
	// Bit mask of PTS field.
	USB1_PORTSC1_H_PTS_Msk = 0xc0000000
	// ULPI
	USB1_PORTSC1_H_PTS_ULPI = 0x2
	// Serial/ 1.1 PHY (Full-speed only)
	USB1_PORTSC1_H_PTS_SERIAL = 0x3

	// USBMODE_D: USB mode (device mode)
	// Position of CM1_0 field.
	USB1_USBMODE_D_CM1_0_Pos = 0x0
	// Bit mask of CM1_0 field.
	USB1_USBMODE_D_CM1_0_Msk = 0x3
	// Idle
	USB1_USBMODE_D_CM1_0_IDLE = 0x0
	// Device controller
	USB1_USBMODE_D_CM1_0_DEVICE_CONTROLLER = 0x2
	// Host controller
	USB1_USBMODE_D_CM1_0_HOST_CONTROLLER = 0x3
	// Position of ES field.
	USB1_USBMODE_D_ES_Pos = 0x2
	// Bit mask of ES field.
	USB1_USBMODE_D_ES_Msk = 0x4
	// Bit ES.
	USB1_USBMODE_D_ES = 0x4
	// Little endian: first byte referenced in least significant byte of 32-bit word.
	USB1_USBMODE_D_ES_LITTLE_ENDIAN_FIRST = 0x0
	// Big endian: first byte referenced in most significant byte of 32-bit word.
	USB1_USBMODE_D_ES_BIG_ENDIAN_FIRST_BY = 0x1
	// Position of SLOM field.
	USB1_USBMODE_D_SLOM_Pos = 0x3
	// Bit mask of SLOM field.
	USB1_USBMODE_D_SLOM_Msk = 0x8
	// Bit SLOM.
	USB1_USBMODE_D_SLOM = 0x8
	// Setup Lockouts on
	USB1_USBMODE_D_SLOM_SETUP_LOCKOUTS_ON = 0x0
	// Setup Lockouts Off (DCD requires the use of Setup Buffer Tripwire in USBCMD)
	USB1_USBMODE_D_SLOM_SETUP_LOCKOUTS_OFF = 0x1
	// Position of SDIS field.
	USB1_USBMODE_D_SDIS_Pos = 0x4
	// Bit mask of SDIS field.
	USB1_USBMODE_D_SDIS_Msk = 0x10
	// Bit SDIS.
	USB1_USBMODE_D_SDIS = 0x10
	// Not disabled
	USB1_USBMODE_D_SDIS_NOT_DISABLED = 0x0
	// Disabled. Setting this bit to one disables double priming on both RX and TX for low bandwidth systems. This mode ensures that when the RX and TX buffers are sufficient to contain an entire packet that the standard double buffering scheme is disabled to prevent overruns/underruns in bandwidth limited systems. Note: In High Speed Mode, all packets received will be responded to with a NYET handshake when stream disable is active.
	USB1_USBMODE_D_SDIS_DISABLED_SETTING_TH = 0x1
	// Position of RESERVED field.
	USB1_USBMODE_D_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB1_USBMODE_D_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USB1_USBMODE_D_RESERVED = 0x20
	// Position of RESERVED field.
	USB1_USBMODE_D_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB1_USBMODE_D_RESERVED_Msk = 0xffffffc0

	// USBMODE_H: USB mode (host mode)
	// Position of CM1_0 field.
	USB1_USBMODE_H_CM1_0_Pos = 0x0
	// Bit mask of CM1_0 field.
	USB1_USBMODE_H_CM1_0_Msk = 0x3
	// Idle
	USB1_USBMODE_H_CM1_0_IDLE = 0x0
	// Device controller
	USB1_USBMODE_H_CM1_0_DEVICE_CONTROLLER = 0x2
	// Host controller
	USB1_USBMODE_H_CM1_0_HOST_CONTROLLER = 0x3
	// Position of ES field.
	USB1_USBMODE_H_ES_Pos = 0x2
	// Bit mask of ES field.
	USB1_USBMODE_H_ES_Msk = 0x4
	// Bit ES.
	USB1_USBMODE_H_ES = 0x4
	// Little endian: first byte referenced in least significant byte of 32-bit word.
	USB1_USBMODE_H_ES_LITTLE_ENDIAN_FIRST = 0x0
	// Big endian: first byte referenced in most significant byte of 32-bit word.
	USB1_USBMODE_H_ES_BIG_ENDIAN_FIRST_BY = 0x1
	// Position of RESERVED field.
	USB1_USBMODE_H_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USB1_USBMODE_H_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USB1_USBMODE_H_RESERVED = 0x8
	// Position of SDIS field.
	USB1_USBMODE_H_SDIS_Pos = 0x4
	// Bit mask of SDIS field.
	USB1_USBMODE_H_SDIS_Msk = 0x10
	// Bit SDIS.
	USB1_USBMODE_H_SDIS = 0x10
	// Not disabled
	USB1_USBMODE_H_SDIS_NOT_DISABLED = 0x0
	// Disabled. Setting to a 1 ensures that overruns/underruns of the latency FIFO are eliminated for low bandwidth systems where the RX and TX buffers are sufficient to contain the entire packet. Enabling stream disable also has the effect of ensuring the the TX latency is filled to capacity before the packet is launched onto the USB. Note: Time duration to pre-fill the FIFO becomes significant when stream disable is active. See TXFILLTUNING to characterize the adjustments needed for the scheduler when using this feature.
	USB1_USBMODE_H_SDIS_DISABLED_SETTING_TO = 0x1
	// Position of VBPS field.
	USB1_USBMODE_H_VBPS_Pos = 0x5
	// Bit mask of VBPS field.
	USB1_USBMODE_H_VBPS_Msk = 0x20
	// Bit VBPS.
	USB1_USBMODE_H_VBPS = 0x20
	// vbus_pwr_select is set LOW.
	USB1_USBMODE_H_VBPS_LOW = 0x0
	// vbus_pwr_select is set HIGH
	USB1_USBMODE_H_VBPS_HIGH = 0x1
	// Position of RESERVED field.
	USB1_USBMODE_H_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB1_USBMODE_H_RESERVED_Msk = 0xffffffc0

	// ENDPTSETUPSTAT: Endpoint setup status
	// Position of ENDPTSETUPSTAT0 field.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Pos = 0x0
	// Bit mask of ENDPTSETUPSTAT0 field.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Msk = 0x1
	// Bit ENDPTSETUPSTAT0.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT0 = 0x1
	// Position of ENDPTSETUPSTAT1 field.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Pos = 0x1
	// Bit mask of ENDPTSETUPSTAT1 field.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Msk = 0x2
	// Bit ENDPTSETUPSTAT1.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT1 = 0x2
	// Position of ENDPTSETUPSTAT2 field.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Pos = 0x2
	// Bit mask of ENDPTSETUPSTAT2 field.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Msk = 0x4
	// Bit ENDPTSETUPSTAT2.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT2 = 0x4
	// Position of ENDPTSETUPSTAT3 field.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Pos = 0x3
	// Bit mask of ENDPTSETUPSTAT3 field.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Msk = 0x8
	// Bit ENDPTSETUPSTAT3.
	USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT3 = 0x8
	// Position of RESERVED field.
	USB1_ENDPTSETUPSTAT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_ENDPTSETUPSTAT_RESERVED_Msk = 0xfffffff0

	// ENDPTPRIME: Endpoint initialization
	// Position of PERB0 field.
	USB1_ENDPTPRIME_PERB0_Pos = 0x0
	// Bit mask of PERB0 field.
	USB1_ENDPTPRIME_PERB0_Msk = 0x1
	// Bit PERB0.
	USB1_ENDPTPRIME_PERB0 = 0x1
	// Position of PERB1 field.
	USB1_ENDPTPRIME_PERB1_Pos = 0x1
	// Bit mask of PERB1 field.
	USB1_ENDPTPRIME_PERB1_Msk = 0x2
	// Bit PERB1.
	USB1_ENDPTPRIME_PERB1 = 0x2
	// Position of PERB2 field.
	USB1_ENDPTPRIME_PERB2_Pos = 0x2
	// Bit mask of PERB2 field.
	USB1_ENDPTPRIME_PERB2_Msk = 0x4
	// Bit PERB2.
	USB1_ENDPTPRIME_PERB2 = 0x4
	// Position of PERB3 field.
	USB1_ENDPTPRIME_PERB3_Pos = 0x3
	// Bit mask of PERB3 field.
	USB1_ENDPTPRIME_PERB3_Msk = 0x8
	// Bit PERB3.
	USB1_ENDPTPRIME_PERB3 = 0x8
	// Position of RESERVED field.
	USB1_ENDPTPRIME_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_ENDPTPRIME_RESERVED_Msk = 0xfff0
	// Position of PETB0 field.
	USB1_ENDPTPRIME_PETB0_Pos = 0x10
	// Bit mask of PETB0 field.
	USB1_ENDPTPRIME_PETB0_Msk = 0x10000
	// Bit PETB0.
	USB1_ENDPTPRIME_PETB0 = 0x10000
	// Position of PETB1 field.
	USB1_ENDPTPRIME_PETB1_Pos = 0x11
	// Bit mask of PETB1 field.
	USB1_ENDPTPRIME_PETB1_Msk = 0x20000
	// Bit PETB1.
	USB1_ENDPTPRIME_PETB1 = 0x20000
	// Position of PETB2 field.
	USB1_ENDPTPRIME_PETB2_Pos = 0x12
	// Bit mask of PETB2 field.
	USB1_ENDPTPRIME_PETB2_Msk = 0x40000
	// Bit PETB2.
	USB1_ENDPTPRIME_PETB2 = 0x40000
	// Position of PETB3 field.
	USB1_ENDPTPRIME_PETB3_Pos = 0x13
	// Bit mask of PETB3 field.
	USB1_ENDPTPRIME_PETB3_Msk = 0x80000
	// Bit PETB3.
	USB1_ENDPTPRIME_PETB3 = 0x80000
	// Position of RESERVED field.
	USB1_ENDPTPRIME_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_ENDPTPRIME_RESERVED_Msk = 0xfff00000

	// ENDPTFLUSH: Endpoint de-initialization
	// Position of FERB0 field.
	USB1_ENDPTFLUSH_FERB0_Pos = 0x0
	// Bit mask of FERB0 field.
	USB1_ENDPTFLUSH_FERB0_Msk = 0x1
	// Bit FERB0.
	USB1_ENDPTFLUSH_FERB0 = 0x1
	// Position of FERB1 field.
	USB1_ENDPTFLUSH_FERB1_Pos = 0x1
	// Bit mask of FERB1 field.
	USB1_ENDPTFLUSH_FERB1_Msk = 0x2
	// Bit FERB1.
	USB1_ENDPTFLUSH_FERB1 = 0x2
	// Position of FERB2 field.
	USB1_ENDPTFLUSH_FERB2_Pos = 0x2
	// Bit mask of FERB2 field.
	USB1_ENDPTFLUSH_FERB2_Msk = 0x4
	// Bit FERB2.
	USB1_ENDPTFLUSH_FERB2 = 0x4
	// Position of FERB3 field.
	USB1_ENDPTFLUSH_FERB3_Pos = 0x3
	// Bit mask of FERB3 field.
	USB1_ENDPTFLUSH_FERB3_Msk = 0x8
	// Bit FERB3.
	USB1_ENDPTFLUSH_FERB3 = 0x8
	// Position of RESERVED field.
	USB1_ENDPTFLUSH_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_ENDPTFLUSH_RESERVED_Msk = 0xfff0
	// Position of FETB0 field.
	USB1_ENDPTFLUSH_FETB0_Pos = 0x10
	// Bit mask of FETB0 field.
	USB1_ENDPTFLUSH_FETB0_Msk = 0x10000
	// Bit FETB0.
	USB1_ENDPTFLUSH_FETB0 = 0x10000
	// Position of FETB1 field.
	USB1_ENDPTFLUSH_FETB1_Pos = 0x11
	// Bit mask of FETB1 field.
	USB1_ENDPTFLUSH_FETB1_Msk = 0x20000
	// Bit FETB1.
	USB1_ENDPTFLUSH_FETB1 = 0x20000
	// Position of FETB2 field.
	USB1_ENDPTFLUSH_FETB2_Pos = 0x12
	// Bit mask of FETB2 field.
	USB1_ENDPTFLUSH_FETB2_Msk = 0x40000
	// Bit FETB2.
	USB1_ENDPTFLUSH_FETB2 = 0x40000
	// Position of FETB3 field.
	USB1_ENDPTFLUSH_FETB3_Pos = 0x13
	// Bit mask of FETB3 field.
	USB1_ENDPTFLUSH_FETB3_Msk = 0x80000
	// Bit FETB3.
	USB1_ENDPTFLUSH_FETB3 = 0x80000
	// Position of RESERVED field.
	USB1_ENDPTFLUSH_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_ENDPTFLUSH_RESERVED_Msk = 0xfff00000

	// ENDPTSTAT: Endpoint status
	// Position of ERBR0 field.
	USB1_ENDPTSTAT_ERBR0_Pos = 0x0
	// Bit mask of ERBR0 field.
	USB1_ENDPTSTAT_ERBR0_Msk = 0x1
	// Bit ERBR0.
	USB1_ENDPTSTAT_ERBR0 = 0x1
	// Position of ERBR1 field.
	USB1_ENDPTSTAT_ERBR1_Pos = 0x1
	// Bit mask of ERBR1 field.
	USB1_ENDPTSTAT_ERBR1_Msk = 0x2
	// Bit ERBR1.
	USB1_ENDPTSTAT_ERBR1 = 0x2
	// Position of ERBR2 field.
	USB1_ENDPTSTAT_ERBR2_Pos = 0x2
	// Bit mask of ERBR2 field.
	USB1_ENDPTSTAT_ERBR2_Msk = 0x4
	// Bit ERBR2.
	USB1_ENDPTSTAT_ERBR2 = 0x4
	// Position of ERBR3 field.
	USB1_ENDPTSTAT_ERBR3_Pos = 0x3
	// Bit mask of ERBR3 field.
	USB1_ENDPTSTAT_ERBR3_Msk = 0x8
	// Bit ERBR3.
	USB1_ENDPTSTAT_ERBR3 = 0x8
	// Position of RESERVED field.
	USB1_ENDPTSTAT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_ENDPTSTAT_RESERVED_Msk = 0xfff0
	// Position of ETBR0 field.
	USB1_ENDPTSTAT_ETBR0_Pos = 0x10
	// Bit mask of ETBR0 field.
	USB1_ENDPTSTAT_ETBR0_Msk = 0x10000
	// Bit ETBR0.
	USB1_ENDPTSTAT_ETBR0 = 0x10000
	// Position of ETBR1 field.
	USB1_ENDPTSTAT_ETBR1_Pos = 0x11
	// Bit mask of ETBR1 field.
	USB1_ENDPTSTAT_ETBR1_Msk = 0x20000
	// Bit ETBR1.
	USB1_ENDPTSTAT_ETBR1 = 0x20000
	// Position of ETBR2 field.
	USB1_ENDPTSTAT_ETBR2_Pos = 0x12
	// Bit mask of ETBR2 field.
	USB1_ENDPTSTAT_ETBR2_Msk = 0x40000
	// Bit ETBR2.
	USB1_ENDPTSTAT_ETBR2 = 0x40000
	// Position of ETBR3 field.
	USB1_ENDPTSTAT_ETBR3_Pos = 0x13
	// Bit mask of ETBR3 field.
	USB1_ENDPTSTAT_ETBR3_Msk = 0x80000
	// Bit ETBR3.
	USB1_ENDPTSTAT_ETBR3 = 0x80000
	// Position of RESERVED field.
	USB1_ENDPTSTAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_ENDPTSTAT_RESERVED_Msk = 0xfff00000

	// ENDPTCOMPLETE: Endpoint complete
	// Position of ERCE0 field.
	USB1_ENDPTCOMPLETE_ERCE0_Pos = 0x0
	// Bit mask of ERCE0 field.
	USB1_ENDPTCOMPLETE_ERCE0_Msk = 0x1
	// Bit ERCE0.
	USB1_ENDPTCOMPLETE_ERCE0 = 0x1
	// Position of ERCE1 field.
	USB1_ENDPTCOMPLETE_ERCE1_Pos = 0x1
	// Bit mask of ERCE1 field.
	USB1_ENDPTCOMPLETE_ERCE1_Msk = 0x2
	// Bit ERCE1.
	USB1_ENDPTCOMPLETE_ERCE1 = 0x2
	// Position of ERCE2 field.
	USB1_ENDPTCOMPLETE_ERCE2_Pos = 0x2
	// Bit mask of ERCE2 field.
	USB1_ENDPTCOMPLETE_ERCE2_Msk = 0x4
	// Bit ERCE2.
	USB1_ENDPTCOMPLETE_ERCE2 = 0x4
	// Position of ERCE3 field.
	USB1_ENDPTCOMPLETE_ERCE3_Pos = 0x3
	// Bit mask of ERCE3 field.
	USB1_ENDPTCOMPLETE_ERCE3_Msk = 0x8
	// Bit ERCE3.
	USB1_ENDPTCOMPLETE_ERCE3 = 0x8
	// Position of RESERVED field.
	USB1_ENDPTCOMPLETE_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_ENDPTCOMPLETE_RESERVED_Msk = 0xfff0
	// Position of ETCE0 field.
	USB1_ENDPTCOMPLETE_ETCE0_Pos = 0x10
	// Bit mask of ETCE0 field.
	USB1_ENDPTCOMPLETE_ETCE0_Msk = 0x10000
	// Bit ETCE0.
	USB1_ENDPTCOMPLETE_ETCE0 = 0x10000
	// Position of ETCE1 field.
	USB1_ENDPTCOMPLETE_ETCE1_Pos = 0x11
	// Bit mask of ETCE1 field.
	USB1_ENDPTCOMPLETE_ETCE1_Msk = 0x20000
	// Bit ETCE1.
	USB1_ENDPTCOMPLETE_ETCE1 = 0x20000
	// Position of ETCE2 field.
	USB1_ENDPTCOMPLETE_ETCE2_Pos = 0x12
	// Bit mask of ETCE2 field.
	USB1_ENDPTCOMPLETE_ETCE2_Msk = 0x40000
	// Bit ETCE2.
	USB1_ENDPTCOMPLETE_ETCE2 = 0x40000
	// Position of ETCE3 field.
	USB1_ENDPTCOMPLETE_ETCE3_Pos = 0x13
	// Bit mask of ETCE3 field.
	USB1_ENDPTCOMPLETE_ETCE3_Msk = 0x80000
	// Bit ETCE3.
	USB1_ENDPTCOMPLETE_ETCE3 = 0x80000
	// Position of RESERVED field.
	USB1_ENDPTCOMPLETE_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_ENDPTCOMPLETE_RESERVED_Msk = 0xfff00000

	// ENDPTCTRL0: Endpoint control 0
	// Position of RXS field.
	USB1_ENDPTCTRL0_RXS_Pos = 0x0
	// Bit mask of RXS field.
	USB1_ENDPTCTRL0_RXS_Msk = 0x1
	// Bit RXS.
	USB1_ENDPTCTRL0_RXS = 0x1
	// Endpoint ok.
	USB1_ENDPTCTRL0_RXS_ENDPOINT_OK_ = 0x0
	// Endpoint stalled Software can write a one to this bit to force the endpoint to return a STALL handshake to the Host. It will continue returning STALL until the bit is cleared by software, or it will automatically be cleared upon receipt of a new SETUP request. After receiving a SETUP request, this bit will continue to be cleared by hardware until the associated ENDSETUPSTAT bit is cleared.[1]
	USB1_ENDPTCTRL0_RXS_ENDPOINT_STALLED_SOF = 0x1
	// Position of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USB1_ENDPTCTRL0_RESERVED = 0x2
	// Position of RXT field.
	USB1_ENDPTCTRL0_RXT_Pos = 0x2
	// Bit mask of RXT field.
	USB1_ENDPTCTRL0_RXT_Msk = 0xc
	// Position of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Msk = 0x70
	// Position of RXE field.
	USB1_ENDPTCTRL0_RXE_Pos = 0x7
	// Bit mask of RXE field.
	USB1_ENDPTCTRL0_RXE_Msk = 0x80
	// Bit RXE.
	USB1_ENDPTCTRL0_RXE = 0x80
	// Position of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Msk = 0xff00
	// Position of TXS field.
	USB1_ENDPTCTRL0_TXS_Pos = 0x10
	// Bit mask of TXS field.
	USB1_ENDPTCTRL0_TXS_Msk = 0x10000
	// Bit TXS.
	USB1_ENDPTCTRL0_TXS = 0x10000
	// Endpoint ok.
	USB1_ENDPTCTRL0_TXS_ENDPOINT_OK_ = 0x0
	// Endpoint stalled Software can write a one to this bit to force the endpoint to return a STALL handshake to the Host. It will continue returning STALL until the bit is cleared by software, or it will automatically be cleared upon receipt of a new SETUP request. After receiving a SETUP request, this bit will continue to be cleared by hardware until the associated ENDSETUPSTAT bit is cleared.[1]
	USB1_ENDPTCTRL0_TXS_ENDPOINT_STALLED_SOF = 0x1
	// Position of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB1_ENDPTCTRL0_RESERVED = 0x20000
	// Position of TXT field.
	USB1_ENDPTCTRL0_TXT_Pos = 0x12
	// Bit mask of TXT field.
	USB1_ENDPTCTRL0_TXT_Msk = 0xc0000
	// Position of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Msk = 0x700000
	// Position of TXE field.
	USB1_ENDPTCTRL0_TXE_Pos = 0x17
	// Bit mask of TXE field.
	USB1_ENDPTCTRL0_TXE_Msk = 0x800000
	// Bit TXE.
	USB1_ENDPTCTRL0_TXE = 0x800000
	// Position of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL0_RESERVED_Msk = 0xff000000

	// ENDPTCTRL1: Endpoint control
	// Position of RXS field.
	USB1_ENDPTCTRL_RXS_Pos = 0x0
	// Bit mask of RXS field.
	USB1_ENDPTCTRL_RXS_Msk = 0x1
	// Bit RXS.
	USB1_ENDPTCTRL_RXS = 0x1
	// Endpoint ok. This bit will be cleared automatically upon receipt of a SETUP request if this Endpoint is configured as a Control Endpoint and this bit will continue to be cleared by hardware until the associated ENDPTSETUPSTAT bit is cleared.
	USB1_ENDPTCTRL_RXS_ENDPOINT_OK_THIS_BI = 0x0
	// Endpoint stalled Software can write a one to this bit to force the endpoint to return a STALL handshake to the Host. It will continue returning STALL until the bit is cleared by software, or it will automatically be cleared upon receipt of a new SETUP request.[1]
	USB1_ENDPTCTRL_RXS_ENDPOINT_STALLED_SOF = 0x1
	// Position of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USB1_ENDPTCTRL_RESERVED = 0x2
	// Position of RXT field.
	USB1_ENDPTCTRL_RXT_Pos = 0x2
	// Bit mask of RXT field.
	USB1_ENDPTCTRL_RXT_Msk = 0xc
	// Control
	USB1_ENDPTCTRL_RXT_CONTROL = 0x0
	// Isochronous
	USB1_ENDPTCTRL_RXT_ISOCHRONOUS = 0x1
	// Bulk
	USB1_ENDPTCTRL_RXT_BULK = 0x2
	// Position of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USB1_ENDPTCTRL_RESERVED = 0x10
	// Position of RXI field.
	USB1_ENDPTCTRL_RXI_Pos = 0x5
	// Bit mask of RXI field.
	USB1_ENDPTCTRL_RXI_Msk = 0x20
	// Bit RXI.
	USB1_ENDPTCTRL_RXI = 0x20
	// Disabled
	USB1_ENDPTCTRL_RXI_DISABLED = 0x0
	// Enabled
	USB1_ENDPTCTRL_RXI_ENABLED = 0x1
	// Position of RXR field.
	USB1_ENDPTCTRL_RXR_Pos = 0x6
	// Bit mask of RXR field.
	USB1_ENDPTCTRL_RXR_Msk = 0x40
	// Bit RXR.
	USB1_ENDPTCTRL_RXR = 0x40
	// Position of RXE field.
	USB1_ENDPTCTRL_RXE_Pos = 0x7
	// Bit mask of RXE field.
	USB1_ENDPTCTRL_RXE_Msk = 0x80
	// Bit RXE.
	USB1_ENDPTCTRL_RXE = 0x80
	// Endpoint disabled.
	USB1_ENDPTCTRL_RXE_ENDPOINT_DISABLED_ = 0x0
	// Endpoint enabled.
	USB1_ENDPTCTRL_RXE_ENDPOINT_ENABLED_ = 0x1
	// Position of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Msk = 0xff00
	// Position of TXS field.
	USB1_ENDPTCTRL_TXS_Pos = 0x10
	// Bit mask of TXS field.
	USB1_ENDPTCTRL_TXS_Msk = 0x10000
	// Bit TXS.
	USB1_ENDPTCTRL_TXS = 0x10000
	// Endpoint ok. This bit will be cleared automatically upon receipt of a SETUP request if this Endpoint is configured as a Control Endpoint, and this bit will continue to be cleared by hardware until the associated ENDPTSETUPSTAT bit is cleared.
	USB1_ENDPTCTRL_TXS_ENDPOINT_OK_THIS_BI = 0x0
	// Endpoint stalled Software can write a one to this bit to force the endpoint to return a STALL handshake to the Host. It will continue returning STALL until the bit is cleared by software, or it will automatically be cleared upon receipt of a new SETUP request.[1]
	USB1_ENDPTCTRL_TXS_ENDPOINT_STALLED_SOF = 0x1
	// Position of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USB1_ENDPTCTRL_RESERVED = 0x20000
	// Position of TXT field.
	USB1_ENDPTCTRL_TXT_Pos = 0x12
	// Bit mask of TXT field.
	USB1_ENDPTCTRL_TXT_Msk = 0xc0000
	// Control
	USB1_ENDPTCTRL_TXT_CONTROL = 0x0
	// Isochronous
	USB1_ENDPTCTRL_TXT_ISOCHRONOUS = 0x1
	// Bulk
	USB1_ENDPTCTRL_TXT_BULK = 0x2
	// Interrupt
	USB1_ENDPTCTRL_TXT_INTERRUPT = 0x3
	// Position of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Msk = 0x100000
	// Bit RESERVED.
	USB1_ENDPTCTRL_RESERVED = 0x100000
	// Position of TXI field.
	USB1_ENDPTCTRL_TXI_Pos = 0x15
	// Bit mask of TXI field.
	USB1_ENDPTCTRL_TXI_Msk = 0x200000
	// Bit TXI.
	USB1_ENDPTCTRL_TXI = 0x200000
	// Enabled
	USB1_ENDPTCTRL_TXI_ENABLED = 0x0
	// Disabled
	USB1_ENDPTCTRL_TXI_DISABLED = 0x1
	// Position of TXR field.
	USB1_ENDPTCTRL_TXR_Pos = 0x16
	// Bit mask of TXR field.
	USB1_ENDPTCTRL_TXR_Msk = 0x400000
	// Bit TXR.
	USB1_ENDPTCTRL_TXR = 0x400000
	// Position of TXE field.
	USB1_ENDPTCTRL_TXE_Pos = 0x17
	// Bit mask of TXE field.
	USB1_ENDPTCTRL_TXE_Msk = 0x800000
	// Bit TXE.
	USB1_ENDPTCTRL_TXE = 0x800000
	// Endpoint disabled.
	USB1_ENDPTCTRL_TXE_ENDPOINT_DISABLED_ = 0x0
	// Endpoint enabled.
	USB1_ENDPTCTRL_TXE_ENDPOINT_ENABLED_ = 0x1
	// Position of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB1_ENDPTCTRL_RESERVED_Msk = 0xff000000
)

// Bitfields for LCD: LCD controller
const (
	// TIMH: Horizontal Timing Control register
	// Position of RESERVED field.
	LCD_TIMH_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_TIMH_RESERVED_Msk = 0x3
	// Position of PPL field.
	LCD_TIMH_PPL_Pos = 0x2
	// Bit mask of PPL field.
	LCD_TIMH_PPL_Msk = 0xfc
	// Position of HSW field.
	LCD_TIMH_HSW_Pos = 0x8
	// Bit mask of HSW field.
	LCD_TIMH_HSW_Msk = 0xff00
	// Position of HFP field.
	LCD_TIMH_HFP_Pos = 0x10
	// Bit mask of HFP field.
	LCD_TIMH_HFP_Msk = 0xff0000
	// Position of HBP field.
	LCD_TIMH_HBP_Pos = 0x18
	// Bit mask of HBP field.
	LCD_TIMH_HBP_Msk = 0xff000000

	// TIMV: Vertical Timing Control register
	// Position of LPP field.
	LCD_TIMV_LPP_Pos = 0x0
	// Bit mask of LPP field.
	LCD_TIMV_LPP_Msk = 0x3ff
	// Position of VSW field.
	LCD_TIMV_VSW_Pos = 0xa
	// Bit mask of VSW field.
	LCD_TIMV_VSW_Msk = 0xfc00
	// Position of VFP field.
	LCD_TIMV_VFP_Pos = 0x10
	// Bit mask of VFP field.
	LCD_TIMV_VFP_Msk = 0xff0000
	// Position of VBP field.
	LCD_TIMV_VBP_Pos = 0x18
	// Bit mask of VBP field.
	LCD_TIMV_VBP_Msk = 0xff000000

	// POL: Clock and Signal Polarity Control register
	// Position of PCD_LO field.
	LCD_POL_PCD_LO_Pos = 0x0
	// Bit mask of PCD_LO field.
	LCD_POL_PCD_LO_Msk = 0x1f
	// Position of CLKSEL field.
	LCD_POL_CLKSEL_Pos = 0x5
	// Bit mask of CLKSEL field.
	LCD_POL_CLKSEL_Msk = 0x20
	// Bit CLKSEL.
	LCD_POL_CLKSEL = 0x20
	// Position of ACB field.
	LCD_POL_ACB_Pos = 0x6
	// Bit mask of ACB field.
	LCD_POL_ACB_Msk = 0x7c0
	// Position of IVS field.
	LCD_POL_IVS_Pos = 0xb
	// Bit mask of IVS field.
	LCD_POL_IVS_Msk = 0x800
	// Bit IVS.
	LCD_POL_IVS = 0x800
	// Position of IHS field.
	LCD_POL_IHS_Pos = 0xc
	// Bit mask of IHS field.
	LCD_POL_IHS_Msk = 0x1000
	// Bit IHS.
	LCD_POL_IHS = 0x1000
	// Position of IPC field.
	LCD_POL_IPC_Pos = 0xd
	// Bit mask of IPC field.
	LCD_POL_IPC_Msk = 0x2000
	// Bit IPC.
	LCD_POL_IPC = 0x2000
	// Position of IOE field.
	LCD_POL_IOE_Pos = 0xe
	// Bit mask of IOE field.
	LCD_POL_IOE_Msk = 0x4000
	// Bit IOE.
	LCD_POL_IOE = 0x4000
	// Position of RESERVED field.
	LCD_POL_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	LCD_POL_RESERVED_Msk = 0x8000
	// Bit RESERVED.
	LCD_POL_RESERVED = 0x8000
	// Position of CPL field.
	LCD_POL_CPL_Pos = 0x10
	// Bit mask of CPL field.
	LCD_POL_CPL_Msk = 0x3ff0000
	// Position of BCD field.
	LCD_POL_BCD_Pos = 0x1a
	// Bit mask of BCD field.
	LCD_POL_BCD_Msk = 0x4000000
	// Bit BCD.
	LCD_POL_BCD = 0x4000000
	// Position of PCD_HI field.
	LCD_POL_PCD_HI_Pos = 0x1b
	// Bit mask of PCD_HI field.
	LCD_POL_PCD_HI_Msk = 0xf8000000

	// LE: Line End Control register
	// Position of LED field.
	LCD_LE_LED_Pos = 0x0
	// Bit mask of LED field.
	LCD_LE_LED_Msk = 0x7f
	// Position of RESERVED field.
	LCD_LE_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	LCD_LE_RESERVED_Msk = 0xff80
	// Position of LEE field.
	LCD_LE_LEE_Pos = 0x10
	// Bit mask of LEE field.
	LCD_LE_LEE_Msk = 0x10000
	// Bit LEE.
	LCD_LE_LEE = 0x10000
	// Position of RESERVED field.
	LCD_LE_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	LCD_LE_RESERVED_Msk = 0xfffe0000

	// UPBASE: Upper Panel Frame Base Address register
	// Position of RESERVED field.
	LCD_UPBASE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_UPBASE_RESERVED_Msk = 0x7
	// Position of LCDUPBASE field.
	LCD_UPBASE_LCDUPBASE_Pos = 0x3
	// Bit mask of LCDUPBASE field.
	LCD_UPBASE_LCDUPBASE_Msk = 0xfffffff8

	// LPBASE: Lower Panel Frame Base Address register
	// Position of RESERVED field.
	LCD_LPBASE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_LPBASE_RESERVED_Msk = 0x7
	// Position of LCDLPBASE field.
	LCD_LPBASE_LCDLPBASE_Pos = 0x3
	// Bit mask of LCDLPBASE field.
	LCD_LPBASE_LCDLPBASE_Msk = 0xfffffff8

	// CTRL: LCD Control register
	// Position of LCDEN field.
	LCD_CTRL_LCDEN_Pos = 0x0
	// Bit mask of LCDEN field.
	LCD_CTRL_LCDEN_Msk = 0x1
	// Bit LCDEN.
	LCD_CTRL_LCDEN = 0x1
	// Position of LCDBPP field.
	LCD_CTRL_LCDBPP_Pos = 0x1
	// Bit mask of LCDBPP field.
	LCD_CTRL_LCDBPP_Msk = 0xe
	// Position of LCDBW field.
	LCD_CTRL_LCDBW_Pos = 0x4
	// Bit mask of LCDBW field.
	LCD_CTRL_LCDBW_Msk = 0x10
	// Bit LCDBW.
	LCD_CTRL_LCDBW = 0x10
	// Position of LCDTFT field.
	LCD_CTRL_LCDTFT_Pos = 0x5
	// Bit mask of LCDTFT field.
	LCD_CTRL_LCDTFT_Msk = 0x20
	// Bit LCDTFT.
	LCD_CTRL_LCDTFT = 0x20
	// Position of LCDMONO8 field.
	LCD_CTRL_LCDMONO8_Pos = 0x6
	// Bit mask of LCDMONO8 field.
	LCD_CTRL_LCDMONO8_Msk = 0x40
	// Bit LCDMONO8.
	LCD_CTRL_LCDMONO8 = 0x40
	// Position of LCDDUAL field.
	LCD_CTRL_LCDDUAL_Pos = 0x7
	// Bit mask of LCDDUAL field.
	LCD_CTRL_LCDDUAL_Msk = 0x80
	// Bit LCDDUAL.
	LCD_CTRL_LCDDUAL = 0x80
	// Position of BGR field.
	LCD_CTRL_BGR_Pos = 0x8
	// Bit mask of BGR field.
	LCD_CTRL_BGR_Msk = 0x100
	// Bit BGR.
	LCD_CTRL_BGR = 0x100
	// Position of BEBO field.
	LCD_CTRL_BEBO_Pos = 0x9
	// Bit mask of BEBO field.
	LCD_CTRL_BEBO_Msk = 0x200
	// Bit BEBO.
	LCD_CTRL_BEBO = 0x200
	// Position of BEPO field.
	LCD_CTRL_BEPO_Pos = 0xa
	// Bit mask of BEPO field.
	LCD_CTRL_BEPO_Msk = 0x400
	// Bit BEPO.
	LCD_CTRL_BEPO = 0x400
	// Position of LCDPWR field.
	LCD_CTRL_LCDPWR_Pos = 0xb
	// Bit mask of LCDPWR field.
	LCD_CTRL_LCDPWR_Msk = 0x800
	// Bit LCDPWR.
	LCD_CTRL_LCDPWR = 0x800
	// Position of LCDVCOMP field.
	LCD_CTRL_LCDVCOMP_Pos = 0xc
	// Bit mask of LCDVCOMP field.
	LCD_CTRL_LCDVCOMP_Msk = 0x3000
	// Position of RESERVED field.
	LCD_CTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	LCD_CTRL_RESERVED_Msk = 0xc000
	// Position of WATERMARK field.
	LCD_CTRL_WATERMARK_Pos = 0x10
	// Bit mask of WATERMARK field.
	LCD_CTRL_WATERMARK_Msk = 0x10000
	// Bit WATERMARK.
	LCD_CTRL_WATERMARK = 0x10000
	// Position of RESERVED field.
	LCD_CTRL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	LCD_CTRL_RESERVED_Msk = 0xfffe0000

	// INTMSK: Interrupt Mask register
	// Position of RESERVED field.
	LCD_INTMSK_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_INTMSK_RESERVED_Msk = 0x1
	// Bit RESERVED.
	LCD_INTMSK_RESERVED = 0x1
	// Position of FUFIM field.
	LCD_INTMSK_FUFIM_Pos = 0x1
	// Bit mask of FUFIM field.
	LCD_INTMSK_FUFIM_Msk = 0x2
	// Bit FUFIM.
	LCD_INTMSK_FUFIM = 0x2
	// Position of LNBUIM field.
	LCD_INTMSK_LNBUIM_Pos = 0x2
	// Bit mask of LNBUIM field.
	LCD_INTMSK_LNBUIM_Msk = 0x4
	// Bit LNBUIM.
	LCD_INTMSK_LNBUIM = 0x4
	// Position of VCOMPIM field.
	LCD_INTMSK_VCOMPIM_Pos = 0x3
	// Bit mask of VCOMPIM field.
	LCD_INTMSK_VCOMPIM_Msk = 0x8
	// Bit VCOMPIM.
	LCD_INTMSK_VCOMPIM = 0x8
	// Position of BERIM field.
	LCD_INTMSK_BERIM_Pos = 0x4
	// Bit mask of BERIM field.
	LCD_INTMSK_BERIM_Msk = 0x10
	// Bit BERIM.
	LCD_INTMSK_BERIM = 0x10
	// Position of RESERVED field.
	LCD_INTMSK_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	LCD_INTMSK_RESERVED_Msk = 0xffffffe0

	// INTRAW: Raw Interrupt Status register
	// Position of RESERVED field.
	LCD_INTRAW_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_INTRAW_RESERVED_Msk = 0x1
	// Bit RESERVED.
	LCD_INTRAW_RESERVED = 0x1
	// Position of FUFRIS field.
	LCD_INTRAW_FUFRIS_Pos = 0x1
	// Bit mask of FUFRIS field.
	LCD_INTRAW_FUFRIS_Msk = 0x2
	// Bit FUFRIS.
	LCD_INTRAW_FUFRIS = 0x2
	// Position of LNBURIS field.
	LCD_INTRAW_LNBURIS_Pos = 0x2
	// Bit mask of LNBURIS field.
	LCD_INTRAW_LNBURIS_Msk = 0x4
	// Bit LNBURIS.
	LCD_INTRAW_LNBURIS = 0x4
	// Position of VCOMPRIS field.
	LCD_INTRAW_VCOMPRIS_Pos = 0x3
	// Bit mask of VCOMPRIS field.
	LCD_INTRAW_VCOMPRIS_Msk = 0x8
	// Bit VCOMPRIS.
	LCD_INTRAW_VCOMPRIS = 0x8
	// Position of BERRAW field.
	LCD_INTRAW_BERRAW_Pos = 0x4
	// Bit mask of BERRAW field.
	LCD_INTRAW_BERRAW_Msk = 0x10
	// Bit BERRAW.
	LCD_INTRAW_BERRAW = 0x10
	// Position of RESERVED field.
	LCD_INTRAW_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	LCD_INTRAW_RESERVED_Msk = 0xffffffe0

	// INTSTAT: Masked Interrupt Status register
	// Position of RESERVED field.
	LCD_INTSTAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_INTSTAT_RESERVED_Msk = 0x1
	// Bit RESERVED.
	LCD_INTSTAT_RESERVED = 0x1
	// Position of FUFMIS field.
	LCD_INTSTAT_FUFMIS_Pos = 0x1
	// Bit mask of FUFMIS field.
	LCD_INTSTAT_FUFMIS_Msk = 0x2
	// Bit FUFMIS.
	LCD_INTSTAT_FUFMIS = 0x2
	// Position of LNBUMIS field.
	LCD_INTSTAT_LNBUMIS_Pos = 0x2
	// Bit mask of LNBUMIS field.
	LCD_INTSTAT_LNBUMIS_Msk = 0x4
	// Bit LNBUMIS.
	LCD_INTSTAT_LNBUMIS = 0x4
	// Position of VCOMPMIS field.
	LCD_INTSTAT_VCOMPMIS_Pos = 0x3
	// Bit mask of VCOMPMIS field.
	LCD_INTSTAT_VCOMPMIS_Msk = 0x8
	// Bit VCOMPMIS.
	LCD_INTSTAT_VCOMPMIS = 0x8
	// Position of BERMIS field.
	LCD_INTSTAT_BERMIS_Pos = 0x4
	// Bit mask of BERMIS field.
	LCD_INTSTAT_BERMIS_Msk = 0x10
	// Bit BERMIS.
	LCD_INTSTAT_BERMIS = 0x10
	// Position of RESERVED field.
	LCD_INTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	LCD_INTSTAT_RESERVED_Msk = 0xffffffe0

	// INTCLR: Interrupt Clear register
	// Position of RESERVED field.
	LCD_INTCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_INTCLR_RESERVED_Msk = 0x1
	// Bit RESERVED.
	LCD_INTCLR_RESERVED = 0x1
	// Position of FUFIC field.
	LCD_INTCLR_FUFIC_Pos = 0x1
	// Bit mask of FUFIC field.
	LCD_INTCLR_FUFIC_Msk = 0x2
	// Bit FUFIC.
	LCD_INTCLR_FUFIC = 0x2
	// Position of LNBUIC field.
	LCD_INTCLR_LNBUIC_Pos = 0x2
	// Bit mask of LNBUIC field.
	LCD_INTCLR_LNBUIC_Msk = 0x4
	// Bit LNBUIC.
	LCD_INTCLR_LNBUIC = 0x4
	// Position of VCOMPIC field.
	LCD_INTCLR_VCOMPIC_Pos = 0x3
	// Bit mask of VCOMPIC field.
	LCD_INTCLR_VCOMPIC_Msk = 0x8
	// Bit VCOMPIC.
	LCD_INTCLR_VCOMPIC = 0x8
	// Position of BERIC field.
	LCD_INTCLR_BERIC_Pos = 0x4
	// Bit mask of BERIC field.
	LCD_INTCLR_BERIC_Msk = 0x10
	// Bit BERIC.
	LCD_INTCLR_BERIC = 0x10
	// Position of RESERVED field.
	LCD_INTCLR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	LCD_INTCLR_RESERVED_Msk = 0xffffffe0

	// UPCURR: Upper Panel Current Address Value register
	// Position of LCDUPCURR field.
	LCD_UPCURR_LCDUPCURR_Pos = 0x0
	// Bit mask of LCDUPCURR field.
	LCD_UPCURR_LCDUPCURR_Msk = 0xffffffff

	// LPCURR: Lower Panel Current Address Value register
	// Position of LCDLPCURR field.
	LCD_LPCURR_LCDLPCURR_Pos = 0x0
	// Bit mask of LCDLPCURR field.
	LCD_LPCURR_LCDLPCURR_Msk = 0xffffffff

	// PAL: 256x16-bit Color Palette registers
	// Position of R04_0 field.
	LCD_PAL_R04_0_Pos = 0x0
	// Bit mask of R04_0 field.
	LCD_PAL_R04_0_Msk = 0x1f
	// Position of G04_0 field.
	LCD_PAL_G04_0_Pos = 0x5
	// Bit mask of G04_0 field.
	LCD_PAL_G04_0_Msk = 0x3e0
	// Position of B04_0 field.
	LCD_PAL_B04_0_Pos = 0xa
	// Bit mask of B04_0 field.
	LCD_PAL_B04_0_Msk = 0x7c00
	// Position of I0 field.
	LCD_PAL_I0_Pos = 0xf
	// Bit mask of I0 field.
	LCD_PAL_I0_Msk = 0x8000
	// Bit I0.
	LCD_PAL_I0 = 0x8000
	// Position of R14_0 field.
	LCD_PAL_R14_0_Pos = 0x10
	// Bit mask of R14_0 field.
	LCD_PAL_R14_0_Msk = 0x1f0000
	// Position of G14_0 field.
	LCD_PAL_G14_0_Pos = 0x15
	// Bit mask of G14_0 field.
	LCD_PAL_G14_0_Msk = 0x3e00000
	// Position of B14_0 field.
	LCD_PAL_B14_0_Pos = 0x1a
	// Bit mask of B14_0 field.
	LCD_PAL_B14_0_Msk = 0x7c000000
	// Position of I1 field.
	LCD_PAL_I1_Pos = 0x1f
	// Bit mask of I1 field.
	LCD_PAL_I1_Msk = 0x80000000
	// Bit I1.
	LCD_PAL_I1 = 0x80000000

	// CRSR_IMG: Cursor Image registers
	// Position of CRSR_IMG field.
	LCD_CRSR_IMG_CRSR_IMG_Pos = 0x0
	// Bit mask of CRSR_IMG field.
	LCD_CRSR_IMG_CRSR_IMG_Msk = 0xffffffff

	// CRSR_CTRL: Cursor Control register
	// Position of CrsrOn field.
	LCD_CRSR_CTRL_CrsrOn_Pos = 0x0
	// Bit mask of CrsrOn field.
	LCD_CRSR_CTRL_CrsrOn_Msk = 0x1
	// Bit CrsrOn.
	LCD_CRSR_CTRL_CrsrOn = 0x1
	// Position of RESERVED field.
	LCD_CRSR_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	LCD_CRSR_CTRL_RESERVED_Msk = 0xe
	// Position of CRSRNUM1_0 field.
	LCD_CRSR_CTRL_CRSRNUM1_0_Pos = 0x4
	// Bit mask of CRSRNUM1_0 field.
	LCD_CRSR_CTRL_CRSRNUM1_0_Msk = 0x30
	// Position of RESERVED field.
	LCD_CRSR_CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	LCD_CRSR_CTRL_RESERVED_Msk = 0xffffffc0

	// CRSR_CFG: Cursor Configuration register
	// Position of CrsrSize field.
	LCD_CRSR_CFG_CrsrSize_Pos = 0x0
	// Bit mask of CrsrSize field.
	LCD_CRSR_CFG_CrsrSize_Msk = 0x1
	// Bit CrsrSize.
	LCD_CRSR_CFG_CrsrSize = 0x1
	// Position of FRAMESYNC field.
	LCD_CRSR_CFG_FRAMESYNC_Pos = 0x1
	// Bit mask of FRAMESYNC field.
	LCD_CRSR_CFG_FRAMESYNC_Msk = 0x2
	// Bit FRAMESYNC.
	LCD_CRSR_CFG_FRAMESYNC = 0x2
	// Position of RESERVED field.
	LCD_CRSR_CFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	LCD_CRSR_CFG_RESERVED_Msk = 0xfffffffc

	// CRSR_PAL0: Cursor Palette register 0
	// Position of RED field.
	LCD_CRSR_PAL0_RED_Pos = 0x0
	// Bit mask of RED field.
	LCD_CRSR_PAL0_RED_Msk = 0xff
	// Position of GREEN field.
	LCD_CRSR_PAL0_GREEN_Pos = 0x8
	// Bit mask of GREEN field.
	LCD_CRSR_PAL0_GREEN_Msk = 0xff00
	// Position of BLUE field.
	LCD_CRSR_PAL0_BLUE_Pos = 0x10
	// Bit mask of BLUE field.
	LCD_CRSR_PAL0_BLUE_Msk = 0xff0000
	// Position of RESERVED field.
	LCD_CRSR_PAL0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	LCD_CRSR_PAL0_RESERVED_Msk = 0xff000000

	// CRSR_PAL1: Cursor Palette register 1
	// Position of RED field.
	LCD_CRSR_PAL1_RED_Pos = 0x0
	// Bit mask of RED field.
	LCD_CRSR_PAL1_RED_Msk = 0xff
	// Position of GREEN field.
	LCD_CRSR_PAL1_GREEN_Pos = 0x8
	// Bit mask of GREEN field.
	LCD_CRSR_PAL1_GREEN_Msk = 0xff00
	// Position of BLUE field.
	LCD_CRSR_PAL1_BLUE_Pos = 0x10
	// Bit mask of BLUE field.
	LCD_CRSR_PAL1_BLUE_Msk = 0xff0000
	// Position of RESERVED field.
	LCD_CRSR_PAL1_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	LCD_CRSR_PAL1_RESERVED_Msk = 0xff000000

	// CRSR_XY: Cursor XY Position register
	// Position of CRSRX field.
	LCD_CRSR_XY_CRSRX_Pos = 0x0
	// Bit mask of CRSRX field.
	LCD_CRSR_XY_CRSRX_Msk = 0x3ff
	// Position of RESERVED field.
	LCD_CRSR_XY_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	LCD_CRSR_XY_RESERVED_Msk = 0xfc00
	// Position of CRSRY field.
	LCD_CRSR_XY_CRSRY_Pos = 0x10
	// Bit mask of CRSRY field.
	LCD_CRSR_XY_CRSRY_Msk = 0x3ff0000
	// Position of RESERVED field.
	LCD_CRSR_XY_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	LCD_CRSR_XY_RESERVED_Msk = 0xfc000000

	// CRSR_CLIP: Cursor Clip Position register
	// Position of CRSRCLIPX field.
	LCD_CRSR_CLIP_CRSRCLIPX_Pos = 0x0
	// Bit mask of CRSRCLIPX field.
	LCD_CRSR_CLIP_CRSRCLIPX_Msk = 0x3f
	// Position of RESERVED field.
	LCD_CRSR_CLIP_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	LCD_CRSR_CLIP_RESERVED_Msk = 0xc0
	// Position of CRSRCLIPY field.
	LCD_CRSR_CLIP_CRSRCLIPY_Pos = 0x8
	// Bit mask of CRSRCLIPY field.
	LCD_CRSR_CLIP_CRSRCLIPY_Msk = 0x3f00
	// Position of RESERVED field.
	LCD_CRSR_CLIP_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	LCD_CRSR_CLIP_RESERVED_Msk = 0xffffc000

	// CRSR_INTMSK: Cursor Interrupt Mask register
	// Position of CRSRIM field.
	LCD_CRSR_INTMSK_CRSRIM_Pos = 0x0
	// Bit mask of CRSRIM field.
	LCD_CRSR_INTMSK_CRSRIM_Msk = 0x1
	// Bit CRSRIM.
	LCD_CRSR_INTMSK_CRSRIM = 0x1
	// Position of RESERVED field.
	LCD_CRSR_INTMSK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	LCD_CRSR_INTMSK_RESERVED_Msk = 0xfffffffe

	// CRSR_INTCLR: Cursor Interrupt Clear register
	// Position of CRSRIC field.
	LCD_CRSR_INTCLR_CRSRIC_Pos = 0x0
	// Bit mask of CRSRIC field.
	LCD_CRSR_INTCLR_CRSRIC_Msk = 0x1
	// Bit CRSRIC.
	LCD_CRSR_INTCLR_CRSRIC = 0x1
	// Position of RESERVED field.
	LCD_CRSR_INTCLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	LCD_CRSR_INTCLR_RESERVED_Msk = 0xfffffffe

	// CRSR_INTRAW: Cursor Raw Interrupt Status register
	// Position of CRSRRIS field.
	LCD_CRSR_INTRAW_CRSRRIS_Pos = 0x0
	// Bit mask of CRSRRIS field.
	LCD_CRSR_INTRAW_CRSRRIS_Msk = 0x1
	// Bit CRSRRIS.
	LCD_CRSR_INTRAW_CRSRRIS = 0x1
	// Position of RESERVED field.
	LCD_CRSR_INTRAW_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	LCD_CRSR_INTRAW_RESERVED_Msk = 0xfffffffe

	// CRSR_INTSTAT: Cursor Masked Interrupt Status register
	// Position of CRSRMIS field.
	LCD_CRSR_INTSTAT_CRSRMIS_Pos = 0x0
	// Bit mask of CRSRMIS field.
	LCD_CRSR_INTSTAT_CRSRMIS_Msk = 0x1
	// Bit CRSRMIS.
	LCD_CRSR_INTSTAT_CRSRMIS = 0x1
	// Position of RESERVED field.
	LCD_CRSR_INTSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	LCD_CRSR_INTSTAT_RESERVED_Msk = 0xfffffffe
)

// Bitfields for EEPROM: EEPROM
const (
	// CMD: EEPROM command register
	// Position of CMD field.
	EEPROM_CMD_CMD_Pos = 0x0
	// Bit mask of CMD field.
	EEPROM_CMD_CMD_Msk = 0x7
	// Position of RESERVED field.
	EEPROM_CMD_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EEPROM_CMD_RESERVED_Msk = 0xfffffff8

	// RWSTATE: EEPROM read wait state register
	// Position of RPHASE2 field.
	EEPROM_RWSTATE_RPHASE2_Pos = 0x0
	// Bit mask of RPHASE2 field.
	EEPROM_RWSTATE_RPHASE2_Msk = 0xff
	// Position of RPHASE1 field.
	EEPROM_RWSTATE_RPHASE1_Pos = 0x8
	// Bit mask of RPHASE1 field.
	EEPROM_RWSTATE_RPHASE1_Msk = 0xff00
	// Position of RESERVED field.
	EEPROM_RWSTATE_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	EEPROM_RWSTATE_RESERVED_Msk = 0xffff0000

	// AUTOPROG: EEPROM auto programming register
	// Position of AUTOPROG field.
	EEPROM_AUTOPROG_AUTOPROG_Pos = 0x0
	// Bit mask of AUTOPROG field.
	EEPROM_AUTOPROG_AUTOPROG_Msk = 0x3
	// Position of RESERVED field.
	EEPROM_AUTOPROG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	EEPROM_AUTOPROG_RESERVED_Msk = 0xfffffffc

	// WSTATE: EEPROM wait state register
	// Position of PHASE3 field.
	EEPROM_WSTATE_PHASE3_Pos = 0x0
	// Bit mask of PHASE3 field.
	EEPROM_WSTATE_PHASE3_Msk = 0xff
	// Position of PHASE2 field.
	EEPROM_WSTATE_PHASE2_Pos = 0x8
	// Bit mask of PHASE2 field.
	EEPROM_WSTATE_PHASE2_Msk = 0xff00
	// Position of PHASE1 field.
	EEPROM_WSTATE_PHASE1_Pos = 0x10
	// Bit mask of PHASE1 field.
	EEPROM_WSTATE_PHASE1_Msk = 0xff0000
	// Position of RESERVED field.
	EEPROM_WSTATE_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	EEPROM_WSTATE_RESERVED_Msk = 0x7f000000
	// Position of LCK_PARWEP field.
	EEPROM_WSTATE_LCK_PARWEP_Pos = 0x1f
	// Bit mask of LCK_PARWEP field.
	EEPROM_WSTATE_LCK_PARWEP_Msk = 0x80000000
	// Bit LCK_PARWEP.
	EEPROM_WSTATE_LCK_PARWEP = 0x80000000

	// CLKDIV: EEPROM clock divider register
	// Position of CLKDIV field.
	EEPROM_CLKDIV_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	EEPROM_CLKDIV_CLKDIV_Msk = 0xffff
	// Position of RESERVED field.
	EEPROM_CLKDIV_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	EEPROM_CLKDIV_RESERVED_Msk = 0xffff0000

	// PWRDWN: EEPROM power-down register
	// Position of PWRDWN field.
	EEPROM_PWRDWN_PWRDWN_Pos = 0x0
	// Bit mask of PWRDWN field.
	EEPROM_PWRDWN_PWRDWN_Msk = 0x1
	// Bit PWRDWN.
	EEPROM_PWRDWN_PWRDWN = 0x1
	// Position of RESERVED field.
	EEPROM_PWRDWN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	EEPROM_PWRDWN_RESERVED_Msk = 0xfffffffe

	// INTENCLR: EEPROM interrupt enable clear
	// Position of RESERVED field.
	EEPROM_INTENCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	EEPROM_INTENCLR_RESERVED_Msk = 0x3
	// Position of PROG_CLR_EN field.
	EEPROM_INTENCLR_PROG_CLR_EN_Pos = 0x2
	// Bit mask of PROG_CLR_EN field.
	EEPROM_INTENCLR_PROG_CLR_EN_Msk = 0x4
	// Bit PROG_CLR_EN.
	EEPROM_INTENCLR_PROG_CLR_EN = 0x4
	// Position of RESERVED field.
	EEPROM_INTENCLR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EEPROM_INTENCLR_RESERVED_Msk = 0xfffffff8

	// INTENSET: EEPROM interrupt enable set
	// Position of RESERVED field.
	EEPROM_INTENSET_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	EEPROM_INTENSET_RESERVED_Msk = 0x3
	// Position of PROG_SET_EN field.
	EEPROM_INTENSET_PROG_SET_EN_Pos = 0x2
	// Bit mask of PROG_SET_EN field.
	EEPROM_INTENSET_PROG_SET_EN_Msk = 0x4
	// Bit PROG_SET_EN.
	EEPROM_INTENSET_PROG_SET_EN = 0x4
	// Position of RESERVED field.
	EEPROM_INTENSET_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EEPROM_INTENSET_RESERVED_Msk = 0xfffffff8

	// INTSTAT: EEPROM interrupt status
	// Position of RESERVED field.
	EEPROM_INTSTAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	EEPROM_INTSTAT_RESERVED_Msk = 0x3
	// Position of END_OF_PROG field.
	EEPROM_INTSTAT_END_OF_PROG_Pos = 0x2
	// Bit mask of END_OF_PROG field.
	EEPROM_INTSTAT_END_OF_PROG_Msk = 0x4
	// Bit END_OF_PROG.
	EEPROM_INTSTAT_END_OF_PROG = 0x4
	// Position of RESERVED field.
	EEPROM_INTSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EEPROM_INTSTAT_RESERVED_Msk = 0xfffffff8

	// INTEN: EEPROM interrupt enable
	// Position of RESERVED field.
	EEPROM_INTEN_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	EEPROM_INTEN_RESERVED_Msk = 0x3
	// Position of EE_PROG_DONE field.
	EEPROM_INTEN_EE_PROG_DONE_Pos = 0x2
	// Bit mask of EE_PROG_DONE field.
	EEPROM_INTEN_EE_PROG_DONE_Msk = 0x4
	// Bit EE_PROG_DONE.
	EEPROM_INTEN_EE_PROG_DONE = 0x4
	// Position of RESERVED field.
	EEPROM_INTEN_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EEPROM_INTEN_RESERVED_Msk = 0xfffffff8

	// INTSTATCLR: EEPROM interrupt status clear
	// Position of RESERVED field.
	EEPROM_INTSTATCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	EEPROM_INTSTATCLR_RESERVED_Msk = 0x3
	// Position of PROG_CLR_ST field.
	EEPROM_INTSTATCLR_PROG_CLR_ST_Pos = 0x2
	// Bit mask of PROG_CLR_ST field.
	EEPROM_INTSTATCLR_PROG_CLR_ST_Msk = 0x4
	// Bit PROG_CLR_ST.
	EEPROM_INTSTATCLR_PROG_CLR_ST = 0x4
	// Position of RESERVED field.
	EEPROM_INTSTATCLR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EEPROM_INTSTATCLR_RESERVED_Msk = 0xfffffff8

	// INTSTATSET: EEPROM interrupt status set
	// Position of RESERVED field.
	EEPROM_INTSTATSET_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	EEPROM_INTSTATSET_RESERVED_Msk = 0x3
	// Position of PROG_SET_ST field.
	EEPROM_INTSTATSET_PROG_SET_ST_Pos = 0x2
	// Bit mask of PROG_SET_ST field.
	EEPROM_INTSTATSET_PROG_SET_ST_Msk = 0x4
	// Bit PROG_SET_ST.
	EEPROM_INTSTATSET_PROG_SET_ST = 0x4
	// Position of RESERVED field.
	EEPROM_INTSTATSET_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EEPROM_INTSTATSET_RESERVED_Msk = 0xfffffff8
)

// Bitfields for ETHERNET: Ethernet
const (
	// MAC_CONFIG: MAC configuration register
	// Position of RESERVED field.
	ETHERNET_MAC_CONFIG_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ETHERNET_MAC_CONFIG_RESERVED_Msk = 0x3
	// Position of RE field.
	ETHERNET_MAC_CONFIG_RE_Pos = 0x2
	// Bit mask of RE field.
	ETHERNET_MAC_CONFIG_RE_Msk = 0x4
	// Bit RE.
	ETHERNET_MAC_CONFIG_RE = 0x4
	// Position of TE field.
	ETHERNET_MAC_CONFIG_TE_Pos = 0x3
	// Bit mask of TE field.
	ETHERNET_MAC_CONFIG_TE_Msk = 0x8
	// Bit TE.
	ETHERNET_MAC_CONFIG_TE = 0x8
	// Position of DF field.
	ETHERNET_MAC_CONFIG_DF_Pos = 0x4
	// Bit mask of DF field.
	ETHERNET_MAC_CONFIG_DF_Msk = 0x10
	// Bit DF.
	ETHERNET_MAC_CONFIG_DF = 0x10
	// Position of BL field.
	ETHERNET_MAC_CONFIG_BL_Pos = 0x5
	// Bit mask of BL field.
	ETHERNET_MAC_CONFIG_BL_Msk = 0x60
	// Position of ACS field.
	ETHERNET_MAC_CONFIG_ACS_Pos = 0x7
	// Bit mask of ACS field.
	ETHERNET_MAC_CONFIG_ACS_Msk = 0x80
	// Bit ACS.
	ETHERNET_MAC_CONFIG_ACS = 0x80
	// Position of RESERVED field.
	ETHERNET_MAC_CONFIG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ETHERNET_MAC_CONFIG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	ETHERNET_MAC_CONFIG_RESERVED = 0x100
	// Position of DR field.
	ETHERNET_MAC_CONFIG_DR_Pos = 0x9
	// Bit mask of DR field.
	ETHERNET_MAC_CONFIG_DR_Msk = 0x200
	// Bit DR.
	ETHERNET_MAC_CONFIG_DR = 0x200
	// Position of RESERVED field.
	ETHERNET_MAC_CONFIG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	ETHERNET_MAC_CONFIG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	ETHERNET_MAC_CONFIG_RESERVED = 0x400
	// Position of DM field.
	ETHERNET_MAC_CONFIG_DM_Pos = 0xb
	// Bit mask of DM field.
	ETHERNET_MAC_CONFIG_DM_Msk = 0x800
	// Bit DM.
	ETHERNET_MAC_CONFIG_DM = 0x800
	// Position of LM field.
	ETHERNET_MAC_CONFIG_LM_Pos = 0xc
	// Bit mask of LM field.
	ETHERNET_MAC_CONFIG_LM_Msk = 0x1000
	// Bit LM.
	ETHERNET_MAC_CONFIG_LM = 0x1000
	// Position of DO field.
	ETHERNET_MAC_CONFIG_DO_Pos = 0xd
	// Bit mask of DO field.
	ETHERNET_MAC_CONFIG_DO_Msk = 0x2000
	// Bit DO.
	ETHERNET_MAC_CONFIG_DO = 0x2000
	// Position of FES field.
	ETHERNET_MAC_CONFIG_FES_Pos = 0xe
	// Bit mask of FES field.
	ETHERNET_MAC_CONFIG_FES_Msk = 0x4000
	// Bit FES.
	ETHERNET_MAC_CONFIG_FES = 0x4000
	// Position of PS field.
	ETHERNET_MAC_CONFIG_PS_Pos = 0xf
	// Bit mask of PS field.
	ETHERNET_MAC_CONFIG_PS_Msk = 0x8000
	// Bit PS.
	ETHERNET_MAC_CONFIG_PS = 0x8000
	// Position of DCRS field.
	ETHERNET_MAC_CONFIG_DCRS_Pos = 0x10
	// Bit mask of DCRS field.
	ETHERNET_MAC_CONFIG_DCRS_Msk = 0x10000
	// Bit DCRS.
	ETHERNET_MAC_CONFIG_DCRS = 0x10000
	// Position of IFG field.
	ETHERNET_MAC_CONFIG_IFG_Pos = 0x11
	// Bit mask of IFG field.
	ETHERNET_MAC_CONFIG_IFG_Msk = 0xe0000
	// Position of JE field.
	ETHERNET_MAC_CONFIG_JE_Pos = 0x14
	// Bit mask of JE field.
	ETHERNET_MAC_CONFIG_JE_Msk = 0x100000
	// Bit JE.
	ETHERNET_MAC_CONFIG_JE = 0x100000
	// Position of RESERVED field.
	ETHERNET_MAC_CONFIG_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	ETHERNET_MAC_CONFIG_RESERVED_Msk = 0x200000
	// Bit RESERVED.
	ETHERNET_MAC_CONFIG_RESERVED = 0x200000
	// Position of JD field.
	ETHERNET_MAC_CONFIG_JD_Pos = 0x16
	// Bit mask of JD field.
	ETHERNET_MAC_CONFIG_JD_Msk = 0x400000
	// Bit JD.
	ETHERNET_MAC_CONFIG_JD = 0x400000
	// Position of WD field.
	ETHERNET_MAC_CONFIG_WD_Pos = 0x17
	// Bit mask of WD field.
	ETHERNET_MAC_CONFIG_WD_Msk = 0x800000
	// Bit WD.
	ETHERNET_MAC_CONFIG_WD = 0x800000
	// Position of RESERVED field.
	ETHERNET_MAC_CONFIG_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	ETHERNET_MAC_CONFIG_RESERVED_Msk = 0xff000000

	// MAC_FRAME_FILTER: MAC frame filter
	// Position of PR field.
	ETHERNET_MAC_FRAME_FILTER_PR_Pos = 0x0
	// Bit mask of PR field.
	ETHERNET_MAC_FRAME_FILTER_PR_Msk = 0x1
	// Bit PR.
	ETHERNET_MAC_FRAME_FILTER_PR = 0x1
	// Position of HUC field.
	ETHERNET_MAC_FRAME_FILTER_HUC_Pos = 0x1
	// Bit mask of HUC field.
	ETHERNET_MAC_FRAME_FILTER_HUC_Msk = 0x2
	// Bit HUC.
	ETHERNET_MAC_FRAME_FILTER_HUC = 0x2
	// Position of HMC field.
	ETHERNET_MAC_FRAME_FILTER_HMC_Pos = 0x2
	// Bit mask of HMC field.
	ETHERNET_MAC_FRAME_FILTER_HMC_Msk = 0x4
	// Bit HMC.
	ETHERNET_MAC_FRAME_FILTER_HMC = 0x4
	// Position of DAIF field.
	ETHERNET_MAC_FRAME_FILTER_DAIF_Pos = 0x3
	// Bit mask of DAIF field.
	ETHERNET_MAC_FRAME_FILTER_DAIF_Msk = 0x8
	// Bit DAIF.
	ETHERNET_MAC_FRAME_FILTER_DAIF = 0x8
	// Position of PM field.
	ETHERNET_MAC_FRAME_FILTER_PM_Pos = 0x4
	// Bit mask of PM field.
	ETHERNET_MAC_FRAME_FILTER_PM_Msk = 0x10
	// Bit PM.
	ETHERNET_MAC_FRAME_FILTER_PM = 0x10
	// Position of DBF field.
	ETHERNET_MAC_FRAME_FILTER_DBF_Pos = 0x5
	// Bit mask of DBF field.
	ETHERNET_MAC_FRAME_FILTER_DBF_Msk = 0x20
	// Bit DBF.
	ETHERNET_MAC_FRAME_FILTER_DBF = 0x20
	// Position of PCF field.
	ETHERNET_MAC_FRAME_FILTER_PCF_Pos = 0x6
	// Bit mask of PCF field.
	ETHERNET_MAC_FRAME_FILTER_PCF_Msk = 0xc0
	// Position of RESERVED field.
	ETHERNET_MAC_FRAME_FILTER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ETHERNET_MAC_FRAME_FILTER_RESERVED_Msk = 0x100
	// Bit RESERVED.
	ETHERNET_MAC_FRAME_FILTER_RESERVED = 0x100
	// Position of RESERVED field.
	ETHERNET_MAC_FRAME_FILTER_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	ETHERNET_MAC_FRAME_FILTER_RESERVED_Msk = 0x200
	// Bit RESERVED.
	ETHERNET_MAC_FRAME_FILTER_RESERVED = 0x200
	// Position of HPF field.
	ETHERNET_MAC_FRAME_FILTER_HPF_Pos = 0xa
	// Bit mask of HPF field.
	ETHERNET_MAC_FRAME_FILTER_HPF_Msk = 0x400
	// Bit HPF.
	ETHERNET_MAC_FRAME_FILTER_HPF = 0x400
	// Position of RESERVED field.
	ETHERNET_MAC_FRAME_FILTER_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ETHERNET_MAC_FRAME_FILTER_RESERVED_Msk = 0x7ffff800
	// Position of RA field.
	ETHERNET_MAC_FRAME_FILTER_RA_Pos = 0x1f
	// Bit mask of RA field.
	ETHERNET_MAC_FRAME_FILTER_RA_Msk = 0x80000000
	// Bit RA.
	ETHERNET_MAC_FRAME_FILTER_RA = 0x80000000

	// MAC_HASHTABLE_HIGH: Hash table high register
	// Position of HTH field.
	ETHERNET_MAC_HASHTABLE_HIGH_HTH_Pos = 0x0
	// Bit mask of HTH field.
	ETHERNET_MAC_HASHTABLE_HIGH_HTH_Msk = 0xffffffff

	// MAC_HASHTABLE_LOW: Hash table low register
	// Position of HTL field.
	ETHERNET_MAC_HASHTABLE_LOW_HTL_Pos = 0x0
	// Bit mask of HTL field.
	ETHERNET_MAC_HASHTABLE_LOW_HTL_Msk = 0xffffffff

	// MAC_MII_ADDR: MII address register
	// Position of GB field.
	ETHERNET_MAC_MII_ADDR_GB_Pos = 0x0
	// Bit mask of GB field.
	ETHERNET_MAC_MII_ADDR_GB_Msk = 0x1
	// Bit GB.
	ETHERNET_MAC_MII_ADDR_GB = 0x1
	// Position of W field.
	ETHERNET_MAC_MII_ADDR_W_Pos = 0x1
	// Bit mask of W field.
	ETHERNET_MAC_MII_ADDR_W_Msk = 0x2
	// Bit W.
	ETHERNET_MAC_MII_ADDR_W = 0x2
	// Position of CR field.
	ETHERNET_MAC_MII_ADDR_CR_Pos = 0x2
	// Bit mask of CR field.
	ETHERNET_MAC_MII_ADDR_CR_Msk = 0x3c
	// Position of GR field.
	ETHERNET_MAC_MII_ADDR_GR_Pos = 0x6
	// Bit mask of GR field.
	ETHERNET_MAC_MII_ADDR_GR_Msk = 0x7c0
	// Position of PA field.
	ETHERNET_MAC_MII_ADDR_PA_Pos = 0xb
	// Bit mask of PA field.
	ETHERNET_MAC_MII_ADDR_PA_Msk = 0xf800
	// Position of RESERVED field.
	ETHERNET_MAC_MII_ADDR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_MAC_MII_ADDR_RESERVED_Msk = 0xffff0000

	// MAC_MII_DATA: MII data register
	// Position of GD field.
	ETHERNET_MAC_MII_DATA_GD_Pos = 0x0
	// Bit mask of GD field.
	ETHERNET_MAC_MII_DATA_GD_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_MAC_MII_DATA_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_MAC_MII_DATA_RESERVED_Msk = 0xffff0000

	// MAC_FLOW_CTRL: Flow control register
	// Position of FCB field.
	ETHERNET_MAC_FLOW_CTRL_FCB_Pos = 0x0
	// Bit mask of FCB field.
	ETHERNET_MAC_FLOW_CTRL_FCB_Msk = 0x1
	// Bit FCB.
	ETHERNET_MAC_FLOW_CTRL_FCB = 0x1
	// Position of TFE field.
	ETHERNET_MAC_FLOW_CTRL_TFE_Pos = 0x1
	// Bit mask of TFE field.
	ETHERNET_MAC_FLOW_CTRL_TFE_Msk = 0x2
	// Bit TFE.
	ETHERNET_MAC_FLOW_CTRL_TFE = 0x2
	// Position of RFE field.
	ETHERNET_MAC_FLOW_CTRL_RFE_Pos = 0x2
	// Bit mask of RFE field.
	ETHERNET_MAC_FLOW_CTRL_RFE_Msk = 0x4
	// Bit RFE.
	ETHERNET_MAC_FLOW_CTRL_RFE = 0x4
	// Position of UP field.
	ETHERNET_MAC_FLOW_CTRL_UP_Pos = 0x3
	// Bit mask of UP field.
	ETHERNET_MAC_FLOW_CTRL_UP_Msk = 0x8
	// Bit UP.
	ETHERNET_MAC_FLOW_CTRL_UP = 0x8
	// Position of PLT field.
	ETHERNET_MAC_FLOW_CTRL_PLT_Pos = 0x4
	// Bit mask of PLT field.
	ETHERNET_MAC_FLOW_CTRL_PLT_Msk = 0x30
	// Position of RESERVED field.
	ETHERNET_MAC_FLOW_CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	ETHERNET_MAC_FLOW_CTRL_RESERVED_Msk = 0x40
	// Bit RESERVED.
	ETHERNET_MAC_FLOW_CTRL_RESERVED = 0x40
	// Position of DZPQ field.
	ETHERNET_MAC_FLOW_CTRL_DZPQ_Pos = 0x7
	// Bit mask of DZPQ field.
	ETHERNET_MAC_FLOW_CTRL_DZPQ_Msk = 0x80
	// Bit DZPQ.
	ETHERNET_MAC_FLOW_CTRL_DZPQ = 0x80
	// Position of RESERVED field.
	ETHERNET_MAC_FLOW_CTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ETHERNET_MAC_FLOW_CTRL_RESERVED_Msk = 0xff00
	// Position of PT field.
	ETHERNET_MAC_FLOW_CTRL_PT_Pos = 0x10
	// Bit mask of PT field.
	ETHERNET_MAC_FLOW_CTRL_PT_Msk = 0xffff0000

	// MAC_VLAN_TAG: VLAN tag register
	// Position of VL field.
	ETHERNET_MAC_VLAN_TAG_VL_Pos = 0x0
	// Bit mask of VL field.
	ETHERNET_MAC_VLAN_TAG_VL_Msk = 0xffff
	// Position of ETV field.
	ETHERNET_MAC_VLAN_TAG_ETV_Pos = 0x10
	// Bit mask of ETV field.
	ETHERNET_MAC_VLAN_TAG_ETV_Msk = 0x10000
	// Bit ETV.
	ETHERNET_MAC_VLAN_TAG_ETV = 0x10000
	// Position of RESERVED field.
	ETHERNET_MAC_VLAN_TAG_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	ETHERNET_MAC_VLAN_TAG_RESERVED_Msk = 0xfffe0000

	// MAC_DEBUG: Debug register
	// Position of RXIDLESTAT field.
	ETHERNET_MAC_DEBUG_RXIDLESTAT_Pos = 0x0
	// Bit mask of RXIDLESTAT field.
	ETHERNET_MAC_DEBUG_RXIDLESTAT_Msk = 0x1
	// Bit RXIDLESTAT.
	ETHERNET_MAC_DEBUG_RXIDLESTAT = 0x1
	// Position of FIFOSTAT0 field.
	ETHERNET_MAC_DEBUG_FIFOSTAT0_Pos = 0x1
	// Bit mask of FIFOSTAT0 field.
	ETHERNET_MAC_DEBUG_FIFOSTAT0_Msk = 0x6
	// Position of RESERVED field.
	ETHERNET_MAC_DEBUG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	ETHERNET_MAC_DEBUG_RESERVED_Msk = 0x8
	// Bit RESERVED.
	ETHERNET_MAC_DEBUG_RESERVED = 0x8
	// Position of RXFIFOSTAT1 field.
	ETHERNET_MAC_DEBUG_RXFIFOSTAT1_Pos = 0x4
	// Bit mask of RXFIFOSTAT1 field.
	ETHERNET_MAC_DEBUG_RXFIFOSTAT1_Msk = 0x10
	// Bit RXFIFOSTAT1.
	ETHERNET_MAC_DEBUG_RXFIFOSTAT1 = 0x10
	// Position of RXFIFOSTAT field.
	ETHERNET_MAC_DEBUG_RXFIFOSTAT_Pos = 0x5
	// Bit mask of RXFIFOSTAT field.
	ETHERNET_MAC_DEBUG_RXFIFOSTAT_Msk = 0x60
	// Position of RESERVED field.
	ETHERNET_MAC_DEBUG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	ETHERNET_MAC_DEBUG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	ETHERNET_MAC_DEBUG_RESERVED = 0x80
	// Position of RXFIFOLVL field.
	ETHERNET_MAC_DEBUG_RXFIFOLVL_Pos = 0x8
	// Bit mask of RXFIFOLVL field.
	ETHERNET_MAC_DEBUG_RXFIFOLVL_Msk = 0x300
	// Position of RESERVED field.
	ETHERNET_MAC_DEBUG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	ETHERNET_MAC_DEBUG_RESERVED_Msk = 0xfc00
	// Position of TXIDLESTAT field.
	ETHERNET_MAC_DEBUG_TXIDLESTAT_Pos = 0x10
	// Bit mask of TXIDLESTAT field.
	ETHERNET_MAC_DEBUG_TXIDLESTAT_Msk = 0x10000
	// Bit TXIDLESTAT.
	ETHERNET_MAC_DEBUG_TXIDLESTAT = 0x10000
	// Position of TXSTAT field.
	ETHERNET_MAC_DEBUG_TXSTAT_Pos = 0x11
	// Bit mask of TXSTAT field.
	ETHERNET_MAC_DEBUG_TXSTAT_Msk = 0x60000
	// Position of PAUSE field.
	ETHERNET_MAC_DEBUG_PAUSE_Pos = 0x13
	// Bit mask of PAUSE field.
	ETHERNET_MAC_DEBUG_PAUSE_Msk = 0x80000
	// Bit PAUSE.
	ETHERNET_MAC_DEBUG_PAUSE = 0x80000
	// Position of TXFIFOSTAT field.
	ETHERNET_MAC_DEBUG_TXFIFOSTAT_Pos = 0x14
	// Bit mask of TXFIFOSTAT field.
	ETHERNET_MAC_DEBUG_TXFIFOSTAT_Msk = 0x300000
	// Position of TXFIFOSTAT1 field.
	ETHERNET_MAC_DEBUG_TXFIFOSTAT1_Pos = 0x16
	// Bit mask of TXFIFOSTAT1 field.
	ETHERNET_MAC_DEBUG_TXFIFOSTAT1_Msk = 0x400000
	// Bit TXFIFOSTAT1.
	ETHERNET_MAC_DEBUG_TXFIFOSTAT1 = 0x400000
	// Position of RESERVED field.
	ETHERNET_MAC_DEBUG_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	ETHERNET_MAC_DEBUG_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	ETHERNET_MAC_DEBUG_RESERVED = 0x800000
	// Position of TXFIFOLVL field.
	ETHERNET_MAC_DEBUG_TXFIFOLVL_Pos = 0x18
	// Bit mask of TXFIFOLVL field.
	ETHERNET_MAC_DEBUG_TXFIFOLVL_Msk = 0x1000000
	// Bit TXFIFOLVL.
	ETHERNET_MAC_DEBUG_TXFIFOLVL = 0x1000000
	// Position of TXFIFOFULL field.
	ETHERNET_MAC_DEBUG_TXFIFOFULL_Pos = 0x19
	// Bit mask of TXFIFOFULL field.
	ETHERNET_MAC_DEBUG_TXFIFOFULL_Msk = 0x2000000
	// Bit TXFIFOFULL.
	ETHERNET_MAC_DEBUG_TXFIFOFULL = 0x2000000
	// Position of RESERVED field.
	ETHERNET_MAC_DEBUG_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	ETHERNET_MAC_DEBUG_RESERVED_Msk = 0xfc000000

	// MAC_RWAKE_FRFLT: Remote wake-up frame filter
	// Position of ADDR field.
	ETHERNET_MAC_RWAKE_FRFLT_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	ETHERNET_MAC_RWAKE_FRFLT_ADDR_Msk = 0xffffffff

	// MAC_PMT_CTRL_STAT: PMT control and status
	// Position of PD field.
	ETHERNET_MAC_PMT_CTRL_STAT_PD_Pos = 0x0
	// Bit mask of PD field.
	ETHERNET_MAC_PMT_CTRL_STAT_PD_Msk = 0x1
	// Bit PD.
	ETHERNET_MAC_PMT_CTRL_STAT_PD = 0x1
	// Position of MPE field.
	ETHERNET_MAC_PMT_CTRL_STAT_MPE_Pos = 0x1
	// Bit mask of MPE field.
	ETHERNET_MAC_PMT_CTRL_STAT_MPE_Msk = 0x2
	// Bit MPE.
	ETHERNET_MAC_PMT_CTRL_STAT_MPE = 0x2
	// Position of WFE field.
	ETHERNET_MAC_PMT_CTRL_STAT_WFE_Pos = 0x2
	// Bit mask of WFE field.
	ETHERNET_MAC_PMT_CTRL_STAT_WFE_Msk = 0x4
	// Bit WFE.
	ETHERNET_MAC_PMT_CTRL_STAT_WFE = 0x4
	// Position of RESERVED field.
	ETHERNET_MAC_PMT_CTRL_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	ETHERNET_MAC_PMT_CTRL_STAT_RESERVED_Msk = 0x18
	// Position of MPR field.
	ETHERNET_MAC_PMT_CTRL_STAT_MPR_Pos = 0x5
	// Bit mask of MPR field.
	ETHERNET_MAC_PMT_CTRL_STAT_MPR_Msk = 0x20
	// Bit MPR.
	ETHERNET_MAC_PMT_CTRL_STAT_MPR = 0x20
	// Position of WFR field.
	ETHERNET_MAC_PMT_CTRL_STAT_WFR_Pos = 0x6
	// Bit mask of WFR field.
	ETHERNET_MAC_PMT_CTRL_STAT_WFR_Msk = 0x40
	// Bit WFR.
	ETHERNET_MAC_PMT_CTRL_STAT_WFR = 0x40
	// Position of RESERVED field.
	ETHERNET_MAC_PMT_CTRL_STAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	ETHERNET_MAC_PMT_CTRL_STAT_RESERVED_Msk = 0x180
	// Position of GU field.
	ETHERNET_MAC_PMT_CTRL_STAT_GU_Pos = 0x9
	// Bit mask of GU field.
	ETHERNET_MAC_PMT_CTRL_STAT_GU_Msk = 0x200
	// Bit GU.
	ETHERNET_MAC_PMT_CTRL_STAT_GU = 0x200
	// Position of RESERVED field.
	ETHERNET_MAC_PMT_CTRL_STAT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	ETHERNET_MAC_PMT_CTRL_STAT_RESERVED_Msk = 0x7ffffc00
	// Position of WFFRPR field.
	ETHERNET_MAC_PMT_CTRL_STAT_WFFRPR_Pos = 0x1f
	// Bit mask of WFFRPR field.
	ETHERNET_MAC_PMT_CTRL_STAT_WFFRPR_Msk = 0x80000000
	// Bit WFFRPR.
	ETHERNET_MAC_PMT_CTRL_STAT_WFFRPR = 0x80000000

	// MAC_INTR: Interrupt status register
	// Position of RESERVED field.
	ETHERNET_MAC_INTR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ETHERNET_MAC_INTR_RESERVED_Msk = 0x7
	// Position of PMT field.
	ETHERNET_MAC_INTR_PMT_Pos = 0x3
	// Bit mask of PMT field.
	ETHERNET_MAC_INTR_PMT_Msk = 0x8
	// Bit PMT.
	ETHERNET_MAC_INTR_PMT = 0x8
	// Position of RESERVED field.
	ETHERNET_MAC_INTR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	ETHERNET_MAC_INTR_RESERVED_Msk = 0x1f0
	// Position of TS field.
	ETHERNET_MAC_INTR_TS_Pos = 0x9
	// Bit mask of TS field.
	ETHERNET_MAC_INTR_TS_Msk = 0x200
	// Bit TS.
	ETHERNET_MAC_INTR_TS = 0x200
	// Position of RESERVED field.
	ETHERNET_MAC_INTR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	ETHERNET_MAC_INTR_RESERVED_Msk = 0x400
	// Bit RESERVED.
	ETHERNET_MAC_INTR_RESERVED = 0x400
	// Position of RESERVED field.
	ETHERNET_MAC_INTR_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ETHERNET_MAC_INTR_RESERVED_Msk = 0xfffff800

	// MAC_INTR_MASK: Interrupt mask register
	// Position of RESERVED field.
	ETHERNET_MAC_INTR_MASK_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ETHERNET_MAC_INTR_MASK_RESERVED_Msk = 0x7
	// Position of PMTIM field.
	ETHERNET_MAC_INTR_MASK_PMTIM_Pos = 0x3
	// Bit mask of PMTIM field.
	ETHERNET_MAC_INTR_MASK_PMTIM_Msk = 0x8
	// Bit PMTIM.
	ETHERNET_MAC_INTR_MASK_PMTIM = 0x8
	// Position of RESERVED field.
	ETHERNET_MAC_INTR_MASK_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	ETHERNET_MAC_INTR_MASK_RESERVED_Msk = 0x1f0
	// Position of TSIM field.
	ETHERNET_MAC_INTR_MASK_TSIM_Pos = 0x9
	// Bit mask of TSIM field.
	ETHERNET_MAC_INTR_MASK_TSIM_Msk = 0x200
	// Bit TSIM.
	ETHERNET_MAC_INTR_MASK_TSIM = 0x200
	// Position of RESERVED field.
	ETHERNET_MAC_INTR_MASK_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	ETHERNET_MAC_INTR_MASK_RESERVED_Msk = 0x400
	// Bit RESERVED.
	ETHERNET_MAC_INTR_MASK_RESERVED = 0x400

	// MAC_ADDR0_HIGH: MAC address 0 high register
	// Position of A47_32 field.
	ETHERNET_MAC_ADDR0_HIGH_A47_32_Pos = 0x0
	// Bit mask of A47_32 field.
	ETHERNET_MAC_ADDR0_HIGH_A47_32_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_MAC_ADDR0_HIGH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_MAC_ADDR0_HIGH_RESERVED_Msk = 0x7fff0000
	// Position of MO field.
	ETHERNET_MAC_ADDR0_HIGH_MO_Pos = 0x1f
	// Bit mask of MO field.
	ETHERNET_MAC_ADDR0_HIGH_MO_Msk = 0x80000000
	// Bit MO.
	ETHERNET_MAC_ADDR0_HIGH_MO = 0x80000000

	// MAC_ADDR0_LOW: MAC address 0 low register
	// Position of A31_0 field.
	ETHERNET_MAC_ADDR0_LOW_A31_0_Pos = 0x0
	// Bit mask of A31_0 field.
	ETHERNET_MAC_ADDR0_LOW_A31_0_Msk = 0xffffffff

	// MAC_TIMESTP_CTRL: Time stamp control register
	// Position of TSENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSENA_Pos = 0x0
	// Bit mask of TSENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSENA_Msk = 0x1
	// Bit TSENA.
	ETHERNET_MAC_TIMESTP_CTRL_TSENA = 0x1
	// Position of TSCFUPDT field.
	ETHERNET_MAC_TIMESTP_CTRL_TSCFUPDT_Pos = 0x1
	// Bit mask of TSCFUPDT field.
	ETHERNET_MAC_TIMESTP_CTRL_TSCFUPDT_Msk = 0x2
	// Bit TSCFUPDT.
	ETHERNET_MAC_TIMESTP_CTRL_TSCFUPDT = 0x2
	// Position of TSINIT field.
	ETHERNET_MAC_TIMESTP_CTRL_TSINIT_Pos = 0x2
	// Bit mask of TSINIT field.
	ETHERNET_MAC_TIMESTP_CTRL_TSINIT_Msk = 0x4
	// Bit TSINIT.
	ETHERNET_MAC_TIMESTP_CTRL_TSINIT = 0x4
	// Position of TSUPDT field.
	ETHERNET_MAC_TIMESTP_CTRL_TSUPDT_Pos = 0x3
	// Bit mask of TSUPDT field.
	ETHERNET_MAC_TIMESTP_CTRL_TSUPDT_Msk = 0x8
	// Bit TSUPDT.
	ETHERNET_MAC_TIMESTP_CTRL_TSUPDT = 0x8
	// Position of TSTRIG field.
	ETHERNET_MAC_TIMESTP_CTRL_TSTRIG_Pos = 0x4
	// Bit mask of TSTRIG field.
	ETHERNET_MAC_TIMESTP_CTRL_TSTRIG_Msk = 0x10
	// Bit TSTRIG.
	ETHERNET_MAC_TIMESTP_CTRL_TSTRIG = 0x10
	// Position of TSADDREG field.
	ETHERNET_MAC_TIMESTP_CTRL_TSADDREG_Pos = 0x5
	// Bit mask of TSADDREG field.
	ETHERNET_MAC_TIMESTP_CTRL_TSADDREG_Msk = 0x20
	// Bit TSADDREG.
	ETHERNET_MAC_TIMESTP_CTRL_TSADDREG = 0x20
	// Position of RESERVED field.
	ETHERNET_MAC_TIMESTP_CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	ETHERNET_MAC_TIMESTP_CTRL_RESERVED_Msk = 0xc0
	// Position of TSENALL field.
	ETHERNET_MAC_TIMESTP_CTRL_TSENALL_Pos = 0x8
	// Bit mask of TSENALL field.
	ETHERNET_MAC_TIMESTP_CTRL_TSENALL_Msk = 0x100
	// Bit TSENALL.
	ETHERNET_MAC_TIMESTP_CTRL_TSENALL = 0x100
	// Position of TSCTRLSSR field.
	ETHERNET_MAC_TIMESTP_CTRL_TSCTRLSSR_Pos = 0x9
	// Bit mask of TSCTRLSSR field.
	ETHERNET_MAC_TIMESTP_CTRL_TSCTRLSSR_Msk = 0x200
	// Bit TSCTRLSSR.
	ETHERNET_MAC_TIMESTP_CTRL_TSCTRLSSR = 0x200
	// Position of TSVER2ENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSVER2ENA_Pos = 0xa
	// Bit mask of TSVER2ENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSVER2ENA_Msk = 0x400
	// Bit TSVER2ENA.
	ETHERNET_MAC_TIMESTP_CTRL_TSVER2ENA = 0x400
	// Position of TSIPENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSIPENA_Pos = 0xb
	// Bit mask of TSIPENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSIPENA_Msk = 0x800
	// Bit TSIPENA.
	ETHERNET_MAC_TIMESTP_CTRL_TSIPENA = 0x800
	// Position of TSIPV6ENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSIPV6ENA_Pos = 0xc
	// Bit mask of TSIPV6ENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSIPV6ENA_Msk = 0x1000
	// Bit TSIPV6ENA.
	ETHERNET_MAC_TIMESTP_CTRL_TSIPV6ENA = 0x1000
	// Position of TSIPV4ENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSIPV4ENA_Pos = 0xd
	// Bit mask of TSIPV4ENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSIPV4ENA_Msk = 0x2000
	// Bit TSIPV4ENA.
	ETHERNET_MAC_TIMESTP_CTRL_TSIPV4ENA = 0x2000
	// Position of TSEVNTENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSEVNTENA_Pos = 0xe
	// Bit mask of TSEVNTENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSEVNTENA_Msk = 0x4000
	// Bit TSEVNTENA.
	ETHERNET_MAC_TIMESTP_CTRL_TSEVNTENA = 0x4000
	// Position of TSMSTRENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSMSTRENA_Pos = 0xf
	// Bit mask of TSMSTRENA field.
	ETHERNET_MAC_TIMESTP_CTRL_TSMSTRENA_Msk = 0x8000
	// Bit TSMSTRENA.
	ETHERNET_MAC_TIMESTP_CTRL_TSMSTRENA = 0x8000
	// Position of TSCLKTYPE field.
	ETHERNET_MAC_TIMESTP_CTRL_TSCLKTYPE_Pos = 0x10
	// Bit mask of TSCLKTYPE field.
	ETHERNET_MAC_TIMESTP_CTRL_TSCLKTYPE_Msk = 0x30000
	// Position of TSENMACADDR field.
	ETHERNET_MAC_TIMESTP_CTRL_TSENMACADDR_Pos = 0x12
	// Bit mask of TSENMACADDR field.
	ETHERNET_MAC_TIMESTP_CTRL_TSENMACADDR_Msk = 0x40000
	// Bit TSENMACADDR.
	ETHERNET_MAC_TIMESTP_CTRL_TSENMACADDR = 0x40000

	// SUBSECOND_INCR: Sub-second increment register
	// Position of SSINC field.
	ETHERNET_SUBSECOND_INCR_SSINC_Pos = 0x0
	// Bit mask of SSINC field.
	ETHERNET_SUBSECOND_INCR_SSINC_Msk = 0xff
	// Position of RESERVED field.
	ETHERNET_SUBSECOND_INCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ETHERNET_SUBSECOND_INCR_RESERVED_Msk = 0xffffff00

	// SECONDS: System time seconds register
	// Position of TSS field.
	ETHERNET_SECONDS_TSS_Pos = 0x0
	// Bit mask of TSS field.
	ETHERNET_SECONDS_TSS_Msk = 0xffffffff

	// NANOSECONDS: System time nanoseconds register
	// Position of TSSS field.
	ETHERNET_NANOSECONDS_TSSS_Pos = 0x0
	// Bit mask of TSSS field.
	ETHERNET_NANOSECONDS_TSSS_Msk = 0x7fffffff
	// Position of PSNT field.
	ETHERNET_NANOSECONDS_PSNT_Pos = 0x1f
	// Bit mask of PSNT field.
	ETHERNET_NANOSECONDS_PSNT_Msk = 0x80000000
	// Bit PSNT.
	ETHERNET_NANOSECONDS_PSNT = 0x80000000

	// SECONDSUPDATE: System time seconds update register
	// Position of TSS field.
	ETHERNET_SECONDSUPDATE_TSS_Pos = 0x0
	// Bit mask of TSS field.
	ETHERNET_SECONDSUPDATE_TSS_Msk = 0xffffffff

	// NANOSECONDSUPDATE: System time nanoseconds update register
	// Position of TSSS field.
	ETHERNET_NANOSECONDSUPDATE_TSSS_Pos = 0x0
	// Bit mask of TSSS field.
	ETHERNET_NANOSECONDSUPDATE_TSSS_Msk = 0x7fffffff
	// Position of ADDSUB field.
	ETHERNET_NANOSECONDSUPDATE_ADDSUB_Pos = 0x1f
	// Bit mask of ADDSUB field.
	ETHERNET_NANOSECONDSUPDATE_ADDSUB_Msk = 0x80000000
	// Bit ADDSUB.
	ETHERNET_NANOSECONDSUPDATE_ADDSUB = 0x80000000

	// ADDEND: Time stamp addend register
	// Position of TSAR field.
	ETHERNET_ADDEND_TSAR_Pos = 0x0
	// Bit mask of TSAR field.
	ETHERNET_ADDEND_TSAR_Msk = 0xffffffff

	// TARGETSECONDS: Target time seconds register
	// Position of TSTR field.
	ETHERNET_TARGETSECONDS_TSTR_Pos = 0x0
	// Bit mask of TSTR field.
	ETHERNET_TARGETSECONDS_TSTR_Msk = 0xffffffff

	// TARGETNANOSECONDS: Target time nanoseconds register
	// Position of TSTR field.
	ETHERNET_TARGETNANOSECONDS_TSTR_Pos = 0x0
	// Bit mask of TSTR field.
	ETHERNET_TARGETNANOSECONDS_TSTR_Msk = 0x7fffffff
	// Position of RESERVED field.
	ETHERNET_TARGETNANOSECONDS_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	ETHERNET_TARGETNANOSECONDS_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	ETHERNET_TARGETNANOSECONDS_RESERVED = 0x80000000

	// HIGHWORD: System time higher word seconds register
	// Position of TSHWR field.
	ETHERNET_HIGHWORD_TSHWR_Pos = 0x0
	// Bit mask of TSHWR field.
	ETHERNET_HIGHWORD_TSHWR_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_HIGHWORD_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_HIGHWORD_RESERVED_Msk = 0xffff0000

	// TIMESTAMPSTAT: Time stamp status register
	// Position of TSSOVF field.
	ETHERNET_TIMESTAMPSTAT_TSSOVF_Pos = 0x0
	// Bit mask of TSSOVF field.
	ETHERNET_TIMESTAMPSTAT_TSSOVF_Msk = 0x1
	// Bit TSSOVF.
	ETHERNET_TIMESTAMPSTAT_TSSOVF = 0x1
	// Position of TSTARGT field.
	ETHERNET_TIMESTAMPSTAT_TSTARGT_Pos = 0x1
	// Bit mask of TSTARGT field.
	ETHERNET_TIMESTAMPSTAT_TSTARGT_Msk = 0x2
	// Bit TSTARGT.
	ETHERNET_TIMESTAMPSTAT_TSTARGT = 0x2
	// Position of RESERVED field.
	ETHERNET_TIMESTAMPSTAT_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	ETHERNET_TIMESTAMPSTAT_RESERVED_Msk = 0xfffffffc

	// DMA_BUS_MODE: Bus Mode Register
	// Position of SWR field.
	ETHERNET_DMA_BUS_MODE_SWR_Pos = 0x0
	// Bit mask of SWR field.
	ETHERNET_DMA_BUS_MODE_SWR_Msk = 0x1
	// Bit SWR.
	ETHERNET_DMA_BUS_MODE_SWR = 0x1
	// Position of DA field.
	ETHERNET_DMA_BUS_MODE_DA_Pos = 0x1
	// Bit mask of DA field.
	ETHERNET_DMA_BUS_MODE_DA_Msk = 0x2
	// Bit DA.
	ETHERNET_DMA_BUS_MODE_DA = 0x2
	// Position of DSL field.
	ETHERNET_DMA_BUS_MODE_DSL_Pos = 0x2
	// Bit mask of DSL field.
	ETHERNET_DMA_BUS_MODE_DSL_Msk = 0x7c
	// Position of ATDS field.
	ETHERNET_DMA_BUS_MODE_ATDS_Pos = 0x7
	// Bit mask of ATDS field.
	ETHERNET_DMA_BUS_MODE_ATDS_Msk = 0x80
	// Bit ATDS.
	ETHERNET_DMA_BUS_MODE_ATDS = 0x80
	// Position of PBL field.
	ETHERNET_DMA_BUS_MODE_PBL_Pos = 0x8
	// Bit mask of PBL field.
	ETHERNET_DMA_BUS_MODE_PBL_Msk = 0x3f00
	// Position of PR field.
	ETHERNET_DMA_BUS_MODE_PR_Pos = 0xe
	// Bit mask of PR field.
	ETHERNET_DMA_BUS_MODE_PR_Msk = 0xc000
	// Position of FB field.
	ETHERNET_DMA_BUS_MODE_FB_Pos = 0x10
	// Bit mask of FB field.
	ETHERNET_DMA_BUS_MODE_FB_Msk = 0x10000
	// Bit FB.
	ETHERNET_DMA_BUS_MODE_FB = 0x10000
	// Position of RPBL field.
	ETHERNET_DMA_BUS_MODE_RPBL_Pos = 0x11
	// Bit mask of RPBL field.
	ETHERNET_DMA_BUS_MODE_RPBL_Msk = 0x7e0000
	// Position of USP field.
	ETHERNET_DMA_BUS_MODE_USP_Pos = 0x17
	// Bit mask of USP field.
	ETHERNET_DMA_BUS_MODE_USP_Msk = 0x800000
	// Bit USP.
	ETHERNET_DMA_BUS_MODE_USP = 0x800000
	// Position of PBL8X field.
	ETHERNET_DMA_BUS_MODE_PBL8X_Pos = 0x18
	// Bit mask of PBL8X field.
	ETHERNET_DMA_BUS_MODE_PBL8X_Msk = 0x1000000
	// Bit PBL8X.
	ETHERNET_DMA_BUS_MODE_PBL8X = 0x1000000
	// Position of AAL field.
	ETHERNET_DMA_BUS_MODE_AAL_Pos = 0x19
	// Bit mask of AAL field.
	ETHERNET_DMA_BUS_MODE_AAL_Msk = 0x2000000
	// Bit AAL.
	ETHERNET_DMA_BUS_MODE_AAL = 0x2000000
	// Position of MB field.
	ETHERNET_DMA_BUS_MODE_MB_Pos = 0x1a
	// Bit mask of MB field.
	ETHERNET_DMA_BUS_MODE_MB_Msk = 0x4000000
	// Bit MB.
	ETHERNET_DMA_BUS_MODE_MB = 0x4000000
	// Position of TXPR field.
	ETHERNET_DMA_BUS_MODE_TXPR_Pos = 0x1b
	// Bit mask of TXPR field.
	ETHERNET_DMA_BUS_MODE_TXPR_Msk = 0x8000000
	// Bit TXPR.
	ETHERNET_DMA_BUS_MODE_TXPR = 0x8000000
	// Position of RESERVED field.
	ETHERNET_DMA_BUS_MODE_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	ETHERNET_DMA_BUS_MODE_RESERVED_Msk = 0xf0000000

	// DMA_TRANS_POLL_DEMAND: Transmit poll demand register
	// Position of TPD field.
	ETHERNET_DMA_TRANS_POLL_DEMAND_TPD_Pos = 0x0
	// Bit mask of TPD field.
	ETHERNET_DMA_TRANS_POLL_DEMAND_TPD_Msk = 0xffffffff

	// DMA_REC_POLL_DEMAND: Receive poll demand register
	// Position of RPD field.
	ETHERNET_DMA_REC_POLL_DEMAND_RPD_Pos = 0x0
	// Bit mask of RPD field.
	ETHERNET_DMA_REC_POLL_DEMAND_RPD_Msk = 0xffffffff

	// DMA_REC_DES_ADDR: Receive descriptor list address register
	// Position of SRL field.
	ETHERNET_DMA_REC_DES_ADDR_SRL_Pos = 0x0
	// Bit mask of SRL field.
	ETHERNET_DMA_REC_DES_ADDR_SRL_Msk = 0xffffffff

	// DMA_TRANS_DES_ADDR: Transmit descriptor list address register
	// Position of SRL field.
	ETHERNET_DMA_TRANS_DES_ADDR_SRL_Pos = 0x0
	// Bit mask of SRL field.
	ETHERNET_DMA_TRANS_DES_ADDR_SRL_Msk = 0xffffffff

	// DMA_STAT: Status register
	// Position of TI field.
	ETHERNET_DMA_STAT_TI_Pos = 0x0
	// Bit mask of TI field.
	ETHERNET_DMA_STAT_TI_Msk = 0x1
	// Bit TI.
	ETHERNET_DMA_STAT_TI = 0x1
	// Position of TPS field.
	ETHERNET_DMA_STAT_TPS_Pos = 0x1
	// Bit mask of TPS field.
	ETHERNET_DMA_STAT_TPS_Msk = 0x2
	// Bit TPS.
	ETHERNET_DMA_STAT_TPS = 0x2
	// Position of TU field.
	ETHERNET_DMA_STAT_TU_Pos = 0x2
	// Bit mask of TU field.
	ETHERNET_DMA_STAT_TU_Msk = 0x4
	// Bit TU.
	ETHERNET_DMA_STAT_TU = 0x4
	// Position of TJT field.
	ETHERNET_DMA_STAT_TJT_Pos = 0x3
	// Bit mask of TJT field.
	ETHERNET_DMA_STAT_TJT_Msk = 0x8
	// Bit TJT.
	ETHERNET_DMA_STAT_TJT = 0x8
	// Position of OVF field.
	ETHERNET_DMA_STAT_OVF_Pos = 0x4
	// Bit mask of OVF field.
	ETHERNET_DMA_STAT_OVF_Msk = 0x10
	// Bit OVF.
	ETHERNET_DMA_STAT_OVF = 0x10
	// Position of UNF field.
	ETHERNET_DMA_STAT_UNF_Pos = 0x5
	// Bit mask of UNF field.
	ETHERNET_DMA_STAT_UNF_Msk = 0x20
	// Bit UNF.
	ETHERNET_DMA_STAT_UNF = 0x20
	// Position of RI field.
	ETHERNET_DMA_STAT_RI_Pos = 0x6
	// Bit mask of RI field.
	ETHERNET_DMA_STAT_RI_Msk = 0x40
	// Bit RI.
	ETHERNET_DMA_STAT_RI = 0x40
	// Position of RU field.
	ETHERNET_DMA_STAT_RU_Pos = 0x7
	// Bit mask of RU field.
	ETHERNET_DMA_STAT_RU_Msk = 0x80
	// Bit RU.
	ETHERNET_DMA_STAT_RU = 0x80
	// Position of RPS field.
	ETHERNET_DMA_STAT_RPS_Pos = 0x8
	// Bit mask of RPS field.
	ETHERNET_DMA_STAT_RPS_Msk = 0x100
	// Bit RPS.
	ETHERNET_DMA_STAT_RPS = 0x100
	// Position of RWT field.
	ETHERNET_DMA_STAT_RWT_Pos = 0x9
	// Bit mask of RWT field.
	ETHERNET_DMA_STAT_RWT_Msk = 0x200
	// Bit RWT.
	ETHERNET_DMA_STAT_RWT = 0x200
	// Position of ETI field.
	ETHERNET_DMA_STAT_ETI_Pos = 0xa
	// Bit mask of ETI field.
	ETHERNET_DMA_STAT_ETI_Msk = 0x400
	// Bit ETI.
	ETHERNET_DMA_STAT_ETI = 0x400
	// Position of RESERVED field.
	ETHERNET_DMA_STAT_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ETHERNET_DMA_STAT_RESERVED_Msk = 0x1800
	// Position of FBI field.
	ETHERNET_DMA_STAT_FBI_Pos = 0xd
	// Bit mask of FBI field.
	ETHERNET_DMA_STAT_FBI_Msk = 0x2000
	// Bit FBI.
	ETHERNET_DMA_STAT_FBI = 0x2000
	// Position of ERI field.
	ETHERNET_DMA_STAT_ERI_Pos = 0xe
	// Bit mask of ERI field.
	ETHERNET_DMA_STAT_ERI_Msk = 0x4000
	// Bit ERI.
	ETHERNET_DMA_STAT_ERI = 0x4000
	// Position of AIE field.
	ETHERNET_DMA_STAT_AIE_Pos = 0xf
	// Bit mask of AIE field.
	ETHERNET_DMA_STAT_AIE_Msk = 0x8000
	// Bit AIE.
	ETHERNET_DMA_STAT_AIE = 0x8000
	// Position of NIS field.
	ETHERNET_DMA_STAT_NIS_Pos = 0x10
	// Bit mask of NIS field.
	ETHERNET_DMA_STAT_NIS_Msk = 0x10000
	// Bit NIS.
	ETHERNET_DMA_STAT_NIS = 0x10000
	// Position of RS field.
	ETHERNET_DMA_STAT_RS_Pos = 0x11
	// Bit mask of RS field.
	ETHERNET_DMA_STAT_RS_Msk = 0xe0000
	// Position of TS field.
	ETHERNET_DMA_STAT_TS_Pos = 0x14
	// Bit mask of TS field.
	ETHERNET_DMA_STAT_TS_Msk = 0x700000
	// Position of EB1 field.
	ETHERNET_DMA_STAT_EB1_Pos = 0x17
	// Bit mask of EB1 field.
	ETHERNET_DMA_STAT_EB1_Msk = 0x800000
	// Bit EB1.
	ETHERNET_DMA_STAT_EB1 = 0x800000
	// Position of EB2 field.
	ETHERNET_DMA_STAT_EB2_Pos = 0x18
	// Bit mask of EB2 field.
	ETHERNET_DMA_STAT_EB2_Msk = 0x1000000
	// Bit EB2.
	ETHERNET_DMA_STAT_EB2 = 0x1000000
	// Position of EB3 field.
	ETHERNET_DMA_STAT_EB3_Pos = 0x19
	// Bit mask of EB3 field.
	ETHERNET_DMA_STAT_EB3_Msk = 0x2000000
	// Bit EB3.
	ETHERNET_DMA_STAT_EB3 = 0x2000000
	// Position of RESERVED field.
	ETHERNET_DMA_STAT_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	ETHERNET_DMA_STAT_RESERVED_Msk = 0xfc000000

	// DMA_OP_MODE: Operation mode register
	// Position of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Msk = 0x1
	// Bit RESERVED.
	ETHERNET_DMA_OP_MODE_RESERVED = 0x1
	// Position of SR field.
	ETHERNET_DMA_OP_MODE_SR_Pos = 0x1
	// Bit mask of SR field.
	ETHERNET_DMA_OP_MODE_SR_Msk = 0x2
	// Bit SR.
	ETHERNET_DMA_OP_MODE_SR = 0x2
	// Position of OSF field.
	ETHERNET_DMA_OP_MODE_OSF_Pos = 0x2
	// Bit mask of OSF field.
	ETHERNET_DMA_OP_MODE_OSF_Msk = 0x4
	// Bit OSF.
	ETHERNET_DMA_OP_MODE_OSF = 0x4
	// Position of RTC field.
	ETHERNET_DMA_OP_MODE_RTC_Pos = 0x3
	// Bit mask of RTC field.
	ETHERNET_DMA_OP_MODE_RTC_Msk = 0x18
	// Position of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Msk = 0x20
	// Bit RESERVED.
	ETHERNET_DMA_OP_MODE_RESERVED = 0x20
	// Position of FUF field.
	ETHERNET_DMA_OP_MODE_FUF_Pos = 0x6
	// Bit mask of FUF field.
	ETHERNET_DMA_OP_MODE_FUF_Msk = 0x40
	// Bit FUF.
	ETHERNET_DMA_OP_MODE_FUF = 0x40
	// Position of FEF field.
	ETHERNET_DMA_OP_MODE_FEF_Pos = 0x7
	// Bit mask of FEF field.
	ETHERNET_DMA_OP_MODE_FEF_Msk = 0x80
	// Bit FEF.
	ETHERNET_DMA_OP_MODE_FEF = 0x80
	// Position of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Msk = 0x1f00
	// Position of ST field.
	ETHERNET_DMA_OP_MODE_ST_Pos = 0xd
	// Bit mask of ST field.
	ETHERNET_DMA_OP_MODE_ST_Msk = 0x2000
	// Bit ST.
	ETHERNET_DMA_OP_MODE_ST = 0x2000
	// Position of TTC field.
	ETHERNET_DMA_OP_MODE_TTC_Pos = 0xe
	// Bit mask of TTC field.
	ETHERNET_DMA_OP_MODE_TTC_Msk = 0x1c000
	// Position of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Msk = 0xe0000
	// Position of FTF field.
	ETHERNET_DMA_OP_MODE_FTF_Pos = 0x14
	// Bit mask of FTF field.
	ETHERNET_DMA_OP_MODE_FTF_Msk = 0x100000
	// Bit FTF.
	ETHERNET_DMA_OP_MODE_FTF = 0x100000
	// Position of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Msk = 0x200000
	// Bit RESERVED.
	ETHERNET_DMA_OP_MODE_RESERVED = 0x200000
	// Position of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Msk = 0xc00000
	// Position of DFF field.
	ETHERNET_DMA_OP_MODE_DFF_Pos = 0x18
	// Bit mask of DFF field.
	ETHERNET_DMA_OP_MODE_DFF_Msk = 0x1000000
	// Bit DFF.
	ETHERNET_DMA_OP_MODE_DFF = 0x1000000
	// Position of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Msk = 0x2000000
	// Bit RESERVED.
	ETHERNET_DMA_OP_MODE_RESERVED = 0x2000000
	// Position of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Msk = 0x4000000
	// Bit RESERVED.
	ETHERNET_DMA_OP_MODE_RESERVED = 0x4000000
	// Position of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	ETHERNET_DMA_OP_MODE_RESERVED_Msk = 0xf8000000

	// DMA_INT_EN: Interrupt enable register
	// Position of TIE field.
	ETHERNET_DMA_INT_EN_TIE_Pos = 0x0
	// Bit mask of TIE field.
	ETHERNET_DMA_INT_EN_TIE_Msk = 0x1
	// Bit TIE.
	ETHERNET_DMA_INT_EN_TIE = 0x1
	// Position of TSE field.
	ETHERNET_DMA_INT_EN_TSE_Pos = 0x1
	// Bit mask of TSE field.
	ETHERNET_DMA_INT_EN_TSE_Msk = 0x2
	// Bit TSE.
	ETHERNET_DMA_INT_EN_TSE = 0x2
	// Position of TUE field.
	ETHERNET_DMA_INT_EN_TUE_Pos = 0x2
	// Bit mask of TUE field.
	ETHERNET_DMA_INT_EN_TUE_Msk = 0x4
	// Bit TUE.
	ETHERNET_DMA_INT_EN_TUE = 0x4
	// Position of TJE field.
	ETHERNET_DMA_INT_EN_TJE_Pos = 0x3
	// Bit mask of TJE field.
	ETHERNET_DMA_INT_EN_TJE_Msk = 0x8
	// Bit TJE.
	ETHERNET_DMA_INT_EN_TJE = 0x8
	// Position of OVE field.
	ETHERNET_DMA_INT_EN_OVE_Pos = 0x4
	// Bit mask of OVE field.
	ETHERNET_DMA_INT_EN_OVE_Msk = 0x10
	// Bit OVE.
	ETHERNET_DMA_INT_EN_OVE = 0x10
	// Position of UNE field.
	ETHERNET_DMA_INT_EN_UNE_Pos = 0x5
	// Bit mask of UNE field.
	ETHERNET_DMA_INT_EN_UNE_Msk = 0x20
	// Bit UNE.
	ETHERNET_DMA_INT_EN_UNE = 0x20
	// Position of RIE field.
	ETHERNET_DMA_INT_EN_RIE_Pos = 0x6
	// Bit mask of RIE field.
	ETHERNET_DMA_INT_EN_RIE_Msk = 0x40
	// Bit RIE.
	ETHERNET_DMA_INT_EN_RIE = 0x40
	// Position of RUE field.
	ETHERNET_DMA_INT_EN_RUE_Pos = 0x7
	// Bit mask of RUE field.
	ETHERNET_DMA_INT_EN_RUE_Msk = 0x80
	// Bit RUE.
	ETHERNET_DMA_INT_EN_RUE = 0x80
	// Position of RSE field.
	ETHERNET_DMA_INT_EN_RSE_Pos = 0x8
	// Bit mask of RSE field.
	ETHERNET_DMA_INT_EN_RSE_Msk = 0x100
	// Bit RSE.
	ETHERNET_DMA_INT_EN_RSE = 0x100
	// Position of RWE field.
	ETHERNET_DMA_INT_EN_RWE_Pos = 0x9
	// Bit mask of RWE field.
	ETHERNET_DMA_INT_EN_RWE_Msk = 0x200
	// Bit RWE.
	ETHERNET_DMA_INT_EN_RWE = 0x200
	// Position of ETE field.
	ETHERNET_DMA_INT_EN_ETE_Pos = 0xa
	// Bit mask of ETE field.
	ETHERNET_DMA_INT_EN_ETE_Msk = 0x400
	// Bit ETE.
	ETHERNET_DMA_INT_EN_ETE = 0x400
	// Position of RESERVED field.
	ETHERNET_DMA_INT_EN_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ETHERNET_DMA_INT_EN_RESERVED_Msk = 0x1800
	// Position of FBE field.
	ETHERNET_DMA_INT_EN_FBE_Pos = 0xd
	// Bit mask of FBE field.
	ETHERNET_DMA_INT_EN_FBE_Msk = 0x2000
	// Bit FBE.
	ETHERNET_DMA_INT_EN_FBE = 0x2000
	// Position of ERE field.
	ETHERNET_DMA_INT_EN_ERE_Pos = 0xe
	// Bit mask of ERE field.
	ETHERNET_DMA_INT_EN_ERE_Msk = 0x4000
	// Bit ERE.
	ETHERNET_DMA_INT_EN_ERE = 0x4000
	// Position of AIE field.
	ETHERNET_DMA_INT_EN_AIE_Pos = 0xf
	// Bit mask of AIE field.
	ETHERNET_DMA_INT_EN_AIE_Msk = 0x8000
	// Bit AIE.
	ETHERNET_DMA_INT_EN_AIE = 0x8000
	// Position of NIE field.
	ETHERNET_DMA_INT_EN_NIE_Pos = 0x10
	// Bit mask of NIE field.
	ETHERNET_DMA_INT_EN_NIE_Msk = 0x10000
	// Bit NIE.
	ETHERNET_DMA_INT_EN_NIE = 0x10000
	// Position of RESERVED field.
	ETHERNET_DMA_INT_EN_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	ETHERNET_DMA_INT_EN_RESERVED_Msk = 0xfffe0000

	// DMA_MFRM_BUFOF: Missed frame and buffer overflow register
	// Position of FMC field.
	ETHERNET_DMA_MFRM_BUFOF_FMC_Pos = 0x0
	// Bit mask of FMC field.
	ETHERNET_DMA_MFRM_BUFOF_FMC_Msk = 0xffff
	// Position of OC field.
	ETHERNET_DMA_MFRM_BUFOF_OC_Pos = 0x10
	// Bit mask of OC field.
	ETHERNET_DMA_MFRM_BUFOF_OC_Msk = 0x10000
	// Bit OC.
	ETHERNET_DMA_MFRM_BUFOF_OC = 0x10000
	// Position of FMA field.
	ETHERNET_DMA_MFRM_BUFOF_FMA_Pos = 0x11
	// Bit mask of FMA field.
	ETHERNET_DMA_MFRM_BUFOF_FMA_Msk = 0xffe0000
	// Position of OF field.
	ETHERNET_DMA_MFRM_BUFOF_OF_Pos = 0x1c
	// Bit mask of OF field.
	ETHERNET_DMA_MFRM_BUFOF_OF_Msk = 0x10000000
	// Bit OF.
	ETHERNET_DMA_MFRM_BUFOF_OF = 0x10000000
	// Position of RESERVED field.
	ETHERNET_DMA_MFRM_BUFOF_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	ETHERNET_DMA_MFRM_BUFOF_RESERVED_Msk = 0xe0000000

	// DMA_REC_INT_WDT: Receive interrupt watchdog timer register
	// Position of RIWT field.
	ETHERNET_DMA_REC_INT_WDT_RIWT_Pos = 0x0
	// Bit mask of RIWT field.
	ETHERNET_DMA_REC_INT_WDT_RIWT_Msk = 0xff
	// Position of RESERVED field.
	ETHERNET_DMA_REC_INT_WDT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ETHERNET_DMA_REC_INT_WDT_RESERVED_Msk = 0xffffff00

	// DMA_CURHOST_TRANS_DES: Current host transmit descriptor register
	// Position of HTD field.
	ETHERNET_DMA_CURHOST_TRANS_DES_HTD_Pos = 0x0
	// Bit mask of HTD field.
	ETHERNET_DMA_CURHOST_TRANS_DES_HTD_Msk = 0xffffffff

	// DMA_CURHOST_REC_DES: Current host receive descriptor register
	// Position of HRD field.
	ETHERNET_DMA_CURHOST_REC_DES_HRD_Pos = 0x0
	// Bit mask of HRD field.
	ETHERNET_DMA_CURHOST_REC_DES_HRD_Msk = 0xffffffff

	// DMA_CURHOST_TRANS_BUF: Current host transmit buffer address register
	// Position of HTB field.
	ETHERNET_DMA_CURHOST_TRANS_BUF_HTB_Pos = 0x0
	// Bit mask of HTB field.
	ETHERNET_DMA_CURHOST_TRANS_BUF_HTB_Msk = 0xffffffff

	// DMA_CURHOST_REC_BUF: Current host receive buffer address register
	// Position of HRB field.
	ETHERNET_DMA_CURHOST_REC_BUF_HRB_Pos = 0x0
	// Bit mask of HRB field.
	ETHERNET_DMA_CURHOST_REC_BUF_HRB_Msk = 0xffffffff
)

// Bitfields for ATIMER: Alarm timer
const (
	// DOWNCOUNTER: Downcounter register
	// Position of CVAL field.
	ATIMER_DOWNCOUNTER_CVAL_Pos = 0x0
	// Bit mask of CVAL field.
	ATIMER_DOWNCOUNTER_CVAL_Msk = 0xffff
	// Position of RESERVED field.
	ATIMER_DOWNCOUNTER_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ATIMER_DOWNCOUNTER_RESERVED_Msk = 0xffff0000

	// PRESET: Preset value register
	// Position of PRESETVAL field.
	ATIMER_PRESET_PRESETVAL_Pos = 0x0
	// Bit mask of PRESETVAL field.
	ATIMER_PRESET_PRESETVAL_Msk = 0xffff
	// Position of RESERVED field.
	ATIMER_PRESET_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ATIMER_PRESET_RESERVED_Msk = 0xffff0000

	// CLR_EN: Interrupt clear enable register
	// Position of CLR_EN field.
	ATIMER_CLR_EN_CLR_EN_Pos = 0x0
	// Bit mask of CLR_EN field.
	ATIMER_CLR_EN_CLR_EN_Msk = 0x1
	// Bit CLR_EN.
	ATIMER_CLR_EN_CLR_EN = 0x1
	// Position of RESERVED field.
	ATIMER_CLR_EN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	ATIMER_CLR_EN_RESERVED_Msk = 0xfffffffe

	// SET_EN: Interrupt set enable register
	// Position of SET_EN field.
	ATIMER_SET_EN_SET_EN_Pos = 0x0
	// Bit mask of SET_EN field.
	ATIMER_SET_EN_SET_EN_Msk = 0x1
	// Bit SET_EN.
	ATIMER_SET_EN_SET_EN = 0x1
	// Position of RESERVED field.
	ATIMER_SET_EN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	ATIMER_SET_EN_RESERVED_Msk = 0xfffffffe

	// STATUS: Status register
	// Position of STAT field.
	ATIMER_STATUS_STAT_Pos = 0x0
	// Bit mask of STAT field.
	ATIMER_STATUS_STAT_Msk = 0x1
	// Bit STAT.
	ATIMER_STATUS_STAT = 0x1
	// Position of RESERVED field.
	ATIMER_STATUS_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	ATIMER_STATUS_RESERVED_Msk = 0xfffffffe

	// ENABLE: Enable register
	// Position of EN field.
	ATIMER_ENABLE_EN_Pos = 0x0
	// Bit mask of EN field.
	ATIMER_ENABLE_EN_Msk = 0x1
	// Bit EN.
	ATIMER_ENABLE_EN = 0x1
	// Position of RESERVED field.
	ATIMER_ENABLE_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	ATIMER_ENABLE_RESERVED_Msk = 0xfffffffe

	// CLR_STAT: Clear register
	// Position of CSTAT field.
	ATIMER_CLR_STAT_CSTAT_Pos = 0x0
	// Bit mask of CSTAT field.
	ATIMER_CLR_STAT_CSTAT_Msk = 0x1
	// Bit CSTAT.
	ATIMER_CLR_STAT_CSTAT = 0x1
	// Position of RESERVED field.
	ATIMER_CLR_STAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	ATIMER_CLR_STAT_RESERVED_Msk = 0xfffffffe

	// SET_STAT: Set register
	// Position of SSTAT field.
	ATIMER_SET_STAT_SSTAT_Pos = 0x0
	// Bit mask of SSTAT field.
	ATIMER_SET_STAT_SSTAT_Msk = 0x1
	// Bit SSTAT.
	ATIMER_SET_STAT_SSTAT = 0x1
	// Position of RESERVED field.
	ATIMER_SET_STAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	ATIMER_SET_STAT_RESERVED_Msk = 0xfffffffe
)

// Bitfields for REGFILE: RTC REGFILE
const (
	// REGFILE: General purpose storage register
	// Position of REGVAL field.
	REGFILE_REGFILE_REGVAL_Pos = 0x0
	// Bit mask of REGVAL field.
	REGFILE_REGFILE_REGVAL_Msk = 0xffffffff
)

// Bitfields for PMC: Power Management Controller (PMC)
const (
	// PD0_SLEEP0_HW_ENA: Hardware sleep event enable register
	// Position of ENA_EVENT0 field.
	PMC_PD0_SLEEP0_HW_ENA_ENA_EVENT0_Pos = 0x0
	// Bit mask of ENA_EVENT0 field.
	PMC_PD0_SLEEP0_HW_ENA_ENA_EVENT0_Msk = 0x1
	// Bit ENA_EVENT0.
	PMC_PD0_SLEEP0_HW_ENA_ENA_EVENT0 = 0x1
	// Position of RESERVED field.
	PMC_PD0_SLEEP0_HW_ENA_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	PMC_PD0_SLEEP0_HW_ENA_RESERVED_Msk = 0xfffffffe

	// PD0_SLEEP0_MODE: Sleep power mode register
	// Position of PWR_STATE field.
	PMC_PD0_SLEEP0_MODE_PWR_STATE_Pos = 0x0
	// Bit mask of PWR_STATE field.
	PMC_PD0_SLEEP0_MODE_PWR_STATE_Msk = 0xffffffff
)

// Bitfields for CREG: Configuration Registers (CREG)
const (
	// CREG0: Chip configuration register 32 kHz oscillator output and BOD control register.
	// Position of EN1KHZ field.
	CREG_CREG0_EN1KHZ_Pos = 0x0
	// Bit mask of EN1KHZ field.
	CREG_CREG0_EN1KHZ_Msk = 0x1
	// Bit EN1KHZ.
	CREG_CREG0_EN1KHZ = 0x1
	// 1 kHz output disabled.
	CREG_CREG0_EN1KHZ_1_KHZ_OUTPUT_DISABLE = 0x0
	// 1 kHz output enabled.
	CREG_CREG0_EN1KHZ_1_KHZ_OUTPUT_ENABLED = 0x1
	// Position of EN32KHZ field.
	CREG_CREG0_EN32KHZ_Pos = 0x1
	// Bit mask of EN32KHZ field.
	CREG_CREG0_EN32KHZ_Msk = 0x2
	// Bit EN32KHZ.
	CREG_CREG0_EN32KHZ = 0x2
	// 32 kHz output disabled.
	CREG_CREG0_EN32KHZ_32_KHZ_OUTPUT_DISABL = 0x0
	// 32 kHz output enabled.
	CREG_CREG0_EN32KHZ_32_KHZ_OUTPUT_ENABLE = 0x1
	// Position of RESET32KHZ field.
	CREG_CREG0_RESET32KHZ_Pos = 0x2
	// Bit mask of RESET32KHZ field.
	CREG_CREG0_RESET32KHZ_Msk = 0x4
	// Bit RESET32KHZ.
	CREG_CREG0_RESET32KHZ = 0x4
	// Clear reset.
	CREG_CREG0_RESET32KHZ_CLEAR_RESET = 0x0
	// Reset active.
	CREG_CREG0_RESET32KHZ_RESET_ACTIVE = 0x1
	// Position of PD32KHZ field.
	CREG_CREG0_PD32KHZ_Pos = 0x3
	// Bit mask of PD32KHZ field.
	CREG_CREG0_PD32KHZ_Msk = 0x8
	// Bit PD32KHZ.
	CREG_CREG0_PD32KHZ = 0x8
	// Powered.
	CREG_CREG0_PD32KHZ_POWERED = 0x0
	// Powered-down.
	CREG_CREG0_PD32KHZ_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	CREG_CREG0_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CREG_CREG0_RESERVED_Msk = 0x10
	// Bit RESERVED.
	CREG_CREG0_RESERVED = 0x10
	// Position of USB0PHY field.
	CREG_CREG0_USB0PHY_Pos = 0x5
	// Bit mask of USB0PHY field.
	CREG_CREG0_USB0PHY_Msk = 0x20
	// Bit USB0PHY.
	CREG_CREG0_USB0PHY = 0x20
	// Enable USB0 PHY power.
	CREG_CREG0_USB0PHY_ENABLE_USB0_PHY_POWE = 0x0
	// Disable USB0 PHY. PHY powered down.
	CREG_CREG0_USB0PHY_DISABLE_USB0_PHY = 0x1
	// Position of ALARMCTRL field.
	CREG_CREG0_ALARMCTRL_Pos = 0x6
	// Bit mask of ALARMCTRL field.
	CREG_CREG0_ALARMCTRL_Msk = 0xc0
	// RTC alarm.
	CREG_CREG0_ALARMCTRL_RTC_ALARM = 0x0
	// Event router event.
	CREG_CREG0_ALARMCTRL_EVENT_ROUTER_EVENT = 0x1
	// Inactive.
	CREG_CREG0_ALARMCTRL_INACTIVE = 0x3
	// Position of BODLVL1 field.
	CREG_CREG0_BODLVL1_Pos = 0x8
	// Bit mask of BODLVL1 field.
	CREG_CREG0_BODLVL1_Msk = 0x300
	// Level 0 interrupt
	CREG_CREG0_BODLVL1_LEVEL_0_INTERRUPT = 0x0
	// Level 1 interrupt
	CREG_CREG0_BODLVL1_LEVEL_1_INTERRUPT = 0x1
	// Level 2 interrupt
	CREG_CREG0_BODLVL1_LEVEL_2_INTERRUPT = 0x2
	// Level 3 interrupt
	CREG_CREG0_BODLVL1_LEVEL_3_INTERRUPT = 0x3
	// Position of BODLVL2 field.
	CREG_CREG0_BODLVL2_Pos = 0xa
	// Bit mask of BODLVL2 field.
	CREG_CREG0_BODLVL2_Msk = 0xc00
	// Level 0 reset
	CREG_CREG0_BODLVL2_LEVEL_0_RESET = 0x0
	// Level 1 reset
	CREG_CREG0_BODLVL2_LEVEL_1_RESET = 0x1
	// Level 2 reset
	CREG_CREG0_BODLVL2_LEVEL_2_RESET = 0x2
	// Level 3 reset
	CREG_CREG0_BODLVL2_LEVEL_3_RESET = 0x3
	// Position of SAMPLECTRL field.
	CREG_CREG0_SAMPLECTRL_Pos = 0xc
	// Bit mask of SAMPLECTRL field.
	CREG_CREG0_SAMPLECTRL_Msk = 0x3000
	// Sample output from the event monitor/recorder.
	CREG_CREG0_SAMPLECTRL_SAMPLE_OUTPUT_FROM_T = 0x1
	// Output from the event router.
	CREG_CREG0_SAMPLECTRL_OUTPUT_FROM_THE_EVEN = 0x2
	// Position of WAKEUP0CTRL field.
	CREG_CREG0_WAKEUP0CTRL_Pos = 0xe
	// Bit mask of WAKEUP0CTRL field.
	CREG_CREG0_WAKEUP0CTRL_Msk = 0xc000
	// Output from the event router.
	CREG_CREG0_WAKEUP0CTRL_OUTPUT_FROM_THE_EVEN = 0x1
	// Position of WAKEUP1CTRL field.
	CREG_CREG0_WAKEUP1CTRL_Pos = 0x10
	// Bit mask of WAKEUP1CTRL field.
	CREG_CREG0_WAKEUP1CTRL_Msk = 0x30000
	// Output from the event router.
	CREG_CREG0_WAKEUP1CTRL_OUTPUT_FROM_THE_EVEN = 0x1
	// Position of RESERVED field.
	CREG_CREG0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	CREG_CREG0_RESERVED_Msk = 0xfffc0000

	// M3MEMMAP: ARM Cortex-M3 memory mapping
	// Position of M3MAP field.
	CREG_M3MEMMAP_M3MAP_Pos = 0xc
	// Bit mask of M3MAP field.
	CREG_M3MEMMAP_M3MAP_Msk = 0xfffff000

	// CREG5: Chip configuration register 5. Controls JTAG access.
	// Position of RESERVED field.
	CREG_CREG5_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CREG_CREG5_RESERVED_Msk = 0x7ff
	// Position of M3TAPSEL field.
	CREG_CREG5_M3TAPSEL_Pos = 0xb
	// Bit mask of M3TAPSEL field.
	CREG_CREG5_M3TAPSEL_Msk = 0x800
	// Bit M3TAPSEL.
	CREG_CREG5_M3TAPSEL = 0x800
	// No effect.
	CREG_CREG5_M3TAPSEL_NO_EFFECT = 0x0
	// Disable JTAG debug. Once JTAG is disabled, JTAG access remains disabled until the chip is reset by any source.
	CREG_CREG5_M3TAPSEL_DISABLE_JTAG_DEBUG = 0x1
	// Position of RESERVED field.
	CREG_CREG5_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CREG_CREG5_RESERVED_Msk = 0xfffff000

	// DMAMUX: DMA mux control
	// Position of DMAMUXPER0 field.
	CREG_DMAMUX_DMAMUXPER0_Pos = 0x0
	// Bit mask of DMAMUXPER0 field.
	CREG_DMAMUX_DMAMUXPER0_Msk = 0x3
	// SPIFI
	CREG_DMAMUX_DMAMUXPER0_SPIFI = 0x0
	// SCT CTOUT_2
	CREG_DMAMUX_DMAMUXPER0_SCT_CTOUT_2 = 0x1
	// Timer3 match 1
	CREG_DMAMUX_DMAMUXPER0_TIMER3_MATCH_1 = 0x3
	// Position of DMAMUXPER1 field.
	CREG_DMAMUX_DMAMUXPER1_Pos = 0x2
	// Bit mask of DMAMUXPER1 field.
	CREG_DMAMUX_DMAMUXPER1_Msk = 0xc
	// Timer0 match 0
	CREG_DMAMUX_DMAMUXPER1_TIMER0_MATCH_0 = 0x0
	// USART0 transmit
	CREG_DMAMUX_DMAMUXPER1_USART0_TRANSMIT = 0x1
	// Position of DMAMUXPER2 field.
	CREG_DMAMUX_DMAMUXPER2_Pos = 0x4
	// Bit mask of DMAMUXPER2 field.
	CREG_DMAMUX_DMAMUXPER2_Msk = 0x30
	// Timer0 match 1
	CREG_DMAMUX_DMAMUXPER2_TIMER0_MATCH_1 = 0x0
	// USART0 receive
	CREG_DMAMUX_DMAMUXPER2_USART0_RECEIVE = 0x1
	// Position of DMAMUXPER3 field.
	CREG_DMAMUX_DMAMUXPER3_Pos = 0x6
	// Bit mask of DMAMUXPER3 field.
	CREG_DMAMUX_DMAMUXPER3_Msk = 0xc0
	// Timer1 match 0
	CREG_DMAMUX_DMAMUXPER3_TIMER1_MATCH_0 = 0x0
	// UART1 transmit
	CREG_DMAMUX_DMAMUXPER3_UART1_TRANSMIT = 0x1
	// I2S1 DMA request 1
	CREG_DMAMUX_DMAMUXPER3_I2S1_DMA_REQUEST_1 = 0x2
	// SSP1 transmit
	CREG_DMAMUX_DMAMUXPER3_SSP1_TRANSMIT = 0x3
	// Position of DMAMUXPER4 field.
	CREG_DMAMUX_DMAMUXPER4_Pos = 0x8
	// Bit mask of DMAMUXPER4 field.
	CREG_DMAMUX_DMAMUXPER4_Msk = 0x300
	// Timer1 match 1
	CREG_DMAMUX_DMAMUXPER4_TIMER1_MATCH_1 = 0x0
	// UART1 receive
	CREG_DMAMUX_DMAMUXPER4_UART1_RECEIVE = 0x1
	// I2S1 DMA request 2
	CREG_DMAMUX_DMAMUXPER4_I2S1_DMA_REQUEST_2 = 0x2
	// SSP1 receive
	CREG_DMAMUX_DMAMUXPER4_SSP1_RECEIVE = 0x3
	// Position of DMAMUXPER5 field.
	CREG_DMAMUX_DMAMUXPER5_Pos = 0xa
	// Bit mask of DMAMUXPER5 field.
	CREG_DMAMUX_DMAMUXPER5_Msk = 0xc00
	// Timer2 match 0
	CREG_DMAMUX_DMAMUXPER5_TIMER2_MATCH_0 = 0x0
	// USART2 transmit
	CREG_DMAMUX_DMAMUXPER5_USART2_TRANSMIT = 0x1
	// SSP1 transmit
	CREG_DMAMUX_DMAMUXPER5_SSP1_TRANSMIT = 0x2
	// Position of DMAMUXPER6 field.
	CREG_DMAMUX_DMAMUXPER6_Pos = 0xc
	// Bit mask of DMAMUXPER6 field.
	CREG_DMAMUX_DMAMUXPER6_Msk = 0x3000
	// Timer2 match 1
	CREG_DMAMUX_DMAMUXPER6_TIMER2_MATCH_1 = 0x0
	// USART2 receive
	CREG_DMAMUX_DMAMUXPER6_USART2_RECEIVE = 0x1
	// SSP1 receive
	CREG_DMAMUX_DMAMUXPER6_SSP1_RECEIVE = 0x2
	// Position of DMAMUXPER7 field.
	CREG_DMAMUX_DMAMUXPER7_Pos = 0xe
	// Bit mask of DMAMUXPER7 field.
	CREG_DMAMUX_DMAMUXPER7_Msk = 0xc000
	// Timer3 match 0
	CREG_DMAMUX_DMAMUXPER7_TIMER3_MATCH_0 = 0x0
	// USART3 transmit
	CREG_DMAMUX_DMAMUXPER7_USART3_TRANSMIT = 0x1
	// SCT DMA request 0
	CREG_DMAMUX_DMAMUXPER7_SCT_DMA_REQUEST_0 = 0x2
	// Position of DMAMUXPER8 field.
	CREG_DMAMUX_DMAMUXPER8_Pos = 0x10
	// Bit mask of DMAMUXPER8 field.
	CREG_DMAMUX_DMAMUXPER8_Msk = 0x30000
	// Timer3 match 1
	CREG_DMAMUX_DMAMUXPER8_TIMER3_MATCH_1 = 0x0
	// USART3 receive
	CREG_DMAMUX_DMAMUXPER8_USART3_RECEIVE = 0x1
	// SCT DMA request 1
	CREG_DMAMUX_DMAMUXPER8_SCT_DMA_REQUEST_1 = 0x2
	// Position of DMAMUXPER9 field.
	CREG_DMAMUX_DMAMUXPER9_Pos = 0x12
	// Bit mask of DMAMUXPER9 field.
	CREG_DMAMUX_DMAMUXPER9_Msk = 0xc0000
	// SSP0 receive
	CREG_DMAMUX_DMAMUXPER9_SSP0_RECEIVE = 0x0
	// I2S0 DMA request 1
	CREG_DMAMUX_DMAMUXPER9_I2S0_DMA_REQUEST_1 = 0x1
	// SCT DMA request 1
	CREG_DMAMUX_DMAMUXPER9_SCT_DMA_REQUEST_1 = 0x2
	// Position of DMAMUXPER10 field.
	CREG_DMAMUX_DMAMUXPER10_Pos = 0x14
	// Bit mask of DMAMUXPER10 field.
	CREG_DMAMUX_DMAMUXPER10_Msk = 0x300000
	// SSP0 transmit
	CREG_DMAMUX_DMAMUXPER10_SSP0_TRANSMIT = 0x0
	// I2S0 DMA request 2
	CREG_DMAMUX_DMAMUXPER10_I2S0_DMA_REQUEST_2 = 0x1
	// SCT DMA request 0
	CREG_DMAMUX_DMAMUXPER10_SCT_DMA_REQUEST_0 = 0x2
	// Position of DMAMUXPER11 field.
	CREG_DMAMUX_DMAMUXPER11_Pos = 0x16
	// Bit mask of DMAMUXPER11 field.
	CREG_DMAMUX_DMAMUXPER11_Msk = 0xc00000
	// SSP1 receive
	CREG_DMAMUX_DMAMUXPER11_SSP1_RECEIVE = 0x0
	// USART0 transmit
	CREG_DMAMUX_DMAMUXPER11_USART0_TRANSMIT = 0x2
	// Position of DMAMUXPER12 field.
	CREG_DMAMUX_DMAMUXPER12_Pos = 0x18
	// Bit mask of DMAMUXPER12 field.
	CREG_DMAMUX_DMAMUXPER12_Msk = 0x3000000
	// SSP1 transmit
	CREG_DMAMUX_DMAMUXPER12_SSP1_TRANSMIT = 0x0
	// USART0 receive
	CREG_DMAMUX_DMAMUXPER12_USART0_RECEIVE = 0x2
	// Position of DMAMUXPER13 field.
	CREG_DMAMUX_DMAMUXPER13_Pos = 0x1a
	// Bit mask of DMAMUXPER13 field.
	CREG_DMAMUX_DMAMUXPER13_Msk = 0xc000000
	// ADC0
	CREG_DMAMUX_DMAMUXPER13_ADC0 = 0x0
	// SSP1 receive
	CREG_DMAMUX_DMAMUXPER13_SSP1_RECEIVE = 0x2
	// USART3 receive
	CREG_DMAMUX_DMAMUXPER13_USART3_RECEIVE = 0x3
	// Position of DMAMUXPER14 field.
	CREG_DMAMUX_DMAMUXPER14_Pos = 0x1c
	// Bit mask of DMAMUXPER14 field.
	CREG_DMAMUX_DMAMUXPER14_Msk = 0x30000000
	// ADC1
	CREG_DMAMUX_DMAMUXPER14_ADC1 = 0x0
	// SSP1 transmit
	CREG_DMAMUX_DMAMUXPER14_SSP1_TRANSMIT = 0x2
	// USART3 transmit
	CREG_DMAMUX_DMAMUXPER14_USART3_TRANSMIT = 0x3
	// Position of DMAMUXPER15 field.
	CREG_DMAMUX_DMAMUXPER15_Pos = 0x1e
	// Bit mask of DMAMUXPER15 field.
	CREG_DMAMUX_DMAMUXPER15_Msk = 0xc0000000
	// DAC
	CREG_DMAMUX_DMAMUXPER15_DAC = 0x0
	// SCT CTOUT_3
	CREG_DMAMUX_DMAMUXPER15_SCT_CTOUT_3 = 0x1
	// Timer3 match 0
	CREG_DMAMUX_DMAMUXPER15_TIMER3_MATCH_0 = 0x3

	// FLASHCFGA: Flash accelerator configuration register for flash bank A
	// Position of RESERVED field.
	CREG_FLASHCFGA_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CREG_FLASHCFGA_RESERVED_Msk = 0xfff
	// Position of FLASHTIM field.
	CREG_FLASHCFGA_FLASHTIM_Pos = 0xc
	// Bit mask of FLASHTIM field.
	CREG_FLASHCFGA_FLASHTIM_Msk = 0xf000
	// 1 BASE_M3_CLK clock. Use for BASE_M3_CLK up to 21 MHz.
	CREG_FLASHCFGA_FLASHTIM_1_BASE_M3_CLK_CLOCK = 0x0
	// 2 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 43 MHz.
	CREG_FLASHCFGA_FLASHTIM_2_BASE_M3_CLK_CLOCKS = 0x1
	// 3 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 64 MHz.
	CREG_FLASHCFGA_FLASHTIM_3_BASE_M3_CLK_CLOCKS = 0x2
	// 4 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 86 MHz.
	CREG_FLASHCFGA_FLASHTIM_4_BASE_M3_CLK_CLOCKS = 0x3
	// 5 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 107 MHz.
	CREG_FLASHCFGA_FLASHTIM_5_BASE_M3_CLK_CLOCKS = 0x4
	// 6 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 129 MHz.
	CREG_FLASHCFGA_FLASHTIM_6_BASE_M3_CLK_CLOCKS = 0x5
	// 7 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 150 MHz.
	CREG_FLASHCFGA_FLASHTIM_7_BASE_M3_CLK_CLOCKS = 0x6
	// 8 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 172 MHz.
	CREG_FLASHCFGA_FLASHTIM_8_BASE_M3_CLK_CLOCKS = 0x7
	// 9 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 180 MHz.
	CREG_FLASHCFGA_FLASHTIM_9_BASE_M3_CLK_CLOCKS = 0x8
	// Position of RESERVED field.
	CREG_FLASHCFGA_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CREG_FLASHCFGA_RESERVED_Msk = 0x7fff0000
	// Position of POW field.
	CREG_FLASHCFGA_POW_Pos = 0x1f
	// Bit mask of POW field.
	CREG_FLASHCFGA_POW_Msk = 0x80000000
	// Bit POW.
	CREG_FLASHCFGA_POW = 0x80000000
	// Power-down
	CREG_FLASHCFGA_POW_POWER_DOWN = 0x0
	// Active (Default)
	CREG_FLASHCFGA_POW_ACTIVE = 0x1

	// FLASHCFGB: Flash accelerator configuration register for flash bank B
	// Position of RESERVED field.
	CREG_FLASHCFGB_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CREG_FLASHCFGB_RESERVED_Msk = 0xfff
	// Position of FLASHTIM field.
	CREG_FLASHCFGB_FLASHTIM_Pos = 0xc
	// Bit mask of FLASHTIM field.
	CREG_FLASHCFGB_FLASHTIM_Msk = 0xf000
	// 1 BASE_M3_CLK clock. Use for BASE_M3_CLK up to 21 MHz.
	CREG_FLASHCFGB_FLASHTIM_1_BASE_M3_CLK_CLOCK = 0x0
	// 2 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 43 MHz.
	CREG_FLASHCFGB_FLASHTIM_2_BASE_M3_CLK_CLOCKS = 0x1
	// 3 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 64 MHz.
	CREG_FLASHCFGB_FLASHTIM_3_BASE_M3_CLK_CLOCKS = 0x2
	// 4 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 86 MHz.
	CREG_FLASHCFGB_FLASHTIM_4_BASE_M3_CLK_CLOCKS = 0x3
	// 5 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 107 MHz.
	CREG_FLASHCFGB_FLASHTIM_5_BASE_M3_CLK_CLOCKS = 0x4
	// 6 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 129 MHz.
	CREG_FLASHCFGB_FLASHTIM_6_BASE_M3_CLK_CLOCKS = 0x5
	// 7 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 150 MHz.
	CREG_FLASHCFGB_FLASHTIM_7_BASE_M3_CLK_CLOCKS = 0x6
	// 8 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 172 MHz.
	CREG_FLASHCFGB_FLASHTIM_8_BASE_M3_CLK_CLOCKS = 0x7
	// 9 BASE_M3_CLK clocks. Use for BASE_M3_CLK up to 180 MHz.
	CREG_FLASHCFGB_FLASHTIM_9_BASE_M3_CLK_CLOCKS = 0x8
	// Position of RESERVED field.
	CREG_FLASHCFGB_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CREG_FLASHCFGB_RESERVED_Msk = 0x7fff0000
	// Position of POW field.
	CREG_FLASHCFGB_POW_Pos = 0x1f
	// Bit mask of POW field.
	CREG_FLASHCFGB_POW_Msk = 0x80000000
	// Bit POW.
	CREG_FLASHCFGB_POW = 0x80000000
	// Power-down
	CREG_FLASHCFGB_POW_POWER_DOWN = 0x0
	// Active (Default)
	CREG_FLASHCFGB_POW_ACTIVE = 0x1

	// ETBCFG: ETB RAM configuration
	// Position of ETB field.
	CREG_ETBCFG_ETB_Pos = 0x0
	// Bit mask of ETB field.
	CREG_ETBCFG_ETB_Msk = 0x1
	// Bit ETB.
	CREG_ETBCFG_ETB = 0x1
	// ETB accesses SRAM at address 0x2000 C000.
	CREG_ETBCFG_ETB_ETB_ACCESSES_SRAM_AT = 0x0
	// AHB accesses SRAM at address 0x2000 C000.
	CREG_ETBCFG_ETB_AHB_ACCESSES_SRAM_AT = 0x1
	// Position of RESERVED field.
	CREG_ETBCFG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CREG_ETBCFG_RESERVED_Msk = 0xfffffffe

	// CREG6: Chip configuration register 6. Controls multiple functions : Ethernet interface, SCT output, I2S0/1 inputs, EMC clock.
	// Position of ETHMODE field.
	CREG_CREG6_ETHMODE_Pos = 0x0
	// Bit mask of ETHMODE field.
	CREG_CREG6_ETHMODE_Msk = 0x7
	// MII
	CREG_CREG6_ETHMODE_MII = 0x0
	// RMII
	CREG_CREG6_ETHMODE_RMII = 0x4
	// Position of RESERVED field.
	CREG_CREG6_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CREG_CREG6_RESERVED_Msk = 0x8
	// Bit RESERVED.
	CREG_CREG6_RESERVED = 0x8
	// Position of CTOUTCTRL field.
	CREG_CREG6_CTOUTCTRL_Pos = 0x4
	// Bit mask of CTOUTCTRL field.
	CREG_CREG6_CTOUTCTRL_Msk = 0x10
	// Bit CTOUTCTRL.
	CREG_CREG6_CTOUTCTRL = 0x10
	// Combine SCT and timer match outputs. SCT outputs are Red with timer outputs.
	CREG_CREG6_CTOUTCTRL_COMBINE_SCT_AND_TIME = 0x0
	// SCT outputs only. SCT outputs are used without timer match outputs.
	CREG_CREG6_CTOUTCTRL_SCT_OUTPUTS_ONLY = 0x1
	// Position of RESERVED field.
	CREG_CREG6_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	CREG_CREG6_RESERVED_Msk = 0xfe0
	// Position of I2S0_TX_SCK_IN_SEL field.
	CREG_CREG6_I2S0_TX_SCK_IN_SEL_Pos = 0xc
	// Bit mask of I2S0_TX_SCK_IN_SEL field.
	CREG_CREG6_I2S0_TX_SCK_IN_SEL_Msk = 0x1000
	// Bit I2S0_TX_SCK_IN_SEL.
	CREG_CREG6_I2S0_TX_SCK_IN_SEL = 0x1000
	// I2S Register. I2S clock selected as defined by the I2S transmit mode register Table 960.
	CREG_CREG6_I2S0_TX_SCK_IN_SEL_I2S_REGISTER = 0x0
	// BASE_AUDIO_CLK for I2S transmit clock MCLK input and MCLK output. The I2S must be configured in slave mode.
	CREG_CREG6_I2S0_TX_SCK_IN_SEL_BASE_AUDIO_CLK_FOR_I = 0x1
	// Position of I2S0_RX_SCK_IN_SEL field.
	CREG_CREG6_I2S0_RX_SCK_IN_SEL_Pos = 0xd
	// Bit mask of I2S0_RX_SCK_IN_SEL field.
	CREG_CREG6_I2S0_RX_SCK_IN_SEL_Msk = 0x2000
	// Bit I2S0_RX_SCK_IN_SEL.
	CREG_CREG6_I2S0_RX_SCK_IN_SEL = 0x2000
	// I2S Register. I2S clock selected as defined by the I2S receive mode register Table 961.
	CREG_CREG6_I2S0_RX_SCK_IN_SEL_I2S_REGISTER = 0x0
	// BASE_AUDIO_CLK for I2S receive clock MCLK input and MCLK output. The I2S must be configured in slave mode.
	CREG_CREG6_I2S0_RX_SCK_IN_SEL_BASE_AUDIO_CLK_FOR_I = 0x1
	// Position of I2S1_TX_SCK_IN_SEL field.
	CREG_CREG6_I2S1_TX_SCK_IN_SEL_Pos = 0xe
	// Bit mask of I2S1_TX_SCK_IN_SEL field.
	CREG_CREG6_I2S1_TX_SCK_IN_SEL_Msk = 0x4000
	// Bit I2S1_TX_SCK_IN_SEL.
	CREG_CREG6_I2S1_TX_SCK_IN_SEL = 0x4000
	// I2S register. I2S clock selected as defined by the I2S transmit mode register Table 960.
	CREG_CREG6_I2S1_TX_SCK_IN_SEL_I2S_REGISTER = 0x0
	// BASE_AUDIO_CLK for I2S transmit clock MCLK input and MCLK output. The I2S must be configured in slave mode.
	CREG_CREG6_I2S1_TX_SCK_IN_SEL_BASE_AUDIO_CLK_FOR_I = 0x1
	// Position of I2S1_RX_SCK_IN_SEL field.
	CREG_CREG6_I2S1_RX_SCK_IN_SEL_Pos = 0xf
	// Bit mask of I2S1_RX_SCK_IN_SEL field.
	CREG_CREG6_I2S1_RX_SCK_IN_SEL_Msk = 0x8000
	// Bit I2S1_RX_SCK_IN_SEL.
	CREG_CREG6_I2S1_RX_SCK_IN_SEL = 0x8000
	// I2S register. I2S clock selected as defined by the I2S receive mode register Table 961.
	CREG_CREG6_I2S1_RX_SCK_IN_SEL_I2S_REGISTER = 0x0
	// BASE_AUDIO_CLK for I2S receive clock MCLK input and MCLK output. The I2S must be configured in slave mode.
	CREG_CREG6_I2S1_RX_SCK_IN_SEL_BASE_AUDIO_CLK_FOR_I = 0x1
	// Position of EMC_CLK_SEL field.
	CREG_CREG6_EMC_CLK_SEL_Pos = 0x10
	// Bit mask of EMC_CLK_SEL field.
	CREG_CREG6_EMC_CLK_SEL_Msk = 0x10000
	// Bit EMC_CLK_SEL.
	CREG_CREG6_EMC_CLK_SEL = 0x10000
	// Divide by 1. EMC_CLK_DIV not divided.
	CREG_CREG6_EMC_CLK_SEL_DIVIDE_BY_1 = 0x0
	// Divide by 2. EMC_CLK_DIV divided by 2.
	CREG_CREG6_EMC_CLK_SEL_DIVIDE_BY_2 = 0x1
	// Position of RESERVED field.
	CREG_CREG6_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	CREG_CREG6_RESERVED_Msk = 0xfffe0000

	// CHIPID: Part ID
	// Position of ID field.
	CREG_CHIPID_ID_Pos = 0x0
	// Bit mask of ID field.
	CREG_CHIPID_ID_Msk = 0xffffffff

	// USB0FLADJ: USB0 frame length adjust register
	// Position of FLTV field.
	CREG_USB0FLADJ_FLTV_Pos = 0x0
	// Bit mask of FLTV field.
	CREG_USB0FLADJ_FLTV_Msk = 0x3f
	// Position of RESERVED field.
	CREG_USB0FLADJ_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CREG_USB0FLADJ_RESERVED_Msk = 0xffffffc0

	// USB1FLADJ: USB1 frame length adjust register
	// Position of FLTV field.
	CREG_USB1FLADJ_FLTV_Pos = 0x0
	// Bit mask of FLTV field.
	CREG_USB1FLADJ_FLTV_Msk = 0x3f
	// Position of RESERVED field.
	CREG_USB1FLADJ_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CREG_USB1FLADJ_RESERVED_Msk = 0xffffffc0
)

// Bitfields for EVENTROUTER: Event router
const (
	// HILO: Level configuration register
	// Position of WAKEUP0_L field.
	EVENTROUTER_HILO_WAKEUP0_L_Pos = 0x0
	// Bit mask of WAKEUP0_L field.
	EVENTROUTER_HILO_WAKEUP0_L_Msk = 0x1
	// Bit WAKEUP0_L.
	EVENTROUTER_HILO_WAKEUP0_L = 0x1
	// Detect LOW level on the WAKEUP0 pin if bit 0 in the EDGE register is 0. Detect falling edge if bit 0 in the EDGE register is 1.
	EVENTROUTER_HILO_WAKEUP0_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level on the WAKEUP0 pin if bit 0 in the EDGE register is 0. Detect rising edge if bit 0 in the EDGE register is 1.
	EVENTROUTER_HILO_WAKEUP0_L_DETECT_HIGH_LEVEL = 0x1
	// Position of WAKEUP1_L field.
	EVENTROUTER_HILO_WAKEUP1_L_Pos = 0x1
	// Bit mask of WAKEUP1_L field.
	EVENTROUTER_HILO_WAKEUP1_L_Msk = 0x2
	// Bit WAKEUP1_L.
	EVENTROUTER_HILO_WAKEUP1_L = 0x2
	// Detect LOW level on the WAKEUP1 pin if bit 1 in the EDGE register is 0.
	EVENTROUTER_HILO_WAKEUP1_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level on the WAKEUP1 pin if bit 1 in the EDGE register is 0. Detect rising edge if bit 1 in the EDGE register is 1.
	EVENTROUTER_HILO_WAKEUP1_L_DETECT_HIGH_LEVEL = 0x1
	// Position of WAKEUP2_L field.
	EVENTROUTER_HILO_WAKEUP2_L_Pos = 0x2
	// Bit mask of WAKEUP2_L field.
	EVENTROUTER_HILO_WAKEUP2_L_Msk = 0x4
	// Bit WAKEUP2_L.
	EVENTROUTER_HILO_WAKEUP2_L = 0x4
	// Detect LOW level on the WAKEUP2 pin if bit 2 in the EDGE register is 0. Detect falling edge if bit 2 in the EDGE register is 1.
	EVENTROUTER_HILO_WAKEUP2_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level on the WAKEUP2 pin if bit 2 in the EDGE register is 0. Detect rising edge if bit 2 in the EDGE register is 1.
	EVENTROUTER_HILO_WAKEUP2_L_DETECT_HIGH_LEVEL = 0x1
	// Position of WAKEUP3_L field.
	EVENTROUTER_HILO_WAKEUP3_L_Pos = 0x3
	// Bit mask of WAKEUP3_L field.
	EVENTROUTER_HILO_WAKEUP3_L_Msk = 0x8
	// Bit WAKEUP3_L.
	EVENTROUTER_HILO_WAKEUP3_L = 0x8
	// Detect LOW level on the WAKEUP3 pin if bit 3 in the EDGE register is 0. Detect falling edge if bit 3 in the EDGE register is 1.
	EVENTROUTER_HILO_WAKEUP3_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level on the WAKEUP3 pin if bit 3 in the EDGE register is 0. Detect rising edge if bit 3 in the EDGE register is 1.
	EVENTROUTER_HILO_WAKEUP3_L_DETECT_HIGH_LEVEL = 0x1
	// Position of ATIMER_L field.
	EVENTROUTER_HILO_ATIMER_L_Pos = 0x4
	// Bit mask of ATIMER_L field.
	EVENTROUTER_HILO_ATIMER_L_Msk = 0x10
	// Bit ATIMER_L.
	EVENTROUTER_HILO_ATIMER_L = 0x10
	// Detect LOW level of the alarm timer interrupt if bit 4 in the EDGE register is 0. Detect falling edge if bit 4 in the EDGE register is 1.
	EVENTROUTER_HILO_ATIMER_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of the alarm timer interrupt if bit 4 in the EDGE register is 0. Detect rising edge if bit 4 in the EDGE register is 1.
	EVENTROUTER_HILO_ATIMER_L_DETECT_HIGH_LEVEL = 0x1
	// Position of RTC_L field.
	EVENTROUTER_HILO_RTC_L_Pos = 0x5
	// Bit mask of RTC_L field.
	EVENTROUTER_HILO_RTC_L_Msk = 0x20
	// Bit RTC_L.
	EVENTROUTER_HILO_RTC_L = 0x20
	// Detect LOW level of the RTC interrupt if bit 5 in the EDGE register is 0. Detect falling edge if bit 5 in the EDGE register is 1.
	EVENTROUTER_HILO_RTC_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of the RTC interrupt if bit 5 in the EDGE register is 0. Detect rising edge if bit 5 in the EDGE register is 1.
	EVENTROUTER_HILO_RTC_L_DETECT_HIGH_LEVEL = 0x1
	// Position of BOD_L field.
	EVENTROUTER_HILO_BOD_L_Pos = 0x6
	// Bit mask of BOD_L field.
	EVENTROUTER_HILO_BOD_L_Msk = 0x40
	// Bit BOD_L.
	EVENTROUTER_HILO_BOD_L = 0x40
	// Detect LOW level of the BOD interrupt if bit 6 in the EDGE register is 0. Detect falling edge if bit 6 in the EDGE register is 1.
	EVENTROUTER_HILO_BOD_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of the BOD interrupt if bit 6 in the EDGE register is 0. Detect rising edge if bit 6 in the EDGE register is 1.
	EVENTROUTER_HILO_BOD_L_DETECT_HIGH_LEVEL = 0x1
	// Position of WWDT_L field.
	EVENTROUTER_HILO_WWDT_L_Pos = 0x7
	// Bit mask of WWDT_L field.
	EVENTROUTER_HILO_WWDT_L_Msk = 0x80
	// Bit WWDT_L.
	EVENTROUTER_HILO_WWDT_L = 0x80
	// Detect LOW level of the WWDT interrupt if bit 7 in the EDGE register is 0. Detect falling edge if bit 7 in the EDGE register is 1.
	EVENTROUTER_HILO_WWDT_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of the WWDT interrupt if bit 7 in the EDGE register is 0. Detect rising edge if bit 7 in the EDGE register is 1.
	EVENTROUTER_HILO_WWDT_L_DETECT_HIGH_LEVEL = 0x1
	// Position of ETH_L field.
	EVENTROUTER_HILO_ETH_L_Pos = 0x8
	// Bit mask of ETH_L field.
	EVENTROUTER_HILO_ETH_L_Msk = 0x100
	// Bit ETH_L.
	EVENTROUTER_HILO_ETH_L = 0x100
	// Detect LOW level of the Ethernet interrupt if bit 8 in the EDGE register is 0. Detect falling edge if bit 8 in the EDGE register is 1.
	EVENTROUTER_HILO_ETH_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of the Ethernet interrupt if bit 8 in the EDGE register is 0. Detect rising edge if bit 8 in the EDGE register is 1.
	EVENTROUTER_HILO_ETH_L_DETECT_HIGH_LEVEL = 0x1
	// Position of USB0_L field.
	EVENTROUTER_HILO_USB0_L_Pos = 0x9
	// Bit mask of USB0_L field.
	EVENTROUTER_HILO_USB0_L_Msk = 0x200
	// Bit USB0_L.
	EVENTROUTER_HILO_USB0_L = 0x200
	// Detect LOW level of the USB0 interrupt if bit 9 in the EDGE register is 0. Detect falling edge if bit 9 in the EDGE register is 1.
	EVENTROUTER_HILO_USB0_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of the USB0 interrupt if bit 9 in the EDGE register is 0. Detect rising edge if bit 9 in the EDGE register is 1.
	EVENTROUTER_HILO_USB0_L_DETECT_HIGH_LEVEL = 0x1
	// Position of USB1_L field.
	EVENTROUTER_HILO_USB1_L_Pos = 0xa
	// Bit mask of USB1_L field.
	EVENTROUTER_HILO_USB1_L_Msk = 0x400
	// Bit USB1_L.
	EVENTROUTER_HILO_USB1_L = 0x400
	// Detect LOW level of the USB1 interrupt if bit 10 in the EDGE register is 0. Detect falling edge if bit 10 in the EDGE register is 1.
	EVENTROUTER_HILO_USB1_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of the USB1 interrupt if bit 10 in the EDGE register is 0. Detect rising edge if bit 10 in the EDGE register is 1.
	EVENTROUTER_HILO_USB1_L_DETECT_HIGH_LEVEL = 0x1
	// Position of SDMMC_L field.
	EVENTROUTER_HILO_SDMMC_L_Pos = 0xb
	// Bit mask of SDMMC_L field.
	EVENTROUTER_HILO_SDMMC_L_Msk = 0x800
	// Bit SDMMC_L.
	EVENTROUTER_HILO_SDMMC_L = 0x800
	// Detect LOW level of the SD/MMC interrupt if bit 11 in the EDGE register is 0. Detect falling edge if bit 11 in the EDGE register is 1.
	EVENTROUTER_HILO_SDMMC_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of the SD/MMC interrupt if bit 11 in the EDGE register is 0. Detect rising edge if bit 11 in the EDGE register is 1.
	EVENTROUTER_HILO_SDMMC_L_DETECT_HIGH_LEVEL = 0x1
	// Position of CAN_L field.
	EVENTROUTER_HILO_CAN_L_Pos = 0xc
	// Bit mask of CAN_L field.
	EVENTROUTER_HILO_CAN_L_Msk = 0x1000
	// Bit CAN_L.
	EVENTROUTER_HILO_CAN_L = 0x1000
	// Detect LOW level of the combined C_CAN interrupt if bit 12 in the EDGE register is 0. Detect falling edge if bit 12 in the EDGE register is 1.
	EVENTROUTER_HILO_CAN_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of the combined C_CAN interrupt if bit 12 in the EDGE register is 0. Detect rising edge if bit 12 in the EDGE register is 1.
	EVENTROUTER_HILO_CAN_L_DETECT_HIGH_LEVEL = 0x1
	// Position of TIM2_L field.
	EVENTROUTER_HILO_TIM2_L_Pos = 0xd
	// Bit mask of TIM2_L field.
	EVENTROUTER_HILO_TIM2_L_Msk = 0x2000
	// Bit TIM2_L.
	EVENTROUTER_HILO_TIM2_L = 0x2000
	// Detect LOW level GIMA output 25 if bit 13 in the EDGE register is 0. Detect falling edge if bit 13 in the EDGE register is 1.
	EVENTROUTER_HILO_TIM2_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level GIMA output 25 if bit 13 in the EDGE register is 0. Detect rising edge if bit 13 in the EDGE register is 1.
	EVENTROUTER_HILO_TIM2_L_DETECT_HIGH_LEVEL = 0x1
	// Position of TIM6_L field.
	EVENTROUTER_HILO_TIM6_L_Pos = 0xe
	// Bit mask of TIM6_L field.
	EVENTROUTER_HILO_TIM6_L_Msk = 0x4000
	// Bit TIM6_L.
	EVENTROUTER_HILO_TIM6_L = 0x4000
	// Detect LOW level of GIMA output 26 if bit 14 in the EDGE register is 0. Detect falling edge if bit 14 in the EDGE register is 1.
	EVENTROUTER_HILO_TIM6_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of GIMA output 26 if bit 14 in the EDGE register is 0. Detect rising edge if bit 14 in the EDGE register is 1.
	EVENTROUTER_HILO_TIM6_L_DETECT_HIGH_LEVEL = 0x1
	// Position of QEI_L field.
	EVENTROUTER_HILO_QEI_L_Pos = 0xf
	// Bit mask of QEI_L field.
	EVENTROUTER_HILO_QEI_L_Msk = 0x8000
	// Bit QEI_L.
	EVENTROUTER_HILO_QEI_L = 0x8000
	// Detect LOW level of the QEI interrupt if bit 15 in the EDGE register is 0. Detect falling edge if bit 15 in the EDGE register is 1.
	EVENTROUTER_HILO_QEI_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of the QEI interrupt if bit 15 in the EDGE register is 0. Detect rising edge if bit 15 in the EDGE register is 1.
	EVENTROUTER_HILO_QEI_L_DETECT_HIGH_LEVEL = 0x1
	// Position of TIM14_L field.
	EVENTROUTER_HILO_TIM14_L_Pos = 0x10
	// Bit mask of TIM14_L field.
	EVENTROUTER_HILO_TIM14_L_Msk = 0x10000
	// Bit TIM14_L.
	EVENTROUTER_HILO_TIM14_L = 0x10000
	// Detect LOW level of GIMA output 27 if bit 16 in the EDGE register is 0. Detect falling edge if bit 16 in the EDGE register is 1.
	EVENTROUTER_HILO_TIM14_L_DETECT_LOW_LEVEL = 0x0
	// Detect HIGH level of GIMA output 27 if bit 16 in the EDGE register is 0. Detect rising edge if bit 16 in the EDGE register is 1.
	EVENTROUTER_HILO_TIM14_L_DETECT_HIGH_LEVEL = 0x1
	// Position of RESERVED field.
	EVENTROUTER_HILO_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	EVENTROUTER_HILO_RESERVED_Msk = 0x60000
	// Position of RESET_L field.
	EVENTROUTER_HILO_RESET_L_Pos = 0x13
	// Bit mask of RESET_L field.
	EVENTROUTER_HILO_RESET_L_Msk = 0x80000
	// Bit RESET_L.
	EVENTROUTER_HILO_RESET_L = 0x80000
	// Detect LOW level if bit 17 in the EDGE register is 0. Detect falling edge if bit 17 in the EDGE register is 1.
	EVENTROUTER_HILO_RESET_L_DETECT_LOW_LEVEL_IF = 0x0
	// Detect HIGH level if bit 17 in the EDGE register is 0. Detect rising edge if bit 17 in the EDGE register is 1.
	EVENTROUTER_HILO_RESET_L_DETECT_HIGH_LEVEL_IF = 0x1
	// Position of BODRESET_L field.
	EVENTROUTER_HILO_BODRESET_L_Pos = 0x14
	// Bit mask of BODRESET_L field.
	EVENTROUTER_HILO_BODRESET_L_Msk = 0x100000
	// Bit BODRESET_L.
	EVENTROUTER_HILO_BODRESET_L = 0x100000
	// Detect LOW level if bit 20 in the EDGE register is 0. Detect falling edge if bit 20 in the EDGE register is 1.
	EVENTROUTER_HILO_BODRESET_L_DETECT_LOW_LEVEL_IF = 0x0
	// Detect HIGH level if bit 20 in the EDGE register is 0. Detect rising edge if bit 20 in the EDGE register is 1.
	EVENTROUTER_HILO_BODRESET_L_DETECT_HIGH_LEVEL_IF = 0x1
	// Position of DPDRESET_L field.
	EVENTROUTER_HILO_DPDRESET_L_Pos = 0x15
	// Bit mask of DPDRESET_L field.
	EVENTROUTER_HILO_DPDRESET_L_Msk = 0x200000
	// Bit DPDRESET_L.
	EVENTROUTER_HILO_DPDRESET_L = 0x200000
	// Detect LOW level if bit 21 in the EDGE register is 0. Detect falling edge if bit 21 in the EDGE register is 1.
	EVENTROUTER_HILO_DPDRESET_L_DETECT_LOW_LEVEL_IF = 0x0
	// Detect HIGH level if bit 21 in the EDGE register is 0. Detect rising edge if bit 21 in the EDGE register is 1.
	EVENTROUTER_HILO_DPDRESET_L_DETECT_HIGH_LEVEL_IF = 0x1
	// Position of RESERVED field.
	EVENTROUTER_HILO_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	EVENTROUTER_HILO_RESERVED_Msk = 0xffc00000

	// EDGE: Edge configuration
	// Position of WAKEUP0_E field.
	EVENTROUTER_EDGE_WAKEUP0_E_Pos = 0x0
	// Bit mask of WAKEUP0_E field.
	EVENTROUTER_EDGE_WAKEUP0_E_Msk = 0x1
	// Bit WAKEUP0_E.
	EVENTROUTER_EDGE_WAKEUP0_E = 0x1
	// Level detect.
	EVENTROUTER_EDGE_WAKEUP0_E_LEVEL_DETECT = 0x0
	// Edge detect of WAKEUP0 pin. Detect falling edge if bit 0 in the HILO register is 0. Detect rising edge if bit 0 in the HILO register is 1.
	EVENTROUTER_EDGE_WAKEUP0_E_EDGE_DETECT_OF_WAKEU = 0x1
	// Position of WAKEUP1_E field.
	EVENTROUTER_EDGE_WAKEUP1_E_Pos = 0x1
	// Bit mask of WAKEUP1_E field.
	EVENTROUTER_EDGE_WAKEUP1_E_Msk = 0x2
	// Bit WAKEUP1_E.
	EVENTROUTER_EDGE_WAKEUP1_E = 0x2
	// Level detect.
	EVENTROUTER_EDGE_WAKEUP1_E_LEVEL_DETECT = 0x0
	// Edge detect of WAKEUP1 pin. Detect falling edge if bit 1 in the HILO register is 0. Detect rising edge if bit 1 in the HILO register is 1.
	EVENTROUTER_EDGE_WAKEUP1_E_EDGE_DETECT_OF_WAKEU = 0x1
	// Position of WAKEUP2_E field.
	EVENTROUTER_EDGE_WAKEUP2_E_Pos = 0x2
	// Bit mask of WAKEUP2_E field.
	EVENTROUTER_EDGE_WAKEUP2_E_Msk = 0x4
	// Bit WAKEUP2_E.
	EVENTROUTER_EDGE_WAKEUP2_E = 0x4
	// Level detect.
	EVENTROUTER_EDGE_WAKEUP2_E_LEVEL_DETECT = 0x0
	// Edge detect of WAKEUP2 pin. Detect falling edge if bit 2 in the HILO register is 0. Detect rising edge if bit 2 in the HILO register is 1.
	EVENTROUTER_EDGE_WAKEUP2_E_EDGE_DETECT_OF_WAKEU = 0x1
	// Position of WAKEUP3_E field.
	EVENTROUTER_EDGE_WAKEUP3_E_Pos = 0x3
	// Bit mask of WAKEUP3_E field.
	EVENTROUTER_EDGE_WAKEUP3_E_Msk = 0x8
	// Bit WAKEUP3_E.
	EVENTROUTER_EDGE_WAKEUP3_E = 0x8
	// Level detect.
	EVENTROUTER_EDGE_WAKEUP3_E_LEVEL_DETECT = 0x0
	// Edge detect of WAKEUP3 pin. Detect falling edge if bit 30 in the HILO register is 0. Detect rising edge if bit 3 in the HILO register is 1.
	EVENTROUTER_EDGE_WAKEUP3_E_EDGE_DETECT_OF_WAKEU = 0x1
	// Position of ATIMER_E field.
	EVENTROUTER_EDGE_ATIMER_E_Pos = 0x4
	// Bit mask of ATIMER_E field.
	EVENTROUTER_EDGE_ATIMER_E_Msk = 0x10
	// Bit ATIMER_E.
	EVENTROUTER_EDGE_ATIMER_E = 0x10
	// Level detect.
	EVENTROUTER_EDGE_ATIMER_E_LEVEL_DETECT = 0x0
	// Edge detect of the alarm timer interrupt. Detect falling edge if bit 4 in the HILO register is 0. Detect rising edge if bit 4 in the HILO register is 1.
	EVENTROUTER_EDGE_ATIMER_E_EDGE_DETECT_OF_THE_A = 0x1
	// Position of RTC_E field.
	EVENTROUTER_EDGE_RTC_E_Pos = 0x5
	// Bit mask of RTC_E field.
	EVENTROUTER_EDGE_RTC_E_Msk = 0x20
	// Bit RTC_E.
	EVENTROUTER_EDGE_RTC_E = 0x20
	// Level detect.
	EVENTROUTER_EDGE_RTC_E_LEVEL_DETECT = 0x0
	// Edge detect of the RTC interrupt. Detect falling edge if bit 5 in the HILO register is 0. Detect rising edge if bit 5 in the HILO register is 1.
	EVENTROUTER_EDGE_RTC_E_EDGE_DETECT_OF_THE_R = 0x1
	// Position of BOD_E field.
	EVENTROUTER_EDGE_BOD_E_Pos = 0x6
	// Bit mask of BOD_E field.
	EVENTROUTER_EDGE_BOD_E_Msk = 0x40
	// Bit BOD_E.
	EVENTROUTER_EDGE_BOD_E = 0x40
	// Level detect.
	EVENTROUTER_EDGE_BOD_E_LEVEL_DETECT = 0x0
	// Edge detect of the BOD interrupt. Detect falling edge if bit 6 in the HILO register is 0. Detect rising edge if bit 6 in the HILO register is 1.
	EVENTROUTER_EDGE_BOD_E_EDGE_DETECT_OF_THE_B = 0x1
	// Position of WWDT_E field.
	EVENTROUTER_EDGE_WWDT_E_Pos = 0x7
	// Bit mask of WWDT_E field.
	EVENTROUTER_EDGE_WWDT_E_Msk = 0x80
	// Bit WWDT_E.
	EVENTROUTER_EDGE_WWDT_E = 0x80
	// Level detect.
	EVENTROUTER_EDGE_WWDT_E_LEVEL_DETECT = 0x0
	// Edge detect of the WWDT interrupt. Detect falling edge if bit 7 in the HILO register is 0. Detect rising edge if bit 7 in the HILO register is 1.
	EVENTROUTER_EDGE_WWDT_E_EDGE_DETECT_OF_THE_W = 0x1
	// Position of ETH_E field.
	EVENTROUTER_EDGE_ETH_E_Pos = 0x8
	// Bit mask of ETH_E field.
	EVENTROUTER_EDGE_ETH_E_Msk = 0x100
	// Bit ETH_E.
	EVENTROUTER_EDGE_ETH_E = 0x100
	// Level detect.
	EVENTROUTER_EDGE_ETH_E_LEVEL_DETECT = 0x0
	// Edge detect of the Ethernet interrupt. Detect falling edge if bit 8 in the HILO register is 0. Detect rising edge if bit 8 in the HILO register is 1.
	EVENTROUTER_EDGE_ETH_E_EDGE_DETECT_OF_THE_E = 0x1
	// Position of USB0_E field.
	EVENTROUTER_EDGE_USB0_E_Pos = 0x9
	// Bit mask of USB0_E field.
	EVENTROUTER_EDGE_USB0_E_Msk = 0x200
	// Bit USB0_E.
	EVENTROUTER_EDGE_USB0_E = 0x200
	// Level detect.
	EVENTROUTER_EDGE_USB0_E_LEVEL_DETECT = 0x0
	// Edge detect of the USB0 event. Detect falling edge if bit 9 in the HILO register is 0. Detect rising edge if bit 9 in the HILO register is 1.
	EVENTROUTER_EDGE_USB0_E_EDGE_DETECT_OF_THE_U = 0x1
	// Position of USB1_E field.
	EVENTROUTER_EDGE_USB1_E_Pos = 0xa
	// Bit mask of USB1_E field.
	EVENTROUTER_EDGE_USB1_E_Msk = 0x400
	// Bit USB1_E.
	EVENTROUTER_EDGE_USB1_E = 0x400
	// Level detect.
	EVENTROUTER_EDGE_USB1_E_LEVEL_DETECT = 0x0
	// Edge detect of the USB1 interrupt. Detect falling edge if bit 10 in the HILO register is 0. Detect rising edge if bit 10 in the HILO register is 1.
	EVENTROUTER_EDGE_USB1_E_EDGE_DETECT_OF_THE_U = 0x1
	// Position of SDMMC_E field.
	EVENTROUTER_EDGE_SDMMC_E_Pos = 0xb
	// Bit mask of SDMMC_E field.
	EVENTROUTER_EDGE_SDMMC_E_Msk = 0x800
	// Bit SDMMC_E.
	EVENTROUTER_EDGE_SDMMC_E = 0x800
	// Level detect.
	EVENTROUTER_EDGE_SDMMC_E_LEVEL_DETECT = 0x0
	// Edge detect of the SD/MMC interrupt. Detect falling edge if bit 10 in the HILO register is 0. Detect rising edge if bit 10 in the HILO register is 1.
	EVENTROUTER_EDGE_SDMMC_E_EDGE_DETECT_OF_THE_S = 0x1
	// Position of CAN_E field.
	EVENTROUTER_EDGE_CAN_E_Pos = 0xc
	// Bit mask of CAN_E field.
	EVENTROUTER_EDGE_CAN_E_Msk = 0x1000
	// Bit CAN_E.
	EVENTROUTER_EDGE_CAN_E = 0x1000
	// Level detect.
	EVENTROUTER_EDGE_CAN_E_LEVEL_DETECT = 0x0
	// Edge detect of the combined C_CAN interrupt. Detect falling edge if bit 12 in the HILO register is 0. Detect rising edge if bit 12 in the HILO register is 1.
	EVENTROUTER_EDGE_CAN_E_EDGE_DETECT_OF_THE_C = 0x1
	// Position of TIM2_E field.
	EVENTROUTER_EDGE_TIM2_E_Pos = 0xd
	// Bit mask of TIM2_E field.
	EVENTROUTER_EDGE_TIM2_E_Msk = 0x2000
	// Bit TIM2_E.
	EVENTROUTER_EDGE_TIM2_E = 0x2000
	// Level detect.
	EVENTROUTER_EDGE_TIM2_E_LEVEL_DETECT = 0x0
	// Edge detect of GIMA output 25. Detect falling edge if bit 13 in the HILO register is 0. Detect rising edge if bit 13 in the HILO register is 1.
	EVENTROUTER_EDGE_TIM2_E_EDGE_DETECT_OF_GIMA = 0x1
	// Position of TIM6_E field.
	EVENTROUTER_EDGE_TIM6_E_Pos = 0xe
	// Bit mask of TIM6_E field.
	EVENTROUTER_EDGE_TIM6_E_Msk = 0x4000
	// Bit TIM6_E.
	EVENTROUTER_EDGE_TIM6_E = 0x4000
	// Level detect.
	EVENTROUTER_EDGE_TIM6_E_LEVEL_DETECT = 0x0
	// Edge detect of GIMA output 26. Detect falling edge if bit 14 in the HILO register is 0. Detect rising edge if bit 14 in the HILO register is 1.
	EVENTROUTER_EDGE_TIM6_E_EDGE_DETECT_OF_GIMA = 0x1
	// Position of QEI_E field.
	EVENTROUTER_EDGE_QEI_E_Pos = 0xf
	// Bit mask of QEI_E field.
	EVENTROUTER_EDGE_QEI_E_Msk = 0x8000
	// Bit QEI_E.
	EVENTROUTER_EDGE_QEI_E = 0x8000
	// Level detect.
	EVENTROUTER_EDGE_QEI_E_LEVEL_DETECT = 0x0
	// Edge detect of QEI interrupt. Detect falling edge if bit 15 in the HILO register is 0. Detect rising edge if bit 15 in the HILO register is 1.
	EVENTROUTER_EDGE_QEI_E_EDGE_DETECT_OF_QEI_I = 0x1
	// Position of TIM14_E field.
	EVENTROUTER_EDGE_TIM14_E_Pos = 0x10
	// Bit mask of TIM14_E field.
	EVENTROUTER_EDGE_TIM14_E_Msk = 0x10000
	// Bit TIM14_E.
	EVENTROUTER_EDGE_TIM14_E = 0x10000
	// Level detect.
	EVENTROUTER_EDGE_TIM14_E_LEVEL_DETECT = 0x0
	// Edge detect of GIMA output 27. Detect falling edge if bit 16 in the HILO register is 0. Detect rising edge if bit 16 in the HILO register is 1.
	EVENTROUTER_EDGE_TIM14_E_EDGE_DETECT_OF_GIMA = 0x1
	// Position of RESERVED field.
	EVENTROUTER_EDGE_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	EVENTROUTER_EDGE_RESERVED_Msk = 0x60000
	// Position of RESET_E field.
	EVENTROUTER_EDGE_RESET_E_Pos = 0x13
	// Bit mask of RESET_E field.
	EVENTROUTER_EDGE_RESET_E_Msk = 0x80000
	// Bit RESET_E.
	EVENTROUTER_EDGE_RESET_E = 0x80000
	// Level detect.
	EVENTROUTER_EDGE_RESET_E_LEVEL_DETECT = 0x0
	// Edge detect of the reset signal. Detect falling edge if bit 19 in the HILO register is 0. Detect rising edge if bit 19 in the HILO register is 1.
	EVENTROUTER_EDGE_RESET_E_EDGE_DETECT_OF_THE_R = 0x1
	// Position of BODRESET_E field.
	EVENTROUTER_EDGE_BODRESET_E_Pos = 0x14
	// Bit mask of BODRESET_E field.
	EVENTROUTER_EDGE_BODRESET_E_Msk = 0x100000
	// Bit BODRESET_E.
	EVENTROUTER_EDGE_BODRESET_E = 0x100000
	// Level detect.
	EVENTROUTER_EDGE_BODRESET_E_LEVEL_DETECT = 0x0
	// Edge detect of the reset signal. Detect falling edge if bit 20 in the HILO register is 0. Detect rising edge if bit 19 in the HILO register is 1.
	EVENTROUTER_EDGE_BODRESET_E_EDGE_DETECT_OF_THE_R = 0x1
	// Position of DPDRESET_E field.
	EVENTROUTER_EDGE_DPDRESET_E_Pos = 0x15
	// Bit mask of DPDRESET_E field.
	EVENTROUTER_EDGE_DPDRESET_E_Msk = 0x200000
	// Bit DPDRESET_E.
	EVENTROUTER_EDGE_DPDRESET_E = 0x200000
	// Level detect.
	EVENTROUTER_EDGE_DPDRESET_E_LEVEL_DETECT = 0x0
	// Edge detect of the reset signal. Detect falling edge if bit 21 in the HILO register is 0. Detect rising edge if bit 21 in the HILO register is 1.
	EVENTROUTER_EDGE_DPDRESET_E_EDGE_DETECT_OF_THE_R = 0x1
	// Position of RESERVED field.
	EVENTROUTER_EDGE_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	EVENTROUTER_EDGE_RESERVED_Msk = 0xffc00000

	// CLR_EN: Clear event enable register
	// Position of WAKEUP0_CLREN field.
	EVENTROUTER_CLR_EN_WAKEUP0_CLREN_Pos = 0x0
	// Bit mask of WAKEUP0_CLREN field.
	EVENTROUTER_CLR_EN_WAKEUP0_CLREN_Msk = 0x1
	// Bit WAKEUP0_CLREN.
	EVENTROUTER_CLR_EN_WAKEUP0_CLREN = 0x1
	// Position of WAKEUP1_CLREN field.
	EVENTROUTER_CLR_EN_WAKEUP1_CLREN_Pos = 0x1
	// Bit mask of WAKEUP1_CLREN field.
	EVENTROUTER_CLR_EN_WAKEUP1_CLREN_Msk = 0x2
	// Bit WAKEUP1_CLREN.
	EVENTROUTER_CLR_EN_WAKEUP1_CLREN = 0x2
	// Position of WAKEUP2_CLREN field.
	EVENTROUTER_CLR_EN_WAKEUP2_CLREN_Pos = 0x2
	// Bit mask of WAKEUP2_CLREN field.
	EVENTROUTER_CLR_EN_WAKEUP2_CLREN_Msk = 0x4
	// Bit WAKEUP2_CLREN.
	EVENTROUTER_CLR_EN_WAKEUP2_CLREN = 0x4
	// Position of WAKEUP3_CLREN field.
	EVENTROUTER_CLR_EN_WAKEUP3_CLREN_Pos = 0x3
	// Bit mask of WAKEUP3_CLREN field.
	EVENTROUTER_CLR_EN_WAKEUP3_CLREN_Msk = 0x8
	// Bit WAKEUP3_CLREN.
	EVENTROUTER_CLR_EN_WAKEUP3_CLREN = 0x8
	// Position of ATIMER_CLREN field.
	EVENTROUTER_CLR_EN_ATIMER_CLREN_Pos = 0x4
	// Bit mask of ATIMER_CLREN field.
	EVENTROUTER_CLR_EN_ATIMER_CLREN_Msk = 0x10
	// Bit ATIMER_CLREN.
	EVENTROUTER_CLR_EN_ATIMER_CLREN = 0x10
	// Position of RTC_CLREN field.
	EVENTROUTER_CLR_EN_RTC_CLREN_Pos = 0x5
	// Bit mask of RTC_CLREN field.
	EVENTROUTER_CLR_EN_RTC_CLREN_Msk = 0x20
	// Bit RTC_CLREN.
	EVENTROUTER_CLR_EN_RTC_CLREN = 0x20
	// Position of BOD_CLREN field.
	EVENTROUTER_CLR_EN_BOD_CLREN_Pos = 0x6
	// Bit mask of BOD_CLREN field.
	EVENTROUTER_CLR_EN_BOD_CLREN_Msk = 0x40
	// Bit BOD_CLREN.
	EVENTROUTER_CLR_EN_BOD_CLREN = 0x40
	// Position of WWDT_CLREN field.
	EVENTROUTER_CLR_EN_WWDT_CLREN_Pos = 0x7
	// Bit mask of WWDT_CLREN field.
	EVENTROUTER_CLR_EN_WWDT_CLREN_Msk = 0x80
	// Bit WWDT_CLREN.
	EVENTROUTER_CLR_EN_WWDT_CLREN = 0x80
	// Position of ETH_CLREN field.
	EVENTROUTER_CLR_EN_ETH_CLREN_Pos = 0x8
	// Bit mask of ETH_CLREN field.
	EVENTROUTER_CLR_EN_ETH_CLREN_Msk = 0x100
	// Bit ETH_CLREN.
	EVENTROUTER_CLR_EN_ETH_CLREN = 0x100
	// Position of USB0_CLREN field.
	EVENTROUTER_CLR_EN_USB0_CLREN_Pos = 0x9
	// Bit mask of USB0_CLREN field.
	EVENTROUTER_CLR_EN_USB0_CLREN_Msk = 0x200
	// Bit USB0_CLREN.
	EVENTROUTER_CLR_EN_USB0_CLREN = 0x200
	// Position of USB1_CLREN field.
	EVENTROUTER_CLR_EN_USB1_CLREN_Pos = 0xa
	// Bit mask of USB1_CLREN field.
	EVENTROUTER_CLR_EN_USB1_CLREN_Msk = 0x400
	// Bit USB1_CLREN.
	EVENTROUTER_CLR_EN_USB1_CLREN = 0x400
	// Position of SDMMC_CLREN field.
	EVENTROUTER_CLR_EN_SDMMC_CLREN_Pos = 0xb
	// Bit mask of SDMMC_CLREN field.
	EVENTROUTER_CLR_EN_SDMMC_CLREN_Msk = 0x800
	// Bit SDMMC_CLREN.
	EVENTROUTER_CLR_EN_SDMMC_CLREN = 0x800
	// Position of CAN_CLREN field.
	EVENTROUTER_CLR_EN_CAN_CLREN_Pos = 0xc
	// Bit mask of CAN_CLREN field.
	EVENTROUTER_CLR_EN_CAN_CLREN_Msk = 0x1000
	// Bit CAN_CLREN.
	EVENTROUTER_CLR_EN_CAN_CLREN = 0x1000
	// Position of TIM2_CLREN field.
	EVENTROUTER_CLR_EN_TIM2_CLREN_Pos = 0xd
	// Bit mask of TIM2_CLREN field.
	EVENTROUTER_CLR_EN_TIM2_CLREN_Msk = 0x2000
	// Bit TIM2_CLREN.
	EVENTROUTER_CLR_EN_TIM2_CLREN = 0x2000
	// Position of TIM6_CLREN field.
	EVENTROUTER_CLR_EN_TIM6_CLREN_Pos = 0xe
	// Bit mask of TIM6_CLREN field.
	EVENTROUTER_CLR_EN_TIM6_CLREN_Msk = 0x4000
	// Bit TIM6_CLREN.
	EVENTROUTER_CLR_EN_TIM6_CLREN = 0x4000
	// Position of QEI_CLREN field.
	EVENTROUTER_CLR_EN_QEI_CLREN_Pos = 0xf
	// Bit mask of QEI_CLREN field.
	EVENTROUTER_CLR_EN_QEI_CLREN_Msk = 0x8000
	// Bit QEI_CLREN.
	EVENTROUTER_CLR_EN_QEI_CLREN = 0x8000
	// Position of TIM14_CLREN field.
	EVENTROUTER_CLR_EN_TIM14_CLREN_Pos = 0x10
	// Bit mask of TIM14_CLREN field.
	EVENTROUTER_CLR_EN_TIM14_CLREN_Msk = 0x10000
	// Bit TIM14_CLREN.
	EVENTROUTER_CLR_EN_TIM14_CLREN = 0x10000
	// Position of RESERVED field.
	EVENTROUTER_CLR_EN_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	EVENTROUTER_CLR_EN_RESERVED_Msk = 0x60000
	// Position of RESET_CLREN field.
	EVENTROUTER_CLR_EN_RESET_CLREN_Pos = 0x13
	// Bit mask of RESET_CLREN field.
	EVENTROUTER_CLR_EN_RESET_CLREN_Msk = 0x80000
	// Bit RESET_CLREN.
	EVENTROUTER_CLR_EN_RESET_CLREN = 0x80000
	// Position of BODRESET_CLREN field.
	EVENTROUTER_CLR_EN_BODRESET_CLREN_Pos = 0x14
	// Bit mask of BODRESET_CLREN field.
	EVENTROUTER_CLR_EN_BODRESET_CLREN_Msk = 0x100000
	// Bit BODRESET_CLREN.
	EVENTROUTER_CLR_EN_BODRESET_CLREN = 0x100000
	// Position of DPDRESET_CLREN field.
	EVENTROUTER_CLR_EN_DPDRESET_CLREN_Pos = 0x15
	// Bit mask of DPDRESET_CLREN field.
	EVENTROUTER_CLR_EN_DPDRESET_CLREN_Msk = 0x200000
	// Bit DPDRESET_CLREN.
	EVENTROUTER_CLR_EN_DPDRESET_CLREN = 0x200000
	// Position of RESERVED field.
	EVENTROUTER_CLR_EN_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	EVENTROUTER_CLR_EN_RESERVED_Msk = 0xffc00000

	// SET_EN: Set event enable register
	// Position of WAKEUP0_SETEN field.
	EVENTROUTER_SET_EN_WAKEUP0_SETEN_Pos = 0x0
	// Bit mask of WAKEUP0_SETEN field.
	EVENTROUTER_SET_EN_WAKEUP0_SETEN_Msk = 0x1
	// Bit WAKEUP0_SETEN.
	EVENTROUTER_SET_EN_WAKEUP0_SETEN = 0x1
	// Position of WAKEUP1_SETEN field.
	EVENTROUTER_SET_EN_WAKEUP1_SETEN_Pos = 0x1
	// Bit mask of WAKEUP1_SETEN field.
	EVENTROUTER_SET_EN_WAKEUP1_SETEN_Msk = 0x2
	// Bit WAKEUP1_SETEN.
	EVENTROUTER_SET_EN_WAKEUP1_SETEN = 0x2
	// Position of WAKEUP2_SETEN field.
	EVENTROUTER_SET_EN_WAKEUP2_SETEN_Pos = 0x2
	// Bit mask of WAKEUP2_SETEN field.
	EVENTROUTER_SET_EN_WAKEUP2_SETEN_Msk = 0x4
	// Bit WAKEUP2_SETEN.
	EVENTROUTER_SET_EN_WAKEUP2_SETEN = 0x4
	// Position of WAKEUP3_SETEN field.
	EVENTROUTER_SET_EN_WAKEUP3_SETEN_Pos = 0x3
	// Bit mask of WAKEUP3_SETEN field.
	EVENTROUTER_SET_EN_WAKEUP3_SETEN_Msk = 0x8
	// Bit WAKEUP3_SETEN.
	EVENTROUTER_SET_EN_WAKEUP3_SETEN = 0x8
	// Position of ATIMER_SETEN field.
	EVENTROUTER_SET_EN_ATIMER_SETEN_Pos = 0x4
	// Bit mask of ATIMER_SETEN field.
	EVENTROUTER_SET_EN_ATIMER_SETEN_Msk = 0x10
	// Bit ATIMER_SETEN.
	EVENTROUTER_SET_EN_ATIMER_SETEN = 0x10
	// Position of RTC_SETEN field.
	EVENTROUTER_SET_EN_RTC_SETEN_Pos = 0x5
	// Bit mask of RTC_SETEN field.
	EVENTROUTER_SET_EN_RTC_SETEN_Msk = 0x20
	// Bit RTC_SETEN.
	EVENTROUTER_SET_EN_RTC_SETEN = 0x20
	// Position of BOD_SETEN field.
	EVENTROUTER_SET_EN_BOD_SETEN_Pos = 0x6
	// Bit mask of BOD_SETEN field.
	EVENTROUTER_SET_EN_BOD_SETEN_Msk = 0x40
	// Bit BOD_SETEN.
	EVENTROUTER_SET_EN_BOD_SETEN = 0x40
	// Position of WWDT_SETEN field.
	EVENTROUTER_SET_EN_WWDT_SETEN_Pos = 0x7
	// Bit mask of WWDT_SETEN field.
	EVENTROUTER_SET_EN_WWDT_SETEN_Msk = 0x80
	// Bit WWDT_SETEN.
	EVENTROUTER_SET_EN_WWDT_SETEN = 0x80
	// Position of ETH_SETEN field.
	EVENTROUTER_SET_EN_ETH_SETEN_Pos = 0x8
	// Bit mask of ETH_SETEN field.
	EVENTROUTER_SET_EN_ETH_SETEN_Msk = 0x100
	// Bit ETH_SETEN.
	EVENTROUTER_SET_EN_ETH_SETEN = 0x100
	// Position of USB0_SETEN field.
	EVENTROUTER_SET_EN_USB0_SETEN_Pos = 0x9
	// Bit mask of USB0_SETEN field.
	EVENTROUTER_SET_EN_USB0_SETEN_Msk = 0x200
	// Bit USB0_SETEN.
	EVENTROUTER_SET_EN_USB0_SETEN = 0x200
	// Position of USB1_SETEN field.
	EVENTROUTER_SET_EN_USB1_SETEN_Pos = 0xa
	// Bit mask of USB1_SETEN field.
	EVENTROUTER_SET_EN_USB1_SETEN_Msk = 0x400
	// Bit USB1_SETEN.
	EVENTROUTER_SET_EN_USB1_SETEN = 0x400
	// Position of SDMMC_SETEN field.
	EVENTROUTER_SET_EN_SDMMC_SETEN_Pos = 0xb
	// Bit mask of SDMMC_SETEN field.
	EVENTROUTER_SET_EN_SDMMC_SETEN_Msk = 0x800
	// Bit SDMMC_SETEN.
	EVENTROUTER_SET_EN_SDMMC_SETEN = 0x800
	// Position of CAN_SETEN field.
	EVENTROUTER_SET_EN_CAN_SETEN_Pos = 0xc
	// Bit mask of CAN_SETEN field.
	EVENTROUTER_SET_EN_CAN_SETEN_Msk = 0x1000
	// Bit CAN_SETEN.
	EVENTROUTER_SET_EN_CAN_SETEN = 0x1000
	// Position of TIM2_SETEN field.
	EVENTROUTER_SET_EN_TIM2_SETEN_Pos = 0xd
	// Bit mask of TIM2_SETEN field.
	EVENTROUTER_SET_EN_TIM2_SETEN_Msk = 0x2000
	// Bit TIM2_SETEN.
	EVENTROUTER_SET_EN_TIM2_SETEN = 0x2000
	// Position of TIM6_SETEN field.
	EVENTROUTER_SET_EN_TIM6_SETEN_Pos = 0xe
	// Bit mask of TIM6_SETEN field.
	EVENTROUTER_SET_EN_TIM6_SETEN_Msk = 0x4000
	// Bit TIM6_SETEN.
	EVENTROUTER_SET_EN_TIM6_SETEN = 0x4000
	// Position of QEI_SETEN field.
	EVENTROUTER_SET_EN_QEI_SETEN_Pos = 0xf
	// Bit mask of QEI_SETEN field.
	EVENTROUTER_SET_EN_QEI_SETEN_Msk = 0x8000
	// Bit QEI_SETEN.
	EVENTROUTER_SET_EN_QEI_SETEN = 0x8000
	// Position of TIM14_SETEN field.
	EVENTROUTER_SET_EN_TIM14_SETEN_Pos = 0x10
	// Bit mask of TIM14_SETEN field.
	EVENTROUTER_SET_EN_TIM14_SETEN_Msk = 0x10000
	// Bit TIM14_SETEN.
	EVENTROUTER_SET_EN_TIM14_SETEN = 0x10000
	// Position of RESERVED field.
	EVENTROUTER_SET_EN_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	EVENTROUTER_SET_EN_RESERVED_Msk = 0x60000
	// Position of RESET_SETEN field.
	EVENTROUTER_SET_EN_RESET_SETEN_Pos = 0x13
	// Bit mask of RESET_SETEN field.
	EVENTROUTER_SET_EN_RESET_SETEN_Msk = 0x80000
	// Bit RESET_SETEN.
	EVENTROUTER_SET_EN_RESET_SETEN = 0x80000
	// Position of BODRESET_SETEN field.
	EVENTROUTER_SET_EN_BODRESET_SETEN_Pos = 0x14
	// Bit mask of BODRESET_SETEN field.
	EVENTROUTER_SET_EN_BODRESET_SETEN_Msk = 0x100000
	// Bit BODRESET_SETEN.
	EVENTROUTER_SET_EN_BODRESET_SETEN = 0x100000
	// Position of DPDRESET_SETEN field.
	EVENTROUTER_SET_EN_DPDRESET_SETEN_Pos = 0x15
	// Bit mask of DPDRESET_SETEN field.
	EVENTROUTER_SET_EN_DPDRESET_SETEN_Msk = 0x200000
	// Bit DPDRESET_SETEN.
	EVENTROUTER_SET_EN_DPDRESET_SETEN = 0x200000
	// Position of RESERVED field.
	EVENTROUTER_SET_EN_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	EVENTROUTER_SET_EN_RESERVED_Msk = 0xffc00000

	// STATUS: Event Status register
	// Position of WAKEUP0_ST field.
	EVENTROUTER_STATUS_WAKEUP0_ST_Pos = 0x0
	// Bit mask of WAKEUP0_ST field.
	EVENTROUTER_STATUS_WAKEUP0_ST_Msk = 0x1
	// Bit WAKEUP0_ST.
	EVENTROUTER_STATUS_WAKEUP0_ST = 0x1
	// Position of WAKEUP1_ST field.
	EVENTROUTER_STATUS_WAKEUP1_ST_Pos = 0x1
	// Bit mask of WAKEUP1_ST field.
	EVENTROUTER_STATUS_WAKEUP1_ST_Msk = 0x2
	// Bit WAKEUP1_ST.
	EVENTROUTER_STATUS_WAKEUP1_ST = 0x2
	// Position of WAKEUP2_ST field.
	EVENTROUTER_STATUS_WAKEUP2_ST_Pos = 0x2
	// Bit mask of WAKEUP2_ST field.
	EVENTROUTER_STATUS_WAKEUP2_ST_Msk = 0x4
	// Bit WAKEUP2_ST.
	EVENTROUTER_STATUS_WAKEUP2_ST = 0x4
	// Position of WAKEUP3_ST field.
	EVENTROUTER_STATUS_WAKEUP3_ST_Pos = 0x3
	// Bit mask of WAKEUP3_ST field.
	EVENTROUTER_STATUS_WAKEUP3_ST_Msk = 0x8
	// Bit WAKEUP3_ST.
	EVENTROUTER_STATUS_WAKEUP3_ST = 0x8
	// Position of ATIMER_ST field.
	EVENTROUTER_STATUS_ATIMER_ST_Pos = 0x4
	// Bit mask of ATIMER_ST field.
	EVENTROUTER_STATUS_ATIMER_ST_Msk = 0x10
	// Bit ATIMER_ST.
	EVENTROUTER_STATUS_ATIMER_ST = 0x10
	// Position of RTC_ST field.
	EVENTROUTER_STATUS_RTC_ST_Pos = 0x5
	// Bit mask of RTC_ST field.
	EVENTROUTER_STATUS_RTC_ST_Msk = 0x20
	// Bit RTC_ST.
	EVENTROUTER_STATUS_RTC_ST = 0x20
	// Position of BOD_ST field.
	EVENTROUTER_STATUS_BOD_ST_Pos = 0x6
	// Bit mask of BOD_ST field.
	EVENTROUTER_STATUS_BOD_ST_Msk = 0x40
	// Bit BOD_ST.
	EVENTROUTER_STATUS_BOD_ST = 0x40
	// Position of WWDT_ST field.
	EVENTROUTER_STATUS_WWDT_ST_Pos = 0x7
	// Bit mask of WWDT_ST field.
	EVENTROUTER_STATUS_WWDT_ST_Msk = 0x80
	// Bit WWDT_ST.
	EVENTROUTER_STATUS_WWDT_ST = 0x80
	// Position of ETH_ST field.
	EVENTROUTER_STATUS_ETH_ST_Pos = 0x8
	// Bit mask of ETH_ST field.
	EVENTROUTER_STATUS_ETH_ST_Msk = 0x100
	// Bit ETH_ST.
	EVENTROUTER_STATUS_ETH_ST = 0x100
	// Position of USB0_ST field.
	EVENTROUTER_STATUS_USB0_ST_Pos = 0x9
	// Bit mask of USB0_ST field.
	EVENTROUTER_STATUS_USB0_ST_Msk = 0x200
	// Bit USB0_ST.
	EVENTROUTER_STATUS_USB0_ST = 0x200
	// Position of USB1_ST field.
	EVENTROUTER_STATUS_USB1_ST_Pos = 0xa
	// Bit mask of USB1_ST field.
	EVENTROUTER_STATUS_USB1_ST_Msk = 0x400
	// Bit USB1_ST.
	EVENTROUTER_STATUS_USB1_ST = 0x400
	// Position of SDMMC_ST field.
	EVENTROUTER_STATUS_SDMMC_ST_Pos = 0xb
	// Bit mask of SDMMC_ST field.
	EVENTROUTER_STATUS_SDMMC_ST_Msk = 0x800
	// Bit SDMMC_ST.
	EVENTROUTER_STATUS_SDMMC_ST = 0x800
	// Position of CAN_ST field.
	EVENTROUTER_STATUS_CAN_ST_Pos = 0xc
	// Bit mask of CAN_ST field.
	EVENTROUTER_STATUS_CAN_ST_Msk = 0x1000
	// Bit CAN_ST.
	EVENTROUTER_STATUS_CAN_ST = 0x1000
	// Position of TIM2_ST field.
	EVENTROUTER_STATUS_TIM2_ST_Pos = 0xd
	// Bit mask of TIM2_ST field.
	EVENTROUTER_STATUS_TIM2_ST_Msk = 0x2000
	// Bit TIM2_ST.
	EVENTROUTER_STATUS_TIM2_ST = 0x2000
	// Position of TIM6_ST field.
	EVENTROUTER_STATUS_TIM6_ST_Pos = 0xe
	// Bit mask of TIM6_ST field.
	EVENTROUTER_STATUS_TIM6_ST_Msk = 0x4000
	// Bit TIM6_ST.
	EVENTROUTER_STATUS_TIM6_ST = 0x4000
	// Position of QEI_ST field.
	EVENTROUTER_STATUS_QEI_ST_Pos = 0xf
	// Bit mask of QEI_ST field.
	EVENTROUTER_STATUS_QEI_ST_Msk = 0x8000
	// Bit QEI_ST.
	EVENTROUTER_STATUS_QEI_ST = 0x8000
	// Position of TIM14_ST field.
	EVENTROUTER_STATUS_TIM14_ST_Pos = 0x10
	// Bit mask of TIM14_ST field.
	EVENTROUTER_STATUS_TIM14_ST_Msk = 0x10000
	// Bit TIM14_ST.
	EVENTROUTER_STATUS_TIM14_ST = 0x10000
	// Position of RESERVED field.
	EVENTROUTER_STATUS_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	EVENTROUTER_STATUS_RESERVED_Msk = 0x60000
	// Position of RESET_ST field.
	EVENTROUTER_STATUS_RESET_ST_Pos = 0x13
	// Bit mask of RESET_ST field.
	EVENTROUTER_STATUS_RESET_ST_Msk = 0x80000
	// Bit RESET_ST.
	EVENTROUTER_STATUS_RESET_ST = 0x80000
	// Position of BODRESET_ST field.
	EVENTROUTER_STATUS_BODRESET_ST_Pos = 0x14
	// Bit mask of BODRESET_ST field.
	EVENTROUTER_STATUS_BODRESET_ST_Msk = 0x100000
	// Bit BODRESET_ST.
	EVENTROUTER_STATUS_BODRESET_ST = 0x100000
	// Position of DPDRESET_ST field.
	EVENTROUTER_STATUS_DPDRESET_ST_Pos = 0x15
	// Bit mask of DPDRESET_ST field.
	EVENTROUTER_STATUS_DPDRESET_ST_Msk = 0x200000
	// Bit DPDRESET_ST.
	EVENTROUTER_STATUS_DPDRESET_ST = 0x200000
	// Position of RESERVED field.
	EVENTROUTER_STATUS_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	EVENTROUTER_STATUS_RESERVED_Msk = 0xffc00000

	// ENABLE: Event Enable register
	// Position of WAKEUP0_EN field.
	EVENTROUTER_ENABLE_WAKEUP0_EN_Pos = 0x0
	// Bit mask of WAKEUP0_EN field.
	EVENTROUTER_ENABLE_WAKEUP0_EN_Msk = 0x1
	// Bit WAKEUP0_EN.
	EVENTROUTER_ENABLE_WAKEUP0_EN = 0x1
	// Position of WAKEUP1_EN field.
	EVENTROUTER_ENABLE_WAKEUP1_EN_Pos = 0x1
	// Bit mask of WAKEUP1_EN field.
	EVENTROUTER_ENABLE_WAKEUP1_EN_Msk = 0x2
	// Bit WAKEUP1_EN.
	EVENTROUTER_ENABLE_WAKEUP1_EN = 0x2
	// Position of WAKEUP2_EN field.
	EVENTROUTER_ENABLE_WAKEUP2_EN_Pos = 0x2
	// Bit mask of WAKEUP2_EN field.
	EVENTROUTER_ENABLE_WAKEUP2_EN_Msk = 0x4
	// Bit WAKEUP2_EN.
	EVENTROUTER_ENABLE_WAKEUP2_EN = 0x4
	// Position of WAKEUP3_EN field.
	EVENTROUTER_ENABLE_WAKEUP3_EN_Pos = 0x3
	// Bit mask of WAKEUP3_EN field.
	EVENTROUTER_ENABLE_WAKEUP3_EN_Msk = 0x8
	// Bit WAKEUP3_EN.
	EVENTROUTER_ENABLE_WAKEUP3_EN = 0x8
	// Position of ATIMER_EN field.
	EVENTROUTER_ENABLE_ATIMER_EN_Pos = 0x4
	// Bit mask of ATIMER_EN field.
	EVENTROUTER_ENABLE_ATIMER_EN_Msk = 0x10
	// Bit ATIMER_EN.
	EVENTROUTER_ENABLE_ATIMER_EN = 0x10
	// Position of RTC_EN field.
	EVENTROUTER_ENABLE_RTC_EN_Pos = 0x5
	// Bit mask of RTC_EN field.
	EVENTROUTER_ENABLE_RTC_EN_Msk = 0x20
	// Bit RTC_EN.
	EVENTROUTER_ENABLE_RTC_EN = 0x20
	// Position of BOD_EN field.
	EVENTROUTER_ENABLE_BOD_EN_Pos = 0x6
	// Bit mask of BOD_EN field.
	EVENTROUTER_ENABLE_BOD_EN_Msk = 0x40
	// Bit BOD_EN.
	EVENTROUTER_ENABLE_BOD_EN = 0x40
	// Position of WWDT_EN field.
	EVENTROUTER_ENABLE_WWDT_EN_Pos = 0x7
	// Bit mask of WWDT_EN field.
	EVENTROUTER_ENABLE_WWDT_EN_Msk = 0x80
	// Bit WWDT_EN.
	EVENTROUTER_ENABLE_WWDT_EN = 0x80
	// Position of ETH_EN field.
	EVENTROUTER_ENABLE_ETH_EN_Pos = 0x8
	// Bit mask of ETH_EN field.
	EVENTROUTER_ENABLE_ETH_EN_Msk = 0x100
	// Bit ETH_EN.
	EVENTROUTER_ENABLE_ETH_EN = 0x100
	// Position of USB0_EN field.
	EVENTROUTER_ENABLE_USB0_EN_Pos = 0x9
	// Bit mask of USB0_EN field.
	EVENTROUTER_ENABLE_USB0_EN_Msk = 0x200
	// Bit USB0_EN.
	EVENTROUTER_ENABLE_USB0_EN = 0x200
	// Position of USB1_EN field.
	EVENTROUTER_ENABLE_USB1_EN_Pos = 0xa
	// Bit mask of USB1_EN field.
	EVENTROUTER_ENABLE_USB1_EN_Msk = 0x400
	// Bit USB1_EN.
	EVENTROUTER_ENABLE_USB1_EN = 0x400
	// Position of SDMMC_EN field.
	EVENTROUTER_ENABLE_SDMMC_EN_Pos = 0xb
	// Bit mask of SDMMC_EN field.
	EVENTROUTER_ENABLE_SDMMC_EN_Msk = 0x800
	// Bit SDMMC_EN.
	EVENTROUTER_ENABLE_SDMMC_EN = 0x800
	// Position of CAN_EN field.
	EVENTROUTER_ENABLE_CAN_EN_Pos = 0xc
	// Bit mask of CAN_EN field.
	EVENTROUTER_ENABLE_CAN_EN_Msk = 0x1000
	// Bit CAN_EN.
	EVENTROUTER_ENABLE_CAN_EN = 0x1000
	// Position of TIM2_EN field.
	EVENTROUTER_ENABLE_TIM2_EN_Pos = 0xd
	// Bit mask of TIM2_EN field.
	EVENTROUTER_ENABLE_TIM2_EN_Msk = 0x2000
	// Bit TIM2_EN.
	EVENTROUTER_ENABLE_TIM2_EN = 0x2000
	// Position of TIM6_EN field.
	EVENTROUTER_ENABLE_TIM6_EN_Pos = 0xe
	// Bit mask of TIM6_EN field.
	EVENTROUTER_ENABLE_TIM6_EN_Msk = 0x4000
	// Bit TIM6_EN.
	EVENTROUTER_ENABLE_TIM6_EN = 0x4000
	// Position of QEI_EN field.
	EVENTROUTER_ENABLE_QEI_EN_Pos = 0xf
	// Bit mask of QEI_EN field.
	EVENTROUTER_ENABLE_QEI_EN_Msk = 0x8000
	// Bit QEI_EN.
	EVENTROUTER_ENABLE_QEI_EN = 0x8000
	// Position of TIM14_EN field.
	EVENTROUTER_ENABLE_TIM14_EN_Pos = 0x10
	// Bit mask of TIM14_EN field.
	EVENTROUTER_ENABLE_TIM14_EN_Msk = 0x10000
	// Bit TIM14_EN.
	EVENTROUTER_ENABLE_TIM14_EN = 0x10000
	// Position of RESERVED field.
	EVENTROUTER_ENABLE_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	EVENTROUTER_ENABLE_RESERVED_Msk = 0x60000
	// Position of RESET_EN field.
	EVENTROUTER_ENABLE_RESET_EN_Pos = 0x13
	// Bit mask of RESET_EN field.
	EVENTROUTER_ENABLE_RESET_EN_Msk = 0x80000
	// Bit RESET_EN.
	EVENTROUTER_ENABLE_RESET_EN = 0x80000
	// Position of BODRESET_EN field.
	EVENTROUTER_ENABLE_BODRESET_EN_Pos = 0x14
	// Bit mask of BODRESET_EN field.
	EVENTROUTER_ENABLE_BODRESET_EN_Msk = 0x100000
	// Bit BODRESET_EN.
	EVENTROUTER_ENABLE_BODRESET_EN = 0x100000
	// Position of DPDRESET_EN field.
	EVENTROUTER_ENABLE_DPDRESET_EN_Pos = 0x15
	// Bit mask of DPDRESET_EN field.
	EVENTROUTER_ENABLE_DPDRESET_EN_Msk = 0x200000
	// Bit DPDRESET_EN.
	EVENTROUTER_ENABLE_DPDRESET_EN = 0x200000
	// Position of RESERVED field.
	EVENTROUTER_ENABLE_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	EVENTROUTER_ENABLE_RESERVED_Msk = 0xffc00000

	// CLR_STAT: Clear event status register
	// Position of WAKEUP0_CLRST field.
	EVENTROUTER_CLR_STAT_WAKEUP0_CLRST_Pos = 0x0
	// Bit mask of WAKEUP0_CLRST field.
	EVENTROUTER_CLR_STAT_WAKEUP0_CLRST_Msk = 0x1
	// Bit WAKEUP0_CLRST.
	EVENTROUTER_CLR_STAT_WAKEUP0_CLRST = 0x1
	// Position of WAKEUP1_CLRST field.
	EVENTROUTER_CLR_STAT_WAKEUP1_CLRST_Pos = 0x1
	// Bit mask of WAKEUP1_CLRST field.
	EVENTROUTER_CLR_STAT_WAKEUP1_CLRST_Msk = 0x2
	// Bit WAKEUP1_CLRST.
	EVENTROUTER_CLR_STAT_WAKEUP1_CLRST = 0x2
	// Position of WAKEUP2_CLRST field.
	EVENTROUTER_CLR_STAT_WAKEUP2_CLRST_Pos = 0x2
	// Bit mask of WAKEUP2_CLRST field.
	EVENTROUTER_CLR_STAT_WAKEUP2_CLRST_Msk = 0x4
	// Bit WAKEUP2_CLRST.
	EVENTROUTER_CLR_STAT_WAKEUP2_CLRST = 0x4
	// Position of WAKEUP3_CLRST field.
	EVENTROUTER_CLR_STAT_WAKEUP3_CLRST_Pos = 0x3
	// Bit mask of WAKEUP3_CLRST field.
	EVENTROUTER_CLR_STAT_WAKEUP3_CLRST_Msk = 0x8
	// Bit WAKEUP3_CLRST.
	EVENTROUTER_CLR_STAT_WAKEUP3_CLRST = 0x8
	// Position of ATIMER_CLRST field.
	EVENTROUTER_CLR_STAT_ATIMER_CLRST_Pos = 0x4
	// Bit mask of ATIMER_CLRST field.
	EVENTROUTER_CLR_STAT_ATIMER_CLRST_Msk = 0x10
	// Bit ATIMER_CLRST.
	EVENTROUTER_CLR_STAT_ATIMER_CLRST = 0x10
	// Position of RTC_CLRST field.
	EVENTROUTER_CLR_STAT_RTC_CLRST_Pos = 0x5
	// Bit mask of RTC_CLRST field.
	EVENTROUTER_CLR_STAT_RTC_CLRST_Msk = 0x20
	// Bit RTC_CLRST.
	EVENTROUTER_CLR_STAT_RTC_CLRST = 0x20
	// Position of BOD_CLRST field.
	EVENTROUTER_CLR_STAT_BOD_CLRST_Pos = 0x6
	// Bit mask of BOD_CLRST field.
	EVENTROUTER_CLR_STAT_BOD_CLRST_Msk = 0x40
	// Bit BOD_CLRST.
	EVENTROUTER_CLR_STAT_BOD_CLRST = 0x40
	// Position of WWDT_CLRST field.
	EVENTROUTER_CLR_STAT_WWDT_CLRST_Pos = 0x7
	// Bit mask of WWDT_CLRST field.
	EVENTROUTER_CLR_STAT_WWDT_CLRST_Msk = 0x80
	// Bit WWDT_CLRST.
	EVENTROUTER_CLR_STAT_WWDT_CLRST = 0x80
	// Position of ETH_CLRST field.
	EVENTROUTER_CLR_STAT_ETH_CLRST_Pos = 0x8
	// Bit mask of ETH_CLRST field.
	EVENTROUTER_CLR_STAT_ETH_CLRST_Msk = 0x100
	// Bit ETH_CLRST.
	EVENTROUTER_CLR_STAT_ETH_CLRST = 0x100
	// Position of USB0_CLRST field.
	EVENTROUTER_CLR_STAT_USB0_CLRST_Pos = 0x9
	// Bit mask of USB0_CLRST field.
	EVENTROUTER_CLR_STAT_USB0_CLRST_Msk = 0x200
	// Bit USB0_CLRST.
	EVENTROUTER_CLR_STAT_USB0_CLRST = 0x200
	// Position of USB1_CLRST field.
	EVENTROUTER_CLR_STAT_USB1_CLRST_Pos = 0xa
	// Bit mask of USB1_CLRST field.
	EVENTROUTER_CLR_STAT_USB1_CLRST_Msk = 0x400
	// Bit USB1_CLRST.
	EVENTROUTER_CLR_STAT_USB1_CLRST = 0x400
	// Position of SDMMC_CLRST field.
	EVENTROUTER_CLR_STAT_SDMMC_CLRST_Pos = 0xb
	// Bit mask of SDMMC_CLRST field.
	EVENTROUTER_CLR_STAT_SDMMC_CLRST_Msk = 0x800
	// Bit SDMMC_CLRST.
	EVENTROUTER_CLR_STAT_SDMMC_CLRST = 0x800
	// Position of CAN_CLRST field.
	EVENTROUTER_CLR_STAT_CAN_CLRST_Pos = 0xc
	// Bit mask of CAN_CLRST field.
	EVENTROUTER_CLR_STAT_CAN_CLRST_Msk = 0x1000
	// Bit CAN_CLRST.
	EVENTROUTER_CLR_STAT_CAN_CLRST = 0x1000
	// Position of TIM2_CLRST field.
	EVENTROUTER_CLR_STAT_TIM2_CLRST_Pos = 0xd
	// Bit mask of TIM2_CLRST field.
	EVENTROUTER_CLR_STAT_TIM2_CLRST_Msk = 0x2000
	// Bit TIM2_CLRST.
	EVENTROUTER_CLR_STAT_TIM2_CLRST = 0x2000
	// Position of TIM6_CLRST field.
	EVENTROUTER_CLR_STAT_TIM6_CLRST_Pos = 0xe
	// Bit mask of TIM6_CLRST field.
	EVENTROUTER_CLR_STAT_TIM6_CLRST_Msk = 0x4000
	// Bit TIM6_CLRST.
	EVENTROUTER_CLR_STAT_TIM6_CLRST = 0x4000
	// Position of QEI_CLRST field.
	EVENTROUTER_CLR_STAT_QEI_CLRST_Pos = 0xf
	// Bit mask of QEI_CLRST field.
	EVENTROUTER_CLR_STAT_QEI_CLRST_Msk = 0x8000
	// Bit QEI_CLRST.
	EVENTROUTER_CLR_STAT_QEI_CLRST = 0x8000
	// Position of TIM14_CLRST field.
	EVENTROUTER_CLR_STAT_TIM14_CLRST_Pos = 0x10
	// Bit mask of TIM14_CLRST field.
	EVENTROUTER_CLR_STAT_TIM14_CLRST_Msk = 0x10000
	// Bit TIM14_CLRST.
	EVENTROUTER_CLR_STAT_TIM14_CLRST = 0x10000
	// Position of RESERVED field.
	EVENTROUTER_CLR_STAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	EVENTROUTER_CLR_STAT_RESERVED_Msk = 0x60000
	// Position of RESET_CLRST field.
	EVENTROUTER_CLR_STAT_RESET_CLRST_Pos = 0x13
	// Bit mask of RESET_CLRST field.
	EVENTROUTER_CLR_STAT_RESET_CLRST_Msk = 0x80000
	// Bit RESET_CLRST.
	EVENTROUTER_CLR_STAT_RESET_CLRST = 0x80000
	// Position of BODRESET_CLRST field.
	EVENTROUTER_CLR_STAT_BODRESET_CLRST_Pos = 0x14
	// Bit mask of BODRESET_CLRST field.
	EVENTROUTER_CLR_STAT_BODRESET_CLRST_Msk = 0x100000
	// Bit BODRESET_CLRST.
	EVENTROUTER_CLR_STAT_BODRESET_CLRST = 0x100000
	// Position of DPDRESET_CLRST field.
	EVENTROUTER_CLR_STAT_DPDRESET_CLRST_Pos = 0x15
	// Bit mask of DPDRESET_CLRST field.
	EVENTROUTER_CLR_STAT_DPDRESET_CLRST_Msk = 0x200000
	// Bit DPDRESET_CLRST.
	EVENTROUTER_CLR_STAT_DPDRESET_CLRST = 0x200000
	// Position of RESERVED field.
	EVENTROUTER_CLR_STAT_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	EVENTROUTER_CLR_STAT_RESERVED_Msk = 0xffc00000

	// SET_STAT: Set event status register
	// Position of WAKEUP0_SETST field.
	EVENTROUTER_SET_STAT_WAKEUP0_SETST_Pos = 0x0
	// Bit mask of WAKEUP0_SETST field.
	EVENTROUTER_SET_STAT_WAKEUP0_SETST_Msk = 0x1
	// Bit WAKEUP0_SETST.
	EVENTROUTER_SET_STAT_WAKEUP0_SETST = 0x1
	// Position of WAKEUP1_SETST field.
	EVENTROUTER_SET_STAT_WAKEUP1_SETST_Pos = 0x1
	// Bit mask of WAKEUP1_SETST field.
	EVENTROUTER_SET_STAT_WAKEUP1_SETST_Msk = 0x2
	// Bit WAKEUP1_SETST.
	EVENTROUTER_SET_STAT_WAKEUP1_SETST = 0x2
	// Position of WAKEUP2_SETST field.
	EVENTROUTER_SET_STAT_WAKEUP2_SETST_Pos = 0x2
	// Bit mask of WAKEUP2_SETST field.
	EVENTROUTER_SET_STAT_WAKEUP2_SETST_Msk = 0x4
	// Bit WAKEUP2_SETST.
	EVENTROUTER_SET_STAT_WAKEUP2_SETST = 0x4
	// Position of WAKEUP3_SETST field.
	EVENTROUTER_SET_STAT_WAKEUP3_SETST_Pos = 0x3
	// Bit mask of WAKEUP3_SETST field.
	EVENTROUTER_SET_STAT_WAKEUP3_SETST_Msk = 0x8
	// Bit WAKEUP3_SETST.
	EVENTROUTER_SET_STAT_WAKEUP3_SETST = 0x8
	// Position of ATIMER_SETST field.
	EVENTROUTER_SET_STAT_ATIMER_SETST_Pos = 0x4
	// Bit mask of ATIMER_SETST field.
	EVENTROUTER_SET_STAT_ATIMER_SETST_Msk = 0x10
	// Bit ATIMER_SETST.
	EVENTROUTER_SET_STAT_ATIMER_SETST = 0x10
	// Position of RTC_SETST field.
	EVENTROUTER_SET_STAT_RTC_SETST_Pos = 0x5
	// Bit mask of RTC_SETST field.
	EVENTROUTER_SET_STAT_RTC_SETST_Msk = 0x20
	// Bit RTC_SETST.
	EVENTROUTER_SET_STAT_RTC_SETST = 0x20
	// Position of BOD_SETST field.
	EVENTROUTER_SET_STAT_BOD_SETST_Pos = 0x6
	// Bit mask of BOD_SETST field.
	EVENTROUTER_SET_STAT_BOD_SETST_Msk = 0x40
	// Bit BOD_SETST.
	EVENTROUTER_SET_STAT_BOD_SETST = 0x40
	// Position of WWDT_SETST field.
	EVENTROUTER_SET_STAT_WWDT_SETST_Pos = 0x7
	// Bit mask of WWDT_SETST field.
	EVENTROUTER_SET_STAT_WWDT_SETST_Msk = 0x80
	// Bit WWDT_SETST.
	EVENTROUTER_SET_STAT_WWDT_SETST = 0x80
	// Position of ETH_SETST field.
	EVENTROUTER_SET_STAT_ETH_SETST_Pos = 0x8
	// Bit mask of ETH_SETST field.
	EVENTROUTER_SET_STAT_ETH_SETST_Msk = 0x100
	// Bit ETH_SETST.
	EVENTROUTER_SET_STAT_ETH_SETST = 0x100
	// Position of USB0_SETST field.
	EVENTROUTER_SET_STAT_USB0_SETST_Pos = 0x9
	// Bit mask of USB0_SETST field.
	EVENTROUTER_SET_STAT_USB0_SETST_Msk = 0x200
	// Bit USB0_SETST.
	EVENTROUTER_SET_STAT_USB0_SETST = 0x200
	// Position of USB1_SETST field.
	EVENTROUTER_SET_STAT_USB1_SETST_Pos = 0xa
	// Bit mask of USB1_SETST field.
	EVENTROUTER_SET_STAT_USB1_SETST_Msk = 0x400
	// Bit USB1_SETST.
	EVENTROUTER_SET_STAT_USB1_SETST = 0x400
	// Position of SDMMC_SETST field.
	EVENTROUTER_SET_STAT_SDMMC_SETST_Pos = 0xb
	// Bit mask of SDMMC_SETST field.
	EVENTROUTER_SET_STAT_SDMMC_SETST_Msk = 0x800
	// Bit SDMMC_SETST.
	EVENTROUTER_SET_STAT_SDMMC_SETST = 0x800
	// Position of CAN_SETST field.
	EVENTROUTER_SET_STAT_CAN_SETST_Pos = 0xc
	// Bit mask of CAN_SETST field.
	EVENTROUTER_SET_STAT_CAN_SETST_Msk = 0x1000
	// Bit CAN_SETST.
	EVENTROUTER_SET_STAT_CAN_SETST = 0x1000
	// Position of TIM2_SETST field.
	EVENTROUTER_SET_STAT_TIM2_SETST_Pos = 0xd
	// Bit mask of TIM2_SETST field.
	EVENTROUTER_SET_STAT_TIM2_SETST_Msk = 0x2000
	// Bit TIM2_SETST.
	EVENTROUTER_SET_STAT_TIM2_SETST = 0x2000
	// Position of TIM6_SETST field.
	EVENTROUTER_SET_STAT_TIM6_SETST_Pos = 0xe
	// Bit mask of TIM6_SETST field.
	EVENTROUTER_SET_STAT_TIM6_SETST_Msk = 0x4000
	// Bit TIM6_SETST.
	EVENTROUTER_SET_STAT_TIM6_SETST = 0x4000
	// Position of QEI_SETST field.
	EVENTROUTER_SET_STAT_QEI_SETST_Pos = 0xf
	// Bit mask of QEI_SETST field.
	EVENTROUTER_SET_STAT_QEI_SETST_Msk = 0x8000
	// Bit QEI_SETST.
	EVENTROUTER_SET_STAT_QEI_SETST = 0x8000
	// Position of TIM14_SETST field.
	EVENTROUTER_SET_STAT_TIM14_SETST_Pos = 0x10
	// Bit mask of TIM14_SETST field.
	EVENTROUTER_SET_STAT_TIM14_SETST_Msk = 0x10000
	// Bit TIM14_SETST.
	EVENTROUTER_SET_STAT_TIM14_SETST = 0x10000
	// Position of RESERVED field.
	EVENTROUTER_SET_STAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	EVENTROUTER_SET_STAT_RESERVED_Msk = 0x60000
	// Position of RESET_SETST field.
	EVENTROUTER_SET_STAT_RESET_SETST_Pos = 0x13
	// Bit mask of RESET_SETST field.
	EVENTROUTER_SET_STAT_RESET_SETST_Msk = 0x80000
	// Bit RESET_SETST.
	EVENTROUTER_SET_STAT_RESET_SETST = 0x80000
	// Position of BODRESET_SETST field.
	EVENTROUTER_SET_STAT_BODRESET_SETST_Pos = 0x14
	// Bit mask of BODRESET_SETST field.
	EVENTROUTER_SET_STAT_BODRESET_SETST_Msk = 0x100000
	// Bit BODRESET_SETST.
	EVENTROUTER_SET_STAT_BODRESET_SETST = 0x100000
	// Position of DPDRESET_SETST field.
	EVENTROUTER_SET_STAT_DPDRESET_SETST_Pos = 0x15
	// Bit mask of DPDRESET_SETST field.
	EVENTROUTER_SET_STAT_DPDRESET_SETST_Msk = 0x200000
	// Bit DPDRESET_SETST.
	EVENTROUTER_SET_STAT_DPDRESET_SETST = 0x200000
	// Position of RESERVED field.
	EVENTROUTER_SET_STAT_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	EVENTROUTER_SET_STAT_RESERVED_Msk = 0xffc00000
)

// Bitfields for RTC: Real-Time Clock (RTC) and event recorder
const (
	// ILR: Interrupt Location Register
	// Position of RTCCIF field.
	RTC_ILR_RTCCIF_Pos = 0x0
	// Bit mask of RTCCIF field.
	RTC_ILR_RTCCIF_Msk = 0x1
	// Bit RTCCIF.
	RTC_ILR_RTCCIF = 0x1
	// Position of RTCALF field.
	RTC_ILR_RTCALF_Pos = 0x1
	// Bit mask of RTCALF field.
	RTC_ILR_RTCALF_Msk = 0x2
	// Bit RTCALF.
	RTC_ILR_RTCALF = 0x2
	// Position of RESERVED field.
	RTC_ILR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	RTC_ILR_RESERVED_Msk = 0xfffffffc

	// CCR: Clock Control Register
	// Position of CLKEN field.
	RTC_CCR_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	RTC_CCR_CLKEN_Msk = 0x1
	// Bit CLKEN.
	RTC_CCR_CLKEN = 0x1
	// The time counters are disabled so that they may be initialized.
	RTC_CCR_CLKEN_DISABLED = 0x0
	// The time counters are enabled.
	RTC_CCR_CLKEN_ENABLED = 0x1
	// Position of CTCRST field.
	RTC_CCR_CTCRST_Pos = 0x1
	// Bit mask of CTCRST field.
	RTC_CCR_CTCRST_Msk = 0x2
	// Bit CTCRST.
	RTC_CCR_CTCRST = 0x2
	// No effect.
	RTC_CCR_CTCRST_NO_EFFECT = 0x0
	// When one, the elements in the internal oscillator divider are reset, and remain reset until CCR[1] is changed to zero. This is the divider that generates the 1 Hz clock from the 32.768 kHz crystal. The state of the divider is not visible to software.
	RTC_CCR_CTCRST_RESET = 0x1
	// Position of RESERVED field.
	RTC_CCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	RTC_CCR_RESERVED_Msk = 0xc
	// Position of CCALEN field.
	RTC_CCR_CCALEN_Pos = 0x4
	// Bit mask of CCALEN field.
	RTC_CCR_CCALEN_Msk = 0x10
	// Bit CCALEN.
	RTC_CCR_CCALEN = 0x10
	// The calibration counter is enabled and counting, using the 1 Hz clock. When the calibration counter is equal to the value of the CALIBRATION register, the counter resets and repeats counting up to the value of the CALIBRATION register. See Section 29.6.6.2 and Section 29.7.1.
	RTC_CCR_CCALEN_ENABLED = 0x0
	// The calibration counter is disabled and reset to zero.
	RTC_CCR_CCALEN_DISABLED = 0x1
	// Position of RESERVED field.
	RTC_CCR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_CCR_RESERVED_Msk = 0xffffffe0

	// CIIR: Counter Increment Interrupt Register
	// Position of IMSEC field.
	RTC_CIIR_IMSEC_Pos = 0x0
	// Bit mask of IMSEC field.
	RTC_CIIR_IMSEC_Msk = 0x1
	// Bit IMSEC.
	RTC_CIIR_IMSEC = 0x1
	// Position of IMMIN field.
	RTC_CIIR_IMMIN_Pos = 0x1
	// Bit mask of IMMIN field.
	RTC_CIIR_IMMIN_Msk = 0x2
	// Bit IMMIN.
	RTC_CIIR_IMMIN = 0x2
	// Position of IMHOUR field.
	RTC_CIIR_IMHOUR_Pos = 0x2
	// Bit mask of IMHOUR field.
	RTC_CIIR_IMHOUR_Msk = 0x4
	// Bit IMHOUR.
	RTC_CIIR_IMHOUR = 0x4
	// Position of IMDOM field.
	RTC_CIIR_IMDOM_Pos = 0x3
	// Bit mask of IMDOM field.
	RTC_CIIR_IMDOM_Msk = 0x8
	// Bit IMDOM.
	RTC_CIIR_IMDOM = 0x8
	// Position of IMDOW field.
	RTC_CIIR_IMDOW_Pos = 0x4
	// Bit mask of IMDOW field.
	RTC_CIIR_IMDOW_Msk = 0x10
	// Bit IMDOW.
	RTC_CIIR_IMDOW = 0x10
	// Position of IMDOY field.
	RTC_CIIR_IMDOY_Pos = 0x5
	// Bit mask of IMDOY field.
	RTC_CIIR_IMDOY_Msk = 0x20
	// Bit IMDOY.
	RTC_CIIR_IMDOY = 0x20
	// Position of IMMON field.
	RTC_CIIR_IMMON_Pos = 0x6
	// Bit mask of IMMON field.
	RTC_CIIR_IMMON_Msk = 0x40
	// Bit IMMON.
	RTC_CIIR_IMMON = 0x40
	// Position of IMYEAR field.
	RTC_CIIR_IMYEAR_Pos = 0x7
	// Bit mask of IMYEAR field.
	RTC_CIIR_IMYEAR_Msk = 0x80
	// Bit IMYEAR.
	RTC_CIIR_IMYEAR = 0x80
	// Position of RESERVED field.
	RTC_CIIR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	RTC_CIIR_RESERVED_Msk = 0xffffff00

	// AMR: Alarm Mask Register
	// Position of AMRSEC field.
	RTC_AMR_AMRSEC_Pos = 0x0
	// Bit mask of AMRSEC field.
	RTC_AMR_AMRSEC_Msk = 0x1
	// Bit AMRSEC.
	RTC_AMR_AMRSEC = 0x1
	// Position of AMRMIN field.
	RTC_AMR_AMRMIN_Pos = 0x1
	// Bit mask of AMRMIN field.
	RTC_AMR_AMRMIN_Msk = 0x2
	// Bit AMRMIN.
	RTC_AMR_AMRMIN = 0x2
	// Position of AMRHOUR field.
	RTC_AMR_AMRHOUR_Pos = 0x2
	// Bit mask of AMRHOUR field.
	RTC_AMR_AMRHOUR_Msk = 0x4
	// Bit AMRHOUR.
	RTC_AMR_AMRHOUR = 0x4
	// Position of AMRDOM field.
	RTC_AMR_AMRDOM_Pos = 0x3
	// Bit mask of AMRDOM field.
	RTC_AMR_AMRDOM_Msk = 0x8
	// Bit AMRDOM.
	RTC_AMR_AMRDOM = 0x8
	// Position of AMRDOW field.
	RTC_AMR_AMRDOW_Pos = 0x4
	// Bit mask of AMRDOW field.
	RTC_AMR_AMRDOW_Msk = 0x10
	// Bit AMRDOW.
	RTC_AMR_AMRDOW = 0x10
	// Position of AMRDOY field.
	RTC_AMR_AMRDOY_Pos = 0x5
	// Bit mask of AMRDOY field.
	RTC_AMR_AMRDOY_Msk = 0x20
	// Bit AMRDOY.
	RTC_AMR_AMRDOY = 0x20
	// Position of AMRMON field.
	RTC_AMR_AMRMON_Pos = 0x6
	// Bit mask of AMRMON field.
	RTC_AMR_AMRMON_Msk = 0x40
	// Bit AMRMON.
	RTC_AMR_AMRMON = 0x40
	// Position of AMRYEAR field.
	RTC_AMR_AMRYEAR_Pos = 0x7
	// Bit mask of AMRYEAR field.
	RTC_AMR_AMRYEAR_Msk = 0x80
	// Bit AMRYEAR.
	RTC_AMR_AMRYEAR = 0x80
	// Position of RESERVED field.
	RTC_AMR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	RTC_AMR_RESERVED_Msk = 0xffffff00

	// CTIME0: Consolidated Time Register 0
	// Position of SECONDS field.
	RTC_CTIME0_SECONDS_Pos = 0x0
	// Bit mask of SECONDS field.
	RTC_CTIME0_SECONDS_Msk = 0x3f
	// Position of RESERVED field.
	RTC_CTIME0_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xc0
	// Position of MINUTES field.
	RTC_CTIME0_MINUTES_Pos = 0x8
	// Bit mask of MINUTES field.
	RTC_CTIME0_MINUTES_Msk = 0x3f00
	// Position of RESERVED field.
	RTC_CTIME0_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xc000
	// Position of HOURS field.
	RTC_CTIME0_HOURS_Pos = 0x10
	// Bit mask of HOURS field.
	RTC_CTIME0_HOURS_Msk = 0x1f0000
	// Position of RESERVED field.
	RTC_CTIME0_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xe00000
	// Position of DOW field.
	RTC_CTIME0_DOW_Pos = 0x18
	// Bit mask of DOW field.
	RTC_CTIME0_DOW_Msk = 0x7000000
	// Position of RESERVED field.
	RTC_CTIME0_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xf8000000

	// CTIME1: Consolidated Time Register 1
	// Position of DOM field.
	RTC_CTIME1_DOM_Pos = 0x0
	// Bit mask of DOM field.
	RTC_CTIME1_DOM_Msk = 0x1f
	// Position of RESERVED field.
	RTC_CTIME1_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_CTIME1_RESERVED_Msk = 0xe0
	// Position of MONTH field.
	RTC_CTIME1_MONTH_Pos = 0x8
	// Bit mask of MONTH field.
	RTC_CTIME1_MONTH_Msk = 0xf00
	// Position of RESERVED field.
	RTC_CTIME1_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	RTC_CTIME1_RESERVED_Msk = 0xf000
	// Position of YEAR field.
	RTC_CTIME1_YEAR_Pos = 0x10
	// Bit mask of YEAR field.
	RTC_CTIME1_YEAR_Msk = 0xfff0000
	// Position of RESERVED field.
	RTC_CTIME1_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	RTC_CTIME1_RESERVED_Msk = 0xf0000000

	// CTIME2: Consolidated Time Register 2
	// Position of DOY field.
	RTC_CTIME2_DOY_Pos = 0x0
	// Bit mask of DOY field.
	RTC_CTIME2_DOY_Msk = 0xfff
	// Position of RESERVED field.
	RTC_CTIME2_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	RTC_CTIME2_RESERVED_Msk = 0xfffff000

	// SEC: Seconds Register
	// Position of SECONDS field.
	RTC_SEC_SECONDS_Pos = 0x0
	// Bit mask of SECONDS field.
	RTC_SEC_SECONDS_Msk = 0x3f
	// Position of RESERVED field.
	RTC_SEC_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RTC_SEC_RESERVED_Msk = 0xffffffc0

	// MIN: Minutes Register
	// Position of MINUTES field.
	RTC_MIN_MINUTES_Pos = 0x0
	// Bit mask of MINUTES field.
	RTC_MIN_MINUTES_Msk = 0x3f
	// Position of RESERVED field.
	RTC_MIN_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RTC_MIN_RESERVED_Msk = 0xffffffc0

	// HRS: Hours Register
	// Position of HOURS field.
	RTC_HRS_HOURS_Pos = 0x0
	// Bit mask of HOURS field.
	RTC_HRS_HOURS_Msk = 0x1f
	// Position of RESERVED field.
	RTC_HRS_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_HRS_RESERVED_Msk = 0xffffffe0

	// DOM: Day of Month Register
	// Position of DOM field.
	RTC_DOM_DOM_Pos = 0x0
	// Bit mask of DOM field.
	RTC_DOM_DOM_Msk = 0x1f
	// Position of RESERVED field.
	RTC_DOM_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_DOM_RESERVED_Msk = 0xffffffe0

	// DOW: Day of Week Register
	// Position of DOW field.
	RTC_DOW_DOW_Pos = 0x0
	// Bit mask of DOW field.
	RTC_DOW_DOW_Msk = 0x7
	// Position of RESERVED field.
	RTC_DOW_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RTC_DOW_RESERVED_Msk = 0xfffffff8

	// DOY: Day of Year Register
	// Position of DOY field.
	RTC_DOY_DOY_Pos = 0x0
	// Bit mask of DOY field.
	RTC_DOY_DOY_Msk = 0x1ff
	// Position of RESERVED field.
	RTC_DOY_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	RTC_DOY_RESERVED_Msk = 0xfffffe00

	// MONTH: Months Register
	// Position of MONTH field.
	RTC_MONTH_MONTH_Pos = 0x0
	// Bit mask of MONTH field.
	RTC_MONTH_MONTH_Msk = 0xf
	// Position of RESERVED field.
	RTC_MONTH_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RTC_MONTH_RESERVED_Msk = 0xfffffff0

	// YEAR: Years Register
	// Position of YEAR field.
	RTC_YEAR_YEAR_Pos = 0x0
	// Bit mask of YEAR field.
	RTC_YEAR_YEAR_Msk = 0xfff
	// Position of RESERVED field.
	RTC_YEAR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	RTC_YEAR_RESERVED_Msk = 0xfffff000

	// CALIBRATION: Calibration Value Register
	// Position of CALVAL field.
	RTC_CALIBRATION_CALVAL_Pos = 0x0
	// Bit mask of CALVAL field.
	RTC_CALIBRATION_CALVAL_Msk = 0x1ffff
	// Position of CALDIR field.
	RTC_CALIBRATION_CALDIR_Pos = 0x11
	// Bit mask of CALDIR field.
	RTC_CALIBRATION_CALDIR_Msk = 0x20000
	// Bit CALDIR.
	RTC_CALIBRATION_CALDIR = 0x20000
	// Forward calibration. When CALVAL is equal to the calibration counter, the RTC timers will jump by 2 seconds.
	RTC_CALIBRATION_CALDIR_FORWARD_CALIBRATION_ = 0x0
	// Backward calibration. When CALVAL is equal to the calibration counter, the RTC timers will stop incrementing for 1 second.
	RTC_CALIBRATION_CALDIR_BACKWARD_CALIBRATION = 0x1

	// ASEC: Alarm value for Seconds
	// Position of SECONDS field.
	RTC_ASEC_SECONDS_Pos = 0x0
	// Bit mask of SECONDS field.
	RTC_ASEC_SECONDS_Msk = 0x3f
	// Position of RESERVED field.
	RTC_ASEC_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RTC_ASEC_RESERVED_Msk = 0xffffffc0

	// AMIN: Alarm value for Minutes
	// Position of MINUTES field.
	RTC_AMIN_MINUTES_Pos = 0x0
	// Bit mask of MINUTES field.
	RTC_AMIN_MINUTES_Msk = 0x3f
	// Position of RESERVED field.
	RTC_AMIN_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RTC_AMIN_RESERVED_Msk = 0xffffffc0

	// AHRS: Alarm value for Hours
	// Position of HOURS field.
	RTC_AHRS_HOURS_Pos = 0x0
	// Bit mask of HOURS field.
	RTC_AHRS_HOURS_Msk = 0x1f
	// Position of RESERVED field.
	RTC_AHRS_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_AHRS_RESERVED_Msk = 0xffffffe0

	// ADOM: Alarm value for Day of Month
	// Position of DOM field.
	RTC_ADOM_DOM_Pos = 0x0
	// Bit mask of DOM field.
	RTC_ADOM_DOM_Msk = 0x1f
	// Position of RESERVED field.
	RTC_ADOM_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_ADOM_RESERVED_Msk = 0xffffffe0

	// ADOW: Alarm value for Day of Week
	// Position of DOW field.
	RTC_ADOW_DOW_Pos = 0x0
	// Bit mask of DOW field.
	RTC_ADOW_DOW_Msk = 0x7
	// Position of RESERVED field.
	RTC_ADOW_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RTC_ADOW_RESERVED_Msk = 0xfffffff8

	// ADOY: Alarm value for Day of Year
	// Position of DOY field.
	RTC_ADOY_DOY_Pos = 0x0
	// Bit mask of DOY field.
	RTC_ADOY_DOY_Msk = 0x1ff
	// Position of RESERVED field.
	RTC_ADOY_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	RTC_ADOY_RESERVED_Msk = 0xfffffe00

	// AMON: Alarm value for Months
	// Position of MONTH field.
	RTC_AMON_MONTH_Pos = 0x0
	// Bit mask of MONTH field.
	RTC_AMON_MONTH_Msk = 0xf
	// Position of RESERVED field.
	RTC_AMON_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RTC_AMON_RESERVED_Msk = 0xfffffff0

	// AYRS: Alarm value for Year
	// Position of YEAR field.
	RTC_AYRS_YEAR_Pos = 0x0
	// Bit mask of YEAR field.
	RTC_AYRS_YEAR_Msk = 0xfff
	// Position of RESERVED field.
	RTC_AYRS_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	RTC_AYRS_RESERVED_Msk = 0xfffff000

	// ERSTATUS: Event Monitor/Recorder Status register. Contains status flags for event channels and other Event Monitor/Recorder conditions.
	// Position of EV0 field.
	RTC_ERSTATUS_EV0_Pos = 0x0
	// Bit mask of EV0 field.
	RTC_ERSTATUS_EV0_Msk = 0x1
	// Bit EV0.
	RTC_ERSTATUS_EV0 = 0x1
	// No event change on channel 0.
	RTC_ERSTATUS_EV0_NO_CHANGE = 0x0
	// At least one event has occurred on channel 0.
	RTC_ERSTATUS_EV0_EVENT = 0x1
	// Position of EV1 field.
	RTC_ERSTATUS_EV1_Pos = 0x1
	// Bit mask of EV1 field.
	RTC_ERSTATUS_EV1_Msk = 0x2
	// Bit EV1.
	RTC_ERSTATUS_EV1 = 0x2
	// No event change on channel 1.
	RTC_ERSTATUS_EV1_NO_CHANGE = 0x0
	// At least one event has occurred on channel 1.
	RTC_ERSTATUS_EV1_EVENT = 0x1
	// Position of EV2 field.
	RTC_ERSTATUS_EV2_Pos = 0x2
	// Bit mask of EV2 field.
	RTC_ERSTATUS_EV2_Msk = 0x4
	// Bit EV2.
	RTC_ERSTATUS_EV2 = 0x4
	// No event change on channel 2.
	RTC_ERSTATUS_EV2_NO_CHANGE = 0x0
	// At least one event has occurred on channel 2.
	RTC_ERSTATUS_EV2_EVENT = 0x1
	// Position of GP_CLEARED field.
	RTC_ERSTATUS_GP_CLEARED_Pos = 0x3
	// Bit mask of GP_CLEARED field.
	RTC_ERSTATUS_GP_CLEARED_Msk = 0x8
	// Bit GP_CLEARED.
	RTC_ERSTATUS_GP_CLEARED = 0x8
	// General purpose registers have not been asynchronous cleared.
	RTC_ERSTATUS_GP_CLEARED_NO_CHANGE = 0x0
	// General purpose registers have been asynchronous cleared.
	RTC_ERSTATUS_GP_CLEARED_EVENT = 0x1
	// Position of RESERVED field.
	RTC_ERSTATUS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RTC_ERSTATUS_RESERVED_Msk = 0x7ffffff0
	// Position of WAKEUP field.
	RTC_ERSTATUS_WAKEUP_Pos = 0x1f
	// Bit mask of WAKEUP field.
	RTC_ERSTATUS_WAKEUP_Msk = 0x80000000
	// Bit WAKEUP.
	RTC_ERSTATUS_WAKEUP = 0x80000000
	// No interrupt/wake-up request is pending
	RTC_ERSTATUS_WAKEUP_NOINTERRUPTWAKEUP = 0x0
	// An interrupt/wake-up request is pending.
	RTC_ERSTATUS_WAKEUP_INTERRUPTWAKEUP = 0x1

	// ERCONTRO: Event Monitor/Recorder Control register. Contains bits that control actions for the event channels as well as for Event Monitor/Recorder setup.
	// Position of INTWAKE_EN0 field.
	RTC_ERCONTRO_INTWAKE_EN0_Pos = 0x0
	// Bit mask of INTWAKE_EN0 field.
	RTC_ERCONTRO_INTWAKE_EN0_Msk = 0x1
	// Bit INTWAKE_EN0.
	RTC_ERCONTRO_INTWAKE_EN0 = 0x1
	// No interrupt or wake-up will be generated by event channel 0.
	RTC_ERCONTRO_INTWAKE_EN0_DISABLED = 0x0
	// An event in channel 0 will trigger an (RTC) interrupt and a wake-up request.
	RTC_ERCONTRO_INTWAKE_EN0_ENABLED = 0x1
	// Position of GPCLEAR_EN0 field.
	RTC_ERCONTRO_GPCLEAR_EN0_Pos = 0x1
	// Bit mask of GPCLEAR_EN0 field.
	RTC_ERCONTRO_GPCLEAR_EN0_Msk = 0x2
	// Bit GPCLEAR_EN0.
	RTC_ERCONTRO_GPCLEAR_EN0 = 0x2
	// Channel 0 has no influence on the general purpose registers.
	RTC_ERCONTRO_GPCLEAR_EN0_DISABLED = 0x0
	// An event in channel 0 will clear the general purpose registers asynchronously.
	RTC_ERCONTRO_GPCLEAR_EN0_ENABLED = 0x1
	// Position of POL0 field.
	RTC_ERCONTRO_POL0_Pos = 0x2
	// Bit mask of POL0 field.
	RTC_ERCONTRO_POL0_Msk = 0x4
	// Bit POL0.
	RTC_ERCONTRO_POL0 = 0x4
	// A channel 0 event is defined as a negative edge on WAKEUP0.
	RTC_ERCONTRO_POL0_NEGATIVE = 0x0
	// A channel 0 event is defined as a positive edge on WAKEUP0.
	RTC_ERCONTRO_POL0_POSITIVE = 0x1
	// Position of EV0_INPUT_EN field.
	RTC_ERCONTRO_EV0_INPUT_EN_Pos = 0x3
	// Bit mask of EV0_INPUT_EN field.
	RTC_ERCONTRO_EV0_INPUT_EN_Msk = 0x8
	// Bit EV0_INPUT_EN.
	RTC_ERCONTRO_EV0_INPUT_EN = 0x8
	// Event 0 input is disabled and forced high internally.
	RTC_ERCONTRO_EV0_INPUT_EN_DISABLED = 0x0
	// Event 0 input is enabled.
	RTC_ERCONTRO_EV0_INPUT_EN_ENABLED = 0x1
	// Position of RESERVED field.
	RTC_ERCONTRO_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RTC_ERCONTRO_RESERVED_Msk = 0x3f0
	// Position of INTWAKE_EN1 field.
	RTC_ERCONTRO_INTWAKE_EN1_Pos = 0xa
	// Bit mask of INTWAKE_EN1 field.
	RTC_ERCONTRO_INTWAKE_EN1_Msk = 0x400
	// Bit INTWAKE_EN1.
	RTC_ERCONTRO_INTWAKE_EN1 = 0x400
	// No interrupt or wake-up will be generated by event channel 1.
	RTC_ERCONTRO_INTWAKE_EN1_DISABLED = 0x0
	// An event in channel 1 will trigger an (RTC) interrupt and a wake-up request.
	RTC_ERCONTRO_INTWAKE_EN1_ENABLED = 0x1
	// Position of GPCLEAR_EN1 field.
	RTC_ERCONTRO_GPCLEAR_EN1_Pos = 0xb
	// Bit mask of GPCLEAR_EN1 field.
	RTC_ERCONTRO_GPCLEAR_EN1_Msk = 0x800
	// Bit GPCLEAR_EN1.
	RTC_ERCONTRO_GPCLEAR_EN1 = 0x800
	// Channel 1 has no influence on the general purpose registers.
	RTC_ERCONTRO_GPCLEAR_EN1_DISABLED = 0x0
	// A n event in channel 1 will clear the general purpose registers asynchronously.
	RTC_ERCONTRO_GPCLEAR_EN1_ENABLED = 0x1
	// Position of POL1 field.
	RTC_ERCONTRO_POL1_Pos = 0xc
	// Bit mask of POL1 field.
	RTC_ERCONTRO_POL1_Msk = 0x1000
	// Bit POL1.
	RTC_ERCONTRO_POL1 = 0x1000
	// A channel 1 event is defined as a negative edge on WAKEUP1.
	RTC_ERCONTRO_POL1_NEGATIVE = 0x0
	// A channel 1 event is defined as a positive edge on WAKEUP1.
	RTC_ERCONTRO_POL1_POSITIVE = 0x1
	// Position of EV1_INPUT_EN field.
	RTC_ERCONTRO_EV1_INPUT_EN_Pos = 0xd
	// Bit mask of EV1_INPUT_EN field.
	RTC_ERCONTRO_EV1_INPUT_EN_Msk = 0x2000
	// Bit EV1_INPUT_EN.
	RTC_ERCONTRO_EV1_INPUT_EN = 0x2000
	// Event 1 input is disabled and forced high internally.
	RTC_ERCONTRO_EV1_INPUT_EN_DISABLED = 0x0
	// Event 1 input is enabled.
	RTC_ERCONTRO_EV1_INPUT_EN_ENABLED = 0x1
	// Position of RESERVED field.
	RTC_ERCONTRO_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	RTC_ERCONTRO_RESERVED_Msk = 0xfc000
	// Position of INTWAKE_EN2 field.
	RTC_ERCONTRO_INTWAKE_EN2_Pos = 0x14
	// Bit mask of INTWAKE_EN2 field.
	RTC_ERCONTRO_INTWAKE_EN2_Msk = 0x100000
	// Bit INTWAKE_EN2.
	RTC_ERCONTRO_INTWAKE_EN2 = 0x100000
	// No interrupt or wake-up will be generated by event channel 2.
	RTC_ERCONTRO_INTWAKE_EN2_DISABLED = 0x0
	// An event in channel 2 will trigger an (RTC) interrupt and a wake-up request.
	RTC_ERCONTRO_INTWAKE_EN2_ENABLED = 0x1
	// Position of GPCLEAR_EN2 field.
	RTC_ERCONTRO_GPCLEAR_EN2_Pos = 0x15
	// Bit mask of GPCLEAR_EN2 field.
	RTC_ERCONTRO_GPCLEAR_EN2_Msk = 0x200000
	// Bit GPCLEAR_EN2.
	RTC_ERCONTRO_GPCLEAR_EN2 = 0x200000
	// Channel 2 has no influence on the general purpose registers.
	RTC_ERCONTRO_GPCLEAR_EN2_DISABLED = 0x0
	// An event in channel 2 will clear the general purpose registers asynchronously.
	RTC_ERCONTRO_GPCLEAR_EN2_ENABLED = 0x1
	// Position of POL2 field.
	RTC_ERCONTRO_POL2_Pos = 0x16
	// Bit mask of POL2 field.
	RTC_ERCONTRO_POL2_Msk = 0x400000
	// Bit POL2.
	RTC_ERCONTRO_POL2 = 0x400000
	// A channel 2 event is defined as a negative edge on WAKEUP2.
	RTC_ERCONTRO_POL2_NEGATIVE = 0x0
	// A channel 2 event is defined as a positive edge on WAKEUP2.
	RTC_ERCONTRO_POL2_POSITIVE = 0x1
	// Position of EV2_INPUT_EN field.
	RTC_ERCONTRO_EV2_INPUT_EN_Pos = 0x17
	// Bit mask of EV2_INPUT_EN field.
	RTC_ERCONTRO_EV2_INPUT_EN_Msk = 0x800000
	// Bit EV2_INPUT_EN.
	RTC_ERCONTRO_EV2_INPUT_EN = 0x800000
	// Event 2 input is disabled and forced high internally.
	RTC_ERCONTRO_EV2_INPUT_EN_DISABLED = 0x0
	// Event 2 input is enabled.
	RTC_ERCONTRO_EV2_INPUT_EN_ENABLED = 0x1
	// Position of RESERVED field.
	RTC_ERCONTRO_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	RTC_ERCONTRO_RESERVED_Msk = 0x3f000000
	// Position of ERMODE field.
	RTC_ERCONTRO_ERMODE_Pos = 0x1e
	// Bit mask of ERMODE field.
	RTC_ERCONTRO_ERMODE_Msk = 0xc0000000
	// Disable Event Monitor/Recorder clocks. Operation of the Event Monitor/Recorder is disabled except for asynchronous clearing of GP registers if selected.
	RTC_ERCONTRO_ERMODE_DISABLE_EVENT_MONITO = 0x0
	// 16 Hz sample clock. Enable Event Monitor/Recorder and select a 16 Hz sample clock for event input edge detection and glitch suppression. Pulses (in either direction) shorter than 62.5 ms to 125 ms will be filtered out.
	RTC_ERCONTRO_ERMODE_16_HZ_SAMPLE_CLOCK = 0x1
	// 64 Hz sample clock. Enable Event Monitor/Recorder and select a 64 Hz sample clock for event input edge detection and glitch suppression. Pulses (in either direction) shorter than 15.6 ms to 31.2 ms will be filtered out.
	RTC_ERCONTRO_ERMODE_64_HZ_SAMPLE_CLOCK = 0x2
	// 1 kHz sample clock. Enable Event Monitor/Recorder and select a 1 kHz sample clock for event input edge detection and glitch suppression. Pulses (in either direction) shorter than 1 ms to 2 ms will be filtered out.
	RTC_ERCONTRO_ERMODE_1_KHZ_SAMPLE_CLOCK = 0x3

	// ERCOUNTERS: Event Monitor/Recorder Counters register. Allows reading the counters associated with the event channels.
	// Position of COUNTER0 field.
	RTC_ERCOUNTERS_COUNTER0_Pos = 0x0
	// Bit mask of COUNTER0 field.
	RTC_ERCOUNTERS_COUNTER0_Msk = 0x7
	// Position of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Msk = 0xf8
	// Position of COUNTER1 field.
	RTC_ERCOUNTERS_COUNTER1_Pos = 0x8
	// Bit mask of COUNTER1 field.
	RTC_ERCOUNTERS_COUNTER1_Msk = 0x700
	// Position of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Msk = 0xf800
	// Position of COUNTER2 field.
	RTC_ERCOUNTERS_COUNTER2_Pos = 0x10
	// Bit mask of COUNTER2 field.
	RTC_ERCOUNTERS_COUNTER2_Msk = 0x70000
	// Position of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Msk = 0xfff80000

	// ERFIRSTSTAMP0: Event Monitor/Recorder First Stamp register for channel 0. Retains the time stamp for the first event on channel 0.
	// Position of SEC field.
	RTC_ERFIRSTSTAMP_SEC_Pos = 0x0
	// Bit mask of SEC field.
	RTC_ERFIRSTSTAMP_SEC_Msk = 0x3f
	// Position of MIN field.
	RTC_ERFIRSTSTAMP_MIN_Pos = 0x6
	// Bit mask of MIN field.
	RTC_ERFIRSTSTAMP_MIN_Msk = 0xfc0
	// Position of HOUR field.
	RTC_ERFIRSTSTAMP_HOUR_Pos = 0xc
	// Bit mask of HOUR field.
	RTC_ERFIRSTSTAMP_HOUR_Msk = 0x1f000
	// Position of DOY field.
	RTC_ERFIRSTSTAMP_DOY_Pos = 0x11
	// Bit mask of DOY field.
	RTC_ERFIRSTSTAMP_DOY_Msk = 0x3fe0000
	// Position of RESERVED field.
	RTC_ERFIRSTSTAMP_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	RTC_ERFIRSTSTAMP_RESERVED_Msk = 0xfc000000

	// ERLASTSTAMP0: Event Monitor/Recorder Last Stamp register for channel 0. Retains the time stamp for the last (i.e. most recent) event on channel 0.
	// Position of SEC field.
	RTC_ERLASTSTAMP_SEC_Pos = 0x0
	// Bit mask of SEC field.
	RTC_ERLASTSTAMP_SEC_Msk = 0x3f
	// Position of MIN field.
	RTC_ERLASTSTAMP_MIN_Pos = 0x6
	// Bit mask of MIN field.
	RTC_ERLASTSTAMP_MIN_Msk = 0xfc0
	// Position of HOUR field.
	RTC_ERLASTSTAMP_HOUR_Pos = 0xc
	// Bit mask of HOUR field.
	RTC_ERLASTSTAMP_HOUR_Msk = 0x1f000
	// Position of DOY field.
	RTC_ERLASTSTAMP_DOY_Pos = 0x11
	// Bit mask of DOY field.
	RTC_ERLASTSTAMP_DOY_Msk = 0x3fe0000
	// Position of RESERVED field.
	RTC_ERLASTSTAMP_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	RTC_ERLASTSTAMP_RESERVED_Msk = 0xfc000000
)

// Bitfields for CGU: Clock Generation Unit (CGU)
const (
	// FREQ_MON: Frequency monitor register
	// Position of RCNT field.
	CGU_FREQ_MON_RCNT_Pos = 0x0
	// Bit mask of RCNT field.
	CGU_FREQ_MON_RCNT_Msk = 0x1ff
	// Position of FCNT field.
	CGU_FREQ_MON_FCNT_Pos = 0x9
	// Bit mask of FCNT field.
	CGU_FREQ_MON_FCNT_Msk = 0x7ffe00
	// Position of MEAS field.
	CGU_FREQ_MON_MEAS_Pos = 0x17
	// Bit mask of MEAS field.
	CGU_FREQ_MON_MEAS_Msk = 0x800000
	// Bit MEAS.
	CGU_FREQ_MON_MEAS = 0x800000
	// RCNT and FCNT disabled
	CGU_FREQ_MON_MEAS_RCNT_AND_FCNT_DISABL = 0x0
	// Frequency counters started
	CGU_FREQ_MON_MEAS_FREQUENCY_COUNTERS_S = 0x1
	// Position of CLK_SEL field.
	CGU_FREQ_MON_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_FREQ_MON_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator (default)
	CGU_FREQ_MON_CLK_SEL_32_KHZ_OSCILLATOR_D = 0x0
	// IRC
	CGU_FREQ_MON_CLK_SEL_IRC = 0x1
	// ENET_RX_CLK
	CGU_FREQ_MON_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_FREQ_MON_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_FREQ_MON_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_FREQ_MON_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0USB
	CGU_FREQ_MON_CLK_SEL_PLL0USB = 0x7
	// PLL0AUDIO
	CGU_FREQ_MON_CLK_SEL_PLL0AUDIO = 0x8
	// PLL1
	CGU_FREQ_MON_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_FREQ_MON_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_FREQ_MON_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_FREQ_MON_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_FREQ_MON_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_FREQ_MON_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_FREQ_MON_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_FREQ_MON_RESERVED_Msk = 0xe0000000

	// XTAL_OSC_CTRL: Crystal oscillator control register
	// Position of ENABLE field.
	CGU_XTAL_OSC_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	CGU_XTAL_OSC_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	CGU_XTAL_OSC_CTRL_ENABLE = 0x1
	// Enable
	CGU_XTAL_OSC_CTRL_ENABLE_ENABLE = 0x0
	// Power-down (default)
	CGU_XTAL_OSC_CTRL_ENABLE_POWER_DOWN = 0x1
	// Position of BYPASS field.
	CGU_XTAL_OSC_CTRL_BYPASS_Pos = 0x1
	// Bit mask of BYPASS field.
	CGU_XTAL_OSC_CTRL_BYPASS_Msk = 0x2
	// Bit BYPASS.
	CGU_XTAL_OSC_CTRL_BYPASS = 0x2
	// Crystal. Operation with crystal connected (default).
	CGU_XTAL_OSC_CTRL_BYPASS_CRYSTAL = 0x0
	// Bypass mode. Use this mode when an external clock source is used instead of a crystal.
	CGU_XTAL_OSC_CTRL_BYPASS_BYPASS_MODE = 0x1
	// Position of HF field.
	CGU_XTAL_OSC_CTRL_HF_Pos = 0x2
	// Bit mask of HF field.
	CGU_XTAL_OSC_CTRL_HF_Msk = 0x4
	// Bit HF.
	CGU_XTAL_OSC_CTRL_HF = 0x4
	// Low. Oscillator low-frequency mode (crystal or external clock source 1 to 20 MHz). Between 15 MHz and 20 MHz, the state of the HF bit is don't care.
	CGU_XTAL_OSC_CTRL_HF_LOW = 0x0
	// High. Oscillator high-frequency mode; crystal or external clock source 15 to 25 MHz. Between 15 MHz and 20 MHz, the state of the HF bit is don't care.
	CGU_XTAL_OSC_CTRL_HF_HIGH = 0x1
	// Position of RESERVED field.
	CGU_XTAL_OSC_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CGU_XTAL_OSC_CTRL_RESERVED_Msk = 0xfffffff8

	// PLL0USB_STAT: PLL0USB status register
	// Position of LOCK field.
	CGU_PLL0USB_STAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	CGU_PLL0USB_STAT_LOCK_Msk = 0x1
	// Bit LOCK.
	CGU_PLL0USB_STAT_LOCK = 0x1
	// Position of FR field.
	CGU_PLL0USB_STAT_FR_Pos = 0x1
	// Bit mask of FR field.
	CGU_PLL0USB_STAT_FR_Msk = 0x2
	// Bit FR.
	CGU_PLL0USB_STAT_FR = 0x2
	// Position of RESERVED field.
	CGU_PLL0USB_STAT_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CGU_PLL0USB_STAT_RESERVED_Msk = 0xfffffffc

	// PLL0USB_CTRL: PLL0USB control register
	// Position of PD field.
	CGU_PLL0USB_CTRL_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_PLL0USB_CTRL_PD_Msk = 0x1
	// Bit PD.
	CGU_PLL0USB_CTRL_PD = 0x1
	// PLL0 enabled
	CGU_PLL0USB_CTRL_PD_PLL0_ENABLED = 0x0
	// PLL0 powered down
	CGU_PLL0USB_CTRL_PD_PLL0_POWERED_DOWN = 0x1
	// Position of BYPASS field.
	CGU_PLL0USB_CTRL_BYPASS_Pos = 0x1
	// Bit mask of BYPASS field.
	CGU_PLL0USB_CTRL_BYPASS_Msk = 0x2
	// Bit BYPASS.
	CGU_PLL0USB_CTRL_BYPASS = 0x2
	// CCO clock sent to post-dividers. Use this in normal operation.
	CGU_PLL0USB_CTRL_BYPASS_CCO_CLOCK_SENT_TO_PO = 0x0
	// PLL0 input clock sent to post-dividers (default).
	CGU_PLL0USB_CTRL_BYPASS_PLL0_INPUT_CLOCK_SEN = 0x1
	// Position of DIRECTI field.
	CGU_PLL0USB_CTRL_DIRECTI_Pos = 0x2
	// Bit mask of DIRECTI field.
	CGU_PLL0USB_CTRL_DIRECTI_Msk = 0x4
	// Bit DIRECTI.
	CGU_PLL0USB_CTRL_DIRECTI = 0x4
	// Position of DIRECTO field.
	CGU_PLL0USB_CTRL_DIRECTO_Pos = 0x3
	// Bit mask of DIRECTO field.
	CGU_PLL0USB_CTRL_DIRECTO_Msk = 0x8
	// Bit DIRECTO.
	CGU_PLL0USB_CTRL_DIRECTO = 0x8
	// Position of CLKEN field.
	CGU_PLL0USB_CTRL_CLKEN_Pos = 0x4
	// Bit mask of CLKEN field.
	CGU_PLL0USB_CTRL_CLKEN_Msk = 0x10
	// Bit CLKEN.
	CGU_PLL0USB_CTRL_CLKEN = 0x10
	// Position of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Msk = 0x20
	// Bit RESERVED.
	CGU_PLL0USB_CTRL_RESERVED = 0x20
	// Position of FRM field.
	CGU_PLL0USB_CTRL_FRM_Pos = 0x6
	// Bit mask of FRM field.
	CGU_PLL0USB_CTRL_FRM_Msk = 0x40
	// Bit FRM.
	CGU_PLL0USB_CTRL_FRM = 0x40
	// Position of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	CGU_PLL0USB_CTRL_RESERVED = 0x80
	// Position of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Msk = 0x100
	// Bit RESERVED.
	CGU_PLL0USB_CTRL_RESERVED = 0x100
	// Position of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Msk = 0x200
	// Bit RESERVED.
	CGU_PLL0USB_CTRL_RESERVED = 0x200
	// Position of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Msk = 0x400
	// Bit RESERVED.
	CGU_PLL0USB_CTRL_RESERVED = 0x400
	// Position of AUTOBLOCK field.
	CGU_PLL0USB_CTRL_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_PLL0USB_CTRL_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_PLL0USB_CTRL_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_PLL0USB_CTRL_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_PLL0USB_CTRL_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_PLL0USB_CTRL_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_PLL0USB_CTRL_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_PLL0USB_CTRL_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_PLL0USB_CTRL_CLK_SEL_IRC = 0x1
	// ENET_RX_CLK
	CGU_PLL0USB_CTRL_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_PLL0USB_CTRL_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_PLL0USB_CTRL_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_PLL0USB_CTRL_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL1
	CGU_PLL0USB_CTRL_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_PLL0USB_CTRL_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_PLL0USB_CTRL_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_PLL0USB_CTRL_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_PLL0USB_CTRL_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_PLL0USB_CTRL_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_PLL0USB_CTRL_RESERVED_Msk = 0xe0000000

	// PLL0USB_MDIV: PLL0USB M-divider register
	// Position of MDEC field.
	CGU_PLL0USB_MDIV_MDEC_Pos = 0x0
	// Bit mask of MDEC field.
	CGU_PLL0USB_MDIV_MDEC_Msk = 0x1ffff
	// Position of SELP field.
	CGU_PLL0USB_MDIV_SELP_Pos = 0x11
	// Bit mask of SELP field.
	CGU_PLL0USB_MDIV_SELP_Msk = 0x3e0000
	// Position of SELI field.
	CGU_PLL0USB_MDIV_SELI_Pos = 0x16
	// Bit mask of SELI field.
	CGU_PLL0USB_MDIV_SELI_Msk = 0xfc00000
	// Position of SELR field.
	CGU_PLL0USB_MDIV_SELR_Pos = 0x1c
	// Bit mask of SELR field.
	CGU_PLL0USB_MDIV_SELR_Msk = 0xf0000000

	// PLL0USB_NP_DIV: PLL0USB N/P-divider register
	// Position of PDEC field.
	CGU_PLL0USB_NP_DIV_PDEC_Pos = 0x0
	// Bit mask of PDEC field.
	CGU_PLL0USB_NP_DIV_PDEC_Msk = 0x7f
	// Position of RESERVED field.
	CGU_PLL0USB_NP_DIV_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CGU_PLL0USB_NP_DIV_RESERVED_Msk = 0xf80
	// Position of NDEC field.
	CGU_PLL0USB_NP_DIV_NDEC_Pos = 0xc
	// Bit mask of NDEC field.
	CGU_PLL0USB_NP_DIV_NDEC_Msk = 0x3ff000
	// Position of RESERVED field.
	CGU_PLL0USB_NP_DIV_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	CGU_PLL0USB_NP_DIV_RESERVED_Msk = 0xffc00000

	// PLL0AUDIO_STAT: PLL0AUDIO status register
	// Position of LOCK field.
	CGU_PLL0AUDIO_STAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	CGU_PLL0AUDIO_STAT_LOCK_Msk = 0x1
	// Bit LOCK.
	CGU_PLL0AUDIO_STAT_LOCK = 0x1
	// Position of FR field.
	CGU_PLL0AUDIO_STAT_FR_Pos = 0x1
	// Bit mask of FR field.
	CGU_PLL0AUDIO_STAT_FR_Msk = 0x2
	// Bit FR.
	CGU_PLL0AUDIO_STAT_FR = 0x2
	// Position of RESERVED field.
	CGU_PLL0AUDIO_STAT_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_STAT_RESERVED_Msk = 0xfffffffc

	// PLL0AUDIO_CTRL: PLL0AUDIO control register
	// Position of PD field.
	CGU_PLL0AUDIO_CTRL_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_PLL0AUDIO_CTRL_PD_Msk = 0x1
	// Bit PD.
	CGU_PLL0AUDIO_CTRL_PD = 0x1
	// PLL0 enabled
	CGU_PLL0AUDIO_CTRL_PD_PLL0_ENABLED = 0x0
	// PLL0 powered down
	CGU_PLL0AUDIO_CTRL_PD_PLL0_POWERED_DOWN = 0x1
	// Position of BYPASS field.
	CGU_PLL0AUDIO_CTRL_BYPASS_Pos = 0x1
	// Bit mask of BYPASS field.
	CGU_PLL0AUDIO_CTRL_BYPASS_Msk = 0x2
	// Bit BYPASS.
	CGU_PLL0AUDIO_CTRL_BYPASS = 0x2
	// CCO clock sent to post-dividers. Use this in normal operation.
	CGU_PLL0AUDIO_CTRL_BYPASS_CCO_CLOCK_SENT_TO_PO = 0x0
	// PLL0 input clock sent to post-dividers (default).
	CGU_PLL0AUDIO_CTRL_BYPASS_PLL0_INPUT_CLOCK_SEN = 0x1
	// Position of DIRECTI field.
	CGU_PLL0AUDIO_CTRL_DIRECTI_Pos = 0x2
	// Bit mask of DIRECTI field.
	CGU_PLL0AUDIO_CTRL_DIRECTI_Msk = 0x4
	// Bit DIRECTI.
	CGU_PLL0AUDIO_CTRL_DIRECTI = 0x4
	// Position of DIRECTO field.
	CGU_PLL0AUDIO_CTRL_DIRECTO_Pos = 0x3
	// Bit mask of DIRECTO field.
	CGU_PLL0AUDIO_CTRL_DIRECTO_Msk = 0x8
	// Bit DIRECTO.
	CGU_PLL0AUDIO_CTRL_DIRECTO = 0x8
	// Position of CLKEN field.
	CGU_PLL0AUDIO_CTRL_CLKEN_Pos = 0x4
	// Bit mask of CLKEN field.
	CGU_PLL0AUDIO_CTRL_CLKEN_Msk = 0x10
	// Bit CLKEN.
	CGU_PLL0AUDIO_CTRL_CLKEN = 0x10
	// Position of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Msk = 0x20
	// Bit RESERVED.
	CGU_PLL0AUDIO_CTRL_RESERVED = 0x20
	// Position of FRM field.
	CGU_PLL0AUDIO_CTRL_FRM_Pos = 0x6
	// Bit mask of FRM field.
	CGU_PLL0AUDIO_CTRL_FRM_Msk = 0x40
	// Bit FRM.
	CGU_PLL0AUDIO_CTRL_FRM = 0x40
	// Position of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	CGU_PLL0AUDIO_CTRL_RESERVED = 0x80
	// Position of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Msk = 0x100
	// Bit RESERVED.
	CGU_PLL0AUDIO_CTRL_RESERVED = 0x100
	// Position of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Msk = 0x200
	// Bit RESERVED.
	CGU_PLL0AUDIO_CTRL_RESERVED = 0x200
	// Position of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Msk = 0x400
	// Bit RESERVED.
	CGU_PLL0AUDIO_CTRL_RESERVED = 0x400
	// Position of AUTOBLOCK field.
	CGU_PLL0AUDIO_CTRL_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_PLL0AUDIO_CTRL_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_PLL0AUDIO_CTRL_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_PLL0AUDIO_CTRL_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_PLL0AUDIO_CTRL_AUTOBLOCK_ENABLED = 0x1
	// Position of PLLFRACT_REQ field.
	CGU_PLL0AUDIO_CTRL_PLLFRACT_REQ_Pos = 0xc
	// Bit mask of PLLFRACT_REQ field.
	CGU_PLL0AUDIO_CTRL_PLLFRACT_REQ_Msk = 0x1000
	// Bit PLLFRACT_REQ.
	CGU_PLL0AUDIO_CTRL_PLLFRACT_REQ = 0x1000
	// Position of SEL_EXT field.
	CGU_PLL0AUDIO_CTRL_SEL_EXT_Pos = 0xd
	// Bit mask of SEL_EXT field.
	CGU_PLL0AUDIO_CTRL_SEL_EXT_Msk = 0x2000
	// Bit SEL_EXT.
	CGU_PLL0AUDIO_CTRL_SEL_EXT = 0x2000
	// FRAC Enabled. Enable fractional divider.
	CGU_PLL0AUDIO_CTRL_SEL_EXT_FRAC_ENABLED = 0x0
	// MDEC enabled. Fractional divider not used.
	CGU_PLL0AUDIO_CTRL_SEL_EXT_MDEC_ENABLED = 0x1
	// Position of MOD_PD field.
	CGU_PLL0AUDIO_CTRL_MOD_PD_Pos = 0xe
	// Bit mask of MOD_PD field.
	CGU_PLL0AUDIO_CTRL_MOD_PD_Msk = 0x4000
	// Bit MOD_PD.
	CGU_PLL0AUDIO_CTRL_MOD_PD = 0x4000
	// Enabled. Sigma-Delta modulator enabled
	CGU_PLL0AUDIO_CTRL_MOD_PD_ENABLED = 0x0
	// Disabled. Sigma-Delta modulator powered down
	CGU_PLL0AUDIO_CTRL_MOD_PD_DISABLED = 0x1
	// Position of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Msk = 0xff8000
	// Position of CLK_SEL field.
	CGU_PLL0AUDIO_CTRL_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_PLL0AUDIO_CTRL_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_PLL0AUDIO_CTRL_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_PLL0AUDIO_CTRL_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_PLL0AUDIO_CTRL_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_PLL0AUDIO_CTRL_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_PLL0AUDIO_CTRL_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_PLL0AUDIO_CTRL_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL1
	CGU_PLL0AUDIO_CTRL_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_PLL0AUDIO_CTRL_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_PLL0AUDIO_CTRL_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_PLL0AUDIO_CTRL_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_PLL0AUDIO_CTRL_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_PLL0AUDIO_CTRL_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_CTRL_RESERVED_Msk = 0xe0000000

	// PLL0AUDIO_MDIV: PLL0AUDIO M-divider register
	// Position of MDEC field.
	CGU_PLL0AUDIO_MDIV_MDEC_Pos = 0x0
	// Bit mask of MDEC field.
	CGU_PLL0AUDIO_MDIV_MDEC_Msk = 0x1ffff
	// Position of RESERVED field.
	CGU_PLL0AUDIO_MDIV_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_MDIV_RESERVED_Msk = 0xfffe0000

	// PLL0AUDIO_NP_DIV: PLL0AUDIO N/P-divider register
	// Position of PDEC field.
	CGU_PLL0AUDIO_NP_DIV_PDEC_Pos = 0x0
	// Bit mask of PDEC field.
	CGU_PLL0AUDIO_NP_DIV_PDEC_Msk = 0x7f
	// Position of RESERVED field.
	CGU_PLL0AUDIO_NP_DIV_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_NP_DIV_RESERVED_Msk = 0xf80
	// Position of NDEC field.
	CGU_PLL0AUDIO_NP_DIV_NDEC_Pos = 0xc
	// Bit mask of NDEC field.
	CGU_PLL0AUDIO_NP_DIV_NDEC_Msk = 0x3ff000
	// Position of RESERVED field.
	CGU_PLL0AUDIO_NP_DIV_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_NP_DIV_RESERVED_Msk = 0xffc00000

	// PLL0AUDIO_FRAC: PLL0AUDIO fractional divider register
	// Position of PLLFRACT_CTRL field.
	CGU_PLL0AUDIO_FRAC_PLLFRACT_CTRL_Pos = 0x0
	// Bit mask of PLLFRACT_CTRL field.
	CGU_PLL0AUDIO_FRAC_PLLFRACT_CTRL_Msk = 0x3fffff
	// Position of RESERVED field.
	CGU_PLL0AUDIO_FRAC_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	CGU_PLL0AUDIO_FRAC_RESERVED_Msk = 0xffc00000

	// PLL1_STAT: PLL1 status register
	// Position of LOCK field.
	CGU_PLL1_STAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	CGU_PLL1_STAT_LOCK_Msk = 0x1
	// Bit LOCK.
	CGU_PLL1_STAT_LOCK = 0x1
	// Position of RESERVED field.
	CGU_PLL1_STAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_PLL1_STAT_RESERVED_Msk = 0xfffffffe

	// PLL1_CTRL: PLL1 control register
	// Position of PD field.
	CGU_PLL1_CTRL_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_PLL1_CTRL_PD_Msk = 0x1
	// Bit PD.
	CGU_PLL1_CTRL_PD = 0x1
	// PLL1 enabled
	CGU_PLL1_CTRL_PD_PLL1_ENABLED = 0x0
	// PLL1 powered down
	CGU_PLL1_CTRL_PD_PLL1_POWERED_DOWN = 0x1
	// Position of BYPASS field.
	CGU_PLL1_CTRL_BYPASS_Pos = 0x1
	// Bit mask of BYPASS field.
	CGU_PLL1_CTRL_BYPASS_Msk = 0x2
	// Bit BYPASS.
	CGU_PLL1_CTRL_BYPASS = 0x2
	// Normal. CCO clock sent to post-dividers. Use for normal operation.
	CGU_PLL1_CTRL_BYPASS_NORMAL = 0x0
	// Input clock. PLL1 input clock sent to post-dividers (default).
	CGU_PLL1_CTRL_BYPASS_INPUT_CLOCK = 0x1
	// Position of RESERVED field.
	CGU_PLL1_CTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CGU_PLL1_CTRL_RESERVED_Msk = 0x4
	// Bit RESERVED.
	CGU_PLL1_CTRL_RESERVED = 0x4
	// Position of RESERVED field.
	CGU_PLL1_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CGU_PLL1_CTRL_RESERVED_Msk = 0x38
	// Position of FBSEL field.
	CGU_PLL1_CTRL_FBSEL_Pos = 0x6
	// Bit mask of FBSEL field.
	CGU_PLL1_CTRL_FBSEL_Msk = 0x40
	// Bit FBSEL.
	CGU_PLL1_CTRL_FBSEL = 0x40
	// CCO out. CCO output is used as feedback divider input clock.
	CGU_PLL1_CTRL_FBSEL_CCO_OUT = 0x0
	// PLL out. PLL output clock (clkout) is used as feedback divider input clock. Use for normal operation.
	CGU_PLL1_CTRL_FBSEL_PLL_OUT = 0x1
	// Position of DIRECT field.
	CGU_PLL1_CTRL_DIRECT_Pos = 0x7
	// Bit mask of DIRECT field.
	CGU_PLL1_CTRL_DIRECT_Msk = 0x80
	// Bit DIRECT.
	CGU_PLL1_CTRL_DIRECT = 0x80
	// Disabled
	CGU_PLL1_CTRL_DIRECT_DISABLED = 0x0
	// Enabled
	CGU_PLL1_CTRL_DIRECT_ENABLED = 0x1
	// Position of PSEL field.
	CGU_PLL1_CTRL_PSEL_Pos = 0x8
	// Bit mask of PSEL field.
	CGU_PLL1_CTRL_PSEL_Msk = 0x300
	// 1
	CGU_PLL1_CTRL_PSEL_1 = 0x0
	// 2 (default)
	CGU_PLL1_CTRL_PSEL_PEQ2 = 0x1
	// 4
	CGU_PLL1_CTRL_PSEL_PEQ4 = 0x2
	// 8
	CGU_PLL1_CTRL_PSEL_8 = 0x3
	// Position of RESERVED field.
	CGU_PLL1_CTRL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	CGU_PLL1_CTRL_RESERVED_Msk = 0x400
	// Bit RESERVED.
	CGU_PLL1_CTRL_RESERVED = 0x400
	// Position of AUTOBLOCK field.
	CGU_PLL1_CTRL_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_PLL1_CTRL_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_PLL1_CTRL_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_PLL1_CTRL_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_PLL1_CTRL_AUTOBLOCK_ENABLED = 0x1
	// Position of NSEL field.
	CGU_PLL1_CTRL_NSEL_Pos = 0xc
	// Bit mask of NSEL field.
	CGU_PLL1_CTRL_NSEL_Msk = 0x3000
	// 1
	CGU_PLL1_CTRL_NSEL_1 = 0x0
	// 2
	CGU_PLL1_CTRL_NSEL_NEQ2 = 0x1
	// 3 (default)
	CGU_PLL1_CTRL_NSEL_NEQ3 = 0x2
	// 4
	CGU_PLL1_CTRL_NSEL_4 = 0x3
	// Position of RESERVED field.
	CGU_PLL1_CTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	CGU_PLL1_CTRL_RESERVED_Msk = 0xc000
	// Position of MSEL field.
	CGU_PLL1_CTRL_MSEL_Pos = 0x10
	// Bit mask of MSEL field.
	CGU_PLL1_CTRL_MSEL_Msk = 0xff0000
	// Position of CLK_SEL field.
	CGU_PLL1_CTRL_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_PLL1_CTRL_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_PLL1_CTRL_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_PLL1_CTRL_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_PLL1_CTRL_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_PLL1_CTRL_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_PLL1_CTRL_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_PLL1_CTRL_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0USB
	CGU_PLL1_CTRL_CLK_SEL_PLL0USB = 0x7
	// PLL0AUDIO
	CGU_PLL1_CTRL_CLK_SEL_PLL0AUDIO = 0x8
	// IDIVA
	CGU_PLL1_CTRL_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_PLL1_CTRL_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_PLL1_CTRL_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_PLL1_CTRL_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_PLL1_CTRL_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_PLL1_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_PLL1_CTRL_RESERVED_Msk = 0xe0000000

	// IDIVA_CTRL: Integer divider A control register
	// Position of PD field.
	CGU_IDIVA_CTRL_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_IDIVA_CTRL_PD_Msk = 0x1
	// Bit PD.
	CGU_IDIVA_CTRL_PD = 0x1
	// Enabled. IDIVA enabled (default)
	CGU_IDIVA_CTRL_PD_ENABLED = 0x0
	// Power-down
	CGU_IDIVA_CTRL_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_IDIVA_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_IDIVA_CTRL_RESERVED_Msk = 0x2
	// Bit RESERVED.
	CGU_IDIVA_CTRL_RESERVED = 0x2
	// Position of IDIV field.
	CGU_IDIVA_CTRL_IDIV_Pos = 0x2
	// Bit mask of IDIV field.
	CGU_IDIVA_CTRL_IDIV_Msk = 0xc
	// 1 (default)
	CGU_IDIVA_CTRL_IDIV_DIV1 = 0x0
	// 2
	CGU_IDIVA_CTRL_IDIV_DIV2 = 0x1
	// 3
	CGU_IDIVA_CTRL_IDIV_DIV3 = 0x2
	// 4
	CGU_IDIVA_CTRL_IDIV_DIV4 = 0x3
	// Position of RESERVED field.
	CGU_IDIVA_CTRL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CGU_IDIVA_CTRL_RESERVED_Msk = 0x7f0
	// Position of AUTOBLOCK field.
	CGU_IDIVA_CTRL_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_IDIVA_CTRL_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_IDIVA_CTRL_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_IDIVA_CTRL_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_IDIVA_CTRL_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_IDIVA_CTRL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_IDIVA_CTRL_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_IDIVA_CTRL_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_IDIVA_CTRL_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_IDIVA_CTRL_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_IDIVA_CTRL_CLK_SEL_IRC = 0x1
	// ENET_RX_CLK
	CGU_IDIVA_CTRL_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_IDIVA_CTRL_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_IDIVA_CTRL_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_IDIVA_CTRL_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0USB
	CGU_IDIVA_CTRL_CLK_SEL_PLL0USB = 0x7
	// PLL0AUDIO
	CGU_IDIVA_CTRL_CLK_SEL_PLL0AUDIO = 0x8
	// PLL1
	CGU_IDIVA_CTRL_CLK_SEL_PLL1 = 0x9
	// Position of RESERVED field.
	CGU_IDIVA_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_IDIVA_CTRL_RESERVED_Msk = 0xe0000000

	// IDIVB_CTRL: Integer divider B control register
	// Position of PD field.
	CGU_IDIVB_CTRL_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_IDIVB_CTRL_PD_Msk = 0x1
	// Bit PD.
	CGU_IDIVB_CTRL_PD = 0x1
	// Enabled. IDIV enabled (default)
	CGU_IDIVB_CTRL_PD_ENABLED = 0x0
	// Power-down
	CGU_IDIVB_CTRL_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_IDIVB_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_IDIVB_CTRL_RESERVED_Msk = 0x2
	// Bit RESERVED.
	CGU_IDIVB_CTRL_RESERVED = 0x2
	// Position of IDIV field.
	CGU_IDIVB_CTRL_IDIV_Pos = 0x2
	// Bit mask of IDIV field.
	CGU_IDIVB_CTRL_IDIV_Msk = 0x3c
	// Position of RESERVED field.
	CGU_IDIVB_CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CGU_IDIVB_CTRL_RESERVED_Msk = 0x7c0
	// Position of AUTOBLOCK field.
	CGU_IDIVB_CTRL_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_IDIVB_CTRL_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_IDIVB_CTRL_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_IDIVB_CTRL_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_IDIVB_CTRL_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_IDIVB_CTRL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_IDIVB_CTRL_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_IDIVB_CTRL_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_IDIVB_CTRL_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_IDIVB_CTRL_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_IDIVB_CTRL_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_IDIVB_CTRL_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_IDIVB_CTRL_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_IDIVB_CTRL_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_IDIVB_CTRL_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0AUDIO
	CGU_IDIVB_CTRL_CLK_SEL_PLL0AUDIO = 0x8
	// PLL1
	CGU_IDIVB_CTRL_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_IDIVB_CTRL_CLK_SEL_IDIVA = 0xc
	// Position of RESERVED field.
	CGU_IDIVB_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_IDIVB_CTRL_RESERVED_Msk = 0xe0000000

	// IDIVC_CTRL: Integer divider C control register
	// Position of PD field.
	CGU_IDIVC_CTRL_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_IDIVC_CTRL_PD_Msk = 0x1
	// Bit PD.
	CGU_IDIVC_CTRL_PD = 0x1
	// Enabled. IDIV enabled (default)
	CGU_IDIVC_CTRL_PD_ENABLED = 0x0
	// Power-down
	CGU_IDIVC_CTRL_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_IDIVC_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_IDIVC_CTRL_RESERVED_Msk = 0x2
	// Bit RESERVED.
	CGU_IDIVC_CTRL_RESERVED = 0x2
	// Position of IDIV field.
	CGU_IDIVC_CTRL_IDIV_Pos = 0x2
	// Bit mask of IDIV field.
	CGU_IDIVC_CTRL_IDIV_Msk = 0x3c
	// Position of RESERVED field.
	CGU_IDIVC_CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CGU_IDIVC_CTRL_RESERVED_Msk = 0x7c0
	// Position of AUTOBLOCK field.
	CGU_IDIVC_CTRL_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_IDIVC_CTRL_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_IDIVC_CTRL_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_IDIVC_CTRL_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_IDIVC_CTRL_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_IDIVC_CTRL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_IDIVC_CTRL_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_IDIVC_CTRL_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_IDIVC_CTRL_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_IDIVC_CTRL_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_IDIVC_CTRL_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_IDIVC_CTRL_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_IDIVC_CTRL_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_IDIVC_CTRL_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_IDIVC_CTRL_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0AUDIO
	CGU_IDIVC_CTRL_CLK_SEL_PLL0AUDIO = 0x8
	// PLL1
	CGU_IDIVC_CTRL_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_IDIVC_CTRL_CLK_SEL_IDIVA = 0xc
	// Position of RESERVED field.
	CGU_IDIVC_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_IDIVC_CTRL_RESERVED_Msk = 0xe0000000

	// IDIVD_CTRL: Integer divider D control register
	// Position of PD field.
	CGU_IDIVD_CTRL_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_IDIVD_CTRL_PD_Msk = 0x1
	// Bit PD.
	CGU_IDIVD_CTRL_PD = 0x1
	// Enabled. IDIV enabled (default)
	CGU_IDIVD_CTRL_PD_ENABLED = 0x0
	// Power-down
	CGU_IDIVD_CTRL_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_IDIVD_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_IDIVD_CTRL_RESERVED_Msk = 0x2
	// Bit RESERVED.
	CGU_IDIVD_CTRL_RESERVED = 0x2
	// Position of IDIV field.
	CGU_IDIVD_CTRL_IDIV_Pos = 0x2
	// Bit mask of IDIV field.
	CGU_IDIVD_CTRL_IDIV_Msk = 0x3c
	// Position of RESERVED field.
	CGU_IDIVD_CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CGU_IDIVD_CTRL_RESERVED_Msk = 0x7c0
	// Position of AUTOBLOCK field.
	CGU_IDIVD_CTRL_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_IDIVD_CTRL_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_IDIVD_CTRL_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_IDIVD_CTRL_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_IDIVD_CTRL_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_IDIVD_CTRL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_IDIVD_CTRL_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_IDIVD_CTRL_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_IDIVD_CTRL_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_IDIVD_CTRL_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_IDIVD_CTRL_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_IDIVD_CTRL_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_IDIVD_CTRL_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_IDIVD_CTRL_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_IDIVD_CTRL_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0AUDIO
	CGU_IDIVD_CTRL_CLK_SEL_PLL0AUDIO = 0x8
	// PLL1
	CGU_IDIVD_CTRL_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_IDIVD_CTRL_CLK_SEL_IDIVA = 0xc
	// Position of RESERVED field.
	CGU_IDIVD_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_IDIVD_CTRL_RESERVED_Msk = 0xe0000000

	// IDIVE_CTRL: Integer divider E control register
	// Position of PD field.
	CGU_IDIVE_CTRL_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_IDIVE_CTRL_PD_Msk = 0x1
	// Bit PD.
	CGU_IDIVE_CTRL_PD = 0x1
	// Enabled. IDIV enabled (default)
	CGU_IDIVE_CTRL_PD_ENABLED = 0x0
	// Power-down
	CGU_IDIVE_CTRL_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_IDIVE_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_IDIVE_CTRL_RESERVED_Msk = 0x2
	// Bit RESERVED.
	CGU_IDIVE_CTRL_RESERVED = 0x2
	// Position of IDIV field.
	CGU_IDIVE_CTRL_IDIV_Pos = 0x2
	// Bit mask of IDIV field.
	CGU_IDIVE_CTRL_IDIV_Msk = 0x3fc
	// Position of RESERVED field.
	CGU_IDIVE_CTRL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	CGU_IDIVE_CTRL_RESERVED_Msk = 0x400
	// Bit RESERVED.
	CGU_IDIVE_CTRL_RESERVED = 0x400
	// Position of AUTOBLOCK field.
	CGU_IDIVE_CTRL_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_IDIVE_CTRL_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_IDIVE_CTRL_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_IDIVE_CTRL_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_IDIVE_CTRL_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_IDIVE_CTRL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_IDIVE_CTRL_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_IDIVE_CTRL_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_IDIVE_CTRL_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_IDIVE_CTRL_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_IDIVE_CTRL_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_IDIVE_CTRL_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_IDIVE_CTRL_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_IDIVE_CTRL_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_IDIVE_CTRL_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0AUDIO
	CGU_IDIVE_CTRL_CLK_SEL_PLL0AUDIO = 0x8
	// PLL1
	CGU_IDIVE_CTRL_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_IDIVE_CTRL_CLK_SEL_IDIVA = 0xc
	// Position of RESERVED field.
	CGU_IDIVE_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_IDIVE_CTRL_RESERVED_Msk = 0xe0000000

	// BASE_SAFE_CLK: Output stage 0 control register for base clock BASE_SAFE_CLK
	// Position of PD field.
	CGU_BASE_SAFE_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_SAFE_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_SAFE_CLK_PD = 0x1
	// Enabled. Output stage enabled (default)
	CGU_BASE_SAFE_CLK_PD_ENABLED = 0x0
	// Power-down
	CGU_BASE_SAFE_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_SAFE_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_SAFE_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_SAFE_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_SAFE_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_SAFE_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_SAFE_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_SAFE_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_SAFE_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_SAFE_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_SAFE_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_SAFE_CLK_CLK_SEL_Msk = 0x1f000000
	// IRC (default)
	CGU_BASE_SAFE_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// Position of RESERVED field.
	CGU_BASE_SAFE_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_SAFE_CLK_RESERVED_Msk = 0xe0000000

	// BASE_USB0_CLK: Output stage 1 control register for base clock BASE_USB0_CLK
	// Position of PD field.
	CGU_BASE_USB0_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_USB0_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_USB0_CLK_PD = 0x1
	// Enabled. Output stage enabled (default)
	CGU_BASE_USB0_CLK_PD_ENABLED = 0x0
	// Power-down
	CGU_BASE_USB0_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_USB0_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_USB0_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_USB0_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_USB0_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_USB0_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_USB0_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_USB0_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_USB0_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_USB0_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_USB0_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_USB0_CLK_CLK_SEL_Msk = 0x1f000000
	// PLL0USB (default)
	CGU_BASE_USB0_CLK_CLK_SEL_PLL0USB = 0x7
	// Position of RESERVED field.
	CGU_BASE_USB0_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_USB0_CLK_RESERVED_Msk = 0xe0000000

	// BASE_PERIPH_CLK: Output stage 2 control register for base clock BASE_PERIPH_CLK
	// Position of PD field.
	CGU_BASE_PERIPH_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_PERIPH_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_PERIPH_CLK_PD = 0x1
	// Enabled. Output stage enabled (default)
	CGU_BASE_PERIPH_CLK_PD_ENABLED = 0x0
	// Power-down
	CGU_BASE_PERIPH_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_PERIPH_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_PERIPH_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_PERIPH_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_PERIPH_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_PERIPH_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_PERIPH_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_PERIPH_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_PERIPH_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_PERIPH_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_PERIPH_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_PERIPH_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_PERIPH_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_PERIPH_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_PERIPH_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_PERIPH_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_PERIPH_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_PERIPH_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0AUDIO
	CGU_BASE_PERIPH_CLK_CLK_SEL_PLL0AUDIO = 0x8
	// PLL1
	CGU_BASE_PERIPH_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_PERIPH_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_PERIPH_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_PERIPH_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_PERIPH_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_PERIPH_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_PERIPH_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_PERIPH_CLK_RESERVED_Msk = 0xe0000000

	// BASE_USB1_CLK: Output stage 3 control register for base clock BASE_USB1_CLK
	// Position of PD field.
	CGU_BASE_USB1_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_USB1_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_USB1_CLK_PD = 0x1
	// Enabled. Output stage enabled (default)
	CGU_BASE_USB1_CLK_PD_ENABLED = 0x0
	// Power-down
	CGU_BASE_USB1_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_USB1_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_USB1_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_USB1_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_USB1_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_USB1_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_USB1_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_USB1_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_USB1_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_USB1_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_USB1_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_USB1_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_USB1_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_USB1_CLK_CLK_SEL_IRC = 0x1
	// ENET_RX_CLK
	CGU_BASE_USB1_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_USB1_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_USB1_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_USB1_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0USB
	CGU_BASE_USB1_CLK_CLK_SEL_PLL0USB = 0x7
	// PLL0AUDIO
	CGU_BASE_USB1_CLK_CLK_SEL_PLL0AUDIO = 0x8
	// PLL1
	CGU_BASE_USB1_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_USB1_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_USB1_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_USB1_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_USB1_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_USB1_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_USB1_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_USB1_CLK_RESERVED_Msk = 0xe0000000

	// BASE_M3_CLK: Output stage BASE_M3_CLK control register
	// Position of PD field.
	CGU_BASE_M3_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_M3_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_M3_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_M3_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_M3_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_M3_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_M3_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_M3_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_M3_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_M3_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_M3_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_M3_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_M3_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_M3_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_M3_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_M3_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_M3_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_M3_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_M3_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_M3_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_M3_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_M3_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_M3_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_M3_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_M3_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_M3_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_M3_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_M3_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_M3_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_M3_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_M3_CLK_RESERVED_Msk = 0xe0000000

	// BASE_SPIFI_CLK: Output stage BASE_SPIFI_CLK control register
	// Position of PD field.
	CGU_BASE_SPIFI_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_SPIFI_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_SPIFI_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_SPIFI_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_SPIFI_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_SPIFI_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_SPIFI_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_SPIFI_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_SPIFI_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_SPIFI_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_SPIFI_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_SPIFI_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_SPIFI_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_SPIFI_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_SPIFI_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_SPIFI_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_SPIFI_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_SPIFI_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_SPIFI_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_SPIFI_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_SPIFI_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_SPIFI_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_SPIFI_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_SPIFI_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_SPIFI_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_SPIFI_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_SPIFI_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_SPIFI_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_SPIFI_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_SPIFI_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_SPIFI_CLK_RESERVED_Msk = 0xe0000000

	// BASE_PHY_RX_CLK: Output stage BASE_PHY_RX_CLK control register
	// Position of PD field.
	CGU_BASE_PHY_RX_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_PHY_RX_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_PHY_RX_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_PHY_RX_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_PHY_RX_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_PHY_RX_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_PHY_RX_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_PHY_RX_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_PHY_RX_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_PHY_RX_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_PHY_RX_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_PHY_RX_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_PHY_RX_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_PHY_RX_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_PHY_RX_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_PHY_RX_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_PHY_RX_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_PHY_RX_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_PHY_RX_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_PHY_RX_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_PHY_RX_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_PHY_RX_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_PHY_RX_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_PHY_RX_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_PHY_RX_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_PHY_RX_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_PHY_RX_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_PHY_RX_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_PHY_RX_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_PHY_RX_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_PHY_RX_CLK_RESERVED_Msk = 0xe0000000

	// BASE_PHY_TX_CLK: Output stage BASE_PHY_TX_CLK control register
	// Position of PD field.
	CGU_BASE_PHY_TX_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_PHY_TX_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_PHY_TX_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_PHY_TX_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_PHY_TX_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_PHY_TX_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_PHY_TX_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_PHY_TX_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_PHY_TX_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_PHY_TX_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_PHY_TX_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_PHY_TX_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_PHY_TX_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_PHY_TX_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_PHY_TX_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_PHY_TX_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_PHY_TX_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_PHY_TX_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_PHY_TX_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_PHY_TX_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_PHY_TX_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_PHY_TX_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_PHY_TX_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_PHY_TX_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_PHY_TX_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_PHY_TX_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_PHY_TX_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_PHY_TX_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_PHY_TX_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_PHY_TX_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_PHY_TX_CLK_RESERVED_Msk = 0xe0000000

	// BASE_APB1_CLK: Output stage BASE_APB1_CLK control register
	// Position of PD field.
	CGU_BASE_APB1_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_APB1_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_APB1_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_APB1_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_APB1_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_APB1_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_APB1_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_APB1_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_APB1_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_APB1_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_APB1_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_APB1_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_APB1_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_APB1_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_APB1_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_APB1_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_APB1_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_APB1_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_APB1_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_APB1_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_APB1_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_APB1_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_APB1_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_APB1_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_APB1_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_APB1_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_APB1_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_APB1_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_APB1_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_APB1_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_APB1_CLK_RESERVED_Msk = 0xe0000000

	// BASE_APB3_CLK: Output stage BASE_APB3_CLK control register
	// Position of PD field.
	CGU_BASE_APB3_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_APB3_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_APB3_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_APB3_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_APB3_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_APB3_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_APB3_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_APB3_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_APB3_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_APB3_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_APB3_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_APB3_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_APB3_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_APB3_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_APB3_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_APB3_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_APB3_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_APB3_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_APB3_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_APB3_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_APB3_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_APB3_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_APB3_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_APB3_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_APB3_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_APB3_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_APB3_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_APB3_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_APB3_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_APB3_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_APB3_CLK_RESERVED_Msk = 0xe0000000

	// BASE_LCD_CLK: Output stage BASE_LCD_CLK control register
	// Position of PD field.
	CGU_BASE_LCD_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_LCD_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_LCD_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_LCD_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_LCD_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_LCD_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_LCD_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_LCD_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_LCD_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_LCD_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_LCD_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_LCD_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_LCD_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_LCD_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_LCD_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_LCD_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_LCD_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_LCD_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_LCD_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_LCD_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_LCD_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_LCD_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_LCD_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_LCD_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_LCD_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_LCD_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_LCD_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_LCD_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_LCD_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_LCD_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_LCD_CLK_RESERVED_Msk = 0xe0000000

	// BASE_SDIO_CLK: Output stage BASE_SDIO_CLK control register
	// Position of PD field.
	CGU_BASE_SDIO_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_SDIO_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_SDIO_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_SDIO_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_SDIO_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_SDIO_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_SDIO_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_SDIO_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_SDIO_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_SDIO_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_SDIO_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_SDIO_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_SDIO_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_SDIO_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_SDIO_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_SDIO_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_SDIO_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_SDIO_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_SDIO_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_SDIO_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_SDIO_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_SDIO_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_SDIO_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_SDIO_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_SDIO_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_SDIO_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_SDIO_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_SDIO_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_SDIO_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_SDIO_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_SDIO_CLK_RESERVED_Msk = 0xe0000000

	// BASE_SSP0_CLK: Output stage BASE_SSP0_CLK control register
	// Position of PD field.
	CGU_BASE_SSP0_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_SSP0_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_SSP0_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_SSP0_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_SSP0_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_SSP0_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_SSP0_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_SSP0_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_SSP0_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_SSP0_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_SSP0_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_SSP0_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_SSP0_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_SSP0_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_SSP0_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_SSP0_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_SSP0_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_SSP0_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_SSP0_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_SSP0_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_SSP0_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_SSP0_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_SSP0_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_SSP0_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_SSP0_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_SSP0_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_SSP0_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_SSP0_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_SSP0_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_SSP0_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_SSP0_CLK_RESERVED_Msk = 0xe0000000

	// BASE_SSP1_CLK: Output stage BASE_SSP1_CLK control register
	// Position of PD field.
	CGU_BASE_SSP1_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_SSP1_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_SSP1_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_SSP1_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_SSP1_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_SSP1_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_SSP1_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_SSP1_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_SSP1_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_SSP1_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_SSP1_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_SSP1_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_SSP1_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_SSP1_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_SSP1_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_SSP1_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_SSP1_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_SSP1_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_SSP1_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_SSP1_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_SSP1_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_SSP1_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_SSP1_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_SSP1_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_SSP1_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_SSP1_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_SSP1_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_SSP1_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_SSP1_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_SSP1_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_SSP1_CLK_RESERVED_Msk = 0xe0000000

	// BASE_UART0_CLK: Output stage BASE_UART0_CLK control register
	// Position of PD field.
	CGU_BASE_UART0_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_UART0_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_UART0_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_UART0_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_UART0_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_UART0_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_UART0_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_UART0_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_UART0_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_UART0_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_UART0_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_UART0_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_UART0_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_UART0_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_UART0_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_UART0_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_UART0_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_UART0_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_UART0_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_UART0_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_UART0_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_UART0_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_UART0_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_UART0_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_UART0_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_UART0_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_UART0_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_UART0_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_UART0_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_UART0_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_UART0_CLK_RESERVED_Msk = 0xe0000000

	// BASE_UART1_CLK: Output stage BASE_UART1_CLK control register
	// Position of PD field.
	CGU_BASE_UART1_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_UART1_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_UART1_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_UART1_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_UART1_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_UART1_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_UART1_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_UART1_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_UART1_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_UART1_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_UART1_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_UART1_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_UART1_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_UART1_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_UART1_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_UART1_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_UART1_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_UART1_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_UART1_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_UART1_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_UART1_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_UART1_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_UART1_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_UART1_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_UART1_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_UART1_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_UART1_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_UART1_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_UART1_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_UART1_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_UART1_CLK_RESERVED_Msk = 0xe0000000

	// BASE_UART2_CLK: Output stage BASE_UART2_CLK control register
	// Position of PD field.
	CGU_BASE_UART2_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_UART2_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_UART2_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_UART2_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_UART2_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_UART2_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_UART2_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_UART2_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_UART2_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_UART2_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_UART2_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_UART2_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_UART2_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_UART2_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_UART2_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_UART2_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_UART2_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_UART2_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_UART2_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_UART2_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_UART2_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_UART2_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_UART2_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_UART2_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_UART2_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_UART2_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_UART2_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_UART2_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_UART2_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_UART2_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_UART2_CLK_RESERVED_Msk = 0xe0000000

	// BASE_UART3_CLK: Output stage BASE_UART3_CLK control register
	// Position of PD field.
	CGU_BASE_UART3_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_UART3_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_UART3_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_UART3_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_UART3_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_UART3_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_UART3_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_UART3_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_UART3_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_UART3_CLK_AUTOBLOCK = 0x800
	// Disabled. Autoblocking disabled
	CGU_BASE_UART3_CLK_AUTOBLOCK_DISABLED = 0x0
	// Enabled. Autoblocking enabled
	CGU_BASE_UART3_CLK_AUTOBLOCK_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_UART3_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_UART3_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_UART3_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_UART3_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_UART3_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_UART3_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_UART3_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_UART3_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_UART3_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_UART3_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_UART3_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_UART3_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_UART3_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_UART3_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_UART3_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_UART3_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_UART3_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_UART3_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_UART3_CLK_RESERVED_Msk = 0xe0000000

	// BASE_OUT_CLK: Output stage 20 control register for base clock BASE_OUT_CLK
	// Position of PD field.
	CGU_BASE_OUT_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_OUT_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_OUT_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_OUT_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_OUT_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_OUT_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_OUT_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_OUT_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_OUT_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_OUT_CLK_AUTOBLOCK = 0x800
	// Autoblocking disabled
	CGU_BASE_OUT_CLK_AUTOBLOCK_AUTOBLOCKING_DISABLE = 0x0
	// Autoblocking enabled
	CGU_BASE_OUT_CLK_AUTOBLOCK_AUTOBLOCKING_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_OUT_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_OUT_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_OUT_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_OUT_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_OUT_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_OUT_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_OUT_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_OUT_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_OUT_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_OUT_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for USB)
	CGU_BASE_OUT_CLK_CLK_SEL_PLL0_FOR_USB = 0x7
	// PLL0 (for audio)
	CGU_BASE_OUT_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_OUT_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_OUT_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_OUT_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_OUT_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_OUT_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_OUT_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_OUT_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_OUT_CLK_RESERVED_Msk = 0xe0000000

	// BASE_AUDIO_CLK: Output stage 25 control register for base clock BASE_AUDIO_CLK
	// Position of PD field.
	CGU_BASE_AUDIO_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_AUDIO_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_AUDIO_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_AUDIO_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_AUDIO_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_AUDIO_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_AUDIO_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_AUDIO_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_AUDIO_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_AUDIO_CLK_AUTOBLOCK = 0x800
	// Autoblocking disabled
	CGU_BASE_AUDIO_CLK_AUTOBLOCK_AUTOBLOCKING_DISABLE = 0x0
	// Autoblocking enabled
	CGU_BASE_AUDIO_CLK_AUTOBLOCK_AUTOBLOCKING_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_AUDIO_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_AUDIO_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_AUDIO_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_AUDIO_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_AUDIO_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_AUDIO_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_AUDIO_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_AUDIO_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_AUDIO_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_AUDIO_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_AUDIO_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_AUDIO_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_AUDIO_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_AUDIO_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_AUDIO_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_AUDIO_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_AUDIO_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_AUDIO_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_AUDIO_CLK_RESERVED_Msk = 0xe0000000

	// BASE_CGU_OUT0_CLK: Output stage 25 control register for base clock BASE_CGU_OUT0_CLK
	// Position of PD field.
	CGU_BASE_CGU_OUT0_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_CGU_OUT0_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_CGU_OUT0_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_CGU_OUT0_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_CGU_OUT0_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_CGU_OUT0_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_CGU_OUT0_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_CGU_OUT0_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_CGU_OUT0_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_CGU_OUT0_CLK_AUTOBLOCK = 0x800
	// Autoblocking disabled
	CGU_BASE_CGU_OUT0_CLK_AUTOBLOCK_AUTOBLOCKING_DISABLE = 0x0
	// Autoblocking enabled
	CGU_BASE_CGU_OUT0_CLK_AUTOBLOCK_AUTOBLOCKING_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_CGU_OUT0_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_CGU_OUT0_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_CGU_OUT0_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_CGU_OUT0_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_CGU_OUT0_CLK_RESERVED_Msk = 0xe0000000

	// BASE_CGU_OUT1_CLK: Output stage 25 control register for base clock BASE_CGU_OUT1_CLK
	// Position of PD field.
	CGU_BASE_CGU_OUT1_CLK_PD_Pos = 0x0
	// Bit mask of PD field.
	CGU_BASE_CGU_OUT1_CLK_PD_Msk = 0x1
	// Bit PD.
	CGU_BASE_CGU_OUT1_CLK_PD = 0x1
	// Output stage enabled (default)
	CGU_BASE_CGU_OUT1_CLK_PD_OUTPUT_STAGE_ENABLED = 0x0
	// power-down
	CGU_BASE_CGU_OUT1_CLK_PD_POWER_DOWN = 0x1
	// Position of RESERVED field.
	CGU_BASE_CGU_OUT1_CLK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CGU_BASE_CGU_OUT1_CLK_RESERVED_Msk = 0x7fe
	// Position of AUTOBLOCK field.
	CGU_BASE_CGU_OUT1_CLK_AUTOBLOCK_Pos = 0xb
	// Bit mask of AUTOBLOCK field.
	CGU_BASE_CGU_OUT1_CLK_AUTOBLOCK_Msk = 0x800
	// Bit AUTOBLOCK.
	CGU_BASE_CGU_OUT1_CLK_AUTOBLOCK = 0x800
	// Autoblocking disabled
	CGU_BASE_CGU_OUT1_CLK_AUTOBLOCK_AUTOBLOCKING_DISABLE = 0x0
	// Autoblocking enabled
	CGU_BASE_CGU_OUT1_CLK_AUTOBLOCK_AUTOBLOCKING_ENABLED = 0x1
	// Position of RESERVED field.
	CGU_BASE_CGU_OUT1_CLK_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CGU_BASE_CGU_OUT1_CLK_RESERVED_Msk = 0xfff000
	// Position of CLK_SEL field.
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_Pos = 0x18
	// Bit mask of CLK_SEL field.
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_Msk = 0x1f000000
	// 32 kHz oscillator
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_32_KHZ_OSCILLATOR = 0x0
	// IRC (default)
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_IRC_DEFAULT = 0x1
	// ENET_RX_CLK
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_ENET_RX_CLK = 0x2
	// ENET_TX_CLK
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_ENET_TX_CLK = 0x3
	// GP_CLKIN
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_GP_CLKIN = 0x4
	// Crystal oscillator
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_CRYSTAL_OSCILLATOR = 0x6
	// PLL0 (for audio)
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_PLL0_FOR_AUDIO = 0x8
	// PLL1
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_PLL1 = 0x9
	// IDIVA
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_IDIVA = 0xc
	// IDIVB
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_IDIVB = 0xd
	// IDIVC
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_IDIVC = 0xe
	// IDIVD
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_IDIVD = 0xf
	// IDIVE
	CGU_BASE_CGU_OUT1_CLK_CLK_SEL_IDIVE = 0x10
	// Position of RESERVED field.
	CGU_BASE_CGU_OUT1_CLK_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	CGU_BASE_CGU_OUT1_CLK_RESERVED_Msk = 0xe0000000
)

// Bitfields for CCU1: Clock Control Unit (CCU)
const (
	// PM: CCU1 power mode register
	// Position of PD field.
	CCU1_PM_PD_Pos = 0x0
	// Bit mask of PD field.
	CCU1_PM_PD_Msk = 0x1
	// Bit PD.
	CCU1_PM_PD = 0x1
	// Normal operation.
	CCU1_PM_PD_NORMAL_OPERATION_ = 0x0
	// Clocks with wake-up mode enabled (W = 1) are disabled.
	CCU1_PM_PD_CLOCKS_WITH_WAKE_UP_ = 0x1
	// Position of RESERVED field.
	CCU1_PM_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CCU1_PM_RESERVED_Msk = 0xfffffffe

	// BASE_STAT: CCU1 base clocks status register
	// Position of BASE_APB3_CLK_IND field.
	CCU1_BASE_STAT_BASE_APB3_CLK_IND_Pos = 0x0
	// Bit mask of BASE_APB3_CLK_IND field.
	CCU1_BASE_STAT_BASE_APB3_CLK_IND_Msk = 0x1
	// Bit BASE_APB3_CLK_IND.
	CCU1_BASE_STAT_BASE_APB3_CLK_IND = 0x1
	// Position of BASE_APB1_CLK_IND field.
	CCU1_BASE_STAT_BASE_APB1_CLK_IND_Pos = 0x1
	// Bit mask of BASE_APB1_CLK_IND field.
	CCU1_BASE_STAT_BASE_APB1_CLK_IND_Msk = 0x2
	// Bit BASE_APB1_CLK_IND.
	CCU1_BASE_STAT_BASE_APB1_CLK_IND = 0x2
	// Position of BASE_SPIFI_CLK_IND field.
	CCU1_BASE_STAT_BASE_SPIFI_CLK_IND_Pos = 0x2
	// Bit mask of BASE_SPIFI_CLK_IND field.
	CCU1_BASE_STAT_BASE_SPIFI_CLK_IND_Msk = 0x4
	// Bit BASE_SPIFI_CLK_IND.
	CCU1_BASE_STAT_BASE_SPIFI_CLK_IND = 0x4
	// Position of BASE_M3_CLK_IND field.
	CCU1_BASE_STAT_BASE_M3_CLK_IND_Pos = 0x3
	// Bit mask of BASE_M3_CLK_IND field.
	CCU1_BASE_STAT_BASE_M3_CLK_IND_Msk = 0x8
	// Bit BASE_M3_CLK_IND.
	CCU1_BASE_STAT_BASE_M3_CLK_IND = 0x8
	// Position of RESERVED field.
	CCU1_BASE_STAT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CCU1_BASE_STAT_RESERVED_Msk = 0x70
	// Position of BASE_USB0_CLK_IND field.
	CCU1_BASE_STAT_BASE_USB0_CLK_IND_Pos = 0x7
	// Bit mask of BASE_USB0_CLK_IND field.
	CCU1_BASE_STAT_BASE_USB0_CLK_IND_Msk = 0x80
	// Bit BASE_USB0_CLK_IND.
	CCU1_BASE_STAT_BASE_USB0_CLK_IND = 0x80
	// Position of BASE_USB1_CLK_IND field.
	CCU1_BASE_STAT_BASE_USB1_CLK_IND_Pos = 0x8
	// Bit mask of BASE_USB1_CLK_IND field.
	CCU1_BASE_STAT_BASE_USB1_CLK_IND_Msk = 0x100
	// Bit BASE_USB1_CLK_IND.
	CCU1_BASE_STAT_BASE_USB1_CLK_IND = 0x100
	// Position of RESERVED field.
	CCU1_BASE_STAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	CCU1_BASE_STAT_RESERVED_Msk = 0xfffffe00

	// CLK_APB3_BUS_CFG: CLK_APB3_BUS clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB3_BUS_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_BUS_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_BUS_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB3_BUS_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB3_BUS_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_BUS_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_BUS_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_BUS_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB3_BUS_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB3_BUS_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB3_BUS_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_BUS_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_BUS_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB3_BUS_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB3_BUS_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB3_BUS_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_BUS_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_BUS_STAT: CLK_APB3_BUS clock status register
	// Position of RUN field.
	CCU1_CLK_APB3_BUS_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_BUS_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_BUS_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_BUS_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_BUS_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_BUS_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB3_BUS_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_BUS_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_BUS_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB3_BUS_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_BUS_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_I2C1_CFG: CLK_APB3_I2C1 clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB3_I2C1_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_I2C1_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_I2C1_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB3_I2C1_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB3_I2C1_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_I2C1_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_I2C1_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_I2C1_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB3_I2C1_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB3_I2C1_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB3_I2C1_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_I2C1_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_I2C1_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB3_I2C1_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB3_I2C1_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB3_I2C1_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_I2C1_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_I2C1_STAT: CLK_APB3_I2C1 clock status register
	// Position of RUN field.
	CCU1_CLK_APB3_I2C1_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_I2C1_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_I2C1_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_I2C1_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_I2C1_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_I2C1_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB3_I2C1_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_I2C1_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_I2C1_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB3_I2C1_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_I2C1_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_DAC_CFG: CLK_APB3_DAC clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB3_DAC_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_DAC_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_DAC_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB3_DAC_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB3_DAC_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_DAC_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_DAC_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_DAC_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB3_DAC_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB3_DAC_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB3_DAC_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_DAC_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_DAC_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB3_DAC_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB3_DAC_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB3_DAC_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_DAC_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_DAC_STAT: CLK_APB3_DAC clock status register
	// Position of RUN field.
	CCU1_CLK_APB3_DAC_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_DAC_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_DAC_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_DAC_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_DAC_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_DAC_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB3_DAC_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_DAC_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_DAC_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB3_DAC_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_DAC_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_ADC0_CFG: CLK_APB3_ADC0 clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB3_ADC0_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_ADC0_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_ADC0_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB3_ADC0_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB3_ADC0_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_ADC0_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_ADC0_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_ADC0_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB3_ADC0_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB3_ADC0_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB3_ADC0_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_ADC0_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_ADC0_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB3_ADC0_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB3_ADC0_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB3_ADC0_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_ADC0_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_ADC0_STAT: CLK_APB3_ADC0 clock status register
	// Position of RUN field.
	CCU1_CLK_APB3_ADC0_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_ADC0_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_ADC0_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_ADC0_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_ADC0_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_ADC0_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB3_ADC0_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_ADC0_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_ADC0_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB3_ADC0_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_ADC0_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_ADC1_CFG: CLK_APB3_ADC1 clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB3_ADC1_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_ADC1_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_ADC1_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB3_ADC1_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB3_ADC1_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_ADC1_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_ADC1_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_ADC1_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB3_ADC1_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB3_ADC1_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB3_ADC1_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_ADC1_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_ADC1_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB3_ADC1_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB3_ADC1_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB3_ADC1_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_ADC1_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_ADC1_STAT: CLK_APB3_ADC1 clock status register
	// Position of RUN field.
	CCU1_CLK_APB3_ADC1_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_ADC1_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_ADC1_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_ADC1_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_ADC1_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_ADC1_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB3_ADC1_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_ADC1_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_ADC1_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB3_ADC1_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_ADC1_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_CAN0_CFG: CLK_APB3_CAN0 clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB3_CAN0_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_CAN0_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_CAN0_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB3_CAN0_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB3_CAN0_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_CAN0_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_CAN0_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_CAN0_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB3_CAN0_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB3_CAN0_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB3_CAN0_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_CAN0_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_CAN0_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB3_CAN0_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB3_CAN0_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB3_CAN0_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_CAN0_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB3_CAN0_STAT: CLK_APB3_CAN0 clock status register
	// Position of RUN field.
	CCU1_CLK_APB3_CAN0_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB3_CAN0_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB3_CAN0_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB3_CAN0_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB3_CAN0_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB3_CAN0_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB3_CAN0_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB3_CAN0_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB3_CAN0_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB3_CAN0_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB3_CAN0_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB1_BUS_CFG: CLK_APB1_BUS clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB1_BUS_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB1_BUS_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB1_BUS_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB1_BUS_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB1_BUS_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB1_BUS_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB1_BUS_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB1_BUS_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB1_BUS_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB1_BUS_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB1_BUS_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB1_BUS_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB1_BUS_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB1_BUS_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB1_BUS_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB1_BUS_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB1_BUS_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB1_BUS_STAT: CLK_APB1_BUS clock status register
	// Position of RUN field.
	CCU1_CLK_APB1_BUS_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB1_BUS_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB1_BUS_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB1_BUS_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB1_BUS_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB1_BUS_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB1_BUS_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB1_BUS_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB1_BUS_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB1_BUS_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB1_BUS_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB1_MOTOCONPWM_CFG: CLK_APB1_MOTOCONPWM clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB1_MOTOCONPWM_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB1_MOTOCONPWM_STAT: CLK_APB1_MOTOCONPWM clock status register
	// Position of RUN field.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB1_MOTOCONPWM_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB1_I2C0_CFG: CLK_ABP1_I2C0 clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB1_I2C0_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB1_I2C0_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB1_I2C0_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB1_I2C0_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB1_I2C0_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB1_I2C0_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB1_I2C0_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB1_I2C0_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB1_I2C0_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB1_I2C0_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB1_I2C0_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB1_I2C0_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB1_I2C0_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB1_I2C0_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB1_I2C0_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB1_I2C0_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB1_I2C0_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB1_I2C0_STAT: CLK_APB1_I2C0 clock status register
	// Position of RUN field.
	CCU1_CLK_APB1_I2C0_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB1_I2C0_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB1_I2C0_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB1_I2C0_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB1_I2C0_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB1_I2C0_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB1_I2C0_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB1_I2C0_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB1_I2C0_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB1_I2C0_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB1_I2C0_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB1_I2S_CFG: CLK_APB1_I2S clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB1_I2S_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB1_I2S_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB1_I2S_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB1_I2S_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB1_I2S_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB1_I2S_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB1_I2S_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB1_I2S_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB1_I2S_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB1_I2S_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB1_I2S_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB1_I2S_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB1_I2S_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB1_I2S_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB1_I2S_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB1_I2S_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB1_I2S_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB1_I2S_STAT: CLK_APB1_I2S clock status register
	// Position of RUN field.
	CCU1_CLK_APB1_I2S_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB1_I2S_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB1_I2S_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB1_I2S_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB1_I2S_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB1_I2S_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB1_I2S_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB1_I2S_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB1_I2S_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB1_I2S_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB1_I2S_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB1_CAN1_CFG: CLK_APB1_CAN1 clock configuration register
	// Position of RUN field.
	CCU1_CLK_APB1_CAN1_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB1_CAN1_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB1_CAN1_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_APB1_CAN1_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_APB1_CAN1_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB1_CAN1_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB1_CAN1_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB1_CAN1_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_APB1_CAN1_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_APB1_CAN1_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_APB1_CAN1_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB1_CAN1_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB1_CAN1_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_APB1_CAN1_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_APB1_CAN1_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_APB1_CAN1_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB1_CAN1_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB1_CAN1_STAT: CLK_APB1_CAN1 clock status register
	// Position of RUN field.
	CCU1_CLK_APB1_CAN1_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_APB1_CAN1_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_APB1_CAN1_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_APB1_CAN1_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_APB1_CAN1_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_APB1_CAN1_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_APB1_CAN1_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_APB1_CAN1_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_APB1_CAN1_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_APB1_CAN1_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_APB1_CAN1_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_SPIFI_CFG: CLK_SPIFI clock configuration register
	// Position of RUN field.
	CCU1_CLK_SPIFI_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_SPIFI_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_SPIFI_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_SPIFI_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_SPIFI_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_SPIFI_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_SPIFI_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_SPIFI_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_SPIFI_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_SPIFI_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_SPIFI_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_SPIFI_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_SPIFI_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_SPIFI_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_SPIFI_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_SPIFI_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_SPIFI_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_SPIFI_STAT: CLK_APB1_SPIFI clock status register
	// Position of RUN field.
	CCU1_CLK_SPIFI_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_SPIFI_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_SPIFI_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_SPIFI_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_SPIFI_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_SPIFI_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_SPIFI_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_SPIFI_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_SPIFI_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_SPIFI_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_SPIFI_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_BUS_CFG: CLK_M3_BUS clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_BUS_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_BUS_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_BUS_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_BUS_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_BUS_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_BUS_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_BUS_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_BUS_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_BUS_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_BUS_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_BUS_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_BUS_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_BUS_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_BUS_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_BUS_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_BUS_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_BUS_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_BUS_STAT: CLK_M4_BUSclock status register
	// Position of RUN field.
	CCU1_CLK_M3_BUS_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_BUS_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_BUS_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_BUS_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_BUS_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_BUS_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_BUS_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_BUS_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_BUS_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_BUS_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_BUS_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SPIFI_CFG: CLK_M3_SPIFI clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_SPIFI_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SPIFI_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SPIFI_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_SPIFI_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_SPIFI_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SPIFI_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SPIFI_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SPIFI_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_SPIFI_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_SPIFI_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_SPIFI_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SPIFI_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SPIFI_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_SPIFI_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_SPIFI_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_SPIFI_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SPIFI_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SPIFI_STAT: CLK_M3_SPIFI clock status register
	// Position of RUN field.
	CCU1_CLK_M3_SPIFI_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SPIFI_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SPIFI_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SPIFI_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SPIFI_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SPIFI_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_SPIFI_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SPIFI_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SPIFI_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_SPIFI_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SPIFI_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_GPIO_CFG: CLK_M3_GPIO clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_GPIO_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_GPIO_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_GPIO_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_GPIO_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_GPIO_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_GPIO_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_GPIO_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_GPIO_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_GPIO_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_GPIO_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_GPIO_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_GPIO_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_GPIO_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_GPIO_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_GPIO_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_GPIO_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_GPIO_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_GPIO_STAT: CLK_M3_GPIO clock status register
	// Position of RUN field.
	CCU1_CLK_M3_GPIO_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_GPIO_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_GPIO_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_GPIO_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_GPIO_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_GPIO_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_GPIO_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_GPIO_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_GPIO_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_GPIO_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_GPIO_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_LCD_CFG: CLK_M3_LCD clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_LCD_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_LCD_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_LCD_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_LCD_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_LCD_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_LCD_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_LCD_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_LCD_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_LCD_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_LCD_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_LCD_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_LCD_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_LCD_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_LCD_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_LCD_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_LCD_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_LCD_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_LCD_STAT: CLK_M3_LCD clock status register
	// Position of RUN field.
	CCU1_CLK_M3_LCD_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_LCD_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_LCD_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_LCD_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_LCD_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_LCD_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_LCD_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_LCD_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_LCD_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_LCD_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_LCD_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_ETHERNET_CFG: CLK_M3_ETHERNET clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_ETHERNET_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_ETHERNET_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_ETHERNET_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_ETHERNET_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_ETHERNET_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_ETHERNET_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_ETHERNET_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_ETHERNET_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_ETHERNET_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_ETHERNET_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_ETHERNET_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_ETHERNET_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_ETHERNET_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_ETHERNET_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_ETHERNET_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_ETHERNET_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_ETHERNET_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_ETHERNET_STAT: CLK_M3_ETHERNET clock status register
	// Position of RUN field.
	CCU1_CLK_M3_ETHERNET_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_ETHERNET_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_ETHERNET_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_ETHERNET_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_ETHERNET_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_ETHERNET_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_ETHERNET_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_ETHERNET_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_ETHERNET_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_ETHERNET_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_ETHERNET_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_USB0_CFG: CLK_M3_USB0 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_USB0_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_USB0_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_USB0_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_USB0_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_USB0_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_USB0_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_USB0_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_USB0_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_USB0_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_USB0_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_USB0_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_USB0_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_USB0_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_USB0_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_USB0_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_USB0_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_USB0_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_USB0_STAT: CLK_M3_USB0 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_USB0_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_USB0_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_USB0_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_USB0_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_USB0_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_USB0_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_USB0_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_USB0_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_USB0_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_USB0_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_USB0_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_EMC_CFG: CLK_M3_EMC clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_EMC_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_EMC_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_EMC_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_EMC_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_EMC_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_EMC_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_EMC_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_EMC_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_EMC_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_EMC_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_EMC_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_EMC_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_EMC_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_EMC_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_EMC_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_EMC_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_EMC_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_EMC_STAT: CLK_M3_EMC clock status register
	// Position of RUN field.
	CCU1_CLK_M3_EMC_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_EMC_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_EMC_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_EMC_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_EMC_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_EMC_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_EMC_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_EMC_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_EMC_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_EMC_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_EMC_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SDIO_CFG: CLK_M3_SDIO clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_SDIO_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SDIO_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SDIO_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_SDIO_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_SDIO_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SDIO_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SDIO_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SDIO_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_SDIO_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_SDIO_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_SDIO_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SDIO_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SDIO_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_SDIO_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_SDIO_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_SDIO_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SDIO_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SDIO_STAT: CLK_M3_SDIO clock status register
	// Position of RUN field.
	CCU1_CLK_M3_SDIO_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SDIO_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SDIO_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SDIO_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SDIO_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SDIO_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_SDIO_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SDIO_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SDIO_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_SDIO_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SDIO_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_DMA_CFG: CLK_M3_DMA clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_DMA_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_DMA_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_DMA_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_DMA_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_DMA_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_DMA_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_DMA_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_DMA_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_DMA_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_DMA_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_DMA_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_DMA_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_DMA_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_DMA_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_DMA_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_DMA_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_DMA_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_DMA_STAT: CLK_M3_DMA clock status register
	// Position of RUN field.
	CCU1_CLK_M3_DMA_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_DMA_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_DMA_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_DMA_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_DMA_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_DMA_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_DMA_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_DMA_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_DMA_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_DMA_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_DMA_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_M3CORE_CFG: CLK_M3_M3CORE clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_M3CORE_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_M3CORE_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_M3CORE_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_M3CORE_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_M3CORE_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_M3CORE_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_M3CORE_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_M3CORE_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_M3CORE_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_M3CORE_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_M3CORE_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_M3CORE_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_M3CORE_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_M3CORE_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_M3CORE_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_M3CORE_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_M3CORE_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_M3CORE_STAT: CLK_M3_M3CORE clock status register
	// Position of RUN field.
	CCU1_CLK_M3_M3CORE_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_M3CORE_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_M3CORE_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_M3CORE_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_M3CORE_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_M3CORE_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_M3CORE_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_M3CORE_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_M3CORE_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_M3CORE_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_M3CORE_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SCT_CFG: CLK_M3_SCT clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_SCT_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SCT_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SCT_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_SCT_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_SCT_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SCT_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SCT_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SCT_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_SCT_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_SCT_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_SCT_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SCT_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SCT_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_SCT_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_SCT_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_SCT_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SCT_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SCT_STAT: CLK_M3_SCT clock status register
	// Position of RUN field.
	CCU1_CLK_M3_SCT_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SCT_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SCT_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SCT_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SCT_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SCT_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_SCT_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SCT_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SCT_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_SCT_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SCT_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_USB1_CFG: CLK_M3_USB1 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_USB1_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_USB1_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_USB1_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_USB1_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_USB1_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_USB1_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_USB1_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_USB1_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_USB1_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_USB1_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_USB1_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_USB1_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_USB1_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_USB1_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_USB1_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_USB1_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_USB1_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_USB1_STAT: CLK_M3_USB1 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_USB1_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_USB1_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_USB1_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_USB1_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_USB1_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_USB1_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_USB1_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_USB1_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_USB1_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_USB1_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_USB1_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_EMCDIV_CFG: CLK_M3_EMCDIV clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_EMCDIV_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_EMCDIV_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_EMCDIV_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_EMCDIV_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_EMCDIV_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_EMCDIV_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_EMCDIV_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_EMCDIV_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_EMCDIV_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_EMCDIV_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_EMCDIV_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_EMCDIV_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_EMCDIV_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_EMCDIV_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_EMCDIV_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_EMCDIV_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_EMCDIV_CFG_RESERVED_Msk = 0x18
	// Position of DIV field.
	CCU1_CLK_M3_EMCDIV_CFG_DIV_Pos = 0x5
	// Bit mask of DIV field.
	CCU1_CLK_M3_EMCDIV_CFG_DIV_Msk = 0xe0
	// No division. Divide by 1.
	CCU1_CLK_M3_EMCDIV_CFG_DIV_DIVIDEBY1 = 0x0
	// Divide by 2.
	CCU1_CLK_M3_EMCDIV_CFG_DIV_DIVIDEBY2 = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_EMCDIV_CFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_EMCDIV_CFG_RESERVED_Msk = 0xffffff00

	// CLK_M3_EMCDIV_STAT: CLK_M3_EMCDIV clock status register
	// Position of RUN field.
	CCU1_CLK_M3_EMCDIV_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_EMCDIV_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_EMCDIV_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_EMCDIV_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_EMCDIV_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_EMCDIV_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_EMCDIV_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_EMCDIV_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_EMCDIV_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_EMCDIV_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_EMCDIV_STAT_RESERVED_Msk = 0x18
	// Position of DIV field.
	CCU1_CLK_M3_EMCDIV_STAT_DIV_Pos = 0x5
	// Bit mask of DIV field.
	CCU1_CLK_M3_EMCDIV_STAT_DIV_Msk = 0xe0
	// No division. Divide by 1.
	CCU1_CLK_M3_EMCDIV_STAT_DIV_DIVIDEBY1 = 0x0
	// Divide by 2.
	CCU1_CLK_M3_EMCDIV_STAT_DIV_DIVIDEBY2 = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_EMCDIV_STAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_EMCDIV_STAT_RESERVED_Msk = 0xffffff00

	// CLK_M3_FLASHA_CFG: CLK_M3_FLASHA clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_FLASHA_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_FLASHA_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_FLASHA_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_FLASHA_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_FLASHA_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_FLASHA_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_FLASHA_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_FLASHA_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_FLASHA_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_FLASHA_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_FLASHA_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_FLASHA_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_FLASHA_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_FLASHA_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_FLASHA_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_FLASHA_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_FLASHA_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_FLASHA_STAT: CLK_M3_FLASHA clock status register
	// Position of RUN field.
	CCU1_CLK_M3_FLASHA_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_FLASHA_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_FLASHA_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_FLASHA_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_FLASHA_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_FLASHA_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_FLASHA_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_FLASHA_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_FLASHA_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_FLASHA_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_FLASHA_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_FLASHB_CFG: CLK_M3_FLASHB clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_FLASHB_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_FLASHB_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_FLASHB_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_FLASHB_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_FLASHB_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_FLASHB_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_FLASHB_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_FLASHB_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_FLASHB_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_FLASHB_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_FLASHB_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_FLASHB_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_FLASHB_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_FLASHB_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_FLASHB_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_FLASHB_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_FLASHB_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_FLASHB_STAT: CLK_M3_FLASHB clock status register
	// Position of RUN field.
	CCU1_CLK_M3_FLASHB_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_FLASHB_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_FLASHB_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_FLASHB_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_FLASHB_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_FLASHB_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_FLASHB_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_FLASHB_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_FLASHB_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_FLASHB_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_FLASHB_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_EEPROM_CFG: CLK_EEPROM_CFG clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_EEPROM_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_EEPROM_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_EEPROM_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_EEPROM_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_EEPROM_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_EEPROM_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_EEPROM_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_EEPROM_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_EEPROM_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_EEPROM_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_EEPROM_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_EEPROM_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_EEPROM_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_EEPROM_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_EEPROM_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_EEPROM_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_EEPROM_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_EEPROM_STAT: CLK_M3_EEPROM clock status register
	// Position of RUN field.
	CCU1_CLK_M3_EEPROM_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_EEPROM_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_EEPROM_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_EEPROM_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_EEPROM_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_EEPROM_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_EEPROM_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_EEPROM_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_EEPROM_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_EEPROM_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_EEPROM_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_WWDT_CFG: CLK_M3_WWDT clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_WWDT_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_WWDT_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_WWDT_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_WWDT_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_WWDT_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_WWDT_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_WWDT_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_WWDT_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_WWDT_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_WWDT_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_WWDT_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_WWDT_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_WWDT_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_WWDT_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_WWDT_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_WWDT_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_WWDT_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_WWDT_STAT: CLK_M3_WWDT clock status register
	// Position of RUN field.
	CCU1_CLK_M3_WWDT_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_WWDT_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_WWDT_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_WWDT_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_WWDT_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_WWDT_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_WWDT_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_WWDT_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_WWDT_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_WWDT_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_WWDT_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_USART0_CFG: CLK_M3_USART0 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_USART0_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_USART0_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_USART0_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_USART0_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_USART0_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_USART0_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_USART0_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_USART0_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_USART0_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_USART0_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_USART0_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_USART0_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_USART0_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_USART0_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_USART0_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_USART0_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_USART0_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_USART0_STAT: CLK_M3_USART0 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_USART0_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_USART0_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_USART0_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_USART0_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_USART0_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_USART0_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_USART0_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_USART0_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_USART0_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_USART0_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_USART0_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_UART1_CFG: CLK_M3_UART1 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_UART1_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_UART1_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_UART1_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_UART1_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_UART1_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_UART1_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_UART1_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_UART1_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_UART1_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_UART1_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_UART1_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_UART1_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_UART1_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_UART1_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_UART1_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_UART1_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_UART1_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_UART1_STAT: CLK_M3_UART1 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_UART1_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_UART1_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_UART1_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_UART1_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_UART1_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_UART1_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_UART1_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_UART1_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_UART1_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_UART1_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_UART1_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SSP0_CFG: CLK_M3_SSP0 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_SSP0_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SSP0_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SSP0_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_SSP0_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_SSP0_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SSP0_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SSP0_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SSP0_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_SSP0_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_SSP0_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_SSP0_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SSP0_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SSP0_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_SSP0_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_SSP0_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_SSP0_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SSP0_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SSP0_STAT: CLK_M3_SSP0 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_SSP0_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SSP0_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SSP0_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SSP0_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SSP0_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SSP0_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_SSP0_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SSP0_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SSP0_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_SSP0_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SSP0_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_TIMER0_CFG: CLK_M3_TIMER0 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_TIMER0_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_TIMER0_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_TIMER0_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_TIMER0_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_TIMER0_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_TIMER0_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_TIMER0_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_TIMER0_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_TIMER0_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_TIMER0_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_TIMER0_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_TIMER0_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_TIMER0_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_TIMER0_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_TIMER0_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_TIMER0_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_TIMER0_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_TIMER0_STAT: CLK_M3_TIMER0 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_TIMER0_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_TIMER0_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_TIMER0_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_TIMER0_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_TIMER0_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_TIMER0_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_TIMER0_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_TIMER0_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_TIMER0_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_TIMER0_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_TIMER0_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_TIMER1_CFG: CLK_M3_TIMER1clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_TIMER1_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_TIMER1_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_TIMER1_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_TIMER1_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_TIMER1_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_TIMER1_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_TIMER1_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_TIMER1_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_TIMER1_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_TIMER1_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_TIMER1_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_TIMER1_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_TIMER1_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_TIMER1_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_TIMER1_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_TIMER1_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_TIMER1_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_TIMER1_STAT: CLK_M3_TIMER1 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_TIMER1_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_TIMER1_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_TIMER1_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_TIMER1_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_TIMER1_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_TIMER1_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_TIMER1_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_TIMER1_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_TIMER1_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_TIMER1_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_TIMER1_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SCU_CFG: CLK_M3_SCU clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_SCU_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SCU_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SCU_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_SCU_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_SCU_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SCU_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SCU_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SCU_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_SCU_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_SCU_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_SCU_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SCU_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SCU_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_SCU_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_SCU_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_SCU_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SCU_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SCU_STAT: CLK_SCU_XXX clock status register
	// Position of RUN field.
	CCU1_CLK_M3_SCU_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SCU_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SCU_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SCU_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SCU_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SCU_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_SCU_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SCU_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SCU_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_SCU_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SCU_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_CREG_CFG: CLK_M3_CREG clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_CREG_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_CREG_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_CREG_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_CREG_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_CREG_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_CREG_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_CREG_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_CREG_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_CREG_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_CREG_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_CREG_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_CREG_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_CREG_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_CREG_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_CREG_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_CREG_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_CREG_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_CREG_STAT: CLK_M3_CREG clock status register
	// Position of RUN field.
	CCU1_CLK_M3_CREG_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_CREG_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_CREG_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_CREG_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_CREG_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_CREG_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_CREG_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_CREG_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_CREG_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_CREG_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_CREG_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_RITIMER_CFG: CLK_M3_RITIMER clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_RITIMER_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_RITIMER_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_RITIMER_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_RITIMER_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_RITIMER_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_RITIMER_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_RITIMER_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_RITIMER_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_RITIMER_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_RITIMER_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_RITIMER_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_RITIMER_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_RITIMER_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_RITIMER_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_RITIMER_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_RITIMER_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_RITIMER_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_RITIMER_STAT: CLK_M3_RITIMER clock status register
	// Position of RUN field.
	CCU1_CLK_M3_RITIMER_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_RITIMER_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_RITIMER_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_RITIMER_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_RITIMER_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_RITIMER_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_RITIMER_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_RITIMER_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_RITIMER_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_RITIMER_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_RITIMER_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_USART2_CFG: CLK_M3_USART2 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_USART2_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_USART2_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_USART2_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_USART2_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_USART2_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_USART2_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_USART2_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_USART2_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_USART2_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_USART2_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_USART2_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_USART2_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_USART2_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_USART2_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_USART2_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_USART2_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_USART2_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_USART2_STAT: CLK_M3_USART2 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_USART2_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_USART2_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_USART2_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_USART2_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_USART2_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_USART2_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_USART2_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_USART2_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_USART2_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_USART2_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_USART2_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_USART3_CFG: CLK_M3_USART3 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_USART3_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_USART3_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_USART3_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_USART3_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_USART3_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_USART3_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_USART3_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_USART3_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_USART3_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_USART3_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_USART3_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_USART3_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_USART3_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_USART3_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_USART3_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_USART3_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_USART3_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_USART3_STAT: CLK_M3_USART3 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_USART3_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_USART3_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_USART3_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_USART3_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_USART3_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_USART3_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_USART3_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_USART3_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_USART3_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_USART3_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_USART3_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_TIMER2_CFG: CLK_M3_TIMER2 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_TIMER2_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_TIMER2_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_TIMER2_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_TIMER2_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_TIMER2_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_TIMER2_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_TIMER2_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_TIMER2_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_TIMER2_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_TIMER2_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_TIMER2_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_TIMER2_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_TIMER2_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_TIMER2_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_TIMER2_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_TIMER2_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_TIMER2_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_TIMER2_STAT: CLK_M3_TIMER2 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_TIMER2_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_TIMER2_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_TIMER2_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_TIMER2_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_TIMER2_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_TIMER2_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_TIMER2_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_TIMER2_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_TIMER2_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_TIMER2_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_TIMER2_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_TIMER3_CFG: CLK_M3_TIMER3 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_TIMER3_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_TIMER3_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_TIMER3_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_TIMER3_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_TIMER3_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_TIMER3_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_TIMER3_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_TIMER3_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_TIMER3_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_TIMER3_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_TIMER3_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_TIMER3_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_TIMER3_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_TIMER3_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_TIMER3_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_TIMER3_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_TIMER3_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_TIMER3_STAT: CLK_M3_TIMER3 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_TIMER3_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_TIMER3_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_TIMER3_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_TIMER3_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_TIMER3_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_TIMER3_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_TIMER3_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_TIMER3_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_TIMER3_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_TIMER3_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_TIMER3_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SSP1_CFG: CLK_M3_SSP1 clock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_SSP1_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SSP1_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SSP1_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_SSP1_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_SSP1_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SSP1_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SSP1_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SSP1_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_SSP1_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_SSP1_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_SSP1_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SSP1_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SSP1_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_SSP1_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_SSP1_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_SSP1_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SSP1_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_SSP1_STAT: CLK_M3_SSP1 clock status register
	// Position of RUN field.
	CCU1_CLK_M3_SSP1_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_SSP1_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_SSP1_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_SSP1_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_SSP1_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_SSP1_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_SSP1_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_SSP1_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_SSP1_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_SSP1_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_SSP1_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_M3_QEI_CFG: CLK_M3_QEIclock configuration register
	// Position of RUN field.
	CCU1_CLK_M3_QEI_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_QEI_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_QEI_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_M3_QEI_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_M3_QEI_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_QEI_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_QEI_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_QEI_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_M3_QEI_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_M3_QEI_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_M3_QEI_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_QEI_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_QEI_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_M3_QEI_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU1_CLK_M3_QEI_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU1_CLK_M3_QEI_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_QEI_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_M3_QEI_STAT: CLK_M3_QEI clock status register
	// Position of RUN field.
	CCU1_CLK_M3_QEI_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_M3_QEI_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_M3_QEI_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_M3_QEI_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_M3_QEI_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_M3_QEI_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_M3_QEI_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_M3_QEI_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_M3_QEI_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_M3_QEI_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_M3_QEI_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_USB0_CFG: CLK_USB0 clock configuration register
	// Position of RUN field.
	CCU1_CLK_USB0_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_USB0_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_USB0_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_USB0_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_USB0_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_USB0_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_USB0_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_USB0_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_USB0_CFG_AUTO_AUTO_IS_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_USB0_CFG_AUTO_AUTO_IS_ENABLED_ = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_USB0_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_USB0_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_USB0_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_USB0_CFG_WAKEUP_WAKE_UP_IS_DISABLED_ = 0x0
	// Wake-up is enabled.
	CCU1_CLK_USB0_CFG_WAKEUP_WAKE_UP_IS_ENABLED_ = 0x1
	// Position of RESERVED field.
	CCU1_CLK_USB0_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_USB0_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_USB0_STAT: CLK_USB0 clock status register
	// Position of RUN field.
	CCU1_CLK_USB0_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_USB0_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_USB0_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_USB0_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_USB0_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_USB0_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_USB0_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_USB0_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_USB0_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_USB0_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_USB0_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_USB1_CFG: CLK_USB1 clock configuration register
	// Position of RUN field.
	CCU1_CLK_USB1_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_USB1_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_USB1_CFG_RUN = 0x1
	// Clock is disabled.
	CCU1_CLK_USB1_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU1_CLK_USB1_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU1_CLK_USB1_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_USB1_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_USB1_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU1_CLK_USB1_CFG_AUTO_AUTO_IS_DISABLED_ = 0x0
	// Auto is enabled.
	CCU1_CLK_USB1_CFG_AUTO_AUTO_IS_ENABLED_ = 0x1
	// Position of WAKEUP field.
	CCU1_CLK_USB1_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_USB1_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_USB1_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU1_CLK_USB1_CFG_WAKEUP_WAKE_UP_IS_DISABLED_ = 0x0
	// Wake-up is enabled.
	CCU1_CLK_USB1_CFG_WAKEUP_WAKE_UP_IS_ENABLED_ = 0x1
	// Position of RESERVED field.
	CCU1_CLK_USB1_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_USB1_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_USB1_STAT: CLK_USB1 clock status register
	// Position of RUN field.
	CCU1_CLK_USB1_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU1_CLK_USB1_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU1_CLK_USB1_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU1_CLK_USB1_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU1_CLK_USB1_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU1_CLK_USB1_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU1_CLK_USB1_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU1_CLK_USB1_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU1_CLK_USB1_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU1_CLK_USB1_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU1_CLK_USB1_STAT_RESERVED_Msk = 0xfffffff8
)

// Bitfields for CCU2: Clock Control Unit (CCU2)
const (
	// PM: Power mode register
	// Position of PD field.
	CCU2_PM_PD_Pos = 0x0
	// Bit mask of PD field.
	CCU2_PM_PD_Msk = 0x1
	// Bit PD.
	CCU2_PM_PD = 0x1
	// Normal operation.
	CCU2_PM_PD_NORMAL_OPERATION_ = 0x0
	// Clocks with wake-up mode enabled (W = 1) are disabled.
	CCU2_PM_PD_CLOCKS_WITH_WAKE_UP_ = 0x1
	// Position of RESERVED field.
	CCU2_PM_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CCU2_PM_RESERVED_Msk = 0xfffffffe

	// BASE_STAT: CCU base clocks status register
	// Position of RESERVED field.
	CCU2_BASE_STAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CCU2_BASE_STAT_RESERVED_Msk = 0x1
	// Bit RESERVED.
	CCU2_BASE_STAT_RESERVED = 0x1
	// Position of BASE_UART3_CLK field.
	CCU2_BASE_STAT_BASE_UART3_CLK_Pos = 0x1
	// Bit mask of BASE_UART3_CLK field.
	CCU2_BASE_STAT_BASE_UART3_CLK_Msk = 0x2
	// Bit BASE_UART3_CLK.
	CCU2_BASE_STAT_BASE_UART3_CLK = 0x2
	// Position of BASE_UART2_CLK field.
	CCU2_BASE_STAT_BASE_UART2_CLK_Pos = 0x2
	// Bit mask of BASE_UART2_CLK field.
	CCU2_BASE_STAT_BASE_UART2_CLK_Msk = 0x4
	// Bit BASE_UART2_CLK.
	CCU2_BASE_STAT_BASE_UART2_CLK = 0x4
	// Position of BASE_UART1_CLK field.
	CCU2_BASE_STAT_BASE_UART1_CLK_Pos = 0x3
	// Bit mask of BASE_UART1_CLK field.
	CCU2_BASE_STAT_BASE_UART1_CLK_Msk = 0x8
	// Bit BASE_UART1_CLK.
	CCU2_BASE_STAT_BASE_UART1_CLK = 0x8
	// Position of BASE_UART0_CLK field.
	CCU2_BASE_STAT_BASE_UART0_CLK_Pos = 0x4
	// Bit mask of BASE_UART0_CLK field.
	CCU2_BASE_STAT_BASE_UART0_CLK_Msk = 0x10
	// Bit BASE_UART0_CLK.
	CCU2_BASE_STAT_BASE_UART0_CLK = 0x10
	// Position of BASE_SSP1_CLK field.
	CCU2_BASE_STAT_BASE_SSP1_CLK_Pos = 0x5
	// Bit mask of BASE_SSP1_CLK field.
	CCU2_BASE_STAT_BASE_SSP1_CLK_Msk = 0x20
	// Bit BASE_SSP1_CLK.
	CCU2_BASE_STAT_BASE_SSP1_CLK = 0x20
	// Position of BASE_SSP0_CLK field.
	CCU2_BASE_STAT_BASE_SSP0_CLK_Pos = 0x6
	// Bit mask of BASE_SSP0_CLK field.
	CCU2_BASE_STAT_BASE_SSP0_CLK_Msk = 0x40
	// Bit BASE_SSP0_CLK.
	CCU2_BASE_STAT_BASE_SSP0_CLK = 0x40
	// Position of RESERVED field.
	CCU2_BASE_STAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CCU2_BASE_STAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	CCU2_BASE_STAT_RESERVED = 0x80
	// Position of RESERVED field.
	CCU2_BASE_STAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CCU2_BASE_STAT_RESERVED_Msk = 0xffffff00

	// CLK_AUDIO_CFG: CLK_AUDIO clock configuration register
	// Position of RUN field.
	CCU2_CLK_AUDIO_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_AUDIO_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_AUDIO_CFG_RUN = 0x1
	// Clock is disabled.
	CCU2_CLK_AUDIO_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU2_CLK_AUDIO_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU2_CLK_AUDIO_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_AUDIO_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_AUDIO_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU2_CLK_AUDIO_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU2_CLK_AUDIO_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU2_CLK_AUDIO_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_AUDIO_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_AUDIO_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU2_CLK_AUDIO_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU2_CLK_AUDIO_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU2_CLK_AUDIO_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_AUDIO_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_AUDIO_STAT: CLK_AUDIO clock status register
	// Position of RUN field.
	CCU2_CLK_AUDIO_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_AUDIO_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_AUDIO_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU2_CLK_AUDIO_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_AUDIO_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_AUDIO_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU2_CLK_AUDIO_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_AUDIO_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_AUDIO_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU2_CLK_AUDIO_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_AUDIO_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB2_USART3_CFG: CLK_APB2_USART3 clock configuration register
	// Position of RUN field.
	CCU2_CLK_APB2_USART3_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB2_USART3_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB2_USART3_CFG_RUN = 0x1
	// Clock is disabled.
	CCU2_CLK_APB2_USART3_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU2_CLK_APB2_USART3_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB2_USART3_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB2_USART3_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB2_USART3_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU2_CLK_APB2_USART3_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU2_CLK_APB2_USART3_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU2_CLK_APB2_USART3_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB2_USART3_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB2_USART3_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU2_CLK_APB2_USART3_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU2_CLK_APB2_USART3_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU2_CLK_APB2_USART3_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB2_USART3_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB2_USART3_STAT: CLK_APB2_USART3 clock status register
	// Position of RUN field.
	CCU2_CLK_APB2_USART3_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB2_USART3_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB2_USART3_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB2_USART3_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB2_USART3_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB2_USART3_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU2_CLK_APB2_USART3_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB2_USART3_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB2_USART3_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU2_CLK_APB2_USART3_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB2_USART3_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB2_USART2_CFG: CLK_APB2_USART2 clock configuration register
	// Position of RUN field.
	CCU2_CLK_APB2_USART2_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB2_USART2_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB2_USART2_CFG_RUN = 0x1
	// Clock is disabled.
	CCU2_CLK_APB2_USART2_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU2_CLK_APB2_USART2_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB2_USART2_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB2_USART2_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB2_USART2_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU2_CLK_APB2_USART2_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU2_CLK_APB2_USART2_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU2_CLK_APB2_USART2_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB2_USART2_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB2_USART2_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU2_CLK_APB2_USART2_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU2_CLK_APB2_USART2_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU2_CLK_APB2_USART2_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB2_USART2_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB2_USART2_STAT: CLK_APB2_USART clock status register
	// Position of RUN field.
	CCU2_CLK_APB2_USART2_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB2_USART2_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB2_USART2_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB2_USART2_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB2_USART2_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB2_USART2_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU2_CLK_APB2_USART2_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB2_USART2_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB2_USART2_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU2_CLK_APB2_USART2_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB2_USART2_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB0_UART1_BUS_CFG: CLK_APB2_UART1 clock configuration register
	// Position of RUN field.
	CCU2_CLK_APB0_UART1_BUS_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB0_UART1_BUS_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB0_UART1_BUS_CFG_RUN = 0x1
	// Clock is disabled.
	CCU2_CLK_APB0_UART1_BUS_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU2_CLK_APB0_UART1_BUS_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB0_UART1_BUS_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB0_UART1_BUS_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB0_UART1_BUS_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU2_CLK_APB0_UART1_BUS_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU2_CLK_APB0_UART1_BUS_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU2_CLK_APB0_UART1_BUS_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB0_UART1_BUS_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB0_UART1_BUS_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU2_CLK_APB0_UART1_BUS_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU2_CLK_APB0_UART1_BUS_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU2_CLK_APB0_UART1_BUS_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB0_UART1_BUS_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB0_UART1_STAT: CLK_APB0_UART1 clock status register
	// Position of RUN field.
	CCU2_CLK_APB0_UART1_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB0_UART1_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB0_UART1_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB0_UART1_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB0_UART1_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB0_UART1_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU2_CLK_APB0_UART1_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB0_UART1_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB0_UART1_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU2_CLK_APB0_UART1_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB0_UART1_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB0_USART0_CFG: CLK_APB2_USART0 clock configuration register
	// Position of RUN field.
	CCU2_CLK_APB0_USART0_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB0_USART0_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB0_USART0_CFG_RUN = 0x1
	// Clock is disabled.
	CCU2_CLK_APB0_USART0_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU2_CLK_APB0_USART0_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB0_USART0_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB0_USART0_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB0_USART0_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU2_CLK_APB0_USART0_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU2_CLK_APB0_USART0_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU2_CLK_APB0_USART0_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB0_USART0_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB0_USART0_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU2_CLK_APB0_USART0_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU2_CLK_APB0_USART0_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU2_CLK_APB0_USART0_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB0_USART0_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB0_USART0_STAT: CLK_APB0_USART0 clock status register
	// Position of RUN field.
	CCU2_CLK_APB0_USART0_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB0_USART0_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB0_USART0_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB0_USART0_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB0_USART0_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB0_USART0_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU2_CLK_APB0_USART0_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB0_USART0_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB0_USART0_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU2_CLK_APB0_USART0_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB0_USART0_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB2_SSP1_CFG: CLK_APB2_SSP1 clock configuration register
	// Position of RUN field.
	CCU2_CLK_APB2_SSP1_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB2_SSP1_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB2_SSP1_CFG_RUN = 0x1
	// Clock is disabled.
	CCU2_CLK_APB2_SSP1_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU2_CLK_APB2_SSP1_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB2_SSP1_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB2_SSP1_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB2_SSP1_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU2_CLK_APB2_SSP1_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU2_CLK_APB2_SSP1_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU2_CLK_APB2_SSP1_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB2_SSP1_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB2_SSP1_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU2_CLK_APB2_SSP1_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU2_CLK_APB2_SSP1_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU2_CLK_APB2_SSP1_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB2_SSP1_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB2_SSP1_STAT: CLK_APB2_SSP1 clock status register
	// Position of RUN field.
	CCU2_CLK_APB2_SSP1_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB2_SSP1_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB2_SSP1_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB2_SSP1_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB2_SSP1_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB2_SSP1_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU2_CLK_APB2_SSP1_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB2_SSP1_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB2_SSP1_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU2_CLK_APB2_SSP1_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB2_SSP1_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_APB0_SSP0_CFG: CLK_APB0_SSP0 clock configuration register
	// Position of RUN field.
	CCU2_CLK_APB0_SSP0_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB0_SSP0_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB0_SSP0_CFG_RUN = 0x1
	// Clock is disabled.
	CCU2_CLK_APB0_SSP0_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU2_CLK_APB0_SSP0_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB0_SSP0_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB0_SSP0_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB0_SSP0_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU2_CLK_APB0_SSP0_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU2_CLK_APB0_SSP0_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU2_CLK_APB0_SSP0_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB0_SSP0_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB0_SSP0_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU2_CLK_APB0_SSP0_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU2_CLK_APB0_SSP0_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU2_CLK_APB0_SSP0_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB0_SSP0_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_APB0_SSP0_STAT: CLK_APB0_SSP0 clock status register
	// Position of RUN field.
	CCU2_CLK_APB0_SSP0_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_APB0_SSP0_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_APB0_SSP0_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU2_CLK_APB0_SSP0_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_APB0_SSP0_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_APB0_SSP0_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU2_CLK_APB0_SSP0_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_APB0_SSP0_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_APB0_SSP0_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU2_CLK_APB0_SSP0_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_APB0_SSP0_STAT_RESERVED_Msk = 0xfffffff8

	// CLK_SDIO_CFG: CLK_SDIO clock configuration register
	// Position of RUN field.
	CCU2_CLK_SDIO_CFG_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_SDIO_CFG_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_SDIO_CFG_RUN = 0x1
	// Clock is disabled.
	CCU2_CLK_SDIO_CFG_RUN_DISABLED = 0x0
	// Clock is enabled.
	CCU2_CLK_SDIO_CFG_RUN_ENABLED = 0x1
	// Position of AUTO field.
	CCU2_CLK_SDIO_CFG_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_SDIO_CFG_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_SDIO_CFG_AUTO = 0x2
	// Auto is disabled.
	CCU2_CLK_SDIO_CFG_AUTO_DISABLED_ = 0x0
	// Auto is enabled.
	CCU2_CLK_SDIO_CFG_AUTO_ENABLED = 0x1
	// Position of WAKEUP field.
	CCU2_CLK_SDIO_CFG_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_SDIO_CFG_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_SDIO_CFG_WAKEUP = 0x4
	// Wake-up is disabled.
	CCU2_CLK_SDIO_CFG_WAKEUP_DISABLED = 0x0
	// Wake-up is enabled.
	CCU2_CLK_SDIO_CFG_WAKEUP_ENABLED = 0x1
	// Position of RESERVED field.
	CCU2_CLK_SDIO_CFG_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_SDIO_CFG_RESERVED_Msk = 0xfffffff8

	// CLK_SDIO_STAT: CLK_SDIO clock status register
	// Position of RUN field.
	CCU2_CLK_SDIO_STAT_RUN_Pos = 0x0
	// Bit mask of RUN field.
	CCU2_CLK_SDIO_STAT_RUN_Msk = 0x1
	// Bit RUN.
	CCU2_CLK_SDIO_STAT_RUN = 0x1
	// Position of AUTO field.
	CCU2_CLK_SDIO_STAT_AUTO_Pos = 0x1
	// Bit mask of AUTO field.
	CCU2_CLK_SDIO_STAT_AUTO_Msk = 0x2
	// Bit AUTO.
	CCU2_CLK_SDIO_STAT_AUTO = 0x2
	// Position of WAKEUP field.
	CCU2_CLK_SDIO_STAT_WAKEUP_Pos = 0x2
	// Bit mask of WAKEUP field.
	CCU2_CLK_SDIO_STAT_WAKEUP_Msk = 0x4
	// Bit WAKEUP.
	CCU2_CLK_SDIO_STAT_WAKEUP = 0x4
	// Position of RESERVED field.
	CCU2_CLK_SDIO_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CCU2_CLK_SDIO_STAT_RESERVED_Msk = 0xfffffff8
)

// Bitfields for RGU: Reset Generation Unit (RGU)
const (
	// RESET_CTRL0: Reset control register 0
	// Position of CORE_RST field.
	RGU_RESET_CTRL0_CORE_RST_Pos = 0x0
	// Bit mask of CORE_RST field.
	RGU_RESET_CTRL0_CORE_RST_Msk = 0x1
	// Bit CORE_RST.
	RGU_RESET_CTRL0_CORE_RST = 0x1
	// Position of PERIPH_RST field.
	RGU_RESET_CTRL0_PERIPH_RST_Pos = 0x1
	// Bit mask of PERIPH_RST field.
	RGU_RESET_CTRL0_PERIPH_RST_Msk = 0x2
	// Bit PERIPH_RST.
	RGU_RESET_CTRL0_PERIPH_RST = 0x2
	// Position of MASTER_RST field.
	RGU_RESET_CTRL0_MASTER_RST_Pos = 0x2
	// Bit mask of MASTER_RST field.
	RGU_RESET_CTRL0_MASTER_RST_Msk = 0x4
	// Bit MASTER_RST.
	RGU_RESET_CTRL0_MASTER_RST = 0x4
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x8
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x8
	// Position of WWDT_RST field.
	RGU_RESET_CTRL0_WWDT_RST_Pos = 0x4
	// Bit mask of WWDT_RST field.
	RGU_RESET_CTRL0_WWDT_RST_Msk = 0x10
	// Bit WWDT_RST.
	RGU_RESET_CTRL0_WWDT_RST = 0x10
	// Position of CREG_RST field.
	RGU_RESET_CTRL0_CREG_RST_Pos = 0x5
	// Bit mask of CREG_RST field.
	RGU_RESET_CTRL0_CREG_RST_Msk = 0x20
	// Bit CREG_RST.
	RGU_RESET_CTRL0_CREG_RST = 0x20
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x40
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x40
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x80
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x80
	// Position of BUS_RST field.
	RGU_RESET_CTRL0_BUS_RST_Pos = 0x8
	// Bit mask of BUS_RST field.
	RGU_RESET_CTRL0_BUS_RST_Msk = 0x100
	// Bit BUS_RST.
	RGU_RESET_CTRL0_BUS_RST = 0x100
	// Position of SCU_RST field.
	RGU_RESET_CTRL0_SCU_RST_Pos = 0x9
	// Bit mask of SCU_RST field.
	RGU_RESET_CTRL0_SCU_RST_Msk = 0x200
	// Bit SCU_RST.
	RGU_RESET_CTRL0_SCU_RST = 0x200
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x400
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x400
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x800
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x800
	// Position of M0_SUB_RST field.
	RGU_RESET_CTRL0_M0_SUB_RST_Pos = 0xc
	// Bit mask of M0_SUB_RST field.
	RGU_RESET_CTRL0_M0_SUB_RST_Msk = 0x1000
	// Bit M0_SUB_RST.
	RGU_RESET_CTRL0_M0_SUB_RST = 0x1000
	// Position of M3_RST field.
	RGU_RESET_CTRL0_M3_RST_Pos = 0xd
	// Bit mask of M3_RST field.
	RGU_RESET_CTRL0_M3_RST_Msk = 0x2000
	// Bit M3_RST.
	RGU_RESET_CTRL0_M3_RST = 0x2000
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x4000
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x8000
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x8000
	// Position of LCD_RST field.
	RGU_RESET_CTRL0_LCD_RST_Pos = 0x10
	// Bit mask of LCD_RST field.
	RGU_RESET_CTRL0_LCD_RST_Msk = 0x10000
	// Bit LCD_RST.
	RGU_RESET_CTRL0_LCD_RST = 0x10000
	// Position of USB0_RST field.
	RGU_RESET_CTRL0_USB0_RST_Pos = 0x11
	// Bit mask of USB0_RST field.
	RGU_RESET_CTRL0_USB0_RST_Msk = 0x20000
	// Bit USB0_RST.
	RGU_RESET_CTRL0_USB0_RST = 0x20000
	// Position of USB1_RST field.
	RGU_RESET_CTRL0_USB1_RST_Pos = 0x12
	// Bit mask of USB1_RST field.
	RGU_RESET_CTRL0_USB1_RST_Msk = 0x40000
	// Bit USB1_RST.
	RGU_RESET_CTRL0_USB1_RST = 0x40000
	// Position of DMA_RST field.
	RGU_RESET_CTRL0_DMA_RST_Pos = 0x13
	// Bit mask of DMA_RST field.
	RGU_RESET_CTRL0_DMA_RST_Msk = 0x80000
	// Bit DMA_RST.
	RGU_RESET_CTRL0_DMA_RST = 0x80000
	// Position of SDIO_RST field.
	RGU_RESET_CTRL0_SDIO_RST_Pos = 0x14
	// Bit mask of SDIO_RST field.
	RGU_RESET_CTRL0_SDIO_RST_Msk = 0x100000
	// Bit SDIO_RST.
	RGU_RESET_CTRL0_SDIO_RST = 0x100000
	// Position of EMC_RST field.
	RGU_RESET_CTRL0_EMC_RST_Pos = 0x15
	// Bit mask of EMC_RST field.
	RGU_RESET_CTRL0_EMC_RST_Msk = 0x200000
	// Bit EMC_RST.
	RGU_RESET_CTRL0_EMC_RST = 0x200000
	// Position of ETHERNET_RST field.
	RGU_RESET_CTRL0_ETHERNET_RST_Pos = 0x16
	// Bit mask of ETHERNET_RST field.
	RGU_RESET_CTRL0_ETHERNET_RST_Msk = 0x400000
	// Bit ETHERNET_RST.
	RGU_RESET_CTRL0_ETHERNET_RST = 0x400000
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x800000
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x1000000
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x1000000
	// Position of FLASHA_RST field.
	RGU_RESET_CTRL0_FLASHA_RST_Pos = 0x19
	// Bit mask of FLASHA_RST field.
	RGU_RESET_CTRL0_FLASHA_RST_Msk = 0x2000000
	// Bit FLASHA_RST.
	RGU_RESET_CTRL0_FLASHA_RST = 0x2000000
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x4000000
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x4000000
	// Position of EEPROM_RST field.
	RGU_RESET_CTRL0_EEPROM_RST_Pos = 0x1b
	// Bit mask of EEPROM_RST field.
	RGU_RESET_CTRL0_EEPROM_RST_Msk = 0x8000000
	// Bit EEPROM_RST.
	RGU_RESET_CTRL0_EEPROM_RST = 0x8000000
	// Position of GPIO_RST field.
	RGU_RESET_CTRL0_GPIO_RST_Pos = 0x1c
	// Bit mask of GPIO_RST field.
	RGU_RESET_CTRL0_GPIO_RST_Msk = 0x10000000
	// Bit GPIO_RST.
	RGU_RESET_CTRL0_GPIO_RST = 0x10000000
	// Position of FLASHB_RST field.
	RGU_RESET_CTRL0_FLASHB_RST_Pos = 0x1d
	// Bit mask of FLASHB_RST field.
	RGU_RESET_CTRL0_FLASHB_RST_Msk = 0x20000000
	// Bit FLASHB_RST.
	RGU_RESET_CTRL0_FLASHB_RST = 0x20000000
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x40000000
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x40000000
	// Position of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL0_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	RGU_RESET_CTRL0_RESERVED = 0x80000000

	// RESET_CTRL1: Reset control register 1
	// Position of TIMER0_RST field.
	RGU_RESET_CTRL1_TIMER0_RST_Pos = 0x0
	// Bit mask of TIMER0_RST field.
	RGU_RESET_CTRL1_TIMER0_RST_Msk = 0x1
	// Bit TIMER0_RST.
	RGU_RESET_CTRL1_TIMER0_RST = 0x1
	// Position of TIMER1_RST field.
	RGU_RESET_CTRL1_TIMER1_RST_Pos = 0x1
	// Bit mask of TIMER1_RST field.
	RGU_RESET_CTRL1_TIMER1_RST_Msk = 0x2
	// Bit TIMER1_RST.
	RGU_RESET_CTRL1_TIMER1_RST = 0x2
	// Position of TIMER2_RST field.
	RGU_RESET_CTRL1_TIMER2_RST_Pos = 0x2
	// Bit mask of TIMER2_RST field.
	RGU_RESET_CTRL1_TIMER2_RST_Msk = 0x4
	// Bit TIMER2_RST.
	RGU_RESET_CTRL1_TIMER2_RST = 0x4
	// Position of TIMER3_RST field.
	RGU_RESET_CTRL1_TIMER3_RST_Pos = 0x3
	// Bit mask of TIMER3_RST field.
	RGU_RESET_CTRL1_TIMER3_RST_Msk = 0x8
	// Bit TIMER3_RST.
	RGU_RESET_CTRL1_TIMER3_RST = 0x8
	// Position of RITIMER_RST field.
	RGU_RESET_CTRL1_RITIMER_RST_Pos = 0x4
	// Bit mask of RITIMER_RST field.
	RGU_RESET_CTRL1_RITIMER_RST_Msk = 0x10
	// Bit RITIMER_RST.
	RGU_RESET_CTRL1_RITIMER_RST = 0x10
	// Position of SCT_RST field.
	RGU_RESET_CTRL1_SCT_RST_Pos = 0x5
	// Bit mask of SCT_RST field.
	RGU_RESET_CTRL1_SCT_RST_Msk = 0x20
	// Bit SCT_RST.
	RGU_RESET_CTRL1_SCT_RST = 0x20
	// Position of MOTOCONPWM_RST field.
	RGU_RESET_CTRL1_MOTOCONPWM_RST_Pos = 0x6
	// Bit mask of MOTOCONPWM_RST field.
	RGU_RESET_CTRL1_MOTOCONPWM_RST_Msk = 0x40
	// Bit MOTOCONPWM_RST.
	RGU_RESET_CTRL1_MOTOCONPWM_RST = 0x40
	// Position of QEI_RST field.
	RGU_RESET_CTRL1_QEI_RST_Pos = 0x7
	// Bit mask of QEI_RST field.
	RGU_RESET_CTRL1_QEI_RST_Msk = 0x80
	// Bit QEI_RST.
	RGU_RESET_CTRL1_QEI_RST = 0x80
	// Position of ADC0_RST field.
	RGU_RESET_CTRL1_ADC0_RST_Pos = 0x8
	// Bit mask of ADC0_RST field.
	RGU_RESET_CTRL1_ADC0_RST_Msk = 0x100
	// Bit ADC0_RST.
	RGU_RESET_CTRL1_ADC0_RST = 0x100
	// Position of ADC1_RST field.
	RGU_RESET_CTRL1_ADC1_RST_Pos = 0x9
	// Bit mask of ADC1_RST field.
	RGU_RESET_CTRL1_ADC1_RST_Msk = 0x200
	// Bit ADC1_RST.
	RGU_RESET_CTRL1_ADC1_RST = 0x200
	// Position of DAC_RST field.
	RGU_RESET_CTRL1_DAC_RST_Pos = 0xa
	// Bit mask of DAC_RST field.
	RGU_RESET_CTRL1_DAC_RST_Msk = 0x400
	// Bit DAC_RST.
	RGU_RESET_CTRL1_DAC_RST = 0x400
	// Position of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Msk = 0x800
	// Bit RESERVED.
	RGU_RESET_CTRL1_RESERVED = 0x800
	// Position of UART0_RST field.
	RGU_RESET_CTRL1_UART0_RST_Pos = 0xc
	// Bit mask of UART0_RST field.
	RGU_RESET_CTRL1_UART0_RST_Msk = 0x1000
	// Bit UART0_RST.
	RGU_RESET_CTRL1_UART0_RST = 0x1000
	// Position of UART1_RST field.
	RGU_RESET_CTRL1_UART1_RST_Pos = 0xd
	// Bit mask of UART1_RST field.
	RGU_RESET_CTRL1_UART1_RST_Msk = 0x2000
	// Bit UART1_RST.
	RGU_RESET_CTRL1_UART1_RST = 0x2000
	// Position of UART2_RST field.
	RGU_RESET_CTRL1_UART2_RST_Pos = 0xe
	// Bit mask of UART2_RST field.
	RGU_RESET_CTRL1_UART2_RST_Msk = 0x4000
	// Bit UART2_RST.
	RGU_RESET_CTRL1_UART2_RST = 0x4000
	// Position of UART3_RST field.
	RGU_RESET_CTRL1_UART3_RST_Pos = 0xf
	// Bit mask of UART3_RST field.
	RGU_RESET_CTRL1_UART3_RST_Msk = 0x8000
	// Bit UART3_RST.
	RGU_RESET_CTRL1_UART3_RST = 0x8000
	// Position of I2C0_RST field.
	RGU_RESET_CTRL1_I2C0_RST_Pos = 0x10
	// Bit mask of I2C0_RST field.
	RGU_RESET_CTRL1_I2C0_RST_Msk = 0x10000
	// Bit I2C0_RST.
	RGU_RESET_CTRL1_I2C0_RST = 0x10000
	// Position of I2C1_RST field.
	RGU_RESET_CTRL1_I2C1_RST_Pos = 0x11
	// Bit mask of I2C1_RST field.
	RGU_RESET_CTRL1_I2C1_RST_Msk = 0x20000
	// Bit I2C1_RST.
	RGU_RESET_CTRL1_I2C1_RST = 0x20000
	// Position of SSP0_RST field.
	RGU_RESET_CTRL1_SSP0_RST_Pos = 0x12
	// Bit mask of SSP0_RST field.
	RGU_RESET_CTRL1_SSP0_RST_Msk = 0x40000
	// Bit SSP0_RST.
	RGU_RESET_CTRL1_SSP0_RST = 0x40000
	// Position of SSP1_RST field.
	RGU_RESET_CTRL1_SSP1_RST_Pos = 0x13
	// Bit mask of SSP1_RST field.
	RGU_RESET_CTRL1_SSP1_RST_Msk = 0x80000
	// Bit SSP1_RST.
	RGU_RESET_CTRL1_SSP1_RST = 0x80000
	// Position of I2S_RST field.
	RGU_RESET_CTRL1_I2S_RST_Pos = 0x14
	// Bit mask of I2S_RST field.
	RGU_RESET_CTRL1_I2S_RST_Msk = 0x100000
	// Bit I2S_RST.
	RGU_RESET_CTRL1_I2S_RST = 0x100000
	// Position of SPIFI_RST field.
	RGU_RESET_CTRL1_SPIFI_RST_Pos = 0x15
	// Bit mask of SPIFI_RST field.
	RGU_RESET_CTRL1_SPIFI_RST_Msk = 0x200000
	// Bit SPIFI_RST.
	RGU_RESET_CTRL1_SPIFI_RST = 0x200000
	// Position of CAN1_RST field.
	RGU_RESET_CTRL1_CAN1_RST_Pos = 0x16
	// Bit mask of CAN1_RST field.
	RGU_RESET_CTRL1_CAN1_RST_Msk = 0x400000
	// Bit CAN1_RST.
	RGU_RESET_CTRL1_CAN1_RST = 0x400000
	// Position of CAN0_RST field.
	RGU_RESET_CTRL1_CAN0_RST_Pos = 0x17
	// Bit mask of CAN0_RST field.
	RGU_RESET_CTRL1_CAN0_RST_Msk = 0x800000
	// Bit CAN0_RST.
	RGU_RESET_CTRL1_CAN0_RST = 0x800000
	// Position of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Msk = 0x1000000
	// Bit RESERVED.
	RGU_RESET_CTRL1_RESERVED = 0x1000000
	// Position of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Msk = 0xe000000
	// Position of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Msk = 0x10000000
	// Bit RESERVED.
	RGU_RESET_CTRL1_RESERVED = 0x10000000
	// Position of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Msk = 0x20000000
	// Bit RESERVED.
	RGU_RESET_CTRL1_RESERVED = 0x20000000
	// Position of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Msk = 0x40000000
	// Bit RESERVED.
	RGU_RESET_CTRL1_RESERVED = 0x40000000
	// Position of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	RGU_RESET_CTRL1_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	RGU_RESET_CTRL1_RESERVED = 0x80000000

	// RESET_STATUS0: Reset status register 0
	// Position of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Msk = 0x3
	// Position of PERIPH_RST field.
	RGU_RESET_STATUS0_PERIPH_RST_Pos = 0x2
	// Bit mask of PERIPH_RST field.
	RGU_RESET_STATUS0_PERIPH_RST_Msk = 0xc
	// Position of MASTER_RST field.
	RGU_RESET_STATUS0_MASTER_RST_Pos = 0x4
	// Bit mask of MASTER_RST field.
	RGU_RESET_STATUS0_MASTER_RST_Msk = 0x30
	// Position of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Msk = 0xc0
	// Position of WWDT_RST field.
	RGU_RESET_STATUS0_WWDT_RST_Pos = 0x8
	// Bit mask of WWDT_RST field.
	RGU_RESET_STATUS0_WWDT_RST_Msk = 0x300
	// Position of CREG_RST field.
	RGU_RESET_STATUS0_CREG_RST_Pos = 0xa
	// Bit mask of CREG_RST field.
	RGU_RESET_STATUS0_CREG_RST_Msk = 0xc00
	// Position of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Msk = 0x3000
	// Position of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Msk = 0xc000
	// Position of BUS_RST field.
	RGU_RESET_STATUS0_BUS_RST_Pos = 0x10
	// Bit mask of BUS_RST field.
	RGU_RESET_STATUS0_BUS_RST_Msk = 0x30000
	// Position of SCU_RST field.
	RGU_RESET_STATUS0_SCU_RST_Pos = 0x12
	// Bit mask of SCU_RST field.
	RGU_RESET_STATUS0_SCU_RST_Msk = 0xc0000
	// Position of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Msk = 0x300000
	// Position of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Msk = 0xc00000
	// Position of M0SUB_RST field.
	RGU_RESET_STATUS0_M0SUB_RST_Pos = 0x18
	// Bit mask of M0SUB_RST field.
	RGU_RESET_STATUS0_M0SUB_RST_Msk = 0x3000000
	// Position of M3_RST field.
	RGU_RESET_STATUS0_M3_RST_Pos = 0x1a
	// Bit mask of M3_RST field.
	RGU_RESET_STATUS0_M3_RST_Msk = 0xc000000
	// Position of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Msk = 0x30000000
	// Position of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS0_RESERVED_Msk = 0xc0000000

	// RESET_STATUS1: Reset status register 1
	// Position of LCD_RST field.
	RGU_RESET_STATUS1_LCD_RST_Pos = 0x0
	// Bit mask of LCD_RST field.
	RGU_RESET_STATUS1_LCD_RST_Msk = 0x3
	// Position of USB0_RST field.
	RGU_RESET_STATUS1_USB0_RST_Pos = 0x2
	// Bit mask of USB0_RST field.
	RGU_RESET_STATUS1_USB0_RST_Msk = 0xc
	// Position of USB1_RST field.
	RGU_RESET_STATUS1_USB1_RST_Pos = 0x4
	// Bit mask of USB1_RST field.
	RGU_RESET_STATUS1_USB1_RST_Msk = 0x30
	// Position of DMA_RST field.
	RGU_RESET_STATUS1_DMA_RST_Pos = 0x6
	// Bit mask of DMA_RST field.
	RGU_RESET_STATUS1_DMA_RST_Msk = 0xc0
	// Position of SDIO_RST field.
	RGU_RESET_STATUS1_SDIO_RST_Pos = 0x8
	// Bit mask of SDIO_RST field.
	RGU_RESET_STATUS1_SDIO_RST_Msk = 0x300
	// Position of EMC_RST field.
	RGU_RESET_STATUS1_EMC_RST_Pos = 0xa
	// Bit mask of EMC_RST field.
	RGU_RESET_STATUS1_EMC_RST_Msk = 0xc00
	// Position of ETHERNET_RST field.
	RGU_RESET_STATUS1_ETHERNET_RST_Pos = 0xc
	// Bit mask of ETHERNET_RST field.
	RGU_RESET_STATUS1_ETHERNET_RST_Msk = 0x3000
	// Position of RESERVED field.
	RGU_RESET_STATUS1_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS1_RESERVED_Msk = 0xc000
	// Position of RESERVED field.
	RGU_RESET_STATUS1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS1_RESERVED_Msk = 0x30000
	// Position of FLASHA_RST field.
	RGU_RESET_STATUS1_FLASHA_RST_Pos = 0x12
	// Bit mask of FLASHA_RST field.
	RGU_RESET_STATUS1_FLASHA_RST_Msk = 0xc0000
	// Position of RESERVED field.
	RGU_RESET_STATUS1_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS1_RESERVED_Msk = 0x300000
	// Position of EEPROM_RST field.
	RGU_RESET_STATUS1_EEPROM_RST_Pos = 0x16
	// Bit mask of EEPROM_RST field.
	RGU_RESET_STATUS1_EEPROM_RST_Msk = 0xc00000
	// Position of GPIO_RST field.
	RGU_RESET_STATUS1_GPIO_RST_Pos = 0x18
	// Bit mask of GPIO_RST field.
	RGU_RESET_STATUS1_GPIO_RST_Msk = 0x3000000
	// Position of FLASHB_RST field.
	RGU_RESET_STATUS1_FLASHB_RST_Pos = 0x1a
	// Bit mask of FLASHB_RST field.
	RGU_RESET_STATUS1_FLASHB_RST_Msk = 0xc000000
	// Position of RESERVED field.
	RGU_RESET_STATUS1_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS1_RESERVED_Msk = 0x30000000
	// Position of RESERVED field.
	RGU_RESET_STATUS1_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS1_RESERVED_Msk = 0xc0000000

	// RESET_STATUS2: Reset status register 2
	// Position of TIMER0_RST field.
	RGU_RESET_STATUS2_TIMER0_RST_Pos = 0x0
	// Bit mask of TIMER0_RST field.
	RGU_RESET_STATUS2_TIMER0_RST_Msk = 0x3
	// Position of TIMER1_RST field.
	RGU_RESET_STATUS2_TIMER1_RST_Pos = 0x2
	// Bit mask of TIMER1_RST field.
	RGU_RESET_STATUS2_TIMER1_RST_Msk = 0xc
	// Position of TIMER2_RST field.
	RGU_RESET_STATUS2_TIMER2_RST_Pos = 0x4
	// Bit mask of TIMER2_RST field.
	RGU_RESET_STATUS2_TIMER2_RST_Msk = 0x30
	// Position of TIMER3_RST field.
	RGU_RESET_STATUS2_TIMER3_RST_Pos = 0x6
	// Bit mask of TIMER3_RST field.
	RGU_RESET_STATUS2_TIMER3_RST_Msk = 0xc0
	// Position of RITIMER_RST field.
	RGU_RESET_STATUS2_RITIMER_RST_Pos = 0x8
	// Bit mask of RITIMER_RST field.
	RGU_RESET_STATUS2_RITIMER_RST_Msk = 0x300
	// Position of SCT_RST field.
	RGU_RESET_STATUS2_SCT_RST_Pos = 0xa
	// Bit mask of SCT_RST field.
	RGU_RESET_STATUS2_SCT_RST_Msk = 0xc00
	// Position of MOTOCONPWM_RST field.
	RGU_RESET_STATUS2_MOTOCONPWM_RST_Pos = 0xc
	// Bit mask of MOTOCONPWM_RST field.
	RGU_RESET_STATUS2_MOTOCONPWM_RST_Msk = 0x3000
	// Position of QEI_RST field.
	RGU_RESET_STATUS2_QEI_RST_Pos = 0xe
	// Bit mask of QEI_RST field.
	RGU_RESET_STATUS2_QEI_RST_Msk = 0xc000
	// Position of ADC0_RST field.
	RGU_RESET_STATUS2_ADC0_RST_Pos = 0x10
	// Bit mask of ADC0_RST field.
	RGU_RESET_STATUS2_ADC0_RST_Msk = 0x30000
	// Position of ADC1_RST field.
	RGU_RESET_STATUS2_ADC1_RST_Pos = 0x12
	// Bit mask of ADC1_RST field.
	RGU_RESET_STATUS2_ADC1_RST_Msk = 0xc0000
	// Position of DAC_RST field.
	RGU_RESET_STATUS2_DAC_RST_Pos = 0x14
	// Bit mask of DAC_RST field.
	RGU_RESET_STATUS2_DAC_RST_Msk = 0x300000
	// Position of RESERVED field.
	RGU_RESET_STATUS2_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS2_RESERVED_Msk = 0xc00000
	// Position of UART0_RST field.
	RGU_RESET_STATUS2_UART0_RST_Pos = 0x18
	// Bit mask of UART0_RST field.
	RGU_RESET_STATUS2_UART0_RST_Msk = 0x3000000
	// Position of UART1_RST field.
	RGU_RESET_STATUS2_UART1_RST_Pos = 0x1a
	// Bit mask of UART1_RST field.
	RGU_RESET_STATUS2_UART1_RST_Msk = 0xc000000
	// Position of UART2_RST field.
	RGU_RESET_STATUS2_UART2_RST_Pos = 0x1c
	// Bit mask of UART2_RST field.
	RGU_RESET_STATUS2_UART2_RST_Msk = 0x30000000
	// Position of UART3_RST field.
	RGU_RESET_STATUS2_UART3_RST_Pos = 0x1e
	// Bit mask of UART3_RST field.
	RGU_RESET_STATUS2_UART3_RST_Msk = 0xc0000000

	// RESET_STATUS3: Reset status register 3
	// Position of I2C0_RST field.
	RGU_RESET_STATUS3_I2C0_RST_Pos = 0x0
	// Bit mask of I2C0_RST field.
	RGU_RESET_STATUS3_I2C0_RST_Msk = 0x3
	// Position of I2C1_RST field.
	RGU_RESET_STATUS3_I2C1_RST_Pos = 0x2
	// Bit mask of I2C1_RST field.
	RGU_RESET_STATUS3_I2C1_RST_Msk = 0xc
	// Position of SSP0_RST field.
	RGU_RESET_STATUS3_SSP0_RST_Pos = 0x4
	// Bit mask of SSP0_RST field.
	RGU_RESET_STATUS3_SSP0_RST_Msk = 0x30
	// Position of SSP1_RST field.
	RGU_RESET_STATUS3_SSP1_RST_Pos = 0x6
	// Bit mask of SSP1_RST field.
	RGU_RESET_STATUS3_SSP1_RST_Msk = 0xc0
	// Position of I2S_RST field.
	RGU_RESET_STATUS3_I2S_RST_Pos = 0x8
	// Bit mask of I2S_RST field.
	RGU_RESET_STATUS3_I2S_RST_Msk = 0x300
	// Position of SPIFI_RST field.
	RGU_RESET_STATUS3_SPIFI_RST_Pos = 0xa
	// Bit mask of SPIFI_RST field.
	RGU_RESET_STATUS3_SPIFI_RST_Msk = 0xc00
	// Position of CAN1_RST field.
	RGU_RESET_STATUS3_CAN1_RST_Pos = 0xc
	// Bit mask of CAN1_RST field.
	RGU_RESET_STATUS3_CAN1_RST_Msk = 0x3000
	// Position of CAN0_RST field.
	RGU_RESET_STATUS3_CAN0_RST_Pos = 0xe
	// Bit mask of CAN0_RST field.
	RGU_RESET_STATUS3_CAN0_RST_Msk = 0xc000
	// Position of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Msk = 0x30000
	// Position of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Msk = 0xfc0000
	// Position of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Msk = 0x3000000
	// Position of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Msk = 0xc000000
	// Position of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Msk = 0x30000000
	// Position of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	RGU_RESET_STATUS3_RESERVED_Msk = 0xc0000000

	// RESET_ACTIVE_STATUS0: Reset active status register 0
	// Position of CORE_RST field.
	RGU_RESET_ACTIVE_STATUS0_CORE_RST_Pos = 0x0
	// Bit mask of CORE_RST field.
	RGU_RESET_ACTIVE_STATUS0_CORE_RST_Msk = 0x1
	// Bit CORE_RST.
	RGU_RESET_ACTIVE_STATUS0_CORE_RST = 0x1
	// Position of PERIPH_RST field.
	RGU_RESET_ACTIVE_STATUS0_PERIPH_RST_Pos = 0x1
	// Bit mask of PERIPH_RST field.
	RGU_RESET_ACTIVE_STATUS0_PERIPH_RST_Msk = 0x2
	// Bit PERIPH_RST.
	RGU_RESET_ACTIVE_STATUS0_PERIPH_RST = 0x2
	// Position of MASTER_RST field.
	RGU_RESET_ACTIVE_STATUS0_MASTER_RST_Pos = 0x2
	// Bit mask of MASTER_RST field.
	RGU_RESET_ACTIVE_STATUS0_MASTER_RST_Msk = 0x4
	// Bit MASTER_RST.
	RGU_RESET_ACTIVE_STATUS0_MASTER_RST = 0x4
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x8
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x8
	// Position of WWDT_RST field.
	RGU_RESET_ACTIVE_STATUS0_WWDT_RST_Pos = 0x4
	// Bit mask of WWDT_RST field.
	RGU_RESET_ACTIVE_STATUS0_WWDT_RST_Msk = 0x10
	// Bit WWDT_RST.
	RGU_RESET_ACTIVE_STATUS0_WWDT_RST = 0x10
	// Position of CREG_RST field.
	RGU_RESET_ACTIVE_STATUS0_CREG_RST_Pos = 0x5
	// Bit mask of CREG_RST field.
	RGU_RESET_ACTIVE_STATUS0_CREG_RST_Msk = 0x20
	// Bit CREG_RST.
	RGU_RESET_ACTIVE_STATUS0_CREG_RST = 0x20
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x40
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x40
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x80
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x80
	// Position of BUS_RST field.
	RGU_RESET_ACTIVE_STATUS0_BUS_RST_Pos = 0x8
	// Bit mask of BUS_RST field.
	RGU_RESET_ACTIVE_STATUS0_BUS_RST_Msk = 0x100
	// Bit BUS_RST.
	RGU_RESET_ACTIVE_STATUS0_BUS_RST = 0x100
	// Position of SCU_RST field.
	RGU_RESET_ACTIVE_STATUS0_SCU_RST_Pos = 0x9
	// Bit mask of SCU_RST field.
	RGU_RESET_ACTIVE_STATUS0_SCU_RST_Msk = 0x200
	// Bit SCU_RST.
	RGU_RESET_ACTIVE_STATUS0_SCU_RST = 0x200
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x400
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x400
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x800
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x800
	// Position of M0SUB_RST field.
	RGU_RESET_ACTIVE_STATUS0_M0SUB_RST_Pos = 0xc
	// Bit mask of M0SUB_RST field.
	RGU_RESET_ACTIVE_STATUS0_M0SUB_RST_Msk = 0x1000
	// Bit M0SUB_RST.
	RGU_RESET_ACTIVE_STATUS0_M0SUB_RST = 0x1000
	// Position of M3_RST field.
	RGU_RESET_ACTIVE_STATUS0_M3_RST_Pos = 0xd
	// Bit mask of M3_RST field.
	RGU_RESET_ACTIVE_STATUS0_M3_RST_Msk = 0x2000
	// Bit M3_RST.
	RGU_RESET_ACTIVE_STATUS0_M3_RST = 0x2000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x4000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x8000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x8000
	// Position of LCD_RST field.
	RGU_RESET_ACTIVE_STATUS0_LCD_RST_Pos = 0x10
	// Bit mask of LCD_RST field.
	RGU_RESET_ACTIVE_STATUS0_LCD_RST_Msk = 0x10000
	// Bit LCD_RST.
	RGU_RESET_ACTIVE_STATUS0_LCD_RST = 0x10000
	// Position of USB0_RST field.
	RGU_RESET_ACTIVE_STATUS0_USB0_RST_Pos = 0x11
	// Bit mask of USB0_RST field.
	RGU_RESET_ACTIVE_STATUS0_USB0_RST_Msk = 0x20000
	// Bit USB0_RST.
	RGU_RESET_ACTIVE_STATUS0_USB0_RST = 0x20000
	// Position of USB1_RST field.
	RGU_RESET_ACTIVE_STATUS0_USB1_RST_Pos = 0x12
	// Bit mask of USB1_RST field.
	RGU_RESET_ACTIVE_STATUS0_USB1_RST_Msk = 0x40000
	// Bit USB1_RST.
	RGU_RESET_ACTIVE_STATUS0_USB1_RST = 0x40000
	// Position of DMA_RST field.
	RGU_RESET_ACTIVE_STATUS0_DMA_RST_Pos = 0x13
	// Bit mask of DMA_RST field.
	RGU_RESET_ACTIVE_STATUS0_DMA_RST_Msk = 0x80000
	// Bit DMA_RST.
	RGU_RESET_ACTIVE_STATUS0_DMA_RST = 0x80000
	// Position of SDIO_RST field.
	RGU_RESET_ACTIVE_STATUS0_SDIO_RST_Pos = 0x14
	// Bit mask of SDIO_RST field.
	RGU_RESET_ACTIVE_STATUS0_SDIO_RST_Msk = 0x100000
	// Bit SDIO_RST.
	RGU_RESET_ACTIVE_STATUS0_SDIO_RST = 0x100000
	// Position of EMC_RST field.
	RGU_RESET_ACTIVE_STATUS0_EMC_RST_Pos = 0x15
	// Bit mask of EMC_RST field.
	RGU_RESET_ACTIVE_STATUS0_EMC_RST_Msk = 0x200000
	// Bit EMC_RST.
	RGU_RESET_ACTIVE_STATUS0_EMC_RST = 0x200000
	// Position of ETHERNET_RST field.
	RGU_RESET_ACTIVE_STATUS0_ETHERNET_RST_Pos = 0x16
	// Bit mask of ETHERNET_RST field.
	RGU_RESET_ACTIVE_STATUS0_ETHERNET_RST_Msk = 0x400000
	// Bit ETHERNET_RST.
	RGU_RESET_ACTIVE_STATUS0_ETHERNET_RST = 0x400000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x800000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x1000000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x1000000
	// Position of FLASHA_RST field.
	RGU_RESET_ACTIVE_STATUS0_FLASHA_RST_Pos = 0x19
	// Bit mask of FLASHA_RST field.
	RGU_RESET_ACTIVE_STATUS0_FLASHA_RST_Msk = 0x2000000
	// Bit FLASHA_RST.
	RGU_RESET_ACTIVE_STATUS0_FLASHA_RST = 0x2000000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x4000000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x4000000
	// Position of EEPROM_RST field.
	RGU_RESET_ACTIVE_STATUS0_EEPROM_RST_Pos = 0x1b
	// Bit mask of EEPROM_RST field.
	RGU_RESET_ACTIVE_STATUS0_EEPROM_RST_Msk = 0x8000000
	// Bit EEPROM_RST.
	RGU_RESET_ACTIVE_STATUS0_EEPROM_RST = 0x8000000
	// Position of GPIO_RST field.
	RGU_RESET_ACTIVE_STATUS0_GPIO_RST_Pos = 0x1c
	// Bit mask of GPIO_RST field.
	RGU_RESET_ACTIVE_STATUS0_GPIO_RST_Msk = 0x10000000
	// Bit GPIO_RST.
	RGU_RESET_ACTIVE_STATUS0_GPIO_RST = 0x10000000
	// Position of FLASHB_RST field.
	RGU_RESET_ACTIVE_STATUS0_FLASHB_RST_Pos = 0x1d
	// Bit mask of FLASHB_RST field.
	RGU_RESET_ACTIVE_STATUS0_FLASHB_RST_Msk = 0x20000000
	// Bit FLASHB_RST.
	RGU_RESET_ACTIVE_STATUS0_FLASHB_RST = 0x20000000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x40000000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x40000000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS0_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS0_RESERVED = 0x80000000

	// RESET_ACTIVE_STATUS1: Reset active status register 1
	// Position of TIMER0_RST field.
	RGU_RESET_ACTIVE_STATUS1_TIMER0_RST_Pos = 0x0
	// Bit mask of TIMER0_RST field.
	RGU_RESET_ACTIVE_STATUS1_TIMER0_RST_Msk = 0x1
	// Bit TIMER0_RST.
	RGU_RESET_ACTIVE_STATUS1_TIMER0_RST = 0x1
	// Position of TIMER1_RST field.
	RGU_RESET_ACTIVE_STATUS1_TIMER1_RST_Pos = 0x1
	// Bit mask of TIMER1_RST field.
	RGU_RESET_ACTIVE_STATUS1_TIMER1_RST_Msk = 0x2
	// Bit TIMER1_RST.
	RGU_RESET_ACTIVE_STATUS1_TIMER1_RST = 0x2
	// Position of TIMER2_RST field.
	RGU_RESET_ACTIVE_STATUS1_TIMER2_RST_Pos = 0x2
	// Bit mask of TIMER2_RST field.
	RGU_RESET_ACTIVE_STATUS1_TIMER2_RST_Msk = 0x4
	// Bit TIMER2_RST.
	RGU_RESET_ACTIVE_STATUS1_TIMER2_RST = 0x4
	// Position of TIMER3_RST field.
	RGU_RESET_ACTIVE_STATUS1_TIMER3_RST_Pos = 0x3
	// Bit mask of TIMER3_RST field.
	RGU_RESET_ACTIVE_STATUS1_TIMER3_RST_Msk = 0x8
	// Bit TIMER3_RST.
	RGU_RESET_ACTIVE_STATUS1_TIMER3_RST = 0x8
	// Position of RITIMER_RST field.
	RGU_RESET_ACTIVE_STATUS1_RITIMER_RST_Pos = 0x4
	// Bit mask of RITIMER_RST field.
	RGU_RESET_ACTIVE_STATUS1_RITIMER_RST_Msk = 0x10
	// Bit RITIMER_RST.
	RGU_RESET_ACTIVE_STATUS1_RITIMER_RST = 0x10
	// Position of SCT_RST field.
	RGU_RESET_ACTIVE_STATUS1_SCT_RST_Pos = 0x5
	// Bit mask of SCT_RST field.
	RGU_RESET_ACTIVE_STATUS1_SCT_RST_Msk = 0x20
	// Bit SCT_RST.
	RGU_RESET_ACTIVE_STATUS1_SCT_RST = 0x20
	// Position of MOTOCONPWM_RST field.
	RGU_RESET_ACTIVE_STATUS1_MOTOCONPWM_RST_Pos = 0x6
	// Bit mask of MOTOCONPWM_RST field.
	RGU_RESET_ACTIVE_STATUS1_MOTOCONPWM_RST_Msk = 0x40
	// Bit MOTOCONPWM_RST.
	RGU_RESET_ACTIVE_STATUS1_MOTOCONPWM_RST = 0x40
	// Position of QEI_RST field.
	RGU_RESET_ACTIVE_STATUS1_QEI_RST_Pos = 0x7
	// Bit mask of QEI_RST field.
	RGU_RESET_ACTIVE_STATUS1_QEI_RST_Msk = 0x80
	// Bit QEI_RST.
	RGU_RESET_ACTIVE_STATUS1_QEI_RST = 0x80
	// Position of ADC0_RST field.
	RGU_RESET_ACTIVE_STATUS1_ADC0_RST_Pos = 0x8
	// Bit mask of ADC0_RST field.
	RGU_RESET_ACTIVE_STATUS1_ADC0_RST_Msk = 0x100
	// Bit ADC0_RST.
	RGU_RESET_ACTIVE_STATUS1_ADC0_RST = 0x100
	// Position of ADC1_RST field.
	RGU_RESET_ACTIVE_STATUS1_ADC1_RST_Pos = 0x9
	// Bit mask of ADC1_RST field.
	RGU_RESET_ACTIVE_STATUS1_ADC1_RST_Msk = 0x200
	// Bit ADC1_RST.
	RGU_RESET_ACTIVE_STATUS1_ADC1_RST = 0x200
	// Position of DAC_RST field.
	RGU_RESET_ACTIVE_STATUS1_DAC_RST_Pos = 0xa
	// Bit mask of DAC_RST field.
	RGU_RESET_ACTIVE_STATUS1_DAC_RST_Msk = 0x400
	// Bit DAC_RST.
	RGU_RESET_ACTIVE_STATUS1_DAC_RST = 0x400
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Msk = 0x800
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS1_RESERVED = 0x800
	// Position of UART0_RST field.
	RGU_RESET_ACTIVE_STATUS1_UART0_RST_Pos = 0xc
	// Bit mask of UART0_RST field.
	RGU_RESET_ACTIVE_STATUS1_UART0_RST_Msk = 0x1000
	// Bit UART0_RST.
	RGU_RESET_ACTIVE_STATUS1_UART0_RST = 0x1000
	// Position of UART1_RST field.
	RGU_RESET_ACTIVE_STATUS1_UART1_RST_Pos = 0xd
	// Bit mask of UART1_RST field.
	RGU_RESET_ACTIVE_STATUS1_UART1_RST_Msk = 0x2000
	// Bit UART1_RST.
	RGU_RESET_ACTIVE_STATUS1_UART1_RST = 0x2000
	// Position of UART2_RST field.
	RGU_RESET_ACTIVE_STATUS1_UART2_RST_Pos = 0xe
	// Bit mask of UART2_RST field.
	RGU_RESET_ACTIVE_STATUS1_UART2_RST_Msk = 0x4000
	// Bit UART2_RST.
	RGU_RESET_ACTIVE_STATUS1_UART2_RST = 0x4000
	// Position of UART3_RST field.
	RGU_RESET_ACTIVE_STATUS1_UART3_RST_Pos = 0xf
	// Bit mask of UART3_RST field.
	RGU_RESET_ACTIVE_STATUS1_UART3_RST_Msk = 0x8000
	// Bit UART3_RST.
	RGU_RESET_ACTIVE_STATUS1_UART3_RST = 0x8000
	// Position of I2C0_RST field.
	RGU_RESET_ACTIVE_STATUS1_I2C0_RST_Pos = 0x10
	// Bit mask of I2C0_RST field.
	RGU_RESET_ACTIVE_STATUS1_I2C0_RST_Msk = 0x10000
	// Bit I2C0_RST.
	RGU_RESET_ACTIVE_STATUS1_I2C0_RST = 0x10000
	// Position of I2C1_RST field.
	RGU_RESET_ACTIVE_STATUS1_I2C1_RST_Pos = 0x11
	// Bit mask of I2C1_RST field.
	RGU_RESET_ACTIVE_STATUS1_I2C1_RST_Msk = 0x20000
	// Bit I2C1_RST.
	RGU_RESET_ACTIVE_STATUS1_I2C1_RST = 0x20000
	// Position of SSP0_RST field.
	RGU_RESET_ACTIVE_STATUS1_SSP0_RST_Pos = 0x12
	// Bit mask of SSP0_RST field.
	RGU_RESET_ACTIVE_STATUS1_SSP0_RST_Msk = 0x40000
	// Bit SSP0_RST.
	RGU_RESET_ACTIVE_STATUS1_SSP0_RST = 0x40000
	// Position of SSP1_RST field.
	RGU_RESET_ACTIVE_STATUS1_SSP1_RST_Pos = 0x13
	// Bit mask of SSP1_RST field.
	RGU_RESET_ACTIVE_STATUS1_SSP1_RST_Msk = 0x80000
	// Bit SSP1_RST.
	RGU_RESET_ACTIVE_STATUS1_SSP1_RST = 0x80000
	// Position of I2S_RST field.
	RGU_RESET_ACTIVE_STATUS1_I2S_RST_Pos = 0x14
	// Bit mask of I2S_RST field.
	RGU_RESET_ACTIVE_STATUS1_I2S_RST_Msk = 0x100000
	// Bit I2S_RST.
	RGU_RESET_ACTIVE_STATUS1_I2S_RST = 0x100000
	// Position of SPIFI_RST field.
	RGU_RESET_ACTIVE_STATUS1_SPIFI_RST_Pos = 0x15
	// Bit mask of SPIFI_RST field.
	RGU_RESET_ACTIVE_STATUS1_SPIFI_RST_Msk = 0x200000
	// Bit SPIFI_RST.
	RGU_RESET_ACTIVE_STATUS1_SPIFI_RST = 0x200000
	// Position of CAN1_RST field.
	RGU_RESET_ACTIVE_STATUS1_CAN1_RST_Pos = 0x16
	// Bit mask of CAN1_RST field.
	RGU_RESET_ACTIVE_STATUS1_CAN1_RST_Msk = 0x400000
	// Bit CAN1_RST.
	RGU_RESET_ACTIVE_STATUS1_CAN1_RST = 0x400000
	// Position of CAN0_RST field.
	RGU_RESET_ACTIVE_STATUS1_CAN0_RST_Pos = 0x17
	// Bit mask of CAN0_RST field.
	RGU_RESET_ACTIVE_STATUS1_CAN0_RST_Msk = 0x800000
	// Bit CAN0_RST.
	RGU_RESET_ACTIVE_STATUS1_CAN0_RST = 0x800000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Msk = 0x1000000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS1_RESERVED = 0x1000000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Msk = 0xe000000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Msk = 0x10000000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS1_RESERVED = 0x10000000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Msk = 0x20000000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS1_RESERVED = 0x20000000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Msk = 0x40000000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS1_RESERVED = 0x40000000
	// Position of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	RGU_RESET_ACTIVE_STATUS1_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	RGU_RESET_ACTIVE_STATUS1_RESERVED = 0x80000000

	// RESET_EXT_STAT1: Reset external status register 1 for PERIPH_RST
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT1_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT1_RESERVED_Msk = 0x1
	// Bit RESERVED.
	RGU_RESET_EXT_STAT1_RESERVED = 0x1
	// Position of CORE_RESET field.
	RGU_RESET_EXT_STAT1_CORE_RESET_Pos = 0x1
	// Bit mask of CORE_RESET field.
	RGU_RESET_EXT_STAT1_CORE_RESET_Msk = 0x2
	// Bit CORE_RESET.
	RGU_RESET_EXT_STAT1_CORE_RESET = 0x2
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT1_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT1_RESERVED_Msk = 0xfffffffc

	// RESET_EXT_STAT2: Reset external status register 2 for MASTER_RST
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT2_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT2_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT2_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT2_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT2_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT2_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT2_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT5: Reset external status register 5 for CREG_RST
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT5_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT5_RESERVED_Msk = 0x1
	// Bit RESERVED.
	RGU_RESET_EXT_STAT5_RESERVED = 0x1
	// Position of CORE_RESET field.
	RGU_RESET_EXT_STAT5_CORE_RESET_Pos = 0x1
	// Bit mask of CORE_RESET field.
	RGU_RESET_EXT_STAT5_CORE_RESET_Msk = 0x2
	// Bit CORE_RESET.
	RGU_RESET_EXT_STAT5_CORE_RESET = 0x2
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT5_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT5_RESERVED_Msk = 0xfffffffc

	// RESET_EXT_STAT8: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT8_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT8_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT8_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT8_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT8_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT8_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT8_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT9: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT9_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT9_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT9_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT9_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT9_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT9_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT9_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT13: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT13_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT13_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT13_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT13_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT13_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT13_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT13_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT16: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT16_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT16_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT16_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT16_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT16_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT16_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT16_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT17: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT17_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT17_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT17_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT17_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT17_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT17_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT17_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT18: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT18_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT18_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT18_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT18_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT18_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT18_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT18_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT19: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT19_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT19_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT19_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT19_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT19_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT19_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT19_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT20: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT20_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT20_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT20_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT20_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT20_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT20_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT20_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT21: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT21_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT21_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT21_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT21_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT21_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT21_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT21_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT22: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT22_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT22_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT22_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT22_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT22_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT22_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT22_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT25: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT25_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT25_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT25_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT25_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT25_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT25_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT25_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT27: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT27_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT27_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT27_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT27_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT27_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT27_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT27_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT28: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT28_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT28_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT28_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT28_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT28_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT28_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT28_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT29: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT29_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT29_RESERVED_Msk = 0x7
	// Position of MASTER_RESET field.
	RGU_RESET_EXT_STAT29_MASTER_RESET_Pos = 0x3
	// Bit mask of MASTER_RESET field.
	RGU_RESET_EXT_STAT29_MASTER_RESET_Msk = 0x8
	// Bit MASTER_RESET.
	RGU_RESET_EXT_STAT29_MASTER_RESET = 0x8
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT29_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT29_RESERVED_Msk = 0xfffffff0

	// RESET_EXT_STAT32: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT32_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT32_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT32_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT32_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT32_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT32_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT32_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT33: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT33_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT33_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT33_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT33_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT33_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT33_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT33_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT34: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT34_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT34_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT34_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT34_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT34_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT34_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT34_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT35: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT35_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT35_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT35_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT35_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT35_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT35_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT35_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT36: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT36_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT36_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT36_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT36_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT36_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT36_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT36_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT37: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT37_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT37_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT37_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT37_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT37_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT37_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT37_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT38: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT38_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT38_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT38_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT38_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT38_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT38_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT38_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT39: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT39_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT39_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT39_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT39_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT39_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT39_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT39_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT40: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT40_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT40_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT40_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT40_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT40_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT40_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT40_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT41: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT41_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT41_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT41_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT41_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT41_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT41_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT41_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT42: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT42_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT42_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT42_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT42_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT42_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT42_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT42_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT44: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT44_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT44_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT44_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT44_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT44_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT44_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT44_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT45: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT45_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT45_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT45_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT45_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT45_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT45_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT45_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT46: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT46_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT46_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT46_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT46_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT46_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT46_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT46_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT47: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT47_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT47_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT47_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT47_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT47_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT47_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT47_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT48: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT48_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT48_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT48_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT48_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT48_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT48_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT48_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT49: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT49_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT49_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT49_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT49_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT49_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT49_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT49_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT50: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT50_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT50_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT50_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT50_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT50_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT50_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT50_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT51: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT51_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT51_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT51_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT51_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT51_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT51_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT51_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT52: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT52_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT52_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT52_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT52_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT52_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT52_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT52_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT53: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT53_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT53_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT53_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT53_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT53_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT53_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT53_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT54: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT54_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT54_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT54_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT54_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT54_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT54_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT54_RESERVED_Msk = 0xfffffff8

	// RESET_EXT_STAT55: Reset external status register
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT55_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT55_RESERVED_Msk = 0x3
	// Position of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT55_PERIPHERAL_RESET_Pos = 0x2
	// Bit mask of PERIPHERAL_RESET field.
	RGU_RESET_EXT_STAT55_PERIPHERAL_RESET_Msk = 0x4
	// Bit PERIPHERAL_RESET.
	RGU_RESET_EXT_STAT55_PERIPHERAL_RESET = 0x4
	// Position of RESERVED field.
	RGU_RESET_EXT_STAT55_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RGU_RESET_EXT_STAT55_RESERVED_Msk = 0xfffffff8
)

// Bitfields for WWDT: Windowed Watchdog timer (WWDT)
const (
	// MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
	// Position of WDEN field.
	WWDT_MOD_WDEN_Pos = 0x0
	// Bit mask of WDEN field.
	WWDT_MOD_WDEN_Msk = 0x1
	// Bit WDEN.
	WWDT_MOD_WDEN = 0x1
	// The watchdog timer is stopped.
	WWDT_MOD_WDEN_WWDTSTOPPED = 0x0
	// The watchdog timer is running.
	WWDT_MOD_WDEN_WWDTRUN = 0x1
	// Position of WDRESET field.
	WWDT_MOD_WDRESET_Pos = 0x1
	// Bit mask of WDRESET field.
	WWDT_MOD_WDRESET_Msk = 0x2
	// Bit WDRESET.
	WWDT_MOD_WDRESET = 0x2
	// A watchdog time-out will not cause a chip reset.
	WWDT_MOD_WDRESET_WWDTINT = 0x0
	// A watchdog time-out will cause a chip reset.
	WWDT_MOD_WDRESET_WWDTRESET = 0x1
	// Position of WDTOF field.
	WWDT_MOD_WDTOF_Pos = 0x2
	// Bit mask of WDTOF field.
	WWDT_MOD_WDTOF_Msk = 0x4
	// Bit WDTOF.
	WWDT_MOD_WDTOF = 0x4
	// Position of WDINT field.
	WWDT_MOD_WDINT_Pos = 0x3
	// Bit mask of WDINT field.
	WWDT_MOD_WDINT_Msk = 0x8
	// Bit WDINT.
	WWDT_MOD_WDINT = 0x8
	// Position of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Pos = 0x4
	// Bit mask of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Msk = 0x10
	// Bit WDPROTECT.
	WWDT_MOD_WDPROTECT = 0x10
	// The watchdog time-out value (WDTC) can be changed at any time.
	WWDT_MOD_WDPROTECT_NO_LOCK = 0x0
	// The watchdog time-out value (WDTC) can be changed only after the counter is below the value of WDWARNINT and WDWINDOW.
	WWDT_MOD_WDPROTECT_LOCK = 0x1
	// Position of RESERVED field.
	WWDT_MOD_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	WWDT_MOD_RESERVED_Msk = 0xe0

	// TC: Watchdog timer constant register. This register determines the time-out value.
	// Position of WDTC field.
	WWDT_TC_WDTC_Pos = 0x0
	// Bit mask of WDTC field.
	WWDT_TC_WDTC_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TC_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TC_RESERVED_Msk = 0xff000000

	// FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	// Position of Feed field.
	WWDT_FEED_Feed_Pos = 0x0
	// Bit mask of Feed field.
	WWDT_FEED_Feed_Msk = 0xff

	// TV: Watchdog timer value register. This register reads out the current value of the Watchdog timer.
	// Position of Count field.
	WWDT_TV_Count_Pos = 0x0
	// Bit mask of Count field.
	WWDT_TV_Count_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TV_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TV_RESERVED_Msk = 0xff000000

	// WARNINT: Watchdog warning interrupt register. This register contains the Watchdog warning interrupt compare value.
	// Position of WDWARNINT field.
	WWDT_WARNINT_WDWARNINT_Pos = 0x0
	// Bit mask of WDWARNINT field.
	WWDT_WARNINT_WDWARNINT_Msk = 0x3ff
	// Position of RESERVED field.
	WWDT_WARNINT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	WWDT_WARNINT_RESERVED_Msk = 0xfffffc00

	// WINDOW: Watchdog timer window register. This register contains the Watchdog window value.
	// Position of WDWINDOW field.
	WWDT_WINDOW_WDWINDOW_Pos = 0x0
	// Bit mask of WDWINDOW field.
	WWDT_WINDOW_WDWINDOW_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WINDOW_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WINDOW_RESERVED_Msk = 0xff000000
)

// Bitfields for USART0: USART0_2_3
const (
	// RBR: Receiver Buffer Register. Contains the next received character to be read (DLAB = 0).
	// Position of RBR field.
	USART_RBR_RBR_Pos = 0x0
	// Bit mask of RBR field.
	USART_RBR_RBR_Msk = 0xff
	// Position of RESERVED field.
	USART_RBR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_RBR_RESERVED_Msk = 0xffffff00

	// THR: Transmit Holding Register. The next character to be transmitted is written here (DLAB = 0).
	// Position of THR field.
	USART_THR_THR_Pos = 0x0
	// Bit mask of THR field.
	USART_THR_THR_Msk = 0xff
	// Position of RESERVED field.
	USART_THR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_THR_RESERVED_Msk = 0xffffff00

	// DLL: Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB = 1).
	// Position of DLLSB field.
	USART_DLL_DLLSB_Pos = 0x0
	// Bit mask of DLLSB field.
	USART_DLL_DLLSB_Msk = 0xff
	// Position of RESERVED field.
	USART_DLL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_DLL_RESERVED_Msk = 0xffffff00

	// DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB = 1).
	// Position of DLMSB field.
	USART_DLM_DLMSB_Pos = 0x0
	// Bit mask of DLMSB field.
	USART_DLM_DLMSB_Msk = 0xff
	// Position of RESERVED field.
	USART_DLM_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_DLM_RESERVED_Msk = 0xffffff00

	// IER: Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential USART interrupts (DLAB = 0).
	// Position of RBRIE field.
	USART_IER_RBRIE_Pos = 0x0
	// Bit mask of RBRIE field.
	USART_IER_RBRIE_Msk = 0x1
	// Bit RBRIE.
	USART_IER_RBRIE = 0x1
	// Disable. Disable the RDA interrupt.
	USART_IER_RBRIE_DISABLE = 0x0
	// Enable. Enable the RDA interrupt.
	USART_IER_RBRIE_ENABLE = 0x1
	// Position of THREIE field.
	USART_IER_THREIE_Pos = 0x1
	// Bit mask of THREIE field.
	USART_IER_THREIE_Msk = 0x2
	// Bit THREIE.
	USART_IER_THREIE = 0x2
	// Disable. Disable the THRE interrupt.
	USART_IER_THREIE_DISABLE = 0x0
	// Enable. Enable the THRE interrupt.
	USART_IER_THREIE_ENABLE = 0x1
	// Position of RXIE field.
	USART_IER_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	USART_IER_RXIE_Msk = 0x4
	// Bit RXIE.
	USART_IER_RXIE = 0x4
	// Disable. Disable the RX line status interrupts.
	USART_IER_RXIE_DISABLE = 0x0
	// Enable. Enable the RX line status interrupts.
	USART_IER_RXIE_ENABLE = 0x1
	// Position of RESERVED field.
	USART_IER_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_IER_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USART_IER_RESERVED = 0x8
	// Position of RESERVED field.
	USART_IER_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART_IER_RESERVED_Msk = 0x70
	// Position of RESERVED field.
	USART_IER_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART_IER_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART_IER_RESERVED = 0x80
	// Position of ABEOINTEN field.
	USART_IER_ABEOINTEN_Pos = 0x8
	// Bit mask of ABEOINTEN field.
	USART_IER_ABEOINTEN_Msk = 0x100
	// Bit ABEOINTEN.
	USART_IER_ABEOINTEN = 0x100
	// Disable. Disable end of auto-baud Interrupt.
	USART_IER_ABEOINTEN_DISABLE = 0x0
	// Enable. Enable end of auto-baud Interrupt.
	USART_IER_ABEOINTEN_ENABLE = 0x1
	// Position of ABTOINTEN field.
	USART_IER_ABTOINTEN_Pos = 0x9
	// Bit mask of ABTOINTEN field.
	USART_IER_ABTOINTEN_Msk = 0x200
	// Bit ABTOINTEN.
	USART_IER_ABTOINTEN = 0x200
	// Disable. Disable auto-baud time-out Interrupt.
	USART_IER_ABTOINTEN_DISABLE = 0x0
	// Enable. Enable auto-baud time-out Interrupt.
	USART_IER_ABTOINTEN_ENABLE = 0x1
	// Position of RESERVED field.
	USART_IER_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_IER_RESERVED_Msk = 0xfffffc00

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	// Position of INTSTATUS field.
	USART_IIR_INTSTATUS_Pos = 0x0
	// Bit mask of INTSTATUS field.
	USART_IIR_INTSTATUS_Msk = 0x1
	// Bit INTSTATUS.
	USART_IIR_INTSTATUS = 0x1
	// Interrupt pending. At least one interrupt is pending.
	USART_IIR_INTSTATUS_INTERRUPT_PENDING = 0x0
	// Not pending. No interrupt is pending.
	USART_IIR_INTSTATUS_NOT_PENDING = 0x1
	// Position of INTID field.
	USART_IIR_INTID_Pos = 0x1
	// Bit mask of INTID field.
	USART_IIR_INTID_Msk = 0xe
	// RLS. Priority 1 (highest). (Highest) Receive Line Status (RLS).
	USART_IIR_INTID_RLS = 0x3
	// RDA. Priority 2 - Receive Data Available (RDA).
	USART_IIR_INTID_RDA = 0x2
	// CTI. Priority 2 - Character Time-out Indicator (CTI).
	USART_IIR_INTID_CTI = 0x6
	// THRE. Priority 3 - THRE Interrupt.
	USART_IIR_INTID_THRE = 0x1
	// Position of RESERVED field.
	USART_IIR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART_IIR_RESERVED_Msk = 0x30
	// Position of FIFOENABLE field.
	USART_IIR_FIFOENABLE_Pos = 0x6
	// Bit mask of FIFOENABLE field.
	USART_IIR_FIFOENABLE_Msk = 0xc0
	// Position of ABEOINT field.
	USART_IIR_ABEOINT_Pos = 0x8
	// Bit mask of ABEOINT field.
	USART_IIR_ABEOINT_Msk = 0x100
	// Bit ABEOINT.
	USART_IIR_ABEOINT = 0x100
	// Position of ABTOINT field.
	USART_IIR_ABTOINT_Pos = 0x9
	// Bit mask of ABTOINT field.
	USART_IIR_ABTOINT_Msk = 0x200
	// Bit ABTOINT.
	USART_IIR_ABTOINT = 0x200
	// Position of RESERVED field.
	USART_IIR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_IIR_RESERVED_Msk = 0xfffffc00

	// FCR: FIFO Control Register. Controls USART FIFO usage and modes.
	// Position of FIFOEN field.
	USART_FCR_FIFOEN_Pos = 0x0
	// Bit mask of FIFOEN field.
	USART_FCR_FIFOEN_Msk = 0x1
	// Bit FIFOEN.
	USART_FCR_FIFOEN = 0x1
	// Disabled. USART FIFOs are disabled. Must not be used in the application.
	USART_FCR_FIFOEN_DISABLED = 0x0
	// Enabled. Active high enable for both USART Rx and TX FIFOs and FCR[7:1] access. This bit must be set for proper USART operation. Any transition on this bit will automatically clear the USART FIFOs.
	USART_FCR_FIFOEN_ENABLED = 0x1
	// Position of RXFIFORES field.
	USART_FCR_RXFIFORES_Pos = 0x1
	// Bit mask of RXFIFORES field.
	USART_FCR_RXFIFORES_Msk = 0x2
	// Bit RXFIFORES.
	USART_FCR_RXFIFORES = 0x2
	// No effect. No impact on either of USART FIFOs.
	USART_FCR_RXFIFORES_NO_EFFECT = 0x0
	// Clear. Writing a logic 1 to FCR[1] will clear all bytes in USART Rx FIFO, reset the pointer logic. This bit is self-clearing.
	USART_FCR_RXFIFORES_CLEAR = 0x1
	// Position of TXFIFORES field.
	USART_FCR_TXFIFORES_Pos = 0x2
	// Bit mask of TXFIFORES field.
	USART_FCR_TXFIFORES_Msk = 0x4
	// Bit TXFIFORES.
	USART_FCR_TXFIFORES = 0x4
	// No effect. No impact on either of USART FIFOs.
	USART_FCR_TXFIFORES_NO_EFFECT = 0x0
	// Clear. Writing a logic 1 to FCR[2] will clear all bytes in USART TX FIFO, reset the pointer logic. This bit is self-clearing.
	USART_FCR_TXFIFORES_CLEAR = 0x1
	// Position of DMAMODE field.
	USART_FCR_DMAMODE_Pos = 0x3
	// Bit mask of DMAMODE field.
	USART_FCR_DMAMODE_Msk = 0x8
	// Bit DMAMODE.
	USART_FCR_DMAMODE = 0x8
	// Position of RESERVED field.
	USART_FCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART_FCR_RESERVED_Msk = 0x30
	// Position of RXTRIGLVL field.
	USART_FCR_RXTRIGLVL_Pos = 0x6
	// Bit mask of RXTRIGLVL field.
	USART_FCR_RXTRIGLVL_Msk = 0xc0
	// Level 0. Trigger level 0 (1 character or 0x01).
	USART_FCR_RXTRIGLVL_LEVEL_0 = 0x0
	// Level 1. Trigger level 1 (4 characters or 0x04).
	USART_FCR_RXTRIGLVL_LEVEL_1 = 0x1
	// Level 2. Trigger level 2 (8 characters or 0x08).
	USART_FCR_RXTRIGLVL_LEVEL_2 = 0x2
	// Level 3. Trigger level 3 (14 characters or 0x0E).
	USART_FCR_RXTRIGLVL_LEVEL_3 = 0x3
	// Position of RESERVED field.
	USART_FCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_FCR_RESERVED_Msk = 0xffffff00

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	// Position of WLS field.
	USART_LCR_WLS_Pos = 0x0
	// Bit mask of WLS field.
	USART_LCR_WLS_Msk = 0x3
	// 5-bit character length.
	USART_LCR_WLS_5_BIT_CHARACTER_LENG = 0x0
	// 6-bit character length.
	USART_LCR_WLS_6_BIT_CHARACTER_LENG = 0x1
	// 7-bit character length.
	USART_LCR_WLS_7_BIT_CHARACTER_LENG = 0x2
	// 8-bit character length.
	USART_LCR_WLS_8_BIT_CHARACTER_LENG = 0x3
	// Position of SBS field.
	USART_LCR_SBS_Pos = 0x2
	// Bit mask of SBS field.
	USART_LCR_SBS_Msk = 0x4
	// Bit SBS.
	USART_LCR_SBS = 0x4
	// 1 stop bit.
	USART_LCR_SBS_1_STOP_BIT = 0x0
	// 2 stop bits (1.5 if LCR[1:0]=00).
	USART_LCR_SBS_2_STOP_BITS_1 = 0x1
	// Position of PE field.
	USART_LCR_PE_Pos = 0x3
	// Bit mask of PE field.
	USART_LCR_PE_Msk = 0x8
	// Bit PE.
	USART_LCR_PE = 0x8
	// Disable parity generation and checking.
	USART_LCR_PE_DISABLE_PARITY_GENER = 0x0
	// Enable parity generation and checking.
	USART_LCR_PE_ENABLE_PARITY_GENERA = 0x1
	// Position of PS field.
	USART_LCR_PS_Pos = 0x4
	// Bit mask of PS field.
	USART_LCR_PS_Msk = 0x30
	// Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	USART_LCR_PS_ODD_PARITY = 0x0
	// Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	USART_LCR_PS_EVEN_PARITY = 0x1
	// Force HIGH. Forced 1 stick parity.
	USART_LCR_PS_FORCE_HIGH = 0x2
	// Force LOW. Forced 0 stick parity.
	USART_LCR_PS_FORCE_LOW = 0x3
	// Position of BC field.
	USART_LCR_BC_Pos = 0x6
	// Bit mask of BC field.
	USART_LCR_BC_Msk = 0x40
	// Bit BC.
	USART_LCR_BC = 0x40
	// Disabled. Disable break transmission.
	USART_LCR_BC_DISABLED = 0x0
	// Enabled. Enable break transmission. Output pin USART TXD is forced to logic 0 when LCR[6] is active high.
	USART_LCR_BC_ENABLED = 0x1
	// Position of DLAB field.
	USART_LCR_DLAB_Pos = 0x7
	// Bit mask of DLAB field.
	USART_LCR_DLAB_Msk = 0x80
	// Bit DLAB.
	USART_LCR_DLAB = 0x80
	// Disabled. Disable access to Divisor Latches.
	USART_LCR_DLAB_DISABLED = 0x0
	// Enabled. Enable access to Divisor Latches.
	USART_LCR_DLAB_ENABLED = 0x1
	// Position of RESERVED field.
	USART_LCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_LCR_RESERVED_Msk = 0xffffff00

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	// Position of RDR field.
	USART_LSR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_LSR_RDR_Msk = 0x1
	// Bit RDR.
	USART_LSR_RDR = 0x1
	// Empty. RBR is empty.
	USART_LSR_RDR_EMPTY = 0x0
	// Data. RBR contains valid data.
	USART_LSR_RDR_DATA = 0x1
	// Position of OE field.
	USART_LSR_OE_Pos = 0x1
	// Bit mask of OE field.
	USART_LSR_OE_Msk = 0x2
	// Bit OE.
	USART_LSR_OE = 0x2
	// Inactive. Overrun error status is inactive.
	USART_LSR_OE_INACTIVE = 0x0
	// Active. Overrun error status is active.
	USART_LSR_OE_ACTIVE = 0x1
	// Position of PE field.
	USART_LSR_PE_Pos = 0x2
	// Bit mask of PE field.
	USART_LSR_PE_Msk = 0x4
	// Bit PE.
	USART_LSR_PE = 0x4
	// Inactive. Parity error status is inactive.
	USART_LSR_PE_INACTIVE = 0x0
	// Active. Parity error status is active.
	USART_LSR_PE_ACTIVE = 0x1
	// Position of FE field.
	USART_LSR_FE_Pos = 0x3
	// Bit mask of FE field.
	USART_LSR_FE_Msk = 0x8
	// Bit FE.
	USART_LSR_FE = 0x8
	// Inactive. Framing error status is inactive.
	USART_LSR_FE_INACTIVE = 0x0
	// Active. Framing error status is active.
	USART_LSR_FE_ACTIVE = 0x1
	// Position of BI field.
	USART_LSR_BI_Pos = 0x4
	// Bit mask of BI field.
	USART_LSR_BI_Msk = 0x10
	// Bit BI.
	USART_LSR_BI = 0x10
	// Inactive. Break interrupt status is inactive.
	USART_LSR_BI_INACTIVE = 0x0
	// Active. Break interrupt status is active.
	USART_LSR_BI_ACTIVE = 0x1
	// Position of THRE field.
	USART_LSR_THRE_Pos = 0x5
	// Bit mask of THRE field.
	USART_LSR_THRE_Msk = 0x20
	// Bit THRE.
	USART_LSR_THRE = 0x20
	// Not empty. THR contains valid data.
	USART_LSR_THRE_NOT_EMPTY = 0x0
	// Empty. THR is empty.
	USART_LSR_THRE_EMPTY = 0x1
	// Position of TEMT field.
	USART_LSR_TEMT_Pos = 0x6
	// Bit mask of TEMT field.
	USART_LSR_TEMT_Msk = 0x40
	// Bit TEMT.
	USART_LSR_TEMT = 0x40
	// Not empty. THR and/or the TSR contains valid data.
	USART_LSR_TEMT_NOT_EMPTY = 0x0
	// Empty. THR and the TSR are empty.
	USART_LSR_TEMT_EMPTY = 0x1
	// Position of RXFE field.
	USART_LSR_RXFE_Pos = 0x7
	// Bit mask of RXFE field.
	USART_LSR_RXFE_Msk = 0x80
	// Bit RXFE.
	USART_LSR_RXFE = 0x80
	// No error. RBR contains no USART RX errors or FCR[0]=0.
	USART_LSR_RXFE_NO_ERROR = 0x0
	// Error. USART RBR contains at least one USART RX error.
	USART_LSR_RXFE_ERROR = 0x1
	// Position of TXERR field.
	USART_LSR_TXERR_Pos = 0x8
	// Bit mask of TXERR field.
	USART_LSR_TXERR_Msk = 0x100
	// Bit TXERR.
	USART_LSR_TXERR = 0x100
	// No error. No error (normal default condition).
	USART_LSR_TXERR_NO_ERROR = 0x0
	// NACK. A NACK response is received during Smart card T=0 operation.
	USART_LSR_TXERR_NACK = 0x1
	// Position of RESERVED field.
	USART_LSR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART_LSR_RESERVED_Msk = 0xfffffe00

	// SCR: Scratch Pad Register. Eight-bit temporary storage for software.
	// Position of PAD field.
	USART_SCR_PAD_Pos = 0x0
	// Bit mask of PAD field.
	USART_SCR_PAD_Msk = 0xff
	// Position of RESERVED field.
	USART_SCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_SCR_RESERVED_Msk = 0xffffff00

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	// Position of START field.
	USART_ACR_START_Pos = 0x0
	// Bit mask of START field.
	USART_ACR_START_Msk = 0x1
	// Bit START.
	USART_ACR_START = 0x1
	// Stop. Auto-baud stop (auto-baud is not running).
	USART_ACR_START_STOP = 0x0
	// Start. Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	USART_ACR_START_START = 0x1
	// Position of MODE field.
	USART_ACR_MODE_Pos = 0x1
	// Bit mask of MODE field.
	USART_ACR_MODE_Msk = 0x2
	// Bit MODE.
	USART_ACR_MODE = 0x2
	// Mode 0.
	USART_ACR_MODE_MODE_0 = 0x0
	// Mode 1.
	USART_ACR_MODE_MODE_1 = 0x1
	// Position of AUTORESTART field.
	USART_ACR_AUTORESTART_Pos = 0x2
	// Bit mask of AUTORESTART field.
	USART_ACR_AUTORESTART_Msk = 0x4
	// Bit AUTORESTART.
	USART_ACR_AUTORESTART = 0x4
	// No restart.
	USART_ACR_AUTORESTART_NO_RESTART = 0x0
	// Restart. Restart in case of time-out (counter restarts at next USART Rx falling edge)
	USART_ACR_AUTORESTART_RESTART = 0x1
	// Position of RESERVED field.
	USART_ACR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_ACR_RESERVED_Msk = 0xf8
	// Position of ABEOINTCLR field.
	USART_ACR_ABEOINTCLR_Pos = 0x8
	// Bit mask of ABEOINTCLR field.
	USART_ACR_ABEOINTCLR_Msk = 0x100
	// Bit ABEOINTCLR.
	USART_ACR_ABEOINTCLR = 0x100
	// No effect. Writing a 0 has no impact.
	USART_ACR_ABEOINTCLR_NO_EFFECT = 0x0
	// Clear. Writing a 1 will clear the corresponding interrupt in the IIR.
	USART_ACR_ABEOINTCLR_CLEAR = 0x1
	// Position of ABTOINTCLR field.
	USART_ACR_ABTOINTCLR_Pos = 0x9
	// Bit mask of ABTOINTCLR field.
	USART_ACR_ABTOINTCLR_Msk = 0x200
	// Bit ABTOINTCLR.
	USART_ACR_ABTOINTCLR = 0x200
	// No effect. Writing a 0 has no impact.
	USART_ACR_ABTOINTCLR_NO_EFFECT = 0x0
	// Clear. Writing a 1 will clear the corresponding interrupt in the IIR.
	USART_ACR_ABTOINTCLR_CLEAR = 0x1
	// Position of RESERVED field.
	USART_ACR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_ACR_RESERVED_Msk = 0xfffffc00

	// ICR: IrDA control register (USART3 only)
	// Position of IRDAEN field.
	USART_ICR_IRDAEN_Pos = 0x0
	// Bit mask of IRDAEN field.
	USART_ICR_IRDAEN_Msk = 0x1
	// Bit IRDAEN.
	USART_ICR_IRDAEN = 0x1
	// Disabled. IrDA mode on USART3 is disabled, USART3 acts as a standard USART.
	USART_ICR_IRDAEN_DISABLED = 0x0
	// Enabled. IrDA mode on USART3 is enabled.
	USART_ICR_IRDAEN_ENABLED = 0x1
	// Position of IRDAINV field.
	USART_ICR_IRDAINV_Pos = 0x1
	// Bit mask of IRDAINV field.
	USART_ICR_IRDAINV_Msk = 0x2
	// Bit IRDAINV.
	USART_ICR_IRDAINV = 0x2
	// Not inverted. The serial input is not inverted.
	USART_ICR_IRDAINV_NOT_INVERTED = 0x0
	// Inverted. The serial input is inverted. This has no effect on the serial output.
	USART_ICR_IRDAINV_INVERTED = 0x1
	// Position of FIXPULSEEN field.
	USART_ICR_FIXPULSEEN_Pos = 0x2
	// Bit mask of FIXPULSEEN field.
	USART_ICR_FIXPULSEEN_Msk = 0x4
	// Bit FIXPULSEEN.
	USART_ICR_FIXPULSEEN = 0x4
	// Disabled. IrDA fixed pulse width mode disabled.
	USART_ICR_FIXPULSEEN_DISABLED = 0x0
	// Enabled. IrDA fixed pulse width mode enabled.
	USART_ICR_FIXPULSEEN_ENABLED = 0x1
	// Position of PULSEDIV field.
	USART_ICR_PULSEDIV_Pos = 0x3
	// Bit mask of PULSEDIV field.
	USART_ICR_PULSEDIV_Msk = 0x38
	// Position of RESERVED field.
	USART_ICR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USART_ICR_RESERVED_Msk = 0xffffffc0

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	// Position of DIVADDVAL field.
	USART_FDR_DIVADDVAL_Pos = 0x0
	// Bit mask of DIVADDVAL field.
	USART_FDR_DIVADDVAL_Msk = 0xf
	// Position of MULVAL field.
	USART_FDR_MULVAL_Pos = 0x4
	// Bit mask of MULVAL field.
	USART_FDR_MULVAL_Msk = 0xf0
	// Position of RESERVED field.
	USART_FDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_FDR_RESERVED_Msk = 0xffffff00

	// OSR: Oversampling Register. Controls the degree of oversampling during each bit time.
	// Position of RESERVED field.
	USART_OSR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART_OSR_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USART_OSR_RESERVED = 0x1
	// Position of OSFRAC field.
	USART_OSR_OSFRAC_Pos = 0x1
	// Bit mask of OSFRAC field.
	USART_OSR_OSFRAC_Msk = 0xe
	// Position of OSINT field.
	USART_OSR_OSINT_Pos = 0x4
	// Bit mask of OSINT field.
	USART_OSR_OSINT_Msk = 0xf0
	// Position of FDINT field.
	USART_OSR_FDINT_Pos = 0x8
	// Bit mask of FDINT field.
	USART_OSR_FDINT_Msk = 0x7f00
	// Position of RESERVED field.
	USART_OSR_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USART_OSR_RESERVED_Msk = 0xffff8000

	// HDEN: Half-duplex enable Register
	// Position of HDEN field.
	USART_HDEN_HDEN_Pos = 0x0
	// Bit mask of HDEN field.
	USART_HDEN_HDEN_Msk = 0x1
	// Bit HDEN.
	USART_HDEN_HDEN = 0x1
	// Disabled. Disable half-duplex mode.
	USART_HDEN_HDEN_DISABLED = 0x0
	// Enabled. Enable half-duplex mode.
	USART_HDEN_HDEN_ENABLED = 0x1
	// Position of RESERVED field.
	USART_HDEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART_HDEN_RESERVED_Msk = 0xfffffffe

	// SCICTRL: Smart card interface control register
	// Position of SCIEN field.
	USART_SCICTRL_SCIEN_Pos = 0x0
	// Bit mask of SCIEN field.
	USART_SCICTRL_SCIEN_Msk = 0x1
	// Bit SCIEN.
	USART_SCICTRL_SCIEN = 0x1
	// Disabled. Smart card interface disabled.
	USART_SCICTRL_SCIEN_DISABLED = 0x0
	// Enabled. synchronous half duplex smart card interface is enabled.
	USART_SCICTRL_SCIEN_ENABLED = 0x1
	// Position of NACKDIS field.
	USART_SCICTRL_NACKDIS_Pos = 0x1
	// Bit mask of NACKDIS field.
	USART_SCICTRL_NACKDIS_Msk = 0x2
	// Bit NACKDIS.
	USART_SCICTRL_NACKDIS = 0x2
	// Enabled. A NACK response is enabled.
	USART_SCICTRL_NACKDIS_ENABLED = 0x0
	// Disabled. A NACK response is inhibited.
	USART_SCICTRL_NACKDIS_DISABLED = 0x1
	// Position of PROTSEL field.
	USART_SCICTRL_PROTSEL_Pos = 0x2
	// Bit mask of PROTSEL field.
	USART_SCICTRL_PROTSEL_Msk = 0x4
	// Bit PROTSEL.
	USART_SCICTRL_PROTSEL = 0x4
	// T = 0
	USART_SCICTRL_PROTSEL_T_EQ_0 = 0x0
	// T = 1
	USART_SCICTRL_PROTSEL_T_EQ_1 = 0x1
	// Position of RESERVED field.
	USART_SCICTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_SCICTRL_RESERVED_Msk = 0x18
	// Position of TXRETRY field.
	USART_SCICTRL_TXRETRY_Pos = 0x5
	// Bit mask of TXRETRY field.
	USART_SCICTRL_TXRETRY_Msk = 0xe0
	// Position of GUARDTIME field.
	USART_SCICTRL_GUARDTIME_Pos = 0x8
	// Bit mask of GUARDTIME field.
	USART_SCICTRL_GUARDTIME_Msk = 0xff00
	// Position of RESERVED field.
	USART_SCICTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART_SCICTRL_RESERVED_Msk = 0xffff0000

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	// Position of NMMEN field.
	USART_RS485CTRL_NMMEN_Pos = 0x0
	// Bit mask of NMMEN field.
	USART_RS485CTRL_NMMEN_Msk = 0x1
	// Bit NMMEN.
	USART_RS485CTRL_NMMEN = 0x1
	// Disabled. RS-485/EIA-485 Normal Multidrop Mode (NMM) is disabled.
	USART_RS485CTRL_NMMEN_DISABLED = 0x0
	// Enabled. RS-485/EIA-485 Normal Multidrop Mode (NMM) is enabled. In this mode, an address is detected when a received byte causes the USART to set the parity error and generate an interrupt.
	USART_RS485CTRL_NMMEN_ENABLED = 0x1
	// Position of RXDIS field.
	USART_RS485CTRL_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	USART_RS485CTRL_RXDIS_Msk = 0x2
	// Bit RXDIS.
	USART_RS485CTRL_RXDIS = 0x2
	// Enabled. The receiver is enabled.
	USART_RS485CTRL_RXDIS_ENABLED = 0x0
	// Disabled.The receiver is disabled.
	USART_RS485CTRL_RXDIS_DISABLED = 0x1
	// Position of AADEN field.
	USART_RS485CTRL_AADEN_Pos = 0x2
	// Bit mask of AADEN field.
	USART_RS485CTRL_AADEN_Msk = 0x4
	// Bit AADEN.
	USART_RS485CTRL_AADEN = 0x4
	// Disabled. Auto Address Detect (AAD) is disabled.
	USART_RS485CTRL_AADEN_DISABLED = 0x0
	// Enabled. Auto Address Detect (AAD) is enabled.
	USART_RS485CTRL_AADEN_ENABLED = 0x1
	// Position of RESERVED field.
	USART_RS485CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_RS485CTRL_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USART_RS485CTRL_RESERVED = 0x8
	// Position of DCTRL field.
	USART_RS485CTRL_DCTRL_Pos = 0x4
	// Bit mask of DCTRL field.
	USART_RS485CTRL_DCTRL_Msk = 0x10
	// Bit DCTRL.
	USART_RS485CTRL_DCTRL = 0x10
	// Disabled. Disable Auto Direction Control.
	USART_RS485CTRL_DCTRL_DISABLED = 0x0
	// Enabled. Enable Auto Direction Control.
	USART_RS485CTRL_DCTRL_ENABLED = 0x1
	// Position of OINV field.
	USART_RS485CTRL_OINV_Pos = 0x5
	// Bit mask of OINV field.
	USART_RS485CTRL_OINV_Msk = 0x20
	// Bit OINV.
	USART_RS485CTRL_OINV = 0x20
	// Low. The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	USART_RS485CTRL_OINV_LOW = 0x0
	// High. The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	USART_RS485CTRL_OINV_HIGH = 0x1
	// Position of RESERVED field.
	USART_RS485CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USART_RS485CTRL_RESERVED_Msk = 0xffffffc0

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	// Position of ADRMATCH field.
	USART_RS485ADRMATCH_ADRMATCH_Pos = 0x0
	// Bit mask of ADRMATCH field.
	USART_RS485ADRMATCH_ADRMATCH_Msk = 0xff
	// Position of RESERVED field.
	USART_RS485ADRMATCH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_RS485ADRMATCH_RESERVED_Msk = 0xffffff00

	// RS485DLY: RS-485/EIA-485 direction control delay.
	// Position of DLY field.
	USART_RS485DLY_DLY_Pos = 0x0
	// Bit mask of DLY field.
	USART_RS485DLY_DLY_Msk = 0xff
	// Position of RESERVED field.
	USART_RS485DLY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_RS485DLY_RESERVED_Msk = 0xffffff00

	// SYNCCTRL: Synchronous mode control register.
	// Position of SYNC field.
	USART_SYNCCTRL_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	USART_SYNCCTRL_SYNC_Msk = 0x1
	// Bit SYNC.
	USART_SYNCCTRL_SYNC = 0x1
	// Disabled.
	USART_SYNCCTRL_SYNC_DISABLED = 0x0
	// Enabled.
	USART_SYNCCTRL_SYNC_ENABLED = 0x1
	// Position of CSRC field.
	USART_SYNCCTRL_CSRC_Pos = 0x1
	// Bit mask of CSRC field.
	USART_SYNCCTRL_CSRC_Msk = 0x2
	// Bit CSRC.
	USART_SYNCCTRL_CSRC = 0x2
	// Slave mode. Synchronous slave mode (SCLK in)
	USART_SYNCCTRL_CSRC_SLAVE_MODE = 0x0
	// Master mode. Synchronous master mode (SCLK out)
	USART_SYNCCTRL_CSRC_MASTER_MODE = 0x1
	// Position of FES field.
	USART_SYNCCTRL_FES_Pos = 0x2
	// Bit mask of FES field.
	USART_SYNCCTRL_FES_Msk = 0x4
	// Bit FES.
	USART_SYNCCTRL_FES = 0x4
	// Rising. RxD is sampled on the rising edge of SCLK.
	USART_SYNCCTRL_FES_RISING = 0x0
	// Falling. RxD is sampled on the falling edge of SCLK.
	USART_SYNCCTRL_FES_FALLING = 0x1
	// Position of TSBYPASS field.
	USART_SYNCCTRL_TSBYPASS_Pos = 0x3
	// Bit mask of TSBYPASS field.
	USART_SYNCCTRL_TSBYPASS_Msk = 0x8
	// Bit TSBYPASS.
	USART_SYNCCTRL_TSBYPASS = 0x8
	// Synchronized. The input clock is synchronized prior to being used in clock edge detection logic.
	USART_SYNCCTRL_TSBYPASS_SYNCHRONIZED = 0x0
	// Not synchronized. The input clock is not synchronized prior to being used in clock edge detection logic. This allows for a high er input clock rate at the expense of potential metastability.
	USART_SYNCCTRL_TSBYPASS_NOT_SYNCHRONIZED = 0x1
	// Position of CSCEN field.
	USART_SYNCCTRL_CSCEN_Pos = 0x4
	// Bit mask of CSCEN field.
	USART_SYNCCTRL_CSCEN_Msk = 0x10
	// Bit CSCEN.
	USART_SYNCCTRL_CSCEN = 0x10
	// On character. SCLK cycles only when characters are being sent on TxD.
	USART_SYNCCTRL_CSCEN_ON_CHARACTER = 0x0
	// Continuously. SCLK runs continuously (characters can be received on RxD independently from transmission on TxD).
	USART_SYNCCTRL_CSCEN_CONTINUOUSLY = 0x1
	// Position of SSSDIS field.
	USART_SYNCCTRL_SSSDIS_Pos = 0x5
	// Bit mask of SSSDIS field.
	USART_SYNCCTRL_SSSDIS_Msk = 0x20
	// Bit SSSDIS.
	USART_SYNCCTRL_SSSDIS = 0x20
	// Send. Send start and stop bits as in other modes.
	USART_SYNCCTRL_SSSDIS_SEND = 0x0
	// Do not send. Do not send start/stop bits.
	USART_SYNCCTRL_SSSDIS_DO_NOT_SEND = 0x1
	// Position of CCCLR field.
	USART_SYNCCTRL_CCCLR_Pos = 0x6
	// Bit mask of CCCLR field.
	USART_SYNCCTRL_CCCLR_Msk = 0x40
	// Bit CCCLR.
	USART_SYNCCTRL_CCCLR = 0x40
	// Software. CSCEN is under software control.
	USART_SYNCCTRL_CCCLR_SOFTWARE = 0x0
	// Hardware. Hardware clears CSCEN after each character is received.
	USART_SYNCCTRL_CCCLR_HARDWARE = 0x1
	// Position of RESERVED field.
	USART_SYNCCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART_SYNCCTRL_RESERVED_Msk = 0xffffff80

	// TER: Transmit Enable Register. Turns off USART transmitter for use with software flow control.
	// Position of TXEN field.
	USART_TER_TXEN_Pos = 0x0
	// Bit mask of TXEN field.
	USART_TER_TXEN_Msk = 0x1
	// Bit TXEN.
	USART_TER_TXEN = 0x1
	// Position of RESERVED field.
	USART_TER_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART_TER_RESERVED_Msk = 0xfffffffe
)

// Bitfields for UART1: UART1
const (
	// RBR: Receiver Buffer Register. Contains the next received character to be read. (DLAB=0)
	// Position of RBR field.
	UART1_RBR_RBR_Pos = 0x0
	// Bit mask of RBR field.
	UART1_RBR_RBR_Msk = 0xff
	// Position of RESERVED field.
	UART1_RBR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_RBR_RESERVED_Msk = 0xffffff00

	// THR: Transmit Holding Register. The next character to be transmitted is written here. (DLAB=0)
	// Position of THR field.
	UART1_THR_THR_Pos = 0x0
	// Bit mask of THR field.
	UART1_THR_THR_Msk = 0xff
	// Position of RESERVED field.
	UART1_THR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_THR_RESERVED_Msk = 0xffffff00

	// DLL: Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLLSB field.
	UART1_DLL_DLLSB_Pos = 0x0
	// Bit mask of DLLSB field.
	UART1_DLL_DLLSB_Msk = 0xff
	// Position of RESERVED field.
	UART1_DLL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_DLL_RESERVED_Msk = 0xffffff00

	// DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider.(DLAB=1)
	// Position of DLMSB field.
	UART1_DLM_DLMSB_Pos = 0x0
	// Bit mask of DLMSB field.
	UART1_DLM_DLMSB_Msk = 0xff
	// Position of RESERVED field.
	UART1_DLM_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_DLM_RESERVED_Msk = 0xffffff00

	// IER: Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential UART1 interrupts. (DLAB=0)
	// Position of RBRIE field.
	UART1_IER_RBRIE_Pos = 0x0
	// Bit mask of RBRIE field.
	UART1_IER_RBRIE_Msk = 0x1
	// Bit RBRIE.
	UART1_IER_RBRIE = 0x1
	// Disable. Disable the RDA interrupts.
	UART1_IER_RBRIE_DISABLE = 0x0
	// Enable. Enable the RDA interrupts.
	UART1_IER_RBRIE_ENABLE = 0x1
	// Position of THREIE field.
	UART1_IER_THREIE_Pos = 0x1
	// Bit mask of THREIE field.
	UART1_IER_THREIE_Msk = 0x2
	// Bit THREIE.
	UART1_IER_THREIE = 0x2
	// Disable. Disable the THRE interrupts.
	UART1_IER_THREIE_DISABLE = 0x0
	// Enable. Enable the THRE interrupts.
	UART1_IER_THREIE_ENABLE = 0x1
	// Position of RXIE field.
	UART1_IER_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	UART1_IER_RXIE_Msk = 0x4
	// Bit RXIE.
	UART1_IER_RXIE = 0x4
	// Disable. Disable the RX line status interrupts.
	UART1_IER_RXIE_DISABLE = 0x0
	// Enable. Enable the RX line status interrupts.
	UART1_IER_RXIE_ENABLE = 0x1
	// Position of MSIE field.
	UART1_IER_MSIE_Pos = 0x3
	// Bit mask of MSIE field.
	UART1_IER_MSIE_Msk = 0x8
	// Bit MSIE.
	UART1_IER_MSIE = 0x8
	// Disable. Disable the modem interrupt.
	UART1_IER_MSIE_DISABLE = 0x0
	// Enable. Enable the modem interrupt.
	UART1_IER_MSIE_ENABLE = 0x1
	// Position of RESERVED field.
	UART1_IER_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART1_IER_RESERVED_Msk = 0x70
	// Position of CTSIE field.
	UART1_IER_CTSIE_Pos = 0x7
	// Bit mask of CTSIE field.
	UART1_IER_CTSIE_Msk = 0x80
	// Bit CTSIE.
	UART1_IER_CTSIE = 0x80
	// Disable. Disable the CTS interrupt.
	UART1_IER_CTSIE_DISABLE = 0x0
	// Enable. Enable the CTS interrupt.
	UART1_IER_CTSIE_ENABLE = 0x1
	// Position of ABEOIE field.
	UART1_IER_ABEOIE_Pos = 0x8
	// Bit mask of ABEOIE field.
	UART1_IER_ABEOIE_Msk = 0x100
	// Bit ABEOIE.
	UART1_IER_ABEOIE = 0x100
	// Disable. Disable end of auto-baud Interrupt.
	UART1_IER_ABEOIE_DISABLE = 0x0
	// Enable. Enable end of auto-baud Interrupt.
	UART1_IER_ABEOIE_ENABLE = 0x1
	// Position of ABTOIE field.
	UART1_IER_ABTOIE_Pos = 0x9
	// Bit mask of ABTOIE field.
	UART1_IER_ABTOIE_Msk = 0x200
	// Bit ABTOIE.
	UART1_IER_ABTOIE = 0x200
	// Disable. Disable auto-baud time-out Interrupt.
	UART1_IER_ABTOIE_DISABLE = 0x0
	// Enable. Enable auto-baud time-out Interrupt.
	UART1_IER_ABTOIE_ENABLE = 0x1
	// Position of RESERVED field.
	UART1_IER_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART1_IER_RESERVED_Msk = 0xfffffc00

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	// Position of INTSTATUS field.
	UART1_IIR_INTSTATUS_Pos = 0x0
	// Bit mask of INTSTATUS field.
	UART1_IIR_INTSTATUS_Msk = 0x1
	// Bit INTSTATUS.
	UART1_IIR_INTSTATUS = 0x1
	// Interrupt pending. At least one interrupt is pending.
	UART1_IIR_INTSTATUS_INTERRUPT_PENDING = 0x0
	// Not pending. No interrupt is pending.
	UART1_IIR_INTSTATUS_NOT_PENDING = 0x1
	// Position of INTID field.
	UART1_IIR_INTID_Pos = 0x1
	// Bit mask of INTID field.
	UART1_IIR_INTID_Msk = 0xe
	// RLS. Priority 1 (highest). (Highest) Receive Line Status (RLS).
	UART1_IIR_INTID_RLS = 0x3
	// RDA. Priority 2 - Receive Data Available (RDA).
	UART1_IIR_INTID_RDA = 0x2
	// CTI. Priority 2 - Character Time-out Indicator (CTI).
	UART1_IIR_INTID_CTI = 0x6
	// THRE. Priority 3 - THRE Interrupt.
	UART1_IIR_INTID_THRE = 0x1
	// Position of RESERVED field.
	UART1_IIR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART1_IIR_RESERVED_Msk = 0x30
	// Position of FIFOENABLE field.
	UART1_IIR_FIFOENABLE_Pos = 0x6
	// Bit mask of FIFOENABLE field.
	UART1_IIR_FIFOENABLE_Msk = 0xc0
	// Position of ABEOINT field.
	UART1_IIR_ABEOINT_Pos = 0x8
	// Bit mask of ABEOINT field.
	UART1_IIR_ABEOINT_Msk = 0x100
	// Bit ABEOINT.
	UART1_IIR_ABEOINT = 0x100
	// Position of ABTOINT field.
	UART1_IIR_ABTOINT_Pos = 0x9
	// Bit mask of ABTOINT field.
	UART1_IIR_ABTOINT_Msk = 0x200
	// Bit ABTOINT.
	UART1_IIR_ABTOINT = 0x200
	// Position of RESERVED field.
	UART1_IIR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART1_IIR_RESERVED_Msk = 0xfffffc00

	// FCR: FIFO Control Register. Controls UART1 FIFO usage and modes.
	// Position of FIFOEN field.
	UART1_FCR_FIFOEN_Pos = 0x0
	// Bit mask of FIFOEN field.
	UART1_FCR_FIFOEN_Msk = 0x1
	// Bit FIFOEN.
	UART1_FCR_FIFOEN = 0x1
	// Disabled. Must not be used in the application.
	UART1_FCR_FIFOEN_DISABLED = 0x0
	// Enabled. Active high enable for both UART1 Rx and TX FIFOs and FCR[7:1] access. This bit must be set for proper UART1 operation. Any transition on this bit will automatically clear the UART1 FIFOs.
	UART1_FCR_FIFOEN_ENABLED = 0x1
	// Position of RXFIFORES field.
	UART1_FCR_RXFIFORES_Pos = 0x1
	// Bit mask of RXFIFORES field.
	UART1_FCR_RXFIFORES_Msk = 0x2
	// Bit RXFIFORES.
	UART1_FCR_RXFIFORES = 0x2
	// No effect. No impact on either of UART1 FIFOs.
	UART1_FCR_RXFIFORES_NO_EFFECT = 0x0
	// Clear. Writing a logic 1 to FCR[1] will clear all bytes in UART1 Rx FIFO, reset the pointer logic. This bit is self-clearing.
	UART1_FCR_RXFIFORES_CLEAR = 0x1
	// Position of TXFIFORES field.
	UART1_FCR_TXFIFORES_Pos = 0x2
	// Bit mask of TXFIFORES field.
	UART1_FCR_TXFIFORES_Msk = 0x4
	// Bit TXFIFORES.
	UART1_FCR_TXFIFORES = 0x4
	// No effect. No impact on either of UART1 FIFOs.
	UART1_FCR_TXFIFORES_NO_EFFECT = 0x0
	// Clear. Writing a logic 1 to FCR[2] will clear all bytes in UART1 TX FIFO, reset the pointer logic. This bit is self-clearing.
	UART1_FCR_TXFIFORES_CLEAR = 0x1
	// Position of DMAMODE field.
	UART1_FCR_DMAMODE_Pos = 0x3
	// Bit mask of DMAMODE field.
	UART1_FCR_DMAMODE_Msk = 0x8
	// Bit DMAMODE.
	UART1_FCR_DMAMODE = 0x8
	// Position of RESERVED field.
	UART1_FCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART1_FCR_RESERVED_Msk = 0x30
	// Position of RXTRIGLVL field.
	UART1_FCR_RXTRIGLVL_Pos = 0x6
	// Bit mask of RXTRIGLVL field.
	UART1_FCR_RXTRIGLVL_Msk = 0xc0
	// Level 0. Trigger level 0 (1 character or 0x01).
	UART1_FCR_RXTRIGLVL_LEVEL_0 = 0x0
	// Level 1. Trigger level 1 (4 characters or 0x04).
	UART1_FCR_RXTRIGLVL_LEVEL_1 = 0x1
	// Level 2. Trigger level 2 (8 characters or 0x08).
	UART1_FCR_RXTRIGLVL_LEVEL_2 = 0x2
	// Level 3. Trigger level 3 (14 characters or 0x0E).
	UART1_FCR_RXTRIGLVL_LEVEL_3 = 0x3
	// Position of RESERVED field.
	UART1_FCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_FCR_RESERVED_Msk = 0xffffff00

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	// Position of WLS field.
	UART1_LCR_WLS_Pos = 0x0
	// Bit mask of WLS field.
	UART1_LCR_WLS_Msk = 0x3
	// 5-bit character length.
	UART1_LCR_WLS_5_BIT_CHARACTER_LENG = 0x0
	// 6-bit character length.
	UART1_LCR_WLS_6_BIT_CHARACTER_LENG = 0x1
	// 7-bit character length.
	UART1_LCR_WLS_7_BIT_CHARACTER_LENG = 0x2
	// 8-bit character length.
	UART1_LCR_WLS_8_BIT_CHARACTER_LENG = 0x3
	// Position of SBS field.
	UART1_LCR_SBS_Pos = 0x2
	// Bit mask of SBS field.
	UART1_LCR_SBS_Msk = 0x4
	// Bit SBS.
	UART1_LCR_SBS = 0x4
	// 1 stop bit.
	UART1_LCR_SBS_1_STOP_BIT = 0x0
	// 2 stop bits. (1.5 if LCR[1:0]=00).
	UART1_LCR_SBS_2_STOP_BITS = 0x1
	// Position of PE field.
	UART1_LCR_PE_Pos = 0x3
	// Bit mask of PE field.
	UART1_LCR_PE_Msk = 0x8
	// Bit PE.
	UART1_LCR_PE = 0x8
	// Disable parity generation and checking.
	UART1_LCR_PE_DISABLE_PARITY_GENER = 0x0
	// Enable parity generation and checking.
	UART1_LCR_PE_ENABLE_PARITY_GENERA = 0x1
	// Position of PS field.
	UART1_LCR_PS_Pos = 0x4
	// Bit mask of PS field.
	UART1_LCR_PS_Msk = 0x30
	// Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	UART1_LCR_PS_ODD_PARITY = 0x0
	// Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	UART1_LCR_PS_EVEN_PARITY = 0x1
	// Force HIGH. Forced 1 stick parity.
	UART1_LCR_PS_FORCE_HIGH = 0x2
	// Force LOW. Forced 0 stick parity.
	UART1_LCR_PS_FORCE_LOW = 0x3
	// Position of BC field.
	UART1_LCR_BC_Pos = 0x6
	// Bit mask of BC field.
	UART1_LCR_BC_Msk = 0x40
	// Bit BC.
	UART1_LCR_BC = 0x40
	// Disabled. Disable break transmission.
	UART1_LCR_BC_DISABLED = 0x0
	// Enabled. Enable break transmission. Output pin UART1 TXD is forced to logic 0 when LCR[6] is active high.
	UART1_LCR_BC_ENABLED = 0x1
	// Position of DLAB field.
	UART1_LCR_DLAB_Pos = 0x7
	// Bit mask of DLAB field.
	UART1_LCR_DLAB_Msk = 0x80
	// Bit DLAB.
	UART1_LCR_DLAB = 0x80
	// Disabled. Disable access to Divisor Latches.
	UART1_LCR_DLAB_DISABLED = 0x0
	// Enabled. Enable access to Divisor Latches.
	UART1_LCR_DLAB_ENABLED = 0x1
	// Position of RESERVED field.
	UART1_LCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_LCR_RESERVED_Msk = 0xffffff00

	// MCR: Modem Control Register. Contains controls for flow control handshaking and loopback mode.
	// Position of DTRCTRL field.
	UART1_MCR_DTRCTRL_Pos = 0x0
	// Bit mask of DTRCTRL field.
	UART1_MCR_DTRCTRL_Msk = 0x1
	// Bit DTRCTRL.
	UART1_MCR_DTRCTRL = 0x1
	// Position of RTSCTRL field.
	UART1_MCR_RTSCTRL_Pos = 0x1
	// Bit mask of RTSCTRL field.
	UART1_MCR_RTSCTRL_Msk = 0x2
	// Bit RTSCTRL.
	UART1_MCR_RTSCTRL = 0x2
	// Position of RESERVED field.
	UART1_MCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	UART1_MCR_RESERVED_Msk = 0xc
	// Position of LMS field.
	UART1_MCR_LMS_Pos = 0x4
	// Bit mask of LMS field.
	UART1_MCR_LMS_Msk = 0x10
	// Bit LMS.
	UART1_MCR_LMS = 0x10
	// Disabled. Disable modem loopback mode.
	UART1_MCR_LMS_DISABLED = 0x0
	// Enabled. Enable modem loopback mode.
	UART1_MCR_LMS_ENABLED = 0x1
	// Position of RESERVED field.
	UART1_MCR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	UART1_MCR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	UART1_MCR_RESERVED = 0x20
	// Position of RTSEN field.
	UART1_MCR_RTSEN_Pos = 0x6
	// Bit mask of RTSEN field.
	UART1_MCR_RTSEN_Msk = 0x40
	// Bit RTSEN.
	UART1_MCR_RTSEN = 0x40
	// Disabled. Disable auto-rts flow control.
	UART1_MCR_RTSEN_DISABLED = 0x0
	// Enabled. Enable auto-rts flow control.
	UART1_MCR_RTSEN_ENABLED = 0x1
	// Position of CTSEN field.
	UART1_MCR_CTSEN_Pos = 0x7
	// Bit mask of CTSEN field.
	UART1_MCR_CTSEN_Msk = 0x80
	// Bit CTSEN.
	UART1_MCR_CTSEN = 0x80
	// Disabled. Disable auto-cts flow control.
	UART1_MCR_CTSEN_DISABLED = 0x0
	// Enabled. Enable auto-cts flow control.
	UART1_MCR_CTSEN_ENABLED = 0x1
	// Position of RESERVED field.
	UART1_MCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_MCR_RESERVED_Msk = 0xffffff00

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	// Position of RDR field.
	UART1_LSR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	UART1_LSR_RDR_Msk = 0x1
	// Bit RDR.
	UART1_LSR_RDR = 0x1
	// Empty. The UART1 receiver FIFO is empty.
	UART1_LSR_RDR_EMPTY = 0x0
	// Data. The UART1 receiver FIFO is not empty.
	UART1_LSR_RDR_DATA = 0x1
	// Position of OE field.
	UART1_LSR_OE_Pos = 0x1
	// Bit mask of OE field.
	UART1_LSR_OE_Msk = 0x2
	// Bit OE.
	UART1_LSR_OE = 0x2
	// Inactive. Overrun error status is inactive.
	UART1_LSR_OE_INACTIVE = 0x0
	// Active. Overrun error status is active.
	UART1_LSR_OE_ACTIVE = 0x1
	// Position of PE field.
	UART1_LSR_PE_Pos = 0x2
	// Bit mask of PE field.
	UART1_LSR_PE_Msk = 0x4
	// Bit PE.
	UART1_LSR_PE = 0x4
	// Inactive. Parity error status is inactive.
	UART1_LSR_PE_INACTIVE = 0x0
	// Active. Parity error status is active.
	UART1_LSR_PE_ACTIVE = 0x1
	// Position of FE field.
	UART1_LSR_FE_Pos = 0x3
	// Bit mask of FE field.
	UART1_LSR_FE_Msk = 0x8
	// Bit FE.
	UART1_LSR_FE = 0x8
	// Inactive. Framing error status is inactive.
	UART1_LSR_FE_INACTIVE = 0x0
	// Active. Framing error status is active.
	UART1_LSR_FE_ACTIVE = 0x1
	// Position of BI field.
	UART1_LSR_BI_Pos = 0x4
	// Bit mask of BI field.
	UART1_LSR_BI_Msk = 0x10
	// Bit BI.
	UART1_LSR_BI = 0x10
	// Position of THRE field.
	UART1_LSR_THRE_Pos = 0x5
	// Bit mask of THRE field.
	UART1_LSR_THRE_Msk = 0x20
	// Bit THRE.
	UART1_LSR_THRE = 0x20
	// Not empty. THR contains valid data.
	UART1_LSR_THRE_NOT_EMPTY = 0x0
	// Empty. THR is empty.
	UART1_LSR_THRE_EMPTY = 0x1
	// Position of TEMT field.
	UART1_LSR_TEMT_Pos = 0x6
	// Bit mask of TEMT field.
	UART1_LSR_TEMT_Msk = 0x40
	// Bit TEMT.
	UART1_LSR_TEMT = 0x40
	// Not empty. THR and/or the TSR contains valid data.
	UART1_LSR_TEMT_NOT_EMPTY = 0x0
	// Empty. THR and the TSR are empty.
	UART1_LSR_TEMT_EMPTY = 0x1
	// Position of RXFE field.
	UART1_LSR_RXFE_Pos = 0x7
	// Bit mask of RXFE field.
	UART1_LSR_RXFE_Msk = 0x80
	// Bit RXFE.
	UART1_LSR_RXFE = 0x80
	// No error. RBR contains no UART1 RX errors or FCR[0]=0.
	UART1_LSR_RXFE_NO_ERROR = 0x0
	// Error. UART1 RBR contains at least one UART1 RX error.
	UART1_LSR_RXFE_ERROR = 0x1
	// Position of RESERVED field.
	UART1_LSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_LSR_RESERVED_Msk = 0xffffff00

	// MSR: Modem Status Register. Contains handshake signal status flags.
	// Position of DCTS field.
	UART1_MSR_DCTS_Pos = 0x0
	// Bit mask of DCTS field.
	UART1_MSR_DCTS_Msk = 0x1
	// Bit DCTS.
	UART1_MSR_DCTS = 0x1
	// No change. No change detected on modem input, CTS.
	UART1_MSR_DCTS_NO_CHANGE = 0x0
	// State change. State change detected on modem input, CTS.
	UART1_MSR_DCTS_STATE_CHANGE = 0x1
	// Position of DDSR field.
	UART1_MSR_DDSR_Pos = 0x1
	// Bit mask of DDSR field.
	UART1_MSR_DDSR_Msk = 0x2
	// Bit DDSR.
	UART1_MSR_DDSR = 0x2
	// No change. No change detected on modem input, DSR.
	UART1_MSR_DDSR_NO_CHANGE = 0x0
	// State change. State change detected on modem input, DSR.
	UART1_MSR_DDSR_STATE_CHANGE = 0x1
	// Position of TERI field.
	UART1_MSR_TERI_Pos = 0x2
	// Bit mask of TERI field.
	UART1_MSR_TERI_Msk = 0x4
	// Bit TERI.
	UART1_MSR_TERI = 0x4
	// No change. No change detected on modem input, RI.
	UART1_MSR_TERI_NO_CHANGE = 0x0
	// Rising. Low-to-high transition detected on RI.
	UART1_MSR_TERI_RISING = 0x1
	// Position of DDCD field.
	UART1_MSR_DDCD_Pos = 0x3
	// Bit mask of DDCD field.
	UART1_MSR_DDCD_Msk = 0x8
	// Bit DDCD.
	UART1_MSR_DDCD = 0x8
	// No change. No change detected on modem input, DCD.
	UART1_MSR_DDCD_NO_CHANGE = 0x0
	// State change. State change detected on modem input, DCD.
	UART1_MSR_DDCD_STATE_CHANGE = 0x1
	// Position of CTS field.
	UART1_MSR_CTS_Pos = 0x4
	// Bit mask of CTS field.
	UART1_MSR_CTS_Msk = 0x10
	// Bit CTS.
	UART1_MSR_CTS = 0x10
	// Position of DSR field.
	UART1_MSR_DSR_Pos = 0x5
	// Bit mask of DSR field.
	UART1_MSR_DSR_Msk = 0x20
	// Bit DSR.
	UART1_MSR_DSR = 0x20
	// Position of RI field.
	UART1_MSR_RI_Pos = 0x6
	// Bit mask of RI field.
	UART1_MSR_RI_Msk = 0x40
	// Bit RI.
	UART1_MSR_RI = 0x40
	// Position of DCD field.
	UART1_MSR_DCD_Pos = 0x7
	// Bit mask of DCD field.
	UART1_MSR_DCD_Msk = 0x80
	// Bit DCD.
	UART1_MSR_DCD = 0x80
	// Position of RESERVED field.
	UART1_MSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_MSR_RESERVED_Msk = 0xffffff00

	// SCR: Scratch Pad Register. 8-bit temporary storage for software.
	// Position of Pad field.
	UART1_SCR_Pad_Pos = 0x0
	// Bit mask of Pad field.
	UART1_SCR_Pad_Msk = 0xff
	// Position of RESERVED field.
	UART1_SCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_SCR_RESERVED_Msk = 0xffffff00

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	// Position of START field.
	UART1_ACR_START_Pos = 0x0
	// Bit mask of START field.
	UART1_ACR_START_Msk = 0x1
	// Bit START.
	UART1_ACR_START = 0x1
	// Stop. Auto-baud stop (auto-baud is not running).
	UART1_ACR_START_STOP = 0x0
	// Start. Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	UART1_ACR_START_START = 0x1
	// Position of MODE field.
	UART1_ACR_MODE_Pos = 0x1
	// Bit mask of MODE field.
	UART1_ACR_MODE_Msk = 0x2
	// Bit MODE.
	UART1_ACR_MODE = 0x2
	// Mode 0.
	UART1_ACR_MODE_MODE_0 = 0x0
	// Mode 1.
	UART1_ACR_MODE_MODE_1 = 0x1
	// Position of AUTORESTART field.
	UART1_ACR_AUTORESTART_Pos = 0x2
	// Bit mask of AUTORESTART field.
	UART1_ACR_AUTORESTART_Msk = 0x4
	// Bit AUTORESTART.
	UART1_ACR_AUTORESTART = 0x4
	// No restart
	UART1_ACR_AUTORESTART_NO_RESTART = 0x0
	// Restart. Restart in case of time-out (counter restarts at next UART1 Rx falling edge)
	UART1_ACR_AUTORESTART_RESTART = 0x1
	// Position of RESERVED field.
	UART1_ACR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	UART1_ACR_RESERVED_Msk = 0xf8
	// Position of ABEOINTCLR field.
	UART1_ACR_ABEOINTCLR_Pos = 0x8
	// Bit mask of ABEOINTCLR field.
	UART1_ACR_ABEOINTCLR_Msk = 0x100
	// Bit ABEOINTCLR.
	UART1_ACR_ABEOINTCLR = 0x100
	// No effect. Writing a 0 has no impact.
	UART1_ACR_ABEOINTCLR_NO_EFFECT = 0x0
	// Clear. Writing a 1 will clear the corresponding interrupt in the IIR.
	UART1_ACR_ABEOINTCLR_CLEAR = 0x1
	// Position of ABTOINTCLR field.
	UART1_ACR_ABTOINTCLR_Pos = 0x9
	// Bit mask of ABTOINTCLR field.
	UART1_ACR_ABTOINTCLR_Msk = 0x200
	// Bit ABTOINTCLR.
	UART1_ACR_ABTOINTCLR = 0x200
	// No effect. Writing a 0 has no impact.
	UART1_ACR_ABTOINTCLR_NO_EFFECT = 0x0
	// Clear. Writing a 1 will clear the corresponding interrupt in the IIR.
	UART1_ACR_ABTOINTCLR_CLEAR = 0x1
	// Position of RESERVED field.
	UART1_ACR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART1_ACR_RESERVED_Msk = 0xfffffc00

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	// Position of DIVADDVAL field.
	UART1_FDR_DIVADDVAL_Pos = 0x0
	// Bit mask of DIVADDVAL field.
	UART1_FDR_DIVADDVAL_Msk = 0xf
	// Position of MULVAL field.
	UART1_FDR_MULVAL_Pos = 0x4
	// Bit mask of MULVAL field.
	UART1_FDR_MULVAL_Msk = 0xf0
	// Position of RESERVED field.
	UART1_FDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_FDR_RESERVED_Msk = 0xffffff00

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	// Position of NMMEN field.
	UART1_RS485CTRL_NMMEN_Pos = 0x0
	// Bit mask of NMMEN field.
	UART1_RS485CTRL_NMMEN_Msk = 0x1
	// Bit NMMEN.
	UART1_RS485CTRL_NMMEN = 0x1
	// Disabled. RS-485/EIA-485 Normal Multidrop Mode (NMM) is disabled.
	UART1_RS485CTRL_NMMEN_DISABLED = 0x0
	// Enabled. RS-485/EIA-485 Normal Multidrop Mode (NMM) is enabled. In this mode, an address is detected when a received byte causes the USART to set the parity error and generate an interrupt.
	UART1_RS485CTRL_NMMEN_ENABLED = 0x1
	// Position of RXDIS field.
	UART1_RS485CTRL_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	UART1_RS485CTRL_RXDIS_Msk = 0x2
	// Bit RXDIS.
	UART1_RS485CTRL_RXDIS = 0x2
	// Enabled. The receiver is enabled.
	UART1_RS485CTRL_RXDIS_ENABLED = 0x0
	// Disabled.The receiver is disabled.
	UART1_RS485CTRL_RXDIS_DISABLED = 0x1
	// Position of AADEN field.
	UART1_RS485CTRL_AADEN_Pos = 0x2
	// Bit mask of AADEN field.
	UART1_RS485CTRL_AADEN_Msk = 0x4
	// Bit AADEN.
	UART1_RS485CTRL_AADEN = 0x4
	// Disabled. Auto Address Detect (AAD) is disabled.
	UART1_RS485CTRL_AADEN_DISABLED = 0x0
	// Enabled. Auto Address Detect (AAD) is enabled.
	UART1_RS485CTRL_AADEN_ENABLED = 0x1
	// Position of SEL field.
	UART1_RS485CTRL_SEL_Pos = 0x3
	// Bit mask of SEL field.
	UART1_RS485CTRL_SEL_Msk = 0x8
	// Bit SEL.
	UART1_RS485CTRL_SEL = 0x8
	// RTS. If direction control is enabled (bit DCTRL = 1), pin RTS is used for direction control.
	UART1_RS485CTRL_SEL_RTS = 0x0
	// DTR. If direction control is enabled (bit DCTRL = 1), pin DTR is used for direction control.
	UART1_RS485CTRL_SEL_DTR = 0x1
	// Position of DCTRL field.
	UART1_RS485CTRL_DCTRL_Pos = 0x4
	// Bit mask of DCTRL field.
	UART1_RS485CTRL_DCTRL_Msk = 0x10
	// Bit DCTRL.
	UART1_RS485CTRL_DCTRL = 0x10
	// Disabled. Disable Auto Direction Control.
	UART1_RS485CTRL_DCTRL_DISABLED = 0x0
	// Enabled. Enable Auto Direction Control.
	UART1_RS485CTRL_DCTRL_ENABLED = 0x1
	// Position of OINV field.
	UART1_RS485CTRL_OINV_Pos = 0x5
	// Bit mask of OINV field.
	UART1_RS485CTRL_OINV_Msk = 0x20
	// Bit OINV.
	UART1_RS485CTRL_OINV = 0x20
	// Low. The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	UART1_RS485CTRL_OINV_LOW = 0x0
	// High. The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	UART1_RS485CTRL_OINV_HIGH = 0x1
	// Position of RESERVED field.
	UART1_RS485CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	UART1_RS485CTRL_RESERVED_Msk = 0xffffffc0

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	// Position of ADRMATCH field.
	UART1_RS485ADRMATCH_ADRMATCH_Pos = 0x0
	// Bit mask of ADRMATCH field.
	UART1_RS485ADRMATCH_ADRMATCH_Msk = 0xff
	// Position of RESERVED field.
	UART1_RS485ADRMATCH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_RS485ADRMATCH_RESERVED_Msk = 0xffffff00

	// RS485DLY: RS-485/EIA-485 direction control delay.
	// Position of DLY field.
	UART1_RS485DLY_DLY_Pos = 0x0
	// Bit mask of DLY field.
	UART1_RS485DLY_DLY_Msk = 0xff
	// Position of RESERVED field.
	UART1_RS485DLY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_RS485DLY_RESERVED_Msk = 0xffffff00

	// TER: Transmit Enable Register. Turns off UART transmitter for use with software flow control.
	// Position of TXEN field.
	UART1_TER_TXEN_Pos = 0x0
	// Bit mask of TXEN field.
	UART1_TER_TXEN_Msk = 0x1
	// Bit TXEN.
	UART1_TER_TXEN = 0x1
	// Position of RESERVED field.
	UART1_TER_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	UART1_TER_RESERVED_Msk = 0xfffffffe
)

// Bitfields for SSP0: SSP0/1
const (
	// CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
	// Position of DSS field.
	SSP_CR0_DSS_Pos = 0x0
	// Bit mask of DSS field.
	SSP_CR0_DSS_Msk = 0xf
	// 4-bit transfer
	SSP_CR0_DSS_4_BIT_TRANSFER = 0x3
	// 5-bit transfer
	SSP_CR0_DSS_5_BIT_TRANSFER = 0x4
	// 6-bit transfer
	SSP_CR0_DSS_6_BIT_TRANSFER = 0x5
	// 7-bit transfer
	SSP_CR0_DSS_7_BIT_TRANSFER = 0x6
	// 8-bit transfer
	SSP_CR0_DSS_8_BIT_TRANSFER = 0x7
	// 9-bit transfer
	SSP_CR0_DSS_9_BIT_TRANSFER = 0x8
	// 10-bit transfer
	SSP_CR0_DSS_10_BIT_TRANSFER = 0x9
	// 11-bit transfer
	SSP_CR0_DSS_11_BIT_TRANSFER = 0xa
	// 12-bit transfer
	SSP_CR0_DSS_12_BIT_TRANSFER = 0xb
	// 13-bit transfer
	SSP_CR0_DSS_13_BIT_TRANSFER = 0xc
	// 14-bit transfer
	SSP_CR0_DSS_14_BIT_TRANSFER = 0xd
	// 15-bit transfer
	SSP_CR0_DSS_15_BIT_TRANSFER = 0xe
	// 16-bit transfer
	SSP_CR0_DSS_16_BIT_TRANSFER = 0xf
	// Position of FRF field.
	SSP_CR0_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SSP_CR0_FRF_Msk = 0x30
	// SPI
	SSP_CR0_FRF_SPI = 0x0
	// TI
	SSP_CR0_FRF_TI = 0x1
	// Microwire
	SSP_CR0_FRF_MICROWIRE = 0x2
	// This combination is not supported and should not be used.
	SSP_CR0_FRF_THIS_COMBINATION_IS_ = 0x3
	// Position of CPOL field.
	SSP_CR0_CPOL_Pos = 0x6
	// Bit mask of CPOL field.
	SSP_CR0_CPOL_Msk = 0x40
	// Bit CPOL.
	SSP_CR0_CPOL = 0x40
	// SSP controller maintains the bus clock low between frames.
	SSP_CR0_CPOL_BUS_LOW = 0x0
	// SSP controller maintains the bus clock high between frames.
	SSP_CR0_CPOL_BUS_HIGH = 0x1
	// Position of CPHA field.
	SSP_CR0_CPHA_Pos = 0x7
	// Bit mask of CPHA field.
	SSP_CR0_CPHA_Msk = 0x80
	// Bit CPHA.
	SSP_CR0_CPHA = 0x80
	// SSP controller captures serial data on the first clock transition of the frame, that is, the transition away from the inter-frame state of the clock line.
	SSP_CR0_CPHA_FIRST_CLOCK = 0x0
	// SSP controller captures serial data on the second clock transition of the frame, that is, the transition back to the inter-frame state of the clock line.
	SSP_CR0_CPHA_SECOND_CLOCK = 0x1
	// Position of SCR field.
	SSP_CR0_SCR_Pos = 0x8
	// Bit mask of SCR field.
	SSP_CR0_SCR_Msk = 0xff00
	// Position of RESERVED field.
	SSP_CR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP_CR0_RESERVED_Msk = 0xffff0000

	// CR1: Control Register 1. Selects master/slave and other modes.
	// Position of LBM field.
	SSP_CR1_LBM_Pos = 0x0
	// Bit mask of LBM field.
	SSP_CR1_LBM_Msk = 0x1
	// Bit LBM.
	SSP_CR1_LBM = 0x1
	// During normal operation.
	SSP_CR1_LBM_NORMAL = 0x0
	// Serial input is taken from the serial output (MOSI or MISO) rather than the serial input pin (MISO or MOSI respectively).
	SSP_CR1_LBM_OUPTU = 0x1
	// Position of SSE field.
	SSP_CR1_SSE_Pos = 0x1
	// Bit mask of SSE field.
	SSP_CR1_SSE_Msk = 0x2
	// Bit SSE.
	SSP_CR1_SSE = 0x2
	// The SSP controller is disabled.
	SSP_CR1_SSE_DISABLED = 0x0
	// The SSP controller will interact with other devices on the serial bus. Software should write the appropriate control information to the other SSP registers and interrupt controller registers, before setting this bit.
	SSP_CR1_SSE_ENABLED = 0x1
	// Position of MS field.
	SSP_CR1_MS_Pos = 0x2
	// Bit mask of MS field.
	SSP_CR1_MS_Msk = 0x4
	// Bit MS.
	SSP_CR1_MS = 0x4
	// The SSP controller acts as a master on the bus, driving the SCLK, MOSI, and SSEL lines and receiving the MISO line.
	SSP_CR1_MS_MASTER = 0x0
	// The SSP controller acts as a slave on the bus, driving MISO line and receiving SCLK, MOSI, and SSEL lines.
	SSP_CR1_MS_SLAVE = 0x1
	// Position of SOD field.
	SSP_CR1_SOD_Pos = 0x3
	// Bit mask of SOD field.
	SSP_CR1_SOD_Msk = 0x8
	// Bit SOD.
	SSP_CR1_SOD = 0x8
	// Position of RESERVED field.
	SSP_CR1_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP_CR1_RESERVED_Msk = 0xfffffff0

	// DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
	// Position of DATA field.
	SSP_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SSP_DR_DATA_Msk = 0xffff
	// Position of RESERVED field.
	SSP_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP_DR_RESERVED_Msk = 0xffff0000

	// SR: Status Register
	// Position of TFE field.
	SSP_SR_TFE_Pos = 0x0
	// Bit mask of TFE field.
	SSP_SR_TFE_Msk = 0x1
	// Bit TFE.
	SSP_SR_TFE = 0x1
	// Position of TNF field.
	SSP_SR_TNF_Pos = 0x1
	// Bit mask of TNF field.
	SSP_SR_TNF_Msk = 0x2
	// Bit TNF.
	SSP_SR_TNF = 0x2
	// Position of RNE field.
	SSP_SR_RNE_Pos = 0x2
	// Bit mask of RNE field.
	SSP_SR_RNE_Msk = 0x4
	// Bit RNE.
	SSP_SR_RNE = 0x4
	// Position of RFF field.
	SSP_SR_RFF_Pos = 0x3
	// Bit mask of RFF field.
	SSP_SR_RFF_Msk = 0x8
	// Bit RFF.
	SSP_SR_RFF = 0x8
	// Position of BSY field.
	SSP_SR_BSY_Pos = 0x4
	// Bit mask of BSY field.
	SSP_SR_BSY_Msk = 0x10
	// Bit BSY.
	SSP_SR_BSY = 0x10
	// Position of RESERVED field.
	SSP_SR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SSP_SR_RESERVED_Msk = 0xffffffe0

	// CPSR: Clock Prescale Register
	// Position of CPSDVSR field.
	SSP_CPSR_CPSDVSR_Pos = 0x0
	// Bit mask of CPSDVSR field.
	SSP_CPSR_CPSDVSR_Msk = 0xff
	// Position of RESERVED field.
	SSP_CPSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SSP_CPSR_RESERVED_Msk = 0xffffff00

	// IMSC: Interrupt Mask Set and Clear Register
	// Position of RORIM field.
	SSP_IMSC_RORIM_Pos = 0x0
	// Bit mask of RORIM field.
	SSP_IMSC_RORIM_Msk = 0x1
	// Bit RORIM.
	SSP_IMSC_RORIM = 0x1
	// Position of RTIM field.
	SSP_IMSC_RTIM_Pos = 0x1
	// Bit mask of RTIM field.
	SSP_IMSC_RTIM_Msk = 0x2
	// Bit RTIM.
	SSP_IMSC_RTIM = 0x2
	// Position of RXIM field.
	SSP_IMSC_RXIM_Pos = 0x2
	// Bit mask of RXIM field.
	SSP_IMSC_RXIM_Msk = 0x4
	// Bit RXIM.
	SSP_IMSC_RXIM = 0x4
	// Position of TXIM field.
	SSP_IMSC_TXIM_Pos = 0x3
	// Bit mask of TXIM field.
	SSP_IMSC_TXIM_Msk = 0x8
	// Bit TXIM.
	SSP_IMSC_TXIM = 0x8
	// Position of RESERVED field.
	SSP_IMSC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP_IMSC_RESERVED_Msk = 0xfffffff0

	// RIS: Raw Interrupt Status Register
	// Position of RORRIS field.
	SSP_RIS_RORRIS_Pos = 0x0
	// Bit mask of RORRIS field.
	SSP_RIS_RORRIS_Msk = 0x1
	// Bit RORRIS.
	SSP_RIS_RORRIS = 0x1
	// Position of RTRIS field.
	SSP_RIS_RTRIS_Pos = 0x1
	// Bit mask of RTRIS field.
	SSP_RIS_RTRIS_Msk = 0x2
	// Bit RTRIS.
	SSP_RIS_RTRIS = 0x2
	// Position of RXRIS field.
	SSP_RIS_RXRIS_Pos = 0x2
	// Bit mask of RXRIS field.
	SSP_RIS_RXRIS_Msk = 0x4
	// Bit RXRIS.
	SSP_RIS_RXRIS = 0x4
	// Position of TXRIS field.
	SSP_RIS_TXRIS_Pos = 0x3
	// Bit mask of TXRIS field.
	SSP_RIS_TXRIS_Msk = 0x8
	// Bit TXRIS.
	SSP_RIS_TXRIS = 0x8
	// Position of RESERVED field.
	SSP_RIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP_RIS_RESERVED_Msk = 0xfffffff0

	// MIS: Masked Interrupt Status Register
	// Position of RORMIS field.
	SSP_MIS_RORMIS_Pos = 0x0
	// Bit mask of RORMIS field.
	SSP_MIS_RORMIS_Msk = 0x1
	// Bit RORMIS.
	SSP_MIS_RORMIS = 0x1
	// Position of RTMIS field.
	SSP_MIS_RTMIS_Pos = 0x1
	// Bit mask of RTMIS field.
	SSP_MIS_RTMIS_Msk = 0x2
	// Bit RTMIS.
	SSP_MIS_RTMIS = 0x2
	// Position of RXMIS field.
	SSP_MIS_RXMIS_Pos = 0x2
	// Bit mask of RXMIS field.
	SSP_MIS_RXMIS_Msk = 0x4
	// Bit RXMIS.
	SSP_MIS_RXMIS = 0x4
	// Position of TXMIS field.
	SSP_MIS_TXMIS_Pos = 0x3
	// Bit mask of TXMIS field.
	SSP_MIS_TXMIS_Msk = 0x8
	// Bit TXMIS.
	SSP_MIS_TXMIS = 0x8
	// Position of RESERVED field.
	SSP_MIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP_MIS_RESERVED_Msk = 0xfffffff0

	// ICR: SSPICR Interrupt Clear Register
	// Position of RORIC field.
	SSP_ICR_RORIC_Pos = 0x0
	// Bit mask of RORIC field.
	SSP_ICR_RORIC_Msk = 0x1
	// Bit RORIC.
	SSP_ICR_RORIC = 0x1
	// Position of RTIC field.
	SSP_ICR_RTIC_Pos = 0x1
	// Bit mask of RTIC field.
	SSP_ICR_RTIC_Msk = 0x2
	// Bit RTIC.
	SSP_ICR_RTIC = 0x2
	// Position of RESERVED field.
	SSP_ICR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SSP_ICR_RESERVED_Msk = 0xfffffffc

	// DMACR: SSP0 DMA control register
	// Position of RXDMAE field.
	SSP_DMACR_RXDMAE_Pos = 0x0
	// Bit mask of RXDMAE field.
	SSP_DMACR_RXDMAE_Msk = 0x1
	// Bit RXDMAE.
	SSP_DMACR_RXDMAE = 0x1
	// Position of TXDMAE field.
	SSP_DMACR_TXDMAE_Pos = 0x1
	// Bit mask of TXDMAE field.
	SSP_DMACR_TXDMAE_Msk = 0x2
	// Bit TXDMAE.
	SSP_DMACR_TXDMAE = 0x2
	// Position of RESERVED field.
	SSP_DMACR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SSP_DMACR_RESERVED_Msk = 0xfffffffc
)

// Bitfields for TIMER0: Timer0/1/2/3
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	TIMER_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	TIMER_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	TIMER_IR_MR0INT = 0x1
	// Position of MR1INT field.
	TIMER_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	TIMER_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	TIMER_IR_MR1INT = 0x2
	// Position of MR2INT field.
	TIMER_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	TIMER_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	TIMER_IR_MR2INT = 0x4
	// Position of MR3INT field.
	TIMER_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	TIMER_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	TIMER_IR_MR3INT = 0x8
	// Position of CR0INT field.
	TIMER_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	TIMER_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	TIMER_IR_CR0INT = 0x10
	// Position of CR1INT field.
	TIMER_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	TIMER_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	TIMER_IR_CR1INT = 0x20
	// Position of CR2INT field.
	TIMER_IR_CR2INT_Pos = 0x6
	// Bit mask of CR2INT field.
	TIMER_IR_CR2INT_Msk = 0x40
	// Bit CR2INT.
	TIMER_IR_CR2INT = 0x40
	// Position of CR3INT field.
	TIMER_IR_CR3INT_Pos = 0x7
	// Bit mask of CR3INT field.
	TIMER_IR_CR3INT_Msk = 0x80
	// Bit CR3INT.
	TIMER_IR_CR3INT = 0x80
	// Position of RESERVED field.
	TIMER_IR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	TIMER_IR_RESERVED_Msk = 0xffffff00

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	TIMER_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIMER_TCR_CEN_Msk = 0x1
	// Bit CEN.
	TIMER_TCR_CEN = 0x1
	// Position of CRST field.
	TIMER_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	TIMER_TCR_CRST_Msk = 0x2
	// Bit CRST.
	TIMER_TCR_CRST = 0x2
	// Position of RESERVED field.
	TIMER_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	TIMER_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	TIMER_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	TIMER_TC_TC_Msk = 0xffffffff

	// PR: Prescale Register. When the Prescale Counter (PC) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PM field.
	TIMER_PR_PM_Pos = 0x0
	// Bit mask of PM field.
	TIMER_PR_PM_Msk = 0xffffffff

	// PC: Prescale Counter. The 32 bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	TIMER_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	TIMER_PC_PC_Msk = 0xffffffff

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	TIMER_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	TIMER_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	TIMER_MCR_MR0I = 0x1
	// Disabled. Interrupt is disabled
	TIMER_MCR_MR0I_DISABLED = 0x0
	// Enabled. Interrupt is generated when MR0 matches the value in the TC.
	TIMER_MCR_MR0I_ENABLED = 0x1
	// Position of MR0R field.
	TIMER_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	TIMER_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	TIMER_MCR_MR0R = 0x2
	// Disabled. Feature disabled.
	TIMER_MCR_MR0R_DISABLED = 0x0
	// Reset. TC will be reset if MR0 matches it.
	TIMER_MCR_MR0R_RESET = 0x1
	// Position of MR0S field.
	TIMER_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	TIMER_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	TIMER_MCR_MR0S = 0x4
	// Disabled. Feature disabled.
	TIMER_MCR_MR0S_DISABLED = 0x0
	// Match. TC and PC will be stopped and TCR[0] will be set to 0 if MR0 matches the TC.
	TIMER_MCR_MR0S_MATCH = 0x1
	// Position of MR1I field.
	TIMER_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	TIMER_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	TIMER_MCR_MR1I = 0x8
	// Disabled. Interrupt is disabled.
	TIMER_MCR_MR1I_DISABLED = 0x0
	// Match. Interrupt is generated when MR1 matches the value in the TC.
	TIMER_MCR_MR1I_MATCH = 0x1
	// Position of MR1R field.
	TIMER_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	TIMER_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	TIMER_MCR_MR1R = 0x10
	// Disabled. Feature disabled.
	TIMER_MCR_MR1R_DISABLED = 0x0
	// Reset. TC will be reset if MR1 matches it.
	TIMER_MCR_MR1R_RESET = 0x1
	// Position of MR1S field.
	TIMER_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	TIMER_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	TIMER_MCR_MR1S = 0x20
	// Disabled. Feature disabled.
	TIMER_MCR_MR1S_DISABLED = 0x0
	// Stop. TC and PC will be stopped and TCR[0] will be set to 0 if MR1 matches the TC.
	TIMER_MCR_MR1S_STOP = 0x1
	// Position of MR2I field.
	TIMER_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	TIMER_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	TIMER_MCR_MR2I = 0x40
	// Disabled. Interrupt is disabled
	TIMER_MCR_MR2I_DISABLED = 0x0
	// Match. Interrupt is generated when MR2 matches the value in the TC.
	TIMER_MCR_MR2I_MATCH = 0x1
	// Position of MR2R field.
	TIMER_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	TIMER_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	TIMER_MCR_MR2R = 0x80
	// Disabled. Feature disabled.
	TIMER_MCR_MR2R_DISABLED = 0x0
	// Match. TC will be reset if MR2 matches it.
	TIMER_MCR_MR2R_MATCH = 0x1
	// Position of MR2S field.
	TIMER_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	TIMER_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	TIMER_MCR_MR2S = 0x100
	// Disabled. Feature disabled.
	TIMER_MCR_MR2S_DISABLED = 0x0
	// Stop. TC and PC will be stopped and TCR[0] will be set to 0 if MR2 matches the TC.
	TIMER_MCR_MR2S_STOP = 0x1
	// Position of MR3I field.
	TIMER_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	TIMER_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	TIMER_MCR_MR3I = 0x200
	// Disabled. This interrupt is disabled.
	TIMER_MCR_MR3I_DISABLED = 0x0
	// Interrupt. Interrupt is generated when MR3 matches the value in the TC.
	TIMER_MCR_MR3I_INTERRUPT = 0x1
	// Position of MR3R field.
	TIMER_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	TIMER_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	TIMER_MCR_MR3R = 0x400
	// Disabled. Feature disabled.
	TIMER_MCR_MR3R_DISABLED = 0x0
	// Match. TC will be reset if MR3 matches it.
	TIMER_MCR_MR3R_MATCH = 0x1
	// Position of MR3S field.
	TIMER_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	TIMER_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	TIMER_MCR_MR3S = 0x800
	// Disabled. Feature disabled.
	TIMER_MCR_MR3S_DISABLED = 0x0
	// Stop. TC and PC will be stopped and TCR[0] will be set to 0 if MR3 matches the TC.
	TIMER_MCR_MR3S_STOP = 0x1
	// Position of RESERVED field.
	TIMER_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	TIMER_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register 0. MR0 can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	TIMER_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	TIMER_MR_MATCH_Msk = 0xffffffff

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	TIMER_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	TIMER_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	TIMER_CCR_CAP0RE = 0x1
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP0RE_DISABLED = 0x0
	// Low to high. A sequence of 0 then 1 on CAPn.0 will cause CR0 to be loaded with the contents of TC.
	TIMER_CCR_CAP0RE_LOW_TO_HIGH = 0x1
	// Position of CAP0FE field.
	TIMER_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	TIMER_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	TIMER_CCR_CAP0FE = 0x2
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP0FE_DISABLED = 0x0
	// High to low. A sequence of 1 then 0 on CAPn.0 will cause CR0 to be loaded with the contents of TC.
	TIMER_CCR_CAP0FE_HIGH_TO_LOW = 0x1
	// Position of CAP0I field.
	TIMER_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	TIMER_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	TIMER_CCR_CAP0I = 0x4
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP0I_DISABLED = 0x0
	// Load. A CR0 load due to a CAPn.0 event will generate an interrupt.
	TIMER_CCR_CAP0I_LOAD = 0x1
	// Position of CAP1RE field.
	TIMER_CCR_CAP1RE_Pos = 0x3
	// Bit mask of CAP1RE field.
	TIMER_CCR_CAP1RE_Msk = 0x8
	// Bit CAP1RE.
	TIMER_CCR_CAP1RE = 0x8
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP1RE_DISABLED = 0x0
	// Low to high. A sequence of 0 then 1 on CAPn.1 will cause CR1 to be loaded with the contents of TC.
	TIMER_CCR_CAP1RE_LOW_TO_HIGH = 0x1
	// Position of CAP1FE field.
	TIMER_CCR_CAP1FE_Pos = 0x4
	// Bit mask of CAP1FE field.
	TIMER_CCR_CAP1FE_Msk = 0x10
	// Bit CAP1FE.
	TIMER_CCR_CAP1FE = 0x10
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP1FE_DISABLED = 0x0
	// High to low. A sequence of 1 then 0 on CAPn.1 will cause CR1 to be loaded with the contents of TC.
	TIMER_CCR_CAP1FE_HIGH_TO_LOW = 0x1
	// Position of CAP1I field.
	TIMER_CCR_CAP1I_Pos = 0x5
	// Bit mask of CAP1I field.
	TIMER_CCR_CAP1I_Msk = 0x20
	// Bit CAP1I.
	TIMER_CCR_CAP1I = 0x20
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP1I_DISABLED = 0x0
	// Load. A CR1 load due to a CAPn.1 event will generate an interrupt.
	TIMER_CCR_CAP1I_LOAD = 0x1
	// Position of CAP2RE field.
	TIMER_CCR_CAP2RE_Pos = 0x6
	// Bit mask of CAP2RE field.
	TIMER_CCR_CAP2RE_Msk = 0x40
	// Bit CAP2RE.
	TIMER_CCR_CAP2RE = 0x40
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP2RE_DISABLED = 0x0
	// Low to high. A sequence of 0 then 1 on CAPn.2 will cause CR2 to be loaded with the contents of TC.
	TIMER_CCR_CAP2RE_LOW_TO_HIGH = 0x1
	// Position of CAP2FE field.
	TIMER_CCR_CAP2FE_Pos = 0x7
	// Bit mask of CAP2FE field.
	TIMER_CCR_CAP2FE_Msk = 0x80
	// Bit CAP2FE.
	TIMER_CCR_CAP2FE = 0x80
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP2FE_DISABLED = 0x0
	// High to low. A sequence of 1 then 0 on CAPn.2 will cause CR2 to be loaded with the contents of TC.
	TIMER_CCR_CAP2FE_HIGH_TO_LOW = 0x1
	// Position of CAP2I field.
	TIMER_CCR_CAP2I_Pos = 0x8
	// Bit mask of CAP2I field.
	TIMER_CCR_CAP2I_Msk = 0x100
	// Bit CAP2I.
	TIMER_CCR_CAP2I = 0x100
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP2I_DISABLED = 0x0
	// Load. A CR2 load due to a CAPn.2 event will generate an interrupt.
	TIMER_CCR_CAP2I_LOAD = 0x1
	// Position of CAP3RE field.
	TIMER_CCR_CAP3RE_Pos = 0x9
	// Bit mask of CAP3RE field.
	TIMER_CCR_CAP3RE_Msk = 0x200
	// Bit CAP3RE.
	TIMER_CCR_CAP3RE = 0x200
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP3RE_DISABLED = 0x0
	// Low to high. A sequence of 0 then 1 on CAPn.3 will cause CR3 to be loaded with the contents of TC.
	TIMER_CCR_CAP3RE_LOW_TO_HIGH = 0x1
	// Position of CAP3FE field.
	TIMER_CCR_CAP3FE_Pos = 0xa
	// Bit mask of CAP3FE field.
	TIMER_CCR_CAP3FE_Msk = 0x400
	// Bit CAP3FE.
	TIMER_CCR_CAP3FE = 0x400
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP3FE_DISABLED = 0x0
	// A sequence of 1 then 0 on CAPn.3 will cause CR3 to be loaded with the contents of TC.
	TIMER_CCR_CAP3FE_HIGH_TO_LOW = 0x1
	// Position of CAP3I field.
	TIMER_CCR_CAP3I_Pos = 0xb
	// Bit mask of CAP3I field.
	TIMER_CCR_CAP3I_Msk = 0x800
	// Bit CAP3I.
	TIMER_CCR_CAP3I = 0x800
	// Disabled. This feature is disabled.
	TIMER_CCR_CAP3I_DISABLED = 0x0
	// Load. A CR3 load due to a CAPn.3 event will generate an interrupt.
	TIMER_CCR_CAP3I_LOAD = 0x1
	// Position of RESERVED field.
	TIMER_CCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	TIMER_CCR_RESERVED_Msk = 0xfffff000

	// CR0: Capture Register 0. CR0 is loaded with the value of TC when there is an event on the CAPn.0 input.
	// Position of CAP field.
	TIMER_CR_CAP_Pos = 0x0
	// Bit mask of CAP field.
	TIMER_CR_CAP_Msk = 0xffffffff

	// EMR: External Match Register. The EMR controls the external match pins MATn.0-3 (MAT0.0-3 and MAT1.0-3 respectively).
	// Position of EM0 field.
	TIMER_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	TIMER_EMR_EM0_Msk = 0x1
	// Bit EM0.
	TIMER_EMR_EM0 = 0x1
	// Position of EM1 field.
	TIMER_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	TIMER_EMR_EM1_Msk = 0x2
	// Bit EM1.
	TIMER_EMR_EM1 = 0x2
	// Position of EM2 field.
	TIMER_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	TIMER_EMR_EM2_Msk = 0x4
	// Bit EM2.
	TIMER_EMR_EM2 = 0x4
	// Position of EM3 field.
	TIMER_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	TIMER_EMR_EM3_Msk = 0x8
	// Bit EM3.
	TIMER_EMR_EM3 = 0x8
	// Position of EMC0 field.
	TIMER_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	TIMER_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	TIMER_EMR_EMC0_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER_EMR_EMC0_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER_EMR_EMC0_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	TIMER_EMR_EMC0_TOGGLE = 0x3
	// Position of EMC1 field.
	TIMER_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	TIMER_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	TIMER_EMR_EMC1_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER_EMR_EMC1_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER_EMR_EMC1_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	TIMER_EMR_EMC1_TOGGLE = 0x3
	// Position of EMC2 field.
	TIMER_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	TIMER_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	TIMER_EMR_EMC2_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER_EMR_EMC2_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER_EMR_EMC2_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	TIMER_EMR_EMC2_TOGGLE = 0x3
	// Position of EMC3 field.
	TIMER_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	TIMER_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	TIMER_EMR_EMC3_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER_EMR_EMC3_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER_EMR_EMC3_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	TIMER_EMR_EMC3_TOGGLE = 0x3
	// Position of RESERVED field.
	TIMER_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	TIMER_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTMODE field.
	TIMER_CTCR_CTMODE_Pos = 0x0
	// Bit mask of CTMODE field.
	TIMER_CTCR_CTMODE_Msk = 0x3
	// Timer Mode. Counts every rising PCLK edge
	TIMER_CTCR_CTMODE_TIMER_MODE = 0x0
	// Counter Mode rising edge. TC is incremented on rising edges on the CAP input selected by bits 3:2.
	TIMER_CTCR_CTMODE_COUNTER_MODE_RISING = 0x1
	// Counter Mode falling edge. TC is incremented on falling edges on the CAP input selected by bits 3:2.
	TIMER_CTCR_CTMODE_COUNTER_MODE_FALLING = 0x2
	// Counter Mode edges. TC is incremented on both edges on the CAP input selected by bits 3:2.
	TIMER_CTCR_CTMODE_COUNTER_MODE_EDGES = 0x3
	// Position of CINSEL field.
	TIMER_CTCR_CINSEL_Pos = 0x2
	// Bit mask of CINSEL field.
	TIMER_CTCR_CINSEL_Msk = 0xc
	// CAP0. CAPn.0 for TIMERn
	TIMER_CTCR_CINSEL_CAP0 = 0x0
	// CAP1. CAPn.1 for TIMERn
	TIMER_CTCR_CINSEL_CAP1 = 0x1
	// CAP2. CAPn.2 for TIMERn
	TIMER_CTCR_CINSEL_CAP2 = 0x2
	// CAP3. CAPn.3 for TIMERn
	TIMER_CTCR_CINSEL_CAP3 = 0x3
	// Position of RESERVED field.
	TIMER_CTCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	TIMER_CTCR_RESERVED_Msk = 0xfffffff0
)

// Bitfields for SCU: System Control Unit (SCU) I/O configuration
const (
	// SFSP0_0: Pin configuration register for pins P0
	// Position of MODE field.
	SCU_SFSP0_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP0_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP0_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP0_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP0_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP0_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP0_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP0_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP0_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP0_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP0_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP0_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP0_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP0_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP0_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP0_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP0_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP0_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP0_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP0_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP0_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP0_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP0_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP0_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP0_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP0_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP0_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP0_EZI = 0x40
	// Disable input buffer
	SCU_SFSP0_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP0_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP0_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP0_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP0_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP0_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP0_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP0_RESERVED_Msk = 0xffffff00

	// SFSP1_0: Pin configuration register for pins P1
	// Position of MODE field.
	SCU_SFSP1_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP1_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP1_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP1_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP1_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP1_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP1_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP1_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP1_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP1_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP1_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP1_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP1_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP1_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP1_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP1_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP1_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP1_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP1_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP1_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP1_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP1_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP1_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP1_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP1_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP1_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP1_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP1_EZI = 0x40
	// Disable input buffer
	SCU_SFSP1_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP1_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP1_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP1_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP1_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP1_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP1_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP1_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP1_RESERVED_Msk = 0xffffff00

	// SFSP1_17: Pin configuration register for pins P1_17
	// Position of MODE field.
	SCU_SFSP1_17_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP1_17_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP1_17_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP1_17_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP1_17_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP1_17_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP1_17_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP1_17_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP1_17_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP1_17_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP1_17_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP1_17_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP1_17_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP1_17_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP1_17_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP1_17_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP1_17_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP1_17_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP1_17_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up
	SCU_SFSP1_17_EPUN_DISABLE_PULL_UP = 0x1
	// Position of RESERVED field.
	SCU_SFSP1_17_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCU_SFSP1_17_RESERVED_Msk = 0x20
	// Bit RESERVED.
	SCU_SFSP1_17_RESERVED = 0x20
	// Position of EZI field.
	SCU_SFSP1_17_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP1_17_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP1_17_EZI = 0x40
	// Disable input buffer
	SCU_SFSP1_17_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP1_17_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP1_17_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP1_17_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP1_17_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP1_17_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP1_17_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of EHD field.
	SCU_SFSP1_17_EHD_Pos = 0x8
	// Bit mask of EHD field.
	SCU_SFSP1_17_EHD_Msk = 0x300
	// Normal-drive: 4 mA drive strength
	SCU_SFSP1_17_EHD_NORMAL_DRIVE_4_MA_D = 0x0
	// Medium-drive: 8 mA drive strength
	SCU_SFSP1_17_EHD_MEDIUM_DRIVE_8_MA_D = 0x1
	// High-drive: 14 mA drive strength
	SCU_SFSP1_17_EHD_HIGH_DRIVE_14_MA_DR = 0x2
	// Ultra high-drive: 20 mA drive strength
	SCU_SFSP1_17_EHD_ULTRA_HIGH_DRIVE_20 = 0x3
	// Position of RESERVED field.
	SCU_SFSP1_17_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCU_SFSP1_17_RESERVED_Msk = 0xfffffc00

	// SFSP1_18: Pin configuration register for pins P1
	// Position of MODE field.
	SCU_SFSP1_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP1_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP1_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP1_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP1_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP1_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP1_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP1_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP1_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP1_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP1_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP1_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP1_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP1_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP1_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP1_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP1_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP1_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP1_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP1_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP1_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP1_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP1_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP1_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP1_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP1_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP1_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP1_EZI = 0x40
	// Disable input buffer
	SCU_SFSP1_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP1_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP1_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP1_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP1_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP1_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP1_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP1_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP1_RESERVED_Msk = 0xffffff00

	// SFSP2_0: Pin configuration register for pins P2
	// Position of MODE field.
	SCU_SFSP2_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP2_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP2_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP2_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP2_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP2_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP2_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP2_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP2_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP2_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP2_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP2_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP2_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP2_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP2_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP2_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP2_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP2_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP2_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP2_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP2_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP2_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP2_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP2_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP2_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP2_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP2_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP2_EZI = 0x40
	// Disable input buffer
	SCU_SFSP2_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP2_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP2_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP2_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP2_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP2_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP2_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP2_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP2_RESERVED_Msk = 0xffffff00

	// SFSP2_3: Pin configuration register for pins P2
	// Position of MODE field.
	SCU_SFSP2_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP2_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP2_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP2_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP2_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP2_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP2_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP2_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP2_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP2_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP2_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP2_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP2_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP2_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP2_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP2_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP2_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP2_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP2_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up
	SCU_SFSP2_EPUN_DISABLE_PULL_UP = 0x1
	// Position of RESERVED field.
	SCU_SFSP2_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCU_SFSP2_RESERVED_Msk = 0x20
	// Bit RESERVED.
	SCU_SFSP2_RESERVED = 0x20
	// Position of EZI field.
	SCU_SFSP2_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP2_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP2_EZI = 0x40
	// Disable input buffer
	SCU_SFSP2_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP2_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP2_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP2_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP2_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP2_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP2_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of EHD field.
	SCU_SFSP2_EHD_Pos = 0x8
	// Bit mask of EHD field.
	SCU_SFSP2_EHD_Msk = 0x300
	// Normal-drive: 4 mA drive strength
	SCU_SFSP2_EHD_NORMAL_DRIVE_4_MA_D = 0x0
	// Medium-drive: 8 mA drive strength
	SCU_SFSP2_EHD_MEDIUM_DRIVE_8_MA_D = 0x1
	// High-drive: 14 mA drive strength
	SCU_SFSP2_EHD_HIGH_DRIVE_14_MA_DR = 0x2
	// Ultra high-drive: 20 mA drive strength
	SCU_SFSP2_EHD_ULTRA_HIGH_DRIVE_20 = 0x3
	// Position of RESERVED field.
	SCU_SFSP2_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCU_SFSP2_RESERVED_Msk = 0xfffffc00

	// SFSP2_6: Pin configuration register for pins P2
	// Position of MODE field.
	SCU_SFSP2_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP2_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP2_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP2_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP2_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP2_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP2_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP2_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP2_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP2_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP2_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP2_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP2_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP2_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP2_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP2_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP2_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP2_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP2_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP2_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP2_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP2_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP2_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP2_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP2_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP2_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP2_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP2_EZI = 0x40
	// Disable input buffer
	SCU_SFSP2_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP2_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP2_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP2_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP2_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP2_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP2_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP2_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP2_RESERVED_Msk = 0xffffff00

	// SFSP3_0: Pin configuration register for pins P3
	// Position of MODE field.
	SCU_SFSP3_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP3_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP3_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP3_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP3_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP3_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP3_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP3_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP3_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP3_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP3_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP3_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP3_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP3_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP3_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP3_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP3_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP3_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP3_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP3_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP3_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP3_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP3_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP3_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP3_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP3_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP3_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP3_EZI = 0x40
	// Disable input buffer
	SCU_SFSP3_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP3_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP3_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP3_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP3_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP3_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP3_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP3_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP3_RESERVED_Msk = 0xffffff00

	// SFSP3_3: Pin configuration register for pins P3
	// Position of MODE field.
	SCU_SFSP3_3_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP3_3_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP3_3_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP3_3_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP3_3_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP3_3_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP3_3_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP3_3_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP3_3_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP3_3_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP3_3_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP3_3_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP3_3_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP3_3_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP3_3_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP3_3_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP3_3_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP3_3_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP3_3_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP3_3_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP3_3_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP3_3_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP3_3_EHS = 0x20
	// Fast (low noise with fast speed)
	SCU_SFSP3_3_EHS_FAST_LOW_NOISE_WITH = 0x0
	// High-speed (medium noise with high speed)
	SCU_SFSP3_3_EHS_HIGH_SPEED_MEDIUM_N = 0x1
	// Position of EZI field.
	SCU_SFSP3_3_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP3_3_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP3_3_EZI = 0x40
	// Disable input buffer
	SCU_SFSP3_3_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP3_3_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP3_3_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP3_3_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP3_3_ZIF = 0x80
	// Enable input filter
	SCU_SFSP3_3_ZIF_ENABLE_INPUT_FILTER = 0x0
	// Disable input filter
	SCU_SFSP3_3_ZIF_DISABLE_INPUT_FILTER = 0x1
	// Position of RESERVED field.
	SCU_SFSP3_3_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP3_3_RESERVED_Msk = 0xffffff00

	// SFSP3_4: Pin configuration register for pins P3
	// Position of MODE field.
	SCU_SFSP3_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP3_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP3_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP3_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP3_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP3_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP3_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP3_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP3_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP3_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP3_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP3_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP3_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP3_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP3_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP3_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP3_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP3_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP3_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP3_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP3_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP3_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP3_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP3_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP3_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP3_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP3_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP3_EZI = 0x40
	// Disable input buffer
	SCU_SFSP3_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP3_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP3_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP3_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP3_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP3_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP3_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP3_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP3_RESERVED_Msk = 0xffffff00

	// SFSP4_0: Pin configuration register for pins P4
	// Position of MODE field.
	SCU_SFSP4_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP4_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP4_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP4_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP4_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP4_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP4_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP4_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP4_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP4_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP4_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP4_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP4_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP4_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP4_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP4_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP4_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP4_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP4_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP4_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP4_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP4_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP4_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP4_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP4_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP4_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP4_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP4_EZI = 0x40
	// Disable input buffer
	SCU_SFSP4_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP4_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP4_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP4_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP4_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP4_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP4_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP4_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP4_RESERVED_Msk = 0xffffff00

	// SFSP5_0: Pin configuration register for pins P5
	// Position of MODE field.
	SCU_SFSP5_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP5_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP5_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP5_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP5_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP5_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP5_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP5_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP5_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP5_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP5_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP5_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP5_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP5_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP5_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP5_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP5_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP5_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP5_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP5_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP5_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP5_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP5_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP5_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP5_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP5_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP5_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP5_EZI = 0x40
	// Disable input buffer
	SCU_SFSP5_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP5_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP5_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP5_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP5_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP5_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP5_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP5_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP5_RESERVED_Msk = 0xffffff00

	// SFSP6_0: Pin configuration register for pins P6
	// Position of MODE field.
	SCU_SFSP6_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP6_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP6_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP6_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP6_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP6_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP6_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP6_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP6_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP6_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP6_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP6_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP6_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP6_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP6_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP6_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP6_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP6_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP6_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP6_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP6_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP6_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP6_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP6_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP6_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP6_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP6_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP6_EZI = 0x40
	// Disable input buffer
	SCU_SFSP6_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP6_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP6_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP6_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP6_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP6_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP6_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP6_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP6_RESERVED_Msk = 0xffffff00

	// SFSP7_0: Pin configuration register for pins P7
	// Position of MODE field.
	SCU_SFSP7_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP7_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP7_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP7_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP7_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP7_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP7_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP7_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP7_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP7_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP7_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP7_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP7_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP7_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP7_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP7_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP7_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP7_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP7_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP7_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP7_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP7_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP7_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP7_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP7_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP7_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP7_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP7_EZI = 0x40
	// Disable input buffer
	SCU_SFSP7_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP7_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP7_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP7_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP7_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP7_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP7_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP7_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP7_RESERVED_Msk = 0xffffff00

	// SFSP8_0: Pin configuration register for pins P8
	// Position of MODE field.
	SCU_SFSP8_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP8_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP8_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP8_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP8_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP8_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP8_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP8_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP8_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP8_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP8_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP8_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP8_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP8_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP8_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP8_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP8_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP8_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP8_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP8_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP8_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP8_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP8_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP8_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP8_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP8_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP8_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP8_EZI = 0x40
	// Disable input buffer
	SCU_SFSP8_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP8_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP8_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP8_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP8_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP8_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP8_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP8_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP8_RESERVED_Msk = 0xffffff00

	// SFSP8_3: Pin configuration register for pins P8
	// Position of MODE field.
	SCU_SFSP8_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP8_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP8_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP8_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP8_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP8_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP8_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP8_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP8_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP8_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP8_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP8_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP8_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP8_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP8_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSP8_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP8_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP8_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSP8_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSP8_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP8_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP8_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP8_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSP8_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSP8_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSP8_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP8_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP8_EZI = 0x40
	// Disable input buffer
	SCU_SFSP8_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP8_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSP8_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSP8_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSP8_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSP8_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSP8_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSP8_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSP8_RESERVED_Msk = 0xffffff00

	// SFSP9_0: Pin configuration register for pins P9
	// Position of MODE field.
	SCU_SFSP9_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSP9_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSP9_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSP9_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSP9_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSP9_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSP9_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSP9_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSP9_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSP9_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSP9_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSP9_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSP9_EPD = 0x8
	// Disable pull-down.
	SCU_SFSP9_EPD_DISABLE_PULL_DOWN_ = 0x0
	// Enable pull-down.
	SCU_SFSP9_EPD_ENABLE_PULL_DOWN_ = 0x1
	// Position of EPUN field.
	SCU_SFSP9_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSP9_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSP9_EPUN = 0x10
	// Enable pull-up
	SCU_SFSP9_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up
	SCU_SFSP9_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSP9_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSP9_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSP9_EHS = 0x20
	// Slow
	SCU_SFSP9_EHS_SLOW = 0x0
	// Fast
	SCU_SFSP9_EHS_FAST = 0x1
	// Position of EZI field.
	SCU_SFSP9_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSP9_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSP9_EZI = 0x40
	// Disable input buffer
	SCU_SFSP9_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSP9_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of RESERVED field.
	SCU_SFSP9_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SCU_SFSP9_RESERVED_Msk = 0x80
	// Bit RESERVED.
	SCU_SFSP9_RESERVED = 0x80
	// Position of EHD field.
	SCU_SFSP9_EHD_Pos = 0x8
	// Bit mask of EHD field.
	SCU_SFSP9_EHD_Msk = 0x300
	// Standard drive: 4 mA drive strength
	SCU_SFSP9_EHD_STANDARD_DRIVE_4_MA = 0x0
	// Medium drive: 8 mA drive strength
	SCU_SFSP9_EHD_MEDIUM_DRIVE_8_MA_D = 0x1
	// High drive: 14 mA drive strength
	SCU_SFSP9_EHD_HIGH_DRIVE_14_MA_DR = 0x2
	// Ultra-high drive: 20 mA drive strength
	SCU_SFSP9_EHD_ULTRA_HIGH_DRIVE_20 = 0x3
	// Position of RESERVED field.
	SCU_SFSP9_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCU_SFSP9_RESERVED_Msk = 0xfffffc00

	// SFSPA_0: Pin configuration register for pins PA
	// Position of MODE field.
	SCU_SFSPA_0_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSPA_0_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSPA_0_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSPA_0_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSPA_0_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSPA_0_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSPA_0_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSPA_0_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSPA_0_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSPA_0_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSPA_0_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSPA_0_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSPA_0_EPD = 0x8
	// Disable pull-down.
	SCU_SFSPA_0_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPA_0_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSPA_0_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSPA_0_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSPA_0_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPA_0_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSPA_0_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSPA_0_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSPA_0_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSPA_0_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSPA_0_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSPA_0_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSPA_0_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSPA_0_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSPA_0_EZI = 0x40
	// Disable input buffer
	SCU_SFSPA_0_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSPA_0_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSPA_0_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSPA_0_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSPA_0_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSPA_0_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSPA_0_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSPA_0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSPA_0_RESERVED_Msk = 0xffffff00

	// SFSPA_1: Pin configuration register for pins PA
	// Position of MODE field.
	SCU_SFSPA_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSPA_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSPA_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSPA_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSPA_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSPA_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSPA_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSPA_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSPA_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSPA_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSPA_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSPA_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSPA_EPD = 0x8
	// Disable pull-down.
	SCU_SFSPA_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPA_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSPA_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSPA_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSPA_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPA_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up
	SCU_SFSPA_EPUN_DISABLE_PULL_UP = 0x1
	// Position of RESERVED field.
	SCU_SFSPA_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCU_SFSPA_RESERVED_Msk = 0x20
	// Bit RESERVED.
	SCU_SFSPA_RESERVED = 0x20
	// Position of EZI field.
	SCU_SFSPA_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSPA_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSPA_EZI = 0x40
	// Disable input buffer
	SCU_SFSPA_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSPA_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSPA_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSPA_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSPA_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSPA_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSPA_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of EHD field.
	SCU_SFSPA_EHD_Pos = 0x8
	// Bit mask of EHD field.
	SCU_SFSPA_EHD_Msk = 0x300
	// Normal-drive: 4 mA drive strength
	SCU_SFSPA_EHD_NORMAL_DRIVE_4_MA_D = 0x0
	// Medium-drive: 8 mA drive strength
	SCU_SFSPA_EHD_MEDIUM_DRIVE_8_MA_D = 0x1
	// High-drive: 14 mA drive strength
	SCU_SFSPA_EHD_HIGH_DRIVE_14_MA_DR = 0x2
	// Ultra high-drive: 20 mA drive strength
	SCU_SFSPA_EHD_ULTRA_HIGH_DRIVE_20 = 0x3
	// Position of RESERVED field.
	SCU_SFSPA_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCU_SFSPA_RESERVED_Msk = 0xfffffc00

	// SFSPA_4: Pin configuration register for pins PA
	// Position of MODE field.
	SCU_SFSPA_4_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSPA_4_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSPA_4_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSPA_4_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSPA_4_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSPA_4_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSPA_4_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSPA_4_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSPA_4_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSPA_4_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSPA_4_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSPA_4_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSPA_4_EPD = 0x8
	// Disable pull-down.
	SCU_SFSPA_4_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPA_4_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSPA_4_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSPA_4_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSPA_4_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPA_4_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSPA_4_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSPA_4_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSPA_4_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSPA_4_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSPA_4_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSPA_4_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSPA_4_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSPA_4_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSPA_4_EZI = 0x40
	// Disable input buffer
	SCU_SFSPA_4_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSPA_4_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSPA_4_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSPA_4_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSPA_4_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSPA_4_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSPA_4_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSPA_4_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSPA_4_RESERVED_Msk = 0xffffff00

	// SFSPB_0: Pin configuration register for pins PB
	// Position of MODE field.
	SCU_SFSPB_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSPB_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSPB_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSPB_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSPB_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSPB_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSPB_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSPB_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSPB_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSPB_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSPB_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSPB_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSPB_EPD = 0x8
	// Disable pull-down.
	SCU_SFSPB_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPB_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSPB_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSPB_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSPB_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPB_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSPB_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSPB_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSPB_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSPB_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSPB_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSPB_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSPB_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSPB_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSPB_EZI = 0x40
	// Disable input buffer
	SCU_SFSPB_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSPB_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSPB_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSPB_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSPB_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSPB_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSPB_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSPB_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSPB_RESERVED_Msk = 0xffffff00

	// SFSPC_0: Pin configuration register for pins PC
	// Position of MODE field.
	SCU_SFSPC_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSPC_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSPC_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSPC_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSPC_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSPC_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSPC_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSPC_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSPC_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSPC_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSPC_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSPC_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSPC_EPD = 0x8
	// Disable pull-down.
	SCU_SFSPC_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPC_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSPC_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSPC_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSPC_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPC_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSPC_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSPC_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSPC_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSPC_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSPC_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSPC_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSPC_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSPC_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSPC_EZI = 0x40
	// Disable input buffer
	SCU_SFSPC_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSPC_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSPC_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSPC_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSPC_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSPC_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSPC_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSPC_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSPC_RESERVED_Msk = 0xffffff00

	// SFSPD_0: Pin configuration register for pins PD
	// Position of MODE field.
	SCU_SFSPD_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSPD_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSPD_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSPD_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSPD_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSPD_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSPD_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSPD_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSPD_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSPD_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSPD_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSPD_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSPD_EPD = 0x8
	// Disable pull-down.
	SCU_SFSPD_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPD_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSPD_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSPD_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSPD_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPD_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSPD_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSPD_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSPD_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSPD_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSPD_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSPD_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSPD_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSPD_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSPD_EZI = 0x40
	// Disable input buffer
	SCU_SFSPD_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSPD_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSPD_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSPD_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSPD_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSPD_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSPD_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSPD_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSPD_RESERVED_Msk = 0xffffff00

	// SFSPE_0: Pin configuration register for pins PE
	// Position of MODE field.
	SCU_SFSPE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSPE_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSPE_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSPE_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSPE_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSPE_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSPE_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSPE_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSPE_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSPE_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSPE_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSPE_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSPE_EPD = 0x8
	// Disable pull-down.
	SCU_SFSPE_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPE_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSPE_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSPE_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSPE_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPE_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSPE_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSPE_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSPE_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSPE_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSPE_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSPE_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSPE_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSPE_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSPE_EZI = 0x40
	// Disable input buffer
	SCU_SFSPE_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSPE_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSPE_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSPE_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSPE_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSPE_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSPE_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSPE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSPE_RESERVED_Msk = 0xffffff00

	// SFSPF_0: Pin configuration register for pins PF
	// Position of MODE field.
	SCU_SFSPF_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSPF_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSPF_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSPF_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSPF_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSPF_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSPF_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSPF_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSPF_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSPF_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSPF_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSPF_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSPF_EPD = 0x8
	// Disable pull-down.
	SCU_SFSPF_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down.Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPF_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSPF_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSPF_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSPF_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSPF_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSPF_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSPF_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSPF_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSPF_EHS = 0x20
	// Slow (low noise with medium speed)
	SCU_SFSPF_EHS_SLOW_LOW_NOISE_WITH = 0x0
	// Fast (medium noise with fast speed)
	SCU_SFSPF_EHS_FAST_MEDIUM_NOISE_W = 0x1
	// Position of EZI field.
	SCU_SFSPF_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSPF_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSPF_EZI = 0x40
	// Disable input buffer
	SCU_SFSPF_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSPF_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSPF_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSPF_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSPF_ZIF = 0x80
	// Enable input glitch filter
	SCU_SFSPF_ZIF_ENABLE_INPUT_GLITCH = 0x0
	// Disable input glitch filter
	SCU_SFSPF_ZIF_DISABLE_INPUT_GLITCH = 0x1
	// Position of RESERVED field.
	SCU_SFSPF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSPF_RESERVED_Msk = 0xffffff00

	// SFSCLK_0: Pin configuration register for pins CLK
	// Position of MODE field.
	SCU_SFSCLK_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SCU_SFSCLK_MODE_Msk = 0x7
	// Function 0 (default)
	SCU_SFSCLK_MODE_FUNCTION_0_DEFAULT = 0x0
	// Function 1
	SCU_SFSCLK_MODE_FUNCTION_1 = 0x1
	// Function 2
	SCU_SFSCLK_MODE_FUNCTION_2 = 0x2
	// Function 3
	SCU_SFSCLK_MODE_FUNCTION_3 = 0x3
	// Function 4
	SCU_SFSCLK_MODE_FUNCTION_4 = 0x4
	// Function 5
	SCU_SFSCLK_MODE_FUNCTION_5 = 0x5
	// Function 6
	SCU_SFSCLK_MODE_FUNCTION_6 = 0x6
	// Function 7
	SCU_SFSCLK_MODE_FUNCTION_7 = 0x7
	// Position of EPD field.
	SCU_SFSCLK_EPD_Pos = 0x3
	// Bit mask of EPD field.
	SCU_SFSCLK_EPD_Msk = 0x8
	// Bit EPD.
	SCU_SFSCLK_EPD = 0x8
	// Disable pull-down.
	SCU_SFSCLK_EPD_DISABLE_PULL_DOWN = 0x0
	// Enable pull-down. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSCLK_EPD_ENABLE_PULL_DOWN = 0x1
	// Position of EPUN field.
	SCU_SFSCLK_EPUN_Pos = 0x4
	// Bit mask of EPUN field.
	SCU_SFSCLK_EPUN_Msk = 0x10
	// Bit EPUN.
	SCU_SFSCLK_EPUN = 0x10
	// Enable pull-up. Enable both pull-down resistor and pull-up resistor for repeater mode.
	SCU_SFSCLK_EPUN_ENABLE_PULL_UP = 0x0
	// Disable pull-up.
	SCU_SFSCLK_EPUN_DISABLE_PULL_UP = 0x1
	// Position of EHS field.
	SCU_SFSCLK_EHS_Pos = 0x5
	// Bit mask of EHS field.
	SCU_SFSCLK_EHS_Msk = 0x20
	// Bit EHS.
	SCU_SFSCLK_EHS = 0x20
	// Fast (low noise with fast speed)
	SCU_SFSCLK_EHS_FAST_LOW_NOISE_WITH = 0x0
	// High-speed (medium noise with high speed)
	SCU_SFSCLK_EHS_HIGH_SPEED_MEDIUM_N = 0x1
	// Position of EZI field.
	SCU_SFSCLK_EZI_Pos = 0x6
	// Bit mask of EZI field.
	SCU_SFSCLK_EZI_Msk = 0x40
	// Bit EZI.
	SCU_SFSCLK_EZI = 0x40
	// Disable input buffer
	SCU_SFSCLK_EZI_DISABLE_INPUT_BUFFER = 0x0
	// Enable input buffer
	SCU_SFSCLK_EZI_ENABLE_INPUT_BUFFER = 0x1
	// Position of ZIF field.
	SCU_SFSCLK_ZIF_Pos = 0x7
	// Bit mask of ZIF field.
	SCU_SFSCLK_ZIF_Msk = 0x80
	// Bit ZIF.
	SCU_SFSCLK_ZIF = 0x80
	// Enable input filter
	SCU_SFSCLK_ZIF_ENABLE_INPUT_FILTER = 0x0
	// Disable input filter
	SCU_SFSCLK_ZIF_DISABLE_INPUT_FILTER = 0x1
	// Position of RESERVED field.
	SCU_SFSCLK_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCU_SFSCLK_RESERVED_Msk = 0xffffff00

	// SFSUSB: Pin configuration register for pins USB1_DM and USB1_DP
	// Position of USB_AIM field.
	SCU_SFSUSB_USB_AIM_Pos = 0x0
	// Bit mask of USB_AIM field.
	SCU_SFSUSB_USB_AIM_Msk = 0x1
	// Bit USB_AIM.
	SCU_SFSUSB_USB_AIM = 0x1
	// Going LOW with full speed edge rate
	SCU_SFSUSB_USB_AIM_GOING_LOW_WITH_FULL = 0x0
	// Going HIGH with full speed edge rate
	SCU_SFSUSB_USB_AIM_GOING_HIGH_WITH_FULL = 0x1
	// Position of USB_ESEA field.
	SCU_SFSUSB_USB_ESEA_Pos = 0x1
	// Bit mask of USB_ESEA field.
	SCU_SFSUSB_USB_ESEA_Msk = 0x2
	// Bit USB_ESEA.
	SCU_SFSUSB_USB_ESEA = 0x2
	// Single input. Enables USB1. Use with the on-chip full-speed PHY.
	SCU_SFSUSB_USB_ESEA_SINGLE_INPUT = 0x1
	// Position of USB_EPD field.
	SCU_SFSUSB_USB_EPD_Pos = 0x2
	// Bit mask of USB_EPD field.
	SCU_SFSUSB_USB_EPD_Msk = 0x4
	// Bit USB_EPD.
	SCU_SFSUSB_USB_EPD = 0x4
	// Pull-down disconnected
	SCU_SFSUSB_USB_EPD_PULL_DOWN_DISCONNECT = 0x0
	// Pull-down connected
	SCU_SFSUSB_USB_EPD_PULL_DOWN_CONNECTED = 0x1
	// Position of RESERVED field.
	SCU_SFSUSB_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	SCU_SFSUSB_RESERVED_Msk = 0x8
	// Bit RESERVED.
	SCU_SFSUSB_RESERVED = 0x8
	// Position of USB_EPWR field.
	SCU_SFSUSB_USB_EPWR_Pos = 0x4
	// Bit mask of USB_EPWR field.
	SCU_SFSUSB_USB_EPWR_Msk = 0x10
	// Bit USB_EPWR.
	SCU_SFSUSB_USB_EPWR = 0x10
	// Power saving mode (Suspend mode)
	SCU_SFSUSB_USB_EPWR_POWER_SAVING_MODE_S = 0x0
	// Normal mode
	SCU_SFSUSB_USB_EPWR_NORMAL_MODE = 0x1
	// Position of USB_VBUS field.
	SCU_SFSUSB_USB_VBUS_Pos = 0x5
	// Bit mask of USB_VBUS field.
	SCU_SFSUSB_USB_VBUS_Msk = 0x20
	// Bit USB_VBUS.
	SCU_SFSUSB_USB_VBUS = 0x20
	// VBUS signal LOW or inactive
	SCU_SFSUSB_USB_VBUS_VBUS_SIGNAL_LOW_OR_I = 0x0
	// VBUS signal HIGH or active
	SCU_SFSUSB_USB_VBUS_VBUS_SIGNAL_HIGH_OR = 0x1
	// Position of RESERVED field.
	SCU_SFSUSB_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCU_SFSUSB_RESERVED_Msk = 0xffffffc0

	// SFSI2C0: Pin configuration register for I2C0-bus pins
	// Position of SCL_EFP field.
	SCU_SFSI2C0_SCL_EFP_Pos = 0x0
	// Bit mask of SCL_EFP field.
	SCU_SFSI2C0_SCL_EFP_Msk = 0x1
	// Bit SCL_EFP.
	SCU_SFSI2C0_SCL_EFP = 0x1
	// 50 ns glitch filter
	SCU_SFSI2C0_SCL_EFP_50_NS_GLITCH_FILTER = 0x0
	// 3 ns glitch filter
	SCU_SFSI2C0_SCL_EFP_3_NS_GLITCH_FILTER = 0x1
	// Position of RESERVED field.
	SCU_SFSI2C0_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SCU_SFSI2C0_RESERVED_Msk = 0x2
	// Bit RESERVED.
	SCU_SFSI2C0_RESERVED = 0x2
	// Position of SCL_EHD field.
	SCU_SFSI2C0_SCL_EHD_Pos = 0x2
	// Bit mask of SCL_EHD field.
	SCU_SFSI2C0_SCL_EHD_Msk = 0x4
	// Bit SCL_EHD.
	SCU_SFSI2C0_SCL_EHD = 0x4
	// Standard/Fast mode transmit
	SCU_SFSI2C0_SCL_EHD_STANDARDFAST_MODE = 0x0
	// Fast-mode Plus transmit
	SCU_SFSI2C0_SCL_EHD_FAST_MODE_PLUS_TRANS = 0x1
	// Position of SCL_EZI field.
	SCU_SFSI2C0_SCL_EZI_Pos = 0x3
	// Bit mask of SCL_EZI field.
	SCU_SFSI2C0_SCL_EZI_Msk = 0x8
	// Bit SCL_EZI.
	SCU_SFSI2C0_SCL_EZI = 0x8
	// Disabled
	SCU_SFSI2C0_SCL_EZI_DISABLED = 0x0
	// Enabled
	SCU_SFSI2C0_SCL_EZI_ENABLED = 0x1
	// Position of RESERVED field.
	SCU_SFSI2C0_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCU_SFSI2C0_RESERVED_Msk = 0x70
	// Position of SCL_ZIF field.
	SCU_SFSI2C0_SCL_ZIF_Pos = 0x7
	// Bit mask of SCL_ZIF field.
	SCU_SFSI2C0_SCL_ZIF_Msk = 0x80
	// Bit SCL_ZIF.
	SCU_SFSI2C0_SCL_ZIF = 0x80
	// Enable input filter
	SCU_SFSI2C0_SCL_ZIF_ENABLE_INPUT_FILTER = 0x0
	// Disable input filter
	SCU_SFSI2C0_SCL_ZIF_DISABLE_INPUT_FILTER = 0x1
	// Position of SDA_EFP field.
	SCU_SFSI2C0_SDA_EFP_Pos = 0x8
	// Bit mask of SDA_EFP field.
	SCU_SFSI2C0_SDA_EFP_Msk = 0x100
	// Bit SDA_EFP.
	SCU_SFSI2C0_SDA_EFP = 0x100
	// 50 ns glitch filter
	SCU_SFSI2C0_SDA_EFP_50_NS_GLITCH_FILTER = 0x0
	// 3 ns glitch filter
	SCU_SFSI2C0_SDA_EFP_3_NS_GLITCH_FILTER = 0x1
	// Position of RESERVED field.
	SCU_SFSI2C0_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SCU_SFSI2C0_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SCU_SFSI2C0_RESERVED = 0x200
	// Position of SDA_EHD field.
	SCU_SFSI2C0_SDA_EHD_Pos = 0xa
	// Bit mask of SDA_EHD field.
	SCU_SFSI2C0_SDA_EHD_Msk = 0x400
	// Bit SDA_EHD.
	SCU_SFSI2C0_SDA_EHD = 0x400
	// Standard/Fast mode transmit
	SCU_SFSI2C0_SDA_EHD_STANDARDFAST_MODE = 0x0
	// Fast-mode Plus transmit
	SCU_SFSI2C0_SDA_EHD_FAST_MODE_PLUS_TRANS = 0x1
	// Position of SDA_EZI field.
	SCU_SFSI2C0_SDA_EZI_Pos = 0xb
	// Bit mask of SDA_EZI field.
	SCU_SFSI2C0_SDA_EZI_Msk = 0x800
	// Bit SDA_EZI.
	SCU_SFSI2C0_SDA_EZI = 0x800
	// Disabled
	SCU_SFSI2C0_SDA_EZI_DISABLED = 0x0
	// Enabled
	SCU_SFSI2C0_SDA_EZI_ENABLED = 0x1
	// Position of RESERVED field.
	SCU_SFSI2C0_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SCU_SFSI2C0_RESERVED_Msk = 0x7000
	// Position of SDA_ZIF field.
	SCU_SFSI2C0_SDA_ZIF_Pos = 0xf
	// Bit mask of SDA_ZIF field.
	SCU_SFSI2C0_SDA_ZIF_Msk = 0x8000
	// Bit SDA_ZIF.
	SCU_SFSI2C0_SDA_ZIF = 0x8000
	// Enable input filter
	SCU_SFSI2C0_SDA_ZIF_ENABLE_INPUT_FILTER = 0x0
	// Disable input filter
	SCU_SFSI2C0_SDA_ZIF_DISABLE_INPUT_FILTER = 0x1
	// Position of RESERVED field.
	SCU_SFSI2C0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCU_SFSI2C0_RESERVED_Msk = 0xffff0000

	// ENAIO0: ADC0 function select register
	// Position of ADC0_0 field.
	SCU_ENAIO0_ADC0_0_Pos = 0x0
	// Bit mask of ADC0_0 field.
	SCU_ENAIO0_ADC0_0_Msk = 0x1
	// Bit ADC0_0.
	SCU_ENAIO0_ADC0_0 = 0x1
	// Digital function selected on pin P4_3.
	SCU_ENAIO0_ADC0_0_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC0_0 selected on pin P4_3
	SCU_ENAIO0_ADC0_0_ANALOG_FUNCTION_ADC0 = 0x1
	// Position of ADC0_1 field.
	SCU_ENAIO0_ADC0_1_Pos = 0x1
	// Bit mask of ADC0_1 field.
	SCU_ENAIO0_ADC0_1_Msk = 0x2
	// Bit ADC0_1.
	SCU_ENAIO0_ADC0_1 = 0x2
	// Digital function selected on pin P4_1.
	SCU_ENAIO0_ADC0_1_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC0_1 selected on pin P4_1.
	SCU_ENAIO0_ADC0_1_ANALOG_FUNCTION_ADC0 = 0x1
	// Position of ADC0_2 field.
	SCU_ENAIO0_ADC0_2_Pos = 0x2
	// Bit mask of ADC0_2 field.
	SCU_ENAIO0_ADC0_2_Msk = 0x4
	// Bit ADC0_2.
	SCU_ENAIO0_ADC0_2 = 0x4
	// Digital function selected on pin PF_8.
	SCU_ENAIO0_ADC0_2_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC0_2 selected on pin PF_8.
	SCU_ENAIO0_ADC0_2_ANALOG_FUNCTION_ADC0 = 0x1
	// Position of ADC0_3 field.
	SCU_ENAIO0_ADC0_3_Pos = 0x3
	// Bit mask of ADC0_3 field.
	SCU_ENAIO0_ADC0_3_Msk = 0x8
	// Bit ADC0_3.
	SCU_ENAIO0_ADC0_3 = 0x8
	// Digital function selected on pin P7_5.
	SCU_ENAIO0_ADC0_3_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC0_3 selected on pin P7_5.
	SCU_ENAIO0_ADC0_3_ANALOG_FUNCTION_ADC0 = 0x1
	// Position of ADC0_4 field.
	SCU_ENAIO0_ADC0_4_Pos = 0x4
	// Bit mask of ADC0_4 field.
	SCU_ENAIO0_ADC0_4_Msk = 0x10
	// Bit ADC0_4.
	SCU_ENAIO0_ADC0_4 = 0x10
	// Digital function selected on pin P7_4.
	SCU_ENAIO0_ADC0_4_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC0_4 selected on pin P7_4.
	SCU_ENAIO0_ADC0_4_ANALOG_FUNCTION_ADC0 = 0x1
	// Position of ADC0_5 field.
	SCU_ENAIO0_ADC0_5_Pos = 0x5
	// Bit mask of ADC0_5 field.
	SCU_ENAIO0_ADC0_5_Msk = 0x20
	// Bit ADC0_5.
	SCU_ENAIO0_ADC0_5 = 0x20
	// Digital function selected on pin PF_10.
	SCU_ENAIO0_ADC0_5_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC0_5 selected on pin PF_10.
	SCU_ENAIO0_ADC0_5_ANALOG_FUNCTION_ADC0 = 0x1
	// Position of ADC0_6 field.
	SCU_ENAIO0_ADC0_6_Pos = 0x6
	// Bit mask of ADC0_6 field.
	SCU_ENAIO0_ADC0_6_Msk = 0x40
	// Bit ADC0_6.
	SCU_ENAIO0_ADC0_6 = 0x40
	// Digital function selected on pin PB_6.
	SCU_ENAIO0_ADC0_6_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC0_6 selected on pin PB_6.
	SCU_ENAIO0_ADC0_6_ANALOG_FUNCTION_ADC0 = 0x1

	// ENAIO1: ADC1 function select register
	// Position of ADC1_0 field.
	SCU_ENAIO1_ADC1_0_Pos = 0x0
	// Bit mask of ADC1_0 field.
	SCU_ENAIO1_ADC1_0_Msk = 0x1
	// Bit ADC1_0.
	SCU_ENAIO1_ADC1_0 = 0x1
	// Digital function selected on pin PC_3.
	SCU_ENAIO1_ADC1_0_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC1_0 selected on pin PC_3.
	SCU_ENAIO1_ADC1_0_ANALOG_FUNCTION_ADC1 = 0x1
	// Position of ADC1_1 field.
	SCU_ENAIO1_ADC1_1_Pos = 0x1
	// Bit mask of ADC1_1 field.
	SCU_ENAIO1_ADC1_1_Msk = 0x2
	// Bit ADC1_1.
	SCU_ENAIO1_ADC1_1 = 0x2
	// Digital function selected on pin PC_0.
	SCU_ENAIO1_ADC1_1_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC1_1 selected on pin PC_0.
	SCU_ENAIO1_ADC1_1_ANALOG_FUNCTION_ADC1 = 0x1
	// Position of ADC1_2 field.
	SCU_ENAIO1_ADC1_2_Pos = 0x2
	// Bit mask of ADC1_2 field.
	SCU_ENAIO1_ADC1_2_Msk = 0x4
	// Bit ADC1_2.
	SCU_ENAIO1_ADC1_2 = 0x4
	// Digital function selected on pin PF_9.
	SCU_ENAIO1_ADC1_2_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC1_2 selected on pin PF_9.
	SCU_ENAIO1_ADC1_2_ANALOG_FUNCTION_ADC1 = 0x1
	// Position of ADC1_3 field.
	SCU_ENAIO1_ADC1_3_Pos = 0x3
	// Bit mask of ADC1_3 field.
	SCU_ENAIO1_ADC1_3_Msk = 0x8
	// Bit ADC1_3.
	SCU_ENAIO1_ADC1_3 = 0x8
	// Digital function selected on pin PF_6.
	SCU_ENAIO1_ADC1_3_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC1_3 selected on pin PF_6.
	SCU_ENAIO1_ADC1_3_ANALOG_FUNCTION_ADC1 = 0x1
	// Position of ADC1_4 field.
	SCU_ENAIO1_ADC1_4_Pos = 0x4
	// Bit mask of ADC1_4 field.
	SCU_ENAIO1_ADC1_4_Msk = 0x10
	// Bit ADC1_4.
	SCU_ENAIO1_ADC1_4 = 0x10
	// Digital function selected on pin PF_5.
	SCU_ENAIO1_ADC1_4_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC1_4 selected on pin PF_5.
	SCU_ENAIO1_ADC1_4_ANALOG_FUNCTION_ADC1 = 0x1
	// Position of ADC1_5 field.
	SCU_ENAIO1_ADC1_5_Pos = 0x5
	// Bit mask of ADC1_5 field.
	SCU_ENAIO1_ADC1_5_Msk = 0x20
	// Bit ADC1_5.
	SCU_ENAIO1_ADC1_5 = 0x20
	// Digital function selected on pin PF_11.
	SCU_ENAIO1_ADC1_5_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC1_5 selected on pin PF_11.
	SCU_ENAIO1_ADC1_5_ANALOG_FUNCTION_ADC1 = 0x1
	// Position of ADC1_6 field.
	SCU_ENAIO1_ADC1_6_Pos = 0x6
	// Bit mask of ADC1_6 field.
	SCU_ENAIO1_ADC1_6_Msk = 0x40
	// Bit ADC1_6.
	SCU_ENAIO1_ADC1_6 = 0x40
	// Digital function selected on pin P7_7.
	SCU_ENAIO1_ADC1_6_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC1_6 selected on pin P7_7.
	SCU_ENAIO1_ADC1_6_ANALOG_FUNCTION_ADC1 = 0x1
	// Position of ADC1_7 field.
	SCU_ENAIO1_ADC1_7_Pos = 0x7
	// Bit mask of ADC1_7 field.
	SCU_ENAIO1_ADC1_7_Msk = 0x80
	// Bit ADC1_7.
	SCU_ENAIO1_ADC1_7 = 0x80
	// Digital function selected on pin PF_7.
	SCU_ENAIO1_ADC1_7_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function ADC1_7 selected on pin PF_7.
	SCU_ENAIO1_ADC1_7_ANALOG_FUNCTION_ADC1 = 0x1

	// ENAIO2: Analog function select register
	// Position of DAC field.
	SCU_ENAIO2_DAC_Pos = 0x0
	// Bit mask of DAC field.
	SCU_ENAIO2_DAC_Msk = 0x1
	// Bit DAC.
	SCU_ENAIO2_DAC = 0x1
	// Digital function selected on pin P4_4.
	SCU_ENAIO2_DAC_DIGITAL_FUNCTION_SEL = 0x0
	// Analog function DAC selected on pin P4_4.
	SCU_ENAIO2_DAC_ANALOG_FUNCTION_DAC = 0x1
	// Position of BG field.
	SCU_ENAIO2_BG_Pos = 0x4
	// Bit mask of BG field.
	SCU_ENAIO2_BG_Msk = 0x10
	// Bit BG.
	SCU_ENAIO2_BG = 0x10
	// Digital function selected on pin PF_7.
	SCU_ENAIO2_BG_DIGITAL_FUNCTION_SEL = 0x0
	// Band gap output selected for pin PF_7.
	SCU_ENAIO2_BG_BAND_GAP_OUTPUT_SELE = 0x1

	// EMCDELAYCLK: EMC clock delay register
	// Position of CLK_DELAY field.
	SCU_EMCDELAYCLK_CLK_DELAY_Pos = 0x0
	// Bit mask of CLK_DELAY field.
	SCU_EMCDELAYCLK_CLK_DELAY_Msk = 0xffff
	// Position of RESERVED field.
	SCU_EMCDELAYCLK_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCU_EMCDELAYCLK_RESERVED_Msk = 0xffff0000

	// SDDELAY: SD/MMC sample and drive delay register
	// Position of SAMPLE_DELAY field.
	SCU_SDDELAY_SAMPLE_DELAY_Pos = 0x0
	// Bit mask of SAMPLE_DELAY field.
	SCU_SDDELAY_SAMPLE_DELAY_Msk = 0xf
	// Position of RESERVED field.
	SCU_SDDELAY_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCU_SDDELAY_RESERVED_Msk = 0xf0
	// Position of DRV_DELAY field.
	SCU_SDDELAY_DRV_DELAY_Pos = 0x8
	// Bit mask of DRV_DELAY field.
	SCU_SDDELAY_DRV_DELAY_Msk = 0xf00
	// Position of RESERVED field.
	SCU_SDDELAY_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SCU_SDDELAY_RESERVED_Msk = 0xfffff000

	// PINTSEL0: Pin interrupt select register for pin interrupts 0 to 3.
	// Position of INTPIN0 field.
	SCU_PINTSEL0_INTPIN0_Pos = 0x0
	// Bit mask of INTPIN0 field.
	SCU_PINTSEL0_INTPIN0_Msk = 0x1f
	// Position of PORTSEL0 field.
	SCU_PINTSEL0_PORTSEL0_Pos = 0x5
	// Bit mask of PORTSEL0 field.
	SCU_PINTSEL0_PORTSEL0_Msk = 0xe0
	// GPIO Port 0
	SCU_PINTSEL0_PORTSEL0_GPIO_PORT_0 = 0x0
	// GPIO Port 1
	SCU_PINTSEL0_PORTSEL0_GPIO_PORT_1 = 0x1
	// GPIO Port 2
	SCU_PINTSEL0_PORTSEL0_GPIO_PORT_2 = 0x2
	// GPIO Port 3
	SCU_PINTSEL0_PORTSEL0_GPIO_PORT_3 = 0x3
	// GPIO Port 4
	SCU_PINTSEL0_PORTSEL0_GPIO_PORT_4 = 0x4
	// GPIO Port 5
	SCU_PINTSEL0_PORTSEL0_GPIO_PORT_5 = 0x5
	// GPIO Port 6
	SCU_PINTSEL0_PORTSEL0_GPIO_PORT_6 = 0x6
	// GPIO Port 7
	SCU_PINTSEL0_PORTSEL0_GPIO_PORT_7 = 0x7
	// Position of INTPIN1 field.
	SCU_PINTSEL0_INTPIN1_Pos = 0x8
	// Bit mask of INTPIN1 field.
	SCU_PINTSEL0_INTPIN1_Msk = 0x1f00
	// Position of PORTSEL1 field.
	SCU_PINTSEL0_PORTSEL1_Pos = 0xd
	// Bit mask of PORTSEL1 field.
	SCU_PINTSEL0_PORTSEL1_Msk = 0xe000
	// GPIO Port 0
	SCU_PINTSEL0_PORTSEL1_GPIO_PORT_0 = 0x0
	// GPIO Port 1
	SCU_PINTSEL0_PORTSEL1_GPIO_PORT_1 = 0x1
	// GPIO Port 2
	SCU_PINTSEL0_PORTSEL1_GPIO_PORT_2 = 0x2
	// GPIO Port 3
	SCU_PINTSEL0_PORTSEL1_GPIO_PORT_3 = 0x3
	// GPIO Port 4
	SCU_PINTSEL0_PORTSEL1_GPIO_PORT_4 = 0x4
	// GPIO Port 5
	SCU_PINTSEL0_PORTSEL1_GPIO_PORT_5 = 0x5
	// GPIO Port 6
	SCU_PINTSEL0_PORTSEL1_GPIO_PORT_6 = 0x6
	// GPIO Port 7
	SCU_PINTSEL0_PORTSEL1_GPIO_PORT_7 = 0x7
	// Position of INTPIN2 field.
	SCU_PINTSEL0_INTPIN2_Pos = 0x10
	// Bit mask of INTPIN2 field.
	SCU_PINTSEL0_INTPIN2_Msk = 0x1f0000
	// Position of PORTSEL2 field.
	SCU_PINTSEL0_PORTSEL2_Pos = 0x15
	// Bit mask of PORTSEL2 field.
	SCU_PINTSEL0_PORTSEL2_Msk = 0xe00000
	// GPIO Port 0
	SCU_PINTSEL0_PORTSEL2_GPIO_PORT_0 = 0x0
	// GPIO Port 1
	SCU_PINTSEL0_PORTSEL2_GPIO_PORT_1 = 0x1
	// GPIO Port 2
	SCU_PINTSEL0_PORTSEL2_GPIO_PORT_2 = 0x2
	// GPIO Port 3
	SCU_PINTSEL0_PORTSEL2_GPIO_PORT_3 = 0x3
	// GPIO Port 4
	SCU_PINTSEL0_PORTSEL2_GPIO_PORT_4 = 0x4
	// GPIO Port 5
	SCU_PINTSEL0_PORTSEL2_GPIO_PORT_5 = 0x5
	// GPIO Port 6
	SCU_PINTSEL0_PORTSEL2_GPIO_PORT_6 = 0x6
	// GPIO Port 7
	SCU_PINTSEL0_PORTSEL2_GPIO_PORT_7 = 0x7
	// Position of INTPIN3 field.
	SCU_PINTSEL0_INTPIN3_Pos = 0x18
	// Bit mask of INTPIN3 field.
	SCU_PINTSEL0_INTPIN3_Msk = 0x1f000000
	// Position of PORTSEL3 field.
	SCU_PINTSEL0_PORTSEL3_Pos = 0x1d
	// Bit mask of PORTSEL3 field.
	SCU_PINTSEL0_PORTSEL3_Msk = 0xe0000000
	// GPIO Port 0
	SCU_PINTSEL0_PORTSEL3_GPIO_PORT_0 = 0x0
	// GPIO Port 1
	SCU_PINTSEL0_PORTSEL3_GPIO_PORT_1 = 0x1
	// GPIO Port 2
	SCU_PINTSEL0_PORTSEL3_GPIO_PORT_2 = 0x2
	// GPIO Port 3
	SCU_PINTSEL0_PORTSEL3_GPIO_PORT_3 = 0x3
	// GPIO Port 4
	SCU_PINTSEL0_PORTSEL3_GPIO_PORT_4 = 0x4
	// GPIO Port 5
	SCU_PINTSEL0_PORTSEL3_GPIO_PORT_5 = 0x5
	// GPIO Port 6
	SCU_PINTSEL0_PORTSEL3_GPIO_PORT_6 = 0x6
	// GPIO Port 7
	SCU_PINTSEL0_PORTSEL3_GPIO_PORT_7 = 0x7

	// PINTSEL1: Pin interrupt select register for pin interrupts 4 to 7.
	// Position of INTPIN4 field.
	SCU_PINTSEL1_INTPIN4_Pos = 0x0
	// Bit mask of INTPIN4 field.
	SCU_PINTSEL1_INTPIN4_Msk = 0x1f
	// Position of PORTSEL4 field.
	SCU_PINTSEL1_PORTSEL4_Pos = 0x5
	// Bit mask of PORTSEL4 field.
	SCU_PINTSEL1_PORTSEL4_Msk = 0xe0
	// GPIO Port 0
	SCU_PINTSEL1_PORTSEL4_GPIO_PORT_0 = 0x0
	// GPIO Port 1
	SCU_PINTSEL1_PORTSEL4_GPIO_PORT_1 = 0x1
	// GPIO Port 2
	SCU_PINTSEL1_PORTSEL4_GPIO_PORT_2 = 0x2
	// GPIO Port 3
	SCU_PINTSEL1_PORTSEL4_GPIO_PORT_3 = 0x3
	// GPIO Port 4
	SCU_PINTSEL1_PORTSEL4_GPIO_PORT_4 = 0x4
	// GPIO Port 5
	SCU_PINTSEL1_PORTSEL4_GPIO_PORT_5 = 0x5
	// GPIO Port 6
	SCU_PINTSEL1_PORTSEL4_GPIO_PORT_6 = 0x6
	// GPIO Port 7
	SCU_PINTSEL1_PORTSEL4_GPIO_PORT_7 = 0x7
	// Position of INTPIN5 field.
	SCU_PINTSEL1_INTPIN5_Pos = 0x8
	// Bit mask of INTPIN5 field.
	SCU_PINTSEL1_INTPIN5_Msk = 0x1f00
	// Position of PORTSEL5 field.
	SCU_PINTSEL1_PORTSEL5_Pos = 0xd
	// Bit mask of PORTSEL5 field.
	SCU_PINTSEL1_PORTSEL5_Msk = 0xe000
	// GPIO Port 0
	SCU_PINTSEL1_PORTSEL5_GPIO_PORT_0 = 0x0
	// GPIO Port 1
	SCU_PINTSEL1_PORTSEL5_GPIO_PORT_1 = 0x1
	// GPIO Port 2
	SCU_PINTSEL1_PORTSEL5_GPIO_PORT_2 = 0x2
	// GPIO Port 3
	SCU_PINTSEL1_PORTSEL5_GPIO_PORT_3 = 0x3
	// GPIO Port 4
	SCU_PINTSEL1_PORTSEL5_GPIO_PORT_4 = 0x4
	// GPIO Port 5
	SCU_PINTSEL1_PORTSEL5_GPIO_PORT_5 = 0x5
	// GPIO Port 6
	SCU_PINTSEL1_PORTSEL5_GPIO_PORT_6 = 0x6
	// GPIO Port 7
	SCU_PINTSEL1_PORTSEL5_GPIO_PORT_7 = 0x7
	// Position of INTPIN6 field.
	SCU_PINTSEL1_INTPIN6_Pos = 0x10
	// Bit mask of INTPIN6 field.
	SCU_PINTSEL1_INTPIN6_Msk = 0x1f0000
	// Position of PORTSEL6 field.
	SCU_PINTSEL1_PORTSEL6_Pos = 0x15
	// Bit mask of PORTSEL6 field.
	SCU_PINTSEL1_PORTSEL6_Msk = 0xe00000
	// GPIO Port 0
	SCU_PINTSEL1_PORTSEL6_GPIO_PORT_0 = 0x0
	// GPIO Port 1
	SCU_PINTSEL1_PORTSEL6_GPIO_PORT_1 = 0x1
	// GPIO Port 2
	SCU_PINTSEL1_PORTSEL6_GPIO_PORT_2 = 0x2
	// GPIO Port 3
	SCU_PINTSEL1_PORTSEL6_GPIO_PORT_3 = 0x3
	// GPIO Port 4
	SCU_PINTSEL1_PORTSEL6_GPIO_PORT_4 = 0x4
	// GPIO Port 5
	SCU_PINTSEL1_PORTSEL6_GPIO_PORT_5 = 0x5
	// GPIO Port 6
	SCU_PINTSEL1_PORTSEL6_GPIO_PORT_6 = 0x6
	// GPIO Port 7
	SCU_PINTSEL1_PORTSEL6_GPIO_PORT_7 = 0x7
	// Position of INTPIN7 field.
	SCU_PINTSEL1_INTPIN7_Pos = 0x18
	// Bit mask of INTPIN7 field.
	SCU_PINTSEL1_INTPIN7_Msk = 0x1f000000
	// Position of PORTSEL7 field.
	SCU_PINTSEL1_PORTSEL7_Pos = 0x1d
	// Bit mask of PORTSEL7 field.
	SCU_PINTSEL1_PORTSEL7_Msk = 0xe0000000
	// GPIO Port 0
	SCU_PINTSEL1_PORTSEL7_GPIO_PORT_0 = 0x0
	// GPIO Port 1
	SCU_PINTSEL1_PORTSEL7_GPIO_PORT_1 = 0x1
	// GPIO Port 2
	SCU_PINTSEL1_PORTSEL7_GPIO_PORT_2 = 0x2
	// GPIO Port 3
	SCU_PINTSEL1_PORTSEL7_GPIO_PORT_3 = 0x3
	// GPIO Port 4
	SCU_PINTSEL1_PORTSEL7_GPIO_PORT_4 = 0x4
	// GPIO Port 5
	SCU_PINTSEL1_PORTSEL7_GPIO_PORT_5 = 0x5
	// GPIO Port 6
	SCU_PINTSEL1_PORTSEL7_GPIO_PORT_6 = 0x6
	// GPIO Port 7
	SCU_PINTSEL1_PORTSEL7_GPIO_PORT_7 = 0x7
)

// Bitfields for GPIO_PIN_INT: GPIO pin interrupt
const (
	// ISEL: Pin Interrupt Mode register
	// Position of PMODE0 field.
	GPIO_PIN_INT_ISEL_PMODE0_Pos = 0x0
	// Bit mask of PMODE0 field.
	GPIO_PIN_INT_ISEL_PMODE0_Msk = 0x1
	// Bit PMODE0.
	GPIO_PIN_INT_ISEL_PMODE0 = 0x1
	// Position of PMODE1 field.
	GPIO_PIN_INT_ISEL_PMODE1_Pos = 0x1
	// Bit mask of PMODE1 field.
	GPIO_PIN_INT_ISEL_PMODE1_Msk = 0x2
	// Bit PMODE1.
	GPIO_PIN_INT_ISEL_PMODE1 = 0x2
	// Position of PMODE2 field.
	GPIO_PIN_INT_ISEL_PMODE2_Pos = 0x2
	// Bit mask of PMODE2 field.
	GPIO_PIN_INT_ISEL_PMODE2_Msk = 0x4
	// Bit PMODE2.
	GPIO_PIN_INT_ISEL_PMODE2 = 0x4
	// Position of PMODE3 field.
	GPIO_PIN_INT_ISEL_PMODE3_Pos = 0x3
	// Bit mask of PMODE3 field.
	GPIO_PIN_INT_ISEL_PMODE3_Msk = 0x8
	// Bit PMODE3.
	GPIO_PIN_INT_ISEL_PMODE3 = 0x8
	// Position of PMODE4 field.
	GPIO_PIN_INT_ISEL_PMODE4_Pos = 0x4
	// Bit mask of PMODE4 field.
	GPIO_PIN_INT_ISEL_PMODE4_Msk = 0x10
	// Bit PMODE4.
	GPIO_PIN_INT_ISEL_PMODE4 = 0x10
	// Position of PMODE5 field.
	GPIO_PIN_INT_ISEL_PMODE5_Pos = 0x5
	// Bit mask of PMODE5 field.
	GPIO_PIN_INT_ISEL_PMODE5_Msk = 0x20
	// Bit PMODE5.
	GPIO_PIN_INT_ISEL_PMODE5 = 0x20
	// Position of PMODE6 field.
	GPIO_PIN_INT_ISEL_PMODE6_Pos = 0x6
	// Bit mask of PMODE6 field.
	GPIO_PIN_INT_ISEL_PMODE6_Msk = 0x40
	// Bit PMODE6.
	GPIO_PIN_INT_ISEL_PMODE6 = 0x40
	// Position of PMODE7 field.
	GPIO_PIN_INT_ISEL_PMODE7_Pos = 0x7
	// Bit mask of PMODE7 field.
	GPIO_PIN_INT_ISEL_PMODE7_Msk = 0x80
	// Bit PMODE7.
	GPIO_PIN_INT_ISEL_PMODE7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_ISEL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_ISEL_RESERVED_Msk = 0xffffff00

	// IENR: Pin Interrupt Enable (Rising) register
	// Position of ENRL0 field.
	GPIO_PIN_INT_IENR_ENRL0_Pos = 0x0
	// Bit mask of ENRL0 field.
	GPIO_PIN_INT_IENR_ENRL0_Msk = 0x1
	// Bit ENRL0.
	GPIO_PIN_INT_IENR_ENRL0 = 0x1
	// Position of ENRL1 field.
	GPIO_PIN_INT_IENR_ENRL1_Pos = 0x1
	// Bit mask of ENRL1 field.
	GPIO_PIN_INT_IENR_ENRL1_Msk = 0x2
	// Bit ENRL1.
	GPIO_PIN_INT_IENR_ENRL1 = 0x2
	// Position of ENRL2 field.
	GPIO_PIN_INT_IENR_ENRL2_Pos = 0x2
	// Bit mask of ENRL2 field.
	GPIO_PIN_INT_IENR_ENRL2_Msk = 0x4
	// Bit ENRL2.
	GPIO_PIN_INT_IENR_ENRL2 = 0x4
	// Position of ENRL3 field.
	GPIO_PIN_INT_IENR_ENRL3_Pos = 0x3
	// Bit mask of ENRL3 field.
	GPIO_PIN_INT_IENR_ENRL3_Msk = 0x8
	// Bit ENRL3.
	GPIO_PIN_INT_IENR_ENRL3 = 0x8
	// Position of ENRL4 field.
	GPIO_PIN_INT_IENR_ENRL4_Pos = 0x4
	// Bit mask of ENRL4 field.
	GPIO_PIN_INT_IENR_ENRL4_Msk = 0x10
	// Bit ENRL4.
	GPIO_PIN_INT_IENR_ENRL4 = 0x10
	// Position of ENRL5 field.
	GPIO_PIN_INT_IENR_ENRL5_Pos = 0x5
	// Bit mask of ENRL5 field.
	GPIO_PIN_INT_IENR_ENRL5_Msk = 0x20
	// Bit ENRL5.
	GPIO_PIN_INT_IENR_ENRL5 = 0x20
	// Position of ENRL6 field.
	GPIO_PIN_INT_IENR_ENRL6_Pos = 0x6
	// Bit mask of ENRL6 field.
	GPIO_PIN_INT_IENR_ENRL6_Msk = 0x40
	// Bit ENRL6.
	GPIO_PIN_INT_IENR_ENRL6 = 0x40
	// Position of ENRL7 field.
	GPIO_PIN_INT_IENR_ENRL7_Pos = 0x7
	// Bit mask of ENRL7 field.
	GPIO_PIN_INT_IENR_ENRL7_Msk = 0x80
	// Bit ENRL7.
	GPIO_PIN_INT_IENR_ENRL7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_IENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IENR_RESERVED_Msk = 0xffffff00

	// SIENR: Set Pin Interrupt Enable (Rising) register
	// Position of SETENRL0 field.
	GPIO_PIN_INT_SIENR_SETENRL0_Pos = 0x0
	// Bit mask of SETENRL0 field.
	GPIO_PIN_INT_SIENR_SETENRL0_Msk = 0x1
	// Bit SETENRL0.
	GPIO_PIN_INT_SIENR_SETENRL0 = 0x1
	// Position of SETENRL1 field.
	GPIO_PIN_INT_SIENR_SETENRL1_Pos = 0x1
	// Bit mask of SETENRL1 field.
	GPIO_PIN_INT_SIENR_SETENRL1_Msk = 0x2
	// Bit SETENRL1.
	GPIO_PIN_INT_SIENR_SETENRL1 = 0x2
	// Position of SETENRL2 field.
	GPIO_PIN_INT_SIENR_SETENRL2_Pos = 0x2
	// Bit mask of SETENRL2 field.
	GPIO_PIN_INT_SIENR_SETENRL2_Msk = 0x4
	// Bit SETENRL2.
	GPIO_PIN_INT_SIENR_SETENRL2 = 0x4
	// Position of SETENRL3 field.
	GPIO_PIN_INT_SIENR_SETENRL3_Pos = 0x3
	// Bit mask of SETENRL3 field.
	GPIO_PIN_INT_SIENR_SETENRL3_Msk = 0x8
	// Bit SETENRL3.
	GPIO_PIN_INT_SIENR_SETENRL3 = 0x8
	// Position of SETENRL4 field.
	GPIO_PIN_INT_SIENR_SETENRL4_Pos = 0x4
	// Bit mask of SETENRL4 field.
	GPIO_PIN_INT_SIENR_SETENRL4_Msk = 0x10
	// Bit SETENRL4.
	GPIO_PIN_INT_SIENR_SETENRL4 = 0x10
	// Position of SETENRL5 field.
	GPIO_PIN_INT_SIENR_SETENRL5_Pos = 0x5
	// Bit mask of SETENRL5 field.
	GPIO_PIN_INT_SIENR_SETENRL5_Msk = 0x20
	// Bit SETENRL5.
	GPIO_PIN_INT_SIENR_SETENRL5 = 0x20
	// Position of SETENRL6 field.
	GPIO_PIN_INT_SIENR_SETENRL6_Pos = 0x6
	// Bit mask of SETENRL6 field.
	GPIO_PIN_INT_SIENR_SETENRL6_Msk = 0x40
	// Bit SETENRL6.
	GPIO_PIN_INT_SIENR_SETENRL6 = 0x40
	// Position of SETENRL7 field.
	GPIO_PIN_INT_SIENR_SETENRL7_Pos = 0x7
	// Bit mask of SETENRL7 field.
	GPIO_PIN_INT_SIENR_SETENRL7_Msk = 0x80
	// Bit SETENRL7.
	GPIO_PIN_INT_SIENR_SETENRL7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_SIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_SIENR_RESERVED_Msk = 0xffffff00

	// CIENR: Clear Pin Interrupt Enable (Rising) register
	// Position of CENRL0 field.
	GPIO_PIN_INT_CIENR_CENRL0_Pos = 0x0
	// Bit mask of CENRL0 field.
	GPIO_PIN_INT_CIENR_CENRL0_Msk = 0x1
	// Bit CENRL0.
	GPIO_PIN_INT_CIENR_CENRL0 = 0x1
	// Position of CENRL1 field.
	GPIO_PIN_INT_CIENR_CENRL1_Pos = 0x1
	// Bit mask of CENRL1 field.
	GPIO_PIN_INT_CIENR_CENRL1_Msk = 0x2
	// Bit CENRL1.
	GPIO_PIN_INT_CIENR_CENRL1 = 0x2
	// Position of CENRL2 field.
	GPIO_PIN_INT_CIENR_CENRL2_Pos = 0x2
	// Bit mask of CENRL2 field.
	GPIO_PIN_INT_CIENR_CENRL2_Msk = 0x4
	// Bit CENRL2.
	GPIO_PIN_INT_CIENR_CENRL2 = 0x4
	// Position of CENRL3 field.
	GPIO_PIN_INT_CIENR_CENRL3_Pos = 0x3
	// Bit mask of CENRL3 field.
	GPIO_PIN_INT_CIENR_CENRL3_Msk = 0x8
	// Bit CENRL3.
	GPIO_PIN_INT_CIENR_CENRL3 = 0x8
	// Position of CENRL4 field.
	GPIO_PIN_INT_CIENR_CENRL4_Pos = 0x4
	// Bit mask of CENRL4 field.
	GPIO_PIN_INT_CIENR_CENRL4_Msk = 0x10
	// Bit CENRL4.
	GPIO_PIN_INT_CIENR_CENRL4 = 0x10
	// Position of CENRL5 field.
	GPIO_PIN_INT_CIENR_CENRL5_Pos = 0x5
	// Bit mask of CENRL5 field.
	GPIO_PIN_INT_CIENR_CENRL5_Msk = 0x20
	// Bit CENRL5.
	GPIO_PIN_INT_CIENR_CENRL5 = 0x20
	// Position of CENRL6 field.
	GPIO_PIN_INT_CIENR_CENRL6_Pos = 0x6
	// Bit mask of CENRL6 field.
	GPIO_PIN_INT_CIENR_CENRL6_Msk = 0x40
	// Bit CENRL6.
	GPIO_PIN_INT_CIENR_CENRL6 = 0x40
	// Position of CENRL7 field.
	GPIO_PIN_INT_CIENR_CENRL7_Pos = 0x7
	// Bit mask of CENRL7 field.
	GPIO_PIN_INT_CIENR_CENRL7_Msk = 0x80
	// Bit CENRL7.
	GPIO_PIN_INT_CIENR_CENRL7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_CIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_CIENR_RESERVED_Msk = 0xffffff00

	// IENF: Pin Interrupt Enable Falling Edge / Active Level register
	// Position of ENAF0 field.
	GPIO_PIN_INT_IENF_ENAF0_Pos = 0x0
	// Bit mask of ENAF0 field.
	GPIO_PIN_INT_IENF_ENAF0_Msk = 0x1
	// Bit ENAF0.
	GPIO_PIN_INT_IENF_ENAF0 = 0x1
	// Position of ENAF1 field.
	GPIO_PIN_INT_IENF_ENAF1_Pos = 0x1
	// Bit mask of ENAF1 field.
	GPIO_PIN_INT_IENF_ENAF1_Msk = 0x2
	// Bit ENAF1.
	GPIO_PIN_INT_IENF_ENAF1 = 0x2
	// Position of ENAF2 field.
	GPIO_PIN_INT_IENF_ENAF2_Pos = 0x2
	// Bit mask of ENAF2 field.
	GPIO_PIN_INT_IENF_ENAF2_Msk = 0x4
	// Bit ENAF2.
	GPIO_PIN_INT_IENF_ENAF2 = 0x4
	// Position of ENAF3 field.
	GPIO_PIN_INT_IENF_ENAF3_Pos = 0x3
	// Bit mask of ENAF3 field.
	GPIO_PIN_INT_IENF_ENAF3_Msk = 0x8
	// Bit ENAF3.
	GPIO_PIN_INT_IENF_ENAF3 = 0x8
	// Position of ENAF4 field.
	GPIO_PIN_INT_IENF_ENAF4_Pos = 0x4
	// Bit mask of ENAF4 field.
	GPIO_PIN_INT_IENF_ENAF4_Msk = 0x10
	// Bit ENAF4.
	GPIO_PIN_INT_IENF_ENAF4 = 0x10
	// Position of ENAF5 field.
	GPIO_PIN_INT_IENF_ENAF5_Pos = 0x5
	// Bit mask of ENAF5 field.
	GPIO_PIN_INT_IENF_ENAF5_Msk = 0x20
	// Bit ENAF5.
	GPIO_PIN_INT_IENF_ENAF5 = 0x20
	// Position of ENAF6 field.
	GPIO_PIN_INT_IENF_ENAF6_Pos = 0x6
	// Bit mask of ENAF6 field.
	GPIO_PIN_INT_IENF_ENAF6_Msk = 0x40
	// Bit ENAF6.
	GPIO_PIN_INT_IENF_ENAF6 = 0x40
	// Position of ENAF7 field.
	GPIO_PIN_INT_IENF_ENAF7_Pos = 0x7
	// Bit mask of ENAF7 field.
	GPIO_PIN_INT_IENF_ENAF7_Msk = 0x80
	// Bit ENAF7.
	GPIO_PIN_INT_IENF_ENAF7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_IENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IENF_RESERVED_Msk = 0xffffff00

	// SIENF: Set Pin Interrupt Enable Falling Edge / Active Level register
	// Position of SETENAF0 field.
	GPIO_PIN_INT_SIENF_SETENAF0_Pos = 0x0
	// Bit mask of SETENAF0 field.
	GPIO_PIN_INT_SIENF_SETENAF0_Msk = 0x1
	// Bit SETENAF0.
	GPIO_PIN_INT_SIENF_SETENAF0 = 0x1
	// Position of SETENAF1 field.
	GPIO_PIN_INT_SIENF_SETENAF1_Pos = 0x1
	// Bit mask of SETENAF1 field.
	GPIO_PIN_INT_SIENF_SETENAF1_Msk = 0x2
	// Bit SETENAF1.
	GPIO_PIN_INT_SIENF_SETENAF1 = 0x2
	// Position of SETENAF2 field.
	GPIO_PIN_INT_SIENF_SETENAF2_Pos = 0x2
	// Bit mask of SETENAF2 field.
	GPIO_PIN_INT_SIENF_SETENAF2_Msk = 0x4
	// Bit SETENAF2.
	GPIO_PIN_INT_SIENF_SETENAF2 = 0x4
	// Position of SETENAF3 field.
	GPIO_PIN_INT_SIENF_SETENAF3_Pos = 0x3
	// Bit mask of SETENAF3 field.
	GPIO_PIN_INT_SIENF_SETENAF3_Msk = 0x8
	// Bit SETENAF3.
	GPIO_PIN_INT_SIENF_SETENAF3 = 0x8
	// Position of SETENAF4 field.
	GPIO_PIN_INT_SIENF_SETENAF4_Pos = 0x4
	// Bit mask of SETENAF4 field.
	GPIO_PIN_INT_SIENF_SETENAF4_Msk = 0x10
	// Bit SETENAF4.
	GPIO_PIN_INT_SIENF_SETENAF4 = 0x10
	// Position of SETENAF5 field.
	GPIO_PIN_INT_SIENF_SETENAF5_Pos = 0x5
	// Bit mask of SETENAF5 field.
	GPIO_PIN_INT_SIENF_SETENAF5_Msk = 0x20
	// Bit SETENAF5.
	GPIO_PIN_INT_SIENF_SETENAF5 = 0x20
	// Position of SETENAF6 field.
	GPIO_PIN_INT_SIENF_SETENAF6_Pos = 0x6
	// Bit mask of SETENAF6 field.
	GPIO_PIN_INT_SIENF_SETENAF6_Msk = 0x40
	// Bit SETENAF6.
	GPIO_PIN_INT_SIENF_SETENAF6 = 0x40
	// Position of SETENAF7 field.
	GPIO_PIN_INT_SIENF_SETENAF7_Pos = 0x7
	// Bit mask of SETENAF7 field.
	GPIO_PIN_INT_SIENF_SETENAF7_Msk = 0x80
	// Bit SETENAF7.
	GPIO_PIN_INT_SIENF_SETENAF7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_SIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_SIENF_RESERVED_Msk = 0xffffff00

	// CIENF: Clear Pin Interrupt Enable Falling Edge / Active Level address
	// Position of CENAF0 field.
	GPIO_PIN_INT_CIENF_CENAF0_Pos = 0x0
	// Bit mask of CENAF0 field.
	GPIO_PIN_INT_CIENF_CENAF0_Msk = 0x1
	// Bit CENAF0.
	GPIO_PIN_INT_CIENF_CENAF0 = 0x1
	// Position of CENAF1 field.
	GPIO_PIN_INT_CIENF_CENAF1_Pos = 0x1
	// Bit mask of CENAF1 field.
	GPIO_PIN_INT_CIENF_CENAF1_Msk = 0x2
	// Bit CENAF1.
	GPIO_PIN_INT_CIENF_CENAF1 = 0x2
	// Position of CENAF2 field.
	GPIO_PIN_INT_CIENF_CENAF2_Pos = 0x2
	// Bit mask of CENAF2 field.
	GPIO_PIN_INT_CIENF_CENAF2_Msk = 0x4
	// Bit CENAF2.
	GPIO_PIN_INT_CIENF_CENAF2 = 0x4
	// Position of CENAF3 field.
	GPIO_PIN_INT_CIENF_CENAF3_Pos = 0x3
	// Bit mask of CENAF3 field.
	GPIO_PIN_INT_CIENF_CENAF3_Msk = 0x8
	// Bit CENAF3.
	GPIO_PIN_INT_CIENF_CENAF3 = 0x8
	// Position of CENAF4 field.
	GPIO_PIN_INT_CIENF_CENAF4_Pos = 0x4
	// Bit mask of CENAF4 field.
	GPIO_PIN_INT_CIENF_CENAF4_Msk = 0x10
	// Bit CENAF4.
	GPIO_PIN_INT_CIENF_CENAF4 = 0x10
	// Position of CENAF5 field.
	GPIO_PIN_INT_CIENF_CENAF5_Pos = 0x5
	// Bit mask of CENAF5 field.
	GPIO_PIN_INT_CIENF_CENAF5_Msk = 0x20
	// Bit CENAF5.
	GPIO_PIN_INT_CIENF_CENAF5 = 0x20
	// Position of CENAF6 field.
	GPIO_PIN_INT_CIENF_CENAF6_Pos = 0x6
	// Bit mask of CENAF6 field.
	GPIO_PIN_INT_CIENF_CENAF6_Msk = 0x40
	// Bit CENAF6.
	GPIO_PIN_INT_CIENF_CENAF6 = 0x40
	// Position of CENAF7 field.
	GPIO_PIN_INT_CIENF_CENAF7_Pos = 0x7
	// Bit mask of CENAF7 field.
	GPIO_PIN_INT_CIENF_CENAF7_Msk = 0x80
	// Bit CENAF7.
	GPIO_PIN_INT_CIENF_CENAF7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_CIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_CIENF_RESERVED_Msk = 0xffffff00

	// RISE: Pin Interrupt Rising Edge register
	// Position of RDET0 field.
	GPIO_PIN_INT_RISE_RDET0_Pos = 0x0
	// Bit mask of RDET0 field.
	GPIO_PIN_INT_RISE_RDET0_Msk = 0x1
	// Bit RDET0.
	GPIO_PIN_INT_RISE_RDET0 = 0x1
	// Position of RDET1 field.
	GPIO_PIN_INT_RISE_RDET1_Pos = 0x1
	// Bit mask of RDET1 field.
	GPIO_PIN_INT_RISE_RDET1_Msk = 0x2
	// Bit RDET1.
	GPIO_PIN_INT_RISE_RDET1 = 0x2
	// Position of RDET2 field.
	GPIO_PIN_INT_RISE_RDET2_Pos = 0x2
	// Bit mask of RDET2 field.
	GPIO_PIN_INT_RISE_RDET2_Msk = 0x4
	// Bit RDET2.
	GPIO_PIN_INT_RISE_RDET2 = 0x4
	// Position of RDET3 field.
	GPIO_PIN_INT_RISE_RDET3_Pos = 0x3
	// Bit mask of RDET3 field.
	GPIO_PIN_INT_RISE_RDET3_Msk = 0x8
	// Bit RDET3.
	GPIO_PIN_INT_RISE_RDET3 = 0x8
	// Position of RDET4 field.
	GPIO_PIN_INT_RISE_RDET4_Pos = 0x4
	// Bit mask of RDET4 field.
	GPIO_PIN_INT_RISE_RDET4_Msk = 0x10
	// Bit RDET4.
	GPIO_PIN_INT_RISE_RDET4 = 0x10
	// Position of RDET5 field.
	GPIO_PIN_INT_RISE_RDET5_Pos = 0x5
	// Bit mask of RDET5 field.
	GPIO_PIN_INT_RISE_RDET5_Msk = 0x20
	// Bit RDET5.
	GPIO_PIN_INT_RISE_RDET5 = 0x20
	// Position of RDET6 field.
	GPIO_PIN_INT_RISE_RDET6_Pos = 0x6
	// Bit mask of RDET6 field.
	GPIO_PIN_INT_RISE_RDET6_Msk = 0x40
	// Bit RDET6.
	GPIO_PIN_INT_RISE_RDET6 = 0x40
	// Position of RDET7 field.
	GPIO_PIN_INT_RISE_RDET7_Pos = 0x7
	// Bit mask of RDET7 field.
	GPIO_PIN_INT_RISE_RDET7_Msk = 0x80
	// Bit RDET7.
	GPIO_PIN_INT_RISE_RDET7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_RISE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_RISE_RESERVED_Msk = 0xffffff00

	// FALL: Pin Interrupt Falling Edge register
	// Position of FDET0 field.
	GPIO_PIN_INT_FALL_FDET0_Pos = 0x0
	// Bit mask of FDET0 field.
	GPIO_PIN_INT_FALL_FDET0_Msk = 0x1
	// Bit FDET0.
	GPIO_PIN_INT_FALL_FDET0 = 0x1
	// Position of FDET1 field.
	GPIO_PIN_INT_FALL_FDET1_Pos = 0x1
	// Bit mask of FDET1 field.
	GPIO_PIN_INT_FALL_FDET1_Msk = 0x2
	// Bit FDET1.
	GPIO_PIN_INT_FALL_FDET1 = 0x2
	// Position of FDET2 field.
	GPIO_PIN_INT_FALL_FDET2_Pos = 0x2
	// Bit mask of FDET2 field.
	GPIO_PIN_INT_FALL_FDET2_Msk = 0x4
	// Bit FDET2.
	GPIO_PIN_INT_FALL_FDET2 = 0x4
	// Position of FDET3 field.
	GPIO_PIN_INT_FALL_FDET3_Pos = 0x3
	// Bit mask of FDET3 field.
	GPIO_PIN_INT_FALL_FDET3_Msk = 0x8
	// Bit FDET3.
	GPIO_PIN_INT_FALL_FDET3 = 0x8
	// Position of FDET4 field.
	GPIO_PIN_INT_FALL_FDET4_Pos = 0x4
	// Bit mask of FDET4 field.
	GPIO_PIN_INT_FALL_FDET4_Msk = 0x10
	// Bit FDET4.
	GPIO_PIN_INT_FALL_FDET4 = 0x10
	// Position of FDET5 field.
	GPIO_PIN_INT_FALL_FDET5_Pos = 0x5
	// Bit mask of FDET5 field.
	GPIO_PIN_INT_FALL_FDET5_Msk = 0x20
	// Bit FDET5.
	GPIO_PIN_INT_FALL_FDET5 = 0x20
	// Position of FDET6 field.
	GPIO_PIN_INT_FALL_FDET6_Pos = 0x6
	// Bit mask of FDET6 field.
	GPIO_PIN_INT_FALL_FDET6_Msk = 0x40
	// Bit FDET6.
	GPIO_PIN_INT_FALL_FDET6 = 0x40
	// Position of FDET7 field.
	GPIO_PIN_INT_FALL_FDET7_Pos = 0x7
	// Bit mask of FDET7 field.
	GPIO_PIN_INT_FALL_FDET7_Msk = 0x80
	// Bit FDET7.
	GPIO_PIN_INT_FALL_FDET7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_FALL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_FALL_RESERVED_Msk = 0xffffff00

	// IST: Pin Interrupt Status register
	// Position of PSTAT0 field.
	GPIO_PIN_INT_IST_PSTAT0_Pos = 0x0
	// Bit mask of PSTAT0 field.
	GPIO_PIN_INT_IST_PSTAT0_Msk = 0x1
	// Bit PSTAT0.
	GPIO_PIN_INT_IST_PSTAT0 = 0x1
	// Position of PSTAT1 field.
	GPIO_PIN_INT_IST_PSTAT1_Pos = 0x1
	// Bit mask of PSTAT1 field.
	GPIO_PIN_INT_IST_PSTAT1_Msk = 0x2
	// Bit PSTAT1.
	GPIO_PIN_INT_IST_PSTAT1 = 0x2
	// Position of PSTAT2 field.
	GPIO_PIN_INT_IST_PSTAT2_Pos = 0x2
	// Bit mask of PSTAT2 field.
	GPIO_PIN_INT_IST_PSTAT2_Msk = 0x4
	// Bit PSTAT2.
	GPIO_PIN_INT_IST_PSTAT2 = 0x4
	// Position of PSTAT3 field.
	GPIO_PIN_INT_IST_PSTAT3_Pos = 0x3
	// Bit mask of PSTAT3 field.
	GPIO_PIN_INT_IST_PSTAT3_Msk = 0x8
	// Bit PSTAT3.
	GPIO_PIN_INT_IST_PSTAT3 = 0x8
	// Position of PSTAT4 field.
	GPIO_PIN_INT_IST_PSTAT4_Pos = 0x4
	// Bit mask of PSTAT4 field.
	GPIO_PIN_INT_IST_PSTAT4_Msk = 0x10
	// Bit PSTAT4.
	GPIO_PIN_INT_IST_PSTAT4 = 0x10
	// Position of PSTAT5 field.
	GPIO_PIN_INT_IST_PSTAT5_Pos = 0x5
	// Bit mask of PSTAT5 field.
	GPIO_PIN_INT_IST_PSTAT5_Msk = 0x20
	// Bit PSTAT5.
	GPIO_PIN_INT_IST_PSTAT5 = 0x20
	// Position of PSTAT6 field.
	GPIO_PIN_INT_IST_PSTAT6_Pos = 0x6
	// Bit mask of PSTAT6 field.
	GPIO_PIN_INT_IST_PSTAT6_Msk = 0x40
	// Bit PSTAT6.
	GPIO_PIN_INT_IST_PSTAT6 = 0x40
	// Position of PSTAT7 field.
	GPIO_PIN_INT_IST_PSTAT7_Pos = 0x7
	// Bit mask of PSTAT7 field.
	GPIO_PIN_INT_IST_PSTAT7_Msk = 0x80
	// Bit PSTAT7.
	GPIO_PIN_INT_IST_PSTAT7 = 0x80
	// Position of RESERVED field.
	GPIO_PIN_INT_IST_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IST_RESERVED_Msk = 0xffffff00
)

// Bitfields for GPIO_GROUP_INT0: GPIO group interrupt 0
const (
	// CTRL: GPIO grouped interrupt control register
	// Position of INT field.
	GPIO_GROUP_INT0_CTRL_INT_Pos = 0x0
	// Bit mask of INT field.
	GPIO_GROUP_INT0_CTRL_INT_Msk = 0x1
	// Bit INT.
	GPIO_GROUP_INT0_CTRL_INT = 0x1
	// No interrupt request is pending.
	GPIO_GROUP_INT0_CTRL_INT_NO_INTERRUPT_REQUEST = 0x0
	// Interrupt request is active.
	GPIO_GROUP_INT0_CTRL_INT_INTERRUPT_REQUEST_IS = 0x1
	// Position of COMB field.
	GPIO_GROUP_INT0_CTRL_COMB_Pos = 0x1
	// Bit mask of COMB field.
	GPIO_GROUP_INT0_CTRL_COMB_Msk = 0x2
	// Bit COMB.
	GPIO_GROUP_INT0_CTRL_COMB = 0x2
	// OR functionality: A grouped interrupt is generated when any one of the enabled inputs is active (based on its programmed polarity).
	GPIO_GROUP_INT0_CTRL_COMB_OR_FUNCTIONALITY_A_ = 0x0
	// AND functionality: An interrupt is generated when all enabled bits are active (based on their programmed polarity).
	GPIO_GROUP_INT0_CTRL_COMB_AND_FUNCTIONALITY_A = 0x1
	// Position of TRIG field.
	GPIO_GROUP_INT0_CTRL_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	GPIO_GROUP_INT0_CTRL_TRIG_Msk = 0x4
	// Bit TRIG.
	GPIO_GROUP_INT0_CTRL_TRIG = 0x4
	// Edge-triggered
	GPIO_GROUP_INT0_CTRL_TRIG_EDGE_TRIGGERED = 0x0
	// Level-triggered
	GPIO_GROUP_INT0_CTRL_TRIG_LEVEL_TRIGGERED = 0x1
	// Position of RESERVED field.
	GPIO_GROUP_INT0_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	GPIO_GROUP_INT0_CTRL_RESERVED_Msk = 0xfffffff8

	// PORT_POL0: GPIO grouped interrupt port polarity register
	// Position of POL_0 field.
	GPIO_GROUP_INT0_PORT_POL_POL_0_Pos = 0x0
	// Bit mask of POL_0 field.
	GPIO_GROUP_INT0_PORT_POL_POL_0_Msk = 0x1
	// Bit POL_0.
	GPIO_GROUP_INT0_PORT_POL_POL_0 = 0x1
	// Position of POL_1 field.
	GPIO_GROUP_INT0_PORT_POL_POL_1_Pos = 0x1
	// Bit mask of POL_1 field.
	GPIO_GROUP_INT0_PORT_POL_POL_1_Msk = 0x2
	// Bit POL_1.
	GPIO_GROUP_INT0_PORT_POL_POL_1 = 0x2
	// Position of POL_2 field.
	GPIO_GROUP_INT0_PORT_POL_POL_2_Pos = 0x2
	// Bit mask of POL_2 field.
	GPIO_GROUP_INT0_PORT_POL_POL_2_Msk = 0x4
	// Bit POL_2.
	GPIO_GROUP_INT0_PORT_POL_POL_2 = 0x4
	// Position of POL_3 field.
	GPIO_GROUP_INT0_PORT_POL_POL_3_Pos = 0x3
	// Bit mask of POL_3 field.
	GPIO_GROUP_INT0_PORT_POL_POL_3_Msk = 0x8
	// Bit POL_3.
	GPIO_GROUP_INT0_PORT_POL_POL_3 = 0x8
	// Position of POL_4 field.
	GPIO_GROUP_INT0_PORT_POL_POL_4_Pos = 0x4
	// Bit mask of POL_4 field.
	GPIO_GROUP_INT0_PORT_POL_POL_4_Msk = 0x10
	// Bit POL_4.
	GPIO_GROUP_INT0_PORT_POL_POL_4 = 0x10
	// Position of POL_5 field.
	GPIO_GROUP_INT0_PORT_POL_POL_5_Pos = 0x5
	// Bit mask of POL_5 field.
	GPIO_GROUP_INT0_PORT_POL_POL_5_Msk = 0x20
	// Bit POL_5.
	GPIO_GROUP_INT0_PORT_POL_POL_5 = 0x20
	// Position of POL_6 field.
	GPIO_GROUP_INT0_PORT_POL_POL_6_Pos = 0x6
	// Bit mask of POL_6 field.
	GPIO_GROUP_INT0_PORT_POL_POL_6_Msk = 0x40
	// Bit POL_6.
	GPIO_GROUP_INT0_PORT_POL_POL_6 = 0x40
	// Position of POL_7 field.
	GPIO_GROUP_INT0_PORT_POL_POL_7_Pos = 0x7
	// Bit mask of POL_7 field.
	GPIO_GROUP_INT0_PORT_POL_POL_7_Msk = 0x80
	// Bit POL_7.
	GPIO_GROUP_INT0_PORT_POL_POL_7 = 0x80
	// Position of POL_8 field.
	GPIO_GROUP_INT0_PORT_POL_POL_8_Pos = 0x8
	// Bit mask of POL_8 field.
	GPIO_GROUP_INT0_PORT_POL_POL_8_Msk = 0x100
	// Bit POL_8.
	GPIO_GROUP_INT0_PORT_POL_POL_8 = 0x100
	// Position of POL_9 field.
	GPIO_GROUP_INT0_PORT_POL_POL_9_Pos = 0x9
	// Bit mask of POL_9 field.
	GPIO_GROUP_INT0_PORT_POL_POL_9_Msk = 0x200
	// Bit POL_9.
	GPIO_GROUP_INT0_PORT_POL_POL_9 = 0x200
	// Position of POL_10 field.
	GPIO_GROUP_INT0_PORT_POL_POL_10_Pos = 0xa
	// Bit mask of POL_10 field.
	GPIO_GROUP_INT0_PORT_POL_POL_10_Msk = 0x400
	// Bit POL_10.
	GPIO_GROUP_INT0_PORT_POL_POL_10 = 0x400
	// Position of POL_11 field.
	GPIO_GROUP_INT0_PORT_POL_POL_11_Pos = 0xb
	// Bit mask of POL_11 field.
	GPIO_GROUP_INT0_PORT_POL_POL_11_Msk = 0x800
	// Bit POL_11.
	GPIO_GROUP_INT0_PORT_POL_POL_11 = 0x800
	// Position of POL_12 field.
	GPIO_GROUP_INT0_PORT_POL_POL_12_Pos = 0xc
	// Bit mask of POL_12 field.
	GPIO_GROUP_INT0_PORT_POL_POL_12_Msk = 0x1000
	// Bit POL_12.
	GPIO_GROUP_INT0_PORT_POL_POL_12 = 0x1000
	// Position of POL_13 field.
	GPIO_GROUP_INT0_PORT_POL_POL_13_Pos = 0xd
	// Bit mask of POL_13 field.
	GPIO_GROUP_INT0_PORT_POL_POL_13_Msk = 0x2000
	// Bit POL_13.
	GPIO_GROUP_INT0_PORT_POL_POL_13 = 0x2000
	// Position of POL_14 field.
	GPIO_GROUP_INT0_PORT_POL_POL_14_Pos = 0xe
	// Bit mask of POL_14 field.
	GPIO_GROUP_INT0_PORT_POL_POL_14_Msk = 0x4000
	// Bit POL_14.
	GPIO_GROUP_INT0_PORT_POL_POL_14 = 0x4000
	// Position of POL_15 field.
	GPIO_GROUP_INT0_PORT_POL_POL_15_Pos = 0xf
	// Bit mask of POL_15 field.
	GPIO_GROUP_INT0_PORT_POL_POL_15_Msk = 0x8000
	// Bit POL_15.
	GPIO_GROUP_INT0_PORT_POL_POL_15 = 0x8000
	// Position of POL_16 field.
	GPIO_GROUP_INT0_PORT_POL_POL_16_Pos = 0x10
	// Bit mask of POL_16 field.
	GPIO_GROUP_INT0_PORT_POL_POL_16_Msk = 0x10000
	// Bit POL_16.
	GPIO_GROUP_INT0_PORT_POL_POL_16 = 0x10000
	// Position of POL_17 field.
	GPIO_GROUP_INT0_PORT_POL_POL_17_Pos = 0x11
	// Bit mask of POL_17 field.
	GPIO_GROUP_INT0_PORT_POL_POL_17_Msk = 0x20000
	// Bit POL_17.
	GPIO_GROUP_INT0_PORT_POL_POL_17 = 0x20000
	// Position of POL_18 field.
	GPIO_GROUP_INT0_PORT_POL_POL_18_Pos = 0x12
	// Bit mask of POL_18 field.
	GPIO_GROUP_INT0_PORT_POL_POL_18_Msk = 0x40000
	// Bit POL_18.
	GPIO_GROUP_INT0_PORT_POL_POL_18 = 0x40000
	// Position of POL_19 field.
	GPIO_GROUP_INT0_PORT_POL_POL_19_Pos = 0x13
	// Bit mask of POL_19 field.
	GPIO_GROUP_INT0_PORT_POL_POL_19_Msk = 0x80000
	// Bit POL_19.
	GPIO_GROUP_INT0_PORT_POL_POL_19 = 0x80000
	// Position of POL_20 field.
	GPIO_GROUP_INT0_PORT_POL_POL_20_Pos = 0x14
	// Bit mask of POL_20 field.
	GPIO_GROUP_INT0_PORT_POL_POL_20_Msk = 0x100000
	// Bit POL_20.
	GPIO_GROUP_INT0_PORT_POL_POL_20 = 0x100000
	// Position of POL_21 field.
	GPIO_GROUP_INT0_PORT_POL_POL_21_Pos = 0x15
	// Bit mask of POL_21 field.
	GPIO_GROUP_INT0_PORT_POL_POL_21_Msk = 0x200000
	// Bit POL_21.
	GPIO_GROUP_INT0_PORT_POL_POL_21 = 0x200000
	// Position of POL_22 field.
	GPIO_GROUP_INT0_PORT_POL_POL_22_Pos = 0x16
	// Bit mask of POL_22 field.
	GPIO_GROUP_INT0_PORT_POL_POL_22_Msk = 0x400000
	// Bit POL_22.
	GPIO_GROUP_INT0_PORT_POL_POL_22 = 0x400000
	// Position of POL_23 field.
	GPIO_GROUP_INT0_PORT_POL_POL_23_Pos = 0x17
	// Bit mask of POL_23 field.
	GPIO_GROUP_INT0_PORT_POL_POL_23_Msk = 0x800000
	// Bit POL_23.
	GPIO_GROUP_INT0_PORT_POL_POL_23 = 0x800000
	// Position of POL_24 field.
	GPIO_GROUP_INT0_PORT_POL_POL_24_Pos = 0x18
	// Bit mask of POL_24 field.
	GPIO_GROUP_INT0_PORT_POL_POL_24_Msk = 0x1000000
	// Bit POL_24.
	GPIO_GROUP_INT0_PORT_POL_POL_24 = 0x1000000
	// Position of POL_25 field.
	GPIO_GROUP_INT0_PORT_POL_POL_25_Pos = 0x19
	// Bit mask of POL_25 field.
	GPIO_GROUP_INT0_PORT_POL_POL_25_Msk = 0x2000000
	// Bit POL_25.
	GPIO_GROUP_INT0_PORT_POL_POL_25 = 0x2000000
	// Position of POL_26 field.
	GPIO_GROUP_INT0_PORT_POL_POL_26_Pos = 0x1a
	// Bit mask of POL_26 field.
	GPIO_GROUP_INT0_PORT_POL_POL_26_Msk = 0x4000000
	// Bit POL_26.
	GPIO_GROUP_INT0_PORT_POL_POL_26 = 0x4000000
	// Position of POL_27 field.
	GPIO_GROUP_INT0_PORT_POL_POL_27_Pos = 0x1b
	// Bit mask of POL_27 field.
	GPIO_GROUP_INT0_PORT_POL_POL_27_Msk = 0x8000000
	// Bit POL_27.
	GPIO_GROUP_INT0_PORT_POL_POL_27 = 0x8000000
	// Position of POL_28 field.
	GPIO_GROUP_INT0_PORT_POL_POL_28_Pos = 0x1c
	// Bit mask of POL_28 field.
	GPIO_GROUP_INT0_PORT_POL_POL_28_Msk = 0x10000000
	// Bit POL_28.
	GPIO_GROUP_INT0_PORT_POL_POL_28 = 0x10000000
	// Position of POL_29 field.
	GPIO_GROUP_INT0_PORT_POL_POL_29_Pos = 0x1d
	// Bit mask of POL_29 field.
	GPIO_GROUP_INT0_PORT_POL_POL_29_Msk = 0x20000000
	// Bit POL_29.
	GPIO_GROUP_INT0_PORT_POL_POL_29 = 0x20000000
	// Position of POL_30 field.
	GPIO_GROUP_INT0_PORT_POL_POL_30_Pos = 0x1e
	// Bit mask of POL_30 field.
	GPIO_GROUP_INT0_PORT_POL_POL_30_Msk = 0x40000000
	// Bit POL_30.
	GPIO_GROUP_INT0_PORT_POL_POL_30 = 0x40000000
	// Position of POL_31 field.
	GPIO_GROUP_INT0_PORT_POL_POL_31_Pos = 0x1f
	// Bit mask of POL_31 field.
	GPIO_GROUP_INT0_PORT_POL_POL_31_Msk = 0x80000000
	// Bit POL_31.
	GPIO_GROUP_INT0_PORT_POL_POL_31 = 0x80000000

	// PORT_ENA0: GPIO grouped interrupt port m enable register
	// Position of ENA_0 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_0_Pos = 0x0
	// Bit mask of ENA_0 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_0_Msk = 0x1
	// Bit ENA_0.
	GPIO_GROUP_INT0_PORT_ENA_ENA_0 = 0x1
	// Position of ENA_1 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_1_Pos = 0x1
	// Bit mask of ENA_1 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_1_Msk = 0x2
	// Bit ENA_1.
	GPIO_GROUP_INT0_PORT_ENA_ENA_1 = 0x2
	// Position of ENA_2 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_2_Pos = 0x2
	// Bit mask of ENA_2 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_2_Msk = 0x4
	// Bit ENA_2.
	GPIO_GROUP_INT0_PORT_ENA_ENA_2 = 0x4
	// Position of ENA_3 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_3_Pos = 0x3
	// Bit mask of ENA_3 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_3_Msk = 0x8
	// Bit ENA_3.
	GPIO_GROUP_INT0_PORT_ENA_ENA_3 = 0x8
	// Position of ENA_4 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_4_Pos = 0x4
	// Bit mask of ENA_4 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_4_Msk = 0x10
	// Bit ENA_4.
	GPIO_GROUP_INT0_PORT_ENA_ENA_4 = 0x10
	// Position of ENA_5 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_5_Pos = 0x5
	// Bit mask of ENA_5 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_5_Msk = 0x20
	// Bit ENA_5.
	GPIO_GROUP_INT0_PORT_ENA_ENA_5 = 0x20
	// Position of ENA_6 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_6_Pos = 0x6
	// Bit mask of ENA_6 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_6_Msk = 0x40
	// Bit ENA_6.
	GPIO_GROUP_INT0_PORT_ENA_ENA_6 = 0x40
	// Position of ENA_7 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_7_Pos = 0x7
	// Bit mask of ENA_7 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_7_Msk = 0x80
	// Bit ENA_7.
	GPIO_GROUP_INT0_PORT_ENA_ENA_7 = 0x80
	// Position of ENA_8 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_8_Pos = 0x8
	// Bit mask of ENA_8 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_8_Msk = 0x100
	// Bit ENA_8.
	GPIO_GROUP_INT0_PORT_ENA_ENA_8 = 0x100
	// Position of ENA_9 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_9_Pos = 0x9
	// Bit mask of ENA_9 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_9_Msk = 0x200
	// Bit ENA_9.
	GPIO_GROUP_INT0_PORT_ENA_ENA_9 = 0x200
	// Position of ENA_10 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_10_Pos = 0xa
	// Bit mask of ENA_10 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_10_Msk = 0x400
	// Bit ENA_10.
	GPIO_GROUP_INT0_PORT_ENA_ENA_10 = 0x400
	// Position of ENA_11 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_11_Pos = 0xb
	// Bit mask of ENA_11 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_11_Msk = 0x800
	// Bit ENA_11.
	GPIO_GROUP_INT0_PORT_ENA_ENA_11 = 0x800
	// Position of ENA_12 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_12_Pos = 0xc
	// Bit mask of ENA_12 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_12_Msk = 0x1000
	// Bit ENA_12.
	GPIO_GROUP_INT0_PORT_ENA_ENA_12 = 0x1000
	// Position of ENA_13 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_13_Pos = 0xd
	// Bit mask of ENA_13 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_13_Msk = 0x2000
	// Bit ENA_13.
	GPIO_GROUP_INT0_PORT_ENA_ENA_13 = 0x2000
	// Position of ENA_14 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_14_Pos = 0xe
	// Bit mask of ENA_14 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_14_Msk = 0x4000
	// Bit ENA_14.
	GPIO_GROUP_INT0_PORT_ENA_ENA_14 = 0x4000
	// Position of ENA_15 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_15_Pos = 0xf
	// Bit mask of ENA_15 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_15_Msk = 0x8000
	// Bit ENA_15.
	GPIO_GROUP_INT0_PORT_ENA_ENA_15 = 0x8000
	// Position of ENA_16 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_16_Pos = 0x10
	// Bit mask of ENA_16 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_16_Msk = 0x10000
	// Bit ENA_16.
	GPIO_GROUP_INT0_PORT_ENA_ENA_16 = 0x10000
	// Position of ENA_17 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_17_Pos = 0x11
	// Bit mask of ENA_17 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_17_Msk = 0x20000
	// Bit ENA_17.
	GPIO_GROUP_INT0_PORT_ENA_ENA_17 = 0x20000
	// Position of ENA_18 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_18_Pos = 0x12
	// Bit mask of ENA_18 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_18_Msk = 0x40000
	// Bit ENA_18.
	GPIO_GROUP_INT0_PORT_ENA_ENA_18 = 0x40000
	// Position of ENA_19 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_19_Pos = 0x13
	// Bit mask of ENA_19 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_19_Msk = 0x80000
	// Bit ENA_19.
	GPIO_GROUP_INT0_PORT_ENA_ENA_19 = 0x80000
	// Position of ENA_20 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_20_Pos = 0x14
	// Bit mask of ENA_20 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_20_Msk = 0x100000
	// Bit ENA_20.
	GPIO_GROUP_INT0_PORT_ENA_ENA_20 = 0x100000
	// Position of ENA_21 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_21_Pos = 0x15
	// Bit mask of ENA_21 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_21_Msk = 0x200000
	// Bit ENA_21.
	GPIO_GROUP_INT0_PORT_ENA_ENA_21 = 0x200000
	// Position of ENA_22 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_22_Pos = 0x16
	// Bit mask of ENA_22 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_22_Msk = 0x400000
	// Bit ENA_22.
	GPIO_GROUP_INT0_PORT_ENA_ENA_22 = 0x400000
	// Position of ENA_23 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_23_Pos = 0x17
	// Bit mask of ENA_23 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_23_Msk = 0x800000
	// Bit ENA_23.
	GPIO_GROUP_INT0_PORT_ENA_ENA_23 = 0x800000
	// Position of ENA_24 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_24_Pos = 0x18
	// Bit mask of ENA_24 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_24_Msk = 0x1000000
	// Bit ENA_24.
	GPIO_GROUP_INT0_PORT_ENA_ENA_24 = 0x1000000
	// Position of ENA_25 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_25_Pos = 0x19
	// Bit mask of ENA_25 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_25_Msk = 0x2000000
	// Bit ENA_25.
	GPIO_GROUP_INT0_PORT_ENA_ENA_25 = 0x2000000
	// Position of ENA_26 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_26_Pos = 0x1a
	// Bit mask of ENA_26 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_26_Msk = 0x4000000
	// Bit ENA_26.
	GPIO_GROUP_INT0_PORT_ENA_ENA_26 = 0x4000000
	// Position of ENA_27 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_27_Pos = 0x1b
	// Bit mask of ENA_27 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_27_Msk = 0x8000000
	// Bit ENA_27.
	GPIO_GROUP_INT0_PORT_ENA_ENA_27 = 0x8000000
	// Position of ENA_28 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_28_Pos = 0x1c
	// Bit mask of ENA_28 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_28_Msk = 0x10000000
	// Bit ENA_28.
	GPIO_GROUP_INT0_PORT_ENA_ENA_28 = 0x10000000
	// Position of ENA_29 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_29_Pos = 0x1d
	// Bit mask of ENA_29 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_29_Msk = 0x20000000
	// Bit ENA_29.
	GPIO_GROUP_INT0_PORT_ENA_ENA_29 = 0x20000000
	// Position of ENA_30 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_30_Pos = 0x1e
	// Bit mask of ENA_30 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_30_Msk = 0x40000000
	// Bit ENA_30.
	GPIO_GROUP_INT0_PORT_ENA_ENA_30 = 0x40000000
	// Position of ENA_31 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_31_Pos = 0x1f
	// Bit mask of ENA_31 field.
	GPIO_GROUP_INT0_PORT_ENA_ENA_31_Msk = 0x80000000
	// Bit ENA_31.
	GPIO_GROUP_INT0_PORT_ENA_ENA_31 = 0x80000000
)

// Bitfields for MCPWM: Motor Control PWM (MOTOCONPWM)
const (
	// CON: PWM Control read address
	// Position of RUN0 field.
	MCPWM_CON_RUN0_Pos = 0x0
	// Bit mask of RUN0 field.
	MCPWM_CON_RUN0_Msk = 0x1
	// Bit RUN0.
	MCPWM_CON_RUN0 = 0x1
	// Stop.
	MCPWM_CON_RUN0_STOP_ = 0x0
	// Run.
	MCPWM_CON_RUN0_RUN_ = 0x1
	// Position of CENTER0 field.
	MCPWM_CON_CENTER0_Pos = 0x1
	// Bit mask of CENTER0 field.
	MCPWM_CON_CENTER0_Msk = 0x2
	// Bit CENTER0.
	MCPWM_CON_CENTER0 = 0x2
	// Edge-aligned.
	MCPWM_CON_CENTER0_EDGE_ALIGNED_ = 0x0
	// Center-aligned.
	MCPWM_CON_CENTER0_CENTER_ALIGNED_ = 0x1
	// Position of POLA0 field.
	MCPWM_CON_POLA0_Pos = 0x2
	// Bit mask of POLA0 field.
	MCPWM_CON_POLA0_Msk = 0x4
	// Bit POLA0.
	MCPWM_CON_POLA0 = 0x4
	// Passive state is LOW, active state is HIGH.
	MCPWM_CON_POLA0_PASSIVE_STATE_IS_LOW = 0x0
	// Passive state is HIGH, active state is LOW.
	MCPWM_CON_POLA0_PASSIVE_STATE_IS_HIG = 0x1
	// Position of DTE0 field.
	MCPWM_CON_DTE0_Pos = 0x3
	// Bit mask of DTE0 field.
	MCPWM_CON_DTE0_Msk = 0x8
	// Bit DTE0.
	MCPWM_CON_DTE0 = 0x8
	// Dead-time disabled.
	MCPWM_CON_DTE0_DEAD_TIME_DISABLED_ = 0x0
	// Dead-time enabled.
	MCPWM_CON_DTE0_DEAD_TIME_ENABLED_ = 0x1
	// Position of DISUP0 field.
	MCPWM_CON_DISUP0_Pos = 0x4
	// Bit mask of DISUP0 field.
	MCPWM_CON_DISUP0_Msk = 0x10
	// Bit DISUP0.
	MCPWM_CON_DISUP0 = 0x10
	// Functional registers are updated from the write registers at the end of each PWM cycle.
	MCPWM_CON_DISUP0_UPDATE = 0x0
	// Functional registers remain the same as long as the timer is running.
	MCPWM_CON_DISUP0_NOUPDATE = 0x1
	// Position of RESERVED field.
	MCPWM_CON_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	MCPWM_CON_RESERVED_Msk = 0xe0
	// Position of RUN1 field.
	MCPWM_CON_RUN1_Pos = 0x8
	// Bit mask of RUN1 field.
	MCPWM_CON_RUN1_Msk = 0x100
	// Bit RUN1.
	MCPWM_CON_RUN1 = 0x100
	// Stop.
	MCPWM_CON_RUN1_STOP_ = 0x0
	// Run.
	MCPWM_CON_RUN1_RUN_ = 0x1
	// Position of CENTER1 field.
	MCPWM_CON_CENTER1_Pos = 0x9
	// Bit mask of CENTER1 field.
	MCPWM_CON_CENTER1_Msk = 0x200
	// Bit CENTER1.
	MCPWM_CON_CENTER1 = 0x200
	// Edge-aligned.
	MCPWM_CON_CENTER1_EDGE_ALIGNED_ = 0x0
	// Center-aligned.
	MCPWM_CON_CENTER1_CENTER_ALIGNED_ = 0x1
	// Position of POLA1 field.
	MCPWM_CON_POLA1_Pos = 0xa
	// Bit mask of POLA1 field.
	MCPWM_CON_POLA1_Msk = 0x400
	// Bit POLA1.
	MCPWM_CON_POLA1 = 0x400
	// Passive state is LOW, active state is HIGH.
	MCPWM_CON_POLA1_PASSIVE_STATE_IS_LOW = 0x0
	// Passive state is HIGH, active state is LOW.
	MCPWM_CON_POLA1_PASSIVE_STATE_IS_HIG = 0x1
	// Position of DTE1 field.
	MCPWM_CON_DTE1_Pos = 0xb
	// Bit mask of DTE1 field.
	MCPWM_CON_DTE1_Msk = 0x800
	// Bit DTE1.
	MCPWM_CON_DTE1 = 0x800
	// Dead-time disabled.
	MCPWM_CON_DTE1_DEAD_TIME_DISABLED_ = 0x0
	// Dead-time enabled.
	MCPWM_CON_DTE1_DEAD_TIME_ENABLED_ = 0x1
	// Position of DISUP1 field.
	MCPWM_CON_DISUP1_Pos = 0xc
	// Bit mask of DISUP1 field.
	MCPWM_CON_DISUP1_Msk = 0x1000
	// Bit DISUP1.
	MCPWM_CON_DISUP1 = 0x1000
	// Functional registers are updated from the write registers at the end of each PWM cycle.
	MCPWM_CON_DISUP1_UPDATE = 0x0
	// Functional registers remain the same as long as the timer is running.
	MCPWM_CON_DISUP1_NOUPDATE = 0x1
	// Position of RESERVED field.
	MCPWM_CON_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	MCPWM_CON_RESERVED_Msk = 0xe000
	// Position of RUN2 field.
	MCPWM_CON_RUN2_Pos = 0x10
	// Bit mask of RUN2 field.
	MCPWM_CON_RUN2_Msk = 0x10000
	// Bit RUN2.
	MCPWM_CON_RUN2 = 0x10000
	// Stop.
	MCPWM_CON_RUN2_STOP_ = 0x0
	// Run.
	MCPWM_CON_RUN2_RUN_ = 0x1
	// Position of CENTER2 field.
	MCPWM_CON_CENTER2_Pos = 0x11
	// Bit mask of CENTER2 field.
	MCPWM_CON_CENTER2_Msk = 0x20000
	// Bit CENTER2.
	MCPWM_CON_CENTER2 = 0x20000
	// Edge-aligned.
	MCPWM_CON_CENTER2_EDGE_ALIGNED_ = 0x0
	// Center-aligned.
	MCPWM_CON_CENTER2_CENTER_ALIGNED_ = 0x1
	// Position of POLA2 field.
	MCPWM_CON_POLA2_Pos = 0x12
	// Bit mask of POLA2 field.
	MCPWM_CON_POLA2_Msk = 0x40000
	// Bit POLA2.
	MCPWM_CON_POLA2 = 0x40000
	// Passive state is LOW, active state is HIGH.
	MCPWM_CON_POLA2_PASSIVE_STATE_IS_LOW = 0x0
	// Passive state is HIGH, active state is LOW.
	MCPWM_CON_POLA2_PASSIVE_STATE_IS_HIG = 0x1
	// Position of DTE2 field.
	MCPWM_CON_DTE2_Pos = 0x13
	// Bit mask of DTE2 field.
	MCPWM_CON_DTE2_Msk = 0x80000
	// Bit DTE2.
	MCPWM_CON_DTE2 = 0x80000
	// Dead-time disabled.
	MCPWM_CON_DTE2_DEAD_TIME_DISABLED_ = 0x0
	// Dead-time enabled.
	MCPWM_CON_DTE2_DEAD_TIME_ENABLED_ = 0x1
	// Position of DISUP2 field.
	MCPWM_CON_DISUP2_Pos = 0x14
	// Bit mask of DISUP2 field.
	MCPWM_CON_DISUP2_Msk = 0x100000
	// Bit DISUP2.
	MCPWM_CON_DISUP2 = 0x100000
	// Functional registers are updated from the write registers at the end of each PWM cycle.
	MCPWM_CON_DISUP2_UPDATE = 0x0
	// Functional registers remain the same as long as the timer is running.
	MCPWM_CON_DISUP2_NOUPDATE = 0x1
	// Position of RESERVED field.
	MCPWM_CON_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	MCPWM_CON_RESERVED_Msk = 0x1fe00000
	// Position of INVBDC field.
	MCPWM_CON_INVBDC_Pos = 0x1d
	// Bit mask of INVBDC field.
	MCPWM_CON_INVBDC_Msk = 0x20000000
	// Bit INVBDC.
	MCPWM_CON_INVBDC = 0x20000000
	// The MCOB outputs have opposite polarity from the MCOA outputs (aside from dead time).
	MCPWM_CON_INVBDC_OPPOSITE = 0x0
	// The MCOB outputs have the same basic polarity as the MCOA outputs. (see Section 24.8.6)
	MCPWM_CON_INVBDC_SAME = 0x1
	// Position of ACMODE field.
	MCPWM_CON_ACMODE_Pos = 0x1e
	// Bit mask of ACMODE field.
	MCPWM_CON_ACMODE_Msk = 0x40000000
	// Bit ACMODE.
	MCPWM_CON_ACMODE = 0x40000000
	// 3-phase AC-mode off: Each PWM channel uses its own timer-counter and period register.
	MCPWM_CON_ACMODE_3_PHASE_AC_MODE_OFF = 0x0
	// 3-phase AC-mode on: All PWM channels use the timer-counter and period register of channel 0.
	MCPWM_CON_ACMODE_3_PHASE_AC_MODE_ON_ = 0x1
	// Position of DCMODE field.
	MCPWM_CON_DCMODE_Pos = 0x1f
	// Bit mask of DCMODE field.
	MCPWM_CON_DCMODE_Msk = 0x80000000
	// Bit DCMODE.
	MCPWM_CON_DCMODE = 0x80000000
	// 3-phase DC mode off: PWM channels are independent (unless bit ACMODE = 1)
	MCPWM_CON_DCMODE_3_PHASE_DC_MODE_OFF = 0x0
	// 3-phase DC mode on: The internal MCOA0 output is routed through the CP register (i.e. a mask) register to all six PWM outputs.
	MCPWM_CON_DCMODE_3_PHASE_DC_MODE_ON_ = 0x1

	// CON_SET: PWM Control set address
	// Position of RUN0_SET field.
	MCPWM_CON_SET_RUN0_SET_Pos = 0x0
	// Bit mask of RUN0_SET field.
	MCPWM_CON_SET_RUN0_SET_Msk = 0x1
	// Bit RUN0_SET.
	MCPWM_CON_SET_RUN0_SET = 0x1
	// Position of CENTER0_SET field.
	MCPWM_CON_SET_CENTER0_SET_Pos = 0x1
	// Bit mask of CENTER0_SET field.
	MCPWM_CON_SET_CENTER0_SET_Msk = 0x2
	// Bit CENTER0_SET.
	MCPWM_CON_SET_CENTER0_SET = 0x2
	// Position of POLA0_SET field.
	MCPWM_CON_SET_POLA0_SET_Pos = 0x2
	// Bit mask of POLA0_SET field.
	MCPWM_CON_SET_POLA0_SET_Msk = 0x4
	// Bit POLA0_SET.
	MCPWM_CON_SET_POLA0_SET = 0x4
	// Position of DTE0_SET field.
	MCPWM_CON_SET_DTE0_SET_Pos = 0x3
	// Bit mask of DTE0_SET field.
	MCPWM_CON_SET_DTE0_SET_Msk = 0x8
	// Bit DTE0_SET.
	MCPWM_CON_SET_DTE0_SET = 0x8
	// Position of DISUP0_SET field.
	MCPWM_CON_SET_DISUP0_SET_Pos = 0x4
	// Bit mask of DISUP0_SET field.
	MCPWM_CON_SET_DISUP0_SET_Msk = 0x10
	// Bit DISUP0_SET.
	MCPWM_CON_SET_DISUP0_SET = 0x10
	// Position of RESERVED field.
	MCPWM_CON_SET_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	MCPWM_CON_SET_RESERVED_Msk = 0xe0
	// Position of RUN1_SET field.
	MCPWM_CON_SET_RUN1_SET_Pos = 0x8
	// Bit mask of RUN1_SET field.
	MCPWM_CON_SET_RUN1_SET_Msk = 0x100
	// Bit RUN1_SET.
	MCPWM_CON_SET_RUN1_SET = 0x100
	// Position of CENTER1_SET field.
	MCPWM_CON_SET_CENTER1_SET_Pos = 0x9
	// Bit mask of CENTER1_SET field.
	MCPWM_CON_SET_CENTER1_SET_Msk = 0x200
	// Bit CENTER1_SET.
	MCPWM_CON_SET_CENTER1_SET = 0x200
	// Position of POLA1_SET field.
	MCPWM_CON_SET_POLA1_SET_Pos = 0xa
	// Bit mask of POLA1_SET field.
	MCPWM_CON_SET_POLA1_SET_Msk = 0x400
	// Bit POLA1_SET.
	MCPWM_CON_SET_POLA1_SET = 0x400
	// Position of DTE1_SET field.
	MCPWM_CON_SET_DTE1_SET_Pos = 0xb
	// Bit mask of DTE1_SET field.
	MCPWM_CON_SET_DTE1_SET_Msk = 0x800
	// Bit DTE1_SET.
	MCPWM_CON_SET_DTE1_SET = 0x800
	// Position of DISUP1_SET field.
	MCPWM_CON_SET_DISUP1_SET_Pos = 0xc
	// Bit mask of DISUP1_SET field.
	MCPWM_CON_SET_DISUP1_SET_Msk = 0x1000
	// Bit DISUP1_SET.
	MCPWM_CON_SET_DISUP1_SET = 0x1000
	// Position of RESERVED field.
	MCPWM_CON_SET_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	MCPWM_CON_SET_RESERVED_Msk = 0xe000
	// Position of RUN2_SET field.
	MCPWM_CON_SET_RUN2_SET_Pos = 0x10
	// Bit mask of RUN2_SET field.
	MCPWM_CON_SET_RUN2_SET_Msk = 0x10000
	// Bit RUN2_SET.
	MCPWM_CON_SET_RUN2_SET = 0x10000
	// Position of CENTER2_SET field.
	MCPWM_CON_SET_CENTER2_SET_Pos = 0x11
	// Bit mask of CENTER2_SET field.
	MCPWM_CON_SET_CENTER2_SET_Msk = 0x20000
	// Bit CENTER2_SET.
	MCPWM_CON_SET_CENTER2_SET = 0x20000
	// Position of POLA2_SET field.
	MCPWM_CON_SET_POLA2_SET_Pos = 0x12
	// Bit mask of POLA2_SET field.
	MCPWM_CON_SET_POLA2_SET_Msk = 0x40000
	// Bit POLA2_SET.
	MCPWM_CON_SET_POLA2_SET = 0x40000
	// Position of DTE2_SET field.
	MCPWM_CON_SET_DTE2_SET_Pos = 0x13
	// Bit mask of DTE2_SET field.
	MCPWM_CON_SET_DTE2_SET_Msk = 0x80000
	// Bit DTE2_SET.
	MCPWM_CON_SET_DTE2_SET = 0x80000
	// Position of DISUP2_SET field.
	MCPWM_CON_SET_DISUP2_SET_Pos = 0x14
	// Bit mask of DISUP2_SET field.
	MCPWM_CON_SET_DISUP2_SET_Msk = 0x100000
	// Bit DISUP2_SET.
	MCPWM_CON_SET_DISUP2_SET = 0x100000
	// Position of RESERVED field.
	MCPWM_CON_SET_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	MCPWM_CON_SET_RESERVED_Msk = 0x1fe00000
	// Position of INVBDC_SET field.
	MCPWM_CON_SET_INVBDC_SET_Pos = 0x1d
	// Bit mask of INVBDC_SET field.
	MCPWM_CON_SET_INVBDC_SET_Msk = 0x20000000
	// Bit INVBDC_SET.
	MCPWM_CON_SET_INVBDC_SET = 0x20000000
	// Position of ACMODE_SET field.
	MCPWM_CON_SET_ACMODE_SET_Pos = 0x1e
	// Bit mask of ACMODE_SET field.
	MCPWM_CON_SET_ACMODE_SET_Msk = 0x40000000
	// Bit ACMODE_SET.
	MCPWM_CON_SET_ACMODE_SET = 0x40000000
	// Position of DCMODE_SET field.
	MCPWM_CON_SET_DCMODE_SET_Pos = 0x1f
	// Bit mask of DCMODE_SET field.
	MCPWM_CON_SET_DCMODE_SET_Msk = 0x80000000
	// Bit DCMODE_SET.
	MCPWM_CON_SET_DCMODE_SET = 0x80000000

	// CON_CLR: PWM Control clear address
	// Position of RUN0_CLR field.
	MCPWM_CON_CLR_RUN0_CLR_Pos = 0x0
	// Bit mask of RUN0_CLR field.
	MCPWM_CON_CLR_RUN0_CLR_Msk = 0x1
	// Bit RUN0_CLR.
	MCPWM_CON_CLR_RUN0_CLR = 0x1
	// Position of CENTER0_CLR field.
	MCPWM_CON_CLR_CENTER0_CLR_Pos = 0x1
	// Bit mask of CENTER0_CLR field.
	MCPWM_CON_CLR_CENTER0_CLR_Msk = 0x2
	// Bit CENTER0_CLR.
	MCPWM_CON_CLR_CENTER0_CLR = 0x2
	// Position of POLA0_CLR field.
	MCPWM_CON_CLR_POLA0_CLR_Pos = 0x2
	// Bit mask of POLA0_CLR field.
	MCPWM_CON_CLR_POLA0_CLR_Msk = 0x4
	// Bit POLA0_CLR.
	MCPWM_CON_CLR_POLA0_CLR = 0x4
	// Position of DTE0_CLR field.
	MCPWM_CON_CLR_DTE0_CLR_Pos = 0x3
	// Bit mask of DTE0_CLR field.
	MCPWM_CON_CLR_DTE0_CLR_Msk = 0x8
	// Bit DTE0_CLR.
	MCPWM_CON_CLR_DTE0_CLR = 0x8
	// Position of DISUP0_CLR field.
	MCPWM_CON_CLR_DISUP0_CLR_Pos = 0x4
	// Bit mask of DISUP0_CLR field.
	MCPWM_CON_CLR_DISUP0_CLR_Msk = 0x10
	// Bit DISUP0_CLR.
	MCPWM_CON_CLR_DISUP0_CLR = 0x10
	// Position of RESERVED field.
	MCPWM_CON_CLR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	MCPWM_CON_CLR_RESERVED_Msk = 0xe0
	// Position of RUN1_CLR field.
	MCPWM_CON_CLR_RUN1_CLR_Pos = 0x8
	// Bit mask of RUN1_CLR field.
	MCPWM_CON_CLR_RUN1_CLR_Msk = 0x100
	// Bit RUN1_CLR.
	MCPWM_CON_CLR_RUN1_CLR = 0x100
	// Position of CENTER1_CLR field.
	MCPWM_CON_CLR_CENTER1_CLR_Pos = 0x9
	// Bit mask of CENTER1_CLR field.
	MCPWM_CON_CLR_CENTER1_CLR_Msk = 0x200
	// Bit CENTER1_CLR.
	MCPWM_CON_CLR_CENTER1_CLR = 0x200
	// Position of POLA1_CLR field.
	MCPWM_CON_CLR_POLA1_CLR_Pos = 0xa
	// Bit mask of POLA1_CLR field.
	MCPWM_CON_CLR_POLA1_CLR_Msk = 0x400
	// Bit POLA1_CLR.
	MCPWM_CON_CLR_POLA1_CLR = 0x400
	// Position of DTE1_CLR field.
	MCPWM_CON_CLR_DTE1_CLR_Pos = 0xb
	// Bit mask of DTE1_CLR field.
	MCPWM_CON_CLR_DTE1_CLR_Msk = 0x800
	// Bit DTE1_CLR.
	MCPWM_CON_CLR_DTE1_CLR = 0x800
	// Position of DISUP1_CLR field.
	MCPWM_CON_CLR_DISUP1_CLR_Pos = 0xc
	// Bit mask of DISUP1_CLR field.
	MCPWM_CON_CLR_DISUP1_CLR_Msk = 0x1000
	// Bit DISUP1_CLR.
	MCPWM_CON_CLR_DISUP1_CLR = 0x1000
	// Position of RESERVED field.
	MCPWM_CON_CLR_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	MCPWM_CON_CLR_RESERVED_Msk = 0xe000
	// Position of RUN2_CLR field.
	MCPWM_CON_CLR_RUN2_CLR_Pos = 0x10
	// Bit mask of RUN2_CLR field.
	MCPWM_CON_CLR_RUN2_CLR_Msk = 0x10000
	// Bit RUN2_CLR.
	MCPWM_CON_CLR_RUN2_CLR = 0x10000
	// Position of CENTER2_CLR field.
	MCPWM_CON_CLR_CENTER2_CLR_Pos = 0x11
	// Bit mask of CENTER2_CLR field.
	MCPWM_CON_CLR_CENTER2_CLR_Msk = 0x20000
	// Bit CENTER2_CLR.
	MCPWM_CON_CLR_CENTER2_CLR = 0x20000
	// Position of POLA2_CLR field.
	MCPWM_CON_CLR_POLA2_CLR_Pos = 0x12
	// Bit mask of POLA2_CLR field.
	MCPWM_CON_CLR_POLA2_CLR_Msk = 0x40000
	// Bit POLA2_CLR.
	MCPWM_CON_CLR_POLA2_CLR = 0x40000
	// Position of DTE2_CLR field.
	MCPWM_CON_CLR_DTE2_CLR_Pos = 0x13
	// Bit mask of DTE2_CLR field.
	MCPWM_CON_CLR_DTE2_CLR_Msk = 0x80000
	// Bit DTE2_CLR.
	MCPWM_CON_CLR_DTE2_CLR = 0x80000
	// Position of DISUP2_CLR field.
	MCPWM_CON_CLR_DISUP2_CLR_Pos = 0x14
	// Bit mask of DISUP2_CLR field.
	MCPWM_CON_CLR_DISUP2_CLR_Msk = 0x100000
	// Bit DISUP2_CLR.
	MCPWM_CON_CLR_DISUP2_CLR = 0x100000
	// Position of RESERVED field.
	MCPWM_CON_CLR_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	MCPWM_CON_CLR_RESERVED_Msk = 0x1fe00000
	// Position of INVBDC_CLR field.
	MCPWM_CON_CLR_INVBDC_CLR_Pos = 0x1d
	// Bit mask of INVBDC_CLR field.
	MCPWM_CON_CLR_INVBDC_CLR_Msk = 0x20000000
	// Bit INVBDC_CLR.
	MCPWM_CON_CLR_INVBDC_CLR = 0x20000000
	// Position of ACMOD_CLR field.
	MCPWM_CON_CLR_ACMOD_CLR_Pos = 0x1e
	// Bit mask of ACMOD_CLR field.
	MCPWM_CON_CLR_ACMOD_CLR_Msk = 0x40000000
	// Bit ACMOD_CLR.
	MCPWM_CON_CLR_ACMOD_CLR = 0x40000000
	// Position of DCMODE_CLR field.
	MCPWM_CON_CLR_DCMODE_CLR_Pos = 0x1f
	// Bit mask of DCMODE_CLR field.
	MCPWM_CON_CLR_DCMODE_CLR_Msk = 0x80000000
	// Bit DCMODE_CLR.
	MCPWM_CON_CLR_DCMODE_CLR = 0x80000000

	// CAPCON: Capture Control read address
	// Position of CAP0MCI0_RE field.
	MCPWM_CAPCON_CAP0MCI0_RE_Pos = 0x0
	// Bit mask of CAP0MCI0_RE field.
	MCPWM_CAPCON_CAP0MCI0_RE_Msk = 0x1
	// Bit CAP0MCI0_RE.
	MCPWM_CAPCON_CAP0MCI0_RE = 0x1
	// Position of CAP0MCI0_FE field.
	MCPWM_CAPCON_CAP0MCI0_FE_Pos = 0x1
	// Bit mask of CAP0MCI0_FE field.
	MCPWM_CAPCON_CAP0MCI0_FE_Msk = 0x2
	// Bit CAP0MCI0_FE.
	MCPWM_CAPCON_CAP0MCI0_FE = 0x2
	// Position of CAP0MCI1_RE field.
	MCPWM_CAPCON_CAP0MCI1_RE_Pos = 0x2
	// Bit mask of CAP0MCI1_RE field.
	MCPWM_CAPCON_CAP0MCI1_RE_Msk = 0x4
	// Bit CAP0MCI1_RE.
	MCPWM_CAPCON_CAP0MCI1_RE = 0x4
	// Position of CAP0MCI1_FE field.
	MCPWM_CAPCON_CAP0MCI1_FE_Pos = 0x3
	// Bit mask of CAP0MCI1_FE field.
	MCPWM_CAPCON_CAP0MCI1_FE_Msk = 0x8
	// Bit CAP0MCI1_FE.
	MCPWM_CAPCON_CAP0MCI1_FE = 0x8
	// Position of CAP0MCI2_RE field.
	MCPWM_CAPCON_CAP0MCI2_RE_Pos = 0x4
	// Bit mask of CAP0MCI2_RE field.
	MCPWM_CAPCON_CAP0MCI2_RE_Msk = 0x10
	// Bit CAP0MCI2_RE.
	MCPWM_CAPCON_CAP0MCI2_RE = 0x10
	// Position of CAP0MCI2_FE field.
	MCPWM_CAPCON_CAP0MCI2_FE_Pos = 0x5
	// Bit mask of CAP0MCI2_FE field.
	MCPWM_CAPCON_CAP0MCI2_FE_Msk = 0x20
	// Bit CAP0MCI2_FE.
	MCPWM_CAPCON_CAP0MCI2_FE = 0x20
	// Position of CAP1MCI0_RE field.
	MCPWM_CAPCON_CAP1MCI0_RE_Pos = 0x6
	// Bit mask of CAP1MCI0_RE field.
	MCPWM_CAPCON_CAP1MCI0_RE_Msk = 0x40
	// Bit CAP1MCI0_RE.
	MCPWM_CAPCON_CAP1MCI0_RE = 0x40
	// Position of CAP1MCI0_FE field.
	MCPWM_CAPCON_CAP1MCI0_FE_Pos = 0x7
	// Bit mask of CAP1MCI0_FE field.
	MCPWM_CAPCON_CAP1MCI0_FE_Msk = 0x80
	// Bit CAP1MCI0_FE.
	MCPWM_CAPCON_CAP1MCI0_FE = 0x80
	// Position of CAP1MCI1_RE field.
	MCPWM_CAPCON_CAP1MCI1_RE_Pos = 0x8
	// Bit mask of CAP1MCI1_RE field.
	MCPWM_CAPCON_CAP1MCI1_RE_Msk = 0x100
	// Bit CAP1MCI1_RE.
	MCPWM_CAPCON_CAP1MCI1_RE = 0x100
	// Position of CAP1MCI1_FE field.
	MCPWM_CAPCON_CAP1MCI1_FE_Pos = 0x9
	// Bit mask of CAP1MCI1_FE field.
	MCPWM_CAPCON_CAP1MCI1_FE_Msk = 0x200
	// Bit CAP1MCI1_FE.
	MCPWM_CAPCON_CAP1MCI1_FE = 0x200
	// Position of CAP1MCI2_RE field.
	MCPWM_CAPCON_CAP1MCI2_RE_Pos = 0xa
	// Bit mask of CAP1MCI2_RE field.
	MCPWM_CAPCON_CAP1MCI2_RE_Msk = 0x400
	// Bit CAP1MCI2_RE.
	MCPWM_CAPCON_CAP1MCI2_RE = 0x400
	// Position of CAP1MCI2_FE field.
	MCPWM_CAPCON_CAP1MCI2_FE_Pos = 0xb
	// Bit mask of CAP1MCI2_FE field.
	MCPWM_CAPCON_CAP1MCI2_FE_Msk = 0x800
	// Bit CAP1MCI2_FE.
	MCPWM_CAPCON_CAP1MCI2_FE = 0x800
	// Position of CAP2MCI0_RE field.
	MCPWM_CAPCON_CAP2MCI0_RE_Pos = 0xc
	// Bit mask of CAP2MCI0_RE field.
	MCPWM_CAPCON_CAP2MCI0_RE_Msk = 0x1000
	// Bit CAP2MCI0_RE.
	MCPWM_CAPCON_CAP2MCI0_RE = 0x1000
	// Position of CAP2MCI0_FE field.
	MCPWM_CAPCON_CAP2MCI0_FE_Pos = 0xd
	// Bit mask of CAP2MCI0_FE field.
	MCPWM_CAPCON_CAP2MCI0_FE_Msk = 0x2000
	// Bit CAP2MCI0_FE.
	MCPWM_CAPCON_CAP2MCI0_FE = 0x2000
	// Position of CAP2MCI1_RE field.
	MCPWM_CAPCON_CAP2MCI1_RE_Pos = 0xe
	// Bit mask of CAP2MCI1_RE field.
	MCPWM_CAPCON_CAP2MCI1_RE_Msk = 0x4000
	// Bit CAP2MCI1_RE.
	MCPWM_CAPCON_CAP2MCI1_RE = 0x4000
	// Position of CAP2MCI1_FE field.
	MCPWM_CAPCON_CAP2MCI1_FE_Pos = 0xf
	// Bit mask of CAP2MCI1_FE field.
	MCPWM_CAPCON_CAP2MCI1_FE_Msk = 0x8000
	// Bit CAP2MCI1_FE.
	MCPWM_CAPCON_CAP2MCI1_FE = 0x8000
	// Position of CAP2MCI2_RE field.
	MCPWM_CAPCON_CAP2MCI2_RE_Pos = 0x10
	// Bit mask of CAP2MCI2_RE field.
	MCPWM_CAPCON_CAP2MCI2_RE_Msk = 0x10000
	// Bit CAP2MCI2_RE.
	MCPWM_CAPCON_CAP2MCI2_RE = 0x10000
	// Position of CAP2MCI2_FE field.
	MCPWM_CAPCON_CAP2MCI2_FE_Pos = 0x11
	// Bit mask of CAP2MCI2_FE field.
	MCPWM_CAPCON_CAP2MCI2_FE_Msk = 0x20000
	// Bit CAP2MCI2_FE.
	MCPWM_CAPCON_CAP2MCI2_FE = 0x20000
	// Position of RT0 field.
	MCPWM_CAPCON_RT0_Pos = 0x12
	// Bit mask of RT0 field.
	MCPWM_CAPCON_RT0_Msk = 0x40000
	// Bit RT0.
	MCPWM_CAPCON_RT0 = 0x40000
	// Position of RT1 field.
	MCPWM_CAPCON_RT1_Pos = 0x13
	// Bit mask of RT1 field.
	MCPWM_CAPCON_RT1_Msk = 0x80000
	// Bit RT1.
	MCPWM_CAPCON_RT1 = 0x80000
	// Position of RT2 field.
	MCPWM_CAPCON_RT2_Pos = 0x14
	// Bit mask of RT2 field.
	MCPWM_CAPCON_RT2_Msk = 0x100000
	// Bit RT2.
	MCPWM_CAPCON_RT2 = 0x100000
	// Position of RESERVED field.
	MCPWM_CAPCON_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	MCPWM_CAPCON_RESERVED_Msk = 0xffe00000

	// CAPCON_SET: Capture Control set address
	// Position of CAP0MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI0_RE_SET_Pos = 0x0
	// Bit mask of CAP0MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI0_RE_SET_Msk = 0x1
	// Bit CAP0MCI0_RE_SET.
	MCPWM_CAPCON_SET_CAP0MCI0_RE_SET = 0x1
	// Position of CAP0MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI0_FE_SET_Pos = 0x1
	// Bit mask of CAP0MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI0_FE_SET_Msk = 0x2
	// Bit CAP0MCI0_FE_SET.
	MCPWM_CAPCON_SET_CAP0MCI0_FE_SET = 0x2
	// Position of CAP0MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI1_RE_SET_Pos = 0x2
	// Bit mask of CAP0MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI1_RE_SET_Msk = 0x4
	// Bit CAP0MCI1_RE_SET.
	MCPWM_CAPCON_SET_CAP0MCI1_RE_SET = 0x4
	// Position of CAP0MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI1_FE_SET_Pos = 0x3
	// Bit mask of CAP0MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI1_FE_SET_Msk = 0x8
	// Bit CAP0MCI1_FE_SET.
	MCPWM_CAPCON_SET_CAP0MCI1_FE_SET = 0x8
	// Position of CAP0MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI2_RE_SET_Pos = 0x4
	// Bit mask of CAP0MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI2_RE_SET_Msk = 0x10
	// Bit CAP0MCI2_RE_SET.
	MCPWM_CAPCON_SET_CAP0MCI2_RE_SET = 0x10
	// Position of CAP0MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI2_FE_SET_Pos = 0x5
	// Bit mask of CAP0MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI2_FE_SET_Msk = 0x20
	// Bit CAP0MCI2_FE_SET.
	MCPWM_CAPCON_SET_CAP0MCI2_FE_SET = 0x20
	// Position of CAP1MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI0_RE_SET_Pos = 0x6
	// Bit mask of CAP1MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI0_RE_SET_Msk = 0x40
	// Bit CAP1MCI0_RE_SET.
	MCPWM_CAPCON_SET_CAP1MCI0_RE_SET = 0x40
	// Position of CAP1MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI0_FE_SET_Pos = 0x7
	// Bit mask of CAP1MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI0_FE_SET_Msk = 0x80
	// Bit CAP1MCI0_FE_SET.
	MCPWM_CAPCON_SET_CAP1MCI0_FE_SET = 0x80
	// Position of CAP1MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI1_RE_SET_Pos = 0x8
	// Bit mask of CAP1MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI1_RE_SET_Msk = 0x100
	// Bit CAP1MCI1_RE_SET.
	MCPWM_CAPCON_SET_CAP1MCI1_RE_SET = 0x100
	// Position of CAP1MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI1_FE_SET_Pos = 0x9
	// Bit mask of CAP1MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI1_FE_SET_Msk = 0x200
	// Bit CAP1MCI1_FE_SET.
	MCPWM_CAPCON_SET_CAP1MCI1_FE_SET = 0x200
	// Position of CAP1MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI2_RE_SET_Pos = 0xa
	// Bit mask of CAP1MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI2_RE_SET_Msk = 0x400
	// Bit CAP1MCI2_RE_SET.
	MCPWM_CAPCON_SET_CAP1MCI2_RE_SET = 0x400
	// Position of CAP1MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI2_FE_SET_Pos = 0xb
	// Bit mask of CAP1MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI2_FE_SET_Msk = 0x800
	// Bit CAP1MCI2_FE_SET.
	MCPWM_CAPCON_SET_CAP1MCI2_FE_SET = 0x800
	// Position of CAP2MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI0_RE_SET_Pos = 0xc
	// Bit mask of CAP2MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI0_RE_SET_Msk = 0x1000
	// Bit CAP2MCI0_RE_SET.
	MCPWM_CAPCON_SET_CAP2MCI0_RE_SET = 0x1000
	// Position of CAP2MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI0_FE_SET_Pos = 0xd
	// Bit mask of CAP2MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI0_FE_SET_Msk = 0x2000
	// Bit CAP2MCI0_FE_SET.
	MCPWM_CAPCON_SET_CAP2MCI0_FE_SET = 0x2000
	// Position of CAP2MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI1_RE_SET_Pos = 0xe
	// Bit mask of CAP2MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI1_RE_SET_Msk = 0x4000
	// Bit CAP2MCI1_RE_SET.
	MCPWM_CAPCON_SET_CAP2MCI1_RE_SET = 0x4000
	// Position of CAP2MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI1_FE_SET_Pos = 0xf
	// Bit mask of CAP2MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI1_FE_SET_Msk = 0x8000
	// Bit CAP2MCI1_FE_SET.
	MCPWM_CAPCON_SET_CAP2MCI1_FE_SET = 0x8000
	// Position of CAP2MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI2_RE_SET_Pos = 0x10
	// Bit mask of CAP2MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI2_RE_SET_Msk = 0x10000
	// Bit CAP2MCI2_RE_SET.
	MCPWM_CAPCON_SET_CAP2MCI2_RE_SET = 0x10000
	// Position of CAP2MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI2_FE_SET_Pos = 0x11
	// Bit mask of CAP2MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI2_FE_SET_Msk = 0x20000
	// Bit CAP2MCI2_FE_SET.
	MCPWM_CAPCO