// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAM3S8B.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,atsam3s8b

// Atmel ATSAM3S8B Microcontroller
//

package sam

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATSAM3S8B"
)

// Interrupt numbers.
const (
	// Power Management Controller
	IRQ_PMC = 5

	// Embedded Flash Controller
	IRQ_EFC = 6

	// Universal Asynchronous Receiver Transmitter 0
	IRQ_UART0 = 8

	// Universal Asynchronous Receiver Transmitter 1
	IRQ_UART1 = 9

	// Parallel Input/Output Controller A
	IRQ_PIOA = 11

	// Parallel Input/Output Controller B
	IRQ_PIOB = 12

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 14

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 15

	// High Speed MultiMedia Card Interface
	IRQ_HSMCI = 18

	// Two-wire Interface 0
	IRQ_TWI0 = 19

	// Two-wire Interface 1
	IRQ_TWI1 = 20

	// Serial Peripheral Interface
	IRQ_SPI = 21

	// Synchronous Serial Controller
	IRQ_SSC = 22

	// Timer Counter 0
	IRQ_TC0 = 23

	// Timer Counter 0
	IRQ_TC1 = 24

	// Timer Counter 0
	IRQ_TC2 = 25

	// Analog-to-Digital Converter
	IRQ_ADC = 29

	// Digital-to-Analog Converter Controller
	IRQ_DACC = 30

	// Pulse Width Modulation Controller
	IRQ_PWM = 31

	// Cyclic Redundancy Check Calculation Unit
	IRQ_CRCCU = 32

	// Analog Comparator Controller
	IRQ_ACC = 33

	// USB Device Port
	IRQ_UDP = 34

	// Highest interrupt number on this device.
	IRQ_max = 34
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_PMC, "PMC_IRQHandler")
	_ = interrupt.Register(IRQ_EFC, "EFC_IRQHandler")
	_ = interrupt.Register(IRQ_UART0, "UART0_IRQHandler")
	_ = interrupt.Register(IRQ_UART1, "UART1_IRQHandler")
	_ = interrupt.Register(IRQ_PIOA, "PIOA_IRQHandler")
	_ = interrupt.Register(IRQ_PIOB, "PIOB_IRQHandler")
	_ = interrupt.Register(IRQ_USART0, "USART0_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_HSMCI, "HSMCI_IRQHandler")
	_ = interrupt.Register(IRQ_TWI0, "TWI0_IRQHandler")
	_ = interrupt.Register(IRQ_TWI1, "TWI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI, "SPI_IRQHandler")
	_ = interrupt.Register(IRQ_SSC, "SSC_IRQHandler")
	_ = interrupt.Register(IRQ_TC0, "TC0_IRQHandler")
	_ = interrupt.Register(IRQ_TC1, "TC1_IRQHandler")
	_ = interrupt.Register(IRQ_TC2, "TC2_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_DACC, "DACC_IRQHandler")
	_ = interrupt.Register(IRQ_PWM, "PWM_IRQHandler")
	_ = interrupt.Register(IRQ_CRCCU, "CRCCU_IRQHandler")
	_ = interrupt.Register(IRQ_ACC, "ACC_IRQHandler")
	_ = interrupt.Register(IRQ_UDP, "UDP_IRQHandler")
)

// Peripherals.
var (
	// High Speed MultiMedia Card Interface
	HSMCI = (*HSMCI_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial Peripheral Interface
	SPI = (*SPI_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// USB Device Port
	UDP = (*UDP_Type)(unsafe.Pointer(uintptr(0x40034000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Digital-to-Analog Converter Controller
	DACC = (*DACC_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// Analog Comparator Controller
	ACC = (*ACC_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// Cyclic Redundancy Check Calculation Unit
	CRCCU = (*CRCCU_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x400e0200)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0400)))

	// Universal Asynchronous Receiver Transmitter 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0600)))

	// Chip Identifier
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0740)))

	// Universal Asynchronous Receiver Transmitter 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0800)))

	// Embedded Flash Controller
	EFC = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0a00)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1000)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1400)))

	// Supply Controller
	SUPC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1410)))

	// Real-time Timer
	RTT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1430)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1450)))

	// Real-time Clock
	RTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1460)))

	// General Purpose Backup Register
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1490)))
)

// High Speed MultiMedia Card Interface
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	_     [4]byte
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [20]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	TPR   volatile.Register32 // 0x108
	TCR   volatile.Register32 // 0x10C
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	TNPR  volatile.Register32 // 0x118
	TNCR  volatile.Register32 // 0x11C
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
	_     [216]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Serial Peripheral Interface
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Timer Counter 0
type TC_Type struct {
	CCR0  volatile.Register32 // 0x0
	CMR0  volatile.Register32 // 0x4
	SMMR0 volatile.Register32 // 0x8
	_     [4]byte
	CV0   volatile.Register32 // 0x10
	RA0   volatile.Register32 // 0x14
	RB0   volatile.Register32 // 0x18
	RC0   volatile.Register32 // 0x1C
	SR0   volatile.Register32 // 0x20
	IER0  volatile.Register32 // 0x24
	IDR0  volatile.Register32 // 0x28
	IMR0  volatile.Register32 // 0x2C
	_     [16]byte
	CCR1  volatile.Register32 // 0x40
	CMR1  volatile.Register32 // 0x44
	SMMR1 volatile.Register32 // 0x48
	_     [4]byte
	CV1   volatile.Register32 // 0x50
	RA1   volatile.Register32 // 0x54
	RB1   volatile.Register32 // 0x58
	RC1   volatile.Register32 // 0x5C
	SR1   volatile.Register32 // 0x60
	IER1  volatile.Register32 // 0x64
	IDR1  volatile.Register32 // 0x68
	IMR1  volatile.Register32 // 0x6C
	_     [16]byte
	CCR2  volatile.Register32 // 0x80
	CMR2  volatile.Register32 // 0x84
	SMMR2 volatile.Register32 // 0x88
	_     [4]byte
	CV2   volatile.Register32 // 0x90
	RA2   volatile.Register32 // 0x94
	RB2   volatile.Register32 // 0x98
	RC2   volatile.Register32 // 0x9C
	SR2   volatile.Register32 // 0xA0
	IER2  volatile.Register32 // 0xA4
	IDR2  volatile.Register32 // 0xA8
	IMR2  volatile.Register32 // 0xAC
	_     [16]byte
	BCR   volatile.Register32 // 0xC0
	BMR   volatile.Register32 // 0xC4
	QIER  volatile.Register32 // 0xC8
	QIDR  volatile.Register32 // 0xCC
	QIMR  volatile.Register32 // 0xD0
	QISR  volatile.Register32 // 0xD4
	FMR   volatile.Register32 // 0xD8
	_     [8]byte
	WPMR  volatile.Register32 // 0xE4
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
	_    [200]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	CLK      volatile.Register32 // 0x0
	ENA      volatile.Register32 // 0x4
	DIS      volatile.Register32 // 0x8
	SR       volatile.Register32 // 0xC
	IER1     volatile.Register32 // 0x10
	IDR1     volatile.Register32 // 0x14
	IMR1     volatile.Register32 // 0x18
	ISR1     volatile.Register32 // 0x1C
	SCM      volatile.Register32 // 0x20
	_        [4]byte
	SCUC     volatile.Register32 // 0x28
	SCUP     volatile.Register32 // 0x2C
	SCUPUPD  volatile.Register32 // 0x30
	IER2     volatile.Register32 // 0x34
	IDR2     volatile.Register32 // 0x38
	IMR2     volatile.Register32 // 0x3C
	ISR2     volatile.Register32 // 0x40
	OOV      volatile.Register32 // 0x44
	OS       volatile.Register32 // 0x48
	OSS      volatile.Register32 // 0x4C
	OSC      volatile.Register32 // 0x50
	OSSUPD   volatile.Register32 // 0x54
	OSCUPD   volatile.Register32 // 0x58
	FMR      volatile.Register32 // 0x5C
	FSR      volatile.Register32 // 0x60
	FCR      volatile.Register32 // 0x64
	FPV      volatile.Register32 // 0x68
	FPE      volatile.Register32 // 0x6C
	_        [12]byte
	ELMR     [2]volatile.Register32 // 0x7C
	_        [96]byte
	WPCR     volatile.Register32 // 0xE4
	WPSR     volatile.Register32 // 0xE8
	_        [28]byte
	TPR      volatile.Register32 // 0x108
	TCR      volatile.Register32 // 0x10C
	_        [8]byte
	TNPR     volatile.Register32 // 0x118
	TNCR     volatile.Register32 // 0x11C
	PTCR     volatile.Register32 // 0x120
	PTSR     volatile.Register32 // 0x124
	_        [8]byte
	CMPV0    volatile.Register32 // 0x130
	CMPVUPD0 volatile.Register32 // 0x134
	CMPM0    volatile.Register32 // 0x138
	CMPMUPD0 volatile.Register32 // 0x13C
	CMPV1    volatile.Register32 // 0x140
	CMPVUPD1 volatile.Register32 // 0x144
	CMPM1    volatile.Register32 // 0x148
	CMPMUPD1 volatile.Register32 // 0x14C
	CMPV2    volatile.Register32 // 0x150
	CMPVUPD2 volatile.Register32 // 0x154
	CMPM2    volatile.Register32 // 0x158
	CMPMUPD2 volatile.Register32 // 0x15C
	CMPV3    volatile.Register32 // 0x160
	CMPVUPD3 volatile.Register32 // 0x164
	CMPM3    volatile.Register32 // 0x168
	CMPMUPD3 volatile.Register32 // 0x16C
	CMPV4    volatile.Register32 // 0x170
	CMPVUPD4 volatile.Register32 // 0x174
	CMPM4    volatile.Register32 // 0x178
	CMPMUPD4 volatile.Register32 // 0x17C
	CMPV5    volatile.Register32 // 0x180
	CMPVUPD5 volatile.Register32 // 0x184
	CMPM5    volatile.Register32 // 0x188
	CMPMUPD5 volatile.Register32 // 0x18C
	CMPV6    volatile.Register32 // 0x190
	CMPVUPD6 volatile.Register32 // 0x194
	CMPM6    volatile.Register32 // 0x198
	CMPMUPD6 volatile.Register32 // 0x19C
	CMPV7    volatile.Register32 // 0x1A0
	CMPVUPD7 volatile.Register32 // 0x1A4
	CMPM7    volatile.Register32 // 0x1A8
	CMPMUPD7 volatile.Register32 // 0x1AC
	_        [80]byte
	CMR0     volatile.Register32 // 0x200
	CDTY0    volatile.Register32 // 0x204
	CDTYUPD0 volatile.Register32 // 0x208
	CPRD0    volatile.Register32 // 0x20C
	CPRDUPD0 volatile.Register32 // 0x210
	CCNT0    volatile.Register32 // 0x214
	DT0      volatile.Register32 // 0x218
	DTUPD0   volatile.Register32 // 0x21C
	CMR1     volatile.Register32 // 0x220
	CDTY1    volatile.Register32 // 0x224
	CDTYUPD1 volatile.Register32 // 0x228
	CPRD1    volatile.Register32 // 0x22C
	CPRDUPD1 volatile.Register32 // 0x230
	CCNT1    volatile.Register32 // 0x234
	DT1      volatile.Register32 // 0x238
	DTUPD1   volatile.Register32 // 0x23C
	CMR2     volatile.Register32 // 0x240
	CDTY2    volatile.Register32 // 0x244
	CDTYUPD2 volatile.Register32 // 0x248
	CPRD2    volatile.Register32 // 0x24C
	CPRDUPD2 volatile.Register32 // 0x250
	CCNT2    volatile.Register32 // 0x254
	DT2      volatile.Register32 // 0x258
	DTUPD2   volatile.Register32 // 0x25C
	CMR3     volatile.Register32 // 0x260
	CDTY3    volatile.Register32 // 0x264
	CDTYUPD3 volatile.Register32 // 0x268
	CPRD3    volatile.Register32 // 0x26C
	CPRDUPD3 volatile.Register32 // 0x270
	CCNT3    volatile.Register32 // 0x274
	DT3      volatile.Register32 // 0x278
	DTUPD3   volatile.Register32 // 0x27C
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR      volatile.Register32 // 0x0
	MR      volatile.Register32 // 0x4
	IER     volatile.Register32 // 0x8
	IDR     volatile.Register32 // 0xC
	IMR     volatile.Register32 // 0x10
	CSR     volatile.Register32 // 0x14
	RHR     volatile.Register32 // 0x18
	THR     volatile.Register32 // 0x1C
	BRGR    volatile.Register32 // 0x20
	RTOR    volatile.Register32 // 0x24
	TTGR    volatile.Register32 // 0x28
	_       [20]byte
	FIDI    volatile.Register32 // 0x40
	NER     volatile.Register32 // 0x44
	_       [4]byte
	IF      volatile.Register32 // 0x4C
	MAN     volatile.Register32 // 0x50
	_       [144]byte
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [16]byte
	VERSION volatile.Register32 // 0xFC
	RPR     volatile.Register32 // 0x100
	RCR     volatile.Register32 // 0x104
	TPR     volatile.Register32 // 0x108
	TCR     volatile.Register32 // 0x10C
	RNPR    volatile.Register32 // 0x110
	RNCR    volatile.Register32 // 0x114
	TNPR    volatile.Register32 // 0x118
	TNCR    volatile.Register32 // 0x11C
	PTCR    volatile.Register32 // 0x120
	PTSR    volatile.Register32 // 0x124
}

// USB Device Port
type UDP_Type struct {
	FRM_NUM  volatile.Register32 // 0x0
	GLB_STAT volatile.Register32 // 0x4
	FADDR    volatile.Register32 // 0x8
	_        [4]byte
	IER      volatile.Register32 // 0x10
	IDR      volatile.Register32 // 0x14
	IMR      volatile.Register32 // 0x18
	ISR      volatile.Register32 // 0x1C
	ICR      volatile.Register32 // 0x20
	_        [4]byte
	RST_EP   volatile.Register32 // 0x28
	_        [4]byte
	CSR      [8]volatile.Register32 // 0x30
	FDR      [8]volatile.Register32 // 0x50
	_        [4]byte
	TXVC     volatile.Register32 // 0x74
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	SEQR1 volatile.Register32 // 0x8
	SEQR2 volatile.Register32 // 0xC
	CHER  volatile.Register32 // 0x10
	CHDR  volatile.Register32 // 0x14
	CHSR  volatile.Register32 // 0x18
	_     [4]byte
	LCDR  volatile.Register32 // 0x20
	IER   volatile.Register32 // 0x24
	IDR   volatile.Register32 // 0x28
	IMR   volatile.Register32 // 0x2C
	ISR   volatile.Register32 // 0x30
	_     [8]byte
	OVER  volatile.Register32     // 0x3C
	EMR   volatile.Register32     // 0x40
	CWR   volatile.Register32     // 0x44
	CGR   volatile.Register32     // 0x48
	COR   volatile.Register32     // 0x4C
	CDR   [15]volatile.Register32 // 0x50
	_     [8]byte
	ACR   volatile.Register32 // 0x94
	_     [76]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [20]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	_     [8]byte
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	_     [8]byte
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
}

// Digital-to-Analog Converter Controller
type DACC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [8]byte
	CHER volatile.Register32 // 0x10
	CHDR volatile.Register32 // 0x14
	CHSR volatile.Register32 // 0x18
	_    [4]byte
	CDR  volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	ISR  volatile.Register32 // 0x30
	_    [96]byte
	ACR  volatile.Register32 // 0x94
	_    [76]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [28]byte
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	_    [8]byte
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Analog Comparator Controller
type ACC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [28]byte
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	ISR  volatile.Register32 // 0x30
	_    [96]byte
	ACR  volatile.Register32 // 0x94
	_    [76]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// Cyclic Redundancy Check Calculation Unit
type CRCCU_Type struct {
	DSCR    volatile.Register32 // 0x0
	_       [4]byte
	DMA_EN  volatile.Register32 // 0x8
	DMA_DIS volatile.Register32 // 0xC
	DMA_SR  volatile.Register32 // 0x10
	DMA_IER volatile.Register32 // 0x14
	DMA_IDR volatile.Register32 // 0x18
	DMA_IMR volatile.Register32 // 0x1C
	DMA_ISR volatile.Register32 // 0x20
	_       [16]byte
	CR      volatile.Register32 // 0x34
	MR      volatile.Register32 // 0x38
	SR      volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MATRIX_MCFG  [4]volatile.Register32 // 0x0
	_            [48]byte
	MATRIX_SCFG  [5]volatile.Register32 // 0x40
	_            [44]byte
	MATRIX_PRAS0 volatile.Register32 // 0x80
	_            [4]byte
	MATRIX_PRAS1 volatile.Register32 // 0x88
	_            [4]byte
	MATRIX_PRAS2 volatile.Register32 // 0x90
	_            [4]byte
	MATRIX_PRAS3 volatile.Register32 // 0x98
	_            [4]byte
	MATRIX_PRAS4 volatile.Register32 // 0xA0
	_            [112]byte
	CCFG_SYSIO   volatile.Register32 // 0x114
	_            [4]byte
	CCFG_SMCNFCS volatile.Register32 // 0x11C
	_            [196]byte
	MATRIX_WPMR  volatile.Register32 // 0x1E4
	MATRIX_WPSR  volatile.Register32 // 0x1E8
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER   volatile.Register32 // 0x0
	PMC_SCDR   volatile.Register32 // 0x4
	PMC_SCSR   volatile.Register32 // 0x8
	_          [4]byte
	PMC_PCER0  volatile.Register32 // 0x10
	PMC_PCDR0  volatile.Register32 // 0x14
	PMC_PCSR0  volatile.Register32 // 0x18
	_          [4]byte
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	CKGR_PLLBR volatile.Register32 // 0x2C
	PMC_MCKR   volatile.Register32 // 0x30
	_          [4]byte
	PMC_USB    volatile.Register32 // 0x38
	_          [4]byte
	PMC_PCK    [3]volatile.Register32 // 0x40
	_          [20]byte
	PMC_IER    volatile.Register32 // 0x60
	PMC_IDR    volatile.Register32 // 0x64
	PMC_SR     volatile.Register32 // 0x68
	PMC_IMR    volatile.Register32 // 0x6C
	PMC_FSMR   volatile.Register32 // 0x70
	PMC_FSPR   volatile.Register32 // 0x74
	PMC_FOCR   volatile.Register32 // 0x78
	_          [104]byte
	PMC_WPMR   volatile.Register32 // 0xE4
	PMC_WPSR   volatile.Register32 // 0xE8
	_          [20]byte
	PMC_PCER1  volatile.Register32 // 0x100
	PMC_PCDR1  volatile.Register32 // 0x104
	PMC_PCSR1  volatile.Register32 // 0x108
	_          [4]byte
	PMC_OCR    volatile.Register32 // 0x110
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [220]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Chip Identifier
type CHIPID_Type struct {
	CIDR volatile.Register32 // 0x0
	EXID volatile.Register32 // 0x4
}

// Embedded Flash Controller
type EFC_Type struct {
	FMR volatile.Register32 // 0x0
	FCR volatile.Register32 // 0x4
	FSR volatile.Register32 // 0x8
	FRR volatile.Register32 // 0xC
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
	_       [76]byte
	PCMR    volatile.Register32 // 0x150
	PCIER   volatile.Register32 // 0x154
	PCIDR   volatile.Register32 // 0x158
	PCIMR   volatile.Register32 // 0x15C
	PCISR   volatile.Register32 // 0x160
	PCRHR   volatile.Register32 // 0x164
	RPR     volatile.Register32 // 0x168
	RCR     volatile.Register32 // 0x16C
	_       [8]byte
	RNPR    volatile.Register32 // 0x178
	RNCR    volatile.Register32 // 0x17C
	_       [8]byte
	PTCR    volatile.Register32 // 0x188
	PTSR    volatile.Register32 // 0x18C
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// Bitfields for HSMCI: High Speed MultiMedia Card Interface
const (
	// CR: Control Register
	// Position of MCIEN field.
	HSMCI_CR_MCIEN_Pos = 0x0
	// Bit mask of MCIEN field.
	HSMCI_CR_MCIEN_Msk = 0x1
	// Bit MCIEN.
	HSMCI_CR_MCIEN = 0x1
	// Position of MCIDIS field.
	HSMCI_CR_MCIDIS_Pos = 0x1
	// Bit mask of MCIDIS field.
	HSMCI_CR_MCIDIS_Msk = 0x2
	// Bit MCIDIS.
	HSMCI_CR_MCIDIS = 0x2
	// Position of PWSEN field.
	HSMCI_CR_PWSEN_Pos = 0x2
	// Bit mask of PWSEN field.
	HSMCI_CR_PWSEN_Msk = 0x4
	// Bit PWSEN.
	HSMCI_CR_PWSEN = 0x4
	// Position of PWSDIS field.
	HSMCI_CR_PWSDIS_Pos = 0x3
	// Bit mask of PWSDIS field.
	HSMCI_CR_PWSDIS_Msk = 0x8
	// Bit PWSDIS.
	HSMCI_CR_PWSDIS = 0x8
	// Position of SWRST field.
	HSMCI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	HSMCI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	HSMCI_CR_SWRST = 0x80

	// MR: Mode Register
	// Position of CLKDIV field.
	HSMCI_MR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	HSMCI_MR_CLKDIV_Msk = 0xff
	// Position of PWSDIV field.
	HSMCI_MR_PWSDIV_Pos = 0x8
	// Bit mask of PWSDIV field.
	HSMCI_MR_PWSDIV_Msk = 0x700
	// Position of RDPROOF field.
	HSMCI_MR_RDPROOF_Pos = 0xb
	// Bit mask of RDPROOF field.
	HSMCI_MR_RDPROOF_Msk = 0x800
	// Bit RDPROOF.
	HSMCI_MR_RDPROOF = 0x800
	// Position of WRPROOF field.
	HSMCI_MR_WRPROOF_Pos = 0xc
	// Bit mask of WRPROOF field.
	HSMCI_MR_WRPROOF_Msk = 0x1000
	// Bit WRPROOF.
	HSMCI_MR_WRPROOF = 0x1000
	// Position of FBYTE field.
	HSMCI_MR_FBYTE_Pos = 0xd
	// Bit mask of FBYTE field.
	HSMCI_MR_FBYTE_Msk = 0x2000
	// Bit FBYTE.
	HSMCI_MR_FBYTE = 0x2000
	// Position of PADV field.
	HSMCI_MR_PADV_Pos = 0xe
	// Bit mask of PADV field.
	HSMCI_MR_PADV_Msk = 0x4000
	// Bit PADV.
	HSMCI_MR_PADV = 0x4000
	// Position of PDCMODE field.
	HSMCI_MR_PDCMODE_Pos = 0xf
	// Bit mask of PDCMODE field.
	HSMCI_MR_PDCMODE_Msk = 0x8000
	// Bit PDCMODE.
	HSMCI_MR_PDCMODE = 0x8000

	// DTOR: Data Timeout Register
	// Position of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Pos = 0x0
	// Bit mask of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Msk = 0xf
	// Position of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Pos = 0x4
	// Bit mask of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Msk = 0x70
	// DTOCYC
	HSMCI_DTOR_DTOMUL_1 = 0x0
	// DTOCYC x 16
	HSMCI_DTOR_DTOMUL_16 = 0x1
	// DTOCYC x 128
	HSMCI_DTOR_DTOMUL_128 = 0x2
	// DTOCYC x 256
	HSMCI_DTOR_DTOMUL_256 = 0x3
	// DTOCYC x 1024
	HSMCI_DTOR_DTOMUL_1024 = 0x4
	// DTOCYC x 4096
	HSMCI_DTOR_DTOMUL_4096 = 0x5
	// DTOCYC x 65536
	HSMCI_DTOR_DTOMUL_65536 = 0x6
	// DTOCYC x 1048576
	HSMCI_DTOR_DTOMUL_1048576 = 0x7

	// SDCR: SD/SDIO Card Register
	// Position of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Pos = 0x0
	// Bit mask of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Msk = 0x3
	// Slot A is selected.
	HSMCI_SDCR_SDCSEL_SLOTA = 0x0
	// -
	HSMCI_SDCR_SDCSEL_SLOTB = 0x1
	// -
	HSMCI_SDCR_SDCSEL_SLOTC = 0x2
	// -
	HSMCI_SDCR_SDCSEL_SLOTD = 0x3
	// Position of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Pos = 0x6
	// Bit mask of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Msk = 0xc0
	// 1 bit
	HSMCI_SDCR_SDCBUS_1 = 0x0
	// 4 bit
	HSMCI_SDCR_SDCBUS_4 = 0x2
	// 8 bit
	HSMCI_SDCR_SDCBUS_8 = 0x3

	// ARGR: Argument Register
	// Position of ARG field.
	HSMCI_ARGR_ARG_Pos = 0x0
	// Bit mask of ARG field.
	HSMCI_ARGR_ARG_Msk = 0xffffffff

	// CMDR: Command Register
	// Position of CMDNB field.
	HSMCI_CMDR_CMDNB_Pos = 0x0
	// Bit mask of CMDNB field.
	HSMCI_CMDR_CMDNB_Msk = 0x3f
	// Position of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Pos = 0x6
	// Bit mask of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Msk = 0xc0
	// No response.
	HSMCI_CMDR_RSPTYP_NORESP = 0x0
	// 48-bit response.
	HSMCI_CMDR_RSPTYP_48_BIT = 0x1
	// 136-bit response.
	HSMCI_CMDR_RSPTYP_136_BIT = 0x2
	// R1b response type
	HSMCI_CMDR_RSPTYP_R1B = 0x3
	// Position of SPCMD field.
	HSMCI_CMDR_SPCMD_Pos = 0x8
	// Bit mask of SPCMD field.
	HSMCI_CMDR_SPCMD_Msk = 0x700
	// Not a special CMD.
	HSMCI_CMDR_SPCMD_STD = 0x0
	// Initialization CMD: 74 clock cycles for initialization sequence.
	HSMCI_CMDR_SPCMD_INIT = 0x1
	// Synchronized CMD: Wait for the end of the current data block transfer before sending the pending command.
	HSMCI_CMDR_SPCMD_SYNC = 0x2
	// CE-ATA Completion Signal disable Command. The host cancels the ability for the device to return a command completion signal on the command line.
	HSMCI_CMDR_SPCMD_CE_ATA = 0x3
	// Interrupt command: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_CMD = 0x4
	// Interrupt response: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_RESP = 0x5
	// Boot Operation Request. Start a boot operation mode, the host processor can read boot data from the MMC device directly.
	HSMCI_CMDR_SPCMD_BOR = 0x6
	// End Boot Operation. This command allows the host processor to terminate the boot operation mode.
	HSMCI_CMDR_SPCMD_EBO = 0x7
	// Position of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Pos = 0xb
	// Bit mask of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Msk = 0x800
	// Bit OPDCMD.
	HSMCI_CMDR_OPDCMD = 0x800
	// Push pull command.
	HSMCI_CMDR_OPDCMD_PUSHPULL = 0x0
	// Open drain command.
	HSMCI_CMDR_OPDCMD_OPENDRAIN = 0x1
	// Position of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Pos = 0xc
	// Bit mask of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Msk = 0x1000
	// Bit MAXLAT.
	HSMCI_CMDR_MAXLAT = 0x1000
	// 5-cycle max latency.
	HSMCI_CMDR_MAXLAT_5 = 0x0
	// 64-cycle max latency.
	HSMCI_CMDR_MAXLAT_64 = 0x1
	// Position of TRCMD field.
	HSMCI_CMDR_TRCMD_Pos = 0x10
	// Bit mask of TRCMD field.
	HSMCI_CMDR_TRCMD_Msk = 0x30000
	// No data transfer
	HSMCI_CMDR_TRCMD_NO_DATA = 0x0
	// Start data transfer
	HSMCI_CMDR_TRCMD_START_DATA = 0x1
	// Stop data transfer
	HSMCI_CMDR_TRCMD_STOP_DATA = 0x2
	// Position of TRDIR field.
	HSMCI_CMDR_TRDIR_Pos = 0x12
	// Bit mask of TRDIR field.
	HSMCI_CMDR_TRDIR_Msk = 0x40000
	// Bit TRDIR.
	HSMCI_CMDR_TRDIR = 0x40000
	// Write.
	HSMCI_CMDR_TRDIR_WRITE = 0x0
	// Read.
	HSMCI_CMDR_TRDIR_READ = 0x1
	// Position of TRTYP field.
	HSMCI_CMDR_TRTYP_Pos = 0x13
	// Bit mask of TRTYP field.
	HSMCI_CMDR_TRTYP_Msk = 0x380000
	// MMC/SDCard Single Block
	HSMCI_CMDR_TRTYP_SINGLE = 0x0
	// MMC/SDCard Multiple Block
	HSMCI_CMDR_TRTYP_MULTIPLE = 0x1
	// MMC Stream
	HSMCI_CMDR_TRTYP_STREAM = 0x2
	// SDIO Byte
	HSMCI_CMDR_TRTYP_BYTE = 0x4
	// SDIO Block
	HSMCI_CMDR_TRTYP_BLOCK = 0x5
	// Position of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Pos = 0x18
	// Bit mask of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Msk = 0x3000000
	// Not an SDIO Special Command
	HSMCI_CMDR_IOSPCMD_STD = 0x0
	// SDIO Suspend Command
	HSMCI_CMDR_IOSPCMD_SUSPEND = 0x1
	// SDIO Resume Command
	HSMCI_CMDR_IOSPCMD_RESUME = 0x2
	// Position of ATACS field.
	HSMCI_CMDR_ATACS_Pos = 0x1a
	// Bit mask of ATACS field.
	HSMCI_CMDR_ATACS_Msk = 0x4000000
	// Bit ATACS.
	HSMCI_CMDR_ATACS = 0x4000000
	// Normal operation mode.
	HSMCI_CMDR_ATACS_NORMAL = 0x0
	// This bit indicates that a completion signal is expected within a programmed amount of time (HSMCI_CSTOR).
	HSMCI_CMDR_ATACS_COMPLETION = 0x1
	// Position of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Pos = 0x1b
	// Bit mask of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Msk = 0x8000000
	// Bit BOOT_ACK.
	HSMCI_CMDR_BOOT_ACK = 0x8000000

	// BLKR: Block Register
	// Position of BCNT field.
	HSMCI_BLKR_BCNT_Pos = 0x0
	// Bit mask of BCNT field.
	HSMCI_BLKR_BCNT_Msk = 0xffff
	// MMC/SDCARD Multiple BlockFrom 1 to 65635: Value 0 corresponds to an infinite block transfer.
	HSMCI_BLKR_BCNT_MULTIPLE = 0x0
	// SDIO ByteFrom 1 to 512 bytes: Value 0 corresponds to a 512-byte transfer.Values from 0x200 to 0xFFFF are forbidden.
	HSMCI_BLKR_BCNT_BYTE = 0x4
	// SDIO BlockFrom 1 to 511 blocks: Value 0 corresponds to an infinite block transfer.Values from 0x200 to 0xFFFF are forbidden.
	HSMCI_BLKR_BCNT_BLOCK = 0x5
	// Position of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Pos = 0x10
	// Bit mask of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Msk = 0xffff0000

	// CSTOR: Completion Signal Timeout Register
	// Position of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Pos = 0x0
	// Bit mask of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Msk = 0xf
	// Position of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Pos = 0x4
	// Bit mask of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Msk = 0x70
	// CSTOCYC x 1
	HSMCI_CSTOR_CSTOMUL_1 = 0x0
	// CSTOCYC x 16
	HSMCI_CSTOR_CSTOMUL_16 = 0x1
	// CSTOCYC x 128
	HSMCI_CSTOR_CSTOMUL_128 = 0x2
	// CSTOCYC x 256
	HSMCI_CSTOR_CSTOMUL_256 = 0x3
	// CSTOCYC x 1024
	HSMCI_CSTOR_CSTOMUL_1024 = 0x4
	// CSTOCYC x 4096
	HSMCI_CSTOR_CSTOMUL_4096 = 0x5
	// CSTOCYC x 65536
	HSMCI_CSTOR_CSTOMUL_65536 = 0x6
	// CSTOCYC x 1048576
	HSMCI_CSTOR_CSTOMUL_1048576 = 0x7

	// RSPR: Response Register
	// Position of RSP field.
	HSMCI_RSPR_RSP_Pos = 0x0
	// Bit mask of RSP field.
	HSMCI_RSPR_RSP_Msk = 0xffffffff

	// RDR: Receive Data Register
	// Position of DATA field.
	HSMCI_RDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_RDR_DATA_Msk = 0xffffffff

	// TDR: Transmit Data Register
	// Position of DATA field.
	HSMCI_TDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_TDR_DATA_Msk = 0xffffffff

	// SR: Status Register
	// Position of CMDRDY field.
	HSMCI_SR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_SR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_SR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_SR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_SR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_SR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_SR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_SR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_SR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_SR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_SR_NOTBUSY = 0x20
	// Position of ENDRX field.
	HSMCI_SR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	HSMCI_SR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	HSMCI_SR_ENDRX = 0x40
	// Position of ENDTX field.
	HSMCI_SR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	HSMCI_SR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	HSMCI_SR_ENDTX = 0x80
	// Position of SDIOIRQA field.
	HSMCI_SR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_SR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_SR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_SR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_SR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_SR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_SR_CSRCV = 0x2000
	// Position of RXBUFF field.
	HSMCI_SR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	HSMCI_SR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	HSMCI_SR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	HSMCI_SR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	HSMCI_SR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	HSMCI_SR_TXBUFE = 0x8000
	// Position of RINDE field.
	HSMCI_SR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_SR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_SR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_SR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_SR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_SR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_SR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_SR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_SR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_SR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_SR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_SR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_SR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_SR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_SR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_SR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_SR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_SR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_SR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_SR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_SR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_SR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_SR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_SR_CSTOE = 0x800000
	// Position of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_SR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_SR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_SR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_SR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_SR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_SR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_SR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_SR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_SR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_SR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_SR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_SR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_SR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_SR_UNRE = 0x80000000

	// IER: Interrupt Enable Register
	// Position of CMDRDY field.
	HSMCI_IER_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IER_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IER_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IER_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IER_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IER_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IER_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IER_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IER_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IER_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IER_NOTBUSY = 0x20
	// Position of ENDRX field.
	HSMCI_IER_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	HSMCI_IER_ENDRX_Msk = 0x40
	// Bit ENDRX.
	HSMCI_IER_ENDRX = 0x40
	// Position of ENDTX field.
	HSMCI_IER_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	HSMCI_IER_ENDTX_Msk = 0x80
	// Bit ENDTX.
	HSMCI_IER_ENDTX = 0x80
	// Position of SDIOIRQA field.
	HSMCI_IER_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IER_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IER_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IER_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IER_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IER_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IER_CSRCV = 0x2000
	// Position of RXBUFF field.
	HSMCI_IER_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	HSMCI_IER_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	HSMCI_IER_RXBUFF = 0x4000
	// Position of TXBUFE field.
	HSMCI_IER_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	HSMCI_IER_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	HSMCI_IER_TXBUFE = 0x8000
	// Position of RINDE field.
	HSMCI_IER_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IER_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IER_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IER_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IER_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IER_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IER_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IER_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IER_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IER_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IER_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IER_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IER_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IER_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IER_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IER_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IER_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IER_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IER_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IER_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IER_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IER_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IER_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IER_CSTOE = 0x800000
	// Position of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IER_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IER_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IER_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IER_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IER_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IER_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IER_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IER_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IER_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IER_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IER_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IER_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IER_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IER_UNRE = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of CMDRDY field.
	HSMCI_IDR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IDR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IDR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IDR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IDR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IDR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IDR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IDR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IDR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IDR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IDR_NOTBUSY = 0x20
	// Position of ENDRX field.
	HSMCI_IDR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	HSMCI_IDR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	HSMCI_IDR_ENDRX = 0x40
	// Position of ENDTX field.
	HSMCI_IDR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	HSMCI_IDR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	HSMCI_IDR_ENDTX = 0x80
	// Position of SDIOIRQA field.
	HSMCI_IDR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IDR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IDR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IDR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IDR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IDR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IDR_CSRCV = 0x2000
	// Position of RXBUFF field.
	HSMCI_IDR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	HSMCI_IDR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	HSMCI_IDR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	HSMCI_IDR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	HSMCI_IDR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	HSMCI_IDR_TXBUFE = 0x8000
	// Position of RINDE field.
	HSMCI_IDR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IDR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IDR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IDR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IDR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IDR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IDR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IDR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IDR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IDR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IDR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IDR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IDR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IDR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IDR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IDR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IDR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IDR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IDR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IDR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IDR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IDR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IDR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IDR_CSTOE = 0x800000
	// Position of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IDR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IDR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IDR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IDR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IDR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IDR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IDR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IDR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IDR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IDR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IDR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IDR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IDR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IDR_UNRE = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of CMDRDY field.
	HSMCI_IMR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IMR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IMR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IMR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IMR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IMR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IMR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IMR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IMR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IMR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IMR_NOTBUSY = 0x20
	// Position of ENDRX field.
	HSMCI_IMR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	HSMCI_IMR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	HSMCI_IMR_ENDRX = 0x40
	// Position of ENDTX field.
	HSMCI_IMR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	HSMCI_IMR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	HSMCI_IMR_ENDTX = 0x80
	// Position of SDIOIRQA field.
	HSMCI_IMR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IMR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IMR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IMR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IMR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IMR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IMR_CSRCV = 0x2000
	// Position of RXBUFF field.
	HSMCI_IMR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	HSMCI_IMR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	HSMCI_IMR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	HSMCI_IMR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	HSMCI_IMR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	HSMCI_IMR_TXBUFE = 0x8000
	// Position of RINDE field.
	HSMCI_IMR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IMR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IMR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IMR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IMR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IMR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IMR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IMR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IMR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IMR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IMR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IMR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IMR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IMR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IMR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IMR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IMR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IMR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IMR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IMR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IMR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IMR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IMR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IMR_CSTOE = 0x800000
	// Position of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IMR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IMR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IMR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IMR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IMR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IMR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IMR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IMR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IMR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IMR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IMR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IMR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IMR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IMR_UNRE = 0x80000000

	// CFG: Configuration Register
	// Position of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Pos = 0x0
	// Bit mask of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Msk = 0x1
	// Bit FIFOMODE.
	HSMCI_CFG_FIFOMODE = 0x1
	// Position of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Pos = 0x4
	// Bit mask of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Msk = 0x10
	// Bit FERRCTRL.
	HSMCI_CFG_FERRCTRL = 0x10
	// Position of HSMODE field.
	HSMCI_CFG_HSMODE_Pos = 0x8
	// Bit mask of HSMODE field.
	HSMCI_CFG_HSMODE_Msk = 0x100
	// Bit HSMODE.
	HSMCI_CFG_HSMODE = 0x100
	// Position of LSYNC field.
	HSMCI_CFG_LSYNC_Pos = 0xc
	// Bit mask of LSYNC field.
	HSMCI_CFG_LSYNC_Msk = 0x1000
	// Bit LSYNC.
	HSMCI_CFG_LSYNC = 0x1000

	// WPMR: Write Protection Mode Register
	// Position of WP_EN field.
	HSMCI_WPMR_WP_EN_Pos = 0x0
	// Bit mask of WP_EN field.
	HSMCI_WPMR_WP_EN_Msk = 0x1
	// Bit WP_EN.
	HSMCI_WPMR_WP_EN = 0x1
	// Position of WP_KEY field.
	HSMCI_WPMR_WP_KEY_Pos = 0x8
	// Bit mask of WP_KEY field.
	HSMCI_WPMR_WP_KEY_Msk = 0xffffff00

	// WPSR: Write Protection Status Register
	// Position of WP_VS field.
	HSMCI_WPSR_WP_VS_Pos = 0x0
	// Bit mask of WP_VS field.
	HSMCI_WPSR_WP_VS_Msk = 0xf
	// No Write Protection Violation occurred since the last read of this register (WP_SR)
	HSMCI_WPSR_WP_VS_NONE = 0x0
	// Write Protection detected unauthorized attempt to write a control register had occurred (since the last read.)
	HSMCI_WPSR_WP_VS_WRITE = 0x1
	// Software reset had been performed while Write Protection was enabled (since the last read).
	HSMCI_WPSR_WP_VS_RESET = 0x2
	// Both Write Protection violation and software reset with Write Protection enabled have occurred since the last read.
	HSMCI_WPSR_WP_VS_BOTH = 0x3
	// Position of WP_VSRC field.
	HSMCI_WPSR_WP_VSRC_Pos = 0x8
	// Bit mask of WP_VSRC field.
	HSMCI_WPSR_WP_VSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	HSMCI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	HSMCI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	HSMCI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	HSMCI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	HSMCI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	HSMCI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	HSMCI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	HSMCI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	HSMCI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	HSMCI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	HSMCI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	HSMCI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	HSMCI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	HSMCI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	HSMCI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	HSMCI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	HSMCI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	HSMCI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	HSMCI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	HSMCI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	HSMCI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	HSMCI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	HSMCI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	HSMCI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	HSMCI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	HSMCI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	HSMCI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	HSMCI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	HSMCI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	HSMCI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	HSMCI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	HSMCI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	HSMCI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	HSMCI_PTSR_TXTEN = 0x100
)

// Bitfields for SSC: Synchronous Serial Controller
const (
	// CR: Control Register
	// Position of RXEN field.
	SSC_CR_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	SSC_CR_RXEN_Msk = 0x1
	// Bit RXEN.
	SSC_CR_RXEN = 0x1
	// Position of RXDIS field.
	SSC_CR_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	SSC_CR_RXDIS_Msk = 0x2
	// Bit RXDIS.
	SSC_CR_RXDIS = 0x2
	// Position of TXEN field.
	SSC_CR_TXEN_Pos = 0x8
	// Bit mask of TXEN field.
	SSC_CR_TXEN_Msk = 0x100
	// Bit TXEN.
	SSC_CR_TXEN = 0x100
	// Position of TXDIS field.
	SSC_CR_TXDIS_Pos = 0x9
	// Bit mask of TXDIS field.
	SSC_CR_TXDIS_Msk = 0x200
	// Bit TXDIS.
	SSC_CR_TXDIS = 0x200
	// Position of SWRST field.
	SSC_CR_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	SSC_CR_SWRST_Msk = 0x8000
	// Bit SWRST.
	SSC_CR_SWRST = 0x8000

	// CMR: Clock Mode Register
	// Position of DIV field.
	SSC_CMR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SSC_CMR_DIV_Msk = 0xfff

	// RCMR: Receive Clock Mode Register
	// Position of CKS field.
	SSC_RCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_RCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_RCMR_CKS_MCK = 0x0
	// TK Clock signal
	SSC_RCMR_CKS_TK = 0x1
	// RK pin
	SSC_RCMR_CKS_RK = 0x2
	// Position of CKO field.
	SSC_RCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_RCMR_CKO_Msk = 0x1c
	// None
	SSC_RCMR_CKO_NONE = 0x0
	// Continuous Receive Clock
	SSC_RCMR_CKO_CONTINUOUS = 0x1
	// Receive Clock only during data transfers
	SSC_RCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_RCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_RCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_RCMR_CKI = 0x20
	// Position of CKG field.
	SSC_RCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_RCMR_CKG_Msk = 0xc0
	// None
	SSC_RCMR_CKG_NONE = 0x0
	// Continuous Receive Clock
	SSC_RCMR_CKG_CONTINUOUS = 0x1
	// Receive Clock only during data transfers
	SSC_RCMR_CKG_TRANSFER = 0x2
	// Position of START field.
	SSC_RCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_RCMR_START_Msk = 0xf00
	// Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data.
	SSC_RCMR_START_CONTINUOUS = 0x0
	// Transmit start
	SSC_RCMR_START_TRANSMIT = 0x1
	// Detection of a low level on RF signal
	SSC_RCMR_START_RF_LOW = 0x2
	// Detection of a high level on RF signal
	SSC_RCMR_START_RF_HIGH = 0x3
	// Detection of a falling edge on RF signal
	SSC_RCMR_START_RF_FALLING = 0x4
	// Detection of a rising edge on RF signal
	SSC_RCMR_START_RF_RISING = 0x5
	// Detection of any level change on RF signal
	SSC_RCMR_START_RF_LEVEL = 0x6
	// Detection of any edge on RF signal
	SSC_RCMR_START_RF_EDGE = 0x7
	// Compare 0
	SSC_RCMR_START_CMP_0 = 0x8
	// Position of STOP field.
	SSC_RCMR_STOP_Pos = 0xc
	// Bit mask of STOP field.
	SSC_RCMR_STOP_Msk = 0x1000
	// Bit STOP.
	SSC_RCMR_STOP = 0x1000
	// Position of STTDLY field.
	SSC_RCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_RCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_RCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_RCMR_PERIOD_Msk = 0xff000000

	// RFMR: Receive Frame Mode Register
	// Position of DATLEN field.
	SSC_RFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_RFMR_DATLEN_Msk = 0x1f
	// Position of LOOP field.
	SSC_RFMR_LOOP_Pos = 0x5
	// Bit mask of LOOP field.
	SSC_RFMR_LOOP_Msk = 0x20
	// Bit LOOP.
	SSC_RFMR_LOOP = 0x20
	// Position of MSBF field.
	SSC_RFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_RFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_RFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_RFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_RFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_RFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_RFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_RFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_RFMR_FSOS_Msk = 0x700000
	// None
	SSC_RFMR_FSOS_NONE = 0x0
	// Negative Pulse
	SSC_RFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse
	SSC_RFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer
	SSC_RFMR_FSOS_LOW = 0x3
	// Driven High during data transfer
	SSC_RFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer
	SSC_RFMR_FSOS_TOGGLING = 0x5
	// Position of FSEDGE field.
	SSC_RFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_RFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_RFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_RFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_RFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Msk = 0xf0000000

	// TCMR: Transmit Clock Mode Register
	// Position of CKS field.
	SSC_TCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_TCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_TCMR_CKS_MCK = 0x0
	// TK Clock signal
	SSC_TCMR_CKS_TK = 0x1
	// RK pin
	SSC_TCMR_CKS_RK = 0x2
	// Position of CKO field.
	SSC_TCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_TCMR_CKO_Msk = 0x1c
	// None
	SSC_TCMR_CKO_NONE = 0x0
	// Continuous Receive Clock
	SSC_TCMR_CKO_CONTINUOUS = 0x1
	// Transmit Clock only during data transfers
	SSC_TCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_TCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_TCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_TCMR_CKI = 0x20
	// Position of CKG field.
	SSC_TCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_TCMR_CKG_Msk = 0xc0
	// None
	SSC_TCMR_CKG_NONE = 0x0
	// Transmit Clock enabled only if TF Low
	SSC_TCMR_CKG_CONTINUOUS = 0x1
	// Transmit Clock enabled only if TF High
	SSC_TCMR_CKG_TRANSFER = 0x2
	// Position of START field.
	SSC_TCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_TCMR_START_Msk = 0xf00
	// Continuous, as soon as a word is written in the SSC_THR Register (if Transmit is enabled), and immediately after the end of transfer of the previous data.
	SSC_TCMR_START_CONTINUOUS = 0x0
	// Receive start
	SSC_TCMR_START_RECEIVE = 0x1
	// Detection of a low level on TF signal
	SSC_TCMR_START_RF_LOW = 0x2
	// Detection of a high level on TF signal
	SSC_TCMR_START_RF_HIGH = 0x3
	// Detection of a falling edge on TF signal
	SSC_TCMR_START_RF_FALLING = 0x4
	// Detection of a rising edge on TF signal
	SSC_TCMR_START_RF_RISING = 0x5
	// Detection of any level change on TF signal
	SSC_TCMR_START_RF_LEVEL = 0x6
	// Detection of any edge on TF signal
	SSC_TCMR_START_RF_EDGE = 0x7
	// Compare 0
	SSC_TCMR_START_CMP_0 = 0x8
	// Position of STTDLY field.
	SSC_TCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_TCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_TCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_TCMR_PERIOD_Msk = 0xff000000

	// TFMR: Transmit Frame Mode Register
	// Position of DATLEN field.
	SSC_TFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_TFMR_DATLEN_Msk = 0x1f
	// Position of DATDEF field.
	SSC_TFMR_DATDEF_Pos = 0x5
	// Bit mask of DATDEF field.
	SSC_TFMR_DATDEF_Msk = 0x20
	// Bit DATDEF.
	SSC_TFMR_DATDEF = 0x20
	// Position of MSBF field.
	SSC_TFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_TFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_TFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_TFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_TFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_TFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_TFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_TFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_TFMR_FSOS_Msk = 0x700000
	// None
	SSC_TFMR_FSOS_NONE = 0x0
	// Negative Pulse
	SSC_TFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse
	SSC_TFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer
	SSC_TFMR_FSOS_LOW = 0x3
	// Driven High during data transfer
	SSC_TFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer
	SSC_TFMR_FSOS_TOGGLING = 0x5
	// Position of FSDEN field.
	SSC_TFMR_FSDEN_Pos = 0x17
	// Bit mask of FSDEN field.
	SSC_TFMR_FSDEN_Msk = 0x800000
	// Bit FSDEN.
	SSC_TFMR_FSDEN = 0x800000
	// Position of FSEDGE field.
	SSC_TFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_TFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_TFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_TFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_TFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Msk = 0xf0000000

	// RHR: Receive Holding Register
	// Position of RDAT field.
	SSC_RHR_RDAT_Pos = 0x0
	// Bit mask of RDAT field.
	SSC_RHR_RDAT_Msk = 0xffffffff

	// THR: Transmit Holding Register
	// Position of TDAT field.
	SSC_THR_TDAT_Pos = 0x0
	// Bit mask of TDAT field.
	SSC_THR_TDAT_Msk = 0xffffffff

	// RSHR: Receive Sync. Holding Register
	// Position of RSDAT field.
	SSC_RSHR_RSDAT_Pos = 0x0
	// Bit mask of RSDAT field.
	SSC_RSHR_RSDAT_Msk = 0xffff

	// TSHR: Transmit Sync. Holding Register
	// Position of TSDAT field.
	SSC_TSHR_TSDAT_Pos = 0x0
	// Bit mask of TSDAT field.
	SSC_TSHR_TSDAT_Msk = 0xffff

	// RC0R: Receive Compare 0 Register
	// Position of CP0 field.
	SSC_RC0R_CP0_Pos = 0x0
	// Bit mask of CP0 field.
	SSC_RC0R_CP0_Msk = 0xffff

	// RC1R: Receive Compare 1 Register
	// Position of CP1 field.
	SSC_RC1R_CP1_Pos = 0x0
	// Bit mask of CP1 field.
	SSC_RC1R_CP1_Msk = 0xffff

	// SR: Status Register
	// Position of TXRDY field.
	SSC_SR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_SR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_SR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_SR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_SR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_SR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_SR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_SR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_SR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_SR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_SR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_SR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_SR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_SR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_SR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_SR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_SR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_SR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_SR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_SR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_SR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_SR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_SR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_SR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_SR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_SR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_SR_CP0 = 0x100
	// Position of CP1 field.
	SSC_SR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_SR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_SR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_SR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_SR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_SR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_SR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_SR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_SR_RXSYN = 0x800
	// Position of TXEN field.
	SSC_SR_TXEN_Pos = 0x10
	// Bit mask of TXEN field.
	SSC_SR_TXEN_Msk = 0x10000
	// Bit TXEN.
	SSC_SR_TXEN = 0x10000
	// Position of RXEN field.
	SSC_SR_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SSC_SR_RXEN_Msk = 0x20000
	// Bit RXEN.
	SSC_SR_RXEN = 0x20000

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	SSC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IER_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IER_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IER_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IER_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IER_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IER_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IER_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IER_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IER_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IER_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IER_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IER_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IER_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IER_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IER_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IER_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IER_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IER_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IER_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IER_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IER_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IER_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IER_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IER_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IER_CP0 = 0x100
	// Position of CP1 field.
	SSC_IER_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IER_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IER_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IER_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IER_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IER_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IER_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IER_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IER_RXSYN = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	SSC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IDR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IDR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IDR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IDR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IDR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IDR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IDR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IDR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IDR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IDR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IDR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IDR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IDR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IDR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IDR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IDR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IDR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IDR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IDR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IDR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IDR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IDR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IDR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IDR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IDR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IDR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IDR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IDR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IDR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IDR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IDR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IDR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IDR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IDR_RXSYN = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	SSC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IMR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IMR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IMR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IMR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IMR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IMR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IMR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IMR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IMR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IMR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IMR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IMR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IMR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IMR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IMR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IMR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IMR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IMR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IMR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IMR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IMR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IMR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IMR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IMR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IMR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IMR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IMR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IMR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IMR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IMR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IMR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IMR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IMR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IMR_RXSYN = 0x800

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	SSC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SSC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SSC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SSC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SSC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	SSC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	SSC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	SSC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	SSC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	SSC_WPSR_WPVSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	SSC_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	SSC_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	SSC_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	SSC_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	SSC_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	SSC_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	SSC_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	SSC_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	SSC_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	SSC_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	SSC_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	SSC_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	SSC_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	SSC_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	SSC_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	SSC_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	SSC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SSC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SSC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	SSC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	SSC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	SSC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	SSC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SSC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SSC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	SSC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	SSC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	SSC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	SSC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SSC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SSC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	SSC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SSC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SSC_PTSR_TXTEN = 0x100
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// CR: Control Register
	// Position of SPIEN field.
	SPI_CR_SPIEN_Pos = 0x0
	// Bit mask of SPIEN field.
	SPI_CR_SPIEN_Msk = 0x1
	// Bit SPIEN.
	SPI_CR_SPIEN = 0x1
	// Position of SPIDIS field.
	SPI_CR_SPIDIS_Pos = 0x1
	// Bit mask of SPIDIS field.
	SPI_CR_SPIDIS_Msk = 0x2
	// Bit SPIDIS.
	SPI_CR_SPIDIS = 0x2
	// Position of SWRST field.
	SPI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	SPI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	SPI_CR_SWRST = 0x80
	// Position of LASTXFER field.
	SPI_CR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_CR_LASTXFER = 0x1000000

	// MR: Mode Register
	// Position of MSTR field.
	SPI_MR_MSTR_Pos = 0x0
	// Bit mask of MSTR field.
	SPI_MR_MSTR_Msk = 0x1
	// Bit MSTR.
	SPI_MR_MSTR = 0x1
	// Position of PS field.
	SPI_MR_PS_Pos = 0x1
	// Bit mask of PS field.
	SPI_MR_PS_Msk = 0x2
	// Bit PS.
	SPI_MR_PS = 0x2
	// Position of PCSDEC field.
	SPI_MR_PCSDEC_Pos = 0x2
	// Bit mask of PCSDEC field.
	SPI_MR_PCSDEC_Msk = 0x4
	// Bit PCSDEC.
	SPI_MR_PCSDEC = 0x4
	// Position of MODFDIS field.
	SPI_MR_MODFDIS_Pos = 0x4
	// Bit mask of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10
	// Bit MODFDIS.
	SPI_MR_MODFDIS = 0x10
	// Position of WDRBT field.
	SPI_MR_WDRBT_Pos = 0x5
	// Bit mask of WDRBT field.
	SPI_MR_WDRBT_Msk = 0x20
	// Bit WDRBT.
	SPI_MR_WDRBT = 0x20
	// Position of LLB field.
	SPI_MR_LLB_Pos = 0x7
	// Bit mask of LLB field.
	SPI_MR_LLB_Msk = 0x80
	// Bit LLB.
	SPI_MR_LLB = 0x80
	// Position of PCS field.
	SPI_MR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_MR_PCS_Msk = 0xf0000
	// Position of DLYBCS field.
	SPI_MR_DLYBCS_Pos = 0x18
	// Bit mask of DLYBCS field.
	SPI_MR_DLYBCS_Msk = 0xff000000

	// RDR: Receive Data Register
	// Position of RD field.
	SPI_RDR_RD_Pos = 0x0
	// Bit mask of RD field.
	SPI_RDR_RD_Msk = 0xffff
	// Position of PCS field.
	SPI_RDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000

	// TDR: Transmit Data Register
	// Position of TD field.
	SPI_TDR_TD_Pos = 0x0
	// Bit mask of TD field.
	SPI_TDR_TD_Msk = 0xffff
	// Position of PCS field.
	SPI_TDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_TDR_PCS_Msk = 0xf0000
	// Position of LASTXFER field.
	SPI_TDR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_TDR_LASTXFER = 0x1000000

	// SR: Status Register
	// Position of RDRF field.
	SPI_SR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_SR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_SR_RDRF = 0x1
	// Position of TDRE field.
	SPI_SR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_SR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_SR_TDRE = 0x2
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_SR_MODF = 0x4
	// Position of OVRES field.
	SPI_SR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_SR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_SR_OVRES = 0x8
	// Position of ENDRX field.
	SPI_SR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_SR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_SR_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_SR_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_SR_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_SR_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_SR_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_SR_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_SR_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_SR_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_SR_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_SR_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_SR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_SR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_SR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_SR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_SR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_SR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_SR_UNDES = 0x400
	// Position of SPIENS field.
	SPI_SR_SPIENS_Pos = 0x10
	// Bit mask of SPIENS field.
	SPI_SR_SPIENS_Msk = 0x10000
	// Bit SPIENS.
	SPI_SR_SPIENS = 0x10000

	// IER: Interrupt Enable Register
	// Position of RDRF field.
	SPI_IER_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IER_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IER_RDRF = 0x1
	// Position of TDRE field.
	SPI_IER_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IER_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IER_TDRE = 0x2
	// Position of MODF field.
	SPI_IER_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IER_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IER_MODF = 0x4
	// Position of OVRES field.
	SPI_IER_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IER_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IER_OVRES = 0x8
	// Position of ENDRX field.
	SPI_IER_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_IER_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_IER_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_IER_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_IER_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_IER_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_IER_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_IER_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_IER_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_IER_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_IER_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_IER_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_IER_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IER_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IER_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IER_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IER_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IER_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IER_UNDES = 0x400

	// IDR: Interrupt Disable Register
	// Position of RDRF field.
	SPI_IDR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IDR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IDR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IDR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IDR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IDR_TDRE = 0x2
	// Position of MODF field.
	SPI_IDR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IDR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IDR_MODF = 0x4
	// Position of OVRES field.
	SPI_IDR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IDR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IDR_OVRES = 0x8
	// Position of ENDRX field.
	SPI_IDR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_IDR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_IDR_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_IDR_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_IDR_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_IDR_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_IDR_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_IDR_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_IDR_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_IDR_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_IDR_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_IDR_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_IDR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IDR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IDR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IDR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IDR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IDR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IDR_UNDES = 0x400

	// IMR: Interrupt Mask Register
	// Position of RDRF field.
	SPI_IMR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IMR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IMR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IMR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IMR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IMR_TDRE = 0x2
	// Position of MODF field.
	SPI_IMR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IMR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IMR_MODF = 0x4
	// Position of OVRES field.
	SPI_IMR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IMR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IMR_OVRES = 0x8
	// Position of ENDRX field.
	SPI_IMR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_IMR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_IMR_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_IMR_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_IMR_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_IMR_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_IMR_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_IMR_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_IMR_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_IMR_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_IMR_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_IMR_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_IMR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IMR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IMR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IMR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IMR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IMR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IMR_UNDES = 0x400

	// CSR: Chip Select Register
	// Position of CPOL field.
	SPI_CSR_CPOL_Pos = 0x0
	// Bit mask of CPOL field.
	SPI_CSR_CPOL_Msk = 0x1
	// Bit CPOL.
	SPI_CSR_CPOL = 0x1
	// Position of NCPHA field.
	SPI_CSR_NCPHA_Pos = 0x1
	// Bit mask of NCPHA field.
	SPI_CSR_NCPHA_Msk = 0x2
	// Bit NCPHA.
	SPI_CSR_NCPHA = 0x2
	// Position of CSNAAT field.
	SPI_CSR_CSNAAT_Pos = 0x2
	// Bit mask of CSNAAT field.
	SPI_CSR_CSNAAT_Msk = 0x4
	// Bit CSNAAT.
	SPI_CSR_CSNAAT = 0x4
	// Position of CSAAT field.
	SPI_CSR_CSAAT_Pos = 0x3
	// Bit mask of CSAAT field.
	SPI_CSR_CSAAT_Msk = 0x8
	// Bit CSAAT.
	SPI_CSR_CSAAT = 0x8
	// Position of BITS field.
	SPI_CSR_BITS_Pos = 0x4
	// Bit mask of BITS field.
	SPI_CSR_BITS_Msk = 0xf0
	// 8 bits for transfer
	SPI_CSR_BITS_8_BIT = 0x0
	// 9 bits for transfer
	SPI_CSR_BITS_9_BIT = 0x1
	// 10 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2
	// 11 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3
	// 12 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4
	// 13 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5
	// 14 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6
	// 15 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7
	// 16 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8
	// Position of SCBR field.
	SPI_CSR_SCBR_Pos = 0x8
	// Bit mask of SCBR field.
	SPI_CSR_SCBR_Msk = 0xff00
	// Position of DLYBS field.
	SPI_CSR_DLYBS_Pos = 0x10
	// Bit mask of DLYBS field.
	SPI_CSR_DLYBS_Msk = 0xff0000
	// Position of DLYBCT field.
	SPI_CSR_DLYBCT_Pos = 0x18
	// Bit mask of DLYBCT field.
	SPI_CSR_DLYBCT_Msk = 0xff000000

	// WPMR: Write Protection Control Register
	// Position of WPEN field.
	SPI_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SPI_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SPI_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SPI_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SPI_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	SPI_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	SPI_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	SPI_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	SPI_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	SPI_WPSR_WPVSRC_Msk = 0xff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	SPI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	SPI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	SPI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	SPI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	SPI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	SPI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	SPI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	SPI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	SPI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	SPI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	SPI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	SPI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	SPI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	SPI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	SPI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	SPI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	SPI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SPI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SPI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	SPI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	SPI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	SPI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	SPI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SPI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SPI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	SPI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	SPI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	SPI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	SPI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SPI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SPI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	SPI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SPI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SPI_PTSR_TXTEN = 0x100
)

// Bitfields for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	// Position of CLKEN field.
	TC_CCR0_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR0_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR0_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR0_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR0_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR0_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR0_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR0_SWTRG = 0x4

	// CMR0: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR0_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR0_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR0_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR0_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR0_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR0_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR0_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR0_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR0_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR0_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR0_LDRA_Msk = 0x30000
	// None
	TC_CMR0_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR0_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR0_LDRB_Msk = 0xc0000
	// None
	TC_CMR0_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRB_EDGE = 0x3

	// CMR0_WAVE_EQ_1: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR0_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR0_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR0_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR0_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR0_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR0_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR0_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR0_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR0_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR0_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR0_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR0_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR0_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR0_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// SMMR0: Stepper Motor Mode Register (channel = 0)
	// Position of GCEN field.
	TC_SMMR0_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR0_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR0_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR0_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR0_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR0_DOWN = 0x2

	// CV0: Counter Value (channel = 0)
	// Position of CV field.
	TC_CV0_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV0_CV_Msk = 0xffffffff

	// RA0: Register A (channel = 0)
	// Position of RA field.
	TC_RA0_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA0_RA_Msk = 0xffffffff

	// RB0: Register B (channel = 0)
	// Position of RB field.
	TC_RB0_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB0_RB_Msk = 0xffffffff

	// RC0: Register C (channel = 0)
	// Position of RC field.
	TC_RC0_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC0_RC_Msk = 0xffffffff

	// SR0: Status Register (channel = 0)
	// Position of COVFS field.
	TC_SR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR0_CPAS = 0x4
	// Position of CPBS field.
	TC_SR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR0_CPBS = 0x8
	// Position of CPCS field.
	TC_SR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR0_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR0_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR0_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR0_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR0_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR0_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR0_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR0_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR0_MTIOB = 0x40000

	// IER0: Interrupt Enable Register (channel = 0)
	// Position of COVFS field.
	TC_IER0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER0_CPAS = 0x4
	// Position of CPBS field.
	TC_IER0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER0_CPBS = 0x8
	// Position of CPCS field.
	TC_IER0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER0_ETRGS = 0x80

	// IDR0: Interrupt Disable Register (channel = 0)
	// Position of COVFS field.
	TC_IDR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR0_ETRGS = 0x80

	// IMR0: Interrupt Mask Register (channel = 0)
	// Position of COVFS field.
	TC_IMR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR0_ETRGS = 0x80

	// CCR1: Channel Control Register (channel = 1)
	// Position of CLKEN field.
	TC_CCR1_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR1_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR1_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR1_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR1_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR1_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR1_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR1_SWTRG = 0x4

	// CMR1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR1_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR1_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR1_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR1_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR1_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR1_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR1_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR1_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR1_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR1_LDRA_Msk = 0x30000
	// None
	TC_CMR1_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR1_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR1_LDRB_Msk = 0xc0000
	// None
	TC_CMR1_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRB_EDGE = 0x3

	// CMR1_WAVE_EQ_1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR1_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR1_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR1_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR1_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR1_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR1_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR1_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR1_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR1_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR1_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR1_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR1_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR1_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR1_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// SMMR1: Stepper Motor Mode Register (channel = 1)
	// Position of GCEN field.
	TC_SMMR1_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR1_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR1_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR1_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR1_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR1_DOWN = 0x2

	// CV1: Counter Value (channel = 1)
	// Position of CV field.
	TC_CV1_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV1_CV_Msk = 0xffffffff

	// RA1: Register A (channel = 1)
	// Position of RA field.
	TC_RA1_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA1_RA_Msk = 0xffffffff

	// RB1: Register B (channel = 1)
	// Position of RB field.
	TC_RB1_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB1_RB_Msk = 0xffffffff

	// RC1: Register C (channel = 1)
	// Position of RC field.
	TC_RC1_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC1_RC_Msk = 0xffffffff

	// SR1: Status Register (channel = 1)
	// Position of COVFS field.
	TC_SR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR1_CPAS = 0x4
	// Position of CPBS field.
	TC_SR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR1_CPBS = 0x8
	// Position of CPCS field.
	TC_SR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR1_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR1_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR1_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR1_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR1_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR1_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR1_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR1_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR1_MTIOB = 0x40000

	// IER1: Interrupt Enable Register (channel = 1)
	// Position of COVFS field.
	TC_IER1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER1_CPAS = 0x4
	// Position of CPBS field.
	TC_IER1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER1_CPBS = 0x8
	// Position of CPCS field.
	TC_IER1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER1_ETRGS = 0x80

	// IDR1: Interrupt Disable Register (channel = 1)
	// Position of COVFS field.
	TC_IDR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR1_ETRGS = 0x80

	// IMR1: Interrupt Mask Register (channel = 1)
	// Position of COVFS field.
	TC_IMR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR1_ETRGS = 0x80

	// CCR2: Channel Control Register (channel = 2)
	// Position of CLKEN field.
	TC_CCR2_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR2_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR2_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR2_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR2_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR2_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR2_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR2_SWTRG = 0x4

	// CMR2: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR2_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR2_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR2_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR2_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR2_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR2_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR2_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR2_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR2_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR2_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR2_LDRA_Msk = 0x30000
	// None
	TC_CMR2_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR2_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR2_LDRB_Msk = 0xc0000
	// None
	TC_CMR2_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRB_EDGE = 0x3

	// CMR2_WAVE_EQ_1: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR2_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR2_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR2_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR2_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR2_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR2_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR2_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR2_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR2_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR2_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR2_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR2_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR2_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR2_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// SMMR2: Stepper Motor Mode Register (channel = 2)
	// Position of GCEN field.
	TC_SMMR2_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR2_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR2_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR2_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR2_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR2_DOWN = 0x2

	// CV2: Counter Value (channel = 2)
	// Position of CV field.
	TC_CV2_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV2_CV_Msk = 0xffffffff

	// RA2: Register A (channel = 2)
	// Position of RA field.
	TC_RA2_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA2_RA_Msk = 0xffffffff

	// RB2: Register B (channel = 2)
	// Position of RB field.
	TC_RB2_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB2_RB_Msk = 0xffffffff

	// RC2: Register C (channel = 2)
	// Position of RC field.
	TC_RC2_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC2_RC_Msk = 0xffffffff

	// SR2: Status Register (channel = 2)
	// Position of COVFS field.
	TC_SR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR2_CPAS = 0x4
	// Position of CPBS field.
	TC_SR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR2_CPBS = 0x8
	// Position of CPCS field.
	TC_SR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR2_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR2_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR2_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR2_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR2_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR2_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR2_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR2_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR2_MTIOB = 0x40000

	// IER2: Interrupt Enable Register (channel = 2)
	// Position of COVFS field.
	TC_IER2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER2_CPAS = 0x4
	// Position of CPBS field.
	TC_IER2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER2_CPBS = 0x8
	// Position of CPCS field.
	TC_IER2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER2_ETRGS = 0x80

	// IDR2: Interrupt Disable Register (channel = 2)
	// Position of COVFS field.
	TC_IDR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR2_ETRGS = 0x80

	// IMR2: Interrupt Mask Register (channel = 2)
	// Position of COVFS field.
	TC_IMR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR2_ETRGS = 0x80

	// BCR: Block Control Register
	// Position of SYNC field.
	TC_BCR_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	TC_BCR_SYNC_Msk = 0x1
	// Bit SYNC.
	TC_BCR_SYNC = 0x1

	// BMR: Block Mode Register
	// Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Pos = 0x0
	// Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk = 0x3
	// Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TCLK0 = 0x0
	// Signal connected to XC0: TIOA1
	TC_BMR_TC0XC0S_TIOA1 = 0x2
	// Signal connected to XC0: TIOA2
	TC_BMR_TC0XC0S_TIOA2 = 0x3
	// Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Pos = 0x2
	// Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk = 0xc
	// Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TCLK1 = 0x0
	// Signal connected to XC1: TIOA0
	TC_BMR_TC1XC1S_TIOA0 = 0x2
	// Signal connected to XC1: TIOA2
	TC_BMR_TC1XC1S_TIOA2 = 0x3
	// Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Pos = 0x4
	// Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk = 0x30
	// Signal connected to XC2: TCLK2
	TC_BMR_TC2XC2S_TCLK2 = 0x0
	// Signal connected to XC2: TIOA1
	TC_BMR_TC2XC2S_TIOA1 = 0x2
	// Signal connected to XC2: TIOA2
	TC_BMR_TC2XC2S_TIOA2 = 0x3
	// Position of QDEN field.
	TC_BMR_QDEN_Pos = 0x8
	// Bit mask of QDEN field.
	TC_BMR_QDEN_Msk = 0x100
	// Bit QDEN.
	TC_BMR_QDEN = 0x100
	// Position of POSEN field.
	TC_BMR_POSEN_Pos = 0x9
	// Bit mask of POSEN field.
	TC_BMR_POSEN_Msk = 0x200
	// Bit POSEN.
	TC_BMR_POSEN = 0x200
	// Position of SPEEDEN field.
	TC_BMR_SPEEDEN_Pos = 0xa
	// Bit mask of SPEEDEN field.
	TC_BMR_SPEEDEN_Msk = 0x400
	// Bit SPEEDEN.
	TC_BMR_SPEEDEN = 0x400
	// Position of QDTRANS field.
	TC_BMR_QDTRANS_Pos = 0xb
	// Bit mask of QDTRANS field.
	TC_BMR_QDTRANS_Msk = 0x800
	// Bit QDTRANS.
	TC_BMR_QDTRANS = 0x800
	// Position of EDGPHA field.
	TC_BMR_EDGPHA_Pos = 0xc
	// Bit mask of EDGPHA field.
	TC_BMR_EDGPHA_Msk = 0x1000
	// Bit EDGPHA.
	TC_BMR_EDGPHA = 0x1000
	// Position of INVA field.
	TC_BMR_INVA_Pos = 0xd
	// Bit mask of INVA field.
	TC_BMR_INVA_Msk = 0x2000
	// Bit INVA.
	TC_BMR_INVA = 0x2000
	// Position of INVB field.
	TC_BMR_INVB_Pos = 0xe
	// Bit mask of INVB field.
	TC_BMR_INVB_Msk = 0x4000
	// Bit INVB.
	TC_BMR_INVB = 0x4000
	// Position of INVIDX field.
	TC_BMR_INVIDX_Pos = 0xf
	// Bit mask of INVIDX field.
	TC_BMR_INVIDX_Msk = 0x8000
	// Bit INVIDX.
	TC_BMR_INVIDX = 0x8000
	// Position of SWAP field.
	TC_BMR_SWAP_Pos = 0x10
	// Bit mask of SWAP field.
	TC_BMR_SWAP_Msk = 0x10000
	// Bit SWAP.
	TC_BMR_SWAP = 0x10000
	// Position of IDXPHB field.
	TC_BMR_IDXPHB_Pos = 0x11
	// Bit mask of IDXPHB field.
	TC_BMR_IDXPHB_Msk = 0x20000
	// Bit IDXPHB.
	TC_BMR_IDXPHB = 0x20000
	// Position of FILTER field.
	TC_BMR_FILTER_Pos = 0x13
	// Bit mask of FILTER field.
	TC_BMR_FILTER_Msk = 0x80000
	// Bit FILTER.
	TC_BMR_FILTER = 0x80000
	// Position of MAXFILT field.
	TC_BMR_MAXFILT_Pos = 0x14
	// Bit mask of MAXFILT field.
	TC_BMR_MAXFILT_Msk = 0x3f00000

	// QIER: QDEC Interrupt Enable Register
	// Position of IDX field.
	TC_QIER_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIER_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIER_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIER_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIER_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIER_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIER_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIER_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIER_QERR = 0x4

	// QIDR: QDEC Interrupt Disable Register
	// Position of IDX field.
	TC_QIDR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIDR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIDR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIDR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIDR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIDR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIDR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIDR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIDR_QERR = 0x4

	// QIMR: QDEC Interrupt Mask Register
	// Position of IDX field.
	TC_QIMR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIMR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIMR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIMR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIMR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIMR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIMR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIMR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIMR_QERR = 0x4

	// QISR: QDEC Interrupt Status Register
	// Position of IDX field.
	TC_QISR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QISR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QISR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QISR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QISR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QISR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QISR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QISR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QISR_QERR = 0x4
	// Position of DIR field.
	TC_QISR_DIR_Pos = 0x8
	// Bit mask of DIR field.
	TC_QISR_DIR_Msk = 0x100
	// Bit DIR.
	TC_QISR_DIR = 0x100

	// FMR: Fault Mode Register
	// Position of ENCF0 field.
	TC_FMR_ENCF0_Pos = 0x0
	// Bit mask of ENCF0 field.
	TC_FMR_ENCF0_Msk = 0x1
	// Bit ENCF0.
	TC_FMR_ENCF0 = 0x1
	// Position of ENCF1 field.
	TC_FMR_ENCF1_Pos = 0x1
	// Bit mask of ENCF1 field.
	TC_FMR_ENCF1_Msk = 0x2
	// Bit ENCF1.
	TC_FMR_ENCF1 = 0x2

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	TC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	TC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	TC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	TC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	TC_WPMR_WPKEY_Msk = 0xffffff00
)

// Bitfields for TWI0: Two-wire Interface 0
const (
	// CR: Control Register
	// Position of START field.
	TWI_CR_START_Pos = 0x0
	// Bit mask of START field.
	TWI_CR_START_Msk = 0x1
	// Bit START.
	TWI_CR_START = 0x1
	// Position of STOP field.
	TWI_CR_STOP_Pos = 0x1
	// Bit mask of STOP field.
	TWI_CR_STOP_Msk = 0x2
	// Bit STOP.
	TWI_CR_STOP = 0x2
	// Position of MSEN field.
	TWI_CR_MSEN_Pos = 0x2
	// Bit mask of MSEN field.
	TWI_CR_MSEN_Msk = 0x4
	// Bit MSEN.
	TWI_CR_MSEN = 0x4
	// Position of MSDIS field.
	TWI_CR_MSDIS_Pos = 0x3
	// Bit mask of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8
	// Bit MSDIS.
	TWI_CR_MSDIS = 0x8
	// Position of SVEN field.
	TWI_CR_SVEN_Pos = 0x4
	// Bit mask of SVEN field.
	TWI_CR_SVEN_Msk = 0x10
	// Bit SVEN.
	TWI_CR_SVEN = 0x10
	// Position of SVDIS field.
	TWI_CR_SVDIS_Pos = 0x5
	// Bit mask of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20
	// Bit SVDIS.
	TWI_CR_SVDIS = 0x20
	// Position of QUICK field.
	TWI_CR_QUICK_Pos = 0x6
	// Bit mask of QUICK field.
	TWI_CR_QUICK_Msk = 0x40
	// Bit QUICK.
	TWI_CR_QUICK = 0x40
	// Position of SWRST field.
	TWI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	TWI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	TWI_CR_SWRST = 0x80

	// MMR: Master Mode Register
	// Position of IADRSZ field.
	TWI_MMR_IADRSZ_Pos = 0x8
	// Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_Msk = 0x300
	// No internal device address
	TWI_MMR_IADRSZ_NONE = 0x0
	// One-byte internal device address
	TWI_MMR_IADRSZ_1_BYTE = 0x1
	// Two-byte internal device address
	TWI_MMR_IADRSZ_2_BYTE = 0x2
	// Three-byte internal device address
	TWI_MMR_IADRSZ_3_BYTE = 0x3
	// Position of MREAD field.
	TWI_MMR_MREAD_Pos = 0xc
	// Bit mask of MREAD field.
	TWI_MMR_MREAD_Msk = 0x1000
	// Bit MREAD.
	TWI_MMR_MREAD = 0x1000
	// Position of DADR field.
	TWI_MMR_DADR_Pos = 0x10
	// Bit mask of DADR field.
	TWI_MMR_DADR_Msk = 0x7f0000

	// SMR: Slave Mode Register
	// Position of SADR field.
	TWI_SMR_SADR_Pos = 0x10
	// Bit mask of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000

	// IADR: Internal Address Register
	// Position of IADR field.
	TWI_IADR_IADR_Pos = 0x0
	// Bit mask of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff

	// CWGR: Clock Waveform Generator Register
	// Position of CLDIV field.
	TWI_CWGR_CLDIV_Pos = 0x0
	// Bit mask of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff
	// Position of CHDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8
	// Bit mask of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00
	// Position of CKDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10
	// Bit mask of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000

	// SR: Status Register
	// Position of TXCOMP field.
	TWI_SR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_SR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_SR_TXRDY = 0x4
	// Position of SVREAD field.
	TWI_SR_SVREAD_Pos = 0x3
	// Bit mask of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8
	// Bit SVREAD.
	TWI_SR_SVREAD = 0x8
	// Position of SVACC field.
	TWI_SR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_SR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_SR_SVACC = 0x10
	// Position of GACC field.
	TWI_SR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_SR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_SR_GACC = 0x20
	// Position of OVRE field.
	TWI_SR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_SR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_SR_OVRE = 0x40
	// Position of NACK field.
	TWI_SR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_SR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_SR_NACK = 0x100
	// Position of ARBLST field.
	TWI_SR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_SR_ARBLST = 0x200
	// Position of SCLWS field.
	TWI_SR_SCLWS_Pos = 0xa
	// Bit mask of SCLWS field.
	TWI_SR_SCLWS_Msk = 0x400
	// Bit SCLWS.
	TWI_SR_SCLWS = 0x400
	// Position of EOSACC field.
	TWI_SR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_SR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_SR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_SR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_SR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_SR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_SR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_SR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_SR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_SR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_SR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_SR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_SR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_SR_TXBUFE = 0x8000

	// IER: Interrupt Enable Register
	// Position of TXCOMP field.
	TWI_IER_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IER_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IER_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IER_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IER_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IER_SVACC = 0x10
	// Position of GACC field.
	TWI_IER_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IER_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IER_GACC = 0x20
	// Position of OVRE field.
	TWI_IER_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IER_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IER_OVRE = 0x40
	// Position of NACK field.
	TWI_IER_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IER_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IER_NACK = 0x100
	// Position of ARBLST field.
	TWI_IER_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IER_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IER_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IER_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IER_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IER_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IER_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IER_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IER_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IER_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IER_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IER_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IER_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IER_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IER_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IER_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IER_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IER_TXBUFE = 0x8000

	// IDR: Interrupt Disable Register
	// Position of TXCOMP field.
	TWI_IDR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IDR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IDR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IDR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IDR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IDR_SVACC = 0x10
	// Position of GACC field.
	TWI_IDR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IDR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IDR_GACC = 0x20
	// Position of OVRE field.
	TWI_IDR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IDR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IDR_OVRE = 0x40
	// Position of NACK field.
	TWI_IDR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IDR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IDR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IDR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IDR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IDR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IDR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IDR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IDR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IDR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IDR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IDR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IDR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IDR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IDR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IDR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IDR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IDR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IDR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IDR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IDR_TXBUFE = 0x8000

	// IMR: Interrupt Mask Register
	// Position of TXCOMP field.
	TWI_IMR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IMR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IMR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IMR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IMR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IMR_SVACC = 0x10
	// Position of GACC field.
	TWI_IMR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IMR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IMR_GACC = 0x20
	// Position of OVRE field.
	TWI_IMR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IMR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IMR_OVRE = 0x40
	// Position of NACK field.
	TWI_IMR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IMR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IMR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IMR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IMR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IMR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IMR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IMR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IMR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IMR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IMR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IMR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IMR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IMR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IMR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IMR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IMR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IMR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IMR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IMR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IMR_TXBUFE = 0x8000

	// RHR: Receive Holding Register
	// Position of RXDATA field.
	TWI_RHR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXDATA field.
	TWI_THR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	TWI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	TWI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	TWI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	TWI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	TWI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	TWI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	TWI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	TWI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	TWI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	TWI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	TWI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	TWI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	TWI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	TWI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	TWI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	TWI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	TWI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	TWI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	TWI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	TWI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	TWI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	TWI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	TWI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	TWI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	TWI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	TWI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	TWI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	TWI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	TWI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	TWI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	TWI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	TWI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	TWI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	TWI_PTSR_TXTEN = 0x100
)

// Bitfields for PWM: Pulse Width Modulation Controller
const (
	// CLK: PWM Clock Register
	// Position of DIVA field.
	PWM_CLK_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PWM_CLK_DIVA_Msk = 0xff
	// Position of PREA field.
	PWM_CLK_PREA_Pos = 0x8
	// Bit mask of PREA field.
	PWM_CLK_PREA_Msk = 0xf00
	// Position of DIVB field.
	PWM_CLK_DIVB_Pos = 0x10
	// Bit mask of DIVB field.
	PWM_CLK_DIVB_Msk = 0xff0000
	// Position of PREB field.
	PWM_CLK_PREB_Pos = 0x18
	// Bit mask of PREB field.
	PWM_CLK_PREB_Msk = 0xf000000

	// ENA: PWM Enable Register
	// Position of CHID0 field.
	PWM_ENA_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ENA_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ENA_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ENA_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ENA_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ENA_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ENA_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ENA_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ENA_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ENA_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ENA_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ENA_CHID3 = 0x8

	// DIS: PWM Disable Register
	// Position of CHID0 field.
	PWM_DIS_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_DIS_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_DIS_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_DIS_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_DIS_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_DIS_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_DIS_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_DIS_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_DIS_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_DIS_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_DIS_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_DIS_CHID3 = 0x8

	// SR: PWM Status Register
	// Position of CHID0 field.
	PWM_SR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_SR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_SR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_SR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_SR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_SR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_SR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_SR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_SR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_SR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_SR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_SR_CHID3 = 0x8

	// IER1: PWM Interrupt Enable Register 1
	// Position of CHID0 field.
	PWM_IER1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IER1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IER1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IER1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IER1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IER1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IER1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IER1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IER1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IER1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IER1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IER1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_IER1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IER1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IER1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IER1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IER1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IER1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IER1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IER1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IER1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IER1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IER1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IER1_FCHID3 = 0x80000

	// IDR1: PWM Interrupt Disable Register 1
	// Position of CHID0 field.
	PWM_IDR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IDR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IDR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IDR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IDR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IDR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IDR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IDR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IDR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IDR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IDR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IDR1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_IDR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IDR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IDR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IDR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IDR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IDR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IDR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IDR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IDR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IDR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IDR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IDR1_FCHID3 = 0x80000

	// IMR1: PWM Interrupt Mask Register 1
	// Position of CHID0 field.
	PWM_IMR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IMR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IMR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IMR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IMR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IMR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IMR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IMR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IMR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IMR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IMR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IMR1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_IMR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IMR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IMR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IMR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IMR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IMR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IMR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IMR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IMR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IMR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IMR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IMR1_FCHID3 = 0x80000

	// ISR1: PWM Interrupt Status Register 1
	// Position of CHID0 field.
	PWM_ISR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ISR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ISR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ISR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ISR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ISR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ISR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ISR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ISR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ISR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ISR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ISR1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_ISR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_ISR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_ISR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_ISR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_ISR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_ISR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_ISR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_ISR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_ISR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_ISR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_ISR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_ISR1_FCHID3 = 0x80000

	// SCM: PWM Sync Channels Mode Register
	// Position of SYNC0 field.
	PWM_SCM_SYNC0_Pos = 0x0
	// Bit mask of SYNC0 field.
	PWM_SCM_SYNC0_Msk = 0x1
	// Bit SYNC0.
	PWM_SCM_SYNC0 = 0x1
	// Position of SYNC1 field.
	PWM_SCM_SYNC1_Pos = 0x1
	// Bit mask of SYNC1 field.
	PWM_SCM_SYNC1_Msk = 0x2
	// Bit SYNC1.
	PWM_SCM_SYNC1 = 0x2
	// Position of SYNC2 field.
	PWM_SCM_SYNC2_Pos = 0x2
	// Bit mask of SYNC2 field.
	PWM_SCM_SYNC2_Msk = 0x4
	// Bit SYNC2.
	PWM_SCM_SYNC2 = 0x4
	// Position of SYNC3 field.
	PWM_SCM_SYNC3_Pos = 0x3
	// Bit mask of SYNC3 field.
	PWM_SCM_SYNC3_Msk = 0x8
	// Bit SYNC3.
	PWM_SCM_SYNC3 = 0x8
	// Position of UPDM field.
	PWM_SCM_UPDM_Pos = 0x10
	// Bit mask of UPDM field.
	PWM_SCM_UPDM_Msk = 0x30000
	// Manual write of double buffer registers and manual update of synchronous channels
	PWM_SCM_UPDM_MODE0 = 0x0
	// Manual write of double buffer registers and automatic update of synchronous channels
	PWM_SCM_UPDM_MODE1 = 0x1
	// Automatic write of duty-cycle update registers by the PDC and automatic update of synchronous channels
	PWM_SCM_UPDM_MODE2 = 0x2
	// Position of PTRM field.
	PWM_SCM_PTRM_Pos = 0x14
	// Bit mask of PTRM field.
	PWM_SCM_PTRM_Msk = 0x100000
	// Bit PTRM.
	PWM_SCM_PTRM = 0x100000
	// Position of PTRCS field.
	PWM_SCM_PTRCS_Pos = 0x15
	// Bit mask of PTRCS field.
	PWM_SCM_PTRCS_Msk = 0xe00000

	// SCUC: PWM Sync Channels Update Control Register
	// Position of UPDULOCK field.
	PWM_SCUC_UPDULOCK_Pos = 0x0
	// Bit mask of UPDULOCK field.
	PWM_SCUC_UPDULOCK_Msk = 0x1
	// Bit UPDULOCK.
	PWM_SCUC_UPDULOCK = 0x1

	// SCUP: PWM Sync Channels Update Period Register
	// Position of UPR field.
	PWM_SCUP_UPR_Pos = 0x0
	// Bit mask of UPR field.
	PWM_SCUP_UPR_Msk = 0xf
	// Position of UPRCNT field.
	PWM_SCUP_UPRCNT_Pos = 0x4
	// Bit mask of UPRCNT field.
	PWM_SCUP_UPRCNT_Msk = 0xf0

	// SCUPUPD: PWM Sync Channels Update Period Update Register
	// Position of UPRUPD field.
	PWM_SCUPUPD_UPRUPD_Pos = 0x0
	// Bit mask of UPRUPD field.
	PWM_SCUPUPD_UPRUPD_Msk = 0xf

	// IER2: PWM Interrupt Enable Register 2
	// Position of WRDY field.
	PWM_IER2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IER2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IER2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_IER2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_IER2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_IER2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_IER2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_IER2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_IER2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_IER2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IER2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IER2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IER2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IER2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IER2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IER2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IER2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IER2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IER2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IER2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IER2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IER2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IER2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IER2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IER2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IER2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IER2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IER2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IER2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IER2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IER2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IER2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IER2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IER2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IER2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IER2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IER2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IER2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IER2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IER2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IER2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IER2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IER2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IER2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IER2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IER2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IER2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IER2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IER2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IER2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IER2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IER2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IER2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IER2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IER2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IER2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IER2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IER2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IER2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IER2_CMPU7 = 0x800000

	// IDR2: PWM Interrupt Disable Register 2
	// Position of WRDY field.
	PWM_IDR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IDR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IDR2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_IDR2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_IDR2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_IDR2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_IDR2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_IDR2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_IDR2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_IDR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IDR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IDR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IDR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IDR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IDR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IDR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IDR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IDR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IDR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IDR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IDR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IDR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IDR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IDR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IDR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IDR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IDR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IDR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IDR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IDR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IDR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IDR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IDR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IDR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IDR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IDR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IDR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IDR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IDR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IDR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IDR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IDR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IDR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IDR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IDR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IDR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IDR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IDR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IDR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IDR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IDR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IDR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IDR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IDR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IDR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IDR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IDR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IDR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IDR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IDR2_CMPU7 = 0x800000

	// IMR2: PWM Interrupt Mask Register 2
	// Position of WRDY field.
	PWM_IMR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IMR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IMR2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_IMR2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_IMR2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_IMR2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_IMR2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_IMR2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_IMR2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_IMR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IMR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IMR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IMR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IMR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IMR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IMR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IMR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IMR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IMR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IMR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IMR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IMR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IMR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IMR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IMR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IMR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IMR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IMR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IMR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IMR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IMR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IMR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IMR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IMR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IMR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IMR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IMR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IMR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IMR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IMR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IMR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IMR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IMR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IMR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IMR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IMR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IMR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IMR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IMR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IMR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IMR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IMR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IMR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IMR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IMR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IMR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IMR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IMR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IMR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IMR2_CMPU7 = 0x800000

	// ISR2: PWM Interrupt Status Register 2
	// Position of WRDY field.
	PWM_ISR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_ISR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_ISR2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_ISR2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_ISR2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_ISR2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_ISR2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_ISR2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_ISR2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_ISR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_ISR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_ISR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_ISR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_ISR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_ISR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_ISR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_ISR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_ISR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_ISR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_ISR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_ISR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_ISR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_ISR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_ISR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_ISR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_ISR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_ISR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_ISR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_ISR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_ISR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_ISR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_ISR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_ISR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_ISR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_ISR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_ISR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_ISR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_ISR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_ISR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_ISR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_ISR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_ISR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_ISR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_ISR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_ISR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_ISR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_ISR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_ISR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_ISR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_ISR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_ISR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_ISR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_ISR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_ISR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_ISR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_ISR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_ISR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_ISR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_ISR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_ISR2_CMPU7 = 0x800000

	// OOV: PWM Output Override Value Register
	// Position of OOVH0 field.
	PWM_OOV_OOVH0_Pos = 0x0
	// Bit mask of OOVH0 field.
	PWM_OOV_OOVH0_Msk = 0x1
	// Bit OOVH0.
	PWM_OOV_OOVH0 = 0x1
	// Position of OOVH1 field.
	PWM_OOV_OOVH1_Pos = 0x1
	// Bit mask of OOVH1 field.
	PWM_OOV_OOVH1_Msk = 0x2
	// Bit OOVH1.
	PWM_OOV_OOVH1 = 0x2
	// Position of OOVH2 field.
	PWM_OOV_OOVH2_Pos = 0x2
	// Bit mask of OOVH2 field.
	PWM_OOV_OOVH2_Msk = 0x4
	// Bit OOVH2.
	PWM_OOV_OOVH2 = 0x4
	// Position of OOVH3 field.
	PWM_OOV_OOVH3_Pos = 0x3
	// Bit mask of OOVH3 field.
	PWM_OOV_OOVH3_Msk = 0x8
	// Bit OOVH3.
	PWM_OOV_OOVH3 = 0x8
	// Position of OOVL0 field.
	PWM_OOV_OOVL0_Pos = 0x10
	// Bit mask of OOVL0 field.
	PWM_OOV_OOVL0_Msk = 0x10000
	// Bit OOVL0.
	PWM_OOV_OOVL0 = 0x10000
	// Position of OOVL1 field.
	PWM_OOV_OOVL1_Pos = 0x11
	// Bit mask of OOVL1 field.
	PWM_OOV_OOVL1_Msk = 0x20000
	// Bit OOVL1.
	PWM_OOV_OOVL1 = 0x20000
	// Position of OOVL2 field.
	PWM_OOV_OOVL2_Pos = 0x12
	// Bit mask of OOVL2 field.
	PWM_OOV_OOVL2_Msk = 0x40000
	// Bit OOVL2.
	PWM_OOV_OOVL2 = 0x40000
	// Position of OOVL3 field.
	PWM_OOV_OOVL3_Pos = 0x13
	// Bit mask of OOVL3 field.
	PWM_OOV_OOVL3_Msk = 0x80000
	// Bit OOVL3.
	PWM_OOV_OOVL3 = 0x80000

	// OS: PWM Output Selection Register
	// Position of OSH0 field.
	PWM_OS_OSH0_Pos = 0x0
	// Bit mask of OSH0 field.
	PWM_OS_OSH0_Msk = 0x1
	// Bit OSH0.
	PWM_OS_OSH0 = 0x1
	// Position of OSH1 field.
	PWM_OS_OSH1_Pos = 0x1
	// Bit mask of OSH1 field.
	PWM_OS_OSH1_Msk = 0x2
	// Bit OSH1.
	PWM_OS_OSH1 = 0x2
	// Position of OSH2 field.
	PWM_OS_OSH2_Pos = 0x2
	// Bit mask of OSH2 field.
	PWM_OS_OSH2_Msk = 0x4
	// Bit OSH2.
	PWM_OS_OSH2 = 0x4
	// Position of OSH3 field.
	PWM_OS_OSH3_Pos = 0x3
	// Bit mask of OSH3 field.
	PWM_OS_OSH3_Msk = 0x8
	// Bit OSH3.
	PWM_OS_OSH3 = 0x8
	// Position of OSL0 field.
	PWM_OS_OSL0_Pos = 0x10
	// Bit mask of OSL0 field.
	PWM_OS_OSL0_Msk = 0x10000
	// Bit OSL0.
	PWM_OS_OSL0 = 0x10000
	// Position of OSL1 field.
	PWM_OS_OSL1_Pos = 0x11
	// Bit mask of OSL1 field.
	PWM_OS_OSL1_Msk = 0x20000
	// Bit OSL1.
	PWM_OS_OSL1 = 0x20000
	// Position of OSL2 field.
	PWM_OS_OSL2_Pos = 0x12
	// Bit mask of OSL2 field.
	PWM_OS_OSL2_Msk = 0x40000
	// Bit OSL2.
	PWM_OS_OSL2 = 0x40000
	// Position of OSL3 field.
	PWM_OS_OSL3_Pos = 0x13
	// Bit mask of OSL3 field.
	PWM_OS_OSL3_Msk = 0x80000
	// Bit OSL3.
	PWM_OS_OSL3 = 0x80000

	// OSS: PWM Output Selection Set Register
	// Position of OSSH0 field.
	PWM_OSS_OSSH0_Pos = 0x0
	// Bit mask of OSSH0 field.
	PWM_OSS_OSSH0_Msk = 0x1
	// Bit OSSH0.
	PWM_OSS_OSSH0 = 0x1
	// Position of OSSH1 field.
	PWM_OSS_OSSH1_Pos = 0x1
	// Bit mask of OSSH1 field.
	PWM_OSS_OSSH1_Msk = 0x2
	// Bit OSSH1.
	PWM_OSS_OSSH1 = 0x2
	// Position of OSSH2 field.
	PWM_OSS_OSSH2_Pos = 0x2
	// Bit mask of OSSH2 field.
	PWM_OSS_OSSH2_Msk = 0x4
	// Bit OSSH2.
	PWM_OSS_OSSH2 = 0x4
	// Position of OSSH3 field.
	PWM_OSS_OSSH3_Pos = 0x3
	// Bit mask of OSSH3 field.
	PWM_OSS_OSSH3_Msk = 0x8
	// Bit OSSH3.
	PWM_OSS_OSSH3 = 0x8
	// Position of OSSL0 field.
	PWM_OSS_OSSL0_Pos = 0x10
	// Bit mask of OSSL0 field.
	PWM_OSS_OSSL0_Msk = 0x10000
	// Bit OSSL0.
	PWM_OSS_OSSL0 = 0x10000
	// Position of OSSL1 field.
	PWM_OSS_OSSL1_Pos = 0x11
	// Bit mask of OSSL1 field.
	PWM_OSS_OSSL1_Msk = 0x20000
	// Bit OSSL1.
	PWM_OSS_OSSL1 = 0x20000
	// Position of OSSL2 field.
	PWM_OSS_OSSL2_Pos = 0x12
	// Bit mask of OSSL2 field.
	PWM_OSS_OSSL2_Msk = 0x40000
	// Bit OSSL2.
	PWM_OSS_OSSL2 = 0x40000
	// Position of OSSL3 field.
	PWM_OSS_OSSL3_Pos = 0x13
	// Bit mask of OSSL3 field.
	PWM_OSS_OSSL3_Msk = 0x80000
	// Bit OSSL3.
	PWM_OSS_OSSL3 = 0x80000

	// OSC: PWM Output Selection Clear Register
	// Position of OSCH0 field.
	PWM_OSC_OSCH0_Pos = 0x0
	// Bit mask of OSCH0 field.
	PWM_OSC_OSCH0_Msk = 0x1
	// Bit OSCH0.
	PWM_OSC_OSCH0 = 0x1
	// Position of OSCH1 field.
	PWM_OSC_OSCH1_Pos = 0x1
	// Bit mask of OSCH1 field.
	PWM_OSC_OSCH1_Msk = 0x2
	// Bit OSCH1.
	PWM_OSC_OSCH1 = 0x2
	// Position of OSCH2 field.
	PWM_OSC_OSCH2_Pos = 0x2
	// Bit mask of OSCH2 field.
	PWM_OSC_OSCH2_Msk = 0x4
	// Bit OSCH2.
	PWM_OSC_OSCH2 = 0x4
	// Position of OSCH3 field.
	PWM_OSC_OSCH3_Pos = 0x3
	// Bit mask of OSCH3 field.
	PWM_OSC_OSCH3_Msk = 0x8
	// Bit OSCH3.
	PWM_OSC_OSCH3 = 0x8
	// Position of OSCL0 field.
	PWM_OSC_OSCL0_Pos = 0x10
	// Bit mask of OSCL0 field.
	PWM_OSC_OSCL0_Msk = 0x10000
	// Bit OSCL0.
	PWM_OSC_OSCL0 = 0x10000
	// Position of OSCL1 field.
	PWM_OSC_OSCL1_Pos = 0x11
	// Bit mask of OSCL1 field.
	PWM_OSC_OSCL1_Msk = 0x20000
	// Bit OSCL1.
	PWM_OSC_OSCL1 = 0x20000
	// Position of OSCL2 field.
	PWM_OSC_OSCL2_Pos = 0x12
	// Bit mask of OSCL2 field.
	PWM_OSC_OSCL2_Msk = 0x40000
	// Bit OSCL2.
	PWM_OSC_OSCL2 = 0x40000
	// Position of OSCL3 field.
	PWM_OSC_OSCL3_Pos = 0x13
	// Bit mask of OSCL3 field.
	PWM_OSC_OSCL3_Msk = 0x80000
	// Bit OSCL3.
	PWM_OSC_OSCL3 = 0x80000

	// OSSUPD: PWM Output Selection Set Update Register
	// Position of OSSUPH0 field.
	PWM_OSSUPD_OSSUPH0_Pos = 0x0
	// Bit mask of OSSUPH0 field.
	PWM_OSSUPD_OSSUPH0_Msk = 0x1
	// Bit OSSUPH0.
	PWM_OSSUPD_OSSUPH0 = 0x1
	// Position of OSSUPH1 field.
	PWM_OSSUPD_OSSUPH1_Pos = 0x1
	// Bit mask of OSSUPH1 field.
	PWM_OSSUPD_OSSUPH1_Msk = 0x2
	// Bit OSSUPH1.
	PWM_OSSUPD_OSSUPH1 = 0x2
	// Position of OSSUPH2 field.
	PWM_OSSUPD_OSSUPH2_Pos = 0x2
	// Bit mask of OSSUPH2 field.
	PWM_OSSUPD_OSSUPH2_Msk = 0x4
	// Bit OSSUPH2.
	PWM_OSSUPD_OSSUPH2 = 0x4
	// Position of OSSUPH3 field.
	PWM_OSSUPD_OSSUPH3_Pos = 0x3
	// Bit mask of OSSUPH3 field.
	PWM_OSSUPD_OSSUPH3_Msk = 0x8
	// Bit OSSUPH3.
	PWM_OSSUPD_OSSUPH3 = 0x8
	// Position of OSSUPL0 field.
	PWM_OSSUPD_OSSUPL0_Pos = 0x10
	// Bit mask of OSSUPL0 field.
	PWM_OSSUPD_OSSUPL0_Msk = 0x10000
	// Bit OSSUPL0.
	PWM_OSSUPD_OSSUPL0 = 0x10000
	// Position of OSSUPL1 field.
	PWM_OSSUPD_OSSUPL1_Pos = 0x11
	// Bit mask of OSSUPL1 field.
	PWM_OSSUPD_OSSUPL1_Msk = 0x20000
	// Bit OSSUPL1.
	PWM_OSSUPD_OSSUPL1 = 0x20000
	// Position of OSSUPL2 field.
	PWM_OSSUPD_OSSUPL2_Pos = 0x12
	// Bit mask of OSSUPL2 field.
	PWM_OSSUPD_OSSUPL2_Msk = 0x40000
	// Bit OSSUPL2.
	PWM_OSSUPD_OSSUPL2 = 0x40000
	// Position of OSSUPL3 field.
	PWM_OSSUPD_OSSUPL3_Pos = 0x13
	// Bit mask of OSSUPL3 field.
	PWM_OSSUPD_OSSUPL3_Msk = 0x80000
	// Bit OSSUPL3.
	PWM_OSSUPD_OSSUPL3 = 0x80000

	// OSCUPD: PWM Output Selection Clear Update Register
	// Position of OSCUPH0 field.
	PWM_OSCUPD_OSCUPH0_Pos = 0x0
	// Bit mask of OSCUPH0 field.
	PWM_OSCUPD_OSCUPH0_Msk = 0x1
	// Bit OSCUPH0.
	PWM_OSCUPD_OSCUPH0 = 0x1
	// Position of OSCUPH1 field.
	PWM_OSCUPD_OSCUPH1_Pos = 0x1
	// Bit mask of OSCUPH1 field.
	PWM_OSCUPD_OSCUPH1_Msk = 0x2
	// Bit OSCUPH1.
	PWM_OSCUPD_OSCUPH1 = 0x2
	// Position of OSCUPH2 field.
	PWM_OSCUPD_OSCUPH2_Pos = 0x2
	// Bit mask of OSCUPH2 field.
	PWM_OSCUPD_OSCUPH2_Msk = 0x4
	// Bit OSCUPH2.
	PWM_OSCUPD_OSCUPH2 = 0x4
	// Position of OSCUPH3 field.
	PWM_OSCUPD_OSCUPH3_Pos = 0x3
	// Bit mask of OSCUPH3 field.
	PWM_OSCUPD_OSCUPH3_Msk = 0x8
	// Bit OSCUPH3.
	PWM_OSCUPD_OSCUPH3 = 0x8
	// Position of OSCUPL0 field.
	PWM_OSCUPD_OSCUPL0_Pos = 0x10
	// Bit mask of OSCUPL0 field.
	PWM_OSCUPD_OSCUPL0_Msk = 0x10000
	// Bit OSCUPL0.
	PWM_OSCUPD_OSCUPL0 = 0x10000
	// Position of OSCUPL1 field.
	PWM_OSCUPD_OSCUPL1_Pos = 0x11
	// Bit mask of OSCUPL1 field.
	PWM_OSCUPD_OSCUPL1_Msk = 0x20000
	// Bit OSCUPL1.
	PWM_OSCUPD_OSCUPL1 = 0x20000
	// Position of OSCUPL2 field.
	PWM_OSCUPD_OSCUPL2_Pos = 0x12
	// Bit mask of OSCUPL2 field.
	PWM_OSCUPD_OSCUPL2_Msk = 0x40000
	// Bit OSCUPL2.
	PWM_OSCUPD_OSCUPL2 = 0x40000
	// Position of OSCUPL3 field.
	PWM_OSCUPD_OSCUPL3_Pos = 0x13
	// Bit mask of OSCUPL3 field.
	PWM_OSCUPD_OSCUPL3_Msk = 0x80000
	// Bit OSCUPL3.
	PWM_OSCUPD_OSCUPL3 = 0x80000

	// FMR: PWM Fault Mode Register
	// Position of FPOL field.
	PWM_FMR_FPOL_Pos = 0x0
	// Bit mask of FPOL field.
	PWM_FMR_FPOL_Msk = 0xff
	// Position of FMOD field.
	PWM_FMR_FMOD_Pos = 0x8
	// Bit mask of FMOD field.
	PWM_FMR_FMOD_Msk = 0xff00
	// Position of FFIL field.
	PWM_FMR_FFIL_Pos = 0x10
	// Bit mask of FFIL field.
	PWM_FMR_FFIL_Msk = 0xff0000

	// FSR: PWM Fault Status Register
	// Position of FIV field.
	PWM_FSR_FIV_Pos = 0x0
	// Bit mask of FIV field.
	PWM_FSR_FIV_Msk = 0xff
	// Position of FS field.
	PWM_FSR_FS_Pos = 0x8
	// Bit mask of FS field.
	PWM_FSR_FS_Msk = 0xff00

	// FCR: PWM Fault Clear Register
	// Position of FCLR field.
	PWM_FCR_FCLR_Pos = 0x0
	// Bit mask of FCLR field.
	PWM_FCR_FCLR_Msk = 0xff

	// FPV: PWM Fault Protection Value Register
	// Position of FPVH0 field.
	PWM_FPV_FPVH0_Pos = 0x0
	// Bit mask of FPVH0 field.
	PWM_FPV_FPVH0_Msk = 0x1
	// Bit FPVH0.
	PWM_FPV_FPVH0 = 0x1
	// Position of FPVH1 field.
	PWM_FPV_FPVH1_Pos = 0x1
	// Bit mask of FPVH1 field.
	PWM_FPV_FPVH1_Msk = 0x2
	// Bit FPVH1.
	PWM_FPV_FPVH1 = 0x2
	// Position of FPVH2 field.
	PWM_FPV_FPVH2_Pos = 0x2
	// Bit mask of FPVH2 field.
	PWM_FPV_FPVH2_Msk = 0x4
	// Bit FPVH2.
	PWM_FPV_FPVH2 = 0x4
	// Position of FPVH3 field.
	PWM_FPV_FPVH3_Pos = 0x3
	// Bit mask of FPVH3 field.
	PWM_FPV_FPVH3_Msk = 0x8
	// Bit FPVH3.
	PWM_FPV_FPVH3 = 0x8
	// Position of FPVL0 field.
	PWM_FPV_FPVL0_Pos = 0x10
	// Bit mask of FPVL0 field.
	PWM_FPV_FPVL0_Msk = 0x10000
	// Bit FPVL0.
	PWM_FPV_FPVL0 = 0x10000
	// Position of FPVL1 field.
	PWM_FPV_FPVL1_Pos = 0x11
	// Bit mask of FPVL1 field.
	PWM_FPV_FPVL1_Msk = 0x20000
	// Bit FPVL1.
	PWM_FPV_FPVL1 = 0x20000
	// Position of FPVL2 field.
	PWM_FPV_FPVL2_Pos = 0x12
	// Bit mask of FPVL2 field.
	PWM_FPV_FPVL2_Msk = 0x40000
	// Bit FPVL2.
	PWM_FPV_FPVL2 = 0x40000
	// Position of FPVL3 field.
	PWM_FPV_FPVL3_Pos = 0x13
	// Bit mask of FPVL3 field.
	PWM_FPV_FPVL3_Msk = 0x80000
	// Bit FPVL3.
	PWM_FPV_FPVL3 = 0x80000

	// FPE: PWM Fault Protection Enable Register
	// Position of FPE0 field.
	PWM_FPE_FPE0_Pos = 0x0
	// Bit mask of FPE0 field.
	PWM_FPE_FPE0_Msk = 0xff
	// Position of FPE1 field.
	PWM_FPE_FPE1_Pos = 0x8
	// Bit mask of FPE1 field.
	PWM_FPE_FPE1_Msk = 0xff00
	// Position of FPE2 field.
	PWM_FPE_FPE2_Pos = 0x10
	// Bit mask of FPE2 field.
	PWM_FPE_FPE2_Msk = 0xff0000
	// Position of FPE3 field.
	PWM_FPE_FPE3_Pos = 0x18
	// Bit mask of FPE3 field.
	PWM_FPE_FPE3_Msk = 0xff000000

	// ELMR: PWM Event Line 0 Mode Register
	// Position of CSEL0 field.
	PWM_ELMR_CSEL0_Pos = 0x0
	// Bit mask of CSEL0 field.
	PWM_ELMR_CSEL0_Msk = 0x1
	// Bit CSEL0.
	PWM_ELMR_CSEL0 = 0x1
	// Position of CSEL1 field.
	PWM_ELMR_CSEL1_Pos = 0x1
	// Bit mask of CSEL1 field.
	PWM_ELMR_CSEL1_Msk = 0x2
	// Bit CSEL1.
	PWM_ELMR_CSEL1 = 0x2
	// Position of CSEL2 field.
	PWM_ELMR_CSEL2_Pos = 0x2
	// Bit mask of CSEL2 field.
	PWM_ELMR_CSEL2_Msk = 0x4
	// Bit CSEL2.
	PWM_ELMR_CSEL2 = 0x4
	// Position of CSEL3 field.
	PWM_ELMR_CSEL3_Pos = 0x3
	// Bit mask of CSEL3 field.
	PWM_ELMR_CSEL3_Msk = 0x8
	// Bit CSEL3.
	PWM_ELMR_CSEL3 = 0x8
	// Position of CSEL4 field.
	PWM_ELMR_CSEL4_Pos = 0x4
	// Bit mask of CSEL4 field.
	PWM_ELMR_CSEL4_Msk = 0x10
	// Bit CSEL4.
	PWM_ELMR_CSEL4 = 0x10
	// Position of CSEL5 field.
	PWM_ELMR_CSEL5_Pos = 0x5
	// Bit mask of CSEL5 field.
	PWM_ELMR_CSEL5_Msk = 0x20
	// Bit CSEL5.
	PWM_ELMR_CSEL5 = 0x20
	// Position of CSEL6 field.
	PWM_ELMR_CSEL6_Pos = 0x6
	// Bit mask of CSEL6 field.
	PWM_ELMR_CSEL6_Msk = 0x40
	// Bit CSEL6.
	PWM_ELMR_CSEL6 = 0x40
	// Position of CSEL7 field.
	PWM_ELMR_CSEL7_Pos = 0x7
	// Bit mask of CSEL7 field.
	PWM_ELMR_CSEL7_Msk = 0x80
	// Bit CSEL7.
	PWM_ELMR_CSEL7 = 0x80

	// WPCR: PWM Write Protect Control Register
	// Position of WPCMD field.
	PWM_WPCR_WPCMD_Pos = 0x0
	// Bit mask of WPCMD field.
	PWM_WPCR_WPCMD_Msk = 0x3
	// Position of WPRG0 field.
	PWM_WPCR_WPRG0_Pos = 0x2
	// Bit mask of WPRG0 field.
	PWM_WPCR_WPRG0_Msk = 0x4
	// Bit WPRG0.
	PWM_WPCR_WPRG0 = 0x4
	// Position of WPRG1 field.
	PWM_WPCR_WPRG1_Pos = 0x3
	// Bit mask of WPRG1 field.
	PWM_WPCR_WPRG1_Msk = 0x8
	// Bit WPRG1.
	PWM_WPCR_WPRG1 = 0x8
	// Position of WPRG2 field.
	PWM_WPCR_WPRG2_Pos = 0x4
	// Bit mask of WPRG2 field.
	PWM_WPCR_WPRG2_Msk = 0x10
	// Bit WPRG2.
	PWM_WPCR_WPRG2 = 0x10
	// Position of WPRG3 field.
	PWM_WPCR_WPRG3_Pos = 0x5
	// Bit mask of WPRG3 field.
	PWM_WPCR_WPRG3_Msk = 0x20
	// Bit WPRG3.
	PWM_WPCR_WPRG3 = 0x20
	// Position of WPRG4 field.
	PWM_WPCR_WPRG4_Pos = 0x6
	// Bit mask of WPRG4 field.
	PWM_WPCR_WPRG4_Msk = 0x40
	// Bit WPRG4.
	PWM_WPCR_WPRG4 = 0x40
	// Position of WPRG5 field.
	PWM_WPCR_WPRG5_Pos = 0x7
	// Bit mask of WPRG5 field.
	PWM_WPCR_WPRG5_Msk = 0x80
	// Bit WPRG5.
	PWM_WPCR_WPRG5 = 0x80
	// Position of WPKEY field.
	PWM_WPCR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PWM_WPCR_WPKEY_Msk = 0xffffff00

	// WPSR: PWM Write Protect Status Register
	// Position of WPSWS0 field.
	PWM_WPSR_WPSWS0_Pos = 0x0
	// Bit mask of WPSWS0 field.
	PWM_WPSR_WPSWS0_Msk = 0x1
	// Bit WPSWS0.
	PWM_WPSR_WPSWS0 = 0x1
	// Position of WPSWS1 field.
	PWM_WPSR_WPSWS1_Pos = 0x1
	// Bit mask of WPSWS1 field.
	PWM_WPSR_WPSWS1_Msk = 0x2
	// Bit WPSWS1.
	PWM_WPSR_WPSWS1 = 0x2
	// Position of WPSWS2 field.
	PWM_WPSR_WPSWS2_Pos = 0x2
	// Bit mask of WPSWS2 field.
	PWM_WPSR_WPSWS2_Msk = 0x4
	// Bit WPSWS2.
	PWM_WPSR_WPSWS2 = 0x4
	// Position of WPSWS3 field.
	PWM_WPSR_WPSWS3_Pos = 0x3
	// Bit mask of WPSWS3 field.
	PWM_WPSR_WPSWS3_Msk = 0x8
	// Bit WPSWS3.
	PWM_WPSR_WPSWS3 = 0x8
	// Position of WPSWS4 field.
	PWM_WPSR_WPSWS4_Pos = 0x4
	// Bit mask of WPSWS4 field.
	PWM_WPSR_WPSWS4_Msk = 0x10
	// Bit WPSWS4.
	PWM_WPSR_WPSWS4 = 0x10
	// Position of WPSWS5 field.
	PWM_WPSR_WPSWS5_Pos = 0x5
	// Bit mask of WPSWS5 field.
	PWM_WPSR_WPSWS5_Msk = 0x20
	// Bit WPSWS5.
	PWM_WPSR_WPSWS5 = 0x20
	// Position of WPVS field.
	PWM_WPSR_WPVS_Pos = 0x7
	// Bit mask of WPVS field.
	PWM_WPSR_WPVS_Msk = 0x80
	// Bit WPVS.
	PWM_WPSR_WPVS = 0x80
	// Position of WPHWS0 field.
	PWM_WPSR_WPHWS0_Pos = 0x8
	// Bit mask of WPHWS0 field.
	PWM_WPSR_WPHWS0_Msk = 0x100
	// Bit WPHWS0.
	PWM_WPSR_WPHWS0 = 0x100
	// Position of WPHWS1 field.
	PWM_WPSR_WPHWS1_Pos = 0x9
	// Bit mask of WPHWS1 field.
	PWM_WPSR_WPHWS1_Msk = 0x200
	// Bit WPHWS1.
	PWM_WPSR_WPHWS1 = 0x200
	// Position of WPHWS2 field.
	PWM_WPSR_WPHWS2_Pos = 0xa
	// Bit mask of WPHWS2 field.
	PWM_WPSR_WPHWS2_Msk = 0x400
	// Bit WPHWS2.
	PWM_WPSR_WPHWS2 = 0x400
	// Position of WPHWS3 field.
	PWM_WPSR_WPHWS3_Pos = 0xb
	// Bit mask of WPHWS3 field.
	PWM_WPSR_WPHWS3_Msk = 0x800
	// Bit WPHWS3.
	PWM_WPSR_WPHWS3 = 0x800
	// Position of WPHWS4 field.
	PWM_WPSR_WPHWS4_Pos = 0xc
	// Bit mask of WPHWS4 field.
	PWM_WPSR_WPHWS4_Msk = 0x1000
	// Bit WPHWS4.
	PWM_WPSR_WPHWS4 = 0x1000
	// Position of WPHWS5 field.
	PWM_WPSR_WPHWS5_Pos = 0xd
	// Bit mask of WPHWS5 field.
	PWM_WPSR_WPHWS5_Msk = 0x2000
	// Bit WPHWS5.
	PWM_WPSR_WPHWS5 = 0x2000
	// Position of WPVSRC field.
	PWM_WPSR_WPVSRC_Pos = 0x10
	// Bit mask of WPVSRC field.
	PWM_WPSR_WPVSRC_Msk = 0xffff0000

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	PWM_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	PWM_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	PWM_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	PWM_TCR_TXCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	PWM_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	PWM_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	PWM_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	PWM_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	PWM_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	PWM_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	PWM_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	PWM_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	PWM_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	PWM_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	PWM_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	PWM_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	PWM_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	PWM_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	PWM_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	PWM_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	PWM_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	PWM_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	PWM_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	PWM_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	PWM_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	PWM_PTSR_TXTEN = 0x100

	// CMPV0: PWM Comparison 0 Value Register
	// Position of CV field.
	PWM_CMPV0_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV0_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV0_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV0_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV0_CVM = 0x1000000

	// CMPVUPD0: PWM Comparison 0 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD0_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD0_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD0_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD0_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD0_CVMUPD = 0x1000000

	// CMPM0: PWM Comparison 0 Mode Register
	// Position of CEN field.
	PWM_CMPM0_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM0_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM0_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM0_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM0_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM0_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM0_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM0_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM0_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM0_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM0_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM0_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM0_CUPRCNT_Msk = 0xf00000

	// CMPMUPD0: PWM Comparison 0 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD0_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD0_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD0_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD0_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD0_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD0_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD0_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD0_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD0_CUPRUPD_Msk = 0xf0000

	// CMPV1: PWM Comparison 1 Value Register
	// Position of CV field.
	PWM_CMPV1_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV1_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV1_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV1_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV1_CVM = 0x1000000

	// CMPVUPD1: PWM Comparison 1 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD1_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD1_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD1_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD1_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD1_CVMUPD = 0x1000000

	// CMPM1: PWM Comparison 1 Mode Register
	// Position of CEN field.
	PWM_CMPM1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM1_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM1_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM1_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM1_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM1_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM1_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM1_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM1_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM1_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM1_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM1_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM1_CUPRCNT_Msk = 0xf00000

	// CMPMUPD1: PWM Comparison 1 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD1_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD1_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD1_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD1_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD1_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD1_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD1_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD1_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD1_CUPRUPD_Msk = 0xf0000

	// CMPV2: PWM Comparison 2 Value Register
	// Position of CV field.
	PWM_CMPV2_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV2_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV2_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV2_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV2_CVM = 0x1000000

	// CMPVUPD2: PWM Comparison 2 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD2_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD2_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD2_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD2_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD2_CVMUPD = 0x1000000

	// CMPM2: PWM Comparison 2 Mode Register
	// Position of CEN field.
	PWM_CMPM2_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM2_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM2_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM2_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM2_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM2_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM2_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM2_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM2_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM2_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM2_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM2_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM2_CUPRCNT_Msk = 0xf00000

	// CMPMUPD2: PWM Comparison 2 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD2_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD2_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD2_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD2_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD2_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD2_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD2_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD2_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD2_CUPRUPD_Msk = 0xf0000

	// CMPV3: PWM Comparison 3 Value Register
	// Position of CV field.
	PWM_CMPV3_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV3_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV3_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV3_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV3_CVM = 0x1000000

	// CMPVUPD3: PWM Comparison 3 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD3_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD3_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD3_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD3_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD3_CVMUPD = 0x1000000

	// CMPM3: PWM Comparison 3 Mode Register
	// Position of CEN field.
	PWM_CMPM3_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM3_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM3_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM3_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM3_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM3_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM3_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM3_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM3_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM3_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM3_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM3_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM3_CUPRCNT_Msk = 0xf00000

	// CMPMUPD3: PWM Comparison 3 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD3_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD3_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD3_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD3_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD3_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD3_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD3_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD3_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD3_CUPRUPD_Msk = 0xf0000

	// CMPV4: PWM Comparison 4 Value Register
	// Position of CV field.
	PWM_CMPV4_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV4_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV4_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV4_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV4_CVM = 0x1000000

	// CMPVUPD4: PWM Comparison 4 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD4_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD4_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD4_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD4_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD4_CVMUPD = 0x1000000

	// CMPM4: PWM Comparison 4 Mode Register
	// Position of CEN field.
	PWM_CMPM4_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM4_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM4_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM4_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM4_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM4_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM4_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM4_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM4_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM4_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM4_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM4_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM4_CUPRCNT_Msk = 0xf00000

	// CMPMUPD4: PWM Comparison 4 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD4_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD4_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD4_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD4_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD4_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD4_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD4_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD4_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD4_CUPRUPD_Msk = 0xf0000

	// CMPV5: PWM Comparison 5 Value Register
	// Position of CV field.
	PWM_CMPV5_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV5_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV5_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV5_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV5_CVM = 0x1000000

	// CMPVUPD5: PWM Comparison 5 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD5_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD5_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD5_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD5_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD5_CVMUPD = 0x1000000

	// CMPM5: PWM Comparison 5 Mode Register
	// Position of CEN field.
	PWM_CMPM5_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM5_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM5_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM5_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM5_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM5_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM5_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM5_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM5_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM5_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM5_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM5_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM5_CUPRCNT_Msk = 0xf00000

	// CMPMUPD5: PWM Comparison 5 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD5_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD5_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD5_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD5_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD5_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD5_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD5_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD5_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD5_CUPRUPD_Msk = 0xf0000

	// CMPV6: PWM Comparison 6 Value Register
	// Position of CV field.
	PWM_CMPV6_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV6_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV6_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV6_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV6_CVM = 0x1000000

	// CMPVUPD6: PWM Comparison 6 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD6_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD6_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD6_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD6_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD6_CVMUPD = 0x1000000

	// CMPM6: PWM Comparison 6 Mode Register
	// Position of CEN field.
	PWM_CMPM6_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM6_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM6_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM6_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM6_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM6_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM6_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM6_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM6_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM6_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM6_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM6_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM6_CUPRCNT_Msk = 0xf00000

	// CMPMUPD6: PWM Comparison 6 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD6_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD6_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD6_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD6_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD6_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD6_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD6_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD6_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD6_CUPRUPD_Msk = 0xf0000

	// CMPV7: PWM Comparison 7 Value Register
	// Position of CV field.
	PWM_CMPV7_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV7_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV7_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV7_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV7_CVM = 0x1000000

	// CMPVUPD7: PWM Comparison 7 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD7_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD7_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD7_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD7_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD7_CVMUPD = 0x1000000

	// CMPM7: PWM Comparison 7 Mode Register
	// Position of CEN field.
	PWM_CMPM7_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM7_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM7_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM7_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM7_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM7_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM7_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM7_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM7_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM7_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM7_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM7_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM7_CUPRCNT_Msk = 0xf00000

	// CMPMUPD7: PWM Comparison 7 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD7_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD7_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD7_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD7_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD7_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD7_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD7_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD7_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD7_CUPRUPD_Msk = 0xf0000

	// CMR0: PWM Channel Mode Register (ch_num = 0)
	// Position of CPRE field.
	PWM_CMR0_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR0_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR0_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR0_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR0_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR0_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR0_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR0_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR0_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR0_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR0_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR0_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR0_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR0_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR0_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR0_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR0_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR0_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR0_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR0_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR0_CPOL = 0x200
	// Position of CES field.
	PWM_CMR0_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR0_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR0_CES = 0x400
	// Position of DTE field.
	PWM_CMR0_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR0_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR0_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR0_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR0_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR0_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR0_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR0_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR0_DTLI = 0x40000

	// CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
	// Position of CDTY field.
	PWM_CDTY0_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY0_CDTY_Msk = 0xffffff

	// CDTYUPD0: PWM Channel Duty Cycle Update Register (ch_num = 0)
	// Position of CDTYUPD field.
	PWM_CDTYUPD0_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD0_CDTYUPD_Msk = 0xffffff

	// CPRD0: PWM Channel Period Register (ch_num = 0)
	// Position of CPRD field.
	PWM_CPRD0_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD0_CPRD_Msk = 0xffffff

	// CPRDUPD0: PWM Channel Period Update Register (ch_num = 0)
	// Position of CPRDUPD field.
	PWM_CPRDUPD0_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD0_CPRDUPD_Msk = 0xffffff

	// CCNT0: PWM Channel Counter Register (ch_num = 0)
	// Position of CNT field.
	PWM_CCNT0_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT0_CNT_Msk = 0xffffff

	// DT0: PWM Channel Dead Time Register (ch_num = 0)
	// Position of DTH field.
	PWM_DT0_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT0_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT0_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT0_DTL_Msk = 0xffff0000

	// DTUPD0: PWM Channel Dead Time Update Register (ch_num = 0)
	// Position of DTHUPD field.
	PWM_DTUPD0_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD0_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD0_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD0_DTLUPD_Msk = 0xffff0000

	// CMR1: PWM Channel Mode Register (ch_num = 1)
	// Position of CPRE field.
	PWM_CMR1_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR1_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR1_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR1_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR1_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR1_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR1_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR1_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR1_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR1_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR1_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR1_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR1_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR1_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR1_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR1_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR1_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR1_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR1_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR1_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR1_CPOL = 0x200
	// Position of CES field.
	PWM_CMR1_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR1_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR1_CES = 0x400
	// Position of DTE field.
	PWM_CMR1_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR1_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR1_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR1_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR1_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR1_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR1_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR1_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR1_DTLI = 0x40000

	// CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
	// Position of CDTY field.
	PWM_CDTY1_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY1_CDTY_Msk = 0xffffff

	// CDTYUPD1: PWM Channel Duty Cycle Update Register (ch_num = 1)
	// Position of CDTYUPD field.
	PWM_CDTYUPD1_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD1_CDTYUPD_Msk = 0xffffff

	// CPRD1: PWM Channel Period Register (ch_num = 1)
	// Position of CPRD field.
	PWM_CPRD1_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD1_CPRD_Msk = 0xffffff

	// CPRDUPD1: PWM Channel Period Update Register (ch_num = 1)
	// Position of CPRDUPD field.
	PWM_CPRDUPD1_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD1_CPRDUPD_Msk = 0xffffff

	// CCNT1: PWM Channel Counter Register (ch_num = 1)
	// Position of CNT field.
	PWM_CCNT1_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT1_CNT_Msk = 0xffffff

	// DT1: PWM Channel Dead Time Register (ch_num = 1)
	// Position of DTH field.
	PWM_DT1_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT1_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT1_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT1_DTL_Msk = 0xffff0000

	// DTUPD1: PWM Channel Dead Time Update Register (ch_num = 1)
	// Position of DTHUPD field.
	PWM_DTUPD1_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD1_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD1_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD1_DTLUPD_Msk = 0xffff0000

	// CMR2: PWM Channel Mode Register (ch_num = 2)
	// Position of CPRE field.
	PWM_CMR2_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR2_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR2_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR2_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR2_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR2_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR2_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR2_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR2_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR2_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR2_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR2_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR2_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR2_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR2_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR2_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR2_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR2_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR2_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR2_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR2_CPOL = 0x200
	// Position of CES field.
	PWM_CMR2_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR2_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR2_CES = 0x400
	// Position of DTE field.
	PWM_CMR2_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR2_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR2_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR2_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR2_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR2_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR2_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR2_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR2_DTLI = 0x40000

	// CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
	// Position of CDTY field.
	PWM_CDTY2_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY2_CDTY_Msk = 0xffffff

	// CDTYUPD2: PWM Channel Duty Cycle Update Register (ch_num = 2)
	// Position of CDTYUPD field.
	PWM_CDTYUPD2_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD2_CDTYUPD_Msk = 0xffffff

	// CPRD2: PWM Channel Period Register (ch_num = 2)
	// Position of CPRD field.
	PWM_CPRD2_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD2_CPRD_Msk = 0xffffff

	// CPRDUPD2: PWM Channel Period Update Register (ch_num = 2)
	// Position of CPRDUPD field.
	PWM_CPRDUPD2_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD2_CPRDUPD_Msk = 0xffffff

	// CCNT2: PWM Channel Counter Register (ch_num = 2)
	// Position of CNT field.
	PWM_CCNT2_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT2_CNT_Msk = 0xffffff

	// DT2: PWM Channel Dead Time Register (ch_num = 2)
	// Position of DTH field.
	PWM_DT2_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT2_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT2_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT2_DTL_Msk = 0xffff0000

	// DTUPD2: PWM Channel Dead Time Update Register (ch_num = 2)
	// Position of DTHUPD field.
	PWM_DTUPD2_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD2_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD2_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD2_DTLUPD_Msk = 0xffff0000

	// CMR3: PWM Channel Mode Register (ch_num = 3)
	// Position of CPRE field.
	PWM_CMR3_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR3_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR3_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR3_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR3_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR3_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR3_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR3_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR3_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR3_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR3_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR3_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR3_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR3_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR3_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR3_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR3_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR3_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR3_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR3_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR3_CPOL = 0x200
	// Position of CES field.
	PWM_CMR3_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR3_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR3_CES = 0x400
	// Position of DTE field.
	PWM_CMR3_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR3_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR3_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR3_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR3_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR3_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR3_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR3_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR3_DTLI = 0x40000

	// CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
	// Position of CDTY field.
	PWM_CDTY3_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY3_CDTY_Msk = 0xffffff

	// CDTYUPD3: PWM Channel Duty Cycle Update Register (ch_num = 3)
	// Position of CDTYUPD field.
	PWM_CDTYUPD3_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD3_CDTYUPD_Msk = 0xffffff

	// CPRD3: PWM Channel Period Register (ch_num = 3)
	// Position of CPRD field.
	PWM_CPRD3_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD3_CPRD_Msk = 0xffffff

	// CPRDUPD3: PWM Channel Period Update Register (ch_num = 3)
	// Position of CPRDUPD field.
	PWM_CPRDUPD3_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD3_CPRDUPD_Msk = 0xffffff

	// CCNT3: PWM Channel Counter Register (ch_num = 3)
	// Position of CNT field.
	PWM_CCNT3_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT3_CNT_Msk = 0xffffff

	// DT3: PWM Channel Dead Time Register (ch_num = 3)
	// Position of DTH field.
	PWM_DT3_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT3_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT3_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT3_DTL_Msk = 0xffff0000

	// DTUPD3: PWM Channel Dead Time Update Register (ch_num = 3)
	// Position of DTHUPD field.
	PWM_DTUPD3_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD3_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD3_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD3_DTLUPD_Msk = 0xffff0000
)

// Bitfields for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	USART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_RSTSTA = 0x100
	// Position of STTBRK field.
	USART_CR_STTBRK_Pos = 0x9
	// Bit mask of STTBRK field.
	USART_CR_STTBRK_Msk = 0x200
	// Bit STTBRK.
	USART_CR_STTBRK = 0x200
	// Position of STPBRK field.
	USART_CR_STPBRK_Pos = 0xa
	// Bit mask of STPBRK field.
	USART_CR_STPBRK_Msk = 0x400
	// Bit STPBRK.
	USART_CR_STPBRK = 0x400
	// Position of STTTO field.
	USART_CR_STTTO_Pos = 0xb
	// Bit mask of STTTO field.
	USART_CR_STTTO_Msk = 0x800
	// Bit STTTO.
	USART_CR_STTTO = 0x800
	// Position of SENDA field.
	USART_CR_SENDA_Pos = 0xc
	// Bit mask of SENDA field.
	USART_CR_SENDA_Msk = 0x1000
	// Bit SENDA.
	USART_CR_SENDA = 0x1000
	// Position of RSTIT field.
	USART_CR_RSTIT_Pos = 0xd
	// Bit mask of RSTIT field.
	USART_CR_RSTIT_Msk = 0x2000
	// Bit RSTIT.
	USART_CR_RSTIT = 0x2000
	// Position of RSTNACK field.
	USART_CR_RSTNACK_Pos = 0xe
	// Bit mask of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000
	// Bit RSTNACK.
	USART_CR_RSTNACK = 0x4000
	// Position of RETTO field.
	USART_CR_RETTO_Pos = 0xf
	// Bit mask of RETTO field.
	USART_CR_RETTO_Msk = 0x8000
	// Bit RETTO.
	USART_CR_RETTO = 0x8000
	// Position of DTREN field.
	USART_CR_DTREN_Pos = 0x10
	// Bit mask of DTREN field.
	USART_CR_DTREN_Msk = 0x10000
	// Bit DTREN.
	USART_CR_DTREN = 0x10000
	// Position of DTRDIS field.
	USART_CR_DTRDIS_Pos = 0x11
	// Bit mask of DTRDIS field.
	USART_CR_DTRDIS_Msk = 0x20000
	// Bit DTRDIS.
	USART_CR_DTRDIS = 0x20000
	// Position of RTSEN field.
	USART_CR_RTSEN_Pos = 0x12
	// Bit mask of RTSEN field.
	USART_CR_RTSEN_Msk = 0x40000
	// Bit RTSEN.
	USART_CR_RTSEN = 0x40000
	// Position of RTSDIS field.
	USART_CR_RTSDIS_Pos = 0x13
	// Bit mask of RTSDIS field.
	USART_CR_RTSDIS_Msk = 0x80000
	// Bit RTSDIS.
	USART_CR_RTSDIS = 0x80000

	// CR_SPI_MODE: Control Register
	// Position of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_SPI_MODE_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_SPI_MODE_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_SPI_MODE_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_SPI_MODE_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_SPI_MODE_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_SPI_MODE_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_SPI_MODE_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_SPI_MODE_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_SPI_MODE_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_SPI_MODE_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_SPI_MODE_RSTSTA = 0x100
	// Position of FCS field.
	USART_CR_SPI_MODE_FCS_Pos = 0x12
	// Bit mask of FCS field.
	USART_CR_SPI_MODE_FCS_Msk = 0x40000
	// Bit FCS.
	USART_CR_SPI_MODE_FCS = 0x40000
	// Position of RCS field.
	USART_CR_SPI_MODE_RCS_Pos = 0x13
	// Bit mask of RCS field.
	USART_CR_SPI_MODE_RCS_Msk = 0x80000
	// Bit RCS.
	USART_CR_SPI_MODE_RCS = 0x80000

	// MR: Mode Register
	// Position of USART_MODE field.
	USART_MR_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_USART_MODE_Msk = 0xf
	// Normal mode
	USART_MR_USART_MODE_NORMAL = 0x0
	// RS485
	USART_MR_USART_MODE_RS485 = 0x1
	// Hardware Handshaking
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2
	// Modem
	USART_MR_USART_MODE_MODEM = 0x3
	// IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_0 = 0x4
	// IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IS07816_T_1 = 0x6
	// IrDA
	USART_MR_USART_MODE_IRDA = 0x8
	// SPI Master
	USART_MR_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_CHRL_Msk = 0xc0
	// Character length is 5 bits
	USART_MR_CHRL_5_BIT = 0x0
	// Character length is 6 bits
	USART_MR_CHRL_6_BIT = 0x1
	// Character length is 7 bits
	USART_MR_CHRL_7_BIT = 0x2
	// Character length is 8 bits
	USART_MR_CHRL_8_BIT = 0x3
	// Position of SYNC field.
	USART_MR_SYNC_Pos = 0x8
	// Bit mask of SYNC field.
	USART_MR_SYNC_Msk = 0x100
	// Bit SYNC.
	USART_MR_SYNC = 0x100
	// Position of PAR field.
	USART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	USART_MR_PAR_Msk = 0xe00
	// Even parity
	USART_MR_PAR_EVEN = 0x0
	// Odd parity
	USART_MR_PAR_ODD = 0x1
	// Parity forced to 0 (Space)
	USART_MR_PAR_SPACE = 0x2
	// Parity forced to 1 (Mark)
	USART_MR_PAR_MARK = 0x3
	// No parity
	USART_MR_PAR_NO = 0x4
	// Multidrop mode
	USART_MR_PAR_MULTIDROP = 0x6
	// Position of NBSTOP field.
	USART_MR_NBSTOP_Pos = 0xc
	// Bit mask of NBSTOP field.
	USART_MR_NBSTOP_Msk = 0x3000
	// 1 stop bit
	USART_MR_NBSTOP_1_BIT = 0x0
	// 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_1_5_BIT = 0x1
	// 2 stop bits
	USART_MR_NBSTOP_2_BIT = 0x2
	// Position of CHMODE field.
	USART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	USART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	USART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_CHMODE_REMOTE_LOOPBACK = 0x3
	// Position of MSBF field.
	USART_MR_MSBF_Pos = 0x10
	// Bit mask of MSBF field.
	USART_MR_MSBF_Msk = 0x10000
	// Bit MSBF.
	USART_MR_MSBF = 0x10000
	// Position of MODE9 field.
	USART_MR_MODE9_Pos = 0x11
	// Bit mask of MODE9 field.
	USART_MR_MODE9_Msk = 0x20000
	// Bit MODE9.
	USART_MR_MODE9 = 0x20000
	// Position of CLKO field.
	USART_MR_CLKO_Pos = 0x12
	// Bit mask of CLKO field.
	USART_MR_CLKO_Msk = 0x40000
	// Bit CLKO.
	USART_MR_CLKO = 0x40000
	// Position of OVER field.
	USART_MR_OVER_Pos = 0x13
	// Bit mask of OVER field.
	USART_MR_OVER_Msk = 0x80000
	// Bit OVER.
	USART_MR_OVER = 0x80000
	// Position of INACK field.
	USART_MR_INACK_Pos = 0x14
	// Bit mask of INACK field.
	USART_MR_INACK_Msk = 0x100000
	// Bit INACK.
	USART_MR_INACK = 0x100000
	// Position of DSNACK field.
	USART_MR_DSNACK_Pos = 0x15
	// Bit mask of DSNACK field.
	USART_MR_DSNACK_Msk = 0x200000
	// Bit DSNACK.
	USART_MR_DSNACK = 0x200000
	// Position of VAR_SYNC field.
	USART_MR_VAR_SYNC_Pos = 0x16
	// Bit mask of VAR_SYNC field.
	USART_MR_VAR_SYNC_Msk = 0x400000
	// Bit VAR_SYNC.
	USART_MR_VAR_SYNC = 0x400000
	// Position of INVDATA field.
	USART_MR_INVDATA_Pos = 0x17
	// Bit mask of INVDATA field.
	USART_MR_INVDATA_Msk = 0x800000
	// Bit INVDATA.
	USART_MR_INVDATA = 0x800000
	// Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Pos = 0x18
	// Bit mask of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk = 0x7000000
	// Position of FILTER field.
	USART_MR_FILTER_Pos = 0x1c
	// Bit mask of FILTER field.
	USART_MR_FILTER_Msk = 0x10000000
	// Bit FILTER.
	USART_MR_FILTER = 0x10000000
	// Position of MAN field.
	USART_MR_MAN_Pos = 0x1d
	// Bit mask of MAN field.
	USART_MR_MAN_Msk = 0x20000000
	// Bit MAN.
	USART_MR_MAN = 0x20000000
	// Position of MODSYNC field.
	USART_MR_MODSYNC_Pos = 0x1e
	// Bit mask of MODSYNC field.
	USART_MR_MODSYNC_Msk = 0x40000000
	// Bit MODSYNC.
	USART_MR_MODSYNC = 0x40000000
	// Position of ONEBIT field.
	USART_MR_ONEBIT_Pos = 0x1f
	// Bit mask of ONEBIT field.
	USART_MR_ONEBIT_Msk = 0x80000000
	// Bit ONEBIT.
	USART_MR_ONEBIT = 0x80000000

	// MR_SPI_MODE: Mode Register
	// Position of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Msk = 0xf
	// SPI Master
	USART_MR_SPI_MODE_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_SPI_MODE_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_SPI_MODE_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_SPI_MODE_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_SPI_MODE_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_SPI_MODE_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_SPI_MODE_CHRL_Msk = 0xc0
	// Character length is 8 bits
	USART_MR_SPI_MODE_CHRL_8_BIT = 0x3
	// Position of CPHA field.
	USART_MR_SPI_MODE_CPHA_Pos = 0x8
	// Bit mask of CPHA field.
	USART_MR_SPI_MODE_CPHA_Msk = 0x100
	// Bit CPHA.
	USART_MR_SPI_MODE_CPHA = 0x100
	// Position of CPOL field.
	USART_MR_SPI_MODE_CPOL_Pos = 0x10
	// Bit mask of CPOL field.
	USART_MR_SPI_MODE_CPOL_Msk = 0x10000
	// Bit CPOL.
	USART_MR_SPI_MODE_CPOL = 0x10000
	// Position of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Pos = 0x14
	// Bit mask of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Msk = 0x100000
	// Bit WRDBT.
	USART_MR_SPI_MODE_WRDBT = 0x100000

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IER_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IER_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IER_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IER_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IER_ENDTX = 0x10
	// Position of OVRE field.
	USART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_OVRE = 0x20
	// Position of FRAME field.
	USART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IER_FRAME = 0x40
	// Position of PARE field.
	USART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IER_PARE_Msk = 0x80
	// Bit PARE.
	USART_IER_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IER_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IER_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IER_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IER_ITER_Msk = 0x400
	// Bit ITER.
	USART_IER_ITER = 0x400
	// Position of TXBUFE field.
	USART_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IER_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IER_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IER_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IER_NACK = 0x2000
	// Position of RIIC field.
	USART_IER_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_IER_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_IER_RIIC = 0x10000
	// Position of DSRIC field.
	USART_IER_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_IER_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_IER_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_IER_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_IER_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_IER_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_IER_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IER_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IER_CTSIC = 0x80000
	// Position of MANE field.
	USART_IER_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IER_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IER_MANE = 0x1000000

	// IER_SPI_MODE: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IER_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IER_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IER_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IER_SPI_MODE_UNRE = 0x400

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IDR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IDR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IDR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IDR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_OVRE = 0x20
	// Position of FRAME field.
	USART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IDR_FRAME = 0x40
	// Position of PARE field.
	USART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IDR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IDR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IDR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IDR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IDR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IDR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IDR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IDR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IDR_NACK = 0x2000
	// Position of RIIC field.
	USART_IDR_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_IDR_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_IDR_RIIC = 0x10000
	// Position of DSRIC field.
	USART_IDR_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_IDR_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_IDR_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_IDR_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_IDR_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_IDR_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_IDR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IDR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IDR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IDR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IDR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IDR_MANE = 0x1000000

	// IDR_SPI_MODE: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IDR_SPI_MODE_UNRE = 0x400

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IMR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IMR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IMR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IMR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_OVRE = 0x20
	// Position of FRAME field.
	USART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IMR_FRAME = 0x40
	// Position of PARE field.
	USART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IMR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IMR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IMR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IMR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IMR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IMR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IMR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IMR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IMR_NACK = 0x2000
	// Position of RIIC field.
	USART_IMR_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_IMR_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_IMR_RIIC = 0x10000
	// Position of DSRIC field.
	USART_IMR_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_IMR_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_IMR_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_IMR_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_IMR_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_IMR_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_IMR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IMR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IMR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IMR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IMR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IMR_MANE = 0x1000000

	// IMR_SPI_MODE: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IMR_SPI_MODE_UNRE = 0x400

	// CSR: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_CSR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_CSR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_CSR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_CSR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_CSR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_CSR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_CSR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_CSR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_CSR_ENDTX = 0x10
	// Position of OVRE field.
	USART_CSR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_OVRE = 0x20
	// Position of FRAME field.
	USART_CSR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_CSR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_CSR_FRAME = 0x40
	// Position of PARE field.
	USART_CSR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_CSR_PARE_Msk = 0x80
	// Bit PARE.
	USART_CSR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_CSR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_CSR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_CSR_ITER_Msk = 0x400
	// Bit ITER.
	USART_CSR_ITER = 0x400
	// Position of TXBUFE field.
	USART_CSR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_CSR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_CSR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_CSR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_CSR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_CSR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_CSR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_CSR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_CSR_NACK = 0x2000
	// Position of RIIC field.
	USART_CSR_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_CSR_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_CSR_RIIC = 0x10000
	// Position of DSRIC field.
	USART_CSR_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_CSR_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_CSR_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_CSR_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_CSR_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_CSR_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_CSR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_CSR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_CSR_CTSIC = 0x80000
	// Position of RI field.
	USART_CSR_RI_Pos = 0x14
	// Bit mask of RI field.
	USART_CSR_RI_Msk = 0x100000
	// Bit RI.
	USART_CSR_RI = 0x100000
	// Position of DSR field.
	USART_CSR_DSR_Pos = 0x15
	// Bit mask of DSR field.
	USART_CSR_DSR_Msk = 0x200000
	// Bit DSR.
	USART_CSR_DSR = 0x200000
	// Position of DCD field.
	USART_CSR_DCD_Pos = 0x16
	// Bit mask of DCD field.
	USART_CSR_DCD_Msk = 0x400000
	// Bit DCD.
	USART_CSR_DCD = 0x400000
	// Position of CTS field.
	USART_CSR_CTS_Pos = 0x17
	// Bit mask of CTS field.
	USART_CSR_CTS_Msk = 0x800000
	// Bit CTS.
	USART_CSR_CTS = 0x800000
	// Position of MANERR field.
	USART_CSR_MANERR_Pos = 0x18
	// Bit mask of MANERR field.
	USART_CSR_MANERR_Msk = 0x1000000
	// Bit MANERR.
	USART_CSR_MANERR = 0x1000000

	// CSR_SPI_MODE: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_CSR_SPI_MODE_UNRE = 0x400

	// RHR: Receiver Holding Register
	// Position of RXCHR field.
	USART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	USART_RHR_RXCHR_Msk = 0x1ff
	// Position of RXSYNH field.
	USART_RHR_RXSYNH_Pos = 0xf
	// Bit mask of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000
	// Bit RXSYNH.
	USART_RHR_RXSYNH = 0x8000

	// THR: Transmitter Holding Register
	// Position of TXCHR field.
	USART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	USART_THR_TXCHR_Msk = 0x1ff
	// Position of TXSYNH field.
	USART_THR_TXSYNH_Pos = 0xf
	// Bit mask of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000
	// Bit TXSYNH.
	USART_THR_TXSYNH = 0x8000

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	USART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	USART_BRGR_CD_Msk = 0xffff
	// Position of FP field.
	USART_BRGR_FP_Pos = 0x10
	// Bit mask of FP field.
	USART_BRGR_FP_Msk = 0x70000

	// RTOR: Receiver Time-out Register
	// Position of TO field.
	USART_RTOR_TO_Pos = 0x0
	// Bit mask of TO field.
	USART_RTOR_TO_Msk = 0xffff

	// TTGR: Transmitter Timeguard Register
	// Position of TG field.
	USART_TTGR_TG_Pos = 0x0
	// Bit mask of TG field.
	USART_TTGR_TG_Msk = 0xff

	// FIDI: FI DI Ratio Register
	// Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Pos = 0x0
	// Bit mask of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0x7ff

	// NER: Number of Errors Register
	// Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Pos = 0x0
	// Bit mask of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff

	// IF: IrDA Filter Register
	// Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Pos = 0x0
	// Bit mask of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff

	// MAN: Manchester Encoder Decoder Register
	// Position of TX_PL field.
	USART_MAN_TX_PL_Pos = 0x0
	// Bit mask of TX_PL field.
	USART_MAN_TX_PL_Msk = 0xf
	// Position of TX_PP field.
	USART_MAN_TX_PP_Pos = 0x8
	// Bit mask of TX_PP field.
	USART_MAN_TX_PP_Msk = 0x300
	// The preamble is composed of '1's
	USART_MAN_TX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_TX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_TX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_TX_PP_ONE_ZERO = 0x3
	// Position of TX_MPOL field.
	USART_MAN_TX_MPOL_Pos = 0xc
	// Bit mask of TX_MPOL field.
	USART_MAN_TX_MPOL_Msk = 0x1000
	// Bit TX_MPOL.
	USART_MAN_TX_MPOL = 0x1000
	// Position of RX_PL field.
	USART_MAN_RX_PL_Pos = 0x10
	// Bit mask of RX_PL field.
	USART_MAN_RX_PL_Msk = 0xf0000
	// Position of RX_PP field.
	USART_MAN_RX_PP_Pos = 0x18
	// Bit mask of RX_PP field.
	USART_MAN_RX_PP_Msk = 0x3000000
	// The preamble is composed of '1's
	USART_MAN_RX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_RX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_RX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_RX_PP_ONE_ZERO = 0x3
	// Position of RX_MPOL field.
	USART_MAN_RX_MPOL_Pos = 0x1c
	// Bit mask of RX_MPOL field.
	USART_MAN_RX_MPOL_Msk = 0x10000000
	// Bit RX_MPOL.
	USART_MAN_RX_MPOL = 0x10000000
	// Position of ONE field.
	USART_MAN_ONE_Pos = 0x1d
	// Bit mask of ONE field.
	USART_MAN_ONE_Msk = 0x20000000
	// Bit ONE.
	USART_MAN_ONE = 0x20000000
	// Position of DRIFT field.
	USART_MAN_DRIFT_Pos = 0x1e
	// Bit mask of DRIFT field.
	USART_MAN_DRIFT_Msk = 0x40000000
	// Bit DRIFT.
	USART_MAN_DRIFT = 0x40000000

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	USART_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	USART_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	USART_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	USART_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	USART_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	USART_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	USART_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	USART_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	USART_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	USART_WPSR_WPVSRC_Msk = 0xffff00

	// VERSION: Version Register
	// Position of VERSION field.
	USART_VERSION_VERSION_Pos = 0x0
	// Bit mask of VERSION field.
	USART_VERSION_VERSION_Msk = 0xfff
	// Position of MFN field.
	USART_VERSION_MFN_Pos = 0x10
	// Bit mask of MFN field.
	USART_VERSION_MFN_Msk = 0x70000

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	USART_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	USART_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	USART_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	USART_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	USART_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	USART_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	USART_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	USART_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	USART_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	USART_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	USART_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	USART_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	USART_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	USART_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	USART_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	USART_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	USART_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	USART_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	USART_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	USART_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	USART_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	USART_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	USART_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	USART_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	USART_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	USART_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTSR_TXTEN = 0x100
)

// Bitfields for UDP: USB Device Port
const (
	// FRM_NUM: Frame Number Register
	// Position of FRM_NUM field.
	UDP_FRM_NUM_FRM_NUM_Pos = 0x0
	// Bit mask of FRM_NUM field.
	UDP_FRM_NUM_FRM_NUM_Msk = 0x7ff
	// Position of FRM_ERR field.
	UDP_FRM_NUM_FRM_ERR_Pos = 0x10
	// Bit mask of FRM_ERR field.
	UDP_FRM_NUM_FRM_ERR_Msk = 0x10000
	// Bit FRM_ERR.
	UDP_FRM_NUM_FRM_ERR = 0x10000
	// Position of FRM_OK field.
	UDP_FRM_NUM_FRM_OK_Pos = 0x11
	// Bit mask of FRM_OK field.
	UDP_FRM_NUM_FRM_OK_Msk = 0x20000
	// Bit FRM_OK.
	UDP_FRM_NUM_FRM_OK = 0x20000

	// GLB_STAT: Global State Register
	// Position of FADDEN field.
	UDP_GLB_STAT_FADDEN_Pos = 0x0
	// Bit mask of FADDEN field.
	UDP_GLB_STAT_FADDEN_Msk = 0x1
	// Bit FADDEN.
	UDP_GLB_STAT_FADDEN = 0x1
	// Position of CONFG field.
	UDP_GLB_STAT_CONFG_Pos = 0x1
	// Bit mask of CONFG field.
	UDP_GLB_STAT_CONFG_Msk = 0x2
	// Bit CONFG.
	UDP_GLB_STAT_CONFG = 0x2
	// Position of ESR field.
	UDP_GLB_STAT_ESR_Pos = 0x2
	// Bit mask of ESR field.
	UDP_GLB_STAT_ESR_Msk = 0x4
	// Bit ESR.
	UDP_GLB_STAT_ESR = 0x4
	// Position of RSMINPR field.
	UDP_GLB_STAT_RSMINPR_Pos = 0x3
	// Bit mask of RSMINPR field.
	UDP_GLB_STAT_RSMINPR_Msk = 0x8
	// Bit RSMINPR.
	UDP_GLB_STAT_RSMINPR = 0x8
	// Position of RMWUPE field.
	UDP_GLB_STAT_RMWUPE_Pos = 0x4
	// Bit mask of RMWUPE field.
	UDP_GLB_STAT_RMWUPE_Msk = 0x10
	// Bit RMWUPE.
	UDP_GLB_STAT_RMWUPE = 0x10

	// FADDR: Function Address Register
	// Position of FADD field.
	UDP_FADDR_FADD_Pos = 0x0
	// Bit mask of FADD field.
	UDP_FADDR_FADD_Msk = 0x7f
	// Position of FEN field.
	UDP_FADDR_FEN_Pos = 0x8
	// Bit mask of FEN field.
	UDP_FADDR_FEN_Msk = 0x100
	// Bit FEN.
	UDP_FADDR_FEN = 0x100

	// IER: Interrupt Enable Register
	// Position of EP0INT field.
	UDP_IER_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IER_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IER_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IER_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IER_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IER_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IER_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IER_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IER_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IER_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IER_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IER_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IER_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IER_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IER_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IER_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IER_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IER_EP5INT = 0x20
	// Position of EP6INT field.
	UDP_IER_EP6INT_Pos = 0x6
	// Bit mask of EP6INT field.
	UDP_IER_EP6INT_Msk = 0x40
	// Bit EP6INT.
	UDP_IER_EP6INT = 0x40
	// Position of EP7INT field.
	UDP_IER_EP7INT_Pos = 0x7
	// Bit mask of EP7INT field.
	UDP_IER_EP7INT_Msk = 0x80
	// Bit EP7INT.
	UDP_IER_EP7INT = 0x80
	// Position of RXSUSP field.
	UDP_IER_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IER_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IER_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IER_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IER_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IER_RXRSM = 0x200
	// Position of EXTRSM field.
	UDP_IER_EXTRSM_Pos = 0xa
	// Bit mask of EXTRSM field.
	UDP_IER_EXTRSM_Msk = 0x400
	// Bit EXTRSM.
	UDP_IER_EXTRSM = 0x400
	// Position of SOFINT field.
	UDP_IER_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IER_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IER_SOFINT = 0x800
	// Position of WAKEUP field.
	UDP_IER_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IER_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IER_WAKEUP = 0x2000

	// IDR: Interrupt Disable Register
	// Position of EP0INT field.
	UDP_IDR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IDR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IDR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IDR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IDR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IDR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IDR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IDR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IDR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IDR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IDR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IDR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IDR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IDR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IDR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IDR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IDR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IDR_EP5INT = 0x20
	// Position of EP6INT field.
	UDP_IDR_EP6INT_Pos = 0x6
	// Bit mask of EP6INT field.
	UDP_IDR_EP6INT_Msk = 0x40
	// Bit EP6INT.
	UDP_IDR_EP6INT = 0x40
	// Position of EP7INT field.
	UDP_IDR_EP7INT_Pos = 0x7
	// Bit mask of EP7INT field.
	UDP_IDR_EP7INT_Msk = 0x80
	// Bit EP7INT.
	UDP_IDR_EP7INT = 0x80
	// Position of RXSUSP field.
	UDP_IDR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IDR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IDR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IDR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IDR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IDR_RXRSM = 0x200
	// Position of EXTRSM field.
	UDP_IDR_EXTRSM_Pos = 0xa
	// Bit mask of EXTRSM field.
	UDP_IDR_EXTRSM_Msk = 0x400
	// Bit EXTRSM.
	UDP_IDR_EXTRSM = 0x400
	// Position of SOFINT field.
	UDP_IDR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IDR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IDR_SOFINT = 0x800
	// Position of WAKEUP field.
	UDP_IDR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IDR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IDR_WAKEUP = 0x2000

	// IMR: Interrupt Mask Register
	// Position of EP0INT field.
	UDP_IMR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IMR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IMR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IMR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IMR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IMR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IMR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IMR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IMR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IMR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IMR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IMR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IMR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IMR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IMR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IMR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IMR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IMR_EP5INT = 0x20
	// Position of EP6INT field.
	UDP_IMR_EP6INT_Pos = 0x6
	// Bit mask of EP6INT field.
	UDP_IMR_EP6INT_Msk = 0x40
	// Bit EP6INT.
	UDP_IMR_EP6INT = 0x40
	// Position of EP7INT field.
	UDP_IMR_EP7INT_Pos = 0x7
	// Bit mask of EP7INT field.
	UDP_IMR_EP7INT_Msk = 0x80
	// Bit EP7INT.
	UDP_IMR_EP7INT = 0x80
	// Position of RXSUSP field.
	UDP_IMR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IMR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IMR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IMR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IMR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IMR_RXRSM = 0x200
	// Position of EXTRSM field.
	UDP_IMR_EXTRSM_Pos = 0xa
	// Bit mask of EXTRSM field.
	UDP_IMR_EXTRSM_Msk = 0x400
	// Bit EXTRSM.
	UDP_IMR_EXTRSM = 0x400
	// Position of SOFINT field.
	UDP_IMR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IMR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IMR_SOFINT = 0x800
	// Position of BIT12 field.
	UDP_IMR_BIT12_Pos = 0xc
	// Bit mask of BIT12 field.
	UDP_IMR_BIT12_Msk = 0x1000
	// Bit BIT12.
	UDP_IMR_BIT12 = 0x1000
	// Position of WAKEUP field.
	UDP_IMR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IMR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IMR_WAKEUP = 0x2000

	// ISR: Interrupt Status Register
	// Position of EP0INT field.
	UDP_ISR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_ISR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_ISR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_ISR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_ISR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_ISR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_ISR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_ISR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_ISR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_ISR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_ISR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_ISR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_ISR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_ISR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_ISR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_ISR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_ISR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_ISR_EP5INT = 0x20
	// Position of EP6INT field.
	UDP_ISR_EP6INT_Pos = 0x6
	// Bit mask of EP6INT field.
	UDP_ISR_EP6INT_Msk = 0x40
	// Bit EP6INT.
	UDP_ISR_EP6INT = 0x40
	// Position of EP7INT field.
	UDP_ISR_EP7INT_Pos = 0x7
	// Bit mask of EP7INT field.
	UDP_ISR_EP7INT_Msk = 0x80
	// Bit EP7INT.
	UDP_ISR_EP7INT = 0x80
	// Position of RXSUSP field.
	UDP_ISR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_ISR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_ISR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_ISR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_ISR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_ISR_RXRSM = 0x200
	// Position of EXTRSM field.
	UDP_ISR_EXTRSM_Pos = 0xa
	// Bit mask of EXTRSM field.
	UDP_ISR_EXTRSM_Msk = 0x400
	// Bit EXTRSM.
	UDP_ISR_EXTRSM = 0x400
	// Position of SOFINT field.
	UDP_ISR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_ISR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_ISR_SOFINT = 0x800
	// Position of ENDBUSRES field.
	UDP_ISR_ENDBUSRES_Pos = 0xc
	// Bit mask of ENDBUSRES field.
	UDP_ISR_ENDBUSRES_Msk = 0x1000
	// Bit ENDBUSRES.
	UDP_ISR_ENDBUSRES = 0x1000
	// Position of WAKEUP field.
	UDP_ISR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_ISR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_ISR_WAKEUP = 0x2000

	// ICR: Interrupt Clear Register
	// Position of RXSUSP field.
	UDP_ICR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_ICR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_ICR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_ICR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_ICR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_ICR_RXRSM = 0x200
	// Position of EXTRSM field.
	UDP_ICR_EXTRSM_Pos = 0xa
	// Bit mask of EXTRSM field.
	UDP_ICR_EXTRSM_Msk = 0x400
	// Bit EXTRSM.
	UDP_ICR_EXTRSM = 0x400
	// Position of SOFINT field.
	UDP_ICR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_ICR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_ICR_SOFINT = 0x800
	// Position of ENDBUSRES field.
	UDP_ICR_ENDBUSRES_Pos = 0xc
	// Bit mask of ENDBUSRES field.
	UDP_ICR_ENDBUSRES_Msk = 0x1000
	// Bit ENDBUSRES.
	UDP_ICR_ENDBUSRES = 0x1000
	// Position of WAKEUP field.
	UDP_ICR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_ICR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_ICR_WAKEUP = 0x2000

	// RST_EP: Reset Endpoint Register
	// Position of EP0 field.
	UDP_RST_EP_EP0_Pos = 0x0
	// Bit mask of EP0 field.
	UDP_RST_EP_EP0_Msk = 0x1
	// Bit EP0.
	UDP_RST_EP_EP0 = 0x1
	// Position of EP1 field.
	UDP_RST_EP_EP1_Pos = 0x1
	// Bit mask of EP1 field.
	UDP_RST_EP_EP1_Msk = 0x2
	// Bit EP1.
	UDP_RST_EP_EP1 = 0x2
	// Position of EP2 field.
	UDP_RST_EP_EP2_Pos = 0x2
	// Bit mask of EP2 field.
	UDP_RST_EP_EP2_Msk = 0x4
	// Bit EP2.
	UDP_RST_EP_EP2 = 0x4
	// Position of EP3 field.
	UDP_RST_EP_EP3_Pos = 0x3
	// Bit mask of EP3 field.
	UDP_RST_EP_EP3_Msk = 0x8
	// Bit EP3.
	UDP_RST_EP_EP3 = 0x8
	// Position of EP4 field.
	UDP_RST_EP_EP4_Pos = 0x4
	// Bit mask of EP4 field.
	UDP_RST_EP_EP4_Msk = 0x10
	// Bit EP4.
	UDP_RST_EP_EP4 = 0x10
	// Position of EP5 field.
	UDP_RST_EP_EP5_Pos = 0x5
	// Bit mask of EP5 field.
	UDP_RST_EP_EP5_Msk = 0x20
	// Bit EP5.
	UDP_RST_EP_EP5 = 0x20
	// Position of EP6 field.
	UDP_RST_EP_EP6_Pos = 0x6
	// Bit mask of EP6 field.
	UDP_RST_EP_EP6_Msk = 0x40
	// Bit EP6.
	UDP_RST_EP_EP6 = 0x40
	// Position of EP7 field.
	UDP_RST_EP_EP7_Pos = 0x7
	// Bit mask of EP7 field.
	UDP_RST_EP_EP7_Msk = 0x80
	// Bit EP7.
	UDP_RST_EP_EP7 = 0x80

	// CSR: Endpoint Control and Status Register
	// Position of TXCOMP field.
	UDP_CSR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	UDP_CSR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	UDP_CSR_TXCOMP = 0x1
	// Position of RX_DATA_BK0 field.
	UDP_CSR_RX_DATA_BK0_Pos = 0x1
	// Bit mask of RX_DATA_BK0 field.
	UDP_CSR_RX_DATA_BK0_Msk = 0x2
	// Bit RX_DATA_BK0.
	UDP_CSR_RX_DATA_BK0 = 0x2
	// Position of RXSETUP field.
	UDP_CSR_RXSETUP_Pos = 0x2
	// Bit mask of RXSETUP field.
	UDP_CSR_RXSETUP_Msk = 0x4
	// Bit RXSETUP.
	UDP_CSR_RXSETUP = 0x4
	// Position of STALLSENT field.
	UDP_CSR_STALLSENT_Pos = 0x3
	// Bit mask of STALLSENT field.
	UDP_CSR_STALLSENT_Msk = 0x8
	// Bit STALLSENT.
	UDP_CSR_STALLSENT = 0x8
	// Position of TXPKTRDY field.
	UDP_CSR_TXPKTRDY_Pos = 0x4
	// Bit mask of TXPKTRDY field.
	UDP_CSR_TXPKTRDY_Msk = 0x10
	// Bit TXPKTRDY.
	UDP_CSR_TXPKTRDY = 0x10
	// Position of FORCESTALL field.
	UDP_CSR_FORCESTALL_Pos = 0x5
	// Bit mask of FORCESTALL field.
	UDP_CSR_FORCESTALL_Msk = 0x20
	// Bit FORCESTALL.
	UDP_CSR_FORCESTALL = 0x20
	// Position of RX_DATA_BK1 field.
	UDP_CSR_RX_DATA_BK1_Pos = 0x6
	// Bit mask of RX_DATA_BK1 field.
	UDP_CSR_RX_DATA_BK1_Msk = 0x40
	// Bit RX_DATA_BK1.
	UDP_CSR_RX_DATA_BK1 = 0x40
	// Position of DIR field.
	UDP_CSR_DIR_Pos = 0x7
	// Bit mask of DIR field.
	UDP_CSR_DIR_Msk = 0x80
	// Bit DIR.
	UDP_CSR_DIR = 0x80
	// Position of EPTYPE field.
	UDP_CSR_EPTYPE_Pos = 0x8
	// Bit mask of EPTYPE field.
	UDP_CSR_EPTYPE_Msk = 0x700
	// Control
	UDP_CSR_EPTYPE_CTRL = 0x0
	// Isochronous OUT
	UDP_CSR_EPTYPE_ISO_OUT = 0x1
	// Bulk OUT
	UDP_CSR_EPTYPE_BULK_OUT = 0x2
	// Interrupt OUT
	UDP_CSR_EPTYPE_INT_OUT = 0x3
	// Isochronous IN
	UDP_CSR_EPTYPE_ISO_IN = 0x5
	// Bulk IN
	UDP_CSR_EPTYPE_BULK_IN = 0x6
	// Interrupt IN
	UDP_CSR_EPTYPE_INT_IN = 0x7
	// Position of DTGLE field.
	UDP_CSR_DTGLE_Pos = 0xb
	// Bit mask of DTGLE field.
	UDP_CSR_DTGLE_Msk = 0x800
	// Bit DTGLE.
	UDP_CSR_DTGLE = 0x800
	// Position of EPEDS field.
	UDP_CSR_EPEDS_Pos = 0xf
	// Bit mask of EPEDS field.
	UDP_CSR_EPEDS_Msk = 0x8000
	// Bit EPEDS.
	UDP_CSR_EPEDS = 0x8000
	// Position of RXBYTECNT field.
	UDP_CSR_RXBYTECNT_Pos = 0x10
	// Bit mask of RXBYTECNT field.
	UDP_CSR_RXBYTECNT_Msk = 0x7ff0000

	// CSR0_ISOENDPT: Endpoint Control and Status Register
	// Position of TXCOMP field.
	UDP_CSR0_ISOENDPT_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	UDP_CSR0_ISOENDPT_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	UDP_CSR0_ISOENDPT_TXCOMP = 0x1
	// Position of RX_DATA_BK0 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK0_Pos = 0x1
	// Bit mask of RX_DATA_BK0 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK0_Msk = 0x2
	// Bit RX_DATA_BK0.
	UDP_CSR0_ISOENDPT_RX_DATA_BK0 = 0x2
	// Position of RXSETUP field.
	UDP_CSR0_ISOENDPT_RXSETUP_Pos = 0x2
	// Bit mask of RXSETUP field.
	UDP_CSR0_ISOENDPT_RXSETUP_Msk = 0x4
	// Bit RXSETUP.
	UDP_CSR0_ISOENDPT_RXSETUP = 0x4
	// Position of ISOERROR field.
	UDP_CSR0_ISOENDPT_ISOERROR_Pos = 0x3
	// Bit mask of ISOERROR field.
	UDP_CSR0_ISOENDPT_ISOERROR_Msk = 0x8
	// Bit ISOERROR.
	UDP_CSR0_ISOENDPT_ISOERROR = 0x8
	// Position of TXPKTRDY field.
	UDP_CSR0_ISOENDPT_TXPKTRDY_Pos = 0x4
	// Bit mask of TXPKTRDY field.
	UDP_CSR0_ISOENDPT_TXPKTRDY_Msk = 0x10
	// Bit TXPKTRDY.
	UDP_CSR0_ISOENDPT_TXPKTRDY = 0x10
	// Position of FORCESTALL field.
	UDP_CSR0_ISOENDPT_FORCESTALL_Pos = 0x5
	// Bit mask of FORCESTALL field.
	UDP_CSR0_ISOENDPT_FORCESTALL_Msk = 0x20
	// Bit FORCESTALL.
	UDP_CSR0_ISOENDPT_FORCESTALL = 0x20
	// Position of RX_DATA_BK1 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK1_Pos = 0x6
	// Bit mask of RX_DATA_BK1 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK1_Msk = 0x40
	// Bit RX_DATA_BK1.
	UDP_CSR0_ISOENDPT_RX_DATA_BK1 = 0x40
	// Position of DIR field.
	UDP_CSR0_ISOENDPT_DIR_Pos = 0x7
	// Bit mask of DIR field.
	UDP_CSR0_ISOENDPT_DIR_Msk = 0x80
	// Bit DIR.
	UDP_CSR0_ISOENDPT_DIR = 0x80
	// Position of EPTYPE field.
	UDP_CSR0_ISOENDPT_EPTYPE_Pos = 0x8
	// Bit mask of EPTYPE field.
	UDP_CSR0_ISOENDPT_EPTYPE_Msk = 0x700
	// Control
	UDP_CSR0_ISOENDPT_EPTYPE_CTRL = 0x0
	// Isochronous OUT
	UDP_CSR0_ISOENDPT_EPTYPE_ISO_OUT = 0x1
	// Isochronous IN
	UDP_CSR0_ISOENDPT_EPTYPE_ISO_IN = 0x5
	// Bulk OUT
	UDP_CSR0_ISOENDPT_EPTYPE_BULK_OUT = 0x2
	// Bulk IN
	UDP_CSR0_ISOENDPT_EPTYPE_BULK_IN = 0x6
	// Interrupt OUT
	UDP_CSR0_ISOENDPT_EPTYPE_INT_OUT = 0x3
	// Interrupt IN
	UDP_CSR0_ISOENDPT_EPTYPE_INT_IN = 0x7
	// Position of DTGLE field.
	UDP_CSR0_ISOENDPT_DTGLE_Pos = 0xb
	// Bit mask of DTGLE field.
	UDP_CSR0_ISOENDPT_DTGLE_Msk = 0x800
	// Bit DTGLE.
	UDP_CSR0_ISOENDPT_DTGLE = 0x800
	// Position of EPEDS field.
	UDP_CSR0_ISOENDPT_EPEDS_Pos = 0xf
	// Bit mask of EPEDS field.
	UDP_CSR0_ISOENDPT_EPEDS_Msk = 0x8000
	// Bit EPEDS.
	UDP_CSR0_ISOENDPT_EPEDS = 0x8000
	// Position of RXBYTECNT field.
	UDP_CSR0_ISOENDPT_RXBYTECNT_Pos = 0x10
	// Bit mask of RXBYTECNT field.
	UDP_CSR0_ISOENDPT_RXBYTECNT_Msk = 0x7ff0000

	// FDR: Endpoint FIFO Data Register
	// Position of FIFO_DATA field.
	UDP_FDR_FIFO_DATA_Pos = 0x0
	// Bit mask of FIFO_DATA field.
	UDP_FDR_FIFO_DATA_Msk = 0xff

	// TXVC: Transceiver Control Register
	// Position of TXVDIS field.
	UDP_TXVC_TXVDIS_Pos = 0x8
	// Bit mask of TXVDIS field.
	UDP_TXVC_TXVDIS_Msk = 0x100
	// Bit TXVDIS.
	UDP_TXVC_TXVDIS = 0x100
	// Position of PUON field.
	UDP_TXVC_PUON_Pos = 0x9
	// Bit mask of PUON field.
	UDP_TXVC_PUON_Msk = 0x200
	// Bit PUON.
	UDP_TXVC_PUON = 0x200
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// CR: Control Register
	// Position of SWRST field.
	ADC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_CR_SWRST = 0x1
	// Position of START field.
	ADC_CR_START_Pos = 0x1
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x2
	// Bit START.
	ADC_CR_START = 0x2
	// Position of AUTOCAL field.
	ADC_CR_AUTOCAL_Pos = 0x3
	// Bit mask of AUTOCAL field.
	ADC_CR_AUTOCAL_Msk = 0x8
	// Bit AUTOCAL.
	ADC_CR_AUTOCAL = 0x8

	// MR: Mode Register
	// Position of TRGEN field.
	ADC_MR_TRGEN_Pos = 0x0
	// Bit mask of TRGEN field.
	ADC_MR_TRGEN_Msk = 0x1
	// Bit TRGEN.
	ADC_MR_TRGEN = 0x1
	// Hardware triggers are disabled. Starting a conversion is only possible by software.
	ADC_MR_TRGEN_DIS = 0x0
	// Hardware trigger selected by TRGSEL field is enabled.
	ADC_MR_TRGEN_EN = 0x1
	// Position of TRGSEL field.
	ADC_MR_TRGSEL_Pos = 0x1
	// Bit mask of TRGSEL field.
	ADC_MR_TRGSEL_Msk = 0xe
	// External trigger
	ADC_MR_TRGSEL_ADC_TRIG0 = 0x0
	// TIO Output of the Timer Counter Channel 0
	ADC_MR_TRGSEL_ADC_TRIG1 = 0x1
	// TIO Output of the Timer Counter Channel 1
	ADC_MR_TRGSEL_ADC_TRIG2 = 0x2
	// TIO Output of the Timer Counter Channel 2
	ADC_MR_TRGSEL_ADC_TRIG3 = 0x3
	// PWM Event Line 0
	ADC_MR_TRGSEL_ADC_TRIG4 = 0x4
	// PWM Event Line 1
	ADC_MR_TRGSEL_ADC_TRIG5 = 0x5
	// Position of LOWRES field.
	ADC_MR_LOWRES_Pos = 0x4
	// Bit mask of LOWRES field.
	ADC_MR_LOWRES_Msk = 0x10
	// Bit LOWRES.
	ADC_MR_LOWRES = 0x10
	// 12-bit resolution
	ADC_MR_LOWRES_BITS_12 = 0x0
	// 10-bit resolution
	ADC_MR_LOWRES_BITS_10 = 0x1
	// Position of SLEEP field.
	ADC_MR_SLEEP_Pos = 0x5
	// Bit mask of SLEEP field.
	ADC_MR_SLEEP_Msk = 0x20
	// Bit SLEEP.
	ADC_MR_SLEEP = 0x20
	// Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions
	ADC_MR_SLEEP_NORMAL = 0x0
	// Sleep Mode: The ADC Core and reference voltage circuitry are OFF between conversions
	ADC_MR_SLEEP_SLEEP = 0x1
	// Position of FWUP field.
	ADC_MR_FWUP_Pos = 0x6
	// Bit mask of FWUP field.
	ADC_MR_FWUP_Msk = 0x40
	// Bit FWUP.
	ADC_MR_FWUP = 0x40
	// Normal Sleep Mode: The sleep mode is defined by the SLEEP bit
	ADC_MR_FWUP_OFF = 0x0
	// Fast Wake Up Sleep Mode: The Voltage reference is ON between conversions and ADC Core is OFF
	ADC_MR_FWUP_ON = 0x1
	// Position of FREERUN field.
	ADC_MR_FREERUN_Pos = 0x7
	// Bit mask of FREERUN field.
	ADC_MR_FREERUN_Msk = 0x80
	// Bit FREERUN.
	ADC_MR_FREERUN = 0x80
	// Normal Mode
	ADC_MR_FREERUN_OFF = 0x0
	// Free Run Mode: Never wait for any trigger.
	ADC_MR_FREERUN_ON = 0x1
	// Position of PRESCAL field.
	ADC_MR_PRESCAL_Pos = 0x8
	// Bit mask of PRESCAL field.
	ADC_MR_PRESCAL_Msk = 0xff00
	// Position of STARTUP field.
	ADC_MR_STARTUP_Pos = 0x10
	// Bit mask of STARTUP field.
	ADC_MR_STARTUP_Msk = 0xf0000
	// 0 periods of ADCClock
	ADC_MR_STARTUP_SUT0 = 0x0
	// 8 periods of ADCClock
	ADC_MR_STARTUP_SUT8 = 0x1
	// 16 periods of ADCClock
	ADC_MR_STARTUP_SUT16 = 0x2
	// 24 periods of ADCClock
	ADC_MR_STARTUP_SUT24 = 0x3
	// 64 periods of ADCClock
	ADC_MR_STARTUP_SUT64 = 0x4
	// 80 periods of ADCClock
	ADC_MR_STARTUP_SUT80 = 0x5
	// 96 periods of ADCClock
	ADC_MR_STARTUP_SUT96 = 0x6
	// 112 periods of ADCClock
	ADC_MR_STARTUP_SUT112 = 0x7
	// 512 periods of ADCClock
	ADC_MR_STARTUP_SUT512 = 0x8
	// 576 periods of ADCClock
	ADC_MR_STARTUP_SUT576 = 0x9
	// 640 periods of ADCClock
	ADC_MR_STARTUP_SUT640 = 0xa
	// 704 periods of ADCClock
	ADC_MR_STARTUP_SUT704 = 0xb
	// 768 periods of ADCClock
	ADC_MR_STARTUP_SUT768 = 0xc
	// 832 periods of ADCClock
	ADC_MR_STARTUP_SUT832 = 0xd
	// 896 periods of ADCClock
	ADC_MR_STARTUP_SUT896 = 0xe
	// 960 periods of ADCClock
	ADC_MR_STARTUP_SUT960 = 0xf
	// Position of SETTLING field.
	ADC_MR_SETTLING_Pos = 0x14
	// Bit mask of SETTLING field.
	ADC_MR_SETTLING_Msk = 0x300000
	// 3 periods of ADCClock
	ADC_MR_SETTLING_AST3 = 0x0
	// 5 periods of ADCClock
	ADC_MR_SETTLING_AST5 = 0x1
	// 9 periods of ADCClock
	ADC_MR_SETTLING_AST9 = 0x2
	// 17 periods of ADCClock
	ADC_MR_SETTLING_AST17 = 0x3
	// Position of ANACH field.
	ADC_MR_ANACH_Pos = 0x17
	// Bit mask of ANACH field.
	ADC_MR_ANACH_Msk = 0x800000
	// Bit ANACH.
	ADC_MR_ANACH = 0x800000
	// No analog change on channel switching: DIFF0, GAIN0 and OFF0 are used for all channels
	ADC_MR_ANACH_NONE = 0x0
	// Allows different analog settings for each channel. See ADC_CGR and ADC_COR Registers
	ADC_MR_ANACH_ALLOWED = 0x1
	// Position of TRACKTIM field.
	ADC_MR_TRACKTIM_Pos = 0x18
	// Bit mask of TRACKTIM field.
	ADC_MR_TRACKTIM_Msk = 0xf000000
	// Position of TRANSFER field.
	ADC_MR_TRANSFER_Pos = 0x1c
	// Bit mask of TRANSFER field.
	ADC_MR_TRANSFER_Msk = 0x30000000
	// Position of USEQ field.
	ADC_MR_USEQ_Pos = 0x1f
	// Bit mask of USEQ field.
	ADC_MR_USEQ_Msk = 0x80000000
	// Bit USEQ.
	ADC_MR_USEQ = 0x80000000
	// Normal Mode: The controller converts channels in a simple numeric order.
	ADC_MR_USEQ_NUM_ORDER = 0x0
	// User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers.
	ADC_MR_USEQ_REG_ORDER = 0x1

	// SEQR1: Channel Sequence Register 1
	// Position of USCH1 field.
	ADC_SEQR1_USCH1_Pos = 0x0
	// Bit mask of USCH1 field.
	ADC_SEQR1_USCH1_Msk = 0x7
	// Position of USCH2 field.
	ADC_SEQR1_USCH2_Pos = 0x4
	// Bit mask of USCH2 field.
	ADC_SEQR1_USCH2_Msk = 0x70
	// Position of USCH3 field.
	ADC_SEQR1_USCH3_Pos = 0x8
	// Bit mask of USCH3 field.
	ADC_SEQR1_USCH3_Msk = 0x700
	// Position of USCH4 field.
	ADC_SEQR1_USCH4_Pos = 0xc
	// Bit mask of USCH4 field.
	ADC_SEQR1_USCH4_Msk = 0x7000
	// Position of USCH5 field.
	ADC_SEQR1_USCH5_Pos = 0x10
	// Bit mask of USCH5 field.
	ADC_SEQR1_USCH5_Msk = 0x70000
	// Position of USCH6 field.
	ADC_SEQR1_USCH6_Pos = 0x14
	// Bit mask of USCH6 field.
	ADC_SEQR1_USCH6_Msk = 0x700000
	// Position of USCH7 field.
	ADC_SEQR1_USCH7_Pos = 0x18
	// Bit mask of USCH7 field.
	ADC_SEQR1_USCH7_Msk = 0x7000000
	// Position of USCH8 field.
	ADC_SEQR1_USCH8_Pos = 0x1c
	// Bit mask of USCH8 field.
	ADC_SEQR1_USCH8_Msk = 0x70000000

	// SEQR2: Channel Sequence Register 2
	// Position of USCH9 field.
	ADC_SEQR2_USCH9_Pos = 0x0
	// Bit mask of USCH9 field.
	ADC_SEQR2_USCH9_Msk = 0x7
	// Position of USCH10 field.
	ADC_SEQR2_USCH10_Pos = 0x4
	// Bit mask of USCH10 field.
	ADC_SEQR2_USCH10_Msk = 0x70
	// Position of USCH11 field.
	ADC_SEQR2_USCH11_Pos = 0x8
	// Bit mask of USCH11 field.
	ADC_SEQR2_USCH11_Msk = 0x700
	// Position of USCH12 field.
	ADC_SEQR2_USCH12_Pos = 0xc
	// Bit mask of USCH12 field.
	ADC_SEQR2_USCH12_Msk = 0x7000
	// Position of USCH13 field.
	ADC_SEQR2_USCH13_Pos = 0x10
	// Bit mask of USCH13 field.
	ADC_SEQR2_USCH13_Msk = 0x70000
	// Position of USCH14 field.
	ADC_SEQR2_USCH14_Pos = 0x14
	// Bit mask of USCH14 field.
	ADC_SEQR2_USCH14_Msk = 0x700000
	// Position of USCH15 field.
	ADC_SEQR2_USCH15_Pos = 0x18
	// Bit mask of USCH15 field.
	ADC_SEQR2_USCH15_Msk = 0x7000000
	// Position of USCH16 field.
	ADC_SEQR2_USCH16_Pos = 0x1c
	// Bit mask of USCH16 field.
	ADC_SEQR2_USCH16_Msk = 0x70000000

	// CHER: Channel Enable Register
	// Position of CH0 field.
	ADC_CHER_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHER_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHER_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHER_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHER_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHER_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHER_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHER_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHER_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHER_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHER_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHER_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHER_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHER_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHER_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHER_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHER_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHER_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHER_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHER_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHER_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHER_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHER_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHER_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHER_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHER_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHER_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHER_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHER_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHER_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHER_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHER_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHER_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHER_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHER_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHER_CH11 = 0x800
	// Position of CH12 field.
	ADC_CHER_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	ADC_CHER_CH12_Msk = 0x1000
	// Bit CH12.
	ADC_CHER_CH12 = 0x1000
	// Position of CH13 field.
	ADC_CHER_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	ADC_CHER_CH13_Msk = 0x2000
	// Bit CH13.
	ADC_CHER_CH13 = 0x2000
	// Position of CH14 field.
	ADC_CHER_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	ADC_CHER_CH14_Msk = 0x4000
	// Bit CH14.
	ADC_CHER_CH14 = 0x4000
	// Position of CH15 field.
	ADC_CHER_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	ADC_CHER_CH15_Msk = 0x8000
	// Bit CH15.
	ADC_CHER_CH15 = 0x8000

	// CHDR: Channel Disable Register
	// Position of CH0 field.
	ADC_CHDR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHDR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHDR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHDR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHDR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHDR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHDR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHDR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHDR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHDR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHDR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHDR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHDR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHDR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHDR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHDR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHDR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHDR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHDR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHDR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHDR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHDR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHDR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHDR_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHDR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHDR_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHDR_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHDR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHDR_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHDR_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHDR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHDR_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHDR_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHDR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHDR_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHDR_CH11 = 0x800
	// Position of CH12 field.
	ADC_CHDR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	ADC_CHDR_CH12_Msk = 0x1000
	// Bit CH12.
	ADC_CHDR_CH12 = 0x1000
	// Position of CH13 field.
	ADC_CHDR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	ADC_CHDR_CH13_Msk = 0x2000
	// Bit CH13.
	ADC_CHDR_CH13 = 0x2000
	// Position of CH14 field.
	ADC_CHDR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	ADC_CHDR_CH14_Msk = 0x4000
	// Bit CH14.
	ADC_CHDR_CH14 = 0x4000
	// Position of CH15 field.
	ADC_CHDR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	ADC_CHDR_CH15_Msk = 0x8000
	// Bit CH15.
	ADC_CHDR_CH15 = 0x8000

	// CHSR: Channel Status Register
	// Position of CH0 field.
	ADC_CHSR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHSR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHSR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHSR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHSR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHSR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHSR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHSR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHSR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHSR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHSR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHSR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHSR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHSR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHSR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHSR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHSR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHSR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHSR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHSR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHSR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHSR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHSR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHSR_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHSR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHSR_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHSR_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHSR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHSR_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHSR_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHSR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHSR_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHSR_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHSR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHSR_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHSR_CH11 = 0x800
	// Position of CH12 field.
	ADC_CHSR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	ADC_CHSR_CH12_Msk = 0x1000
	// Bit CH12.
	ADC_CHSR_CH12 = 0x1000
	// Position of CH13 field.
	ADC_CHSR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	ADC_CHSR_CH13_Msk = 0x2000
	// Bit CH13.
	ADC_CHSR_CH13 = 0x2000
	// Position of CH14 field.
	ADC_CHSR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	ADC_CHSR_CH14_Msk = 0x4000
	// Bit CH14.
	ADC_CHSR_CH14 = 0x4000
	// Position of CH15 field.
	ADC_CHSR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	ADC_CHSR_CH15_Msk = 0x8000
	// Bit CH15.
	ADC_CHSR_CH15 = 0x8000

	// LCDR: Last Converted Data Register
	// Position of LDATA field.
	ADC_LCDR_LDATA_Pos = 0x0
	// Bit mask of LDATA field.
	ADC_LCDR_LDATA_Msk = 0xfff
	// Position of CHNB field.
	ADC_LCDR_CHNB_Pos = 0xc
	// Bit mask of CHNB field.
	ADC_LCDR_CHNB_Msk = 0xf000

	// IER: Interrupt Enable Register
	// Position of EOC0 field.
	ADC_IER_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IER_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IER_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IER_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IER_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IER_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IER_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IER_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IER_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IER_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IER_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IER_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IER_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IER_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IER_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IER_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IER_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IER_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IER_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IER_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IER_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IER_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IER_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IER_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IER_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IER_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IER_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IER_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IER_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IER_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IER_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IER_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IER_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IER_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IER_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IER_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_IER_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_IER_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_IER_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_IER_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_IER_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_IER_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_IER_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_IER_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_IER_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_IER_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_IER_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_IER_EOC15 = 0x8000
	// Position of EOCAL field.
	ADC_IER_EOCAL_Pos = 0x17
	// Bit mask of EOCAL field.
	ADC_IER_EOCAL_Msk = 0x800000
	// Bit EOCAL.
	ADC_IER_EOCAL = 0x800000
	// Position of DRDY field.
	ADC_IER_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IER_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IER_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IER_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IER_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IER_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IER_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IER_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IER_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IER_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IER_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IER_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IER_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IER_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IER_RXBUFF = 0x10000000

	// IDR: Interrupt Disable Register
	// Position of EOC0 field.
	ADC_IDR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IDR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IDR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IDR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IDR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IDR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IDR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IDR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IDR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IDR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IDR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IDR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IDR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IDR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IDR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IDR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IDR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IDR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IDR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IDR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IDR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IDR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IDR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IDR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IDR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IDR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IDR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IDR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IDR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IDR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IDR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IDR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IDR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IDR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IDR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IDR_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_IDR_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_IDR_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_IDR_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_IDR_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_IDR_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_IDR_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_IDR_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_IDR_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_IDR_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_IDR_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_IDR_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_IDR_EOC15 = 0x8000
	// Position of EOCAL field.
	ADC_IDR_EOCAL_Pos = 0x17
	// Bit mask of EOCAL field.
	ADC_IDR_EOCAL_Msk = 0x800000
	// Bit EOCAL.
	ADC_IDR_EOCAL = 0x800000
	// Position of DRDY field.
	ADC_IDR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IDR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IDR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IDR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IDR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IDR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IDR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IDR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IDR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IDR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IDR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IDR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IDR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IDR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IDR_RXBUFF = 0x10000000

	// IMR: Interrupt Mask Register
	// Position of EOC0 field.
	ADC_IMR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IMR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IMR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IMR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IMR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IMR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IMR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IMR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IMR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IMR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IMR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IMR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IMR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IMR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IMR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IMR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IMR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IMR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IMR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IMR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IMR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IMR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IMR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IMR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IMR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IMR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IMR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IMR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IMR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IMR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IMR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IMR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IMR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IMR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IMR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IMR_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_IMR_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_IMR_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_IMR_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_IMR_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_IMR_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_IMR_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_IMR_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_IMR_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_IMR_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_IMR_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_IMR_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_IMR_EOC15 = 0x8000
	// Position of EOCAL field.
	ADC_IMR_EOCAL_Pos = 0x17
	// Bit mask of EOCAL field.
	ADC_IMR_EOCAL_Msk = 0x800000
	// Bit EOCAL.
	ADC_IMR_EOCAL = 0x800000
	// Position of DRDY field.
	ADC_IMR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IMR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IMR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IMR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IMR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IMR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IMR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IMR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IMR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IMR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IMR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IMR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IMR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IMR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IMR_RXBUFF = 0x10000000

	// ISR: Interrupt Status Register
	// Position of EOC0 field.
	ADC_ISR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_ISR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_ISR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_ISR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_ISR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_ISR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_ISR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_ISR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_ISR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_ISR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_ISR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_ISR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_ISR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_ISR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_ISR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_ISR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_ISR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_ISR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_ISR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_ISR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_ISR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_ISR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_ISR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_ISR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_ISR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_ISR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_ISR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_ISR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_ISR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_ISR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_ISR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_ISR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_ISR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_ISR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_ISR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_ISR_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_ISR_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_ISR_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_ISR_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_ISR_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_ISR_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_ISR_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_ISR_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_ISR_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_ISR_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_ISR_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_ISR_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_ISR_EOC15 = 0x8000
	// Position of EOCAL field.
	ADC_ISR_EOCAL_Pos = 0x17
	// Bit mask of EOCAL field.
	ADC_ISR_EOCAL_Msk = 0x800000
	// Bit EOCAL.
	ADC_ISR_EOCAL = 0x800000
	// Position of DRDY field.
	ADC_ISR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_ISR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_ISR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_ISR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_ISR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_ISR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_ISR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_ISR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_ISR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_ISR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_ISR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_ISR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_ISR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_ISR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_ISR_RXBUFF = 0x10000000

	// OVER: Overrun Status Register
	// Position of OVRE0 field.
	ADC_OVER_OVRE0_Pos = 0x0
	// Bit mask of OVRE0 field.
	ADC_OVER_OVRE0_Msk = 0x1
	// Bit OVRE0.
	ADC_OVER_OVRE0 = 0x1
	// Position of OVRE1 field.
	ADC_OVER_OVRE1_Pos = 0x1
	// Bit mask of OVRE1 field.
	ADC_OVER_OVRE1_Msk = 0x2
	// Bit OVRE1.
	ADC_OVER_OVRE1 = 0x2
	// Position of OVRE2 field.
	ADC_OVER_OVRE2_Pos = 0x2
	// Bit mask of OVRE2 field.
	ADC_OVER_OVRE2_Msk = 0x4
	// Bit OVRE2.
	ADC_OVER_OVRE2 = 0x4
	// Position of OVRE3 field.
	ADC_OVER_OVRE3_Pos = 0x3
	// Bit mask of OVRE3 field.
	ADC_OVER_OVRE3_Msk = 0x8
	// Bit OVRE3.
	ADC_OVER_OVRE3 = 0x8
	// Position of OVRE4 field.
	ADC_OVER_OVRE4_Pos = 0x4
	// Bit mask of OVRE4 field.
	ADC_OVER_OVRE4_Msk = 0x10
	// Bit OVRE4.
	ADC_OVER_OVRE4 = 0x10
	// Position of OVRE5 field.
	ADC_OVER_OVRE5_Pos = 0x5
	// Bit mask of OVRE5 field.
	ADC_OVER_OVRE5_Msk = 0x20
	// Bit OVRE5.
	ADC_OVER_OVRE5 = 0x20
	// Position of OVRE6 field.
	ADC_OVER_OVRE6_Pos = 0x6
	// Bit mask of OVRE6 field.
	ADC_OVER_OVRE6_Msk = 0x40
	// Bit OVRE6.
	ADC_OVER_OVRE6 = 0x40
	// Position of OVRE7 field.
	ADC_OVER_OVRE7_Pos = 0x7
	// Bit mask of OVRE7 field.
	ADC_OVER_OVRE7_Msk = 0x80
	// Bit OVRE7.
	ADC_OVER_OVRE7 = 0x80
	// Position of OVRE8 field.
	ADC_OVER_OVRE8_Pos = 0x8
	// Bit mask of OVRE8 field.
	ADC_OVER_OVRE8_Msk = 0x100
	// Bit OVRE8.
	ADC_OVER_OVRE8 = 0x100
	// Position of OVRE9 field.
	ADC_OVER_OVRE9_Pos = 0x9
	// Bit mask of OVRE9 field.
	ADC_OVER_OVRE9_Msk = 0x200
	// Bit OVRE9.
	ADC_OVER_OVRE9 = 0x200
	// Position of OVRE10 field.
	ADC_OVER_OVRE10_Pos = 0xa
	// Bit mask of OVRE10 field.
	ADC_OVER_OVRE10_Msk = 0x400
	// Bit OVRE10.
	ADC_OVER_OVRE10 = 0x400
	// Position of OVRE11 field.
	ADC_OVER_OVRE11_Pos = 0xb
	// Bit mask of OVRE11 field.
	ADC_OVER_OVRE11_Msk = 0x800
	// Bit OVRE11.
	ADC_OVER_OVRE11 = 0x800
	// Position of OVRE12 field.
	ADC_OVER_OVRE12_Pos = 0xc
	// Bit mask of OVRE12 field.
	ADC_OVER_OVRE12_Msk = 0x1000
	// Bit OVRE12.
	ADC_OVER_OVRE12 = 0x1000
	// Position of OVRE13 field.
	ADC_OVER_OVRE13_Pos = 0xd
	// Bit mask of OVRE13 field.
	ADC_OVER_OVRE13_Msk = 0x2000
	// Bit OVRE13.
	ADC_OVER_OVRE13 = 0x2000
	// Position of OVRE14 field.
	ADC_OVER_OVRE14_Pos = 0xe
	// Bit mask of OVRE14 field.
	ADC_OVER_OVRE14_Msk = 0x4000
	// Bit OVRE14.
	ADC_OVER_OVRE14 = 0x4000
	// Position of OVRE15 field.
	ADC_OVER_OVRE15_Pos = 0xf
	// Bit mask of OVRE15 field.
	ADC_OVER_OVRE15_Msk = 0x8000
	// Bit OVRE15.
	ADC_OVER_OVRE15 = 0x8000

	// EMR: Extended Mode Register
	// Position of CMPMODE field.
	ADC_EMR_CMPMODE_Pos = 0x0
	// Bit mask of CMPMODE field.
	ADC_EMR_CMPMODE_Msk = 0x3
	// Generates an event when the converted data is lower than the low threshold of the window.
	ADC_EMR_CMPMODE_LOW = 0x0
	// Generates an event when the converted data is higher than the high threshold of the window.
	ADC_EMR_CMPMODE_HIGH = 0x1
	// Generates an event when the converted data is in the comparison window.
	ADC_EMR_CMPMODE_IN = 0x2
	// Generates an event when the converted data is out of the comparison window.
	ADC_EMR_CMPMODE_OUT = 0x3
	// Position of CMPSEL field.
	ADC_EMR_CMPSEL_Pos = 0x4
	// Bit mask of CMPSEL field.
	ADC_EMR_CMPSEL_Msk = 0xf0
	// Position of CMPALL field.
	ADC_EMR_CMPALL_Pos = 0x9
	// Bit mask of CMPALL field.
	ADC_EMR_CMPALL_Msk = 0x200
	// Bit CMPALL.
	ADC_EMR_CMPALL = 0x200
	// Position of CMPFILTER field.
	ADC_EMR_CMPFILTER_Pos = 0xc
	// Bit mask of CMPFILTER field.
	ADC_EMR_CMPFILTER_Msk = 0x3000
	// Position of TAG field.
	ADC_EMR_TAG_Pos = 0x18
	// Bit mask of TAG field.
	ADC_EMR_TAG_Msk = 0x1000000
	// Bit TAG.
	ADC_EMR_TAG = 0x1000000

	// CWR: Compare Window Register
	// Position of LOWTHRES field.
	ADC_CWR_LOWTHRES_Pos = 0x0
	// Bit mask of LOWTHRES field.
	ADC_CWR_LOWTHRES_Msk = 0xfff
	// Position of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Pos = 0x10
	// Bit mask of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Msk = 0xfff0000

	// CGR: Channel Gain Register
	// Position of GAIN0 field.
	ADC_CGR_GAIN0_Pos = 0x0
	// Bit mask of GAIN0 field.
	ADC_CGR_GAIN0_Msk = 0x3
	// Position of GAIN1 field.
	ADC_CGR_GAIN1_Pos = 0x2
	// Bit mask of GAIN1 field.
	ADC_CGR_GAIN1_Msk = 0xc
	// Position of GAIN2 field.
	ADC_CGR_GAIN2_Pos = 0x4
	// Bit mask of GAIN2 field.
	ADC_CGR_GAIN2_Msk = 0x30
	// Position of GAIN3 field.
	ADC_CGR_GAIN3_Pos = 0x6
	// Bit mask of GAIN3 field.
	ADC_CGR_GAIN3_Msk = 0xc0
	// Position of GAIN4 field.
	ADC_CGR_GAIN4_Pos = 0x8
	// Bit mask of GAIN4 field.
	ADC_CGR_GAIN4_Msk = 0x300
	// Position of GAIN5 field.
	ADC_CGR_GAIN5_Pos = 0xa
	// Bit mask of GAIN5 field.
	ADC_CGR_GAIN5_Msk = 0xc00
	// Position of GAIN6 field.
	ADC_CGR_GAIN6_Pos = 0xc
	// Bit mask of GAIN6 field.
	ADC_CGR_GAIN6_Msk = 0x3000
	// Position of GAIN7 field.
	ADC_CGR_GAIN7_Pos = 0xe
	// Bit mask of GAIN7 field.
	ADC_CGR_GAIN7_Msk = 0xc000
	// Position of GAIN8 field.
	ADC_CGR_GAIN8_Pos = 0x10
	// Bit mask of GAIN8 field.
	ADC_CGR_GAIN8_Msk = 0x30000
	// Position of GAIN9 field.
	ADC_CGR_GAIN9_Pos = 0x12
	// Bit mask of GAIN9 field.
	ADC_CGR_GAIN9_Msk = 0xc0000
	// Position of GAIN10 field.
	ADC_CGR_GAIN10_Pos = 0x14
	// Bit mask of GAIN10 field.
	ADC_CGR_GAIN10_Msk = 0x300000
	// Position of GAIN11 field.
	ADC_CGR_GAIN11_Pos = 0x16
	// Bit mask of GAIN11 field.
	ADC_CGR_GAIN11_Msk = 0xc00000
	// Position of GAIN12 field.
	ADC_CGR_GAIN12_Pos = 0x18
	// Bit mask of GAIN12 field.
	ADC_CGR_GAIN12_Msk = 0x3000000
	// Position of GAIN13 field.
	ADC_CGR_GAIN13_Pos = 0x1a
	// Bit mask of GAIN13 field.
	ADC_CGR_GAIN13_Msk = 0xc000000
	// Position of GAIN14 field.
	ADC_CGR_GAIN14_Pos = 0x1c
	// Bit mask of GAIN14 field.
	ADC_CGR_GAIN14_Msk = 0x30000000
	// Position of GAIN15 field.
	ADC_CGR_GAIN15_Pos = 0x1e
	// Bit mask of GAIN15 field.
	ADC_CGR_GAIN15_Msk = 0xc0000000

	// COR: Channel Offset Register
	// Position of OFF0 field.
	ADC_COR_OFF0_Pos = 0x0
	// Bit mask of OFF0 field.
	ADC_COR_OFF0_Msk = 0x1
	// Bit OFF0.
	ADC_COR_OFF0 = 0x1
	// Position of OFF1 field.
	ADC_COR_OFF1_Pos = 0x1
	// Bit mask of OFF1 field.
	ADC_COR_OFF1_Msk = 0x2
	// Bit OFF1.
	ADC_COR_OFF1 = 0x2
	// Position of OFF2 field.
	ADC_COR_OFF2_Pos = 0x2
	// Bit mask of OFF2 field.
	ADC_COR_OFF2_Msk = 0x4
	// Bit OFF2.
	ADC_COR_OFF2 = 0x4
	// Position of OFF3 field.
	ADC_COR_OFF3_Pos = 0x3
	// Bit mask of OFF3 field.
	ADC_COR_OFF3_Msk = 0x8
	// Bit OFF3.
	ADC_COR_OFF3 = 0x8
	// Position of OFF4 field.
	ADC_COR_OFF4_Pos = 0x4
	// Bit mask of OFF4 field.
	ADC_COR_OFF4_Msk = 0x10
	// Bit OFF4.
	ADC_COR_OFF4 = 0x10
	// Position of OFF5 field.
	ADC_COR_OFF5_Pos = 0x5
	// Bit mask of OFF5 field.
	ADC_COR_OFF5_Msk = 0x20
	// Bit OFF5.
	ADC_COR_OFF5 = 0x20
	// Position of OFF6 field.
	ADC_COR_OFF6_Pos = 0x6
	// Bit mask of OFF6 field.
	ADC_COR_OFF6_Msk = 0x40
	// Bit OFF6.
	ADC_COR_OFF6 = 0x40
	// Position of OFF7 field.
	ADC_COR_OFF7_Pos = 0x7
	// Bit mask of OFF7 field.
	ADC_COR_OFF7_Msk = 0x80
	// Bit OFF7.
	ADC_COR_OFF7 = 0x80
	// Position of OFF8 field.
	ADC_COR_OFF8_Pos = 0x8
	// Bit mask of OFF8 field.
	ADC_COR_OFF8_Msk = 0x100
	// Bit OFF8.
	ADC_COR_OFF8 = 0x100
	// Position of OFF9 field.
	ADC_COR_OFF9_Pos = 0x9
	// Bit mask of OFF9 field.
	ADC_COR_OFF9_Msk = 0x200
	// Bit OFF9.
	ADC_COR_OFF9 = 0x200
	// Position of OFF10 field.
	ADC_COR_OFF10_Pos = 0xa
	// Bit mask of OFF10 field.
	ADC_COR_OFF10_Msk = 0x400
	// Bit OFF10.
	ADC_COR_OFF10 = 0x400
	// Position of OFF11 field.
	ADC_COR_OFF11_Pos = 0xb
	// Bit mask of OFF11 field.
	ADC_COR_OFF11_Msk = 0x800
	// Bit OFF11.
	ADC_COR_OFF11 = 0x800
	// Position of OFF12 field.
	ADC_COR_OFF12_Pos = 0xc
	// Bit mask of OFF12 field.
	ADC_COR_OFF12_Msk = 0x1000
	// Bit OFF12.
	ADC_COR_OFF12 = 0x1000
	// Position of OFF13 field.
	ADC_COR_OFF13_Pos = 0xd
	// Bit mask of OFF13 field.
	ADC_COR_OFF13_Msk = 0x2000
	// Bit OFF13.
	ADC_COR_OFF13 = 0x2000
	// Position of OFF14 field.
	ADC_COR_OFF14_Pos = 0xe
	// Bit mask of OFF14 field.
	ADC_COR_OFF14_Msk = 0x4000
	// Bit OFF14.
	ADC_COR_OFF14 = 0x4000
	// Position of OFF15 field.
	ADC_COR_OFF15_Pos = 0xf
	// Bit mask of OFF15 field.
	ADC_COR_OFF15_Msk = 0x8000
	// Bit OFF15.
	ADC_COR_OFF15 = 0x8000
	// Position of DIFF0 field.
	ADC_COR_DIFF0_Pos = 0x10
	// Bit mask of DIFF0 field.
	ADC_COR_DIFF0_Msk = 0x10000
	// Bit DIFF0.
	ADC_COR_DIFF0 = 0x10000
	// Position of DIFF1 field.
	ADC_COR_DIFF1_Pos = 0x11
	// Bit mask of DIFF1 field.
	ADC_COR_DIFF1_Msk = 0x20000
	// Bit DIFF1.
	ADC_COR_DIFF1 = 0x20000
	// Position of DIFF2 field.
	ADC_COR_DIFF2_Pos = 0x12
	// Bit mask of DIFF2 field.
	ADC_COR_DIFF2_Msk = 0x40000
	// Bit DIFF2.
	ADC_COR_DIFF2 = 0x40000
	// Position of DIFF3 field.
	ADC_COR_DIFF3_Pos = 0x13
	// Bit mask of DIFF3 field.
	ADC_COR_DIFF3_Msk = 0x80000
	// Bit DIFF3.
	ADC_COR_DIFF3 = 0x80000
	// Position of DIFF4 field.
	ADC_COR_DIFF4_Pos = 0x14
	// Bit mask of DIFF4 field.
	ADC_COR_DIFF4_Msk = 0x100000
	// Bit DIFF4.
	ADC_COR_DIFF4 = 0x100000
	// Position of DIFF5 field.
	ADC_COR_DIFF5_Pos = 0x15
	// Bit mask of DIFF5 field.
	ADC_COR_DIFF5_Msk = 0x200000
	// Bit DIFF5.
	ADC_COR_DIFF5 = 0x200000
	// Position of DIFF6 field.
	ADC_COR_DIFF6_Pos = 0x16
	// Bit mask of DIFF6 field.
	ADC_COR_DIFF6_Msk = 0x400000
	// Bit DIFF6.
	ADC_COR_DIFF6 = 0x400000
	// Position of DIFF7 field.
	ADC_COR_DIFF7_Pos = 0x17
	// Bit mask of DIFF7 field.
	ADC_COR_DIFF7_Msk = 0x800000
	// Bit DIFF7.
	ADC_COR_DIFF7 = 0x800000
	// Position of DIFF8 field.
	ADC_COR_DIFF8_Pos = 0x18
	// Bit mask of DIFF8 field.
	ADC_COR_DIFF8_Msk = 0x1000000
	// Bit DIFF8.
	ADC_COR_DIFF8 = 0x1000000
	// Position of DIFF9 field.
	ADC_COR_DIFF9_Pos = 0x19
	// Bit mask of DIFF9 field.
	ADC_COR_DIFF9_Msk = 0x2000000
	// Bit DIFF9.
	ADC_COR_DIFF9 = 0x2000000
	// Position of DIFF10 field.
	ADC_COR_DIFF10_Pos = 0x1a
	// Bit mask of DIFF10 field.
	ADC_COR_DIFF10_Msk = 0x4000000
	// Bit DIFF10.
	ADC_COR_DIFF10 = 0x4000000
	// Position of DIFF11 field.
	ADC_COR_DIFF11_Pos = 0x1b
	// Bit mask of DIFF11 field.
	ADC_COR_DIFF11_Msk = 0x8000000
	// Bit DIFF11.
	ADC_COR_DIFF11 = 0x8000000
	// Position of DIFF12 field.
	ADC_COR_DIFF12_Pos = 0x1c
	// Bit mask of DIFF12 field.
	ADC_COR_DIFF12_Msk = 0x10000000
	// Bit DIFF12.
	ADC_COR_DIFF12 = 0x10000000
	// Position of DIFF13 field.
	ADC_COR_DIFF13_Pos = 0x1d
	// Bit mask of DIFF13 field.
	ADC_COR_DIFF13_Msk = 0x20000000
	// Bit DIFF13.
	ADC_COR_DIFF13 = 0x20000000
	// Position of DIFF14 field.
	ADC_COR_DIFF14_Pos = 0x1e
	// Bit mask of DIFF14 field.
	ADC_COR_DIFF14_Msk = 0x40000000
	// Bit DIFF14.
	ADC_COR_DIFF14 = 0x40000000
	// Position of DIFF15 field.
	ADC_COR_DIFF15_Pos = 0x1f
	// Bit mask of DIFF15 field.
	ADC_COR_DIFF15_Msk = 0x80000000
	// Bit DIFF15.
	ADC_COR_DIFF15 = 0x80000000

	// CDR: Channel Data Register
	// Position of DATA field.
	ADC_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_CDR_DATA_Msk = 0xfff

	// ACR: Analog Control Register
	// Position of TSON field.
	ADC_ACR_TSON_Pos = 0x4
	// Bit mask of TSON field.
	ADC_ACR_TSON_Msk = 0x10
	// Bit TSON.
	ADC_ACR_TSON = 0x10
	// Position of IBCTL field.
	ADC_ACR_IBCTL_Pos = 0x8
	// Bit mask of IBCTL field.
	ADC_ACR_IBCTL_Msk = 0x300

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	ADC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	ADC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	ADC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	ADC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	ADC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	ADC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	ADC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	ADC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	ADC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	ADC_WPSR_WPVSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	ADC_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	ADC_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	ADC_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	ADC_RCR_RXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	ADC_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	ADC_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	ADC_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	ADC_RNCR_RXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	ADC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	ADC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	ADC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	ADC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	ADC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	ADC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	ADC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	ADC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	ADC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	ADC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC_PTSR_TXTEN = 0x100
)

// Bitfields for DACC: Digital-to-Analog Converter Controller
const (
	// CR: Control Register
	// Position of SWRST field.
	DACC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DACC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	DACC_CR_SWRST = 0x1

	// MR: Mode Register
	// Position of TRGEN field.
	DACC_MR_TRGEN_Pos = 0x0
	// Bit mask of TRGEN field.
	DACC_MR_TRGEN_Msk = 0x1
	// Bit TRGEN.
	DACC_MR_TRGEN = 0x1
	// External trigger mode disabled. DACC in free running mode.
	DACC_MR_TRGEN_DIS = 0x0
	// External trigger mode enabled.
	DACC_MR_TRGEN_EN = 0x1
	// Position of TRGSEL field.
	DACC_MR_TRGSEL_Pos = 0x1
	// Bit mask of TRGSEL field.
	DACC_MR_TRGSEL_Msk = 0xe
	// Position of WORD field.
	DACC_MR_WORD_Pos = 0x4
	// Bit mask of WORD field.
	DACC_MR_WORD_Msk = 0x10
	// Bit WORD.
	DACC_MR_WORD = 0x10
	// Half-Word transfer
	DACC_MR_WORD_HALF = 0x0
	// Word Transfer
	DACC_MR_WORD_WORD = 0x1
	// Position of SLEEP field.
	DACC_MR_SLEEP_Pos = 0x5
	// Bit mask of SLEEP field.
	DACC_MR_SLEEP_Msk = 0x20
	// Bit SLEEP.
	DACC_MR_SLEEP = 0x20
	// Position of FASTWKUP field.
	DACC_MR_FASTWKUP_Pos = 0x6
	// Bit mask of FASTWKUP field.
	DACC_MR_FASTWKUP_Msk = 0x40
	// Bit FASTWKUP.
	DACC_MR_FASTWKUP = 0x40
	// Position of REFRESH field.
	DACC_MR_REFRESH_Pos = 0x8
	// Bit mask of REFRESH field.
	DACC_MR_REFRESH_Msk = 0xff00
	// Position of USER_SEL field.
	DACC_MR_USER_SEL_Pos = 0x10
	// Bit mask of USER_SEL field.
	DACC_MR_USER_SEL_Msk = 0x30000
	// Channel 0
	DACC_MR_USER_SEL_CHANNEL0 = 0x0
	// Channel 1
	DACC_MR_USER_SEL_CHANNEL1 = 0x1
	// Position of TAG field.
	DACC_MR_TAG_Pos = 0x14
	// Bit mask of TAG field.
	DACC_MR_TAG_Msk = 0x100000
	// Bit TAG.
	DACC_MR_TAG = 0x100000
	// Tag selection mode disabled. Using USER_SEL to select the channel for the conversion.
	DACC_MR_TAG_DIS = 0x0
	// Tag selection mode enabled
	DACC_MR_TAG_EN = 0x1
	// Position of MAXS field.
	DACC_MR_MAXS_Pos = 0x15
	// Bit mask of MAXS field.
	DACC_MR_MAXS_Msk = 0x200000
	// Bit MAXS.
	DACC_MR_MAXS = 0x200000
	// Normal Mode
	DACC_MR_MAXS_NORMAL = 0x0
	// Max Speed Mode enabled
	DACC_MR_MAXS_MAXIMUM = 0x1
	// Position of STARTUP field.
	DACC_MR_STARTUP_Pos = 0x18
	// Bit mask of STARTUP field.
	DACC_MR_STARTUP_Msk = 0x3f000000
	// 0 periods of DACClock
	DACC_MR_STARTUP_0 = 0x0
	// 8 periods of DACClock
	DACC_MR_STARTUP_8 = 0x1
	// 16 periods of DACClock
	DACC_MR_STARTUP_16 = 0x2
	// 24 periods of DACClock
	DACC_MR_STARTUP_24 = 0x3
	// 64 periods of DACClock
	DACC_MR_STARTUP_64 = 0x4
	// 80 periods of DACClock
	DACC_MR_STARTUP_80 = 0x5
	// 96 periods of DACClock
	DACC_MR_STARTUP_96 = 0x6
	// 112 periods of DACClock
	DACC_MR_STARTUP_112 = 0x7
	// 512 periods of DACClock
	DACC_MR_STARTUP_512 = 0x8
	// 576 periods of DACClock
	DACC_MR_STARTUP_576 = 0x9
	// 640 periods of DACClock
	DACC_MR_STARTUP_640 = 0xa
	// 704 periods of DACClock
	DACC_MR_STARTUP_704 = 0xb
	// 768 periods of DACClock
	DACC_MR_STARTUP_768 = 0xc
	// 832 periods of DACClock
	DACC_MR_STARTUP_832 = 0xd
	// 896 periods of DACClock
	DACC_MR_STARTUP_896 = 0xe
	// 960 periods of DACClock
	DACC_MR_STARTUP_960 = 0xf
	// 1024 periods of DACClock
	DACC_MR_STARTUP_1024 = 0x10
	// 1088 periods of DACClock
	DACC_MR_STARTUP_1088 = 0x11
	// 1152 periods of DACClock
	DACC_MR_STARTUP_1152 = 0x12
	// 1216 periods of DACClock
	DACC_MR_STARTUP_1216 = 0x13
	// 1280 periods of DACClock
	DACC_MR_STARTUP_1280 = 0x14
	// 1344 periods of DACClock
	DACC_MR_STARTUP_1344 = 0x15
	// 1408 periods of DACClock
	DACC_MR_STARTUP_1408 = 0x16
	// 1472 periods of DACClock
	DACC_MR_STARTUP_1472 = 0x17
	// 1536 periods of DACClock
	DACC_MR_STARTUP_1536 = 0x18
	// 1600 periods of DACClock
	DACC_MR_STARTUP_1600 = 0x19
	// 1664 periods of DACClock
	DACC_MR_STARTUP_1664 = 0x1a
	// 1728 periods of DACClock
	DACC_MR_STARTUP_1728 = 0x1b
	// 1792 periods of DACClock
	DACC_MR_STARTUP_1792 = 0x1c
	// 1856 periods of DACClock
	DACC_MR_STARTUP_1856 = 0x1d
	// 1920 periods of DACClock
	DACC_MR_STARTUP_1920 = 0x1e
	// 1984 periods of DACClock
	DACC_MR_STARTUP_1984 = 0x1f

	// CHER: Channel Enable Register
	// Position of CH0 field.
	DACC_CHER_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DACC_CHER_CH0_Msk = 0x1
	// Bit CH0.
	DACC_CHER_CH0 = 0x1
	// Position of CH1 field.
	DACC_CHER_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DACC_CHER_CH1_Msk = 0x2
	// Bit CH1.
	DACC_CHER_CH1 = 0x2

	// CHDR: Channel Disable Register
	// Position of CH0 field.
	DACC_CHDR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DACC_CHDR_CH0_Msk = 0x1
	// Bit CH0.
	DACC_CHDR_CH0 = 0x1
	// Position of CH1 field.
	DACC_CHDR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DACC_CHDR_CH1_Msk = 0x2
	// Bit CH1.
	DACC_CHDR_CH1 = 0x2

	// CHSR: Channel Status Register
	// Position of CH0 field.
	DACC_CHSR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DACC_CHSR_CH0_Msk = 0x1
	// Bit CH0.
	DACC_CHSR_CH0 = 0x1
	// Position of CH1 field.
	DACC_CHSR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DACC_CHSR_CH1_Msk = 0x2
	// Bit CH1.
	DACC_CHSR_CH1 = 0x2

	// CDR: Conversion Data Register
	// Position of DATA field.
	DACC_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DACC_CDR_DATA_Msk = 0xffffffff

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	DACC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_IER_TXRDY = 0x1
	// Position of EOC field.
	DACC_IER_EOC_Pos = 0x1
	// Bit mask of EOC field.
	DACC_IER_EOC_Msk = 0x2
	// Bit EOC.
	DACC_IER_EOC = 0x2
	// Position of ENDTX field.
	DACC_IER_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	DACC_IER_ENDTX_Msk = 0x4
	// Bit ENDTX.
	DACC_IER_ENDTX = 0x4
	// Position of TXBUFE field.
	DACC_IER_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	DACC_IER_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	DACC_IER_TXBUFE = 0x8

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	DACC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_IDR_TXRDY = 0x1
	// Position of EOC field.
	DACC_IDR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	DACC_IDR_EOC_Msk = 0x2
	// Bit EOC.
	DACC_IDR_EOC = 0x2
	// Position of ENDTX field.
	DACC_IDR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	DACC_IDR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	DACC_IDR_ENDTX = 0x4
	// Position of TXBUFE field.
	DACC_IDR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	DACC_IDR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	DACC_IDR_TXBUFE = 0x8

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	DACC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_IMR_TXRDY = 0x1
	// Position of EOC field.
	DACC_IMR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	DACC_IMR_EOC_Msk = 0x2
	// Bit EOC.
	DACC_IMR_EOC = 0x2
	// Position of ENDTX field.
	DACC_IMR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	DACC_IMR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	DACC_IMR_ENDTX = 0x4
	// Position of TXBUFE field.
	DACC_IMR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	DACC_IMR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	DACC_IMR_TXBUFE = 0x8

	// ISR: Interrupt Status Register
	// Position of TXRDY field.
	DACC_ISR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_ISR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_ISR_TXRDY = 0x1
	// Position of EOC field.
	DACC_ISR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	DACC_ISR_EOC_Msk = 0x2
	// Bit EOC.
	DACC_ISR_EOC = 0x2
	// Position of ENDTX field.
	DACC_ISR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	DACC_ISR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	DACC_ISR_ENDTX = 0x4
	// Position of TXBUFE field.
	DACC_ISR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	DACC_ISR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	DACC_ISR_TXBUFE = 0x8

	// ACR: Analog Current Register
	// Position of IBCTLCH0 field.
	DACC_ACR_IBCTLCH0_Pos = 0x0
	// Bit mask of IBCTLCH0 field.
	DACC_ACR_IBCTLCH0_Msk = 0x3
	// Position of IBCTLCH1 field.
	DACC_ACR_IBCTLCH1_Pos = 0x2
	// Bit mask of IBCTLCH1 field.
	DACC_ACR_IBCTLCH1_Msk = 0xc
	// Position of IBCTLDACCORE field.
	DACC_ACR_IBCTLDACCORE_Pos = 0x8
	// Bit mask of IBCTLDACCORE field.
	DACC_ACR_IBCTLDACCORE_Msk = 0x300

	// WPMR: Write Protect Mode register
	// Position of WPEN field.
	DACC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	DACC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	DACC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	DACC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	DACC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status register
	// Position of WPROTERR field.
	DACC_WPSR_WPROTERR_Pos = 0x0
	// Bit mask of WPROTERR field.
	DACC_WPSR_WPROTERR_Msk = 0x1
	// Bit WPROTERR.
	DACC_WPSR_WPROTERR = 0x1
	// Position of WPROTADDR field.
	DACC_WPSR_WPROTADDR_Pos = 0x8
	// Bit mask of WPROTADDR field.
	DACC_WPSR_WPROTADDR_Msk = 0xff00

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	DACC_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	DACC_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	DACC_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	DACC_TCR_TXCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	DACC_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	DACC_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	DACC_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	DACC_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	DACC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	DACC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	DACC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	DACC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	DACC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	DACC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	DACC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	DACC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	DACC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	DACC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	DACC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	DACC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	DACC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	DACC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	DACC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	DACC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	DACC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	DACC_PTSR_TXTEN = 0x100
)

// Bitfields for ACC: Analog Comparator Controller
const (
	// CR: Control Register
	// Position of SWRST field.
	ACC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ACC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	ACC_CR_SWRST = 0x1

	// MR: Mode Register
	// Position of SELMINUS field.
	ACC_MR_SELMINUS_Pos = 0x0
	// Bit mask of SELMINUS field.
	ACC_MR_SELMINUS_Msk = 0x7
	// SelectTS
	ACC_MR_SELMINUS_TS = 0x0
	// Select ADVREF
	ACC_MR_SELMINUS_ADVREF = 0x1
	// Select DAC0
	ACC_MR_SELMINUS_DAC0 = 0x2
	// Select DAC1
	ACC_MR_SELMINUS_DAC1 = 0x3
	// Select AD0
	ACC_MR_SELMINUS_AD0 = 0x4
	// Select AD1
	ACC_MR_SELMINUS_AD1 = 0x5
	// Select AD2
	ACC_MR_SELMINUS_AD2 = 0x6
	// Select AD3
	ACC_MR_SELMINUS_AD3 = 0x7
	// Position of SELPLUS field.
	ACC_MR_SELPLUS_Pos = 0x4
	// Bit mask of SELPLUS field.
	ACC_MR_SELPLUS_Msk = 0x70
	// Select AD0
	ACC_MR_SELPLUS_AD0 = 0x0
	// Select AD1
	ACC_MR_SELPLUS_AD1 = 0x1
	// Select AD2
	ACC_MR_SELPLUS_AD2 = 0x2
	// Select AD3
	ACC_MR_SELPLUS_AD3 = 0x3
	// Select AD4
	ACC_MR_SELPLUS_AD4 = 0x4
	// Select AD5
	ACC_MR_SELPLUS_AD5 = 0x5
	// Select AD6
	ACC_MR_SELPLUS_AD6 = 0x6
	// Select AD7
	ACC_MR_SELPLUS_AD7 = 0x7
	// Position of ACEN field.
	ACC_MR_ACEN_Pos = 0x8
	// Bit mask of ACEN field.
	ACC_MR_ACEN_Msk = 0x100
	// Bit ACEN.
	ACC_MR_ACEN = 0x100
	// Analog Comparator Disabled.
	ACC_MR_ACEN_DIS = 0x0
	// Analog Comparator Enabled.
	ACC_MR_ACEN_EN = 0x1
	// Position of EDGETYP field.
	ACC_MR_EDGETYP_Pos = 0x9
	// Bit mask of EDGETYP field.
	ACC_MR_EDGETYP_Msk = 0x600
	// only rising edge of comparator output
	ACC_MR_EDGETYP_RISING = 0x0
	// falling edge of comparator output
	ACC_MR_EDGETYP_FALLING = 0x1
	// any edge of comparator output
	ACC_MR_EDGETYP_ANY = 0x2
	// Position of INV field.
	ACC_MR_INV_Pos = 0xc
	// Bit mask of INV field.
	ACC_MR_INV_Msk = 0x1000
	// Bit INV.
	ACC_MR_INV = 0x1000
	// Analog Comparator output is directly processed.
	ACC_MR_INV_DIS = 0x0
	// Analog Comparator output is inverted prior to being processed.
	ACC_MR_INV_EN = 0x1
	// Position of SELFS field.
	ACC_MR_SELFS_Pos = 0xd
	// Bit mask of SELFS field.
	ACC_MR_SELFS_Msk = 0x2000
	// Bit SELFS.
	ACC_MR_SELFS = 0x2000
	// the CF flag is used to drive the FAULT output.
	ACC_MR_SELFS_CF = 0x0
	// the output of the Analog Comparator flag is used to drive the FAULT output.
	ACC_MR_SELFS_OUTPUT = 0x1
	// Position of FE field.
	ACC_MR_FE_Pos = 0xe
	// Bit mask of FE field.
	ACC_MR_FE_Msk = 0x4000
	// Bit FE.
	ACC_MR_FE = 0x4000
	// the FAULT output is tied to 0.
	ACC_MR_FE_DIS = 0x0
	// the FAULT output is driven by the signal defined by SELFS.
	ACC_MR_FE_EN = 0x1

	// IER: Interrupt Enable Register
	// Position of CE field.
	ACC_IER_CE_Pos = 0x0
	// Bit mask of CE field.
	ACC_IER_CE_Msk = 0x1
	// Bit CE.
	ACC_IER_CE = 0x1

	// IDR: Interrupt Disable Register
	// Position of CE field.
	ACC_IDR_CE_Pos = 0x0
	// Bit mask of CE field.
	ACC_IDR_CE_Msk = 0x1
	// Bit CE.
	ACC_IDR_CE = 0x1

	// IMR: Interrupt Mask Register
	// Position of CE field.
	ACC_IMR_CE_Pos = 0x0
	// Bit mask of CE field.
	ACC_IMR_CE_Msk = 0x1
	// Bit CE.
	ACC_IMR_CE = 0x1

	// ISR: Interrupt Status Register
	// Position of CE field.
	ACC_ISR_CE_Pos = 0x0
	// Bit mask of CE field.
	ACC_ISR_CE_Msk = 0x1
	// Bit CE.
	ACC_ISR_CE = 0x1
	// Position of SCO field.
	ACC_ISR_SCO_Pos = 0x1
	// Bit mask of SCO field.
	ACC_ISR_SCO_Msk = 0x2
	// Bit SCO.
	ACC_ISR_SCO = 0x2
	// Position of MASK field.
	ACC_ISR_MASK_Pos = 0x1f
	// Bit mask of MASK field.
	ACC_ISR_MASK_Msk = 0x80000000
	// Bit MASK.
	ACC_ISR_MASK = 0x80000000

	// ACR: Analog Control Register
	// Position of ISEL field.
	ACC_ACR_ISEL_Pos = 0x0
	// Bit mask of ISEL field.
	ACC_ACR_ISEL_Msk = 0x1
	// Bit ISEL.
	ACC_ACR_ISEL = 0x1
	// low power option.
	ACC_ACR_ISEL_LOPW = 0x0
	// high speed option.
	ACC_ACR_ISEL_HISP = 0x1
	// Position of HYST field.
	ACC_ACR_HYST_Pos = 0x1
	// Bit mask of HYST field.
	ACC_ACR_HYST_Msk = 0x6

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	ACC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	ACC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	ACC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	ACC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	ACC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPROTERR field.
	ACC_WPSR_WPROTERR_Pos = 0x0
	// Bit mask of WPROTERR field.
	ACC_WPSR_WPROTERR_Msk = 0x1
	// Bit WPROTERR.
	ACC_WPSR_WPROTERR = 0x1
)

// Bitfields for CRCCU: Cyclic Redundancy Check Calculation Unit
const (
	// DSCR: CRCCU Descriptor Base Register
	// Position of DSCR field.
	CRCCU_DSCR_DSCR_Pos = 0x9
	// Bit mask of DSCR field.
	CRCCU_DSCR_DSCR_Msk = 0xfffffe00

	// DMA_EN: CRCCU DMA Enable Register
	// Position of DMAEN field.
	CRCCU_DMA_EN_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	CRCCU_DMA_EN_DMAEN_Msk = 0x1
	// Bit DMAEN.
	CRCCU_DMA_EN_DMAEN = 0x1

	// DMA_DIS: CRCCU DMA Disable Register
	// Position of DMADIS field.
	CRCCU_DMA_DIS_DMADIS_Pos = 0x0
	// Bit mask of DMADIS field.
	CRCCU_DMA_DIS_DMADIS_Msk = 0x1
	// Bit DMADIS.
	CRCCU_DMA_DIS_DMADIS = 0x1

	// DMA_SR: CRCCU DMA Status Register
	// Position of DMASR field.
	CRCCU_DMA_SR_DMASR_Pos = 0x0
	// Bit mask of DMASR field.
	CRCCU_DMA_SR_DMASR_Msk = 0x1
	// Bit DMASR.
	CRCCU_DMA_SR_DMASR = 0x1

	// DMA_IER: CRCCU DMA Interrupt Enable Register
	// Position of DMAIER field.
	CRCCU_DMA_IER_DMAIER_Pos = 0x0
	// Bit mask of DMAIER field.
	CRCCU_DMA_IER_DMAIER_Msk = 0x1
	// Bit DMAIER.
	CRCCU_DMA_IER_DMAIER = 0x1

	// DMA_IDR: CRCCU DMA Interrupt Disable Register
	// Position of DMAIDR field.
	CRCCU_DMA_IDR_DMAIDR_Pos = 0x0
	// Bit mask of DMAIDR field.
	CRCCU_DMA_IDR_DMAIDR_Msk = 0x1
	// Bit DMAIDR.
	CRCCU_DMA_IDR_DMAIDR = 0x1

	// DMA_IMR: CRCCU DMA Interrupt Mask Register
	// Position of DMAIMR field.
	CRCCU_DMA_IMR_DMAIMR_Pos = 0x0
	// Bit mask of DMAIMR field.
	CRCCU_DMA_IMR_DMAIMR_Msk = 0x1
	// Bit DMAIMR.
	CRCCU_DMA_IMR_DMAIMR = 0x1

	// DMA_ISR: CRCCU DMA Interrupt Status Register
	// Position of DMAISR field.
	CRCCU_DMA_ISR_DMAISR_Pos = 0x0
	// Bit mask of DMAISR field.
	CRCCU_DMA_ISR_DMAISR_Msk = 0x1
	// Bit DMAISR.
	CRCCU_DMA_ISR_DMAISR = 0x1

	// CR: CRCCU Control Register
	// Position of RESET field.
	CRCCU_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRCCU_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRCCU_CR_RESET = 0x1

	// MR: CRCCU Mode Register
	// Position of ENABLE field.
	CRCCU_MR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	CRCCU_MR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	CRCCU_MR_ENABLE = 0x1
	// Position of COMPARE field.
	CRCCU_MR_COMPARE_Pos = 0x1
	// Bit mask of COMPARE field.
	CRCCU_MR_COMPARE_Msk = 0x2
	// Bit COMPARE.
	CRCCU_MR_COMPARE = 0x2
	// Position of PTYPE field.
	CRCCU_MR_PTYPE_Pos = 0x2
	// Bit mask of PTYPE field.
	CRCCU_MR_PTYPE_Msk = 0xc
	// Polynom 0x04C11DB7
	CRCCU_MR_PTYPE_CCITT8023 = 0x0
	// Polynom 0x1EDC6F41
	CRCCU_MR_PTYPE_CASTAGNOLI = 0x1
	// Polynom 0x1021
	CRCCU_MR_PTYPE_CCITT16 = 0x2
	// Position of DIVIDER field.
	CRCCU_MR_DIVIDER_Pos = 0x4
	// Bit mask of DIVIDER field.
	CRCCU_MR_DIVIDER_Msk = 0xf0

	// SR: CRCCU Status Register
	// Position of CRC field.
	CRCCU_SR_CRC_Pos = 0x0
	// Bit mask of CRC field.
	CRCCU_SR_CRC_Msk = 0xffffffff

	// IER: CRCCU Interrupt Enable Register
	// Position of ERRIER field.
	CRCCU_IER_ERRIER_Pos = 0x0
	// Bit mask of ERRIER field.
	CRCCU_IER_ERRIER_Msk = 0x1
	// Bit ERRIER.
	CRCCU_IER_ERRIER = 0x1

	// IDR: CRCCU Interrupt Disable Register
	// Position of ERRIDR field.
	CRCCU_IDR_ERRIDR_Pos = 0x0
	// Bit mask of ERRIDR field.
	CRCCU_IDR_ERRIDR_Msk = 0x1
	// Bit ERRIDR.
	CRCCU_IDR_ERRIDR = 0x1

	// IMR: CRCCU Interrupt Mask Register
	// Position of ERRIMR field.
	CRCCU_IMR_ERRIMR_Pos = 0x0
	// Bit mask of ERRIMR field.
	CRCCU_IMR_ERRIMR_Msk = 0x1
	// Bit ERRIMR.
	CRCCU_IMR_ERRIMR = 0x1

	// ISR: CRCCU Interrupt Status Register
	// Position of ERRISR field.
	CRCCU_ISR_ERRISR_Pos = 0x0
	// Bit mask of ERRISR field.
	CRCCU_ISR_ERRISR_Msk = 0x1
	// Bit ERRISR.
	CRCCU_ISR_ERRISR = 0x1
)

// Bitfields for MATRIX: AHB Bus Matrix
const (
	// MATRIX_MCFG: Master Configuration Register
	// Position of ULBT field.
	MATRIX_MATRIX_MCFG_ULBT_Pos = 0x0
	// Bit mask of ULBT field.
	MATRIX_MATRIX_MCFG_ULBT_Msk = 0x7

	// MATRIX_SCFG: Slave Configuration Register
	// Position of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Pos = 0x0
	// Bit mask of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Msk = 0xff
	// Position of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Pos = 0x10
	// Bit mask of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Msk = 0x30000
	// Position of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Pos = 0x12
	// Bit mask of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Msk = 0x1c0000
	// Position of ARBT field.
	MATRIX_MATRIX_SCFG_ARBT_Pos = 0x18
	// Bit mask of ARBT field.
	MATRIX_MATRIX_SCFG_ARBT_Msk = 0x3000000

	// MATRIX_PRAS0: Priority Register A for Slave 0
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS0_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS0_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS0_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS0_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS0_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS0_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS0_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS0_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS0_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS0_M4PR_Msk = 0x30000

	// MATRIX_PRAS1: Priority Register A for Slave 1
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS1_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS1_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS1_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS1_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS1_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS1_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS1_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS1_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS1_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS1_M4PR_Msk = 0x30000

	// MATRIX_PRAS2: Priority Register A for Slave 2
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS2_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS2_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS2_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS2_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS2_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS2_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS2_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS2_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS2_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS2_M4PR_Msk = 0x30000

	// MATRIX_PRAS3: Priority Register A for Slave 3
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS3_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS3_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS3_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS3_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS3_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS3_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS3_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS3_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS3_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS3_M4PR_Msk = 0x30000

	// MATRIX_PRAS4: Priority Register A for Slave 4
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS4_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS4_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS4_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS4_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS4_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS4_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS4_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS4_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS4_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS4_M4PR_Msk = 0x30000

	// CCFG_SYSIO: System I/O Configuration register
	// Position of SYSIO4 field.
	MATRIX_CCFG_SYSIO_SYSIO4_Pos = 0x4
	// Bit mask of SYSIO4 field.
	MATRIX_CCFG_SYSIO_SYSIO4_Msk = 0x10
	// Bit SYSIO4.
	MATRIX_CCFG_SYSIO_SYSIO4 = 0x10
	// Position of SYSIO5 field.
	MATRIX_CCFG_SYSIO_SYSIO5_Pos = 0x5
	// Bit mask of SYSIO5 field.
	MATRIX_CCFG_SYSIO_SYSIO5_Msk = 0x20
	// Bit SYSIO5.
	MATRIX_CCFG_SYSIO_SYSIO5 = 0x20
	// Position of SYSIO6 field.
	MATRIX_CCFG_SYSIO_SYSIO6_Pos = 0x6
	// Bit mask of SYSIO6 field.
	MATRIX_CCFG_SYSIO_SYSIO6_Msk = 0x40
	// Bit SYSIO6.
	MATRIX_CCFG_SYSIO_SYSIO6 = 0x40
	// Position of SYSIO7 field.
	MATRIX_CCFG_SYSIO_SYSIO7_Pos = 0x7
	// Bit mask of SYSIO7 field.
	MATRIX_CCFG_SYSIO_SYSIO7_Msk = 0x80
	// Bit SYSIO7.
	MATRIX_CCFG_SYSIO_SYSIO7 = 0x80
	// Position of SYSIO10 field.
	MATRIX_CCFG_SYSIO_SYSIO10_Pos = 0xa
	// Bit mask of SYSIO10 field.
	MATRIX_CCFG_SYSIO_SYSIO10_Msk = 0x400
	// Bit SYSIO10.
	MATRIX_CCFG_SYSIO_SYSIO10 = 0x400
	// Position of SYSIO11 field.
	MATRIX_CCFG_SYSIO_SYSIO11_Pos = 0xb
	// Bit mask of SYSIO11 field.
	MATRIX_CCFG_SYSIO_SYSIO11_Msk = 0x800
	// Bit SYSIO11.
	MATRIX_CCFG_SYSIO_SYSIO11 = 0x800
	// Position of SYSIO12 field.
	MATRIX_CCFG_SYSIO_SYSIO12_Pos = 0xc
	// Bit mask of SYSIO12 field.
	MATRIX_CCFG_SYSIO_SYSIO12_Msk = 0x1000
	// Bit SYSIO12.
	MATRIX_CCFG_SYSIO_SYSIO12 = 0x1000

	// CCFG_SMCNFCS: SMC Chip Select NAND Flash Assignment Register
	// Position of SMC_NFCS0 field.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS0_Pos = 0x0
	// Bit mask of SMC_NFCS0 field.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS0_Msk = 0x1
	// Bit SMC_NFCS0.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS0 = 0x1
	// Position of SMC_NFCS1 field.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS1_Pos = 0x1
	// Bit mask of SMC_NFCS1 field.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS1_Msk = 0x2
	// Bit SMC_NFCS1.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS1 = 0x2
	// Position of SMC_NFCS2 field.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS2_Pos = 0x2
	// Bit mask of SMC_NFCS2 field.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS2_Msk = 0x4
	// Bit SMC_NFCS2.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS2 = 0x4
	// Position of SMC_NFCS3 field.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS3_Pos = 0x3
	// Bit mask of SMC_NFCS3 field.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS3_Msk = 0x8
	// Bit SMC_NFCS3.
	MATRIX_CCFG_SMCNFCS_SMC_NFCS3 = 0x8

	// MATRIX_WPMR: Write Protect Mode Register
	// Position of WPEN field.
	MATRIX_MATRIX_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	MATRIX_MATRIX_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	MATRIX_MATRIX_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	MATRIX_MATRIX_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	MATRIX_MATRIX_WPMR_WPKEY_Msk = 0xffffff00

	// MATRIX_WPSR: Write Protect Status Register
	// Position of WPVS field.
	MATRIX_MATRIX_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	MATRIX_MATRIX_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	MATRIX_MATRIX_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	MATRIX_MATRIX_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	MATRIX_MATRIX_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for PMC: Power Management Controller
const (
	// PMC_SCER: System Clock Enable Register
	// Position of UDP field.
	PMC_PMC_SCER_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCER_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCER_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCER_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCER_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCER_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCER_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCER_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCER_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCER_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCER_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCER_PCK2 = 0x400

	// PMC_SCDR: System Clock Disable Register
	// Position of UDP field.
	PMC_PMC_SCDR_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCDR_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCDR_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCDR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCDR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCDR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCDR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCDR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCDR_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCDR_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCDR_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCDR_PCK2 = 0x400

	// PMC_SCSR: System Clock Status Register
	// Position of UDP field.
	PMC_PMC_SCSR_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCSR_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCSR_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCSR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCSR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCSR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCSR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCSR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCSR_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCSR_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCSR_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCSR_PCK2 = 0x400

	// PMC_PCER0: Peripheral Clock Enable Register 0
	// Position of PID2 field.
	PMC_PMC_PCER0_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCER0_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCER0_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCER0_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCER0_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCER0_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCER0_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCER0_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCER0_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCER0_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCER0_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCER0_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCER0_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCER0_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCER0_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCER0_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCER0_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCER0_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCER0_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCER0_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCER0_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCER0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCER0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCER0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCER0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCER0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCER0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCER0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCER0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCER0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCER0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCER0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCER0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCER0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCER0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCER0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCER0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCER0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCER0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCER0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCER0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCER0_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCER0_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCER0_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCER0_PID16 = 0x10000
	// Position of PID18 field.
	PMC_PMC_PCER0_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCER0_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCER0_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCER0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCER0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCER0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCER0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCER0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCER0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCER0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCER0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCER0_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCER0_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCER0_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCER0_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCER0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCER0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCER0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCER0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCER0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCER0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCER0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCER0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCER0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCER0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCER0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCER0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCER0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCER0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCER0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCER0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCER0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCER0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCER0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCER0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCER0_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCER0_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCER0_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCER0_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCER0_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCER0_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCER0_PID31 = 0x80000000

	// PMC_PCDR0: Peripheral Clock Disable Register 0
	// Position of PID2 field.
	PMC_PMC_PCDR0_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCDR0_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCDR0_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCDR0_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCDR0_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCDR0_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCDR0_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCDR0_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCDR0_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCDR0_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCDR0_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCDR0_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCDR0_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCDR0_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCDR0_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCDR0_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCDR0_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCDR0_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCDR0_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCDR0_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCDR0_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCDR0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCDR0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCDR0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCDR0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCDR0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCDR0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCDR0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCDR0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCDR0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCDR0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCDR0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCDR0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCDR0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCDR0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCDR0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCDR0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCDR0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCDR0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCDR0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCDR0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCDR0_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCDR0_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCDR0_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCDR0_PID16 = 0x10000
	// Position of PID18 field.
	PMC_PMC_PCDR0_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCDR0_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCDR0_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCDR0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCDR0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCDR0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCDR0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCDR0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCDR0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCDR0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCDR0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCDR0_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCDR0_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCDR0_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCDR0_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCDR0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCDR0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCDR0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCDR0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCDR0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCDR0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCDR0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCDR0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCDR0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCDR0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCDR0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCDR0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCDR0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCDR0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCDR0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCDR0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCDR0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCDR0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCDR0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCDR0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCDR0_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCDR0_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCDR0_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCDR0_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCDR0_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCDR0_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCDR0_PID31 = 0x80000000

	// PMC_PCSR0: Peripheral Clock Status Register 0
	// Position of PID2 field.
	PMC_PMC_PCSR0_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCSR0_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCSR0_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCSR0_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCSR0_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCSR0_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCSR0_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCSR0_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCSR0_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCSR0_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCSR0_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCSR0_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCSR0_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCSR0_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCSR0_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCSR0_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCSR0_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCSR0_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCSR0_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCSR0_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCSR0_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCSR0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCSR0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCSR0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCSR0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCSR0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCSR0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCSR0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCSR0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCSR0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCSR0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCSR0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCSR0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCSR0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCSR0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCSR0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCSR0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCSR0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCSR0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCSR0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCSR0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCSR0_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCSR0_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCSR0_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCSR0_PID16 = 0x10000
	// Position of PID18 field.
	PMC_PMC_PCSR0_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCSR0_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCSR0_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCSR0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCSR0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCSR0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCSR0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCSR0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCSR0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCSR0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCSR0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCSR0_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCSR0_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCSR0_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCSR0_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCSR0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCSR0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCSR0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCSR0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCSR0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCSR0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCSR0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCSR0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCSR0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCSR0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCSR0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCSR0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCSR0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCSR0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCSR0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCSR0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCSR0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCSR0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCSR0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCSR0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCSR0_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCSR0_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCSR0_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCSR0_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCSR0_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCSR0_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCSR0_PID31 = 0x80000000

	// CKGR_MOR: Main Oscillator Register
	// Position of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Pos = 0x0
	// Bit mask of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Msk = 0x1
	// Bit MOSCXTEN.
	PMC_CKGR_MOR_MOSCXTEN = 0x1
	// Position of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Pos = 0x1
	// Bit mask of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Msk = 0x2
	// Bit MOSCXTBY.
	PMC_CKGR_MOR_MOSCXTBY = 0x2
	// Position of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Pos = 0x3
	// Bit mask of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Msk = 0x8
	// Bit MOSCRCEN.
	PMC_CKGR_MOR_MOSCRCEN = 0x8
	// Position of MOSCRCF field.
	PMC_CKGR_MOR_MOSCRCF_Pos = 0x4
	// Bit mask of MOSCRCF field.
	PMC_CKGR_MOR_MOSCRCF_Msk = 0x70
	// The Fast RC Oscillator Frequency is at 4 MHz (default)
	PMC_CKGR_MOR_MOSCRCF_4_MHz = 0x0
	// The Fast RC Oscillator Frequency is at 8 MHz
	PMC_CKGR_MOR_MOSCRCF_8_MHz = 0x1
	// The Fast RC Oscillator Frequency is at 12 MHz
	PMC_CKGR_MOR_MOSCRCF_12_MHz = 0x2
	// Position of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Pos = 0x8
	// Bit mask of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Msk = 0xff00
	// Position of KEY field.
	PMC_CKGR_MOR_KEY_Pos = 0x10
	// Bit mask of KEY field.
	PMC_CKGR_MOR_KEY_Msk = 0xff0000
	// Position of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Pos = 0x18
	// Bit mask of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Msk = 0x1000000
	// Bit MOSCSEL.
	PMC_CKGR_MOR_MOSCSEL = 0x1000000
	// Position of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Pos = 0x19
	// Bit mask of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Msk = 0x2000000
	// Bit CFDEN.
	PMC_CKGR_MOR_CFDEN = 0x2000000

	// CKGR_MCFR: Main Clock Frequency Register
	// Position of MAINF field.
	PMC_CKGR_MCFR_MAINF_Pos = 0x0
	// Bit mask of MAINF field.
	PMC_CKGR_MCFR_MAINF_Msk = 0xffff
	// Position of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Pos = 0x10
	// Bit mask of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Msk = 0x10000
	// Bit MAINFRDY.
	PMC_CKGR_MCFR_MAINFRDY = 0x10000
	// Position of RCMEAS field.
	PMC_CKGR_MCFR_RCMEAS_Pos = 0x14
	// Bit mask of RCMEAS field.
	PMC_CKGR_MCFR_RCMEAS_Msk = 0x100000
	// Bit RCMEAS.
	PMC_CKGR_MCFR_RCMEAS = 0x100000

	// CKGR_PLLAR: PLLA Register
	// Position of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Msk = 0xff
	// Position of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Pos = 0x8
	// Bit mask of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Msk = 0x3f00
	// Position of MULA field.
	PMC_CKGR_PLLAR_MULA_Pos = 0x10
	// Bit mask of MULA field.
	PMC_CKGR_PLLAR_MULA_Msk = 0x7ff0000
	// Position of ONE field.
	PMC_CKGR_PLLAR_ONE_Pos = 0x1d
	// Bit mask of ONE field.
	PMC_CKGR_PLLAR_ONE_Msk = 0x20000000
	// Bit ONE.
	PMC_CKGR_PLLAR_ONE = 0x20000000

	// CKGR_PLLBR: PLLB Register
	// Position of DIVB field.
	PMC_CKGR_PLLBR_DIVB_Pos = 0x0
	// Bit mask of DIVB field.
	PMC_CKGR_PLLBR_DIVB_Msk = 0xff
	// Position of PLLBCOUNT field.
	PMC_CKGR_PLLBR_PLLBCOUNT_Pos = 0x8
	// Bit mask of PLLBCOUNT field.
	PMC_CKGR_PLLBR_PLLBCOUNT_Msk = 0x3f00
	// Position of MULB field.
	PMC_CKGR_PLLBR_MULB_Pos = 0x10
	// Bit mask of MULB field.
	PMC_CKGR_PLLBR_MULB_Msk = 0x7ff0000

	// PMC_MCKR: Master Clock Register
	// Position of CSS field.
	PMC_PMC_MCKR_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_MCKR_CSS_Msk = 0x3
	// Slow Clock is selected
	PMC_PMC_MCKR_CSS_SLOW_CLK = 0x0
	// Main Clock is selected
	PMC_PMC_MCKR_CSS_MAIN_CLK = 0x1
	// PLLA Clock is selected
	PMC_PMC_MCKR_CSS_PLLA_CLK = 0x2
	// PLLBClock is selected
	PMC_PMC_MCKR_CSS_PLLB_CLK = 0x3
	// Position of PRES field.
	PMC_PMC_MCKR_PRES_Pos = 0x4
	// Bit mask of PRES field.
	PMC_PMC_MCKR_PRES_Msk = 0x70
	// Selected clock
	PMC_PMC_MCKR_PRES_CLK_1 = 0x0
	// Selected clock divided by 2
	PMC_PMC_MCKR_PRES_CLK_2 = 0x1
	// Selected clock divided by 4
	PMC_PMC_MCKR_PRES_CLK_4 = 0x2
	// Selected clock divided by 8
	PMC_PMC_MCKR_PRES_CLK_8 = 0x3
	// Selected clock divided by 16
	PMC_PMC_MCKR_PRES_CLK_16 = 0x4
	// Selected clock divided by 32
	PMC_PMC_MCKR_PRES_CLK_32 = 0x5
	// Selected clock divided by 64
	PMC_PMC_MCKR_PRES_CLK_64 = 0x6
	// Selected clock divided by 3
	PMC_PMC_MCKR_PRES_CLK_3 = 0x7
	// Position of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Pos = 0xc
	// Bit mask of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Msk = 0x1000
	// Bit PLLADIV2.
	PMC_PMC_MCKR_PLLADIV2 = 0x1000
	// Position of PLLBDIV2 field.
	PMC_PMC_MCKR_PLLBDIV2_Pos = 0xd
	// Bit mask of PLLBDIV2 field.
	PMC_PMC_MCKR_PLLBDIV2_Msk = 0x2000
	// Bit PLLBDIV2.
	PMC_PMC_MCKR_PLLBDIV2 = 0x2000

	// PMC_USB: USB Clock Register
	// Position of USBS field.
	PMC_PMC_USB_USBS_Pos = 0x0
	// Bit mask of USBS field.
	PMC_PMC_USB_USBS_Msk = 0x1
	// Bit USBS.
	PMC_PMC_USB_USBS = 0x1
	// Position of USBDIV field.
	PMC_PMC_USB_USBDIV_Pos = 0x8
	// Bit mask of USBDIV field.
	PMC_PMC_USB_USBDIV_Msk = 0xf00

	// PMC_PCK: Programmable Clock 0 Register
	// Position of CSS field.
	PMC_PMC_PCK_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_PCK_CSS_Msk = 0x7
	// Slow Clock is selected
	PMC_PMC_PCK_CSS_SLOW_CLK = 0x0
	// Main Clock is selected
	PMC_PMC_PCK_CSS_MAIN_CLK = 0x1
	// PLLA Clock is selected
	PMC_PMC_PCK_CSS_PLLA_CLK = 0x2
	// PLLB Clock is selected
	PMC_PMC_PCK_CSS_PLLB_CLK = 0x3
	// Master Clock is selected
	PMC_PMC_PCK_CSS_MCK = 0x4
	// Position of PRES field.
	PMC_PMC_PCK_PRES_Pos = 0x4
	// Bit mask of PRES field.
	PMC_PMC_PCK_PRES_Msk = 0x70
	// Selected clock
	PMC_PMC_PCK_PRES_CLK_1 = 0x0
	// Selected clock divided by 2
	PMC_PMC_PCK_PRES_CLK_2 = 0x1
	// Selected clock divided by 4
	PMC_PMC_PCK_PRES_CLK_4 = 0x2
	// Selected clock divided by 8
	PMC_PMC_PCK_PRES_CLK_8 = 0x3
	// Selected clock divided by 16
	PMC_PMC_PCK_PRES_CLK_16 = 0x4
	// Selected clock divided by 32
	PMC_PMC_PCK_PRES_CLK_32 = 0x5
	// Selected clock divided by 64
	PMC_PMC_PCK_PRES_CLK_64 = 0x6

	// PMC_IER: Interrupt Enable Register
	// Position of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IER_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IER_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IER_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IER_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IER_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IER_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IER_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IER_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IER_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IER_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IER_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IER_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IER_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IER_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IER_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IER_CFDEV = 0x40000

	// PMC_IDR: Interrupt Disable Register
	// Position of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IDR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IDR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IDR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IDR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IDR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IDR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IDR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IDR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IDR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IDR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IDR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IDR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IDR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IDR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IDR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IDR_CFDEV = 0x40000

	// PMC_SR: Status Register
	// Position of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_SR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_SR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_SR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_SR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_SR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_SR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_SR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_SR_MCKRDY = 0x8
	// Position of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Pos = 0x7
	// Bit mask of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Msk = 0x80
	// Bit OSCSELS.
	PMC_PMC_SR_OSCSELS = 0x80
	// Position of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_SR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_SR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_SR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_SR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_SR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_SR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_SR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_SR_CFDEV = 0x40000
	// Position of CFDS field.
	PMC_PMC_SR_CFDS_Pos = 0x13
	// Bit mask of CFDS field.
	PMC_PMC_SR_CFDS_Msk = 0x80000
	// Bit CFDS.
	PMC_PMC_SR_CFDS = 0x80000
	// Position of FOS field.
	PMC_PMC_SR_FOS_Pos = 0x14
	// Bit mask of FOS field.
	PMC_PMC_SR_FOS_Msk = 0x100000
	// Bit FOS.
	PMC_PMC_SR_FOS = 0x100000

	// PMC_IMR: Interrupt Mask Register
	// Position of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IMR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IMR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IMR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IMR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IMR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IMR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IMR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IMR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IMR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IMR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IMR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IMR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IMR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IMR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IMR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IMR_CFDEV = 0x40000

	// PMC_FSMR: Fast Startup Mode Register
	// Position of FSTT0 field.
	PMC_PMC_FSMR_FSTT0_Pos = 0x0
	// Bit mask of FSTT0 field.
	PMC_PMC_FSMR_FSTT0_Msk = 0x1
	// Bit FSTT0.
	PMC_PMC_FSMR_FSTT0 = 0x1
	// Position of FSTT1 field.
	PMC_PMC_FSMR_FSTT1_Pos = 0x1
	// Bit mask of FSTT1 field.
	PMC_PMC_FSMR_FSTT1_Msk = 0x2
	// Bit FSTT1.
	PMC_PMC_FSMR_FSTT1 = 0x2
	// Position of FSTT2 field.
	PMC_PMC_FSMR_FSTT2_Pos = 0x2
	// Bit mask of FSTT2 field.
	PMC_PMC_FSMR_FSTT2_Msk = 0x4
	// Bit FSTT2.
	PMC_PMC_FSMR_FSTT2 = 0x4
	// Position of FSTT3 field.
	PMC_PMC_FSMR_FSTT3_Pos = 0x3
	// Bit mask of FSTT3 field.
	PMC_PMC_FSMR_FSTT3_Msk = 0x8
	// Bit FSTT3.
	PMC_PMC_FSMR_FSTT3 = 0x8
	// Position of FSTT4 field.
	PMC_PMC_FSMR_FSTT4_Pos = 0x4
	// Bit mask of FSTT4 field.
	PMC_PMC_FSMR_FSTT4_Msk = 0x10
	// Bit FSTT4.
	PMC_PMC_FSMR_FSTT4 = 0x10
	// Position of FSTT5 field.
	PMC_PMC_FSMR_FSTT5_Pos = 0x5
	// Bit mask of FSTT5 field.
	PMC_PMC_FSMR_FSTT5_Msk = 0x20
	// Bit FSTT5.
	PMC_PMC_FSMR_FSTT5 = 0x20
	// Position of FSTT6 field.
	PMC_PMC_FSMR_FSTT6_Pos = 0x6
	// Bit mask of FSTT6 field.
	PMC_PMC_FSMR_FSTT6_Msk = 0x40
	// Bit FSTT6.
	PMC_PMC_FSMR_FSTT6 = 0x40
	// Position of FSTT7 field.
	PMC_PMC_FSMR_FSTT7_Pos = 0x7
	// Bit mask of FSTT7 field.
	PMC_PMC_FSMR_FSTT7_Msk = 0x80
	// Bit FSTT7.
	PMC_PMC_FSMR_FSTT7 = 0x80
	// Position of FSTT8 field.
	PMC_PMC_FSMR_FSTT8_Pos = 0x8
	// Bit mask of FSTT8 field.
	PMC_PMC_FSMR_FSTT8_Msk = 0x100
	// Bit FSTT8.
	PMC_PMC_FSMR_FSTT8 = 0x100
	// Position of FSTT9 field.
	PMC_PMC_FSMR_FSTT9_Pos = 0x9
	// Bit mask of FSTT9 field.
	PMC_PMC_FSMR_FSTT9_Msk = 0x200
	// Bit FSTT9.
	PMC_PMC_FSMR_FSTT9 = 0x200
	// Position of FSTT10 field.
	PMC_PMC_FSMR_FSTT10_Pos = 0xa
	// Bit mask of FSTT10 field.
	PMC_PMC_FSMR_FSTT10_Msk = 0x400
	// Bit FSTT10.
	PMC_PMC_FSMR_FSTT10 = 0x400
	// Position of FSTT11 field.
	PMC_PMC_FSMR_FSTT11_Pos = 0xb
	// Bit mask of FSTT11 field.
	PMC_PMC_FSMR_FSTT11_Msk = 0x800
	// Bit FSTT11.
	PMC_PMC_FSMR_FSTT11 = 0x800
	// Position of FSTT12 field.
	PMC_PMC_FSMR_FSTT12_Pos = 0xc
	// Bit mask of FSTT12 field.
	PMC_PMC_FSMR_FSTT12_Msk = 0x1000
	// Bit FSTT12.
	PMC_PMC_FSMR_FSTT12 = 0x1000
	// Position of FSTT13 field.
	PMC_PMC_FSMR_FSTT13_Pos = 0xd
	// Bit mask of FSTT13 field.
	PMC_PMC_FSMR_FSTT13_Msk = 0x2000
	// Bit FSTT13.
	PMC_PMC_FSMR_FSTT13 = 0x2000
	// Position of FSTT14 field.
	PMC_PMC_FSMR_FSTT14_Pos = 0xe
	// Bit mask of FSTT14 field.
	PMC_PMC_FSMR_FSTT14_Msk = 0x4000
	// Bit FSTT14.
	PMC_PMC_FSMR_FSTT14 = 0x4000
	// Position of FSTT15 field.
	PMC_PMC_FSMR_FSTT15_Pos = 0xf
	// Bit mask of FSTT15 field.
	PMC_PMC_FSMR_FSTT15_Msk = 0x8000
	// Bit FSTT15.
	PMC_PMC_FSMR_FSTT15 = 0x8000
	// Position of RTTAL field.
	PMC_PMC_FSMR_RTTAL_Pos = 0x10
	// Bit mask of RTTAL field.
	PMC_PMC_FSMR_RTTAL_Msk = 0x10000
	// Bit RTTAL.
	PMC_PMC_FSMR_RTTAL = 0x10000
	// Position of RTCAL field.
	PMC_PMC_FSMR_RTCAL_Pos = 0x11
	// Bit mask of RTCAL field.
	PMC_PMC_FSMR_RTCAL_Msk = 0x20000
	// Bit RTCAL.
	PMC_PMC_FSMR_RTCAL = 0x20000
	// Position of USBAL field.
	PMC_PMC_FSMR_USBAL_Pos = 0x12
	// Bit mask of USBAL field.
	PMC_PMC_FSMR_USBAL_Msk = 0x40000
	// Bit USBAL.
	PMC_PMC_FSMR_USBAL = 0x40000
	// Position of LPM field.
	PMC_PMC_FSMR_LPM_Pos = 0x14
	// Bit mask of LPM field.
	PMC_PMC_FSMR_LPM_Msk = 0x100000
	// Bit LPM.
	PMC_PMC_FSMR_LPM = 0x100000

	// PMC_FSPR: Fast Startup Polarity Register
	// Position of FSTP0 field.
	PMC_PMC_FSPR_FSTP0_Pos = 0x0
	// Bit mask of FSTP0 field.
	PMC_PMC_FSPR_FSTP0_Msk = 0x1
	// Bit FSTP0.
	PMC_PMC_FSPR_FSTP0 = 0x1
	// Position of FSTP1 field.
	PMC_PMC_FSPR_FSTP1_Pos = 0x1
	// Bit mask of FSTP1 field.
	PMC_PMC_FSPR_FSTP1_Msk = 0x2
	// Bit FSTP1.
	PMC_PMC_FSPR_FSTP1 = 0x2
	// Position of FSTP2 field.
	PMC_PMC_FSPR_FSTP2_Pos = 0x2
	// Bit mask of FSTP2 field.
	PMC_PMC_FSPR_FSTP2_Msk = 0x4
	// Bit FSTP2.
	PMC_PMC_FSPR_FSTP2 = 0x4
	// Position of FSTP3 field.
	PMC_PMC_FSPR_FSTP3_Pos = 0x3
	// Bit mask of FSTP3 field.
	PMC_PMC_FSPR_FSTP3_Msk = 0x8
	// Bit FSTP3.
	PMC_PMC_FSPR_FSTP3 = 0x8
	// Position of FSTP4 field.
	PMC_PMC_FSPR_FSTP4_Pos = 0x4
	// Bit mask of FSTP4 field.
	PMC_PMC_FSPR_FSTP4_Msk = 0x10
	// Bit FSTP4.
	PMC_PMC_FSPR_FSTP4 = 0x10
	// Position of FSTP5 field.
	PMC_PMC_FSPR_FSTP5_Pos = 0x5
	// Bit mask of FSTP5 field.
	PMC_PMC_FSPR_FSTP5_Msk = 0x20
	// Bit FSTP5.
	PMC_PMC_FSPR_FSTP5 = 0x20
	// Position of FSTP6 field.
	PMC_PMC_FSPR_FSTP6_Pos = 0x6
	// Bit mask of FSTP6 field.
	PMC_PMC_FSPR_FSTP6_Msk = 0x40
	// Bit FSTP6.
	PMC_PMC_FSPR_FSTP6 = 0x40
	// Position of FSTP7 field.
	PMC_PMC_FSPR_FSTP7_Pos = 0x7
	// Bit mask of FSTP7 field.
	PMC_PMC_FSPR_FSTP7_Msk = 0x80
	// Bit FSTP7.
	PMC_PMC_FSPR_FSTP7 = 0x80
	// Position of FSTP8 field.
	PMC_PMC_FSPR_FSTP8_Pos = 0x8
	// Bit mask of FSTP8 field.
	PMC_PMC_FSPR_FSTP8_Msk = 0x100
	// Bit FSTP8.
	PMC_PMC_FSPR_FSTP8 = 0x100
	// Position of FSTP9 field.
	PMC_PMC_FSPR_FSTP9_Pos = 0x9
	// Bit mask of FSTP9 field.
	PMC_PMC_FSPR_FSTP9_Msk = 0x200
	// Bit FSTP9.
	PMC_PMC_FSPR_FSTP9 = 0x200
	// Position of FSTP10 field.
	PMC_PMC_FSPR_FSTP10_Pos = 0xa
	// Bit mask of FSTP10 field.
	PMC_PMC_FSPR_FSTP10_Msk = 0x400
	// Bit FSTP10.
	PMC_PMC_FSPR_FSTP10 = 0x400
	// Position of FSTP11 field.
	PMC_PMC_FSPR_FSTP11_Pos = 0xb
	// Bit mask of FSTP11 field.
	PMC_PMC_FSPR_FSTP11_Msk = 0x800
	// Bit FSTP11.
	PMC_PMC_FSPR_FSTP11 = 0x800
	// Position of FSTP12 field.
	PMC_PMC_FSPR_FSTP12_Pos = 0xc
	// Bit mask of FSTP12 field.
	PMC_PMC_FSPR_FSTP12_Msk = 0x1000
	// Bit FSTP12.
	PMC_PMC_FSPR_FSTP12 = 0x1000
	// Position of FSTP13 field.
	PMC_PMC_FSPR_FSTP13_Pos = 0xd
	// Bit mask of FSTP13 field.
	PMC_PMC_FSPR_FSTP13_Msk = 0x2000
	// Bit FSTP13.
	PMC_PMC_FSPR_FSTP13 = 0x2000
	// Position of FSTP14 field.
	PMC_PMC_FSPR_FSTP14_Pos = 0xe
	// Bit mask of FSTP14 field.
	PMC_PMC_FSPR_FSTP14_Msk = 0x4000
	// Bit FSTP14.
	PMC_PMC_FSPR_FSTP14 = 0x4000
	// Position of FSTP15 field.
	PMC_PMC_FSPR_FSTP15_Pos = 0xf
	// Bit mask of FSTP15 field.
	PMC_PMC_FSPR_FSTP15_Msk = 0x8000
	// Bit FSTP15.
	PMC_PMC_FSPR_FSTP15 = 0x8000

	// PMC_FOCR: Fault Output Clear Register
	// Position of FOCLR field.
	PMC_PMC_FOCR_FOCLR_Pos = 0x0
	// Bit mask of FOCLR field.
	PMC_PMC_FOCR_FOCLR_Msk = 0x1
	// Bit FOCLR.
	PMC_PMC_FOCR_FOCLR = 0x1

	// PMC_WPMR: Write Protect Mode Register
	// Position of WPEN field.
	PMC_PMC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	PMC_PMC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	PMC_PMC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Msk = 0xffffff00

	// PMC_WPSR: Write Protect Status Register
	// Position of WPVS field.
	PMC_PMC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	PMC_PMC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	PMC_PMC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Msk = 0xffff00

	// PMC_PCER1: Peripheral Clock Enable Register 1
	// Position of PID32 field.
	PMC_PMC_PCER1_PID32_Pos = 0x0
	// Bit mask of PID32 field.
	PMC_PMC_PCER1_PID32_Msk = 0x1
	// Bit PID32.
	PMC_PMC_PCER1_PID32 = 0x1
	// Position of PID33 field.
	PMC_PMC_PCER1_PID33_Pos = 0x1
	// Bit mask of PID33 field.
	PMC_PMC_PCER1_PID33_Msk = 0x2
	// Bit PID33.
	PMC_PMC_PCER1_PID33 = 0x2
	// Position of PID34 field.
	PMC_PMC_PCER1_PID34_Pos = 0x2
	// Bit mask of PID34 field.
	PMC_PMC_PCER1_PID34_Msk = 0x4
	// Bit PID34.
	PMC_PMC_PCER1_PID34 = 0x4

	// PMC_PCDR1: Peripheral Clock Disable Register 1
	// Position of PID32 field.
	PMC_PMC_PCDR1_PID32_Pos = 0x0
	// Bit mask of PID32 field.
	PMC_PMC_PCDR1_PID32_Msk = 0x1
	// Bit PID32.
	PMC_PMC_PCDR1_PID32 = 0x1
	// Position of PID33 field.
	PMC_PMC_PCDR1_PID33_Pos = 0x1
	// Bit mask of PID33 field.
	PMC_PMC_PCDR1_PID33_Msk = 0x2
	// Bit PID33.
	PMC_PMC_PCDR1_PID33 = 0x2
	// Position of PID34 field.
	PMC_PMC_PCDR1_PID34_Pos = 0x2
	// Bit mask of PID34 field.
	PMC_PMC_PCDR1_PID34_Msk = 0x4
	// Bit PID34.
	PMC_PMC_PCDR1_PID34 = 0x4

	// PMC_PCSR1: Peripheral Clock Status Register 1
	// Position of PID32 field.
	PMC_PMC_PCSR1_PID32_Pos = 0x0
	// Bit mask of PID32 field.
	PMC_PMC_PCSR1_PID32_Msk = 0x1
	// Bit PID32.
	PMC_PMC_PCSR1_PID32 = 0x1
	// Position of PID33 field.
	PMC_PMC_PCSR1_PID33_Pos = 0x1
	// Bit mask of PID33 field.
	PMC_PMC_PCSR1_PID33_Msk = 0x2
	// Bit PID33.
	PMC_PMC_PCSR1_PID33 = 0x2
	// Position of PID34 field.
	PMC_PMC_PCSR1_PID34_Pos = 0x2
	// Bit mask of PID34 field.
	PMC_PMC_PCSR1_PID34_Msk = 0x4
	// Bit PID34.
	PMC_PMC_PCSR1_PID34 = 0x4

	// PMC_OCR: Oscillator Calibration Register
	// Position of CAL4 field.
	PMC_PMC_OCR_CAL4_Pos = 0x0
	// Bit mask of CAL4 field.
	PMC_PMC_OCR_CAL4_Msk = 0x7f
	// Position of SEL4 field.
	PMC_PMC_OCR_SEL4_Pos = 0x7
	// Bit mask of SEL4 field.
	PMC_PMC_OCR_SEL4_Msk = 0x80
	// Bit SEL4.
	PMC_PMC_OCR_SEL4 = 0x80
	// Position of CAL8 field.
	PMC_PMC_OCR_CAL8_Pos = 0x8
	// Bit mask of CAL8 field.
	PMC_PMC_OCR_CAL8_Msk = 0x7f00
	// Position of SEL8 field.
	PMC_PMC_OCR_SEL8_Pos = 0xf
	// Bit mask of SEL8 field.
	PMC_PMC_OCR_SEL8_Msk = 0x8000
	// Bit SEL8.
	PMC_PMC_OCR_SEL8 = 0x8000
	// Position of CAL12 field.
	PMC_PMC_OCR_CAL12_Pos = 0x10
	// Bit mask of CAL12 field.
	PMC_PMC_OCR_CAL12_Msk = 0x7f0000
	// Position of SEL12 field.
	PMC_PMC_OCR_SEL12_Pos = 0x17
	// Bit mask of SEL12 field.
	PMC_PMC_OCR_SEL12_Msk = 0x800000
	// Bit SEL12.
	PMC_PMC_OCR_SEL12 = 0x800000
)

// Bitfields for UART0: Universal Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	UART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	UART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	UART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	UART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	UART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	UART_CR_RSTTX = 0x8
	// Position of RXEN field.
	UART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	UART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	UART_CR_RXEN = 0x10
	// Position of RXDIS field.
	UART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	UART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	UART_CR_RXDIS = 0x20
	// Position of TXEN field.
	UART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	UART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	UART_CR_TXEN = 0x40
	// Position of TXDIS field.
	UART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	UART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	UART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	UART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	UART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	UART_CR_RSTSTA = 0x100

	// MR: Mode Register
	// Position of PAR field.
	UART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	UART_MR_PAR_Msk = 0xe00
	// Even parity
	UART_MR_PAR_EVEN = 0x0
	// Odd parity
	UART_MR_PAR_ODD = 0x1
	// Space: parity forced to 0
	UART_MR_PAR_SPACE = 0x2
	// Mark: parity forced to 1
	UART_MR_PAR_MARK = 0x3
	// No parity
	UART_MR_PAR_NO = 0x4
	// Position of CHMODE field.
	UART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	UART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	UART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo
	UART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback
	UART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback
	UART_MR_CHMODE_REMOTE_LOOPBACK = 0x3

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	UART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IER_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IER_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IER_ENDTX = 0x10
	// Position of OVRE field.
	UART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IER_OVRE = 0x20
	// Position of FRAME field.
	UART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IER_FRAME = 0x40
	// Position of PARE field.
	UART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IER_PARE_Msk = 0x80
	// Bit PARE.
	UART_IER_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IER_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IER_RXBUFF = 0x1000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	UART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IDR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IDR_ENDTX = 0x10
	// Position of OVRE field.
	UART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IDR_OVRE = 0x20
	// Position of FRAME field.
	UART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IDR_FRAME = 0x40
	// Position of PARE field.
	UART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IDR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IDR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IDR_RXBUFF = 0x1000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	UART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IMR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IMR_ENDTX = 0x10
	// Position of OVRE field.
	UART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IMR_OVRE = 0x20
	// Position of FRAME field.
	UART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IMR_FRAME = 0x40
	// Position of PARE field.
	UART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IMR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IMR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IMR_RXBUFF = 0x1000

	// SR: Status Register
	// Position of RXRDY field.
	UART_SR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_SR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_SR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_SR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_SR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_SR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_SR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_SR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_SR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_SR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_SR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_SR_ENDTX = 0x10
	// Position of OVRE field.
	UART_SR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_SR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_SR_OVRE = 0x20
	// Position of FRAME field.
	UART_SR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_SR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_SR_FRAME = 0x40
	// Position of PARE field.
	UART_SR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_SR_PARE_Msk = 0x80
	// Bit PARE.
	UART_SR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_SR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_SR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_SR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_SR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_SR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_SR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_SR_RXBUFF = 0x1000

	// RHR: Receive Holding Register
	// Position of RXCHR field.
	UART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	UART_RHR_RXCHR_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXCHR field.
	UART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	UART_THR_TXCHR_Msk = 0xff

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	UART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	UART_BRGR_CD_Msk = 0xffff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	UART_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	UART_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	UART_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	UART_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	UART_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	UART_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	UART_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	UART_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	UART_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	UART_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	UART_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	UART_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	UART_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	UART_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	UART_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	UART_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	UART_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	UART_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	UART_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	UART_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	UART_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	UART_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	UART_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	UART_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	UART_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	UART_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	UART_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	UART_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	UART_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	UART_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	UART_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	UART_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	UART_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	UART_PTSR_TXTEN = 0x100
)

// Bitfields for CHIPID: Chip Identifier
const (
	// CIDR: Chip ID Register
	// Position of VERSION field.
	CHIPID_CIDR_VERSION_Pos = 0x0
	// Bit mask of VERSION field.
	CHIPID_CIDR_VERSION_Msk = 0x1f
	// Position of EPROC field.
	CHIPID_CIDR_EPROC_Pos = 0x5
	// Bit mask of EPROC field.
	CHIPID_CIDR_EPROC_Msk = 0xe0
	// ARM946ES
	CHIPID_CIDR_EPROC_ARM946ES = 0x1
	// ARM7TDMI
	CHIPID_CIDR_EPROC_ARM7TDMI = 0x2
	// Cortex-M3
	CHIPID_CIDR_EPROC_CM3 = 0x3
	// ARM920T
	CHIPID_CIDR_EPROC_ARM920T = 0x4
	// ARM926EJS
	CHIPID_CIDR_EPROC_ARM926EJS = 0x5
	// Cortex-A5
	CHIPID_CIDR_EPROC_CA5 = 0x6
	// Cortex-M4
	CHIPID_CIDR_EPROC_CM4 = 0x7
	// Position of NVPSIZ field.
	CHIPID_CIDR_NVPSIZ_Pos = 0x8
	// Bit mask of NVPSIZ field.
	CHIPID_CIDR_NVPSIZ_Msk = 0xf00
	// None
	CHIPID_CIDR_NVPSIZ_NONE = 0x0
	// 8K bytes
	CHIPID_CIDR_NVPSIZ_8K = 0x1
	// 16K bytes
	CHIPID_CIDR_NVPSIZ_16K = 0x2
	// 32K bytes
	CHIPID_CIDR_NVPSIZ_32K = 0x3
	// 64K bytes
	CHIPID_CIDR_NVPSIZ_64K = 0x5
	// 128K bytes
	CHIPID_CIDR_NVPSIZ_128K = 0x7
	// 256K bytes
	CHIPID_CIDR_NVPSIZ_256K = 0x9
	// 512K bytes
	CHIPID_CIDR_NVPSIZ_512K = 0xa
	// 1024K bytes
	CHIPID_CIDR_NVPSIZ_1024K = 0xc
	// 2048K bytes
	CHIPID_CIDR_NVPSIZ_2048K = 0xe
	// Position of NVPSIZ2 field.
	CHIPID_CIDR_NVPSIZ2_Pos = 0xc
	// Bit mask of NVPSIZ2 field.
	CHIPID_CIDR_NVPSIZ2_Msk = 0xf000
	// None
	CHIPID_CIDR_NVPSIZ2_NONE = 0x0
	// 8K bytes
	CHIPID_CIDR_NVPSIZ2_8K = 0x1
	// 16K bytes
	CHIPID_CIDR_NVPSIZ2_16K = 0x2
	// 32K bytes
	CHIPID_CIDR_NVPSIZ2_32K = 0x3
	// 64K bytes
	CHIPID_CIDR_NVPSIZ2_64K = 0x5
	// 128K bytes
	CHIPID_CIDR_NVPSIZ2_128K = 0x7
	// 256K bytes
	CHIPID_CIDR_NVPSIZ2_256K = 0x9
	// 512K bytes
	CHIPID_CIDR_NVPSIZ2_512K = 0xa
	// 1024K bytes
	CHIPID_CIDR_NVPSIZ2_1024K = 0xc
	// 2048K bytes
	CHIPID_CIDR_NVPSIZ2_2048K = 0xe
	// Position of SRAMSIZ field.
	CHIPID_CIDR_SRAMSIZ_Pos = 0x10
	// Bit mask of SRAMSIZ field.
	CHIPID_CIDR_SRAMSIZ_Msk = 0xf0000
	// 48K bytes
	CHIPID_CIDR_SRAMSIZ_48K = 0x0
	// 1K bytes
	CHIPID_CIDR_SRAMSIZ_1K = 0x1
	// 2K bytes
	CHIPID_CIDR_SRAMSIZ_2K = 0x2
	// 6K bytes
	CHIPID_CIDR_SRAMSIZ_6K = 0x3
	// 24K bytes
	CHIPID_CIDR_SRAMSIZ_24K = 0x4
	// 4K bytes
	CHIPID_CIDR_SRAMSIZ_4K = 0x5
	// 80K bytes
	CHIPID_CIDR_SRAMSIZ_80K = 0x6
	// 160K bytes
	CHIPID_CIDR_SRAMSIZ_160K = 0x7
	// 8K bytes
	CHIPID_CIDR_SRAMSIZ_8K = 0x8
	// 16K bytes
	CHIPID_CIDR_SRAMSIZ_16K = 0x9
	// 32K bytes
	CHIPID_CIDR_SRAMSIZ_32K = 0xa
	// 64K bytes
	CHIPID_CIDR_SRAMSIZ_64K = 0xb
	// 128K bytes
	CHIPID_CIDR_SRAMSIZ_128K = 0xc
	// 256K bytes
	CHIPID_CIDR_SRAMSIZ_256K = 0xd
	// 96K bytes
	CHIPID_CIDR_SRAMSIZ_96K = 0xe
	// 512K bytes
	CHIPID_CIDR_SRAMSIZ_512K = 0xf
	// Position of ARCH field.
	CHIPID_CIDR_ARCH_Pos = 0x14
	// Bit mask of ARCH field.
	CHIPID_CIDR_ARCH_Msk = 0xff00000
	// AT91SAM9xx Series
	CHIPID_CIDR_ARCH_AT91SAM9xx = 0x19
	// AT91SAM9XExx Series
	CHIPID_CIDR_ARCH_AT91SAM9XExx = 0x29
	// AT91x34 Series
	CHIPID_CIDR_ARCH_AT91x34 = 0x34
	// CAP7 Series
	CHIPID_CIDR_ARCH_CAP7 = 0x37
	// CAP9 Series
	CHIPID_CIDR_ARCH_CAP9 = 0x39
	// CAP11 Series
	CHIPID_CIDR_ARCH_CAP11 = 0x3b
	// AT91x40 Series
	CHIPID_CIDR_ARCH_AT91x40 = 0x40
	// AT91x42 Series
	CHIPID_CIDR_ARCH_AT91x42 = 0x42
	// AT91x55 Series
	CHIPID_CIDR_ARCH_AT91x55 = 0x55
	// AT91SAM7Axx Series
	CHIPID_CIDR_ARCH_AT91SAM7Axx = 0x60
	// AT91SAM7AQxx Series
	CHIPID_CIDR_ARCH_AT91SAM7AQxx = 0x61
	// AT91x63 Series
	CHIPID_CIDR_ARCH_AT91x63 = 0x63
	// AT91SAM7Sxx Series
	CHIPID_CIDR_ARCH_AT91SAM7Sxx = 0x70
	// AT91SAM7XCxx Series
	CHIPID_CIDR_ARCH_AT91SAM7XCxx = 0x71
	// AT91SAM7SExx Series
	CHIPID_CIDR_ARCH_AT91SAM7SExx = 0x72
	// AT91SAM7Lxx Series
	CHIPID_CIDR_ARCH_AT91SAM7Lxx = 0x73
	// AT91SAM7Xxx Series
	CHIPID_CIDR_ARCH_AT91SAM7Xxx = 0x75
	// AT91SAM7SLxx Series
	CHIPID_CIDR_ARCH_AT91SAM7SLxx = 0x76
	// SAM3UxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3UxC = 0x80
	// SAM3UxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM3UxE = 0x81
	// SAM3AxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3AxC = 0x83
	// SAM4AxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4AxC = 0x83
	// SAM3XxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3XxC = 0x84
	// SAM4XxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4XxC = 0x84
	// SAM3XxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM3XxE = 0x85
	// SAM4XxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM4XxE = 0x85
	// SAM3XxG Series (208/217-pin version)
	CHIPID_CIDR_ARCH_SAM3XxG = 0x86
	// SAM4XxG Series (208/217-pin version)
	CHIPID_CIDR_ARCH_SAM4XxG = 0x86
	// SAM3SxASeries (48-pin version)
	CHIPID_CIDR_ARCH_SAM3SxA = 0x88
	// SAM4SxA Series (48-pin version)
	CHIPID_CIDR_ARCH_SAM4SxA = 0x88
	// SAM3SxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM3SxB = 0x89
	// SAM4SxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM4SxB = 0x89
	// SAM3SxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3SxC = 0x8a
	// SAM4SxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4SxC = 0x8a
	// AT91x92 Series
	CHIPID_CIDR_ARCH_AT91x92 = 0x92
	// SAM3NxA Series (48-pin version)
	CHIPID_CIDR_ARCH_SAM3NxA = 0x93
	// SAM3NxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM3NxB = 0x94
	// SAM3NxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3NxC = 0x95
	// SAM3SDxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM3SDxB = 0x99
	// SAM3SDxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3SDxC = 0x9a
	// SAM5A
	CHIPID_CIDR_ARCH_SAM5A = 0xa5
	// AT75Cxx Series
	CHIPID_CIDR_ARCH_AT75Cxx = 0xf0
	// Position of NVPTYP field.
	CHIPID_CIDR_NVPTYP_Pos = 0x1c
	// Bit mask of NVPTYP field.
	CHIPID_CIDR_NVPTYP_Msk = 0x70000000
	// ROM
	CHIPID_CIDR_NVPTYP_ROM = 0x0
	// ROMless or on-chip Flash
	CHIPID_CIDR_NVPTYP_ROMLESS = 0x1
	// Embedded Flash Memory
	CHIPID_CIDR_NVPTYP_FLASH = 0x2
	// ROM and Embedded Flash MemoryNVPSIZ is ROM size NVPSIZ2 is Flash size
	CHIPID_CIDR_NVPTYP_ROM_FLASH = 0x3
	// SRAM emulating ROM
	CHIPID_CIDR_NVPTYP_SRAM = 0x4
	// Position of EXT field.
	CHIPID_CIDR_EXT_Pos = 0x1f
	// Bit mask of EXT field.
	CHIPID_CIDR_EXT_Msk = 0x80000000
	// Bit EXT.
	CHIPID_CIDR_EXT = 0x80000000

	// EXID: Chip ID Extension Register
	// Position of EXID field.
	CHIPID_EXID_EXID_Pos = 0x0
	// Bit mask of EXID field.
	CHIPID_EXID_EXID_Msk = 0xffffffff
)

// Bitfields for EFC: Embedded Flash Controller
const (
	// FMR: EEFC Flash Mode Register
	// Position of FRDY field.
	EFC_FMR_FRDY_Pos = 0x0
	// Bit mask of FRDY field.
	EFC_FMR_FRDY_Msk = 0x1
	// Bit FRDY.
	EFC_FMR_FRDY = 0x1
	// Position of FWS field.
	EFC_FMR_FWS_Pos = 0x8
	// Bit mask of FWS field.
	EFC_FMR_FWS_Msk = 0xf00
	// Position of SCOD field.
	EFC_FMR_SCOD_Pos = 0x10
	// Bit mask of SCOD field.
	EFC_FMR_SCOD_Msk = 0x10000
	// Bit SCOD.
	EFC_FMR_SCOD = 0x10000
	// Position of FAM field.
	EFC_FMR_FAM_Pos = 0x18
	// Bit mask of FAM field.
	EFC_FMR_FAM_Msk = 0x1000000
	// Bit FAM.
	EFC_FMR_FAM = 0x1000000

	// FCR: EEFC Flash Command Register
	// Position of FCMD field.
	EFC_FCR_FCMD_Pos = 0x0
	// Bit mask of FCMD field.
	EFC_FCR_FCMD_Msk = 0xff
	// Get Flash Descriptor
	EFC_FCR_FCMD_GETD = 0x0
	// Write page
	EFC_FCR_FCMD_WP = 0x1
	// Write page and lock
	EFC_FCR_FCMD_WPL = 0x2
	// Erase page and write page
	EFC_FCR_FCMD_EWP = 0x3
	// Erase page and write page then lock
	EFC_FCR_FCMD_EWPL = 0x4
	// Erase all
	EFC_FCR_FCMD_EA = 0x5
	// Set Lock Bit
	EFC_FCR_FCMD_SLB = 0x8
	// Clear Lock Bit
	EFC_FCR_FCMD_CLB = 0x9
	// Get Lock Bit
	EFC_FCR_FCMD_GLB = 0xa
	// Set GPNVM Bit
	EFC_FCR_FCMD_SGPB = 0xb
	// Clear GPNVM Bit
	EFC_FCR_FCMD_CGPB = 0xc
	// Get GPNVM Bit
	EFC_FCR_FCMD_GGPB = 0xd
	// Start Read Unique Identifier
	EFC_FCR_FCMD_STUI = 0xe
	// Stop Read Unique Identifier
	EFC_FCR_FCMD_SPUI = 0xf
	// Position of FARG field.
	EFC_FCR_FARG_Pos = 0x8
	// Bit mask of FARG field.
	EFC_FCR_FARG_Msk = 0xffff00
	// Position of FKEY field.
	EFC_FCR_FKEY_Pos = 0x18
	// Bit mask of FKEY field.
	EFC_FCR_FKEY_Msk = 0xff000000
	// The 0x5A value enables the command defined by the bits of the register. If the field is written with a different value, the write is not performed and no action is started.
	EFC_FCR_FKEY_PASSWD = 0x5a

	// FSR: EEFC Flash Status Register
	// Position of FRDY field.
	EFC_FSR_FRDY_Pos = 0x0
	// Bit mask of FRDY field.
	EFC_FSR_FRDY_Msk = 0x1
	// Bit FRDY.
	EFC_FSR_FRDY = 0x1
	// Position of FCMDE field.
	EFC_FSR_FCMDE_Pos = 0x1
	// Bit mask of FCMDE field.
	EFC_FSR_FCMDE_Msk = 0x2
	// Bit FCMDE.
	EFC_FSR_FCMDE = 0x2
	// Position of FLOCKE field.
	EFC_FSR_FLOCKE_Pos = 0x2
	// Bit mask of FLOCKE field.
	EFC_FSR_FLOCKE_Msk = 0x4
	// Bit FLOCKE.
	EFC_FSR_FLOCKE = 0x4

	// FRR: EEFC Flash Result Register
	// Position of FVALUE field.
	EFC_FRR_FVALUE_Pos = 0x0
	// Bit mask of FVALUE field.
	EFC_FRR_FVALUE_Msk = 0xffffffff
)

// Bitfields for PIOA: Parallel Input/Output Controller A
const (
	// PER: PIO Enable Register
	// Position of P0 field.
	PIO_PER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PER_P0_Msk = 0x1
	// Bit P0.
	PIO_PER_P0 = 0x1
	// Position of P1 field.
	PIO_PER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PER_P1_Msk = 0x2
	// Bit P1.
	PIO_PER_P1 = 0x2
	// Position of P2 field.
	PIO_PER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PER_P2_Msk = 0x4
	// Bit P2.
	PIO_PER_P2 = 0x4
	// Position of P3 field.
	PIO_PER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PER_P3_Msk = 0x8
	// Bit P3.
	PIO_PER_P3 = 0x8
	// Position of P4 field.
	PIO_PER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PER_P4_Msk = 0x10
	// Bit P4.
	PIO_PER_P4 = 0x10
	// Position of P5 field.
	PIO_PER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PER_P5_Msk = 0x20
	// Bit P5.
	PIO_PER_P5 = 0x20
	// Position of P6 field.
	PIO_PER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PER_P6_Msk = 0x40
	// Bit P6.
	PIO_PER_P6 = 0x40
	// Position of P7 field.
	PIO_PER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PER_P7_Msk = 0x80
	// Bit P7.
	PIO_PER_P7 = 0x80
	// Position of P8 field.
	PIO_PER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PER_P8_Msk = 0x100
	// Bit P8.
	PIO_PER_P8 = 0x100
	// Position of P9 field.
	PIO_PER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PER_P9_Msk = 0x200
	// Bit P9.
	PIO_PER_P9 = 0x200
	// Position of P10 field.
	PIO_PER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PER_P10_Msk = 0x400
	// Bit P10.
	PIO_PER_P10 = 0x400
	// Position of P11 field.
	PIO_PER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PER_P11_Msk = 0x800
	// Bit P11.
	PIO_PER_P11 = 0x800
	// Position of P12 field.
	PIO_PER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PER_P12 = 0x1000
	// Position of P13 field.
	PIO_PER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PER_P13 = 0x2000
	// Position of P14 field.
	PIO_PER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PER_P14 = 0x4000
	// Position of P15 field.
	PIO_PER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PER_P15 = 0x8000
	// Position of P16 field.
	PIO_PER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PER_P16 = 0x10000
	// Position of P17 field.
	PIO_PER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PER_P17 = 0x20000
	// Position of P18 field.
	PIO_PER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PER_P18 = 0x40000
	// Position of P19 field.
	PIO_PER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PER_P19 = 0x80000
	// Position of P20 field.
	PIO_PER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PER_P20 = 0x100000
	// Position of P21 field.
	PIO_PER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PER_P21 = 0x200000
	// Position of P22 field.
	PIO_PER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PER_P22 = 0x400000
	// Position of P23 field.
	PIO_PER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PER_P23 = 0x800000
	// Position of P24 field.
	PIO_PER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PER_P31 = 0x80000000

	// PDR: PIO Disable Register
	// Position of P0 field.
	PIO_PDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDR_P0 = 0x1
	// Position of P1 field.
	PIO_PDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDR_P1 = 0x2
	// Position of P2 field.
	PIO_PDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDR_P2 = 0x4
	// Position of P3 field.
	PIO_PDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDR_P3 = 0x8
	// Position of P4 field.
	PIO_PDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDR_P4 = 0x10
	// Position of P5 field.
	PIO_PDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDR_P5 = 0x20
	// Position of P6 field.
	PIO_PDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDR_P6 = 0x40
	// Position of P7 field.
	PIO_PDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDR_P7 = 0x80
	// Position of P8 field.
	PIO_PDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDR_P8 = 0x100
	// Position of P9 field.
	PIO_PDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDR_P9 = 0x200
	// Position of P10 field.
	PIO_PDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDR_P10 = 0x400
	// Position of P11 field.
	PIO_PDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDR_P11 = 0x800
	// Position of P12 field.
	PIO_PDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDR_P31 = 0x80000000

	// PSR: PIO Status Register
	// Position of P0 field.
	PIO_PSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PSR_P0 = 0x1
	// Position of P1 field.
	PIO_PSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PSR_P1 = 0x2
	// Position of P2 field.
	PIO_PSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PSR_P2 = 0x4
	// Position of P3 field.
	PIO_PSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PSR_P3 = 0x8
	// Position of P4 field.
	PIO_PSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PSR_P4 = 0x10
	// Position of P5 field.
	PIO_PSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PSR_P5 = 0x20
	// Position of P6 field.
	PIO_PSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PSR_P6 = 0x40
	// Position of P7 field.
	PIO_PSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PSR_P7 = 0x80
	// Position of P8 field.
	PIO_PSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PSR_P8 = 0x100
	// Position of P9 field.
	PIO_PSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PSR_P9 = 0x200
	// Position of P10 field.
	PIO_PSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PSR_P10 = 0x400
	// Position of P11 field.
	PIO_PSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PSR_P11 = 0x800
	// Position of P12 field.
	PIO_PSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PSR_P31 = 0x80000000

	// OER: Output Enable Register
	// Position of P0 field.
	PIO_OER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OER_P0_Msk = 0x1
	// Bit P0.
	PIO_OER_P0 = 0x1
	// Position of P1 field.
	PIO_OER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OER_P1_Msk = 0x2
	// Bit P1.
	PIO_OER_P1 = 0x2
	// Position of P2 field.
	PIO_OER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OER_P2_Msk = 0x4
	// Bit P2.
	PIO_OER_P2 = 0x4
	// Position of P3 field.
	PIO_OER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OER_P3_Msk = 0x8
	// Bit P3.
	PIO_OER_P3 = 0x8
	// Position of P4 field.
	PIO_OER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OER_P4_Msk = 0x10
	// Bit P4.
	PIO_OER_P4 = 0x10
	// Position of P5 field.
	PIO_OER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OER_P5_Msk = 0x20
	// Bit P5.
	PIO_OER_P5 = 0x20
	// Position of P6 field.
	PIO_OER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OER_P6_Msk = 0x40
	// Bit P6.
	PIO_OER_P6 = 0x40
	// Position of P7 field.
	PIO_OER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OER_P7_Msk = 0x80
	// Bit P7.
	PIO_OER_P7 = 0x80
	// Position of P8 field.
	PIO_OER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OER_P8_Msk = 0x100
	// Bit P8.
	PIO_OER_P8 = 0x100
	// Position of P9 field.
	PIO_OER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OER_P9_Msk = 0x200
	// Bit P9.
	PIO_OER_P9 = 0x200
	// Position of P10 field.
	PIO_OER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OER_P10_Msk = 0x400
	// Bit P10.
	PIO_OER_P10 = 0x400
	// Position of P11 field.
	PIO_OER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OER_P11_Msk = 0x800
	// Bit P11.
	PIO_OER_P11 = 0x800
	// Position of P12 field.
	PIO_OER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OER_P12 = 0x1000
	// Position of P13 field.
	PIO_OER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OER_P13 = 0x2000
	// Position of P14 field.
	PIO_OER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OER_P14 = 0x4000
	// Position of P15 field.
	PIO_OER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OER_P15 = 0x8000
	// Position of P16 field.
	PIO_OER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OER_P16 = 0x10000
	// Position of P17 field.
	PIO_OER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OER_P17 = 0x20000
	// Position of P18 field.
	PIO_OER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OER_P18 = 0x40000
	// Position of P19 field.
	PIO_OER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OER_P19 = 0x80000
	// Position of P20 field.
	PIO_OER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OER_P20 = 0x100000
	// Position of P21 field.
	PIO_OER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OER_P21 = 0x200000
	// Position of P22 field.
	PIO_OER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OER_P22 = 0x400000
	// Position of P23 field.
	PIO_OER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OER_P23 = 0x800000
	// Position of P24 field.
	PIO_OER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OER_P31 = 0x80000000

	// ODR: Output Disable Register
	// Position of P0 field.
	PIO_ODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODR_P0 = 0x1
	// Position of P1 field.
	PIO_ODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODR_P1 = 0x2
	// Position of P2 field.
	PIO_ODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODR_P2 = 0x4
	// Position of P3 field.
	PIO_ODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODR_P3 = 0x8
	// Position of P4 field.
	PIO_ODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODR_P4 = 0x10
	// Position of P5 field.
	PIO_ODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODR_P5 = 0x20
	// Position of P6 field.
	PIO_ODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODR_P6 = 0x40
	// Position of P7 field.
	PIO_ODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODR_P7 = 0x80
	// Position of P8 field.
	PIO_ODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODR_P8 = 0x100
	// Position of P9 field.
	PIO_ODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODR_P9 = 0x200
	// Position of P10 field.
	PIO_ODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODR_P10 = 0x400
	// Position of P11 field.
	PIO_ODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODR_P11 = 0x800
	// Position of P12 field.
	PIO_ODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODR_P31 = 0x80000000

	// OSR: Output Status Register
	// Position of P0 field.
	PIO_OSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OSR_P0 = 0x1
	// Position of P1 field.
	PIO_OSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OSR_P1 = 0x2
	// Position of P2 field.
	PIO_OSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OSR_P2 = 0x4
	// Position of P3 field.
	PIO_OSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OSR_P3 = 0x8
	// Position of P4 field.
	PIO_OSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OSR_P4 = 0x10
	// Position of P5 field.
	PIO_OSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OSR_P5 = 0x20
	// Position of P6 field.
	PIO_OSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OSR_P6 = 0x40
	// Position of P7 field.
	PIO_OSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OSR_P7 = 0x80
	// Position of P8 field.
	PIO_OSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OSR_P8 = 0x100
	// Position of P9 field.
	PIO_OSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OSR_P9 = 0x200
	// Position of P10 field.
	PIO_OSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OSR_P10 = 0x400
	// Position of P11 field.
	PIO_OSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OSR_P11 = 0x800
	// Position of P12 field.
	PIO_OSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OSR_P31 = 0x80000000

	// IFER: Glitch Input Filter Enable Register
	// Position of P0 field.
	PIO_IFER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFER_P0_Msk = 0x1
	// Bit P0.
	PIO_IFER_P0 = 0x1
	// Position of P1 field.
	PIO_IFER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFER_P1_Msk = 0x2
	// Bit P1.
	PIO_IFER_P1 = 0x2
	// Position of P2 field.
	PIO_IFER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFER_P2_Msk = 0x4
	// Bit P2.
	PIO_IFER_P2 = 0x4
	// Position of P3 field.
	PIO_IFER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFER_P3_Msk = 0x8
	// Bit P3.
	PIO_IFER_P3 = 0x8
	// Position of P4 field.
	PIO_IFER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFER_P4_Msk = 0x10
	// Bit P4.
	PIO_IFER_P4 = 0x10
	// Position of P5 field.
	PIO_IFER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFER_P5_Msk = 0x20
	// Bit P5.
	PIO_IFER_P5 = 0x20
	// Position of P6 field.
	PIO_IFER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFER_P6_Msk = 0x40
	// Bit P6.
	PIO_IFER_P6 = 0x40
	// Position of P7 field.
	PIO_IFER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFER_P7_Msk = 0x80
	// Bit P7.
	PIO_IFER_P7 = 0x80
	// Position of P8 field.
	PIO_IFER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFER_P8_Msk = 0x100
	// Bit P8.
	PIO_IFER_P8 = 0x100
	// Position of P9 field.
	PIO_IFER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFER_P9_Msk = 0x200
	// Bit P9.
	PIO_IFER_P9 = 0x200
	// Position of P10 field.
	PIO_IFER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFER_P10_Msk = 0x400
	// Bit P10.
	PIO_IFER_P10 = 0x400
	// Position of P11 field.
	PIO_IFER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFER_P11_Msk = 0x800
	// Bit P11.
	PIO_IFER_P11 = 0x800
	// Position of P12 field.
	PIO_IFER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFER_P12 = 0x1000
	// Position of P13 field.
	PIO_IFER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFER_P13 = 0x2000
	// Position of P14 field.
	PIO_IFER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFER_P14 = 0x4000
	// Position of P15 field.
	PIO_IFER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFER_P15 = 0x8000
	// Position of P16 field.
	PIO_IFER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFER_P16 = 0x10000
	// Position of P17 field.
	PIO_IFER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFER_P17 = 0x20000
	// Position of P18 field.
	PIO_IFER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFER_P18 = 0x40000
	// Position of P19 field.
	PIO_IFER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFER_P19 = 0x80000
	// Position of P20 field.
	PIO_IFER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFER_P20 = 0x100000
	// Position of P21 field.
	PIO_IFER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFER_P21 = 0x200000
	// Position of P22 field.
	PIO_IFER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFER_P22 = 0x400000
	// Position of P23 field.
	PIO_IFER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFER_P23 = 0x800000
	// Position of P24 field.
	PIO_IFER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFER_P31 = 0x80000000

	// IFDR: Glitch Input Filter Disable Register
	// Position of P0 field.
	PIO_IFDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFDR_P0 = 0x1
	// Position of P1 field.
	PIO_IFDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFDR_P1 = 0x2
	// Position of P2 field.
	PIO_IFDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFDR_P2 = 0x4
	// Position of P3 field.
	PIO_IFDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFDR_P3 = 0x8
	// Position of P4 field.
	PIO_IFDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFDR_P4 = 0x10
	// Position of P5 field.
	PIO_IFDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFDR_P5 = 0x20
	// Position of P6 field.
	PIO_IFDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFDR_P6 = 0x40
	// Position of P7 field.
	PIO_IFDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFDR_P7 = 0x80
	// Position of P8 field.
	PIO_IFDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFDR_P8 = 0x100
	// Position of P9 field.
	PIO_IFDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFDR_P9 = 0x200
	// Position of P10 field.
	PIO_IFDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFDR_P10 = 0x400
	// Position of P11 field.
	PIO_IFDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFDR_P11 = 0x800
	// Position of P12 field.
	PIO_IFDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFDR_P31 = 0x80000000

	// IFSR: Glitch Input Filter Status Register
	// Position of P0 field.
	PIO_IFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSR_P31 = 0x80000000

	// SODR: Set Output Data Register
	// Position of P0 field.
	PIO_SODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_SODR_P0_Msk = 0x1
	// Bit P0.
	PIO_SODR_P0 = 0x1
	// Position of P1 field.
	PIO_SODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_SODR_P1_Msk = 0x2
	// Bit P1.
	PIO_SODR_P1 = 0x2
	// Position of P2 field.
	PIO_SODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_SODR_P2_Msk = 0x4
	// Bit P2.
	PIO_SODR_P2 = 0x4
	// Position of P3 field.
	PIO_SODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_SODR_P3_Msk = 0x8
	// Bit P3.
	PIO_SODR_P3 = 0x8
	// Position of P4 field.
	PIO_SODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_SODR_P4_Msk = 0x10
	// Bit P4.
	PIO_SODR_P4 = 0x10
	// Position of P5 field.
	PIO_SODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_SODR_P5_Msk = 0x20
	// Bit P5.
	PIO_SODR_P5 = 0x20
	// Position of P6 field.
	PIO_SODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_SODR_P6_Msk = 0x40
	// Bit P6.
	PIO_SODR_P6 = 0x40
	// Position of P7 field.
	PIO_SODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_SODR_P7_Msk = 0x80
	// Bit P7.
	PIO_SODR_P7 = 0x80
	// Position of P8 field.
	PIO_SODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_SODR_P8_Msk = 0x100
	// Bit P8.
	PIO_SODR_P8 = 0x100
	// Position of P9 field.
	PIO_SODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_SODR_P9_Msk = 0x200
	// Bit P9.
	PIO_SODR_P9 = 0x200
	// Position of P10 field.
	PIO_SODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_SODR_P10_Msk = 0x400
	// Bit P10.
	PIO_SODR_P10 = 0x400
	// Position of P11 field.
	PIO_SODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_SODR_P11_Msk = 0x800
	// Bit P11.
	PIO_SODR_P11 = 0x800
	// Position of P12 field.
	PIO_SODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_SODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_SODR_P12 = 0x1000
	// Position of P13 field.
	PIO_SODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_SODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_SODR_P13 = 0x2000
	// Position of P14 field.
	PIO_SODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_SODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_SODR_P14 = 0x4000
	// Position of P15 field.
	PIO_SODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_SODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_SODR_P15 = 0x8000
	// Position of P16 field.
	PIO_SODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_SODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_SODR_P16 = 0x10000
	// Position of P17 field.
	PIO_SODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_SODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_SODR_P17 = 0x20000
	// Position of P18 field.
	PIO_SODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_SODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_SODR_P18 = 0x40000
	// Position of P19 field.
	PIO_SODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_SODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_SODR_P19 = 0x80000
	// Position of P20 field.
	PIO_SODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_SODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_SODR_P20 = 0x100000
	// Position of P21 field.
	PIO_SODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_SODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_SODR_P21 = 0x200000
	// Position of P22 field.
	PIO_SODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_SODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_SODR_P22 = 0x400000
	// Position of P23 field.
	PIO_SODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_SODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_SODR_P23 = 0x800000
	// Position of P24 field.
	PIO_SODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_SODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_SODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_SODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_SODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_SODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_SODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_SODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_SODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_SODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_SODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_SODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_SODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_SODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_SODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_SODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_SODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_SODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_SODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_SODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_SODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_SODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_SODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_SODR_P31 = 0x80000000

	// CODR: Clear Output Data Register
	// Position of P0 field.
	PIO_CODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_CODR_P0_Msk = 0x1
	// Bit P0.
	PIO_CODR_P0 = 0x1
	// Position of P1 field.
	PIO_CODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_CODR_P1_Msk = 0x2
	// Bit P1.
	PIO_CODR_P1 = 0x2
	// Position of P2 field.
	PIO_CODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_CODR_P2_Msk = 0x4
	// Bit P2.
	PIO_CODR_P2 = 0x4
	// Position of P3 field.
	PIO_CODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_CODR_P3_Msk = 0x8
	// Bit P3.
	PIO_CODR_P3 = 0x8
	// Position of P4 field.
	PIO_CODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_CODR_P4_Msk = 0x10
	// Bit P4.
	PIO_CODR_P4 = 0x10
	// Position of P5 field.
	PIO_CODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_CODR_P5_Msk = 0x20
	// Bit P5.
	PIO_CODR_P5 = 0x20
	// Position of P6 field.
	PIO_CODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_CODR_P6_Msk = 0x40
	// Bit P6.
	PIO_CODR_P6 = 0x40
	// Position of P7 field.
	PIO_CODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_CODR_P7_Msk = 0x80
	// Bit P7.
	PIO_CODR_P7 = 0x80
	// Position of P8 field.
	PIO_CODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_CODR_P8_Msk = 0x100
	// Bit P8.
	PIO_CODR_P8 = 0x100
	// Position of P9 field.
	PIO_CODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_CODR_P9_Msk = 0x200
	// Bit P9.
	PIO_CODR_P9 = 0x200
	// Position of P10 field.
	PIO_CODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_CODR_P10_Msk = 0x400
	// Bit P10.
	PIO_CODR_P10 = 0x400
	// Position of P11 field.
	PIO_CODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_CODR_P11_Msk = 0x800
	// Bit P11.
	PIO_CODR_P11 = 0x800
	// Position of P12 field.
	PIO_CODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_CODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_CODR_P12 = 0x1000
	// Position of P13 field.
	PIO_CODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_CODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_CODR_P13 = 0x2000
	// Position of P14 field.
	PIO_CODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_CODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_CODR_P14 = 0x4000
	// Position of P15 field.
	PIO_CODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_CODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_CODR_P15 = 0x8000
	// Position of P16 field.
	PIO_CODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_CODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_CODR_P16 = 0x10000
	// Position of P17 field.
	PIO_CODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_CODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_CODR_P17 = 0x20000
	// Position of P18 field.
	PIO_CODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_CODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_CODR_P18 = 0x40000
	// Position of P19 field.
	PIO_CODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_CODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_CODR_P19 = 0x80000
	// Position of P20 field.
	PIO_CODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_CODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_CODR_P20 = 0x100000
	// Position of P21 field.
	PIO_CODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_CODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_CODR_P21 = 0x200000
	// Position of P22 field.
	PIO_CODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_CODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_CODR_P22 = 0x400000
	// Position of P23 field.
	PIO_CODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_CODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_CODR_P23 = 0x800000
	// Position of P24 field.
	PIO_CODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_CODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_CODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_CODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_CODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_CODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_CODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_CODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_CODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_CODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_CODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_CODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_CODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_CODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_CODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_CODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_CODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_CODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_CODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_CODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_CODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_CODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_CODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_CODR_P31 = 0x80000000

	// ODSR: Output Data Status Register
	// Position of P0 field.
	PIO_ODSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODSR_P0 = 0x1
	// Position of P1 field.
	PIO_ODSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODSR_P1 = 0x2
	// Position of P2 field.
	PIO_ODSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODSR_P2 = 0x4
	// Position of P3 field.
	PIO_ODSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODSR_P3 = 0x8
	// Position of P4 field.
	PIO_ODSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODSR_P4 = 0x10
	// Position of P5 field.
	PIO_ODSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODSR_P5 = 0x20
	// Position of P6 field.
	PIO_ODSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODSR_P6 = 0x40
	// Position of P7 field.
	PIO_ODSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODSR_P7 = 0x80
	// Position of P8 field.
	PIO_ODSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODSR_P8 = 0x100
	// Position of P9 field.
	PIO_ODSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODSR_P9 = 0x200
	// Position of P10 field.
	PIO_ODSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODSR_P10 = 0x400
	// Position of P11 field.
	PIO_ODSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODSR_P11 = 0x800
	// Position of P12 field.
	PIO_ODSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODSR_P31 = 0x80000000

	// PDSR: Pin Data Status Register
	// Position of P0 field.
	PIO_PDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDSR_P0 = 0x1
	// Position of P1 field.
	PIO_PDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDSR_P1 = 0x2
	// Position of P2 field.
	PIO_PDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDSR_P2 = 0x4
	// Position of P3 field.
	PIO_PDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDSR_P3 = 0x8
	// Position of P4 field.
	PIO_PDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDSR_P4 = 0x10
	// Position of P5 field.
	PIO_PDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDSR_P5 = 0x20
	// Position of P6 field.
	PIO_PDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDSR_P6 = 0x40
	// Position of P7 field.
	PIO_PDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDSR_P7 = 0x80
	// Position of P8 field.
	PIO_PDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDSR_P8 = 0x100
	// Position of P9 field.
	PIO_PDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDSR_P9 = 0x200
	// Position of P10 field.
	PIO_PDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDSR_P10 = 0x400
	// Position of P11 field.
	PIO_PDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDSR_P11 = 0x800
	// Position of P12 field.
	PIO_PDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDSR_P31 = 0x80000000

	// IER: Interrupt Enable Register
	// Position of P0 field.
	PIO_IER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IER_P0_Msk = 0x1
	// Bit P0.
	PIO_IER_P0 = 0x1
	// Position of P1 field.
	PIO_IER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IER_P1_Msk = 0x2
	// Bit P1.
	PIO_IER_P1 = 0x2
	// Position of P2 field.
	PIO_IER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IER_P2_Msk = 0x4
	// Bit P2.
	PIO_IER_P2 = 0x4
	// Position of P3 field.
	PIO_IER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IER_P3_Msk = 0x8
	// Bit P3.
	PIO_IER_P3 = 0x8
	// Position of P4 field.
	PIO_IER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IER_P4_Msk = 0x10
	// Bit P4.
	PIO_IER_P4 = 0x10
	// Position of P5 field.
	PIO_IER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IER_P5_Msk = 0x20
	// Bit P5.
	PIO_IER_P5 = 0x20
	// Position of P6 field.
	PIO_IER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IER_P6_Msk = 0x40
	// Bit P6.
	PIO_IER_P6 = 0x40
	// Position of P7 field.
	PIO_IER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IER_P7_Msk = 0x80
	// Bit P7.
	PIO_IER_P7 = 0x80
	// Position of P8 field.
	PIO_IER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IER_P8_Msk = 0x100
	// Bit P8.
	PIO_IER_P8 = 0x100
	// Position of P9 field.
	PIO_IER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IER_P9_Msk = 0x200
	// Bit P9.
	PIO_IER_P9 = 0x200
	// Position of P10 field.
	PIO_IER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IER_P10_Msk = 0x400
	// Bit P10.
	PIO_IER_P10 = 0x400
	// Position of P11 field.
	PIO_IER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IER_P11_Msk = 0x800
	// Bit P11.
	PIO_IER_P11 = 0x800
	// Position of P12 field.
	PIO_IER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IER_P12 = 0x1000
	// Position of P13 field.
	PIO_IER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IER_P13 = 0x2000
	// Position of P14 field.
	PIO_IER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IER_P14 = 0x4000
	// Position of P15 field.
	PIO_IER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IER_P15 = 0x8000
	// Position of P16 field.
	PIO_IER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IER_P16 = 0x10000
	// Position of P17 field.
	PIO_IER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IER_P17 = 0x20000
	// Position of P18 field.
	PIO_IER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IER_P18 = 0x40000
	// Position of P19 field.
	PIO_IER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IER_P19 = 0x80000
	// Position of P20 field.
	PIO_IER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IER_P20 = 0x100000
	// Position of P21 field.
	PIO_IER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IER_P21 = 0x200000
	// Position of P22 field.
	PIO_IER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IER_P22 = 0x400000
	// Position of P23 field.
	PIO_IER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IER_P23 = 0x800000
	// Position of P24 field.
	PIO_IER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IER_P31 = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of P0 field.
	PIO_IDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IDR_P0 = 0x1
	// Position of P1 field.
	PIO_IDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IDR_P1 = 0x2
	// Position of P2 field.
	PIO_IDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IDR_P2 = 0x4
	// Position of P3 field.
	PIO_IDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IDR_P3 = 0x8
	// Position of P4 field.
	PIO_IDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IDR_P4 = 0x10
	// Position of P5 field.
	PIO_IDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IDR_P5 = 0x20
	// Position of P6 field.
	PIO_IDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IDR_P6 = 0x40
	// Position of P7 field.
	PIO_IDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IDR_P7 = 0x80
	// Position of P8 field.
	PIO_IDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IDR_P8 = 0x100
	// Position of P9 field.
	PIO_IDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IDR_P9 = 0x200
	// Position of P10 field.
	PIO_IDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IDR_P10 = 0x400
	// Position of P11 field.
	PIO_IDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IDR_P11 = 0x800
	// Position of P12 field.
	PIO_IDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IDR_P31 = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of P0 field.
	PIO_IMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IMR_P0_Msk = 0x1
	// Bit P0.
	PIO_IMR_P0 = 0x1
	// Position of P1 field.
	PIO_IMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IMR_P1_Msk = 0x2
	// Bit P1.
	PIO_IMR_P1 = 0x2
	// Position of P2 field.
	PIO_IMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IMR_P2_Msk = 0x4
	// Bit P2.
	PIO_IMR_P2 = 0x4
	// Position of P3 field.
	PIO_IMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IMR_P3_Msk = 0x8
	// Bit P3.
	PIO_IMR_P3 = 0x8
	// Position of P4 field.
	PIO_IMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IMR_P4_Msk = 0x10
	// Bit P4.
	PIO_IMR_P4 = 0x10
	// Position of P5 field.
	PIO_IMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IMR_P5_Msk = 0x20
	// Bit P5.
	PIO_IMR_P5 = 0x20
	// Position of P6 field.
	PIO_IMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IMR_P6_Msk = 0x40
	// Bit P6.
	PIO_IMR_P6 = 0x40
	// Position of P7 field.
	PIO_IMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IMR_P7_Msk = 0x80
	// Bit P7.
	PIO_IMR_P7 = 0x80
	// Position of P8 field.
	PIO_IMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IMR_P8_Msk = 0x100
	// Bit P8.
	PIO_IMR_P8 = 0x100
	// Position of P9 field.
	PIO_IMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IMR_P9_Msk = 0x200
	// Bit P9.
	PIO_IMR_P9 = 0x200
	// Position of P10 field.
	PIO_IMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IMR_P10_Msk = 0x400
	// Bit P10.
	PIO_IMR_P10 = 0x400
	// Position of P11 field.
	PIO_IMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IMR_P11_Msk = 0x800
	// Bit P11.
	PIO_IMR_P11 = 0x800
	// Position of P12 field.
	PIO_IMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IMR_P12 = 0x1000
	// Position of P13 field.
	PIO_IMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IMR_P13 = 0x2000
	// Position of P14 field.
	PIO_IMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IMR_P14 = 0x4000
	// Position of P15 field.
	PIO_IMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IMR_P15 = 0x8000
	// Position of P16 field.
	PIO_IMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IMR_P16 = 0x10000
	// Position of P17 field.
	PIO_IMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IMR_P17 = 0x20000
	// Position of P18 field.
	PIO_IMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IMR_P18 = 0x40000
	// Position of P19 field.
	PIO_IMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IMR_P19 = 0x80000
	// Position of P20 field.
	PIO_IMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IMR_P20 = 0x100000
	// Position of P21 field.
	PIO_IMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IMR_P21 = 0x200000
	// Position of P22 field.
	PIO_IMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IMR_P22 = 0x400000
	// Position of P23 field.
	PIO_IMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IMR_P23 = 0x800000
	// Position of P24 field.
	PIO_IMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IMR_P31 = 0x80000000

	// ISR: Interrupt Status Register
	// Position of P0 field.
	PIO_ISR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ISR_P0_Msk = 0x1
	// Bit P0.
	PIO_ISR_P0 = 0x1
	// Position of P1 field.
	PIO_ISR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ISR_P1_Msk = 0x2
	// Bit P1.
	PIO_ISR_P1 = 0x2
	// Position of P2 field.
	PIO_ISR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ISR_P2_Msk = 0x4
	// Bit P2.
	PIO_ISR_P2 = 0x4
	// Position of P3 field.
	PIO_ISR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ISR_P3_Msk = 0x8
	// Bit P3.
	PIO_ISR_P3 = 0x8
	// Position of P4 field.
	PIO_ISR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ISR_P4_Msk = 0x10
	// Bit P4.
	PIO_ISR_P4 = 0x10
	// Position of P5 field.
	PIO_ISR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ISR_P5_Msk = 0x20
	// Bit P5.
	PIO_ISR_P5 = 0x20
	// Position of P6 field.
	PIO_ISR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ISR_P6_Msk = 0x40
	// Bit P6.
	PIO_ISR_P6 = 0x40
	// Position of P7 field.
	PIO_ISR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ISR_P7_Msk = 0x80
	// Bit P7.
	PIO_ISR_P7 = 0x80
	// Position of P8 field.
	PIO_ISR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ISR_P8_Msk = 0x100
	// Bit P8.
	PIO_ISR_P8 = 0x100
	// Position of P9 field.
	PIO_ISR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ISR_P9_Msk = 0x200
	// Bit P9.
	PIO_ISR_P9 = 0x200
	// Position of P10 field.
	PIO_ISR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ISR_P10_Msk = 0x400
	// Bit P10.
	PIO_ISR_P10 = 0x400
	// Position of P11 field.
	PIO_ISR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ISR_P11_Msk = 0x800
	// Bit P11.
	PIO_ISR_P11 = 0x800
	// Position of P12 field.
	PIO_ISR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ISR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ISR_P12 = 0x1000
	// Position of P13 field.
	PIO_ISR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ISR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ISR_P13 = 0x2000
	// Position of P14 field.
	PIO_ISR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ISR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ISR_P14 = 0x4000
	// Position of P15 field.
	PIO_ISR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ISR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ISR_P15 = 0x8000
	// Position of P16 field.
	PIO_ISR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ISR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ISR_P16 = 0x10000
	// Position of P17 field.
	PIO_ISR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ISR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ISR_P17 = 0x20000
	// Position of P18 field.
	PIO_ISR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ISR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ISR_P18 = 0x40000
	// Position of P19 field.
	PIO_ISR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ISR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ISR_P19 = 0x80000
	// Position of P20 field.
	PIO_ISR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ISR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ISR_P20 = 0x100000
	// Position of P21 field.
	PIO_ISR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ISR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ISR_P21 = 0x200000
	// Position of P22 field.
	PIO_ISR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ISR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ISR_P22 = 0x400000
	// Position of P23 field.
	PIO_ISR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ISR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ISR_P23 = 0x800000
	// Position of P24 field.
	PIO_ISR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ISR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ISR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ISR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ISR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ISR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ISR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ISR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ISR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ISR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ISR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ISR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ISR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ISR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ISR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ISR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ISR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ISR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ISR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ISR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ISR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ISR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ISR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ISR_P31 = 0x80000000

	// MDER: Multi-driver Enable Register
	// Position of P0 field.
	PIO_MDER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDER_P0_Msk = 0x1
	// Bit P0.
	PIO_MDER_P0 = 0x1
	// Position of P1 field.
	PIO_MDER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDER_P1_Msk = 0x2
	// Bit P1.
	PIO_MDER_P1 = 0x2
	// Position of P2 field.
	PIO_MDER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDER_P2_Msk = 0x4
	// Bit P2.
	PIO_MDER_P2 = 0x4
	// Position of P3 field.
	PIO_MDER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDER_P3_Msk = 0x8
	// Bit P3.
	PIO_MDER_P3 = 0x8
	// Position of P4 field.
	PIO_MDER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDER_P4_Msk = 0x10
	// Bit P4.
	PIO_MDER_P4 = 0x10
	// Position of P5 field.
	PIO_MDER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDER_P5_Msk = 0x20
	// Bit P5.
	PIO_MDER_P5 = 0x20
	// Position of P6 field.
	PIO_MDER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDER_P6_Msk = 0x40
	// Bit P6.
	PIO_MDER_P6 = 0x40
	// Position of P7 field.
	PIO_MDER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDER_P7_Msk = 0x80
	// Bit P7.
	PIO_MDER_P7 = 0x80
	// Position of P8 field.
	PIO_MDER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDER_P8_Msk = 0x100
	// Bit P8.
	PIO_MDER_P8 = 0x100
	// Position of P9 field.
	PIO_MDER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDER_P9_Msk = 0x200
	// Bit P9.
	PIO_MDER_P9 = 0x200
	// Position of P10 field.
	PIO_MDER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDER_P10_Msk = 0x400
	// Bit P10.
	PIO_MDER_P10 = 0x400
	// Position of P11 field.
	PIO_MDER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDER_P11_Msk = 0x800
	// Bit P11.
	PIO_MDER_P11 = 0x800
	// Position of P12 field.
	PIO_MDER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDER_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDER_P12 = 0x1000
	// Position of P13 field.
	PIO_MDER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDER_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDER_P13 = 0x2000
	// Position of P14 field.
	PIO_MDER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDER_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDER_P14 = 0x4000
	// Position of P15 field.
	PIO_MDER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDER_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDER_P15 = 0x8000
	// Position of P16 field.
	PIO_MDER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDER_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDER_P16 = 0x10000
	// Position of P17 field.
	PIO_MDER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDER_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDER_P17 = 0x20000
	// Position of P18 field.
	PIO_MDER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDER_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDER_P18 = 0x40000
	// Position of P19 field.
	PIO_MDER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDER_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDER_P19 = 0x80000
	// Position of P20 field.
	PIO_MDER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDER_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDER_P20 = 0x100000
	// Position of P21 field.
	PIO_MDER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDER_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDER_P21 = 0x200000
	// Position of P22 field.
	PIO_MDER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDER_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDER_P22 = 0x400000
	// Position of P23 field.
	PIO_MDER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDER_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDER_P23 = 0x800000
	// Position of P24 field.
	PIO_MDER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDER_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDER_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDER_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDER_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDER_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDER_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDER_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDER_P31 = 0x80000000

	// MDDR: Multi-driver Disable Register
	// Position of P0 field.
	PIO_MDDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDDR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDDR_P0 = 0x1
	// Position of P1 field.
	PIO_MDDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDDR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDDR_P1 = 0x2
	// Position of P2 field.
	PIO_MDDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDDR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDDR_P2 = 0x4
	// Position of P3 field.
	PIO_MDDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDDR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDDR_P3 = 0x8
	// Position of P4 field.
	PIO_MDDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDDR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDDR_P4 = 0x10
	// Position of P5 field.
	PIO_MDDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDDR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDDR_P5 = 0x20
	// Position of P6 field.
	PIO_MDDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDDR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDDR_P6 = 0x40
	// Position of P7 field.
	PIO_MDDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDDR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDDR_P7 = 0x80
	// Position of P8 field.
	PIO_MDDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDDR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDDR_P8 = 0x100
	// Position of P9 field.
	PIO_MDDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDDR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDDR_P9 = 0x200
	// Position of P10 field.
	PIO_MDDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDDR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDDR_P10 = 0x400
	// Position of P11 field.
	PIO_MDDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDDR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDDR_P11 = 0x800
	// Position of P12 field.
	PIO_MDDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDDR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDDR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDDR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDDR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDDR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDDR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDDR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDDR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDDR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDDR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDDR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDDR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDDR_P31 = 0x80000000

	// MDSR: Multi-driver Status Register
	// Position of P0 field.
	PIO_MDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDSR_P0 = 0x1
	// Position of P1 field.
	PIO_MDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDSR_P1 = 0x2
	// Position of P2 field.
	PIO_MDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDSR_P2 = 0x4
	// Position of P3 field.
	PIO_MDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDSR_P3 = 0x8
	// Position of P4 field.
	PIO_MDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDSR_P4 = 0x10
	// Position of P5 field.
	PIO_MDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDSR_P5 = 0x20
	// Position of P6 field.
	PIO_MDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDSR_P6 = 0x40
	// Position of P7 field.
	PIO_MDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDSR_P7 = 0x80
	// Position of P8 field.
	PIO_MDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDSR_P8 = 0x100
	// Position of P9 field.
	PIO_MDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDSR_P9 = 0x200
	// Position of P10 field.
	PIO_MDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDSR_P10 = 0x400
	// Position of P11 field.
	PIO_MDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDSR_P11 = 0x800
	// Position of P12 field.
	PIO_MDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDSR_P31 = 0x80000000

	// PUDR: Pull-up Disable Register
	// Position of P0 field.
	PIO_PUDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUDR_P0 = 0x1
	// Position of P1 field.
	PIO_PUDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUDR_P1 = 0x2
	// Position of P2 field.
	PIO_PUDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUDR_P2 = 0x4
	// Position of P3 field.
	PIO_PUDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUDR_P3 = 0x8
	// Position of P4 field.
	PIO_PUDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUDR_P4 = 0x10
	// Position of P5 field.
	PIO_PUDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUDR_P5 = 0x20
	// Position of P6 field.
	PIO_PUDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUDR_P6 = 0x40
	// Position of P7 field.
	PIO_PUDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUDR_P7 = 0x80
	// Position of P8 field.
	PIO_PUDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUDR_P8 = 0x100
	// Position of P9 field.
	PIO_PUDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUDR_P9 = 0x200
	// Position of P10 field.
	PIO_PUDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUDR_P10 = 0x400
	// Position of P11 field.
	PIO_PUDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUDR_P11 = 0x800
	// Position of P12 field.
	PIO_PUDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUDR_P31 = 0x80000000

	// PUER: Pull-up Enable Register
	// Position of P0 field.
	PIO_PUER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUER_P0_Msk = 0x1
	// Bit P0.
	PIO_PUER_P0 = 0x1
	// Position of P1 field.
	PIO_PUER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUER_P1_Msk = 0x2
	// Bit P1.
	PIO_PUER_P1 = 0x2
	// Position of P2 field.
	PIO_PUER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUER_P2_Msk = 0x4
	// Bit P2.
	PIO_PUER_P2 = 0x4
	// Position of P3 field.
	PIO_PUER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUER_P3_Msk = 0x8
	// Bit P3.
	PIO_PUER_P3 = 0x8
	// Position of P4 field.
	PIO_PUER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUER_P4_Msk = 0x10
	// Bit P4.
	PIO_PUER_P4 = 0x10
	// Position of P5 field.
	PIO_PUER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUER_P5_Msk = 0x20
	// Bit P5.
	PIO_PUER_P5 = 0x20
	// Position of P6 field.
	PIO_PUER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUER_P6_Msk = 0x40
	// Bit P6.
	PIO_PUER_P6 = 0x40
	// Position of P7 field.
	PIO_PUER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUER_P7_Msk = 0x80
	// Bit P7.
	PIO_PUER_P7 = 0x80
	// Position of P8 field.
	PIO_PUER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUER_P8_Msk = 0x100
	// Bit P8.
	PIO_PUER_P8 = 0x100
	// Position of P9 field.
	PIO_PUER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUER_P9_Msk = 0x200
	// Bit P9.
	PIO_PUER_P9 = 0x200
	// Position of P10 field.
	PIO_PUER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUER_P10_Msk = 0x400
	// Bit P10.
	PIO_PUER_P10 = 0x400
	// Position of P11 field.
	PIO_PUER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUER_P11_Msk = 0x800
	// Bit P11.
	PIO_PUER_P11 = 0x800
	// Position of P12 field.
	PIO_PUER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUER_P12 = 0x1000
	// Position of P13 field.
	PIO_PUER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUER_P13 = 0x2000
	// Position of P14 field.
	PIO_PUER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUER_P14 = 0x4000
	// Position of P15 field.
	PIO_PUER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUER_P15 = 0x8000
	// Position of P16 field.
	PIO_PUER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUER_P16 = 0x10000
	// Position of P17 field.
	PIO_PUER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUER_P17 = 0x20000
	// Position of P18 field.
	PIO_PUER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUER_P18 = 0x40000
	// Position of P19 field.
	PIO_PUER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUER_P19 = 0x80000
	// Position of P20 field.
	PIO_PUER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUER_P20 = 0x100000
	// Position of P21 field.
	PIO_PUER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUER_P21 = 0x200000
	// Position of P22 field.
	PIO_PUER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUER_P22 = 0x400000
	// Position of P23 field.
	PIO_PUER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUER_P23 = 0x800000
	// Position of P24 field.
	PIO_PUER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUER_P31 = 0x80000000

	// PUSR: Pad Pull-up Status Register
	// Position of P0 field.
	PIO_PUSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUSR_P0 = 0x1
	// Position of P1 field.
	PIO_PUSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUSR_P1 = 0x2
	// Position of P2 field.
	PIO_PUSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUSR_P2 = 0x4
	// Position of P3 field.
	PIO_PUSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUSR_P3 = 0x8
	// Position of P4 field.
	PIO_PUSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUSR_P4 = 0x10
	// Position of P5 field.
	PIO_PUSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUSR_P5 = 0x20
	// Position of P6 field.
	PIO_PUSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUSR_P6 = 0x40
	// Position of P7 field.
	PIO_PUSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUSR_P7 = 0x80
	// Position of P8 field.
	PIO_PUSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUSR_P8 = 0x100
	// Position of P9 field.
	PIO_PUSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUSR_P9 = 0x200
	// Position of P10 field.
	PIO_PUSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUSR_P10 = 0x400
	// Position of P11 field.
	PIO_PUSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUSR_P11 = 0x800
	// Position of P12 field.
	PIO_PUSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUSR_P31 = 0x80000000

	// ABCDSR: Peripheral Select Register
	// Position of P0 field.
	PIO_ABCDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ABCDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ABCDSR_P0 = 0x1
	// Position of P1 field.
	PIO_ABCDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ABCDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ABCDSR_P1 = 0x2
	// Position of P2 field.
	PIO_ABCDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ABCDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ABCDSR_P2 = 0x4
	// Position of P3 field.
	PIO_ABCDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ABCDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ABCDSR_P3 = 0x8
	// Position of P4 field.
	PIO_ABCDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ABCDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ABCDSR_P4 = 0x10
	// Position of P5 field.
	PIO_ABCDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ABCDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ABCDSR_P5 = 0x20
	// Position of P6 field.
	PIO_ABCDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ABCDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ABCDSR_P6 = 0x40
	// Position of P7 field.
	PIO_ABCDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ABCDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ABCDSR_P7 = 0x80
	// Position of P8 field.
	PIO_ABCDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ABCDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ABCDSR_P8 = 0x100
	// Position of P9 field.
	PIO_ABCDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ABCDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ABCDSR_P9 = 0x200
	// Position of P10 field.
	PIO_ABCDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ABCDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ABCDSR_P10 = 0x400
	// Position of P11 field.
	PIO_ABCDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ABCDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ABCDSR_P11 = 0x800
	// Position of P12 field.
	PIO_ABCDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ABCDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ABCDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ABCDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ABCDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ABCDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ABCDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ABCDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ABCDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ABCDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ABCDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ABCDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ABCDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ABCDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ABCDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ABCDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ABCDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ABCDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ABCDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ABCDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ABCDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ABCDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ABCDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ABCDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ABCDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ABCDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ABCDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ABCDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ABCDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ABCDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ABCDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ABCDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ABCDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ABCDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ABCDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ABCDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ABCDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ABCDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ABCDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ABCDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ABCDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ABCDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ABCDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ABCDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ABCDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ABCDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ABCDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ABCDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ABCDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ABCDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ABCDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ABCDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ABCDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ABCDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ABCDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ABCDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ABCDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ABCDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ABCDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ABCDSR_P31 = 0x80000000

	// IFSCDR: Input Filter Slow Clock Disable Register
	// Position of P0 field.
	PIO_IFSCDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSCDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSCDR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSCDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSCDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSCDR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSCDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSCDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSCDR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSCDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSCDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSCDR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSCDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSCDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSCDR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSCDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSCDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSCDR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSCDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSCDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSCDR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSCDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSCDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSCDR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSCDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSCDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSCDR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSCDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSCDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSCDR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSCDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSCDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSCDR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSCDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSCDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSCDR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSCDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSCDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSCDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSCDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSCDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSCDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSCDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSCDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSCDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSCDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSCDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSCDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSCDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSCDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSCDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSCDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSCDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSCDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSCDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSCDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSCDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSCDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSCDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSCDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSCDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSCDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSCDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSCDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSCDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSCDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSCDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSCDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSCDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSCDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSCDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSCDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSCDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSCDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSCDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSCDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSCDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSCDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSCDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSCDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSCDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSCDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSCDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSCDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSCDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSCDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSCDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSCDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSCDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSCDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSCDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSCDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSCDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSCDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSCDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSCDR_P31 = 0x80000000

	// IFSCER: Input Filter Slow Clock Enable Register
	// Position of P0 field.
	PIO_IFSCER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSCER_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSCER_P0 = 0x1
	// Position of P1 field.
	PIO_IFSCER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSCER_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSCER_P1 = 0x2
	// Position of P2 field.
	PIO_IFSCER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSCER_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSCER_P2 = 0x4
	// Position of P3 field.
	PIO_IFSCER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSCER_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSCER_P3 = 0x8
	// Position of P4 field.
	PIO_IFSCER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSCER_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSCER_P4 = 0x10
	// Position of P5 field.
	PIO_IFSCER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSCER_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSCER_P5 = 0x20
	// Position of P6 field.
	PIO_IFSCER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSCER_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSCER_P6 = 0x40
	// Position of P7 field.
	PIO_IFSCER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSCER_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSCER_P7 = 0x80
	// Position of P8 field.
	PIO_IFSCER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSCER_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSCER_P8 = 0x100
	// Position of P9 field.
	PIO_IFSCER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSCER_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSCER_P9 = 0x200
	// Position of P10 field.
	PIO_IFSCER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSCER_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSCER_P10 = 0x400
	// Position of P11 field.
	PIO_IFSCER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSCER_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSCER_P11 = 0x800
	// Position of P12 field.
	PIO_IFSCER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSCER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSCER_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSCER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSCER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSCER_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSCER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSCER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSCER_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSCER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSCER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSCER_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSCER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSCER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSCER_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSCER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSCER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSCER_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSCER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSCER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSCER_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSCER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSCER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSCER_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSCER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSCER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSCER_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSCER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSCER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSCER_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSCER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSCER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSCER_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSCER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSCER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSCER_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSCER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSCER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSCER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSCER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSCER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSCER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSCER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSCER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSCER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSCER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSCER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSCER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSCER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSCER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSCER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSCER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSCER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSCER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSCER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSCER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSCER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSCER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSCER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSCER_P31 = 0x80000000

	// IFSCSR: Input Filter Slow Clock Status Register
	// Position of P0 field.
	PIO_IFSCSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSCSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSCSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSCSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSCSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSCSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSCSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSCSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSCSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSCSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSCSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSCSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSCSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSCSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSCSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSCSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSCSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSCSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSCSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSCSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSCSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSCSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSCSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSCSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSCSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSCSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSCSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSCSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSCSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSCSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSCSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSCSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSCSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSCSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSCSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSCSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSCSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSCSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSCSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSCSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSCSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSCSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSCSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSCSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSCSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSCSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSCSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSCSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSCSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSCSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSCSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSCSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSCSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSCSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSCSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSCSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSCSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSCSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSCSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSCSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSCSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSCSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSCSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSCSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSCSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSCSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSCSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSCSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSCSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSCSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSCSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSCSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSCSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSCSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSCSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSCSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSCSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSCSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSCSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSCSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSCSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSCSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSCSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSCSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSCSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSCSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSCSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSCSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSCSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSCSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSCSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSCSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSCSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSCSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSCSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSCSR_P31 = 0x80000000

	// SCDR: Slow Clock Divider Debouncing Register
	// Position of DIV field.
	PIO_SCDR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	PIO_SCDR_DIV_Msk = 0x3fff

	// PPDDR: Pad Pull-down Disable Register
	// Position of P0 field.
	PIO_PPDDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PPDDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PPDDR_P0 = 0x1
	// Position of P1 field.
	PIO_PPDDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PPDDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PPDDR_P1 = 0x2
	// Position of P2 field.
	PIO_PPDDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PPDDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PPDDR_P2 = 0x4
	// Position of P3 field.
	PIO_PPDDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PPDDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PPDDR_P3 = 0x8
	// Position of P4 field.
	PIO_PPDDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PPDDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PPDDR_P4 = 0x10
	// Position of P5 field.
	PIO_PPDDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PPDDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PPDDR_P5 = 0x20
	// Position of P6 field.
	PIO_PPDDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PPDDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PPDDR_P6 = 0x40
	// Position of P7 field.
	PIO_PPDDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PPDDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PPDDR_P7 = 0x80
	// Position of P8 field.
	PIO_PPDDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PPDDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PPDDR_P8 = 0x100
	// Position of P9 field.
	PIO_PPDDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PPDDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PPDDR_P9 = 0x200
	// Position of P10 field.
	PIO_PPDDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PPDDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PPDDR_P10 = 0x400
	// Position of P11 field.
	PIO_PPDDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PPDDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PPDDR_P11 = 0x800
	// Position of P12 field.
	PIO_PPDDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PPDDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PPDDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PPDDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PPDDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PPDDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PPDDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PPDDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PPDDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PPDDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PPDDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PPDDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PPDDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PPDDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PPDDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PPDDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PPDDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PPDDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PPDDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PPDDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PPDDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PPDDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PPDDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PPDDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PPDDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PPDDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PPDDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PPDDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PPDDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PPDDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PPDDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PPDDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PPDDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PPDDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PPDDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PPDDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PPDDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PPDDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PPDDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PPDDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PPDDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PPDDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PPDDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PPDDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PPDDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PPDDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PPDDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PPDDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PPDDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PPDDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PPDDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PPDDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PPDDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PPDDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PPDDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PPDDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PPDDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PPDDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PPDDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PPDDR_P31 = 0x80000000

	// PPDER: Pad Pull-down Enable Register
	// Position of P0 field.
	PIO_PPDER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PPDER_P0_Msk = 0x1
	// Bit P0.
	PIO_PPDER_P0 = 0x1
	// Position of P1 field.
	PIO_PPDER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PPDER_P1_Msk = 0x2
	// Bit P1.
	PIO_PPDER_P1 = 0x2
	// Position of P2 field.
	PIO_PPDER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PPDER_P2_Msk = 0x4
	// Bit P2.
	PIO_PPDER_P2 = 0x4
	// Position of P3 field.
	PIO_PPDER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PPDER_P3_Msk = 0x8
	// Bit P3.
	PIO_PPDER_P3 = 0x8
	// Position of P4 field.
	PIO_PPDER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PPDER_P4_Msk = 0x10
	// Bit P4.
	PIO_PPDER_P4 = 0x10
	// Position of P5 field.
	PIO_PPDER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PPDER_P5_Msk = 0x20
	// Bit P5.
	PIO_PPDER_P5 = 0x20
	// Position of P6 field.
	PIO_PPDER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PPDER_P6_Msk = 0x40
	// Bit P6.
	PIO_PPDER_P6 = 0x40
	// Position of P7 field.
	PIO_PPDER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PPDER_P7_Msk = 0x80
	// Bit P7.
	PIO_PPDER_P7 = 0x80
	// Position of P8 field.
	PIO_PPDER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PPDER_P8_Msk = 0x100
	// Bit P8.
	PIO_PPDER_P8 = 0x100
	// Position of P9 field.
	PIO_PPDER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PPDER_P9_Msk = 0x200
	// Bit P9.
	PIO_PPDER_P9 = 0x200
	// Position of P10 field.
	PIO_PPDER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PPDER_P10_Msk = 0x400
	// Bit P10.
	PIO_PPDER_P10 = 0x400
	// Position of P11 field.
	PIO_PPDER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PPDER_P11_Msk = 0x800
	// Bit P11.
	PIO_PPDER_P11 = 0x800
	// Position of P12 field.
	PIO_PPDER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PPDER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PPDER_P12 = 0x1000
	// Position of P13 field.
	PIO_PPDER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PPDER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PPDER_P13 = 0x2000
	// Position of P14 field.
	PIO_PPDER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PPDER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PPDER_P14 = 0x4000
	// Position of P15 field.
	PIO_PPDER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PPDER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PPDER_P15 = 0x8000
	// Position of P16 field.
	PIO_PPDER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PPDER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PPDER_P16 = 0x10000
	// Position of P17 field.
	PIO_PPDER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PPDER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PPDER_P17 = 0x20000
	// Position of P18 field.
	PIO_PPDER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PPDER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PPDER_P18 = 0x40000
	// Position of P19 field.
	PIO_PPDER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PPDER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PPDER_P19 = 0x80000
	// Position of P20 field.
	PIO_PPDER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PPDER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PPDER_P20 = 0x100000
	// Position of P21 field.
	PIO_PPDER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PPDER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PPDER_P21 = 0x200000
	// Position of P22 field.
	PIO_PPDER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PPDER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PPDER_P22 = 0x400000
	// Position of P23 field.
	PIO_PPDER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PPDER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PPDER_P23 = 0x800000
	// Position of P24 field.
	PIO_PPDER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PPDER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PPDER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PPDER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PPDER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PPDER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PPDER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PPDER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PPDER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PPDER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PPDER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PPDER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PPDER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PPDER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PPDER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PPDER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PPDER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PPDER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PPDER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PPDER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PPDER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PPDER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PPDER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PPDER_P31 = 0x80000000

	// PPDSR: Pad Pull-down Status Register
	// Position of P0 field.
	PIO_PPDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PPDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PPDSR_P0 = 0x1
	// Position of P1 field.
	PIO_PPDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PPDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PPDSR_P1 = 0x2
	// Position of P2 field.
	PIO_PPDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PPDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PPDSR_P2 = 0x4
	// Position of P3 field.
	PIO_PPDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PPDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PPDSR_P3 = 0x8
	// Position of P4 field.
	PIO_PPDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PPDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PPDSR_P4 = 0x10
	// Position of P5 field.
	PIO_PPDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PPDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PPDSR_P5 = 0x20
	// Position of P6 field.
	PIO_PPDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PPDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PPDSR_P6 = 0x40
	// Position of P7 field.
	PIO_PPDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PPDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PPDSR_P7 = 0x80
	// Position of P8 field.
	PIO_PPDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PPDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PPDSR_P8 = 0x100
	// Position of P9 field.
	PIO_PPDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PPDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PPDSR_P9 = 0x200
	// Position of P10 field.
	PIO_PPDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PPDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PPDSR_P10 = 0x400
	// Position of P11 field.
	PIO_PPDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PPDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PPDSR_P11 = 0x800
	// Position of P12 field.
	PIO_PPDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PPDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PPDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PPDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PPDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PPDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PPDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PPDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PPDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PPDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PPDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PPDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PPDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PPDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PPDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PPDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PPDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PPDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PPDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PPDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PPDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PPDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PPDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PPDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PPDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PPDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PPDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PPDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PPDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PPDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PPDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PPDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PPDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PPDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PPDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PPDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PPDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PPDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PPDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PPDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PPDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PPDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PPDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PPDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PPDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PPDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PPDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PPDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PPDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PPDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PPDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PPDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PPDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PPDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PPDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PPDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PPDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PPDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PPDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PPDSR_P31 = 0x80000000

	// OWER: Output Write Enable
	// Position of P0 field.
	PIO_OWER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWER_P0_Msk = 0x1
	// Bit P0.
	PIO_OWER_P0 = 0x1
	// Position of P1 field.
	PIO_OWER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWER_P1_Msk = 0x2
	// Bit P1.
	PIO_OWER_P1 = 0x2
	// Position of P2 field.
	PIO_OWER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWER_P2_Msk = 0x4
	// Bit P2.
	PIO_OWER_P2 = 0x4
	// Position of P3 field.
	PIO_OWER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWER_P3_Msk = 0x8
	// Bit P3.
	PIO_OWER_P3 = 0x8
	// Position of P4 field.
	PIO_OWER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWER_P4_Msk = 0x10
	// Bit P4.
	PIO_OWER_P4 = 0x10
	// Position of P5 field.
	PIO_OWER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWER_P5_Msk = 0x20
	// Bit P5.
	PIO_OWER_P5 = 0x20
	// Position of P6 field.
	PIO_OWER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWER_P6_Msk = 0x40
	// Bit P6.
	PIO_OWER_P6 = 0x40
	// Position of P7 field.
	PIO_OWER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWER_P7_Msk = 0x80
	// Bit P7.
	PIO_OWER_P7 = 0x80
	// Position of P8 field.
	PIO_OWER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWER_P8_Msk = 0x100
	// Bit P8.
	PIO_OWER_P8 = 0x100
	// Position of P9 field.
	PIO_OWER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWER_P9_Msk = 0x200
	// Bit P9.
	PIO_OWER_P9 = 0x200
	// Position of P10 field.
	PIO_OWER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWER_P10_Msk = 0x400
	// Bit P10.
	PIO_OWER_P10 = 0x400
	// Position of P11 field.
	PIO_OWER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWER_P11_Msk = 0x800
	// Bit P11.
	PIO_OWER_P11 = 0x800
	// Position of P12 field.
	PIO_OWER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWER_P12 = 0x1000
	// Position of P13 field.
	PIO_OWER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWER_P13 = 0x2000
	// Position of P14 field.
	PIO_OWER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWER_P14 = 0x4000
	// Position of P15 field.
	PIO_OWER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWER_P15 = 0x8000
	// Position of P16 field.
	PIO_OWER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWER_P16 = 0x10000
	// Position of P17 field.
	PIO_OWER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWER_P17 = 0x20000
	// Position of P18 field.
	PIO_OWER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWER_P18 = 0x40000
	// Position of P19 field.
	PIO_OWER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWER_P19 = 0x80000
	// Position of P20 field.
	PIO_OWER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWER_P20 = 0x100000
	// Position of P21 field.
	PIO_OWER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWER_P21 = 0x200000
	// Position of P22 field.
	PIO_OWER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWER_P22 = 0x400000
	// Position of P23 field.
	PIO_OWER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWER_P23 = 0x800000
	// Position of P24 field.
	PIO_OWER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWER_P31 = 0x80000000

	// OWDR: Output Write Disable
	// Position of P0 field.
	PIO_OWDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWDR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWDR_P0 = 0x1
	// Position of P1 field.
	PIO_OWDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWDR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWDR_P1 = 0x2
	// Position of P2 field.
	PIO_OWDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWDR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWDR_P2 = 0x4
	// Position of P3 field.
	PIO_OWDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWDR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWDR_P3 = 0x8
	// Position of P4 field.
	PIO_OWDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWDR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWDR_P4 = 0x10
	// Position of P5 field.
	PIO_OWDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWDR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWDR_P5 = 0x20
	// Position of P6 field.
	PIO_OWDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWDR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWDR_P6 = 0x40
	// Position of P7 field.
	PIO_OWDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWDR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWDR_P7 = 0x80
	// Position of P8 field.
	PIO_OWDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWDR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWDR_P8 = 0x100
	// Position of P9 field.
	PIO_OWDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWDR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWDR_P9 = 0x200
	// Position of P10 field.
	PIO_OWDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWDR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWDR_P10 = 0x400
	// Position of P11 field.
	PIO_OWDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWDR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWDR_P11 = 0x800
	// Position of P12 field.
	PIO_OWDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWDR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWDR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWDR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWDR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWDR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWDR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWDR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWDR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWDR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWDR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWDR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWDR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWDR_P31 = 0x80000000

	// OWSR: Output Write Status Register
	// Position of P0 field.
	PIO_OWSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWSR_P0 = 0x1
	// Position of P1 field.
	PIO_OWSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWSR_P1 = 0x2
	// Position of P2 field.
	PIO_OWSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWSR_P2 = 0x4
	// Position of P3 field.
	PIO_OWSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWSR_P3 = 0x8
	// Position of P4 field.
	PIO_OWSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWSR_P4 = 0x10
	// Position of P5 field.
	PIO_OWSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWSR_P5 = 0x20
	// Position of P6 field.
	PIO_OWSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWSR_P6 = 0x40
	// Position of P7 field.
	PIO_OWSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWSR_P7 = 0x80
	// Position of P8 field.
	PIO_OWSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWSR_P8 = 0x100
	// Position of P9 field.
	PIO_OWSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWSR_P9 = 0x200
	// Position of P10 field.
	PIO_OWSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWSR_P10 = 0x400
	// Position of P11 field.
	PIO_OWSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWSR_P11 = 0x800
	// Position of P12 field.
	PIO_OWSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWSR_P31 = 0x80000000

	// AIMER: Additional Interrupt Modes Enable Register
	// Position of P0 field.
	PIO_AIMER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMER_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMER_P0 = 0x1
	// Position of P1 field.
	PIO_AIMER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMER_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMER_P1 = 0x2
	// Position of P2 field.
	PIO_AIMER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMER_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMER_P2 = 0x4
	// Position of P3 field.
	PIO_AIMER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMER_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMER_P3 = 0x8
	// Position of P4 field.
	PIO_AIMER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMER_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMER_P4 = 0x10
	// Position of P5 field.
	PIO_AIMER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMER_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMER_P5 = 0x20
	// Position of P6 field.
	PIO_AIMER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMER_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMER_P6 = 0x40
	// Position of P7 field.
	PIO_AIMER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMER_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMER_P7 = 0x80
	// Position of P8 field.
	PIO_AIMER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMER_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMER_P8 = 0x100
	// Position of P9 field.
	PIO_AIMER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMER_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMER_P9 = 0x200
	// Position of P10 field.
	PIO_AIMER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMER_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMER_P10 = 0x400
	// Position of P11 field.
	PIO_AIMER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMER_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMER_P11 = 0x800
	// Position of P12 field.
	PIO_AIMER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMER_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMER_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMER_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMER_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMER_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMER_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMER_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMER_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMER_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMER_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMER_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMER_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMER_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMER_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMER_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMER_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMER_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMER_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMER_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMER_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMER_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMER_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMER_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMER_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMER_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMER_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMER_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMER_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMER_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMER_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMER_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMER_P31 = 0x80000000

	// AIMDR: Additional Interrupt Modes Disables Register
	// Position of P0 field.
	PIO_AIMDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMDR_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMDR_P0 = 0x1
	// Position of P1 field.
	PIO_AIMDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMDR_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMDR_P1 = 0x2
	// Position of P2 field.
	PIO_AIMDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMDR_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMDR_P2 = 0x4
	// Position of P3 field.
	PIO_AIMDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMDR_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMDR_P3 = 0x8
	// Position of P4 field.
	PIO_AIMDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMDR_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMDR_P4 = 0x10
	// Position of P5 field.
	PIO_AIMDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMDR_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMDR_P5 = 0x20
	// Position of P6 field.
	PIO_AIMDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMDR_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMDR_P6 = 0x40
	// Position of P7 field.
	PIO_AIMDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMDR_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMDR_P7 = 0x80
	// Position of P8 field.
	PIO_AIMDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMDR_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMDR_P8 = 0x100
	// Position of P9 field.
	PIO_AIMDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMDR_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMDR_P9 = 0x200
	// Position of P10 field.
	PIO_AIMDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMDR_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMDR_P10 = 0x400
	// Position of P11 field.
	PIO_AIMDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMDR_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMDR_P11 = 0x800
	// Position of P12 field.
	PIO_AIMDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMDR_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMDR_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMDR_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMDR_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMDR_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMDR_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMDR_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMDR_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMDR_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMDR_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMDR_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMDR_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMDR_P31 = 0x80000000

	// AIMMR: Additional Interrupt Modes Mask Register
	// Position of P0 field.
	PIO_AIMMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMMR_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMMR_P0 = 0x1
	// Position of P1 field.
	PIO_AIMMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMMR_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMMR_P1 = 0x2
	// Position of P2 field.
	PIO_AIMMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMMR_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMMR_P2 = 0x4
	// Position of P3 field.
	PIO_AIMMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMMR_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMMR_P3 = 0x8
	// Position of P4 field.
	PIO_AIMMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMMR_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMMR_P4 = 0x10
	// Position of P5 field.
	PIO_AIMMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMMR_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMMR_P5 = 0x20
	// Position of P6 field.
	PIO_AIMMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMMR_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMMR_P6 = 0x40
	// Position of P7 field.
	PIO_AIMMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMMR_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMMR_P7 = 0x80
	// Position of P8 field.
	PIO_AIMMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMMR_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMMR_P8 = 0x100
	// Position of P9 field.
	PIO_AIMMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMMR_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMMR_P9 = 0x200
	// Position of P10 field.
	PIO_AIMMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMMR_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMMR_P10 = 0x400
	// Position of P11 field.
	PIO_AIMMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMMR_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMMR_P11 = 0x800
	// Position of P12 field.
	PIO_AIMMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMMR_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMMR_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMMR_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMMR_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMMR_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMMR_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMMR_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMMR_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMMR_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMMR_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMMR_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMMR_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMMR_P31 = 0x80000000

	// ESR: Edge Select Register
	// Position of P0 field.
	PIO_ESR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ESR_P0_Msk = 0x1
	// Bit P0.
	PIO_ESR_P0 = 0x1
	// Position of P1 field.
	PIO_ESR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ESR_P1_Msk = 0x2
	// Bit P1.
	PIO_ESR_P1 = 0x2
	// Position of P2 field.
	PIO_ESR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ESR_P2_Msk = 0x4
	// Bit P2.
	PIO_ESR_P2 = 0x4
	// Position of P3 field.
	PIO_ESR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ESR_P3_Msk = 0x8
	// Bit P3.
	PIO_ESR_P3 = 0x8
	// Position of P4 field.
	PIO_ESR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ESR_P4_Msk = 0x10
	// Bit P4.
	PIO_ESR_P4 = 0x10
	// Position of P5 field.
	PIO_ESR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ESR_P5_Msk = 0x20
	// Bit P5.
	PIO_ESR_P5 = 0x20
	// Position of P6 field.
	PIO_ESR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ESR_P6_Msk = 0x40
	// Bit P6.
	PIO_ESR_P6 = 0x40
	// Position of P7 field.
	PIO_ESR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ESR_P7_Msk = 0x80
	// Bit P7.
	PIO_ESR_P7 = 0x80
	// Position of P8 field.
	PIO_ESR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ESR_P8_Msk = 0x100
	// Bit P8.
	PIO_ESR_P8 = 0x100
	// Position of P9 field.
	PIO_ESR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ESR_P9_Msk = 0x200
	// Bit P9.
	PIO_ESR_P9 = 0x200
	// Position of P10 field.
	PIO_ESR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ESR_P10_Msk = 0x400
	// Bit P10.
	PIO_ESR_P10 = 0x400
	// Position of P11 field.
	PIO_ESR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ESR_P11_Msk = 0x800
	// Bit P11.
	PIO_ESR_P11 = 0x800
	// Position of P12 field.
	PIO_ESR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ESR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ESR_P12 = 0x1000
	// Position of P13 field.
	PIO_ESR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ESR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ESR_P13 = 0x2000
	// Position of P14 field.
	PIO_ESR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ESR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ESR_P14 = 0x4000
	// Position of P15 field.
	PIO_ESR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ESR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ESR_P15 = 0x8000
	// Position of P16 field.
	PIO_ESR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ESR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ESR_P16 = 0x10000
	// Position of P17 field.
	PIO_ESR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ESR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ESR_P17 = 0x20000
	// Position of P18 field.
	PIO_ESR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ESR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ESR_P18 = 0x40000
	// Position of P19 field.
	PIO_ESR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ESR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ESR_P19 = 0x80000
	// Position of P20 field.
	PIO_ESR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ESR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ESR_P20 = 0x100000
	// Position of P21 field.
	PIO_ESR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ESR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ESR_P21 = 0x200000
	// Position of P22 field.
	PIO_ESR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ESR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ESR_P22 = 0x400000
	// Position of P23 field.
	PIO_ESR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ESR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ESR_P23 = 0x800000
	// Position of P24 field.
	PIO_ESR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ESR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ESR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ESR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ESR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ESR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ESR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ESR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ESR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ESR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ESR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ESR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ESR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ESR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ESR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ESR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ESR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ESR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ESR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ESR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ESR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ESR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ESR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ESR_P31 = 0x80000000

	// LSR: Level Select Register
	// Position of P0 field.
	PIO_LSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_LSR_P0_Msk = 0x1
	// Bit P0.
	PIO_LSR_P0 = 0x1
	// Position of P1 field.
	PIO_LSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_LSR_P1_Msk = 0x2
	// Bit P1.
	PIO_LSR_P1 = 0x2
	// Position of P2 field.
	PIO_LSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_LSR_P2_Msk = 0x4
	// Bit P2.
	PIO_LSR_P2 = 0x4
	// Position of P3 field.
	PIO_LSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_LSR_P3_Msk = 0x8
	// Bit P3.
	PIO_LSR_P3 = 0x8
	// Position of P4 field.
	PIO_LSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_LSR_P4_Msk = 0x10
	// Bit P4.
	PIO_LSR_P4 = 0x10
	// Position of P5 field.
	PIO_LSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_LSR_P5_Msk = 0x20
	// Bit P5.
	PIO_LSR_P5 = 0x20
	// Position of P6 field.
	PIO_LSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_LSR_P6_Msk = 0x40
	// Bit P6.
	PIO_LSR_P6 = 0x40
	// Position of P7 field.
	PIO_LSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_LSR_P7_Msk = 0x80
	// Bit P7.
	PIO_LSR_P7 = 0x80
	// Position of P8 field.
	PIO_LSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_LSR_P8_Msk = 0x100
	// Bit P8.
	PIO_LSR_P8 = 0x100
	// Position of P9 field.
	PIO_LSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_LSR_P9_Msk = 0x200
	// Bit P9.
	PIO_LSR_P9 = 0x200
	// Position of P10 field.
	PIO_LSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_LSR_P10_Msk = 0x400
	// Bit P10.
	PIO_LSR_P10 = 0x400
	// Position of P11 field.
	PIO_LSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_LSR_P11_Msk = 0x800
	// Bit P11.
	PIO_LSR_P11 = 0x800
	// Position of P12 field.
	PIO_LSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_LSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_LSR_P12 = 0x1000
	// Position of P13 field.
	PIO_LSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_LSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_LSR_P13 = 0x2000
	// Position of P14 field.
	PIO_LSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_LSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_LSR_P14 = 0x4000
	// Position of P15 field.
	PIO_LSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_LSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_LSR_P15 = 0x8000
	// Position of P16 field.
	PIO_LSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_LSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_LSR_P16 = 0x10000
	// Position of P17 field.
	PIO_LSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_LSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_LSR_P17 = 0x20000
	// Position of P18 field.
	PIO_LSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_LSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_LSR_P18 = 0x40000
	// Position of P19 field.
	PIO_LSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_LSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_LSR_P19 = 0x80000
	// Position of P20 field.
	PIO_LSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_LSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_LSR_P20 = 0x100000
	// Position of P21 field.
	PIO_LSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_LSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_LSR_P21 = 0x200000
	// Position of P22 field.
	PIO_LSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_LSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_LSR_P22 = 0x400000
	// Position of P23 field.
	PIO_LSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_LSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_LSR_P23 = 0x800000
	// Position of P24 field.
	PIO_LSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_LSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_LSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_LSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_LSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_LSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_LSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_LSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_LSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_LSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_LSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_LSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_LSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_LSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_LSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_LSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_LSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_LSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_LSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_LSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_LSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_LSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_LSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_LSR_P31 = 0x80000000

	// ELSR: Edge/Level Status Register
	// Position of P0 field.
	PIO_ELSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ELSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ELSR_P0 = 0x1
	// Position of P1 field.
	PIO_ELSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ELSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ELSR_P1 = 0x2
	// Position of P2 field.
	PIO_ELSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ELSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ELSR_P2 = 0x4
	// Position of P3 field.
	PIO_ELSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ELSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ELSR_P3 = 0x8
	// Position of P4 field.
	PIO_ELSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ELSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ELSR_P4 = 0x10
	// Position of P5 field.
	PIO_ELSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ELSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ELSR_P5 = 0x20
	// Position of P6 field.
	PIO_ELSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ELSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ELSR_P6 = 0x40
	// Position of P7 field.
	PIO_ELSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ELSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ELSR_P7 = 0x80
	// Position of P8 field.
	PIO_ELSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ELSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ELSR_P8 = 0x100
	// Position of P9 field.
	PIO_ELSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ELSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ELSR_P9 = 0x200
	// Position of P10 field.
	PIO_ELSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ELSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ELSR_P10 = 0x400
	// Position of P11 field.
	PIO_ELSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ELSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ELSR_P11 = 0x800
	// Position of P12 field.
	PIO_ELSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ELSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ELSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ELSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ELSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ELSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ELSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ELSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ELSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ELSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ELSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ELSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ELSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ELSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ELSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ELSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ELSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ELSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ELSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ELSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ELSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ELSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ELSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ELSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ELSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ELSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ELSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ELSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ELSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ELSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ELSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ELSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ELSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ELSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ELSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ELSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ELSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ELSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ELSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ELSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ELSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ELSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ELSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ELSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ELSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ELSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ELSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ELSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ELSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ELSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ELSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ELSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ELSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ELSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ELSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ELSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ELSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ELSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ELSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ELSR_P31 = 0x80000000

	// FELLSR: Falling Edge/Low Level Select Register
	// Position of P0 field.
	PIO_FELLSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_FELLSR_P0_Msk = 0x1
	// Bit P0.
	PIO_FELLSR_P0 = 0x1
	// Position of P1 field.
	PIO_FELLSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_FELLSR_P1_Msk = 0x2
	// Bit P1.
	PIO_FELLSR_P1 = 0x2
	// Position of P2 field.
	PIO_FELLSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_FELLSR_P2_Msk = 0x4
	// Bit P2.
	PIO_FELLSR_P2 = 0x4
	// Position of P3 field.
	PIO_FELLSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_FELLSR_P3_Msk = 0x8
	// Bit P3.
	PIO_FELLSR_P3 = 0x8
	// Position of P4 field.
	PIO_FELLSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_FELLSR_P4_Msk = 0x10
	// Bit P4.
	PIO_FELLSR_P4 = 0x10
	// Position of P5 field.
	PIO_FELLSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_FELLSR_P5_Msk = 0x20
	// Bit P5.
	PIO_FELLSR_P5 = 0x20
	// Position of P6 field.
	PIO_FELLSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_FELLSR_P6_Msk = 0x40
	// Bit P6.
	PIO_FELLSR_P6 = 0x40
	// Position of P7 field.
	PIO_FELLSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_FELLSR_P7_Msk = 0x80
	// Bit P7.
	PIO_FELLSR_P7 = 0x80
	// Position of P8 field.
	PIO_FELLSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_FELLSR_P8_Msk = 0x100
	// Bit P8.
	PIO_FELLSR_P8 = 0x100
	// Position of P9 field.
	PIO_FELLSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_FELLSR_P9_Msk = 0x200
	// Bit P9.
	PIO_FELLSR_P9 = 0x200
	// Position of P10 field.
	PIO_FELLSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_FELLSR_P10_Msk = 0x400
	// Bit P10.
	PIO_FELLSR_P10 = 0x400
	// Position of P11 field.
	PIO_FELLSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_FELLSR_P11_Msk = 0x800
	// Bit P11.
	PIO_FELLSR_P11 = 0x800
	// Position of P12 field.
	PIO_FELLSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_FELLSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_FELLSR_P12 = 0x1000
	// Position of P13 field.
	PIO_FELLSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_FELLSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_FELLSR_P13 = 0x2000
	// Position of P14 field.
	PIO_FELLSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_FELLSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_FELLSR_P14 = 0x4000
	// Position of P15 field.
	PIO_FELLSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_FELLSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_FELLSR_P15 = 0x8000
	// Position of P16 field.
	PIO_FELLSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_FELLSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_FELLSR_P16 = 0x10000
	// Position of P17 field.
	PIO_FELLSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_FELLSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_FELLSR_P17 = 0x20000
	// Position of P18 field.
	PIO_FELLSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_FELLSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_FELLSR_P18 = 0x40000
	// Position of P19 field.
	PIO_FELLSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_FELLSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_FELLSR_P19 = 0x80000
	// Position of P20 field.
	PIO_FELLSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_FELLSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_FELLSR_P20 = 0x100000
	// Position of P21 field.
	PIO_FELLSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_FELLSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_FELLSR_P21 = 0x200000
	// Position of P22 field.
	PIO_FELLSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_FELLSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_FELLSR_P22 = 0x400000
	// Position of P23 field.
	PIO_FELLSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_FELLSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_FELLSR_P23 = 0x800000
	// Position of P24 field.
	PIO_FELLSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_FELLSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_FELLSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_FELLSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_FELLSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_FELLSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_FELLSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_FELLSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_FELLSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_FELLSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_FELLSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_FELLSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_FELLSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_FELLSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_FELLSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_FELLSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_FELLSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_FELLSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_FELLSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_FELLSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_FELLSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_FELLSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_FELLSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_FELLSR_P31 = 0x80000000

	// REHLSR: Rising Edge/ High Level Select Register
	// Position of P0 field.
	PIO_REHLSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_REHLSR_P0_Msk = 0x1
	// Bit P0.
	PIO_REHLSR_P0 = 0x1
	// Position of P1 field.
	PIO_REHLSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_REHLSR_P1_Msk = 0x2
	// Bit P1.
	PIO_REHLSR_P1 = 0x2
	// Position of P2 field.
	PIO_REHLSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_REHLSR_P2_Msk = 0x4
	// Bit P2.
	PIO_REHLSR_P2 = 0x4
	// Position of P3 field.
	PIO_REHLSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_REHLSR_P3_Msk = 0x8
	// Bit P3.
	PIO_REHLSR_P3 = 0x8
	// Position of P4 field.
	PIO_REHLSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_REHLSR_P4_Msk = 0x10
	// Bit P4.
	PIO_REHLSR_P4 = 0x10
	// Position of P5 field.
	PIO_REHLSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_REHLSR_P5_Msk = 0x20
	// Bit P5.
	PIO_REHLSR_P5 = 0x20
	// Position of P6 field.
	PIO_REHLSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_REHLSR_P6_Msk = 0x40
	// Bit P6.
	PIO_REHLSR_P6 = 0x40
	// Position of P7 field.
	PIO_REHLSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_REHLSR_P7_Msk = 0x80
	// Bit P7.
	PIO_REHLSR_P7 = 0x80
	// Position of P8 field.
	PIO_REHLSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_REHLSR_P8_Msk = 0x100
	// Bit P8.
	PIO_REHLSR_P8 = 0x100
	// Position of P9 field.
	PIO_REHLSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_REHLSR_P9_Msk = 0x200
	// Bit P9.
	PIO_REHLSR_P9 = 0x200
	// Position of P10 field.
	PIO_REHLSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_REHLSR_P10_Msk = 0x400
	// Bit P10.
	PIO_REHLSR_P10 = 0x400
	// Position of P11 field.
	PIO_REHLSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_REHLSR_P11_Msk = 0x800
	// Bit P11.
	PIO_REHLSR_P11 = 0x800
	// Position of P12 field.
	PIO_REHLSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_REHLSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_REHLSR_P12 = 0x1000
	// Position of P13 field.
	PIO_REHLSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_REHLSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_REHLSR_P13 = 0x2000
	// Position of P14 field.
	PIO_REHLSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_REHLSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_REHLSR_P14 = 0x4000
	// Position of P15 field.
	PIO_REHLSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_REHLSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_REHLSR_P15 = 0x8000
	// Position of P16 field.
	PIO_REHLSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_REHLSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_REHLSR_P16 = 0x10000
	// Position of P17 field.
	PIO_REHLSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_REHLSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_REHLSR_P17 = 0x20000
	// Position of P18 field.
	PIO_REHLSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_REHLSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_REHLSR_P18 = 0x40000
	// Position of P19 field.
	PIO_REHLSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_REHLSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_REHLSR_P19 = 0x80000
	// Position of P20 field.
	PIO_REHLSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_REHLSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_REHLSR_P20 = 0x100000
	// Position of P21 field.
	PIO_REHLSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_REHLSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_REHLSR_P21 = 0x200000
	// Position of P22 field.
	PIO_REHLSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_REHLSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_REHLSR_P22 = 0x400000
	// Position of P23 field.
	PIO_REHLSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_REHLSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_REHLSR_P23 = 0x800000
	// Position of P24 field.
	PIO_REHLSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_REHLSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_REHLSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_REHLSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_REHLSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_REHLSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_REHLSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_REHLSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_REHLSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_REHLSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_REHLSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_REHLSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_REHLSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_REHLSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_REHLSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_REHLSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_REHLSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_REHLSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_REHLSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_REHLSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_REHLSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_REHLSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_REHLSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_REHLSR_P31 = 0x80000000

	// FRLHSR: Fall/Rise - Low/High Status Register
	// Position of P0 field.
	PIO_FRLHSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_FRLHSR_P0_Msk = 0x1
	// Bit P0.
	PIO_FRLHSR_P0 = 0x1
	// Position of P1 field.
	PIO_FRLHSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_FRLHSR_P1_Msk = 0x2
	// Bit P1.
	PIO_FRLHSR_P1 = 0x2
	// Position of P2 field.
	PIO_FRLHSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_FRLHSR_P2_Msk = 0x4
	// Bit P2.
	PIO_FRLHSR_P2 = 0x4
	// Position of P3 field.
	PIO_FRLHSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_FRLHSR_P3_Msk = 0x8
	// Bit P3.
	PIO_FRLHSR_P3 = 0x8
	// Position of P4 field.
	PIO_FRLHSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_FRLHSR_P4_Msk = 0x10
	// Bit P4.
	PIO_FRLHSR_P4 = 0x10
	// Position of P5 field.
	PIO_FRLHSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_FRLHSR_P5_Msk = 0x20
	// Bit P5.
	PIO_FRLHSR_P5 = 0x20
	// Position of P6 field.
	PIO_FRLHSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_FRLHSR_P6_Msk = 0x40
	// Bit P6.
	PIO_FRLHSR_P6 = 0x40
	// Position of P7 field.
	PIO_FRLHSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_FRLHSR_P7_Msk = 0x80
	// Bit P7.
	PIO_FRLHSR_P7 = 0x80
	// Position of P8 field.
	PIO_FRLHSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_FRLHSR_P8_Msk = 0x100
	// Bit P8.
	PIO_FRLHSR_P8 = 0x100
	// Position of P9 field.
	PIO_FRLHSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_FRLHSR_P9_Msk = 0x200
	// Bit P9.
	PIO_FRLHSR_P9 = 0x200
	// Position of P10 field.
	PIO_FRLHSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_FRLHSR_P10_Msk = 0x400
	// Bit P10.
	PIO_FRLHSR_P10 = 0x400
	// Position of P11 field.
	PIO_FRLHSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_FRLHSR_P11_Msk = 0x800
	// Bit P11.
	PIO_FRLHSR_P11 = 0x800
	// Position of P12 field.
	PIO_FRLHSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_FRLHSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_FRLHSR_P12 = 0x1000
	// Position of P13 field.
	PIO_FRLHSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_FRLHSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_FRLHSR_P13 = 0x2000
	// Position of P14 field.
	PIO_FRLHSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_FRLHSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_FRLHSR_P14 = 0x4000
	// Position of P15 field.
	PIO_FRLHSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_FRLHSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_FRLHSR_P15 = 0x8000
	// Position of P16 field.
	PIO_FRLHSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_FRLHSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_FRLHSR_P16 = 0x10000
	// Position of P17 field.
	PIO_FRLHSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_FRLHSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_FRLHSR_P17 = 0x20000
	// Position of P18 field.
	PIO_FRLHSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_FRLHSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_FRLHSR_P18 = 0x40000
	// Position of P19 field.
	PIO_FRLHSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_FRLHSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_FRLHSR_P19 = 0x80000
	// Position of P20 field.
	PIO_FRLHSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_FRLHSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_FRLHSR_P20 = 0x100000
	// Position of P21 field.
	PIO_FRLHSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_FRLHSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_FRLHSR_P21 = 0x200000
	// Position of P22 field.
	PIO_FRLHSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_FRLHSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_FRLHSR_P22 = 0x400000
	// Position of P23 field.
	PIO_FRLHSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_FRLHSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_FRLHSR_P23 = 0x800000
	// Position of P24 field.
	PIO_FRLHSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_FRLHSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_FRLHSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_FRLHSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_FRLHSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_FRLHSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_FRLHSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_FRLHSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_FRLHSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_FRLHSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_FRLHSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_FRLHSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_FRLHSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_FRLHSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_FRLHSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_FRLHSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_FRLHSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_FRLHSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_FRLHSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_FRLHSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_FRLHSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_FRLHSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_FRLHSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_FRLHSR_P31 = 0x80000000

	// LOCKSR: Lock Status
	// Position of P0 field.
	PIO_LOCKSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_LOCKSR_P0_Msk = 0x1
	// Bit P0.
	PIO_LOCKSR_P0 = 0x1
	// Position of P1 field.
	PIO_LOCKSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_LOCKSR_P1_Msk = 0x2
	// Bit P1.
	PIO_LOCKSR_P1 = 0x2
	// Position of P2 field.
	PIO_LOCKSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_LOCKSR_P2_Msk = 0x4
	// Bit P2.
	PIO_LOCKSR_P2 = 0x4
	// Position of P3 field.
	PIO_LOCKSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_LOCKSR_P3_Msk = 0x8
	// Bit P3.
	PIO_LOCKSR_P3 = 0x8
	// Position of P4 field.
	PIO_LOCKSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_LOCKSR_P4_Msk = 0x10
	// Bit P4.
	PIO_LOCKSR_P4 = 0x10
	// Position of P5 field.
	PIO_LOCKSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_LOCKSR_P5_Msk = 0x20
	// Bit P5.
	PIO_LOCKSR_P5 = 0x20
	// Position of P6 field.
	PIO_LOCKSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_LOCKSR_P6_Msk = 0x40
	// Bit P6.
	PIO_LOCKSR_P6 = 0x40
	// Position of P7 field.
	PIO_LOCKSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_LOCKSR_P7_Msk = 0x80
	// Bit P7.
	PIO_LOCKSR_P7 = 0x80
	// Position of P8 field.
	PIO_LOCKSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_LOCKSR_P8_Msk = 0x100
	// Bit P8.
	PIO_LOCKSR_P8 = 0x100
	// Position of P9 field.
	PIO_LOCKSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_LOCKSR_P9_Msk = 0x200
	// Bit P9.
	PIO_LOCKSR_P9 = 0x200
	// Position of P10 field.
	PIO_LOCKSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_LOCKSR_P10_Msk = 0x400
	// Bit P10.
	PIO_LOCKSR_P10 = 0x400
	// Position of P11 field.
	PIO_LOCKSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_LOCKSR_P11_Msk = 0x800
	// Bit P11.
	PIO_LOCKSR_P11 = 0x800
	// Position of P12 field.
	PIO_LOCKSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_LOCKSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_LOCKSR_P12 = 0x1000
	// Position of P13 field.
	PIO_LOCKSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_LOCKSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_LOCKSR_P13 = 0x2000
	// Position of P14 field.
	PIO_LOCKSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_LOCKSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_LOCKSR_P14 = 0x4000
	// Position of P15 field.
	PIO_LOCKSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_LOCKSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_LOCKSR_P15 = 0x8000
	// Position of P16 field.
	PIO_LOCKSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_LOCKSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_LOCKSR_P16 = 0x10000
	// Position of P17 field.
	PIO_LOCKSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_LOCKSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_LOCKSR_P17 = 0x20000
	// Position of P18 field.
	PIO_LOCKSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_LOCKSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_LOCKSR_P18 = 0x40000
	// Position of P19 field.
	PIO_LOCKSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_LOCKSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_LOCKSR_P19 = 0x80000
	// Position of P20 field.
	PIO_LOCKSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_LOCKSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_LOCKSR_P20 = 0x100000
	// Position of P21 field.
	PIO_LOCKSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_LOCKSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_LOCKSR_P21 = 0x200000
	// Position of P22 field.
	PIO_LOCKSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_LOCKSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_LOCKSR_P22 = 0x400000
	// Position of P23 field.
	PIO_LOCKSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_LOCKSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_LOCKSR_P23 = 0x800000
	// Position of P24 field.
	PIO_LOCKSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_LOCKSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_LOCKSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_LOCKSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_LOCKSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_LOCKSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_LOCKSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_LOCKSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_LOCKSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_LOCKSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_LOCKSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_LOCKSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_LOCKSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_LOCKSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_LOCKSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_LOCKSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_LOCKSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_LOCKSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_LOCKSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_LOCKSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_LOCKSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_LOCKSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_LOCKSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_LOCKSR_P31 = 0x80000000

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	PIO_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	PIO_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	PIO_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	PIO_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PIO_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	PIO_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	PIO_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	PIO_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	PIO_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	PIO_WPSR_WPVSRC_Msk = 0xffff00

	// SCHMITT: Schmitt Trigger Register
	// Position of SCHMITT0 field.
	PIO_SCHMITT_SCHMITT0_Pos = 0x0
	// Bit mask of SCHMITT0 field.
	PIO_SCHMITT_SCHMITT0_Msk = 0x1
	// Bit SCHMITT0.
	PIO_SCHMITT_SCHMITT0 = 0x1
	// Position of SCHMITT1 field.
	PIO_SCHMITT_SCHMITT1_Pos = 0x1
	// Bit mask of SCHMITT1 field.
	PIO_SCHMITT_SCHMITT1_Msk = 0x2
	// Bit SCHMITT1.
	PIO_SCHMITT_SCHMITT1 = 0x2
	// Position of SCHMITT2 field.
	PIO_SCHMITT_SCHMITT2_Pos = 0x2
	// Bit mask of SCHMITT2 field.
	PIO_SCHMITT_SCHMITT2_Msk = 0x4
	// Bit SCHMITT2.
	PIO_SCHMITT_SCHMITT2 = 0x4
	// Position of SCHMITT3 field.
	PIO_SCHMITT_SCHMITT3_Pos = 0x3
	// Bit mask of SCHMITT3 field.
	PIO_SCHMITT_SCHMITT3_Msk = 0x8
	// Bit SCHMITT3.
	PIO_SCHMITT_SCHMITT3 = 0x8
	// Position of SCHMITT4 field.
	PIO_SCHMITT_SCHMITT4_Pos = 0x4
	// Bit mask of SCHMITT4 field.
	PIO_SCHMITT_SCHMITT4_Msk = 0x10
	// Bit SCHMITT4.
	PIO_SCHMITT_SCHMITT4 = 0x10
	// Position of SCHMITT5 field.
	PIO_SCHMITT_SCHMITT5_Pos = 0x5
	// Bit mask of SCHMITT5 field.
	PIO_SCHMITT_SCHMITT5_Msk = 0x20
	// Bit SCHMITT5.
	PIO_SCHMITT_SCHMITT5 = 0x20
	// Position of SCHMITT6 field.
	PIO_SCHMITT_SCHMITT6_Pos = 0x6
	// Bit mask of SCHMITT6 field.
	PIO_SCHMITT_SCHMITT6_Msk = 0x40
	// Bit SCHMITT6.
	PIO_SCHMITT_SCHMITT6 = 0x40
	// Position of SCHMITT7 field.
	PIO_SCHMITT_SCHMITT7_Pos = 0x7
	// Bit mask of SCHMITT7 field.
	PIO_SCHMITT_SCHMITT7_Msk = 0x80
	// Bit SCHMITT7.
	PIO_SCHMITT_SCHMITT7 = 0x80
	// Position of SCHMITT8 field.
	PIO_SCHMITT_SCHMITT8_Pos = 0x8
	// Bit mask of SCHMITT8 field.
	PIO_SCHMITT_SCHMITT8_Msk = 0x100
	// Bit SCHMITT8.
	PIO_SCHMITT_SCHMITT8 = 0x100
	// Position of SCHMITT9 field.
	PIO_SCHMITT_SCHMITT9_Pos = 0x9
	// Bit mask of SCHMITT9 field.
	PIO_SCHMITT_SCHMITT9_Msk = 0x200
	// Bit SCHMITT9.
	PIO_SCHMITT_SCHMITT9 = 0x200
	// Position of SCHMITT10 field.
	PIO_SCHMITT_SCHMITT10_Pos = 0xa
	// Bit mask of SCHMITT10 field.
	PIO_SCHMITT_SCHMITT10_Msk = 0x400
	// Bit SCHMITT10.
	PIO_SCHMITT_SCHMITT10 = 0x400
	// Position of SCHMITT11 field.
	PIO_SCHMITT_SCHMITT11_Pos = 0xb
	// Bit mask of SCHMITT11 field.
	PIO_SCHMITT_SCHMITT11_Msk = 0x800
	// Bit SCHMITT11.
	PIO_SCHMITT_SCHMITT11 = 0x800
	// Position of SCHMITT12 field.
	PIO_SCHMITT_SCHMITT12_Pos = 0xc
	// Bit mask of SCHMITT12 field.
	PIO_SCHMITT_SCHMITT12_Msk = 0x1000
	// Bit SCHMITT12.
	PIO_SCHMITT_SCHMITT12 = 0x1000
	// Position of SCHMITT13 field.
	PIO_SCHMITT_SCHMITT13_Pos = 0xd
	// Bit mask of SCHMITT13 field.
	PIO_SCHMITT_SCHMITT13_Msk = 0x2000
	// Bit SCHMITT13.
	PIO_SCHMITT_SCHMITT13 = 0x2000
	// Position of SCHMITT14 field.
	PIO_SCHMITT_SCHMITT14_Pos = 0xe
	// Bit mask of SCHMITT14 field.
	PIO_SCHMITT_SCHMITT14_Msk = 0x4000
	// Bit SCHMITT14.
	PIO_SCHMITT_SCHMITT14 = 0x4000
	// Position of SCHMITT15 field.
	PIO_SCHMITT_SCHMITT15_Pos = 0xf
	// Bit mask of SCHMITT15 field.
	PIO_SCHMITT_SCHMITT15_Msk = 0x8000
	// Bit SCHMITT15.
	PIO_SCHMITT_SCHMITT15 = 0x8000
	// Position of SCHMITT16 field.
	PIO_SCHMITT_SCHMITT16_Pos = 0x10
	// Bit mask of SCHMITT16 field.
	PIO_SCHMITT_SCHMITT16_Msk = 0x10000
	// Bit SCHMITT16.
	PIO_SCHMITT_SCHMITT16 = 0x10000
	// Position of SCHMITT17 field.
	PIO_SCHMITT_SCHMITT17_Pos = 0x11
	// Bit mask of SCHMITT17 field.
	PIO_SCHMITT_SCHMITT17_Msk = 0x20000
	// Bit SCHMITT17.
	PIO_SCHMITT_SCHMITT17 = 0x20000
	// Position of SCHMITT18 field.
	PIO_SCHMITT_SCHMITT18_Pos = 0x12
	// Bit mask of SCHMITT18 field.
	PIO_SCHMITT_SCHMITT18_Msk = 0x40000
	// Bit SCHMITT18.
	PIO_SCHMITT_SCHMITT18 = 0x40000
	// Position of SCHMITT19 field.
	PIO_SCHMITT_SCHMITT19_Pos = 0x13
	// Bit mask of SCHMITT19 field.
	PIO_SCHMITT_SCHMITT19_Msk = 0x80000
	// Bit SCHMITT19.
	PIO_SCHMITT_SCHMITT19 = 0x80000
	// Position of SCHMITT20 field.
	PIO_SCHMITT_SCHMITT20_Pos = 0x14
	// Bit mask of SCHMITT20 field.
	PIO_SCHMITT_SCHMITT20_Msk = 0x100000
	// Bit SCHMITT20.
	PIO_SCHMITT_SCHMITT20 = 0x100000
	// Position of SCHMITT21 field.
	PIO_SCHMITT_SCHMITT21_Pos = 0x15
	// Bit mask of SCHMITT21 field.
	PIO_SCHMITT_SCHMITT21_Msk = 0x200000
	// Bit SCHMITT21.
	PIO_SCHMITT_SCHMITT21 = 0x200000
	// Position of SCHMITT22 field.
	PIO_SCHMITT_SCHMITT22_Pos = 0x16
	// Bit mask of SCHMITT22 field.
	PIO_SCHMITT_SCHMITT22_Msk = 0x400000
	// Bit SCHMITT22.
	PIO_SCHMITT_SCHMITT22 = 0x400000
	// Position of SCHMITT23 field.
	PIO_SCHMITT_SCHMITT23_Pos = 0x17
	// Bit mask of SCHMITT23 field.
	PIO_SCHMITT_SCHMITT23_Msk = 0x800000
	// Bit SCHMITT23.
	PIO_SCHMITT_SCHMITT23 = 0x800000
	// Position of SCHMITT24 field.
	PIO_SCHMITT_SCHMITT24_Pos = 0x18
	// Bit mask of SCHMITT24 field.
	PIO_SCHMITT_SCHMITT24_Msk = 0x1000000
	// Bit SCHMITT24.
	PIO_SCHMITT_SCHMITT24 = 0x1000000
	// Position of SCHMITT25 field.
	PIO_SCHMITT_SCHMITT25_Pos = 0x19
	// Bit mask of SCHMITT25 field.
	PIO_SCHMITT_SCHMITT25_Msk = 0x2000000
	// Bit SCHMITT25.
	PIO_SCHMITT_SCHMITT25 = 0x2000000
	// Position of SCHMITT26 field.
	PIO_SCHMITT_SCHMITT26_Pos = 0x1a
	// Bit mask of SCHMITT26 field.
	PIO_SCHMITT_SCHMITT26_Msk = 0x4000000
	// Bit SCHMITT26.
	PIO_SCHMITT_SCHMITT26 = 0x4000000
	// Position of SCHMITT27 field.
	PIO_SCHMITT_SCHMITT27_Pos = 0x1b
	// Bit mask of SCHMITT27 field.
	PIO_SCHMITT_SCHMITT27_Msk = 0x8000000
	// Bit SCHMITT27.
	PIO_SCHMITT_SCHMITT27 = 0x8000000
	// Position of SCHMITT28 field.
	PIO_SCHMITT_SCHMITT28_Pos = 0x1c
	// Bit mask of SCHMITT28 field.
	PIO_SCHMITT_SCHMITT28_Msk = 0x10000000
	// Bit SCHMITT28.
	PIO_SCHMITT_SCHMITT28 = 0x10000000
	// Position of SCHMITT29 field.
	PIO_SCHMITT_SCHMITT29_Pos = 0x1d
	// Bit mask of SCHMITT29 field.
	PIO_SCHMITT_SCHMITT29_Msk = 0x20000000
	// Bit SCHMITT29.
	PIO_SCHMITT_SCHMITT29 = 0x20000000
	// Position of SCHMITT30 field.
	PIO_SCHMITT_SCHMITT30_Pos = 0x1e
	// Bit mask of SCHMITT30 field.
	PIO_SCHMITT_SCHMITT30_Msk = 0x40000000
	// Bit SCHMITT30.
	PIO_SCHMITT_SCHMITT30 = 0x40000000
	// Position of SCHMITT31 field.
	PIO_SCHMITT_SCHMITT31_Pos = 0x1f
	// Bit mask of SCHMITT31 field.
	PIO_SCHMITT_SCHMITT31_Msk = 0x80000000
	// Bit SCHMITT31.
	PIO_SCHMITT_SCHMITT31 = 0x80000000

	// PCMR: Parallel Capture Mode Register
	// Position of PCEN field.
	PIO_PCMR_PCEN_Pos = 0x0
	// Bit mask of PCEN field.
	PIO_PCMR_PCEN_Msk = 0x1
	// Bit PCEN.
	PIO_PCMR_PCEN = 0x1
	// Position of DSIZE field.
	PIO_PCMR_DSIZE_Pos = 0x4
	// Bit mask of DSIZE field.
	PIO_PCMR_DSIZE_Msk = 0x30
	// The reception data in the PIO_PCRHR register is a BYTE (8-bit)
	PIO_PCMR_DSIZE_BYTE = 0x0
	// The reception data in the PIO_PCRHR register is a HALF-WORD (16-bit)
	PIO_PCMR_DSIZE_HALFWORD = 0x1
	// The reception data in the PIO_PCRHR register is a WORD (32-bit)
	PIO_PCMR_DSIZE_WORD = 0x2
	// Position of ALWYS field.
	PIO_PCMR_ALWYS_Pos = 0x9
	// Bit mask of ALWYS field.
	PIO_PCMR_ALWYS_Msk = 0x200
	// Bit ALWYS.
	PIO_PCMR_ALWYS = 0x200
	// Position of HALFS field.
	PIO_PCMR_HALFS_Pos = 0xa
	// Bit mask of HALFS field.
	PIO_PCMR_HALFS_Msk = 0x400
	// Bit HALFS.
	PIO_PCMR_HALFS = 0x400
	// Position of FRSTS field.
	PIO_PCMR_FRSTS_Pos = 0xb
	// Bit mask of FRSTS field.
	PIO_PCMR_FRSTS_Msk = 0x800
	// Bit FRSTS.
	PIO_PCMR_FRSTS = 0x800

	// PCIER: Parallel Capture Interrupt Enable Register
	// Position of DRDY field.
	PIO_PCIER_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	PIO_PCIER_DRDY_Msk = 0x1
	// Bit DRDY.
	PIO_PCIER_DRDY = 0x1
	// Position of OVRE field.
	PIO_PCIER_OVRE_Pos = 0x1
	// Bit mask of OVRE field.
	PIO_PCIER_OVRE_Msk = 0x2
	// Bit OVRE.
	PIO_PCIER_OVRE = 0x2
	// Position of ENDRX field.
	PIO_PCIER_ENDRX_Pos = 0x2
	// Bit mask of ENDRX field.
	PIO_PCIER_ENDRX_Msk = 0x4
	// Bit ENDRX.
	PIO_PCIER_ENDRX = 0x4
	// Position of RXBUFF field.
	PIO_PCIER_RXBUFF_Pos = 0x3
	// Bit mask of RXBUFF field.
	PIO_PCIER_RXBUFF_Msk = 0x8
	// Bit RXBUFF.
	PIO_PCIER_RXBUFF = 0x8

	// PCIDR: Parallel Capture Interrupt Disable Register
	// Position of DRDY field.
	PIO_PCIDR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	PIO_PCIDR_DRDY_Msk = 0x1
	// Bit DRDY.
	PIO_PCIDR_DRDY = 0x1
	// Position of OVRE field.
	PIO_PCIDR_OVRE_Pos = 0x1
	// Bit mask of OVRE field.
	PIO_PCIDR_OVRE_Msk = 0x2
	// Bit OVRE.
	PIO_PCIDR_OVRE = 0x2
	// Position of ENDRX field.
	PIO_PCIDR_ENDRX_Pos = 0x2
	// Bit mask of ENDRX field.
	PIO_PCIDR_ENDRX_Msk = 0x4
	// Bit ENDRX.
	PIO_PCIDR_ENDRX = 0x4
	// Position of RXBUFF field.
	PIO_PCIDR_RXBUFF_Pos = 0x3
	// Bit mask of RXBUFF field.
	PIO_PCIDR_RXBUFF_Msk = 0x8
	// Bit RXBUFF.
	PIO_PCIDR_RXBUFF = 0x8

	// PCIMR: Parallel Capture Interrupt Mask Register
	// Position of DRDY field.
	PIO_PCIMR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	PIO_PCIMR_DRDY_Msk = 0x1
	// Bit DRDY.
	PIO_PCIMR_DRDY = 0x1
	// Position of OVRE field.
	PIO_PCIMR_OVRE_Pos = 0x1
	// Bit mask of OVRE field.
	PIO_PCIMR_OVRE_Msk = 0x2
	// Bit OVRE.
	PIO_PCIMR_OVRE = 0x2
	// Position of ENDRX field.
	PIO_PCIMR_ENDRX_Pos = 0x2
	// Bit mask of ENDRX field.
	PIO_PCIMR_ENDRX_Msk = 0x4
	// Bit ENDRX.
	PIO_PCIMR_ENDRX = 0x4
	// Position of RXBUFF field.
	PIO_PCIMR_RXBUFF_Pos = 0x3
	// Bit mask of RXBUFF field.
	PIO_PCIMR_RXBUFF_Msk = 0x8
	// Bit RXBUFF.
	PIO_PCIMR_RXBUFF = 0x8

	// PCISR: Parallel Capture Interrupt Status Register
	// Position of DRDY field.
	PIO_PCISR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	PIO_PCISR_DRDY_Msk = 0x1
	// Bit DRDY.
	PIO_PCISR_DRDY = 0x1
	// Position of OVRE field.
	PIO_PCISR_OVRE_Pos = 0x1
	// Bit mask of OVRE field.
	PIO_PCISR_OVRE_Msk = 0x2
	// Bit OVRE.
	PIO_PCISR_OVRE = 0x2
	// Position of ENDRX field.
	PIO_PCISR_ENDRX_Pos = 0x2
	// Bit mask of ENDRX field.
	PIO_PCISR_ENDRX_Msk = 0x4
	// Bit ENDRX.
	PIO_PCISR_ENDRX = 0x4
	// Position of RXBUFF field.
	PIO_PCISR_RXBUFF_Pos = 0x3
	// Bit mask of RXBUFF field.
	PIO_PCISR_RXBUFF_Msk = 0x8
	// Bit RXBUFF.
	PIO_PCISR_RXBUFF = 0x8

	// PCRHR: Parallel Capture Reception Holding Register
	// Position of RDATA field.
	PIO_PCRHR_RDATA_Pos = 0x0
	// Bit mask of RDATA field.
	PIO_PCRHR_RDATA_Msk = 0xffffffff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	PIO_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	PIO_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	PIO_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	PIO_RCR_RXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	PIO_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	PIO_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	PIO_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	PIO_RNCR_RXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	PIO_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	PIO_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	PIO_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	PIO_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	PIO_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	PIO_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	PIO_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	PIO_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	PIO_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	PIO_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	PIO_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	PIO_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	PIO_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	PIO_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	PIO_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	PIO_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	PIO_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	PIO_PTSR_TXTEN = 0x100
)

// Bitfields for RSTC: Reset Controller
const (
	// CR: Control Register
	// Position of PROCRST field.
	SYSC_CR_PROCRST_Pos = 0x0
	// Bit mask of PROCRST field.
	SYSC_CR_PROCRST_Msk = 0x1
	// Bit PROCRST.
	SYSC_CR_PROCRST = 0x1
	// Position of PERRST field.
	SYSC_CR_PERRST_Pos = 0x2
	// Bit mask of PERRST field.
	SYSC_CR_PERRST_Msk = 0x4
	// Bit PERRST.
	SYSC_CR_PERRST = 0x4
	// Position of EXTRST field.
	SYSC_CR_EXTRST_Pos = 0x3
	// Bit mask of EXTRST field.
	SYSC_CR_EXTRST_Msk = 0x8
	// Bit EXTRST.
	SYSC_CR_EXTRST = 0x8
	// Position of KEY field.
	SYSC_CR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_CR_KEY_Msk = 0xff000000

	// SR: Status Register
	// Position of URSTS field.
	SYSC_SR_URSTS_Pos = 0x0
	// Bit mask of URSTS field.
	SYSC_SR_URSTS_Msk = 0x1
	// Bit URSTS.
	SYSC_SR_URSTS = 0x1
	// Position of RSTTYP field.
	SYSC_SR_RSTTYP_Pos = 0x8
	// Bit mask of RSTTYP field.
	SYSC_SR_RSTTYP_Msk = 0x700
	// Position of NRSTL field.
	SYSC_SR_NRSTL_Pos = 0x10
	// Bit mask of NRSTL field.
	SYSC_SR_NRSTL_Msk = 0x10000
	// Bit NRSTL.
	SYSC_SR_NRSTL = 0x10000
	// Position of SRCMP field.
	SYSC_SR_SRCMP_Pos = 0x11
	// Bit mask of SRCMP field.
	SYSC_SR_SRCMP_Msk = 0x20000
	// Bit SRCMP.
	SYSC_SR_SRCMP = 0x20000

	// MR: Mode Register
	// Position of URSTEN field.
	SYSC_MR_URSTEN_Pos = 0x0
	// Bit mask of URSTEN field.
	SYSC_MR_URSTEN_Msk = 0x1
	// Bit URSTEN.
	SYSC_MR_URSTEN = 0x1
	// Position of URSTIEN field.
	SYSC_MR_URSTIEN_Pos = 0x4
	// Bit mask of URSTIEN field.
	SYSC_MR_URSTIEN_Msk = 0x10
	// Bit URSTIEN.
	SYSC_MR_URSTIEN = 0x10
	// Position of ERSTL field.
	SYSC_MR_ERSTL_Pos = 0x8
	// Bit mask of ERSTL field.
	SYSC_MR_ERSTL_Msk = 0xf00
	// Position of KEY field.
	SYSC_MR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_MR_KEY_Msk = 0xff000000
)
