/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.gephi.appearance.api.Function;
import org.gephi.desktop.appearance.AppearanceUIController;

public class AutoAppyTransformer
implements Runnable {
    private static final long DEFAULT_DELAY = 500L;
    private final Function function;
    private final AppearanceUIController controller;
    private ScheduledExecutorService executor;

    public AutoAppyTransformer(AppearanceUIController controller, Function function) {
        this.controller = controller;
        this.function = function;
    }

    public void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Appearance Auto Transformer");
                return t;
            }
        });
        this.executor.scheduleWithFixedDelay(this, 0L, this.getDelayInMs(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    @Override
    public void run() {
        this.controller.appearanceController.transform(this.function);
    }

    public boolean isRunning() {
        return this.executor != null;
    }

    private long getDelayInMs() {
        return 500L;
    }
}

