/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class ClasspathJsr199
extends ClasspathLocation {
    private static final Set<JavaFileObject.Kind> fileTypes = new HashSet<JavaFileObject.Kind>();
    private JavaFileManager fileManager;
    private JavaFileManager.Location location;

    public ClasspathJsr199(JavaFileManager javaFileManager, JavaFileManager.Location location) {
        super(null, null);
        this.fileManager = javaFileManager;
        this.location = location;
    }

    @Override
    public List fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter classpathSectionProblemReporter) {
        return null;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2) {
        return this.findClass(cArray, string, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, boolean bl) {
        String string3 = File.separatorChar == '/' ? string2 : string2.replace(File.separatorChar, '/');
        try {
            int n = string3.lastIndexOf(46);
            String string4 = n < 0 ? string3 : string3.substring(0, n);
            FileObject fileObject = null;
            try {
                fileObject = this.fileManager.getJavaFileForInput(this.location, string4, JavaFileObject.Kind.CLASS);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (fileObject == null) {
                return null;
            }
            try (InputStream inputStream = fileObject.openInputStream();){
                ClassFileReader classFileReader = ClassFileReader.read(inputStream, string3);
                if (classFileReader == null) return null;
                NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer(classFileReader, this.fetchAccessRestriction(string3));
                return nameEnvironmentAnswer;
            }
        }
        catch (ClassFormatException classFormatException) {
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public char[][][] findTypeNames(String string) {
        String string2 = File.separatorChar == '/' ? string : string.replace(File.separatorChar, '/');
        Iterable<JavaFileObject> iterable = null;
        try {
            iterable = this.fileManager.list(this.location, string2, fileTypes, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (iterable == null) {
            return null;
        }
        ArrayList<char[][]> arrayList = new ArrayList<char[][]>();
        char[][] cArray = CharOperation.splitOn(File.separatorChar, string2.toCharArray());
        for (JavaFileObject object : iterable) {
            int n;
            String string3 = object.toUri().getPath();
            int n2 = string3.lastIndexOf(47);
            if (n2 <= 0 || (n = string3.lastIndexOf(46)) == -1) continue;
            String string4 = string3.substring(n2 + 1, n);
            arrayList.add(CharOperation.arrayConcat(cArray, string4.toCharArray()));
        }
        int n = arrayList.size();
        if (n != 0) {
            char[][][] cArrayArray = new char[n][][];
            arrayList.toArray((T[])cArrayArray);
            return cArrayArray;
        }
        return null;
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public boolean isPackage(String string) {
        String string2 = File.separatorChar == '/' ? string : string.replace(File.separatorChar, '/');
        boolean bl = false;
        try {
            Iterable<JavaFileObject> iterable = this.fileManager.list(this.location, string2, fileTypes, false);
            Iterator<JavaFileObject> iterator = iterable.iterator();
            if (iterator.hasNext()) {
                bl = true;
            } else {
                iterable = this.fileManager.list(this.location, string2, fileTypes, true);
                iterator = iterable.iterator();
                if (iterator.hasNext()) {
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public void reset() {
        try {
            this.fileManager.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "Classpath for Jsr 199 JavaFileManager: " + this.location;
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            this.normalizedPath = this.path.toCharArray();
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = this.location.getName();
        }
        return this.path;
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public boolean hasAnnotationFileFor(String string) {
        return false;
    }

    static {
        fileTypes.add(JavaFileObject.Kind.CLASS);
    }
}

