/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.FilterAutoRefreshor;
import org.gephi.filters.FilterLibraryImpl;
import org.gephi.filters.FilterQueryImpl;
import org.gephi.filters.FilterThread;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;

public class FilterModelImpl
implements FilterModel {
    private final FilterLibraryImpl filterLibraryImpl;
    private final LinkedList<Query> queries;
    private FilterThread filterThread;
    private final GraphModel graphModel;
    private final Workspace workspace;
    private Query currentQuery;
    private boolean filtering;
    private boolean selecting;
    private GraphView currentResult;
    private boolean autoRefresh;
    private final FilterAutoRefreshor autoRefreshor;
    private List<ChangeListener> listeners;

    public FilterModelImpl(Workspace workspace) {
        this.workspace = workspace;
        this.filterLibraryImpl = new FilterLibraryImpl(workspace);
        this.queries = new LinkedList();
        this.listeners = new ArrayList<ChangeListener>();
        this.autoRefresh = true;
        this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        this.autoRefreshor = new FilterAutoRefreshor(this, this.graphModel);
    }

    public FilterLibrary getLibrary() {
        return this.filterLibraryImpl;
    }

    public Query[] getQueries() {
        return this.queries.toArray(new Query[0]);
    }

    public boolean hasQuery(Query query) {
        for (Query q : this.getQueries()) {
            if (q != query) continue;
            return true;
        }
        return false;
    }

    public void addFirst(Query function) {
        this.updateParameters(function);
        this.queries.addFirst(function);
        this.currentQuery = function;
        this.fireChangeEvent();
    }

    public void addLast(Query function) {
        this.updateParameters(function);
        this.queries.addLast(function);
        this.fireChangeEvent();
    }

    public void set(int index, Query function) {
        this.queries.set(index, function);
    }

    public void remove(Query query) {
        if (query == this.currentQuery) {
            this.currentQuery = query.getParent();
        }
        this.queries.remove(query);
        this.destroyQuery(query);
        this.fireChangeEvent();
    }

    public void rename(Query query, String name) {
        ((AbstractQueryImpl)query).setName(name);
        this.fireChangeEvent();
    }

    public void setSubQuery(Query query, Query subQuery) {
        this.updateParameters(subQuery);
        if (this.queries.contains(subQuery)) {
            this.queries.remove(subQuery);
        }
        if (subQuery.getParent() != null) {
            ((AbstractQueryImpl)subQuery.getParent()).removeSubQuery(subQuery);
        }
        if (subQuery == this.currentQuery) {
            this.currentQuery = ((AbstractQueryImpl)query).getRoot();
        }
        AbstractQueryImpl impl = (AbstractQueryImpl)query;
        impl.addSubQuery(subQuery);
        this.fireChangeEvent();
        this.autoRefreshor.manualRefresh();
    }

    public void removeSubQuery(Query query, Query parent) {
        AbstractQueryImpl impl = (AbstractQueryImpl)parent;
        impl.removeSubQuery(query);
        ((AbstractQueryImpl)query).setParent(null);
        if (query == this.currentQuery) {
            this.currentQuery = parent;
        }
        this.fireChangeEvent();
        this.autoRefreshor.manualRefresh();
    }

    public int getIndex(Query function) {
        int i = 0;
        for (Query f : this.queries) {
            if (f == function) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isFiltering() {
        return this.currentQuery != null && this.filtering;
    }

    public boolean isSelecting() {
        return this.currentQuery != null && this.selecting;
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
        if (filtering) {
            this.selecting = false;
        }
    }

    public void setSelecting(boolean selecting) {
        this.selecting = selecting;
        if (selecting) {
            this.filtering = false;
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
        this.fireChangeEvent();
        if (!autoRefresh) {
            this.autoRefreshor.setEnable(false);
        } else if (autoRefresh && this.currentResult != null) {
            this.autoRefreshor.setEnable(true);
        }
    }

    public Query getCurrentQuery() {
        return this.currentQuery;
    }

    public void setCurrentQuery(Query currentQuery) {
        if (currentQuery != null) {
            currentQuery = ((AbstractQueryImpl)currentQuery).getRoot();
        }
        if (this.currentQuery != currentQuery) {
            this.currentQuery = currentQuery;
            this.fireChangeEvent();
        }
    }

    public void updateParameters(Query query) {
        if (query instanceof FilterQueryImpl) {
            ((FilterQueryImpl)query).updateParameters();
            this.fireChangeEvent();
        }
    }

    public Query getQuery(Filter filter) {
        for (Query q : this.getAllQueries()) {
            if (filter != q.getFilter()) continue;
            return q;
        }
        return null;
    }

    public Query[] getAllQueries() {
        ArrayList<Query> result = new ArrayList<Query>();
        LinkedList<Query> stack = new LinkedList<Query>();
        stack.addAll(this.queries);
        while (!stack.isEmpty()) {
            Query q = (Query)stack.pop();
            result.add(q);
            stack.addAll(Arrays.asList(q.getChildren()));
        }
        return result.toArray(new Query[0]);
    }

    public FilterThread getFilterThread() {
        return this.filterThread;
    }

    public FilterAutoRefreshor getAutoRefreshor() {
        return this.autoRefreshor;
    }

    public void setFilterThread(FilterThread filterThread) {
        this.filterThread = filterThread;
    }

    public void setCurrentResult(GraphView currentResult) {
        this.currentResult = currentResult;
        if (currentResult != null && this.autoRefresh) {
            this.autoRefreshor.setEnable(true);
        } else if (currentResult == null && this.autoRefresh) {
            this.autoRefreshor.setEnable(false);
        }
    }

    public GraphView getCurrentResult() {
        return this.currentResult;
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void destroy() {
        if (this.filterThread != null) {
            this.filterThread.setRunning(false);
        }
        this.autoRefreshor.setRunning(false);
        this.currentResult = null;
        this.listeners = null;
        for (Query q : this.queries) {
            this.destroyQuery(q);
        }
    }

    private void destroyQuery(Query query) {
        if (query instanceof AbstractQueryImpl) {
            AbstractQueryImpl absQuery = (AbstractQueryImpl)query;
            for (Query q : absQuery.getDescendantsAndSelf()) {
                if (!(q instanceof FilterQueryImpl)) continue;
                Filter f = ((FilterQueryImpl)q).getFilter();
                FilterBuilder builder = ((FilterQueryImpl)q).getBuilder();
                if (builder == null) continue;
                builder.destroy(f);
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(evt);
        }
    }
}

