/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

final class NetigsoLoader
extends ClassLoader {
    private final Module mi;

    public NetigsoLoader(Module mi) {
        this.mi = mi;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader del = this.getDelegate(10000L);
        if (del == null) {
            Util.err.log(Level.WARNING, "Time out waiting to enabled {0}. Cannot load {1}", new Object[]{this.mi.getCodeNameBase(), className});
            throw new ClassNotFoundException(className);
        }
        return del.loadClass(className);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader d = this.getDelegate();
        if (d instanceof ProxyClassLoader) {
            return ((ProxyClassLoader)d).loadClass(name, resolve);
        }
        return d.loadClass(name);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        return this.getDelegate().getResources(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        return this.getDelegate().getResourceAsStream(string);
    }

    @Override
    public URL getResource(String string) {
        return this.getDelegate().getResource(string);
    }

    private ClassLoader getDelegate() {
        return this.getDelegate(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getDelegate(long timeout) {
        if (!this.mi.isEnabled()) {
            Util.err.log(Level.INFO, "OSGi is requesting adhoc start of {0}. This is inefficient. It is suggested turn the module on by default", this.mi.getCodeNameBase());
            Mutex.Privileged p = this.mi.getManager().mutexPrivileged();
            if (!p.tryWriteAccess(timeout)) {
                return null;
            }
            try {
                this.mi.getManager().enable(this.mi, false);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                p.exitWriteAccess();
            }
        }
        return this.mi.getClassLoader();
    }
}

