/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.swt;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.macosx.MacOSXGraphicsDevice;
import com.jogamp.nativewindow.windows.WindowsGraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.nativewindow.x11.X11Lib;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scrollable;

public class SWTAccessor {
    private static final boolean DEBUG;
    private static final Method swt_scrollable_clientAreaInPixels;
    private static final Method swt_control_locationInPixels;
    private static final Method swt_control_sizeInPixels;
    private static final Method swt_dpiutil_getScalingFactor;
    private static final Field swt_control_handle;
    private static final boolean swt_uses_long_handles;
    private static Object swt_osx_init;
    private static Field swt_osx_control_view;
    private static Field swt_osx_view_id;
    private static final String nwt;
    public static final boolean isOSX;
    public static final boolean isWindows;
    public static final boolean isX11;
    public static final boolean isX11GTK;
    private static final String str_handle = "handle";
    private static final String str_osx_view = "view";
    private static final String str_osx_id = "id";
    private static final Method swt_control_internal_new_GC;
    private static final Method swt_control_internal_dispose_GC;
    private static final String str_internal_new_GC = "internal_new_GC";
    private static final String str_internal_dispose_GC = "internal_dispose_GC";
    private static final String str_OS_gtk_class = "org.eclipse.swt.internal.gtk.OS";
    private static final String str_GTK_gtk_class = "org.eclipse.swt.internal.gtk.GTK";
    private static final String str_GDK_gtk_class = "org.eclipse.swt.internal.gtk.GDK";
    public static final Class<?> OS_gtk_class;
    private static final String str_OS_gtk_version = "GTK_VERSION";
    public static final VersionNumber OS_gtk_version;
    private static final Method OS_gtk_widget_realize;
    private static final Method OS_gtk_widget_unrealize;
    private static final Method OS_GTK_WIDGET_WINDOW;
    private static final Method OS_gtk_widget_get_window;
    private static final Method OS_gdk_x11_drawable_get_xdisplay;
    private static final Method OS_gdk_x11_display_get_xdisplay;
    private static final Method OS_gdk_window_get_display;
    private static final Method OS_gdk_x11_drawable_get_xid;
    private static final Method OS_gdk_x11_window_get_xid;
    private static final Method OS_gdk_window_set_back_pixmap;
    private static final Method OS_gdk_window_set_background_pattern;
    private static final String str_gtk_widget_realize = "gtk_widget_realize";
    private static final String str_gtk_widget_unrealize = "gtk_widget_unrealize";
    private static final String str_GTK_WIDGET_WINDOW = "GTK_WIDGET_WINDOW";
    private static final String str_gtk_widget_get_window = "gtk_widget_get_window";
    private static final String str_gdk_x11_drawable_get_xdisplay = "gdk_x11_drawable_get_xdisplay";
    private static final String str_gdk_x11_display_get_xdisplay = "gdk_x11_display_get_xdisplay";
    private static final String str_gdk_window_get_display = "gdk_window_get_display";
    private static final String str_gdk_x11_drawable_get_xid = "gdk_x11_drawable_get_xid";
    private static final String str_gdk_x11_window_get_xid = "gdk_x11_window_get_xid";
    private static final String str_gdk_window_set_back_pixmap = "gdk_window_set_back_pixmap";
    private static final String str_gdk_window_set_background_pattern = "gdk_window_set_background_pattern";
    private static final VersionNumber GTK_VERSION_2_14_0;
    private static final VersionNumber GTK_VERSION_2_24_0;
    private static final VersionNumber GTK_VERSION_2_90_0;
    private static final VersionNumber GTK_VERSION_3_0_0;

    private static VersionNumber GTK_VERSION(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        return new VersionNumber(n4, n3, n2);
    }

    private static Number getIntOrLong(long l) {
        if (swt_uses_long_handles) {
            return l;
        }
        return (int)l;
    }

    private static void callStaticMethodL2V(Method method, long l) {
        ReflectionUtil.callMethod(null, (Method)method, (Object[])new Object[]{SWTAccessor.getIntOrLong(l)});
    }

    private static void callStaticMethodLL2V(Method method, long l, long l2) {
        ReflectionUtil.callMethod(null, (Method)method, (Object[])new Object[]{SWTAccessor.getIntOrLong(l), SWTAccessor.getIntOrLong(l2)});
    }

    private static void callStaticMethodLLZ2V(Method method, long l, long l2, boolean bl) {
        ReflectionUtil.callMethod(null, (Method)method, (Object[])new Object[]{SWTAccessor.getIntOrLong(l), SWTAccessor.getIntOrLong(l2), bl});
    }

    private static long callStaticMethodL2L(Method method, long l) {
        Object object = ReflectionUtil.callMethod(null, (Method)method, (Object[])new Object[]{SWTAccessor.getIntOrLong(l)});
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw new InternalError("SWT method " + method.getName() + " didn't return int or long but " + object.getClass());
    }

    public static boolean isUsingLongHandles() {
        return swt_uses_long_handles;
    }

    public static boolean useX11GTK() {
        return isX11GTK;
    }

    public static VersionNumber GTK_VERSION() {
        return OS_gtk_version;
    }

    public static long gdk_widget_get_window(long l) {
        long l2 = OS_gtk_version.compareTo(GTK_VERSION_2_14_0) >= 0 ? SWTAccessor.callStaticMethodL2L(OS_gtk_widget_get_window, l) : SWTAccessor.callStaticMethodL2L(OS_GTK_WIDGET_WINDOW, l);
        if (0L == l2) {
            throw new NativeWindowException("Null gtk-window-handle of SWT handle 0x" + Long.toHexString(l));
        }
        return l2;
    }

    public static long gdk_window_get_xdisplay(long l) {
        long l2;
        if (OS_gtk_version.compareTo(GTK_VERSION_2_24_0) >= 0) {
            long l3 = SWTAccessor.callStaticMethodL2L(OS_gdk_window_get_display, l);
            if (0L == l3) {
                throw new NativeWindowException("Null display-handle of gtk-window-handle 0x" + Long.toHexString(l));
            }
            l2 = SWTAccessor.callStaticMethodL2L(OS_gdk_x11_display_get_xdisplay, l3);
        } else {
            l2 = SWTAccessor.callStaticMethodL2L(OS_gdk_x11_drawable_get_xdisplay, l);
        }
        if (0L == l2) {
            throw new NativeWindowException("Null x11-display-handle of gtk-window-handle 0x" + Long.toHexString(l));
        }
        return l2;
    }

    public static long gdk_window_get_xwindow(long l) {
        long l2 = OS_gtk_version.compareTo(GTK_VERSION_3_0_0) >= 0 ? SWTAccessor.callStaticMethodL2L(OS_gdk_x11_window_get_xid, l) : SWTAccessor.callStaticMethodL2L(OS_gdk_x11_drawable_get_xid, l);
        if (0L == l2) {
            throw new NativeWindowException("Null x11-window-handle of gtk-window-handle 0x" + Long.toHexString(l));
        }
        return l2;
    }

    public static void gdk_window_set_back_pixmap(long l, long l2, boolean bl) {
        if (OS_gdk_window_set_back_pixmap != null) {
            SWTAccessor.callStaticMethodLLZ2V(OS_gdk_window_set_back_pixmap, l, l2, bl);
        } else if (OS_gdk_window_set_background_pattern != null) {
            SWTAccessor.callStaticMethodLL2V(OS_gdk_window_set_background_pattern, l, 0L);
        }
    }

    public static void printInfo(PrintStream printStream, Display display) {
        printStream.println("SWT: Platform: " + SWT.getPlatform() + ", Version " + SWT.getVersion());
        printStream.println("SWT: isX11 " + isX11 + ", isX11GTK " + isX11GTK + " (GTK Version: " + OS_gtk_version + ")");
        printStream.println("SWT: isOSX " + isOSX + ", isWindows " + isWindows);
        printStream.println("SWT: DeviceZoom: " + DPIUtil.getDeviceZoom() + ", deviceZoomScalingFactor " + SWTAccessor.getDeviceZoomScalingFactor());
        printStream.println("SWT: Display.DPI " + display.getDPI() + "; DPIUtil: autoScalingFactor " + SWTAccessor.getAutoScalingFactor() + " (use-swt " + (null != swt_dpiutil_getScalingFactor) + "), useCairoAutoScale " + DPIUtil.useCairoAutoScale());
    }

    public static float getAutoScalingFactor() throws NativeWindowException {
        if (null != swt_dpiutil_getScalingFactor) {
            try {
                return ((Float)swt_dpiutil_getScalingFactor.invoke(null, new Object[0])).floatValue();
            }
            catch (Throwable throwable) {
                throw new NativeWindowException(throwable);
            }
        }
        int n = DPIUtil.getDeviceZoom();
        if (100 == n || DPIUtil.useCairoAutoScale()) {
            return 1.0f;
        }
        return (float)n / 100.0f;
    }

    public static int autoScaleUp(int n) {
        int n2 = DPIUtil.getDeviceZoom();
        if (100 == n2 || DPIUtil.useCairoAutoScale()) {
            return n;
        }
        float f = (float)n2 / 100.0f;
        return Math.round((float)n * f);
    }

    public static int autoScaleDown(int n) {
        int n2 = DPIUtil.getDeviceZoom();
        if (100 == n2 || DPIUtil.useCairoAutoScale()) {
            return n;
        }
        float f = (float)n2 / 100.0f;
        return Math.round((float)n / f);
    }

    public static float getDeviceZoomScalingFactor() {
        int n = DPIUtil.getDeviceZoom();
        if (100 == n) {
            return 1.0f;
        }
        return (float)n / 100.0f;
    }

    public static int deviceZoomScaleUp(int n) {
        int n2 = DPIUtil.getDeviceZoom();
        if (100 == n2) {
            return n;
        }
        float f = (float)n2 / 100.0f;
        return Math.round((float)n * f);
    }

    public static int deviceZoomScaleDown(int n) {
        int n2 = DPIUtil.getDeviceZoom();
        if (100 == n2) {
            return n;
        }
        float f = (float)n2 / 100.0f;
        return Math.round((float)n / f);
    }

    public static com.jogamp.nativewindow.util.Point deviceZoomScaleUp(com.jogamp.nativewindow.util.Point point) {
        int n = DPIUtil.getDeviceZoom();
        if (100 == n || null == point) {
            return point;
        }
        float f = (float)n / 100.0f;
        return point.set(Math.round((float)point.getX() * f), Math.round((float)point.getY() * f));
    }

    public static com.jogamp.nativewindow.util.Point deviceZoomScaleDown(com.jogamp.nativewindow.util.Point point) {
        int n = DPIUtil.getDeviceZoom();
        if (100 == n || null == point) {
            return point;
        }
        float f = (float)n / 100.0f;
        return point.set(Math.round((float)point.getX() / f), Math.round((float)point.getY() / f));
    }

    public static Rectangle getClientAreaInPixels(Scrollable scrollable) throws NativeWindowException {
        if (null == swt_scrollable_clientAreaInPixels) {
            return DPIUtil.autoScaleUp((Rectangle)scrollable.getClientArea());
        }
        try {
            return (Rectangle)swt_scrollable_clientAreaInPixels.invoke((Object)scrollable, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new NativeWindowException(throwable);
        }
    }

    public static Point getLocationInPixels(Control control) throws NativeWindowException {
        if (null == swt_control_locationInPixels) {
            return DPIUtil.autoScaleUp((Point)control.getLocation());
        }
        try {
            return (Point)swt_control_locationInPixels.invoke((Object)control, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new NativeWindowException(throwable);
        }
    }

    public static Point getSizeInPixels(Control control) throws NativeWindowException {
        if (null == swt_control_sizeInPixels) {
            return DPIUtil.autoScaleUp((Point)control.getSize());
        }
        try {
            return (Point)swt_control_sizeInPixels.invoke((Object)control, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new NativeWindowException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getHandle(Control control) throws NativeWindowException {
        long l = 0L;
        if (isOSX) {
            Object object = swt_osx_init;
            synchronized (object) {
                try {
                    if (null == swt_osx_view_id) {
                        swt_osx_control_view = Control.class.getField(str_osx_view);
                        Object object2 = swt_osx_control_view.get(control);
                        swt_osx_view_id = object2.getClass().getField(str_osx_id);
                        l = swt_osx_view_id.getLong(object2);
                    } else {
                        l = swt_osx_view_id.getLong(swt_osx_control_view.get(control));
                    }
                }
                catch (Exception exception) {
                    throw new NativeWindowException(exception);
                }
            }
        }
        try {
            l = swt_control_handle.getLong(control);
        }
        catch (Exception exception) {
            throw new NativeWindowException(exception);
        }
        if (0L == l) {
            throw new NativeWindowException("Null widget-handle of SWT " + control.getClass().getName() + ": " + control.toString());
        }
        return l;
    }

    public static void setRealized(Control control, final boolean bl) throws NativeWindowException {
        if (!bl && control.isDisposed()) {
            return;
        }
        final long l = SWTAccessor.getHandle(control);
        if (null != OS_gtk_class) {
            SWTAccessor.invokeOnOSTKThread(true, new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        SWTAccessor.callStaticMethodL2V(OS_gtk_widget_realize, l);
                    } else if (null != OS_gtk_widget_unrealize) {
                        SWTAccessor.callStaticMethodL2V(OS_gtk_widget_unrealize, l);
                    }
                }
            });
        }
    }

    public static AbstractGraphicsDevice getDevice(Control control) throws NativeWindowException, UnsupportedOperationException {
        long l = SWTAccessor.getHandle(control);
        if (isX11GTK) {
            long l2 = SWTAccessor.gdk_window_get_xdisplay(SWTAccessor.gdk_widget_get_window(l));
            return new X11GraphicsDevice(l2, 0, false);
        }
        if (isWindows) {
            return new WindowsGraphicsDevice(0);
        }
        if (isOSX) {
            return new MacOSXGraphicsDevice(0);
        }
        throw new UnsupportedOperationException("n/a for this windowing system: " + nwt);
    }

    public static AbstractGraphicsScreen getScreen(AbstractGraphicsDevice abstractGraphicsDevice, int n) {
        return NativeWindowFactory.createScreen(abstractGraphicsDevice, n);
    }

    public static int getNativeVisualID(AbstractGraphicsDevice abstractGraphicsDevice, long l) {
        if (isX11) {
            return X11Lib.GetVisualIDFromWindow(abstractGraphicsDevice.getHandle(), l);
        }
        if (isWindows || isOSX) {
            return 0;
        }
        throw new UnsupportedOperationException("n/a for this windowing system: " + nwt);
    }

    public static long getWindowHandle(Control control) throws NativeWindowException, UnsupportedOperationException {
        long l = SWTAccessor.getHandle(control);
        if (0L == l) {
            throw new NativeWindowException("Null SWT handle of SWT control " + control);
        }
        if (isX11GTK) {
            return SWTAccessor.gdk_window_get_xwindow(SWTAccessor.gdk_widget_get_window(l));
        }
        if (isWindows || isOSX) {
            return l;
        }
        throw new UnsupportedOperationException("n/a for this windowing system: " + nwt);
    }

    public static long newGC(final Control control, final GCData gCData) {
        final Object[] objectArray = new Object[1];
        SWTAccessor.invokeOnOSTKThread(true, new Runnable(){

            @Override
            public void run() {
                objectArray[0] = ReflectionUtil.callMethod((Object)control, (Method)swt_control_internal_new_GC, (Object[])new Object[]{gCData});
            }
        });
        if (objectArray[0] instanceof Number) {
            return ((Number)objectArray[0]).longValue();
        }
        throw new InternalError("SWT internal_new_GC did not return int or long but " + objectArray[0].getClass());
    }

    public static void disposeGC(final Control control, final long l, final GCData gCData) {
        SWTAccessor.invokeOnOSTKThread(true, new Runnable(){

            @Override
            public void run() {
                if (swt_uses_long_handles) {
                    ReflectionUtil.callMethod((Object)control, (Method)swt_control_internal_dispose_GC, (Object[])new Object[]{l, gCData});
                } else {
                    ReflectionUtil.callMethod((Object)control, (Method)swt_control_internal_dispose_GC, (Object[])new Object[]{(int)l, gCData});
                }
            }
        });
    }

    public static void invokeOnOSTKThread(boolean bl, Runnable runnable) {
        if (isOSX) {
            OSXUtil.RunOnMainThread(bl, false, runnable);
        } else {
            runnable.run();
        }
    }

    public static void invokeOnSWTThread(Display display, boolean bl, Runnable runnable) {
        if (null == display || display.isDisposed() || Thread.currentThread() == display.getThread()) {
            SWTAccessor.invokeOnOSTKThread(bl, runnable);
        } else if (bl) {
            display.syncExec(runnable);
        } else {
            display.asyncExec(runnable);
        }
    }

    public static boolean isOnSWTThread(Display display) {
        return null != display && Thread.currentThread() == display.getThread();
    }

    public static long createCompatibleX11ChildWindow(AbstractGraphicsScreen abstractGraphicsScreen, Control control, int n, int n2, int n3) {
        long l = SWTAccessor.getHandle(control);
        long l2 = SWTAccessor.gdk_widget_get_window(l);
        long l3 = SWTAccessor.gdk_window_get_xwindow(l2);
        long l4 = X11Lib.CreateWindow(l3, abstractGraphicsScreen.getDevice().getHandle(), abstractGraphicsScreen.getIndex(), n, n2, n3, true, true);
        return l4;
    }

    public static void resizeX11Window(AbstractGraphicsDevice abstractGraphicsDevice, Rectangle rectangle, long l) {
        X11Lib.SetWindowPosSize(abstractGraphicsDevice.getHandle(), l, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void destroyX11Window(AbstractGraphicsDevice abstractGraphicsDevice, long l) {
        X11Lib.DestroyWindow(abstractGraphicsDevice.getHandle(), l);
    }

    public static long createCompatibleGDKChildWindow(Control control, int n, int n2, int n3) {
        return 0L;
    }

    public static void showGDKWindow(long l) {
    }

    public static void focusGDKWindow(long l) {
    }

    public static void resizeGDKWindow(Rectangle rectangle, long l) {
    }

    public static void destroyGDKWindow(long l) {
    }

    static {
        Class<Number> clazz;
        Method method;
        block33: {
            block32: {
                block31: {
                    block30: {
                        DEBUG = Debug.debug("SWT");
                        swt_osx_init = new Object();
                        swt_osx_control_view = null;
                        swt_osx_view_id = null;
                        GTK_VERSION_2_14_0 = new VersionNumber(2, 14, 0);
                        GTK_VERSION_2_24_0 = new VersionNumber(2, 24, 0);
                        GTK_VERSION_2_90_0 = new VersionNumber(2, 90, 0);
                        GTK_VERSION_3_0_0 = new VersionNumber(3, 0, 0);
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                NativeWindowFactory.initSingleton();
                                return null;
                            }
                        });
                        nwt = NativeWindowFactory.getNativeWindowType(false);
                        isOSX = ".macosx" == nwt;
                        isWindows = ".windows" == nwt;
                        isX11 = ".x11" == nwt;
                        method = null;
                        try {
                            method = Control.class.getDeclaredMethod("getLocationInPixels", new Class[0]);
                            method.setAccessible(true);
                        }
                        catch (Exception exception) {
                            method = null;
                            if (!DEBUG) break block30;
                            System.err.println("getLocationInPixels not implemented: " + exception.getMessage());
                        }
                    }
                    swt_control_locationInPixels = method;
                    method = null;
                    try {
                        method = Control.class.getDeclaredMethod("getSizeInPixels", new Class[0]);
                        method.setAccessible(true);
                    }
                    catch (Exception exception) {
                        method = null;
                        if (!DEBUG) break block31;
                        System.err.println("getSizeInPixels not implemented: " + exception.getMessage());
                    }
                }
                swt_control_sizeInPixels = method;
                method = null;
                try {
                    method = Scrollable.class.getDeclaredMethod("getClientAreaInPixels", new Class[0]);
                    method.setAccessible(true);
                }
                catch (Exception exception) {
                    method = null;
                    if (!DEBUG) break block32;
                    System.err.println("getClientAreaInPixels not implemented: " + exception.getMessage());
                }
            }
            swt_scrollable_clientAreaInPixels = method;
            method = null;
            try {
                method = DPIUtil.class.getDeclaredMethod("getScalingFactor", new Class[0]);
                method.setAccessible(true);
            }
            catch (Exception exception) {
                method = null;
                if (!DEBUG) break block33;
                System.err.println("getScalingFactor not implemented: " + exception.getMessage());
            }
        }
        swt_dpiutil_getScalingFactor = method;
        Field field = null;
        if (!isOSX) {
            try {
                field = Control.class.getField(str_handle);
            }
            catch (Exception exception) {
                throw new NativeWindowException(exception);
            }
        }
        boolean bl = null != (swt_control_handle = field) ? swt_control_handle.getGenericType().toString().equals(Long.TYPE.toString()) : Platform.is64Bit();
        swt_uses_long_handles = bl;
        method = null;
        try {
            method = ReflectionUtil.getMethod(Control.class, (String)str_internal_new_GC, (Class[])new Class[]{GCData.class});
        }
        catch (Exception exception) {
            throw new NativeWindowException(exception);
        }
        swt_control_internal_new_GC = method;
        method = null;
        try {
            method = swt_uses_long_handles ? Control.class.getDeclaredMethod(str_internal_dispose_GC, Long.TYPE, GCData.class) : Control.class.getDeclaredMethod(str_internal_dispose_GC, Integer.TYPE, GCData.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NativeWindowException(noSuchMethodException);
        }
        swt_control_internal_dispose_GC = method;
        Class clazz2 = null;
        VersionNumber versionNumber = new VersionNumber(0, 0, 0);
        Method method2 = null;
        Method method3 = null;
        Method method4 = null;
        Method method5 = null;
        Method method6 = null;
        Method method7 = null;
        Method method8 = null;
        Method method9 = null;
        Method method10 = null;
        Method method11 = null;
        Method method12 = null;
        Class<Number> clazz3 = clazz = swt_uses_long_handles ? Long.TYPE : Integer.TYPE;
        if (isX11) {
            try {
                Field field2;
                ClassLoader classLoader = SWTAccessor.class.getClassLoader();
                Class clazz4 = clazz2 = ReflectionUtil.getClass((String)str_OS_gtk_class, (boolean)false, (ClassLoader)classLoader);
                try {
                    field2 = clazz2.getField(str_OS_gtk_version);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    clazz2 = ReflectionUtil.getClass((String)str_GTK_gtk_class, (boolean)false, (ClassLoader)classLoader);
                    field2 = clazz2.getField(str_OS_gtk_version);
                    clazz4 = ReflectionUtil.getClass((String)str_GDK_gtk_class, (boolean)false, (ClassLoader)classLoader);
                }
                versionNumber = SWTAccessor.GTK_VERSION(field2.getInt(null));
                method2 = clazz2.getDeclaredMethod(str_gtk_widget_realize, clazz);
                if (versionNumber.compareTo(GTK_VERSION_2_14_0) >= 0) {
                    method5 = clazz2.getDeclaredMethod(str_gtk_widget_get_window, clazz);
                } else {
                    method4 = clazz2.getDeclaredMethod(str_GTK_WIDGET_WINDOW, clazz);
                }
                if (versionNumber.compareTo(GTK_VERSION_2_24_0) >= 0) {
                    method7 = clazz4.getDeclaredMethod(str_gdk_x11_display_get_xdisplay, clazz);
                    method8 = clazz4.getDeclaredMethod(str_gdk_window_get_display, clazz);
                } else {
                    method6 = clazz2.getDeclaredMethod(str_gdk_x11_drawable_get_xdisplay, clazz);
                }
                if (versionNumber.compareTo(GTK_VERSION_3_0_0) >= 0) {
                    method10 = clazz4.getDeclaredMethod(str_gdk_x11_window_get_xid, clazz);
                } else {
                    method9 = clazz2.getDeclaredMethod(str_gdk_x11_drawable_get_xid, clazz);
                }
                if (versionNumber.compareTo(GTK_VERSION_2_90_0) >= 0) {
                    method12 = clazz4.getDeclaredMethod(str_gdk_window_set_background_pattern, clazz, clazz);
                } else {
                    method11 = clazz2.getDeclaredMethod(str_gdk_window_set_back_pixmap, clazz, clazz, Boolean.TYPE);
                }
            }
            catch (Exception exception) {
                throw new NativeWindowException(exception);
            }
            try {
                method3 = clazz2.getDeclaredMethod(str_gtk_widget_unrealize, clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OS_gtk_class = clazz2;
        OS_gtk_version = versionNumber;
        OS_gtk_widget_realize = method2;
        OS_gtk_widget_unrealize = method3;
        OS_GTK_WIDGET_WINDOW = method4;
        OS_gtk_widget_get_window = method5;
        OS_gdk_x11_drawable_get_xdisplay = method6;
        OS_gdk_x11_display_get_xdisplay = method7;
        OS_gdk_window_get_display = method8;
        OS_gdk_x11_drawable_get_xid = method9;
        OS_gdk_x11_window_get_xid = method10;
        OS_gdk_window_set_back_pixmap = method11;
        OS_gdk_window_set_background_pattern = method12;
        isX11GTK = isX11 && null != OS_gtk_class;
    }
}

