/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicClock;
import com.sun.media.BasicController;
import com.sun.media.BasicFilterModule;
import com.sun.media.BasicJMD;
import com.sun.media.BasicModule;
import com.sun.media.BasicPlayer;
import com.sun.media.BasicRendererModule;
import com.sun.media.BasicSinkModule;
import com.sun.media.BasicSourceModule;
import com.sun.media.BasicTrackControl;
import com.sun.media.GraphNode;
import com.sun.media.InputConnector;
import com.sun.media.JMD;
import com.sun.media.Log;
import com.sun.media.Module;
import com.sun.media.ModuleListener;
import com.sun.media.OutputConnector;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.StateTransistor;
import com.sun.media.controls.BitRateAdapter;
import com.sun.media.controls.FramePositioningAdapter;
import com.sun.media.controls.FrameRateAdapter;
import com.sun.media.controls.ProgressControl;
import com.sun.media.controls.ProgressControlAdapter;
import com.sun.media.controls.StringControlAdapter;
import com.sun.media.protocol.Streamable;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.RTPInfo;
import com.sun.media.util.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.Demultiplexer;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.InternalErrorEvent;
import javax.media.Manager;
import javax.media.MediaTimeSetEvent;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.PlugIn;
import javax.media.Renderer;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.Track;
import javax.media.control.BitRateControl;
import javax.media.control.BufferControl;
import javax.media.control.FramePositioningControl;
import javax.media.control.FrameRateControl;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.renderer.VideoRenderer;
import javax.media.renderer.VisualContainer;

public class PlaybackEngine
extends BasicController
implements ModuleListener {
    protected BasicPlayer player;
    protected DataSource dsource;
    protected Vector modules;
    protected Vector filters;
    protected Vector sinks;
    protected Vector waitPrefetched;
    protected Vector waitStopped;
    protected Vector waitEnded;
    protected Vector waitResetted;
    protected Track[] tracks;
    protected Demultiplexer parser;
    protected BasicSinkModule masterSink = null;
    protected BasicSourceModule source;
    protected SlaveClock slaveClock;
    private boolean internalErrorOccurred = false;
    protected boolean prefetched = false;
    protected boolean started = false;
    private boolean dataPathBlocked = false;
    private boolean useMoreRenderBuffer = false;
    private boolean deallocated = false;
    public boolean prefetchEnabled = true;
    protected static boolean needSavingDB = false;
    private Time timeBeforeAbortPrefetch = null;
    private float rate = 1.0f;
    protected BitRateControl bitRateControl;
    protected FrameRateControl frameRateControl;
    protected FramePositioningControl framePositioningControl = null;
    private long latency = 0L;
    static boolean DEBUG = true;
    protected JMD jmd = null;
    protected Container container = null;
    public static boolean TRACE_ON = false;
    protected BasicTrackControl[] trackControls = new BasicTrackControl[0];
    protected ProgressControl progressControl;
    private long realizeTime;
    private long prefetchTime;
    static String NOT_CONFIGURED_ERROR;
    static String NOT_REALIZED_ERROR;
    static String STARTED_ERROR;
    String configError = "Failed to configure: " + this;
    String configIntError = "  The configure process is being interrupted.\n";
    String configInt2Error = "interrupted while the Processor is being configured.";
    String parseError = "failed to parse the input media.";
    protected String realizeError = "Failed to realize: " + this;
    protected String timeBaseError = "  Cannot manage the different time bases.\n";
    protected String genericProcessorError = "cannot handle the customized options set on the Processor.\nCheck jmf.log for full details.";
    String prefetchError = "Failed to prefetch: " + this;
    RTPInfo rtpInfo = null;
    boolean testedRTP = false;
    boolean prefetchLogged = false;
    long markedDataStartTime = 0L;
    boolean reportOnce = false;
    long lastBitRate = 0L;
    long lastStatsTime = 0L;
    static boolean USE_MASTER;
    static boolean USE_BACKUP;

    public static void setMemoryTrace(boolean on) {
        TRACE_ON = on;
    }

    public PlaybackEngine(BasicPlayer p) {
        long initTime = System.currentTimeMillis();
        this.player = p;
        this.createProgressControl();
        this.slaveClock = new SlaveClock();
        this.setClock(this.slaveClock);
        this.stopThreadEnabled = false;
        PlaybackEngine.profile("instantiation", initTime);
    }

    protected boolean isConfigurable() {
        return true;
    }

    public void setSource(DataSource ds) throws IOException, IncompatibleSourceException {
        try {
            this.source = BasicSourceModule.createModule(ds);
        }
        catch (IOException ioe) {
            Log.warning("Input DataSource: " + ds);
            Log.warning("  Failed with IO exception: " + ioe.getMessage());
            throw ioe;
        }
        catch (IncompatibleSourceException ise) {
            Log.warning("Input DataSource: " + ds);
            Log.warning("  is not compatible with the MediaEngine.");
            Log.warning("  It's likely that the DataSource is required to extend PullDataSource;");
            Log.warning("  and that its source streams implement the Seekable interface ");
            Log.warning("  and with random access capability.");
            throw ise;
        }
        if (this.source == null) {
            throw new IncompatibleSourceException();
        }
        if (DEBUG && this.jmd == null) {
            String jmdTitle = "PlugIn Viewer";
            if (ds != null && ds.getLocator() != null) {
                jmdTitle = ds.getLocator().toString();
                String protocol = ds.getLocator().getProtocol();
                if (protocol != null && ((protocol = protocol.toLowerCase()).equals("file") || protocol.startsWith("http") || protocol.equals("ftp"))) {
                    this.useMoreRenderBuffer = true;
                }
            }
            this.jmd = new BasicJMD(jmdTitle);
        }
        if (DEBUG) {
            this.source.setJMD(this.jmd);
        }
        this.source.setController(this);
        this.dsource = ds;
        if (this.dsource instanceof Streamable && !((Streamable)((Object)this.dsource)).isPrefetchable()) {
            this.prefetchEnabled = false;
            this.dataPathBlocked = true;
        }
        if (this.dsource instanceof CaptureDevice) {
            this.prefetchEnabled = false;
        }
    }

    protected boolean doConfigure() {
        if (!this.doConfigure1()) {
            return false;
        }
        String[] names = this.source.getOutputConnectorNames();
        this.trackControls = new BasicTrackControl[this.tracks.length];
        int i = 0;
        while (i < this.tracks.length) {
            this.trackControls[i] = new PlayerTControl(this, this.tracks[i], this.source.getOutputConnector(names[i]));
            ++i;
        }
        return this.doConfigure2();
    }

    protected boolean doConfigure1() {
        long parsingTime = System.currentTimeMillis();
        this.modules = new Vector();
        this.filters = new Vector();
        this.sinks = new Vector();
        this.waitPrefetched = new Vector();
        this.waitStopped = new Vector();
        this.waitEnded = new Vector();
        this.waitResetted = new Vector();
        this.source.setModuleListener(this);
        this.source.setController(this);
        this.modules.addElement(this.source);
        if (!this.source.doRealize()) {
            Log.error(this.configError);
            if (this.source.errMsg != null) {
                Log.error("  " + this.source.errMsg + "\n");
            }
            this.player.processError = this.parseError;
            return false;
        }
        if (this.isInterrupted()) {
            Log.error(this.configError);
            Log.error(this.configIntError);
            this.player.processError = this.configInt2Error;
            return false;
        }
        this.parser = this.source.getDemultiplexer();
        if (this.parser == null) {
            Log.error(this.configError);
            Log.error("  Cannot obtain demultiplexer for the source.\n");
            this.player.processError = this.parseError;
            return false;
        }
        try {
            this.tracks = this.parser.getTracks();
        }
        catch (Exception e) {
            Log.error(this.configError);
            Log.error("  Cannot obtain tracks from the demultiplexer: " + e + "\n");
            this.player.processError = this.parseError;
            return false;
        }
        if (this.isInterrupted()) {
            Log.error(this.configError);
            Log.error(this.configIntError);
            this.player.processError = this.configInt2Error;
            return false;
        }
        PlaybackEngine.profile("parsing", parsingTime);
        return true;
    }

    protected boolean doConfigure2() {
        Track master;
        if (this.parser.isPositionable() && this.parser.isRandomAccess() && (master = FramePositioningAdapter.getMasterTrack(this.tracks)) != null) {
            this.framePositioningControl = new FramePositioningAdapter(this.player, master);
        }
        return true;
    }

    protected synchronized boolean doRealize() {
        return this.doRealize1() && this.doRealize2();
    }

    protected boolean doRealize1() {
        Log.comment("Building flow graph for: " + this.dsource.getLocator() + "\n");
        this.realizeTime = System.currentTimeMillis();
        boolean atLeastOneTrack = false;
        int trackID = 0;
        int numTracks = this.getNumTracks();
        int i = 0;
        while (i < this.trackControls.length) {
            if (this.trackControls[i].isEnabled()) {
                Log.setIndent(0);
                Log.comment("Building Track: " + i);
                if (this.trackControls[i].buildTrack(trackID, numTracks)) {
                    atLeastOneTrack = true;
                    this.trackControls[i].setEnabled(true);
                } else {
                    if (this.trackControls[i].isCustomized()) {
                        Log.error(this.realizeError);
                        this.trackControls[i].prError();
                        this.player.processError = this.genericProcessorError;
                        return false;
                    }
                    this.trackControls[i].setEnabled(false);
                    Log.warning("Failed to handle track " + i);
                    this.trackControls[i].prError();
                }
                if (this.isInterrupted()) {
                    Log.error(this.realizeError);
                    Log.error("  The graph building process is being interrupted.\n");
                    this.player.processError = "interrupted while the player is being constructed.";
                    return false;
                }
                ++trackID;
                Log.write("\n");
            }
            ++i;
        }
        if (!atLeastOneTrack) {
            Log.error(this.realizeError);
            this.player.processError = "input media not supported: " + this.getCodecList();
            return false;
        }
        return true;
    }

    protected boolean doRealize2() {
        if (!this.manageTimeBases()) {
            Log.error(this.realizeError);
            Log.error(this.timeBaseError);
            this.player.processError = this.timeBaseError;
            return false;
        }
        Log.comment("Here's the completed flow graph:");
        this.traceGraph(this.source);
        Log.write("\n");
        PlaybackEngine.profile("graph building", this.realizeTime);
        this.realizeTime = System.currentTimeMillis();
        this.updateFormats();
        if (DEBUG) {
            this.jmd.initGraph(this.source);
        }
        PlaybackEngine.profile("realize, post graph building", this.realizeTime);
        return true;
    }

    String getCodecList() {
        String list = "";
        int i = 0;
        while (i < this.trackControls.length) {
            Format fmt = this.trackControls[i].getOriginalFormat();
            if (fmt != null && fmt.getEncoding() != null) {
                list = list + fmt.getEncoding();
                if (fmt instanceof VideoFormat) {
                    list = list + " video";
                } else if (fmt instanceof AudioFormat) {
                    list = list + " audio";
                }
                if (i + 1 < this.trackControls.length) {
                    list = list + ", ";
                }
            }
            ++i;
        }
        return list;
    }

    int getNumTracks() {
        int num = 0;
        int i = 0;
        while (i < this.trackControls.length) {
            if (this.trackControls[i].isEnabled()) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    boolean manageTimeBases() {
        this.masterSink = this.findMasterSink();
        return this.updateMasterTimeBase();
    }

    protected BasicSinkModule findMasterSink() {
        int i = 0;
        while (i < this.trackControls.length) {
            if (this.trackControls[i].isEnabled() && this.trackControls[i].rendererModule != null && this.trackControls[i].rendererModule.getClock() != null) {
                return this.trackControls[i].rendererModule;
            }
            ++i;
        }
        return null;
    }

    boolean updateMasterTimeBase() {
        int size = this.sinks.size();
        if (this.masterSink != null) {
            this.slaveClock.setMaster(this.masterSink.getClock());
        } else {
            this.slaveClock.setMaster(null);
        }
        int i = 0;
        while (i < size) {
            BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
            if (bsm != this.masterSink && !bsm.prefetchFailed()) {
                try {
                    bsm.setTimeBase(this.slaveClock.getTimeBase());
                }
                catch (IncompatibleTimeBaseException e) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected synchronized void abortConfigure() {
        if (this.source != null) {
            this.source.abortRealize();
        }
    }

    protected synchronized void abortRealize() {
        int size = this.modules.size();
        int i = 0;
        while (i < size) {
            StateTransistor m = (StateTransistor)this.modules.elementAt(i);
            m.abortRealize();
            ++i;
        }
    }

    protected synchronized void doFailedRealize() {
        int size = this.modules.size();
        int i = 0;
        while (i < size) {
            StateTransistor m = (StateTransistor)this.modules.elementAt(i);
            m.doFailedRealize();
            ++i;
        }
        super.doFailedRealize();
    }

    protected synchronized boolean doPrefetch() {
        if (this.prefetched) {
            return true;
        }
        return this.doPrefetch1() && this.doPrefetch2();
    }

    protected boolean doPrefetch1() {
        if (this.timeBeforeAbortPrefetch != null) {
            this.doSetMediaTime(this.timeBeforeAbortPrefetch);
            this.timeBeforeAbortPrefetch = null;
        }
        this.prefetchTime = System.currentTimeMillis();
        this.resetPrefetchedList();
        if (!this.source.doPrefetch()) {
            Log.error(this.prefetchError);
            if (this.dsource != null) {
                Log.error("  Cannot prefetch the source: " + this.dsource.getLocator() + "\n");
            }
            return false;
        }
        boolean atLeastOneTrack = false;
        int i = 0;
        while (i < this.trackControls.length) {
            boolean usedToFailed = this.trackControls[i].prefetchFailed;
            if (!usedToFailed || this.getState() <= 400) {
                if (this.trackControls[i].prefetchTrack()) {
                    atLeastOneTrack = true;
                    if (usedToFailed) {
                        if (!this.manageTimeBases()) {
                            Log.error(this.prefetchError);
                            Log.error(this.timeBaseError);
                            return false;
                        }
                        this.doSetMediaTime(this.getMediaTime());
                    }
                } else {
                    this.trackControls[i].prError();
                    if (this.trackControls[i].isTimeBase() && !this.manageTimeBases()) {
                        Log.error(this.prefetchError);
                        Log.error(this.timeBaseError);
                        this.player.processError = this.timeBaseError;
                        return false;
                    }
                    if (this.trackControls[i].getFormat() instanceof AudioFormat && this.trackControls[i].rendererFailed) {
                        this.player.processError = "cannot open the audio device.";
                    }
                }
            }
            ++i;
        }
        if (!atLeastOneTrack) {
            Log.error(this.prefetchError);
            return false;
        }
        this.player.processError = null;
        return true;
    }

    protected boolean doPrefetch2() {
        if (this.prefetchEnabled) {
            Vector vector = this.waitPrefetched;
            synchronized (vector) {
                this.source.doStart();
                try {
                    if (!this.waitPrefetched.isEmpty()) {
                        this.waitPrefetched.wait(3000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.prefetched = true;
        this.deallocated = false;
        return true;
    }

    protected synchronized void abortPrefetch() {
        this.timeBeforeAbortPrefetch = this.getMediaTime();
        this.doReset();
        int size = this.modules.size();
        int i = 0;
        while (i < size) {
            StateTransistor m = (StateTransistor)this.modules.elementAt(i);
            m.abortPrefetch();
            ++i;
        }
        this.deallocated = true;
    }

    protected synchronized void doFailedPrefetch() {
        int size = this.modules.size();
        int i = 0;
        while (i < size) {
            StateTransistor m = (StateTransistor)this.modules.elementAt(i);
            m.doFailedPrefetch();
            ++i;
        }
        super.doFailedPrefetch();
    }

    protected synchronized void doStart() {
        if (this.started) {
            return;
        }
        this.doStart1();
        this.doStart2();
    }

    protected void doStart1() {
        if (this.dsource instanceof CaptureDevice || this.isRTP()) {
            this.reset();
        }
        this.resetPrefetchedList();
        this.resetStoppedList();
        this.resetEndedList();
        int i = 0;
        while (i < this.trackControls.length) {
            if (this.trackControls[i].isEnabled()) {
                this.trackControls[i].startTrack();
            }
            ++i;
        }
    }

    protected void doStart2() {
        this.source.doStart();
        this.started = true;
        this.prefetched = true;
    }

    public synchronized void stop() {
        super.stop();
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    protected synchronized void localStop() {
        super.stop();
    }

    protected synchronized void doStop() {
        if (!this.started) {
            return;
        }
        this.doStop1();
        this.doStop2();
    }

    protected void doStop1() {
        this.resetPrefetchedList();
        this.source.doStop();
        int i = 0;
        while (i < this.trackControls.length) {
            if (this.trackControls[i].isEnabled()) {
                this.trackControls[i].stopTrack();
            }
            ++i;
        }
    }

    protected void doStop2() {
        if (!this.prefetchEnabled) {
            this.source.pause();
        }
        this.started = false;
    }

    public void setStopTime(Time t) {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("Cannot set stop time on an unrealized controller."));
        }
        if (this.getStopTime() != null && this.getStopTime().getNanoseconds() != t.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, t));
        }
        if (this.getState() == 600 && t != Clock.RESET && t.getNanoseconds() < this.getMediaNanoseconds()) {
            this.localStop();
            this.setStopTime(Clock.RESET);
            this.sendEvent(new StopAtTimeEvent(this, this.getState(), 500, this.getTargetState(), this.getMediaTime()));
        } else {
            this.getClock().setStopTime(t);
            int size = this.sinks.size();
            int i = 0;
            while (i < size) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
                bsm.setStopTime(t);
                ++i;
            }
        }
    }

    protected void doDeallocate() {
    }

    protected synchronized void doClose() {
        if (this.modules == null) {
            if (this.source != null) {
                this.source.doClose();
            }
            return;
        }
        if (this.getState() == 600) {
            this.localStop();
        }
        if (this.getState() == 500) {
            this.doReset();
        }
        int size = this.modules.size();
        int i = 0;
        while (i < size) {
            StateTransistor m = (StateTransistor)this.modules.elementAt(i);
            m.doClose();
            ++i;
        }
        if (needSavingDB) {
            Resource.saveDB();
            needSavingDB = false;
        }
    }

    public boolean isRTP() {
        if (this.testedRTP) {
            return this.rtpInfo != null;
        }
        this.rtpInfo = (RTPInfo)this.dsource.getControl("com.sun.media.util.RTPInfo");
        this.testedRTP = true;
        return this.rtpInfo != null;
    }

    public String getCNAME() {
        if (this.rtpInfo == null && (this.rtpInfo = (RTPInfo)this.dsource.getControl("com.sun.media.util.RTPInfo")) == null) {
            return null;
        }
        return this.rtpInfo.getCNAME();
    }

    public synchronized void setMediaTime(Time when) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set media time on a unrealized controller"));
        }
        if (when.getNanoseconds() == this.getMediaNanoseconds()) {
            return;
        }
        this.reset();
        this.timeBeforeAbortPrefetch = null;
        this.doSetMediaTime(when);
        this.doPrefetch();
        this.sendEvent(new MediaTimeSetEvent(this, when));
    }

    protected void doSetMediaTime(Time when) {
        this.slaveClock.setMediaTime(when);
        Time t = this.source.setPosition(when, 0);
        if (t == null) {
            t = when;
        }
        int size = this.sinks.size();
        int i = 0;
        while (i < size) {
            BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
            bsm.doSetMediaTime(when);
            bsm.setPreroll(when.getNanoseconds(), t.getNanoseconds());
            ++i;
        }
    }

    public synchronized float doSetRate(float r) {
        if (r <= 0.0f) {
            r = 1.0f;
        }
        if (r == this.rate) {
            return r;
        }
        r = this.masterSink == null ? this.getClock().setRate(r) : this.masterSink.doSetRate(r);
        int size = this.modules.size();
        int i = 0;
        while (i < size) {
            BasicModule m = (BasicModule)this.modules.elementAt(i);
            if (m != this.masterSink) {
                m.doSetRate(r);
            }
            ++i;
        }
        this.rate = r;
        return r;
    }

    protected synchronized void reset() {
        if (this.started || !this.prefetched || this.dataPathBlocked) {
            return;
        }
        this.doReset();
    }

    protected synchronized void doReset() {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            BasicSinkModule bsm;
            this.resetResettedList();
            int size = this.modules.size();
            int i = size - 1;
            while (i >= 0) {
                BasicModule m = (BasicModule)this.modules.elementAt(i);
                if (!m.prefetchFailed()) {
                    m.reset();
                }
                --i;
            }
            size = this.sinks.size();
            int i2 = 0;
            while (i2 < size) {
                bsm = (BasicSinkModule)this.sinks.elementAt(i2);
                if (!bsm.prefetchFailed()) {
                    bsm.triggerReset();
                }
                ++i2;
            }
            if (!this.waitResetted.isEmpty()) {
                try {
                    this.waitResetted.wait(3000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            size = this.sinks.size();
            int i3 = 0;
            while (i3 < size) {
                bsm = (BasicSinkModule)this.sinks.elementAt(i3);
                if (!bsm.prefetchFailed()) {
                    bsm.doneReset();
                }
                ++i3;
            }
        }
        this.prefetched = false;
    }

    private void resetPrefetchedList() {
        Vector vector = this.waitPrefetched;
        synchronized (vector) {
            this.waitPrefetched.removeAllElements();
            int size = this.sinks.size();
            int i = 0;
            while (i < size) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
                if (!bsm.prefetchFailed()) {
                    this.waitPrefetched.addElement(bsm);
                }
                ++i;
            }
            this.waitPrefetched.notifyAll();
        }
    }

    private void resetStoppedList() {
        Vector vector = this.waitStopped;
        synchronized (vector) {
            this.waitStopped.removeAllElements();
            int size = this.sinks.size();
            int i = 0;
            while (i < size) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
                if (!bsm.prefetchFailed()) {
                    this.waitStopped.addElement(bsm);
                }
                ++i;
            }
            this.waitStopped.notifyAll();
        }
    }

    private void resetEndedList() {
        Vector vector = this.waitEnded;
        synchronized (vector) {
            this.waitEnded.removeAllElements();
            int size = this.sinks.size();
            int i = 0;
            while (i < size) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
                if (!bsm.prefetchFailed()) {
                    this.waitEnded.addElement(bsm);
                }
                ++i;
            }
            this.waitEnded.notifyAll();
        }
    }

    private void resetResettedList() {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            this.waitResetted.removeAllElements();
            int size = this.sinks.size();
            int i = 0;
            while (i < size) {
                BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
                if (!bsm.prefetchFailed()) {
                    this.waitResetted.addElement(bsm);
                }
                ++i;
            }
            this.waitResetted.notifyAll();
        }
    }

    public void bufferPrefetched(Module src) {
        if (!this.prefetchEnabled) {
            return;
        }
        if (src instanceof BasicSinkModule) {
            Vector vector = this.waitPrefetched;
            synchronized (vector) {
                if (this.waitPrefetched.contains(src)) {
                    this.waitPrefetched.removeElement(src);
                }
                if (this.waitPrefetched.isEmpty()) {
                    this.waitPrefetched.notifyAll();
                    if (!this.prefetchLogged) {
                        PlaybackEngine.profile("prefetch", this.prefetchTime);
                        this.prefetchLogged = true;
                    }
                    if (this.getState() != 600 && this.getTargetState() != 600) {
                        this.source.pause();
                    }
                    this.prefetched = true;
                }
            }
        }
    }

    public void stopAtTime(Module src) {
        if (src instanceof BasicSinkModule) {
            Vector vector = this.waitStopped;
            synchronized (vector) {
                if (this.waitStopped.contains(src)) {
                    this.waitStopped.removeElement(src);
                }
                if (this.waitStopped.isEmpty() || this.waitEnded.size() == 1 && this.waitEnded.contains(src)) {
                    this.started = false;
                    this.stopControllerOnly();
                    this.setStopTime(Clock.RESET);
                    this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                    this.slaveClock.reset(USE_MASTER);
                } else if (src == this.masterSink) {
                    this.slaveClock.reset(USE_BACKUP);
                }
            }
        }
    }

    public void mediaEnded(Module src) {
        if (src instanceof BasicSinkModule) {
            Vector vector = this.waitEnded;
            synchronized (vector) {
                if (this.waitEnded.contains(src)) {
                    this.waitEnded.removeElement(src);
                }
                if (this.waitEnded.isEmpty()) {
                    this.started = false;
                    this.stopControllerOnly();
                    this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                    this.slaveClock.reset(USE_MASTER);
                } else if (src == this.masterSink) {
                    this.slaveClock.reset(USE_BACKUP);
                }
            }
        }
    }

    public void resetted(Module src) {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            if (this.waitResetted.contains(src)) {
                this.waitResetted.removeElement(src);
            }
            if (this.waitResetted.isEmpty()) {
                this.waitResetted.notifyAll();
            }
        }
    }

    public void dataBlocked(Module src, boolean blocked) {
        this.dataPathBlocked = blocked;
        if (blocked) {
            this.resetPrefetchedList();
            this.resetResettedList();
        }
        if (this.getTargetState() != 600) {
            return;
        }
        if (blocked) {
            this.localStop();
            this.setTargetState(600);
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        } else {
            this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), this.getTimeBase().getTime()));
        }
    }

    public void framesBehind(Module src, float frames, InputConnector ic) {
        while (ic != null) {
            OutputConnector oc = ic.getOutputConnector();
            if (oc == null || (src = oc.getModule()) == null || !(src instanceof BasicFilterModule)) break;
            BasicFilterModule bfm = (BasicFilterModule)src;
            bfm.setFramesBehind(frames);
            ic = src.getInputConnector(null);
        }
    }

    public void markedDataArrived(Module src, Buffer buffer) {
        if (src instanceof BasicSourceModule) {
            this.markedDataStartTime = this.getMediaNanoseconds();
        } else {
            long t = this.getMediaNanoseconds() - this.markedDataStartTime;
            if (t > 0L && t < 1000000000L) {
                if (!this.reportOnce) {
                    Log.comment("Computed latency for video: " + t / 1000000L + " ms\n");
                    this.reportOnce = true;
                }
                this.latency = (t + this.latency) / 2L;
            }
        }
    }

    public void formatChanged(Module src, Format oldFormat, Format newFormat) {
        Log.comment(src + ": input format changed: " + newFormat);
        if (src instanceof BasicRendererModule && oldFormat instanceof VideoFormat && newFormat instanceof VideoFormat) {
            Dimension s1 = ((VideoFormat)oldFormat).getSize();
            Dimension s2 = ((VideoFormat)newFormat).getSize();
            if (!(s2 == null || s1 != null && s1.equals(s2))) {
                this.sendEvent(new SizeChangeEvent(this, s2.width, s2.height, 1.0f));
            }
        }
    }

    public void formatChangedFailure(Module src, Format oldFormat, Format newFormat) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new InternalErrorEvent(this, "Internal module " + src + ": failed to handle a data format change!"));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    public void pluginTerminated(Module src) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new ControllerClosedEvent(this));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    public void internalErrorOccurred(Module src) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new InternalErrorEvent(this, "Internal module " + src + " failed!"));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    public boolean audioEnabled() {
        int i = 0;
        while (i < this.trackControls.length) {
            if (this.trackControls[i].isEnabled() && this.trackControls[i].getOriginalFormat() instanceof AudioFormat) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean videoEnabled() {
        int i = 0;
        while (i < this.trackControls.length) {
            if (this.trackControls[i].isEnabled() && this.trackControls[i].getOriginalFormat() instanceof VideoFormat) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Control[] getControls() {
        Vector<Object> cv = new Vector<Object>();
        int size = this.modules == null ? 0 : this.modules.size();
        int otherSize = 0;
        int i = 0;
        while (i < size) {
            Module m = (Module)this.modules.elementAt(i);
            Object[] cs = m.getControls();
            if (cs != null) {
                int j = 0;
                while (j < cs.length) {
                    cv.addElement(cs[j]);
                    ++j;
                }
            }
            ++i;
        }
        size = cv.size();
        if (this.videoEnabled() && this.frameRateControl == null) {
            this.frameRateControl = new FrameRateAdapter(this.player, 0.0f, 0.0f, 30.0f, false){

                public float setFrameRate(float rate) {
                    this.value = rate;
                    return -1.0f;
                }

                public Component getControlComponent() {
                    return null;
                }

                public Object getOwner() {
                    return PlaybackEngine.this.player;
                }
            };
        }
        if (this.bitRateControl == null) {
            this.bitRateControl = new BitRateA(0, -1, -1, false);
        }
        if (this.frameRateControl != null) {
            ++otherSize;
        }
        if (this.bitRateControl != null) {
            ++otherSize;
        }
        if (this.framePositioningControl != null) {
            ++otherSize;
        }
        if (DEBUG) {
            ++otherSize;
        }
        Control[] controls = new Control[size + otherSize + this.trackControls.length];
        i = 0;
        while (i < size) {
            controls[i] = (Control)cv.elementAt(i);
            ++i;
        }
        if (this.bitRateControl != null) {
            controls[size++] = this.bitRateControl;
        }
        if (this.frameRateControl != null) {
            controls[size++] = this.frameRateControl;
        }
        if (this.framePositioningControl != null) {
            controls[size++] = this.framePositioningControl;
        }
        if (DEBUG) {
            controls[size++] = this.jmd;
        }
        i = 0;
        while (i < this.trackControls.length) {
            controls[size + i] = this.trackControls[i];
            ++i;
        }
        return controls;
    }

    public GainControl getGainControl() {
        return (GainControl)this.getControl("javax.media.GainControl");
    }

    public Component getVisualComponent() {
        Vector<Component> visuals = new Vector<Component>(1);
        if (this.modules == null) {
            return null;
        }
        int i = 0;
        while (i < this.modules.size()) {
            Component comp;
            BasicModule bm = (BasicModule)this.modules.elementAt(i);
            PlugIn pi = this.getPlugIn(bm);
            if (pi instanceof VideoRenderer && (comp = ((VideoRenderer)pi).getComponent()) != null) {
                visuals.addElement(comp);
            }
            ++i;
        }
        if (visuals.size() == 0) {
            return null;
        }
        if (visuals.size() == 1) {
            return (Component)visuals.elementAt(0);
        }
        return this.createVisualContainer(visuals);
    }

    protected Component createVisualContainer(Vector visuals) {
        Boolean hint = (Boolean)Manager.getHint(3);
        if (this.container == null) {
            this.container = hint == null || hint == false ? new HeavyPanel(visuals) : new LightPanel(visuals);
            this.container.setLayout(new FlowLayout());
            this.container.setBackground(Color.black);
            int i = 0;
            while (i < visuals.size()) {
                Component c = (Component)visuals.elementAt(i);
                this.container.add(c);
                c.setSize(c.getPreferredSize());
                ++i;
            }
        }
        return this.container;
    }

    public Time getStartLatency() {
        if (this.state == 100 || this.state == 200) {
            this.throwError(new NotRealizedError("Cannot get start latency from an unrealized controller"));
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public long getLatency() {
        return this.latency;
    }

    public Time getDuration() {
        return this.source.getDuration();
    }

    public void setProgressControl(ProgressControl p) {
        this.progressControl = p;
    }

    public void createProgressControl() {
        StringControlAdapter frameRate = new StringControlAdapter();
        frameRate.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter bitRate = new StringControlAdapter();
        bitRate.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter videoProps = new StringControlAdapter();
        videoProps.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter audioProps = new StringControlAdapter();
        audioProps.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter audioCodec = new StringControlAdapter();
        audioCodec.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter videoCodec = new StringControlAdapter();
        videoCodec.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        this.progressControl = new ProgressControlAdapter(frameRate, bitRate, videoProps, audioProps, videoCodec, audioCodec);
    }

    public void updateFormats() {
        int i = 0;
        while (i < this.trackControls.length) {
            this.trackControls[i].updateFormat();
            ++i;
        }
    }

    public void updateRates() {
        if (this.getState() < 300) {
            return;
        }
        long now = System.currentTimeMillis();
        long rate = now == this.lastStatsTime ? this.lastBitRate : (long)((double)this.getBitRate() * 8.0 / (double)(now - this.lastStatsTime) * 1000.0);
        long avg = (this.lastBitRate + rate) / 2L;
        if (this.bitRateControl != null) {
            this.bitRateControl.setBitRate((int)avg);
        }
        this.lastBitRate = rate;
        this.lastStatsTime = now;
        this.resetBitRate();
        int i = 0;
        while (i < this.trackControls.length) {
            this.trackControls[i].updateRates(now);
            ++i;
        }
        this.source.checkLatency();
    }

    protected long getBitRate() {
        return this.source.getBitsRead();
    }

    protected void resetBitRate() {
        this.source.resetBitsRead();
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        this.getClock().setTimeBase(tb);
        if (this.sinks == null) {
            return;
        }
        int size = this.sinks.size();
        int i = 0;
        while (i < size) {
            BasicSinkModule bsm = (BasicSinkModule)this.sinks.elementAt(i);
            bsm.setTimeBase(tb);
            ++i;
        }
    }

    public TimeBase getTimeBase() {
        return this.getClock().getTimeBase();
    }

    protected GraphNode buildTrackFromGraph(BasicTrackControl tc, GraphNode node) {
        BasicModule src = null;
        BasicModule dst = null;
        InputConnector ic = null;
        OutputConnector oc = null;
        boolean lastNode = true;
        Vector used = new Vector(5);
        int indent = 0;
        if (node.plugin == null) {
            return null;
        }
        Log.setIndent(indent++);
        while (node != null && node.plugin != null) {
            src = this.createModule(node, used);
            if (src == null) {
                Log.error("Internal error: buildTrackFromGraph");
                node.failed = true;
                return node;
            }
            if (lastNode) {
                if (src instanceof BasicRendererModule) {
                    tc.rendererModule = (BasicRendererModule)src;
                    if (this.useMoreRenderBuffer && tc.rendererModule.getRenderer() instanceof AudioRenderer) {
                        this.setRenderBufferSize(tc.rendererModule.getRenderer());
                    }
                } else if (src instanceof BasicFilterModule) {
                    tc.lastOC = src.getOutputConnector(null);
                    tc.lastOC.setFormat(node.output);
                }
                lastNode = false;
            }
            ic = src.getInputConnector(null);
            ic.setFormat(node.input);
            if (dst != null) {
                oc = src.getOutputConnector(null);
                ic = dst.getInputConnector(null);
                oc.setFormat(ic.getFormat());
            }
            src.setController(this);
            if (!src.doRealize()) {
                Log.setIndent(indent--);
                node.failed = true;
                return node;
            }
            if (oc != null && ic != null) {
                this.connectModules(oc, ic, dst);
            }
            dst = src;
            node = node.prev;
        }
        dst = src;
        do {
            dst.setModuleListener(this);
            this.modules.addElement(dst);
            tc.modules.addElement(dst);
            if (dst instanceof BasicFilterModule) {
                this.filters.addElement(dst);
                continue;
            }
            if (!(dst instanceof BasicSinkModule)) continue;
            this.sinks.addElement(dst);
        } while ((oc = dst.getOutputConnector(null)) != null && (ic = oc.getInputConnector()) != null && (dst = (BasicModule)ic.getModule()) != null);
        tc.firstOC.setFormat(tc.getOriginalFormat());
        ic = src.getInputConnector(null);
        Format fmt = ic.getFormat();
        if (fmt == null || !fmt.equals(tc.getOriginalFormat())) {
            ic.setFormat(tc.getOriginalFormat());
        }
        this.connectModules(tc.firstOC, ic, src);
        Log.setIndent(indent--);
        return null;
    }

    protected void setRenderBufferSize(Renderer r) {
        BufferControl bc = (BufferControl)r.getControl("javax.media.control.BufferControl");
        if (bc != null) {
            bc.setBufferLength(2000L);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected BasicModule lastModule(BasicModule bm) {
        InputConnector ic;
        OutputConnector oc = bm.getOutputConnector(null);
        while (oc != null && (ic = oc.getInputConnector()) != null) {
            void var3_3;
            bm = (BasicModule)var3_3.getModule();
            oc = bm.getOutputConnector(null);
        }
        return bm;
    }

    protected BasicModule createModule(GraphNode n, Vector used) {
        PlugIn p;
        BasicModule m = null;
        if (n.plugin == null) {
            return null;
        }
        if (used.contains(n.plugin)) {
            if (n.cname == null || (p = SimpleGraphBuilder.createPlugIn(n.cname, -1)) == null) {
                Log.write("Failed to instantiate " + n.cname);
                return null;
            }
        } else {
            p = n.plugin;
            used.addElement(p);
        }
        if ((n.type == -1 || n.type == 4) && p instanceof Renderer) {
            m = new BasicRendererModule((Renderer)p);
        } else if ((n.type == -1 || n.type == 2) && p instanceof Codec) {
            m = new BasicFilterModule((Codec)p);
        }
        if (DEBUG && m != null) {
            m.setJMD(this.jmd);
        }
        return m;
    }

    protected void connectModules(OutputConnector oc, InputConnector ic, BasicModule dst) {
        if (dst instanceof BasicRendererModule) {
            oc.setProtocol(ic.getProtocol());
        } else {
            ic.setProtocol(oc.getProtocol());
        }
        oc.connectTo(ic, ic.getFormat());
    }

    static boolean isRawVideo(Format fmt) {
        return fmt instanceof RGBFormat || fmt instanceof YUVFormat;
    }

    void traceGraph(BasicModule source) {
        String[] names = source.getOutputConnectorNames();
        int i = 0;
        while (i < names.length) {
            Module m;
            OutputConnector oc = source.getOutputConnector(names[i]);
            InputConnector ic = oc.getInputConnector();
            if (ic != null && (m = ic.getModule()) != null) {
                Log.write("  " + this.getPlugIn(source));
                Log.write("     connects to: " + this.getPlugIn((BasicModule)m));
                Log.write("     format: " + oc.getFormat());
                this.traceGraph((BasicModule)m);
            }
            ++i;
        }
    }

    protected PlugIn getPlugIn(BasicModule m) {
        if (m instanceof BasicSourceModule) {
            return ((BasicSourceModule)m).getDemultiplexer();
        }
        if (m instanceof BasicFilterModule) {
            return ((BasicFilterModule)m).getCodec();
        }
        if (m instanceof BasicRendererModule) {
            return ((BasicRendererModule)m).getRenderer();
        }
        return null;
    }

    static void profile(String msg, long time) {
        Log.profile("Profile: " + msg + ": " + (System.currentTimeMillis() - time) + " ms\n");
    }

    static {
        try {
            Toolkit.getDefaultToolkit();
        }
        catch (Throwable t) {
            DEBUG = false;
        }
        NOT_CONFIGURED_ERROR = "cannot be called before configured";
        NOT_REALIZED_ERROR = "cannot be called before realized";
        STARTED_ERROR = "cannot be called after started";
        USE_MASTER = true;
        USE_BACKUP = false;
    }

    class LightPanel
    extends Container
    implements VisualContainer {
        public LightPanel(Vector visuals) {
        }
    }

    class HeavyPanel
    extends Panel
    implements VisualContainer {
        public HeavyPanel(Vector visuals) {
        }
    }

    class PlayerGraphBuilder
    extends SimpleGraphBuilder {
        protected PlaybackEngine engine;

        PlayerGraphBuilder(PlaybackEngine engine) {
            this.engine = engine;
        }

        protected GraphNode buildTrackFromGraph(BasicTrackControl tc, GraphNode node) {
            return this.engine.buildTrackFromGraph((PlayerTControl)tc, node);
        }
    }

    class PlayerTControl
    extends BasicTrackControl
    implements Owned {
        protected PlayerGraphBuilder gb;

        public PlayerTControl(PlaybackEngine engine, Track track, OutputConnector oc) {
            super(engine, track, oc);
        }

        public Object getOwner() {
            return PlaybackEngine.this.player;
        }

        public boolean buildTrack(int trackID, int numTracks) {
            if (this.gb == null) {
                this.gb = new PlayerGraphBuilder(this.engine);
            } else {
                this.gb.reset();
            }
            boolean rtn = this.gb.buildGraph(this);
            this.gb = null;
            return rtn;
        }

        public boolean isTimeBase() {
            int j = 0;
            while (j < this.modules.size()) {
                if (this.modules.elementAt(j) == PlaybackEngine.this.masterSink) {
                    return true;
                }
                ++j;
            }
            return false;
        }

        protected ProgressControl progressControl() {
            return PlaybackEngine.this.progressControl;
        }

        protected FrameRateControl frameRateControl() {
            return PlaybackEngine.this.frameRateControl;
        }
    }

    class SlaveClock
    implements Clock {
        Clock master;
        Clock current;
        BasicClock backup = new BasicClock();

        SlaveClock() {
            this.current = this.backup;
        }

        public void setMaster(Clock master) {
            this.master = master;
            Clock clock = this.current = master == null ? this.backup : master;
            if (master != null) {
                try {
                    this.backup.setTimeBase(master.getTimeBase());
                }
                catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                    // empty catch block
                }
            }
        }

        public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setTimeBase(tb);
            }
        }

        public void syncStart(Time tbt) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                if (this.backup.getState() != 1) {
                    this.backup.syncStart(tbt);
                }
            }
        }

        public void stop() {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.stop();
            }
        }

        public void setStopTime(Time t) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setStopTime(t);
            }
        }

        public Time getStopTime() {
            return this.backup.getStopTime();
        }

        public void setMediaTime(Time now) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                if (this.backup.getState() == 1) {
                    this.backup.stop();
                    this.backup.setMediaTime(now);
                    this.backup.syncStart(this.backup.getTimeBase().getTime());
                } else {
                    this.backup.setMediaTime(now);
                }
            }
        }

        public Time getMediaTime() {
            return this.current.getMediaTime();
        }

        public long getMediaNanoseconds() {
            return this.current.getMediaNanoseconds();
        }

        public Time getSyncTime() {
            return this.current.getSyncTime();
        }

        public TimeBase getTimeBase() {
            return this.current.getTimeBase();
        }

        public Time mapToTimeBase(Time t) throws ClockStoppedException {
            return this.current.mapToTimeBase(t);
        }

        public float setRate(float factor) {
            return this.backup.setRate(factor);
        }

        public float getRate() {
            return this.current.getRate();
        }

        protected void reset(boolean useMaster) {
            if (this.master != null && useMaster) {
                this.current = this.master;
            } else {
                if (this.master != null) {
                    BasicClock basicClock = this.backup;
                    synchronized (basicClock) {
                        boolean started = false;
                        if (this.backup.getState() == 1) {
                            this.backup.stop();
                            started = true;
                        }
                        this.backup.setMediaTime(this.master.getMediaTime());
                        if (started) {
                            this.backup.syncStart(this.backup.getTimeBase().getTime());
                        }
                    }
                }
                this.current = this.backup;
            }
        }
    }

    class BitRateA
    extends BitRateAdapter
    implements Owned {
        public BitRateA(int initialBitRate, int minBitRate, int maxBitRate, boolean settable) {
            super(initialBitRate, minBitRate, maxBitRate, settable);
        }

        public int setBitRate(int rate) {
            this.value = rate;
            return this.value;
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return PlaybackEngine.this.player;
        }
    }
}

