/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.core.module.id;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

public class ModuleId
implements Comparable<ModuleId> {
    private static final Map<ModuleId, WeakReference<ModuleId>> CACHE = new WeakHashMap<ModuleId, WeakReference<ModuleId>>();
    private String organisation;
    private String name;
    private int hash;
    private Map<String, String> attributes = new HashMap<String, String>();
    public static final Pattern MID_PATTERN = Pattern.compile("([a-zA-Z0-9\\-/\\._+=]*)#([a-zA-Z0-9\\-/\\._+=]+)");

    public static ModuleId newInstance(String org, String name) {
        return ModuleId.intern(new ModuleId(org, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleId intern(ModuleId moduleId) {
        ModuleId r = null;
        Map<ModuleId, WeakReference<ModuleId>> map = CACHE;
        synchronized (map) {
            WeakReference<ModuleId> ref = CACHE.get(moduleId);
            if (ref != null) {
                r = (ModuleId)ref.get();
            }
            if (r == null) {
                r = moduleId;
                CACHE.put(r, new WeakReference<ModuleId>(r));
            }
        }
        return r;
    }

    public ModuleId(String organisation, String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name not allowed");
        }
        this.organisation = organisation;
        this.name = name;
        this.attributes.put("organisation", organisation);
        this.attributes.put("module", name);
    }

    public String getName() {
        return this.name;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleId)) {
            return false;
        }
        ModuleId other = (ModuleId)obj;
        return other.organisation == null ? this.organisation == null && other.name.equals(this.name) : other.organisation.equals(this.organisation) && other.name.equals(this.name);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31;
            this.hash = this.hash * 13 + (this.organisation == null ? 0 : this.organisation.hashCode());
            this.hash = this.hash * 13 + this.name.hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return this.organisation + "#" + this.name;
    }

    @Override
    public int compareTo(ModuleId that) {
        int result = this.organisation.compareTo(that.organisation);
        if (result == 0) {
            result = this.name.compareTo(that.name);
        }
        return result;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

