/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.engine.api;

import java.lang.ref.WeakReference;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;

public final class ReferenceChain {
    private WeakReference<Object> obj;
    ReferenceChain next;
    private Heap heap;
    private long id;
    private char type;
    private static char TYPE_INSTANCE = '\u0000';
    private static char TYPE_CLASS = '\u0001';

    public ReferenceChain(Heap heap, Object object, ReferenceChain referenceChain) {
        this.obj = new WeakReference<Object>(object);
        this.next = referenceChain;
        this.heap = heap;
        if (object instanceof Instance) {
            this.type = TYPE_INSTANCE;
            this.id = ((Instance)object).getInstanceId();
        } else if (object instanceof JavaClass) {
            this.type = TYPE_CLASS;
            this.id = ((JavaClass)object).getJavaClassId();
        }
    }

    public Object getObj() {
        Object object = this.obj.get();
        if (object == null) {
            if (this.type == TYPE_INSTANCE) {
                object = this.heap.getInstanceByID(this.id);
            } else if (this.type == TYPE_CLASS) {
                object = this.heap.getJavaClassByID(this.id);
            }
            this.obj = new WeakReference(object);
        }
        return object;
    }

    public ReferenceChain getNext() {
        return this.next;
    }

    public boolean contains(Object object) {
        ReferenceChain referenceChain = this;
        while (referenceChain != null) {
            if (referenceChain.getObj().equals(object)) {
                return true;
            }
            referenceChain = referenceChain.next;
        }
        return false;
    }

    public int getDepth() {
        int n = 1;
        ReferenceChain referenceChain = this.next;
        while (referenceChain != null) {
            ++n;
            referenceChain = referenceChain.next;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.obj instanceof Instance) {
            Instance instance = (Instance)this.obj;
            stringBuilder.append(instance.getJavaClass().getName()).append("#").append(instance.getInstanceNumber());
        } else if (this.obj instanceof JavaClass) {
            stringBuilder.append("class of ").append(((JavaClass)this.obj).getName());
        }
        stringBuilder.append(this.next != null ? "->" + this.next.toString() : "");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReferenceChain referenceChain = (ReferenceChain)object;
        if (!(this.obj == referenceChain.obj || this.obj != null && this.obj.equals(referenceChain.obj))) {
            return false;
        }
        return this.next == referenceChain.next || this.next != null && this.next.equals(referenceChain.next);
    }

    public int hashCode() {
        int n = 3;
        n = 79 * n + (this.obj != null ? this.obj.hashCode() : 0);
        n = 79 * n + (this.next != null ? this.next.hashCode() : 0);
        return n;
    }
}

