/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.spi.ArchiveRootProvider;
import org.openide.util.Exceptions;

final class JarArchiveRootProvider
implements ArchiveRootProvider {
    private static final String PROTOCOL = "jar";
    private static byte[] ZIP_HEADER_1 = new byte[]{80, 75, 3, 4};
    private static byte[] ZIP_HEADER_2 = new byte[]{80, 75, 5, 6};
    private static final Logger LOG = Logger.getLogger(JarArchiveRootProvider.class.getName());
    private static final Map<FileObject, Boolean> archiveFileCache = Collections.synchronizedMap(new WeakHashMap());

    JarArchiveRootProvider() {
    }

    @Override
    public boolean isArchiveFile(URL uRL, boolean bl) {
        if (PROTOCOL.equals(uRL.getProtocol())) {
            return false;
        }
        FileObject fileObject = URLMapper.findFileObject(uRL);
        if (fileObject != null && !fileObject.isVirtual()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "isArchiveFile_FILE_RESOLVED", fileObject);
            }
            return this.isArchiveFile(fileObject, bl);
        }
        return JarArchiveRootProvider.isArchiveFile(uRL.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isArchiveFile(FileObject fileObject, boolean bl) {
        if (!fileObject.isValid()) {
            return JarArchiveRootProvider.isArchiveFile(fileObject.getPath());
        }
        if (fileObject.isVirtual()) {
            return JarArchiveRootProvider.isArchiveFile(fileObject.getPath());
        }
        if (fileObject.isFolder()) {
            return false;
        }
        Boolean bl2 = archiveFileCache.get(fileObject);
        if (bl2 != null) return bl2;
        try (InputStream inputStream = fileObject.getInputStream();){
            byte[] byArray = new byte[4];
            int n = inputStream.read(byArray, 0, 4);
            if (n != 4) {
                boolean bl3 = !bl;
                return bl3;
            }
            bl2 = Arrays.equals(ZIP_HEADER_1, byArray) || Arrays.equals(ZIP_HEADER_2, byArray);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, null, iOException);
        }
        if (bl2 == null) {
            bl2 = JarArchiveRootProvider.isArchiveFile(fileObject.getPath());
        }
        archiveFileCache.put(fileObject, bl2);
        return bl2;
    }

    @Override
    public boolean isArchiveArtifact(URL uRL) {
        return PROTOCOL.equals(uRL.getProtocol());
    }

    @Override
    public URL getArchiveFile(URL uRL) {
        String string;
        int n;
        String string2 = uRL.getProtocol();
        if (PROTOCOL.equals(string2) && (n = (string = uRL.getPath()).indexOf("!/")) >= 0) {
            String string3 = null;
            try {
                string3 = string.substring(0, n);
                if (string3.indexOf("file://") > -1 && string3.indexOf("file:////") == -1) {
                    string3 = string3.replaceFirst("file://", "file:////");
                }
                return new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                LOG.log(Level.WARNING, "Invalid URL ({0}): {1}, jarPath: {2}", new Object[]{malformedURLException.getMessage(), uRL.toExternalForm(), string3});
            }
        }
        return null;
    }

    @Override
    public FileObject getArchiveFile(FileObject fileObject) {
        try {
            FileSystem fileSystem = fileObject.getFileSystem();
            if (fileSystem instanceof JarFileSystem) {
                File file = ((JarFileSystem)fileSystem).getJarFile();
                return FileUtil.toFileObject(file);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    @Override
    public URL getArchiveRoot(URL uRL) {
        try {
            return new URL("jar:" + uRL + "!/");
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    private static boolean isArchiveFile(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 && n > string.lastIndexOf(47) + 1;
    }
}

